	function account_multi_exec(url, params, container_id){		
		Ext.getCmp(container_id + '_progress_bar').wait();
		
		params.url  = url;
		params.container_id = container_id;
		pegAjaxDefer(url, params, function(jsonData){
			if(jsonData.ok==0){
				pegAlert(jsonData.msg);
				Ext.getCmp(jsonData.params.container_id + '_progress_bar').reset();
			}
			if(jsonData.ok==1){				
				Ext.getCmp(jsonData.params.container_id + '_progress_bar').updateProgress('1', jsonData.msg, true );
				if(jsonData.params.step!=''){
					params = jsonData.params;
					account_multi_exec(params.url, params, params.container_id);	
				}else{
					pegAlert(jsonData.msg);
					Ext.getCmp(jsonData.params.container_id + '_progress_bar').reset();	
				}	
			}
		}, 'json');	
	}
	
	var account_get_exchange_rate_ajax='';	
	function account_get_exchange_rate(container_id , mode){
		
		let prefix = '';

		if(mode=='a55'){
			var container_id_main     = pegGetContainer_id_d(container_id , 'a55_d'  , '' , 'a55_d' );
			var container_id_stoixeia = pegGetContainer_id_d(container_id , 'a55_d4' , '' , 'a55_d' );
			
		}
		
		if(mode=='a56'){
			var container_id_main     = pegGetContainer_id_d(container_id , 'a56_d'  , '' , 'a56_d' );
			var container_id_stoixeia = pegGetContainer_id_d(container_id , 'a56_d4' , '' , 'a56_d' );
			
		}
			
		if(mode=='a57'){
			var container_id_main     = pegGetContainer_id_d(container_id , 'a57_d'  , '' , 'a57_d' );
			var container_id_stoixeia = pegGetContainer_id_d(container_id , 'a57_d3' , '' , 'a57_d' );
		}
	
		if(mode=='a67'){
			var container_id_main     = pegGetContainer_id_d(container_id , 'a67_d'  , '' , 'a67_d' );
			var container_id_stoixeia = pegGetContainer_id_d(container_id , 'a67_d3' , '' , 'a67_d' );
		}

		if(mode == 'retail00_01') {
			var container_id_main 	  = pegGetContainer_id_d(container_id , 'retail00_01_d04' , '' , 'retail00_01_d' );
			var container_id_stoixeia = pegGetContainer_id_d(container_id , 'retail00_01_d04' , '' , 'retail00_01_d' );
			prefix = 'a55';
		}
	
	    var account00_params = {};
	    	account00_params.dt   = pegGetVal(prefix + 'p01'  , container_id_main );
			account00_params.pn01 = pegGetVal(prefix + 'pn01' , container_id_stoixeia );
	
	  	    if(account_get_exchange_rate_ajax!=''){
			   if(account_get_exchange_rate_ajax.id>0){ 
				  Ext.ux.AjaxDefer.abort(account_get_exchange_rate_ajax);  
			   }
		    }
		    
			account_get_exchange_rate_ajax = pegAjaxDefer('/' + main_path + '/account01/account_get_exchange_rate.php' , account00_params , 
			function(jsonData){
	            pegSetVal(prefix + 'pn02' , container_id_stoixeia, jsonData.pn02);
	        } , 
			'json' , true);		
	}
	
	var account00_t01_values_ajax='';	
	function account00_t01_values(container_id)
	{
	
	    var account00_params = {};
			account00_params.dias_fld_nr01  = pegGetVal('nr01', container_id); // Μ.Κ. t01
	        account00_params.dias_fld_p07   = pegGetVal('p07', container_id);  // Κωδικός Κίνησης
	        account00_params.dias_fld_vp03  = pegGetVal('vp03', container_id); // Ποσό Κίνησης
	        account00_params.dias_fld_pn02  = pegGetVal('pn02', container_id); // Ισοτιμία
			account00_params.dias_fld_p101  = pegGetVal('p101', container_id); // ΦΠΑ
			account00_params.dias_fld_p09   = pegGetVal('p09', container_id);  // Κατάστημα
			account00_params.dias_fld_p303  = pegGetVal('p303', container_id); // Κατηγορία Κίνησης

	  	    if(account00_t01_values_ajax!=''){
			   if(account00_t01_values_ajax.id>0){ 
				  Ext.ux.AjaxDefer.abort(account00_t01_values_ajax);  
			   }
		    }
	
			account00_t01_values_ajax = pegAjaxDefer('/' + main_path + '/account01/t01_002.php' , account00_params , 
			function(jsonData)
			{
	            pegSetVal('p03' , container_id, jsonData.p03);
	            pegSetVal('p04' , container_id, jsonData.p04);
	            pegSetVal('pn02' , container_id, jsonData.pn02);
	            pegSetVal('pn03' , container_id, jsonData.pn03);
	            pegSetVal('pn04' , container_id, jsonData.pn04);
				pegSetVal('p201' , container_id, jsonData.p201);

				if(jsonData.p06) {
					pegSetVal('p06' , container_id, jsonData.p06);
					pegSetFieldReadonly('p06', container_id, true);
				} else {
					pegSetFieldReadonly('p06', container_id, false);
				}
	        } , 
			'json' , true);		
		
		
	}
	
	var account00_t01_relation_ajax='';	
	function account00_t01_relation(container_id,type, params = {}){
	
			
		    var t01_params = {};
	
		    if(type==1){
		    	var row= pegGridGetSelectedRow( container_id ,  'grid');
	       		t01_params.nr01=row.nr01;
	       	    t01_params.p302=row.p302;
	       	    t01_params.p303=row.p303;
			}
	
		    if(type==2){
				t01_params.nr01=pegGetVal('nr01', container_id);
				t01_params.p302=pegGetVal('p302', container_id);
				t01_params.p303=pegGetVal('p303', container_id);
			}
			if(type==3){
				t01_params = params;
			}
	  	    if(account00_t01_relation_ajax!=''){
			   if(account00_t01_relation_ajax.id>0){ 
				  Ext.ux.AjaxDefer.abort(account00_t01_relation_ajax);  
			   }
		    }
	
			account00_t01_relation_ajax = pegAjaxDefer('/' + main_path + '/account01/t01_relation.php' , t01_params , 
			function(jsonData){
				if(jsonData.ok==1){
					/*pegAddTab(main_tab_id, jsonData.title  ,  ''  , true , '/' +  main_path + '/core_global/show_d.php?tab_name=tab&_d=' + jsonData.view_d +  '&module=' + jsonData.view_module +  '&table=' + jsonData.view_table +  '&nr01=' + jsonData.view_nr01 +  ''  , jsonData.con_id );*/
					pegAddTab_d('' , jsonData.view_table  , jsonData.view_d  , jsonData.view_module  , jsonData.view_con_id  , jsonData.view_nr01  , '' );  //'" .$this->container_id. "'				
				}else{
					pegAlert(jsonData.msg);
				}
	  
	        } , 'json' , true);		
		
		
	}

	var account00_t01_copy_ajax='';	
	function account00_t01_copy(container_id){
	
			
		    var t01_params = {};
			var row= pegGridGetSelectedRow( container_id ,  'grid');
		
			t01_params.nr01=row.nr01;
			t01_params.p302=row.p302;
			t01_params.p303=row.p303;
	
			if(account00_t01_copy_ajax!=''){
				if(account00_t01_copy_ajax.id>0){ 
				   Ext.ux.AjaxDefer.abort(account00_t01_copy_ajax);  
				}
			 }
			account00_t01_copy_ajax = pegAjaxDefer('/' + main_path + '/account01/t01_copy.php' , t01_params , 
			function(jsonData){
				if(jsonData.ok==1){
					pegAddTab_d(
						'' , 
						jsonData.view_table  , 
						jsonData.view_d  , 
						jsonData.view_module  , 
						jsonData.view_con_id  , 
						0  , 
						'' ,
						{'rec_copy_nr01' : jsonData.view_nr01}
						);  //'" .$this->container_id. "'				

					}else{
					
				}
	  
	        } , 'json' , true);		
		
		
	}

	var account__t3_d1_refresh_ajax='';	
	/**
	 * Εκτελει την αναζήτηση του _t3_d1
	 * @param container_id
	 */
	function account__t3_d1_refresh(container_id){
		
		_t3_d1_container_id   =  pegGetContainer_id_d(container_id , '_t3_d1'   , '' , '_t3_d1' );
		var params      = {};
		params.container_id =  _t3_d1_container_id; 
		params =  Ext.Object.merge(params, pegGetFormVal(_t3_d1_container_id)); 
		
		
		if(account__t3_d1_refresh_ajax!=''){
		   if(account__t3_d1_refresh_ajax.dias_fld_mnr01>0){ 
			  Ext.ux.AjaxDefer.abort(account__t3_d1_refresh_ajax);  
		   }
	    }
		
		account__t3_d1_refresh_ajax =  
			pegAjaxDefer('/' + main_path + '/account02/refresh_t3_d_00.php' , params , function(jsondata){
				pegGridRefresh(container_id , 'grid');
				account__t3_d1_refresh_ajax ='';
			});
	}
	
	var account__t3_d1_open_tab_ajax='';	
	/**
	 * Anoigei se neo TAB thn kartela toy CRM h pelath h promhueyth
	 * @param mode enum{crm,a01,a00,d01}
	 * @param container_id
	 */
	function account__t3_d1_open_tab(mode,container_id){
		//console.log(container_id);
		var slctRec = pegGridGetSelectedRow( container_id ,  'grid');
		//XXX Gia na elegxw ean eimai se pelati h promitheuti	
		var t_type = pegGetVal('t_type', container_id);
		var params = {
				t_type: t_type,
				mode: mode,
				nr01: 0
		};
		var tableData = {
				table:'',
				_d:'',
				module:''
		};
		
		if(account__t3_d1_open_tab_ajax!=''){
		   if(account__t3_d1_open_tab_ajax.dias_fld_mnr01>0){ 
			  Ext.ux.AjaxDefer.abort(account__t3_d1_open_tab_ajax);  
		   }
	    }
		
		switch (mode) {
		case 'crm':
			params['nr01'] = slctRec['pnr01'] ;
			break;
		case 'd01':
			params['nr01']		   = slctRec['d01nr01'] ;
			params['_t3_d1_conid'] = container_id;
			break;
		case 't08':
			params['nr01']		          = 0 ;
			params['peg_'+t_type+'_nr01'] = slctRec['nr01'] ;
			params['peg_ypol']		      = slctRec['ypol'] ;
			params['_t3_d1_conid']	      = container_id;
			break;
		case 't01':
			params['nr01'] = slctRec['p21'];
			break;
		default:
			params['nr01'] = slctRec['nr01'] ;
			break;
		}
		params['pnr01']	  = slctRec['pnr01'] ;
		params['d01p311'] = slctRec['ypol'] ;
		
		
		account__t3_d1_open_tab_ajax = 
			pegAjaxDefer('/' + main_path + '/account02/open_tab_t3_d_00.php' , params , function(jsonData){
				if(jsonData['ok'] == 1){
					if(jsonData['t08_ok'] == 0) {
						pegConfirmBox(jsonData.title, jsonData.message, function(res) {
							if(res == 'yes') {
								pegAddTab_d( 
									'',
									jsonData['table'] , 
									jsonData['_d']	 , 
									jsonData['module'], 
									'' , 
									jsonData['nr01'],
									'',
									jsonData['params']
								);		
							}
						});
					} else {
						pegAddTab_d( 
							'',
							jsonData['table'] , 
							jsonData['_d']	 , 
							jsonData['module'], 
							'' , 
							jsonData['nr01'],
							'',
							jsonData['params']
						);		
					}
					
					return ;					
				}else{
					pegAlert(jsonData['msg']  );
				}
				account__t3_d1_open_tab_ajax ='';
			});
	}
	
	var account__t5_d_refresh_ajax='';	
	/**
	 * Εκτελει την αναζήτηση του _t5_d
	 * @param container_id
	 */
	function account__t5_d_refresh(container_id){
		
		_t5_d_container_id   =  pegGetContainer_id_d(container_id , '_t5_d'   , '' , '_t5_d' );
		var params      = {};
		params.container_id =  _t5_d_container_id; 
		params =  Ext.Object.merge(params, pegGetFormVal(_t5_d_container_id)); 
		
		
		if(account__t5_d_refresh_ajax!=''){
		   if(account__t5_d_refresh_ajax.dias_fld_mnr01>0){ 
			  Ext.ux.AjaxDefer.abort(account__t5_d_refresh_ajax);  
		   }
	    }
		
		account__t5_d_refresh_ajax =  
			pegAjaxDefer('/' + main_path + '/account03/refresh__t5_d_00.php' , params , function(jsondata){
				pegGridRefresh(container_id , 'grid');
				account__t5_d_refresh_ajax ='';
			});
	}
	
	function account_a26_d_afterDraw_listeners(container_id){
		var screen = pegGetCmp(container_id );
		var grid01 = pegGetCmp(container_id, 'grid01');
		grid01.setpeg_isEditable(true);
	    grid01.on('edit', function(editor, context) {
				 
		var values = {};
		values = context.record.getData({serialize:true});
		pegSave_grid_row( 
				grid01.peg_view__d ,
		        'peg_tmp_a27' , 
		        grid01.peg_view_module  ,
		        grid01.getMnr01(),  
		        grid01.getMmnr01(), 
		        values , 
		        function(jsonData){ 
		        	context.record.set( 'nr01' ,  jsonData.data.nr01);
		        	context.record.commit();
		        }
			); 
	   });
	   grid01.on('canceledit', function(editor, context) {  
	       context.record.reject();  
	   }); 
   }
	
	function account_t01_d_afterDraw_listeners(container_id){
		var screen = pegGetCmp(container_id );
		var vp03 = pegGetCmp(container_id, 'vp03');
		var pn01 = pegGetCmp(container_id, 'pn01');
		var pn02 = pegGetCmp(container_id, 'pn02');
		var p07 = pegGetCmp(container_id, 'p07');
		var bt01 = pegGetCmp(container_id, 'bt01');

		vp03.on('blur', function(this_00){
			if((this_00.value_old!=this_00.getValue()) || (!this_00.value_old)){		
				this_00.value_old=this_00.getValue();
				account00_t01_values(this_00.container_id);
			}
	
		});		
		
		//Δεν καταλαβαίνω γιατί έχει onChange από τη στιγμή που είναι readOnly 
		//και δεν μπορώ να βρω ότι μπορεί να αλλάξει από κάπου ΦΨ
		pn01.on('change', function(me, newValue, oldValue, eOpts ){
			if(newValue == oldValue ){
				return ;
			} 
			if(newValue!=''){
				var params={};
				    params.dias_fld_p02 =pegGetVal('p02', container_id);
				    params.dias_fld_pn01=pegGetVal('pn01', container_id);
				pegAjax('/' + main_path + '/account01/t01_001.php' , params , function(ret_data){
				            pegSetVal('pn02' , container_id , ret_data.pn02);
				       }, 'json' , true);
			}else{
			  pegSetVal('pn02' ,container_id, 1);
			}  
			
		});
		//Δεν καταλαβαίνω γιατί έχει onChange από τη στιγμή που είναι readOnly 
		//και δεν μπορώ να βρω ότι μπορεί να αλλάξει από κάπου ΦΨ
		pn02.on('blur', function(this_00){
			if((this_00.value_old!=this_00.getValue()) || (!this_00.value_old)){		
				this_00.value_old=this_00.getValue();
				account00_t01_values(this_00.container_id);
			}
	
		});		
		p07.on('blur', function(this_00){
			if((this_00.value_old!=this_00.getValue()) || (!this_00.value_old)){		
				this_00.value_old=this_00.getValue();
				account00_t01_values(this_00.container_id);
			}
	
		});					
		p07.on('change', function(me, newValue, oldValue, eOpts ){
			if(newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue) )){
				return ;
			} 
	        account00_t01_values(container_id);
		});
		bt01.setPeg_handler(function(me){
			account00_t01_relation(container_id, 2);
		});			
	}

	function account_update_fldSet_title(fldSetName, container_id){

		var fldSet     = pegGetCmp(container_id, fldSetName);
		var screen	   = pegGetCmp(container_id)
		let screenData = screen.peg_getData();	
		
		if(fldSet.collapsed==true){
			if(screen.peg__d=='t01_d100'){				
				fldSet.setTitle(Ext.util.Format.date(pegGetVal('t_df', container_id), 'd/m/Y') + ' - ' + Ext.util.Format.date(pegGetVal('t_dt', container_id), 'd/m/Y'));
			}
		}else{
			fldSet.setTitle(fldSet.title00);
		}

	}

	var account_t01_d100_search_ajax='';
	function account_t01_d100_afterDraw_listeners(container_id){
		var screen = pegGetCmp(container_id );
		var but01  = pegGetCmp(container_id, 'but01');
		var but02  = pegGetCmp(container_id, 'but02');
		//var but03  = pegGetCmp(container_id, 'but03');
		var grid01 = pegGetCmp(container_id, 'grid01');
		var fset01 = pegGetCmp(container_id, 'fset01');

		var container_id_t01_d102 = pegGetContainer_id_d(container_id, 't01_d102', '', 't01_d100');
		var container_id_t01_d103 = pegGetContainer_id_d(container_id, 't01_d103', '', 't01_d100');
		var container_id_t01_d105 = pegGetContainer_id_d(container_id, 't01_d105', '', 't01_d100');
		var container_id_t01_d107 = pegGetContainer_id_d(container_id, 't01_d107', '', 't01_d100');

		var t_lo   = pegGetCmp(container_id, 't_lo');
		t_lo.on('change', function (me, newValue, oldValue, eOpts) {
			if (newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue))) {
				return;
			}
			var params ={};
			params.container_id = container_id;
			params.t_lo = pegGetVal('t_lo', container_id);
			params.t_ypok_a00 = pegGetVal('t_ypok_a00', container_id);
			params.t_ypok_a01 = pegGetVal('t_ypok_a01', container_id);

			pegAjax('/' + main_path + '/account01/t01_d100_t_lo_change.php', params, function (jsonData) {
				pegSetFieldHidden('t_ypok_a01', container_id, jsonData.t_ypok_a01_hidden);
				pegSetFieldHidden('t_ypok_a00', container_id, jsonData.t_ypok_a00_hidden);
				pegSetVal('t_ypok_a01' ,container_id, jsonData.t_ypok_a01);
				pegSetVal('t_ypok_a00' ,container_id, jsonData.t_ypok_a00);

			}, 'json', true); 

			// console.log(newValue, oldValue);
		});

		fset01.on('collapse', function(){	
			account_update_fldSet_title('fset01', container_id);
		});
		fset01.on('expand', function(){
			account_update_fldSet_title('fset01', container_id);
		});
		but01.setPeg_handler(function(me){
			pegGridRefresh(container_id_t01_d102, 'grid', -1);
			pegGridRefresh(container_id_t01_d103, 'grid', -1);
			pegGridRefresh(container_id_t01_d105, 'grid', -1);
			pegGridRefresh(container_id_t01_d107, 'grid', -1);
			  
			params = {};
			params.mmnr01 = screen.getMmnr01();
			params.container_id = container_id;
			params.t_df = pegGetVal('t_df', container_id);
			params.t_dt = pegGetVal('t_dt', container_id);
			params.t_kat = pegGetVal('t_kat', container_id);
			params.t_lo = pegGetVal('t_lo', container_id);
			params.t_nom = pegGetVal('t_nom', container_id);
			params.t_ypok_a00 = pegGetVal('t_ypok_a00', container_id);
			params.t_ypok_a01 = pegGetVal('t_ypok_a01', container_id);
			params.p503 = pegGetVal('p503', container_id);
			params.p504 = pegGetVal('p504', container_id);

			if(account_t01_d100_search_ajax!=''){
				if(account_t01_d100_search_ajax.id>0){ 
				Ext.ux.AjaxDefer.abort(account_t01_d100_search_ajax);  
				}
			}
			
			account_t01_d100_search_ajax = pegAjaxDefer('/' + main_path + '/account01/refresh.php', params, 
				function(jsonData){
					pegGridRefresh(container_id_t01_d102 , 'grid');
					pegGridRefresh(container_id_t01_d103 , 'grid');
					pegGridRefresh(container_id_t01_d105 , 'grid');
					pegGridRefresh(container_id_t01_d107 , 'grid');
				} , 
				'json' , true);	
		});				

		but02.setPeg_handler(function(me){
			peg_windowShow_d(
				'',
				'account_browse_t01_d100' ,
				'account',
				container_id,
				'',
					0 ,
				'',
				'',  
				{
					peg_screen_parent_container_id:container_id
				},
				false,true,0,0,'tablet' 
			);
		});
	}
	
	function account_account_browse_t01_d100_afterDraw_listeners(container_id){
		//console.log(container_id);
		var screen = pegGetCmp(container_id);
		var container_id_t01_d100 = screen.peg_screen_parent_container_id;
		
		//console.log('screen.peg__d');
		//console.log( pegGetCmp(container_id_t01_d100).peg__d);

		var grid = pegGetCmp(container_id,  'grid');
		grid.on('itemdblclick', function( view, record, item, index, e, opts){
			if(pegGetCmp(container_id_t01_d100).peg__d == 'd00_d5602'){
				var ypok = pegGetVal('p303' ,container_id_t01_d100).split('#');
				ypok = ypok.slice(1, ypok.length -1);

				var log = pegGetVal('p302' ,container_id_t01_d100).split('#');
				log = log.slice(1, log.length -1);
				var contact = '';
				

				if(log.length > 1){
					pegGetDicAlert('peg_dic_crm001_only_one_account')
				}else if(ypok.length > 1){
					pegGetDicAlert('peg_dic_crm001_only_one_branch')
				}else{
					var p302 = log[0]
					var p303 = ypok[0]
					params = {
							parent_container_id: container_id_t01_d100, 
							t_lo: p302 , 
							t_df: pegGetVal('dt_f' ,container_id_t01_d100),
							t_dt: pegGetVal('dt_t' , container_id_t01_d100),
							t_kat:pegGetVal('p301',container_id_t01_d100)
							// t_ypok_a01: pegGetVal('t_ypok_a01' , container_id_t01_d100)
							}
					if(p302.substr(0, 2) == '30'){
						params.t_ypok_a01 = p303;
					}else{
						params.t_ypok_a00 = p303;
					}
					pegPrintToPDF(
						record.data.nr01, 
						params
						
					);
				}
			}else{
				pegPrintToPDF(
					record.data.nr01 , 
					{
						parent_container_id: container_id_t01_d100, 
						t_lo: pegGetVal('t_lo' ,container_id_t01_d100) , 
						t_df: pegGetVal('t_df' ,container_id_t01_d100),
						t_dt: pegGetVal('t_dt' , container_id_t01_d100),
						t_kat:pegGetVal('t_kat',container_id_t01_d100),
						t_ypok_a00: pegGetVal('t_ypok_a00' , container_id_t01_d100),
						t_ypok_a01: pegGetVal('t_ypok_a01' , container_id_t01_d100)
					}
				);
			}
		});
	}

	function account_t01_d101_afterDraw_listeners(container_id){
		var screen = pegGetCmp(container_id );
		var vp03 = pegGetCmp(container_id, 'vp03');
		var pn01 = pegGetCmp(container_id, 'pn01');
		var bt01 = pegGetCmp(container_id, 'bt01');
		var p07  = pegGetCmp(container_id, 'p07');
		const p101 = pegGetCmp(container_id,'p101');
		parent_id = screen.peg_screen_parent_container_id
		
		if(pegGetCmp(parent_id).peg__d == 'd00_d5602'){
			// Εαν ανοίγει από την οικονομική καρτέλα συναλλασσόμενου θέλουμε να έχει προεπιλεγμένο τον 1ο λογαριασμό
			//και να μην ειναι readonly 
			parent_id = screen.peg_screen_parent_container_id
			var p302 = pegGetVal('p302' ,parent_id).split('#');
			p302 = p302.slice(1, p302.length -1);
			pegSetFieldReadonly('p01', container_id, false);
			pegSetVal('p01', container_id, p302[0])
		}
		vp03.on('blur', function(this_00){
			if((this_00.value_old!=this_00.getValue())){		
				this_00.value_old=this_00.getValue();
		        account00_t01_values(this_00.container_id);		
			}
		});
		p07.on('blur', function(this_00){
			if((this_00.value_old!=this_00.getValue()) || (!this_00.value_old)){		
				this_00.value_old=this_00.getValue();
				account00_t01_values(this_00.container_id);
			}
	
		});	
		p07.on('change', function(me, newValue, oldValue, eOpts ){
			if(newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue) )){
				return ;
			} 
	        account00_t01_values(container_id);
		});		
		//Δεν καταλαβαίνω γιατί έχει onChange από τη στιγμή που είναι readOnly 
		//και δεν μπορώ να βρω ότι μπορεί να αλλάξει από κάπου ΦΨ					
		pn01.on('change', function(me, newValue, oldValue, eOpts ){
			if(newValue == oldValue ){
				return ;
			} 
			if(newValue!=''){
				var params={};
				    params.dias_fld_p02 =pegGetVal('p02', container_id);
				    params.dias_fld_pn01=pegGetVal('pn01', container_id);
				pegAjax('/' + main_path + '/account01/t01_001.php' , params , function(ret_data){
				            pegSetVal('pn02' , container_id , ret_data.pn02);
				       }, 'json' , true);
			}else{
			  pegSetVal('pn02' ,container_id, 1);
			}  
			
		});
		bt01.setPeg_handler(function(me){
			account00_t01_relation(container_id, 2);
		});		
		p101.on('blur', function( me, event, eOpts ){
			if(!(me.peg_onBlurValueHasChanged()) ){
				return false;
			}
			account00_t01_values(container_id);
		})	
		
	}

	function account_t01_d102_afterDraw_listeners(container_id) {
		var grid  = pegGetCmp(container_id, 'grid');
		var container_id_main = pegGetContainer_id_d(container_id, 't01_d100', '', 't01_d100');
		var p503 = pegGetCmp(container_id_main, 'p503');

		grid.record_insert = function(me,row){	
			if (p503) {
				if(pegGetVal('p503',container_id_main)>0){
					pegGetDic('peg_dic_projects_perm_deny_edit_rec', function (desc) { pegAlert(desc); });
					return false;
				}
			}

			var peg_log = pegGetVal('t_lo', container_id_main);  
			
			let getGridMnr01 = me.getGridMnr01();
			let getMmnr01 = me.getMmnr01();
			
			// περιπτωση συμβολαιων (hota14_d) παίρνω το hota14.nr01 από την μαμά οθόνη 
			if(getMmnr01.includes("hota14_d")){
				var container_id_main_of_main = pegGetContainer_id_d(container_id_main, 'hota14_d', '', 'hota14_d');
				getGridMnr01 = pegGetVal('nr01',container_id_main_of_main);
			}
			
			peg_windowShow_d(
					me.peg_view_table,
					me.peg_view__d,
					me.peg_view_module,
					container_id_main,
					'',
					0,
					me.store.url_vars00 ,
					'',
					{
						mmnr01: getMmnr01,
						mnr01: getGridMnr01,
						peg_screen_parent_element_name: me.name,
						peg_screen_parent_container_id: me.getContainer_ID(),
						grid_element_name: me.name,
						grid_element_con_id: container_id,
						peg_log: peg_log
					},
					false,true,0,0,'tablet'
			);
					
		};
		
	}

	function account_t01_d302_afterDraw_listeners(container_id){
		var screen = pegGetCmp(container_id );
		var bt01 = pegGetCmp(container_id, 'bt01');
		
		bt01.setPeg_handler(function(me){
			account00_t01_relation(container_id, 2);
		});			
	}

	function account__t3_d1_afterDraw_listeners(container_id){
		var screen = pegGetCmp(container_id );
		var bt01 = pegGetCmp(container_id, 'bt01');

		// var bt_crmopen = pegGetCmp(container_id, 'bt_crmopen');
		// var bt_a01open = pegGetCmp(container_id, 'bt_a01open' );
		// var bt_a00open = pegGetCmp(container_id, 'bt_a00open');
		// var bt_d01open = pegGetCmp(container_id, 'bt_d01open');
		// var bt_t08ins  = pegGetCmp(container_id, 'bt_t08ins');
	
		bt01.setPeg_handler(function(me){
			account__t3_d1_refresh(container_id);
		});		
		
	}
	
	function account__t5_d_afterDraw_listeners(container_id){
		var screen = pegGetCmp(container_id );
		var bt01   = pegGetCmp(container_id, 'bt01');
		var grid   = pegGetCmp(container_id, 'grid');
		
		bt01.setPeg_handler(function(me){
			account__t5_d_refresh(container_id);
		});	
		
		grid.record_change = function(me,row){
			var row=pegGridGetSelectedRow( me.getContainer_ID() , 'grid');
			if(row){
				var nr01=row.nr01;
				if(nr01<1){
					pegGetDic('peg_dic_core_perm_deny_edit_rec', function(desc){ pegAlert(desc); } );
				    return;
				}
				pegAddTab_d(
					'' , 
					me.peg_view_table , 
					'd01_d', 
					'crm002', 
					'' , 
					nr01 , 
					me.store.url_vars00 , 
					{
						mmnr01:me.getMmnr01(),
						mnr01: me.getMnr01(),
						peg_screen_parent_element_name: me.name,
						peg_screen_parent_container_id: me.getContainer_ID(),
						grid_element_name: me.name,
						grid_element_con_id:  me.getContainer_ID()
					}
				);	
			}	
		};	
	}	

	var account_t00_d_open_customer_supplier_ajax='';
	function account_t00_d_open_customer_supplier(container_id,mode){

		if(account_t00_d_open_customer_supplier_ajax!=''){
			if(account_t00_d_open_customer_supplier_ajax.id>0){ 
			   Ext.ux.AjaxDefer.abort(account_t00_d_open_customer_supplier_ajax);  
			}
		 }
	
		 const ajax_params = {
			 mode:mode,
			 p01: pegGetVal('p01',container_id)
		 }
		 account_t00_d_open_customer_supplier_ajax = 
		pegAjaxDefer('/' + main_path + '/account01/t00_open_tab_customer_supplier.php' , ajax_params , function(jsonData){
			if(jsonData['ok'] == 1){
				pegAddTab_d( 
						'',
						jsonData['data']['table'] , 
						jsonData['data']['_d']	 , 
						jsonData['data']['module'], 
						'' , 
						jsonData['data']['nr01'],
						'',
						{
							nr01:jsonData['data']['nr01']
						}
						
					);		
					return ;			
				
			}else{
				pegAlert(jsonData['msg']  );
			}
		});
	}
	function account_t01_d200_afterDraw_listeners(container_id){
		const grid = pegGetCmp(container_id,'grid')
		grid.on('itemdblclick', function (view, record, item, index, e, opts) {

			const t01_container_id = pegGetContainer_id_d(container_id, 't01_d', '', 't01_d')

			pegSetVal('p01', t01_container_id, record.data.p01)
			
			pegWindowClose(Ext.getCmp(container_id).up().id)
		})
	}
	function account_t01_update_parent(screen) {
		const peg_screen_parent_container_id = screen.peg_screen_parent_container_id
		const nr01 = screen.getNr01();
		const t01 = pegGetCmp(peg_screen_parent_container_id,'t01')
		if(
			peg_screen_parent_container_id
			&& t01
		) {
			pegSetVal('t01',peg_screen_parent_container_id,nr01)
		}
	}
	function account_t01_d_find_p01_by_t00tot(screen) {
		const container_id = screen.getContainer_ID();
		const t01_p03 = pegGetVal('p03',container_id)
		const t01_p04 = pegGetVal('p04',container_id)
		const t01_vp03 = pegGetVal('vp03',container_id)
		return peg_windowShow_d(
			'',
			't01_d200',
			'account',
			container_id,
			'',
			0,
			null,
			'',
			{
				t01_p03: t01_p03,
				t01_p04 :t01_p04,
				t01_vp03 : t01_vp03
			},
			true,
			true,
			0,
			'',
			'tablet'
		)
	}

	var account_t01_d100_check_perm='';
	/**
	* Με αυτή τη συνάρτηση υλοποιούμε τη λογική για το άνοιγμα της οικονομικής καρτέλας από διάφορες οθόνες
	* @param container_id	
	* @param params	
	*/
	function account_t01_d100_open(container_id, params) {
		if (account_t01_d100_check_perm != '') {
			if (account_t01_d100_check_perm.id > 0) {
				Ext.ux.AjaxDefer.abort(account_t01_d100_check_perm);
			}
		}
		
		const params00 = {};

		account_t01_d100_check_perm = pegAjaxDefer(
			'/' + main_path + '/account01/t01_d100_check_perm.php',
			params00,
			function (jsonData) {
				if (jsonData.has_perm) {				
					peg_windowShow_d( '' , 't01_d100' , 'account' , container_id , '' , 0 , '' ,  '' , params, false, true, 0, 0, 'tablet');						
				} else {
					pegToast(jsonData.msg, 'alert');
				}
			},
			'json', true);
	}
	function account__t3_d_grid_view_afterDraw_listeners(container_id){
		var grid = pegGetCmp(container_id, 'grid');
		var Columnd01p03 = WebApp.view.grid.Grid.peg_getColumn(grid, 'd01p03');
		if(Columnd01p03){
			Columnd01p03.peg_column_celldblclick_handler=function(me, td, cellIndex, record, tr, rowIndex, e, eOpts){
				pegAddTab_d('', 'd01', 'd01_d', 'crm002'  , ''  , record.get('d01nr01')  , '' );
			}
		}
		
	}
	function query_q10_d90_140000009000000_d101_grid01_view_afterDraw_listeners(container_id){
		var grid = pegGetCmp(container_id, 'grid01');
		grid.on('itemdblclick', function( view, record, item, index, e, opts){
			params = {
				nr01: record.get('fld_000007'),
				p302: record.get('fld_000010'),
				p303: record.get('fld_000011')
			}

			account00_t01_relation(container_id,3, params)			
		});
	}

	function query_q10_d90_140000009000001_d101_grid01_view_afterDraw_listeners(container_id){
		var grid = pegGetCmp(container_id, 'grid01');
		grid.on('itemdblclick', function( view, record, item, index, e, opts){
			params = {
				nr01: record.get('fld_000007'),
				p302: record.get('fld_000014'),
				p303: record.get('fld_000013')
			}

			account00_t01_relation(container_id,3, params)			
		});
	}

	function query_q10_d90_140000009000004_d101_grid01_view_afterDraw_listeners(container_id){
		var grid = pegGetCmp(container_id, 'grid01');
		grid.on('itemdblclick', function( view, record, item, index, e, opts){
			params = {
				nr01: record.get('fld_000006'),
				p302: record.get('fld_000010'),
				p303: record.get('fld_000011')
			}

			account00_t01_relation(container_id,3, params)			
		});
	}

	function query_q10_d90_140000009000005_d101_grid01_view_afterDraw_listeners(container_id){
		var grid = pegGetCmp(container_id, 'grid01');
		grid.on('itemdblclick', function( view, record, item, index, e, opts){
			params = {
				nr01: record.get('fld_000007'),
				p302: record.get('fld_000010'),
				p303: record.get('fld_000011')
			}

			account00_t01_relation(container_id,3, params)			
		});
	}


	function query_q10_d90_140000009000002_d101_grid01_view_afterDraw_listeners(container_id){
		var grid = pegGetCmp(container_id, 'grid01');
		grid.on('itemdblclick', function( view, record, item, index, e, opts){
			pegAddTab_d('', 'a01', 'a01_d', 'customers'  , ''  , record.get('nr01')  , '' );  //'" .$this->container_id. "'				
					
		});
	}

	function query_q10_d90_140000009000006_d101_grid01_view_afterDraw_listeners(container_id){
		var grid = pegGetCmp(container_id, 'grid01');
		grid.on('itemdblclick', function( view, record, item, index, e, opts){
			pegAddTab_d('', 'a00', 'a00_d', 'suppliers'  , ''  , record.get('nr01')  , '' );  //'" .$this->container_id. "'				
					
		});
	}

	function account_t01_d101_grid_view_afterDraw_listeners(container_id){
		var grid = pegGetCmp(container_id, 'grid');
		grid.peg_deleteRec_params=function(params,row){
			params.mmnr01='t01_d-'+row['nr01'];
			return params;
		};
	}	


	function account_toolbar_show_transactions(container_id, params, callback){
	
		pegAjaxDefer('/' + main_path + '/account01/show_transactions.php', params, function (json_data) {
			if (json_data.ok==1) {
	
				var module    = 'account';
				var table     = '';
				var _d 	      = (params._d!=undefined) ? params._d : 't01_d300';
				var nr01      = 0;
				var view_grid = (params.view_grid!=undefined) ? params.view_grid : 0;
	
				if(json_data.cnt==1 && view_grid==0){
					module = 'account';
					table  = 't01';
					_d 	   = 't01_d';
					nr01   = json_data.nr01;
				}	
				
				peg_windowShow_d(
					table,
					_d,
					module,
					container_id,
					'',
					nr01,
					'',
					'',  
					params,
					true,
					true,
					0,
					'',
					'tablet'
				);

				if(callback!=undefined && typeof callback==='function'){
					return callback(json_data);
				}

			}else{
				pegAlert(json_data.msg);
			}
		});	
	}

	function account_t02_d01_afterDraw_listeners(container_id) {
		var p0903 = pegGetCmp(container_id, 'p0903');

		p0903.on('change', function(me, newValue, oldValue, eOpts){
			if(newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue) )){
				return ;
			} 

			if(newValue == 0) {
				pegSetFieldReadonly('p0903_1', container_id, true);
				pegSetFieldReadonly('p0903_2', container_id, true);
			} else {
				pegSetFieldReadonly('p0903_1', container_id, false);
				pegSetFieldReadonly('p0903_2', container_id, false);
			}
		});
	}

	function account_t02_d100_afterDraw_listeners(container_id) {
		var p0903 = pegGetCmp(container_id, 'p0903');

		p0903.on('change', function(me, newValue, oldValue, eOpts){
			if(newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue))) {
				return ;
			} 

			if(newValue == 0) {
				pegSetFieldReadonly('p0903_1', container_id, true);
				pegSetFieldReadonly('p0903_2', container_id, true);
			} else {
				pegSetFieldReadonly('p0903_1', container_id, false);
				pegSetFieldReadonly('p0903_2', container_id, false);
			}
		});
	}
	
	function account_proceed_to_payment(container_id, id){	
		var grid     = pegGetCmp(container_id, id);
		var selected = grid.getSelection();

		if (selected.length == 0) {
			pegAlert(dic);
			return
		}
		
		let nr01s = [];
		selected.forEach(function(row) {
			nr01s.push(row.get('nr01'));
		});

		const params = {
			v_mode  : grid.peg_view__d,
			v_nr01s : nr01s.join(',')
		};

		pegWindowShow_d(
			'',
			'account_003_d',
			'account',
			'',
			0,
			'',
			container_id,
			'',
			'',
			'',
			params,
			true, true, 0, 'tablet'
		);	
	}

	function account_account_003_d_afterDraw_listeners(container_id){

		var btn01  = pegGetCmp(container_id, 'btn01');
		var btn02  = pegGetCmp(container_id, 'btn02');

		btn01.setPeg_handler(function(me){

			var params    = {};
			params.account_mode   = pegGetVal('v_mode', container_id);
			params.account_nr01s  = pegGetVal('v_nr01s', container_id);			

			account_add_payment(container_id, params);
			//pegWindowClose(container_id);
		});
		
		btn02.setPeg_handler(function(me){

			var params    = {};
			params.mode   = pegGetVal('v_mode', container_id);
			params.nr01s  = pegGetVal('v_nr01s', container_id);			

			account00_add_payment(container_id, params);
			//pegWindowClose(container_id);			
		});	

	}
	

	function account_add_payment(container_id, params) {	
		// Αντικατασήσαμε το ajax: '/' + main_path + '/account01/add_payment.php'
		pegAddTab_d("", "", "account_002_d", "account", "", 0, "", params, container_id);
	}

	function account_account_002_d_afterDraw_listeners(container_id){
		
		const btn_add = pegGetCmp(container_id, 'btn_add');
		const btn_pay = pegGetCmp(container_id, 'btn_pay');

		btn_add.setPeg_handler(function (me) {
			var params = {};
			params.tbl = pegGetVal('v_tbl', container_id);

			account_account_002_d_add_tbl(container_id, params);
		});
		

		btn_pay.setPeg_handler(function (me) {
			var params = {};
			params.tbl = pegGetVal('v_tbl', container_id);

			account_account_002_d_pay(container_id, params);
		});
	}

	function account_account_002_d_dynamic_fields_init(container_id){
		account_account_002_d_create_dynamic_fields_structure(container_id);
	}

	function account_account_002_d_create_dynamic_fields_structure(container_id){
		var screenData = peg002_get_screen_data(container_id);
		
		if(screenData.tbl_records){
			/** Add all existing tbl records */
			var records_nr01_array = Object.keys(screenData.tbl_records).filter(k=>{return  k.match(/tbl_rec_nr01_[0-9]*$/) });
			var tot = records_nr01_array.length;
			for (let i = 0; i < tot; i++) {
				var record_index = records_nr01_array[i].replace('tbl_rec_nr01_','');
				account_account_002_d_create_dynamic_fld_record_structure(container_id, record_index);
			}
		}	
	}

	function account_account_002_d_create_dynamic_fld_record_structure(container_id, index){

		var screenData    = peg002_get_screen_data(container_id);
		var panelFieldSet = pegGetCmp(container_id, "fldset01_00");
		//console.log(screenData);

		var container_title = 'Παραστατικό';
		var table 		  = 'a55';
		var _d 			  = 'a55_d';
		var module 		  = 'invcust';
		var field_label   = container_title;

		if(screenData['v_tbl']=='tran01'){
			container_title = 'Φορτωτική';	
			table 		    = 'tran01';
			_d 			    = 'tran01_d';
			module 		    = 'tran';
			field_label 	= container_title;
		}

		/** Main Container for each added record */
		var rec_container_obj = {
			name : "tbl_rec_container_" + index,
			xtype: 'PanelFieldset',
			title: container_title,
			bodyPadding: "5",
			collapsible: true,
			layout: {
				type: 'vbox',
				align: 'stretch'
			},
			// responsiveConfig: {
			// 	"mobile": {
			// 		"layout": {
			// 			"type": "box",
			// 			"vertical": true
			// 		}
			// 	},
			// 	"!mobile": {
			// 		"layout": {
			// 			"type": "box",
			// 			"vertical": true
			// 		}
			// 	}
			// },
			margin: "0 0 5 0"
		};
		
		var rec_container = panelFieldSet.peg_insert(rec_container_obj);

	
		// Delete action handler
		var del_fun = function () {
			account_account_002_d_dynamic_fld_refresh_records(container_id, index);
		}
	
		// Delete record component
		var del_fun_obj = {
			name: 'tbl_rec_' + index + "_remove",
			xtype: 'button',
			// flex_mobile: 1,
			// flex: 1,
			// width: "30px",
			// maxHeight: 24,
			text: "Αφαίρεση",
			scale: 'small',
			tooltip: "Αφαίρεση",
			margin: "0 0 5 0",
			iconCls: "fa fa-times",
			peg_handler: del_fun
		};
		rec_container.peg_insert(del_fun_obj);

	
		// Παραστατικό/Φορτωτική
		var rec_tbl_nr01_obj = {
			name : 'tbl_rec_nr01_' + index,
			xtype: 'comboboxV2',
			flex : 1,
			table: table,
			_d   : _d,
			module: module,
			displayField: 'nr01',
			valueField  : 'nr01',
			fieldLabel  : field_label
		}
		var rec_tbl_nr01 = rec_container.peg_insert(rec_tbl_nr01_obj);
		
	
		// Ποσό Είσπραξης Παραστατικού/Φορτωτικής
		var rec_tbl_amount_obj = {
			name : 'tbl_rec_amount_' + index,
			xtype: 'numberbox',
			size : 13,
			decimalPrecision: 2,
			fieldLabel      : 'Ποσό'
		}
		var rec_tbl_amount = rec_container.peg_insert(rec_tbl_amount_obj);
		
	
		if(screenData['tbl_records']) {
			panelFieldset_rec = pegGetCmp(container_id, 'tbl_rec_container_'+index);
	
			pegSetVal('tbl_rec_nr01_' + index, container_id, {value:screenData['tbl_records']['tbl_rec_nr01_'+index], display:screenData['tbl_records']['tbl_rec_nr01_'+index]});
			pegSetVal('tbl_rec_amount_' + index, container_id, screenData['tbl_records']['tbl_rec_amount_'+index]);
			
			if(screenData['tbl_records']['tbl_rec_memo_'+index]) {
				panelFieldset_rec.setTitle(screenData['tbl_records']['tbl_rec_memo_'+index]);
			}
	
			peg002_set_screen_data(container_id, 'tbl_rec_nr01_'+ index,   screenData['tbl_records']['tbl_rec_nr01_'+index]);
			peg002_set_screen_data(container_id, 'tbl_rec_amount_'+ index, screenData['tbl_records']['tbl_rec_amount_'+index]);	
		}
		// console.log(screenData)
	
		rec_tbl_nr01.on('change', function(me, newValue, oldValue, eOpts ){
			account_account_002_d_change_dynamic_tbl(container_id, newValue, index);
		});
	
		rec_tbl_amount.on('blur', function(me){ 			
			if((me.peg_onBlurValueHasChanged())){
				peg002_set_screen_data(container_id, 'tbl_rec_amount_'+ index, me.getValue());
				pegSetVal('v_amount', container_id, account_account_002_d_d_calculate_dynamic_fields_amount(container_id));
			}
		});
	
		return rec_container;
	}

	var account_account_002_d_dynamic_fld_refresh_records_ajax = '';
	function account_account_002_d_dynamic_fld_refresh_records(container_id, delete_index){ 
		var screenData = peg002_get_screen_data(container_id);

		var params = {
			container_id : container_id,
			delete_index : delete_index,
			delete_nr01  : peg002_get_screen_data(container_id, 'tbl_rec_nr01_' + delete_index)
		};
		

		if (account_account_002_d_dynamic_fld_refresh_records_ajax != '') {
			if (account_account_002_d_dynamic_fld_refresh_records_ajax.id > 0) {
				Ext.ux.AjaxDefer.abort(account_account_002_d_dynamic_fld_refresh_records_ajax);
			}
		}

		account_account_002_d_dynamic_fld_refresh_records_ajax = pegAjaxDefer('/' + main_path + '/account01/account_002_d_dynamic_fld_refresh_records.php', params, function (jsondata) {
			// Remove previous records on refresh	
			var fldcont = 'fldset01_00';
			var pattern = /^tbl_rec_nr01_(\d+)$/;
		
		
			if(delete_index > 0) {
				if(pegGetCmp(container_id,'tbl_rec_nr01_' + delete_index)) {
					pegGetCmp(container_id, fldcont).peg_remove(pegGetCmp(container_id, 'tbl_rec_container_' + delete_index));
				}

				peg002_unset_screen_data(container_id, 'tbl_rec_nr01_' + delete_index); 
				peg002_unset_screen_data(container_id, 'tbl_rec_amount_' + delete_index); 
				peg002_unset_screen_data(container_id, 'dias_var_tbl_rec_nr01_' + delete_index); 
		
				//! Όχι unset! Θα χτυπήσει.
				peg002_set_screen_data(container_id, 'tbl_records', "");
			}else{
				const keys = Object.keys(screenData);
		
				//* Remove previous elements on refresh
				//* Αντί έλεγχο με pegGetCmp, η peg_remove δεν τα αφαιρεί από τα data της οθόνης οπότε δεν παίζει σωστά, θα ξεκινήσει
				//* από το τελευταίο index που θα βρει στα screenData όταν φτιάχνει elements, άρα θα πέσει σε κενό.
				keys.forEach((key) => {
					if (pattern.test(key)) {
						const i = key.match(pattern)[1];
						
						if(pegGetCmp(container_id, 'tbl_rec_nr01_' + i)) {
							pegGetCmp(container_id, fldcont).peg_remove(pegGetCmp(container_id, 'tbl_rec_container_' + i));
						}
						
						peg002_unset_screen_data(container_id, 'tbl_rec_nr01_' + i); 
						peg002_unset_screen_data(container_id, 'tbl_rec_amount_' + i); 
						peg002_unset_screen_data(container_id, 'dias_var_tbl_rec_nr01_' + i);

					}
				});

				peg002_set_screen_data(container_id, 'tbl_records', "");
			}

			pegSetVal('v_amount', container_id, account_account_002_d_d_calculate_dynamic_fields_amount(container_id));
		
			var screenDataNew = peg002_get_screen_data(container_id);
			const matchingFields = Object.keys(screenDataNew).filter(key => pattern.test(key));
			if (matchingFields.length > 0) {}
			//console.log(screenDataNew);
			//console.log(matchingFields);
		}, 'json', 1);


		
	}


	var account_account_002_d_change_dynamic_tbl_ajax = '';
	function account_account_002_d_change_dynamic_tbl(container_id, nr01, index) {

		var values = {
			container_id : container_id,
			tbl  : pegGetVal('v_tbl', container_id),
			nr01 : nr01,
			index: index
		};

		if (account_account_002_d_change_dynamic_tbl_ajax != '') {
			if (account_account_002_d_change_dynamic_tbl_ajax.id > 0) {
				Ext.ux.AjaxDefer.abort(account_account_002_d_change_dynamic_tbl_ajax);
			}
		}

		account_account_002_d_change_dynamic_tbl_ajax = pegAjaxDefer('/' + main_path + '/account01/account_002_d_change_dynamic_tbl.php', values, function (jsondata) {
			pegSetVal('tbl_rec_amount_' + index, container_id, jsondata.ypoloipo);
			peg002_set_screen_data(container_id,	'tbl_rec_amount_'+ index, jsondata.ypoloipo);
			panelFieldset = pegGetCmp(container_id ,'tbl_rec_container_'+index);
			panelFieldset.setTitle(jsondata.memo_html);

			pegSetVal('v_amount', container_id, account_account_002_d_d_calculate_dynamic_fields_amount(container_id));
		}, 'json', 1);
	}


	function account_account_002_d_d_calculate_dynamic_fields_amount(container_id) {
		var screenData = peg002_get_screen_data(container_id);
		let amount = 0;
		// Colorsize records
		const pattern_amount = /^tbl_rec_amount_(\d+)$/;
		const sum_amount = Object.keys(screenData)
			.filter(key => pattern_amount.test(key))
			.reduce((acc, key) => {
				const match = key.match(pattern_amount);
				const correspondingKey = `tbl_rec_nr01_${match[1]}`;
				const amount = Number(screenData[key]); // Cast to numeric type
				if (screenData[correspondingKey] && !isNaN(amount)) {
					acc += amount;
					console.log(screenData[correspondingKey] + ' ' + amount);
				}
				return acc;
		}, 0);
		amount += sum_amount;
		
		return amount;
	}

	
	function account_account_002_d_add_tbl(container_id, params) {

		var screenData = peg002_get_screen_data(container_id);
		var records_nr01_array = Object.keys(screenData).filter(k=>{return  k.match(/^tbl_rec_nr01_[0-9]*$/) }); 
		//console.log(screenData);
		
		// βρίσκω το μέγιστο index που έχω στα data για τις εγγραφές μου
		var maxIndex = 0;
		if(records_nr01_array){
			var indexes_array = records_nr01_array.map(it=>parseInt(it.replace('tbl_rec_nr01_', '')));
			var maxIndex = Math.max(...indexes_array);
		}
	
		if(!(maxIndex>0)){
			maxIndex = 0;
		}
		maxIndex++;

		// Καλώ τη συνάρτηση που δημιουργήσαμε παραπάνω και υλοποιεί τη δημιουργία 
		// του container της εγγραφής και όλων των components που περιέχονται σε αυτό.
		account_account_002_d_create_dynamic_fld_record_structure(container_id, maxIndex); 
	
		// Αρχικοποιώ τα data για τη νέα εγγραφή σε κενό string
		peg002_set_screen_data(container_id, 'tbl_rec_nr01_' + maxIndex, 0); // μου κάνει περιέργειες αν σετάρω value και display 
		peg002_set_screen_data(container_id, 'dias_var_tbl_rec_nr01_' + maxIndex, ''); // μου κάνει περιέργειες αν σετάρω value και display 
		peg002_set_screen_data(container_id, 'tbl_rec_amount_'	+ maxIndex, 0);
	}


	function account_account_002_d_refresh(container_id) {		
		account_account_002_d_dynamic_fld_refresh_records(container_id);
	}

	var account_account_002_d_pay_ajax = '';
	function account_account_002_d_pay(container_id) {

		const params = {
			container_id: container_id,
			v_tbl 		: pegGetVal('v_tbl', container_id),
			v_a01 		: pegGetVal('v_a01', container_id),
			v_a14 		: pegGetVal('v_a14', container_id),
			v_amount 	: pegGetVal('v_amount', container_id)
		}

		var screenData = peg002_get_screen_data(container_id);
		var pattern1 = /^tbl_rec_nr01_(\d+)$/;
		var pattern2 = /^tbl_rec_amount_(\d+)$/;
		const keys = Object.keys(screenData);

		keys.forEach((key) => {
			if (pattern1.test(key)) {
				let match1 = key.match(pattern1);
				let i = match1[1];
				let newKey1 = `tbl_rec_nr01_${i}`;
				params[newKey1] = pegGetVal(key, container_id);
				// console.log(pegGetVal(key, container_id));
			}
			if (pattern2.test(key)) {
				let match2 = key.match(pattern2);
				let j = match2[1];
				let newKey2 = `tbl_rec_amount_${j}`;
				params[newKey2] = pegGetVal(key, container_id);
			}
		});
		// console.log(keys);
		// console.log(params);

		if (account_account_002_d_pay_ajax != '') {
			if (account_account_002_d_pay_ajax.id > 0) {
				Ext.ux.AjaxDefer.abort(account_account_002_d_pay_ajax);
			}
		}

		account_account_002_d_pay_ajax = pegAjaxDefer('/' + main_path + '/account01/account_002_d_pay.php', params, function (jsonData) {

			if(jsonData.ok != 1) {
				pegToast(jsonData.msg, 'alert');
				return;
			}

			account_account_002_d_refresh(container_id);
			pegToast(jsonData.msg, 'success');
			
		},'json', 1);
	}