<?php
function peg_account_get_exchange_rate(
	$date = '0100-01-01',
	$pn01 = '',
	$pn02 = 1
) {
	$pn02 = 0;

	$pn02 = pegasus_mysql_printfld('t13', 'p03', 'p01=:p01 and p02=:p02', array('p01' => $pn01, 'p02' => $date));
	if (!($pn02 > 0)) {
		$pn02 = pegasus_mysql_printfld('t12', 'p03', 'p01=:p01 ', array('p01' => $pn01));
	}
	if (!($pn02 > 0)) {
		$pn02 = 1;
	}
	return $pn02;
}
/**
 * Μαζική δημιουργία κινήσεων για πελάτη ή και προμηθευτή από την τιμή παραμετρικού πεδίου
 *
 * @param integer $p01  Κ.Κ.Χρέωση
 * @param integer $p02  Κ.Κ.Πίστωσης
 * @param boolean $p03  Ενημέρωση Πελατών
 * @param boolean $p04  Ενημέρωση Προμηθευτών
 * @param string $p05   Ημερομηνία Κίνησης
 * @param integer $p06  Κατάστημα
 * @param integer $p07  Αριθμός (1-4)
 * @return array
 */
function peg_account_mass_insert_t01_from_pd3_field(
	$p01 = 0,
	$p02 = 0,
	$p03 = false,
	$p04 = false,
	$p05 = '0100-01-01',
	$p06 = 0,
	$p07 = 0
) {
	try {
		$data = array(
			'log'	=> array()
		);
		$pd3 = NULL;
		$my_str = 'Από μεταφορά';
		//	Πρέπει να επιλέξετε Αριθμό από 1 έως και 4
		if (
			empty($p07)
			|| $p07 < 1
			|| $p07 > 4
		) {
			throw new Exception($_SESSION['peg_dic_account_mass_t01_error_p07_not_set'], 1);
		}
		//	Πρέπει να επιλέξετε πελάτες ή/και προμηθευτές για ενημέρωση
		if (
			!$p03
			&& !$p04
		) {
			throw new Exception($_SESSION['peg_dic_account_mass_t01_error_set_p03orp04'], 1);
		}
		//	Πρέπει να ορίσετε ΚΚ Χρέωσης που να δηλώνει Χρέωση
		if (
			empty($p01)
			|| $p01 == 0
			|| pegasus_mysql_printfld('t02', 'p03', 'p01=:p01', array('p01' => $p01)) != 1
		) {
			throw new Exception($_SESSION['peg_dic_account_mass_t01_error_p01_not_set'], 1);
		}
		//	Πρέπει να ορίσετε ΚΚ Πίστωσης που να δηλώνει Πίστωση
		if (
			empty($p02)
			|| $p02 == 0
			|| pegasus_mysql_printfld('t02', 'p04', 'p01=:p01', array('p01' => $p02)) != 1
		) {
			throw new Exception($_SESSION['peg_dic_account_mass_t01_error_p02_not_set'], 1);
		}
		if(pegasus_module_exists('stores')) {
			//	Πρέπει να ορίσετε υπαρκτό κατάστημα
			if ((!(pegasus_mysql_printfld('t07', 'nr01', 'p01=:p01', array('p01' => $p06)) > 0))) {
				throw new Exception($_SESSION['peg_dic_account_mass_t01_error_p06_not_set'], 1);
			}
		}
		//	Πρέπει να ορίσετε Ημερομηνία Κίνησης
		if (
			empty($p05)
			|| peg_dateIsEmpty($p05, 'Y-m-d')
			|| $p05 <= '0100-01-01'
		) {
			throw new Exception($_SESSION['peg_dic_account_mass_t01_error_p05_not_set'], 1);
		}
		//	Ορισμός λεκτικού πεδίου
		switch ($p07) {
			case 1:
				$pd3 = "pd30";
				break;
			case 2:
				$pd3 = "pd31";
				break;
			case 3:
				$pd3 = "pd32";
				break;
			case 4:
				$pd3 = "pd33";
				break;
			default:
				throw new Exception($_SESSION['peg_dic_account_mass_t01_error_p07_not_set'], 1);
		}
		//	Τιμές ενημέρωσης για τον t01
		$values = array(
			'my_date'	=> $p05,
			'my_kkxr'	=> $p01,
			'my_kkpi'	=> $p02,
			'my_store'	=> $p06,
			'user_pswd'	=> $_SESSION['username'],
			'my_str'	=> $my_str
		);
		//	Ενημέρωση Πελατών
		if ($p03) {
			$a01_cnt = pegasus_mysql_printfld('a01', 'COUNT(nr01)', $pd3 . ' <> 0');
			$sql = peg_read_file('../account_sql/a01_mass_update_t01_by_pd3_field.sql');
			$sql = str_replace(
				'{{my_fld}}',
				$pd3,
				$sql
			);
			if (!pegasus_query($sql, $values)) {
				throw new Exception(pegasus_mysql_error(), 0);
			}
			$msg = $_SESSION['peg_dic_account_mass_t01_a01_report'];
			$msg = str_replace(
				array("#a01_cnt#", '#my_str#'),
				array($a01_cnt, $my_str),
				$msg
			);
			$data['log'][] = $msg;
		}
		//	Ενημέρωση Προμηθευτών
		if ($p04) {
			$a00_cnt = pegasus_mysql_printfld('a00', 'COUNT(nr01)', $pd3 . ' <> 0');
			$sql = peg_read_file('../account_sql/a00_mass_update_t01_by_pd3_field.sql');
			$sql = str_replace(
				'{{my_fld}}',
				$pd3,
				$sql
			);
			if (!pegasus_query($sql, $values)) {
				throw new Exception(pegasus_mysql_error(), 0);
			}
			$msg = $_SESSION['peg_dic_account_mass_t01_a00_report'];
			$msg = str_replace(
				array("#a00_cnt#", '#my_str#'),
				array($a00_cnt, $my_str),
				$msg
			);
			$data['log'][] = $msg;
		}
		return array(
			'ok'	=> 1,
			'error'	=> NULL,
			'data'	=> $data,
			'msg'	=> $_SESSION['peg_dic_account_mass_t01_success_go2log']
		);
	} catch (Exception $e) {
		$msg = $_SESSION['peg_dic_account_mass_t01_error'];
		if ($e->getCode() == 1) {
			$msg = $e->getMessage();
		}
		return array(
			'ok'     => 0,
			'error' => $e->getMessage(),
			'data'  => null,
			'msg'	=> $msg
		);
	}
}

function account_t02_d_initialize($data, $mmnr01, $mnr01, $_d, $container_id)
{

	if ($_d == 't02_d') {
		if (empty($data['nr01'])) {
			$data['nr01'] = pegasus_mysql_newrec("t02");
			$peg_is_newrec = 1;
		}
	}

	if($peg_is_newrec) {
		$data['p0903_2'] = "****";
	}

	if(empty($data['p0903'])) {
		$data['account_t02_d100_p0903_1_readonly'] = 1;
		$data['account_t02_d100_p0903_2_readonly'] = 1;
	}

	pegasus_make_all_tmp_recs('t02', $data, $data['nr01'], $_REQUEST['rec_copy_nr01'], 't02_d-' . $data['nr01']);
	if (pegasus_module_exists('genlogef')) {
		$data = genlogef_l20_d100_initialize($data, $mmnr01, $mnr01, $_d, $container_id);
	}

	return $data;
}

function account_t02_d_onsave($data, $permDeny, $mmnr01, $checkOnlyPerm)
{
	if (pegasus_module_exists('genlogef')) {
		$ret_array = genlogef_l20_d100_onsave($data, $permDeny, $mmnr01, $checkOnlyPerm);
		$data = $ret_array[0];
		$permDeny = $ret_array[1];
	}

	return array($data, $permDeny);
}

function account_backup_table($table, $alias = 'backup_')
{
	if (!pegasus_mysql_table_exists($table)) {
		return false;
	}

	$exit = false;
	$i = 0;
	while ($exit == false) {
		$i++;
		$back_up_table_name = $alias . date('YmdHis') . '_' . $table . '_' . $i;
		if (!pegasus_mysql_table_exists($back_up_table_name)) {
			$exit = true;
		}
	}


	$res = pegasus_query('create table ' . $back_up_table_name . ' select * from ' . $table . ' ;');
	if (!$res) {
		return false;
	}
	return $back_up_table_name;
}

function account_query_exec($file, $replace_arr, $delimiter = '/*peg_end*/')
{
	$query = account_get_query($file, $replace_arr);
	$query_arr = explode($delimiter, $query);
	$log = '';
	foreach ($query_arr as $single_query) {
		if(strpos($single_query, '/*start module exists b2g*/') !== false){
			if(!pegasus_module_exists('b2g')) {
				continue;
			}
		}
		if (!empty($single_query)) {
			$ttt = pegasus_query($single_query);

			if (!$ttt) {
				$log .= pegasus_mysql_error() . ' , sql file: "' . $file . '"' . chr(10) . chr(13);
			}
		}
	}
	//peg_write_file('../../tmp/tesae_debug_' . rand(1,5000000), $query . $log);
	return  $log;
}

function account_get_query($file, $replace_arr)
{
	if (file_exists('../account_sql_sme/' . $file)) {
		$file = '../account_sql_sme/' . $file;
	} else {
		$file = '../account_sql/' . $file;
		if (!file_exists($file)) {
			throw new PegApiException('', 500, null, 500, 'Query File not found', 'Query File not found' . $file);
		}
	}

	$query = peg_read_file($file);
	$replace_arr['LANG'] = $_SESSION['lang'];

	if (!isset($replace_arr['where']) || empty($replace_arr['where'])) {
		$replace_arr['where'] = 1;
	}

	if (!isset($replace_arr['orderby'])) {
		$replace_arr['orderby'] = '';
	}

	foreach ($replace_arr as $key => $value) {
		$query = str_replace('##' . $key . '##', $value, $query);
	}

	return $query;
}

function account_date_in_account_period($date = '0000-00-00')
{

	$temp_eos = (empty($_SESSION['account_000_p102']) || peg_dateIsEmpty($_SESSION['account_000_p102'])) ?
		date('Y-m-d') : $_SESSION['account_000_p102'];

	if (!(peg_dateDiff($_SESSION['account_000_p101'], $date, 'Y-m-d') <= 0 and
		peg_dateDiff($date, $temp_eos, 'Y-m-d') <= 0)) {
		return false;
	}
	return true;
}

/**
 * 
 */
function peg_account_t13_d_change($data, $permDeny, $mmnr01, $checkOnlyPerm)
{
	$peg_tmp_msg = '';
	if (pegasus_mysql_printfld('t12', 'nr01', "p01=?", array($data['p01'])) == 0) {
		array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_account_t13_001'] . $peg_tmp_msg));
	}

	return array('data' => $data, 'permDeny' => $permDeny);
}



/**
 * Η συνατησηση αυτή παραγει μετρητές παρασταικών και αποδείξεων
 * 
 * $p0121   = Το κατάστημα  
 * $a10p06  = Ο κώδικος του μετρηρη
 * $p701    = Σειρά
 */
function account_make_invoice_num($p0121, $a10p06, $p701, $update_a19 = true)
{

	//oi metrites einai diaforetikoi ana katastima
	if ($_SESSION['f02_p015'] == 0 || empty($p0121)) {
		$p0121 = 0;
	}

	if (!(pegasus_mysql_printfld('a19', 'nr01', 'p01=? and p02=? and p04=? ', array($a10p06, $p701, $p0121))) > 0) {
		$arr1 = array('nr01');
		$arr2 = array(pegasus_mysql_newrec('a19'));
		array_push($arr1, 'p01');
		array_push($arr2, $a10p06);
		array_push($arr1, 'p02');
		array_push($arr2, $p701);
		array_push($arr1, 'p03');
		array_push($arr2, '0');
		array_push($arr1, 'p04');
		array_push($arr2, $p0121);
		pegasus_mysql_insert('a19', $arr1, $arr2);
	}

	if ($update_a19) {
		pegasus_query("SET @new_metr:=0;");
		pegasus_query("UPDATE a19 SET p03=@new_metr:=p03+1 WHERE p01=? and p02=? and p04=? ;", array($a10p06, $p701, $p0121));
		pegasus_mysql_use("SELECT cast(@new_metr as signed) as p01;", $ttt);
	} else {
		pegasus_mysql_use("SELECT p03+1 as p01 FROM a19 WHERE p01=? and p02=? and p04=? ;", $ttt, array($a10p06, $p701, $p0121));
	}


	return  $ttt['p01'];
}





function account__t3_d1_grid_custom_actions($retArray = array())
{

	if (pegasus_module_exists('crm001')) {
		$peg_handler = 'account__t3_d1_open_tab("crm", screen.getContainer_ID());';
		$retArray[]  = array(
			'xtype' => 'pegasusToolBarGridAction',
			'peg_custom_id' => 'account_view_crm',
			'viewModel' => array(
				'type' => 'GridButtonModel',
				'isToolBar' => 1,
				'data' => array(
					'toolBarButton' => 'account_view_crm'
				)
			),
			'icon' => 'crm001_images/d00_16x16.png',
			'text' =>  $_SESSION['peg_dic_account_view_crm'],
			'peghandler' => $peg_handler
		);
	}

	if (pegasus_module_exists('customers')) {
		$peg_handler = 'account__t3_d1_open_tab("a01", screen.getContainer_ID());';
		$retArray[]  = array(
			'xtype' => 'pegasusToolBarGridAction',
			'peg_custom_id' => 'account_view_a01',
			'viewModel' => array(
				'type' => 'GridButtonModel',
				'isToolBar' => 1,
				'data' => array(
					'toolBarButton' => 'account_view_a01'
				)
			),
			'icon' => 'customers_images/a01_16x16.png',
			'text' =>  $_SESSION['peg_dic_account_view_a01'],
			'peghandler' => $peg_handler
		);
	}


	if (pegasus_module_exists('suppliers')) {
		$peg_handler = 'account__t3_d1_open_tab("a00", screen.getContainer_ID());';
		$retArray[]  = array(
			'xtype' => 'pegasusToolBarGridAction',
			'peg_custom_id' => 'account_view_a00',
			'viewModel' => array(
				'type' => 'GridButtonModel',
				'isToolBar' => 1,
				'data' => array(
					'toolBarButton' => 'account_view_a00'
				)
			),
			'icon' => 'suppliers_images/a00_16x16.png',
			'text' =>  $_SESSION['peg_dic_account_view_a00'],
			'peghandler' => $peg_handler
		);
	}


	if (pegasus_module_exists('crm002')) {
		$peg_handler = 'account__t3_d1_open_tab("d01", screen.getContainer_ID());';
		$retArray[]  = array(
			'xtype' => 'pegasusToolBarGridAction',
			'peg_custom_id' => 'account_view_d01',
			'viewModel' => array(
				'type' => 'GridButtonModel',
				'isToolBar' => 1,
				'data' => array(
					'toolBarButton' => 'account_view_d01'
				)
			),
			'icon' => 'crm002_images/calendar_16x16.png',
			'text' =>  $_SESSION['peg_dic_account_view_d01'],
			'peghandler' => $peg_handler
		);
	}


	if (pegasus_module_exists('receipts')) {
		$peg_handler = 'account__t3_d1_open_tab("t08", screen.getContainer_ID());';
		$retArray[]  = array(
			'xtype' => 'pegasusToolBarGridAction',
			'peg_custom_id' => 'account_ins_t08',
			'viewModel' => array(
				'type' => 'GridButtonModel',
				'isToolBar' => 1,
				'data' => array(
					'toolBarButton' => 'account_ins_t08'
				)
			),
			'icon' => 'receipts_images/receipts_16x16.png',
			'text' =>  $_SESSION['peg_dic_account_ins_t08'],
			'peghandler' => $peg_handler
		);
	}

	$peg_handler = 'account__t3_d1_open_tab("t01", screen.getContainer_ID());';
	$retArray[]  = array(
		'xtype' => 'pegasusToolBarGridAction',
		'peg_custom_id' => 'account_view_t01',
		'viewModel' => array(
			'type' => 'GridButtonModel',
			'isToolBar' => 1,
			'data' => array(
				'toolBarButton' => 'account_view_t01'
			)
		),
		'iconCls' => 'fa fa-receipt',
		'text' => $_SESSION['peg_dic_account__t3_d1_free_trans'],
		'peghandler' => $peg_handler
	);

	return $retArray;
}

function peg_account_t3_d_query($data)
{
	
	$fileName   = '';

	$locate_stores  = '';
	if (pegasus_module_exists('stores')) {
		$locate_stores  = " && locate(concat('#',t01.p09,'#'), '". $data['t_kat']."') >0 ";
	}

	$replace_ar = array(
		'##t_pe1##' => date('Y-m-d', strtotime("-" . $data['t_pe1'] . " day")),
		'##t_pe2##' => date('Y-m-d', strtotime("-" . $data['t_pe2'] . " day")),
		'##t_pe3##' => date('Y-m-d', strtotime("-" . $data['t_pe3'] . " day")),
		'##t_kat##' => $locate_stores ,
		'##t_y1##'	=> $data['t_y1'],
		'##t_y2##'	=> $data['t_y2'],
		'##t_kind##' => $data['t_kind'],
		'##where_kind1##' => '',
		'##where_kind2##' => '',
		'##where_d01##' => ' d01.nr01<0 ',
		'##d32p01##' => '',
		'##d32p02##' => '',
		'##d32p03##' => ''
	);
	
	if ($data['t_type'] == 'a01') {
		$fileName = '../account_sql/account_t3_d_customers.sql';
	} else {
		$fileName = '../account_sql/account_t3_d_suppliers.sql';
	}

	$d32query = " select d32.nr01, d32.p01, d32.p02, d32.p03 from d32 ";
	$d32where = " where  ";

	$d32_array = array();
	if ($data['t_type'] == 'a01') {
		pegasus_mysql_use(" $d32query , customers_000 $d32where customers_000.nr01=1 and customers_000.f00_p506 = d32.nr01", $d32_array);
	} elseif ($data['t_type'] == 'a00') {
		pegasus_mysql_use(" $d32query , suppliers_000 $d32where suppliers_000.nr01=1 and suppliers_000.f00_p606 = d32.nr01", $d32_array);
	}

	if ($d32_array['nr01'] > 0) {
		$replace_ar['##where_d01##'] = ' 1=1 ';
		$replace_ar['##d32p01##'] = $d32_array['p01'];
		$replace_ar['##d32p02##'] = $d32_array['p02'];
		$replace_ar['##d32p03##'] = $d32_array['p03'];
	}

	/* ##where_kind1## 
		##where_kind2## */
	if ($data['t_kind'] == 2) {
		$replace_ar['##where_kind1##'] = 'ttmp.p102';
		$replace_ar['##where_kind2##'] = 'ttmp.p102';
	} else {
		$replace_ar['##where_kind1##'] = 'ttmp.ypol';
		$replace_ar['##where_kind2##'] = 'ttmp.ypol';
	}

	$t3_d_query = peg_read_file($fileName);

	if (pegasus_module_exists('crm002')) {
		$t3_d_query = str_replace(array('##startd01join##', '##endd01join##'), array('', ''), $t3_d_query);
	} else {
		$start 		= mb_strripos($t3_d_query, '##startd01join##', 0, 'UTF-8');
		$end   		= mb_strripos($t3_d_query, '##endd01join##', 0, 'UTF-8') +  mb_strlen('##endd01join##', 'UTF-8');
		$tmpstr_rep = mb_substr($t3_d_query, $start, $end - $start, 'UTF-8');
		$t3_d_query = str_replace(
			$tmpstr_rep,
			" left join (select '' as d01p03,  '' as d01nr01, '' as d01p01, 0 filedorder  ) as d01d32 on 1=1 ",
			$t3_d_query
		);
		//echo $t3_d_query . " <br/>". $tmpstr_rep;
	}
	
	peg_write_file("../../tmp/account_query.txt", str_replace(array_keys($replace_ar), array_values($replace_ar), $t3_d_query));
	return str_replace(array_keys($replace_ar), array_values($replace_ar), $t3_d_query);
}



/**
 * Tha kanei return to recname apo to tb vasi aytwn poy exw anagki 
 * @param string $recname
 * @param array $tb //το record  του queryπου βρησκομαι 
 */
function peg_account__t3_d_row_rec($recname, $tb)
{
	$peg_tmp_s4 = 0;
	$peg_tmp_s3 = 0;
	$peg_tmp_s2 = 0;
	$peg_tmp_s2 = 0;
	$peg_tmp_s1 = 0;
	// 		IF p21='30'
	$peg_tmp_p21substr = substr($tb['p21'], 0, 2);
	if ($peg_tmp_p21substr == '30') {
		if ($tb['xr3'] > $tb['pi']) {
			$peg_tmp_s4 = $tb['xr3'] - $tb['pi'];
		}
		if ($tb['xr2'] > $tb['pi']) {
			$peg_tmp_s3 = $tb['xr2'] - $tb['pi'] - $peg_tmp_s4;
		}
		if ($tb['xr1'] > $tb['pi']) {
			$peg_tmp_s2 = $tb['xr1'] - $tb['pi'] - $peg_tmp_s4 - $peg_tmp_s3;
		}
		if ($tb['xr'] > $tb['pi']) {
			$peg_tmp_s1 = $tb['xr'] - $tb['pi'] - $peg_tmp_s4 - $peg_tmp_s3 - $peg_tmp_s2;
		}
	} else if ($peg_tmp_p21substr == '50') {
		if ($tb['pi3'] > $tb['xr']) {
			$peg_tmp_s4 = $tb['pi3'] - $tb['xr'];
		}
		if ($tb['pi2'] > $tb['xr']) {
			$peg_tmp_s3 = $tb['pi2'] - $tb['xr'] - $peg_tmp_s4;
		}
		if ($tb['pi1'] > $tb['xr']) {
			$peg_tmp_s2 = $tb['pi1'] - $tb['xr'] - $peg_tmp_s4 - $peg_tmp_s3;
		}
		if ($tb['pi'] > $tb['xr']) {
			$peg_tmp_s1 = $tb['pi'] - $tb['xr'] - $peg_tmp_s4 - $peg_tmp_s3 - $peg_tmp_s2;
		}
		$peg_tmp_s1 = -1 * $peg_tmp_s1;
		$peg_tmp_s2 = -1 * $peg_tmp_s2;
		$peg_tmp_s3 = -1 * $peg_tmp_s3;
		$peg_tmp_s4 = -1 * $peg_tmp_s4;
	}
	if ($peg_tmp_p21substr == '30' || $peg_tmp_p21substr == '50') {
		$tb['yp1'] = $peg_tmp_s1;
		$tb['yp2'] = $peg_tmp_s2;
		$tb['yp3'] = $peg_tmp_s3;
		$tb['yp4'] = $peg_tmp_s4;
	}
	return $tb[$recname];
}


function peg_account__t5_d_initialize($data, $mmnr01, $mnr01, $_d, $container_id)
{
	$data['message'] = '';
	$data['p_t00eid'] = 0;
	$data['p_t00sko'] = 0;

	if (
		isset($_REQUEST['t_type']) and
		($_REQUEST['t_type'] == 'a01' || $_REQUEST['t_type'] == 'a00')
	) {
		$data['t_type'] = $_REQUEST['t_type'];
	} else {
		$data['t_type'] = 'a01';
	}

	if (peg_dateIsEmpty($data['p_df'])) {
		$data['p_df'] = date('Y-m-d', strtotime("now"));
	}
	if (peg_dateIsEmpty($data['p_dt'])) {
		$data['p_dt'] = date('Y-m-d', strtotime("now"));
	}

	$d32_array = array();
	$d32query = " select d32.nr01, d32.p00, d32.p01, d32.p02, d32.p03, d32.p30 , d32.p011, d32.p012, d32.p010 from d32 ";
	$d32where = " where  ";
	if ($data['t_type'] == 'a01') {
		pegasus_mysql_use(" $d32query , customers_000 $d32where customers_000.nr01=1 and customers_000.f00_p506 = d32.nr01", $d32_array);
	} else if ($data['t_type'] == 'a00') {
		pegasus_mysql_use(" $d32query , suppliers_000 $d32where suppliers_000.nr01=1 and suppliers_000.f00_p606 = d32.nr01", $d32_array);
	}


	if (!pegasus_module_exists('crm002')) {
		$data['message'] = $_SESSION['peg_dic_account_non_existent_crm002'];
	} else if (empty($d32_array['nr01'])) {
		// 			$data['t_type']
		if ($data['t_type'] == 'a01') {
			$data['message'] = $_SESSION['peg_dic_account_undefined_d32nrtoa01'];
		} else {
			$data['message'] = $_SESSION['peg_dic_account_undefined_d32nrtoa00'];
		}
	}


	//@p_t00eid
	if (!empty($d32_array['p01']))
		$data['p_t00eid']  = $d32_array['p01'];

	//@p_t00sko
	if (!empty($d32_array['p02']))
		$data['p_t00sko']  = $d32_array['p02'];


	if (!empty($data['message'])) {
		$data['message'] = '<div class="alert_message">' . $data['message'] . '</div>';
	} else {
		$data['message_hidden'] = 1;
	}

	if (pegasus_module_exists('crm002')) {
		$data['account__t5_d_p_df_hidden'] = 0;
		$data['account__t5_d_p_dt_hidden'] = 0;
		$data['account__t5_d_d02p01_hidden'] = 0;
		$data['account__t5_d_bt01_hidden'] = 0;
		$data['account__t5_d_grid_hidden'] = 0;
	} else {
		$data['account__t5_d_p_df_hidden'] = 1;
		$data['account__t5_d_p_dt_hidden'] = 1;
		$data['account__t5_d_d02p01_hidden'] = 1;
		$data['account__t5_d_bt01_hidden'] = 1;
		$data['account__t5_d_grid_hidden'] = 1;
	}

	//To query tou grid
	pegasusSetGlobalVar('_t5_d2_query_'  . $container_id, peg_account__t5_d2_query($data));
	return $data;
}

function peg_account__t5_d2_query($data)
{
	$fileName = '../account_sql/account__t5_d2.sql';
	$replace_ar = array(
		'##p_t00fld2##' => ''
	);

	//Katastasi epadis
	if (!empty($data['d02p01'])) {
		$replace_ar['##p_t00fld2##'] = ' d01.p06 = "' . $data['d02p01'] . '" ';
	} else {
		$replace_ar['##p_t00fld2##'] = ' d01.p06 >= 0 ';
	}

	//Hmerominia Epafis
	$replace_ar['##p_t00fld1##'] =
		' d01.p03>="' . $data['p_df'] . '" and ' .
		' d01.p03<="' . $data['p_dt'] . '" ';
	$replace_ar['##p_t00eid##']  = $data['p_t00eid'];
	$replace_ar['##p_t00sko##']  = $data['p_t00sko'];

	$t5_d2_query = peg_read_file($fileName);

	// 		echo str_replace(array_keys($replace_ar), array_values($replace_ar), $t5_d2_query);
	return str_replace(array_keys($replace_ar), array_values($replace_ar), $t5_d2_query);
}

function peg_account__t5_d2_query_sum($p_df = '', $p_dt = '', $t_type = '')
{

	if (!pegasus_module_exists("crm002")) {
		return peg002_format_number(0, 2);
	}

	if (empty($p_df)) {
		$p_df = date('Y-m-d');
	}
	if (empty($p_dt)) {
		$p_dt = date('Y-m-d');
	}
	if ($t_type == 'a01') {
		pegasus_mysql_use("select d32.p01, d32.p02 from d32, customers_000 where customers_000.nr01=1 and customers_000.f00_p506 = d32.nr01", $d32_array);
	} else { //type = a00
		pegasus_mysql_use("select d32.p01, d32.p02 from d32, suppliers_000 where suppliers_000.nr01=1 and suppliers_000.f00_p606 = d32.nr01", $d32_array);
	}

	$t5_data = array("p_t00eid" => $d32_array['p01'], "p_t00sko" => $d32_array['p02'], "p_df" => $p_df, "p_dt" => $p_dt);
	if (empty($t5_data["p_t00eid"]) || empty($t5_data["p_t00sko"])) {
		return peg002_format_number(0, 2);
	}
	$t5_data_query = peg_account__t5_d2_query($t5_data);
	$t5_data_query  = str_replace(";", "", $t5_data_query);
	pegasus_mysql_use('select sum(p04) as p04 from (' . $t5_data_query . ') as ttt', $t5_sum);

	return peg002_format_number($t5_sum['p04'], 2);
}

function peg_account_a26_d_initialize($data, $mmnr01 = '', $mnr01 = '', $_d = '', $container_id = '')
{
	if ($_d == 'a26_d') {
		if (empty($data['nr01'])) {
			$data['nr01'] = pegasus_mysql_newrec("a26");
			$peg_is_newrec = 1;
		}

		$whereTmpTbl = ' peg_flag!=9 and ' .
			' peg_sess_id="' . session_id() . '"  and ' .
			' peg_mmnr01="a26_d-' . $data['nr01']  . '" and  ' .
			' peg_mnr01="' . $data['nr01']  . '" ';
		$whereTmpTbl_prep = ' peg_flag!=9 and 
							  peg_sess_id=:peg_sess_id  and 
							  peg_mmnr01=:peg_mmnr01 and 
							  peg_mnr01=:peg_mnr01';
		$whereTmpTbl_prep_arr = array(
			'peg_sess_id'	=>	session_id(),
			'peg_mmnr01'	=>	'a26_d-' . $data['nr01'],
			'peg_mnr01'	=>	$data['nr01']
		);
		//Dimiourgoume ola ta tmp
		pegasus_make_all_tmp_recs('a26', $data, $data['nr01'], $_REQUEST['rec_copy_nr01'], 'a26_d-' . $data['nr01']);

		//pegasusSetGlobalVar($container_id . '_where', ' peg_tmp_a27.p1="' . $data['p01']  . '" and ' . $whereTmpTbl);
		$where_prep = array(
			'sql'		=>	' peg_tmp_a27.p1=:v_a27p1 and ' . $whereTmpTbl_prep,
			'sqlParams'	=>	array_merge(array('v_a27p1' => $data['p01']), $whereTmpTbl_prep_arr)
		);
		pegasusSetGlobalVar(
			$container_id . '_where_prep',
			$where_prep
		);
		
		$peg_p01 = pegasus_mysql_printfld( 'a26' , 'p01' , 'nr01=?', array($data['nr01']) );
		if(empty($peg_p01)){
			$peg_p01=0;
		}

		$sql= "select 
			ifnull(peg_tmp_a27.nr01, 0) as nr01,  
			ifnull(peg_tmp_a27.p1, :peg_p01 ) as p1,  
			ifnull(peg_tmp_a27.p2, i13.p01) as p2,  
			i13.p02 as vp2, 
			ifnull(peg_tmp_a27.p3, i13.p01) as p3,
			i13_01.p02 as vp3
		
		from i13
		LEFT JOIN peg_tmp_a27  ON peg_tmp_a27.p2=i13.p01 and " .$where_prep['sql'] . "
		LEFT JOIN i13 as i13_01  ON peg_tmp_a27.p3=i13_01.p01 ";
		$sql_params=array_merge(array( 'peg_p01' => $peg_p01 ), $where_prep['sqlParams'] ) ;
		pegasusSetGlobalVar(
			$container_id . '_query_prep',
			array(
				'sql'       =>  $sql,
				'sqlParams' =>  $sql_params
			)
		);
	}
	return $data;
}

function peg_account_a26_d_before_save($container_id)
{
	$where = pegasusGetGlobalVar($container_id . '_where_prep');
	pegasus_mysql_update('peg_tmp_a27' , array('p1') , array($_REQUEST['p01']) , $where['sql'],0,1,1,$where['sqlParams']  );
}

function peg_account_t00_d_initialize($data, $mmnr01 = '', $mnr01 = '', $_d = '', $container_id = '')
{
	if ($_d == 't00_d') {

		$tmp_str = "substr(p01, 1, 2)=? ";
		if (pegasus_mysql_printfld('t14', 'nr01', $tmp_str, array(substr($data['p01'], 0, 2))) <> 0) {
			$data['readonly'] = 1;
		}

		$peg_tmpquery = "select sum(p03) as p03
              FROM t00tot
              WHERE t00tot.p01=?";
		$peg_tmpres = pegasus_query($peg_tmpquery, array($data['p01']));
		$peg_tmprec = pegasus_fetch($peg_tmpres);
		$data['t_p01'] = $peg_tmprec['p03'];

		$data['account_t00_d_toolbarbutton_140000028000031_hidden'] = true;
		$data['account_t00_d_toolbarbutton_140000007000052_hidden'] = true;

		if(substr($data['p01'],0,2) =="30" ){
			$data['account_t00_d_toolbarbutton_140000007000052_hidden'] = false;
		}else if(substr($data['p01'],0,2) =="50" ){
			if(pegasus_module_exists('suppliers')){
				$data['account_t00_d_toolbarbutton_140000028000031_hidden'] = false;
			}
		}
	}

	return $data;
}

function peg_account_t01_d100_initialize($data, $mmnr01 = '', $mnr01 = '', $_d = '', $container_id = '')
{

	$data['account_t01_d102_grid_account_view_relation_hidden'] = false;
	$data['account_t01_d102_grid_account_copy_t01_hidden'] = false;
	if ($_d == 't01_d100') {

		//TODO: Να εμφανίσουμε το νόμισμα μόνο αν έχει νόημα (παραπάνω από ένα νομίσματα)
		//$data['t_nom_hidden'] = 1;

		if (pegasus_module_exists('stores')) {

			if (function_exists('peg_stores_get_all_stores_multi')) {
				$data['t_kat'] = peg_stores_get_all_stores_multi(1);
			}
		}

		if (!pegasus_module_exists('stores')) {
			$data['t_kat_hidden'] = 1;
		}

		pegasusSetGlobalVar('peg_' . $container_id . '_mmnr01', $mmnr01);

		if (substr($mmnr01, 0, 5) == 'a00_d') {
			pegasusSetGlobalVar(
				'peg_' . $container_id . '_a00_select_where',
				array(
					'sql'		=>	"p601=:v_a00_nr01",
					'sqlParams'	=>	array('v_a00_nr01'	=> 	substr($mmnr01, 6))
				)
			);

			$data['t_ypok_a01_hidden'] = 1;
			$data['p503_hidden'] = 1;
			$data['p504_hidden'] = 1;

			// $tmp_peg_t_log = $_REQUEST['peg_t_log'];
			$tmp_peg_t_log = pegasus_mysql_printfld('a00', 'p21', 'nr01=:nr01', array('nr01' => substr($mmnr01, 6)));
			if (!empty($tmp_peg_t_log)) {
				$data['t_lo']  = $tmp_peg_t_log;
				$data['peg_t_log_readonly'] = 1;
			}
		} else if (substr($mmnr01, 0, 5) == 'a01_d') {
			pegasusSetGlobalVar(
				'peg_' . $container_id . '_a01_select_where',
				array(
					'sql'		=>	"p601=:v_a01_nr01",
					'sqlParams'	=>	array('v_a01_nr01'	=> 	substr($mmnr01, 6))
				)
			);

			$data['t_ypok_a00_hidden'] = 1;
			$data['p503_hidden'] = 1;
			$data['p504_hidden'] = 1;

			// $tmp_peg_t_log = $_REQUEST['peg_t_log']; -> Ήταν η λογική πριν την ομαδοποίηση του Toolbar 
			$tmp_peg_t_log = pegasus_mysql_printfld('a01', 'p21', 'nr01=:nr01', array('nr01' => substr($mmnr01, 6)));
			if (!empty($tmp_peg_t_log)) {
				$data['t_lo']  = $tmp_peg_t_log;
				$data['peg_t_log_readonly'] = 1;
			}
		}else if (substr($mmnr01, 0, 8) == 'hota14_d'){
			$data['p503_hidden'] = 1;
			$data['p504_hidden'] = 1;
			$data['t_ypok_a00_hidden'] = 1;
			$data['t_ypok_a01_hidden'] = 1;
			$data['t_nom_hidden'] = 1;
			$data['t_lo_hidden']  = 2;
			$data['hota14_nr01'] = $mnr01;
			pegasus_mysql_use(
				"SELECT a01.p21 as t_log 
					from hota14 
					join a01 on a01.nr01 = hota14.pnr01
					where hota14.nr01=:hota14_nr01",
				$tbl,
				array("hota14_nr01" => $mnr01)
			);
			$data['t_lo'] = $tbl['t_log'];
		}else if ( substr($mmnr01, 0, 5) == 'd25_d' || substr($mmnr01, 0, 5) == 'd35_d') {
			if(function_exists('peg_projects_t01_d100_initialize') ){
				$data = peg_projects_t01_d100_initialize($data, $mmnr01, $mnr01, $_d, $container_id);
			}
		}
		else if (empty($mmnr01)){ //Καρτέλα λογαριασμού
			$data['p503_hidden'] = 1;
			$data['p504_hidden'] = 1;
			$data['t_ypok_a00_hidden'] = 1;
			$data['t_ypok_a01_hidden'] = 1;
			// $data['t_nom_hidden'] = 1;

		}

		$data['t_df'] = date('Y-01-01');
		$data['t_dt'] = date('Y-m-d');

		$t_df = pegasusGetSuperGlobalVar('account_t01_d100_t_df_'.$_SESSION['username']);
		
		$t_dt = pegasusGetSuperGlobalVar('account_t01_d100_t_dt_'.$_SESSION['username']);
		if(!empty($t_dt)) {
			$date_diff = peg_dateDiff(date('Y-m-d'), $t_dt, 'Y-m-d');
			// Αν η σημερινή ημερομηνία Έως είναι μεγαλύτερη από την σημερινή ημερομηνία, τότε αρχικοποιείται με την σημερινή, αλλιώς παραμένει η ήδη υπάρχουσα
			if($date_diff > 0) {
				$data['t_dt'] = date('Y-m-d');
			} else {
				$data['t_dt'] = $t_dt;
			}
			
			// Αν η Ημερομηνία Από είναι μεγαλύτερη από την Εως τότε αρχικοποιείται με 1/1 της χρονιάς που διανύουμε 
			if($t_df > $t_dt){
				$t_df = date('Y-01-01');
			}
		}

		if(!empty($t_df)) {
			$data['t_df'] = $t_df;
		}
	}

	$data['mmnr01'] = $mmnr01;

	account_t01_d100_set_grid_query($container_id, $data);

	return $data;
}

/**
 * Set peg_'.$container_id.'_grid_query για το table_query του grid του t01_d100
 * @param string $container_id 
 * @param array $datas Έχει τα κριτήρια αναζήτησης της t01_d100 και το mmnr01  
 */
function account_t01_d100_set_grid_query($container_id, $datas)
{
	$mmnr01 = $datas['mmnr01'];
	
	if (substr($mmnr01, 0, 5) == 'a01_d') {
		$_d = "a01_d";
	}
	if (substr($mmnr01, 0, 5) == 'a00_d') {
		$_d = "a00_d";
	}
	if (substr($mmnr01, 0, 5) == 'd25_d') {
		$_d = "d25_d";
	}
	if (substr($mmnr01, 0, 5) == 'd35_d') {
		$_d = "d25_d";
	}
	if (substr($mmnr01, 0, 8) == 'hota14_d') {
		$_d = "hota14_d";
	}
	if (substr($mmnr01, 0, 5) == 't01_d100') {
		$_d = "t01_d100";
	}	

	$tmp_array = account_t01_d100_find_grid_query($mmnr01, $datas, $_d);
	pegasusSetGlobalVar(
		'peg_' . $container_id . '_grid_query',
		array(
			'sql' => $tmp_array['sql'],
			'sqlParams' => $tmp_array['sqlParams']
		)
	);

	// if ($_d == 'd25_d') {
	// 	$tmp_array = projects_t01_d100_find_grid_query_2($mmnr01, $datas);
	// } else if ($_d == 'd35_d') {
	// 	$tmp_array = projects_t01_d100_find_grid_query_2($mmnr01, $datas);
	// }else if(substr($mmnr01, 0, 8) == 'hota14_d'){
	// 	$tmp_array = hot002_t01_d100_find_grid_query_2($mmnr01, $datas);
	// } else {
	// 	$tmp_array = account_t01_d100_find_grid_query_2($mmnr01, $datas, $_d);
	// }

	$tmp_array = account_t01_d100_find_grid_query_2($mmnr01, $datas, $_d);
	pegasusSetGlobalVar(
		'peg_' . $container_id . '_grid_query_2',
		array(
			'sql' => $tmp_array['sql'],
			'sqlParams' => $tmp_array['sqlParams']
		)
	);

	// query gia Κινήσεις ανά Μήνα ή Έτος

	$tmp_array = account_t01_d100_find_grid_query_3($mmnr01, $datas, $_d);
	pegasusSetGlobalVar(
		'peg_' . $container_id . '_grid_query_3',
		array(
			'sql' => $tmp_array['sql'],
			'sqlParams' => $tmp_array['sqlParams']
		)
	);
	if(pegasus_module_exists('account01')){
		$tmp_array = account01_account_t01_d100_find_grid_query_4($mmnr01, $datas, $_d);
		pegasusSetGlobalVar(
			'peg_' . $container_id . '_grid_query_4',
			array(
				'sql' => $tmp_array['sql'],
				'sqlParams' => $tmp_array['sqlParams']
			)
		);
	}

	//Super Global Μεταβλητές για την αποθήκευση της τελευταίας αναζήτησης των ημερομηνιών
	pegasusSetSuperGlobalVar('account_t01_d100_t_df_'.$_SESSION['username'], substr($datas['t_df'], 0, 10));
	pegasusSetSuperGlobalVar('account_t01_d100_t_dt_'.$_SESSION['username'], substr($datas['t_dt'], 0, 10));
}

/**
 * @param string $mmnr01 
 * @param array $datas
 */
function account_t01_d100_find_grid_query($mmnr01, $datas, $_d)
{

	$module_invsupp_exists = pegasus_module_exists('invsupp');
	$module_invcust_exists = pegasus_module_exists('invcust');
	$module_receipts_exists = pegasus_module_exists('receipts');

	//TODO: Θα πρέπει να εμφανίσουμε τα πεδία έργου, εργασίας και υποκαταστημάτων στην καρτέλα λογαριασμού και να φτιάξουμε τα where

	$t01_d100_params = array();

	$t01_d100_params['tmp_df']  = $datas['t_df'];
	$t01_d100_params['tmp_dt']  = $datas['t_dt'];
	//Παράμετροι του query
	if ( $_d == 'd25_d') {
		$t01_d100_params['var_p503'] = $datas['p503'];
	} else if ( $_d == 'd35_d') {
		$t01_d100_params['var_p504'] = str_replace("#", '', $datas['p504']);//TODO: Να δούμε αν χρειάζεται το replace
		//$t01_d100_params['tmp_ergasia'] = $datas['p504'];
	} else if($_d == 'hota14_d'){
		$t01_d100_params['tmp_lo']  = $datas['t_lo'];
		$t01_d100_params['tmp_ypok'] = '';
		$hota14_nr01 = explode('-',$mmnr01)[1]; //Στην περίπτωση του refresh διαβάζει το mmnr01 
		$t01_d100_params['hota14_nr01']  = empty($datas['hota14_nr01']) ? $hota14_nr01  : $datas['hota14_nr01'];
	} else{ //Οικονομική καρτέλα πελάτη/προμηθευτη/Καρτέλα λογαριασμού
		$t01_d100_params['tmp_lo']  = $datas['t_lo'];
		if ( $_d == 'a00_d') {
			$t01_d100_params['tmp_ypok'] = $datas['t_ypok_a00'];

		} elseif ( $_d == 'a01_d') {
			$t01_d100_params['tmp_ypok'] = $datas['t_ypok_a01'];
		} else{
			$t01_d100_params['tmp_ypok'] = $datas['t_ypok_a00'];
			if(empty($t01_d100_params['tmp_ypok'])){
				$t01_d100_params['tmp_ypok'] = $datas['t_ypok_a01'];
			}
		}
		if (!($t01_d100_params['tmp_ypok'] > 0) && ($t01_d100_params['tmp_ypok'] != -1)) {
			$t01_d100_params['tmp_ypok'] = '';
		}
	}
	$extra_join = '';
	if ($module_invsupp_exists) {
		$extra_join = " LEFT JOIN a56 ON a56.nr01=t01.p302 and t01.p303 in (1,3) ";
		$extra_join .= " LEFT JOIN a11 ON a11.p01=a56.p05 ";
	}
	if ($module_receipts_exists) {

		$extra_join .= " LEFT JOIN t08 ON t08.nr01=t01.p302 and t01.p303 in (6,13) ";
		$extra_join .= " LEFT JOIN t10 ON t10.p01=t08.p05 ";
	}

	if ($module_invcust_exists) {
		$extra_join .= " LEFT JOIN a55 ON a55.nr01=t01.p302 and t01.p303 in (2,4,9) ";
		$extra_join .= " LEFT JOIN a10 ON a10.p01=a55.p05 ";
		if($_d == 'hota14_d'){
			$extra_join .= " LEFT JOIN i01 on i01.p06 = a55.nr01  and i01.p07 = '2'
							 LEFT JOIN hot002_01 on hot002_01.hota14=:hota14_nr01 and i01.pd101='hota002_01' and i01.pd102=hot002_01.nr01 ";
		}
	}

	if( $_d == 'd35_d'){
		$extra_where = " AND t01.p504=:var_p504 ";
	}elseif( $_d == 'd25_d'){
		$extra_where = " AND t01.p503=:var_p503 ";
	}elseif( $_d == 'hota14_d'){
		$extra_where = " AND t01.p01=:tmp_lo AND (:tmp_ypok='' OR :tmp_ypok=0 OR t01.p900=:tmp_ypok OR (:tmp_ypok = -1 AND t01.p900=0)) ";
		if($module_invcust_exists){
			$extra_where .= " AND ((t01.pd101='hota14' AND t01.pd102=:hota14_nr01) OR (hot002_01.nr01 IS NOT NULL)) ";
		}
		else{
			$extra_where .= " AND t01.pd101='hota14' AND t01.pd102=:hota14_nr01 ";
		}
	}
	else{
		$extra_where = " AND t01.p01=:tmp_lo AND (:tmp_ypok='' OR :tmp_ypok=0 OR t01.p900=:tmp_ypok OR (:tmp_ypok = -1 AND t01.p900=0)) ";
	}

	$extra_select = ' , ##replace_tag_p06_1## as p06_1
					  , ##replace_tag_p701## as p701
					  , ##replace_tag_v_p702## as v_p702
					  , ##replace_tag_v_desc## as v_desc';
					  
	if($module_invsupp_exists){
		$extra_select = str_replace('##replace_tag_p06_1##', 'if(a56.p06 IS NULL, ##replace_tag_p06_1## , a56.p06)', $extra_select );
		$extra_select = str_replace('##replace_tag_p701##', 'if(a56.p701 IS NULL, ##replace_tag_p701## , a56.p701)', $extra_select );
		$extra_select = str_replace('##replace_tag_v_p702##', 'if(a56.p702 IS NULL, ##replace_tag_v_p702## , a56.p702)', $extra_select );
		$extra_select = str_replace('##replace_tag_v_desc##', 'if(a11.p02 IS NULL, ##replace_tag_v_desc## , a11.p02)', $extra_select );
	}
	if($module_invcust_exists){
		$extra_select = str_replace('##replace_tag_p06_1##', 'if(a55.p06 IS NULL, ##replace_tag_p06_1## , a55.p06)', $extra_select );
		$extra_select = str_replace('##replace_tag_p701##', 'if(a55.p701 IS NULL, ##replace_tag_p701## , a55.p701)', $extra_select );
		$extra_select = str_replace('##replace_tag_v_p702##', 'if(a55.p702 IS NULL, ##replace_tag_v_p702## , a55.p702)', $extra_select );
		$extra_select = str_replace('##replace_tag_v_desc##', 'if(a10.p02 IS NULL, ##replace_tag_v_desc## , a10.p02)', $extra_select );
	}
	if($module_receipts_exists){
		$extra_select = str_replace('##replace_tag_p06_1##', 'if(t08.p06 IS NULL, ##replace_tag_p06_1## , t08.p06)', $extra_select );
		$extra_select = str_replace('##replace_tag_p701##', 'if(t08.p701 IS NULL, ##replace_tag_p701## , t08.p701)', $extra_select );
		$extra_select = str_replace('##replace_tag_v_desc##', 'if(t10.p02 IS NULL, ##replace_tag_v_desc## , t10.p02)', $extra_select );
	}
	$extra_select = str_replace('##replace_tag_p06_1##', '" "', $extra_select );
	$extra_select = str_replace('##replace_tag_p701##', '" "', $extra_select );
	$extra_select = str_replace('##replace_tag_v_p702##', '" "', $extra_select );
	$extra_select = str_replace('##replace_tag_v_desc##', '" "', $extra_select );
	
	if (pegasus_module_exists('stores')) {
		$locate_stores  = " && locate(concat('#',t01.p09,'#'), :tmp_kat) >0 ";
		$t01_d100_params['tmp_kat'] = $datas['t_kat'];
	}

	// if empty currency then all, else only this currency transactions
	$tmp_p03 = 't01.p03';
	$tmp_p04 = 't01.p04';
	$tmp_cond1 = " t01.nr01>=0 ";
	if (!empty($datas['t_nom'])) {
		$t01_d100_params['t_nom'] = $datas['t_nom'];
		$tmp_cond1 = " t01.pn01=:t_nom ";
	};

	$tmp_query =  " SELECT tabl01.*, (@sum := @sum + tabl01.p03-tabl01.p04) as tmp_p01 
					FROM 
					(    /*********************************
							tabl01=all final records
						**********************************/  
					/*************************
						find previous total
					**************************/     
					(select  0 as nr01, 
							cast('01000101' as date)  as p02, 
							'' as p02t,
							if(sum($tmp_p03-$tmp_p04)>0, sum($tmp_p03-$tmp_p04), 0)  as p03, 
							if(sum($tmp_p04-$tmp_p03)>0, sum($tmp_p04-$tmp_p03), 0)  as p04, 
							'" . $_SESSION['peg_dic_account_t01_011'] . "'  as p05, 
							''  as p06, 
							0  as p07, 
							'' as v_selectbox_p07, 
							0  as p09, 
							'' as v_selectbox_p09, 
							0 as p101, 
							0 as p201, 
							'' as p401, 
							'' as v_selectbox_p401, 
							'' as pn01, 
							0 as pn02, 
							0 as pn03, 
							0 as pn04, 
							0 as p302, 
							0 as p303,
							'' as p01,
							'' as p06_1,
							'' as p701,
							'' as v_p702,
							'' as v_desc
					FROM t01 ";
	
	$tmp_query .= $extra_join ;
	$tmp_query .= " WHERE t01.p02<:tmp_df
						$locate_stores   
						&& $tmp_cond1 $extra_where";

																	
	$tmp_query .= "						)
					
					union ALL    

					/*****************************
						analysis into period
					*****************************/
					(select  t01.nr01 as nr01, 
							t01.p02  as p02, 
							t01.p02t  as p02t,
							$tmp_p03  as p03,
							$tmp_p04  as p04,         
							t01.p05  as p05, 
							t01.p06  as p06, 
							t01.p07  as p07, 
							ifnull(t02.p02, '')  as v_selectbox_p07, 
							t01.p09  as p09, ";

	if (pegasus_mysql_table_exists('t07')) {
		$tmp_query .= "ifnull(t07.p02, '')  as v_selectbox_p09, ";
	} else {
		$tmp_query .= "''  as v_selectbox_p09, ";
	}

	$tmp_query .= "           
							t01.p101 as p101, 
							t01.p201 as p201, 
							t01.p401 as p401, 
							ifnull(us0.p100, '') as v_selectbox_p401, 
							t01.pn01 as pn01, 
							t01.pn02 as pn02, 
							t01.pn03 as pn03, 
							t01.pn04 as pn04, 
							t01.p302 as p302,
							t01.p303 as p303,
							t01.p01  as p01";

	$tmp_query .= $extra_select;

	$tmp_query .= "	FROM t01 
					LEFT JOIN t02 ON t02.p01=t01.p07 ";

	if (pegasus_mysql_table_exists('t07')) {
		$tmp_query .= "  LEFT JOIN t07 ON t07.p01=t01.p09 ";
	}
	
	$tmp_query .= $extra_join;

	$tmp_query .= "			
							LEFT JOIN us0 ON us0.p01=t01.p401 
							WHERE t01.p02>=:tmp_df
								&& t01.p02<=:tmp_dt
								$locate_stores
								&& $tmp_cond1   
								$extra_where
							)	  
							ORDER BY p02 , nr01
							) as tabl01,
							(select @sum := 0) AS params;";

	// peg_write_file('../../tmp/account_balance.sql',pegasus_replace_values_in_sql($tmp_query,$t01_d100_params));
	// echo pegasus_replace_values_in_sql($tmp_query, $t01_d100_params);
	return array(
		'sql' => $tmp_query,
		'sqlParams' => $t01_d100_params
	);
}

/**
 * @param string $mmnr01 
 * @param array $datas
 */
function account_t01_d100_find_grid_query_2($mmnr01, $datas, $_d)
{
	$tmp_query = "";
	$t01_d100_params = array();

	// ΓΡΑΜΜΕΣ
	// Σύνολα έως
	// Σύνολα Περιόδου
	// Γενικά Σύνολα

	// ΣΤΗΛΕΣ
	// "Σύνολο Χρεώσεων" (p02), "Σύνολο Πιστώσεων" (p03), "Υπόλοιπο" (p04)

	$t01_d100_params['metafora'] = $_SESSION['peg_dic_account_t01_d103_lex_1'] ." (" . peg_dateToStr($datas['t_df'], 'd/m/Y').")";
	$t01_d100_params['periodou'] = $_SESSION['peg_dic_account_t01_d103_lex_2'] ." (" . peg_dateToStr($datas['t_df'], 'd/m/Y'). "-".peg_dateToStr($datas['t_dt'], ' d/m/Y').")";
	$t01_d100_params['genika'] = $_SESSION['peg_dic_account_t01_d103_lex_3'];
	$t01_d100_params['tmp_lo']  = $datas['t_lo'];
	$t01_d100_params['tmp_df']  = $datas['t_df'];
	$t01_d100_params['tmp_dt']  = $datas['t_dt'];
	$t01_d100_params['tmp_ypok'] = '';

	if ( $_d == 'a00_d' || $_d == 't01_d100') {
		$t01_d100_params['tmp_ypok'] = $datas['t_ypok_a00'];
	}else if ( $_d == 'a01_d' || $_d == 't01_d100') {
		$t01_d100_params['tmp_ypok'] = $datas['t_ypok_a01'];
	}else if ( $_d == 'd25_d') {
		$t01_d100_params['var_p503'] = $datas['p503'];
	}else if ( $_d == 'd35_d') {
		$t01_d100_params['var_p504'] = $datas['p504'];
	} else if($_d == 'hota14_d'){
		$hota14_nr01 = explode('-',$mmnr01)[1]; //Στην περίπτωση του refresh διαβάζει το mmnr01 
		$t01_d100_params['hota14_nr01']  = empty($datas['hota14_nr01']) ? $hota14_nr01  : $datas['hota14_nr01'];
	}

	// if empty currency then all, else only this currency transactions
	$where_nom = '';
	if(!empty($datas['t_nom'])) {
		$tmp_p03 = 't01.pn03';
		$tmp_p04 = 't01.pn04';
		$where_nom = ' AND t01.pn01=:t_nom ';
		$t01_d100_params['t_nom'] = $datas['t_nom'];
	}else{
		$tmp_p03 = 't01.p03';
		$tmp_p04 = 't01.p04';
		
	};

	if (pegasus_module_exists('stores')) {
		if($_d == 'd00_d56'){
			$tmp_kat = explode('#', $datas['p301']);
			$tmp_kat = array_slice($tmp_kat, 1, count($tmp_kat) - 2);
			$tmp_kat_in = pegasus_mysql_create_in($tmp_kat, 'kat_in');

			$locate_stores = " && t01.p09 IN (:kat) ";

			$locate_stores = str_replace(':kat', $tmp_kat_in['sql'], $locate_stores);
			$t01_d100_params = array_merge($t01_d100_params, $tmp_kat_in['sqlParams']);
			
		}else{
			$locate_stores  = " && locate(concat('#',t01.p09,'#'), :tmp_kat) >0 ";
			$t01_d100_params['tmp_kat'] = $datas['t_kat'];
		}
		
	}
	/*t02.p012: Μηνιαία κατάσταση φορολογικών στοιχείων: 
	Σε συνεννόηση με τον Δημητρη είδαμε ότι αυτό μπήκε προκειμένου να καλύψουμε την περίπτωση κάποιας λογιστικής κίνησης που δεν θα έπρεπε να έχει καθαρα. 
	Είχαμε κάποιο τέτοιο bug π.χ. στην Φορτωτική
	*/
	//t01.p080: ακυρωτικό
	//t02.p03: Συντελεστής χρεωσης  t02.p04: Συντελεστής πίστωσης 
	//t01.p03: χρέωση  t01.p04: πίστωση
	$tmp_p101 = " if(ifnull(t02.p012, 0)<=1, 0, 1) * if(t01.p080=1, -1, 1) * if(ifnull(t02.p03 + t02.p04, t01.p03+t01.p04)>0, 1, -1) * abs(t01.p101)";
	$tmp_p201 = " if(ifnull(t02.p012, 0)<=1, 0, 1) * if(t01.p080=1, -1, 1) * if(ifnull(t02.p03 + t02.p04, t01.p03+t01.p04)>0, 1, -1) * abs(t01.p201)";

	$extra_join = '';
	if( $_d == 'd35_d'){
		$extra_where = " AND t01.p504=:var_p504 ";
	}elseif( $_d == 'd25_d'){
		$extra_where = " AND t01.p503=:var_p503 ";
	}
	elseif( $_d == 'hota14_d'){
		$extra_where = " AND t01.p01=:tmp_lo AND (:tmp_ypok='' OR :tmp_ypok=0 OR t01.p900=:tmp_ypok OR (:tmp_ypok = -1 AND t01.p900=0)) ";
		if(pegasus_module_exists('invcust')){
				$extra_where .= " AND ((t01.pd101='hota14' AND t01.pd102=:hota14_nr01) OR (hot002_01.nr01 IS NOT NULL)) ";
				$extra_join   = " LEFT JOIN a55 ON a55.nr01=t01.p302 and t01.p303 in (2,4) 
								 LEFT JOIN i01 on i01.p06 = a55.nr01  and i01.p07 = '2'
								 LEFT JOIN hot002_01 on hot002_01.hota14=:hota14_nr01 and i01.pd101='hota002_01' and i01.pd102=hot002_01.nr01 ";
		}
		else{
			$extra_where .= " AND t01.pd101='hota14' AND t01.pd102=:hota14_nr01 ";
		}
	}elseif($_d == 'd00_d56'){
		$separated_datas = crm001_separate_a00_a01_data($datas['p302'], $datas['p303']);
		if(!empty($datas['p303'])){
			$extra_where = " AND ( ( t01.p01 IN (:a01_p302) AND t01.p900 IN (:a01_p303) ) OR ( t01.p01 IN (:a00_p302) AND t01.p900 IN (:a00_p303) ) ) ";
			
		}else{
			$extra_where = " AND ( ( t01.p01 IN (:a01_p302) ) OR ( t01.p01 IN (:a00_p302) ) ) ";
		}
		$tmp = crm001_replace_a00_a01_data($separated_datas, $extra_where, $t01_d100_params);
			$extra_where = $tmp['table_query'];
			$t01_d100_params = $tmp['sqlParams'];
		
	}
	else{
		$extra_where = " AND t01.p01=:tmp_lo AND (:tmp_ypok='' OR :tmp_ypok=0 OR t01.p900=:tmp_ypok OR (:tmp_ypok = -1 AND t01.p900=0)) ";
	}

	$tmp_query =  " SELECT tabl01.* FROM 
					/*************************
						find previous total
					**************************/     
					(SELECT 
							1 as pos,
							:metafora  as p01, 
							sum($tmp_p03)  as p02, 
							sum($tmp_p04) as p03,
							sum($tmp_p03-$tmp_p04)  as p04,
							sum( $tmp_p101 ) AS p05,
							sum( $tmp_p201 ) AS p06 	
					FROM t01 
					LEFT JOIN t02 ON t02.p01=t01.p07
					$extra_join
					WHERE  t01.p02<:tmp_df
						$locate_stores   
						$extra_where
						$where_nom

					UNION ALL    
					
					/*****************************
						analysis into period
					*****************************/
					SELECT  
							2 as pos,
							:periodou  as p01, 
							sum($tmp_p03)  as p02, 
							sum($tmp_p04) as p03,
							sum($tmp_p03-$tmp_p04)  as p04,
							sum( $tmp_p101 ) AS p05,
							sum( $tmp_p201 ) AS p06 	
					FROM t01 
					LEFT JOIN t02 ON t02.p01=t01.p07
					$extra_join
					WHERE   t01.p02>=:tmp_df
							&& t01.p02<=:tmp_dt
							$locate_stores   
							$extra_where
							$where_nom

					UNION ALL    
					
					/*****************************
						genika sunola
					*****************************/
					SELECT  
							3 as pos,
							:genika  as p01, 
							sum($tmp_p03)  as p02, 
							sum($tmp_p04) as p03,
							sum($tmp_p03-$tmp_p04)  as p04,
							sum( $tmp_p101 ) AS p05,
							sum( $tmp_p201 ) AS p06 	
					FROM t01 
					LEFT JOIN t02 ON t02.p01=t01.p07
					$extra_join
					WHERE t01.p02<=:tmp_dt
						  $locate_stores   
						  $extra_where
						  $where_nom
					) AS tabl01 
					GROUP BY tabl01.p01
					ORDER BY tabl01.pos";
					
	// echo pegasus_replace_values_in_sql($tmp_query, $t01_d100_params);
	// peg_write_file('../../tmp/account_balance.sql',pegasus_replace_values_in_sql($tmp_query,$t01_d100_params));

	return array(
		'sql' => $tmp_query,
		'sqlParams' => $t01_d100_params
	);
}

function account_t01_d100_find_grid_query_3($mmnr01, $datas, $_d)
{
	$tmp_query = '';
	$t01_d100_params = array();

	$t01_d100_params['tmp_lo']  = $datas['t_lo']; // Λογαριασμός
	$t01_d100_params['tmp_df']  = $datas['t_df']; 
	$t01_d100_params['tmp_dt']  = $datas['t_dt'];
	$t01_d100_params['tmp_ypok'] = '';

	$tmp_t01_p02 = 't01.p02'; // Ημερομηνία
	$tmp_t01_p03 = 't01.p03'; // Χρέωση
	$tmp_t01_p04 = 't01.p04'; // Πίστωση
	$tmp_t01_nr01 = 't01.nr01';

	// Υποκαταστήματα
	// a00_d -> Προμηθευτές		a01_d -> Πελάτες	d25_d -> Έργα λειτουργιών projects	
	// d35_d -> Εργασίες Έργων  hota14_d -> Συμβόλαια Πελατών
	if ( $_d == 'a00_d' || $_d == 't01_d100') {
		$t01_d100_params['tmp_ypok'] = $datas['t_ypok_a00'];
	}else if ( $_d == 'a01_d' || $_d == 't01_d100') {
		$t01_d100_params['tmp_ypok'] = $datas['t_ypok_a01'];
	}else if ( $_d == 'd25_d') {
		$t01_d100_params['var_p503'] = $datas['p503'];
	}else if ( $_d == 'd35_d') {
		$t01_d100_params['var_p504'] = $datas['p504'];
	} else if($_d == 'hota14_d'){
		$hota14_nr01 = explode('-',$mmnr01)[1]; //Στην περίπτωση του refresh διαβάζει το mmnr01 
		$t01_d100_params['hota14_nr01']  = empty($datas['hota14_nr01']) ? $hota14_nr01  : $datas['hota14_nr01'];
	}

	if (pegasus_module_exists('stores')) {
		if($_d == 'd00_d56'){
			$tmp_kat = explode('#', $datas['p301']);
			$tmp_kat = array_slice($tmp_kat, 1, count($tmp_kat) - 2);
			$tmp_kat_in = pegasus_mysql_create_in($tmp_kat, 'kat_in');

			$locate_stores = " && t01.p09 IN (:kat) ";

			$locate_stores = str_replace(':kat', $tmp_kat_in['sql'], $locate_stores);
			$t01_d100_params = array_merge($t01_d100_params, $tmp_kat_in['sqlParams']);
			
		}else{
			$locate_stores  = " && locate(concat('#',t01.p09,'#'), :tmp_kat) >0 ";
			$t01_d100_params['tmp_kat'] = $datas['t_kat'];
		}
		
	}

	$tmp_query = "	SELECT ttt.*,
						IF (p02 is NULL AND p01 is not null , 'Όλοι οι Μήνες', p02) as p06 , 
						IF (p01 is NULL  , 'Όλα τα χρόνια', p01) as p07
						FROM
						(SELECT 
							year($tmp_t01_p02) as p01,
							month($tmp_t01_p02) as p02,
							sum($tmp_t01_p03) as p03,
							sum($tmp_t01_p04) as p04,
							sum($tmp_t01_p03-$tmp_t01_p04) as p05
						FROM t01 
						LEFT JOIN t00 ON t01.p01 = t00.p01
						WHERE t01.p01=:tmp_lo AND t01.p02>=:tmp_df AND t01.p02<=:tmp_dt 
							AND (:tmp_ypok='' OR :tmp_ypok=0 OR t01.p900=:tmp_ypok OR (:tmp_ypok = -1 AND t01.p900=0)) 
							$locate_stores
						GROUP BY year($tmp_t01_p02), month($tmp_t01_p02)
						WITH ROLLUP)
					as ttt;";
	
	return array(
		'sql' => $tmp_query,
		'sqlParams' => $t01_d100_params
	);
}
function account_t01_d100_grid_custom_actions($retArray = array())
{

	$peg_handler = 'account00_t01_relation(screen.getContainer_ID(), 1);';
	$retArray[]  = array(
		'xtype' => 'pegasusToolBarGridAction',
		'peg_custom_id' => 'account_view_relation',
		'viewModel' => array(
			'type' => 'GridButtonModel',
			'isToolBar' => 1,
			'data' => array(
				'toolBarButton' => 'account_view_relation',

			)
		),
		'icon' => 'account_images/t01_relation_16x16.png',
		'text' =>  $_SESSION['peg_dic_account_view_relation'],
		'peghandler' => $peg_handler
	);

	
	$peg_handler = 'account00_t01_copy(screen.getContainer_ID());';
	$retArray[]  = array(
		'xtype' => 'pegasusToolBarGridAction',
		'peg_custom_id' => 'account_copy_t01',
		'viewModel' => array(
			'type' => 'GridButtonModel',
			'isToolBar' => 1,
			'data' => array(
				'toolBarButton' => 'account_copy_t01',

			)
		),
		'iconCls'=> 'icon-copy',
		'text' =>  $_SESSION['peg_dic_account_copy'],
		'peghandler' => $peg_handler
	);
	return $retArray;
}
function account_i13_d_initialize($data,$mmnr01='',$mnr01='',$_d='',$container_id=''){
	
	//Παραμετροποίηση myDATA
	$data['v_q30_620024'] = pegasus_mysql_printfld("q31", "p05", "p03 = ? and p01 = 620024", array($data['p01'])); 
	$data['v_q30_620025'] = pegasus_mysql_printfld("q31", "p05", "p03 = ? and p01 = 620025", array($data['p01']));
	
	return $data;
}
function account_i13_d_onchange($data , $permDeny , $mmnr01 , $checkOnlyPerm){
	global $PegInput;

	//Παραμετροποίηση myDATA
	if ($checkOnlyPerm == 1){
		$PegInput->addVar(new peg_input_alphanumeric('v_q30_620024', 'request'));
		$PegInput->addVar(new peg_input_alphanumeric('v_q30_620025', 'request'));
		$v_q30_620024 = $PegInput->getRequest('v_q30_620024');
		$v_q30_620025 = $PegInput->getRequest('v_q30_620025');

		core00_manage_relation($v_q30_620024, '620024', $data['p01']);
		core00_manage_relation($v_q30_620025, '620025', $data['p01']);
	}
	

	return array($data, $permDeny);
}
function peg_account_t01_d200_initialize($data, $mmnr01 = '', $mnr01 = '', $_d = '', $container_id = '')
{
	global $PegInput;
	$PegInput->addVar(new peg_input_number('t01_p03', 'request'));
	$PegInput->addVar(new peg_input_number('t01_p04', 'request'));
	$PegInput->addVar(new peg_input_number('t01_vp03', 'request'));
	$t01_p03  = $PegInput->getRequest('t01_p03');
	$t01_p04  = $PegInput->getRequest('t01_p04');
	//$t01_vp03  = $PegInput->getRequest('t01_vp03');


	//π.χ.SUBSTRING(t00.p01,1,2) = '30'
	$t01p03_global = pegasusGetGlobalVar(pegasus_container_id_get_parentBy_d($container_id ,'t01_d') . '_where_p01_t01_d');
	
	//Όταν έχω αρνητικό υπόλοιπο, σημαίνει ότι χρωστάω είτε στον πελάτη έίτε στον προμηθευτή. 
	$ypoloipo = 0;
	if($t01_p03!=0) {
		$ypoloipo =  (-1)*$t01_p03; //Χρέωση (π.χ. πληρωμή προμηθευτή)
	}
	elseif($t01_p04!=0) { //Πίστωση (π.χ. είσπραξη από πελάτη)
		$ypoloipo = $t01_p04;
	} 

	if(!empty($t01p03_global)) {
		$t01grid_global=array(
			'sql'		=> $t01p03_global['sql'],
			'sqlParams'	=> $t01p03_global['sqlParams']
		);
		if($ypoloipo != 0) {
			$t01grid_global['sql']= $t01p03_global['sql']." AND t00tot.p03 = :t00tot_p03";
			$t01grid_global['sqlParams']= $t01p03_global['sqlParams'];
			$t01grid_global['sqlParams']['t00tot_p03'] = $ypoloipo;
		}
	} else {
		$t01grid_global= array(
			'sql'		=> 't00tot.p03 = :t00tot_p03',
			'sqlParams'	=> array('t00tot_p03' => $ypoloipo)

		);
	}

	// print_r($t01grid_global);
	// die();
	pegasusSetGlobalVar($container_id . '_where_grid_t01_d200',$t01grid_global);

	return $data;

}
function peg_account_t01_d_initialize($data, $mmnr01 = '', $mnr01 = '', $_d = '', $container_id = '')
{

	$new_rec = false;
	if(!($data['nr01'] > 0)) {
		$data['nr01'] = pegasus_mysql_newrec('t01');
		$new_rec = true;
	}

	global $PegInput;
	$PegInput->addVar(new peg_input_number('bnk03_nr01', 'request'));
	$PegInput->addVar(new peg_input_number('a01_rec', 'request'));
	$PegInput->addVar(new peg_input_number('a00_rec', 'request'));
	$PegInput->addVar(new peg_input_number('rec_copy_nr01'));
	$PegInput->addVar(new peg_input_number('t00_p01'));

	$bnk03_nr01    = $PegInput->getRequest('bnk03_nr01');
	$a01_rec       = $PegInput->getRequest('a01_rec');
	$a00_rec       = $PegInput->getRequest('a00_rec');
	$rec_copy_nr01 = $PegInput->getRequest('rec_copy_nr01');
	$t00_p01       = $PegInput->getRequest('t00_p01');

	$data['readonly'] = 0;
	$data['message'] = '';

	if ((!($rec_copy_nr01 > 0)) and $new_rec == 1) {
		//Κατάστημα από ΤΕΡΜΑΤΙΚΟ
		$data['p09'] = $_SESSION['cor003_p104'];
	}

	if($new_rec == 1 ) {
		$data['p401'] = $_SESSION['username'];
	}

	// it's linked with logi-document
	if ($data['p302'] <> 0 or $data['p303'] <> 0) {
		$data['readonly'] = 1;

		if (in_array($data['p303'], array('42','43'))){
			$data['message'] .= $_SESSION['peg_dic_account_t01_015'] . '<br>';

			if($data['p303']=='43'){
				//Έλεγχος αν υπάρχει το Δικαίωμα "Επιτρέπεται η Τροποποίηση Ελέυθερων Πιστώσεων Κράτησης" (hot013)
				$data['message']  = $_SESSION['peg_dic_account_t01_017'] . '<br>';	
				if(pegasus_module_exists('hot013') && pegasus_check_permission('hot013.t01.t06.43.change')){
					$data['message']  = '';	
					$data['readonly'] = 0;					
				}
			}
		}else{
			$data['message'] .= $_SESSION['peg_dic_account_t01_007'] . '<br>';
		}
	}

	if (peg_dateIsEmpty($data['p02'], 'Y-m-d') and $new_rec) {
		$data['p02'] = date('Y-m-d');
		$data['p02t'] = date('H:i');
	}

	// it's in closed period
	if (!account_date_in_account_period($data['p02'])) {
		$data['readonly'] = 1;
		$data['message'] = $data['message'] . $_SESSION['peg_dic_account_t01_008'] . '<br>';
	}

	//set message red
	if ($data['readonly'] == 1) {
		$data['message'] = '<span style="color:red">' . $data['message'] . '</span>';
	}
	$fsum = -999999999999999;
	$tsum = 999999999999999;
	
	if (in_array($_d, array("t01_d", "t01_d302"))) {
		// #### Module: bnk ####
		if(
			$bnk03_nr01 > 0
			&& function_exists('bnk_t01_d_initialize')
		) {
			$data = bnk_t01_d_initialize(
				$bnk03_nr01,
				$data,
				$a01_rec,
				$a00_rec
			);
		}
		if($a01_rec == 1) {
			pegasusSetGlobalVar(
				$container_id . '_where_p01_t01_d',
				array(
					'sql'=>	"SUBSTRING(t00.p01,1,2) = '30'",
					'sqlParams'	=>	array()
				)
			);
			/*pegasusSetGlobalVar(
				$container_id . '_where_grid_t01_d200',
				array(
					'sql'=>	"
						SUBSTRING(t00.p01,1,2) = '30' 
						AND t00tot.p03 >= :fsum 
						AND t00tot.p03 <= :tsum
					",
					'sqlParams'	=>	array(
						'fsum'	=> $fsum,
						'tsum'	=> $tsum
					)
				)
			);*/
		}
		elseif($a00_rec == 1) {
			pegasusSetGlobalVar(
				$container_id . '_where_p01_t01_d',
				array(
					'sql'=>	"SUBSTRING(t00.p01,1,2) = '50'",
					'sqlParams'	=>	array()
				)
			);
			/*pegasusSetGlobalVar(
				$container_id . '_where_grid_t01_d200',
				array(
					'sql'=>	"
						SUBSTRING(t00.p01,1,2) = '50' 
						AND t00tot.p03 >= :fsum 
						AND t00tot.p03 <= :tsum
					",
					'sqlParams'	=>	array(
						'fsum'	=> $fsum,
						'tsum'	=> $tsum
					)
				)
			);*/
		}
		//
		if(!empty($t00_p01)) {
			$data['p01'] = $t00_p01;
		}
		if (abs($data['pn03'] + $data['pn04']) == 0) {
			$data['vp03'] = abs($data['p03'] + $data['p04']);
		} else {
			$data['vp03'] = abs($data['pn03'] + $data['pn04']);
		}
	}

	if (empty($data['message'])) {
		$data['message_hidden'] = 1;
	}

	return $data;
}




function account_t01_d_ondelete($data, $permDeny, $mmnr01, $checkOnlyPerm)
{
	$mmnr01_arr = explode('-', $mmnr01);
	
	// print_r($mmnr01_arr);

	// it's linked with logi-document
	if (
		($data['p302'] > 0 AND $data['p303'] > 0) and
		$mmnr01_arr[0] != 'a55_d' 		and
		$mmnr01_arr[0] != 'a56_d' 		and
		$mmnr01_arr[0] != 't08_d' 		and
		$mmnr01_arr[0] != 't03_d' 		and
		$mmnr01_arr[0] != 'hota17_d' 	and
		$mmnr01_arr[0] != 'hota04_d' 	and
		$mmnr01_arr[0] != 'tran01_d' 	and
		$mmnr01_arr[0] != 'pos00_04_d'	and !pegasus_check_permission('account_delete_linked_t01')
	) {
		//* Αν το ΜΚ Σχετικής Κίνησης είναι συμπληρωμένο 
		//* και η Κατηγορία Κίνησης αφορά a55, a56, t08
		//* και το αντιστοιχο παραστατικό/απόδειξη δεν υπάρχει
		//* Επιτρέπουμε τη διαγραφή κίνησης
		pegasus_mysql_use('SELECT * FROM t06 WHERE p01 = :t01p303', $t06, array('t01p303' => $data['p303']));
		$t06_p03_str = explode('.', $t06['p03']);
		$t06_p03_tbl = $t06_p03_str[0];
		$tbl_to_check = array('a55', 'a56', 't08'); // Αν θέλουμε να ελέγχουμε και άλλους πίνακες θα τους βάλουμε εδώ.
		if(in_array($t06_p03_tbl, $tbl_to_check)) {
			if(!empty(pegasus_mysql_printfld($t06_p03_tbl, 'nr01', 'nr01 = ?', array($data['p302'])))) {
				if($t06_p03_tbl == 'a55') {
					if(	   empty(pegasus_mysql_printfld($t06_p03_tbl, 'y_ekd', 'nr01 = ?', array($data['p302'])))
						|| !empty(pegasus_mysql_printfld("t19", "nr01", "tbl=? and tbl_nr01=?", array($t06_p03_tbl, $data['p302'])))
						|| $data['p303'] != '9'
					){
						//* Επιτρέπω τη διαγραφή αν είναι δεμένο με παραστατικό που είναι υπό έκδοση, δεν έχει υπογραφή και είναι p303 = 9.
						//TODO Σε αυτές τις περιπτώσεις ίσως θα μπορούσαμε να έχουμε διαφορετικά μηνύματα αλλά δεν ξέρω αν υπάρχει λόγος.
						array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_account_t01_014'] . ' (' . $mmnr01 . ')'));
					}
				}else{
					array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_account_t01_014'] . ' (' . $mmnr01 . ')'));
				}
			}

		}if(in_array($t06_p03_tbl, array('hota04', 'hota17'))) {
			array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_account_t01_016'] . ' (' . $mmnr01 . ')'));
		}else{
			array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_account_t01_014'] . ' (' . $mmnr01 . ')'));
		}
		// array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_account_t01_014'] . ' (' . $mmnr01 . ')'));
	}


	// it's in closed period
	if (peg_dateIsEmpty($data['p02'], 'Y-m-d') and empty($data['nr01'])) {
		$data['p02'] = date('Y-m-d');
	}


	if (!account_date_in_account_period($data['p02'])) {
		$account_000_p102 = $_SESSION['account_000_p102'];
		if (peg_dateIsEmpty($_SESSION['account_000_p102'], 'Y-m-d')) {
			$account_000_p102 = date('Y-m-d');
		}

		$peg_tmp_mes = $_SESSION['peg_dic_account_t01_009'];
		$peg_tmp_mes = str_replace('#1#', peg_dateToStr($_SESSION['account_000_p101']), $peg_tmp_mes);
		$peg_tmp_mes = str_replace('#2#', peg_dateToStr($account_000_p102), $peg_tmp_mes);
		array_push($permDeny, array('type' => 'deny', 'message' => $peg_tmp_mes));
	}
	return array($data, $permDeny);
}

function account_t01_d_onchange($data, $permDeny, $mmnr01, $checkOnlyPerm)
{
	/***************
		  date
	 ***************/
	if (!account_date_in_account_period($data['p02'])) {
		$account_000_p102 = $_SESSION['account_000_p102'];

		if (peg_dateIsEmpty($_SESSION['account_000_p102'], 'Y-m-d')) {
			$account_000_p102 = date('Y-m-d');
		}

		$peg_tmp_mes = $_SESSION['peg_dic_account_t01_009'];
		$peg_tmp_mes = str_replace('#1#', peg_dateToStr($_SESSION['account_000_p101']), $peg_tmp_mes);
		$peg_tmp_mes = str_replace('#2#', peg_dateToStr($account_000_p102), $peg_tmp_mes);
		array_push($permDeny, array('type' => 'deny', 'message' => $peg_tmp_mes));
	}


	/*************************
		    debit - credit
	 *************************/
	if ($data['p03'] == 0 and $data['p04'] == 0) {
		array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_account_t01_010']));
	}


	/**********************
		   find t02 fields
	 ***********************/
	$peg_tmp_t02arr = array(
		"nr01"    => 0, 
		"p03"     => 0, 
		"p04"     => 0, 
		"p30"     => '',
		"p0903"   => 0,
		"p0903_1" => '',
		"p0903_2" => ''
	);

	$peg_tmp_str = "select * FROM t02 WHERE t02.p01=? ";
	$peg_tmp_p07 = empty($data['p07']) ? '0' : $data['p07'];

	pegasus_mysql_use($peg_tmp_str, $peg_tmp_res, array($peg_tmp_p07));

	if (!empty($peg_tmp_res)) {
		$peg_tmp_t02arr = array(
			"nr01"    => $peg_tmp_res['nr01'], 
			"p03"     => $peg_tmp_res['p03'], 
			"p04"     => $peg_tmp_res['p04'], 
			"p30"     => $peg_tmp_res['p30'],
			"p0903"   => $peg_tmp_res['p0903'],
			"p0903_1" => $peg_tmp_res['p0903_1'],
			"p0903_2" => $peg_tmp_res['p0903_2']
		);
	}

	$t01_cnt = pegasus_mysql_printfld("t01", "count(nr01)", "nr01 = :nr01", array("nr01" => $data['nr01']));

	if(
		$t01_cnt == 0 && // Νέα Εγγραφή
		$data['p303'] == 0 && // Ελεύθερη Καταχώρηση
		$checkOnlyPerm == 0 &&
		!empty($peg_tmp_t02arr['p0903']) // Υπάρχει Μετρητής
	) {
		$counter = account_make_invoice_num($data['p09'], $peg_tmp_t02arr['p0903'], $peg_tmp_t02arr['p0903_2']);

		$data['p06'] = "";

		if(!empty($peg_tmp_t02arr['p0903_1'])) {
		  $data['p06'] .= $peg_tmp_t02arr['p0903_1'] . " ";
		}
  
		if(!empty($peg_tmp_t02arr['p0903_2'])) {
		  $data['p06'] .= $peg_tmp_t02arr['p0903_2']. " ";
		}
  
		$data['p06'] .= $counter;
	}

	/************************
		 check t01.p07
	 *************************/
	if ($peg_tmp_t02arr['nr01'] == 0) {
		array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_account_t01_002']));
	}

	/************************
		 check t02.p30
	 *************************/
	$peg_tmp_p01 = empty($data['p01']) ? '' : $data['p01'];
	$peg_tmp_str = $peg_tmp_t02arr['p30'];
	$peg_tmp_p01 = '#' . substr($peg_tmp_p01, 0, 2) . '#';
	if ($peg_tmp_str != '#' and !empty($peg_tmp_str) and strpos($peg_tmp_str, $peg_tmp_p01) === false) {
		array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_account_t01_005']));
	}

	if(!$checkOnlyPerm) {
		if(
			pegasus_module_exists('bnk')
			&& $data['pd101'] == 'bnk03'
			&& $data['pd102'] > 0
		) {
			pegasus_mysql_update(
				'bnk03',
				array('t01'),
				array($data['nr01']),
				'nr01 = :nr01',
				0,1,1,
				array('nr01' => $data['pd102'])
			);
		}
	}


	if(pegasus_module_exists("bnk") && $data['pd101']=='bnk03'){
		if(pegasus_mysql_printfld('t01', 
								  'count(*)', 
								  "pd101 = 'bnk03' and pd102=:t01_pd102",
								   array('t01_pd102' => $data['pd102']))>0
		){
			$query = "SELECT t01.pd102,
							 t01.remdate as remdate,
							 t01.remtime as remtime,
							 t01.remuser as remuser, 
							 us0.p100 as user 
							  
						from t01
							join us0 on t01.remuser = us0.p01
		 				where pd102=:t01_pd102 and pd101='bnk03'";
			pegasus_mysql_use($query, $res, array('t01_pd102' => $data['pd102']));
			
			$dt_format = pegasus_mysql_printfld('cor000', 'dt_format', 'nr01=1', '');
			$res["remdate"] = peg_dateToStr($res["remdate"], $dt_format);
			$mess = str_replace(array("##t01_nr01##", "##remdate##", "##remtime##", "##uname##", "##user##"), 
								$res, $_SESSION["peg_dic_account_t01_013"]);
			array_push( $permDeny , array( 'type'=>'CONFIRM' , 'message'=>$mess));
		}
	}

	return array($data, $permDeny);
}


function peg_account_t01_d101_initialize($data, $mmnr01 = '', $mnr01 = '', $_d = '', $container_id = '')
{
	$data['readonly'] = 0;
	$data['message'] = '';
	global $PegInput;
	
	$PegInput->addVar(new peg_input_number('rec_copy_nr01'));
	$rec_copy_nr01  = $PegInput->getRequest('rec_copy_nr01');
	$new_rec = false;
	if(!($data['nr01'] > 0)) {
		$new_rec = true;
	}

	if ((!($rec_copy_nr01 > 0)) and $new_rec == 1) {
		//Κατάστημα από ΤΕΡΜΑΤΙΚΟ
		$data['p09'] = $_SESSION['cor003_p104'];
	}

	if($new_rec == 1 ) {
		$data['p401'] = $_SESSION['username'];
	}

	// it's linked with logi-document
	if ($data['p302'] <> 0 or $data['p303'] <> 0) {
		$data['readonly'] = 1;
		$data['message'] =  $_SESSION['peg_dic_account_t01_007'] . '<br>';
	}

	if ($data['p303'] == 5) {
		$data['readonly'] = 1;
		$data['message'] =  $_SESSION['peg_dic_account_t01_0071'] . '<br>';
	}

	// it's in closed period
	if (peg_dateIsEmpty($data['p02'], 'Y-m-d') and empty($data['nr01'])) {
		$data['p02'] = date('Y-m-d');
		$data['p02t'] = date('H:i');
	}

	if (!account_date_in_account_period($data['p02'])) {
		$data['readonly'] = 1;
		$data['message'] = $data['message'] . $_SESSION['peg_dic_account_t01_008'] . '<br>';
	}

	//set message red
	if ($data['readonly'] == 1) {
		$data['message'] = '<span style="color:red">' . $data['message'] . '</span>';
	}

	if ($_d == 't01_d101') {
		if (abs($data['pn03'] + $data['pn04']) == 0) {
			$data['vp03'] = abs($data['p03'] + $data['p04']);
		} else {
			$data['vp03'] = abs($data['pn03'] + $data['pn04']);
		};
	}

	/*  Εαν είναι κενος ο Λογαριασμος 
		? - Λογικά μονο για τις καινούριες εγγραφες το θέλουμε αυτο? ΦΨ*/
	if (!(pegasus_mysql_printfld('t01', 'p01', 'nr01=?', array($data['nr01'])))) {

		$data['p01'] =  $_REQUEST['peg_log']; //t01_d100 -> grid -> insert

		if (
			empty($data['p07']) and
			!(pegasus_mysql_printfld('t01', 'p01', 'nr01=?', array($data['nr01'])))
		) {
			$data['p07'] = pegasus_mysql_printfld('t02', 'p01', "ifnull(p30, '')='' or locate(concat('#', ?, '#'), t02.p30)>0", array(substr($data['p01'], 0, 2)));
		}
	}

	if($data['p01'] > 0){
		$data['p01_readonly'] = 1;
	}
	if (substr($mmnr01, 0, 8) == 'hota14_d'){
		$data['pd101'] = "hota14";
		$data['pd102'] =  $mnr01;
	}

	return $data;
}
function peg_account_t16_d_initialize($data, $mmnr01 = '', $mnr01 = '', $_d = '', $container_id = '')
{
	if ($_d == 't16_d') {
		if (empty($data['nr01'])) {
			$data['nr01'] = pegasus_mysql_newrec("t16");
			$peg_is_newrec = 1;
		}

		pegasusSetGlobalVar($container_id . '_where_prep',  array(
			'sql'		=>	"p101=:v_p101 ",
			'sqlParams'	=>	array('v_p101' => $data['nr01'])
		));
	}
	return $data;
}
function account__t1_d11_initialize($data, $mmnr01 = '', $mnr01 = '', $_d = '', $container_id = '') {
	// Αποθήκη
	pegasus_mysql_use("select min(p00) as min_code, max(p00) as max_code from i16;", $i16);
	$data['t_p401'] = $i16['min_code'];
	$data['t_p402'] = $i16['max_code'];
	
	// Κατάστημα
	if(pegasus_module_exists('stores') and pegasus_mysql_table_exists('t07')) {
		pegasus_mysql_use("select min(p01) as min_code, max(p01) as max_code from t07;", $t07);
		$data['t_p403'] = $t07['min_code'];
		$data['t_p404'] = $t07['max_code'];
	} else {
		$data['fldset01_03_hidden'] = true;
	}

	// Διαγραφή
	$data['t_p105_hidden'] = 1;
	$data['t_p106_hidden'] = 1;
	$data['t_p107_hidden'] = 1;
	if(pegasus_module_exists('receipts')) {
		$data['t_p105_hidden'] = 0;
		$data['t_p106_hidden'] = 0;
		$data['t_p107_hidden'] = 0;
	}

	// Διαγραφή Παραστατικών Πελατών
	$data['t_p101_hidden']   = 1;
	$data['t_p101or_hidden'] = 1;
	if(pegasus_module_exists('invcust') && pegasus_mysql_table_exists('a10')) {
		$data['t_p101_hidden'] = 0;
		
		pegasus_mysql_use("select min(p01) as min_code, max(p01) as max_code from a10;", $a10);
		$data['t_p101a'] = $a10['min_code'];
		$data['t_p101e'] = $a10['max_code'];

		if(pegasus_module_exists('ordercust')) {
			$data['t_p101or_hidden'] = 0;
		}		
	} else {
		$data['fldset02_01_hidden'] = true;
	}

	// Διαγραφή Παραστατικών Προμηθευτών
	$data['t_p102_hidden']   = 1;
	$data['t_p102or_hidden'] = 1;
	if(pegasus_module_exists('invsupp') && pegasus_mysql_table_exists('a11')) {
		$data['t_p102_hidden'] = 0;
		
		pegasus_mysql_use("select min(p01) as min_code, max(p01) as max_code from a11;", $a11);
		$data['t_p102a'] = $a11['min_code'];
		$data['t_p102e'] = $a11['max_code'];

		if(pegasus_module_exists('ordersupp')) {
			$data['t_p102or_hidden'] = 0;
		}
	} else {
		$data['fldset02_02_hidden'] = true;
	}

	// Διαγραφή Παραστατικών Εσωτερικής Διακίνησης
	$data['t_p103_hidden']   = 1;
	$data['t_p103or_hidden'] = 1;
	if(pegasus_module_exists('invtrans00') and pegasus_mysql_table_exists('a30')) {
		$data['t_p103_hidden']   = 0;

		pegasus_mysql_use("select min(p01) as min_code, max(p01) as max_code from a30;", $a30);
		$data['t_p103a'] = $a30['min_code'];
		$data['t_p103e'] = $a30['max_code'];

		if(pegasus_module_exists('interorder')) {
			$data['t_p103or_hidden'] = 0;
		}
	} else {
		$data['fldset02_03_hidden'] = true;
	}

	// Δημιουργία Εγγραφών Συνόλων
	$data['t_p202_hidden'] = 1;
	if (pegasus_module_exists('invtrans') and pegasus_mysql_table_exists('i15') and pegasus_mysql_table_exists('t02')) {
		$data['t_p202_hidden'] = 0;
	}

	return $data;
}

function peg_account_t12_d_initialize($data, $mmnr01 = '', $mnr01 = '', $_d = '', $container_id = '')
{
	if ($_d == 't12_d') {
		$data['account_t12_d_grid_hidden'] = 0;
		if (empty($data['nr01'])) {
			$data['nr01'] = pegasus_mysql_newrec("t12");
			$peg_is_newrec = 1;
		}
		if ($peg_is_newrec == 1) {

			$data['account_t12_d_grid_hidden'] = 1;
		}
		pegasus_make_all_tmp_recs('t12', $data, $data['nr01'], $_REQUEST['rec_copy_nr01'], 't12_d-' . $data['nr01']);
		pegasusSetGlobalVar(
			$container_id . '_where_prep',
			array(
				'sql'		=>	'peg_tmp_t13.peg_flag!=9 and 
													 peg_tmp_t13.p01=:t13_p01 and 
													 peg_tmp_t13.peg_sess_id=:t13_peg_sess_id  and 
													 peg_tmp_t13.peg_mmnr01=:t13_peg_mmnr01 and 
													 peg_tmp_t13.peg_mnr01=:t13_peg_mnr01 ',
				'sqlParams'	=>	array(
					't13_p01'			=>	$data['p01'],
					't13_peg_sess_id'	=>	session_id(),
					't13_peg_mmnr01'	=>	't12_d-' . $data['nr01'],
					't13_peg_mnr01'		=>	$data['nr01']
				)
			)
		);
	}
	return $data;
}

function peg_account_t13_d_initialize($data, $mmnr01 = '', $mnr01 = '', $_d = '', $container_id = '')
{
	if ($_d == 't13_d') {
		if (substr($mmnr01, 0, 5) == 't12_d') {
			$data['p01'] = pegasus_mysql_printfld('t12', 'p01',  'nr01=?', array(substr($mmnr01, 6)));
		}
	}
	return $data;
}
function account_account_browse_t01_d100_initialize($data,$mmnr01='',$mnr01='',$_d='',$container_id=''){

	$data['grid_change_hidden'] = true;
	$data['grid_rowchange_hidden'] = true; 
	if($_d=='account_browse_t01_d100'){
		pegasusSetGlobalVar(
			$container_id. '_where_grid_account_browse_t01_d100' ,
			array(
				'sql' => ' p85.nr01 IN ("140000009000004","140000009000007", "140000009000008", "140000009000009", "140000009000011", "140000009000013", "140000009000014", "140000009000015") ', 
				'sqlParams' => array()
			)
		);
	}
	return $data;
}
function peg_account_calculate_mis001($peg_p01e, $peg_p01, $peg_yp1, $peg_yp2, $peg_allkin = 0)
{
	$ret_arr = array("ok" => 1);
	$peg_days = peg_dateDiff($peg_p01e, $peg_p01, 'Y-m-d') + 1;

	//logi totals 
	$ret_arr = peg_account_calculate_mis001_find001($peg_p01e, $peg_p01, $peg_yp1, $peg_yp2, $ret_arr, $peg_days, $peg_allkin);
	//logi balances
	$ret_arr = peg_account_calculate_mis001_find002($peg_p01e, $peg_p01, $peg_yp1, $peg_yp2, $ret_arr, $peg_allkin);
	//inventory totals
	$ret_arr = peg_account_calculate_mis001_find003($peg_p01e, $peg_p01, $peg_yp1, $peg_yp2, $ret_arr, $peg_allkin);

	return $ret_arr;
}


/**
 * Χρησιμοποιούμε την συνάρτηση αυτή π.χ. στην Εικόνα Επιχείρησης και τις Αναφορές της
 * προκειμενου να μπορούμε να ορίζουμε με sme τους Λογαριασμούς που θα γίνονται exclude 
 * απο τους υπολογισμούς 
 */
function peg_account_exclude_t00_from_mis001()
{
	if (function_exists('sme_exclude_t00_from_mis001')) {
		return sme_exclude_t00_from_mis001();
	}
	return "";
}

/**
 * Η συνάρτηση αυτή αντικαθιστά το extra where στα query τις Εικόνας 
 * επιχείρησης με τους Λογαριασμούς που θα εξαιρεθούν. Οι λογαριασμοί που 
 * θα εξαιρεθούν βρισκονται από sme: peg_account_exclude_t00_from_mis001 -> sme_exclude_t00_from_mis001
 */
function peg_account_calculate_mis001_extra_where(&$sql, &$sqlParams)
{

	if (($excl_accounts = peg_account_exclude_t00_from_mis001()) != '') {
		if (strpos($excl_accounts, '#') === 0) {
			$excl_accounts = mb_substr($excl_accounts, 1);
		}
		if ($excl_accounts[strlen($excl_accounts) - 1] == '#') {
			$excl_accounts = mb_substr($excl_accounts, 0, strlen($excl_accounts) - 1);
		}

		$excl_accounts_arr = explode('#', $excl_accounts);

		if (!empty($excl_accounts_arr)) {
			$extra_where = '';
			for ($i = 0; $i < count($excl_accounts_arr); $i++) {
				$extra_where .= " and t01.p01 <> :excl_accounts_$i";
				$sqlParams['excl_accounts_' . $i] = $excl_accounts_arr[$i];
			}
			$sql = str_replace('/*peg_where*/', $extra_where, $sql);
		}
	}
}
function peg_account_calculate_mis001_find001($peg_p01e, $peg_p01, $peg_yp1, $peg_yp2, $ret_arr, $peg_days, $peg_allkin = 0)
{
	$sql = peg_read_file('../account_sql/mis001_find_001_1.sql');
	$sql_params_find001_1 = array();
	$sql_params_find001_1['p01'] = $peg_p01;
	$sql_params_find001_1['p01e'] = $peg_p01e;
	$sql_params_find001_1['yp1'] = $peg_yp1;
	$sql_params_find001_1['yp2'] = $peg_yp2;
	peg_account_calculate_mis001_extra_where($sql, $sql_params_find001_1);
	if($peg_allkin == 0){
	$peg_allkin_extra_where =  
	"and (
		(substr(t01.p01, 1, 2)='30' and t01.p03<>0 and t01.p303 in (1, 2, 6, 11, 20, 22, 24, 31, 41))
	    or (substr(t01.p01, 1, 2)='50' and t01.p04<>0 and t01.p303 in (1, 2, 6, 11, 20, 22, 24, 31, 41))
	    or (substr(t01.p01, 1, 2)='30' and t01.p04<>0 and (ifnull(t02.p05,0)<>0 or ifnull(t02.p010,0)<>0 or ifnull(t02.p011,0)<>0 ))                                                                               
		or (substr(t01.p01, 1, 2)='50' and t01.p03<>0 and (ifnull(t02.p05,0)<>0 or ifnull(t02.p010,0)<>0 or ifnull(t02.p011,0)<>0 ))
		)";
	$sql = str_replace('/*peg_allkin_extra_where*/', $peg_allkin_extra_where, $sql);
	}
	
	pegasus_mysql_use($sql, $res_arr, $sql_params_find001_1);
	if (!empty($res_arr['flag'])) //Είναι empty μόνο όταν δεν έχω κανένα αποτέλεσμα
	{
		$ret_arr['p02'] = round($res_arr['p02'], 2);
		$ret_arr['p03'] = round($res_arr['p03'], 2);
		$ret_arr['p09'] = round($res_arr['p09'], 2);
		$ret_arr['p010'] = round($res_arr['p010'], 2);
		$ret_arr['p301'] = round($res_arr['p301'], 2);
		$ret_arr['p302'] = round($res_arr['p302'], 2);
	} else {
		$ret_arr['p02'] = 0;
		$ret_arr['p03'] = 0;
		$ret_arr['p09'] = 0;
		$ret_arr['p010'] = 0;
		$ret_arr['p301'] = 0;
		$ret_arr['p302'] = 0;
	}

	//average per day
	if ($peg_days != 0) {
		$ret_arr['p308'] = round($ret_arr['p02'] / $peg_days, 2);
		$ret_arr['p309'] = round($ret_arr['p03'] / $peg_days, 2);
		$ret_arr['p304'] = round($ret_arr['p09'] / $peg_days, 2);
		$ret_arr['p305'] = round($ret_arr['p010'] / $peg_days, 2);
	} else {
		$ret_arr['p308'] = 0;
		$ret_arr['p309'] = 0;
		$ret_arr['p304'] = 0;
		$ret_arr['p305'] = 0;
	}

	$ret_arr['p303'] = $ret_arr['p301'] - $ret_arr['p302'];

	//Καθαρά
	$ret_arr['p301_1'] = $ret_arr['p02'] - $ret_arr['p301'];
	$ret_arr['p302_1'] = $ret_arr['p09'] - $ret_arr['p302'];
	$ret_arr['p303_1'] = $ret_arr['p301_1'] - $ret_arr['p302_1'];

	return $ret_arr;
}


function peg_account_calculate_mis001_find002($peg_p01e, $peg_p01, $peg_yp1, $peg_yp2, $ret_arr, $peg_allkin = 0)
{
	$sql = peg_read_file('../account_sql/mis001_find_001_2.sql');

	$sql_params_find001_2 = array();
	$sql_params_find001_2['p01'] = $peg_p01;
	$sql_params_find001_2['p01e'] = $peg_p01e;
	$sql_params_find001_2['yp1'] = $peg_yp1;
	$sql_params_find001_2['yp2'] = $peg_yp2;
	peg_account_calculate_mis001_extra_where($sql, $sql_params_find001_2);
	if($peg_allkin == 0){
		$peg_allkin_extra_where =  
		"and (
				(substr(t01.p01, 1, 2)='30' and t01.p03<>0 and t01.p303<>0) or 
				(substr(t01.p01, 1, 2)='50' and t01.p04<>0 and t01.p303<>0)
			)";
		$sql = str_replace('/*peg_allkin_extra_where*/', $peg_allkin_extra_where, $sql);
		}

	// echo pegasus_replace_values_in_sql($sql, $sql_params_find001_2);
	pegasus_mysql_use($sql, $res_arr, $sql_params_find001_2);

	if (!empty($res_arr['flag'])) {
		$ret_arr['p04'] = round($res_arr['p04'], 0);
		$ret_arr['p05'] = round($res_arr['p05'], 2);
		$ret_arr['p06'] = round($res_arr['p06'], 0);
		$ret_arr['p05_1'] = round($res_arr['p05_1'], 2);
		$ret_arr['abs_p05_1'] = abs(round($res_arr['p05_1'], 2));
		$ret_arr['p06_1'] = round($res_arr['p06_1'], 0);
		$ret_arr['p041'] = round($res_arr['p041'], 0);
		$ret_arr['p07'] = round($res_arr['p07'], 2);
		$ret_arr['abs_p07'] = abs(round($res_arr['p07'], 2));
		$ret_arr['p08'] = round($res_arr['p08'], 0);
		$ret_arr['p07_1'] = round($res_arr['p07_1'], 2);
		$ret_arr['p08_1'] = round($res_arr['p08_1'], 0);
	} else {
		$ret_arr['p04'] = 0;
		$ret_arr['p05'] = 0;
		$ret_arr['p06'] = 0;
		$ret_arr['p05_1'] = 0;
		$ret_arr['abs_p05_1'] = 0;
		$ret_arr['p06_1'] = 0;
		$ret_arr['p041'] = 0;
		$ret_arr['p07'] = 0;
		$ret_arr['abs_p07'] = 0;
		$ret_arr['p08'] = 0;
		$ret_arr['p07_1'] = 0;
		$ret_arr['p08_1'] = 0;
	}

	return $ret_arr;
}


function peg_account_calculate_mis001_find003($peg_p01e, $peg_p01, $peg_yp1, $peg_yp2, $ret_arr, $peg_allkin = 0)
{
	$sql = peg_read_file('../account_sql/mis001_find_001_3.sql');

	$sql_params_find001_3 = array();
	$sql_params_find001_3['p01'] = $peg_p01;
	$sql_params_find001_3['p01e'] = $peg_p01e;
	$sql_params_find001_3['yp1'] = $peg_yp1;
	$sql_params_find001_3['yp2'] = $peg_yp2;
	if($peg_allkin == 0){
		$peg_allkin_extra_where =  "and i01.p07 in (1, 2) and i01.p023>=:yp1 and i01.p023<=:yp2 ";
		$sql = str_replace('/*peg_allkin_extra_where*/', $peg_allkin_extra_where, $sql);
		}
	pegasus_mysql_use($sql, $res_arr, $sql_params_find001_3);

	if (!empty($res_arr['flag'])) {
		$ret_arr['p401'] = round($res_arr['axex'], 2);
		$ret_arr['p402'] = round($res_arr['axeis'], 2);
		$ret_arr['p501'] = round($res_arr['daxex'], 2);
		$ret_arr['p502'] = round($res_arr['daxeis'], 2);
	} else {
		$ret_arr['p401'] = 0;
		$ret_arr['p402'] = 0;
		$ret_arr['p501'] = 0;
		$ret_arr['p502'] = 0;
	}
	return $ret_arr;
}
/** Επιστρέφει τις τιμές για να ανοίξει το σωστό tab του αντιστοιχισμένου πελάτη η προμηθευτή.
 * @param mixed $t00_p01: Λογαριασμός
 * @param mixed $mode: a00 | a01;
 */
function account_supplier_customer_data($t00_p01 = 0, $mode = "")
{

	$ret_array = array();
	$ret_array['ok'] = 0;
	$ret_array['data'] = array();
	$nr01 = 0;

	if (!empty($mode)) {
		$nr01 = pegasus_mysql_printfld($mode, "nr01", "p21=:logar", array("logar" => $t00_p01));
		if ($nr01 > 0) {
			$ret_array['data']['nr01'] = $nr01;
			$ret_array['ok'] = 1;
			if ($mode == "a01") {
				$ret_array['data']['table'] = 'a01';
				$ret_array['data']['_d'] = 'a01_d';
				$ret_array['data']['module'] = "customers";
			} else {
				$ret_array['data']['table'] = 'a00';
				$ret_array['data']['_d'] = 'a00_d';
				$ret_array['data']['module'] = "suppliers";
			}
		}else{
			$ret_array['msg'] = $_SESSION['peg_dic_account_t00_p00_not_assigned'];
		} 
	}
	return $ret_array;
}
function account_a18_d_onsave($data, $permDeny, $mmnr01, $checkOnlyPerm)
{
	if($data['p01'] == '****') {
		array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_account_a18_p01_invalid']));
	}
	return array(
		'data'		=> $data,
		'permDeny'	=> $permDeny
	);
}
function account_after_update()
{
	pegasus_mysql_use('select rel, ver from p55 where p00="account"', $version);

	/** Μετά από αναβάθμιση τσέκαρει αν υπάρχει η εγγραφή με κωδικό "100" 
	 * και την εισάγει στην περιπτωση που δεν υπάρχει. */

	if (!(pegasus_mysql_printfld('t00', 'nr01', 'p01=100') > 0)) {
		$arr1 = array();		$arr2 = array();
		array_push($arr1, 'nr01');		array_push($arr2, pegasus_mysql_newrec("t00"));
		array_push($arr1, 'p01');		array_push($arr2, "100");
		array_push($arr1, 'p02');		array_push($arr2, "ΕΤΑΙΡΕΙΑ");
		pegasus_mysql_insert('t00', $arr1, $arr2);
	}

	if (!(pegasus_mysql_printfld('t00', 'nr01', 'p01=3800000000') > 0)) {
		$arr1 = array();		$arr2 = array();
		array_push($arr1, 'nr01');		array_push($arr2, pegasus_mysql_newrec("t00"));
		array_push($arr1, 'p01');		array_push($arr2, "3800000000");
		array_push($arr1, 'p02');		array_push($arr2, "ΤΑΜΕΙΟ");
		pegasus_mysql_insert('t00', $arr1, $arr2);
	}


	//Εαν δεν υπάρχει καμία εγγραφή στο t17
	//Upload sql 
	if (!(pegasus_mysql_printfld('t17', 'nr01', 'nr01>0') > 0)) {
		//BackUp table t17
		pegasus_mysql_backup_table('t17');
		//delete
		pegasus_mysql_delete('t17', 'nr01>0');
		//upload.sgl
		pegasus_mysql_upload_sql('../account_exec/t17.sql');
		pegasus_mysql_remake_p75('t17');
		pegasus_change_stracture('t17', 't17_d', 'account', 1);
	}

	if (file_exists('../account01/account_change_date.php')) {
        unlink('../account01/account_change_date.php');
    }

	if (file_exists('../account_app_health/account_app_health_checkt00tot.php')) {
        unlink('../account_app_health/account_app_health_checkt00tot.php');
    }

	if ($version['ver'] == 2 && $version['rel'] <= 210) {
        // Update dashboard00_13 for PC.16.00.00 & PC.10.00.00 Web App
        $sql = "    SELECT nr01
                    FROM dashboard00_10
                    WHERE auto_updated = 1
                    AND dashboard00_13 = :dashboard00_10_dashboard00_13
        ";
        $values = array(
            'dashboard00_10_dashboard00_13' => '140000009000000'    // E-Commerce
        );
        $res = pegasus_query($sql,$values);
        while($rs = pegasus_fetch_assoc($res)) {
            $values = array(
                'nr01' => $rs['nr01']
            );
             //  Pegasus Web App Freelancer  (E-Commerce -> Freelancer)
            if($_SESSION['cor000_app_code'] == 'PC.16.00.00') {
                $update = array(
                    'dashboard00_13' => '140000009000001'   // Freelancer
                );
                pegasus_mysql_update(
                    'dashboard00_10',
                    array_keys($update),
                    array_values($update),
                    'nr01 = :nr01',
                    0,1,1,
                    $values
                );
            }
            //  Pegasus Web App ERP Start UP (E-Commerce -> ERP Startup)
            if($_SESSION['cor000_app_code'] == 'PC.10.00.00') {
                $update = array(
                    'dashboard00_13' => '140000009000002'   // ERP Startup
                );
                pegasus_mysql_update(
                    'dashboard00_10',
                    array_keys($update),
                    array_values($update),
                    'nr01 = :nr01',
                    0,1,1,
                    $values
                );
            }
        }
    }
	if ($version['ver'] == 2 && $version['rel'] <= 224) {
		if(file_exists('../account_exec/account_massive_insert_t01_from_pd3_field.php')) {
			unlink('../account_exec/account_massive_insert_t01_from_pd3_field.php');
		}
	}

	if ($version['ver'] == 2 && $version['rel'] <= 227) {
		$tmpFolder = '../../pegasus_cloud_app/account_exec/account03/';
		if(is_dir($tmpFolder)){  
			pegasus_delete_directory($tmpFolder);
		}
	}

	if ($version['ver'] == 2 && $version['rel'] <= 367) {
		$query = 'SELECT * FROM t06';
		$res = pegasus_query($query);
		while($rs = pegasus_fetch_assoc($res)){
			$tbl = explode('.', $rs['p03'])[0];
			pegasus_mysql_update('t06', array('p04'), array($tbl),'nr01=?', 0, 1, 1, array($rs['nr01']));
		}
	}
}

/**
 * Επαναϋπολογίζει τα υπόλοιπα ενός παραστατικού πελάτη/προμηθευτή
 * Χρησιμοποιείται από τον αυτοματισμό "Επαναϋπολογισμός υπολοίπων παραστατικών
 * 
 * @param string $mode - a55/a56
 * @param array $invoice - Παραστατικό (πελάτη/προμηθευτή)
 * @param float $p411 - Προηγούμενο Υπόλοιπο
 * @param float $p417 - Προηγούμενο Τοπικό Υπόλοιπο
 * @param float $p413 - Νέο Υπόλοιπο
 * @param float $p418 - Νέο Τοπικό υπόλοιπο
 * 
 * @return array $result - Τα 2 νέα υπόλοιπα.
 */
function account_recalc_invoice_balances($mode = '', $invoice = array()) {
    if(empty($mode) || empty($invoice)) {
        return;
    }

    $result = array();

	if($mode == 'a55') {
		pegasus_mysql_use("SELECT p21 FROM a01 WHERE nr01=? ", $tbl_p03, array($invoice['p03']));
		$t01_p303_arr = array(2, 4); // Κατηγορίες Κίνησης Λογαριασμών με σύνδεση στον a55
	}elseif($mode == 'a56') {
		pegasus_mysql_use("SELECT p21 FROM a00 WHERE nr01=? ", $tbl_p03, array($invoice['p03']));
		$t01_p303_arr = array(1, 3); // Κατηγορίες Κίνησης Λογαριασμών με σύνδεση στον a56
	}

	// Προηγούμενο Υπόλοιπο
	$p411 = account_find_balance($tbl_p03['p21'], 0, 9999999999, $invoice['p01'], $invoice['p02'], $invoice['nr01'], $t01_p303_arr, $mode); 
	// Προηγούμενο Τοπικό Υπόλοιπο
	$p417 = account_find_balance($tbl_p03['p21'], $invoice['p415'], $invoice['p416'], $invoice['p01'], $invoice['p02'], $invoice['nr01'], $t01_p303_arr, $mode);

	$result['p411'] = $p411;
	$result['p417'] = $p417;
	//Ορίζω το νέο υπόλοιπο ίσο με το προηγούμενο για την περίπτωση παραστατικού που δεν έχει ΚΚ
	$p413 = $p411;
	$p418 = $p417;
    // p414 -> Κωδικός Παραστατικού που ακυρώθηκε
    $p_newp05 = $invoice['p05'];
    if ($invoice['p414'] == 0) {
        $p_asyn  = 1;
    } else {
        $p_asyn  = -1;
        $p_newp05 = $invoice['p414'];
    }

    // ΚΚ Λογιστηρίου από a10/a11 (Ορισμός Παραστατικών Πελατών/Προμηθευτών)
    if($mode == 'a55') {
        pegasus_mysql_use('SELECT * FROM a10 WHERE p01=?', $a10, array($p_newp05));
        $p_kklo = $a10['p04'];
    }elseif($mode == 'a56') {
        pegasus_mysql_use('SELECT * FROM a11 WHERE p01=?', $a11, array($p_newp05));
        $p_kklo = $a11['p04'];
    }

    if ($p_kklo != 0) {
        pegasus_mysql_use('select * from t02 where p01=? ', $t02, array($p_kklo));
        $p_kkxr = $t02['p03'];
        $p_kkpi = $t02['p04'];

        if (!($p_kkxr == 0 and $p_kkpi == 0)) {
            // Ισοτιμία, αν 0 -> 1
            if ($invoice['pn02'] == 0) {
                $invoice['pn02'] = 1;
            }

            // Νέο Υπόλοιπο
            $result['p413'] = $p411 + ($invoice['p0109'] * $p_asyn * $p_kkxr - $invoice['p0109'] * $p_asyn * $p_kkpi) / $invoice['pn02'];
            // Νέο Τοπικό Υπόλοιπο
            $result['p418'] = $p417 + ($invoice['p0109'] * $p_asyn * $p_kkxr - $invoice['p0109'] * $p_asyn * $p_kkpi) / $invoice['pn02'];
            
        }
    }
    
    if ($invoice['p0109'] > 0) {
        $p_kklo = 0;
        $p_kkxr = 0;
        $p_kkpi = 0;

        $p_kklo = pegasus_mysql_printfld('a14', 'p02', 'nr01=? ', array($invoice['p015']));
        if ($p_kklo != 0) {
            pegasus_mysql_use('select * from t02 where p01=? ', $t02, array($p_kklo));
            $p_kkxr = $t02['p03'];
            $p_kkpi = $t02['p04'];
            if (!($p_kkxr == 0 and $p_kkpi == 0)) {
                if ($invoice['pn02'] == 0) {
                    $invoice['pn02'] = 1;
                }

                // Νέο Υπόλοιπο
                $result['p413'] = $p413 + ($invoice['p0109'] * $p_asyn * $p_kkxr - $invoice['p0109'] * $p_asyn * $p_kkpi) / $invoice['pn02'];
                // Νέο Τοπικό Υπόλοιπο
                $result['p418'] = $p418 + ($invoice['p0109'] * $p_asyn * $p_kkxr - $invoice['p0109'] * $p_asyn * $p_kkpi) / $invoice['pn02'];
            }
        }
    }

    return $result;
}

function account_t01_d300_initialize($data, $mmnr01, $mnr01, $_d, $container_id){
	global $PegInput;
	$PegInput->addVar(new peg_input_alphanumeric('__mmnr01', 'request'));	
	$__mmnr01 = $PegInput->getRequest('__mmnr01');

	// Αλλάξαμε το $mmnr01 -> $__mmnr01 για να λειτουργήσει η on_delete όταν κάνουμε διαγραφή από το grid κινήσεων παραστατικού από το toolbar item του a55.
	$__mmnr01_arr = explode('-', $__mmnr01);
	if($__mmnr01_arr[0]=='a55_d'){
		$sql 		= 'p302=:p302 and p303 in ("2","4","9")';
		$sqlParams 	= array('p302'=>$__mmnr01_arr[1]);

	}elseif($__mmnr01_arr[0]=='tran01_d'){
		$sql 		= 'p302=:p302 and p303 in ("11","12","14","15","16","18")';
		$sqlParams 	= array('p302'=>$__mmnr01_arr[1]);
		
	}
	
	pegasusSetGlobalVar($container_id . '_where_grid_t01_d300', 
			array(
				'sql'		=>$sql, 
				'sqlParams'	=>$sqlParams
			)
		);
	
	
	return $data;
}

function account_t01_d301_initialize($data, $mmnr01, $mnr01, $_d, $container_id){
	global $PegInput;

	// Αλλάξαμε το $mmnr01 -> $__mmnr01 για να λειτουργήσει η on_delete όταν κάνουμε διαγραφή από το grid κινήσεων παραστατικού από το toolbar item του a55.
	$PegInput->addVar(new peg_input_alphanumeric('__mmnr01', 'request'));
	$PegInput->addVar(new peg_input_number('a01_nr01'));
	
	$__mmnr01 = $PegInput->getRequest('__mmnr01');
	$a01_nr01 = $PegInput->getRequest('a01_nr01');


	$query 		  = array('sql'=>'', 'sqlParams' =>array());
	$__mmnr01_arr = explode('-', $__mmnr01);
	if($__mmnr01_arr[0]=='hota04_d'){
		if(pegasus_module_exists('hot013')){ 
            $stm = hot013_account_get_t01_query($mnr01, $a01_nr01);

            $query['sql']       = ' t01.nr01 in ( select t01_00.nr01 from ( '. $stm['sql'] . ') as t01_00 )';
            $query['sqlParams'] = $stm['sqlParams'];
        }				
	}
	
	pegasusSetGlobalVar($container_id . '_where_grid_t01_d301', $query);


	$data['account_t01_d301_grid_account_view_relation_hidden'] = false;	
	
	return $data;
}


function account_t01_d301_grid_custom_actions($retArray = array()){

	$peg_handler = 'account00_t01_relation(screen.getContainer_ID(), 1);';
	$retArray[]  = array(
		'xtype' => 'pegasusToolBarGridAction',
		'peg_custom_id' => 'account_view_relation',
		'viewModel' => array(
			'type' => 'GridButtonModel',
			'isToolBar' => 1,
			'data' => array(
				'toolBarButton' => 'account_view_relation',

			)
		),
		'icon' => 'account_images/t01_relation_16x16.png',
		'text' =>  $_SESSION['peg_dic_account_view_relation'],
		'peghandler' => $peg_handler
	);
	
	return $retArray;
}


function account_get_t06(){

	$query = array('sql'=>'', 'sqlParams'=>array());

	$t06p02 = $_SESSION['peg_dic_account_t06_get_all'];

	$query['sql']  = "SELECT * from (";
	$query['sql'] .= "SELECT  
							t06.nr01 as nr01,
							t06.p01  as p01,
							t06.p02  as p02,
							t06.p03  as p03,
							t06.remdate  as remdate, 
							t06.remtime  as remtime, 
							t06.remuser  as remuser, 
							t06.remguc   as remguc, 
							t06.remfdate as remfdate, 
							t06.remftime as remftime, 
							t06.remfuser as remfuser
					FROM t06

					UNION

					SELECT
						-1 as nr01,					
						-1 as p01,
						'".$t06p02."' as p02,
						'' as p03,
						'' as remdate, 
						'' as remtime, 
						'' as remuser, 
						'' as remguc, 
						'' as remfdate, 
						'' as remftime, 
						'' as remfuser ";

	$query['sql'] .= ") as tbl_00";

	return $query;
}

function account_account_schdl_d00_initialize($data, $mmnr01, $mnr01, $_d, $container_id){
	
	$mmnr01_arr = explode('-', $mmnr01);
	if($mmnr01_arr[0]=='scheduler03_d'){		
		if($data["peg_new_rec"]==1){
			pegasusSetGlobalVar(pegasus_container_id_get_parentBy_d($container_id, $mmnr01_arr[0]) . '_query_t06', account_get_t06());
		}
	}

	return $data;
}

function peg_account_t02_d01_initialize($data, $mmnr01 = '', $mnr01 = '', $_d = '', $container_id = '') {
	$new_rec = 0;

	if(!($data['nr01'] > 0)) {
		$new_rec = 1;
	}

	if($new_rec) {
		$data['p0903_2'] = "****";
	}

	if(empty($data['p0903'])) {
		$data['p0903_1_readonly'] = 1;
		$data['p0903_2_readonly'] = 1;
	}

	return $data;
}

/**
 * Insert/Update t01 record (Επιστρέφει την καινούρια εγγραφή στον t01 και τον μετρητή aa)
 * @param  array    $data (t01 data)
 * @param  int    	$amount (Ποσό Κίνησης)
 */
function account_add_t01($data, $amount){
	/**Αν έχουμε ΚΚ Λογιστηρίου */
	$p_kklo = $data['p07'];
	if($p_kklo!=0){
		pegasus_mysql_use('select * from t02 where p01=?', $t02, array($p_kklo));
		// echo pegasus_replace_values_in_sql('select * from t02 where p01=? ',array($p_kklo));
		$p_kkxr = $t02['p03'];
		$p_kkpi = $t02['p04'];

		//Αν έχουμε συντελεστή Χρέωσης-Πίστωσης
		if(!($p_kkxr==0 && $p_kkpi==0)){
			if(in_array($data['p303'], [2, 4, 9])){
				pegasus_mysql_use('select * from a55 where nr01=?', $a55, array($data['p302']));
				if($a55['nr01']>0){
					pegasus_mysql_use('select * from a10 where p01=?', $a10, array($a55['p05']));
					pegasus_mysql_use('select * from a01 where nr01=?', $a01, array($a55['p03']));
					if(empty($data['p06'])){
						$data['p06'] = $a10['p00'] . ' ' . $a55['p701'] . ' ' . $a55['p06'];//παραστατικο
					}
					if(empty($data['p09'])){
						$data['p09'] = $a55['p0121']; 										//καταστημα
					}
					if(empty($data['p900'])){
						$data['p900'] = $a55['p04']; 										//υποκατάστημα
					}
					if(empty($data['p503'])){
						$data['p503'] = $a55['p503']; 										//κωδ.έργου
					}
					if(empty($data['p504'])){
						$data['p504'] = $a55['p504']; 										//κωδ.εργασίας
					}
					if(empty($data['p401'])){
						$data['p401'] = $a55['p016']; ; 									//κωδ.πωλιτή
					}
				}
			}elseif(in_array($data['p303'], [11,12,14,15,16,18])){
				pegasus_mysql_use('select * from tran01 where nr01=?', $tran01, array($data['p302']));
				if($tran01['nr01']>0){
					pegasus_mysql_use('select * from tran20 where p01=?', $tran20, array($tran01['p105']));
					pegasus_mysql_use('select * from a01 where nr01=?', $a01, array($tran01['p61']));
					if(empty($data['p06'])){
						$data['p06'] = $tran20['p00'] . ' ' . $tran01['sp00'] . ' ' . $tran01['p00'];
					}
					if(empty($data['p09'])){
						$data['p09'] = $tran01['p704'];
					}
					if(empty($data['p900'])){
						$data['p900'] = $tran01['p611'];
					}
					if(empty($data['p503'])){
						$data['p503'] = $tran01['p302'];
					}
					if(empty($data['p504'])){
						$data['p504'] = $tran01['p303'];
					}
					if(empty($data['p401'])){
						$data['p401'] = $tran01['p101'];
					}
				}
			}elseif(in_array($data['p303'], [71,72])){
				pegasus_mysql_use('select * from este01 left join a01 on a01.nr01=este01.p05 where este01.nr01=?', $a01, array($data['p302']));
			}

			$data['pn02'] = (!empty($a55['pn02'])) ? $a55['pn02'] : 1; //Να το ξαναδούμε

			$arr1 = array();            $arr2 = array();
			if(empty($data['p01'])){
				$data['p01'] = $a01['p21'];
			}
			array_push($arr1, 'p01');   array_push($arr2, $data['p01']);

			if(empty($data['p03'])){
				$data['p03'] = $amount * $p_kkxr;
			}
			array_push($arr1, 'p03');   array_push($arr2, $data['p03']);

			if(empty($data['p04'])){
				$data['p04'] = $amount * $p_kkpi;
			}
			array_push($arr1, 'p04');   array_push($arr2, $data['p04']);

			if(empty($data['pn03'])){
				$data['pn03'] = $amount * $p_kkxr * $data['pn02'];
			}
			array_push($arr1, 'pn03');  array_push($arr2, $data['pn03']);

			if(empty($data['pn04'])){
				$data['pn04'] = $amount * $p_kkpi * $data['pn02'];
			}
			array_push($arr1, 'pn04');  array_push($arr2, $data['pn04']);

			if(empty($data['pn01'])){
				$data['pn01'] = $a55['pn01'];
			}
			array_push($arr1, 'pn01');  array_push($arr2, $data['pn01']);

			array_push($arr1, 'pn02');  array_push($arr2, $data['pn02']);

			array_push($arr1, 'p07');   array_push($arr2, $p_kklo);
			array_push($arr1, 'p900');  array_push($arr2, $data['p900']);
			array_push($arr1, 'p503');  array_push($arr2, $data['p503']);
			array_push($arr1, 'p504');  array_push($arr2, $data['p504']);
			

			if(!empty($data['p02'])){
				array_push($arr1, 'p02');   array_push($arr2, $data['p02']);
			}
			if(!empty($data['p02t'])){
				array_push($arr1, 'p02t');  array_push($arr2, $data['p02t']);
			}
			if(!empty($data['p05'])){
				array_push($arr1, 'p05');   array_push($arr2, $data['p05']);
			}

			//αν μου περνα data['nr01'] elegxo an yparxei h eggrafh
			if($data['nr01']>0){ //Υπάρχον t01 για αυτό το pos04_00
				array_push($arr1, 'p06');   array_push($arr2, $data['p06']);
				array_push($arr1, 'p09');   array_push($arr2, $data['p09']);
				array_push($arr1, 'p401');  array_push($arr2, $data['p401']);
				pegasus_mysql_update('t01', $arr1, $arr2, 'nr01=:nr01', 0, 1, 1, array('nr01'=>$data['nr01']));
			}else{
				$data['p401'] = $_SESSION['username'];                          //εισπράκτορας

				$aa = 0;
				if(($data['p303']=='0' || $data['p303']=='71') && !empty($t02['p0903'])){
					$data['p09'] = $_SESSION['cor003_p104'];
					$aa = account_make_invoice_num($data['p09'], $t02['p0903'], $t02['p0903_2']);
		
					$data['p06'] = "";
					if(!empty($t02['p0903_1'])) {
						$data['p06'] .= $t02['p0903_1'] . " ";
					}
					if(!empty($t02['p0903_2'])) {
						$data['p06'] .= $t02['p0903_2']. " ";
					}
			
					$data['p06'] .= $aa;
				}

				array_push($arr1, 'p06');   array_push($arr2, $data['p06']);
				array_push($arr1, 'p09');   array_push($arr2, $data['p09']);
				array_push($arr1, 'p401');  array_push($arr2, $data['p401']);

				$data['nr01'] = pegasus_mysql_newrec('t01');

				array_push($arr1, 'nr01');  array_push($arr2, $data['nr01']);
				array_push($arr1, 'p303');  array_push($arr2, $data['p303']);

				array_push($arr1, 'pd101'); array_push($arr2, $data['pd101']);
				array_push($arr1, 'pd102'); array_push($arr2, $data['pd102']);
				
				if(!empty($data['p302'])){
					array_push($arr1, 'p302');  array_push($arr2, $data['p302']);
				}
				pegasus_mysql_insert('t01', $arr1, $arr2);
			}
		}
	}
	pegasus_mysql_use('select * from t01 where nr01=?', $t01, array($data['nr01']));
	if($aa>0){
		$t01['p06_aa'] = $aa;
	}
	return $t01;
}

function account_add_payment_check($tbl, $nr01s){

	$ret_arr = array('ok'=>1, 'msg'=>'');
    
    foreach($nr01s as $nr01) {

        pegasus_mysql_use("SELECT * FROM ".$tbl." WHERE nr01 = ?", $tbl_data, array($nr01));

        if($tbl=='a55'){
            $a01_nr01 = $tbl_data['p03']; 

            $query_a10 = "  select 
                                a10.p00, 
                                t02.p03 as t02_p03, 
                                t02.p04 as t02_p04 
                            from a10 
                            join t02 on t02.p01=a10.p04
                            where a10.p01=?";
            pegasus_mysql_use($query_a10, $a10, array($tbl_data['p05']));

            //Συντελεστές Χρέωσης/Πίστωσης στον ΚΚ του τυπου Παραστατικού
            $t02_p03 = $a10['t02_p03'];
            $t02_p04 = $a10['t02_p04'];

            $msg_prefix = "<u>" . $a10['p00'] . " " . $tbl_data['p701'] . " " . $tbl_data['p06'] . " (" . $nr01 . ")</u>";

        }elseif($tbl=='tran01'){
            $a01_nr01 = $tbl_data['p61'];

            $query_tran20 = " 	select 
									tran20.p00, 
									t02.p03 as t02_p03, 
									t02.p04 as t02_p04 
								from tran20 
								join t02 on t02.p01=tran20.p04
								where tran20.p01=?";
            pegasus_mysql_use($query_tran20, $tran20, array($tbl_data['p105']));

            //Συντελεστές Χρέωσης/Πίστωσης στον ΚΚ του τυπου Παραστατικού
            $t02_p03 = $tran20['t02_p03'];
            $t02_p04 = $tran20['t02_p04'];

            $msg_prefix = "<u>" . $tran20['p00'] . " " . $tbl_data['sp00'] . " " . $tbl_data['p00'] . " (" . $nr01 . ")</u>";
        }


		//*1* Θα πρέπει τα επιλεγμένα ΜΚ (Παραστατικά/Φορτωτικές) να έχουν τον ίδιο Πελάτη. 
		if(!isset($curr_a01)) { $curr_a01 = $a01_nr01; }
		if($curr_a01!=$a01_nr01) {
			$ret_arr['ok']  = 0;
			$ret_arr['msg'] = $_SESSION['peg_dic_account_add_payment_error_diff_a01_'.$tbl];
			break;
		}


        //*2* Θα πρέπει τα επιλεγμένα ΜΚ (Παραστατικά/Φορτωτικές) να έχουν ίδιο Συντελεστή Χρέωσης και Πίστωσης στον ΚΚ τους. 
		//Θα χρειαστώ το Συντελεστή Χρέωσης και Πίστωσης στην οθόνη Είσπραξης για τον περιορισμό των Παραστατικών/Φορτωτικών (combobox)
        if(!isset($curr_t02_p03)) { $curr_t02_p03 = $t02_p03; }
        if(!isset($curr_t02_p04)) { $curr_t02_p04 = $t02_p04; }

        if($curr_t02_p03!=$t02_p03 || $curr_t02_p04!=$t02_p04) {
            $ret_arr['ok']  = 0;
            $ret_arr['msg'] = $_SESSION['peg_dic_account_add_payment_error_diff_t02_'.$tbl];
            break;
        }


		//*3* Θα πρέπει τα επιλεγμένα ΜΚ (Παραστατικά/Φορτωτικές) να έχουν εκδοθεί 
        if($tbl=='a55'){
            // Αν το παραστατικό είναι υπό έκδοση
            if($tbl_data['y_ekd'] == 1) {
                if(!empty($ret_arr['msg'])) {
                    $ret_arr['msg'] .= '<br>';
                }
                $ret_arr['ok']   = 0;
                $ret_arr['msg'] .= $msg_prefix . ": " . $_SESSION['peg_dic_account_add_payment_error_y_ekd'];
                continue;
            }

        }elseif($tbl=='tran01'){
            //Αν δεν έχει εκδοθεί η Φορτωτική
            if($tbl_data['sp02'] != 1) {
                if(!empty($ret_arr['msg'])) {
                    $ret_arr['msg'] .= '<br>';
                }

                $ret_arr['ok']   = 0;
                $ret_arr['msg'] .= $msg_prefix . ": " . $_SESSION['peg_dic_account_add_payment_error_tran01_not_issued'];
                continue;
            }
        }
        


		//*4* Θα πρέπει τα επιλεγμένα ΜΚ (Παραστατικά/Φορτωτικές) να έχουν Υπόλοιπο
        $t35_p03 = pegasus_mysql_printfld('t35', 'p03', 'tbl=:tbl AND tbl_nr=:nr01', array('tbl'=>$tbl, 'nr01'=>$nr01));
        if(empty($t35_p03) || $t35_p03 == 0) {
            if(!empty($ret_arr['msg'])) {
                $ret_arr['msg'] .= '<br>';
            }
            $ret_arr['ok']   = 0;
            $ret_arr['msg'] .= $msg_prefix . ": " . $_SESSION['peg_dic_account_add_payment_error_no_t35_'.$tbl];
            continue;
        }

    }

	return $ret_arr;
}

function account_account_002_d_initialize($data, $mmnr01='', $mnr01='', $_d='', $container_id=''){

	global $PegInput;

    $PegInput->addVar(new peg_input_alphanumeric('account_mode'));
    $PegInput->addVar(new peg_input_alphanumeric('account_nr01s'));

	$account_mode  = $PegInput->getRequest('account_mode');
	$account_nr01s = $PegInput->getRequest('account_nr01s');
    $account_nr01s = array_filter(explode(',', $account_nr01s));

	
	$data['tbl_records'] = array();
	if(in_array($account_mode, array('a55_d', 'a55_d01'))){
		$data['v_tbl'] = 'a55';
	}elseif($account_mode=='tran01_d'){
		$data['v_tbl'] = 'tran01';
	}
	

	$repsonse = account_add_payment_check($data['v_tbl'], $account_nr01s);
	if($repsonse['ok']==0){
		$data = array('permDeny'=>1, 'permDenyMessage'=>$repsonse['msg']);
		return $data;
	}



	$msg_add = $_SESSION['peg_dic_account_add_payment_msg_'.$data['v_tbl']];

	if(!empty($msg_add)){
		$data['msg_add'] = '<div class="peg_alert_info_plain" style="text-align:center;">'.$msg_add.'</div>';
	}


	$i = 1;
	$amount = 0;
	foreach($account_nr01s as $tbl_nr01) {
		$t35_p03 = pegasus_mysql_printfld('t35', 'abs(p03)', 'tbl=:tbl AND tbl_nr=:nr01', array('tbl'=>$data['v_tbl'], 'nr01'=>$tbl_nr01));

		$tbl_array['tbl_rec_nr01_'.$i]   = $tbl_nr01;
		$tbl_array['tbl_rec_amount_'.$i] = $t35_p03;
		
		$amount += $tbl_array['tbl_rec_amount_'.$i];

		$par_lek = $_SESSION['peg_dic_account_add_payment_label_'.$data['v_tbl']];
		if($data['v_tbl']=='a55'){
			pegasus_mysql_use("SELECT * FROM a55 WHERE nr01=?", $a55, array($tbl_nr01));
			pegasus_mysql_use("SELECT * FROM a10 WHERE p01=?", $a10, array($a55['p05']));

			$a01_nr01 = $a55['p03'];
			$t02_p01  = $a10['p04'];
	
			$memo_data = array();
			$memo_data['seira']    = $a55['p701'];
			$memo_data['arithmos'] = $a55['p06'];
			$memo_data['typos']    = $a10['p02'];
			$memo_data['date']     = peg_dateToStr($a55['p01']);
			$memo_data['time']     = $a55['p02'];
			
			if($_SESSION['lang'] == 'EN') {
				$memo_data['typos'] = $a10['ep02'];
			}
	
			$memo_html = $par_lek . ': ' . $a10['p00'] . ' / ' . $memo_data['seira'] . ' No. ' . $memo_data['arithmos'] . ' / ' . $memo_data['date']. ' ' .$memo_data['time'];
			$tbl_array['tbl_rec_memo_'.$i] = $memo_html;

		}elseif($data['v_tbl']=='tran01'){
			
			pegasus_mysql_use("SELECT * FROM tran01 WHERE nr01=?", $tran01, array($tbl_nr01));
			pegasus_mysql_use("SELECT * FROM tran20 WHERE p01=?", $tran20, array($tran01['p105']));

			$a01_nr01 = $tran01['p61'];
			$t02_p01  = $tran20['p04'];
	
			$memo_data = array();
			$memo_data['seira']    = $tran01['sp00'];
			$memo_data['arithmos'] = $tran01['p00'];
			$memo_data['typos']    = $tran20['p02'];
			$memo_data['date']     = peg_dateToStr($tran01['p014']);
			$memo_data['time']     = $tran01['p017'];
			
			if($_SESSION['lang'] == 'EN') {
				$memo_data['typos'] = $tran20['ep02'];
			}
	
			$memo_html = $par_lek . ': ' . $tran20['p00'] . ' / ' . $memo_data['seira'] . ' No. ' . $memo_data['arithmos'] . ' / ' . $memo_data['date']. ' ' .$memo_data['time'];
			$tbl_array['tbl_rec_memo_'.$i] = $memo_html;
		}

		
		pegasus_mysql_use("SELECT p03, p04 FROM t02 WHERE t02.p01=?", $t02, array($t02_p01));
		
		$i++;
	}
	

	pegasusSetGlobalVar($container_id.'_v_tbl', $data['v_tbl']);
	pegasusSetGlobalVar($container_id.'_v_tbl_recs', $account_nr01s);
	pegasusSetGlobalVar($container_id.'_v_t02_p03', $t02['p03']);
	pegasusSetGlobalVar($container_id.'_v_t02_p04', $t02['p04']);
	pegasusSetGlobalVar($container_id.'_v_a01', $a01_nr01);



	//Ο Τρόπος Είσπραξης θα πρέπει 
	// να ΜΗΝ έχει συνδεδεμένη POS Συσκευή
	// να έχει Κ.Κ. Λογιστηρίου με Θετικό Συντελεστή Πίστωσης (Θετική Χρέωση Παραστατικού)
	// να έχει Κ.Κ. Λογιστηρίου με Αρνητικό Συντελεστή Πίστωσης (Αρνητική Χρέωση Παραστατικού)
	$query_v_a14 = "select a14.*, t02.p03 as t02_p03, t02.p04 as t02_p04
					from a14
					join t02 on t02.p01=a14.p02
					left join pos00_02 on pos00_02.a14=a14.nr01
					where 	a14.p100>=0 								
							and a14.p02>0 
							and pos00_02.nr01 is null 
							and t02.p04!=0
							and if(:t02_p03>0, t02.p04>0, t02.p04<0)
					";
	pegasusSetGlobalVar($container_id . '_query_v_a14', array('sql'=>$query_v_a14, 'sqlParams'=>array('t02_p03'=>$t02['p03'])));



	$data['v_amount']     = $amount;
	$data['v_a01'] 	      = $a01_nr01;
	$data['tbl_records']  = $tbl_array;

	$data['v_tbl_hidden'] = 2;
	$data['v_a14_hidden'] = false; 
	
	return $data; 
}

function account_account_003_d_initialize($data, $mmnr01='', $mnr01='', $_d='', $container_id=''){

	global $PegInput;
	
	$PegInput->addVar(new peg_input_alphanumeric('v_mode'));
	$PegInput->addVar(new peg_input_alphanumeric('v_nr01s'));
	
	$v_mode  = $PegInput->getRequest('v_mode');	
	$v_nr01s = $PegInput->getRequest('v_nr01s');
	
	$data['v_mode']   = isset($v_mode) ? $v_mode : "";
	$data['v_nr01s']  = isset($v_nr01s) ? $v_nr01s : "";

	$data['v_mode_hidden']  = 2;
	$data['v_nr01s_hidden'] = 2;
	if(!pegasus_module_exists("account00")){
		$data['btn02_hidden'] = 1;
	}
	
	return $data; 
}

function account_account_002_d_comboboxV2_dynamic_fields_where($field_name, $container_id){ 

	$ret_arr = array('sql' => '', 'sqlParams' => array());
	$v_tbl   = pegasusGetGlobalVar($container_id.'_v_tbl');
	

    if (substr($field_name, 0, 13) == 'tbl_rec_nr01_') {

		$where 		= "";
		$values_arr = array();
		$values_arr['t02_p03']  = pegasusGetGlobalVar($container_id.'_v_t02_p03');
		$values_arr['t02_p04']  = pegasusGetGlobalVar($container_id.'_v_t02_p04');
		$values_arr['a01_nr01'] = pegasusGetGlobalVar($container_id.'_v_a01');
		
		
		$tbl_recs    = pegasusGetGlobalVar($container_id.'_v_tbl_recs');
		$tbl_recs_in = pegasus_mysql_create_in($tbl_recs, 'tbl_nr01');

		//Εξαιρεί τις εγγραφές που εμφανίζονται στα υπόλοιπα Δυναμικά Πεδία
		if(is_array($tbl_recs_in['sqlParams']) && count($tbl_recs_in['sqlParams'])>0){
			$where     .= " AND ".$v_tbl.".nr01 NOT IN (".$tbl_recs_in['sql'].") ";
			$values_arr = array_merge($values_arr, $tbl_recs_in['sqlParams']);
		}


		if($v_tbl=='a55'){

			//Φέρνει τα Παραστατικά που έχουν Εκδοθεί, που έχουν Υπόλοιπο και που εχουν ιδιο Συντελεστή Χρέωσης/Πιστωσης με τα υπολοιπα
			$sql  = "a55.y_ekd=0 AND a55.nr01 IN (SELECT t35.tbl_nr FROM t35 WHERE t35.tbl='a55' AND t35.p03<>0) ";       
			$sql .= " AND a55.nr01 IN (
										select a55.nr01 from a55
										join a10 on a10.p01=a55.p05
										join t02 on t02.p01=a10.p04
										where t02.p03=:t02_p03 and t02.p04=:t02_p04 and a55.p03=:a01_nr01	
									) ";

		}elseif($v_tbl=='tran01'){
			//Φέρνει τις Φορτωτικές που έχουν Εκδοθεί, που έχουν Υπόλοιπο και που εχουν ιδιο Συντελεστή Χρέωσης/Πιστωσης με τα υπολοιπα
			$sql  = "tran01.sp02=1 AND tran01.nr01 IN (SELECT t35.tbl_nr FROM t35 WHERE t35.tbl='tran01' AND t35.p03<>0) ";       
			$sql .= " AND tran01.nr01 IN (
										select tran01.nr01 from tran01
										join tran20 on tran20.p01=tran01.p105
										join t02 on t02.p01=tran20.p04
										where t02.p03=:t02_p03 and t02.p04=:t02_p04 and tran01.p61=:a01_nr01	
									) ";  			
		}

		$sql .= $where;
		
		$ret_arr['sql'] 	  = $sql;
		$ret_arr['sqlParams'] = $values_arr;
    }

    return $ret_arr;
}

function account_account_002_d_pay($container_id, $data){

	$ret_array = array('ok'=>1, 'msg'=>$_SESSION["peg_dic_account_pay_success"]);

	$v_tbl = $data['v_tbl'];
	$v_a01 = $data['v_a01'];
	$v_a14 = $data['v_a14'];

	//Έλεγχος για τον επιλεγμένο Τρόπο Είσπραξης
	$stm_a14 = pegasusGetGlobalVar($container_id . '_query_v_a14');
	$stm_a14['sql'] .= ' and a14.nr01=:a14nr01 ';
	$stm_a14['sqlParams']['a14nr01'] = $v_a14;
	pegasus_mysql_use($stm_a14['sql'], $a14, $stm_a14['sqlParams']);
	
	if(!($a14['nr01']>0)){
		$ret_array['msg'] = $_SESSION["peg_dic_account_pay_error_invalid_a14"];
		$ret_array['ok']  = 0;
		return $ret_array;
	}
	

	$msg = '';
	
	$rec_nr01s   = array();
	$rec_amounts = array();
	foreach ($data as $key => $value) {
		if (preg_match('/^tbl_rec_nr01_(\d+)$/', $key, $matches)) {
			$i = $matches[1];
			$rec_nr01s[$i] = $value;
		}

		if (preg_match('/^tbl_rec_amount_(\d+)$/', $key, $matches)) {
			$i = $matches[1];
			$rec_amounts[$i] = $value;
		}
	}


	
	
	if(!($data['v_amount']>0)){
		$ret_array['msg'] = $_SESSION["peg_dic_account_pay_error_empty_amount"];
		$ret_array['ok']  = 0;
		return $ret_array;
	}



	if(!(count($rec_nr01s)>0)){
		$ret_array['msg'] = $_SESSION["peg_dic_account_pay_error_empty_".$v_tbl];
		$ret_array['ok']  = 0;
		return $ret_array;
	}


	//Εύρεση ΚΚ Λογιστηρίου για χρηση συντελεστή Χρεωσης/Πιστωσης
	pegasus_mysql_use('select p03,p04 from t02 where p01=?', $t02, array($a14['p02']));


	$t01_p05 = "";
	foreach ($rec_nr01s as $key => $value) {

		if(empty($rec_nr01s[$key])) {
			if(!empty($msg)) { $msg .= "<br>"; }
			$msg .= $_SESSION["peg_dic_account_pay_error_empty_".$v_tbl];
			continue;
		}

		if($v_tbl=='a55') {

			pegasus_mysql_use("SELECT * FROM a55 WHERE nr01=?", $a55, array($rec_nr01s[$key]));
			$a10_p00  = pegasus_mysql_printfld('a10', 'p00', 'p01=?', array($a55['p05']));
			$t01_main = pegasus_mysql_printfld('t01', 'nr01', 'p302=? and p303=2', array($rec_nr01s[$key])); 	//* το 2 ειναι μόνο για a55!

			$t01_p05 .= (!empty($t01_p05)) ? ", " : "";
			$t01_p05 .= $a10_p00 . $a55['p701'] . $a55['p06'];

			$msg_prefix = "<u>" . $a10_p00 . " " . $a55['p701'] . " " . $a55['p06'] . " (" . $rec_nr01s[$key] . ")</u>";
			
		}elseif($v_tbl=='tran01') {
			pegasus_mysql_use("SELECT * FROM tran01 WHERE nr01=?", $tran01, array($rec_nr01s[$key]));
			$tran20_p00 = pegasus_mysql_printfld('tran20', 'p00', 'p01=?', array($tran01['p105']));
			$t01_main   = pegasus_mysql_printfld('t01', 'nr01', 'p302=? and p303=11', array($rec_nr01s[$key])); 	//* το 11 ειναι μόνο για tran01!

			$t01_p05   .= (!empty($t01_p05)) ? ", " : "";
			$t01_p05   .= $tran20_p00 . $tran01['sp00'] . $tran01['p00'];

			$msg_prefix = "<u>" . $tran20_p00 . " " . $tran01['sp00'] . " " . $tran01['p00'] . " (" . $rec_nr01s[$key] . ")</u>";
		}
		

		if (!isset($rec_amounts[$key]) || empty($rec_amounts[$key])) {
			// Amount for the selected invoice is empty
			if(!empty($msg)) { $msg .= "<br>"; }
			$msg .= $msg_prefix . ": " . $_SESSION['peg_dic_account_pay_error_empty_amount_tbl']; 

		}else{
			$rec_amount = $rec_amounts[$key];
			$t35_ypol   = pegasus_mysql_printfld('t35', 'abs(p03)', 'tbl=:tbl AND tbl_nr=:tbl_nr', array('tbl'=>$v_tbl, 'tbl_nr'=>$rec_nr01s[$key]));
				
			if($rec_amount>$t35_ypol) {
				// Collection amount exceeds the invoice's balance
				if(!empty($msg)) { $msg .= "<br>"; }
				$msg .= $msg_prefix . ": " . $_SESSION['peg_dic_account_pay_error_invalid_amount_tbl'] . " " . $t35_ypol; 
			}else{

				//Data Αντιστοίχισης Κίνησεων
				$t38_arr[] = array(
					"p01"  => $t01_main,
					"p03"  => $a14['t02_p03']*0,
					"p04"  => $a14['t02_p04']*$rec_amounts[$key]
				);
			}
		}
	}
	

	if(!empty($msg)) {
		$ret_array['msg'] = $msg;
		$ret_array['ok']  = 0;
		return $ret_array;
	}

	
	//Εύρεση Πελάτη
	pegasus_mysql_use("SELECT nr01, p21 FROM a01 WHERE nr01=?", $a01, array($v_a01));


	//Data Κίνησης Ελεύθερης Καταχώρησης	
	if(strlen($t01_p05)>150){
		$t01_p05 = substr($t01_p05, 0, -3)."...";
	}

	$t01_arr = array(
		'data'	 => array(
						"p01"   => $a01['p21'],
						"p02"   => date("Y-m-d"),
						"p02t"  => date("H:i:s"),
						"p302"  => 0,
						"p303"  => 0,
						"pd101" => 'a14',
						"pd102" => $a14['nr01'],
						"p05"   => $t01_p05, 
						"p06"   => "", 
						"p07"   => $a14['p02']
					),
	    'amount' => $data['v_amount']
	);
	


	//Εισαγωγή Κίνησης Ελεύθερης Καταχώρησης
	$t01 = account_add_t01($t01_arr['data'], $t01_arr['amount']);
	
	if(pegasus_module_exists('account01')){
		//Εισαγωγή Αντιστοιχίσεων Κίνησης
		foreach ($t38_arr as $t38) {
			$arr1 = array_keys($t38);		$arr2 = array_values($t38);
			array_push($arr1, 'nr01');		array_push($arr2, pegasus_mysql_newrec("t38"));
			array_push($arr1, 'p02');		array_push($arr2, $t01['nr01']);
			pegasus_mysql_insert('t38', $arr1, $arr2);
		}
	}
	
	return $ret_array;
}