<?php

/**
 * Βρίσκει το υπόλοιπο του  του λογαριασμού
 * $p21 : Ο λογαριασμός
 * $p09_min: Από κατάστημα 
 * $p09_max: Εως κατάστημα
 * $date : Ημερομηνία απόδειξης - παραστατικού ...
 * $time : Ώρα απόδειξης - παραστατικού ....
 * $t01_p302: ΜΚ κίνησης
 * $t01_p303: Κωδικός κατηγορίας κίνησης
 * */
function account_find_balance($p21 = 0, $p09_min = 0,  $p09_max = 9999999999, $date = '', $time = '', $t01_p302 = 0, $t01_p303 = 0, $mode='')
{

    //* Σετάρω σωστά το $t01_p303 ακόμα και αν ειναι γεμάτο.
	if ($mode=='a55') {
		$t01_p303 = array(2, 4, 9);
	}
	if ($mode=='a56') {
		$t01_p303 = array(1, 3);
	}
	if ($mode=='t08') {
		$t01_p303 = array(6, 13);
	}
	if ($mode=='tran01') {
		$t01_p303 = array(11, 12, 14);
	}

	
	if (!isset($p09_min)) {
		$p09_min = 0;
	}
	if (!isset($p09_max)) {
		$p09_max = 0;
	}

	//* Αν δεν έχει σεταρισμένη Ημερομηνία και δεν εχει ΜΚ Παραστατικού κάνει return το τρέχον υπόλοιπο
	if (peg_dateIsEmpty($date, 'Y-m-d') && empty($t01_p302)) {
		pegasus_mysql_use("select ifnull(sum(t00tot.p03),0) as balance from t00tot where p01=? and p09>=? and p09<=?", $t00tot, array($p21, $p09_min, $p09_max));
		return $t00tot['balance'];
	}
    if(peg_dateIsEmpty($date, 'Y-m-d') ){
        $date = date('Y-m-d');
    }
	$query_params = array();
	$where_time = '';
	if (!empty($time) && $time != '') {
		$where_time = " and if(p02t='', remftime <= :wh_remftime ,p02t<=:wh_p02t )";
		$query_params['wh_remftime'] = $time;
		$query_params['wh_p02t'] = $time;
	}

	$where_p302 = '';
	if (!empty($t01_p302) && $t01_p302 != '') {
		if(is_array($t01_p303) && !empty($t01_p303)) {
			$t01_p303_in = pegasus_mysql_create_in($t01_p303, "t01_p303");
			$query_params  = array_merge($query_params, $t01_p303_in['sqlParams']);

			$where_p302 .= " and  !( p303 in ({$t01_p303_in['sql']}) and p302 =:wh_p302 ) ";
			$query_params['wh_p302'] = $t01_p302;
			$query_params['wh_p303'] = $t01_p303;
		}else{
			$where_p302 = " and (p302<>:wh_p302 or p303<>:wh_p303) ";
			$query_params['wh_p302'] = $t01_p302;
			$query_params['wh_p303'] = $t01_p303;
		}
	}

	$query = "SELECT ifnull( sum(p03) - sum(p04) , 0 ) as sum
			  FROM t01 
			  WHERE p01 = :q_p01 
				$where_p302 
				and (p02< :q_p02_0 or (p02= :q_p02_1 $where_time ))
				and p09>=:q_p09_min and p09<=:q_p09_max	";
	$query_params['q_p01'] = $p21;
	$query_params['q_p02_0'] = $date;
	$query_params['q_p02_1'] = $date;
	$query_params['q_p09_min'] = $p09_min;
	$query_params['q_p09_max'] = $p09_max;
	pegasus_mysql_use($query, $ret, $query_params);
	
	// echo '<pre>' . pegasus_replace_values_in_sql($query, $query_params) . '</pre>';
	// echo '<pre>' .print_r($ret, 1). '</pre>';
	return $ret['sum'];
}

/**
 * H synartisi poy arxikopoie;i to t3_d1
 * @param array() $data //$this->data
 */
function peg_account_t3_d1_initialize($data, $mmnr01, $mnr01, $_d, $container_id)
{

	$data['account__t3_d1_grid_account_view_crm_hidden'] = (pegasus_module_exists('crm001'))    ? false : true;
	$data['account__t3_d1_grid_account_view_a01_hidden'] = (pegasus_module_exists('customers')) ? false : true;
	$data['account__t3_d1_grid_account_view_a00_hidden'] = (pegasus_module_exists('suppliers')) ? false : true;
	$data['account__t3_d1_grid_account_view_d01_hidden'] = (pegasus_module_exists('crm002'))    ? false : true;
	$data['account__t3_d1_grid_account_ins_t08_hidden']  = (pegasus_module_exists('receipts'))  ? false : true;
	$data['account__t3_d1_grid_account_view_t01_hidden'] = (pegasus_module_exists('account'))   ? false : true;

	if (pegasus_module_exists('stores')) {

		if (function_exists('peg_stores_get_all_stores_multi')) {
			$data['t_kat'] = peg_stores_get_all_stores_multi();
		}
	}

	$data['t_pe1']	= 30; //Periodos 1
	$data['t_pe2']	= 60; //Periodos 2
	$data['t_pe3']	= 90; //Periodos 3

	$t_type = $_REQUEST['t_type'];
	$data['t_kind']	= 1;
	if ($t_type == 'a01' || $t_type == 'a00') {
		$data['t_type'] = $t_type;
	} else {
		$data['t_type'] = 'a01';
	}

	if ($data['t_type'] == 'a01') {
		$data['t_y1']	= 0.01; // Apo upoloipo
		$data['t_y2']	= 9999999999.99; //Eos Ypoloipo
		// $data['account__t3_d1_bt_a01open_hidden'] = 0;
		// $data['account__t3_d1_bt_a00open_hidden'] = 1;
		$data['account__t3_d1_grid_account_view_a00_hidden'] = true;
	} else {
		$data['t_y1']	= -9999999999.99; //Eos Ypoloipo
		$data['t_y2']	= -0.01; // Apo upoloipo
		// $data['account__t3_d1_bt_a01open_hidden'] = 1;
		// $data['account__t3_d1_bt_a00open_hidden'] = 0;
		$data['account__t3_d1_grid_account_view_a01_hidden'] = true;
	}

	pegasusSetGlobalVar('_t3_d1_query_' . $container_id, peg_account_t3_d_query($data));
	return $data;
}