function app_health_show_p92_d00(
	nr01
) {
	return app_health_show_d('', 'p92_d00', 'core', { p92: nr01 })
}
function app_health_show_d(
	table,
	_d,
	module,
	params = {},
	nr01 = 0
) {
	return pegAddTab_d(
		'',
		table,
		_d,
		module,
		'',
		nr01,
		'',
		params
	);
}
function app_health_app_health01_d_check_all(screen) {
	const container_id = screen.getContainer_ID()
	scenarios = []
	return app_health_scenario_loader_find(function (error, data) {
		if (error) {
			return pegAlert(error.message)
		}
		for (module in data) {
			var cnt = 0
			for (senarionName in data[module].scenarios) {
				cnt++
				scenarios.push({
					module: module,
					scenario: senarionName,
					moduleName: data[module].name,
					len: Object.keys(data[module].scenarios).length,
					cnt: cnt
				})
			}
		}
		if (scenarios.length > 0) {
			scenarios.reverse()
			pegSetVal('p01', container_id, '');
			return app_health_app_health01_d_check_single_html(container_id, scenarios, scenarios.length)
		}

	})
}
var app_health_app_health01_d_check_single_html_ajax = ''
function app_health_app_health01_d_check_single_html(container_id, scenarios, len) {
	const scenario = scenarios.pop()
	const p02 = pegGetCmp(container_id, 'p02')
	p02.reset();
	p02.updateProgress(
		'1', 
		`
			Module: ${scenario.moduleName} - ${scenario.cnt} / ${scenario.len}
			<br>${len - scenarios.length} / ${len}
		`
		, true);
	if (app_health_app_health01_d_check_single_html_ajax != '') {
		if (app_health_app_health01_d_check_single_html_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(app_health_app_health01_d_check_single_html_ajax)
		}
	}
	const params = {
		module: scenario.module,
		scenario: scenario.scenario
	}
	const url = '/' + main_path + '/app_health01/app_health_app_health01_d_check_single_html.php'
	app_health_app_health01_d_check_single_html_ajax = pegAjaxDefer(url, params, function (jsonData) {
		if (jsonData.ok != 1) {
			p02.reset();
			return pegAlert(jsonData.msg)
		}
		//
		let p01_val = pegGetVal('p01', container_id);
		p01_val = `${jsonData.data.html}\n${p01_val}`;
		pegSetVal('p01', container_id, p01_val)
		//
		if (scenarios.length > 0) {
			return app_health_app_health01_d_check_single_html(container_id, scenarios, len)
		}
		return app_health_scenario_loader_end(0,function(error,data) {
			if(error) {
				return pegAlert(error)
			}
			p02.reset();
			pegGetDic('peg_dic_app_health_app_health01_p02_end', function (msg) {
				p02.updateProgress('1', `${len - scenarios.length} / ${len}<br>${msg}`, true);
			})

		})
	}, 'json', 0, true)
	return
}
var app_health_scenario_loader_find_ajax = ''
function app_health_scenario_loader_find(next) {
	if (app_health_scenario_loader_find_ajax != '') {
		if (app_health_scenario_loader_find_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(app_health_scenario_loader_find_ajax)
		}
	}
	const url = '/' + main_path + '/app_health01/app_health_scenario_loader_find.php'
	app_health_scenario_loader_find_ajax = pegAjaxDefer(url, {}, function (jsonData) {
		if (jsonData.ok != 1) {
			return next(new Error(jsonData.msg))
		}
		return next(null, jsonData.data)
	}, 'json', 0, true)
	return
}
var app_health_scenario_loader_end_ajax = '' 
function app_health_scenario_loader_end(p02 = 0,next) {
	if (app_health_scenario_loader_end_ajax != '') {
		if (app_health_scenario_loader_end_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(app_health_scenario_loader_end_ajax)
		}
	}
	const url = '/' + main_path + '/app_health01/app_health_scenario_loader_end.php'
	app_health_scenario_loader_end_ajax = pegAjaxDefer(url, {p02:p02}, function (jsonData) {
		if (jsonData.ok != 1) {
			return next(new Error(jsonData.msg))
		}
		return next(null, jsonData.data)
	}, 'json', 0, true)
	return
}
function app_health_dashboard_later_link(a) {
	return app_health_scenario_loader_end(1,function(error,data) {
		if(error) {
			return pegAlert(error)
		}
		const parent_container_id = pegGetContainer_id_d("_main_d", dashboard00_find_screen_name(), "", "_main_d");
		const app_health_msg = pegGetCmp(parent_container_id,'app_health_msg');
		app_health_msg.setHidden(true);
	})
}