<?php
if (!class_exists('App_health_scenario')) {
	require_once('../../pegasus_cloud_app/app_health_libs/app_health_scenario.php');
}
if (!class_exists('App_health_scenario_loader_class')) {
	require_once('../../pegasus_cloud_app/app_health_libs/app_health_scenarios_loader.php');
}
function app_health_get_last_check() {

	$nr01 = pegasus_mysql_printfld(
		'p95p55',
		'nr01',
		'en=1 AND module = :module AND p95 = :p95',
		array(
			'module'	=> 'app_health',
			'p95'		=> $_SESSION['user_profile']
		)
	);
	if(!($nr01 > 0)) {
		return '';
	}
	if($_SESSION['app_health00_p02'] == 1) {
		date('Y-m-d') < peg_addDate($_SESSION['app_health00_p01'],'Y-m-d',30);

		return '';
	}
	$template = peg_read_file('../../pegasus_cloud_app/app_health_templates/app_health_dashboard_panel_message.html');
	$ico_class = 'x-fa fa-heartbeat';
	$color_fo = '#004085';
	$color_bo = '#b8daff';
	$color_bg = '#cce5ff';
	$message = $_SESSION['peg_dic_app_health_dashboard00'];
	$template = str_replace('#message#', $message, $template);
	$ret = str_replace(
		array(
			'ico-class',
			'color-fo',
			'color-bo',
			'color-bg'
		),
		array(
			$ico_class,
			$color_fo,
			$color_bo,
			$color_bg
		),
		$template
	);
	return $ret;
}
function app_health_scenario_loader_end($p02 = 0) {
	$update = array(
		'nr01'	=> 1,
		'p01'	=> date('Y-m-d'),
		'p02'	=>$p02
	);
	pegasus_mysql_insert(
		'app_health00',
		array_keys($update),
		array_values($update),
		1
	);
	pegasusWriteSession('app_health00');
	pegasusReadSession('app_health00');

	return array(
		'ok'	=> 1,
		'data'	=> null,
		'msg'	=> 'Success'
	);
	
}
/**
 * Εκτέλεση συγκεκριμένου σεναρίου (module / scenario)
 *
 * @param string $module
 * @param string $scenario
 * @return array
 */
function app_health_scenario_loader_check(
	$module = '',
	$scenario = ''
) {
	$modules = pegasus_query("SELECT p00,p01 FROM p55 WHERE en = 1");
	$modules = pegasus_fetchall($modules);
	$app_health_scenario_loader = new AppHealthScenariosLoader();
	$ret = $app_health_scenario_loader->check($modules, $module, $scenario);
	return $ret;
}
/**
 * Επιστρέφει ενα (html) αποτελεσμα απο την εκτέλεση του ζητουμενου ελεγχου
 *
 * @param string $module	To module που ειναι καταχωρημενος ο ελεγχος
 * @param string $scenario	Το ονομα του σεναριου / ελεγχου
 * @return array data[
 *  - html	Το html response toy ελεγχου (template)
 * ]
 */
function app_health_scenario_loader_check_html(
	$module = '',
	$scenario = ''
) {
	//	Αν για κάποιο λόγο ο ελεγχοσ δεν εκτελεστει (οχι εκτελεστει ανεπιτυχος) απλα επιστρεφουμε την αποτυχια
	$resp = app_health_scenario_loader_check($module, $scenario);
	if ($resp['ok'] != 1) {
		return $resp;
	}
	$check = $resp['data'];
	$tempate = peg_read_file('../../pegasus_cloud_app/app_health_templates/app_health_check_row.html');
	//	Δημιουργία HTML
	//	** Αν ο έλεγχος δεν είναι επιτυχής
	$class = 'peg_alert_danger';
	$message = $check['message'];
	if (!empty($check['_d'])) {
		//	Αν ο ελεγχος επιστρεψει εγγραφει _d τοτε διμιουργουμε ενα link για αυτην την οθονη.
		//	Το _d πρεπει να ειναι array και να εχει τις τιμές table, _d, module και προερετικά τις params και nr01.
		$table	= $check['_d']['table'];
		$_d		= $check['_d']['_d'];
		$module	= $check['_d']['module'];
		$params	= isset($check['_d']['params']) ? $check['_d']['params'] : '{}';
		$nr01	= isset($check['_d']['nr01']) ? $check['_d']['nr01'] : '0';
		$flt	= 'desc02';
		if ($_SESSION['lang'] != 'GR') {
			$flt = 'edesc02';
		}
		$values = array(
			'desc05'	=> 'screen',
			'p02'		=> $_d,
			'module'	=> $module
		);
		$title = pegasus_mysql_printfld('p51', $flt, 'desc05 = :desc05 AND p02 = :p02 AND module = :module', $values);
		$href = "javascript:app_health_show_d('$table','$_d','$module',$params,'$nr01')";
		$message = str_replace(
			'#link#',
			'<a style="color: inherit; font-weight: bold;" href="' . $href . '">' . $title . '</a>',
			$message
		);
	} elseif (!empty($check['p92'])) {
		//	Ο ελεγχος μπορει να επιστρεψει εγγραφει p92 τοτε δημιουργουμε link για αυτον τον αυτοματισμό
		//	Το p92 πρέπει να είναι int (το nr01 του αυτοματισμου)
		$flt = 'p01';
		if ($_SESSION['lang'] != 'GR') {
			$flt = 'ep01';
		}
		$title = pegasus_mysql_printfld('p92', $flt, 'nr01=:nr01', array('nr01' => $check['p92']));
		$href = "javascript:app_health_show_p92_d00(" . $check['p92'] . ")";
		$message = str_replace(
			'#link#',
			'<a style="color: inherit; font-weight: bold;" href="' . $href . '">' . $title . '</a>',
			$message
		);
	}
	//	** Αν ο ελεχως είναι επιτυχής απλα επιστρέφουμε ένα info msg
	if ($check['status']) {
		$class = 'peg_alert_success';
		$message = $check['message'];

		if($check['muted']) {
			return array(
				'ok'    => 1,
				'data'  => array('html' => ''),
				'msg'   => 'Success'
			);
		}
	}
	$ret = str_replace(
		array(
			'#class#',
			'#message#'
		),
		array(
			$class,
			$message
		),
		$tempate
	);
	return array(
		'ok'    => 1,
		'data'  => array('html' => $ret),
		'msg'   => 'Sucess'
	);
}
/**
 * Αναζήτηση σεναρίων / ελεγχων για ολα τα διαθεσιμα module της εφαρμογής
 * @return array
 */
function app_health_scenario_loader_find()
{
	$modules = pegasus_query("SELECT p00,p01 FROM p55 WHERE en = 1");
	$modules = pegasus_fetchall($modules);
	$app_health_scenario_loader = new AppHealthScenariosLoader();
	$ret = $app_health_scenario_loader->find($modules);
	return $ret;
}
/**
 *
 * @param array $data
 * @param string $mmnr01
 * @param string $mnr01
 * @param string $_d
 * @param string $container_id
 * @return void
 */
function app_health_app_health01_d_initialize(
	$data = array(),
	$mmnr01 = '',
	$mnr01 = '',
	$_d = '',
	$container_id = ''
) {
	$message = $_SESSION['peg_dic_app_health_app_health01_p00'];
	$html = '<div class="peg_alert_success_plain" style="text-align:center">' .  $message . '</div>';
	$data['p00'] = $html;
	return $data;
}


function app_health_after_update(){

	if (file_exists('../../pegasus_cloud_app/app_health_app_health/app_health_app_health_isup2tendeleted.php')) {
		unlink('../../pegasus_cloud_app/app_health_app_health/app_health_app_health_isup2tendeleted.php');
	}
}