<?php

class App_healthAppHealthIsinboundsnr01 extends AppHealthScenario
{
	public function check()
	{
		$data = array(
			'status'	=> true,
			'message'	=> $_SESSION['peg_dic_app_health_app_health_isinboundsnr01_pass']
		);
		$pass = true;
		$max_nr01 = pegasus_mysql_printfld('cor000','max_nr01','nr01 = 1'); 

		$query = "SELECT p75.* FROM p75 
				  JOIN p50 ON p50.p01 = p75.p01
				  WHERE p010 > :max_nr01 AND p50.is_view = 0";
		$params = array('max_nr01' => $max_nr01);
		$result = pegasus_query($query, $params);

		$tables_out_of_bound = "";
		while($p75 = pegasus_fetch($result)){
			if(!empty($tables_out_of_bound)){
				$tables_out_of_bound .= ", ";
			}
			$perigrafi_pinaka = pegasus_mysql_printfld('p50', 'p03', 'p01 = :p75_p01' , array('p75_p01' => $p75['p01']));
			$tables_out_of_bound .= $perigrafi_pinaka . " (". $p75['p01'] .")";
			$pass = false;
		}


		$message = str_replace("##tables##", $tables_out_of_bound, $_SESSION['peg_dic_app_health_app_health_isinboundsnr01_error_1']);
		
		if (!$pass) {
			return array(
				'ok'	=> 1,
				'data'  => array(
					'status'	=> false,
					'message'	=> $message,
					'_d'		=> array('table'=>'cor000','_d'=>'cor000_d','module'=>'core','nr01'=>1),
				),
				'msg'	=> 'Fail'
			);
		}
		return array(
			'ok'	=> 1,
			'data'	=> $data,
			'msg'	=> 'Pass'
		);
	}
}
