<?php

class App_healthAppHealthIsphpversion extends AppHealthScenario
{
    public function check()
    {
        $phpvers = '7.4';
        if (function_exists('phpversion')) {
            $phpvers = substr(phpversion(), 0, 3);
        }
        $phpver = '7.4';
		$phpver1='7';
        $phcurpver = 'Unknown';
        $message = $_SESSION['peg_dic_app_health_app_health_isphpversion_pass'];
        $message = str_replace(
            '#phpver#',
            $phpvers,
            $message
        );
        $data = array(
            'status' => true,
            'message' => $message,
        );


        if (function_exists('phpversion')) {
            $phcurpver = phpversion(); 
            if (substr($phcurpver, 0, 3) < $phpver) { 
                $message = $_SESSION['peg_dic_app_health_app_health_isphpversion_error_2'];
			
                if (substr($phcurpver, 0, 1) < $phpver1  ) {													
                    $message .= $_SESSION['peg_dic_app_health_app_health_isphpversion_error_21'];
					$message .= "<br>" . $this->app_health_check_if_pdo_forms();
                }
                $message = str_replace(
                    array(
                        '#phcurpver#',
                        '#phpver#',
                    ),
                    array(
                        $phcurpver,
                        $phpver,
                    ),
                    $message
                );
                return array(
                    'ok' => 1,
                    'data' => array(
                        'status' => false,
                        'message' => $message,
                    ),
                    'msg' => 'Fail',
                );
            }
        }
        return array(
            'ok' => 1,
            'data' => $data,
            'msg' => 'Pass',
        );
    }

    private function app_health_check_if_pdo_forms()
    {
        // ----p85 checkValidation---- //
        $query = "select body_sql_code, code, nr01 from p85";
        $result = pegasus_query($query);
        $p85_with_problem = array();

        while ($p85 = pegasus_fetch($result)) {																							
            $illegal_string_exists_code = $this->app_health_check_if_illegal_string_exists($p85['code']);
            $illegal_string_exists_body_sql_code = $this->app_health_check_if_illegal_string_exists($p85['body_sql_code']);

            if ($illegal_string_exists_code || $illegal_string_exists_body_sql_code) {
                array_push($p85_with_problem, $p85['nr01']);
            }
        }
        // !! ----p85 checkValidation---- !! //

        // ----p86 checkValidation---- //
        $query = "select p30, cond, p85 from p86";
        $result = pegasus_query($query);
        $p86_with_problem = array();

        while ($p86 = pegasus_fetch($result)) {
            $illegal_string_exists_cond = $this->app_health_check_if_illegal_string_exists($p86['cond']);
            $illegal_string_exists_p30 = $this->app_health_check_if_illegal_string_exists($p86['p30']);

            if ($illegal_string_exists_cond || $illegal_string_exists_p30) {															
                array_push($p86_with_problem, $p86['p85']);
            }

        }
        // !! ----p86 checkValidation---- !! //

        //  ----customer message----  //
        $result = array_merge($p85_with_problem, $p86_with_problem);


		

        if (!empty($result)) {

			$return_message = '';
			foreach($result as $value) {
				if($_SESSION['lang']=='GR'){
 					$result_p01= pegasus_mysql_printfld('p85', 'p01', "nr01= :value", array('value'=> $value) );

				}
 else{
 	$result_p01= pegasus_mysql_printfld('p85', 'ep01', "nr01= :value", array('value'=> $value) );

 }			
				if($return_message != ''){
					$return_message .=", ";
				}	
				  $return_message .= $result_p01 . " (".$value.")";

			}
			  					 					  
		 
            $message_ill_str_exist = str_replace("##forms##", $return_message, $_SESSION['peg_dic_app_health_app_health_illegal_string_exists']);
            return $message_ill_str_exist;
        }
        return '';

    }
	private function app_health_search_for_strings($contents = '', $string_arr = array()){
		$lastPos = 0;
		$occurences='';
		$prev_line=-1;
		while($lastPos!== false){
			$pos=array();
			foreach ($string_arr as  $value) {

                if ($lastPos+1 < strlen($contents)) {
                    $p=strpos($contents, $value, $lastPos+1);
                }else{
                    break;
                }
				
				if($p!=FALSE){
					$pos[]=$p;
				}
			}
			//βρισκω την πρώτη εμφανιση κάποιου από τα stings
            /**
            * min() throws a ValueError on failure now; previously, false was returned and an E_WARNING error was emitted.
            * https://www.php.net/manual/en/function.min.php
            */
            if(empty($pos)){
                break;
            }
			$lastPos=min($pos);

			$line=(substr_count($contents,PHP_EOL,0,$lastPos)+1);
			if($line!==$prev_line){
				$tmpFnName = substr($contents, $lastPos, ( strpos($contents, '(', $lastPos) - $lastPos )  );
				$occurences.= "line: $line \n\t".$tmpFnName." ";
				if($GLOBALS['mapString'][$tmpFnName]){
					$occurences.= " --> ". $GLOBALS['mapString'][$tmpFnName];
				}
				$occurences .= PHP_EOL;
			}
			$prev_line=$line;
		}
		return $occurences;
	}

    private function app_health_check_if_illegal_string_exists($code)
    {
        /*$position = strpos($code, 'mysql_real_escape'); //false , 0, 1, 2, ->function  return true ή false
        if($position != false ){ //Βρέθηκε το illegal string
        return true;
        }
        return false;*/

        $illegal_strings = array(
            ' mysql_query',
            'pegasus_mysql_query',

            'mysql_fetch_array',
            'mysql_fetch_assoc',
            'mysql_​fetch_​field',
            'mysql_​fetch_​lengths',
            'mysql_​fetch_​row',
            'mysql_​field_​name',
            'mysql_​field_​seek',
            'mysql_​field_​table',
            'mysql_​field_​type',
            'mysql_​free_​result',

            'mysql_​num_​fields',

            'pegasus_mysql_num_rows',
            ' mysql_​num_​rows',

            'mysql_errno',
            ' mysql_error',

            'mysql_data_seek',

            ' mysql_escape_string',
            ' mysql_real_escape_string',
            'pegasus_mysql_real_escape_string',
        );

        $occurences = $this->app_health_search_for_strings($code, $illegal_strings);
        if ($occurences != '') {
            return true;
        }
        return false;

    }
}
