/**
 * @class Functions.backup.global
 * 
 * @member WebApp.view
 * 
 *  ##Properties
 *  
 *  The global variables of the module
 *  
 *   
 *  ##Methods
 *  
 	- Global variables
 	- General Functions
 	- After draw Functions
 *  
 *   
 */
//XXX Start Global variables 
if(pegGetFramework() == 'peg002'){
	//TODO MAKE THIS variables to the screen 
	var backup_task = null ;
	var restore_task= null ;	
}


//XXX Start General Functions
function backup01_make_backup(container_id , next_recs , file, step){
	
	var progressbar00 = pegGetCmp(container_id, 'progressbar00');
	
	var params = {};
	params.container_id = container_id;
	params.next_recs	= next_recs;
	params.step			= step;

	
	
	backup_ajax_execution = pegAjaxDefer('/' + main_path + '/backup01/'+file , params , function(json_data){
		if(json_data.gotonext == 1){
			backup01_make_backup(container_id , 0 , file, json_data.step);
		}else{
			progressbar00.reset().updateProgress( '1', '' , true);
			progressbar00.reset().updateProgress( '1', json_data.msg , true);
			if(backup_task ){
				try {
					backup_task.stop();	
				} catch (e) {
					// TODO: handle exception
				}

			}
			if(progressbar00 && progressbar00.peg_task){
				
				try {
					progressbar00.peg_task.stop();
				} catch (e) {
					// TODO: handle exception
				}
			}

			pegAjaxDefer('/'+main_path + '/backup01/find_zip.php' , params , function(jsondata){
				if(jsondata.ok==0){
					pegAlert(jsondata.msg);
				}else{
					pegConfirmBox( '' , jsondata.msg ,  function(but){ 
						if(but=='yes'){
							win = window.open('/'+main_path+'/backup01/download.php?container_id='+container_id, 'download');
						}
					});
				}
			});
		}
	});
}

function backup02_make_restore(container_id, gotonext){
	
	var progressbar00 = pegGetCmp(container_id, 'progressbar00');
	
	var params = {};
	params.container_id = container_id;
	params.gotonext		= gotonext;
		
	pegAjaxDefer('/' + main_path + '/backup02/restore01.php', params , function(json_data){
		if(json_data.gotonext == 1){
			backup02_make_restore(json_data.container_id , json_data.gotonext);
		}else{
			progressbar00.reset().updateProgress( '1', '' , true);
			progressbar00.reset().updateProgress( '1', json_data.msg , true);
			pegAlert(json_data.msg);
			if(restore_task){	
				try {
					restore_task.stop();					
				} catch (e) {
					// TODO: handle exception
				}

			}
			if(backup_task){
				try {
					backup_task.stop();					
				} catch (e) {
					// TODO: handle exception
				}

			}

			if(progressbar00 && progressbar00.peg_task){
				progressbar00.peg_task.stop();
			}
			
			
		}
	});
}


//XXX Start After draw functions 
/**
 * backup01_d => Εκτέλεση backup
 * @param {String} container_id
 * @returns
 */
function backup_backup01_d_afterDraw_listeners(container_id){
	var screen			= pegGetCmp(container_id );
	var progressbar00	= pegGetCmp(container_id , 'progressbar00');
	var bt08			= pegGetCmp(container_id , 'bt08');
	var bt09			= pegGetCmp(container_id , 'bt09');
	
	progressbar00.peg_updateTaskRunner = function () {
		if(!(progressbar00)){
			progressbar00.peg_task.stop();
		}

		if(progressbar00.wait()==false){
			progressbar00.peg_task.stop();
		}


        pegAjax(
    		'/' + main_path + '/backup01/exec_task.php' , 
    		{'container_id' : container_id} , 
    		function(jsondata){
    			if(jsondata.text==''){
    				progressbar00.updateProgress( '1', '', true );
    			}else{
    				progressbar00.updateProgress( '1', jsondata.text , true );
    			}
    		}
        );
	};

	progressbar00.peg_runner = new Ext.util.TaskRunner();
	progressbar00.peg_task = progressbar00.peg_runner.newTask({
	     run: progressbar00.peg_updateTaskRunner,
	     interval: 500
	 });
	
	bt08.setHandler(function(){
		var permission_backup = screen.peg_getData('permission_backup_sql');
		if(!(permission_backup)){
			if(pegGetFramework() == 'peg002'){
				pegGetDic('peg_dic_backup_noper', 
					function(desc){ 
						if(desc){
							pegAlert(desc, 'backup.backup.sql');
						}
					});
			}else{
				pegAlert(peg_dic_backup_noper, 'backup.backup.sql');
			}

		}else{
			var params = {};
			params.step = 0;
			params.container_id = container_id;	
			params.senario=pegGetVal('p030', container_id);
			pegAjaxDefer(
					'/'+main_path + '/backup01/make_sql_file0.php' , 
					params , 
					function(jsondata){
						if(jsondata.ok==1){
							pegConfirmBox( '' , jsondata.msg ,  function(but){ 
								if(but=='yes'){
									progressbar00.peg_task.start(); 	
									backup01_make_backup(container_id, 0, 'make_sql_file1.php', 0);
								}
							});
						}else{
							pegAlert(jsondata.msg);
						}
			});
					
		}
	});
	
	bt09.setHandler(function(){
		var permission_backup = screen.peg_getData('permission_backup_bat');
		if(!(permission_backup)){
			// pegAlert(peg_dic_backup_noper, 'backup.backup.bat');
			if(pegGetFramework() == 'peg002'){
				pegGetDic('peg_dic_backup_noper', 
					function(desc){ 
						if(desc){
							pegAlert(desc, 'backup.backup.bat');
						}
					});
			}else{
				pegAlert(peg_dic_backup_noper, 'backup.backup.bat');
			}
		}else{
			var params = {};
			params.step = 0;
			params.container_id = container_id;	
			params.senario=pegGetVal('p030', container_id );
			pegAjaxDefer(
					'/'+main_path + '/backup01/make_bat_file.php' , 
					params , 
					function(jsondata){
						if(jsondata.ok==1){
							pegConfirmBox( '' , jsondata.msg ,  function(but){ 
								if(but=='yes'){
									progressbar00.peg_task.start(); 	
									backup01_make_backup(container_id, 0, 'make_bat_file.php', 1);
								}
							});
						}else{
							pegAlert(jsondata.msg);
						}
			});
					
		}
	});
}
var backup_backup01_d01_search_criteria_ajax = '';
var backup_backup01_d01_refresh_ajax = '';
function backup_backup01_d01_afterDraw_listeners(container_id){
	var screen		= pegGetCmp(container_id );
	var grid0		= pegGetCmp(container_id , 'grid0');
	var grid1		= pegGetCmp(container_id , 'grid1');
	var type		= pegGetCmp(container_id , 'type');
	
	grid0.setpeg_isEditable(false);
	WebApp.view.grid.Grid.peg_setEditHidden(grid0, true);
	WebApp.view.grid.Grid.peg_setEditableHidden(grid0, true);
	 
	grid1.setpeg_isEditable(false);
	WebApp.view.grid.Grid.peg_setEditHidden(grid1, true);
	WebApp.view.grid.Grid.peg_setEditableHidden(grid1, true);
	 

	grid0.on('drop',function(node, data, dropRec, dropPosition){
		var peg_parms_array = {};
		var peg_selected_items = data.records;
		var peg_i=0;
	  
		Ext.Array.each(peg_selected_items, function(name, index, peg_selected_items_itself) {
			peg_i++;
			
			var peg_fld_name = 'peg_fld_' + peg_i + '_';
			var peg_data  = peg_selected_items_itself[index].data ;
			Ext.Object.each(peg_data, function(name, index, peg_data_itself) {			
	 
	            	peg_parms_array[peg_fld_name + name] = index;
	 
			});	
			
			if(peg_i>50){
				peg_parms_array['container_id'] = container_id;
				peg_parms_array['mmnr01'] = screen.getMmnr01();
				peg_parms_array['mnr01'] = screen.getMnr01();

				pegAjax('/' + main_path + '/backup01/backup01_drop_ins.php' , peg_parms_array , function(jsonData){} , 'json' );
				peg_i=0;		
				peg_parms_array = {};	
			}
		});
		
		peg_parms_array['container_id'] = container_id;
		peg_parms_array['mmnr01'] = screen.getMmnr01();
		peg_parms_array['mnr01'] = screen.getMnr01();
				
		pegAjax('/' + main_path + '/backup01/backup01_drop_ins.php' , peg_parms_array , function(jsonData){
			pegGridRefresh(container_id , 'grid0' ,  0 );
			pegGridRefresh(container_id , 'grid1' ,  0 );
		} , 'json' );
	});

	grid1.on('drop',function(node, data, dropRec, dropPosition){
		var peg_parms_array = {};
		var peg_selected_items = data.records;
		var peg_i=0;
	  
		Ext.Array.each(peg_selected_items, function(name, index, peg_selected_items_itself) {
			peg_i++;
			
			var peg_fld_name = 'peg_fld_' + peg_i + '_';
			var peg_data  = peg_selected_items_itself[index].data ;
			Ext.Object.each(peg_data, function(name, index, peg_data_itself) {			
	 
	            	peg_parms_array[peg_fld_name + name] = index;
	 
			});	
			
			if(peg_i>50){
				peg_parms_array['container_id'] = container_id;
				peg_parms_array['mmnr01'] = screen.getMmnr01();
				peg_parms_array['mnr01'] = screen.getMnr01();
					
				pegAjax('/' + main_path + '/backup01/backup01_drop_del.php' , peg_parms_array , function(jsonData){} , 'json' );
				peg_i=0;		
				peg_parms_array = {};	
			}
		});
		
		peg_parms_array['container_id'] = container_id;
		peg_parms_array['mmnr01'] = screen.getMmnr01();
		peg_parms_array['mnr01'] = screen.getMnr01();
		
		pegAjax('/' + main_path + '/backup01/backup01_drop_del.php' , peg_parms_array , function(jsonData){
			pegGridRefresh(container_id, 'grid0' ,  0 );
			pegGridRefresh(container_id, 'grid1' ,  0 );
		} , 'json' );
	}); 

	type.on('change', function (me, newValue, oldValue, eOpts) {
		if (newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue))) {
			return;
		}
		if(newValue == 1){//Κατηγορίες πινάκων
			pegSetFieldHidden('fldset001', container_id, false)
			pegSetFieldHidden('fldset000', container_id, true)
		}
		else{ //Συγκεκριμένοι πίνακες
			pegSetFieldHidden('fldset000', container_id, false)
			pegSetFieldHidden('fldset001', container_id, true)
		}
	});
}

var restore_ajax_execution = '';
var restore_task = null;
function backup_backup02_d_afterDraw_listeners(container_id){
	var screen	= pegGetCmp(container_id );
	var progressbar00	= pegGetCmp(container_id +'_progressbar00');
	var bt08			= pegGetCmp(container_id +'_bt08');
	var bt09			= pegGetCmp(container_id +'_bt09');
	
	progressbar00.restore_updateTaskRunner = function () {
		if(!(progressbar00)){	
			restore_task.stop();
		}

		if(progressbar00.wait()==false){
			restore_task.stop();
		}

		
        pegAjax(
        		'/' + main_path + '/backup01/exec_task.php' , 
        		{'container_id' : container_id} , 
        		function(jsondata){
 
        			if(jsondata.text==''){
        				progressbar00.updateProgress( '1', '', true );
        			}else{
        				progressbar00.updateProgress( '1', jsondata.text , true );
        			}
        		}
        );
	 };
	
	 var restore_runner = new Ext.util.TaskRunner();
	 restore_task = restore_runner.newTask({
	     run: progressbar00.restore_updateTaskRunner,
	     interval: 500 	 
	 });
	 
	
	bt08.setHandler(function(){
		peg_windowShow_d( 
				'', 
				'backup02_d01', 
				'backup', 
				container_id , 
				'', 
				'', 
				'',  
				'', 
				{
					peg_nr01: screen.getNr01()
				}
		);
	});
	
	bt09.setHandler(function(){
		var params = {};
			params.step = 0;
			params.container_id =  container_id ;	
			pegAjaxDefer(
				'/'+main_path + '/backup02/restore00.php' , 
				params , 
				function(jsondata){
					if(jsondata.ok==1){
						pegConfirmBox( '' , jsondata.msg ,  function(but){ 
							if(but=='yes'){
								restore_task.start(); 	
								backup02_make_restore(container_id, 0);
							}
						});
					}else{
						pegAlert(jsondata.msg);
					}
			});
	});
}
