<?php
	/** 
	* @param  char $file_path 	: the hole file path
	* @param  char $file_dir 	: only the path to the dir of containing the sql file
	* @param  char $filename 	: the name of sql file
	* @return 
	*/
	function backup_restore_sql_file($file_path, $file_dir='', $filename=''){
		if(!empty($file_path) and (empty($file_dir) or empty($filename)) ){
			$exp_path = explode('/', $file_path);
			$filename = end($exp_path);
			$file_dir = str_replace($filename, "", $file_path);
		}else if(!empty($file_dir) and !empty($filename) and empty($file_path) ){
			$file_path = $file_dir.$filename;
		}
        $table_name = str_replace(".sql","", $filename);
        if(pegasus_mysql_table_exists($table_name)){
            pegasus_mysql_backup_table($table_name);
        }
       
		pegasus_mysql_upload_sql($file_dir.$filename);
	}

	/** 
	* @param  char $table 	: name of table to backup
	* @param  char $directory 	: the directory to be saved
	* @return 
	*/
	function backup_make_sql_file($table, $directory){
        
        if(!pegasus_mysql_table_exists($table)){
            return;
        }

        //MySQL Field Types
        $field_types = pegasus_query("DESCRIBE ". $table);
        $field_types_arr = array();
        while($field_types_row = pegasus_fetch_assoc($field_types)){
            $field_types_arr[$field_types_row['Field']] = $field_types_row['Type'];
        }
        
        //Όλες οι εγγραφές του πίνακα
        $result = pegasus_query('SELECT * FROM '.$table);
       
       
        $num_fields = 0;
        $i = 0;
        $empty_values = array(); //The array that holds the default empty value
        if(pegasus_db_api_isPDO() || !function_exists( 'mysql_num_fields' )){
            $num_fields = $result->columnCount();
            while ($i < $num_fields) {
                $meta = $result->getColumnMeta($i);
                $fieldName = $meta['name'];
                $mysqlType = $field_types_arr[$fieldName];
                $empty_values[$i] = backup_return_default_balue_of_mysql_type($mysqlType);
                $i++;
            }
        }else{
            $num_fields = mysql_num_fields($result);
            while ($i < $num_fields) {
                $meta = mysql_fetch_field($result, $i);
                $fieldName = $meta->name;
                $mysqlType = $field_types_arr[$fieldName];
                $empty_values[$i] = backup_return_default_balue_of_mysql_type($mysqlType);
                //echo '<pre>Field: '. $fieldName .' is of type: ' . $mysqlType , ' and empty value is: '. $empty_values[$i]. "\n</pre>";
                $i++;
            }
        }

        $return = "/*!40101 SET NAMES utf8 */;"."\n\n";
		$return .= "/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;"."\n\n";
        $return .= "DROP TABLE IF EXISTS ".$table.";";
        //row2 is the sql command to create the table
        $row2 = pegasus_fetch_row(pegasus_query('SHOW CREATE TABLE '.$table));

        $return .= "\n\n".$row2[1].";\n\n";
        //removed the for i - I think it is useless FPsr: https://davidwalsh.name/backup-mysql-database-php#comment-23316
		//for ($i = 0; $i < $num_fields; $i++) { 
			while($row = pegasus_fetch_row($result)) {
				$return.= 'INSERT INTO '.$table.' VALUES(';
				for($j=0; $j<$num_fields; $j++) {


                   $row[$j] = addslashes($row[$j]);
// 					$row[$j] = preg_replace("\n","\\n",$row[$j]); 
					
					$row[$j] = str_replace(array("\n","\r"), array("\\n", "\\r"), $row[$j]);

				    if (!empty($row[$j])) {
						$return .= '"'.$row[$j].'"' ;
                    }
                    else{
						$return .= $empty_values[$j];
					}
					if ($j<($num_fields-1)) {
						$return .= ',';
					}
				}
				$return .= ");\n";
			}
		//}

        $return .= "\n\n" . "/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;";
		$return .= "\n\n\n";
		$handle = fopen($directory.$table.'.sql','w+');
		fwrite($handle,$return);
		fclose($handle);
      	}
    
    /**
     * This function returns the default value of an empty MySQL field
     * The types examined derive from pegasus_create_stracture
     */
    function backup_return_default_balue_of_mysql_type($mysqlType){
        if( strpos($mysqlType, "int") !== false ||
            strpos($mysqlType, "decimal") !== false ||  
            strpos($mysqlType, "tinyint") !== false ){
                   return '0';
            }
        else if(strpos($mysqlType, "date") !== false){
            return '0100-01-01';
        }  
        else{
            return '""';
        }  
    }


	function peg_backup_backup01_d_initialize($data,$mmnr01='',$mnr01='',$_d='',$container_id=''){
	    $select_grid = 'select p50.* from p50 join backup03 on p50.p01=backup03.p50 and backup03.nr01<-9999';
	    pegasusSetGlobalVar( 'backup01_d01_grid_'.$container_id , $select_grid);
	    
	    if($_d=='backup01_d'){
	        $data['permission_backup_sql'] = pegasus_check_permission('backup.backup.sql');
	        $data['permission_backup_bat'] = pegasus_check_permission('backup.backup.bat');
	        

	    }
	    return $data;
	}
	function peg_backup_backup01_d01_initialize($data,$mmnr01='',$mnr01='',$_d='',$container_id=''){
	    
	    if($_d=='backup01_d01'){
            
            if($data['is_std']==1 /*&& !pegasus_module_exists('dias')*/){
                $data['readonly']   = true;
                $data['message'] = '<div class="alert_message">' . $_SESSION['peg_dic_core_is_std_nochange'] . '</div>';
            }
            if(empty($data['message'])){
                $data['message_hidden'] = 1;
            }
	        if(empty($data['nr01'])){
	            $data['nr01'] = pegasus_mysql_newrec('backup01');   
            }

            if($data['type'] == 1){ //Επιλογή Κατηγοριών
                $data['fldset000_hidden'] = true; //Επιλογή πινάκων 
            }
            else if($data['type'] == 2){ //Επιλογή πινάκων 
                $data['fldset001_hidden'] = true; //Επιλογή Κατηγοριών
            }
            else{
                $data['fldset000_hidden'] = true; //Επιλογή πινάκων 
                $data['fldset001_hidden'] = true; //Επιλογή Κατηγοριών
            }

            pegasus_make_all_tmp_recs('backup01' , $data , $data['nr01'] , $_REQUEST['rec_copy_nr01'] , 'backup01_d01-'.$data['nr01'] );
            
            $where_tmp_backup03 = ' peg_flag!=9 and peg_tmp_backup03.backup01="' .$data['nr01'] .'" and peg_tmp_backup03.peg_sess_id="'.session_id().'" and peg_tmp_backup03.peg_mmnr01="backup01_d01-'.$data['nr01'].'" and peg_tmp_backup03.peg_mnr01="'.$data['nr01'].'"';
            $select_grid0 = 'select p50.p01 as p50, p50.p03 as v_p03, p50.module as v_module, cor006.p01 as v_cor006 from p50 join cor006 on p50.cor006=cor006.p00 join peg_tmp_backup03 on p50.p01=peg_tmp_backup03.p50 and'.$where_tmp_backup03;
            $select_grid1 = 'select p50.* from p50 where p50.p01!=\'\' and p50.p102=1 and p50.p01 not in (select p50 from peg_tmp_backup03 where '.$where_tmp_backup03.') and p50.p03!=\'\' order by p50.p01; ';
            
            // echo print_r($select_grid0, 1);
            // echo print_r($select_grid1, 1);

            pegasusSetGlobalVar( 'backup01_grid0_'.$container_id , $select_grid0);
            pegasusSetGlobalVar( 'backup01_grid1_'.$container_id , $select_grid1);
            pegasusSetGlobalVar( 'backup01_nr01_'.$container_id , $data['nr01']);
            pegasusSetGlobalVar( 'backup03_where_'.$container_id , $where_tmp_backup03);
	        
	    }
	    return $data;
    }
    


	/**
     * @deprecated
     * 
     * @see peg_mime_content_type()
     */
	function backup_get_mime($filename) {
        if(function_exists('peg_mime_content_type')){
            return peg_mime_content_type($filename);
        }
        $mime_types = array(
            'txt' => 'text/plain',
            'htm' => 'text/html',
            'html' => 'text/html',
            'php' => 'text/html',
            'css' => 'text/css',
            'js' => 'application/javascript',
            'json' => 'application/json',
            'xml' => 'application/xml',
            'swf' => 'application/x-shockwave-flash',
            'flv' => 'video/x-flv',

            // images
            'png' => 'image/png',
            'jpe' => 'image/jpeg',
            'jpeg' => 'image/jpeg',
            'jpg' => 'image/jpeg',
            'gif' => 'image/gif',
            'bmp' => 'image/bmp',
            'ico' => 'image/vnd.microsoft.icon',
            'tiff' => 'image/tiff',
            'tif' => 'image/tiff',
            'svg' => 'image/svg+xml',
            'svgz' => 'image/svg+xml',

            // archives
            'zip' => 'application/zip',
            'rar' => 'application/x-rar-compressed',
            'exe' => 'application/x-msdownload',
            'msi' => 'application/x-msdownload',
            'cab' => 'application/vnd.ms-cab-compressed',

            // audio/video
            'mp3' => 'audio/mpeg',
            'qt' => 'video/quicktime',
            'mov' => 'video/quicktime',

            // adobe
            'pdf' => 'application/pdf',
            'psd' => 'image/vnd.adobe.photoshop',
            'ai' => 'application/postscript',
            'eps' => 'application/postscript',
            'ps' => 'application/postscript',

            // ms office
            'doc' => 'application/msword',
            'docx' => 'application/msword',
            'rtf' => 'application/rtf',
            'xls' => 'application/vnd.ms-excel',
            'xlsx' => 'application/vnd.ms-excel',
            'ppt' => 'application/vnd.ms-powerpoint',

            // open office
            'odt' => 'application/vnd.oasis.opendocument.text',
            'ods' => 'application/vnd.oasis.opendocument.spreadsheet',
        );

        //$ext = strtolower(array_pop(explode('.',$filename)));
        $ttt = explode('.',$filename);
        if(gettype($ttt) == "array"){
        	$ext = strtolower(array_pop($ttt));
        	if (array_key_exists($ext, $mime_types)) {
        		return $mime_types[$ext];
        	}
        }
        if (function_exists('finfo_open')) {
            $finfo = finfo_open(FILEINFO_MIME);
            $mimetype = finfo_file($finfo, $filename);
            finfo_close($finfo);
            return $mimetype;
        }
        else {
            return 'application/octet-stream';
        }
	}

    function backup_format_where_str_of_scenario($backup01_nr01){
        pegasus_mysql_use('select * from backup01 where nr01 =?', $backup01, array($backup01_nr01));

        $in_str = " p50.p01 <> '' and p50.is_view <> 1 ";
        if($backup01['type'] == 1){ //Κατηγορία πινάκων

            $explode_arr  = explode('#', $backup01['exclude_cor006']);
            $exclude_cor006_in = '';
            foreach ($explode_arr as $value) {
                if(!empty($value)){
                    if(!empty($exclude_cor006_in)){
                        $exclude_cor006_in .= ", ";
                    }
                    $exclude_cor006_in .= $value;                   
                }         
            }
            if(!empty($exclude_cor006_in)){
                $in_str .= " and p50.cor006 not in (".$exclude_cor006_in.")";
            }
        }
        else{ //Ξεχωριστοί πίνακες
            $query = 'select * from backup03 where backup01 = :backup03backup01';
            $result = pegasus_query(
                $query,
                array(
                    'backup03backup01' => $backup01_nr01
                )
            );
            $in_tbls = '';
            while($row = pegasus_fetch($result,PEG_FETCH_ASSOC)) {
                if(!empty($in_tbls)){
                    $in_tbls .= ", ";
                }
                $in_tbls .= "'".$row['p50']."'";
            }
            if(!empty($in_tbls)){
                $in_str .= " and p50.p01 in (".$in_tbls.")";
            }
        }
        return " where ".$in_str;
    }

    function backup_after_update(){

        pegasus_mysql_use('select rel, ver from p55 where p00="backup"', $version);
        if($version['ver'] == 1 && $version['rel'] <= 30) { 
            pegasus_mysql_update('backup01', array('type'), array(2), 'type=""');
        }

        if(file_exists('../../pegasus_cloud_app/backup01/deselect_all.php')){
            unlink('../../pegasus_cloud_app/backup01/deselect_all.php');
        }
        if(file_exists('../../pegasus_cloud_app/backup01/select_all.php')){
            unlink('../../pegasus_cloud_app/backup01/select_all.php');
        }
        if(file_exists('../../pegasus_cloud_app/backup01/refresh_grid.php')){
            unlink('../../pegasus_cloud_app/backup01/refresh_grid.php');
        }

        //Το διαγράφω γιατί πλεόν τα έχω σε φάκελο bin με versions
        if(file_exists('../../pegasus_cloud_app/backup_mysqldump/mysqldump.exe')){
            unlink('../../pegasus_cloud_app/backup_mysqldump/mysqldump.exe');
        }
        
        //fix table categories
        $pinakes_dedomenwn = "('a63', 'd31', 'd80', 'contract01', 'courier00_01', 'massimport00', 'massimport01', ".
                             "'massimport03', 'offers00', 'mail00', 'masssms00', 'chaa22', 'chaa25', 'chaa50', ".
                             "'chaa95', 'chaa96', 'pegapi01_q10', 'este60', 'hostsrv91', 'hostsrv92', 'hostsrv93', ".
                             "'a64', 'a65', 'l92', 'l93', 'z70', 'z69', 'z71', 'contacts01', 'contacts00', 'hser00',".
                             " 'her_syllo00', 'offersfe00', 'rating00', 'rating01', 'rating02', 'rating03', ".
                             "'ratingtot', 'champion00_01', 'champion00_10', 'champion00_11', 'query00_00', ".
                             "'query00_q10', 'query00_q13', 'query00_q131', 'courier03_00', 'courier03_01', ".
                             "'courier03_05', 'estiasi00_01', 'estiasi00_05', 'estiasi00_15', 'estiasi00_16', ".
                             "'estiasi00_11', 'estiasi00_12', 'tags_00', 'tags_01', 'champion02_00', 'champion03_00', ".
                             "'champion03_01', 'web_notif10', 'd99100', 'tour00_03', 'gteshop01', 'hmobp0', ".
                             "'products02_01', 'mob_courier00', 'mob_courier02', 'p98', 'charts_q10', ".
                             "'clsa01', 't05', 'i70', 'hota42', 'chaa23', 'este31', 'este20', 'este54', 'p30', 'cor011', ".
                             "'dashboard00_13', 'dashboard00_14', 'mydt10', 'mydt12', 'mydt65', 'phna01', 'phna98', 'champion06_00' )";
        $pinakes_efarmogis = "('pegapi04', 'dias05', 'dias06', 'dias_tester', 'veh021', 'i46001', 'q96', 'hota34')";
        $pinakes_dikaiwmatwn ="('p97', 'p97p95', 'p97p96')";

        pegasus_mysql_update('p50', array('cor006'), array(2), 'p01 in '.$pinakes_dedomenwn);
        pegasus_mysql_update('p50', array('cor006'), array(1), 'p01 in '.$pinakes_efarmogis);
        pegasus_mysql_update('p50', array('cor006'), array(4), 'p01 in '.$pinakes_dikaiwmatwn);


        $backup01_arr=array(); 
		$backup01_arr['nr01']="10000000001"; 
		$backup01_arr['p01']="Πλήρες Backup"; 
        $backup01_arr['is_std']="1"; 
        $backup01_arr['type']="1"; 
        $backup01_arr['exclude_cor006']="#1#5#3#";
		if(pegasus_mysql_printfld('backup01' , 'nr01' , 'nr01=:nr01' , array('nr01' => $backup01_arr['nr01']))>0){
			pegasus_mysql_update('backup01' ,array_keys($backup01_arr),array_values($backup01_arr), 'nr01=:nr01',0,1,1, array('nr01' => $backup01_arr['nr01']));
		}else{
			pegasus_mysql_insert('backup01' ,array_keys($backup01_arr),array_values($backup01_arr));
        }
        $backup01_arr=array(); 
		$backup01_arr['nr01']="10000000002"; 
		$backup01_arr['p01']="Backup Φωτογραφιών"; 
        $backup01_arr['is_std']="1"; 
        $backup01_arr['type']="1"; 
        $backup01_arr['exclude_cor006']="#1#2#4#5#6#";
		if(pegasus_mysql_printfld('backup01' , 'nr01' , 'nr01=:nr01' , array('nr01' => $backup01_arr['nr01']))>0){
			pegasus_mysql_update('backup01' ,array_keys($backup01_arr),array_values($backup01_arr), 'nr01=:nr01',0,1,1, array('nr01' => $backup01_arr['nr01']));
		}else{
			pegasus_mysql_insert('backup01' ,array_keys($backup01_arr),array_values($backup01_arr));
		}
    }