/**
 * @class Functions.charts.global
 * 
 * @member WebApp.view 
 *  
 *  ##Properties
 *  
 *  The global variables of the module
 *   
 *  ##Methods
 *  
		- General functions
		- Start After draw listeners
 *  
 *  The functions of the module
 *  
 */
//XXX General functions

function charts_q10_d_updateType(container_id, value){
	var pieHidden = true;
	var cartesianHidden = true;
	if(value == 'pie'){
		pieHidden = false;
		cartesianHidden = true;
	}else if (value.substr(0, 9) == 'cartesian') {
		pieHidden = true;
		cartesianHidden = false ;
	}else{
		pegAlert('Undefined type');
	}
	
	pegSetFieldHidden('xaxis', container_id, cartesianHidden);
	pegSetFieldHidden('yaxis', container_id, cartesianHidden);
	pegSetFieldHidden('groupfield', container_id, cartesianHidden);
	pegSetFieldHidden('yminimum', container_id, cartesianHidden);
	pegSetFieldHidden('ymaximum', container_id, cartesianHidden);

	pegSetFieldHidden('angularaxis', container_id, pieHidden);
	pegSetFieldHidden('label', container_id, pieHidden);
}

//XXX After Draw Listeners
function core_charts_q10_d_afterDraw_listeners(container_id){
	var screen = pegGetCmp(container_id);
	var type = pegGetCmp(container_id, 'type');
	
	charts_q10_d_updateType(container_id, type.getSubmitValue());
	

	type.on('change', function(me, newValue, oldValue, eOpts ){
		charts_q10_d_updateType( me.getContainer_ID() , newValue );
	});
}


/**
 * 
 * @param array charts_array [ { 'container_id': chart_container_id, 'name': charts_name }, ....]
 */
var charts_q10_d90_refresh_charts_ajax= '';
 function charts_q10_d90_refresh_charts(params){
	
	if (charts_q10_d90_refresh_charts_ajax) {
		if (charts_q10_d90_refresh_charts_ajax.id) {
			Ext.ux.AjaxDefer.abort(charts_q10_d90_refresh_charts_ajax);
		}
	}
	
	charts_q10_d90_refresh_charts_ajax = pegAjax(
		'/' + main_path + '/charts_01/q10_d90_refresh_charts.php',
		params,
		function (jsonData) {
			jsonData.forEach(chart_element => {
				chart_temp_container_id = chart_element.container_id;
				if (pegGetCmp(chart_temp_container_id, 'pie')) {
					pegGetCmp(chart_temp_container_id, 'pie').store.load();
				}
				else if (pegGetCmp(chart_temp_container_id, 'cartesianchart')) {
					temp_cartesianchart = pegGetCmp(chart_temp_container_id, 'cartesianchart');
					if (temp_cartesianchart.getChart() && temp_cartesianchart.getChart().store) {
						temp_cartesianchart.getChart().store.load();
						temp_cartesianchart.getChart().setSeries(chart_element.series);
						temp_cartesianchart.getChart().setAxes(chart_element.axes);
					}
				}
			});
		},
		'json',
		true
	);
}