/**
 * @class Functions.core.global
 * 
 * @member WebApp.view 
 *  
 *  ##Properties
 *  
 *  The global variables of the module
 *   
 *  ##Methods
 *  
		- General functions
		- Start After draw listeners
 *  
 *  The functions of the module
 *  
 */


		function core__main_d_afterDraw_listeners(container_id){
			pegGetCmp('_main_d').on('resize', function(){
				core__main_d_onResize_actions();
			});
		
			core__main_d_onResize_actions(); 
			if(typeof sme_core__main_d_afterDraw_listeners  === 'function'){
				sme_core__main_d_afterDraw_listeners (container_id);    
			}

			if(typeof crm002_main_d_toolbaritem_initialize === 'function') {
				crm002_main_d_toolbaritem_initialize(container_id);
			}
			
			if(typeof notif_initializeNotificationButton == 'function'){
				notif_initializeNotificationButton();
			}
			
			pegGetCmp('_main_d_toolbarbutton_140000000000204').on('beforeshow',function(me){if(peg002_IsMobileScreen()){return false}}); //toolbox:hidden σε mobile
		}
		 
		function core__main_d_onResize_actions() {
			/*Επιλογες,Dashboard,Λιστα Αναφορών*/
			var buttons = ["140000000000203", "140000108000015", "140000000000205"];
			buttons.forEach((button) => {
				var myId = "_main_d_toolbarbutton_" + button;
				var meCmp = pegGetCmp(myId);
				if(meCmp){
					if (peg002_IsMobileScreen()) {
						  meCmp.setText([]);
						  meCmp.setMargin("0 10");
					} else {
						  meCmp.setText(meCmp.text00);
						  meCmp.setMargin("0");
					}	 
				  }
			});
		}
		
		var core_q31_d_ajax=null;
		function core_q31_d_afterDraw_listeners(container_id){
		 
			var p01	= pegGetCmp(container_id , 'p01');
			p01.on('change', function(me, newValue, oldValue, eOpts ){
				if(newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue) )){
					return ;
				} 
				
				if (core_q31_d_ajax  ) {
					if (core_q31_d_ajax.id > 0) {
						Ext.ux.AjaxDefer.abort(core_q31_d_ajax);
					}
				}
				core_q31_d_ajax = pegAjaxDefer(
						'/' + main_path + '/core07/core_q31_d_p01_change.php', 
						{
							q31_p01	: newValue,
							q31_container_id : container_id
						}, 
						function(jsonData) {
							if(jsonData['ok'] === 1) { 
								pegSetVal( 'p03'  , container_id  ,jsonData['p03']); 
								pegSetVal( 'vp03' , container_id , jsonData['vp03']); 
							} else {
								pegAlert(jsonData['msg']);
							} 
		
							core_q31_d_ajax = null;
						}
				);
			});
		
			var bt_p05	= pegGetCmp(container_id , 'bt_p05');
			bt_p05.setHandler(function(){
				pegWindowShow_d( 
					'' , 
					'q31_select_rel_d' , 
					'core' , 
					'' ,
					0 ,
					'&peg_q30_p01=' +  	pegGetVal( 'p01' , container_id),  
					container_id
				);
			});
		  
		}
		 
		
		
		var core_q31_select_rel_d_ajax='';
		function core_q31_select_rel_d_afterDraw_listeners(container_id){
			var screen	= peg_peg002_getCmp(container_id );
			var grid	= peg_peg002_getCmp(container_id + '_grid');
			var container_id_q31_d	= pegGetContainer_id_d(container_id , 'q31_d'   , '' , 'q31_d' );
		
		 
			grid.record_change = function(me,row){
				 //row.nr01
		
				 if (core_q31_select_rel_d_ajax  ) {
					if (core_q31_select_rel_d_ajax.id > 0) {
						Ext.ux.AjaxDefer.abort(core_q31_select_rel_d_ajax);
					}
				}
				core_q31_select_rel_d_ajax = pegAjaxDefer(
						'/' + main_path + '/core07/core_q31_select_rel_d_select.php', 
						{
							q31_p03_nr01	: row.nr01,
							q31_container_id : container_id,
							q31_p01 :pegGetVal('p01', container_id_q31_d)
						}, 
						function(jsonData) {
							if(jsonData['ok'] === 1) { 
								pegSetVal( 'p05'  , container_id_q31_d  ,jsonData['p05']); 
								pegSetVal( 'vp05' , container_id_q31_d , jsonData['vp05']); 
		
								pegWindowClose(screen.peg_winid);
							}  
		
							core_q31_select_rel_d_ajax = null;
						}
				);
		
					 
			};
		}
		
		
		
		
		
		
		
		/**
		 * The requestin XSR on function {@link core_smtp_check}
		 * @type {string}
		 */
		var core_smtp_check_ajax=null;
		
		if(pegGetFramework && typeof pegGetFramework == 'function' ){
			if(pegGetFramework() == 'peg002'){
				//TODO MAKE THIS variables to the screen
				/**
				 * The requestin XSR on function {@link core_p92_d00_afterDraw_listeners}
				 * @type {string}
				 */
				var p92_ajax_execution = '';
				/**
				 * The runer task of an automation {@link core_p92_d00_afterDraw_listeners}
				 * @type {Ext.util.TaskRunner.Task}
				 */
				var p92_task={};	
			}
		} 
		
		
		
		/** 
		 * This function make a request to check if the SMTP data is correct
		 * @param String container_id //The container ID of the screen
		 * @param {enum} type 
		 * 
				-- cor000
				 -- us0
				 
		 * @returns Alert If it is OK or not OK
		 */
		function core_smtp_check(container_id, type){
			var nr01 = 1;
			var smtpEncrypt = '';
			var smtpPort	= '';
			var smtpServer = '';
			var smtpUser = '';
			var smtpPassword = '';
			
			if(type == 'cor000'){
				smtpEncrypt = pegGetVal('smtp_encrypt', container_id);
				smtpPort	= pegGetVal('smtp_port', container_id);
				smtpServer = pegGetVal('smtp_server', container_id);
				smtpUser = pegGetVal('smtp_user', container_id);
				smtpPassword = pegGetVal('smtp_pass', container_id);
			}else if (type == 'us0') {
				var container_id_us0_d = pegGetContainer_id_d(container_id ,'us0_d', false,'us0_d');
				nr01		= pegGetVal('nr01', container_id_us0_d);
				smtpEncrypt = pegGetVal('smtp_encrypt', container_id);
				smtpEncrypt = pegGetVal('smtp_encrypt', container_id);
				smtpPort	= pegGetVal('smtp_port', container_id);
				smtpServer = pegGetVal('smtp_server', container_id);
				smtpUser = pegGetVal('smtp_user', container_id);
				smtpPassword = pegGetVal('smtp_pass', container_id);
			}else if(type == 'massmail93'){ 
				nr01        = pegGetVal('nr01', container_id);
				smtpEncrypt = pegGetVal('smtp_encrypt', container_id);
				smtpPort    = pegGetVal('smtp_port', container_id);
				smtpServer  = pegGetVal('smtp_server', container_id);
				smtpUser    = pegGetVal('smtp_user', container_id);
				smtpPassword= pegGetVal('smtp_pass', container_id);
			}else{
				pegAlert('Undefined Type');
				return ;
			}
			
			if (core_smtp_check_ajax  ) {
				if (core_smtp_check_ajax.id > 0) {
					Ext.ux.AjaxDefer.abort(core_smtp_check_ajax);
				}
			}
		
			core_smtp_check_ajax = pegAjaxDefer(
					'/' + main_path + '/core06/smtp_check.php', 
					{
						nr01	: nr01,
						type	: type,
						encypt	: smtpEncrypt,
						port	: smtpPort,
						server	: smtpServer,
						user	: smtpUser,
						password: smtpPassword
					}, 
					function( jsonData) {
						if (jsonData['ok'] == 1) { 
							pegMsgBox( jsonData['msg'] );
						} else {
							pegAlert(jsonData['msg']);
							
						} 
						core_smtp_check_ajax = null;
			});
		}
		
		/**
		 * The requestin XSR on function {@link core_show_my_ip}
		 * @type {string}
		 */
		var core_show_my_ip_ajax=null;
		/**
		 * Alert the current IP of the user
		 * @returns
		 */
		function core_show_my_ip(){
			var params = {};
		
			if(core_show_my_ip_ajax ){
				if(core_show_my_ip_ajax.id>0){
					Ext.ux.AjaxDefer.abort(core_show_my_ip_ajax);
				}
			}
		
			core_show_my_ip_ajax = pegAjaxDefer('/' + main_path + '/core06/show_my_ip.php' , params , function(jsondata){
				if(jsondata.ok){
					pegAlert(jsondata.msg);			
				}
				core_show_my_ip_ajax = null;
			  });
		
		}
		 
		
		function core_update_exec( params , container_id ) {
			if(!container_id){
				return ;
			}
			if(!pegGetCmp(container_id)){
				return;
			}
			
			
			// Ext.getCmp(container_id + '_progress_bar').wait();
			pegAjax('/'+main_path+'/core_update/update.php' , params , function(jsonData){
			
				var progress_bar=Ext.getCmp(container_id + '_progress_bar');
				if(jsonData.exec_next==1){
					core_update_exec( jsonData.params , container_id ) ;
					if(!progress_bar || progress_bar.isDestroyed ){ 
						if(progress_bar && progress_bar.peg_task && typeof progress_bar.peg_task.stop == "function"){
							progress_bar.peg_task.stop();							
						}
						return;
					}
					if(jsonData.params && jsonData.params.progress){
						progress_bar.peg_progress=jsonData.params.progress;
					} 
					var step_descr='';
					if(jsonData.params ){ 
						if(jsonData.params.step=='download_files'){
							progress_bar.peg_step=1; 
							if( progress_bar.peg_progress==1){
									progress_bar.peg_progress=0.99;
								}
						}else if(jsonData.params.step=='install_files'){
							progress_bar.peg_step=2; 
							if( progress_bar.peg_progress==1){
									progress_bar.peg_progress=0.99;
								}
						}else{
							progress_bar.peg_step=0;
							progress_bar.peg_progress=0; 
							jsonData.message ='';
						}
					
						step_descr=jsonData.params.step_descr;

					} 
					if( step_descr && progress_bar.peg_step_descr!=step_descr){
						progress_bar.peg_progress=0;
						progress_bar.peg_step_descr=step_descr;
					} 	
					core_update_progressbar_text(progress_bar, jsonData.message);
				}
				
				if(jsonData.end==1){
					
					pegMsgBox( jsonData.message );
					pegWindowClose(Ext.getCmp(container_id).up().id);
					progress_bar.setStyle('line-height','40px');
					progress_bar.updateProgress(1, jsonData.message,true);
					progress_bar.reset();
					if(progress_bar.peg_task && typeof progress_bar.peg_task.stop == "function"){
						progress_bar.peg_task.stop();							
					}
				}
			}, 'json');
			
		 
		}		
		function core_update_progressbar_text(progressbar,message){
			if(progressbar.isDestroyed ){ 
				if(progressbar.peg_task && typeof progressbar.peg_task.stop == "function"){
					progressbar.peg_task.stop();							
				}
				return;
			}
			progressbar.setStyle('line-height','19px');
			
			var peg_step=progressbar.peg_step;
			var peg_step_descr=progressbar.peg_step_descr;
		
			var peg_progress=progressbar.peg_progress;
			 
			var percentage=Math.round(peg_progress*100);
			var step_dic='Step';
			if (peg002_getCookieLang()=='GR'){
				step_dic='Βήμα';
			}
			var step_str=`${step_dic} ${peg_step}/2&nbsp;&nbsp;-&nbsp;&nbsp;`;
			if( progressbar.peg_step==0){
				step_str='';
			}
			if(percentage>=0 && progressbar.peg_step!=0){
				var percentage_str=`&nbsp;( ${percentage}% )`;
			}else{
				var percentage_str='';
			}
			if(!message || message==progressbar.message ||  progressbar.message==peg_step_descr){
				message='...';
			}
			progressbar.message=message;
			progressbar.updateProgress(peg_progress, ` ${message}<br>${step_str}${peg_step_descr}${percentage_str}`);
		}
		/**
		 * This function set the codeMirror mode php or javascript {@link WebApp.view.codemirror.CodeMirror.setCodeMode}
		 * @param {WebApp.view.codemirror.CodeMirror} codeMirror
		 * @param {boolean} code
		 * @returns
		 */
		function core_p52_d_setMode(codeMirror,code){
			if(!codeMirror){
				console.error("core_p52_d_setMode:: Codemirror is undefined");
			}
			if(code){
				codeMirror.setCodeMode('php');
			}else{
				codeMirror.setCodeMode('javascript');
			}
		}
		
		
		/**
		 * The default key maps of browse_d00* screens
		 * @param screen
		 * @returns
		 */
		function core_browse_d00keymap(screen){ 
			WebApp.view.Screen.peg_appendKeyMap(
					screen,
					Ext.event.Event.ENTER ,
					function(  keyCode, me){   
						if(me && !me.getContainer_ID){
							return ;
						}
						if(me.peg_mainForm!=me.getContainer_ID()){
							return ;
						}
						return pegGetCmp(screen.getContainer_ID()+'_but_sear').handler();
					},
					{ ctrl:true }
			  ); 
			WebApp.view.Screen.peg_appendKeyMap(
					screen,
					Ext.event.Event.ENTER ,
					function(keyCode,  me){  
						if(me && !me.getContainer_ID){
							return ;
						}
						if(me.peg_mainForm!=me.getContainer_ID()){
							return ;
						}
						
						return pegGetCmp(screen.getContainer_ID()+'_but_searnclos').handler();
					} 
			  ); 
			//From default keymap it's ok
		//	WebApp.view.Screen.peg_appendKeyMap(
		//			screen,
		//			 Ext.event.Event.ESC ,
		//			  function( keyCode,  me){   
		//				  return pegGetCmp(screen.getContainer_ID()+'_but_clos').handler();
		//			  } 
		//	  );
		}
		/**
		 * The action of search button of browse_d00* screens
		 * @param container_id
		 * @param fld
		 * @param type
		 * @returns
		 */
		function core_searchbox_but_sear_handler(container_id, fld, type,field_name){

			var screen = pegGetCmp(container_id);
			var searchVal =  pegGetVal('search_val' , screen.getContainer_ID()) ;
			var tpVal =  pegGetVal('tp' , screen.getContainer_ID()) ;
			var searchVal1 =  pegGetVal('search_val1' , screen.getContainer_ID()) ;
			var search_valCmp=pegGetCmp(container_id,'search_val');
			var displayValue='';
			if(search_valCmp.xtype=="pegasusComboBox"){
				displayValue=search_valCmp.getDisplayValue();
				if(tpVal==1){
					displayValue=pegGetVal('search_val_dist_disp',container_id);
				}
			}else if(search_valCmp.xtype=="pegasusComboBoxV2"){
				displayValue=search_valCmp.getPeg_values()[0].display;
				if(tpVal==1){
					displayValue=pegGetVal('search_val_dist_disp',container_id);
				}
			}
			var not =  pegGetVal('not' , screen.getContainer_ID()) ;
			var grid_name = screen.peg_screen_parent_element_name;
			if(pegIsEmpty(grid_name)){
				grid_name = 'grid'
			}
			var tpCmp=pegGetCmp(container_id,'tp');
			if(tpCmp && tpCmp.xtype=='pegasusCheckBox'){
				if(tpVal==1){
					tpVal='in';
				}
			}
			if(tpVal=='in'){ 
				searchVal=pegGetVal('search_val_dist' , screen.getContainer_ID()) ;
			}
			var order=pegGetVal('order',container_id);			
			var order_tax=pegGetVal('order_tax',container_id);
			var ref_grid =  pegGetCmp(screen.peg_screen_parent_container_id +'_'+ grid_name);
			//WebApp.view.grid.Grid.peg_suspendGridFocus( ref_grid );
			return peg002_GridAddWhereFld(
					screen.peg_screen_parent_container_id,  
					grid_name, 
					fld ,  
					searchVal   ,  
					type,  
					tpVal, 
					1, 
					searchVal1,
					field_name,
					displayValue,
					order,
					order_tax,
					not
			);
		} 
		/**
		 * The action of close button of browse_d00* screens
		 * @param container_id
		 * @returns
		 */
		function core_searchbox_but_clos_handler(container_id ){
			 var screen = pegGetCmp(container_id); 
			 WebApp.view.Screen.peg_close(screen);
		}
		/**
		 * The action of search and close button of browse_d00* screens
		 * @param container_id
		 * @returns
		 */
		function core_searchbox_but_searnclos_handler(container_id , fld, type , field_name ){

			var screen = pegGetCmp(container_id);  
			var searchVal =  pegGetVal('search_val' , screen.getContainer_ID()) ;
			var tpVal =  pegGetVal('tp' , screen.getContainer_ID()) ; 
			var searchVal1 =  pegGetVal('search_val1' , screen.getContainer_ID()) ;
			var search_valCmp=pegGetCmp(container_id,'search_val');
			var displayValue='';
			var not =  pegGetVal('not' , screen.getContainer_ID()) ;
			if(search_valCmp.xtype=="pegasusComboBox"){
				displayValue=search_valCmp.getDisplayValue();
				if(tpVal==1){
					displayValue=pegGetVal('search_val_dist_disp',container_id);
				}
			}else if(search_valCmp.xtype=="pegasusComboBoxV2"){
				displayValue=search_valCmp.getPeg_values()[0].display;
				if(tpVal==1){
					displayValue=pegGetVal('search_val_dist_disp',container_id);
				}
			}
			var grid_name = screen.peg_screen_parent_element_name;
			if(pegIsEmpty(grid_name)){
				grid_name = 'grid'
			}
			var tpCmp=pegGetCmp(container_id,'tp');
			if(tpCmp &&  tpCmp.xtype=='pegasusCheckBox'){
				if(tpVal==1){
					tpVal='in';
				}
			}
			if(tpVal=='in'){ 
				searchVal=pegGetVal('search_val_dist' , screen.getContainer_ID()) ;
			}
			var order=pegGetVal('order',container_id);			
			var order_tax=pegGetVal('order_tax',container_id);
			
			var ref_grid =  pegGetCmp(screen.peg_screen_parent_container_id +'_'+ grid_name);
			peg002_GridAddWhereFld(
					screen.peg_screen_parent_container_id,  
					grid_name, 
					fld ,  
					searchVal   ,  
					type ,  
					tpVal, 
					1, 
					searchVal1,
					field_name,
					displayValue,
					order,
					order_tax,
					not
			);
			WebApp.view.Screen.peg_close(screen);
		}
		
		var core_p81_d_change_ajax='';
		function core_p81_d_change(container_id,name){
			
			
			var params ={};
			
			params['chfield']	= name;
			params['_d']		= pegGetVal('_d', container_id);
			params['module']	= pegGetVal('module', container_id);
			
			
			if (core_p81_d_change_ajax) {
				if (core_p81_d_change_ajax.id > 0) {
					Ext.ux.AjaxDefer.abort(core_p81_d_change_ajax);
				}
			}
		
			core_p81_d_change_ajax = pegAjaxDefer('/' + main_path
					+ '/core05/get_p81_d_relations.php', params, function(
					jsonData) {
				if (jsonData['ok'] == 1) { 
					if(name == '_d'){
						pegSetVal('module' , container_id , jsonData['module']);
					}else{
						pegSetVal('_d' , container_id , jsonData['_d']);
					}
				}
				core_p81_d_change_ajax = '';
		
			});
		}
		
		
		
		function p92_exec( parameters , container_id ) {
			if(!container_id){
				return ;
			}
			if(!pegGetCmp(container_id)){
				return;
			}
			return pegAjax('/' + main_path + '/core_exec/exec.php' , parameters , function(jsonData){
						var progress_bar = pegGetCmp(container_id + '_progress_bar');
						progress_bar.reset();
									
						if(jsonData.msg!='' && jsonData.exec_next!=1){
							pegAlert(jsonData.msg);				
						}
						else{
							parameters.go_next = 1;
							p92_exec( parameters , container_id );
						}	
						//console.log(jsonData);
						
						if(jsonData.logout==1){
							window.onbeforeunload=null; 
							window.location.reload();		
						}
						if(jsonData.exec_next!=1){
							progress_bar.updateProgress( '1', '100%', true );
							p92_task.stop();
						}
			} , 'json');	
				
		}		
		/**
		 * The requestin XSR on function {@link core_p92_d00_p92_change}
		 * @type {string}
		 */
		var core_p92_d00_p92_change_ajax ='';
		/**
		 * Οθόνη εκτέλεση αυτοματισμών on change  'Επιλέξτε τoν Αυτοματισμό που θέλετε να εκτελέσετε:'
		 * @param {String} container_id
		 * @returns
		 */
		function core_p92_d00_p92_change(container_id ){
			var progress_bar	= pegGetCmp(container_id +'_progress_bar');
			var postObj = {};
		
			postObj['p92_nr01'] =  pegGetVal('p92', container_id);
			postObj['cor007']	=  pegGetVal('cor007', container_id);
			
			if (core_p92_d00_p92_change_ajax ) {
				if (core_p92_d00_p92_change_ajax.id > 0) {
					Ext.ux.AjaxDefer.abort(core_p92_d00_p92_change_ajax);
				}
			} 
			
			core_p92_d00_p92_change_ajax = pegAjax('/' + main_path + '/core_exec/get_help.php' ,postObj, 
					function(jsonData){
		//			console.log('Data' + jsonData.cor007 + ' _d=' + postObj['cor007'] + ' container_id="'+container_id+'" '  );
		//				pegSetVal('help' , container_id , jsonData.p30);
						
						pegGetCmp(container_id+'_help' ).update( jsonData.p30);
						if( jsonData.cor007 == postObj['cor007']){
							pegGridRefresh(container_id , 'grid' ,0 );	
						}else{
							pegSetVal('cor007' , container_id , jsonData.cor007);
						}
						core_p92_d00_p92_change_ajax = '';
					} , 
				'json');
		}
		/**
		 * The requestin XSR on function {@link core_p92_d00_save_p93_values}
		 * @type {string}
		 */
		var core_p92_d00_save_p93_values_ajax='';
		/**
		 * Αποθήκευση - Ενημέρωση  παραμέτρων εκτέλεσης αυτοματισμών
		 * @param {String} container_id 
		 */
		function core_p92_d00_save_p93_values(container_id){
			var postObj = {
				action: 'cor007'
			};
			var cor007 =  pegGetVal('cor007', container_id);
			
		
			postObj.p92 = pegGetVal('p92', container_id);
			
			
			Ext.getCmp(container_id+'_grid').getStore().each(function(record){
				postObj['peg_grid_' + record.data.name] = record.data.value;
			});
			
			if (core_p92_d00_save_p93_values_ajax != '') {
				if (core_p92_d00_save_p93_values_ajax.id > 0) {
					Ext.ux.AjaxDefer.abort(core_p92_d00_save_p93_values_ajax);
				}
			}
		
			core_p92_d00_save_p93_values_ajax = pegAjaxDefer('/' + main_path
					+ '/core03/isValidToSave.php', postObj, function(
					jsonData) {
				if (jsonData['ok'] == 1) {
					if(pegIsEmpty(cor007) || cor007 ==0){
						pegWindowShow_d( 
							'cor007' , 
							'cor007_d' , 
							'core' , 
							'' ,
							0 ,//postObj.nr01
							'&p92='+postObj.p92,  
							container_id
						);
						core_p92_d00_save_p93_values_ajax = '';
					}else{
		//				cor007
						postObj['cor007'] = cor007;
						core_p92_d00_save_p93_values_ajax = pegAjaxDefer('/' + main_path
								+ '/core03/updateCor007Values.php', postObj, 
								function(jsonData00){
									if (jsonData00['ok'] == 1) {
										pegMsgBox(jsonData00['msg']);
									}else{
										pegAlert(jsonData00['msg']);
									}
									core_p92_d00_save_p93_values_ajax = '';
								}
						);
					}
				} else {
					pegAlert(jsonData['msg']);
					core_p92_d00_save_p93_values_ajax = '';
				}
				
				
		
			});
			
		}
		/**
		 * OnChange 
		 */
		function core_p95_onChangeModuleP50(container_id){
			var p95_dContainer_id,
				p95_d01Container_id,
				p95_d02Container_id,
				p95_d03Container_id,
				p95_d04Container_id,
				p95_d06Container_id;
			var type;
			var screen = pegGetCmp(container_id); 
			switch (screen.peg__d) {
				case 'p95_d':
					type = 'prodile';
					p95_dContainer_id = screen.getContainer_ID();
				break;
				case 'p95_d01':
					type = 'module';
					p95_dContainer_id = screen.peg_mainForm; 
					//Module
				break;
				case 'p95_d02':
					type = 'table';
					p95_dContainer_id = screen.peg_mainForm;
				break;
				// case 'p95_d03':
				// 	type = 'menu';
				// 	// p95_dContainer_id = screen.peg_mainForm;
				// break;
				// case 'p95_d04':
				// 	type = 'toolbar';
				// 	// p95_dContainer_id = screen.peg_mainForm;	
				// break;
				// case 'p95_d06':
				// 	type = 'preports';
				// 	// p95_dContainer_id = screen.peg_mainForm;	
				// break;																			
				default:
					// return false;
					break;
			} 
			if((type!='module' && type!='table') || pegIsEmpty(p95_dContainer_id)){ 
				return false;
			} 
			 
			p95_d03Container_id = pegGetContainer_id_d(p95_dContainer_id , 'p95_d03'  , 'down' , 'p95_d' );
			var menuItemsGrid = pegGetCmp(p95_d03Container_id,'p95p80') ;
			var menuItemsStore;
			if(menuItemsGrid){
				try {
					menuItemsStore = menuItemsGrid.getStore();
					if(menuItemsStore.isLoading()){
						menuItemsStore.proxy.lastRequest._proxy.abort()
					}				
				} catch (error) {
					
				}
				 
			}
			//ToolbarItems
			p95_d04Container_id = pegGetContainer_id_d(p95_dContainer_id , 'p95_d04'  , 'down' , 'p95_d' ); 
			var toolbarItemsGrid = pegGetCmp(p95_d04Container_id,'p95p81') ;
			var toolbarItemsStore;
			if(toolbarItemsGrid){
				toolbarItemsStore = toolbarItemsGrid.getStore();
				try {
					if(toolbarItemsStore.isLoading()){
						toolbarItemsStore.proxy.lastRequest._proxy.abort()
					}	
				} catch (error) {
					
				}
				 
			}
		
			//pReports
			p95_d06Container_id= pegGetContainer_id_d(p95_dContainer_id , 'p95_d06'  , 'down' , 'p95_d' ); 
			var pReportsGrid = pegGetCmp(p95_d06Container_id,'p95q10') ;
			var en_q10_perm = pegGetVal('en_q10_perm', p95_d06Container_id );
			var pReportsStore;
			if(pReportsGrid && en_q10_perm == 1){
				pReportsStore = pReportsGrid.getStore();
				
				try {
					if(pReportsStore.isLoading()){
						pReportsStore.proxy.lastRequest._proxy.abort()
					}	 
				} catch (error) {
					
				}
			}
		
			if(type=='module'){
				//refresh
				p95_d02Container_id = pegGetContainer_id_d(p95_dContainer_id , 'p95_d02'  , 'down' , 'p95_d' );
				var tableGrid = pegGetCmp(p95_d02Container_id,'p95p50') ;
				if(tableGrid){
					var tableStore;
					try {
						tableStore = tableGrid.getStore();
						if(tableStore.isLoading()){
							tableStore.proxy.lastRequest._proxy.abort()
						}				
					} catch (error) {
						
					}
					tableStore.load({
						scope: this,
						callback: function(records, operation, success) { 
							if(menuItemsStore){
								menuItemsStore.load({
									scope: this,
									callback: function(records, operation, success) { 
										if(toolbarItemsStore){
											toolbarItemsStore.load({
												scope: this,
												callback: function(records, operation, success) { 
													if(pReportsStore){
														pReportsStore.load();
													}
												}
											});
										}
		
									}
								});
							}
						}
					});
					return true;
					// WebApp.view.grid.Grid.pegGridRefresh(tableGrid);
				}
			} 
			
			menuItemsStore.load({
				scope: this,
				callback: function(records, operation, success) { 
					if(toolbarItemsStore){
						toolbarItemsStore.load({
							scope: this,
							callback: function(records, operation, success) { 
								if(pReportsStore){
									pReportsStore.load();
								}
							}
						});
					}
		
				}
			});
		
			return true;
		}
		 
		/**
		 * Η οθόνη του  grid που χρησιμοποιείτε για την αναζήτηση πεδίον στο selectΒox.
		 * @param container_id
		 * @returns
		 */
		function core__selectbox_grid_d_afterDraw_listeners(container_id){  
			var gridobj = pegGetCmp(container_id + '_grid'); 
			 
			gridobj.peg_preventDefault_itemdblclick = true;
			gridobj.peg_preventDefault_enter = true;
			
			gridobj.on('itemdblclick', function( me, record, item, index, e, opts){  
				
				var selectBox = pegGetCmp(gridobj.ref_con_id);
				var screen = pegGetCmp(gridobj.getContainer_ID()); 
				
				var panel = pegGetCmp(screen.peg_winid); 
				var parentScreen = pegGetCmp(panel.peg_screen_parent_container_id );
				
				var params = selectBox[gridobj.ref_data_request]();
				
				params['type'] = '_selectbox_grid_d';
				peg002_GridModifyGlobalWhere(screen.getContainer_ID(), gridobj.name, params  ,function(){   
					var codeFldValue = record.data[selectBox.valueField] ;
					var valueFldValue = record.data[selectBox.displayField];
					
		
		//			console.info('codeFldValue', codeFldValue);
		//			console.info('valueFldValue', valueFldValue);
					var obj = pegGetCmp(selectBox.peg_getCodeID());
					 
					 if(obj){
		//				 if(obj.fireEvent){
		//					 obj.fireEvent('blur', obj);					 
		//				 }
						 obj.focus();
					 }
					if(screen.contextcolIdx && screen.contextrowIdx){
							 
						var grid = pegGetCmp(selectBox.getContainer_ID());
						var celleditingPl = grid.getPlugin('cellediting');
						celleditingPl.startEditByPosition({
							row: screen.contextrowIdx,
							column: screen.contextcolIdx 
						});
						
		//				console.info('selectBox.getContainer_ID', selectBox.getContainer_ID());
		//				console.info('selectBox.peg_getFullCodeName', selectBox.peg_getFullCodeName());
		//				console.info('selectBox.peg_getFullValueName', selectBox.peg_getFullValueName());
						
						
						pegSetVal( selectBox.peg_getFullCodeName() , selectBox.getContainer_ID(), codeFldValue);
						pegSetVal( selectBox.peg_getFullValueName(), selectBox.getContainer_ID(), valueFldValue); 	 
					}else{
		//				console.info('selectBox.getContainer_ID', selectBox.getContainer_ID());
		//				console.info('selectBox.peg_getFullCodeName', selectBox.peg_getFullCodeName());
		//				console.info('selectBox.peg_getFullValueName', selectBox.peg_getFullValueName());
						 
						
						pegSetVal( selectBox.peg_getFullCodeName() , selectBox.getContainer_ID(), codeFldValue);
						pegSetVal( selectBox.peg_getFullValueName(), selectBox.getContainer_ID(), valueFldValue);		
		
					}
					
					peg002_windowCloseAction(panel, 1, true);
					
					
		//			
					 
		
		
		
				});
				//XXX to stop default action
				return false;
				
			});
		}
		function core_browse_d00_afterDraw_listeners(container_id){
			var grid = pegGetCmp(container_id , 'grid');
			var screen = pegGetCmp(container_id );
			var propertypanel = pegGetCmp(container_id , 'propertypanel');
			
			if(grid.peg_view__d == 'a55_d' || grid.peg_view__d == 'a56_d' || grid.peg_view__d == 'a57_d' || grid.peg_view__d == 'a67_d'|| grid.peg_view__d == 'a60_d' || grid.peg_view__d == 'a61_d') {
				grid.record_copy=function(me, record) {		
					var p_table        = '';
					var p__d           = '_invoices_copy_tables_d';
					var p_module       = 'invoices';
					var p_container_id = container_id;
					var p_nr01         = 0;

					params = {
						peg_screen_parent_element_name: 'grid',
						peg_screen_parent_container_id: container_id
					}

					peg_windowShow_d(p_table, p__d, p_module, p_container_id, '', p_nr01, '', '', params, false, true, 0, 0, 'tablet');
				}
			}

			grid.peg_grid_totalCount_handler=function( totalCount, me, meStore ){
				grid.peg_total_count=totalCount;
			}
			grid.on('edit', function(editor, context) {  
				
					
				var values = {};
				values = context.record.getData({serialize:true});
				if(grid.peg_view_table=="a55" || grid.peg_view_table=="a56" ){
					if(typeof invoices_edit_ischecked_from_grid === "function"){
					invoices_edit_ischecked_from_grid(container_id, values.nr01, grid.peg_view_table, values.p901, context)
					}
				}else{ 
					pegSave_grid_row( 
							grid.peg_view__d ,
							grid.peg_view_table , 
							grid.peg_view_module  ,
							grid.getMnr01(),  
							grid.getMmnr01(), 
							values , 
							function(jsonData){   
								if(!jsonData.ok){ 
									context.record.reject();
									pegAlert(jsonData.message);
								}else{
									context.record.commit();
								}
							}
					); 
				}
			});  
			grid.on('canceledit', function(editor, context) {  
				context.record.reject();  
			});
			var pegasus_selected_index = grid.getStore().pegasus_selected_index;
			

			var property_task = new Ext.util.DelayedTask(function(record){
				var view_nr01=0;
				if(!pegIsEmpty(record)){
					view_nr01=record.getId();
				}
				peg002_update_GridProperty_data(grid,pegGetCmp(container_id,'propertypanel'),view_nr01);
			});

			grid.on('select', function( view, record, item, index, e, opts){
				if(!peg002_IsMobileOrTabletScreen()){
					property_task.delay(500,null,null,[record]);
				}		
			});
			grid.getStore().on('load',function(me,recs){
				if(recs.length==0){
					property_task.delay(500,null,null,[]);
				} 
			});

			propertypanel.on('collapse',function(me){;
				peg002_update_profile_prop_collasped(1);
				pegGetCmp(container_id).updateLayout();
			});
			propertypanel.on('expand',function(me){
				peg002_update_profile_prop_collasped(0);
				pegGetCmp(container_id).updateLayout();
			});
		}
		var core_browse_d0021_refresh_ajax='';
		function core_browse_d0021_refresh(container_id){		
			pegGetCmp(container_id,'search_fields').mask();
			if (core_browse_d0021_refresh_ajax) {
				if (core_browse_d0021_refresh_ajax.id > 0) {
					Ext.ux.AjaxDefer.abort(core_browse_d0021_refresh_ajax);
				}
			}
			var parent_container_id=pegGetCmp(container_id).getPeg_screen_parent_container_id();
			var parent_grid_name=pegGetCmp(container_id).getPeg_screen_parent_element_name();
			// var main_grid=pegGetCmp(pegGetContainer_id_d(container_id,'browse_d00','','browse_d00'),'grid');
			var main_grid=pegGetCmp(parent_container_id,parent_grid_name);
			var params={
				"container_id":container_id,
				"search_grid_container_id": main_grid.getContainer_ID(),
				"search_d": main_grid.peg_view__d,
				"_d": main_grid.peg__d,
				"module": main_grid.peg_module,
				"search_table": main_grid.peg_view_table,
				"search_module": main_grid.peg_view_module,
				"search_grid_name": main_grid.name,
				"p51_filter": pegGetVal('quicksearch',container_id)
			}
			core_browse_d0021_refresh_ajax = pegAjaxDefer(
				'/' + main_path + '/peg002_03/browse_d0021_griddata_refresh.php', 
				params, 
				function(jsonData00){
					pegSetVal('search_fields',container_id,jsonData00.data);
					core_browse_d0021_refresh_ajax = '';
					pegGetCmp(container_id,'search_fields').unmask();
				}
			);
 
		}
		var core_browse_d0021_cor012_save_ajax='';
		function core_browse_d0021_cor012_save(container_id){
			if (core_browse_d0021_cor012_save_ajax) {
				if (core_browse_d0021_cor012_save_ajax.id > 0) {
					Ext.ux.AjaxDefer.abort(core_browse_d0021_cor012_save_ajax);
				}
			}
			var params={
				'cor012_nr01'		:	pegGetVal('cor012',container_id),
				'cor012_p01'		:	pegGetVal('var_cor012_p01',container_id),
				'grid_name'			:	peg002_get_screen_data(container_id,'grid_name'),
				'grid_container_id'	:	peg002_get_screen_data(container_id,'grid_container_id'),
				'grid_table'		:	peg002_get_screen_data(container_id,'grid_table'),
				'grid__d'			:	peg002_get_screen_data(container_id,'grid__d'),
				'grid_module'		:	peg002_get_screen_data(container_id,'grid_module')
			};

			core_browse_d0021_cor012_save_ajax = pegAjaxDefer(
				'/' + main_path + '/peg002_03/browse_d0021_save_cor0012.php', 
				params, 
				function(jsonData00){
					if(!jsonData00.ok){
						pegToast(jsonData00.msg,'alert');
						return;
					}
					if(!pegIsEmpty(jsonData00.info)){
						pegToast(jsonData00.info,'info');
						return;
					}
					if(jsonData00.data){
						if(pegGetVal('cor012',container_id) !=jsonData00.data.cor012_nr01){
							pegSetVal('cor012',container_id,{'value': jsonData00.data.cor012_nr01 ,'display':jsonData00.data.cor012_p01});
							pegSetVal('var_cor012_p01',container_id,'');
						}
					}
					pegToast(jsonData00.msg,'success');
					pegGridRefresh(peg002_get_screen_data(container_id,'grid_container_id'),peg002_get_screen_data(container_id,'grid_name'))


				}
			);
		}

		var core_browse_d0021_cor012_change_ajax='';
		function core_browse_d0021_cor012_change(container_id){
			if (core_browse_d0021_cor012_change_ajax) {
				if (core_browse_d0021_cor012_change_ajax.id > 0) {
					Ext.ux.AjaxDefer.abort(core_browse_d0021_cor012_change_ajax);
				}
			}
			var params={
				'cor012_nr01'		:	pegGetVal('cor012',container_id),
				'grid_name'			:	peg002_get_screen_data(container_id,'grid_name'),
				'grid_container_id'	:	peg002_get_screen_data(container_id,'grid_container_id'),
				'grid__d'			:	peg002_get_screen_data(container_id,'grid__d'),
				'grid_module'		:	peg002_get_screen_data(container_id,'grid_module'),
				'parent_d'			: 	peg002_get_screen_data(container_id,'parent_d'),
				'isMobileOrTablet'	:	(peg002_IsMobileOrTabletScreen()?1:0)
			};

			core_browse_d0021_cor012_change_ajax = pegAjaxDefer(
				'/' + main_path + '/peg002_03/browse_d0021_change_cor0012.php', 
				params, 
				function(jsonData00){
					if(pegGetCmp(container_id)){
						core_browse_d0021_refresh(container_id);
					}
					pegGridRefresh(peg002_get_screen_data(container_id,'grid_container_id'),peg002_get_screen_data(container_id,'grid_name'))
					core_browse_d0021_cor012_change_ajax=null;
				}
			);
		}

		/**
		 * After draw function for "Απλή αναζήτηση"
		 * @param {String} container_id
		 * @returns
		 */
		function core_browse_d0021_afterDraw_listeners(container_id){
			
			core_browse_d0021_refresh(container_id);
			pegGetCmp(container_id,'search_btn').setPeg_handler(function(){
				core_browse_d0021_refresh(container_id);
			}); 
			pegGetCmp(container_id,'quicksearch').on('keydown', function(me2 , e, eOpts ) {
				if(e.event.keyCode==Ext.event.Event.ENTER ){
					core_browse_d0021_refresh(container_id);
				}
			}); 
			var cor012=pegGetCmp(container_id,'cor012');
			cor012.on('change', function( me, newValue, oldValue, eOpts ){
				core_browse_d0021_cor012_change(container_id);
			});
		

		}
		/**
		 * After draw function for Printing Forms  		
		 * @_d browse_d005
		 * @param container_id
		 * @returns
		 */
		function core_browse_d005_afterDraw_listeners(container_id){
			var screen = pegGetCmp(container_id);
			var grid   = peg_peg002_getCmp(container_id + '_grid');
			var btn01  = pegGetCmp(container_id, 'btn01');
		  
			grid.record_change = function(me,row){
				var p85Nr01    = row.nr01;
				var gridStore  = me.getStore();
				var gridParams = gridStore.vars;
				gridParams.container_id 	= container_id;
				gridParams.dias_main_field 	= "nr01";
		
				var parent_screen = pegGetCmp(gridParams.peg_screen_parent_container_id);
				if(parent_screen!=undefined){				
					if(parent_screen.peg__d=="inventory_004_d00"){
						gridParams.dias_main_field = "i00nr01";
					}else if(parent_screen.peg__d=="colorsize_001_d00"){
						gridParams.dias_main_field = "i47nr01";
					}else if(parent_screen.peg__d=="serial_001_d00"){
						gridParams.dias_main_field = "i31nr01";
					}else if(parent_screen.peg__d=="lot_001_d00"){
                        gridParams.dias_main_field = "i11nr01";
                    }
				}
				
				prints_formPrint(p85Nr01, gridParams);			 
			};
			
			
			btn01.setPeg_handler(function (me) {
				const grid = pegGetCmp(me.getContainer_ID(), 'grid');
				var row    = pegGridGetSelectedRow(grid.getContainer_ID(), grid.name, grid.getGridMnr01(), grid.mmnr01); 
				
				if(row){
				  const nr01 = row.nr01;
				  if(nr01<1){
					pegAlert('peg_dic_core_perm_deny_edit_rec' );
				  }else{
					const gridStore = grid.getStore();
					var gridParams  = gridStore.vars;
					gridParams.container_id 	= grid.getContainer_ID();
					gridParams.dias_main_field 	= "nr01";

					var parent_screen = pegGetCmp(gridParams.peg_screen_parent_container_id);
					if(parent_screen!=undefined){				
						if(parent_screen.peg__d=="inventory_004_d00"){
							gridParams.dias_main_field = "i00nr01";
						}else if(parent_screen.peg__d=="colorsize_001_d00"){
							gridParams.dias_main_field = "i47nr01";
						}else if(parent_screen.peg__d=="serial_001_d00"){
							gridParams.dias_main_field = "i31nr01";
						}else if(parent_screen.peg__d=="lot_001_d00"){
							gridParams.dias_main_field = "i11nr01";
						}
					}
					prints_formPrint(nr01, gridParams);
				  }
				}
			});
				
			return;
		}
		
		function core_browse_d00_import_json(
			screen = {}
		) {
			var grid_row = pegGridGetSelectedRow( screen.getContainer_ID() ,'grid' , screen.getMnr01(), screen.getMmnr01());

			params = {};
			params.module = grid_row.module;
			params.p02 = grid_row.p02;
			screen.mask();
			pegAjax('/'+main_path+'/dias03/import__d_from_json.php' , params , function(jsonData){ 
				screen.unmask();
				if(jsonData.ok == 0){
					pegAlert(jsonData.msg);
				}else{
					pegMsgBox(jsonData.msg);
				}
			})

		}

		function core_export_module_json(screen){
			var params = {};
			params.ver = screen.peg_getData('ver');
			params.rel = screen.peg_getData('rel');
			params.tax = screen.peg_getData('tax');
			params._ddt = screen.peg_getData('_ddt');
			params.q10dt = screen.peg_getData('q10dt');
			params.module = screen.peg_getData('p00');
			message = "Exporting JSON for "+ params.module;
			screen.mask(message);
			pegAjax('/' +main_path + '/dias03/export_module_json.php', params , function(js_data){
					screen.unmask(message);
					if(js_data.ok = 1){
						pegMsgBox(js_data.msg,'JSON File Created'  );			
					}else{
						pegAlert(js_data.msg,'ERROR ')
					}
					
   				 });
		}
		/**
		 * After draw function for the searchbox of 
		 * 
				  -- {WebApp.view.field.Text}
				  -- {WebApp.view.field.textarea.TextArea}
				  -- {WebApp.view.codemirror.CodeMirror}
				  -- {WebApp.view.field.textarea.tinyMCE.TinyMCE}
				  
		 * @_d browse_d0011
		 * 
		 * @see {@link peg002_GridSearchBox}
		 * 
		 * @param container_id
		 * @returns
		 */
		function core_browse_d0011_afterDraw_listeners(container_id){
			var screen = pegGetCmp(container_id );
			var search_val = pegGetCmp(container_id, 'search_val' );
			core_browse_d00keymap(screen);
			var tp = pegGetCmp(container_id,'tp' );
			tp.on('change',function(me, newValue, oldValue, eOpts){
				if(newValue=='in'){
					pegSetFieldHidden('search_val',container_id,true);
					pegSetFieldHidden('search_val_dist',container_id,false);
				}else{
					pegSetFieldHidden('search_val',container_id,false);
					pegSetFieldHidden('search_val_dist',container_id,true);
				}
			});
			search_val.focus();
			pegGetCmp(container_id,'order').on('change',function(me,newValue, oldValue, eOpts){
				if(!pegIsEmpty(newValue)){
					pegSetFieldHidden('order_tax',container_id,false);
				}else{
					pegSetFieldHidden('order_tax',container_id,true);
				}
			});
			return ; 
			
		}
		/**
		 * After draw function for the searchbox of 
		 * 
				  -- {WebApp.view.field.Number} 
				  
		 * @_d browse_d0012
		 * 
		 * @see {@link peg002_GridSearchBox}
		 * 
		 * @param container_id
		 * @returns
		 */
		function core_browse_d0012_afterDraw_listeners(container_id){
			var screen = pegGetCmp(container_id );
			var search_val = pegGetCmp(container_id, 'search_val' );
			
			core_browse_d00keymap(screen);
			var tp = pegGetCmp(container_id,'tp' );
			tp.on('change',function(me, newValue, oldValue, eOpts){
				if(newValue=='1'){
					pegSetFieldHidden('search_val',container_id,true);
					pegSetFieldHidden('search_val1',container_id,true);
					pegSetFieldHidden('search_val_dist',container_id,false);
				}else{
					pegSetFieldHidden('search_val',container_id,false);
					pegSetFieldHidden('search_val1',container_id,false);
					pegSetFieldHidden('search_val_dist',container_id,true);
				}
			});
			pegGetCmp(container_id,'order').on('change',function(me,newValue, oldValue, eOpts){
				if(!pegIsEmpty(newValue)){
					pegSetFieldHidden('order_tax',container_id,false);
				}else{
					pegSetFieldHidden('order_tax',container_id,true);
				}
			});
			search_val.focus();
		
			return ; 
			
		}
		/**
		 * After draw function for the searchbox of 
		 * 
				  -- {WebApp.view.field.Checkbox} 
				  
		 * @_d browse_d0013
		 * 
		 * @see {@link peg002_GridSearchBox}
		 * 
		 * @param container_id
		 * @returns
		 */
		function core_browse_d0013_afterDraw_listeners(container_id){
			var screen = pegGetCmp(container_id );
			var search_val = pegGetCmp(container_id, 'search_val' );
			core_browse_d00keymap(screen);
			search_val.focus();		
			return ; 
			
		}
		/**
		 * After draw function for the searchbox of 
		 * 
				  -- {WebApp.view.field.ComboBox} 
				  
		 * @_d browse_d0014
		 * 
		 * @see {@link peg002_GridSearchBox}
		 * 
		 * @param container_id
		 * @returns
		 */
		function core_browse_d0014_afterDraw_listeners(container_id){
			var screen = pegGetCmp(container_id );
			var search_val = pegGetCmp(container_id, 'search_val' );
			core_browse_d00keymap(screen);
			var tp = pegGetCmp(container_id,'tp' );
			tp.on('change',function(me, newValue, oldValue, eOpts){
				if(newValue=='1'){
					pegSetFieldHidden('search_val',container_id,true);
					pegSetFieldHidden('search_val_dist_preview',container_id,false);
					pegSetFieldHidden('add_val_combo',container_id,false);
					pegSetFieldHidden('add_val_btn',container_id,false);
				}else{
					pegSetFieldHidden('search_val',container_id,false); 
					pegSetFieldHidden('search_val_dist_preview',container_id,true);
					pegSetFieldHidden('add_val_combo',container_id,true);
					pegSetFieldHidden('add_val_btn',container_id,true);
				}
			});
			search_val.focus();
			pegGetCmp(container_id,'order').on('change',function(me,newValue, oldValue, eOpts){
				if(!pegIsEmpty(newValue)){
					pegSetFieldHidden('order_tax',container_id,false);
				}else{
					pegSetFieldHidden('order_tax',container_id,true);
				}
			});
			var add_val_btn=pegGetCmp(container_id,'add_val_btn');
			var add_val_combo=pegGetCmp(container_id,'add_val_combo');
			
			add_val_combo.selected_values=peg002_get_screen_data(container_id,'core_browse_d0014_search_val_dist_selected_values');
			core_browse_combo_preview_update(container_id);		

			add_val_btn.setPeg_handler(function(){
				if(!add_val_combo.selected_values){
					add_val_combo.selected_values=[];
				}
				if(!add_val_combo.selected_values.find(val=>val.value==add_val_combo.getValue())){					
					add_val_combo.selected_values.push({	'display':add_val_combo.getDisplayValue()||"",
															'value':add_val_combo.getValue()||""
														});
				}
				core_browse_combo_preview_update(container_id);				
			});
			return ; 
			
		}
		
		/**
		 * After draw function for the searchbox of 
		 * 
				  -- {WebApp.view.field.Date} 
				  
		 * @_d browse_d0015
		 * 
		 * @see {@link peg002_GridSearchBox}
		 * 
		 * @param container_id
		 * @returns
		 */
		function core_browse_d0015_afterDraw_listeners(container_id){
			var screen = pegGetCmp(container_id );
			var search_val = pegGetCmp(container_id, 'search_val' );
			core_browse_d00keymap(screen);
			var tp = pegGetCmp(container_id,'tp' );
			var tp = pegGetCmp(container_id,'tp' );
			tp.on('change',function(me, newValue, oldValue, eOpts){
				if(newValue=='1'){
					pegSetFieldHidden('search_val',container_id,true);
					pegSetFieldHidden('search_val1',container_id,true);
					pegSetFieldHidden('search_val_dist',container_id,false);
				}else{
					pegSetFieldHidden('search_val',container_id,false);
					pegSetFieldHidden('search_val1',container_id,false);
					pegSetFieldHidden('search_val_dist',container_id,true);
				}
			});
			search_val.focus();
		
			pegGetCmp(container_id,'order').on('change',function(me,newValue, oldValue, eOpts){
				if(!pegIsEmpty(newValue)){
					pegSetFieldHidden('order_tax',container_id,false);
				}else{
					pegSetFieldHidden('order_tax',container_id,true);
				}
			});
			return ; 
			
		}
		/**
		 * After draw function for the searchbox of 
		 * 
				  -- {WebApp.view.SelectBox} 
				  
		 * @_d browse_d0016
		 * 
		 * @see {@link peg002_GridSearchBox}
		 * 
		 * @param container_id
		 * @returns
		 */
		function core_browse_d0016_afterDraw_listeners(container_id){ 
			var screen = pegGetCmp(container_id ); 
			var tp = pegGetCmp(container_id,'tp' );
			tp.on('change',function(me, newValue, oldValue, eOpts){
				if(newValue=='1'){
					pegSetFieldHidden('search_val',container_id,true);
					pegSetFieldHidden('search_val_dist_preview',container_id,false);
					pegSetFieldHidden('add_val_combo',container_id,false);
					pegSetFieldHidden('add_val_btn',container_id,false);
					// pegSetFieldHidden('search_val_dist',container_id,false);
				}else{
					pegSetFieldHidden('search_val',container_id,false);
					pegSetFieldHidden('search_val_dist_preview',container_id,true);
					pegSetFieldHidden('add_val_combo',container_id,true);
					pegSetFieldHidden('add_val_btn',container_id,true);
					// pegSetFieldHidden('search_val_dist',container_id,true);
				}
			});
			core_browse_d00keymap(screen);
			var add_val_btn=pegGetCmp(container_id,'add_val_btn');
			var add_val_combo=pegGetCmp(container_id,'add_val_combo');
			
			add_val_combo.selected_values=peg002_get_screen_data(container_id,'core_browse_d0016_search_val_dist_selected_values');
			core_browse_combo_preview_update(container_id);		

			add_val_btn.setPeg_handler(function(){
				if(!add_val_combo.selected_values){
					add_val_combo.selected_values=[];
				}
				var add_val=add_val_combo.peg_values[0];
				if(!add_val_combo.selected_values.find(val=>val.value==add_val.value)){					
					add_val_combo.selected_values.push({	'display':add_val.display,
															'value':add_val.value
														});
				}
				core_browse_combo_preview_update(container_id);				
			});
			
			pegGetCmp(container_id,'order').on('change',function(me,newValue, oldValue, eOpts){
				if(!pegIsEmpty(newValue)){
					pegSetFieldHidden('order_tax',container_id,false);
				}else{
					pegSetFieldHidden('order_tax',container_id,true);
				}
			});
			return ; 
		}
		function core_browse_d0017_afterDraw_listeners(container_id){
			var screen = pegGetCmp(container_id );
			var search_val = pegGetCmp(container_id, 'search_val' );
			core_browse_d00keymap(screen);
			var tp = pegGetCmp(container_id,'tp' );
			var tp = pegGetCmp(container_id,'tp' );
			tp.on('change',function(me, newValue, oldValue, eOpts){
				if(newValue=='1'){
					pegSetFieldHidden('search_val',container_id,true);
					pegSetFieldHidden('search_val1',container_id,true);
					pegSetFieldHidden('search_val_dist',container_id,false);
				}else{
					pegSetFieldHidden('search_val',container_id,false);
					pegSetFieldHidden('search_val1',container_id,false);
					pegSetFieldHidden('search_val_dist',container_id,true);
				}
			});
			search_val.focus();
		
			pegGetCmp(container_id,'order').on('change',function(me,newValue, oldValue, eOpts){
				if(!pegIsEmpty(newValue)){
					pegSetFieldHidden('order_tax',container_id,false);
				}else{
					pegSetFieldHidden('order_tax',container_id,true);
				}
			});
			return ; 
			
		}
		function core_browse_combo_preview_update(container_id){
			var add_val_combo=pegGetCmp(container_id,'add_val_combo');
			if(add_val_combo.selected_values){
				pegGetCmp(container_id,'search_val_dist_preview').mask();
				pegGetDic('peg_dic_core_browse_combo_tag',function(desc){
					var tot=add_val_combo.selected_values.length;
					var preview_str='';
					var value_str='';
					var display_str='';
					for (let i = 0; i < tot; i++) {
						preview_str+=desc.replaceAll("##display##",add_val_combo.selected_values[i].display).replaceAll("##value##",add_val_combo.selected_values[i].value).replaceAll("##container_id##",container_id);
						if(i>0){
							value_str+=',';
							display_str+=',';
						}
						value_str+=add_val_combo.selected_values[i].value;
						display_str+='"'+add_val_combo.selected_values[i].display+'"';
					}
					pegSetVal('search_val_dist_preview',container_id,preview_str );
					pegSetVal('search_val_dist',container_id,value_str );
					pegSetVal('search_val_dist_disp',container_id,display_str );
					pegSetVal('add_val_combo',container_id,{'display':"",'value':""});
					pegGetCmp(container_id,'search_val_dist_preview').unmask();
				});
			}

		}
		function core_browse_combo_remove_selection (container_id,value){
			var add_val_combo=pegGetCmp(container_id,'add_val_combo');
			if(add_val_combo.selected_values){
				add_val_combo.selected_values.splice(add_val_combo.selected_values.findIndex(it=>it.value==value),1);
				core_browse_combo_preview_update(container_id);
			}
		}
		/**
		 * The requestin XSR on function {@link core__login_d_afterDraw_listeners}
		 * @type {string}
		 */
		var core_login_ajax=null;
		function core__login_d_afterDraw_listeners(container_id){
			var screen  =  pegGetCmp(container_id);
			var themecombo = pegGetCmp(container_id + '_theme');
			var langcombo = pegGetCmp(container_id + '_lang');
			var loginbutton = pegGetCmp(container_id + '_login');
			 
		
			loginbutton.setPeg_handler( function(me){  
				var url = '../core01/login00.php' ; 
				var data = screen.peg_getData();
				
				if (core_login_ajax  ) {
					if (core_login_ajax.id > 0) {
						Ext.ux.AjaxDefer.abort(core_login_ajax);
					}
				}
				core_login_ajax = pegAjaxDefer(url, data,  function(jsonData){ 
					core_login_ajax = null;
					if(!jsonData.login){
						pegAlert(jsonData.message);
					}else{
						var timeout = 0;
						if(jsonData.toast){
							pegToast(jsonData.message, 'alert');
							timeout = 1000;
						}
						window.onbeforeunload = null;
						setTimeout(() => {
							window.location.reload();
						}, timeout);
						
					}
				} , 'json' , 1); 
			});
			
		
			if(themecombo){
				themecombo.on('change',function( themecombo, newValue, oldValue, eOpts ){
					if(newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue) ) || (!pegIsEmpty(newValue) && pegIsEmpty(oldValue) )){
						return ;
					}
					peg002_updateCookie('','',newValue);
					window.onbeforeunload = null;
					window.location = '/'+main_path+'/peg002_app/index.html?theme=' +newValue;
				});
			}
				
				
			if(langcombo){
				langcombo.on('change',function( langcombo, newValue, oldValue, eOpts){
				
					if(newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue) ) || (!pegIsEmpty(newValue) && pegIsEmpty(oldValue) )){
						return ;
					}
					peg002_updateCookie('',newValue);
					window.onbeforeunload = null;
					window.location.reload();
				
				});
			}
		
		
		// 	if(themecombo){
		// 		themecombo.on('change',function( themecombo,  newValue, oldValue, eOpts ){  
		// 			if(newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue) ) || (!pegIsEmpty(newValue) && pegIsEmpty(oldValue) )){
		// 				return ;
		// 			} 
		// 			peg002_updateCookie('','',newValue);
		// 			window.location = '/'+main_path+'/peg002_app/index.html?theme=' +newValue;
		// 		});		
		// 	}
		
			
		// 	if(langcombo){
		// 		langcombo.on('change',function( langcombo, newValue, oldValue, eOpts){ 
					
		// 			if(newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue) ) || (!pegIsEmpty(newValue) && pegIsEmpty(oldValue) )){
		// 				return ;
		// 			} 
		// 			peg002_updateCookie('',newValue);
		// //			var userCookie  = pegJsonDecode( Ext.util.Cookies.get(PEGASUS.cookiePrpName) );
		// //			if(userCookie ){
		// //				userCookie['lang'] = newValue;
		// //				Ext.util.Cookies.set(PEGASUS.cookiePrpName, pegJsonEncode(userCookie) );
		// //			}
		// 			window.location.reload();
					 
		// 		});
		// 	}
			
			WebApp.view.Screen.peg_appendKeyMap( 
					screen,
					Ext.event.Event.ENTER,
					function(  keyCode, screen){ 
						pegGetCmp(screen.getContainer_ID()+'_login').handler();
						  return false;
					  }, 
					''
				);  
		}
		
		function core__login_d1_afterDraw_listeners(container_id){
			var screen	= pegGetCmp(container_id);
			var but01	= pegGetCmp(container_id + '_but01');
			
			but01.setHandler(function(){
				peg_windowShow_d( '', '_login_d00', 'core', screen.getContainer_ID() , '', 0, '',  '', {} , '' , 1, 1);
			});
		}
		
		
		var core_us0_d_refresh_ajax=null;
		function core_us0_d_refresh(container_id){
			
			var	container_id_us0_d     =  pegGetContainer_id_d(container_id , 'us0_d'   , '' , 'us0_d' );
			var	container_id_us0_d00   =  pegGetContainer_id_d(container_id , 'us0_d00' , '' , 'us0_d' );
					
			params = {};
			params.p97  = pegGetVal('p97'  , container_id_us0_d);
			params.p95  = pegGetVal('p95'  , container_id_us0_d);
			params.p410 = pegGetVal('p410' , container_id_us0_d00);
			
			if(core_us0_d_refresh_ajax){
				if(core_us0_d_refresh_ajax.id>0){
					Ext.ux.AjaxDefer.abort(core_us0_d_refresh_ajax);
				}
			}
				
			core_us0_d_refresh_ajax = pegAjaxDefer('/' + main_path + '/core01/us0_refresh.php' , params , function(jsondata){
				if(jsondata.ok==1){
					if(jsondata.p95!=undefined){
						pegSetVal('p95'  , container_id_us0_d   , jsondata.p95);
					}
					if(jsondata.p412!=undefined){
						pegSetVal('p412'  , container_id_us0_d00   , jsondata.p412);
					}
							
				}
			}, 'json' , true );	
		}
		
		function core_us0_d_afterDraw_listeners(container_id){
				var screen  =  pegGetCmp(container_id);
				
				var	container_id_us0_d     =  pegGetContainer_id_d(container_id , 'us0_d'   , '' , 'us0_d' );
				var	container_id_us0_d00   =  pegGetContainer_id_d(container_id , 'us0_d00' , '' , 'us0_d' );
				
				
				var p97  = pegGetCmp(container_id_us0_d, 'p97' );
				var p95  = pegGetCmp(container_id_us0_d, 'p95' );
				
				var p410 = pegGetCmp(container_id_us0_d00, 'p410' );
				var p412 = pegGetCmp(container_id_us0_d00, 'p412' );
				
				
				p97.on('change', function(me, newValue, oldValue, eOpts ){
					if(newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue) )){
						return ;
					}
					 core_us0_d_refresh(container_id);
				});	
		
				if(p410){
					p410.on('change', function(me, newValue, oldValue, eOpts ){
						if(newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue) )){
							return ;
						}
						 core_us0_d_refresh(container_id);
					});	
				}
		 
				var button_upload = pegGetCmp(container_id_us0_d , 'button_upload');
				button_upload.setPeg_handler(function(){
					pegWindowShow_d( '' , 'us0_d100' , 'core' , '' , 0 , '&peg_nr01='+button_upload.getMnr01(), container_id_us0_d  ,0 , 0 ,'',{},false,true,0,'mobile');
		
				});
		
				var button_delete = pegGetCmp(container_id_us0_d , 'button_delete');
				button_delete.setPeg_handler(function(){
					pegAjax('/'+main_path+'/core06/delete_user_avatar.php' , {} , function(jsonData){core_us0_d_change_profile_photo(container_id);}); 
				});
		}
		
		function core_us0_d00_afterDraw_listeners(container_id){
			var reset_2fa=pegGetCmp(container_id,'reset_2fa');
			reset_2fa.setPeg_handler(function (me) {
				firewall_reset_2fa_secret(pegGetVal('p01',container_id));
			});
		}
		
		function core_us0_d_change_profile_photo(container_id){
			var	container_id_us0_d     =  pegGetContainer_id_d(container_id , 'us0_d'   , '' , 'us0_d' );
			pegSetVal('profile_photo' , container_id_us0_d       , '<img src="/' + main_path + '/core06/user_avatar.php?tm='+pegMicrotime(1)+'"  class="peg_avatar_us0" >');
			Ext.getCmp('_main_d_toolbarbutton_user_menu').setText( '<img src="/' + main_path + '/core06/user_avatar.php?tm='+pegMicrotime(1)+'"  class="peg_avatar" > ' + pegGetVal('p100' , container_id_us0_d))
		
		}
		
		function core_us0_d01_afterDraw_listeners(container_id){
			var screen	= pegGetCmp(container_id);
			var smtp_but	= pegGetCmp(container_id + '_smtp_but');
			
			smtp_but.setHandler(function(){
				core_smtp_check(container_id, 'us0');
			});
		}
		
		function core_p97_d_afterDraw_listeners(container_id){
		
			var screen = pegGetCmp(container_id );
			var tab	= pegGetCmp(container_id , 'tab');
			var nr01   = screen.peg_getData('nr01'); 
			 
			if( nr01==0 ) {
				var totalItems = tab.items.getCount();
				for (i = 0; i < totalItems; i++) {
					tab.items.get(i).disable();   
				}
			} 
		}
		/**
		 * Δικαιώματα πεδίων browse ανά προφίλ χρήστη
		 *   
		 * @param {String} container_id
		 * @returns
		 */
		function core__profile_d00_afterDraw_listeners(container_id){
			var screen = pegGetCmp(container_id );
			var profilecombo = pegGetCmp(container_id, 'p95' );
			var profilegrid= pegGetCmp(container_id , 'grid');
		
			// profilegrid.setpeg_isEditable(true);
		
			var editableBt = pegGetCmp(container_id+'_grid_toolbarbutton_editable');
			//console.info('editableBt', editableBt);
			if(editableBt){
				editableBt.setHidden00(editableBt, true, false);
			}
			WebApp.view.grid.Grid.peg_enableRowEdit(profilegrid);
			
			profilecombo.on('select' ,function(me, record,  eOpts ){ 	
				// profilegridStore.loadPar['p95'] = me.getValue();
				// profilegridStore.load(); 
				var container =Ext.getStore('store_'+container_id+'_grid');
				profilegrid.mask();
				
				var params = {
						type:				'grid',
						_d:  				me.peg__d,
						module:				me.peg_module,
						mmnr01:				me.getMmnr01(),
						mnr01:				me.getMnr01(),
						container_id:		container_id,
						p95:				me.getValue()
						
				};
		
				
				pegAjax(
						PEGREQUEST.GLOBALDATAFUNCTION, 
						params , 
						function(json){
							profilegrid.unmask();
							container.load();	
						} 
						,'json' );  
				
			 
			});  
			
			profilegrid.on('validateedit',function(editor, e){
				if(  e.value==0	){
					pegGetDicAlert('peg_dic_core_profile_zero_value');
					//pegAlert('peg_dic_core_profile_zero_value');
					// e.cancel = true;
					e.record.data[e.field] = e.value;
				} 	
			});
			
			profilegrid.on('edit',function(editor, e) {
				values = e.record.data;
				values.p95 =  pegGetVal('p95' , container_id); 
		
				values = e.record.data;
				if(values && values['nr01']<0){
					values['nr01'] = 0;
				}
				  
				pegSave_grid_row('p95p51_d' , 'p95p51' , 'core' , '' ,  ''  , values ,function(jsonData){  
					if(!jsonData.ok){  
						e.record.reject();
						pegAlert(jsonData.message);
					}else{
						e.record.data['nr01'] = jsonData.nr01;				
						e.record.commit();
					}
		
					
				});
			}); 
		
		}
		
		function core__profile_d01_afterDraw_listeners(container_id){
			var profilecombo = pegGetCmp(container_id + '_p95');
			var profilegrid= pegGetCmp(container_id + '_grid');
			
			profilegrid.setpeg_isEditable(true);
			
			
			profilecombo.on('select',function( me, data ){ 
				var container =Ext.getStore('store_'+container_id+'_grid');
				profilegrid.mask();
				
				var params = {
						type:				'screen',
						_d:  				me.peg__d,
						module:				me.peg_module,
						mmnr01:				me.getMmnr01(),
						mnr01:				me.getMnr01(),
						container_id:		container_id,
						p95:				me.getValue()
						
				};
		
				
				pegAjax(
						PEGREQUEST.GLOBALDATAFUNCTION, 
						params , 
						function(json){
							profilegrid.unmask();
							container.load();	
						} 
						,'json' );  
				
			 
				
			});
			profilegrid.on('edit' ,  function(editor, e) {
				  if(e.field=='hidden'){
					if(e.record.data.hidden_def==1){
						pegGetDicAlert('peg_dic_core_no_change_value'); 
						e.record.reject();
						return;
					}
				  }
				  if(e.record.data.desc07 == 'button' && e.field == 'rdonly'){
						pegGetDicAlert('peg_dic_core_no_change_value'); 
						e.record.reject();
						return;
				  }
				  if(e.field=='rdonly'){
					if(e.record.data.rdonly_def==1){
						pegGetDicAlert('peg_dic_core_no_change_value'); 
						e.record.reject();
						return;
					}
				  }
		
				  values = e.record.data;
				  if(values && values['nr01']<0){
					  values['nr01'] = 0;
				  }
				  values.p95 =  pegGetVal('p95' , container_id); 
				  
				  pegSave_grid_row('p95p51_d' , 'p95p51' , 'core' , '' ,  ''  , values ,function(jsondata){  
					  e.record.data['nr01'] = jsondata.nr01;
					  e.record.commit();
				  }  ) ; 
				 
		
				});	
		 
		}
			
		
		function core_p50_d_grid_afterDraw_listeners(container_id){ 
			var grid = pegGetCmp(container_id+'_grid'); 
			grid.peg_isEditable = false;
		}
		function core_p50_d_afterDraw_listeners(container_id){
			var screen = pegGetCmp(container_id);
			var tabs = pegGetCmp(container_id+'_tab_p50');
			
			var p102 = screen.peg_getData('p102');
			
		 
			if(p102!=true){
				var totalItems = tabs.items.getCount();
				for (i = 0; i < totalItems; i++) {
					 _d  = tabs.getItem_d(i);
					 
					 if(
							(
								 _d == 'p50_d05' ||
								 _d == 'p50_d07' ||
								 _d == 'p50_d08' ||
								 _d == 'p50_d09' ||
								 _d == 'p50_d10'
							)
						 
						 && !(p102)){
						 tabs.items.get(i).disable(); 
					 }	 
				}
			} 
		}
		
		function core_p50_d03_afterDraw_listeners(container_id){
			var screen = pegGetCmp(container_id);
			var grid = pegGetCmp(container_id + '_grid');
			
			grid.peg_isEditable = false;
			grid.on('edit',function(editor, e) {
			  var peg_originalValue = e.originalValue;
			  var peg_value = e.value;
		
			if(e.newValues.desc07!=e.originalValues.desc07){
				  params = e.record.data;
				  params.mnr01= screen.getMnr01()	;
				  params.mmnr01= screen.getMmnr01();
		
				  params.originalvalue = e.originalValue; 	
				  pegAjax('/'+main_path+'/dias01/change_desc07.php' , params , function(jsonData){ 
					  var record = e.record;
					  var container =   Ext.getCmp(container_id + '_tab1' ); 
		 
					  container.loader.url = '/' +main_path + '/core_global/show_d.php?inWindow=1&table=peg_tmp_p51&_d=p51_d&module=core&nr01=' + record.data.nr01 +
							  '&mnr01='+screen.getMnr01()+'&mmnr01='+screen.getMmnr01()+'&container_id='+container_id+'&p51_module=' + record.data.module + '&p51_p02=' + record.data.p02 + 
							  '&p51_desc05=' + record.data.desc05  + '&parent_id=';
					  container.loader.load();		 
					  if(!container.tab.active){
						  container.loader.peg_auto_reload=1;
					  }else{
						  container.loader.peg_auto_reload=0;
					  }
					  var container =   Ext.getCmp( container_id + '_tab2' ); 
		
					  container.loader.url = '/' +main_path + '/core_global/show_d.php?inWindow=1&table=peg_tmp_p52&_d=p51_d01&module=core&nr01=' + record.data.nr01 + '&mnr01=' + record.data.nr01 + 
							  '&mmnr01='+screen.getMmnr01()+'&container_id='+container_id+'&p51_module=' + record.data.module + '&p51_p02=' + record.data.p02 + '&p51_desc05=' + record.data.desc05 + '&p51_desc07=' + record.data.desc07 + '&pp_width=' + container.getWidth()+ '&pp_height='  + container.getHeight();
					  container.loader.load();
					  if(!container.tab.active){
						  container.loader.peg_auto_reload=1;
					  }else{
						  container.loader.peg_auto_reload=0;
					  }
		
				  } , 'json' , true);
				 
			  }
			  values = e.record.data;
			  values.p95 = screen.peg_getData('nr01'); 
			   
			  pegSave_grid_row(grid.peg_view__d, 'peg_tmp_p51' , grid.peg_view_module  ,grid.getMnr01(),  grid.getMmnr01(), values,  function(jsondata){  
				  e.record.data['nr01'] = jsondata.nr01;
				 
			  } );
			  e.record.commit();
			}); 
			grid.on('beforeselect',function( view, record, item, index, e, opts){
				return ;
				var container =   Ext.getCmp( container_id+ '_tab1' ); 
			 
				container.loader.url = '/' +main_path + '/core_global/show_d.php?inWindow=1&table=peg_tmp_p51&_d=p51_d&module=core&nr01=' +
					record.data.nr01 + '&mnr01='+screen.getMnr01()+'&mmnr01='+screen.getMmnr01()+'&container_id='+container_id+'&p51_module=' + 
					record.data.module + '&p51_p02=' + record.data.p02 + '&p51_desc05=' + 
					record.data.desc05  + '&p51_desc02=' + encodeURIComponent(record.data.desc02)  + '&parent_id=';
				container.loader.load();
				
				if(!container.tab.active){
					container.loader.peg_auto_reload=1;
				}else{
					container.loader.peg_auto_reload=0;
				}
		
				var container =   Ext.getCmp( container_id + '_tab2' ); 
		
				container.loader.url = '/' +main_path + '/core_global/show_d.php?inWindow=1&table=peg_tmp_p52&_d=p51_d01&module=core&nr01=' + 
					record.data.nr01 + '&mnr01=' + record.data.nr01 + '&mmnr01='+screen.getMmnr01()+'&container_id='+container_id+'&p51_module=' + 
					record.data.module + '&p51_p02=' + record.data.p02 + '&p51_desc05=' + record.data.desc05 + '&p51_desc07=' + record.data.desc07 +  
					'&p51_desc02=' + encodeURIComponent(record.data.desc02)  +  '&pp_width=' + container.getWidth()+ '&pp_height='  + container.getHeight();
				container.loader.load();
				if(!container.tab.active){
					container.loader.peg_auto_reload=1;
				}else{
					container.loader.peg_auto_reload=0;
				}
					
			});
		
		
		}
		
		
		
		 
		function core_p50_d11_afterDraw_listeners(container_id){
			var screen = pegGetCmp(container_id);
			var refresh = pegGetCmp(container_id+'_refresh');
			var treepanel = pegGetCmp(container_id + '_fields');
			var treepanelStore = treepanel.getStore();
			 
			refresh.setHandler(function(){
				Ext.getStore('peg_store_'+container_id+'_fields').load();	
			}); 
			treepanelStore.on( 'beforeload', function( me, operation, eOpts ){
				console.log('Before Load');
				me.proxy.extraParams = {
						module: screen.peg_getData('module'),
						_d: screen.peg_getData('p02'), 
						mmnr01: screen.getMmnr01()
				};
			}); 
			treepanel.on('drop',function( node, data, overModel, dropPosition ){
				parms = {};
				parms.drop_position  =  dropPosition;
				parms.mmnr01		=  screen.getMmnr01();
				parms.data_p51_nr01 = data.records[0].raw.p51_nr01;
				parms.drop_p51_nr01 = overModel.raw.p51_nr01;
				pegAjax('/' + main_path + '/dias01/tree_view_d_fields_change_parm.php' , parms , function(){} , 'json' , true , true);		
			});
			treepanelStore.load();
		}
		
		function core_p51_d_afterDraw_listeners(container_id){
			var screen = pegGetCmp(container_id);
			var butt = pegGetCmp(container_id + '_butt' );
			
			butt.setHandler(function(){
				pegSave_d(
						container_id,  
						'p51_d' ,  
						'peg_tmp_p51' ,  
						'core' ,  
						container_id , 'p51_d' ,  screen.getMnr01()   ,   screen.getMmnr01()		
				);
			});
			
			//XXX Den jerw poy anaferonte
			var screen_p50_d03 = pegGetCmp(pegGetContainer_id_d(container_id , 'p50_d03'   , '' , 'p50_d'));
			
			var grid_p52 = pegGetCmp(container_id+'_grid_p52');
			
			grid_p52.setpeg_isEditable(false);
			grid_p52.peg_preventDefault_itemdblclick = true;
			
			grid_p52.on('beforeitemdblclick',function(view, record, item, index, e, opts){
				var _d='p52_d';
				if(record.data.p62_00_type=='S'){
					_d='p52_d01';
				}
				if(record.data.p62_00_type=='N'){
					_d='p52_d02';
				}
				
				var grid_row = pegGridGetSelectedRow( screen_p50_d03.getContainer_ID() ,'grid' , screen_p50_d03.getMnr01(), screen_p50_d03.getMmnr01());
				
				pegWindowShow_d( 
						'peg_tmp_p52' , 
						_d , 
						'core' , 
						'' ,   
						record.data.nr01 , 
						 '',
						 screen_p50_d03.getContainer_ID() ,
						{
							mmnr01: screen.getMmnr01(),
							mnr01: screen.getMnr01(),
							p51_p02: '',
							p51_desc05: '',
							p51_module: '',
							p51_desc07: '',
							p62_par_nm: record.data.par_nm ,
							peg_screen_parent_element_name: me.name,
							peg_screen_parent_container_id: me.getContainer_ID()
						},
						modal 
						
				);		 
				
				return false;
			});
		}
		
		
		function core_p52_d_afterDraw_listeners(container_id){
			console.log('core_p52_d_afterDraw_listeners');
			var screen = pegGetCmp(container_id);
			var code = pegGetCmp(container_id + '_code');
			
			code.on('change', function(me,  newVal, oldVal, eOpts ){ 
				 if(newVal === oldVal){
					 return true;
				 }
				core_p52_d_setMode(pegGetCmp(pegGetContainer_id_d(container_id , 'p52_d03'   , '' , 'p52_d') + '_par_val' ),newVal);
				core_p52_d_setMode(pegGetCmp(pegGetContainer_id_d(container_id , 'p52_d05'   , '' , 'p52_d') + '_epar_val' ),newVal);
			});
		}
		
		
		function core_p52_d03_afterDraw_listeners(container_id){ 
			var screen = pegGetCmp(container_id);
			var par_val = pegGetCmp(container_id + '_par_val');
			
			core_p52_d_setMode(par_val,screen.peg_getData('code'));
		}
		function core_p52_d04_afterDraw_listeners(container_id){
			var screen = pegGetCmp(container_id);
			var par_val_js = pegGetCmp(container_id + '_par_val_js');
			
			core_p52_d_setMode(par_val_js,screen.peg_getData('code'));
		}
		function core_p52_d05_afterDraw_listeners(container_id){
			var screen = pegGetCmp(container_id);
			var epar_val = pegGetCmp(container_id + '_epar_val');
			
			core_p52_d_setMode(epar_val,screen.peg_getData('code'));
		}
		function core_p52_d06_afterDraw_listeners(container_id){
			var screen = pegGetCmp(container_id);
			var epar_val_js = pegGetCmp(container_id + '_epar_val_js');
			
			core_p52_d_setMode(epar_val_js,screen.peg_getData('code'));
		}
		
		function core_p61_d_afterDraw_listeners(container_id){
			var screen = pegGetCmp(container_id);
			var but_save = pegGetCmp(container_id + '_but_save');
			var butt_clos = pegGetCmp(container_id + '_butt_clos');
			
			but_save.setHandler(function(){
				console.error("Todo handler");
				/*pegSave_d(
						container_id , '" . $this->scr__d. "', '" . $this->scr_table. "', '" . $this->scr_module. "', '" . $this->container_id. "' ,  '" . $this->scr__d. "' ,  '" . $this->mnr01 . "', '" .$this->mmnr01 . "' ,  function(){
		
		
					//FIND THE PANEL  	
					con_4 = '" . pegasus_container_id_get_parent($this->container_id,4) . "';
					
					//FIND THE PANEL
					con_5 = '" . pegasus_container_id_get_parent($this->container_id,5) . "';
					
					pegTabClose('" . pegasus_container_id_get_parent($this->container_id) . "');
					Ext.getCmp(con_5 + '_dias02_tab').setActiveTab(con_4);
					
					pegGridRefresh( '".pegasus_container_id_get_parent($this->container_id, 3)."' , 'grid' ); 
		
				});*/
			});
			
			butt_clos.setHandler(function(){
				console.error("Todo handler");
		/*	  	pegTabClose('" . pegasus_container_id_get_parent($this->container_id) . "');
				  con_4 = '" . pegasus_container_id_get_parent($this->container_id,4) . "';
				  con_5 = '" . pegasus_container_id_get_parent($this->container_id,5) . "';
				  Ext.getCmp(con_5 + '_dias02_tab').setActiveTab(con_4);*/
			});
		}
		
		function core_p63_d_afterDraw_listeners(container_id){
			var screen = pegGetCmp(container_id);
			var but_save = pegGetCmp(container_id + '_but_save');
			var butt_clos = pegGetCmp(container_id + '_butt_clos');
			
			but_save.setHandler(function(){
				console.error("Todo handler");
			});
			
			butt_clos.setHandler(function(){
				console.error("Todo handler");
			});
			
		} 
		function core_p81_d_afterDraw_listeners(container_id){
			var screen = pegGetCmp(container_id);
			var module = pegGetCmp(container_id+'_module');
			var _d = pegGetCmp(container_id+'__d');
			
			module.on('change', function(me, newValue, oldValue, eOpts ){
				if(newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue) )){
					return ;
				} 
				core_p81_d_change( container_id,me.name);
				
			})
			_d.on('change', function(me, newValue, oldValue, eOpts ){
				if(newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue) )){
					return ;
				} 
				core_p81_d_change( container_id,me.name);
			})
		}
		
		
		function core_p90_d_afterDraw_listeners(container_id){
			var screen = pegGetCmp(container_id);
			var save = pegGetCmp(container_id + '_save'); 
			var close = pegGetCmp(container_id + '_close'); 
			
			save.setHandler(function(){
				console.error("Todo handler");
			});
			
			close.setHandler(function(){
				console.error("Todo handler");
			});
		}

	   
		function core_p92_d00_afterDraw_listeners(container_id){
			var screen	= pegGetCmp(container_id);
			var p92		= pegGetCmp(container_id + '_p92');
			var cor007	= pegGetCmp(container_id + '_cor007'); 
			var progress_bar	= pegGetCmp(container_id +'_progress_bar');
			var grid	= pegGetCmp(container_id +'_grid');
			
			
			
			p92.on('change', function(me, newValue, oldValue, eOpts ){
				if(newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue) )){
					return ;
				}
			 
				core_p92_d00_p92_change(container_id);
			});
			 
			cor007.on('change', function(me, newValue, oldValue, eOpts ){
				if(newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue) )){
					return ;
				}
				pegGridRefresh(container_id , 'grid' ,0 );
			});
			
			
			var p92_updateTaskRunner = function () {
				if(!(progress_bar)){
					p92_task.stop();
				}
		
				if(progress_bar.wait()==false){
					p92_task.stop();
				}
				pegAjax('/' + main_path + '/core_exec/exec_task.php' , {} , function(jsondata){

					if(jsondata.text==''){
						progress_bar.updateProgress( '1', '', true );
					}else{
						progress_bar.updateProgress( '1', jsondata.text , true );			
					}
				 });
			 }
			
			progress_bar.p92_runner = new Ext.util.TaskRunner();
			 p92_task = progress_bar.p92_runner.newTask({
				 run: p92_updateTaskRunner,
				 interval: 500 	 
			 });
			 
			 var editableBt = pegGetCmp(container_id+'_grid_toolbarbutton_editable');
			 //console.info('editableBt', editableBt);
			 if(editableBt){
				 editableBt.setHidden00(editableBt, true, false);
			 }
			WebApp.view.grid.Grid.peg_enableRowEdit(grid);

			if(peg002_IsMobileScreen()){  
				grid.record_change = function(me,row){
					peg_windowShow_d(
						me.peg_view_table,
						me.peg_view__d,
						me.peg_view_module,
						me.getContainer_ID(),
						'',
						row.nr01,
						'',
						'',
						{
							mmnr01:me.getMmnr01(),
							mnr01: me.getGridMnr01(),
							peg_screen_parent_element_name: me.name,
							peg_screen_parent_container_id: me.getContainer_ID(),
							value:row.value
						},
						false 
					); 
				}
				grid.peg_isEditable=false;
				grid.on('itemdblclick', function( me, record, item, index, e, opts){  
					var me = me.ownerGrid;
					return WebApp.view.grid.Grid.peg_tryEditRec(me,record); 
				});
			}
			
			
			grid.on('edit', function(editor, context) {   
				   context.record.commit();
			});
		
			grid.on('canceledit', function(editor, context) {  
				  context.record.reject();  
			});
		}


		function core_p93_d00_afterDraw_listeners(container_id){
			var update_p93_val=pegGetCmp(container_id,'update_p93_val');
			update_p93_val.setHandler(function(){
				var screen=pegGetCmp(container_id);
				var paren_grid=pegGetCmp(screen.peg_screen_parent_container_id,screen.peg_screen_parent_element_name);
				var sel_model=paren_grid.getSelectionModel(); 
				sel_model.getSelection()[0].set('value',pegGetVal('value',container_id));
				pegWindowClose(container_id);
			});
		}


		function p92_d00_toolbar_execute(screen) {
			pegAjax(
				'/' + main_path + '/core_exec/exec.php',
				{
					'step': 1,
					'p92_nr01': pegGetVal('p92', screen.getContainer_ID())
				},
				function (jsonData) {
					if (jsonData.ok == 0) {
						pegAlert(jsonData.msg);
					}

					if (jsonData.ok == 1) {
						var peg_dic_core_please_wait = '';
						pegGetDic('peg_dic_core_please_wait', function (desc) { peg_dic_core_please_wait = desc; });
						pegConfirmBox('', jsonData.msg,
							function (button) {
								if (button === 'yes') {
									var progress_bar = pegGetCmp(screen.getContainer_ID() + '_progress_bar');
									p92_task.start();
									progress_bar.wait();
									progress_bar.updateProgress('1', peg_dic_core_please_wait, true);

									parameters = { 'step': 2, 'p92_nr01': pegGetVal('p92', screen.getContainer_ID()) };
									pegGetCmp(screen.getContainer_ID() + '_grid').getStore().each(function (record) {
										parameters['peg_grid_' + record.data.name] = record.data.value;
									});


									if (p92_ajax_execution != '') {
										Ext.Ajax.abort(p92_ajax_execution);
									}

									p92_ajax_execution = p92_exec(parameters, screen.getContainer_ID());
								}
							}
						)
					}
				}, 'json');
		}

		/**
		 * Eπιτρεπόμενα δίκτυα (Valid Hosts)
		 * @param container_id
		 * @returns
		 */
		function core_p95_d00_afterDraw_listeners(container_id){
			var screen	= pegGetCmp(container_id);
			var p95p98	= pegGetCmp(container_id + '_p95p98');
			
			WebApp.view.grid.Grid.peg_enableRowEdit(p95p98);
			p95p98.on(
					'edit',
					function( editor, e){
						var values = {};
						values = e.record.getData({serialize:true});
						values.p95 = screen.getNr01(); 
						if(values && values['nr01']<0){
								values['nr01'] = 0;
						}
		 
						pegSave_grid_row(
							p95p98.peg_view__d ,
							'peg_tmp_p95p98' , 
							p95p98.peg_view_module  ,
							p95p98.getMnr01(),  
							p95p98.getMmnr01(), 
							values ,  
							function(jsondata){  
								e.record.data['nr01'] = jsondata.nr01;
								e.record.commit();
						});  
					}
			);
			p95p98.on('canceledit', function(editor, context) {  
				context.record.reject();  
			});
		}
		/**
		 * Modules
		 * @param container_id
		 * @returns
		 */
		function core_p95_d01_afterDraw_listeners(container_id){
			var screen	= pegGetCmp(container_id);
			var p95p55	= pegGetCmp(container_id + '_p95p55');
			
			WebApp.view.grid.Grid.peg_enableRowEdit(p95p55);
		
		
			p95p55.on(
					'edit',
					function( editor, e){
						  var myTargetRow = 6;
						  values = e.record.getData({serialize:true}) ;
						  if(values && values['nr01']<0){
								values['nr01'] = 0;
							}
						  values.p95 = screen.getNr01(); 
						  pegSave_grid_row( p95p55.peg_view__d , 'peg_tmp_p95p55', p95p55.peg_view_module  ,p95p55.getMnr01(),  p95p55.getMmnr01(), values ,  function(jsondata){
							  if(jsondata['ok']){
									e.record.data['nr01'] = jsondata.nr01;
									e.record.commit(); 
									core_p95_onChangeModuleP50(container_id);
								}else{
									e.record.reject();
									pegAlert(jsondata.message);
								}
						});
						  
						  
					}
			);
			p95p55.on('canceledit', function(editor, context) {  
				context.record.reject();  
			});
		}
		function core_p95p50_d_p95p50_viewConfigGetRowClass(record, rowIndex, rowParams, store){
			return (record.get("module_en")) ? "" : Ext.baseCSSPrefix+"row-disabled";
		}
		/**
		 * Πίνακες Βάσης Δεδομένων
		 * @param container_id
		 * @returns
		 */
		function core_p95_d02_afterDraw_listeners(container_id){
			var screen	= pegGetCmp(container_id);
			var p95p50	= pegGetCmp(container_id + '_p95p50');
			
			WebApp.view.grid.Grid.peg_enableRowEdit(p95p50);
		
			p95p50.on('beforeEdit', function(  editor , context ){
				
				if(context && context.record){
					var record = context.record;
					return (record.get("module_en"))?true:false;
				}
				return true;
		
			});
		
			p95p50.on(
					'edit',
					function( editor, e){
						 var values = {};
						  values = e.record.getData({serialize:true});
						  if(values && values['nr01']<0){
								values['nr01'] = 0;
							}
						  values.p95 = screen.getNr01(); 
						  pegSave_grid_row( 
								  p95p50.peg_view__d ,
								  'peg_tmp_p95p50' , 
								  p95p50.peg_view_module  ,
								  p95p50.getMnr01(),  
								  p95p50.getMmnr01(), 
								  values ,  
								  function(jsondata){  
										  if(jsondata['ok']){
											e.record.data['nr01'] = jsondata.nr01;
											e.record.commit();
											core_p95_onChangeModuleP50(container_id);
										}else{
											e.record.reject();
											pegAlert(jsondata.message);
										}
								  }
						  ); 
						  
						  
						  
					}
			);
			p95p50.on('canceledit', function(editor, context) {  
				context.record.reject();  
			});
		}
		
		
		function core_p95p80_d_p95p80_viewConfigGetRowClass(record, rowIndex, rowParams, store){ 
			var data = record.getData({serialize:true}); //= record.get("module_en") ; 
			return (
				data['v_module_en'] === 0 || 
				(data['v_module_en'] !== 0  &&  data['v_table_sh'] ===0)
			)?  Ext.baseCSSPrefix+"row-disabled":"";
		}
		/**
		 * Menu Items
		 * @param container_id
		 * @returns
		 */
		function core_p95_d03_afterDraw_listeners(container_id){
			var screen	= pegGetCmp(container_id);
			var p95p80	= pegGetCmp(container_id + '_p95p80');
			
			WebApp.view.grid.Grid.peg_enableRowEdit(p95p80);
		
			p95p80.on('beforeEdit', function(  editor , context ){
				
				if(context && context.record){
					var data = context.record.getData({serialize:true}); //= record.get("module_en") ; 
					return (
						data['v_module_en'] === 0 || 
						(data['v_module_en'] !== 0  && !pegIsEmpty(data['v_table_p01']) && data['v_table_sh'] ===0)
					)? false:true;
				}
				return true;
		
			});
		
			p95p80.on(
					'edit',
					function( editor, e){
						 var values = {};
						  values = e.record.getData({serialize:true});
						  if(values && values['nr01']<0){
								values['nr01'] = 0;
							}
						  values.p95 = screen.getNr01(); 
						  pegSave_grid_row( p95p80.peg_view__d ,'peg_tmp_p95p80' , p95p80.peg_view_module  ,p95p80.getMnr01(),  p95p80.getMmnr01(), values ,  function(jsondata){
							if(jsondata['ok']){
								e.record.data['nr01'] = jsondata.nr01;
								e.record.commit();
							}else{
								e.record.reject();
								pegAlert(jsondata.message);
							}
		//					  e.record.data['nr01'] = jsondata.nr01;
		//					  e.record.commit();
						  }   ); 
						  
						  
						  
					}
			);
			p95p80.on('canceledit', function(editor, context) {  
				context.record.reject();  
			});
		}
		
		
		
		function core_p95p81_d_p95p81_viewConfigGetRowClass(record, rowIndex, rowParams, store){ 
			var data = record.getData({serialize:true}); //= record.get("module_en") ; 
			return (
				data['v_module_en'] === 0 || 
				(data['v_module_en'] !== 0  && !pegIsEmpty(data['v_table_p01']) && data['v_table_sh'] ===0)
			)?  Ext.baseCSSPrefix+"row-disabled":"";
		}
		/**
		 * Toolbar Items
		 * @param container_id
		 * @returns
		 */
		function core_p95_d04_afterDraw_listeners(container_id){
			var screen	= pegGetCmp(container_id);
			var p95p81	= pegGetCmp(container_id + '_p95p81');
			
			WebApp.view.grid.Grid.peg_enableRowEdit(p95p81);
		
			p95p81.on('beforeEdit', function(  editor , context ){
				
				if(context && context.record){
					var data = context.record.getData({serialize:true}); //= record.get("module_en") ; 
					return (
						data['v_module_en'] === 0 || 
						(data['v_module_en'] !== 0  && !pegIsEmpty(data['v_table_p01']) && data['v_table_sh'] ===0)
					)?  false:true;
				}
				return true;
		
			});
		
			p95p81.on(
					'edit',
					function( editor, e){
						 var values = {}; 
						  values = e.record.getData({serialize:true});
						  if(values && values['nr01']<0){
								values['nr01'] = 0;
							}
						  values.p95 = screen.getNr01(); 
						  pegSave_grid_row( p95p81.peg_view__d ,'peg_tmp_p95p81' , p95p81.peg_view_module  ,p95p81.getMnr01(),  p95p81.getMmnr01(), values ,  function(jsondata){
							if(jsondata['ok']){
								e.record.data['nr01'] = jsondata.nr01;
								e.record.commit();
							}else{
								e.record.reject();
								pegAlert(jsondata.message);
							}
		//					  e.record.data['nr01'] = jsondata.nr01;
		//					  e.record.commit();
						  }   ); 
						  
						  
						  
					}
			);
			p95p81.on('canceledit', function(editor, context) {  
				context.record.reject();  
			});
		}
		function core_p95q10_d_p95q10_viewConfigGetRowClass(record, rowIndex, rowParams, store){
			var tmpStore = store;
			if(tmpStore instanceof Ext.grid.feature.GroupStore){
				tmpStore = tmpStore.store;
			}
			if(tmpStore && tmpStore.container_id && !(pegGetCmp(tmpStore.container_id, 'en_q10_perm').getValue())){
				return Ext.baseCSSPrefix+"row-disabled";
			}
			return (record.get("v_module_en")) ? "" : Ext.baseCSSPrefix+"row-disabled";
		}
		/**
		 * π-Αναφορές
		 * @param container_id
		 * @returns
		 */
		function core_p95_d06_afterDraw_listeners(container_id){
			var screen	= pegGetCmp(container_id);
			var p95q10	= pegGetCmp(container_id , 'p95q10');
			var en_q10_perm	= pegGetCmp(container_id , 'en_q10_perm');
			var tb_selectall = pegGetCmp(container_id , 'toolbarbutton_selectall');
			var tb_deselectall = pegGetCmp(container_id , 'toolbarbutton_deselectall');
		
			var en_q10_permVal = screen.peg_getData('en_q10_perm');
		
			if(en_q10_permVal){
				// WebApp.view.grid.Grid.peg_enableRowEdit(p95q10);
				WebApp.view.grid.Grid.peg_setEditableHidden( p95q10, false,true );
				WebApp.view.grid.Grid.peg_enableRowEdit(p95q10);
				tb_selectall.setDisabled(false);
				tb_deselectall.setDisabled(false);
				
			}else{
				// WebApp.view.grid.Grid.peg_disableRowEdit(p95q10);
				WebApp.view.grid.Grid.peg_setEditableHidden( p95q10, true,true );
				WebApp.view.grid.Grid.peg_disableRowEdit(p95q10);
				tb_selectall.setDisabled(true);
				tb_deselectall.setDisabled(true);
			}
		
		
			en_q10_perm.on('change', function( me, newValue, oldValue, eOpts ) {
				if(newValue==oldValue){
					return false;
				}
				if(newValue){
					WebApp.view.grid.Grid.pegGridRefresh(p95q10);
					WebApp.view.grid.Grid.peg_setEditableHidden( p95q10, false,true );
					WebApp.view.grid.Grid.peg_enableRowEdit(p95q10);
					tb_selectall.setDisabled(false);
					tb_deselectall.setDisabled(false);
				}else{
					WebApp.view.grid.Grid.pegGridRefresh(p95q10);
					WebApp.view.grid.Grid.peg_setEditableHidden( p95q10, true,true );
					WebApp.view.grid.Grid.peg_disableRowEdit(p95q10);
					tb_selectall.setDisabled(true);
					tb_deselectall.setDisabled(true);
				}
				
				
		
			});
			p95q10.on('beforeEdit', function(  editor , context ){
				
				if(context && context.record){
					var data = context.record.getData({serialize:true});  
					if( !( en_q10_perm.getValue() )){
						return false;
					}
					return (data["v_module_en"]) ? true:false; 
				}
				return true;
		
			});
		
			p95q10.on(
					'edit',
					function( editor, e){
						var values = {}; 
							values = e.record.getData({serialize:true});
						if(values && values['nr01']<0){
							values['nr01'] = 0;
						}
						values.p95 = screen.getNr01(); 
						pegSave_grid_row( 
							  p95q10.peg_view__d ,
							  'peg_tmp_p95q10' , 
							  p95q10.peg_view_module  ,
							  p95q10.getMnr01(),  
							  p95q10.getMmnr01(), 
							  values ,  
							  function(jsondata){
								if(jsondata['ok']){
									e.record.data['nr01'] = jsondata.nr01;
									e.record.commit();
								}else{
									e.record.reject();
									pegAlert(jsondata.message);
								}
			//					  e.record.data['nr01'] = jsondata.nr01;
			//					  e.record.commit();
							}   
						);
					}
			);
			p95q10.on('canceledit', function(editor, context) {  
				context.record.reject();  
			});
		}
		
		/**
		 * Profile.
		 * @param container_id
		 * @param gridName 
		 * @param type enum {module, p80,p81, p50}
		 * @param actionType enum{add, 	remove}
		 * @returns
		 */
		function core_p95_d_grid_action(container_id, gridName,  type, actionType){
			// var p95_container_id = pegGetContainer_id_d(container_id , 'p95_d'   , '' , 'p95_d' );
			var screen	= pegGetCmp(container_id);
			var action = 0; 
			
		
			
			if(actionType == 'add'){
				action = 1;
			}
			
			var params	= {
					type:  type,
					action:action,
					p95: screen.getNr01(),
					mmnr01: screen.getMmnr01(),
					mnr01: screen.getMnr01(),
					gridname: gridName,
					container_id: container_id
				};
			
		
			if(type =='p50'){
				params['ins00'] = ( pegGetVal('ins' , container_id)==true)?1:0 ;
				params['del00'] =  ( pegGetVal('del' , container_id)==true)?1:0 ;//  pegGetVal('del' , container_id) ;
				params['chan00'] =   ( pegGetVal('chan' , container_id)==true)?1:0 ;//pegGetVal('chan' , container_id) ;
				params['sh00'] =   ( pegGetVal('sh' , container_id)==true)?1:0 ;//pegGetVal('sh' , container_id) ;
			}else if(type == 'q10'){
				params['en_q10_perm'] = ( pegGetVal('en_q10_perm' , container_id)==true)?1:0 ;
			}
			
			var grid =  pegGetCmp(screen.getContainer_ID() + '_' + gridName);
			
			grid.mask();
			pegAjax(
					'/' + main_path+ '/core01/update_profiles_data.php' ,
					params,
					function(jsondata){
						if(!(grid.isDestroyed)){
							if(grid.masked){
								grid.unmask();
							}
							if(jsondata && jsondata.ok==1){
								WebApp.view.grid.Grid.pegGridRefresh(grid) ; 
								core_p95_onChangeModuleP50(container_id);
							}else if(!pegIsEmpty(jsondata.msg)){
								pegAlert(jsondata.msg);
							}
		
						}
					});
		}
		/**
		 * Οµάδες Χρηστώ tab Profile Χρηστών
		 * @param {String} container_id
		 * @returns
		 */
		function core_p97_d01_afterDraw_listeners( container_id ){
		
			var p97_container_id =  pegGetContainer_id_d(container_id , 'p97_d' , '' , 'p97_d' );
			var grid = pegGetCmp(container_id , 'p97p95');
			   
			   if(!grid){
				   pegAlert(' Grid not found the screen id is [' + p97_container_id +'] Screen: p97_d01');
				   console.log(grid);
				   return;
			   }
				
			grid.peg_preventDefault_itemdblclick = true; 
			WebApp.view.grid.Grid.peg_enableRowEdit(grid);
		
			
			grid.on('edit', function(editor, context) {  
				  var values = {};
				  values  	= context.record.getData({serialize:true}); 	
				  if(values && values['nr01']<0){
					values['nr01'] = 0;
				}
				  values.p97  = pegGetVal( 'nr01' , p97_container_id);
				  pegSave_grid_row( 
						  grid.peg_view__d ,
						  grid.peg_view_table , 
						  grid.peg_view_module  ,
						  grid.getGridMnr01(),  
						  grid.getMmnr01(), 
						  values , 
						  function(jsonData){   
							if(jsonData.ok){ 
								context.record.data['nr01'] = jsonData.nr01;		
								context.record.commit();
								//console.log(context.record);
							  }else{
								  context.record.reject();
								  pegAlert(jsonData.message);
							  }
						  }
				  ); 
					   
			  });
		
			  grid.on('canceledit', function(editor, context) {  
				  context.record.reject();  
			  });
				  
			
		}
		/**
		 * Οµάδες Χρηστώ tab Δικαιόματα
		 * @param {String} container_id
		 * @returns
		 */
		function core_p97_d02_afterDraw_listeners(container_id){
			
			p97_container_id =  pegGetContainer_id_d(container_id , 'p97_d' , '' , 'p97_d' );
			console.info('p97_container_id', p97_container_id);
			var grid = pegGetCmp(container_id , 'p97p96');
			
			   if(!grid){
				   pegAlert(' Grid not found the screen id is [' + p97_container_id +'] Screen: p97_d02');
				   console.log(grid);
				   return;
			   }
						
			grid.peg_preventDefault_itemdblclick = true; 
			WebApp.view.grid.Grid.peg_enableRowEdit(grid);
			
			grid.on('edit', function(editor, context) {  
				  var values = {};
				  values = context.record.getData({serialize:true}); 	
				  if(values && values['nr01']<0){
					values['nr01'] = 0;
				}
				  values.p97  = pegGetVal( 'nr01', p97_container_id); 		
				  pegSave_grid_row( 
						  grid.peg_view__d ,
						  grid.peg_view_table , 
						  grid.peg_view_module  ,
						  grid.getGridMnr01(),  
						  grid.getMmnr01(), 
						  values , 
						  function(jsonData){   
							  if(jsonData.ok){ 
								context.record.data['nr01'] = jsonData.nr01;		
								context.record.commit();
								//console.log(context.record);
							  }else{
								  context.record.reject();
								  pegAlert(jsonData.message);
							  }
						  }
				  ); 
			  });
		
			  grid.on('canceledit', function(editor, context) {  
				  context.record.reject();  
			  });
		}	
		
		
		
		function core__auto_unlock_d00_afterDraw_listeners(container_id){
			var screen	= pegGetCmp(container_id);
			var but01	= pegGetCmp(container_id + '_but01');
			
			but01.setHandler(function(){
				pegAjax('/' + main_path + '/core_exec/exec00.php' , 
					{'new_sn': pegGetVal('sn' , container_id)} , 
					function(jsonData){
						
						if(jsonData.ok==1){	
							pegWindowClose(screen.peg_winid);
							// pegAlert(jsonData.msg)
							pegGetDic( 
									'peg_dic_core_should_refresh_app' , 
									function(desc00){ 
										var msg  = jsonData.msg  + desc00;
										pegConfirmBox( 
												'', 
												msg , 
												function(but){
													if(but=='yes'){ 
														location.reload(true);
													} 
												}
										);	
									});
		
						}else{
							pegAlert(jsonData.msg)
						}
					} , 
					'json' , 
					'1' 
				);
			});
		}
		
		
		function core__help_d_afterDraw_listeners(container_id){
			var screen = pegGetCmp(container_id); 
			var treemenu = pegGetCmp(container_id + '_treemenu');
		
			treemenu.on('itemclick',function( me, record, item, index, e, eOpts ){ 
				var _d = record.raw.view_d;
				var module = record.raw.view_module; 
				
				peg002_mask(container_id + '_help');
					
				if( (!pegIsEmpty(_d)) && (!pegIsEmpty(module)) ){
					pegAjax('/' +main_path + '/core_global/help.php?_d=' + _d +'&module='+ module + '&mmnr01=' + _d + '-', {} ,
					function(json_data){
						if(peg002_IsMobileOrTabletScreen()){
							pegAddTab_d('','','_help_text_d','core','',0,'',{'help':json_data.message});
						}else{
							Ext.getCmp(container_id + '_help').update(json_data.message);
						}
						peg002_unmask(container_id + '_help');
					});
				}else{
					peg002_unmask(container_id + '_help');
				}
			});
			var treemenuStore=treemenu.getStore();
			var qstring=pegGetCmp(container_id,'qstring');
			
			qstring.on('change', function (field, newValue, oldValue) {
				if(treemenuStore.isLoading()){
					return true;
				}
				var searchString = newValue; 
					searchString = searchString.toLowerCase();
					searchStringGR = peg_strGreekToGreekenglish(searchString);
				if (searchString.length < 1) {
					treemenuStore.clearTreeFilter();
							treemenu.collapseAll();
				}else{
					var regexps00 = Ext.Array.map(searchString.split(/\s+/), function (token) {
							return new RegExp(Ext.String.escapeRegex(searchString), 'i');
						});
					var regexps01; 
					if(searchString!=searchStringGR){
							regexps01 = Ext.Array.map(searchStringGR.split(/\s+/), function (token) {
								return new RegExp(Ext.String.escapeRegex(searchStringGR), 'i');
							});				
					}else{
						regexps01 = regexps00;
					}
					var length = regexps00.length;
					 treemenuStore.filterTreeBy(function (resource) {
						var text = peg_strGreekToGreekenglish( resource.get('text').toLowerCase() ); 
						var ret=peg_strGreekToLatinCheck(text);
						if(resource.parentNode){
							if(resource.parentNode.get('text')){
								var ret2=peg_strGreekToLatinCheck(resource.parentNode.get('text'));
								for (var i = 0; i < ret2.length; i++){
									for (var ii = 0; ii < length; ii++){
										if(regexps01[ii].test(ret2[i])){return true;} 
									}
								}
								for (var i = 0; i < ret.length; i++){
									for (var ii = 0; ii < length; ii++){
										if(regexps01[ii].test(ret[i])){return true;} 
									}
								} 
							}
						}
						return false;
					});   
				}
			});
		}
		function core__help_text_d_afterDraw_listeners(container_id){
			var bt_close	= pegGetCmp(container_id , 'bt_close');
			bt_close.setHandler(function(){
				pegTabClose(pegGetCmp(container_id).peg_tabid)
		
			});
		}
		
		function core_cor000_d_afterDraw_listeners(container_id){
			var screen	= pegGetCmp(container_id);
			var smtp_but	= pegGetCmp(container_id + '_smtp_but');
			var debug_ip_bt	= pegGetCmp(container_id + '_debug_ip_bt');
			var add_ip_bt	= pegGetCmp(container_id + '_add_ip_bt');
			var btn_ulock_upd_mutex	= pegGetCmp(container_id, 'btn_ulock_upd_mutex');
			
			smtp_but.setHandler(function(){
				core_smtp_check(container_id, 'cor000');
			});
			debug_ip_bt.setHandler(function(){
				core_show_my_ip();
			});
			add_ip_bt.setHandler(function(){
				if(core_show_my_ip_ajax ){
					if(core_show_my_ip_ajax.id0){
						Ext.ux.AjaxDefer.abort(core_show_my_ip_ajax);
					}
				}
	
				core_show_my_ip_ajax = pegAjaxDefer('/' + main_path + '/core06/show_my_ip.php' , {} , 
					function(jsondata){
						if(jsondata.ok){
							var vdebug_ip_val=pegGetVal('vdebug_ip',container_id);
							var ips=vdebug_ip_val.split(',');
							if(ips.filter(ip=>{return ip==jsondata.ip}).length==0){
								pegSetVal('vdebug_ip',container_id,vdebug_ip_val+(pegIsEmpty(vdebug_ip_val)?'':',')+jsondata.ip);	
								pegGetDic('peg_dic_core_ip_added', function(desc){ pegToast(desc,'success');});

							}else{
								pegGetDic('peg_dic_core_ip_already_added', function(desc){ pegToast(desc,'alert');}); 
							}
							core_show_my_ip_ajax = null;
						}
					});
			});
			btn_ulock_upd_mutex.setHandler(function(){
				pegAjax('/' + main_path + '/core01/update_app_unlock_mutex.php' ,{},function(jsonData){
					if(jsonData.ok){
						pegSetVal('v_active_update',container_id,'');
						pegToast(jsonData.msg);
					}
				});
			});
			
			
		}
		function core__module_d00_afterDraw_listeners(container_id){
			var screen	= pegGetCmp(container_id);
			var butt	= pegGetCmp(container_id + '_butt');
			var progress_bar	= pegGetCmp(container_id + '_progress_bar');
			
			butt.setHandler(function(){
				
				progress_bar.wait();
				pegAjax(
						'/'+main_path+'/core_update/update.php' , 
						{'step':'login_to_tesae'} , 
						function(jsonData){
					
							//login to tesae
							if(jsonData.ok==1){
								progress_bar.updateProgress( '1', jsonData.message, true );			
								pegAjax(
										'/'+main_path+'/core_update/update.php' , 
										{'step':'validate_sn'} , 
										function(jsonData){
							
											//validate sn
											if(jsonData.ok==1){
												progress_bar.updateProgress(  '1', jsonData.message, true );
												pegAjax(
														'/'+main_path+'/core_update/update.php' , 
														{'step':'get_modules'} , 
														function(jsonData){
									
															// innstall files
															if(jsonData.ok==1){
																progress_bar.updateProgress( '1', jsonData.message, true );
																progress_bar.reset();
										
																Ext.getCmp(container_id+'_p30').update(jsonData.ret_html);
										
																// pegAlert( jsonData.message );
																// 	pegWindowClose('" . pegasus_container_id_get_parent($this->container_id) . "');
															}else{
																pegAlert( jsonData.message );
																progress_bar.reset();
															}
									
														} , 'json' , 0  ,true);
											}else{
												pegAlert( jsonData.message );
												progress_bar.reset();
												pegWindowClose(screen.peg_winid);
											}
										} , 'json' , 0 ,true );
												
							}else{	
								pegAlert( jsonData.message );
								progress_bar.reset();
								pegWindowClose(screen.peg_winid);
							}
						} , 'json' , 0  ,true);	
			});
		}
		
		function core__upd_app_d00_progress_bar_action(me){
			var screen	= pegGetCmp(me.getContainer_ID());
			var parent	= screen.getParent_ID();
			// if(me.peg_task && typeof me.peg_task.start == "function"){
			// 	me.peg_task.start();							
			// }
				
			
			pegAjax(
					'/'+main_path+'/core_update/update.php' , 
					{'step':'login_to_tesae',
					 'check_platform': 1
					} , 
					function(jsonData){
				
						if(me && jsonData){
							// me.wait();
							//login to tesae
							if(jsonData.ok==1){ 
								me.peg_progress=1/3;
								me.peg_messsage=jsonData.message;
								me.updateProgress( 1/3, jsonData.message, true );
								pegAjax(
										'/'+main_path+'/core_update/update.php' , 
										{'step':'validate_sn'} , 
										function(jsonData){
						
											//validate sn
											if(jsonData.ok==1){ 
												me.peg_progress=2/3;
												me.peg_messsage=jsonData.message;
												me.updateProgress(2/3,jsonData.message, true);  
												pegAjax(
														'/'+main_path+'/core_update/update.php' , 
														{'step':'check_module'} , 
														function(jsonData){
										
															//check module
															if(jsonData.ok==1){
																//	alert('check_module_ok	');	
																
																me.peg_progress=1;
																me.peg_messsage=jsonData.message;
																me.updateProgress(1,jsonData.message, true); 
																// if(me.peg_task && typeof me.peg_task.stop == "function"){
																// 	me.peg_task.stop();							
																// }
																pegWindowClose(screen.peg_winid);	
																peg_windowShow_d( 
																		'', 
																		'_upd_app_d01' , 
																		'core' , 
																		parent , 
																		'', 
																		0, 
																		'',  
																		'', 
																		{  } , 
																		true , 
																		true
																	);
															}else{
																// me.reset();
																// if(me.peg_task && typeof me.peg_task.stop == "function"){
																// 	me.peg_task.stop();							
																// }
																pegMsgBox( jsonData.message );
																pegAjax('/' + main_path + '/core01/update_app_unlock_mutex.php' ,{});
																pegWindowClose(screen.peg_winid);	
															}
														} , 'json' , 0  ,true);
											}else{
												me.reset();
												if(me.peg_task && typeof me.peg_task.stop == "function"){
													me.peg_task.stop();							
												}
												pegAlert( jsonData.message );
												
												pegWindowClose(screen.peg_winid);
											}
										} , 'json' , 0 ,true );
											
							}else{
								me.reset();
								if(me.peg_task && typeof me.peg_task.stop == "function"){
									me.peg_task.stop();							
								}
								pegAlert( jsonData.message );
								
								pegWindowClose(screen.peg_winid);
							}
						}else{
							me.reset();
							if(me.peg_task && typeof me.peg_task.stop == "function"){
								me.peg_task.stop();							
							}
		
						}
					} , 'json' , 0  ,true);
			 
		}
		function core__upd_app_d00_afterDraw_listeners(container_id){
			var screen	= pegGetCmp(container_id);
			var parent	= screen.getParent_ID();
			var progress_bar	= pegGetCmp(container_id + '_progress_bar');
			progress_bar.setFlex(1);
		
			 core__upd_app_d00_progress_bar_action(progress_bar);
		}
		function core__upd_app_d01_afterDraw_listeners(container_id){
			var screen	= pegGetCmp(container_id);
			var parent	= screen.getParent_ID();
			var progress_bar	= pegGetCmp(container_id + '_progress_bar');
			screen.on('destroy',function(){ 
				pegAjax('/' + main_path + '/core01/update_app_unlock_mutex.php' ,{});
			});
			progress_bar._upd_updateTaskRunner = function (){ 
			  
				// if(progress_bar.isDestroyed || progress_bar.wait()==false){
				// 	progress_bar.peg_task.stop();
				// }
				//console.log('test');
				pegAjax(
						'/' + main_path + '/core_update/update_task.php' , 
						{} , 
						function(jsondata){
							core_update_progressbar_text(progress_bar,jsondata.text);
						}
				 );
			 }	
			
			 var _upd_runner = new Ext.util.TaskRunner();
			 progress_bar.peg_task = _upd_runner.newTask({
				 run: progress_bar._upd_updateTaskRunner,
				 interval: 1500 	 
			 }); 
		}
		

		function core_pegapi02_d_afterDraw_listeners(container_id){ 
			var screen = pegGetCmp(container_id);
			var grid = pegGetCmp(container_id+ '_grid_pegapi11');
			 
			grid.record_change = function(me, row) {
				var nr01=row.nr01;
				
				if(nr01<1){
					nr01 = 0;
				}
		
				var tmpPegapi01 = screen.peg_getData('pegapi01');
				var params00 = {
					mmnr01:me.getMmnr01(),
					mnr01: me.getGridMnr01(), 
					field_name: row.field_name, 
					peg_screen_parent_element_name: me.name,
					peg_screen_parent_container_id: me.getContainer_ID()
				  };
				if(!pegIsEmpty(tmpPegapi01) && tmpPegapi01>0 ){
					return peg_windowShow_d( 
						'peg_tmp_pegapi11' ,
						me.peg_view__d , 
						me.peg_view_module , 
						screen.getContainer_ID() , 
						'' , 
						nr01 , 
						me.store.url_vars00  ,  
						'c-c' , params00 
					);
				}else{
		
					return pegAddTab_d(
						'' , 
						'peg_tmp_pegapi11' , 
						me.peg_view__d , 
						me.peg_view_module , 
						'' , 
						nr01 , 
						me.store.url_vars00 , 
						params00
					);
				}
				 
		
			}
		
			grid.record_insert = function(me){
				var tmpModule = screen.peg_getData('module');
				var tmpAction = screen.peg_getData('action');
				
				
				return pegAddTab_d(
					'' , 
					'peg_tmp_pegapi11' , 
					me.peg_view__d , 
					me.peg_view_module , 
					'' , 
					0 , 
					me.store.url_vars00 , 
					{
					  mmnr01:me.getMmnr01(),
					  mnr01: me.getGridMnr01(), 
					  mmodule: tmpModule, 
					  maction:tmpAction,
					  peg_screen_parent_element_name: me.name,
					  peg_screen_parent_container_id: me.getContainer_ID()
					}
				  );
			}
			
		}
		
		
		