<?php
class core00AppHealthDynamic extends AppHealthScenario
{
	public function check()
	{
        if(strpos($_SERVER['SERVER_NAME'],'pegcloud.io')===false){
            return array(
                'ok'	=> 1,
                'data'	=> array(
                    'status'	=> true,
                    'muted'		=> true
                ),
                'msg'	=> "Pass"
            );
        }
        $res=pegasus_query('show variables like "innodb_default_row_format"');
        if(!$res){
            return array(
                'ok'	=> 1,
                'data'	=> array(
                    'status'	=> true,
                    'muted'		=> true
                ),
                'msg'	=> "Pass"
            );
        }
        $innodb_default_row_format=pegasus_fetchall( $res);
        if($innodb_default_row_format[0]['Value']!="dynamic"){
            return array(
                'ok'	=> 1,
                'data'	=> array(
                    'status'	=> true,
                    'muted'		=> true
                ),
                'msg'	=> "Pass"
            );
        }

       $query= 'SHOW TABLE STATUS where Row_format not like "Dynamic" and Engine like "InnoDB"';
        $result= pegasus_query($query);
        while ($res = pegasus_fetch($result)){
            $tables[] =  $res['Name'];
        }
        if(!empty($tables)){
            $message= $_SESSION['peg_dic_core00_app_health_dynamic_row_format'];
            return array(
                'ok'	=> 1,
                'data'	=> array(
                    'status'	=> false,
                    'message' => $message,
                    'p92'		=> 140000136000001
                ),
                'msg'	=> "Fail"
            );
    
        }else{

            return array(
                'ok'	=> 1,
                'data'	=> array(
                    'status'	=> true,
                    'muted'		=> true
                ),
                'msg'	=> "Pass"
            );

        }


     }

}