<?php

class Core00Field extends Core00Element
{
}
class Core00Numberbox extends Core00Field
{
	public function __construct(
		$title,
		$eTitle,
		$name,
		$browseIndex = 0,
		$size = 15,
		$decimals = 0,
		$is_variable = false,
		$propertyBrowseIndex = 0
	) {
		parent::__construct(
			$title,
			$eTitle,
			$name,
			$browseIndex,
			$size,
			$decimals,
			$propertyBrowseIndex
		);
		$this->field_type = "N";
		if ($is_variable) {
			$this->field_type = "V";
		}
		$this->view_type = "numberbox";
	}
}

class Core00Datebox extends Core00Field
{
	public function __construct(
		$title,
		$eTitle,
		$name,
		$browseIndex = 0,
		$size = 10,
		$decimals = 0,
		$is_variable = false,
		$propertyBrowseIndex=0
	) {
		parent::__construct(
			$title,
			$eTitle,
			$name,
			$browseIndex,
			$size,
			$decimals,
			$propertyBrowseIndex
		);

		$this->field_type = "D";
		if ($is_variable) {
			$this->field_type = "V";
		}
		$this->view_type = "datebox";
	}
}

class Core00Checkbox extends Core00Field
{
	public function __construct(
		$title,
		$eTitle,
		$name,
		$browseIndex = 0,
		$size = 1,
		$decimals = 0,
		$is_variable = false,
		$propertyBrowseIndex = 0
	) {
		parent::__construct(
			$title,
			$eTitle,
			$name,
			$browseIndex,
			$size,
			$decimals,
			$propertyBrowseIndex
		);

		$this->field_type = "L";
		if ($is_variable) {
			$this->field_type = "V";
		}
		$this->view_type = "checkbox";
	}
}

class Core00Textbox extends Core00Field
{
	public function __construct(
		$title,
		$eTitle,
		$name,
		$browseIndex = 0,
		$size = 40,
		$decimals = 0,
		$is_variable = false,
		$propertyBrowseIndex = 0
	) {
		parent::__construct(
			$title,
			$eTitle,
			$name,
			$browseIndex,
			$size,
			$decimals,
			$propertyBrowseIndex
		);

		$this->field_type = "C";
		if ($is_variable) {
			$this->field_type = "V";
		}
		$this->view_type = "textbox";
	}
}
class Core00Textarea extends Core00Field
{
	public function __construct(
		$title,
		$eTitle,
		$name,
		$browseIndex = 0,
		$size = 40,
		$decimals = 0,
		$is_variable = false,
		$propertyBrowseIndex = 0
	) {
		parent::__construct(
			$title,
			$eTitle,
			$name,
			$browseIndex,
			$size,
			$decimals,
			$propertyBrowseIndex
		);

		$this->field_type = "M";
		if ($is_variable) {
			$this->field_type = "V";
		}
		$this->view_type = "textarea";
	}
}
class Core00Memo extends Core00Field
{
	public function __construct($title, $eTitle, $name, $browseIndex = 0, $size = 10, $decimals = 0, $is_variable = false)
	{
		parent::__construct($title, $eTitle, $name, $browseIndex, $size, $decimals);

		$this->field_type = "M";
		if ($is_variable) {
			$this->field_type = "V";
		}
		$this->view_type = "textbox";
	}
}

class Core00Tinymce extends Core00Field
{
	public function __construct($title, $eTitle, $name, $browseIndex = 0, $size = 0, $decimals = 0, $is_variable = false)
	{
		parent::__construct($title, $eTitle, $name, $browseIndex, $size, $decimals);

		$this->field_type = "M";
		if ($is_variable) {
			$this->field_type = "V";
		}
		$this->view_type = "tinymce";
	}
}

class Core00Pie extends Core00Field
{
	public function __construct($title, $eTitle, $name, $browseIndex = 0, $size = 0, $decimals = 0)
	{
		parent::__construct($title, $eTitle, $name, $browseIndex, $size, $decimals);

		$this->field_type = "V";
		$this->view_type = "polarchart";
	}
}


class Core00Cartesian extends Core00Field
{
	public function __construct($title, $eTitle, $name, $browseIndex = 0, $size = 0, $decimals = 0)
	{
		parent::__construct($title, $eTitle, $name, $browseIndex, $size, $decimals);

		$this->field_type = "V";
		$this->view_type = 'cartesianchart';
	}
}
class Core00FileUpload extends Core00Field
{
	public function __construct($title, $eTitle, $name, $browseIndex = 0, $size = 0, $decimals = 0, $is_variable = false)
	{
		parent::__construct($title, $eTitle, $name, $browseIndex, $size, $decimals);

		$this->field_type = "X";
		if ($is_variable) {
			$this->field_type = "V";
		}
		$this->view_type = 'fileUpload';
	}
}

class Core00FieldSet extends Core00Element
{
	public function __construct($title, $eTitle, $name, $browseIndex = 0, $size = 0, $decimals = 0)
	{
		parent::__construct($title, $eTitle, $name, $browseIndex, $size, $decimals);

		$this->field_type = "";
		$this->view_type = 'fieldSet';
	}
	public function addResponsiveConfig()
	{
		$respConfig =
			'{  "small" : {
			"layout" :{
			"type" : "box",
			"vertical": true,
				"align":"stretch"
			}
		},
		"medium || large" : {
			"layout" :{
			"type" : "box",
			"vertical": false
			}
		}
	}';
		$this->addP52('responsiveConfig', array('par_val' => $respConfig));
	}
}

class Core00PanelFieldset extends Core00Element
{
	public function __construct($title, $eTitle, $name, $browseIndex = 0, $size = 0, $decimals = 0)
	{
		parent::__construct($title, $eTitle, $name, $browseIndex, $size, $decimals);

		$this->field_type = "";
		$this->view_type = 'PanelFieldset';
	}
	public function addResponsiveConfig()
	{
		$respConfig =
			'{  "small" : {
				"layout" :{
				"type" : "box",
				"vertical": true,
					"align":"stretch"
				}
			},
			"medium || large" : {
				"layout" :{
				"type" : "box",
				"vertical": false
				}
			}
		}';
		$this->addP52('responsiveConfig', array('par_val' => $respConfig));
	}
}

class Core00FieldContainer extends Core00Element
{
	public function __construct($title, $eTitle, $name, $browseIndex = 0, $size = 0, $decimals = 0)
	{
		parent::__construct($title, $eTitle, $name, $browseIndex, $size, $decimals);

		$this->field_type = "";
		$this->view_type = 'fieldcontainer';
	}
	public function addResponsiveConfig()
	{
		$respConfig =
			'{  "small" : {
				"layout" :{
				"type" : "box",
				"vertical": true,
					"align":"stretch"
				}
			},
			"medium || large" : {
				"layout" :{
				"type" : "box",
				"vertical": false
				}
			}
		}';
		$this->addP52('responsiveConfig', array('par_val' => $respConfig));
	}
}

class Core00Combobox extends Core00Element
{
	public function __construct($title, $eTitle, $name, $valueField, $displayField, $ls_data, $ls_data_eng, $field_type = '', $browseIndex = 0, $size = 0, $decimals = 0)
	{
		parent::__construct($title, $eTitle, $name, $browseIndex, $size, $decimals);

		$this->field_type = $field_type;
		$this->view_type = 'combobox';

		$this->addP52('ls_data', array('par_val' => $ls_data, 'epar_val' => $ls_data_eng));
		$this->addP52('displayField', array('par_val' => $displayField));
		$this->addP52('valueField', array('par_val' => $valueField));
	}
}

class Core00SelectBox extends Core00Element
{
	public function __construct($title, 
								$eTitle,  
								$name, 
								$type, 
								$module, 
								$table, 
								$_d, 
								$valueField, 
								$displayField, 
								$orderby, 
								$wherePHP='', 
								$where='',
								$browseIndex = 0, 
								$size = 15, 
								$propertyBrowseIndex = 0
							   )
	{
		parent::__construct($title, $eTitle, $name, $browseIndex, $size, 0, $propertyBrowseIndex);
		$this->field_type = $type;
		$this->view_type = 'comboboxV2';

		if (empty($displayField)) {
			$displayField = $valueField;
		}
		if(!empty($wherePHP)){
			$this->addP52('where', array('par_val' => $wherePHP, 'code' =>1));
		}
		else{
			$this->addP52('where', array('par_val' => $where, 'code' =>0));
		}
		$this->addP52('table', array('par_val' => $table));
		$this->addP52('module', array('par_val' => $module));
		$this->addP52('_d', array('par_val' => $_d));
		$this->addP52('displayField', array('par_val' => $displayField));
		$this->addP52('valueField', array('par_val' => $valueField));
		$this->addP52('orderby', array('par_val' => $orderby));
	}
}
class Core00MultiSelectBox extends Core00Element
{
	public function __construct($title, $eTitle, $name, $module, $table, $_d, $valueField, $displayField, $orderby, $wherePHP, $p_report = '')
	{
		parent::__construct($title, $eTitle, $name, 0, 0, 0);
		$this->field_type = "M";
		$this->view_type = 'multi_selectbox';

		if (empty($displayField)) {
			$displayField = $valueField;
		}

		$this->addP52('where', array('par_val' => $wherePHP, 'code' => 1));
		$this->addP52('table', array('par_val' => $table));
		$this->addP52('module', array('par_val' => $module));
		$this->addP52('_d', array('par_val' => $_d));
		$this->addP52('multi_selectbox_displayField', array('par_val' => $displayField));
		$this->addP52('multi_selectbox_valueField', array('par_val' => $valueField));
		$this->addP52('orderby', array('par_val' => $orderby));
		$this->addP52('request_params', array('par_val' => 'q10_d90_'.$p_report.'_d'));
	}
}
