<?php
class core00_external_logging
{
	private static $api_key = '8d931c7bca257de2b5e7df45f0dc8905';
	/**
	 *
	 * @param  integer $is_error	Αν είναι error ή όχι (1-0)
	 * @param  string  $type		Ο τύπος του λάθους (format = module:function:error)
	 * @param  string  $user		Ο Χρήστης
	 * @param  ?string  $request	Το Request (Αν υπάρχει)
	 * @param  ?string  $response	Το Response (Αν υπάρχει)
	 * @param  ?string  $message	Το Message (Αν υπάρχει)
	 * @return boolean
	 */
	public static function send(
		$is_error = 0,
		$type = 'external_logging:send:Uknown',
		$user = 'Uknown',
		$request = null,
		$response = null,
		$message = null,
		$attributes = array()
	) : bool {
		//	Αν δεν έχει οριστεί API Key ή αν έχει οριστεί να μην καταγράφει τότε δεν καταγράφει.
		if (
			empty(self::$api_key)
			|| (
				isset($_SESSION['cor000_dis_log_send'])
				&& $_SESSION['cor000_dis_log_send'] == 1
			)
		) {
			return false;
		}
		//	Αρχικοποίηση τιμών
		$client_ip = $_SERVER['REMOTE_ADDR'];
		$service = 'webapp_code';
		$error = 0;
		if ($is_error == 1) {
			$error = 1;
		}
		$document = array(
			'error'		=> $error,
			'type'		=> $type,
			'user'		=> $user,
			'client_ip'	=> $client_ip,
			'service'	=> $service,
			'sn'		=> pegasus_get_app_sn(),
			'app_code'	=> $_SESSION['cor000_app_code'],
			'status'	=> $error ? 'error':'success'
		);
		if (!empty($request)) {
			$document['request']  = $request;
		}
		if (!empty($response)) {
			$document['response']  = $response;
		}
		if (!empty($message)) {
			$document['message']  = $message;
		}
		// attributes
		if(!empty($attributes['service-host'])) {
			$document['service-host'] = $attributes['service-host'];
		}
		if(!empty($attributes['host'])) {
			$document['host'] = $attributes['host'];
		}
		if(!empty($attributes['pnr01'])) {
			$document['pnr01'] = $attributes['pnr01'];
		}
		if(
			!empty($attributes['pos_protocol']) 
			|| $attributes['pos_protocol'] === 0
			|| $attributes['pos_protocol'] === '0'

		) {
			$document['pos_protocol'] = self::pos_protocol_translate($attributes['pos_protocol']);
		}
		if(!empty($attributes['p_sign'])) {
			$document['p_sign'] = $attributes['p_sign'];
		}
		$service_url = 'https://http-intake.logs.datadoghq.eu/api/v2/logs';
		$headers = array(
			'Content-Encoding: identity',
			'Content-Type: application/json',
			'Accept: application/json',
			'DD-API-KEY: '.self::$api_key
		);
		$options = array(
			CURLOPT_URL => $service_url,
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => '',
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 5,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => 'POST',
			CURLOPT_POSTFIELDS => json_encode($document),
			CURLOPT_HTTPHEADER => $headers,
			CURLOPT_SSL_VERIFYPEER => false
		);
		$curl = curl_init();
		curl_setopt_array($curl,$options);
		$response = curl_exec($curl);
		curl_close($curl) ;
		if($response === false) {
			return false;
		}
		return true;
	}
	static function pos_protocol_translate($pos_protocol) {
		switch($pos_protocol) {
			case '0' :
				return 'Mellon Web ECR';
			break;
			case '1' :
				return 'ΕDPS Json Protocol';
			break;
			case '2' :
				return 'Viva Wallet';
			break;
			case '3' :
				return 'Cardlink (6.3)';
			break;
			case '4' :
				return 'Euronet Web ECR';
			break;
			case '999' :
				return 'Demo POS';
			break;
			default :
				return $pos_protocol;
		}
	}
}
