<?php


/**
 * Η κλάση αυτή αναλαμβάνει να βρει τους κοινούς πίνακες για μεταφορά  
 * Καλεί την core00_TableTransfer->exec για καθένα πίνακα 
 * Αν βρει core00_TableTransfer_{όνομα πίνακα} χρησιμοποιεί αυτήν την κλάση
 */
class core00_p92Action_Transfer extends p92Action
{
    private $list_of_tables = array();
    private $given_tables_by_user       = '';
    private $excluded_tables_by_user    = '';
    private $current_table_index;
    private $pdo;
    private $is_local;
    private $only_append = false;


    public function exec()
    {

        $error_message = $this->init();

        if (!empty($error_message)) {
            return $this->return_abort_result($error_message);
        }

        $table = $this->get_current_table();
        $class_of_table_action = $this->find_class($table);

        if (!class_exists($class_of_table_action)) {
            return $this->return_abort_result("Class '" . $class_of_table_action . "' does not exist. Executed for table: " . $table);
        }
        $transfer_only_sme = in_array($table, $this->sme_tables());
        $aa = new $class_of_table_action($table, $this->pdo, $transfer_only_sme, $this->only_append);

        $action_result = $aa->exec();
        $this->write_progress_bar_msg($action_result->get_message());

        $result =  $this->prepare_next_step($action_result);
        return $result;
    }


    private function init()
    {
        
        $db_host   =  trim($_REQUEST['peg_grid_db_host']);
        $db_name   =  trim($_REQUEST['peg_grid_db_name']);
        $db_user   =  trim($_REQUEST['peg_grid_db_user']);
        $db_pass   =  trim($_REQUEST['peg_grid_db_pass']);

        $this->is_local     = $_REQUEST['peg_grid_is_local']== 1    ? true : false;
        $this->only_append  = $_REQUEST['peg_grid_only_append']==1  ? true : false;

        try {
            $this->write_progress_bar_msg("Σύνδεση στην απομακρυσμένη βάση...");
            $this->pdo = $this->core00_p92_exec_connect_to_remote_db($db_host, $db_name, $db_user, $db_pass); //TODO: Θα πρέπει αυτή η συνάρτηση να μην κάνει die αλλά throw 
        } catch (Exception $exc) {
            return $exc->getMessage();
        } catch (Throwable $th) {
            return 'Υπήρξε πρόβλημα στην σύνδεση με την απομακρυσμένη βάση';
        }
        $error = 0;
        if (!$this->is_local) {
            $error = $this->check_if_same_encryption_library();
        }
        if (!empty($error)) {
            return $error;
        }

        //TODO: Κάπου θα πρέπει και να κλείνω το connection της βασης 

        $this->given_tables_by_user     =  isset($_REQUEST['peg_grid_only_tables'])     ?  $_REQUEST['peg_grid_only_tables']     :  '';
        $this->excluded_tables_by_user  =  isset($_REQUEST['peg_grid_excluded_tables']) ?  $_REQUEST['peg_grid_excluded_tables'] :  '';
        $this->list_of_tables           = !isset($_REQUEST['list_of_tables']) ? $this->find_list_of_tables() : $_REQUEST['list_of_tables'];
        if (empty($this->list_of_tables)) {
            return 'Δεν βρέθηκαν κοινοί πίνακες μεταξύ των δύο εγκαταστάσεων';
        }
        $this->current_table_index = !isset($_REQUEST['current_table_index']) ? 0 : $_REQUEST['current_table_index'];

        //Additional Initialization Checks
        $init_error = $this->init_check();
        if (!empty($init_error)) {
            return $init_error;
        }


        // $TT = peg_read_file("../../tmp/req.txt");
        // peg_write_file("../../tmp/req.txt", $TT . print_r($_REQUEST, 1));
        
        return "";
    }
    private function find_list_of_tables()
    {
        $in = array("sql" => '', "sqlParams" => array());
        if (!empty($this->given_tables_by_user)) {
            $only_tables_input = explode(',', $this->given_tables_by_user);
            $only_tables = array();
            foreach ($only_tables_input as $key => $value) {
                $tt = trim($value);
                if (!empty($tt)) {
                    array_push($only_tables, $tt);
                }
            }
            if (!empty($only_tables)) {
                $in = pegasus_mysql_create_in($only_tables, 'tbl');
                $in["sql"] = " AND p50.p01 in (" . $in["sql"] . ") ";
            }
        }

        
       
        if (!empty($only_tables)){
            $non_common_tables = array();
            foreach ($this->non_common_transferable_tables() as $key => $value) {
                if(in_array($value['p01'], $only_tables)){
                    $non_common_tables[] = $value;
                }
            }
        }
        else{
            $non_common_tables = $this->non_common_transferable_tables();
        }


        //Excluded Tables
        $exclude = array("sql" => '', "sqlParams" => array());
        if(!empty($this->excluded_tables_by_user)){
            $excluded_tables_arr = explode(',', $this->excluded_tables_by_user);
            $exclude = pegasus_mysql_create_in($excluded_tables_arr, 'ex_tbl');
            $exclude["sql"] = " AND p50.p01 not in (" . $exclude["sql"] . ") ";
        }


        $query = " SELECT p50.p01 , p50.p502 as tax
                        FROM p50
                        LEFT JOIN cor006 ON cor006.p00 = p50.cor006
                        JOIN p55 ON p55.p00=p50.module and p55.en=1 
                        where p50.p01 <> ''
                        and p50.p02 not like 'massimport_z%' /* όχι*/
                        and (p50.cor006 <> 1 or p50.p01 = 'p92' or p50.p01 = 'p93') /* Εξαιρώ τους πίνακες εφαρμογής εκτός από τους p92, p93*/
                        and p50.cor006 <> 5 /* όχι οι log πίνακες*/
                        and p50.cor006 <> 6 /* όχι οι temporary πίνακες*/
                        
                        and p50.p01 not in ('herh00', 'cor006', 'd99005', 'firewall00' )

                        /* and p50.p01 in ('a10', 'a11', 'mail02', 'test_fotini', 'backup_20180831192243_p50_1', 'us0', 'cor000')  το κρατάω μόνο για το debug προς το παρόν */
                                    
                        " .  $in["sql"] . "  
                        " .  $exclude["sql"] . "            
                        and p50.is_view <> 1
                        order by p50.module, p50.p01 ";


        $values = array_merge($in["sqlParams"], $exclude["sqlParams"]);
        // echo pegasus_replace_values_in_sql($query, $values);
        // die();

        if (!$this->is_local) {
            $res = $this->pdo->pegasus_query($query, $values);
            $p50_remote_array = $res->fetchAll(PDO::FETCH_ASSOC);
        }

        $res = pegasus_query($query, $values);
        $p50_local_array00 = pegasus_fetchall($res);
        
        $p50_local_array = $non_common_tables;
        $tables_inserted = array();
        //Είναι σημαντικό να μπούνε πρώτα αυτοί οι πίνακες γιατί έχουν συγκεκριμένη διαδοχή
        foreach ($non_common_tables as $key => $value) {
            $tables_inserted[] = $value["p01"];
        }
        foreach ($p50_local_array00 as $key => $value) {
            if(in_array($value["p01"], $tables_inserted)){
                continue;
            }
            $p50_local_array[] = $value; 
        }

        //βαζω τους πινακες με την διαδοχη για να εχουν την σωστη σειρα δνε μπορω αν μεταφερω  πχ. chaa00 - αν δεν εχω μεταφερει πρωτα a01
        usort($p50_local_array, 'core00_usort_sortByOrder');
        $common_tables = array();

        foreach ($p50_local_array as $table) {
            if (!$this->is_local) {
                if( array_search($table['p01'], array_column($p50_remote_array, 'p01'))!==false) {
                    array_push($common_tables, $table['p01']);
                }
            } else {
                $sth = $this->pdo->pegasus_query(
                    "SELECT TABLE_NAME FROM INFORMATION_SCHEMA.tables
                                    WHERE table_schema =:db_name  AND table_name =:tbl_name  LIMIT 1;",
                    array('db_name' => $_REQUEST['peg_grid_db_name'], 'tbl_name' => $table['p01'])
                );

                $exists = $sth->fetchAll(PDO::FETCH_ASSOC);
                if ($exists[0]['TABLE_NAME'] == $table['p01']) {
                    array_push($common_tables, $table['p01']);
                }
            }
        }

        return $common_tables;
    }

    private function sme_tables()
    {
        return
            array(
                'p85', 'p86', 'p87', 'p88', 'p92', 'p93',
                'herdic', 'herf01', 'herd01', 'herd02', 'herd03',
                'z18', 'z19', 'z20', 'z21', 'z52', 'kernel_01', 'kernel_02', 'urls01',
                'q01', 'q08', 'q09', 'q10', 'q11', 'q12', 'q13', 'q131', 'q14', 'q15', 'q16', 'q97', 'q98', 'charts_q10',
                'mail02', 'dashboard00_12_d', 'dashboard00_13', 'dashboard00_14',
                'p95', 'p95p50', 'p95p51', 'p95p55', 'p95p80', 'p95p81', 'p95p98', 'p95q10', 'p95tbl'
            );
    }

    private function non_common_transferable_tables()
    {
        return
            array(
                array('p01' => 'chaa80' , 'tax' => '9999999997'), //πρέπει να εκτελεστεί πριν από την καταχώρηση υπηρεσίας 
                array('p01' => 'chaa00' , 'tax' => '9999999998'), //Μέλος
                array('p01' => 'chaa02' , 'tax' => '9999999998'), //Τιμοκατάλογος Γυμναστηρίου
                array('p01' => 'chaa01' , 'tax' => '9999999999'), //Φωτογραφίες μελών
                array('p01' => 'chaa61' , 'tax' => '9999999999'), //Αίθουσες
                array('p01' => 'chaa20' , 'tax' => '9999999999'), //Ομαδικά Μαθήματα
                array('p01' => 'chaa74' , 'tax' => '9999999999'), //Καταστάσεις παρουσιών
                array('p01' => 'chaa03' , 'tax' => '9999999999') //Υπηρεσίες μέλους
            );
    }

    private function return_abort_result($message)
    {
        return new core00_p92ActionResult(core00_p92ActionResultStatus::$ErrorP92ShouldAbort, $message);
    }

    private function prepare_next_step($action_result)
    {
        $result = null;

        $status = $action_result->get_status();

        switch ($status) {
            case core00_p92ActionResultStatus::$ErrorP92ShouldAbort:
                $result = $action_result;
                break;
            case core00_p92ActionResultStatus::$OKActionCompleted:
                // Η θα πάω στο επόμενο action ή θα τελειώσω με την εκτέλεση του αυτοματισμού

                $next_step = $this->find_next_index();

                if ($next_step == -1) {
                    $result = new core00_p92ActionResult(
                        core00_p92ActionResultStatus::$OKActionCompleted,
                        $this->get_success_message()
                    );
                    $result->set_log($action_result->get_log());
                    $result->add_log_record("End of Procedure");
                }
                //Προχωραω στο επόμενο βήμα
                else {
                    $next_execution_request = $action_result->get_next_exec_request();
                    $next_execution_request['current_table_index'] = $next_step;
                    $next_execution_request['list_of_tables'] = $this->list_of_tables;
                    $result = new core00_p92ActionResult(
                        core00_p92ActionResultStatus::$OKActionShouldBeRepeated,
                        "",
                        $next_execution_request
                    );
                    $result->set_log($action_result->get_log());
                    $result->add_log_record("Proceed to next step: " . $this->list_of_tables[$next_step]);
                }
                break;
            case core00_p92ActionResultStatus::$OKActionShouldBeRepeated:
                /**
                 * Συνεχίζω με το ίδιο βήμα
                 */
                $action_result->add_in_next_exec_requests_params(array('current_table_index' => $this->current_table_index, 'list_of_tables' => $this->list_of_tables));
                $result = $action_result;
                break;
            default:
                return $this->return_abort_result("Debug Info: Δεν δόθηκε σωστό response από τοο action");
                break;
        }

        return $result;
    }

    protected function find_next_index()
    {
        //Next table
        if (isset($this->list_of_tables[$this->current_table_index + 1])) {
            return $this->current_table_index + 1;
        }

        //Reached the End of the list
        return -1;
    }

    protected function get_success_message()
    {
        return "Ο αυτοματισμός μεταφοράς εκτελέστηκε με επιτυχία";
    }




    private function check_if_same_encryption_library()
    {
        $query = "select ifnull(encr_lib_php, 0) as encr_lib_php from firewall00 where nr01 = 1";


        $res = $this->pdo->pegasus_query($query);
        $remote_encr_library = $res->fetch(PDO::FETCH_ASSOC);
        if ($remote_encr_library === false) { //Αν δεν έχει εγγραφή το firewall00 γυρνάει false. Προσοχή, νομίζω αυτό αλλάζει από PHP8 και πάνω
            $remote_encr_library['encr_lib_php'] = 0;
        }

        $res = pegasus_query($query);
        $local_encr_library = pegasus_fetch($res, PEG_FETCH_ASSOC);

        if ($remote_encr_library != $local_encr_library) {
            return 'Δεν είναι δυνατή η μεταφορά δεδομένων στην περίπτωση που δεν συμπίπτει η βιβλιοθήκη κρυπτογράφησης που χρησιμοποιούν οι δύο εγκαταστάσεις.';
        }
        return '';
    }

    private function init_check(){
        $init_error = "";

        if(!pegasus_module_exists('stores')){
            //Έλεγχος για το αν υπάρχει t01 (Κίνηση Λογαριασμού) με Κατάστημα!=0 και αν δεν εχει το module "Καταστήματα" εμφανιζουμε μηνυμα. 
            $query = "select * from t01 where p09!=0 limit 1;";            
            $res   = $this->pdo->pegasus_query($query);
            if($res!=false){
                $data = $res->fetchAll(PDO::FETCH_ASSOC);            
                if(count($data)>0){
                    $init_error = 'Δεν είναι δυνατή η Μεταφορά Δεδομένων, βρέθηκαν Κίνησεις Λογαριασμού σε επιπλέον Καταστήματα ενω δε είναι διαθέσιμο το αντίστοιχο Module "Καταστήματα"';
                }
            }
        }

        return $init_error;
    }

    private function get_current_table()
    {
        return $this->list_of_tables[$this->current_table_index];
    }


    private function find_class($table)
    {

        $className = 'core00_TableTransfer';
        if (class_exists($className . "_" . $table)) {
            return $className . "_" . $table;
        } else {
            return $className;
        }
    }

    private function core00_p92_exec_connect_to_remote_db($db_host = '', $db_name = '', $db_user = '', $db_pass = '')
    {

        if (empty($db_host) || empty($db_name) || empty($db_user) || empty($db_pass)) {
            throw new Exception("Ελέγξτε τις τιμές των παραμέτρων για την σύνδεση στην απομακρυσμένη βάση.", 1);
        }

        $db_host = str_replace("https://", '', $db_host);
        $db_host = str_replace("http://", '', $db_host);
        $db_host = str_replace("www.", '', $db_host);

        $this_web_app = $_SERVER['SERVER_NAME'];
        $this_web_app = str_replace("https://", '', $this_web_app);
        $this_web_app = str_replace("http://", '', $this_web_app);
        $this_web_app = str_replace("www.", '', $this_web_app);

        if ($db_host == $this_web_app &&  DB_NAME == $db_name) {
            throw new Exception("Προσοχή! Έχετε επιλέξει δώσει ως στοιχεία βάσης τα στοιχεία αυτού του Web App.");
        }


        $pdo_var = new PegasusDB(array(
            "db_type" => "mysql",
            "db_host" => $db_host,
            "db_name" => $db_name,
            "db_username" => $db_user,
            "db_password" => $db_pass
        ));
        return $pdo_var;
    }
}
