<?php


class core00_TableTransfer
{

    protected $table;
    protected $current_table_action;
    protected $pdo;
    protected $transfer_only_sme;
    protected $only_append;

    function __construct($table, $pdo, $transfer_only_sme, $only_append=false)
    {
        $this->table    = $table;
        $this->pdo      = $pdo;
        $this->transfer_only_sme    = $transfer_only_sme;
        $this->only_append          = $only_append;
        //current_table_action:  backup ή delete ή insert
        $this->current_table_action = isset($_REQUEST['current_table_action']) ? $_REQUEST['current_table_action'] :'backup';
    }

    public function exec()
    {

        $class_name = $this->find_class_name($this->transfer_only_sme);
        $action = new $class_name($this->table, $this->only_append);

        //echo "\nExec curerrent_table_action: ". $this->current_table_action ." current table " . $this->table ." class: ".$class_name;

        if(method_exists($action, 'set_pdo_to_remote_db')){
            $action->set_pdo_to_remote_db($this->pdo);
        }

        $action_result = $action->exec();
        
        $transfer_table_result = $this->prepare_next_step($action_result);
        $transfer_table_result->add_log_record("Executed table_action: ". $this->current_table_action ." for table " . $this->table ." class: ".$class_name);
        return $transfer_table_result;
    }

    private function find_next_step(){
        
        $next_step = '';
        switch ($this->current_table_action) {
            case 'backup':
                $next_step = ($this->only_append) ? 'insert' : 'delete';
                break;
            case 'delete':
                $next_step = 'insert';
                break;
            case 'insert':
                $next_step = '';
                break;
            default:
                break;
        }
        // echo "current action: ". $this->current_table_action;
        // echo "next_step: ". $next_step;

        return $next_step;
    }

    private function find_class_name($transfer_only_sme = true){
        $class_name = '';
        switch ($this->current_table_action) {
            case 'backup':
                $class_name = 'core00_TableTransferBackUp';
                break;
            case 'delete':
                $class_name = $transfer_only_sme ? 'core00DeleteSmeRecordsOfTable' :'core00_TableTransferDelete';
                break;
            case 'insert':
                $class_name = $transfer_only_sme ? 'core00InsertSmeRecordsOfTable' :'core00_TableTransferInsert';
                break;
        }

        if (class_exists($class_name . "_" . $this->table)) {
            return $class_name . "_" . $this->table;
        } else {
            return $class_name;
        }

    }

    private function prepare_next_step($action_result)
    {
        $result = null;

        $status = $action_result->get_status();

        // echo "\n Current step: " . $this->current_table_action;
        // echo " Response: ".$action_result->obj_to_str();

        switch ($status) {
            case core00_p92ActionResultStatus::$ErrorP92ShouldAbort:
                $result = $action_result;
                break;
            case core00_p92ActionResultStatus::$OKActionCompleted:
                // Η θα πάω στο επόμενο action ή θα τελειώσω με την εκτέλεση του αυτοματισμού

                $next_step = $this->find_next_step();

                if ($next_step == '') {
                    $result = new core00_p92ActionResult( core00_p92ActionResultStatus::$OKActionCompleted,'Η μεταφορά του πίνακα ' .$this->table. ' εκτελέστηκε');
                }
                //Προχωραω στο επόμενο βήμα
                else {
                    $next_execution_request = $action_result->get_next_exec_request();
                    $next_execution_request['current_table_action'] = $next_step;
                    $result = new core00_p92ActionResult(
                        core00_p92ActionResultStatus::$OKActionShouldBeRepeated,
                        "Έναρξη μεταφοράς: ". $this->table,
                        $next_execution_request
                    );
                }
                break;
            case core00_p92ActionResultStatus::$OKActionShouldBeRepeated:
                /**
                 * Συνεχίζω με το ίδιο βήμα
                 */
                $next_execution_request = $action_result->get_next_exec_request();
                $next_execution_request['current_table_action'] = $this->current_table_action;
                $result = new core00_p92ActionResult(
                    $action_result->get_status(),
                    "Συνέχεια Μεταφοράς μεταφοράς: ". $this->table ,
                    $next_execution_request
                );


                break;
            default:
                return $this->return_abort_result("Debug Info: Δεν δόθηκε σωστό response από τοο action");
                break;
        }

        if(!empty($action_result->get_message())){
            $result->add_log_record($action_result->get_message());
        }
        
        return $result;
    }

    private function return_abort_result($message)
    {
        return new core00_p92ActionResult( core00_p92ActionResultStatus::$ErrorP92ShouldAbort,$message);
    }
    
}

//TODO: Θα πρέπει να ελέγχω αν υπάρχει ο πίνακας
class core00_TableTransferBackUp
{

    protected $table;

    function __construct($table)
    {
        $this->table = $table;
    }

    public function exec()
    {
        pegasus_mysql_backup_table($this->table);
        return new core00_p92ActionResult(
            core00_p92ActionResultStatus::$OKActionCompleted
        );
    }
}

//TODO: Θα πρέπει να ελέγχω αν υπάρχει ο πίνακας
class core00_TableTransferDelete
{

    protected $table;

    function __construct($table)
    {
        $this->table = $table;
    }

    public function exec()
    {
        pegasus_query("SET @pegasus_no_triggers_tmp_backup = @pegasus_no_triggers");
        pegasus_query("SET @pegasus_no_triggers = 1");
        $this->delete();
        pegasus_query("SET @pegasus_no_triggers = @pegasus_no_triggers_tmp_backup");
        return new core00_p92ActionResult(
            core00_p92ActionResultStatus::$OKActionCompleted
        );
    }
    protected function delete()
    {
        pegasus_mysql_delete($this->table, 'nr01>=0');
    }
}

class core00DeleteSmeRecordsOfTable extends core00_TableTransferDelete
{
    protected function delete()
    {
        pegasus_mysql_delete($this->table, 'nr01<140000000000000 OR (140000035000000<=nr01 AND nr01<=140000035999999)');
    }
}

//TODO: Θα πρέπει να ελέγχω αν υπάρχει ο πίνακας
class core00_TableTransferInsert
{

    protected $pdo;
    protected $table;
    protected $offset;
    protected $rec_per_page;
    protected $only_append;

    function __construct($table, $only_append=false)
    {
        $this->table = $table;
        $this->offset         = isset($_REQUEST['offset']) ? $_REQUEST['offset'] : 0;
        $this->rec_per_page   = 500;
        $this->only_append    = $only_append;
    }

    public function set_pdo_to_remote_db($pdo)
    {
        $this->pdo = $pdo;
    }

    public function exec()
    {

        pegasus_query("SET @pegasus_no_triggers_tmp_backup = @pegasus_no_triggers");
        pegasus_query("SET @pegasus_no_triggers = 1");

        $query = $this->fetch_query();
        //Καλό θα ήταν εδώ να ελέγχουμε ότι δεν γυρισε false ή κενό row (). Προσοχή είναι κενό row στην PHP8
        $res = $this->pdo->pegasus_query("SET sql_mode = ''");
        $res = $this->pdo->pegasus_query($query);
        if(!$res){
            return new core00_p92ActionResult(
                core00_p92ActionResultStatus::$OKActionCompleted, 
                "Δεν βρέθηκαν εγγραφές στον απομακρυσμένο πίνακα με το query: ".  $query
            );
        }
        $result = $res->fetchAll(PDO::FETCH_ASSOC);
        $this->insert($result);
        pegasus_query("SET @pegasus_no_triggers = @pegasus_no_triggers_tmp_backup");
        if(pegasus_mysql_table_exists($this->table)){
            pegasus_mysql_remake_p75($this->table);
        }

        if (is_array($result) && count($result) < $this->rec_per_page) {
            return new core00_p92ActionResult(
                core00_p92ActionResultStatus::$OKActionCompleted
            );
        } else {
            return new core00_p92ActionResult(
                core00_p92ActionResultStatus::$OKActionShouldBeRepeated,
                "",
                array("offset" => $this->offset + $this->rec_per_page)
            );
        }
    }

    protected function fetch_query()
    {
        return ' SELECT * FROM ' . $this->table . ' ORDER BY nr01 DESC LIMIT ' . $this->offset . ' , ' . $this->rec_per_page;
    }

    protected function insert($result)
    {
        $columns = array();
        foreach ($result[0] as $column_name => $value) {
            if (pegasus_mysql_table_field_exists($this->table, $column_name)) {
                array_push($columns, $column_name);
            }
        }
        $all_columns_exist = false;
        if (is_countable($result[0]) && is_countable($result[0]) && count($result[0]) == count($columns)) {
            $all_columns_exist = true;
        }
        foreach ($result as $row) {
            if (!$all_columns_exist) {
                foreach ($row as $column_name => $value) {
                    if (in_array($column_name, $columns)) {
                        $new_record[$column_name] = $value;
                    }
                }
            } else {
                $new_record = $row;
            }
            //Έβαλα onDuplicate update. 
            //Στις γενικές περιπτώσεις πινάκων έχει διαγραφεί ολόκληρος ο πίνακας πριν κάνω insert
            //όμως π.χ. στον us0 θα κρατήσω τον χρήστη που είναι logαρισμένος και εκτελεί τον αυτοματισμό
            pegasus_mysql_insert($this->table, array_keys($new_record), array_values($new_record), 1, 1); 
        }
    }
}

class core00InsertSmeRecordsOfTable extends core00_TableTransferInsert
{
    protected function fetch_query()
    {
        return
            ' SELECT * FROM '
            . $this->table .
            ' WHERE  nr01<140000000000000 OR  (140000035000000<=nr01 AND nr01<=140000035999999) ' .
            ' ORDER BY nr01 DESC ' .
            ' LIMIT ' . $this->offset . ' , ' . $this->rec_per_page;
    }
}


// class core00_TableTransferBackUp_a11{

//     public function exec()
//     {
//        die("\ncheck if in exec of custom backup");
//     }
// }



//Κώδικας Αυτοματισμού
// $p92_exec  = new p92Exec('core00_p92Action_Transfer');
// $p92_exec->exec();
