<?php

function core01_core01_02_d_p01_template(
	$container_id = '',
	$data = array(),
	$service = 'pegcloud.io'
) {
	$module = $data['modules'][0];
	$html = '';
	$template = peg_read_file('../core01_templates/core01_core01_02_d_p01_template.html');
	// description
	$description = $module['description'];
	$description = str_replace(
		array(
			'href="/',
			'href='
		),
		array(
			'href="https://tesae.gr/',
			'target="_blank" href='
		),
		$description
	);
	if($module['extra_value_pd32'] > 0) {
		$msg = str_replace(
			array(
				'#value#'
			),
			array(
				$module['extra_value_pd32']
			),
			$_SESSION['peg_dic_core01_02_d_mextra_value_pd32']
		);
		$description .= "<br/><div>$msg</div>";
	}
	// html
	$html = str_replace(
		array(
			'#description#',
		),
		array(
			$description
		),		
		$template
	);
	return $html;
}
function core01_core01_01_d_p01_template(
	$container_id = '', 
	$data = array(),
	$service = 'pegcloud.io'
	
) {

	$module_image_src_template = "https://update.$service/pegasus/update_ver5/execute.php?action=getAddonModulesImage&nr01=#nr01#";
	 // $module_image_src_template = 'https://mock-update.pegcloud.io/pegasus/update_ver5/execute.php?action=getAddonModulesImage&nr01=#nr01#';

	$html = '';
	$modules_html = '';
	$module_html = '';
	$template = peg_read_file('../core01_templates/core01_core01_01_d_p01_template.html');
	$modules_template =  pegasus_get_text_inside_tags('<!--modules start-->', '<!--modules end-->', $template);
	$module_template =  pegasus_get_text_inside_tags('<!--module start-->', '<!--module end-->', $modules_template);
	$module_image_template =  pegasus_get_text_inside_tags('<!--module-img start-->', '<!--module-img end-->', $module_template);
	$module_title_template =  pegasus_get_text_inside_tags('<!--module-title start-->', '<!--module-title end-->', $module_template);
	$category_template =  pegasus_get_text_inside_tags('<!--category start-->', '<!--category end-->', $module_template);
	// Module
	$last_category = 0;
	$text_color = '#5fa2dd';
	$text_color_2 = '#333';
	
	foreach ($data['modules'] as $module) {
		
		$category_html = '';
		if($module['category'] != $last_category) {
			$category_html = str_replace(
				'#category_title#',
				$module['category_title'],
				$category_template
			);
		}
		$last_category = $module['category'];

		$new_text_color = $text_color;
		$new_text_color_2 = $text_color_2;
		$module_image_html = '';
		$module_title_html = str_replace(
			'#module-title#',
			$module['title'],
			$module_title_template
		);
		if ($module['image'] > 0) {
			$image_nr01 = $module['image'];
			if(empty($image_nr01)) {
				$image_nr01 = 0;
			}
			$module_image_src = str_replace(
				'#nr01#',
				$image_nr01,
				$module_image_src_template
			);
			$module_title_html = '';
			$module_image_html = str_replace(
				array(
					'src=""',
					'#module-title#',
				),
				array(
					'src="' . $module_image_src . '"',
					$module['title'],
				),
				$module_image_template
			);
		}
		$sort_description = str_replace(
			array(
				'<p>'
			),
			array(
				'<p style="margin:0; padding:0; line-height:14px">'
			),
			$module['sort_description']
		);
		$btn_block = '';
		if ($module['exists'] === false) {
			$sn			= 'Π' . pegasus_leading_zeros($_SESSION['cor000_sn'], 7);
			$code = $_SESSION['cor000_app_code'];
			$href = "https://www.tesae.gr/pegasus/serialnm01/edit.php?sn=$sn&code=$code&d00nr=0&tmppcode=SN_CD1";
			
			$btn_block .= '<a href="'.$href.'" style="text-decoration: none; margin-right: 10px; color: inherit;" target="_blank">';
			$btn_block .= '<i class="fas fa-cart-arrow-down"></i>';
			$btn_block .= '</a>';

			$btn_block .= '<strong style="margin-right:10px; color: #333; font-size:80%;">';
			$btn_block .= number_format($module['price'], 2);
			$btn_block .= ' €</strong>';
		}
		if (!empty($module['video'])) {
			$hvid02 = $module['video'];
			$href = "https://www.tesae.gr/pegasus/videos01/show00.php?hvid02=$hvid02&pcode=hvid02_cd$hvid02";
			$btn_block .= '<a href="'.$href.'" style="text-decoration: none; margin-right: 10px; color: inherit;" target="_blank">';
			$btn_block .= '<i class="fab fa-youtube"></i>';
			$btn_block .= '</a>';
		}
		$description = trim(str_replace(
			'',
			'',
			strip_tags($module['description'])
		));
		if(!empty($description)) {
			$js = "core01_core01_01_d_show_core01_02('" . $container_id . "','" . $module['module'] . "')";
			$btn_block .= '<a href="javascript:' . $js . '" style="text-decoration: none; color: inherit;">';
			$btn_block .= '<i class="fas fa-info-circle"></i>';
			$btn_block .= '</a>';
		}

		$module_html .= str_replace(
			array(
				$category_template,
				$module_image_template,
				$module_title_template,
				'#sort-description#',
				'#btn-block#',
				$text_color,
				$text_color_2,
				'#exists#',
				'#exists_class#'
			),
			array(
				$category_html,
				$module_image_html,
				$module_title_html,
				$sort_description,
				$btn_block,
				$new_text_color,
				$new_text_color_2,
				$_SESSION['peg_dic_core01_core01_d_module_exists'],
				$module['exists']?'was_not_exists':''
			),
			$module_template
		);
	}
	// Modules
	$modules_html .= str_replace(
		$module_template,
		$module_html,
		$modules_template
	);
	// Html
	$html .= str_replace(
		array(
			$modules_template
		),
		array(
			$modules_html
		),
		$template
	);
	$html.= '<p style="text-align:right; color:#ccc"><small>'.$service.'</small></p>';
	return $html;
}
function core01_get_addon_modules(
	$show_module = ''
)
{
	$service_name = 'pegcloud.io';

	$main_service_url = 'https://update.pegcloud.io';
	//$main_service_url = 'http://mock-update.pegcloud.io';
	try {
		$json_response = pegasus_curl_request("$main_service_url/is_alive.php", false,  array(), array(CURLOPT_TIMEOUT => 4));
	} catch (Exception $ex) {
		$json_response = false;
	}
	if (!empty($json_response) and  $json_response == 'true') {
		$url = "$main_service_url/pegasus/update_ver5/execute.php";
	} else {
		$service_name = 'tesae.gr';
		$url = "https://update.tesae.gr/pegasus/update_ver5/execute.php";
	}
	$sn			= 'Π' . pegasus_leading_zeros($_SESSION['cor000_sn'], 7);
	$user = $_SESSION['cor000_tesae_user'];
	$pass = $_SESSION['cor000_tesae_pass'];
	$app_code = $_SESSION['cor000_app_code'];
	$sid = '';
	// Login to service
	$params = array(
		'action'	=> 'login',
		'user'		=> $user,
		'pass'		=> $pass,
		'sn'		=> $sn,
		'un'		=> 1
	);
	$resp = pegasus_curl_request_post($url, $params);
	$xml = simplexml_load_string($resp);
	if ($xml->code == '100') {
		$sid = $xml->sid;
		$en = 1;
		if ($_SESSION['lang'] == 'GR') {
			$en = 0;
		}
		$params = array(
			'action'	=> 'getAddonModules',
			'sid'		=> $sid,
			'app_code'	=> $app_code,
			'en'        => $en,
			'sn'		=> $sn,
		);
		// Load Single Module
		if(!empty($show_module)) {
			$params['module'] = $show_module;
		}
		//print_r($params);
		$resp = pegasus_curl_request_post($url, $params);
		$xml = simplexml_load_string($resp);
		if ($xml->code == 703) {
			$getAddonModules = $xml->getAddonModules;
			$getAddonModules = json_decode(base64_decode($getAddonModules), true);

			//var_dump($getAddonModules['data']);
			//die('TEST');
			return array(
				'ok'		=> 1,
				'data'		=> $getAddonModules['data'],
				'service'	=> $service_name,
				'msg'		=> 'Success',
			);
		}
		$params = array(
			'action'	=> 'sessionDestroy',
			'sid'		=> $sid
		);
		pegasus_curl_request_post($url, $params);
	}
	return array(
		'ok'	=> 0,
		'msg'	=> 'Error'
	);
}
function core01_core01_01_d_initialize(
	$data = array(),
	$mmnr01 = '',
	$mnr01 = '',
	$_d = '',
	$container_id = ''
) {
	$getAddonModulesResp = core01_get_addon_modules();
	$data['p01'] = core01_core01_01_d_p01_template($container_id, $getAddonModulesResp['data'], $getAddonModulesResp['service']);
	return $data;
}
function core01_core01_02_d_initialize(
	$data = array(),
	$mmnr01 = '',
	$mnr01 = '',
	$_d = '',
	$container_id = ''
) {
	global $PegInput;
	$PegInput->addVar(new peg_input_alphanumeric('show_module', 'request'));
	$show_module = $PegInput->getRequest('show_module');

	$getAddonModulesResp = core01_get_addon_modules($show_module);
	$data['p01'] = core01_core01_02_d_p01_template($container_id, $getAddonModulesResp['data'], $getAddonModulesResp['service']);
	return $data;
}