Ext.define('Ext.ux.AjaxDefer', {
    extend: 'Ext.data.Connection',

    singleton: true,

    callbacks: [],

    hasPendingRequests: function () {
        var requests = this.requests,
            prop;

        for (prop in requests) {
            if (requests.hasOwnProperty(prop)) {
                return true;
            }
        }
        return false;
    },

    onComplete: function (request) {
        var i = 0,
            len,
            callbacks,
            callback;

        this.callParent(arguments);

        if (!this.hasPendingRequests()) {
            callbacks = this.callbacks;
            while (callbacks.length) {
                callback = callbacks.shift();
                //alert( callback[0]);
                //alert( callback[1]);
                callback[0](callback[1]);
            }
        }
    },

    wrap: function (fn, params) {
        if (!this.hasPendingRequests()) {
        	fn(params);
        }else{
        	 
        	this.callbacks.push([fn , params]);    
        }
    }
});