/**
 * @class Functions.core.form
 * 
 * @member WebApp.view
 * 
 *  ##Properties
 *  
 *  The global variables of the module
 *  
 *   
 *  ##Methods
 * 
 	- Get Form Data
 	- Manage Data (submit/delete)
 	- Element Type functions
 *  
 *   
 */

//XXX Start Get Form Data
/**
 * Return The fields of a form 
 * @param form_name The container_id of the form  
 * @returns {Object/boolean}
 * @private
 */
function pegGetFormFields(form_name){ 
	if(pegIsForm(form_name)){ 
		return Ext.getCmp(form_name).getForm().getFields();
	} 
	return false;
}

/**
 * Gets the values of the form
 * @param form_name The container_id of the form  
 * @param {0/1} without_memo ignore memo fiels
 * @returns {Object}
 */
function pegGetFormVal00(form_name , without_memo){
	if(without_memo==undefined){	 
		without_memo = 0;
	}
	
	params = {};
	fld = pegGetFormFields(form_name);
 	

	if(fld){				
		fld.each(  function(item) {
		 
				if(item.container_id==form_name){
//					console.info('item', item);
					if(pegIsCheckboxObject(item)){
						if(item.value && item.value!=0){
							params[item.name] = item.inputValue;	
						}else{
							params[item.name] =0;	
						}
					}else if(pegIsCodeMirrorObject(item)){
						if(without_memo!=1){
							params[item.name] = item.lastValue;	
						}
					}else if( pegIsTimeObject(item) ){
						params[item.name] = item.rawValue;	
					}else if(pegIsTinyMCETextAreaObject(item) ){
						if(without_memo!=1){
							if(tinymce.get(item.getInputId())){
								params[item.name] = tinymce.get(item.getInputId()).save();	
							}
						}
					}else if(pegIsHTMLEditorObject(item)){
						params[item.name] = item.getValue();

					}else if(pegIsTextAreaObject(item) ){
						if(without_memo!=1){
							params[item.name] = item.getSubmitValue();
						}
					}else if(pegIsDateObject(item) ){
						params[item.name] = item.getSubmitValue();
					}else if(pegIsTextboxObject(item)){
//						if(without_memo!=1 ){
//						Pegasus.field.Text
							params[item.name] = item.getSubmitValue();
//						}
					}else if(pegIsDisplayObject(item)){
						if(without_memo!=1){
							params[item.name] = item.getSubmitValue();
						}
					}else if(pegIsNumberObject(item)){
						params[item.name] = item.getValue();
					}
					else if(pegIsTagObject(item)){
						params[item.name] = item.peg_getSubmitValue();
					}else{
						params[item.name] = item.getSubmitValue();
					}
				} 
		});
	}
	
	
	return params;
} 
//OLD
//function pegGetFormVal00(form_name , without_memo){
//	if(without_memo==undefined){	 
//		without_memo = 0;
//	}
//	
//	params = {};
//	fld = pegGetFormFields(form_name);
// 	
//
//	if(fld){				
//		fld.each(  function(item) {
//												
//		if(item.container_id==form_name){
//			if(item.$className == 'Ext.form.field.Checkbox' || item.$className == 'Pegasus.field.Checkbox' ){
//				if(item.value && item.value!=0){
//					params[item.name] = item.inputValue;	
//				}else{
//					params[item.name] =0;	
//				}
//			}else{
//				if(item.$className == 'Ext.ux.form.field.CodeMirror' || item.$className == 'Pegasus.field.CodeMirror'){
//					if(without_memo!=1){
//						params[item.name] = item.lastValue;	
//					}
//				}else{
//					if(item.$className == 'Ext.form.field.Time' || item.$className == 'Pegasus.field.Time'){
//						params[item.name] = item.rawValue;	
//					}else{										
//						if(item.$className == "Ext.ux.form.TinyMCETextArea" || item.$className == 'Pegasus.field.TinyMCETextArea'){
//							if(without_memo!=1){
//								if(tinymce.get(item.getInputId())){
//									params[item.name] = tinymce.get(item.getInputId()).save();	
//								}
//							}
//						}else{	
//							if(item.$className == "Ext.form.field.TextArea" || item.$className == 'Pegasus.field.TextArea'){
//								if(without_memo!=1){
//										params[item.name] = item.getSubmitValue();
//								}
//							}else{								
//								if(item.$className == "Ext.form.field.Date" || item.$className == 'Pegasus.field.Date'){
//								 	params[item.name] = item.getSubmitValue();
//								}else{									
//									if(item.$className == 'Ext.form.field.Textbox' || item.$className == 'Pegasus.field.Textbox'){
//										if(without_memo!=1){
//											params[item.name] = item.getSubmitValue();
//										}
//									}else{
//										if(item.$className == 'Ext.form.field.Display' || item.$className == 'Pegasus.field.Display'){
//											if(without_memo!=1){
//												params[item.name] = item.getSubmitValue();
//											}
//										}else{
//											if(item.$className == 'Ext.form.field.Number' || item.$className == 'Pegasus.field.Number'){
//												params[item.name] = item.getValue();
//											}else{
//												if(item.$className == 'Ext.form.field.HtmlEditor' ){
//													params[item.name] = item.getValue();
//												}else{
//													params[item.name] = item.getSubmitValue();
//												}
//											}
//										}
//									}
//								}
//							}
//						}
//					}
//				}
//			}
//		}		
//		});
//	}
//	
//	
//	return params;
//}
/**
 * Gets the values of the form
 * @param form_name The container_id of the form 
 * @param prefix Return the data with perfix
 * @param {0/1} without_memo ignore memo fiels
 * @returns {Object}
 */
function pegGetFormVal(form_name , prefix , without_memo){
	if(without_memo==undefined){	 
		without_memo = 0;
	}

	new_form_items = {};
	form_items = pegGetFormVal00(form_name , without_memo);
	if(prefix==undefined){							
		return form_items;
	}		

	Ext.Object.each(form_items ,  function(key, value, myself){
		new_form_items[prefix + key] = value;
	});
	return new_form_items;
	
}

/**
 * * Gets the values of the form over and _d
 * @param {String} container_id curent container _id
 * @param {String} _d the _d
 * @param  {false/'up'/'down'} type
 * @param {String} prefix  Return the data with perfix
 * @param {String} parent_d The parent containair if tha it will search
 * @param {0/1} without_memo
 * @returns {Object}
 */
function pegGetFormVal_d(container_id , _d , type , prefix , parent_d , without_memo){
	if(without_memo==undefined){	 
		without_memo = 0;
	}
	
 	var var_00 = {};
 	var id = pegGetContainer_id_d(container_id , _d , type , parent_d );
	var_00 = pegGetFormVal( id , prefix , without_memo) ; 		
	return var_00;
}
//XXX Start Manage Data (submit/delete)
  
/**
 * 
 * @param {String} form_name
 * @param {String}  _d the _d , to submit
 * @param {String} table  the table to submit
 * @param {String} module the module to submit
 * @param {String} container_id
 * @param {String} sub_d subform to submit if empty submit alla the forms  ex. p50_d01,p50_d03  
 * @param {String} mnr01
 * @param {String} mmnr01
 * @param {String} callback
 * @param {String} no_confim
 * @returns
 */
function pegSave_d(form_name , _d , table , module , container_id , sub_d , mnr01 ,  mmnr01 , callback , no_confim ){
	

 //Ext.ux.AjaxDefer.wrap(function () {	 
//	Ext.get(container_id).mask(dic_mask_msg);
	if(pegGetFramework() == 'peg002'){
		peg002_mask(container_id)
	}else{
		Ext.get(container_id).mask(dic_mask_msg);
	}
	

	if(no_confim==undefined){
		no_confim=1;
	}
	
	if(mnr01==undefined){
		mnr01=-1;
	}
	
	if(mmnr01==undefined){
		mmnr01='';
	}
	
	//url = '/' +main_path + '/core_global/get_childs_ids.php';
	url = '/' +main_path + '/core_global/ok.php';
	var params_pp = {};

//	console.info('pegSave_d::form_name', form_name);
//	console.info('pegSave_d::_d', _d);
//	console.info('pegSave_d::table', table);
//	console.info('pegSave_d::module', module);
//	console.info('pegSave_d::container_id', container_id);
//	console.info('pegSave_d::sub_d', sub_d);
//	console.info('pegSave_d::mnr01', mnr01);
//	console.info('pegSave_d::mmnr01', mmnr01);
//	console.info('pegSave_d::callback', mmnr01);
//	console.info('pegSave_d::no_confim', no_confim);
 
	var params = {};
	params_pp.id = container_id;
	params_pp.sub_d = sub_d;
	
	var _d_arr = sub_d.split(',');
	var _container_id_arr = [];	

	i=0;
	Ext.each(_d_arr , function(_d00){
		var id = pegGetContainer_id_d(container_id , _d00 , '' , _d );
		if(id!=''){
 			_container_id_arr.push(id);
		}
		i++;
	});

	if(sub_d==''){
		_container_id_arr.push(pegGetContainer_id_d(container_id , _d , '' , _d ));
	}
	
	/* make this ajaxa request just to confirm that all the request finished*/ 		
		Ext.ux.AjaxDefer.request({
		    url: url      ,
		    params: params_pp,
		    timeout : 300000, 
		    callback: function( options, success, response ){
		    	if(!pegAjaxCallBack( options, success, response )){
		    		try {
						if(pegGetFramework() == 'peg002'){
							peg002_unmask(container_id);
						}else{
							Ext.getCmp(container_id).unmask();
						}
						
					} catch (e) {
						// TODO: handle exception
					}
		    		return ;
		    	}
		    	
		    	var text = response.responseText;
				var jsonData =null;
				try {
        			jsonData = pegJsonDecode( text );
    			} catch (e) {
    				console.error('Unable to decode data');
    				console.info('Try to decode string',text);
    				console.dir(e);
    				// TODO: handle exception
    			}
	
				var fld = null;
				
				Ext.each(_container_id_arr , function(item00){ 
					fld  =  pegGetFormFields(item00) ; 
					if(fld){				
						fld.each(  function(item) { 
							if(item.container_id==item00){		
								if(pegIsCheckboxObject(item)){
									if(item.value && item.value!=0){
										params[item.name] = item.inputValue;	
									}else{
										params[item.name] =0;	
									}
								}else if(pegIsCodeMirrorObject(item)){
									params[item.name] = item.getSubmitValue();
								}else if( pegIsTimeObject(item) ){
									params[item.name] = item.rawValue;	
								}else if(pegIsTinyMCETextAreaObject(item)){
									if(tinymce.get(item.getInputId())){
										params[item.name] = tinymce.get(item.getInputId()).save();	
									}
								}else if (pegIsHTMLEditorObject(item)) {
									params[item.name] = item.getValue();
								}else if(pegIsTagObject(item)){
									params[item.name] = item.peg_getSubmitValue();
								}else if(pegIsDateObject(item) ){
									params[item.name] = item.getSubmitValue();
								}else if(pegIsComboboxV2Object(item) ){
									params[item.name] = item.getValue();
								}else{
									params[item.name] = item.value;
								}
							
							}
						});
					}
								
				});

			if(fld==''){
				pegAlert('No fields Values ');
				if(callback && typeof(callback) === "function"){
					callback({});
				}
				try {
					if(pegGetFramework() == 'peg002'){
						peg002_unmask(container_id);
					}else{
						Ext.getCmp(container_id).unmask();
					}
					
				} catch (e) {
					// TODO: handle exception
				}
				return;
			}

			url00 = '/' +main_path + '/core_global/save_d.php' ;
			params.scr__d = _d;
			params.scr_table = table;
			params.scr_module = module;
			params.scr_container_id = container_id;
			params.mnr01 = mnr01;
			params.mmnr01 = mmnr01;
			params.no_confim = no_confim;
			
			Ext.ux.AjaxDefer.request({
			    url: url00      ,
			    params: params,
			    timeout : 300000,
			    callback: function( options, success, response ){
			    	if(pegAjaxCallBack( options, success, response )){
			    		var text = response.responseText;
			    		try {
		        			jsonData = pegJsonDecode( text );
		    			} catch (e) {
		    				console.error('Unable to decode data');
		    				console.info('Try to decode string',text);
		    				console.dir(e);
		    				// TODO: handle exception
		    			}
			        	 
			    		if(callback && typeof(callback) === "function"){ 
			    			callback(jsonData);
			    		}	
			    	}
			    	try {
						if(pegGetFramework() == 'peg002'){
							peg002_unmask(container_id);
						}else{
							Ext.getCmp(container_id).unmask();
						}
					} catch (e) {
						// TODO: handle exception
					}
			    },
			    success: function(response){	
			    	 return true;
			    	var text = response.responseText;					        
					var jsonData = Ext.JSON.decode( text );
					try {
						if(pegGetFramework() == 'peg002'){
							peg002_unmask(container_id);
						}else{
							Ext.getCmp(container_id).unmask();
						}
					} catch (e) {
					}
					if(callback && typeof(callback) === "function"){
						callback(jsonData);
					} 
					
						
					
			    }
			});

		 
		}
	});
	/**/ 

	Ext.getCmp(container_id).setLoading(false); 		
	Ext.getCmp(container_id).peg_saveload=0;  
} 


/**
 * 
 * @param container_id
 * @param table
 * @param mnr01
 * @param mmnr01
 * @param callback
 * @param nr01
 * @returns
 */
function pegDelete_d(container_id ,  table , mnr01 , mmnr01 , callback , nr01){
	if(nr01>0){
		var params ={};
		url00 = '/' +main_path + '/core_global/delete_rec.php' ; 
		params.table  = table;
		params.nr01   = nr01;
		params.container_id = container_id;
		params.mnr01  = mnr01;
		params.mmnr01 = mmnr01;
			
		Ext.Ajax.request({
		    url: url00      ,
		    params: params  ,
		    success: function(response){	
		    	var text = response.responseText;					        
				var jsonData = Ext.JSON.decode( text );
				if(!jsonData.ok){
					pegAlert(jsonData.message);				
				}else{
					if(callback && typeof(callback) === "function"){
						callback(jsonData);
					}	
				}
		    }
		}); 			
	}else{
		return;
	}
}

//XXX Start Element Type functions
/** 
 * @param {String} form_name the container_id of the form
 * @returns {Boolean}
 */
function pegIsForm(form_name){
	var item = Ext.getCmp(form_name);
	if(item){ 
		return pegIsFormObject(item);
	}else{
		return false;	
	}
}
/**
 * If the object instance of 
 * 
 * 		- Ext.form.Panel
 * 		- Pegasus.form.Screen
 * 		- WebApp.view.Screen
 * 
 * @param {Object} obj 
 * @returns {boolean}
 */
function pegIsFormObject(obj){
	if(
		obj.$className=="Ext.form.Panel" || 
		obj.$className=="Pegasus.form.Screen" ||
		obj.$className=="WebApp.view.Screen" 
	){
		return true;
	}
	return false;
}
/**
 * If the object instance of 
 * 
 * 		- Ext.form.field.Checkbox
 * 		- Pegasus.field.Checkbox
 * 		- WebApp.view.field.Checkbox
 * 
 * @param {Object} obj 
 * @returns {boolean}
 */
function pegIsCheckboxObject(obj){
	if(
		obj.$className=="Ext.form.field.Checkbox" || 
		obj.$className=="Pegasus.field.Checkbox" ||
		obj.$className=="WebApp.view.field.Checkbox" 
	){
		return true;
	}
	return false;
}
/**
 * If the object instance of 
 * 
 * 		- Ext.form.field.Number
 * 		- Pegasus.field.Number
 * 		- WebApp.view.field.Number
 * 
 * @param {Object} obj 
 * @returns {boolean}
 */
function pegIsNumberObject(obj){ 
	if(
		obj.$className=="Ext.form.field.Number" || 
		obj.$className=="Pegasus.field.Number" ||
		obj.$className=="WebApp.view.field.Number"  
	){
		return true;
	}
	return false;
}
/**
 * If the object instance of 
 * 
 * 		- Ext.form.field.Display
 * 		- Pegasus.field.Display
 * 		- WebApp.view.field.Display
 * 
 * @param {Object} obj 
 * @returns {boolean}
 */
function pegIsDisplayObject(obj){ 
	if(
		obj.$className=="Ext.form.field.Display" || 
		obj.$className=="Pegasus.field.Display"  ||
		obj.$className=="WebApp.view.field.Display"
	){
		return true;
	}
	return false;
}
/**
 * If the object instance of 
 * 
 * 		- Ext.form.field.Textbox
 * 		- Pegasus.field.Textbox
 * 		- WebApp.view.Text
 * 		- WebApp.view.field.Text
 * 
 * @param {Object} obj 
 * @returns {boolean}
 */
function pegIsTextboxObject(obj){ 
	if(
		obj.$className=="Ext.form.field.Textbox" || 
		obj.$className=="Pegasus.field.Textbox" || 
		obj.$className== 'WebApp.view.Text' ||
		obj.$className=="WebApp.view.field.Text"
	){
		return true;
	}
	return false;
}
/**
 * If the object instance of 
 * 
 * 		- Ext.form.field.TextArea
 * 		- Pegasus.field.TextArea
 * 		- WebApp.view.TextArea
 * 		- WebApp.view.field.textarea.TextArea
 * 
 * @param {Object} obj 
 * @returns {boolean}
 */
function pegIsTextAreaObject(obj){ 
	if(
		obj.$className=="Ext.form.field.TextArea" || 
		obj.$className=="Pegasus.field.TextArea" || 
		obj.$className== 'WebApp.view.TextArea' ||
		obj.$className== 'WebApp.view.field.textarea.TextArea'
		
	){
		return true;
	}
	return false;
}
/**
 * If the object instance of 
 * 
 * 		- Ext.form.field.Date 
 * 		- Pegasus.field.Date
 * 		- WebApp.view.field.Date 
 * 
 * @param {Object} obj 
 * @returns {boolean}
 */
function pegIsDateObject(obj){ 
	if(
		obj.$className=="Ext.form.field.Date" || 
		obj.$className=="Pegasus.field.Date" || 
		obj.$className== 'WebApp.view.field.Date'
	){
		return true;
	}
	return false;
}
/**
 * If the object instance of 
 * 
 * 		- Ext.form.field.CodeMirror
 * 		- Pegasus.field.CodeMirror
 * 		- WebApp.view.TextArea.CodeMirror
 * 		- WebApp.view.field.textarea.codeMirror.CodeMirror
 * 
 * @param {Object} obj 
 * @returns {boolean}
 */
function pegIsCodeMirrorObject(obj){
	//TODO CodeMirror
	if(
		obj.$className=="Ext.form.field.CodeMirror" || 
		obj.$className=="Pegasus.field.CodeMirror" ||
		obj.$className=="WebApp.view.TextArea.CodeMirror"  ||
		obj.$className=="WebApp.view.field.textarea.codeMirror.CodeMirror" 
	){
		return true;
	}
	return false;
}
/**
 * If the object instance of 
 * 
 * 		- Ext.form.field.Time
 * 		- Pegasus.field.Time
 * 		- WebApp.view.Time
 * 		- WebApp.view.field.Time
 * 
 * @param {Object} obj 
 * @returns {boolean}
 */
function pegIsTimeObject(obj){
	//TODO Time
	if(
		obj.$className=="Ext.form.field.Time" || 
		obj.$className=="Pegasus.field.Time"   ||
		obj.$className=="WebApp.view.Time"  ||
		obj.$className=="WebApp.view.field.Time"  
	){
		return true;
	}
	return false;
}
/**
 * If the object instance of 
 * 
 * 		- Ext.form.field.HtmlEditor
 * 		- WebApp.view.HtmlEditor
 * 
 * @param {Object} obj 
 * @returns {boolean}
 */
function pegIsHTMLEditorObject(obj){
	//TODO Time
	if(
		obj.$className=="WebApp.view.HtmlEditor" || 
		obj.$className=="Ext.form.field.HtmlEditor" 
	){
		return true;
	}
	return false;
}
/**
 * If the object instance of 
 * 
 * 		- Ext.ux.form.TinyMCETextArea
 * 		- Pegasus.field.TinyMCETextArea
 * 		- WebApp.view.TextArea.TinyMCE
 * 		- WebApp.view.field.textarea.tinyMCE.TinyMCE
 * 
 * @param {Object} obj 
 * @returns {boolean}
 */
function pegIsTinyMCETextAreaObject(obj){ 
	if(
		obj.$className=="Ext.ux.form.TinyMCETextArea" || 
		obj.$className=="Pegasus.field.TinyMCETextArea"  || 
		obj.$className=="WebApp.view.TextArea.TinyMCE" ||
		obj.$className=="WebApp.view.field.textarea.tinyMCE.TinyMCE"
	){
		return true;
	}
	return false;
}



/**
 * If the object instance of 
 * 
 * 		- Ext.form.field.Picker
 * 		- WebApp.view.field.ComboBoxV2
 * 
 * @param {Object} obj 
 * @returns {boolean}
 */
function pegIsComboboxV2Object(obj){ 
    if(
          obj.$className=="Ext.form.field.Picker" || 
          obj.$className=="WebApp.view.field.ComboBoxV2"  
     ){
          return true;
     }
      return false;
}

/**
 * If the object instance of 
 * 
 * 		- Ext.form.RadioGroup
 * 		- Pegasus.field.RadioGroup
 * 		- WebApp.view.field.Radio
 * 
 * @param {Object} obj 
 * @returns {boolean}
 */
function pegIsRadioObject(obj){ 
	if(
		obj.$className == "Ext.form.RadioGroup"  ||
		obj.$className == "Pegasus.field.RadioGroup" ||
		obj.$className == "WebApp.view.field.Radio"
	){
		return true;
	}
	return false;
}
/**
 * If the object instance of 
 * 
 * 		- Ext.form.field.Tag
 * 		- WebApp.view.Tag
 * 		- WebApp.view.field.Tag
 * 
 * @param {Object} obj 
 * @returns {boolean}
 */
function pegIsTagObject(obj){ 
	if(
		obj.$className == "Ext.form.field.Tag"  ||
		obj.$className == "WebApp.view.Tag" ||
		obj.$className == "WebApp.view.field.Tag"
	){
		return true;
	}
	return false;
}
/**
 * If the object instance of 
 * 
 * 		- Ext.grid.Panel
 * 		- Pegasus.grid.Panel
 * 		- WebApp.view.Grid
 * 		- WebApp.view.grid.Grid
 * 
 * @param {Object} obj 
 * @returns {boolean}
 */
function pegIsGridObject(obj){ 
	if(
		obj.$className == "Ext.grid.Panel"  ||
		obj.$className == "Pegasus.grid.Panel" ||
		obj.$className == "WebApp.view.Grid" ||
		obj.$className == "WebApp.view.grid.Grid" 
	){
		return true;
	}
	return false;
}


/**
 * If the object instance of 
 * 
 * WebApp.view.field.ComboBoxV2
 * WebApp.element.ComboBoxV2
 * 
 * @param {Object} obj 
 * @returns {boolean}
 */
function pegIsComboboxV2Object(obj){ 
	if(
		obj.$className == "WebApp.view.field.ComboBoxV2"  ||
		obj.$className == "WebApp.element.ComboBoxV2" 
	){
		return true;
	}
	return false;
}