/**
 * @class Functions.core.tab
 * 
 * @member WebApp.view
 * 
 *  ##Properties
 *  
 *  The global variables of the module
 *  
 *   
 *  ##Methods
 * 
 */

/**
 * 
 * @param {String} tab_id [='_main_d_tab'] the id of {@link WebApp.view.tab.Tab}  
 * @param {String} table the table of the ID
 * @param {String} _d The id tha will display
 * @param {String} module The module tha _d belonks
 * @param {String} container_id //deprecated   Use ''
 * @param {Number} nr01 the id of the rec to table
 * @param  {String} url_vars  //deprecated   Use {@link pegAddTab_d#params00}
 * @param {Object} params00
 * @param {String} peg_screen_parent_container_id The container id of the parent
 * @param {String} peg_screen_parent_element_name The name of the parent element
 * @returns
 */
function pegAddTab_d(tab_id , table , _d , module , container_id , nr01 , url_vars , params00, peg_screen_parent_container_id, peg_screen_parent_element_name){	
	if(container_id==undefined){ container_id='';}
	if(pegGetFramework() == 'peg002'){
		return peg002_addTab_d(tab_id , table , _d , module , container_id , nr01 , url_vars , params00, peg_screen_parent_container_id, peg_screen_parent_element_name) ;
	}
	//pegAlert('Alert 00');
	//return;
	if((tab_id == null) || (tab_id=='')){
		if(main_tab_id!='undefined'){
			tab_id = main_tab_id;
		}else{
			return;
		}
	}
	
	if(container_id==''){
		container_id = tab_id + '_' +  table + '_' + _d + '_' + module + '_' +  nr01; 

	} 			
	if(_d==''){
		return;
	} 			    		
	if(module==''){
		return;
	} 			
    //if(!url_vars){
	//	url_vars='?';
    //}
    if(!peg_screen_parent_container_id){
    	peg_screen_parent_container_id='';
    }else if (typeof peg_screen_parent_container_id === 'string') {
    	url_vars += '&peg_screen_parent_container_id='+peg_screen_parent_container_id; 
    }
    
    if(!peg_screen_parent_element_name){
    	peg_screen_parent_element_name='';
    }else if (typeof peg_screen_parent_element_name === 'string') {
    	url_vars += '&peg_screen_parent_element_name='+peg_screen_parent_element_name;
	} 
    
    
  	var parms = {};	       	
   	var screen_data;       	
    var params = {
    	layout: {type:'fit'},
    	
    	/* 
    	region:'center',   		
 		width: Ext.getCmp(tab_id).getWidth(),
 		height: Ext.getCmp(tab_id).getHeight(),  
 		 */
    	border:0,
       	loader: {	 
		      url: '',
			  renderer:    'html' ,	
			  contentType: 'html' ,
			  scripts: true,
			  listener:{}
		},
		listeners: {
			  added:function(){},	
			  activate:function(tab){},
              render: function(tab) {
              	tab.loader.load();
               	tab.setLoading(dic_mask_msg);
               	tab.loader.on('load' , function(){	 
                   		Ext.Function.defer(function(){tab.setLoading(false);} , 300); 
                   	});	                   	
              	  },
              	  close:function(panel){	            
              	  		pegTabClose(panel.id);
              	  }
			}
        };	       	 
       	
 
		Ext.Ajax.request({
	    	url: '/' +main_path + '/core_global/get_screen_params.php?_d=' +_d + '&module=' + module + '&container_id=' + container_id + '&nr01=' + nr01 + '&table=' + table,		    	
    	success: function(response){
    		var text = response.responseText;
			var screen_data = Ext.JSON.decode(text);										
			if(screen_data){
				params.title = screen_data.title;
				if(parseFloat(nr01)>=0){
					params.title = params.title  + ' (' + nr01 + ')';
				}
			}			 				
			params.id =  "" + screen_data.container_id ;		    		
			params.loader.url=
				'/' + main_path + '/core_global/show_d.php?parent_id=' + screen_data.container_id  + 
				'&table=' + table + '&_d=' + _d +
				'&module=' + module + '&nr01=' + nr01 + '&container_id=' +  screen_data.container_id + url_vars ;
			params.loader.params=params00;

			// Find the TAB
			var tabs = Ext.getCmp(tab_id);
			 if(tabs){
				// Find if tab exist with the same title
	         	var totalItems = tabs.items.getCount();
	        	for (i = 0; i < totalItems; i++) {
	        		 title00  = tabs.items.get(i).title;
					 if(params.title==title00){
						 tabs.setActiveTab( i );
						 return;
					 }	 
	        	}
	       /*	params.minHeight=768;* params.scrollable =true; */
        		params.closable='true';	
        	
				tabs.nextTabNumber = tabs.items.getCount() + 1;
				tabs.add(params).show();  
				tabs.move(tabs.items.getCount(),1)   ;          						        	
			} 
    	}
	});            	        	
} 

function pegEditRec2Tab(table , _d , module , container_id , value_fld , value,  peg_screen_parent_container_id, peg_screen_parent_element_name){
	if(pegGetFramework() == 'peg002'){
		return peg002_editRec2Tab(table , _d , module , container_id , value_fld , value,  peg_screen_parent_container_id, peg_screen_parent_element_name)
	}
	pegAjax('/' + main_path + '/core_global/edit_rec_to_tab.php' , {'table':table , 'module':module , '_d':_d, 'container_id':container_id , 'value_fld':value_fld ,  'value':value} , function(jsonData){	
		if(jsonData.ok==0){
			pegAlert(jsonData.message);
			return;
		}
		
		pegAddTab_d('' , jsonData.table , jsonData._d , jsonData.module , jsonData.new_container , jsonData.nr01 , '' );
		
	} , 'json' , '1'  );
	
	return ;
	
	new_container = '';
}

/**
 * This function close a tab
 * @param {String} container_id the container id of TAB Item
 * @returns
 */
function pegTabClose(container_id){
	if(pegGetFramework() == 'peg002'){
		return peg002_TabClose(container_id) ;
	}
	
	close_params = {};
	close_params.container_id = container_id; 

	if(container_id!='' && container_id!=undefined ){
		if(Ext.getCmp(container_id)){
			Ext.getCmp(container_id).mask( dic_mask_msg );
		}
	}
	
	pegAjax('/' + main_path + '/core_global/close_d.php' , close_params , '' , 'json' , 0 );
	
	if(container_id!=''  && container_id!=undefined){
		if(Ext.getCmp(container_id)){
		 	Ext.getCmp(container_id).destroy();
		}
	}
	 
	return true;
}


/**
 *    @deprecated   Use {@link pegAddTab_d}
 */
function pegAddTab(tab_id , title , content , close , href , container_id , create_con_id , params00){
	if(pegGetFramework() == 'peg002'){
		return peg002_AddTab(tab_id , title , content , close , href , container_id , create_con_id , params00) ;
	}
	if (tab_id == null){
			 return;
		}
		
		//elenxei an den ;exei oristi h parametros create_con_id 
		if(create_con_id==null){
			create_con_id=0;	
		}
		
	if (title == null){
			 title="";
		}
	if (content == null){
			 content="";
		}
	if (href == null){
			 href="";
		}
		if (close == null){
			 close= true;
 	}
 	
 	//alert(' tab_id -> ' + tab_id);
	var tabs = Ext.getCmp(tab_id);
	        	
	var totalItems = tabs.items.getCount();
	for (i = 0; i < totalItems; i++) {
		 title00  = tabs.items.get(i).title;
		 if(title==title00){
			 tabs.setActiveTab( i );
			 return;
		 }
		 
	}
	
	if(create_con_id==0){
        	if(href!=''){
	        	var params = {
	        		autoShow:'true',
	        		layout:'fit',
	        		border:0, 
	            	loader: {
					      url: href + '&container_id='+container_id ,
					      contentType: 'html' ,
					      scripts: true,
					      listeners: {
					      	load:function(){},
					      	beforeload:function(){}
					      }
					 },
					 listeners: {
	                      render: function(tab) {
			                  	tab.loader.load();
			                   	tab.setLoading(dic_mask_msg);
			                   	tab.loader.on('load' , function(){	 
			                   		Ext.Function.defer(function(){tab.setLoading(false);} , 300);
			                   	});
	                 	  },
		              	  close:function(panel){
		              	  	pegTabClose(panel.id);
		              	  }
					 }
	        	};
	        	params.loader.params=params00;
        	}else{
        		var params = {};
        	}
        	
        	params.id=container_id;
        	params.title=title;
        	if(content!=''){
        		params.html=content;
        	}
        	
        	params.autoScroll ='true';
        	params.closable=close;
			params.deferredRender ='false';
        	 
			var i = tabs.items.getCount() + 1;
        	tabs.nextTabNumber = i ;
        	tabs.add(params).show();       

        	tabs.setActiveTab( i );       	
        	
	} else{
		
		Ext.Ajax.request({
	    	url: '/' +main_path + '/core_global/get_screen_params.php?container_id=' + container_id,		    	
	    	success: function(response){
		    	var text = response.responseText;
				var screen_data = Ext.JSON.decode(text);					

				if(href!=''){
		        	var params = {
		        		autoShow:'true',
		        		layout:'fit',
		        		border:0,
		            	loader: {
						      url: href + '&container_id='+screen_data.container_id ,
						      
						      contentType: 'html' ,
						      scripts: true,
						      listeners: {
					      	  	load:function(){
					      			Ext.getBody().unmask();
					      		}
						      }
						 },
						 listeners: {
		                      render: function(tab) {
		                      	Ext.getBody().mask(dic_mask_msg);
		                      	tab.loader.load();
		                 	  },
			              	  close:function(panel){
			              	  		pegTabClose(panel.id);
			              	  }
						 }
		        	};
		        	params.loader.params=params00;
	        	}else{
	        		var params = {};
	        	}
	        	params.id=screen_data.container_id;
	        	params.title=title;
	        	if(content!=''){
	        		params.html=content;
	        	}
	        	
	        	params.autoScroll ='true';
	        	params.closable=close;
				params.deferredRender ='false';
	        	 
				var i = tabs.items.getCount() + 1;
	        	tabs.nextTabNumber = i ;
	        	tabs.add(params).show();       
	
	        	tabs.setActiveTab( i );    						
    			
    			
	    	}
		});             			
	}
} 
/**
 * @private 
 *  @deprecated   Use {@link pegEditRec2Tab}
 * @param table
 * @param _d
 * @param module
 * @param container_id
 * @param value_fld
 * @param value
 * @returns
 */
function pedEditRec2Tab(table , _d , module , container_id , value_fld , value){
	pegEditRec2Tab(table , _d , module , container_id , value_fld , value);
}
	