/**
 * @class Functions.core.Window
 * 
 * @member WebApp.view.window.Window
 *  
 *  ##Properties
 *  
 *  The global variables of the module
 *   
 *  ##Methods
 *  
 *  The functions of the module
 *  
 */
/**
 * Display a confirm box
 * @param {String} title
 * @param {String} message
 * @param {Function} callback
 * @param {Object} [scope] The scope (`this` reference) in which the callback is executed.
 * @returns {Ext.MessageBox} 
 */
function pegConfirmBox( title , message , callback , scope ){
	if(pegGetFramework() == 'peg002'){
		return peg002_confirmBox( title , message , callback , scope );
	}
	var msgBox = Ext.create('Ext.window.MessageBox',{
		/*icon:'/' + main_path + '/core_images/confirm_48x48.png'*/
	});
	if(title==undefined){
		title = 'Pegasus Confirm';
	}	
	return msgBox.confirm(title, message , callback , scope);
}


 /**
  * Display a message box
  * @param {String} message
  * @param {String} title
  * @returns
  */
function pegMsgBox(  message , title ){
	if(pegGetFramework() == 'peg002'){
		return peg002_msgBox(  message , title );
	}
	var msgBox = Ext.create('Ext.window.MessageBox',{
		/*icon:'/' + main_path + '/core_images/info_48x48.png',*/
		overflowY : 'auto'
	});
	if(title==undefined){
		title = 'Pegasus Info';
	}
	msgBox.alert(title, message );
}

/**
 * Display an alert box 
 * see {@link pegGetDicAlert}
 * @param {String} message
 * @param {String} title
 * @returns
 */
function pegAlert(  message , title ){
	if(pegGetFramework() == 'peg002'){
		return peg002_alert(  message , title );
	}
	var msgBox = Ext.create('Ext.window.MessageBox',{
		/*icon:'/' + main_path + '/core_images/alert_48x48.png',*/
		overflowY : 'auto'
	});
	if(title==undefined){
		title = 'Pegasus Alert';
	}
	msgBox.alert(title, message );
}


function pegWindow( x , y , width , height , title , href ){	
	if(pegGetFramework() == 'peg002'){
		return peg002_window( x , y , width , height , title , href );
	}
	var params = {
				    title:   title,
				    height:  width,
				    width:   height,
				    border:0,
				    layout: 'fit',
				    closeAction :'destroy',
				   	loader: {
					      url: href ,			      
						  contentType: 'html' ,
						  scripts: true,
						  autoLoad: true
				   	}
				};
	Ext.create('Ext.window.Window', params).show();
}

function pegWindowClose(container_id , no_login_check){
	if(pegGetFramework() == 'peg002'){
		return peg002_windowClose(container_id , no_login_check);
	}
	if(container_id==''){
		return false;
	}
	
	if(no_login_check==undefined){
		no_login_check=0;
	}
	
	///return true;
	if(container_id!=''){
		if(Ext.getCmp(container_id) && Ext.getCmp(container_id)!=undefined){	
			Ext.getCmp(container_id).destroy();
			/*
			Για το πρόβλημα με την 5.1	
			*/		 
			close_params = {};
			close_params.container_id = container_id; 
			close_params.not_check_login = no_login_check;
			pegAjax('/' + main_path + '/core_global/close_d.php' , close_params , '' , 'json' , 0 );
			
		}
	}
	return true;
}

/**
 * 
 * @param {String} table the data table
 * @param {String} _d the _d to display
 * @param {String} module the module tha _d belongs
 * @param {String} [container_id= 'win_' + parent_id + '_' +  table + '_' + _d + '_' + module + '_'  + nr01] 
 * @param {Number} nr01=0
 * @param {String} url_vars @Deprecated
 * @param {String} parent_id='' the parent screen tha the subscreen will be renderd
 * @param {Number} x=0 @Deprecated
 * @param {Number} y=0 @Deprecated
 * @param {String} align='c-c'
 * @param {Object} params00={grid_element_name: '', peg_screen_parent_element_name: '', peg_screen_parent_container_id: ''}
 * @param {Boolean} modal=falses
 * @param {Boolean} closable=true
 * @param {Number} not_login_check=0
 * @param {Enum('','mobile','tablet')} responsive To open a new tab instead of window when we are in mobile/tablet screen
 * @returns
 */
function pegWindowShow_d( table , _d , module , container_id , nr01 , url_vars, parent_id , x , y  , align , params00 , modal , closable , not_login_check,responsive){
	    if(pegGetFramework() == 'peg002'){
	        return peg002_windowShow_d( table , _d , module , parent_id , container_id , nr01 , url_vars ,  align , params00 , modal , closable , not_login_check, 0,responsive);
	    }

		if(!url_vars){
       		url_vars='';
       	}
       	
       	var parent_id_width=0;
       	var parent_id_height=0;
       	
      	if(parent_id==undefined){
       		parent_id='';
       	}else{
       		if(Ext.getCmp(parent_id)){
       			parent_id_width = Ext.getCmp(parent_id).getWidth();
       			parent_id_height = Ext.getCmp(parent_id).getHeight();
       		}
       	}
       	
      	if(not_login_check==undefined){
       		var not_login_check=0;
       	}
      	if(modal==undefined){
       		modal=false;
       	}
      	if(modal==undefined){
       		modal=false;
       	}
       	
      	if(closable==undefined){
       		closable=true;
       	}
      	if(x==undefined){
       		x=0;
       	}
      	if(y==undefined){
       		y=0;
       	}
      	if(align==undefined ){
       		align='tl';
       	}
      	if(align=='' ){
       		align='tl';
       	}
       	
       	if(container_id==''){
       		container_id = parent_id + '_' +  table + '_' + _d + '_' + module + '_'  + nr01; 
       		//return;
       	}
        	
       // container_id  =Ext.id();	
       	var parms = {};
       	var style = {};
       	var left  = 0;
       	var top   = 0;
 
		pegWindowClose("" + container_id  );	
       	var screen_data; 
       	 
       	
		Ext.Ajax.request({
	    	url: '/' +main_path + '/core_global/get_screen_params.php?not_create_container_id=1&_d=' +_d + '&module=' + module + '&container_id=' + container_id + '&not_login_check=' + not_login_check ,   	
	    	success: function(response){

		    	var text = response.responseText;
	        
		    	// process server response here
				var screen_data = Ext.JSON.decode( text );					
			
				//if(response.)			
				if(parent_id!=''){
				  parms.renderTo = parent_id ;
				}
				
				//if( (!pegIsEmpty(screen_data.container_id)) && ( container_id==parent_id )){
				//	parms.id = screen_data.container_id ;
				//	container_id = screen_data.container_id;
				//}else{
					
					parms.id = container_id ;
				//}
							
				if(screen_data.width){
					parms.width = screen_data.width ;
				}
				if(screen_data.height){
					parms.height = screen_data.height ;						 
				}
		 
				if(screen_data.x>0){
					x = screen_data.x ;
				}					
				if(screen_data.y>0){
					y = screen_data.y ;
				}
				
				 
				if(screen_data.align!='' && screen_data.align!=undefined ){
					align = screen_data.align ;
				}
				
				if(screen_data.title){
					parms.title = screen_data.title ;
				}
			 
				//parms.id =  "" + container_id ;
			 	parms.autoDestroy=true;
				parms.hideMode = 'visibility';
				parms.closeAction	 = 'destroy';
				parms.shadow = false;
				//parms.toFrontOnShow  = true;
				//parms.focusOnToFront = true;
				//parms.alwaysOnTop    = true;
				 parms.floating       = true;
				//if(parent_id == ""){
				//	parent_id = Ext.getBody();
				//}
				
				parms.collapsible	=  true;
        		parms.animCollapse	= true;
        		parms.maximizable	=  true;
        
				parms.autoShow 	= false;
				parms.start_x 	= 15;
				parms.start_y 	= 15;			
				parms.layout 	= 'fit';
				parms.modal  	=  modal;
				parms.closable  =  closable;
				parms.screen_parent_id  =  parent_id;
				parms.border  =  0;
				parms.loader = { 
								  url: '/' +main_path + '/core_global/show_d.php?inWindow=1&table=' + table + '&_d=' + _d + '&module=' + module + '&nr01=' + nr01 + '&container_id=' + container_id + '&parent_id=' + container_id + url_vars + '&not_login_check=' + not_login_check ,			      
								  contentType: 'html' ,
								  scripts: true       ,
								  autoLoad: true , 
								  listeners:{
									  load:function(){}
								  }
								};
								
				parms.loader.params = params00; 
				parms.listeners = {
									move:function(this00){
										pp = [0,0];
										if(Ext.getCmp(this00.screen_parent_id)){	
											pp = Ext.getCmp(this00.screen_parent_id).getXY() ;
										}
										cc = Ext.getCmp(container_id).getXY() ; 
										/* alert('move'); */
										this00.start_x = cc[0] - pp[0];
										this00.start_y = cc[1] - pp[1];	
										if(this00.start_x<0){
											this00.start_x = 0;
										}
										if(this00.start_y<0){
											this00.start_y = 0;
										}
									},					
					
									afterlayout:function( this00 ){
										xy=[this00.start_x , this00.start_y];		
										/*alert('afterlayout');*/
										if(Ext.getCmp(container_id)){									
											if(Ext.getCmp(this00.screen_parent_id)){
												Ext.getCmp(container_id).alignTo(Ext.get(this00.screen_parent_id) , 'tl'  , xy ) ;
											}else{
												Ext.getCmp(container_id).alignTo(Ext.getBody() , 'tl'  , xy ) ;
											}
										}
										
									},
									
									maximize:function( this00 ){
										/*alert('maximize');*/
										this00.start_x = 0;
										this00.start_y = 0;	
										xy=[this00.start_x , this00.start_y];	
										if(Ext.getCmp(container_id)){
											if(Ext.getCmp(this00.screen_parent_id)){																														
												Ext.getCmp(container_id).alignTo(Ext.get(this00.screen_parent_id) , 'tl'  , xy ) ;
											}else{
												Ext.getCmp(container_id).alignTo(Ext.getBody() , 'tl'  , xy ) ;
											}
										}
									},
									
									restore:function( this00 ){
										/*alert('restore');*/
										xy=[this00.start_x , this00.start_y];
										if(Ext.getCmp(container_id)){
											if(Ext.getCmp(this00.screen_parent_id)){	
												Ext.getCmp(container_id).alignTo(Ext.get(this00.screen_parent_id) , 'tl'  , xy ) ;
											}else{
												Ext.getCmp(container_id).alignTo(Ext.getBody() , 'tl'  , xy ) ;
											}							
										}			
									},
									close:function(panel){
										
											/*pegWindowClose(panel.id  );*/		
											 
	              	  						close_params = {};
											close_params.container_id = panel.id; 
											
											close_params.not_check_login = not_login_check; 
											pegAjax('/' + main_path + '/core_global/close_d.php' , close_params , function(){
												
												if(Ext.getCmp(parent_id)){												
													id = Ext.getCmp(parent_id).last_focused;
													if(Ext.getCmp(id)){
														if(Ext.getCmp(id).$className=='Ext.grid.Panel' || Ext.getCmp(id).$className=='Pegasus.grid.Panel'){
															Ext.getCmp(id).getView().focus();
														}else{
															Ext.getCmp(id).focus();
														}
													}														 
												}
												
																					
											} , 'json' , 1   ); 
											 
								 	}	
								 };			
			
 
				pegWindowClose(parms.id  );
				win = new Ext.window.Window(parms);		
				if(parseFloat(parms.width)==0){
					parms.width=500;
				}
				
				if(parseFloat(parms.height)==0){
					parms.height=500;
				}
 
				if(parent_id_width>0){
					if(parent_id_width<parms.width){
						parms.width = parent_id_width-20;
					}
				}

				if(parent_id_height>0){
					if(parent_id_height<parms.height){
						parms.height = parent_id_height-20;
					}
				}

						

			 	win.setWidth(parseFloat(parms.width) );
				win.setHeight(parseFloat(parms.height)); 
				align = align.replace(/^\s\s*/, '').replace(/\s\s*$/, '');
				if(align==''){
					align = 'tl';
				}
				
				xy=[];
				xy[0] = parseFloat(x);
				xy[1] = parseFloat(y);
				if(parent_id!='' && Ext.getCmp(parent_id)!='undefined'){
				 	Ext.getCmp(parent_id).add(win);
				 	Ext.getCmp(container_id).show();
				 	Ext.getCmp(container_id).alignTo(Ext.get(parent_id) , align  , xy ) ;
				}else{
				 	win.show();
					Ext.getCmp(container_id).alignTo(Ext.getBody() , align  , xy ) ;
				}
	    	}	
		}); 		
}
/**
 * @param {String} table the data table
 * @param {String} _d the _d to display
 * @param {String} module the module tha _d belongs
 * @param {String} parent_id='' the parent screen tha the subscreen will be renderd
 * @param {String} [container_id= 'win_' + parent_id + '_' +  table + '_' + _d + '_' + module + '_'  + nr01]  * The container id of the screen that will be create  
 * @param {Number} nr01=0
 * @param {String} url_vars @Deprecated
 * @param {String} [align='c-c']
 * @param {Object} params00={
        grid_element_name: '',
        peg_screen_parent_element_name: '',
        peg_screen_parent_container_id: ''
 * }
 * @param {Boolean} modal=false
 * @param {Boolean} closable=true
 * @param {Number} not_login_check=0
 * @param zIndex
 * @param {Enum('','mobile','tablet')} responsive To open a new tab instead of window when we are in mobile/tablet screen
 * @returns
 */
function peg_windowShow_d( table , _d , module , parent_id , container_id , nr01 , url_vars ,  align , params00 , modal , closable , not_login_check, zIndex,responsive){
	    if(pegGetFramework() == 'peg002'){
	        return peg002_windowShow_d( table , _d , module , parent_id , container_id , nr01 , url_vars ,  align , params00 , modal , closable , not_login_check, zIndex,responsive);
	    }
	    return  pegWindowShow_d( table , _d , module , container_id , nr01 , url_vars, parent_id , 0 , 0  , align , params00 , modal , closable , not_login_check,responsive);
}
	