Ext.define('Pegasus.field.Number', {
   extend: 'Ext.form.field.Number',
   
   config: {
    	mouseWheelEnabled:true,
		validateOnChange:true,
		validateOnBlur:true  ,
		enableKeyEvents:true,
		autoStripChars:false,
		baseChars:'0132456789,.'
   },
   
   onRender:function() {							    
	   	this.callParent(arguments); 
	 	if(this.getEl().child('#' + this.getEl().id + '-bodyEl')){
			this.getEl().child('#' + this.getEl().id + '-bodyEl').on('contextmenu', function(e, t , eOpts){									
		   		e.stopPropagation();
			});
		}
		
  		if(pegIsEmpty(this.getValue())){
			this.setValue('0.00000000000000');
		}
		 
		if(Ext.get('peg_content_tip_' + this.container_id + '_' + this.name)){
			var tip =  Ext.get('peg_content_tip_' + this.container_id + '_' + this.name).getValue() ;
			if(!pegIsEmpty(tip)){
				this.tip = Ext.create('Ext.tip.ToolTip', { target: this.getEl(), trackMouse: true, anchor :'left', html: tip });
			}	
		}							    			   	
	},
	
	onBlur:function() {							    
	   	this.callParent(arguments);
		if(!this.isValid()){
		 	this.setValue('0.00000000000000');
		 	this.focus(false, true);
		 }
											 
		 if(pegIsEmpty(this.getValue())){
		 	this.setValue('0.00000000000000');
		 }
	},
								   
	onChange:function() {							       		 
	   	this.callParent(arguments);
		var maxValue = this.maxValue;
		if(maxValue<this.getValue()){
			val00 = this.getValue().toString();
			this.setValue(val00.substr( 0 , (val00.length -1)) + ',' + val00.substr( (val00.length -1) , 1));
		} 
	},
									 
	onFocus:function(){
    	this.callParent(arguments);
   		this.peg_focused = 1;	
 		Ext.getCmp(this.container_id).last_focused = this.id;
    }   	    
  
});