<?php

class pegasusP20OnChange{
    /** Αυτή η μέθοδος προσθέτει την αντιστοιχία $key=>$value στο PHP Array  $pdo_array και επιστρέφει το pdo αναγνωριστικό id που θα εισαχθεί στο query. Η συνάρτηση φροντίζει ώστε το αναγνωριστικό να είναι μοναδικό μέσα στο PDO array
     * @param array $pdo_array O πινακας με τα sqlParams - by referrence
     * @param string $key Το αναγνωριστικό id της pdo παραμέτρου
     * @param string $value  Η τιμή της pdo παραμέτρου
     * @return array Ένας string στη μορφή ":".{unique key}
     */
    private static function add_pdo_value(&$pdo_array,$key,$value){
		$i=0;
		$key=trim($key);
		$tmpKey=$key;
		while(isset($pdo_array[$tmpKey])){
			$tmpKey=$key.'_'.$i;
			$i++;
		}
		$pdo_array[$tmpKey]=$value;
		return ' :'.$tmpKey.' ';
	}
    /** Αυτή η μέθοδος επιστρέφει ένα array με όλα τα relations του δοσμένου πίνακα
     * @param array $table O πινακας
     * @return array Ένας php πίνακας με τα στοιχεία της συσχέτισης.
     */
    private static function getAllRelations($table){
        $queryParam=array();
        $query="SELECT  if(p01=".self::add_pdo_value($queryParam,'var_tb',$table)." ,p03, p01) as other_tb,
                        if(p01=".self::add_pdo_value($queryParam,'var_tb',$table)." ,p04, p02) as other_fld1,
                        if(p01=".self::add_pdo_value($queryParam,'var_tb',$table)." ,p14, p12) as other_fld2,
                        if(p01=".self::add_pdo_value($queryParam,'var_tb',$table)." ,p24, p22) as other_fld3,
                        if(p01=".self::add_pdo_value($queryParam,'var_tb',$table)." ,p01, p03) as tb,
                        if(p01=".self::add_pdo_value($queryParam,'var_tb',$table)." ,p02, p04) as fld1,
                        if(p01=".self::add_pdo_value($queryParam,'var_tb',$table)." ,p12, p14) as fld2,
                        if(p01=".self::add_pdo_value($queryParam,'var_tb',$table)." ,p22, p24) as fld3,
                        if(p01=".self::add_pdo_value($queryParam,'var_tb',$table)." ,p010, p030) as ch

                FROM p20 WHERE (p01=".self::add_pdo_value($queryParam,'var_tb',$table)." AND p010=1 OR 
                                p03=".self::add_pdo_value($queryParam,'var_tb',$table)." AND p030=1)";
        $result=pegasus_query($query,$queryParam);
        $p20array=array();
        //var_dump(pegasus_replace_values_in_sql($query,$queryParam));
        while($row=pegasus_fetch($result)){
            $p20array[]=$row;
        }
        return $p20array;
        
    }
    /** Αυτή η μέθοδος αλλάζει όλες τις συσχετιζόμενες εγγραφές που συνδέονται με την εγγραφη με ΜΚ $nr01 του πίνακα $table
     * @param string $table Ο πίνακας που τροποποιήθηκε
     * @param string $nr01  Το ΜΚ της εγγραφής που τροποποιήθηκε
     * @param array $old_data Τα δεδομένα της εγγραφής πριν την αλλαγή
     * @param array $new_data Τα νέα δεδομένα της εγγραφής
     * @param array $track_array Ο πίνακας με τα ΜΚ ανά πίνακα της βάσης που τροποποιήθηκαν . Πχ array('i00'=>array(1,234,5) , 'a00'=>array(55,56) )
     */
    public static function changeRelatedRecords($table,$nr01,$old_data,$new_data,&$track_array){
        $p20recs=self::getAllRelations($table);
        foreach($p20recs as $p20){
            $recsarray=self::getAllRelatedRecs($p20,$old_data);
            foreach ($recsarray as $rec) {
                $makeCh=self::make_change00($p20,$track_array,$rec,$old_data,$new_data);
                if($makeCh){
                    pegasus_mysql_use("SELECT * FROM ".$p20['other_tb']." WHERE nr01=?",$rec_new,array($rec['nr01']));
                    self::changeRelatedRecords($p20['other_tb'],$rec['nr01'],$rec,$rec_new,$track_array);
                }
            }
        }
        
    }
    /** Αυτή η μέθοδος επιστρέφει ένα πίνακα με τις εγγραφές που σχετίζονται με τη δοσμένη με βάση τη συσχέτιση που περνάμε ως όρισμα
     * @param array $p20 Η δοσμένη συσχέτιση
     * @param array $old_data Τα δεδομένα της αρχικής εγγραφής
     * @return array  Ο πίνακας με τις εγγραφές που βρέθηκαν
     */
    private static function getAllRelatedRecs($p20,$old_data){
        $other_table=$p20['other_tb'];
        $fld1=$p20['fld1'];
        $other_fld1=$p20['other_fld1'];
        $fld2=$p20['fld2'];
        $other_fld2=$p20['other_fld2'];
        $fld3=$p20['fld3'];
        $other_fld3=$p20['other_fld3'];

        $query00Params=array();
        $query00="  SELECT $other_table.* FROM $other_table WHERE 1=1 ";
        $query00.=" AND $other_table.$other_fld1=";
        if(substr($fld1,0,2)=='!:'){
            $query00.=self::add_pdo_value($query00Params,'var_p20_fld1',substr($fld1,2)) ;
        }else{
            $query00.=self::add_pdo_value($query00Params,'var_p20_fld1',$old_data[$fld1]) ;
        }
        
        if(!empty($fld2) && substr($other_fld2,0,2)!='!:'){

            $query00.=" AND $other_table.$other_fld2= ";
            if(substr($fld2,0,2)=='!:'){
                $query00.=self::add_pdo_value($query00Params,'var_p20_fld2',substr($fld2,2)) ;
            }else{
                $query00.=self::add_pdo_value($query00Params,'var_p20_fld2',$old_data[$fld2]) ;
            }
        } 
        if(!empty($fld3) && substr($other_fld3,0,2)!='!:'){
            $query00.=" AND $other_table.$other_fld3= ";
            
            if(substr($fld2,0,2)=='!:'){
                $query00.=self::add_pdo_value($query00Params,'var_p20_fld3',substr($fld3,2)) ;
            }else{
                $query00.=self::add_pdo_value($query00Params,'var_p20_fld3',$old_data[$fld3]) ;
            }
        } 
        $res=pegasus_query($query00,$query00Params);
        $recsarray=array();
        while($row=pegasus_fetch($res)){
            $recsarray[]=$row;
        }
        return $recsarray;
    }
    /** Αυτή η μέθοδος ενημερώνει τη δοσμένη εγγραφή με τα δεδομένα που υπάρχουν στο $new_data και αφορούν τα πεδία της συσχέτισης
     * @param array $p20 Η δοσμένη συσχέτιση
     * @param array $p20 Ο πίνακας που περιέχει τις εγγραφές ανά db table που έχουν ενημερωθεί
     * @param array $rec Η εγγραφή προς ενημέρωση
     * @param array $old_data Τα δεδομένα της αρχικής εγγραφής
     * @param array $new_data Τα νέα δεδομένα της εγγραφής
     * @return boolean  true- αν έγινε η ενημέρωση . false- αν δεν έγινε η ενημέρωση
     */
    private static function make_change00($p20,&$track_array,$rec,$old_data,$new_data){
        $table=$p20['other_tb'];
        /**Record has already changed */
        if(!empty($track_array[$table]) && 
            in_array($rec['nr01'],$track_array[$table])){
            return false;
        }
        if(empty($track_array[$table])){
            $track_array[$table]=array();
        }
        array_push($track_array[$table], $rec['nr01']);

        if( ! ( $old_data[$p20['fld1']] != $new_data[$p20['fld1']] || 
                $old_data[$p20['fld2']] != $new_data[$p20['fld2']] || 
                $old_data[$p20['fld3']] != $new_data[$p20['fld3']])){
            return false;
        }
        $arr1=array(); $arr2=array();
        
        if(substr($p20['other_fld1'],0,2)!='!:' && $old_data[$p20['fld1']] != $new_data[$p20['fld1']]  ){
            array_push($arr1,$p20['other_fld1']); array_push($arr2,$new_data[$p20['fld1']]); 
        }
        if(substr($p20['other_fld2'],0,2)!='!:' && !empty($p20['fld2']) && $old_data[$p20['fld2']] != $new_data[$p20['fld2']] ){
            array_push($arr1,$p20['other_fld2']); array_push($arr2,$new_data[$p20['fld2']]); 
        }
        if(substr($p20['other_fld3'],0,2)!='!:' &&!empty($p20['fld3']) && $old_data[$p20['fld3']] != $new_data[$p20['fld3']]  ){
            array_push($arr1,$p20['other_fld3']); array_push($arr2,$new_data[$p20['fld3']]); 
        }
        pegasus_mysql_update($p20['other_tb'],$arr1,$arr2,'nr01=?',0,1,1,array($rec['nr01']));
        return true;
    }

}