function crm001_change_pc00(container_id){
	
	if(pegGetVal('pc22' , container_id)!=''){
		pegSetVal('p22' , container_id , '');
		pegSetFieldReadonly('p22' , container_id , true);
		
	}else{
		pegSetFieldReadonly('p22' , container_id , false);
		
	}
}

function crm001_change_p7_1(container_id){
	var params =  pegGetFormVal(container_id , 'dias_fld_');
	params.mode='p7_1';
	pegAjax('/' + main_path + '/crm001_d00/address.php' , params , function(jsonData){
		if(jsonData.p06!=''){
			if(pegGetCmp(container_id,'p06').xtype=='pegasusComboBoxV2'){
				pegSetVal('p06' , container_id , 
							{'value':jsonData.p06,
							 'display':jsonData.p06_display}	);
			}else{
				pegSetVal('p06' , container_id , jsonData.p06);
			}
		}
	} , 'json' , true);
	
}

function crm001_d00_d03_find_address_data(container_id,mode){
	var params = {};
	params.tk=pegGetVal('p7_1',container_id);
	params.d23p01=pegGetVal('p013',container_id);
	params.d27p01=pegGetVal('p014',container_id);
	params.d22p01=pegGetVal('p06',container_id);
	params.peg_search_locality_short_name=pegGetCmp(container_id,'p7_1').peg_search_locality_short_name;
	params.peg_search_locality_long_name=pegGetCmp(container_id,'p7_1').peg_search_locality_long_name;

	params.mode=mode;
	pegAjax('/' + main_path + '/crm000_01/find_address_data.php' , params , function(jsonData){
		if( jsonData.change_d22 && pegGetVal('p06' , container_id )!=jsonData.d22 ){ 
			pegSetVal('p06' , container_id ,  {'value':jsonData.d22,'display':jsonData.d22_display}	); 
		}
		if(  jsonData.change_d27  && pegGetVal('p014' , container_id )!=jsonData.d27){
			pegSetVal('p014' , container_id ,  {'value':jsonData.d27, 'display':jsonData.d27_display});
		}
		if( jsonData.change_d23 && pegGetVal('p013' , container_id )!=jsonData.d23){ 
			pegSetVal('p013' , container_id , {'value':jsonData.d23, 'display':jsonData.d23_display});
		}
		pegGetCmp(container_id,'p7_1').peg_search_locality_short_name=null;
		pegGetCmp(container_id,'p7_1').peg_search_locality_long_name=null;

	} , 'json' , true); 
}

function crm001_d64_d_afterDraw_listeners(container_id){

	var p00 = pegGetVal('p00' , pegGetCmp(container_id).peg_screen_parent_container_id);
	if(p00 != ''){
		pegSetVal('p00', container_id, p00)
	}

	var grid	= pegGetCmp(container_id , 'grid');

	grid.record_insert = function(me,row){
		 
		 
		  
		peg_windowShow_d(
				  me.peg_view_table,
				  me.peg_view__d,
				  me.peg_view_module,
				  me.getContainer_ID(),
				  '',
				  0,
				  me.store.url_vars00 ,
				  '',
				  {
					  mmnr01:me.getMmnr01(),
					  mnr01: me.getGridMnr01(),
					  peg_screen_parent_element_name: me.name,
					  peg_screen_parent_container_id: me.getContainer_ID(),
					  peg_tbl: 'd64'
				  }
		  );
		   
  };
}

function crm001_d65_d_afterDraw_listeners(container_id){

	var grid	= pegGetCmp(container_id , 'grid');

	grid.record_insert = function(me,row){
		 
		 
		  
		peg_windowShow_d(
				  me.peg_view_table,
				  me.peg_view__d,
				  me.peg_view_module,
				  me.getContainer_ID(),
				  '',
				  0,
				  me.store.url_vars00 ,
				  '',
				  {
					  mmnr01:me.getMmnr01(),
					  mnr01: me.getGridMnr01(),
					  peg_screen_parent_element_name: me.name,
					  peg_screen_parent_container_id: me.getContainer_ID(),
					  peg_tbl: 'd65'
				  }
		  );
		   
  };
}
function crm001_d64_d001_afterDraw_listeners(container_id){
	var grid	= pegGetCmp(container_id , 'grid');
	
  
  	grid.record_insert = function(me,row){
		 
		 
		  
		  peg_windowShow_d(
					me.peg_view_table,
					me.peg_view__d,
					me.peg_view_module,
					me.getContainer_ID(),
					'',
					0,
					me.store.url_vars00 ,
					'',
					{
						mmnr01:me.getMmnr01(),
                        mnr01: me.getGridMnr01(),
                        peg_screen_parent_element_name: me.name,
                        peg_screen_parent_container_id: me.getContainer_ID(),
                        peg_tbl: 'd64'
					}
			);
			 
	};

}

function crm001_d65_d00_d_afterDraw_listeners(container_id){
	var screen = pegGetCmp(container_id);
	var grid=pegGetCmp(container_id,'grid');
	grid.on('edit', function(editor, context) { 
		values = context.record.data;
		pegSave_grid_row(grid.peg_view__d, grid.peg_view_table, grid.peg_view_module, 
		grid.getMnr01(),grid.getMmnr01(), values, function(jsondata){  
			if(!jsondata.ok){ 
				context.record.reject();
				pegAlert(jsondata.message);
			}else{	
				context.record.commit();
				crm001_update_d64d65_rec_on_save(screen,'d65',jsondata.data);
			}		
		});
	});
	grid.on('canceledit', 
		function(editor, context) {  
			context.record.reject();  
		}
	);
	grid.on('peg_delete',function(me,rec){ 
		crm001_d64d65_delete_rec(grid,'d65',rec);
	});
	grid.on('peg_delete_all',function(me,recs){
		
	    var container_id= pegGetCmp(grid.getContainer_ID()).getPeg_screen_parent_container_id();
		var d00_d_container_id=pegGetContainer_id_d(container_id,'d00_d',0,'d00_d');
		var d00_d00_container_id=pegGetContainer_id_d(d00_d_container_id,'d00_d00',0,'d00_d00');
		crm001_d00_d00_d64d65_remove_empty_recs(d00_d00_container_id,'d65'); 
		pegGridRefresh( container_id , grid.name);
	});
}

function crm001_d64_d00_d_afterDraw_listeners(container_id){
	var screen = pegGetCmp(container_id);
	var grid=pegGetCmp(container_id,'grid');
	grid.on('edit', function(editor, context) { 
		values = context.record.data;
		pegSave_grid_row(grid.peg_view__d, grid.peg_view_table, grid.peg_view_module, 
		grid.getMnr01(),grid.getMmnr01(), values, function(jsondata){  
			if(!jsondata.ok){ 
				context.record.reject();
				pegAlert(jsondata.message); 
			}else{	
				context.record.commit();
				crm001_update_d64d65_rec_on_save(screen,'d64',jsondata.data);
			}		
		});
	});
	grid.on('canceledit', 
		function(editor, context) {  
			context.record.reject();  
		}
	);
	grid.on('peg_delete',function(me,rec){
		crm001_d64d65_delete_rec(grid,'d64',rec);
	});
	grid.on('peg_delete_all',function(me,recs){
		var container_id= pegGetCmp(grid.getContainer_ID()).getPeg_screen_parent_container_id();
		var d00_d_container_id=pegGetContainer_id_d(container_id,'d00_d',0,'d00_d');
		var d00_d00_container_id=pegGetContainer_id_d(d00_d_container_id,'d00_d00',0,'d00_d00');
		crm001_d00_d00_d64d65_remove_empty_recs(d00_d00_container_id,'d64'); 
		pegGridRefresh( container_id , grid.name); 
	});
}


function crm001_d65_d001_afterDraw_listeners(container_id){
	var grid	= pegGetCmp(container_id , 'grid');
	
  
  	grid.record_insert = function(me,row){
		 
		 
		  
		  peg_windowShow_d(
					me.peg_view_table,
					me.peg_view__d,
					me.peg_view_module,
					me.getContainer_ID(),
					'',
					0,
					me.store.url_vars00 ,
					'',
					{
						mmnr01:me.getMmnr01(),
                        mnr01: me.getGridMnr01(),
                        peg_screen_parent_element_name: me.name,
                        peg_screen_parent_container_id: me.getContainer_ID(),
                        peg_tbl: 'd65'
					}
			);
			 
	};

}

function crm001_d00_d00_afterDraw_listeners(container_id){
	var screen = pegGetCmp(container_id);
	
}

function crm001_d00_d02_afterDraw_listeners(container_id){
	var screen = pegGetCmp(container_id);
	
	/*Button  check VAT ID*/
	var btafmsh = pegGetCmp(container_id , 'btafmsh');
	
	btafmsh.setHandler(function(){
		customers_a01_taxixNetdata( container_id, 'd00'); 
	});
	 
	var pc22	= pegGetCmp(container_id , 'pc22');
	pc22.on('change', function(me, newValue, oldValue, eOpts ){
		if(newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue) )){
			return ;
		} 
       
        crm001_change_pc00(container_id);
	});	 
	 
}

function crm001_d00_d03_afterDraw_listeners(container_id){
	var screen   = pegGetCmp(container_id);
	var p4   = pegGetCmp(container_id , 'p4');
	var p013 = pegGetCmp(container_id , 'p013');
	var p014 = pegGetCmp(container_id , 'p014');
	var p06  = pegGetCmp(container_id , 'p06');
	var p53  = pegGetCmp(container_id , 'p53');
	var p7_1 = pegGetCmp(container_id , 'p7_1');
	var btopgmaps = pegGetCmp(container_id , 'btopgmaps');
	
	
	
	btopgmaps.setPeg_handler(function(me){
			var peg_tmp_plat = pegGetVal_d('plat' , me.getContainer_ID() , 'd00_d03' , 'd00_d' , 'd00_d03');  
            var peg_tmp_plng = pegGetVal_d('plng' , me.getContainer_ID() , 'd00_d03' , 'd00_d' , 'd00_d03');   
            if(peg_tmp_plat  && peg_tmp_plng){ 
                 win = window.open('http://maps.google.com/?q='+peg_tmp_plat +','+peg_tmp_plng); 
            }else{
            	pegGetDicAlert('peg_dic_crm000_geocodingapi_emptyloc');
            }		 
	});
	p4.on(
		'peg_place_changed',
		function (myTextfield, placeLocation) {
			pegSetVal('p4',container_id,placeLocation.formatted_address);
			placeLocation.address_components.forEach(
				it=>{	
						if(	it.types.find(tp=>{return tp=='postal_code'})	){
							pegSetVal('p7_1',container_id,it.long_name.replace(' ',''));
							pegSetVal('plat',container_id, placeLocation.geometry.location.lat());
							pegSetVal('plng',container_id, placeLocation.geometry.location.lng());
							crm001_d00_d03_find_address_data(container_id,'tk');
						}
						if(	it.types.find(tp=>{return tp=='country'})	){
							pegSetVal('p013',container_id,it.short_name.replace(' ',''));
							crm001_d00_d03_find_address_data(container_id,'tk')
						}
						if(	it.types.find(tp=>{return tp=='locality'})	){
							p7_1.peg_search_locality_short_name=it.short_name.replace(' ',''); 
							p7_1.peg_search_locality_long_name=it.long_name.replace(' ',''); 
						}
				}
			);
		}
	);
	/**Χώρα - Πίνακας d23**/
	p013.on('change', function(me,newValue, oldValue, eOpts){
		if(newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue) )){
			return ;
		}
		crm001_d00_d03_find_address_data(container_id,'d23');
	});
	/**Νομός - Πίνακας d27**/
	p014.on('change', function(me, newValue, oldValue, eOpts ){
		if(newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue) )){
			return ;
		}
		crm001_d00_d03_find_address_data(container_id,'d27');
	});
	
	/**Πόλη - πίνακας d22**/
	p06.on('change', function(me, newValue, oldValue, eOpts ){
		if(newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue) )){
			return ;
		}
		crm001_d00_d03_find_address_data(container_id,'d22');
	});
	
	/**Tαχυδρομικός Κώδικας**/
	p7_1.on('blur', function(me){
		if(me.peg_onBlurValueHasChanged()){
			crm001_d00_d03_find_address_data(container_id,'tk');
		}					
	}); 
}

function crm001_d65_d64_mail02(nr01, d65_or_d64, container_id){
		
		var params = {};
		params.nr01 = nr01;
		params.d65_or_d64 = d65_or_d64;
		
		pegAjax('/' + main_path + '/crm00101/d65_d64_send_mail.php' , params , function(jsonData){		
			
			if(jsonData.ok==1){
				pegAddTab_d('', '', 'mail_send_d00', 'mail' ,'' , '', '&peg_table=' + jsonData.table + '&peg_nr01=' + jsonData.nr01, {}, container_id );
			}
			else{
				pegAlert(jsonData.msg);
			}
		} , 'json' , true);	
}

function crm001_d00_d50_afterDraw_listeners(container_id){
	var grid = pegGetCmp(container_id ,'grid');
	grid.on('edit', function(editor, context) { 
		values = context.record.data;
		pegSave_grid_row(grid.peg_view__d, grid.peg_view_table, grid.peg_view_module, 
		grid.getMnr01(),grid.getMmnr01(), values, function(jsondata){  
			if(!jsondata.ok){ 
				context.record.reject();
				pegAlert(jsondata.message);
			}else{	
				context.record.commit();
			}		
		});
	});
	grid.on('canceledit', 
		function(editor, context) {  
			context.record.reject();  
		}
	);
}

function crm001_d00_d51_afterDraw_listeners(container_id){
	var screen = pegGetCmp(container_id);
	var grid   = pegGetCmp(container_id,'grid');
	
	grid.on('peg_delete',function(me,rec){
		crm001_update_d64d65_rec_on_save(screen, 'd64', rec);
		crm001_update_d64d65_rec_on_save(screen, 'd65', rec);
		pegGridRefresh(grid.getContainer_ID(), grid.name);
	});
	
	grid.on('peg_delete_all',function(me,recs){
	});
}

function crm001_d00_d_comboboxV2_extraSearchFields(combo){
	pegGetDic('peg_dic_crm001_all_emails', function(desc){ 
		combo.addExtraSearchField('d65',desc,'textbox',3,1); 
	});   
	pegGetDic('peg_dic_crm001_all_phones', function(desc){ 
	 combo.addExtraSearchField('d64',desc,'textbox',3,1); 
	}); 
	
}

function crm001_d00_d_update_fldcont01_title(container_id){
	let fldcont01= pegGetCmp(container_id ,'fldcont01');
	let screenData=pegGetCmp(container_id).peg_getData();
	if(fldcont01.peg_isCollapsed() && screenData.p19 !== undefined && (screenData.p19.length> 0) ){
		let p19, chars=40;
		if(peg002_IsMobileScreen()){
			chars=30;
		}

		if(screenData.p19.length>=chars){
			p19=screenData.p19.substr(0,chars-3)+'...';
		}else{
			p19=screenData.p19;
		}

		fldcont01.setTitle(p19);
	}else{
		fldcont01.setTitle(fldcont01.title00);
	}
}

function crm001_d00_d_afterDraw_listeners(container_id){
	var screen = pegGetCmp(container_id);
	let fldcont01 = pegGetCmp(container_id ,'fldcont01');
	var p19 = pegGetCmp(container_id , 'p19');
		
	p19.on('change', function (me, e) {
		crm001_d00_d_update_fldcont01_title(container_id);
	});
	crm001_d00_d_update_fldcont01_title(container_id);
	fldcont01.on('collapse',function(){	
		crm001_d00_d_update_fldcont01_title(container_id);
	});
	fldcont01.on('expand',function(){
		crm001_d00_d_update_fldcont01_title(container_id);
	});		

	var d00_d02_container_id = pegGetContainer_id_d(container_id,'d00_d02','','d00_d')
	// Target Groups
	var p51 = pegGetCmp(container_id, 'p51');
	if(!p51) {
		p51 = pegGetCmp(d00_d02_container_id, 'p51');
	}
	p51.on('change', function (me, newValue, oldValue, eOpts) {
		if (
			newValue == oldValue 
			|| pegIsEmpty(newValue)
		) {
			return;
		}
		crm001_d00_d_update_p161(container_id, newValue);
	});
	// ΚΑτηγορίες επαγγέλματος
	var p161 = pegGetCmp(container_id, 'p161');
	if(!p161) {
		p161 = pegGetCmp(d00_d02_container_id, 'p161');
	}
	p161.on('change', function (me, newValue, oldValue, eOpts) {
		if (
			newValue == oldValue 
			|| pegIsEmpty(newValue)
		) {
			return
		}
		crm001_d00_d_update_p51(container_id, newValue);
	});

	var erpa70_btn = pegGetCmp(container_id ,'erpa70_btn');
	if(erpa70_btn) {
		erpa70_btn.setPeg_handler(function(me){
			peg_photos_erpa70_record_photo_d_show(screen)
		});
	}

}

var crm001_return_d88_ajax = '';
function crm001_return_d88(container_id, mode) {

	params = {};
	/* Έργα */
	if (mode == 'd25') {
		var container_id_main = pegGetContainer_id_d(container_id, 'd25_d', '', 'd25_d');	
		params.d00 	= pegGetVal('p03', container_id_main);
		params.d88 	= pegGetVal('p03_1', container_id_main);
	}
	/* Συμβάσεις */
	if (mode == 'cona11') {
		var container_id_main = pegGetContainer_id_d(container_id, 'cona11_d', '', 'cona11_d');	
		params.d00 	= pegGetVal('p03', container_id_main);
		params.d88 	= pegGetVal('p03_1', container_id_main);
	}
	/* Δραστηριότητες */
	if (mode == 'd01') {
		var container_id_main = pegGetContainer_id_d(container_id, 'd01_d', '', 'd01_d');	
		params.d00 	= pegGetVal('p01', container_id_main);
		params.d88 	= pegGetVal('p01_1', container_id_main);
	}

	params.nr01 = pegGetVal('nr01', container_id_main);
	params.mode = mode;

	if (crm001_return_d88_ajax != '') {
		if (crm001_return_d88_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(crm001_return_d88_ajax);
		}
	}

	crm001_return_d88_ajax = pegAjaxDefer('/' + main_path + '/crm00101/crm001_return_d88.php', params, function (jsondata) {
		
		/* Έργα */
		if (mode == 'd25') {
			if (jsondata.clear_d88 == 1) {
				pegSetVal('p03_1', container_id_main, '');
			}	
			pegSetFieldHidden('p03_1', container_id_main, jsondata.d88_hidden);
		}
		/* Συμβάσεις */
		if (mode == 'cona11') {
			if (jsondata.clear_d88 == 1) {
				pegSetVal('p03_1', container_id_main, '');
			}	
			pegSetFieldHidden('p03_1', container_id_main, jsondata.d88_hidden);
		}
		/* Δραστηριότητες */
		if (mode == 'd01') {
			if (jsondata.clear_d88 == 1) {
				pegSetVal('p01_1', container_id_main, '');
			}	
			pegSetFieldHidden('p01_1', container_id_main, jsondata.d88_hidden);
		}
	});
}

var crm001_return_d69_ajax = '';
function crm001_return_d69(container_id, d00 ) {
	params = {};
	/* Δραστηριότητες */
	var container_id_main = pegGetContainer_id_d(container_id, 'd01_d', '', 'd01_d');	
	params.d00 	= d00;
	params.d69 	= pegGetVal('p312', container_id_main);
	
	if (crm001_return_d69_ajax != '') {
		if (crm001_return_d69_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(crm001_return_d69_ajax);
		}
	}

	crm001_return_d69_ajax = pegAjaxDefer('/' + main_path + '/crm00101/crm001_return_d69.php', params, function (jsondata) {

			if (jsondata.clear_d69 == 1) {
				pegSetVal('p312', container_id_main, '');
			}	
			pegSetFieldHidden('p312', container_id_main, jsondata.d69_hidden);
		
	});
}


/** Καλείται από τα κουμπιά του grid για την προσθήκη πελάτη ή προμηθευτή
 * 
 * @param {*} container_id 
 * @param {*} mode : a01|| a00 
 */
function crm001_d00_d5601_add_customer_supplier(container_id, mode) {
	let container_id_main = pegGetContainer_id_d(container_id, 'd00_d56', '', 'd00_d56');
	let screen_main = pegGetCmp(container_id_main);

	let table = 'a01';
	let view_d = 'a01_d';
	let peg_module = 'customers';

	if (mode == 'a00') {
		table = 'a00';
		view_d = 'a00_d';
		peg_module = 'suppliers';
	} 

	pegAddTab_d(
		"",
		table,
		view_d,
		peg_module,
		"",
		"",
		"",
		{
		mmnr01: screen_main.getMmnr01(),
		mnr01: screen_main.getMnr01(),
		},
		container_id,
		'grid');

}

function crm001_d00_d5604_add_customer_supplier(container_id, mode){
	let container_id_main = pegGetContainer_id_d(container_id, 'd00_d56', '', 'd00_d56');
	let screen_main = pegGetCmp(container_id_main);

	let table = 'a57';
	let view_d = 'a57_d';
	let peg_module = 'ordercust';

	if(mode == 'a67') {
		table = 'a67';
		view_d = 'a67_d';
		peg_module = 'ordersupp';
	}

	pegAddTab_d(
		"",
		table,
		view_d,
		peg_module,
		"",
		0,
		"",
		{
		mmnr01: screen_main.getMmnr01(),
		mnr01: screen_main.getMnr01(),
		},
		container_id,
		'grid');
}


function crm001_d00_d5604_grid_record_change_handler(me){
	let table;
	let view_d;
	let peg_module;
	let grid = me;
	let container_id = grid.getContainer_ID();
	let container_id_main = pegGetContainer_id_d(container_id, 'd00_d56', '', 'd00_d56');
	let screen_main = pegGetCmp(container_id_main);

	let row = pegGridGetSelectedRow(grid.getContainer_ID(), 'grid');

	console.log(row);

	if(row['p20'] == 1){

		table = 'a57';
		view_d = 'a57_d';
		peg_module = 'ordercust';
	}else{
		table = 'a67';
		view_d = 'a67_d';
		peg_module = 'ordersupp';
	}

	pegAddTab_d(
		"",
		table,
		view_d,
		peg_module,
		"",
		row['nr01'],
		"",
		{
		mmnr01: screen_main.getMmnr01(),
		mnr01: screen_main.getMnr01(),
		},
		container_id,
		'grid');

	
}
function crm001_d00_d5601_afterDraw_listeners(container_id){
	let grid = pegGetCmp(container_id ,'grid');
	let v_color_red =  'ed0e1d'; 
	let p19Col = WebApp.view.grid.Grid.peg_getColumn(grid, 'p19');
	let p21Col = WebApp.view.grid.Grid.peg_getColumn(grid, 'p21');

	grid.record_change = function(me,row){	
		params01 = {};

		if(row.nr01>0 ){
			params01.nr01 = row.a01_nr01;
			let mode = (row.p21).substr(0,2);
			let table ='a01';
			let view_d = 'a01_d';
			let peg_module = 'customers';
			if(mode=='50'){
				params01.nr01 = row.a00_nr01;
				table ='a00';
				view_d ='a00_d';
				peg_module = 'suppliers';
			}
			pegAddTab_d("", table, view_d, peg_module, "", "", "", params01, container_id, 'grid');	

		}

	}
	grid.record_copy = function(me,row){	
		params01 = {};
		if(row.nr01>0 ){
			params01.nr01 = 0;
			params01.rec_copy_nr01 = row.a01_nr01;
			let mode = (row.p21).substr(0,2);
			let table ='a01';
			let view_d = 'a01_d';
			let peg_module = 'customers';
			if(mode=='50'){
				params01.rec_copy_nr01 = row.a00_nr01;
				table ='a00';
				view_d ='a00_d';
				peg_module = 'suppliers';
			}
			pegAddTab_d("", table, view_d, peg_module, "", "", "", params01, container_id, 'grid');	

		}

	}
	if(p19Col){
		p19Col.renderer = function(value, metaData, record, rowIndex, colIndex, store, view) {  
			try {
				var anenergos_data = record.get('p0400');			// έλεγχος με το Ανενεργός	
	
				if(anenergos_data>0){
					metaData.tdStyle = "color:#"+v_color_red+";";
					metaData.style = "font-weight:bold;";
				}				
			} catch (error) {
				
			}
			return value;
		};
	}
	if(p21Col){
		p21Col.renderer = function(value, metaData, record, rowIndex, colIndex, store, view) {  
			try {
				var anenergos_data = record.get('p0400');			// έλεγχος με το Ανενεργός	
	
				if(anenergos_data>0){
					metaData.tdStyle = "color:#"+v_color_red+";";
					metaData.style = "font-weight:bold;";
				}				
			} catch (error) {
				
			}
			return value;
		};
	}

}
var d00_d5602_search_ajax = '';
function crm001_d00_d5602_afterDraw_listeners(container_id){
	let grid = pegGetCmp(container_id ,'grid');
	let p302 = pegGetCmp(container_id, 'p302');
	let p303 = pegGetCmp(container_id, 'p303');
	let btn_search = pegGetCmp(container_id ,'btn_search');
	let btn_print = pegGetCmp(container_id ,'btn_print');	
	btn_search.setHandler(function(){
		crm001_d00_d56_search(container_id);
	})
	p302.on('change',function(me, newValue, oldValue, eOpts ){
		log = '#';		
		newValue.forEach(fld =>{ log = log + fld+'#'})
		if (d00_d5602_search_ajax != '') {
			if (d00_d5602_search_ajax.id > 0) {
				Ext.ux.AjaxDefer.abort(d00_d5602_search_ajax);
			}
		}
		
		params = {}
		params.container_id = container_id
		params.logariasmoi = log
		params.p303 =  pegGetVal('p303', container_id)

		console.log(params.p303)
		d00_d5602_search_ajax = pegAjaxDefer('/' + main_path + '/crm00101/set_d00_d5602_params.php', params, function (jsondata) {
			if(jsondata.ypok){
				pegSetVal('p303', container_id, jsondata.ypok)
			}
			Ext.getCmp(p303.id).getStore().load();	
		});
	})

	btn_print.setPeg_handler(function(me){
		peg_windowShow_d(
			'',
			'account_browse_t01_d100' ,
			'account',
			container_id,
			'',
				0 ,
			'',
			'',  
			{
				peg_screen_parent_container_id:container_id
			},
			false,true,0,0,'tablet' 
		);
	});
	
}

function crm001_d00_d5604_afterDraw_listeners(container_id){
	let grid = pegGetCmp(container_id ,'grid');
	let table;
	let view_d;
	let peg_module;
	// let container_id = grid.getContainer_ID();
	let container_id_main = pegGetContainer_id_d(container_id, 'd00_d56', '', 'd00_d56');
	let screen_main = pegGetCmp(container_id_main);

	

	grid.record_delete = function () {
		let row = pegGridGetSelectedRow(container_id, 'grid');

		console.log(row);
	
		if(row['p20'] == 1){
	
			table = 'a57';
			view_d = 'a57_d';
			peg_module = 'ordercust';
		}else{
			table = 'a67';
			view_d = 'a67_d';
			peg_module = 'ordersupp';
		}

		pegGridDelSelectedRow(
			container_id,
			'grid',
			table,
			screen_main.getMnr01(),
			screen_main.getMmnr01(),
			function () {
				pegGridRefresh(container_id, 'grid');
			}
		);
	};
}


function crm001_d00_d560200_afterDraw_listeners(container_id){
	let grid = pegGetCmp(container_id ,'grid');
	var parent_id = pegGetContainer_id_d(container_id, 'd00_d5602', '', 'd00_d5602');
	
	
	grid.record_change = function(me,row){		
		window = peg_windowShow_d(
			't01',
			't01_d101',
			'account',
			container_id,
			'',
			row.nr01,
			null,
			'',
			{},
			true,
			true,
			0,
			'',
			'tablet'
		)
	}
	grid.record_insert = function(me,row){

		peg_windowShow_d(
			't01',
			't01_d101',
			'account',
			parent_id,
			'',
			0,
			null ,
			'',
			{},
			true,
			true,
			0,
			'',
			'tablet'
		);
		
	}
}
var d00_d56_search_ajax = '';
function crm001_d00_d56_search(container_id){
	let container_id_main = pegGetContainer_id_d(container_id, 'd00_d56', '', 'd00_d56');
	var container_id_d00_d560200 = pegGetContainer_id_d(container_id, 'd00_d560200', '', 'd00_d5602');	
	let t01_d103 = pegGetContainer_id_d(container_id, 't01_d103', '', 'd00_d56');
	let screen_main = pegGetCmp(container_id_main);
	params ={}
	params.container_id = container_id_main;
	params.mnr01 = screen_main.getMnr01();
	params.mmnr01 = screen_main.getMmnr01();
	params._d = screen_main.peg__d;
	params.t_df = pegGetVal('t_df', container_id);
	params.t_dt = pegGetVal('t_dt', container_id);
	params.p301 = pegGetVal('p301', container_id);
	params.p303 = pegGetVal('p303', container_id);
	params.p302 = pegGetVal('p302', container_id);
	params.t_nom = pegGetVal('t_nom', container_id);
	if (d00_d56_search_ajax != '') {
		if (d00_d56_search_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(d00_d56_search_ajax);
		}
	}
	d00_d56_search_ajax = pegAjaxDefer('/' + main_path + '/crm00101/set_d00_d56_params.php', params, function (jsondata) {
		if(jsondata.ok ==0){
			pegGetDicAlert('peg_dic_crm001_zero_account');
		}else{
			pegGridRefresh(container_id_d00_d560200,'grid',0);	
			pegGridRefresh(t01_d103,'grid',0);	
		}
		

		
	});

}

var crm001_d00_d_update_p161_ajax = '';
/**
 * Λογική για αυτόματη επιλογή της πρώτης κατηγορίας επαγγέλματος βάσει του Target Group.
 * @param container_id
 */
function crm001_d00_d_update_p161(container_id, newValue) {

	var params = {};
	params.p51 = newValue; // Target Group
	params.container_id = container_id;

	if (crm001_d00_d_update_p161_ajax != '') {
		if (crm001_d00_d_update_p161_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(crm001_d00_d_update_p161_ajax);
		}
	}
	crm001_d00_d_update_p161_ajax = 
	pegAjaxDefer('/' + main_path + '/crm00101/update_p161.php', params, function (jsondata) {

		if (!jsondata) {
			return;
		}
		else{
			p161 = pegGetCmp(container_id,'p161');
			if(!p161) {
				container_id = pegGetContainer_id_d(container_id,'d00_d02','','d00_d')
			}
			
			pegSetVal('p161', container_id, jsondata['p161']); // Κατηγορία επαγγέλματος			
		}
	});
}

var crm001_d00_d_update_p51_ajax = '';
/**
 * Λογική για αυτόματη επιλογή της πρώτης κατηγορίας επαγγέλματος βάσει του Target Group.
 * @param container_id
 */
function crm001_d00_d_update_p51(container_id, newValue) {

	var params = {};
	params.p161 = newValue; // Κατηγορία επαγγέλματος	
	params.container_id = container_id;
	if (crm001_d00_d_update_p51_ajax != '') {
		if (crm001_d00_d_update_p51_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(crm001_d00_d_update_p51_ajax);
		}
	}
	crm001_d00_d_update_p51_ajax = 
	pegAjaxDefer('/' + main_path + '/crm00101/update_p51.php', params, function (jsondata) {
		if (!jsondata) {
			return;
		}
		p51 = pegGetCmp(container_id,'p51');
		if(!p51) {
			container_id = pegGetContainer_id_d(container_id,'d00_d02','','d00_d')
		}
		pegSetVal('p51', container_id, {"value":jsondata.p51,"display":jsondata.p51_desc}); //Target Group		
	});
}

function crm001_d00_d00_dynamic_fields_init(container_id){
	crm001_d00_d00_create_d64d65_structure(container_id,'d64');
	crm001_d00_d00_create_d64d65_structure(container_id,'d65');
}

function crm001_d00_d00_get_d65d64_nr01_array(container_id,mode){
	var screenData=peg002_get_screen_data(container_id);
	if(mode=='d64'){
		return Object.keys(screenData).filter(k=>{return  k.match(/d64_rec_nr01_[0-9]*$/) });
	}else if( mode=='d65'){
		return Object.keys(screenData).filter(k=>{return  k.match(/d65_rec_nr01_[0-9]*$/) });
	}
}

function crm001_d00_d00_create_d64d65_structure(container_id,mode){
	if(mode!='d64' && mode!='d65')return;
	var d00_d00_container = pegGetCmp(container_id,((mode=='d64')?"fldset01":"fldset02")); 
	// d00_d00_container.expand(); 
	var records_nr01_array=crm001_d00_d00_get_d65d64_nr01_array(container_id,mode);

	/** main fieldcontainer for all records */
	var records_container=d00_d00_container.peg_insert({name:mode+'_records_container',xtype:'fieldcontainer',margin:"10 5",layout:{type:'vbox',align:'stretch'},flex:1
	});

	/** main fieldcontainer for all records */
	var hidden_container=d00_d00_container.peg_insert({name:mode+'_hidden_container',xtype:'fieldcontainer',bind:{hidden:"true"}	});

	var tot=records_nr01_array.length ;
	/** Add all existing d65 records */
	for (let i = 0; i < tot; i++) { 
		var record_index=records_nr01_array[i].replace(mode+'_rec_nr01_','');
		crm001_d00_d00_create_d64d65_record_structure(records_container, record_index ,mode );
	}

	/** Insert Add button */
	var d00_d_container_id=pegGetContainer_id_d(container_id,'d00_d','','d00_d');
	var screenData=peg002_get_screen_data(d00_d_container_id);
    if(!pegIsEmpty(screenData[mode+'_rec_add_label'])){
		var buttonAdd=d00_d00_container.peg_insert({name:'add_'+mode+'_btn',xtype:'button',height:35, text:screenData[mode+'_rec_add_label'] , iconCls:'fa fa-plus'}); 
		buttonAdd.setPeg_handler(function(){crm001_d00_d00_d64d65_add_handler(container_id,mode);});
	}
}

function crm001_d00_d00_create_d64d65_record_structure(records_container,index,mode){
	if(mode!='d64' && mode!='d65')return;
	
	var container_id=records_container.container_id;
	
	var screenData=peg002_get_screen_data(container_id);

	var d00_d_container_id=pegGetContainer_id_d(container_id,'d00_d','','d00_d');
	var d00_d_screen=pegGetCmp(d00_d_container_id);

	var hidden_container=pegGetCmp(container_id,mode+'_hidden_container');
	/** The main container for the d65/d64 record */
	var rec_container_obj={ name:mode+"_rec_container_"+index,xtype:'fieldcontainer', layout:{ type:'vbox', align:'stretch'},margin:"0 0 5 0"};
	var rec_container=records_container.peg_insert(rec_container_obj);


	/** Row 1 containing e-mail/phone textbox and action buttons */
	var rec_row1_obj={name:mode+"_rec_row1_"+index,xtype:'fieldcontainer',flex:1,margin:0,
	responsiveConfig:{  
	 "mobile" : {
		"layout" :{
		   "type" : "box",
		   "vertical": true
		}
	 },
	 "!mobile" : { 
		"layout" :{
		   "type" : "box",
		   "vertical": false
		}
	 }}};
	var rec_row1=rec_container.peg_insert(rec_row1_obj);


	/** Row 2 containing Details*/
	var rec_row2_obj={name:mode+"_rec_row2_"+index,xtype:'fieldcontainer', layout:{type:'hbox',align:'stretch'},flex:1 };
	var rec_row2=rec_container.peg_insert(rec_row2_obj);


	/** Email/phone textbox */
	var rec_p01_obj={name:mode+'_rec_p01_'+index,xtype:'textbox',flex:1,tooltip:screenData[mode+'_rec_p01_label'], margin:"0 2 5 2"};
	var rec_p01=rec_row1.peg_insert(rec_p01_obj);
	rec_p01.on('blur', function(me){ 
		if((me.peg_onBlurValueHasChanged())){
			crm001_d00_d00_d64d65_save_data(container_id,index,mode,crm001_d00_d00_d64d65_getData(container_id,index,mode));
		}
	});

	/** Container for all buttons*/
	var rec_btns_obj={name:mode+'_rec_btns_'+index,xtype:'fieldcontainer', layout:{type:'hbox',align:'stretch'},flex_mobile:1};
	var rec_btns=rec_row1.peg_insert(rec_btns_obj);
	
	if(mode=='d65'){
		/** d65.p02 toggle function - Ενεργό για Αποστολές */
		var d65_p02_toggle_func=function(){
			
			var val=peg002_get_screen_data(container_id,'d65_rec_p02_'+index);
			peg002_set_screen_data(container_id,'d65_rec_p02_'+index,(val=='1')?'0':'1');
			if(crm001_d00_d00_d64d65_save_data(container_id,index,mode,crm001_d00_d00_d64d65_getData(container_id,index,mode))){
				pegToast(peg002_get_screen_data(container_id,'d65_rec_p01_'+index)+':'+screenData['d65_rec_p02_label_'+((val=='1')?'off':'on')]);
			}
		};
		/** Ενεργό για Αποστολές button */
		var d65_rec_p02_obj={name:'d65_rec_p02_'+index+'_btn',xtype:'button', width:20 ,maxHeight:24, tooltip:screenData['d65_rec_p02_label'], margin:"0 2 0 2",peg_handler:d65_p02_toggle_func,
		bind:{ 
			iconCls:'{theRec.d65_rec_p02_'+index+'==\'1\' ? "fa fa-toggle-on " : "fa fa-toggle-off peg_grayscale"}' 
		},flex_mobile:1}; 
		rec_btns.peg_insert(d65_rec_p02_obj); 
		hidden_container.peg_insert({name:'d65_rec_p02_'+index,xtype:'textbox',bind:{hidden:"true"}}); 

	}else{
		/** d64.p07 toggle function - Ενεργό για SMS */
		var d64_p07_toggle_func=function(){
			var val=peg002_get_screen_data(container_id,'d64_rec_p07_'+index);
			peg002_set_screen_data(container_id,'d64_rec_p07_'+index,(val=='1')?'0':'1');
			if(crm001_d00_d00_d64d65_save_data(container_id,index,mode,crm001_d00_d00_d64d65_getData(container_id,index,mode))){
				pegToast(peg002_get_screen_data(container_id,'d64_rec_p01_'+index)+':'+screenData['d64_rec_p07_label_'+((val=='1')?'off':'on')]);
			}
		};
		/** Ενεργό για Αποστολές button */
		var d65_rec_p07_obj={	name:'d64_rec_p07_'+index+'_btn',xtype:'button', width:20 ,maxHeight:24,tooltip:screenData['d64_rec_p07_label'], margin:"0 2 0 2",peg_handler:d64_p07_toggle_func,
						bind:{ 
							iconCls:'{theRec.d64_rec_p07_'+index+'==\'1\' ? "fa fa-toggle-on " : "fa fa-toggle-off peg_grayscale"}'
						},flex_mobile:1}; 
		rec_btns.peg_insert(d65_rec_p07_obj);
		hidden_container.peg_insert({name:'d64_rec_p07_'+index,xtype:'textbox',bind:{hidden:"true"}}); 
	}

	/** d65/d64.p300 toggle function - Λαμβάνει Μαζικές έγινε αποδοχή από Συναλλασσόμενο */
	var p300_toggle_func=function(){
		var val=peg002_get_screen_data(container_id,mode+'_rec_p300_'+index);
		peg002_set_screen_data(container_id,mode+'_rec_p300_'+index,(val=='1')?'0':'1');
		if(crm001_d00_d00_d64d65_save_data(container_id,index,mode,crm001_d00_d00_d64d65_getData(container_id,index,mode) )){
			pegToast(peg002_get_screen_data(container_id,mode+'_rec_p01_'+index)+':'+screenData[mode+'_rec_p300_label_'+((val=='1')?'off':'on')]);
			
		}
	};
	/**  Λαμβάνει Μαζικές έγινε αποδοχή από Συναλλασσόμενο button */
	var rec_p300_obj={	name:mode+'_rec_p300_'+index+'_btn',xtype:'button',width:20,maxHeight:24,height:24,tooltip:screenData[mode+'_rec_p300_label'], 
				peg_handler:p300_toggle_func, margin:"0 2 0 2",
					bind:{
						iconCls:'{theRec.'+mode+'_rec_p300_'+index+'==\'1\' ? "fa fa-mail-bulk" : "fa fa-mail-bulk peg_grayscale"}'
					},flex_mobile:1};  
	rec_btns.peg_insert(rec_p300_obj);

	hidden_container.peg_insert({name:mode+'_rec_p300_'+index,xtype:'textbox',bind:{hidden:"true"}}); 
	if(mode=='d65'){
		/** d65 send mail function */
		var d65_send_func=function(){
			var params00 = {peg_nr01: peg002_get_screen_data(container_id,'nr01'),peg_table: 'd00', peg_mail:peg002_get_screen_data(container_id,'d65_rec_p01_'+index)};
			pegAddTab_d('' , '','mail_send_d00','mail' ,'', 0  , '', params00);
		};
		/** Send mail button */
		var d65_send_obj={name:'d56_rec_send_'+index,flex_mobile:1,xtype:'button',width:20,maxHeight:24,tooltip:screenData['d65_rec_send_label'],iconCls:'fa fa-paper-plane', margin:"0 2 0 2",peg_handler:d65_send_func}; 
		rec_btns.peg_insert(d65_send_obj);
	}else{
		/** d64 call function */
		var d64_call_func=function(){
			window.open("tel:"+peg002_get_screen_data(container_id,'d64_rec_p01_'+index));
		};
		/** Send mail button */
		var d64_call_obj={name:'d64_rec_call_'+index,flex_mobile:1,xtype:'button',width:20,maxHeight:24,tooltip:screenData['d64_rec_call_label'],iconCls:'fa fa-phone', margin:"0 2 0 2",peg_handler:d64_call_func}; 
		rec_btns.peg_insert(d64_call_obj);
	}

	/** d65/d64 edit function */
	var edit_fun=function(){
		if(!(peg002_get_screen_data(container_id,mode+'_rec_nr01_'+index) >0)){
			return;
		}
		var params00 = { mmnr01:d00_d_screen.getMmnr01() , mnr01:d00_d_screen.getMnr01() , peg_screen_parent_element_name:d00_d_screen.name , peg_screen_parent_container_id:d00_d_screen.getContainer_ID(), peg_tbl: mode}; 
		pegAddTab_d( '' , 'peg_tmp_'+mode, mode+'_d', 'crm001' , '', peg002_get_screen_data(container_id,mode+'_rec_nr01_'+index) , '', params00);
	}; 
	/** edit mail button */
	var rec_edi_obj={	name:mode+'_rec_edit_'+index,xtype:'button',flex_mobile:1,  width:20,maxHeight:24,tooltip:screenData[mode+'_rec_edit_label'],iconCls:'fa fa-pen', margin:"0 2 0 2",peg_handler:edit_fun};
	rec_btns.peg_insert(rec_edi_obj);

	var del_fun=function(){
		if(peg002_get_screen_data(container_id,mode+'_rec_nr01_'+index)>0 ){
			crm001_d00_d00_d64d65_remove_record(container_id,index,mode);
			return;
		} 
		if(!pegIsEmpty(peg002_get_screen_data(container_id,mode+'_rec_p01_'+index))){
			return;
		}
		crm001_d00_d00_d64d65_remove_empty_recs(container_id,mode);
	}
	/** delete mail button */
	var del_fun_obj={name:mode+'_rec_'+index+"_remove",flex_mobile:1,xtype:'button',width:"30px",maxHeight:24,tooltip:screenData[mode+'_rec_remove_label'], margin:"0 2 0 2",iconCls:"fa fa-times",peg_handler:del_fun};
	rec_btns.peg_insert(del_fun_obj);


	/** Paratiriseis */	
	var rec_p04_obj={name:mode+'_rec_p04_custom_'+index,readOnly:1,xtype:'tinymce',flex:1,tooltip:peg002_get_screen_data(container_id,mode+'_rec_p04_label'),baseCls:"peg_alert_info_plain",style:{paddingTop:'0px',paddingBottom:'0px'}, 
		bind:{
			hidden:'{theRec.'+mode+'_rec_p04_custom_'+index+'==\'\'? 1 : 0}'
	}}; 
	rec_row2.peg_insert(rec_p04_obj);

	/** NR01 */	 
	hidden_container.peg_insert({name:mode+'_rec_nr01_'+index,xtype:'textbox',bind:{hidden:"true"}});


	return rec_container;
}


function crm001_d00_d00_d64d65_add_handler(container_id,mode){
	if(mode!='d64' && mode!='d65')return;
	var records_container=pegGetCmp(container_id,mode+'_records_container');

	var records_nr01_array=crm001_d00_d00_get_d65d64_nr01_array(container_id,mode); 
	var maxIndex=0;
	if(records_nr01_array){
		var indexes_array=records_nr01_array.map(it=>parseInt(it.replace(mode+'_rec_nr01_','')));
		var maxIndex=Math.max(...indexes_array);
	}
	if(!(maxIndex>0)){
		maxIndex=0;
	}
	var d00_d_container_id=pegGetContainer_id_d(container_id,'d00_d','','d00_d');
	var d00_d_screen=pegGetCmp(d00_d_container_id);
	
	if(pegGetCmp(container_id,mode+'_rec_p01_'+maxIndex) && d00_d_screen){
		var val=peg002_get_screen_data(container_id,mode+'_rec_p01_'+maxIndex);
		if(pegIsEmpty(val)){
			pegGetCmp(container_id,mode+'_rec_p01_'+maxIndex).focus();
			records_container.scrollBy(0,99999);
			return;
		}
	} 
	maxIndex++;

	
	crm001_d00_d00_create_d64d65_record_structure(records_container,maxIndex,mode); 
	pegGetCmp(container_id,mode+'_rec_p01_'+maxIndex).focus();
	records_container.scrollBy(0,99999);

	if(mode=='d65'){
		var fields=['nr01','p01','p04'];
	}else{
		var fields=['nr01','p01','p04'];
	}

	fields.forEach(fld=>{
		peg002_set_screen_data(d00_d_container_id,mode+'_rec_'+fld+'_'+maxIndex,''); 
	}); 
}

function crm001_d00_d00_d64d65_getData(container_id,index,mode){
	var screenData=peg002_get_screen_data(container_id);
	if(mode=='d65'){
		var fields=['nr01','p01','p02','p300'];
	}else{
		var fields=['nr01','p01','p07','p300'];
	}

	var saveData={};
	fields.forEach(fld=>{saveData[fld]=screenData[mode+'_rec_'+fld+'_'+index];}); 
	return saveData;
}

var crm001_peg_tmp_d64d65_update={};
function crm001_d00_d00_d64d65_save_data(container_id,index,mode,saveData){
	if(mode!='d64' && mode!='d65')return false;

	var d00_d_container_id=pegGetContainer_id_d(container_id,'d00_d','','d00_d');
	var d00_d00_container_id=pegGetContainer_id_d(d00_d_container_id,'d00_d00',0,'d00_d00'); 


	if (crm001_peg_tmp_d64d65_update[mode+'_'+index] ) {
		crm001_peg_tmp_d64d65_update[mode+'_'+index].then(
			function(){
				crm001_peg_tmp_d64d65_update[mode+'_'+index]=null;
				saveData.nr01=peg002_get_screen_data(container_id,mode+'_rec_nr01_'+index);
				crm001_d00_d00_d64d65_save_data(container_id,index,mode,saveData);
			});
		return;
	}
	var screenData=peg002_get_screen_data(container_id);
	if(pegIsEmpty(screenData[mode+'_rec_p01_'+index])){
		return false;
	}

	var d00_d_screen=pegGetCmp(d00_d_container_id);
	if(mode=='d65'){
		var fields=['nr01','p01','p02','p300','p04','p04_custom'];
	}else{
		var fields=['nr01','p01','p07','p300','p04','p04_custom'];
	}

	var update_fields = ['nr01','p04','p04_custom']
	saveData.container_id=d00_d_screen.getContainer_ID();
	saveData.mode=mode;

	crm001_peg_tmp_d64d65_update[mode+'_'+index] = 
	pegAjaxPromise('/' + main_path + '/crm00101/crm001_peg_tmp_d64d65_update.php', saveData, function (jsondata) {
		
		crm001_peg_tmp_d64d65_update[mode+'_'+index]=null;
		if(jsondata && jsondata.data ){ 
			fields.forEach(fld=>{
				if(jsondata.ok &&  !update_fields.includes(fld)  && pegGetCmp(container_id) && peg002_get_screen_data(container_id,mode+'_rec_'+fld+'_'+index ) !=  jsondata.data[fld] ){
					return;
				}
				peg002_set_screen_data(d00_d_container_id,mode+'_rec_'+fld+'_'+index, jsondata.data[fld]);
			});
		}else{
			fields.forEach(fld=>{
				peg002_set_screen_data(d00_d_container_id,mode+'_rec_'+fld+'_'+index,'');
				if(fld=='nr01'){
					crm001_d00_d00_d64d65_remove_empty_recs(d00_d00_container_id,mode);
				}
			});
		}
		if(jsondata.ok!=1){
			pegAlert(jsondata.message);
			return;
		}
	});
	return true;
}

function crm001_d00_d00_d64d65_remove_record(container_id,index,mode){
	if(mode!='d64' && mode!='d65')return;
	var screenData=peg002_get_screen_data(container_id);

	if(mode=='d65'){
		var fields=['nr01','p01','p02','p300'];
	}else{
		var fields=['nr01','p01','p07','p300'];
	}
	var table='peg_tmp_'+mode,	nr01=screenData[mode+'_rec_nr01_'+index],	mnr01=screenData['nr01'],	mmnr01='d00_d-'+screenData['nr01'];
	peg002_delete_record(container_id,table,nr01,mnr01,mmnr01,function(jsondata){
		if(jsondata && jsondata.ok){
			fields.forEach(fld=>{
				peg002_set_screen_data(container_id,mode+'_rec_'+fld+'_'+index,'');
				if(fld=='nr01'){
					crm001_d00_d00_d64d65_remove_empty_recs(container_id,mode);
				}
			});
		} 
	});
}

var crm001_peg_tmp_d64d65_refresh={};
function crm001_d00_d00_d64d65_remove_empty_recs(container_id,mode){

	if(mode!='d64' && mode!='d65')return;
	var records_nr01_array=crm001_d00_d00_get_d65d64_nr01_array(container_id,mode);
	var tot=records_nr01_array.length ;
	var screenData=peg002_get_screen_data(container_id);
	
	/** Add all existing d65 records */
	for (let i = 0; i < tot; i++) { 
		var index=records_nr01_array[i].replace(mode+'_rec_nr01_','');
		if(pegIsEmpty(screenData[records_nr01_array[i]])){
			pegGetCmp(container_id,mode+'_records_container').peg_remove(pegGetCmp(container_id,mode+'_rec_container_'+index));
		}
	}

}
 
function crm001_update_d64d65_rec_on_save(screen, mode, jsonData){
	
	if(mode!='d64' && mode!='d65')return;

	var _d_exceptions 		= [mode+'_d00_d', "d00_d51"];
	var parent_container_id = screen.getPeg_screen_parent_container_id();
	if(_d_exceptions.includes(pegGetCmp(parent_container_id).peg__d)){
		parent_container_id = pegGetCmp(parent_container_id).getPeg_screen_parent_container_id();
	}
	
	var d00_d_container_id	 = pegGetContainer_id_d(parent_container_id,'d00_d',0,'d00_d');
	var d00_d00_container_id = pegGetContainer_id_d(d00_d_container_id,'d00_d00',0,'d00_d00');
	var d00_rec				 = peg002_get_screen_data(d00_d_container_id);

	var d64d65_nr01 = jsonData.nr01;
	var update_flds = [];
	if(screen.peg__d=='d69_d' || screen.peg__d=='d00_d51'){
		update_flds = ['p04_custom'];
		if(mode=='d65'){
			d64d65_nr01 = jsonData.p07;
		}else{
			d64d65_nr01 = jsonData.p06;
		}
		if(!(d64d65_nr01>0)){
			return;	
		}
	}else{
		if(mode=='d65'){
			update_flds = ['p01','p02','p300','p04','p04_custom'];
		}else{
			update_flds = ['p01','p07','p300','p04','p04_custom'];
		}
	}
	
	if(mode=='d65'){
		var nr01_rec = Object.keys(d00_rec).find(key =>d00_rec[key] == d64d65_nr01 && key.match(/d65_rec_nr01_[0-9]*$/));
	}else{
		var nr01_rec = Object.keys(d00_rec).find(key =>d00_rec[key] == d64d65_nr01 && key.match(/d64_rec_nr01_[0-9]*$/));
	}

	
	var records_nr01_array = crm001_d00_d00_get_d65d64_nr01_array(d00_d00_container_id, mode); 

	if(nr01_rec){
		var index= nr01_rec.replace(mode+'_rec_nr01_',''); 
	}else{
		var maxIndex=Math.max(...records_nr01_array.map(it=>parseInt(it.replace(mode+'_rec_nr01_',''))));
		maxIndex++;
		update_flds.push('nr01');
		index=maxIndex;
		crm001_d00_d00_create_d64d65_record_structure(pegGetCmp(d00_d00_container_id,mode+'_records_container'),maxIndex,mode) ;
	}
	
	var tot = records_nr01_array.length;
	update_flds.forEach(fld=>{
		if(fld=='p04_custom'){
			for (let i=0; i<tot; i++) { 
				var index00 = records_nr01_array[i].replace(mode+'_rec_nr01_','');
				if(peg002_get_screen_data(d00_d00_container_id, mode+'_rec_nr01_'+index00)>0){	
					crm001_d00_d00_d64d65_save_data(d00_d00_container_id, index00, mode, crm001_d00_d00_d64d65_getData(d00_d00_container_id, index00, mode));
				}
			}
			
		}else if(mode=='d64' && fld=='p01'){ 
			peg002_set_screen_data(d00_d_container_id ,mode+'_rec_'+fld+'_'+index, jsonData.p001);
		}else{
			peg002_set_screen_data(d00_d_container_id ,mode+'_rec_'+fld+'_'+index, jsonData[fld]+"");
		}
	});
}

function crm001_d64d65_delete_rec(grid,mode,row){
	if(mode!='d64' && mode!='d65')return;
	if(mode=='d65'){
		var fields=['nr01','p01','p02','p300'];
	}else{
		var fields=['nr01','p01','p07','p300'];
	}
	 
	var container_id= pegGetCmp(grid.getContainer_ID()).getPeg_screen_parent_container_id();
	 
	var d00_d_container_id=pegGetContainer_id_d(container_id,'d00_d',0,'d00_d');
	var d00_d00_container_id=pegGetContainer_id_d(d00_d_container_id,'d00_d00',0,'d00_d00');
	var d00_rec=peg002_get_screen_data(d00_d_container_id);
	if(mode=='d65'){
		var nr01_rec=Object.keys(d00_rec).find(key =>(d00_rec[key] ==row.nr01 && key.match(/d65_rec_nr01_[0-9]*$/)));
	}else{
		var nr01_rec=Object.keys(d00_rec).find(key =>(d00_rec[key] == row.nr01 && key.match(/d64_rec_nr01_[0-9]*$/)));
	}
	if(nr01_rec){
		var index=nr01_rec.replace(mode+'_rec_nr01_',''); 
		fields.forEach(fld=>{
			peg002_set_screen_data(d00_d00_container_id,mode+'_rec_'+fld+'_'+index,'');
		});	 
	}
}

function crm001_v_prop_d65_d64_search(container_id,mode){ 
	if(mode!='d65' && mode!='d64'){
		return;
	}
	peg002_GridSearchBox('','d00_d','d00', mode+'_prop.p01','textbox','',container_id,'crm001','grid','C','v_prop_'+mode);
}

//  crm001_query_140000005000001
function query_q10_d90_140000005000001_d101_grid01_view_afterDraw_listeners(container_id){
	
    var grid = pegGetCmp(container_id, 'grid01');
    var v_color_red =  '#ff0000';
	var v_color_green =  '#008000'; 
    var p03_year3_diff   = WebApp.view.grid.Grid.peg_getColumn(grid, 'p03_year3_diff');
	var last_contact = WebApp.view.grid.Grid.peg_getColumn(grid, 'last_contact');
	var next_contact = WebApp.view.grid.Grid.peg_getColumn(grid, 'next_contact');
	var prosfora   = WebApp.view.grid.Grid.peg_getColumn(grid, 'prosfora');

	if(last_contact){
		last_contact.peg_set_metaData = function (value, metaData, record, rowIndex, colIndex){
			try{
					metaData.tdCls = 'peg_clickable_cell';
				}catch(error){
				}
				return metaData;
		
			}
		last_contact.peg_column_celldblclick_handler=function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts){
				// console.log("You clicked p05 column"+record.get("last_contact_nr01"));
				pegAddTab_d('', 'd01', 'd01_d', 'crm002', '', record.get("last_contact_nr01"));
				return false;
			}
				
	}

	if(next_contact){
		next_contact.peg_set_metaData = function (value, metaData, record, rowIndex, colIndex){
			try{
					metaData.tdCls = 'peg_clickable_cell';
				}catch(error){
				}
				return metaData;
		
			}
		next_contact.peg_column_celldblclick_handler=function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts){
				pegAddTab_d('', 'd01', 'd01_d', 'crm002', '', record.get("next_contact_nr01"));
				return false;
			}
				
	}

    if(p03_year3_diff){
		p03_year3_diff.renderer = function(value, metaData, record, rowIndex, colIndex, store, view) {  
			try {
				var p03_year3_diff_val = record.get('p03_year3_diff');			// αν έχει άκυρη κατάσταση	
	
				if(p03_year3_diff_val<0){
					metaData.tdStyle = "color:"+v_color_red+";";
					metaData.style = "font-weight:bold;";
				}
				else if(p03_year3_diff_val>0){
					metaData.tdStyle = "color:"+v_color_green+";";
					metaData.style = "font-weight:bold;";
				}	
				else{
					metaData.style = "font-weight:bold;";
				}			
			} catch (error) {
				
			}
			return value;
		};
	}

	if(prosfora){
		prosfora.renderer = function(value, metaData, record, rowIndex, colIndex, store, view) {
			try{
				var prosfora_val = record.get('prosfora');

				if(prosfora_val > 0){
					metaData.tdStyle = "color:"+v_color_red+";";
					metaData.style = "font-weight:bold;";
				}else{
					metaData.style = "font-weight:bold;";
				}
			}catch(error){}
			return value;
		};

	}
    
}


function crm001_d00_d5603_grid_view_afterDraw_listeners(container_id){
	var grid = pegGetCmp(container_id, 'grid');
	grid.peg_deleteRec_params=function(params,row){
		params.mmnr01='t01_d-'+row['nr01'];
		return params;
	};
}	