<?php

require_once('../crm002_libs/d99104.php');
function crm002_crm004_build_open_tab_params(
	$da4_nr01 = 0,
	$d01_nr01 = 0,
	$d00_nr01 = 0
) {
	$ret = array(
		'ok'	=> 1,
		'msg'	=> ''
	);
	if (!pegasus_module_exists('crm004')) {
		$ret['ok'] = 0;
		$ret['msg'] .= $_SESSION['peg_dic_crm002_d01_d_p403_no_module'] . "\n";
	}
	if (!function_exists('crm004_factory_config')) {
		$ret['ok'] = 0;
		$ret['msg'] .= $_SESSION['peg_dic_crm002_d01_d_p403_no_module'] . "\n";
	}
	if (!($da4_nr01 > 0)) {
		$ret['ok'] = 0;
		$ret['msg'] .= $_SESSION['peg_dic_crm002_d01_d_p403_emty_error'] . "\n";
	}
	if (!($d00_nr01 > 0)) {
		$ret['ok'] = 0;
		$ret['msg'] .= $_SESSION['peg_dic_crm002_d01_d_p01_emty_error'] . "\n";
	}

	if ($ret['ok'] == 0) {
		return $ret;
	}

	$config = crm004_factory_config($da4_nr01);

	if (!pegasus_mysql_table_exists($config['factory_table'])) {
		$ret['ok'] = 0;
		$ret['msg'] .= $_SESSION['peg_dic_crm002_d01_d_p403_no_table'] . "\n";
	}

	if ($ret['ok'] == 0) {
		return $ret;
	}

	return array(
		'ok'	=> 1,
		'data'	=> array(
			'_d'		=> $config['factory_d'],
			'table'		=> $config['factory_table'],
			'module'	=> $config['factory_module'],
		),
		'msg'	=> 'Success'
	);
}
function crm002_dashboard_initialize_constructor() {
	return array(
		'grid_tabs' => array(
			array(
				'_d' 		=> 'd01_d53', 
				'module' 	=> 'crm002',
				//'custom_id'	=> ''
			),
		),
		//'initialize_provider'	=> ''
	);
}
function crm002_grid_d01_custom_actions($retArray = array(), $id = ''){
	$peg_handler = 'crm002_d01_d_grid_d01_toolbar_item_open_relation(screen.getContainer_ID(), \'' . $id . '\', \'' . $_SESSION['peg_dic_crm002_not_select_d01'] . '\' );';
	$retArray[] = array(
		'xtype' => 'pegasusToolBarGridAction',
		'peg_custom_id' => 'crm002_grid_d01_open_relation',
		'viewModel' => array(
			'type' => 'GridButtonModel',
			'isToolBar' => 1,
			'data' => array(
				'toolBarButton' => 'crm002_grid_d01_open_relation',
			)
		),
		'icon' => 'crm002_images/relation_16x16.png',
		'text' =>  $_SESSION['peg_dic_crm002_open_relation'],
		'peg_handler' => $peg_handler
	);


	/* Μαζική Δημιουργία */
	$peg_handler = "crm002_d01_d50_mass_show_create(screen.getContainer_ID(),'$id');";
	$retArray[] = array(
	'xtype' => 'pegasusToolBarGridAction',
	'peg_custom_id' => 'crm002_d01_d50_mass_show_create',
	'viewModel' => array(
	'type' => 'GridButtonModel',
	'isToolBar' => 1,
	'data' => array(
		'toolBarButton' => 'crm002_d01_d50_mass_show_create',
	)
	),
	'iconCls' => 'far fa-calendar-plus',
	'text' =>  $_SESSION['peg_dic_crm002_d01_d50_mass_show_create'],
	'peg_handler' => $peg_handler
	);

	/* Αλλαγή επιλεγμένων Δραστηριοτήτων  */
	$peg_handler = "crm002_d01_d50_show_d01_d61(screen.getContainer_ID(),'$id');";
	$retArray[] = array(
	'xtype' => 'pegasusToolBarGridAction',
	'peg_custom_id' => 'crm002_d01_d50_show_d01_d61',
	'viewModel' => array(
	'type' => 'GridButtonModel',
	'isToolBar' => 1,
	'data' => array(
		'toolBarButton' => 'crm002_d01_d50_show_d01_d61',
	)
	),
	'iconCls' => 'fas fa-bolt',
	'text' =>  $_SESSION['peg_dic_crm002_d01_d50_show_d01_d61'],
	'peg_handler' => $peg_handler
	);

	/* Αποστολή δραστηριότητας ημερολογίου  */
	$peg_handler = "crm000_crm000_04_d_show(screen.getContainer_ID(),'$id');";
	$retArray[] = array(
	'xtype' => 'pegasusToolBarGridAction',
	'peg_custom_id' => 'crm000_ics_create',
	'viewModel' => array(
	'type' => 'GridButtonModel',
	'isToolBar' => 1,
	'data' => array(
		'toolBarButton' => 'crm000_ics_create',
	)
	),
	'iconCls' => 'far fa-paper-plane',
	'text' =>  $_SESSION['peg_dic_crm000_ics_create'],
	'peg_handler' => $peg_handler
	);


	return $retArray;
}
function peg_crm002_find_task_sequences($d01_data)
{
	pegasus_mysql_use('select * from d01 where nr01=?', $d01_tmp, array($d01_data['nr01']));

	$d01_p05_is_changed = false;
	if ($d01_data['p05'] != $d01_tmp['p05']) {
		$d01_p05_is_changed = true;
	}

	$d01_p06_is_changed = false;
	if ($d01_data['p06'] != $d01_tmp['p06']) {
		$d01_p06_is_changed = true;
	}

	$d01_p07_is_changed = false;
	if ($d01_data['p07'] != $d01_tmp['p07']) {
		$d01_p07_is_changed = true;
	}

	$d32_seqs = array();
	if ($d01_p05_is_changed == true or $d01_p06_is_changed == true or $d01_p07_is_changed == true) {
		$query  = 'select d30.* ';
		$query .= 'from d30 ';
		$query .= 'left join d32 on d32.p01=d30.p901 ';
		$query .= 'where d30.p01=:p01 and d30.p02=:p02 and d30.p03=:p03 and (d30.p04=:p04 or d30.p04=0) ';
		$query .= 'order by d32.p100;';

		$result = pegasus_query($query, array('p01' => $d01_data['p05'], 'p02' => $d01_data['p07'], 'p03' => $d01_data['p06'], 'p04' => $d01_data['p02']));
		while ($d30 = pegasus_fetch_assoc($result)) {
			array_push($d32_seqs,array('d32_nr01'=>$d30['p901'], 'd30_p05'=>$d30['p05']));
		}

		if (count($d32_seqs) > 0) {
			return $d32_seqs;
		} else {
			return false;
		}
	}

	return false;
}

function peg_crm002_d01_d50_initialize($data,$mmnr01 ,$mnr01 ,$_d,$container_id ){

	$data['crm002_d01_d50_grid_d01_crm002_grid_d01_open_relation_hidden'] = false;
	$data['crm002_d01_d50_grid_d01_crm002_d01_d50_mass_show_create_hidden'] = false;
	$data['crm002_d01_d50_grid_d01_crm002_d01_d50_show_d01_d61_hidden'] = false;
	$data['crm002_d01_d50_grid_d01_crm000_ics_create_hidden'] = false;
	if(peg_dateIsEmpty($data['dt'])){
		$data['dt']  = date('Y-m-d');
	}
	
	if(empty($data['d01_alert'])){
		$data['d01_alert_hidden'] = true;
	}

	if(empty($data['us0'])){
		$data['us0'] = $_SESSION['username'];
	}
	
	if(empty($data['pending'])){
		$data['pending'] = 0;
	}
	$data['crm002_d01_d50_tab_hidden_tablet']=true;

	$data['crm002_d01_d50_dt_prev_hidden_mobile']=true;
	$data['crm002_d01_d50_dt_next_hidden_mobile']=true;
	$data['crm002_d01_d50_dt_today_hidden_mobile']=true;

	return $data;
}
function peg_crm002_d01_d99_initialize($data,$mmnr01 ,$mnr01 ,$_d,$container_id ){
	
	$data['dt_f'] =  date('Y-m-d');
	$data['dt_t'] =  peg_addDate($data['dt_f'], 'Y-m-d', 30) ;
	$us0_p01 =  $_REQUEST['us0_p01'];

	crm002_d01_d99_query($container_id, $us0_p01,$data['dt_f'], $data['dt_t']);
	return $data;
}
function crm002_d01_d99_query($container_id, $us0_p01, $dt_f, $dt_t)
{
	$sql = "SELECT
                d01.*
            FROM
                ( select * FROM d01 WHERE kete >= :kete01 AND kete < :kete02 ) AS d01
                LEFT JOIN d00 ON d00.nr01 = d01.p01
                LEFT JOIN d04 ON d04.p01 = d01.p05
                LEFT JOIN d07 ON d07.p01 = d01.p07
                LEFT JOIN d02 ON d02.p01 = d01.p06
                LEFT JOIN d60 ON d60.p01 = d01.p320
                LEFT JOIN us0 ON us0.p01 = d01.p02 
                WHERE d01.p02=:us0_p01 AND d04.p101=1 AND
                      d02.p03=1 AND (d01.p03 >=:dt_f AND d01.p03<=:dt_t)";
	$sqlParams['us0_p01']   = $us0_p01;
	$sqlParams['dt_f']      = $dt_f;
	$sqlParams['dt_t']      = $dt_t;
	$sqlParams['kete01']	= $_SESSION['us0_p401'];
	$sqlParams['kete02']	= $_SESSION['us0_p402'];
	//echo pegasus_replace_values_in_sql($sql,$sqlParams);
	pegasusSetGlobalVar(
		$container_id . '_query_d01_grid_d10',
		array(
			'sql' => $sql,
			'sqlParams' => $sqlParams
		)
	);
}
function crm002_d20_refresh($mmnr01, $mnr01, $container_id, $pending = "false")
{
	$pending_where ='';
	$sql =' 1 = 0 ';
	$sqlParams = array();
	
	if($pending=="true"){
		$pending_where = " AND d02.p03=1";
	}

	if (substr($mmnr01, 0, 5) == 'd25_d') {

		$sql = 'd01.p301=:nr01' . $pending_where;
		$sqlParams['nr01'] = $mnr01;

	} else if (substr($mmnr01, 0, 5) == 'd35_d') {

		$sql = 'd01.p302=:nr01' . $pending_where;
		$sqlParams['nr01'] = $mnr01;

	} else if (substr($mmnr01, 0, 5) == 'd00_d') {
		
		$sql = 'd01.p01=:nr01' . $pending_where;
		$sqlParams['nr01'] = $mnr01;

		if (!pegasus_check_permission('crm002.d01.us0')) {
			$sql .=' AND (d01.p02=:us0_p01) ';
			$sqlParams['us0_p01'] = $_SESSION['username'];
		}

	} else if (substr($mmnr01, 0, 8) == 'cona11_d' || substr($mmnr01, 0, 8) == 'cona17_d' ||  substr($mmnr01, 0, 8) == 'cona18_d' || substr($mmnr01, 0, 8) == 'cona19_d') {
	/** Αν η καταχώρηση έρχεται από:
	 *  cona11_d : συμβάσεις πελατών
	 *  cona17_d : Ληξιάριο
	 *  cona18_d : Ατιμολόγητες συμβάσεις
	 *  cona19_d : Περιοδική Τιμολόγηση
	 **/
		$sql = 'd01.p303=:nr01' . $pending_where;
		$sqlParams['nr01'] = $mnr01;
	} else if (substr($mmnr01, 0, 5) == 'i31_d') {

		$i31_query = "SELECT * FROM i31 WHERE nr01=:i31_nr01";
		pegasus_mysql_use($i31_query, $i31, array('i31_nr01' => $mnr01));
		$sql = 'd01.p304=:i31_p02 AND d01.p3041=:i31_p01 ' . $pending_where;
		$sqlParams['i31_p01'] = $i31['p01'];
		$sqlParams['i31_p02'] = $i31['p02'];

	} else {
		$mmnr01_arr = explode("-", $mmnr01); //e43_d-2056004
		$table = pegasus_mysql_printfld("p50", "p01", "p02=?", array($mmnr01_arr[0]));

		if(pegasus_mysql_table_exists($table)){
			$sql = ' d01.p012=:table and d01.p010=:table_nr01 ' . $pending_where;
			$sqlParams['table'] = $table;	
			$sqlParams['table_nr01'] = $mmnr01_arr[1];	
			// echo pegasus_replace_values_in_sql($sql, $sqlParams);		
		}

	}

	pegasusSetGlobalVar(
		$container_id . '_where_d01_d20',
		array(
			'sql' => $sql,
			'sqlParams' => $sqlParams
		)
	);

	return;
}
/** 
 * @param mixed $p010: MK Εγγραφής Συσχέτισης
 * @param mixed $p012: Πίνακας Συσχέτισης 
 * @param associative $data: Περιέχει p301: Έργο (ΜΚ),
 * 									  p302: Εργασία Έργου (ΜΚ),
 * 									  p303: Σύμβαση (ΜΚ) 
 */
function crm002_find_d01_relation($p010, $p012, $data = array())
{

	$message_hidden = true;
	$valuefield = "nr01";
	$p_text = $_SESSION['peg_dic_crm002_d01_msg_link'] . ' ';
	$link_color = '#ffffff';
	if (!empty($data['p301']) && empty($data['p302'])) {
		$d25_p02 = pegasus_mysql_printfld('d25', 'p02', 'nr01=:d25_nr01', array('d25_nr01' => $data['p301']));
		$p_text .= $_SESSION['peg_dic_crm002_d01_msg_project'] . ' <a style="color:'.$link_color.'" href="javascript:peg002_editRec2Tab( 
			\'d25\', 
			\'d25_d\', 
			\'projects\', 
			0 , 
			\'' . $valuefield . '\', 
			\'' . $data['p301'] . '\'
		);void(0);"><b>' . $data['p301'] .': '.$d25_p02 . '</b></a>';
		$message_hidden = false;
	} else if (!empty($data['p302'])) {
		$query = 'SELECT d35.p02, d25.p02 as d25_p02 FROM d35
					JOIN d25 ON (d35.p00 = d25.nr01)
					WHERE d35.nr01=:d35_nr01';
		pegasus_mysql_use($query, $tbl, array('d35_nr01' => $data['p302']));
		$p_text .= $_SESSION['peg_dic_crm002_d01_msg_project'] . '
		<a style="color:'.$link_color.'" href="javascript:peg002_editRec2Tab( 
			\'d25\', 
			\'d25_d\', 
			\'projects\', 
			0 , 
			\'' . $valuefield . '\', 
			\'' . $data['p301'] . '\'
		);void(0);"><b>' . $data['p301'] .':  '. $tbl['d25_p02'] . '</b></a> ';
		$p_text .= $_SESSION['peg_dic_crm002_d01_msg_project_task'] . '
		<a style="color:'.$link_color.'" href="javascript:peg002_editRec2Tab( 
			\'d35\', 
			\'d35_d\', 
			\'projects\', 
			0 , 
			\'' . $valuefield . '\', 
			\'' . $data['p302'] . '\'
		);void(0);"><b>' .$data['p302'] .': '. $tbl['p02'] . '</b></a>';
		$message_hidden = false;
	} 
	if (!empty($data['p303'])) {
		if(!$message_hidden){
			$p_text .= '.</br>'.$_SESSION['peg_dic_crm002_d01_msg_contract'] . ' ';
		}else{
			$p_text =  $_SESSION['peg_dic_crm002_d01_msg_contract'] . ' ';
		}
		$p_text .= '<a style="color:'.$link_color.'" href="javascript:peg002_editRec2Tab( 
						 \'cona11\', 
						 \'cona11_d\', 
						 \'contract\', 
						 0 , 
						 \'' . $valuefield . '\', 
						 \'' . $data['p303'] . '\'
					 );void(0);"><b>' . $data['p303'] . '</b></a>';
		$message_hidden = false;
	}
	if (!empty($data['p304'])) {
		$valuefield='p02';
		if(!$message_hidden){
			$p_text .= '.</br>'.$_SESSION['peg_dic_crm002_d01_msg_serial'] . ' ';
		}else{
			$p_text =  $_SESSION['peg_dic_crm002_d01_msg_serial'] . ' ';
		}
		$p_text .= '<a style="color:'.$link_color.'" href="javascript:peg002_editRec2Tab( 
						 \'i31\', 
						 \'i31_d\', 
						 \'serial\', 
						 0 , 
						 \'' . $valuefield . '\', 
						 \'' . $data['p304'] . '\'
					 );void(0);"><b>' . $data['p304'] . '</b></a>';
		$message_hidden = false;
	}
	if (!empty($p012) && !empty($p010)) {
		pegasus_mysql_use("SELECT * FROM p50 WHERE p01=?", $p50, array($p012));
		if (pegasus_mysql_table_exists($p50['p01']) &&  
			$p50['p01']!='d35' && 
			$p50['p01']!='d25' && 
			$p50['p01']!='cona11' &&
	    	$p50['p01']!='i31' &&
			$p50['p01']!='misa01'
			) {
			if(!$message_hidden){
				$p_text .= '.</br>'.$_SESSION['peg_dic_crm002_d01_msg_link_rel'] . ' ';
			}else{
				$p_text =  $_SESSION['peg_dic_crm002_d01_msg_link_rel'] . ' ';
			}
			
			$value = $data['p010'];
			$table = $p50['p01'];
			$view_d = $p50['p02'];
			$module = $p50['module'];
			$text_d  = $p50['p03'];
			$p_text .= str_replace('##p50_p03##', $text_d, $_SESSION['peg_dic_crm002_d01_msg_relation']);
			$p_text .= '<a style="color:'.$link_color.'" href="javascript:peg002_editRec2Tab( 
				\'' . $table . '\', 
				\'' . $view_d . '\', 
				\'' . $module . '\',  
				0 , 
				\'nr01\', 
				\'' . $value . '\'
			);void(0);"><b>' . $value . '</b></a>';
			$message_hidden = false;
		}
	}
	return array('hidden' => $message_hidden, 'msg_txt' => $p_text);
}

function peg_crm002_d01_d53_initialize($data,$mmnr01 ,$mnr01 ,$_d,$container_id ){

	$data['crm002_d01_d53_grid_d01_crm002_grid_d01_open_relation_hidden'] = false;

	return $data;
}

function crm002_d01_d50_find_table_query()
{
	$d01_p03 = $_REQUEST['dias_d01_d50_fld_dt'];
	$pending = $_REQUEST['dias_d01_d50_fld_pending'];
	$d01_p02 = $_REQUEST['dias_d01_d50_fld_us0'];
	$d01_p05 = $_REQUEST['dias_d01_d50_fld_d04'];
	$d01_p06 = $_REQUEST['dias_d01_d50_fld_d02'];
	$us0_p402 = $_SESSION['us0_p402'];
	$us0_p401 = $_SESSION['us0_p401'];

	return crm002_find_d01_query($d01_p03, $d01_p02, $d01_p05, $d01_p06, $us0_p401, $us0_p402, $pending);
}
function crm002_d01_d50_find_table_where()
{

	$p03 = $_REQUEST['dias_d01_d50_fld_dt'];
	$pending = $_REQUEST['dias_d01_d50_fld_pending'];

	$peg_where = ' 1=1 ';
	if (!empty($p03)) {
		if ($pending > 0) {
			$peg_where .= ' and d02.p03=1';
		}
	}
	return $peg_where;
}
/**
 * @param d01_p03: date
 * @param d01_p02: us0
 * @param d01_p05: Είδος δραστηριότητας
 * @param d01_p06: Κατάσταση
 * @param us0_p401: Προνόμιο από
 * @param us0_p402: Προνόμιο εώς
 * @param pending: Εκκρεμότητες
 */
function crm002_find_d01_query($d01_p03, $d01_p02, $d01_p05, $d01_p06, $us0_p401, $us0_p402, $pending=0)
{
	if(empty($us0_p401)){
		$us0_p401 = $_SESSION['us0_p401'];
	}
	
	if(empty($us0_p402)){
		$us0_p402 = $_SESSION['us0_p402'];
	}

	$peg_where = '';
	$where_array = array();

	if (!empty($d01_p03)) {
		if ($pending == 1) {
			$peg_where .= '  d01.p03<=:d01_p03 ';
		} elseif ($pending == 2) {
			$where_array['curdate_30_y_bf'] = peg_addDate(date('Y-m-d') , 'Y-m-d' , 0 , -1 , 0);
			$peg_where .= '  d01.p03>=:curdate_30_y_bf and d01.p03<=:d01_p03 ';
		}else if($pending ==  3){
			$where_array['dt_today'] = $d01_p03;
			$peg_where .= '  d01.p03=:dt_today ';
		}else {
			$peg_where .= '  d01.p03=:d01_p03';
		}
		$where_array['d01_p03'] = $d01_p03;
		
		
	}

	if (!empty($d01_p02)) {
		if (!empty($peg_where)) {
			$peg_where .= ' and ';
		}
		$peg_where .= '  d01.p02=:d01_p02 ';
		$where_array['d01_p02'] = $d01_p02;
	}

	if (!empty($d01_p05)) {
		if (!empty($peg_where)) {
			$peg_where .= ' and ';
		}
		$peg_where .= '  d01.p05=:d01_p05';
		$where_array['d01_p05'] = $d01_p05;
	}

	if (!empty($d01_p06)) {
		if (!empty($peg_where)) {
			$peg_where .= ' and ';
		}
		$peg_where .= ' d01.p06=:d01_p06';
		$where_array['d01_p06'] = $d01_p06;
	}

	if ($us0_p402 > 0) {
		if (!empty($peg_where)) {
			$peg_where .= ' and ';
		}
		$peg_where .= ' (d01.kete>=:us0_p401 and d01.kete<:us0_p402) ';
		$where_array['us0_p401'] = $us0_p401;
		$where_array['us0_p402'] = $us0_p402;
	}

	if (empty($peg_where)) {
		$peg_where = ' d01.nr01<= 1000000000000 ';
	}

	
	if(!pegasus_check_permission('crm002.d01.us0')){
		if (!empty($peg_where)) {
			$peg_where .= ' and ';
		}
		$peg_where .= ' (d01.p02=:us0_p01) ';
		$where_array['us0_p01'] = $_SESSION['username'];
	}  
	

	$d01_query = pegasus_get_grid_table('d01');
	 

	/*Θα πρέπει να χρησιμοποιούνται πάντα named parameters στα pdo statements !*/
	return	array(
		'sql'       =>  " select * from  ". $d01_query."  where $peg_where ",
		'sqlParams' =>  $where_array
	);
}

function peg_crm002_d01_d15_initialize($data, $mmnr01 = '', $mnr01 = '', $_d = '', $container_id = '')
{
	// hide or not υποκατάστημα πελάτη
	$data['crm002_d01_d15_p307_1_hidden'] = true;
	if ($data['p307'] > 0) {
		// Hide υποκαταστημα
		$query = "SELECT count(*) AS cnt 
					FROM a71 JOIN a01 ON a71.p601=a01.nr01 AND a01.nr01= :nr01 ;";
		pegasus_mysql_use($query, $has_store, array('nr01' => $data['p307']));
		if ($has_store['cnt'] > 0) {
			$data['crm002_d01_d15_p307_1_hidden'] = false;
		}
	}
	return $data;
}
function peg_crm002_d01_d15_p304_set_where($container_id,$p01='',$p307=''){

	$p304_where=array(
		'sql' =>  '1=1', 
		'sqlParams' =>  array()
	);

	if(!empty($p01)){ // Συναλλασσόμενος
		$p304_where['sql'].=" and ( i31.p07=:d01_p01_0 /*ιδιοκτητης(CRM) SN */  OR 
									i31.p070=:d01_p01_1  /*πελατης(CRM) SN */ )";
		$p304_where['sqlParams']['d01_p01_0']=$p01;
		$p304_where['sqlParams']['d01_p01_1']=$p01;
	}
	if(!empty($p307)){ //Πελάτης 
		$a01_pnr01 = pegasus_mysql_printfld('a01', 'pnr01', 'nr01 = ?', array($p307));
		$p304_where['sql'].=" and ( i31.p07=:a01_pnr01_0 /*ιδιοκτητης(CRM) SN */  OR 
									i31.p070=:a01_pnr01_1  /*πελατης(CRM) SN */ )"; 
		$p304_where['sqlParams']['a01_pnr01_0']=$a01_pnr01;
		$p304_where['sqlParams']['a01_pnr01_1']=$a01_pnr01;
	}
	if(!empty($p01) && !empty($p307)){
		$p304_where=array(
			'sql' =>  '1=1', 
			'sqlParams' =>  array()
		);
	}
	// var_dump($p304_where);
	
	pegasusSetGlobalVar($container_id.'_crm002_d01_d15_p304_where', $p304_where	);
}
function peg_crm002_d01_d15_reset_p304($container_id,$p304){
	$p304_where = pegasusGetGlobalVar($container_id.'_crm002_d01_d15_p304_where');
	if(pegasus_module_exists('serial')){
		$query = 'select * from i31 where '.$p304_where['sql'].' and i31.p02=:p304';
		$p304_where['sqlParams']['p304']=$p304;
		$result = pegasus_query($query, $p304_where['sqlParams']);
		if (pegasus_num_rows($result) > 0) {
			return true;
		} else {
			return false;
		}
	}
	return false;
}
function peg_crm002_d01_d20_initialize($data, $mmnr01 = '', $mnr01 = '', $_d = '', $container_id = '')
{

	$data['crm002_d01_d20_tab_hidden_tablet']=true;

	crm002_d20_refresh($mmnr01 ,$mnr01,$container_id);

	return $data;
}


function peg_crm002_d01_d_initialize($data, $mmnr01 = '', $mnr01 = '', $_d = '', $container_id = '')
{
	global $PegInput;

	$peg_isNewRec = false;
	if (!($data['nr01'] > 0) and $_d == 'd01_d') {
		$peg_isNewRec = true;
		$data['nr01'] = pegasus_mysql_newrec('d01');
		$data['kete'] = $_SESSION['us0_p400'];
	}

	if ($_SESSION['us0_p402'] > 0 && !$peg_isNewRec) {
		$res = pegasus_query(
			"select * from d01 where kete>=:kete01 and kete<:kete02 and nr01=:value limit 1",
			array(
				'kete01'	=>	$_SESSION['us0_p401'],
				'kete02'	=>	$_SESSION['us0_p402'],
				'value' 	=> 	$data['nr01']
			)
		);
		if (pegasus_num_rows($res) <= 0) {
			$data = array();
			$data['permDeny'] = 1;
			$data['permDenyMessage'] = $_SESSION['peg_dic_crm002_kete_deny'];
			return $data;
		}
	}
	if (empty($data['p01'])) {
		if (!empty($mmnr01)) {
			$peg_arr = explode('-', $mmnr01);
			// αν η νέα εγγραφή προέρχεται μεσα απο το από ένα συναλλασσόμενο γνωρίζω το d00nr
			if (strtolower($peg_arr[0]) == 'd00_d') {
				$data['p01'] = $peg_arr[1];
			} else if (strtolower($peg_arr[0]) == 'a57_d') {
				$query = "SELECT a01.pnr01 
                			  FROM a01 
                			  JOIN a57 ON a57.p03=a01.nr01
                			  WHERE a57.nr01=?";

				pegasus_mysql_use($query, $a01, array($peg_arr[1]));
				$data['p01'] = $a01['pnr01'];
			} else if (strtolower($peg_arr[0]) == 'a67_d') {
				$query = "SELECT a00.pnr01 
                			  FROM a00 
                			  JOIN a67 ON a67.p03=a00.nr01
                			  WHERE a67.nr01=?";

				pegasus_mysql_use($query, $a00, array($peg_arr[1]));
				$data['p01'] = $a00['pnr01'];
			} else if (strtolower($peg_arr[0]) == 'a55_d') {
				$query = "SELECT a01.pnr01 
                			  FROM a01 
                			  JOIN a55 ON a55.p03=a01.nr01
                			  WHERE a55.nr01=?";

				pegasus_mysql_use($query, $a01, array($peg_arr[1]));
				$data['p01'] = $a01['pnr01'];
			} else if (strtolower($peg_arr[0]) == 'a56_d') {
				$query = "SELECT a00.pnr01 
                			  FROM a00 
                			  JOIN a56 ON a56.p03=a00.nr01
                			  WHERE a56.nr01=?";

				pegasus_mysql_use($query, $a00, array($peg_arr[1]));
				$data['p01'] = $a00['pnr01'];
			}
		}
	}

	//Αν η καταχώρηση ειναι μέσα σπο Εργο
	if (substr($mmnr01, 0, 5) == 'd25_d') {
		$data['p301'] = substr($mmnr01, 6);

		/* Βρίσκω τον συν/μενο του έργου */
		$query = " SELECT * FROM d25 WHERE nr01= :nr01";
		pegasus_mysql_use($query, $d25, array('nr01' => $data['p301']));

		$data['p307']  = $d25['p09'];
		$data['p303']  = $d25['p012'];
		$data['p304']  = $d25['p013'];
		$data['p3041'] = $d25['p014'];
		if ($peg_isNewRec === true) {
			$data['p02']   = $d25['p01'];
			if (isset($d25['p03'])) {
				$data['p01'] = $d25['p03'];
			}
			$data['v_p30'] = $d25['p02'];
		}


		/* Αντίγραφο Πρότυπης Εργασίας στο ίδιο έργο */
		$query = 'SELECT p100_1 
					FROM d35
					WHERE d35.p00= :d25_nr01';
		pegasus_mysql_use($query, $d35, array('d25_nr01' => $data['p301']));

		$data['p313_1'] = $d35['p100_1'];
	}

	//Αν η καταχώρηση ειναι μέσα σπο Εργασία Εργου
	if (substr($mmnr01, 0, 5) == 'd35_d') {
		$query = 'SELECT p00,d25.p03,d35.p01,d35.p02, d25.p02 as d25_p02 FROM d35
						   JOIN d25 ON (d35.p00 = d25.nr01)
						    WHERE d35.nr01=:mnr01';
		pegasus_mysql_use($query, $tbl, array('mnr01' => $mnr01));

		$data['p301'] = $tbl['p00'];
		$data['p302'] = $mnr01;
		if ($peg_isNewRec === true) {
			$data['p02']  = $tbl['p01'];
			if (isset($tbl['p03'])) {
				$data['p01'] = $tbl['p03'];
			}
			$data['v_p30'] = $tbl['p02'];
		}
	}

	/* Υπολογίζω Αριθμό δραστηριότητας βάσει το έργο*/
	if ($data['p301'] > 0) {
		$query = "	SELECT max(p313) AS max1 
					FROM d01
					WHERE d01.p301= :d25_nr01";

		pegasus_mysql_use($query, $tt, array('d25_nr01' => $data['p301']));

		if ($tt['max1'] == 0) {
			$data['p313'] = 1;
		} elseif ($tt['max1'] != 0 && $data['p313'] == 0) {
			$data['p313'] = $tt['max1'] + 1;
		}
	}


	/** Αν η καταχώρηση έρχεται από:
	 *  cona11_d : συμβάσεις πελατών
	 *  cona18_d : Ατιμολόγητες συμβάσεις
	 *  cona19_d : Περιοδική Τιμολόγηση
	 * cona17_d : Συμβασεις: Ληξιάριο
	 */

	if (substr($mmnr01, 0, 8) == 'cona11_d' || substr($mmnr01, 0, 8) == 'cona18_d' || substr($mmnr01, 0, 8) == 'cona19_d' || substr($mmnr01, 0, 8) == 'cona17_d') {
		$data['p303'] = $mnr01;
		$query = 'SELECT * FROM cona11 WHERE cona11.nr01= :mnr01';
		pegasus_mysql_use($query, $tbl, array('mnr01' => $mnr01));
		$data['p307'] 	= $tbl['p02'];
		$data['p307_1'] = $tbl['p02_1'];
		$data['p01'] 	= $tbl['p03'];
		$data['p01_1'] 	= $tbl['p03_1'];
	}
	//Ανοιγμα απο Serial
	if (substr($mmnr01, 0, 5) == 'i31_d' ) {
		$query = 'SELECT * FROM i31 WHERE nr01= :mnr01';
		pegasus_mysql_use($query, $tbl, array('mnr01' => $mnr01));
		$data['p304'] 	= $tbl['p02'];
		$data['p3041'] 	= $tbl['p01'];
		$data['p307'] 	= $tbl['p070'];
		$data['p01'] 	= $tbl['p07'];
	}
	if(substr($mmnr01, 0, 8) == 'phna01_d'){
		if(function_exists('phone_phna01_peg_crm002_d01_d_initialize')){
			$data = phone_phna01_peg_crm002_d01_d_initialize($data, $mnr01);
		}
	}

	
	// hide or not υποκατάστημα συναλλασσομένου
	$data['crm002_d01_d_p01_1_hidden'] = true;
	if ($data['p01'] > 0) {
		// Hide υποκαταστημα συναλλασσομένου
		$query = "SELECT count(*) AS cnt 
					FROM d88 JOIN d00 ON d88.p601=d00.nr01 AND d00.nr01= :nr01 ;";
		pegasus_mysql_use($query, $has_store, array('nr01' => $data['p01']));
		if ($has_store['cnt'] > 0) {
			$data['crm002_d01_d_p01_1_hidden'] = false;
		}
	}

	// hide or not υπευθυνο συναλλασσομένου
	$data['crm002_d01_d_p312_hidden'] = true;
	if ($data['p01'] > 0) {
		// Hide υπευθυνο συναλλασσομένου
		$query = "SELECT count(*) AS cnt 
					FROM d69 WHERE d69.p00 =:nr01 ";
		pegasus_mysql_use($query, $has_salesperson, array('nr01' => $data['p01']));
		//$has_salesperson['cnt']=3;
		if ($has_salesperson['cnt'] > 0) {
			$data['crm002_d01_d_p312_hidden'] = false;
		}
	}

	/* Ανοίγουμε από button Ληξιάριο */

	$PegInput->addVar(new peg_input_number('cona11_nr01'));
	if ($PegInput->issetRequest('cona11_nr01') && $PegInput->getRequest('cona11_nr01') > 0) {
		$data['p303'] = $PegInput->getRequest('cona11_nr01');
		$data['p01'] = pegasus_mysql_printfld('cona11', 'p03', 'nr01=:cona11_nr01', array('cona11_nr01' => $data['p303']));
	}

	if (empty($data['p02'])) {
		$data['p02'] = $_SESSION['username'];
	}


	if (($_REQUEST['rec_copy_nr01'] > 0)) {
		$data['v_p30'] = $data['p30'];
		$data['p30']   = '';
	}
	$data['peg_user_p01'] = $_SESSION['username'];
	$data['peg_user_p100'] = pegasus_mysql_printfld('us0', 'p100', 'p01=?', array($_SESSION['username']));
	$data['peg_p30_init'] = $data['p30'];
	$data['peg_p31_init'] = $data['p31'];

	$data['message_link_hidden'] = true;
	$data['message_hidden'] = true;

	$relation_msg = crm002_find_d01_relation($data['p010'],$data['p012'],$data);
	
	if($relation_msg['hidden']===false){
		$data['message_link_hidden'] = false;
		$data['message_link'] = '<p class=\'success_message\'>' . $relation_msg['msg_txt'] . '.</p>';
	}
	

	// An einai neo record dimioyrgw to nr01
	if ((!($data['nr01'] > 0)) and $_d == 'd01_d') {
		$data['kete'] = $_SESSION['us0_p400'];
	}

	//
	//pegasusSetGlobalVar('peg_d01_d-' . $data['nr01'] . '_p02_where',  "p300=1");

	if (!empty($_REQUEST['gd01dname'])) {
		$peg_tmp_dataArray = pegasusGetGlobalVar($_REQUEST['gd01dname']);
		if (is_array($peg_tmp_dataArray)) {
			foreach ($peg_tmp_dataArray as $key => $value) {
				$data[$key] = $value;
			}
		}
		pegasusUnSetGlobalVar($_REQUEST['gd01dname']);
	} elseif (!empty($_REQUEST['_plano00_crm005_d_vars'])) {
		$peg_tmp_dataArray = pegasusGetGlobalVar($_REQUEST['_plano00_crm005_d_vars']);
		if (is_array($peg_tmp_dataArray)) {
			foreach ($peg_tmp_dataArray as $key => $value) {
				$data[$key] = $value;
			}
		}
		pegasusUnSetGlobalVar($_REQUEST['_plano00_crm005_d_vars']);
	}

	if (!empty($_REQUEST['peg_table'])) {
		$data['p012'] = $_REQUEST['peg_table'];
		$data['p010'] = $_REQUEST['peg_nr01'];
	}
	$p012_query=
	"	SELECT p50.* 
		FROM p50 
		JOIN p95p50 ON p95p50.p50=p50.p01 AND ( p95p50.sh=1 || p95p50.p50=:var_p012 ) && p95p50.p95=:var_p95 
		WHERE p50.p01!='' AND p50.is_view=0";
	$p012_queryParams=array(	"var_p95"	=>	$_SESSION['user_profile'] ,
								"var_p012"	=>	$data['p012']  );
	
	
	pegasusSetGlobalVar($container_id."_p012_query",array(	'sql'		=>	$p012_query, 
															'sqlParams'	=>	$p012_queryParams));

	
	$data['p010_label']=$_SESSION['peg_dic_crm002_d01_p010_label'];			
	if(!empty($data['p012'])){
		$p50_rel_data=array();
		pegasus_mysql_use("SELECT p01,p02,p03,module from p50 where p01=?",$p50_rel_data,array($data['p012']));
		$data['crm002_d01_d15_p010_hidden']=(pegasus_mysql_printfld("p95p50","sh"," p95p50.p50=:var_p012 && p95p50.p95=:var_p95",$p012_queryParams)==1);
		$data['crm002_d01_d15_p010_'.$p50_rel_data['p01'].'_hidden']=(!$data['crm002_d01_d15_p010_hidden']);

		$data['p010_selected_table']=$p50_rel_data['p01'];
		$data['p010_selected__d']=$p50_rel_data['p02'];
		$data['p010_selected_module']=$p50_rel_data['module'];
		if(!empty($data['p010'])){
			$data['p010_'.$p50_rel_data['p01']]=$data['p010'];
			$data['dias_var_p010_'.$p50_rel_data['p01']]=$data['p010'];
		}
	}
	if ($_d == 'd01_d') {
		/* 
    	    $whereTmpTbl = ' peg_flag!=9 and '.
    	   	    ' peg_sess_id="' . session_id() . '"  and '.
    	   	    ' peg_mmnr01="d01_d-'.$data['nr01']  . '" and  '.
    	   	    ' peg_mnr01="'.$data['nr01']  . '" ';
    	    //Dimiourgoume ola ta tmp
    	    pegasus_make_all_tmp_recs('d01' , $data , $data['nr01'] , $_REQUEST['rec_copy_nr01'] , 'd01_d-'.$data['nr01'] );
    	*/
		//pegasusSetGlobalVar( $container_id . '_where_d01_d20' ,  'd01.p01="' .$mnr01. '"' );

		//γράφτηκε μέσα στο where της οθόνης για να παίζει και στο grid - προς διαγραφή
		// $where = ' d04.p00>=0 ';
		// pegasusSetGlobalVar($container_id . '_where_d04', $where);


		pegasusSetGlobalVar($container_id . '_query_d02_d', peg_crm002_d02_d_query($data));
	}

	$data = peg_crm002_d01_d_refresh($data);


	/**
	 * permission (crm002.d01.us0) proboli drastiriothtas allon xristwn
	 */
	if (
		!pegasus_check_permission('crm002.d01.us0')  and 
		!empty($data['p02']) and 
		$data['p02'] != $_SESSION['username'] and
		$peg_isNewRec===false
		) {
		foreach ($data as $key => $value) {
			if (!strpos(strtolower($key), '_hidden') > 0 and !strpos(strtolower($key), '_readnoly') > 0) {
				$data[$key] = "";
				$data[$key . '_hidden'] = 1;
			}
		}

		$res = pegasus_query('select * from p51 where p02="d01_d" and module="crm002" and desc07 in ("fieldset" , "tab")');
		while ($d01_p51 = pegasus_fetch($res)) {
			$data[$d01_p51['desc05'] . '_hidden'] = 1;
		}


		$res = pegasus_query("select * from p81 where _d=\"d01_d\"  and module = \"crm002\" and type not in ('save_tab' ,  'close_tab' , 'update_tab') ");
		while ($d01_p81 = pegasus_fetch($res)) {
			if ($d01_p81['type'] == 'archive') {
				$data[$d01_p81['module'] . '_' . $d01_p81['_d'] . '_archive_hidden'] = true;
			} else {
				$data[$d01_p81['module'] . '_' . $d01_p81['_d'] . '_toolbarbutton_' . $d01_p81['nr01'] . '_hidden'] = true;
			}
		}

		$data['msg'] = "<p class=\"alert_message\">" . $_SESSION['peg_dic_crm002_noperm_crm002.d01.us0'] . "</p>";
		$data['readonly'] = 1;
	}


	if (empty($data['msg'])) {
		$data['msg_hidden'] = 1;
	} else {
		$data['msg_hidden'] = 0;
	}
	
	$data['p421_btn_hidden'] = true;
	if(
		pegasus_module_exists('crm004')
		&& pegasus_profile_check_data_permission('da4' , 'SHOW' , $_SESSION['user_profile'])
		&& pegasus_profile_check_module_permission('crm004', $_SESSION['user_profile'])
	) {
		$data['p421_btn_hidden'] = false;
	}

	$data['v_vis_sn'] = 3;
	$p01=''; //Συναλλασσόμενος
	$p307=''; //Κωδικός πελάτη
	if($data['p307']>0){
		$data['v_vis_sn'] = 2;
		$p307=$data['p307'];
	}
	if($data['p01']>0){
		$data['v_vis_sn'] = 1;
		$p01=$data['p01'];
	}
	if($data['p307']>0 && $data['p01']>0 ){
		$data['v_vis_sn'] = 3;

	}
	
	peg_crm002_d01_d15_p304_set_where($container_id,$p01,$p307);

	pegasusSetGlobalVar(
		$container_id . '_d01_p401_where', 
		array(
			'sql'=> '(d32.p013 = 1 OR d32.nr01 = :nr01)',
			'sqlParams' => array('nr01' => $data['p401'])
		)
	);
	
	return $data;

}

function peg_crm002_d02_d_query($data)
{

	$join_d02_d = '';
	if (!empty($data['p05'])) {
		$join_d02_d = " join d04 on d04.p01='" . $data['p05'] . "' and (d04.p04 like concat('%#', d02.p01, '#%') or d04.p04='') ";
	}

	$query_d02_d  = "select d02.* from d02 ";
	$query_d02_d .= $join_d02_d;
	$query_d02_d .= "where d02.p00>=0;";

	return $query_d02_d;
}

/**
 * Αλλαγή Σημειώσεων
 * @param array $data
 * @param string $mmnr01
 * @param string $mnr01
 * @param string $_d
 * @param string $container_id
 * @return array
 */
function peg_crm002_d01_d03_initialize($data, $mmnr01 = '', $mnr01 = '', $_d = '', $container_id = '')
{
	if ($_d == 'd01_d03' ) {
		if (strpos($mmnr01, 'd01_d-') === 0 || strpos($mmnr01, 'd25_d-') === 0 || strpos($mmnr01, 'd35_d-') === 0) {
			$tmp_vp30 = pegasusGetGlobalVar($_REQUEST['peg_screen_parent_container_id'] . '_tmp_p30');
			if (empty($tmp_vp30)) {
				$data['vp30'] = pegasus_mysql_printfld('d01', 'p30', 'nr01 = :mnr01', array('mnr01' => $mnr01));
			} else {
				$data['vp30'] = $tmp_vp30;
			}
		}
		$data['vp30'] .= '<p></p>';
	}
	return $data;
}

function peg_crm002_d04_d_initialize($data, $mmnr01 = '', $mnr01 = '', $_d = '', $container_id = '')
{
	if ($_d == 'd04_d') {
		$where = ' d02.p00>=0 ';
		pegasusSetGlobalVar($container_id . '_where_d02', $where);
	}
	return $data;
}

function crm002_d01_d_ondelete( $data,$permDeny , $mmnr01 , $checkOnlyPerm,$grid_editing){
	if(pegasus_module_exists("notif") && !$checkOnlyPerm){
		pegasus_mysql_delete('notif02',"p01=:notif02_p01 and tbl='d01' and tbl_nr01=:notif_tbl_nr01",0,array(	'notif02_p01'	=>	$data['p02'] , 'notif_tbl_nr01'	=>	$data['nr01']));
		notif_broadcast_push_event(array('type'=>'read_d01' ,'us0p01' =>$data['p02'],'actionType'=>	 'messageToClient'));

	}
	return array($data, $permDeny);
}

function peg_crm002_d01_d_execute_before_save()
{
	global $PegInput;
	$PegInput->addVar(new peg_input_number('nr01'));
	$PegInput->addVar(new peg_input_alphanumeric('p02'));
	$PegInput->addVar(new peg_input_number('p104'));
	$PegInput->addVar(new peg_input_alphanumeric('p03'));
	$PegInput->addVar(new peg_input_number('p3053'));
	$PegInput->addVar(new peg_input_number('p306'));
	$PegInput->addVar(new peg_input_number('p06'));
	$PegInput->addVar(new peg_input_alphanumeric('p09'));
	$PegInput->addVar(new peg_input_number('p05'));
	$data = array(
		'nr01'	=> $PegInput->getRequest('nr01'),
		'p02'	=> $PegInput->getRequest('p02'),
		'p03'	=> $PegInput->getRequest('p03'),
		'p3053'	=> $PegInput->getRequest('p3053'),
		'p306'	=> $PegInput->getRequest('p306'),
		'p06'	=> $PegInput->getRequest('p06'),
		'p09'	=> $PegInput->getRequest('p09'),
		'p05'	=> $PegInput->getRequest('p05'),
	);


	$old_p02 = pegasus_mysql_printfld('d01' , 'p02' , 'nr01=' . $data['nr01']);
	// Αν άλλαξε ο χρήστης τότε ορισμός ως μη αναγνωσμένη
	if($data['p02'] != $old_p02){
		$PegInput->setRequest('p104',0);
	}
	// Αν είναι δραστηριότητα του ίδιου του user τότε είναι αναγνωσμένη
	if($data['p02'] == $_SESSION['username']){
		$PegInput->setRequest('p104',1);
	}
	// Αν δεν έχει ημερομηνία
	if(peg_dateIsEmpty($data['p03'],'Y-m-d')){
		return array(
			'denySave'	=> 1,
			'denyMsg'	=> $_SESSION['peg_dic_crm002_d01_p03empty']
		);
	}
	// Αν δεν έχει οριστεί προγραμματισμένη διάρκεια
	if($data['p3053'] < 0){
		return array(
			'denySave'	=> 1,
			'denyMsg'	=> $_SESSION['peg_dic_crm002_d01_al1']
		);
	}
	// Αν δεν έχει οριστεί πραγματική διάρκεια   
	if($data['p306'] < 0){
		return array(
			'denySave'	=> 1,
			'denyMsg'	=> $_SESSION['peg_dic_crm002_d01_al2']
		);
	}
	// Κατάσταση
	$d02_p03 = pegasus_mysql_printfld(
		'd02', 
		'p03', 
		'p01 = :p01',
		array(
			'p01' => $data['p06']
		)
	); 
	// Αν η κατάσταση είναι (τύπου) εκτελέστηκα και δεν έχει οριστεί πραγματική ώρα εκτέλεσης
	// Και δεν έχει εγγραφή στους χρόνους δραστηριότητας με ημερομηνία  και ώρα λήξης (Ε: 10000289)
	$d99104_p09_cnt = pegasus_mysql_printfld(
		'd99104',
		'COUNT(nr01)',
		"d01 = :d01",
		array(
			'd01' => $data['nr01']
		)
	);
	if(
		$d02_p03 == 3 
		&& empty($data['p09'])
		&& !($d99104_p09_cnt > 0)
	) {
		return array(
			'denySave'	=> 1,
			'denyMsg'	=> $_SESSION['peg_dic_crm002_d01_al3']
		);
		
	}
	// Αν η κατάσταση Δεν είναι (τύπου) εκτελέστηκα και  έχει οριστεί πραγματική ώρα εκτέλεσης
	if(
		$d02_p03 != 3 
		&& !empty($data['p09'])
	) {
		return array(
			'denySave'	=> 1,
			'denyMsg'	=> $_SESSION['peg_dic_crm002_d01_al4']
		);
	}
	// Επιτρέπεται η καταχώρηση το Σάββατο
	$d04_p106 = pegasus_mysql_printfld(
		'd04', 
		'p106', 
		'p01 = :p01',
		array(
			'p01' => $data['p05']
		)
	); 
	// Αν είναι Σάββατο και δεν επιτρέπεται το Σάββατο
	if(
		date('w' , peg_dateToTimeStamp(substr($data['p03'],0,10) , 'Y-m-d') ) == 6
		&& $d04_p106 == 0
	) {
		return array(
			'denySave'	=> 1,
			'denyMsg'	=> $_SESSION['peg_dic_crm002_d01_al5']
		);
	}
	// Επιτρέπεται η καταχώρηση την Κυριακή
	$d04_p107 = pegasus_mysql_printfld(
		'd04', 
		'p107', 
		'p01 = :p01',
		array(
			'p01' => $data['p05']
		)
	);
	// Αν είναι Κυριακή και δεν επιτρέπεται η Κυριακή
	if(
		date('w' , peg_dateToTimeStamp(substr($data['p03'],0,10) , 'Y-m-d') ) == 0 
		&& $d04_p107 == 0
	) {
		return array(
			'denySave'	=> 1,
			'denyMsg'	=> $_SESSION['peg_dic_crm002_d01_al6']
		);
	}
	// Επιτρέπετε η καταχώρηση την αργία
	$d04_p108 = pegasus_mysql_printfld(
		'd04',
		'p108',
		'p01 = :p01',
		array('p01' => $data['p05'])
	); 
	if($d04_p108 == 0){
		$argia_0 = array();
		$argia_1 = array();
		$arr = peg_dateToArray(substr($data['p03'],0,10) , 'Y-m-d');
		// Αργία που ισχύει για όλες τις χρονιές
		$sql = "	SELECT
						DAY(d43.p01) AS `day`,
						MONTH(d43.p01) as `month`,
						d43.* 
					FROM d43
					WHERE 1 = 1
					AND d43.p05 = 1
					HAVING `month` = :p03_month 
					AND `day` = :p03_day
		";
		$values = array(
			'p03_month'	=> $arr['month'],
			'p03_day'	=> $arr['day']
		);
		pegasus_mysql_use($sql, $argia_0, $values);
		// Αργία που ΔΕΝ ισχύει για όλες τις χρονιές
		$sql = "	SELECT d43.* 
					FROM d43  
					WHERE 1 = 1
					AND p05 = 0
					AND p01 = :p01
		";
		$values = array(
			'p01'	=> $arr['year'] . $arr['month'] . $arr['day']
		);
		pegasus_mysql_use($sql, $argia_1, $values);
		// Αν υπάρχει στις αργίες της εταιρίας
		if(
			$argia_0['nr01'] > 0
			|| $argia_1['nr01'] > 0
		){
			return array(
				'denySave'	=> 1,
				'denyMsg'	=> $_SESSION['peg_dic_crm002_d01_al7']
			);
		}
	}
	return array(
		'denySave'	=> 0,
		'denyMsg'	=> ''
	);
}
function peg_crm002_d01_d_onsave($data, $permDeny, $mmnr01, $checkOnlyPerm)
{

	if(
		$data['p06'] == $_SESSION['crm002_d01_d02_play']
		|| $data['p06'] == $_SESSION['crm002_d01_d02_pause']
		|| $data['p06'] == $_SESSION['crm002_d01_d02_stop']
	) {
		$d99104 = new d99104();
		$resp = $d99104->set_d01(
			$data['nr01'],
			$data['p03']
		);
		if($resp['ok'] != 1) {
			array_push($permDeny, array('type' => 'confirm', 'message' => $resp['msg']));
		}
		$resp = array();
		switch($data['p06']) {
			case $_SESSION['crm002_d01_d02_play'] :
				$resp = $d99104->play($data,$checkOnlyPerm);
			break;
			case $_SESSION['crm002_d01_d02_pause'] : 
				$resp =  $d99104->pause($data,$checkOnlyPerm);
			break;
			case $_SESSION['crm002_d01_d02_stop'] : 
				$resp =  $d99104->stop($data,$checkOnlyPerm);
			break;
		}
		if(
			!empty($resp)
			&& $resp['ok'] != 1
		) {
			array_push($permDeny, array('type' => $resp['type'], 'message' => $resp['msg']));
		}
	}


	if(pegasus_mysql_table_exists('crm004_000_10000000')){
		if($data['p05'] == 99999 || $data['p05'] == 99998){
			$query = "select da5_10000001, da5_10000000 from crm004_000_10000000 where d01 = :d01_nr01";
			pegasus_mysql_use($query, $crm004_000, array('d01_nr01' => $data['nr01']));
			if($data['p421'] != 10000000){
				array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_crm002_empty_p421']));
			}elseif(empty($crm004_000['da5_10000000']) || empty($crm004_000['da5_10000001'])){
				array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_crm002_empty_year_or_kind']));
			}
			//file_put_contents("../../tmp/btheo.txt", print_r($data, true), FILE_APPEND);
		}
	}

	if (peg_dateIsEmpty(substr($data['p03'], 0, 10), 'Y-m-d')) {
		array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_crm002_d01_p03empty']));
		return array($data, $permDeny);
	}

	$chans_memo='';
	$data = peg_crm002_d01_d_refresh($data);
	// Άμα δεν έχει εγγραφές στον d99104 (Ε: 10000289)
	$d99104_cnt = pegasus_mysql_printfld(
		'd99104',
		'COUNT(nr01)',
		'd01 = :d01',
		array('d01' => $data['nr01'])
	);
	unset($data['message']);
	unset($data['message_hidden']);
	//Καναμε unset διότι δημιουργούσε πρόβλημα στο onsave του d01_d 

	pegasus_mysql_use("select * from d04 where p01=?;", $d04, array($data['p05']));
	pegasus_mysql_use("select * from d60 where p01=?;", $d60, array($data['p320']));
	pegasus_mysql_use("select * from d02 where p01=?;", $d02, array($data['p06']));
	pegasus_mysql_use("select * from d01 where nr01=?;", $old_d01, array($data['nr01']));
	// Δεν μπορεί να αλλάξει η ημερομηνία της δραστηριότητας άμα αυτή έχει χρόνους και ο χρήστης δεν έχει permissions
	if(
		$d99104_cnt > 0
		&& $old_d01['nr01'] > 0
		&& $data['p03'] != $old_d01['p03']
		&& !pegasus_check_permission('crm002_d99104_d01_p03_change')
	) {
		array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_crm002_d01_d_no_p03_change_on_d99104_exists']));
	}
	// Δεν μπορεί να αλλάξει ο χρήστης της δραστηριότητας άμα αυτή έχει χρόνους και ο χρήστης δεν έχει permissions
	if(
		$d99104_cnt > 0
		&& $old_d01['nr01'] > 0
		&& $data['p02'] != $old_d01['p02']
		&& !pegasus_check_permission('crm002_d99104_d01_p02_change')
	) {
		array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_crm002_d01_d_no_p02_change_on_d99104_exists']));
	}
	//$peg_old_v_p02 =  pegasus_mysql_printfld('d01', 'p02', 'nr01=?', array($data['nr01']));
	if (
		$data['p02'] != $old_d01['p02'] 
		&& $old_d01['nr01']>0
	) {
		$chans_memo .= 	'<b>' . $_SESSION['peg_dic_crm002_d01_p02'] . ':</b> ' .
		' (' . $old_d01['p02'] . ') ' . pegasus_mysql_printfld('us0', 'p100', 'p01=?', array($old_d01['p02']))  . ' -> ' .
		' (' . $data['p02'] . ') '    . pegasus_mysql_printfld('us0', 'p100', 'p01=?', array($data['p02']))  . '<br>'; 
		$data['p104'] = 0;
	}
	if (
		$old_d01['nr01'] > 0
		&& (
			$data['p02'] != $old_d01['p02'] 
			|| $old_d01['p02'] == $_SESSION['username']
		)
	) {
		if(function_exists('notif_set_notification_read_status')){
			//An o xristis exei allaxei tote i eidopoiisi gia ton palio tha prepei na markaristei os diavasmeni
			$notif02_query="SELECT nr01 FROM notif02 WHERE p01=:notif02_p01 and tbl='d01' and tbl_nr01=:notif_tbl_nr01";
			$notif02_queryParams=array(	'notif02_p01'	=>	$old_d01['p02'] , 'notif_tbl_nr01'	=>	$old_d01['nr01']);
			$notif02_res=pegasus_query($notif02_query,$notif02_queryParams);
			while($row=pegasus_fetch($notif02_res)){
				notif_set_notification_read_status($row['nr01']);
			}
		}
	}

	if ($data['p02'] == $_SESSION['username']) {
		$data['p104'] = 1;
	}
	// Προγραμματισμένη Διάρκεια (ωρες)
	if ($data['p3053'] < 0) {
		array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_crm002_d01_al1']));
	}
	// Πραγματική Διάρκεια (Ωρες)
	if ($data['p306'] < 0) {
		array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_crm002_d01_al2']));
	}
	$d02_p03 = pegasus_mysql_printfld('d02', 'p03', 'p01=?', array($data['p06']));
	if (
		$d02_p03 == 3 
		&& empty($data['p09'])
	) {
		array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_crm002_d01_al3']));
	}
	if (
		$d02_p03 != 3 
		&& (!empty($data['p09']))
	) {
		array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_crm002_d01_al4']));
	}
	$d04_p106 = pegasus_mysql_printfld('d04', 'p106', 'p01=?', array($data['p05']));
	if (
		date('w', peg_dateToTimeStamp(substr($data['p03'], 0, 10), 'Y-m-d')) == 6 
		&& $d04_p106 == 0
	) {
		array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_crm002_d01_al5']));
	}
	$d04_p107 = pegasus_mysql_printfld('d04', 'p107', 'p01=?', array($data['p05']));
	if (
		date('w', peg_dateToTimeStamp(substr($data['p03'], 0, 10), 'Y-m-d')) == 0 
		&& $d04_p107 == 0
	) {
		array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_crm002_d01_al6']));
	}
	$d04_p108 = pegasus_mysql_printfld('d04', 'p108', 'p01=?', array($data['p05']));
	if ($d04_p108 == 0) {
		$arr = peg_dateToArray(substr($data['p03'], 0, 10), 'Y-m-d');
		pegasus_mysql_use("select DAY(d43.p01) as day ,MONTH(d43.p01) as month,d43.* from d43  where p05=1 having month=:month and day=:day;", $argia_0, array('month' => $arr['month'], 'day' => $arr['day']));
		pegasus_mysql_use("select d43.* from d43 where p05=0 and p01=:p01;", $argia_1, array('p01' => $arr['year'] . $arr['month'] . $arr['day']));

		if ($argia_0['nr01'] > 0  or $argia_1['nr01'] > 0) {
			array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_crm002_d01_al7']));
		}
	}
	if (
		(
			$d04['p105'] == 1 
			|| $d04['p101'] == 1 
			|| $d60['p010'] == 1
		)
		&& (
			empty($data['p04']) 
			|| empty($data['p08'])
			)
		) {
		array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_crm002_fill_in_the_time']));
	}
	$d01_start_date = $data['p03'];
	$d01_end_date   = '';
	if (!peg_dateIsEmpty($data['p081'])) {
		$d01_end_date = $data['p081'];
	}

	if (!peg_dateIsEmpty($data['p091'])) {
		$d01_end_date = $data['p091'];
	}
	$d99104_end_date = pegasus_mysql_printfld(
		'd99104',
		'p02',
		"
			d01 = :d01
			AND IFNULL(p02,'') > '0100-01-01'
		",
		array('d01' => $data['nr01'])
	);
	if (!peg_dateIsEmpty($d99104_end_date)) {
		$d01_end_date = $d99104_end_date;
	}

	/**
	 * Ώρα έναρξης 
	 */
	$d01_start_time = '';
	if (!empty($data['p04'])) {
		$d01_start_time = $data['p04'];
	}

	/**
	 * Ώρα λήξης 
	 */
	$d01_end_time   = '';
	if (!empty($data['p08'])) {
		$d01_end_time = $data['p08'];
	}

	/*Υπάρχει δραστηριοτήτα την ίδια ώρα.*/
	if (
		(
			$d04['p101'] == 1
			|| $d60['p010'] == 1
		) 
		&& (
			$d02['p03'] == 1
			||  $d02['p03'] == 3
		) 
		&& !empty($d01_start_time) 
		&& !empty($d01_end_time) 
		&& $d01_start_time!='00:00' 
		&& $d01_end_time!='00:00'
	) {
		$peg_str = "SELECT 		
    			d01.nr01 as nr01,
    			d00.p19 as p19,
    			d01.p03 as start_date,
    			if(d01.p091<='01000101' 
    				, if(d01.p081<='01000101' , d01.p03, d01.p081  )
    				, d01.p091  
    			) as end_date ,
                
				d01.p04 as start_time,
    			d01.p08 as end_time 

                FROM d01, d02, d04, d60 , d00
                WHERE d01.nr01<>:nr01  
                  &&  d01.p02=:p02
    
                  &&  substr(d01.p04, 1,2)<>'  ' && d01.p04<>''
                  &&  substr(d01.p08, 1,2)<>'  ' && d01.p08<>''
                  
    			  
                  &&  d01.p01=d00.nr01
    			  &&  d01.p05=d04.p01
                  &&  d01.p06=d02.p01
                  &&  d01.p320=d60.p01
                  &&  (d04.p101='1' || d60.p010='1') 
                  &&  d02.p03 IN (1, 3) 
                  &&  d01.p03 IN (:p03_00 , :p03_01, :p03_02)
                  
					HAVING
					 (
						   ( :d01_start_dt_tm < CONCAT(start_date,' ',start_time)  AND CONCAT(start_date,' ',start_time) < :d01_end_dt_tm )
						OR ( :d01_start_dt_tm < CONCAT(end_date,' ',end_time)  AND CONCAT(end_date,' ',end_time) < :d01_end_dt_tm )
						OR ( CONCAT(start_date,' ',start_time) < :d01_start_dt_tm AND  :d01_start_dt_tm < CONCAT(end_date,' ',end_time) )
						OR ( CONCAT(start_date,' ',start_time) < :d01_end_dt_tm AND :d01_end_dt_tm < CONCAT(end_date,' ',end_time) )
						OR ( CONCAT(start_date,' ',start_time) = :d01_start_dt_tm OR :d01_end_dt_tm = CONCAT(end_date,' ',end_time) )
					)

            ";
			
		$concat_start_dt_tm = $d01_start_date.' '.$d01_start_time;
		$concat_end_dt_tm = $d01_end_date.' '.$d01_end_time;

		$values = array(
			'nr01'    => $data['nr01'], 
			'p02'     => $data['p02'], 
			'p03_00'  => $data['p03'], 
			'p03_01'  => peg_addDate($data['p03'], 'Y-m-d', -1), 
			'p03_02'  => peg_addDate($data['p03'], 'Y-m-d', +1),
			'd01_start_dt_tm' => $concat_start_dt_tm,
			'd01_end_dt_tm' => $concat_end_dt_tm,

		);

		$txt    = '';
		$res00  = pegasus_query($peg_str, $values);
	    //peg_write_file('../../tmp/crm002_query.txt' , pegasus_replace_values_in_sql($peg_str, $values)); 

		while ($tbl = pegasus_fetch_assoc($res00)) {
			$txt .= "<br>" . $_SESSION['peg_dic_crm002_id'] . ":" . $tbl['nr01']  . " " . $tbl['p19']  . " " . peg_dateToStr($tbl['start_date']) . " " . $tbl['start_time'] . " - " . peg_dateToStr($tbl['end_date']) . " " . $tbl['end_time'] . " " . $tbl['d00_p19'] . " ";
		}

		if ($txt != '') {
			array_push($permDeny, array('type' => 'deny', 'message' =>  $_SESSION['peg_dic_crm002_time_overlap'] . $txt));
		}
	}

	if ($checkOnlyPerm == 0) {
		if ($data['upd'] == 0) {
			//Mono sthn kataxvrisi thelw na kanw update thn enimerosi eggrafis
			if (peg_dateIsEmpty($data['p102'], 'Y-m-d')) {
				$data['p102'] = date('Y-m-d');
			}

			if (empty($data['p103'])) {
				$data['p103'] = date('H:i:s');
			}

			if (empty($data['p101'])) {
				$data['p101'] = $_SESSION['username'];
			}
		}
		if($_SESSION['username']==$data['p02']){
			$data['p104'] = 1;
		}else{
			$data['p104'] = 0;
		}
		$d32_seqs = peg_crm002_find_task_sequences($data);
		if ($d32_seqs !== false) {
			$us0_nr01 = pegasus_mysql_printfld('us0', 'nr01', 'p01=?', array($data['p02']));
			foreach ($d32_seqs as $seq) {
				pegasus_mysql_use("SELECT * FROM d32 WHERE nr01=:d32_nr01",$d32,array('d32_nr01'=>$seq['d32_nr01']));
				$total_add_days=$d32['p15']+$seq['d30_p05'];
				pegasus_add_crm_event(
					$us0_nr01,
					$seq['d32_nr01'],
					$data['p01'],
					'',
					'',
					0,
					'd01',
					$data['nr01'],
					$data['p301'],
					$data['p302'],
					0,
					'',
					1,
					$total_add_days,
					$data['p03']
				);
			}
		}
		if (function_exists('notif_insert_notification') && function_exists('notif_d01_before_insert')) {
			if(notif_d01_before_insert($data)['ok']){
				$d04_p02 = pegasus_mysql_printfld('d04','p02','p01=:d04_p01',array('d04_p01'=>$data['p05']));
				$d00_p19 = pegasus_mysql_printfld('d00','p19','nr01=:d00_nr01',array('d00_nr01'=>$data['p01']));
				if(empty($d04_p02)){
					$d04_p02 = 'New task';
				}
				$desc = str_replace(array('##task_type##','##d00##'),array($d04_p02,$d00_p19),$_SESSION['peg_dic_notif_new_task']);
				notif_insert_notification($data['p02'], $desc, 'd01', $data['nr01'],$data['p101'], array('type' => 'new_d01', 'us0p01' => $data['p02']));
			}
		}
		
		if(pegasus_module_exists('phone')){
			if($data['p012'] =='phna01' && $data['p010'] >0){
				if(function_exists('phone_set_as_answered')){
					phone_set_as_answered($data['p010']);
				}
			}
		}

		// κενή παρατήρηση
		if(empty($data['p308']) && pegasus_module_exists('projects')){
			// είναι δεμένη μόνο με έργο
			if($data['p301']>0 && !($data['p302']>0) ){
				$d25_title = pegasus_mysql_printfld('d25', 'p02', 'nr01=:nr01', array('nr01'=>$data['p301']));
				if(!empty($d25_title)){
					$data['p308'] = $_SESSION['peg_dic_crm002_d01_msg_project_2'] .': '.$d25_title;
				}
			}
			// είναι δεμένη με εργασία
			else if($data['p302']>0){
				$d35_title = pegasus_mysql_printfld('d35', 'p02', 'nr01=:nr01', array('nr01'=>$data['p302']));
				if(!empty($d35_title)){
					$data['p308'] = $_SESSION['peg_dic_crm002_d01_msg_project_task_2'] .': '.$d35_title;
				}		
			}		
		}
	}


	//Find differences
	if ($data['p03'] != $old_d01['p03'] and $old_d01['nr01']>0 ) {
		$chans_memo .= 	'<b>' . $_SESSION['peg_dic_crm002_d01_p03'] . ':</b> ' . peg_dateToStr($old_d01['p03']) . ' -> ' . peg_dateToStr($data['p03'])    . '<br>'; 
	}

	if ($data['p01'] != $old_d01['p01'] and $old_d01['nr01']>0 ) {
		$chans_memo .= 	'<b>' . $_SESSION['peg_dic_crm002_d01_p01'] . ':</b> ' . pegasus_mysql_printfld('d00', 'p19', 'nr01=?', array($old_d01['p01']))   . ' -> ' . pegasus_mysql_printfld('d00', 'p19', 'nr01=?', array($data['p01']))    . '<br>'; 
	}

	if ($data['p312'] != $old_d01['p312'] and $old_d01['nr01']>0 ) {
		$chans_memo .= 	'<b>' . $_SESSION['peg_dic_crm002_d01_p312'] . ':</b> ' . pegasus_mysql_printfld('d69', 'p01', 'nr01=?', array($old_d01['p312']))  . ' -> ' . pegasus_mysql_printfld('d69', 'p01', 'nr01=?', array($data['p312']))   . '<br>'; 
	}

	if ($data['p05'] != $old_d01['p05'] and $old_d01['nr01']>0 ) {
		$chans_memo .= 	'<b>' . $_SESSION['peg_dic_crm002_d01_p05'] . ':</b> ' . pegasus_mysql_printfld('d04', 'p02', 'p01=?', array($old_d01['p05']))    . ' -> ' . pegasus_mysql_printfld('d04', 'p02', 'p01=?', array($data['p05']))     . '<br>'; 
	}

	if ($data['p07'] != $old_d01['p07'] and $old_d01['nr01']>0 ) {
		$chans_memo .= 	'<b>' . $_SESSION['peg_dic_crm002_d01_p07'] . ':</b> ' . pegasus_mysql_printfld('d07', 'p02', 'p01=?', array($old_d01['p07']))    . ' -> ' . pegasus_mysql_printfld('d07', 'p02', 'p01=?', array($data['p07']))     . '<br>'; 
	}

	if ($data['p06'] != $old_d01['p06'] and $old_d01['nr01']>0 ) {
		$chans_memo .= 	'<b>' . $_SESSION['peg_dic_crm002_d01_p06'] . ':</b> ' . pegasus_mysql_printfld('d02', 'p02', 'p01=?', array($old_d01['p06']))    . ' -> ' . pegasus_mysql_printfld('d02', 'p02', 'p01=?', array($data['p06']))     . '<br>'; 
	}

	if ($data['p320'] != $old_d01['p320'] and $old_d01['nr01']>0 ) {
		$chans_memo .= 	'<b>' . $_SESSION['peg_dic_crm002_d01_p320'] . ':</b> ' . pegasus_mysql_printfld('d60', 'p02', 'p01=?', array($old_d01['p320']))   . ' -> ' . pegasus_mysql_printfld('d60', 'p02', 'p01=?', array($data['p320']))    . '<br>'; 
	}


	if ($data['p04'] != $old_d01['p04'] and $old_d01['nr01']>0 ) {
		$chans_memo .= 	'<b>' . $_SESSION['peg_dic_crm002_d01_p04'] . ':</b> ' .  $old_d01['p04']    . ' -> ' . $data['p04']     . '<br>'; 
	}
	if ($data['p08'] != $old_d01['p08'] and $old_d01['nr01']>0 ) {
		$chans_memo .= 	'<b>' . $_SESSION['peg_dic_crm002_d01_p08'] . ':</b> ' .  $old_d01['p08']    . ' -> ' . $data['p08']     . '<br>'; 
	}
	if ($data['p041'] != $old_d01['p041'] and $old_d01['nr01']>0 ) {
		$chans_memo .= 	'<b>' . $_SESSION['peg_dic_crm002_d01_p041'] . ':</b> ' .  $old_d01['p041']    . ' -> ' . $data['p041']     . '<br>'; 
	}
	if ($data['p09'] != $old_d01['p09'] and $old_d01['nr01']>0 ) {
		$chans_memo .= 	'<b>' . $_SESSION['peg_dic_crm002_d01_p09'] . ':</b> ' .  $old_d01['p09']    . ' -> ' . $data['p09']     . '<br>'; 
	}

	if(!empty($chans_memo)){
		$data['p30'] .=	'<div class="sign_title ">' . 	date('d/m/Y H:i:s') . ' (' . $_SESSION['username'] . ') ' .	pegasus_mysql_printfld('us0', 'p100', 'p01=?', array($_SESSION['username'])) .'</div>'.
		'<div class="sign_line">' . $chans_memo . '</div>';

	}
	return array($data, $permDeny);
}

function peg_crm002_d01_d_refresh($data)
{

	if (peg_dateIsEmpty($data['p03'])) {
		$data['p03'] = date('Y-m-d');
	}

	$d00nr01 = $data['p01'];
	if ($d00nr01 > 0) {
		pegasus_mysql_use('select * from d00 where nr01=?;', $d00, array($d00nr01));
		if (
			$d00['pl30'] == 1
			&& !empty($d00['p30'])
		) {
			$data['message'] = '<div class="warning_message" style=" max-height:100px;overflow-x: auto; overflow-y: auto;">' . str_replace("\n", "<br>", $d00['p30']) . '</div>';
			$data['message_hidden'] = false;
		} else {
			$data['message'] = '';
			$data['message_hidden'] = true;
		}
	}
	
	// Άμα δεν έχει εγγραφές στον d99104 (Ε: 10000289)
	$d99104_cnt = pegasus_mysql_printfld('d99104','COUNT(nr01)','d01 = :d01',array('d01' => $data['nr01']));
	/* allagi imerominia katastasis  */
	$d02_p01 = $data['p06'];
	if (!empty($d02_p01)) {
		pegasus_mysql_use("select * from d02 where p01=?;", $d02, array($d02_p01));
		//Ακολουθουμε την λογική του τοπικού με την διαφορά το παρακάτω if
		//Αν και η πραγματική εναρξη και η πραγματικη ληξη ειναι κενα και πρέπει να τα συμπληρώσω τότε - αν ειανι ορισμενα - καλό είναι να πάρουν τα προγραμματισμένα. 
		//Μας το ζήτησαν ΠΠΥ/2053516
		if (
			$d02['p500'] == 1 
			&& $d02['p501'] == 1  
			&& empty($data['p041'])  
			&& empty($data['p09'])
		) {	
			$data['p041'] = !empty($data['p04']) ? $data['p04'] : date('H:i');
			$data['p09']  = !empty($data['p08']) ? $data['p08'] : date('H:i');
		}
		else{
			if ($d02['p500'] == 1 && empty($data['p041']) ) {
				$data['p041'] = !empty($data['p04']) && ($data['p03'] != date('Y-m-d') )? $data['p04'] : date('H:i');
			}
			if ($d02['p501'] == 1 && empty($data['p09'])) {
				$data['p09']  = !empty($data['p08']) && ($data['p03'] != date('Y-m-d') ) ? $data['p08'] : date('H:i');
			}	
		}

		if ($d02['p03'] < 3) {
			$data['p09'] = '';
		}
	}

	/* Προγραμματισμένη Διάρκεια */
	$diarkeia = 0;
	$diarkeia_anamonis = 0;

	//Αν η ώρα λήξης ή ώρα έναρξης είναι κενή
	if (empty($data['p04']) or empty($data['p08'])) {
		$data['p081'] = '';
	}
	if (!empty($data['p04']) and !empty($data['p08'])) {
		//Αν η ώρα λήξης είναι μικρότερη από την ώρα έναρξης
		if (str2int($data['p08']) < str2int($data['p04'])) {
			$data['p081'] = peg_addDate($data['p03'], 'Y-m-d', 1);
		}
		if (str2int($data['p08']) >= str2int($data['p04'])) {
			$data['p081'] = $data['p03'];
		}

		$diarkeiaStartDay = $data['p03'];
		$diarkeiaEndDay   = $data['p081'];

		$diarkeiaStartDay_array =   peg_dateToArray($diarkeiaStartDay, 'Y-m-d');
		list($diarkeiaStartDay_array['hour'], $diarkeiaStartDay_array['minute']) = explode(':', $data['p04']);
		$diarkeiaStartDay_time = mktime(
			$diarkeiaStartDay_array['hour'],
			$diarkeiaStartDay_array['minute'],
			0,
			$diarkeiaStartDay_array['month'],
			$diarkeiaStartDay_array['day'],
			$diarkeiaStartDay_array['year']
		);

		$diarkeiaEndDay_array =   peg_dateToArray($diarkeiaEndDay, 'Y-m-d');
		list($diarkeiaEndDay_array['hour'], $diarkeiaEndDay_array['minute']) = explode(':', $data['p08']);
		$diarkeiaEndDay_time = mktime(
			$diarkeiaEndDay_array['hour'],
			$diarkeiaEndDay_array['minute'],
			0,
			$diarkeiaEndDay_array['month'],
			$diarkeiaEndDay_array['day'],
			$diarkeiaEndDay_array['year']
		);
		$diarkeia_diff = $diarkeiaEndDay_time - $diarkeiaStartDay_time;
		$diarkeia = $diarkeia_diff / 3600;
	}
	$data['p3053'] = $diarkeia;


	/* pragmatiki diarkia*/
	$diarkeia = 0;

	if($d99104_cnt != 0) {
		$sql = peg_read_file("../crm002_sql/find_d01_p306_from_d99104.sql");
		$sql = pegasus_get_text_inside_tags('/*d01_p306_from_d99104_start*/','/*d01_p306_from_d99104_end*/',$sql);
		$values = array(
			'd01' => $data['nr01']
		);
		$d99104_sum = array();
		pegasus_mysql_use($sql,$d99104_sum,$values);

		$diarkeia = $d99104_sum['d01_p306'];
	
	}
	elseif (
		empty($data['p09'])
		|| empty($data['p041'])
	) {
		$data['p091'] = '';
	}
	elseif (
		!empty($data['p041']) 
		&& !empty($data['p09'])
	) {
		//echo "str2int(data['p09'])=".str2int($data['p09'])."   str2int(data['p041'])=".str2int($data['p041']);
		if (str2int($data['p09']) < str2int($data['p041'])) {
			$data['p091'] = peg_addDate($data['p03'], 'Y-m-d', 1);
		}
		//echo "P03=".$data['p03'];
		if (str2int($data['p09']) >= str2int($data['p041'])) {
			$data['p091'] = $data['p03'];
		}

		$diarkeiaStartDay = $data['p03'];
		$diarkeiaEndDay   = $data['p091'];

		$diarkeiaStartDay_array =   peg_dateToArray($diarkeiaStartDay, 'Y-m-d');
		list($diarkeiaStartDay_array['hour'], $diarkeiaStartDay_array['minute']) = explode(':', $data['p041']);
		$diarkeiaStartDay_time = mktime(
			$diarkeiaStartDay_array['hour'],
			$diarkeiaStartDay_array['minute'],
			0,
			$diarkeiaStartDay_array['month'],
			$diarkeiaStartDay_array['day'],
			$diarkeiaStartDay_array['year']
		);

		$diarkeiaEndDay_array =   peg_dateToArray($diarkeiaEndDay, 'Y-m-d');
		list($diarkeiaEndDay_array['hour'], $diarkeiaEndDay_array['minute']) = explode(':', $data['p09']);
		$diarkeiaEndDay_time = mktime(
			$diarkeiaEndDay_array['hour'],
			$diarkeiaEndDay_array['minute'],
			0,
			$diarkeiaEndDay_array['month'],
			$diarkeiaEndDay_array['day'],
			$diarkeiaEndDay_array['year']
		);

		$diarkeia_diff = $diarkeiaEndDay_time - $diarkeiaStartDay_time;
		$diarkeia = $diarkeia_diff / 3600;

		/*
    		$enarxi = explode( ':' , $data['p041']);
    		$lixi   = explode( ':' , $data['p09']);
    		$diarkeia = (($lixi[0]*60) -  ($enarxi[0]*60)) + (($lixi[1]) -  ($enarxi[1]));
    		$diarkeia = $diarkeia/60;
    		*/
	}
	$data['p306'] = $diarkeia;

	$diarkeia_anamonis = 0;
	if (
		!empty($data['p041']) 
		&& !empty($data['p103'])
	) {
		$enarxi = explode(':', $data['p103']);
		$lixi   = explode(':', $data['p041']);
		$diarkeia_anamonis = (($lixi[0] * 60) -  ($enarxi[0] * 60)) + (($lixi[1]) -  ($enarxi[1]));
		$diarkeia_anamonis = $diarkeia_anamonis / 60;
	}

	$data['p314'] = $diarkeia_anamonis;

	if (function_exists('sme_peg_crm002_d01_d_refresh')) {
		$data = sme_peg_crm002_d01_d_refresh($data);
	}
	return $data;
}

function peg_crm002_d02_d_onsave($data, $permDeny, $mmnr01, $checkOnlyPerm)
{

	// 	die(print_r($data));
	if (empty($data['p01'])) {
		array_push($permDeny, array('type' => 'deny', 'message' =>   $_SESSION['peg_dic_crm002_d02_p01empty']));
	}
	$peg_tmp_d02_nr01 = pegasus_mysql_printfld('d02', 'nr01', 'p01=?', array($data['p01']));
	if (!empty($peg_tmp_d02_nr01) and $peg_tmp_d02_nr01 != $data['nr01']) {
		array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_crm002_d02_p01exists']));
	}

	return array($data, $permDeny);
}

function peg_crm002_d04_d_onsave($data, $permDeny, $mmnr01, $checkOnlyPerm)
{

	// 	die(print_r($data));
	if (empty($data['p01'])) {
		array_push($permDeny, array('type' => 'deny', 'message' =>   $_SESSION['peg_dic_crm002_d04_p01empty']));
	}
	$peg_tmp_d04_nr01 = pegasus_mysql_printfld('d04', 'nr01', 'p01=?', array($data['p01']));
	if (!empty($peg_tmp_d04_nr01) and $peg_tmp_d04_nr01 != $data['nr01']) {
		array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_crm002_d04_p01exists']));
	}

	return array($data, $permDeny);
}

function peg_crm002_crm002_d01_grid_d_initialize($data, $mmnr01 = '', $mnr01 = '', $_d = '', $container_id = '')
{	
	/* Εαν ανοίγουμε από Ληξιαριο συμβασεων (Button) */
	if(isset($_REQUEST['cona11_nr01']) && $_REQUEST['cona11_nr01']>0){
		
		$data['cona11_nr01'] = $_REQUEST['cona11_nr01'];
		
		$peg_where = 'd01.p303= :cona11_nr01';

		pegasusSetGlobalVar($container_id . '_where', array(
			'sql'       =>   $peg_where,
			'sqlParams' =>  array(  'cona11_nr01' => $_REQUEST['cona11_nr01'])
		));
	
	// Εαν την ανοιγουμε μέσα απο την cona11_d
	}else if (substr($mmnr01, 0, 8) == 'cona11_d'){
		
		$peg_where = 'd01.p303= :cona11_nr01';

		pegasusSetGlobalVar($container_id . '_where', array(
			'sql'       =>   $peg_where,
			'sqlParams' =>  array(  'cona11_nr01' => $_REQUEST['cona11_nr01'])
		));
	}else{
		$peg_where = 'd01.p012= :peg_table and d01.p010= :peg_nr01';
		pegasusSetGlobalVar(
			$container_id . '_where',array(
				'sql'       =>   $peg_where,
				'sqlParams' =>  array(  'peg_table' => $_REQUEST['peg_table'],
										'peg_nr01' =>$_REQUEST['peg_nr01'])		
		));

	}

	

	return $data;
}

function crm002_crm002_schdl_d00_initialize($data, $mmnr01='', $mnr01=0, $_d='', $container_id=''){
	
	$d01_data = array();
	pegasusSetGlobalVar($container_id . '_query_d02_d', peg_crm002_d02_d_query($d01_data));
	
	return $data;
}

function crm002_crm002_schdl_d01_initialize($data, $mmnr01='', $mnr01=0, $_d='', $container_id=''){
	
	$d01_data = array();
	pegasusSetGlobalVar($container_id . '_query_d02_d', peg_crm002_d02_d_query($d01_data));
	
	return $data;
}
function peg_crm002_crm002_d_execute_after_save(){
	pegasusWriteSession('crm002');
	pegasusReadSession('crm002');
	peg002_clean_dCache('_plano00_crm005_d');
}
/**
 * @param  array  $data
 * @param  string $mmnr01
 * @param  string $mnr01
 * @param  string $_d
 * @param  string $container_id
 * @return array
 */
function crm002_d99104_d_initialize(
	$data = array(),
	$mmnr01 = '',
	$mnr01 = '',
	$_d = '',
	$container_id = ''
) {
	global $PegInput;
	$PegInput->addVar(new peg_input_number('rec_copy_nr01'));
	$rec_copy_nr01 = $PegInput->getRequest('rec_copy_nr01');
	if(empty($rec_copy_nr01)) {
		$rec_copy_nr01 = 0;
	}
	$new_rec = false;
	if(
		!($data['nr01'] > 0)
		|| !(pegasus_mysql_printfld('d99104','nr01','nr01 = :nr01',array('nr01' => $data['nr01'])) > 0)
	) {
		$data['nr01'] = pegasus_mysql_newrec('d99104');
		$new_rec = true;
	}
	if(empty($data['p01'])) {
		$data['p01'] = '0100-01-01';
	}
	if(empty($data['p02'])) {
		$data['p02'] = '0100-01-01';
	}
	if(
		$new_rec
		&& $rec_copy_nr01 == 0
	) {
		$mmnr01_arr = explode('-',$mmnr01);
		if(
			count($mmnr01_arr) == 2
			&& $mmnr01_arr[0] == 'd01_d'
		) {
			$data['d01'] = $mmnr01_arr[1];
		}
		$data['p01'] = date('Y-m-d');
		$data['p011'] = date('H:i:s');
	}
	return $data;
}
/**
 * @param  array  $data
 * @param  string $mmnr01
 * @param  string $mnr01
 * @param  string $_d
 * @param  string $container_id
 * @return array
 */
function crm002_d99104_d01_initialize(
	$data = array(),
	$mmnr01 = '',
	$mnr01 = '',
	$_d = '',
	$container_id = ''
) {
	pegasusSetGlobalVar(
		$container_id . '_grid_where',
		array(
			'sql'		=> 'd01 = :d01',
			'sqlParams'	=> array('d01' => $data['nr01'])
		)
	);
	return $data;
}
/**
 *
 * @param  array   $data
 * @param  array   $permDeny
 * @param  string  $mmnr01
 * @param  boolean $checkOnlyPerm
 * @return array
 */
function crm002_d99104_d_onsave(
	$data = array(), 
	$permDeny = array(), 
	$mmnr01 = '', 
	$checkOnlyPerm = false
) {
	if(
		empty($data['d01'])
		|| !(pegasus_mysql_printfld('d01','nr01','nr01 = :nr01',array('nr01' => $data['d01'])) > 0)
	) {
		array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_crm002_d99104_d_no_d01_set']));
	}
	if(empty($data['p01'])) {
		$data['p01'] = date('Y-m-d');
	}
	if(empty($data['p011'])) {
		$data['p011'] = date('H:i:s');
	}
	if(
		$data['p02'] > '0100-01-01'
		&& !empty($data['p021'])
	) {
		$date_time_start = strtotime("{$data['p01']} {$data['p011']}");
		$date_time_end = strtotime("{$data['p02']} {$data['p021']}");
		if($date_time_start >= $date_time_end) {
			array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_crm002_d99104_d_date_diff_error']));
		}
	}
	return array(
		'data'		=> $data,
		'permDeny'	=> $permDeny
	);
}
/**
 *
 * @return array
 */
function crm002_d99104_vp03_browse_jn_field () {
	$sql = peg_read_file("../crm002_sql/find_d01_p306_from_d99104.sql");
	$sql = pegasus_get_text_inside_tags('/*d99104_vp03_browse_jn_field_start*/','/*d99104_vp03_browse_jn_field_end*/',$sql);
	return $sql;
}
/**
 *
 * @param  integer $d01_nr01
 * @return string
 */
function crm002_d01_d50_build_d01_alert_html(
	$d01_nr01 = 0
) {
	$resp = crm002_d01_d50_build_d01_alert($d01_nr01);
	if($resp['ok'] != 1) {
		return '';
	}
	return $resp['data']['html'];
}
/**
 *
 * @param  integer $d01_nr01
 * @return array
 */
function crm002_d01_d50_build_d01_alert(
	$d01_nr01 = 0
) {
	$d99104 = new d99104($d01_nr01);
	return $d99104->get_status();
}
/**
 *
 * @param  string  $container_id
 * @param  integer $d01_nr01
 * @return array
 */
function crm002_d01_d50_get_alert(
	$container_id = '',
	$d01_nr01 = 0
) {
	$d99104 = new d99104($d01_nr01);
	return $d99104->get_status($container_id);
}
/**
 *
 * @param  string  $container_id
 * @param  integer $d01_nr01
 * @param  string  $status
 * @return array
 */
function crm002_d01_d50_set_change_status(
	$container_id = '',
	$d01_nr01 = 0,
	$status = 'play'
) {
	$mode = '';
	switch($status) {
		case 'play' :
			$mode = 'play';
			break;
		case 'pause' :
			$mode = 'pause';
			break;
		case 'stop' : 
			$mode = 'stop';
			break; 
		case 'update' : 
			$mode = 'update';
			break; 
		default : 
			return array(
				'ok'	=> 0,
				'msg'	=> "Uknown status ($status)"
			);
	}
	$d99104 = new d99104();
	$resp = $d99104->set_d01(
		$d01_nr01
	);
	if($resp['ok'] != 1) {
		return array(
			'ok'	=> 1,
			'msg'	=> $resp['msg']
		);
	}
	$resp = array();
	$d01 =$d99104->get_d01_data();
	if($mode == 'pause') {
		$resp = $d99104->pause($d01,false,$container_id);
	}
	if($mode == 'stop') {
		$resp = $d99104->stop($d01,false,$container_id);
	}
	if($mode == 'play') {
		$resp = $d99104->play($d01,false,$container_id);
	}
	if($mode == 'update') {
		$resp = $d99104->get_status($container_id);
	}
	if($resp['ok'] != 1) {
		return array(
			'ok' 	=> 1,
			'error'	=> array(
				'type'		=> 'alert',
				'message'	=> $resp['msg']
			),
			'msg'	=> $resp['msg']
		);
	}
	if($mode == 'update')  {
		return $resp;
	}
	if(pegasus_mysql_printfld('d01','p06','nr01 = :nr01', array('nr01' => $d01_nr01)) != $resp['data']['d02_p01']) {

		$screen_resp = crm002_d01_screen_update($d01_nr01,$resp['data']['d02_p01']);
		if($screen_resp['ok'] != 1) {
			return array(
				'ok' 	=> 1,
				'error'	=> array(
					'type'		=> 'alert',
					'message'	=> $screen_resp['msg']
				),
				'msg'	=> $screen_resp['msg']
			);
		}
	}
	return $resp;
}
/**
 *
 * @param  integer $nr01
 * @param  integer|null  $p06
 * @param  string|null  $p02
 * @param  string|null  $p03
 * @return array
 */
function crm002_d01_screen_update(
	$nr01 = 0,
	$p06 = null,	// Κατάσταση
	$p02 = null,	// Χρήστης
	$p03 = null		// Ημερομηνία
) {
	$screen = new screen();
	$screen->container_id	= pegasus_container_id_create(0, session_id(), 'd01_d');
	$screen->module			= 'crm002';
	$screen->_d				= 'd01_d';
	$screen->table			= 'd01';
	$screen->nr01			= $nr01;

	$screen->read_data_from_db();
	$screen->read_params_from_db();

	$screen->data['nr01'] = $nr01;
	if(isset($p06)) {
		$screen->data['p06'] = $p06;
	}
	if(isset($p02)) {
		$screen->data['p02'] = $p02;
	}
	if(isset($p03)) {
		$screen->data['p03'] = $p03;
	}

	// $screen->data = peg_crm002_d01_d_refresh($screen->data);

	$request_tmp = $_REQUEST ;
	$_REQUEST = $screen->data;
	$_REQUEST['no_confirm'] = 1;
	$ret = $screen->save_data();
	$_REQUEST = $request_tmp;
	peg_close_d($screen->container_id);
	if ($ret[0] == false) {
		return array(
			'ok'	=> 0,
			'msg'	=> $ret[1]
		);
	}
	return array(
		'ok'	=> 1,
		'msg'	=> 'Success'
	);
}
/**
 *
 * @return array
 */
function crm002_main_d_toolbaritem(){
	return array(
		array(
			'xtype' => 'pegasusToolBarTimerButton',
			'name' => 'core_main_d_crm002_toolbaritem',
			'peg_module' => 'core',
			'peg__d' => '_main_d',                
			'minWidth' => 30,
			'clickHandlerName' => 'core_main_d_crm002_toolbaritem'
		),
		array(
			'xtype' 	=> 'pegasusToolBartbseparator',
			'id'		=> 'core_main_d_crm002_toolbaritem_separator',
			'hidden'	=> true
		)
	);
}
/**
 *
 * @return array
 */
function toolbarbutton_crm002_main_d_toolbaritem() {
	if(empty($_SESSION['crm002_d01_d02_play'])) {
		return array(
			'ok'	=> 1,
			'msg'	=> $_SESSION['peg_dic_crm002_d99104_initialize_d02_p01_play_not_set']
		);
	}
	$sql = "	SELECT
					CONCAT(d99104.p01,' ',d99104.p011)	AS time_started
				FROM d01
				LEFT JOIN d99104 ON d01.nr01 = d99104.d01
				WHERE 1 = 1
				AND d01.p02 = :p02
				AND d01.p06 = :p06
				AND IFNULL(d99104.p01,'') > '0100-01-01'
				AND IFNULL(d99104.p011,'') != ''
				AND IFNULL(d99104.p02,'') <= '0100-01-01'
				AND IFNULL(d99104.p021,'') = ''
				LIMIT 1
	";
	$values = array(
		'p02'	=> $_SESSION['username'],
		'p06'	=> $_SESSION['crm002_d01_d02_play']
	);
	$res = pegasus_query($sql,$values);
	if(pegasus_num_rows($res) == 0) {
		return array(
			'ok'	=> 1,
			'data'	=> array(
				'has_started'	=> 0
			),
			'msg'	=> 'No need to start'
		);
	}
	$d99104 = pegasus_fetch_assoc($res);
	return array(
		'ok'	=> 1,
		'data'	=> array(
			'has_started'	=> 1,
			'time'			=> $d99104['time_started']
		),
		'msg'	=> 'Start Timer'
	);
}
/**
 *
 * @param  array  $data
 * @param  string $mmnr01
 * @param  string $mnr01
 * @param  string $_d
 * @param  string $container_id
 * @return array
 */
function crm002_d01_d60_initialize(
	$data = array(), 
	$mmnr01 = '', 
	$mnr01 = '', 
	$_d = '', 
	$container_id = ''
) {
	$data['not_rsdt'] = 1;
	$data['stdt'] = date('Y-m-d');
	$data['endt'] = date('Y-m-d');
	$data['sttm'] = date('H:i');
	$data['entm'] = date('H:i');
	$data['us0'] = $_SESSION['username'];
	
	pegasus_mysql_delete(
		"peg_tmp_d01",
		"
			peg_mnr01 = :peg_mnr01
			AND peg_mmnr01 = :peg_mmnr01
			AND peg_sess_id = :peg_sess_id

		",
		0,
		array(
			'peg_mnr01'		=> 0,
			'peg_mmnr01'	=> 'd01_d60-0',
			'peg_sess_id'	=> session_id()
		)
	);
	pegasusSetGlobalVar(
		$container_id.'_d01_d60_grid_query',
		array(
			"sql" => "	SELECT peg_tmp_d01.*
						FROM peg_tmp_d01
						WHERE 1 = 1 
						AND peg_mnr01 = :peg_mnr01
						AND peg_mmnr01 = :peg_mmnr01
						AND peg_sess_id = :peg_sess_id
						AND peg_flag != :peg_flag
						GROUP BY peg_tmp_d01.nr01
			",
			"sqlParams" => array(
				'peg_mnr01'		=> 0,
				'peg_mmnr01'	=> 'd01_d60-0',
				'peg_sess_id'	=> session_id(),
				'peg_flag'		=> 9
			)
		)
	);
	return $data;
}
/**
 *
 * @param  integer $d32_nr01
 * @return array
 */
function crm002_d01_d60_get_data_from_d32(
	$d32_nr01 = 0
) {
	$d32 = array();
	$sql = "	SELECT
					d32.p01				AS d04,
					d32.p02				AS d07,
					d32.p03				AS d02,
					d32.d60				AS d60,
					IFNULL(d04.p02,'')	AS v_selectbox_d04,
					IFNULL(d07.p02,'')	AS v_selectbox_d07,
					IFNULL(d02.p02,'')	AS v_selectbox_d02,
					IFNULL(d60.p02,'')	AS v_selectbox_d60
				FROM d32
				LEFT JOIN d04 ON d04.p01 = d32.p01
				LEFT JOIN d07 ON d07.p01 = d32.p02
				LEFT JOIN d02 ON d02.p01 = d32.p03
				LEFT JOIN d60 ON d60.p01 = d32.d60
				WHERE d32.nr01 = :nr01
	";
	pegasus_mysql_use($sql, $d32, array('nr01' => $d32_nr01));
	if(empty($d32)) {
		return array(
			'ok'	=> 0,
			'msg'	=> "d32 ($d32_nr01) not exists"
		);
	}
	return array(
		'ok'	=> 1,
		'data'	=> array(
			'd04'	=> $d32['d04'],
			'd07'	=> $d32['d07'],
			'd02'	=> $d32['d02'],
			'd60'	=> $d32['d60'],
			'v_selectbox_d04'	=> $d32['v_selectbox_d04'],
			'v_selectbox_d07'	=> $d32['v_selectbox_d07'],
			'v_selectbox_d02'	=> $d32['v_selectbox_d02'],
			'v_selectbox_d60'	=> $d32['v_selectbox_d60'],
		),
		'msg'	=> 'Success'
	);
}
/**
 *
 * @param  array $args
 * @return array
 */
function crm002_d01_d60_create_tmp_d01(
	$args = array()
) {
	$errors = array();
	if($args['stdt'] <= '0100-01-01') {
		$errors[] = $_SESSION['peg_dic_crm002_d01_d60_set_date_from'];
	}
	if($args['endt'] <= '0100-01-01') {
		$errors[] = $_SESSION['peg_dic_crm002_d01_d60_set_date_to'];
	}
	if($args['endt'] < $args['stdt']) {
		$errors[] = $_SESSION['peg_dic_crm002_d01_d60_set_date_range'];
	}
	if(!empty($errors)) {
		return array(
			'ok'	=> 0,
			'msg'	=> implode("<br>\n",$errors)
		);
	}
	pegasus_mysql_delete(
		"peg_tmp_d01",
		"
			peg_mnr01 = :peg_mnr01
			AND peg_mmnr01 = :peg_mmnr01
			AND peg_sess_id = :peg_sess_id

		",
		0,
		array(
			'peg_mnr01'		=> 0,
			'peg_mmnr01'	=> 'd01_d60-0',
			'peg_sess_id'	=> session_id()
		)
	);
	$sql = peg_read_file('../crm002_sql/crm002_d01_d60_create_tmp_d01_dates.sql');
	$values = array(
		'stdt'		=> $args['stdt'],
		'endt'		=> $args['endt'],
		'not_rsdt'	=> $args['not_rsdt'],
		'monday'	=> $args['monday'],
		'tuesday'	=> $args['tuesday'],
		'wednesday'	=> $args['wednesday'],
		'thursday'	=> $args['thursday'],
		'friday'	=> $args['friday'],
		'saturday'	=> $args['saturday'],
		'sunday'	=> $args['sunday'],

		'p01'	=> $args['d00'],	// Συναλλασσόμενος
		'p02'	=> $args['us0'],	// Χρήστης
		'p05'	=> $args['d04'],	// Είδος Δραστηριότητας
		'p07'	=> $args['d07'],	// Σκοπός
		'p06'	=> $args['d02'],	// Κατάσταση
		'p320'	=> $args['d60'],	// Προτεραιότητα
		'p401'	=> $args['d32'],	// Πρότυπη Δραστηριότητα
		'p04'	=> $args['sttm'],	// Προγραμματισμένη Ώρα Εναρξης
		'p08'	=> $args['entm'],	// Προγραμματισμένη Ώρα Λήξης
		'p30'	=> $args['p30'],	// Σημειώσεις

		'peg_flag'		=> 1,
		'peg_mnr01'		=> 0,
		'peg_mmnr01'	=> 'd01_d60-0',
		'peg_sess_id'	=> session_id(),
	);
	$res = pegasus_query($sql,$values);
	while($rs = pegasus_fetch_assoc($res)) {
		$data= array(
			'nr01'	=> $rs['nr01'],	// M.K.
			'p03'	=> $rs['p03'],	// Ημερομηνία
			'p01'	=> $rs['p01'],	// Συναλλασσόμενος
			'p02'	=> $rs['p02'],	// Χρήστης
			'p05'	=> $rs['p05'],	// Είδος Δραστηριότητας
			'p07'	=> $rs['p07'],	// Σκοπός
			'p06'	=> $rs['p06'],	// Κατάσταση
			'p320'	=> $rs['p320'],	// Προτεραιότητα
			'p401'	=> $rs['p401'],	// Πρότυπη Δραστηριότητα
			'p04'	=> $rs['p04'],	// Προγραμματισμένη Ώρα Εναρξης
			'p08'	=> $rs['p08'],	// Προγραμματισμένη Ώρα Λήξης
			'p30'	=> $rs['p30'],	// Σημειώσεις
		);
		if(
			$args['not_rsdt'] == 1
			&& $rs['p104'] == 1
		) {
			$data['p308'] = '<span style="color:red">'.$_SESSION['peg_dic_crm002_d01_d60_create_tmp_d01_d43'].'<span>';
		} else {
		
			$resp =crm002_d01_d60_d01_save_from_tmp(
				$data,
				1
			);
			if($resp['ok']	!= 1) {
				$data['p308'] = '<span style="color:red">'.$resp['msg'].'<span>';
			} else {
				$data['nr01'] = $resp['data']['nr01'];
			}
		}
		$data['peg_flag'] = 1;
		$data['peg_mnr01'] = 0;
		$data['peg_mmnr01'] = 'd01_d60-0';
		$data['peg_sess_id'] = session_id();
		pegasus_mysql_insert(
			'peg_tmp_d01',
			array_keys($data),
			array_values($data),
			1,
		);
	}
	return array(
		'ok'	=> 1,
		'msg'	=> 'Success'
	);
}
/**
 *
 * @return array
 */
function crm002_d01_d60_get_tmp_d01() {
	$sql = "	SELECT *
				FROM peg_tmp_d01
				WHERE 1 = 1
				AND peg_flag != 9
				AND peg_mnr01 = 0
				AND peg_mmnr01 = 'd01_d60-0'
				AND peg_sess_id = :peg_sess_id
				AND nr01 > 0
	";
	$values = array(
		'peg_sess_id'	=> session_id(),

	);
	$res = pegasus_query($sql,$values);
	$rows = array();
	while($rs = pegasus_fetch_assoc($res)) {
		$rows[] = array(
			'nr01'	=> $rs['nr01'],	// M.K.
			'p03'	=> $rs['p03'],	// Ημερομηνία
			'p01'	=> $rs['p01'],	// Συναλλασσόμενος
			'p02'	=> $rs['p02'],	// Χρήστης
			'p05'	=> $rs['p05'],	// Είδος Δραστηριότητας
			'p07'	=> $rs['p07'],	// Σκοπός
			'p06'	=> $rs['p06'],	// Κατάσταση
			'p320'	=> $rs['p320'],	// Προτεραιότητα
			'p401'	=> $rs['p401'],	// Πρότυπη Δραστηριότητα
			'p04'	=> $rs['p04'],	// Προγραμματισμένη Ώρα Εναρξης
			'p08'	=> $rs['p08'],	// Προγραμματισμένη Ώρα Λήξης
			'p30'	=> $rs['p30'],	// Σημειώσεις
		);
	}
	return array(
		'ok'	=> 1,
		'data'	=> array(
			'mask'	=> array($_SESSION['peg_dic_crm002_d01_d60_mask_title']),
			'rows'	=> $rows
		),
		'msg'	=> 'Success'
	);
}
/**
 *
 * @param  array   $data
 * @param  integer $checkOnlyPerm
 * @return array
 */
function crm002_d01_d60_d01_save_from_tmp(
	$data = array(),
	$checkOnlyPerm = 0
) {
	$clear_tmp_table = false;
	if(isset($data['clear_tmp_table'])) {
		$clear_tmp_table = true;
		unset($data['clear_tmp_table']);
	}
	$screen = new screen();
	$screen->container_id = pegasus_container_id_create(0, session_id(), 'd01_d');
	$screen->module       = 'crm002';
	$screen->_d           = 'd01_d';
	$screen->table        = 'd01';
	$screen->read_data_from_db();
	$screen->read_params_from_db();
	$screen->data['nr01'] = $data['nr01'];
	$screen->data['p03'] = $data['p03'];
	$screen->data['p01'] = $data['p01'];
	$screen->data['p02'] = $data['p02'];
	$screen->data['p05'] = $data['p05'];
	$screen->data['p07'] = $data['p07'];
	$screen->data['p06'] = $data['p06'];
	$screen->data['p320'] = $data['p320'];
	$screen->data['p401'] = $data['p401'];
	$screen->data['p04'] = $data['p04'];
	$screen->data['p08'] = $data['p08'];
	$screen->data['p30'] = $data['p30'];
	$_REQUEST = $screen->data;
	$_REQUEST['no_confirm'] = 1;
	$ret = $screen->save_data($checkOnlyPerm);
	$nr01 = $screen->nr01;
	peg_close_d($screen->container_id);
	if($clear_tmp_table) {
		pegasus_mysql_delete(
			'peg_tmp_d01',
			"
				AND peg_mnr01 = 0
				AND peg_mmnr01 = 'd01_d60-0'
				AND peg_sess_id = :peg_sess_id
			",
			0,
			array(
				'peg_sess_id'	=> session_id()
			)
		);
	}
	if($checkOnlyPerm) {
		if ($ret[0] == false) {
			return array(
				'ok'	=> 0,
				'msg'	=> $ret[1]
			);
		}
		return array(
			'ok'	=> 1,
			'data'	=> array(
				'nr01'	=> $nr01
			),
			'msg'	=> '<span style="color:green">'.$_SESSION['peg_dic_crm002_d01_d60_create_tmp_d01_success'].'<span>'
		);
	}
	if($ret[0] == false) {
		return array(
			'ok'	=> 0,
			'msg'	=> str_replace(
				array(
					'##date##'
				),
				array(
					peg_dateToStr($data['p03'],'d/m/Y')
				),
				$_SESSION['peg_dic_crm002_d01_d60_mask_error']
			)
		);
	}
	return array(
		'ok'	=> 1,
		'data'	=> array(
			'nr01'	=> $nr01
		),
		'msg'	=> str_replace(
			array(
				'##date##',
				'##nr01##'
			),
			array(
				peg_dateToStr($data['p03'],'d/m/Y'),
				$nr01
			),
			$_SESSION['peg_dic_crm002_d01_d60_mask_success']
		)
	);
}
/**
 *
 * @param  string  $dt
 * @param  string  $us0
 * @param  integer $d02
 * @param  array   $nr01s
 * @return array
 */
function crm002_d01_d61_d01_mass_change(
	$dt = '0100-01-01',
	$us0 = '',
	$d02 = 0,
	$nr01s = array()
) {
	if(count($nr01s) == 0) {
		return array(
			'ok'	=> 0,
			'msg'	=> $_SESSION['peg_dic_crm002_d01_d61_d01_no_d01_set']
		);
	}
	if(
		$dt <= '0100-01-01'
		&& $us0 == ''
		&& $d02 == 0
	) {
		return array(
			'ok'	=> 0,
			'msg'	=> $_SESSION['peg_dic_crm002_d01_d61_d01_no_change_set']
		);
	}
	$error = array();
	foreach($nr01s as $v) {
		$nr01 = pegasus_mysql_printfld('d01','nr01','nr01 = :nr01',array('nr01' => $v));
		if(!($nr01 > 0)) {
			$error[] = $_SESSION['peg_dic_crm002_d01_d61_d01_nr01_not_exists'].": ".$v;
			continue;
		}
		$resp = crm002_d01_screen_update(
			$nr01,
			$d02 > 0 ? $d02 : null,
			$us0 != '' ? $us0 : null,
			$dt > '0100-01-01' ? $dt : null
		);
		if($resp['ok'] != 1) {
			$error[] = "[<b style=\"color:red\">ERROR</b>][$nr01]: {$resp['msg']}";
		}
	}
	return array(
		'ok'	=> 1,
		'data'	=> array(
			'error'	=> $error
		),
		'msg'	=> 'Success'
	);
}
/**
 *
 * @return array
 */
function crm002_after_update(){
	$query = ' SELECT p97.* 

	from p97
		left join p97p96 on p97.nr01= p97p96.p97 and p97p96.p96="crm002.d01.us0" 
		left join p96 on p96.cd= p97p96.p96 and p96.cd="crm002.d01.us0" 
		
	where p96.nr01 is null and p97.nr01 is not null
	group by p97.nr01;';

	$res = pegasus_query($query);
	while($p97 = pegasus_fetch($res)){
		$arr1 = array('nr01');  $arr2 = array(pegasus_mysql_newrec('p97p96'));
		array_push($arr1 , 'en');  array_push($arr2 , '1');
		array_push($arr1 , 'p96'); array_push($arr2 , 'crm002.d01.us0');
		array_push($arr1 , 'p97'); array_push($arr2 , $p97['nr01']);
		pegasus_mysql_insert('p97p96' , $arr1 , $arr2 );
	}

	$tables =  [
		'd01',
	];
	foreach ($tables as &$value) {
		if (!pegasus_mysql_table_exists('peg_tmp_' . $value)) {
			pegasus_change_stracture($value, $value . '_d', 'crm002', 1, 1);
		}
	}
}

