WITH RECURSIVE d01_d60_tmp_maker (
	nr01,
	p03,
	p01,
	p02,
	p05,
	p07,
	p06,
	p320,
	p401,
	p04,
	p08,
	p30,
	peg_flag,
	peg_mnr01,
	peg_mmnr01,
	peg_sess_id
) AS (
	SELECT
		-1		AS nr01,
		:stdt	AS p03,
		:p01	AS p01,
		:p02	AS p02,
		:p05	AS p05,
		:p07	AS p07,
		:p06	AS p06,
		:p320	AS p320,
		:p401	AS p401,
		:p04	AS p04,
		:p08	AS p08,
		:p30	AS p30,
		:peg_flag	AS peg_flag,
		:peg_mnr01	AS peg_mnr01,
		:peg_mmnr01	AS peg_mmnr01,
		:peg_sess_id AS peg_sess_id
	UNION ALL
	(
		SELECT 
			nr01 -1,
			p03 + INTERVAL 1 DAY,
			p01,
			p02,
			p05,
			p07,
			p06,
			p320,
			p401,
			p04,
			p08,
			p30,
			peg_flag,
			peg_mnr01,
			peg_mmnr01,
			peg_sess_id
		FROM d01_d60_tmp_maker
		WHERE p03 < :endt
	)
)
SELECT
	d01_d60_tmp_maker.nr01,
	d01_d60_tmp_maker.p03,
	d01_d60_tmp_maker.p01,
	d01_d60_tmp_maker.p02,
	d01_d60_tmp_maker.p05,
	d01_d60_tmp_maker.p07,
	d01_d60_tmp_maker.p06,
	d01_d60_tmp_maker.p320,
	d01_d60_tmp_maker.p401,
	d01_d60_tmp_maker.p04,
	d01_d60_tmp_maker.p08,
	d01_d60_tmp_maker.p30,
	d01_d60_tmp_maker.peg_flag,
	d01_d60_tmp_maker.peg_mnr01,
	d01_d60_tmp_maker.peg_mmnr01,
	d01_d60_tmp_maker.peg_sess_id,
	IF(
		d43.nr01 IS NULL,
		0,
		1
	)			AS p104
FROM d01_d60_tmp_maker
LEFT JOIN d43 ON	d43.p01 = d01_d60_tmp_maker.p03
					OR (
						d43.p05 = 1
						AND MONTH(d43.p01) = MONTH(d01_d60_tmp_maker.p03)
						AND DAY(d43.p01) = DAY(d01_d60_tmp_maker.p03)
					)
WHERE 1 = 1
AND IF(
		:sunday = 0,
		DAYOFWEEK(d01_d60_tmp_maker.p03) != 1,
		1 = 1
)
AND IF(
	:monday = 0,
	DAYOFWEEK(d01_d60_tmp_maker.p03) != 2,
	1 = 1
)
AND IF(
	:tuesday = 0,
	DAYOFWEEK(d01_d60_tmp_maker.p03) != 3,
	1 = 1 
)
AND IF(
	:wednesday = 0,
	DAYOFWEEK(d01_d60_tmp_maker.p03) != 4,
	1 = 1
)
AND IF(
	:thursday = 0,
	DAYOFWEEK(d01_d60_tmp_maker.p03) != 5,
	1 = 1
)
AND IF(
	:friday = 0,
	DAYOFWEEK(d01_d60_tmp_maker.p03) != 6,
	1 = 1
)
AND IF(
	:saturday = 0,
	DAYOFWEEK(d01_d60_tmp_maker.p03) != 7,
	1 = 1
)
GROUP BY d01_d60_tmp_maker.nr01
ORDER BY p03 ASC