<?php
/**
 * @param mixed $_d: Περνάμε το _d οπου θα προβληθεί το combobox ώστε να εμφανίσει το ανάλογο λεκτικό.
 */
function customers_get_a71( $container_id)
{

	$a01_select_where =  pegasusGetGlobalVar('peg_'.pegasus_container_id_get_parentBy_d($container_id,'t01_d100').'_a01_select_where');
	if(empty($a01_select_where)){
		return;
	}
	$p600 = $_SESSION['peg_dic_customers_customers00_kentriko'];
	$query = "";
	$query  = "SELECT * from (";
	$query .= "SELECT  a71.nr01 as nr01,
						a71.p600 as p600,
						a71.p601  as p601,
						a71.p603 as p603,
						a71.p605 as p605,
						concat(a71.p600,' ',a71.p603) as p600_p603,
						a71.p606 as p606,
						a71.p607 as p607,
						a71.remdate as remdate, 
						a71.remtime as remtime, 
						a71.remuser as remuser, 
						a71.remguc  as remguc, 
						a71.remfdate as remfdate, 
						a71.remftime as remftime, 
						a71.remfuser as remfuser
				FROM a71
				WHERE ".$a01_select_where['sql']."
				UNION
			   SELECT
					-1 as nr01,
					'" . $p600 . "' as p600,
					''  as p601,
					'' as p603,
					'' as p605,
					'' as p600_p603,
					'' as p606,
					'' as p607,
					'' as remdate, 
					'' as remtime, 
					'' as remuser, 
					''  as remguc, 
					'' as remfdate, 
					'' as remftime, 
					'' as remfuser

				) as tbl_01";

	return array("sql" => $query, "sqlParams" => $a01_select_where["sqlParams"]);
}

/**
 * Χρησιμοποιείται για να φέρει τα στοιχεία σε οθόνες του backend
 * @param string $afm
 * @param string $type
 * @return array
 */
function customers_getAFM(
	$afm = '',
	$type = ''
) {
	//
	$ret_data = array();
	$ret_data = customers_search_vat_data($afm);
	switch ($type) {
		case "a01":
			$ret_data['confirm_msg'] = $_SESSION['peg_dic_customers_comfa01'];
			break;
		case "a00":
			$ret_data['confirm_msg'] = $_SESSION['peg_dic_customers_comfa00'];
			break;
		case "d00":
			$ret_data['confirm_msg'] = $_SESSION['peg_dic_customers_comfd00'];
			break;
		default:
			$ret_data['confirm_msg'] = '';
	}
	if ($ret_data['respCode'] == 200) {
		foreach ($ret_data['data'] as $key => $value) {
			switch ($key) {
				case 'deactivationFlag':
					$tmp_msg = ($ret_data['data']['deactivationFlag'] == 1) ? '<span style="color:green">' . $_SESSION['peg_dic_customers_yes'] . '</span>' : '<span style="color:red">' . $_SESSION['peg_dic_customers_no'] . '</span>';
					$ret_data['msg'] .= $_SESSION['peg_dic_customers_deactivationFlagDescr'] . ": " . $tmp_msg . " <br/>";
					break;
				case 'onomasia':
					$ret_data['msg'] .= $_SESSION['peg_dic_customers_onomasia'] . ": " . $ret_data['data']['onomasia'] . " <br/>";
					break;
				case 'afm':
					$ret_data['msg'] .= $_SESSION['peg_dic_customers_afm'] . ": $value <br/>";
					break;
				case 'registDate':
					$ret_data['msg'] .= $_SESSION['peg_dic_customers_registDate'] . ": " . peg_dateToStr($value) . " <br/>";
					break;
				case 'stopDate':
					$ret_data['msg'] .= $_SESSION['peg_dic_customers_stopDate'] . ": $value <br/>";
					break;
				case 'doy':
					$ret_data['msg'] .= $_SESSION['peg_dic_customers_doy'] . ": " . $ret_data['data']['doy'] . " <br/>";
					break;
				case 'doyDescr':
					$ret_data['msg'] .= $_SESSION['peg_dic_customers_doyDescr'] . ": " . $ret_data['data']['doyDescr'] . " <br/>";
					break;
				case 'commerTitle':
					$ret_data['msg'] .= $_SESSION['peg_dic_customers_commerTitle'] . ": " . $ret_data['data']['commerTitle'] . " <br/>";
					break;
				case 'parDescription':
					$ret_data['msg'] .= $_SESSION['peg_dic_customers_parDescription'] . ": " . $ret_data['data']['parDescription'] . " <br/>";
					break;
				case 'postalAddressNo':
					$ret_data['msg'] .= $_SESSION['peg_dic_customers_postalAddressNo'] . ": $value <br/>";
					break;
				case 'postalAddress':
					$ret_data['msg'] .= $_SESSION['peg_dic_customers_postalAddress'] . ": " . $ret_data['data']['postalAddress'] . " <br/>";
					break;
				case 'postalZipCode':
					$ret_data['msg'] .= $_SESSION['peg_dic_customers_postalZipCode'] . ": $value <br/>";
					break;
				case 'i_ni_flag_descr':
					$tmp_msg = ($ret_data['data']['i_ni_flag_descr'] == 'ΦΠ') ? '<span style="color:green">' . $_SESSION['peg_dic_customers_yes'] . '</span>' : '<span style="color:red">' . $_SESSION['peg_dic_customers_no'] . '</span>';
					$ret_data['msg'] .= $_SESSION['peg_dic_customers_individual'] . ": $tmp_msg <br/>";
					break;
				case 'firm_flag_descr':
					$ret_data['msg'] .= "$value <br/>";
					break;
				case 'legal_status_descr':
					$ret_data['msg'] .= $_SESSION['peg_dic_customers_legal_form'] . ": $value <br/>";
					break;
				case 'normal_vat_system_flag':
					$tmp_msg = ($ret_data['data']['normal_vat_system_flag'] == 'Y') ? '<span style="color:green">' . $_SESSION['peg_dic_customers_yes'] . '</span>' : '<span style="color:red">' . $_SESSION['peg_dic_customers_no'] . '</span>';
					$ret_data['msg'] .= $_SESSION['peg_dic_customers_normal_vat_status'] . ": $tmp_msg <br/>";
					break;
				case 'firmActCode':
					$ret_data['msg'] .= $_SESSION['peg_dic_customers_firmActCode'] . ": $value <br/>";
					break;
				case 'facActivity':
					$ret_data['msg'] .= $_SESSION['peg_dic_customers_firmActDescr'] . ": " . $ret_data['data']['facActivity'] . " <br/>";
					break;
				case 'actLongDescr':
					$ret_data['msg'] .= $_SESSION['peg_dic_customers_firmActKind'] . ": " . $ret_data['data']['actLongDescr'] . " <br/>";
					break;
				default:
					break;
			}
		}
		if (!is_null($ret_data['data']['firmsacts'])) {
			$ret_data['msg'] .= "<div style='max-height: 200px; overflow-x: auto; padding: 0 10px;'> ";
			$ret_data['msg'] .= $_SESSION['peg_dic_customers_moreFirmAct'] . "<br/>";
			foreach ($ret_data['data']['firmsacts'] as $firmactrt) {
				$temp = (string) $firmactrt->firmActCode;
				$ret_data['msg'] .= $_SESSION['peg_dic_customers_firmActCode'] . ": $temp <br/>";

				$temp = (string) $firmactrt->facActivity;
				$ret_data['msg'] .= $_SESSION['peg_dic_customers_firmActDescr'] . ": " . $temp . " <br/>";

				$temp = (string) $firmactrt->actLongDescr;
				$ret_data['msg'] .= $_SESSION['peg_dic_customers_firmActKind'] . ": " . $temp . " <br/>";
			}
			$ret_data['msg'] .= "</div>";
		}
	}else{
		$ret_data['errDesc'] = str_replace(array("<p>", "</p>"), "", $ret_data['errDesc']);
		switch ($ret_data['respCode']) {
			case 552:
				$ret_data['msg']  = (string) $ret_data['errDesc'];
				$ret_data['msg']  .= "<br/>" . $_SESSION['peg_dic_customers_emptyuser'];
				break;
			default:
				$ret_data['msg'] = (string) $ret_data['errDesc'];
				break;
		}	
	}

	return $ret_data;
}
	/* functions.php */
	function customers_get_d00_data( $nr01 ){		
		
		$peg_tmpquery="SELECT d00.nr01 as pnr01, 
	                   if(d00.p190='', d00.p19, d00.p190)  as p19, 
	                   if(d00.p19=d00.p190 || d00.p190='', '', d00.p19)   as p190, 
	                   d00.p2    as p2, 
	                   d00.p3    as p3, 
	                   d00.p4    as p4, 
	                   d00.p23   as p23, 
	                   d00.p5   as p5, 
	                   IF(d00.p7_1!='', d00.p7_1, d00.p7)     as p7, 
	                   d00.p20  as p20, 
	                   d00.p22  as p22, 
	                   d00.pc22 as pc22, 
	                   d00.p803 as p11, 
	                   d00.p900 as p51, 
	                   
	                   d00.p013 as p4_1,
	                   d00.p014 as p4_2,
	                   d00.p06 as p4_3,	 
	                   d00.p012 as p6,	 	                   
	                    
	                   ifnull(d64_p8.p001, '')  as p8, 
	                   ifnull(d64_p9.p001, '')  as p9, 
	                   ifnull(d64_p10.p001, '') as p10, 
	                   ifnull(d65_p01.p01, '')  as p01
	       
	               FROM d00
	               LEFT JOIN d64 as d64_p8  ON d64_p8.p00=d00.nr01
	                                        && d64_p8.pd100='phone-01'
	               LEFT JOIN d64 as d64_p9  ON d64_p9.p00=d00.nr01
	                                        && d64_p9.pd100='phone-02'
	               LEFT JOIN d64 as d64_p10 ON d64_p10.p00=d00.nr01
	                                        && d64_p10.pd100='fax-01'
	                                       
	               LEFT JOIN d65 as d65_p01 ON d65_p01.p00=d00.nr01
	                                        && d65_p01.pd100='email-01'
	               WHERE d00.nr01=?;";
	
	     pegasus_mysql_use($peg_tmpquery, $peg_qresult, array($nr01));
		  
	     $peg_json_return_array = array();
	     $peg_json_return_array['pnr01']  = $peg_qresult['pnr01'];
	     $peg_json_return_array['p19']   = $peg_qresult['p19'];
	     $peg_json_return_array['p190']  = $peg_qresult['p190'];
	     $peg_json_return_array['p2']    = $peg_qresult['p2'];
	     $peg_json_return_array['p3']    = $peg_qresult['p3'];
	     $peg_json_return_array['p4']    = $peg_qresult['p4'];
	     $peg_json_return_array['p23']   = $peg_qresult['p23'];
	     $peg_json_return_array['p5']    = $peg_qresult['p5'];
	     $peg_json_return_array['p7']    = $peg_qresult['p7'];
	     $peg_json_return_array['p20']   = $peg_qresult['p20'];
	     $peg_json_return_array['p22']   = $peg_qresult['p22'];
	     $peg_json_return_array['pc22']  = $peg_qresult['pc22'];
	     
	    if(!empty($peg_qresult['pc22'])){
			$peg_json_return_array['p22'] = pegasus_mysql_printfld('d40' , 'p01' , 'p02=:p02', array('p02'=> $peg_qresult['pc22']));
		}

	     $peg_json_return_array['p11']   = $peg_qresult['p11'];
	     $peg_json_return_array['p51']   = $peg_qresult['p51'];
		 
		 $peg_json_return_array['p4_1']   = $peg_qresult['p4_1'];
		 $peg_json_return_array['p4_2']   = $peg_qresult['p4_2'];
		 $peg_json_return_array['p4_3']   = $peg_qresult['p4_3'];
		 $peg_json_return_array['p6']   = $peg_qresult['p6'];
				 
	     $peg_json_return_array['p8']    = $peg_qresult['p8'];
	     $peg_json_return_array['p9']    = $peg_qresult['p9'];
	     $peg_json_return_array['p10']   = $peg_qresult['p10'];
	     $peg_json_return_array['p01']   = $peg_qresult['p01'];
		 
		 
		 return $peg_json_return_array;
	
	} 
     // if no found return nr01=0
     //if(empty($peg_qresult['nr01']) ){$peg_json_return_array['nr01']=0;};
     
	function customers_after_update(){

		// if(pegasus_module_exists('gym00') &&  !pegasus_module_exists('dias') && function_exists('peg_gym00_initialize_customers_a01_p51_p52')){
			// peg_gym00_initialize_customers_a01_p51_p52();
		// }

		$cor000_app_code = pegasus_mysql_printfld('cor000', 'app_code', 'nr01 = 1');
		if($cor000_app_code == 'PC.18.00.00' || $cor000_app_code == 'PC.20.00.00') {
			// Αν Retail, Πελάτες Accordeon πρώτο στη διαδοχή
			if(pegasus_mysql_printfld('p80', 'tax', 'nr01 = ?', array(140000007000004)) > 0) {
				pegasus_mysql_update('p80', array('tax'), array(-10), 'nr01 = ?', 0, 1, 1, array(140000007000004));
			}
		}
		pegasus_mysql_use('select rel, ver from p55 where p00="customers"', $version);
		
		if($version['ver'] == 2 && $version['rel'] <= 108) {
			// if( pegasus_module_exists('gym00') && function_exists('peg_gym00_initialize_customers000_a01_p801')){
				// peg_gym00_initialize_customers000_a01_p801();
			// }	
			// Σε περίπτωση που είναι κενή τιμή στο Update
			if( empty($_SESSION['customers_000_a01_p801'] )){
				pegasus_mysql_use('SELECT * FROM p82 WHERE p00= :p00; ', $p82, array('p00' => 'customers_ref_code_1'));
    			$tit  = $p82['p01'];
				$arr1 = array();
				$arr2 = array();
				array_push($arr1, 'desc02');  	array_push($arr2, $tit);
				pegasus_mysql_update('p51', $arr1, $arr2, 'p02 in ("a01_d", "a01_d000") AND desc05=?', 0, 1, 1, array('p801'));					
			}
			if( empty($_SESSION['customers_000_a01_p802'] )){
				pegasus_mysql_use('SELECT * FROM p82 WHERE p00= :p00; ', $p82, array('p00' => 'customers_ref_code_2'));
    			$tit  = $p82['p01'];
				$arr1 = array();
				$arr2 = array();
				array_push($arr1, 'desc02');  	array_push($arr2, $tit);
				pegasus_mysql_update('p51', $arr1, $arr2, 'p02 in ("a01_d", "a01_d000") AND desc05=?', 0, 1, 1, array('p802'));	
			}
		}

		peg_customers_user_defined_fields();
		peg_customers_vehicle_defined_fields();
		//Τρέχουμε την παρακάτω αλλαγή για version <= 2.78
		if($version['ver'] == 2 && $version['rel'] <= 78) {
			$query = 'update a01 set pikat=-1'; // Ενημερώνουμε όλους τους πελάτες με το προκαθορισμένο (-1) κατάστημα
			pegasus_query($query);
		}

		//Τρέχουμε την παρακάτω αλλαγή για version <= 2.82
		if($version['ver'] == 2 && $version['rel'] <= 82) {
			$query = 'update a01 set piinv=-1'; // Ενημερώνουμε όλους τους πελάτες με το προκαθορισμένο (-1) αποθηκευτικό χώρο
			pegasus_query($query);
		}

		//Διορθωση λαθος εγκαταστασης στο freelance
		pegasus_query("update a01 set p21='', remdate=curdate() , remtime=curtime() where nr01=1 and p21='3003000001';");
	}
	
	function peg_customers_user_defined_fields(){
	    for ($i = 0; $i < 4; $i++) {
	        
	        for ($ii = 1; $ii < 6; $ii++) {
				
				$values = array('p00' => 'customers_pd' . $ii . $i .'_tit');

	            pegasus_mysql_use('select * from p82 where p00=:p00; ', $p82, $values);
	            
	            $tit  = $p82['p01'];
	            $etit = $p82['ep01'];
	        
	            if( !empty($_SESSION['customers_000_pd' .$ii .$i]) ){
	                $tit  = $_SESSION['customers_000_pd' .$ii .$i];
	                $etit = $_SESSION['customers_000_epd' .$ii .$i];
	            }
	            
	            
	            $arr1 = array(); $arr2 = array();
	            array_push($arr1 , 'desc02');  array_push($arr2 , $tit);
	            array_push($arr1 , 'edesc02'); array_push($arr2 , $etit);
				pegasus_mysql_update('p51', $arr1, $arr2, 'p02 in ("a01_d" , "a01_d004" ) and desc05=:desc05', 0, 1, 1, array('desc05' => 'pd'.$ii.$i)); 

				if($ii == 1) { // Μόνο Λεκτικά
					if(pegasus_module_exists('retail00')) {
						pegasus_mysql_update('p51', $arr1, $arr2, 'p02 = "retail00_01_d02" and desc05=:desc05', 0, 1, 1, array('desc05' => 'a01pd'.$ii.$i));

						$values = array('p00' => 'retail00_a01pd' . $ii . $i .'_tit');
						pegasus_mysql_use('select * from p82 where p00=:p00; ', $p82, $values);
						$tit  = $p82['p01'];
						$etit = $p82['ep01'];
						if( !empty($_SESSION['customers_000_pd' .$ii .$i]) ){
							//concat σε παρένθεση
							$tit  .= ' ('.$_SESSION['customers_000_pd' .$ii .$i].')';
							$etit .= ' ('.$_SESSION['customers_000_epd' .$ii .$i].')';
						}
						$arr1 = array(); $arr2 = array();
						array_push($arr1 , 'desc02');  array_push($arr2 , $tit);
						array_push($arr1 , 'edesc02'); array_push($arr2 , $etit);
						pegasus_mysql_update('p51', $arr1, $arr2, 'p02 = "retail00_00_d" and desc05=:desc05', 0, 1, 1, array('desc05' => 'a01pd'.$ii.$i.'_en'));

						pegasus_delete_directory('../../tmp/retail00/retail00_00_d/');
						pegasus_delete_directory('../../tmp/retail00/retail00_01_d02/');
						
						if( pegasus_module_exists('peg002') && function_exists('peg002_clean_dCache')){
							peg002_clean_dCache('retail00_00_d');
							peg002_clean_dCache('retail00_01_d02');
						}
					}
				}
	        }
	        
	    }
		/* Κωδικός αναφοράς 1 [p801] */
		if( !empty($_SESSION['customers_000_a01_p801']) ){
			$tit  = $_SESSION['customers_000_a01_p801'];
			$etit = $_SESSION['customers_000_a01_ep801'];

			$arr1 = array();
			$arr2 = array();
			array_push($arr1, 'desc02');  	array_push($arr2, $tit);
			array_push($arr1, 'edesc02');  	array_push($arr2, $etit);
			pegasus_mysql_update('p51', $arr1, $arr2, 'p02 in ("a01_d", "a01_d000") AND desc05=?', 0, 1, 1, array('p801'));	
		}
		else{
			pegasus_mysql_use('SELECT * FROM p82 WHERE p00= :p00; ', $p82, array('p00' => 'customers_ref_code_1'));
			$tit  = $p82['p01'];
			$etit = $p82['ep01'];
			$arr1 = array();
			$arr2 = array();
			array_push($arr1, 'desc02');  	array_push($arr2, $tit);
			array_push($arr1, 'edesc02');  	array_push($arr2, $etit);
			pegasus_mysql_update('p51', $arr1, $arr2, 'p02 in ("a01_d", "a01_d000") AND desc05=?', 0, 1, 1, array('p801'));	
		}

		/* Κωδικός αναφοράς 2 [p802] */
		if( !empty($_SESSION['customers_000_a01_p802']) ){
			$tit  = $_SESSION['customers_000_a01_p802'];
			$etit = $_SESSION['customers_000_a01_ep802'];

			$arr1 = array();
			$arr2 = array();
			array_push($arr1, 'desc02');  	array_push($arr2, $tit);
			array_push($arr1, 'edesc02');  	array_push($arr2, $etit);
			pegasus_mysql_update('p51', $arr1, $arr2, 'p02 in ("a01_d", "a01_d000") AND desc05=?', 0, 1, 1, array('p802'));
		}
		else{
			pegasus_mysql_use('SELECT * FROM p82 WHERE p00= :p00; ', $p82, array('p00' => 'customers_ref_code_2'));
			$tit  = $p82['p01'];
			$etit = $p82['ep01'];

			$arr1 = array();
			$arr2 = array();
			array_push($arr1, 'desc02');  	array_push($arr2, $tit);
			array_push($arr1, 'edesc02');  	array_push($arr2, $etit);
			pegasus_mysql_update('p51', $arr1, $arr2, 'p02 in ("a01_d", "a01_d000") AND desc05=?', 0, 1, 1, array('p802'));	
		}
		
	    
	    pegasus_delete_directory('../../tmp/customers/a01_d/');
		pegasus_delete_directory('../../tmp/customers/a01_d000/');
	    pegasus_delete_directory('../../tmp/customers/a01_d004/');
		
		if( pegasus_module_exists('peg002') && function_exists('peg002_clean_dCache')){
			peg002_clean_dCache('a01_d');
			peg002_clean_dCache('a01_d000');
			peg002_clean_dCache('a01_d004');
		}		
	}

	function peg_customers_vehicle_defined_fields(){
		for ($i = 0; $i < 4; $i++) {
			$values = array('p00' => 'customers_erpa02_pd5' . $i .'_tit');
			
			pegasus_mysql_use('select * from p82 where p00=:p00; ', $p82, $values);
			
			$tit  = $p82['p01'];
			$etit = $p82['ep01'];
		
			if( !empty($_SESSION['customers_000_erpa02_pd5' .$i]) ){
				$tit  = $_SESSION['customers_000_erpa02_pd5' .$i];
				$etit = $_SESSION['customers_000_erpa02_epd5' .$i];
			}

			$arr1 = array(); $arr2 = array();
			array_push($arr1 , 'desc02');  array_push($arr2 , $tit);
			array_push($arr1 , 'edesc02'); array_push($arr2 , $etit);
			pegasus_mysql_update('p51', $arr1, $arr2, 'p02 in ("erpa02_d" , "erpa02_d04") and desc05=:desc05', 0, 1, 1, array('desc05' => 'pd5'.$i)); 
		}

		pegasus_delete_directory('../../tmp/customers/erpa02_d/');
		pegasus_delete_directory('../../tmp/customers/erpa02_d04/');
		
		if( pegasus_module_exists('peg002') && function_exists('peg002_clean_dCache')){
			peg002_clean_dCache('erpa02_d');
			peg002_clean_dCache('erpa02_d04');
		}
	}

	/**
	 * $data $data['p19'] =  15
	 */	 	
	function peg_customers_a01_d_initialize($data,$mmnr01='',$mnr01='',$_d='',$container_id=''){
	    		
	    	
	    if(!$data['nr01']>0){
			// Set Default values
			$default_values=peg_customers_a01_get_default_values();
			foreach($default_values as $default_field=>$default_value)
				$data[$default_field]=$default_value;
			$data['pikat'] = -1;
			$data['piinv'] = -1;
	    }

	    
	    
	    if(strtolower(substr($mmnr01,0,5))=='d00_d' and  !$data['nr01']>0 ){
			$exploded_mmnr01 = explode('-',$mmnr01);
	        $data['pnr01'] = $exploded_mmnr01[1];
	        $ret = customers_get_d00_data( $data['pnr01'] );
	        foreach ($ret as $key => $value) {
	            $data[$key] =  $value;
	        }
	        
	    }
		
	    
	    if(!empty($data['pc22'])){
	        $data['p22'] = pegasus_mysql_printfld('d40' , 'p01' , 'p02=:p02', array('p02' => $data['pc22']));
	    }
		
	    
	    if($_d=='a01_d'){
	        if(empty($data['nr01'])){
	            $data['nr01'] = pegasus_mysql_newrec("a01");
	            $peg_is_newrec =1 ;
	        }

			/*Δημιουργια πελάτη μέσα από ανάλυση χρέωσης κράτησης*/
	        if( isset($_REQUEST['hota04_pnr01']) && $_REQUEST['hota04_pnr01']>0 && $peg_is_newrec){
	        	$data['pnr01'] = $_REQUEST['hota04_pnr01'];
	        }
			
			$values = array(
				'sessionid' => session_id(), 
				'mmnr01' => 'a01_d-'.$data['nr01'],
				'mnr01' => $data['nr01'],
			);

	        $whereTmpTbl = ' peg_flag!=9 and '.
	   	        ' peg_sess_id=:sessionid  and '.
	   	        ' peg_mmnr01=:mmnr01 and '.
				' peg_mnr01=:mnr01 ';
				   
	        //Dimiourgoume ola ta tmp
	        pegasus_make_all_tmp_recs('a01' , $data , $data['nr01'] , $_REQUEST['rec_copy_nr01'] , 'a01_d-'.$data['nr01'] );

			// if(function_exists('gym00_a01_d_setup')){
			// 	gym00_a01_d_setup($container_id, $data['nr01']);
			// }

			/* Καρτέλα πιστοποιητικό covid */
			// if(pegasus_module_exists('gym00')){
			// 	$query = "SELECT * FROM gym00_09 WHERE a01= :a01";
			// 	pegasus_mysql_use($query, $gym00_09, array('a01'=>$data["nr01"]));
			// 	$data["v_cov_cer"] = $gym00_09["cov_cer"];
			// 	$data["v_cov_valid"] = $gym00_09["cov_valid"];
			// }

			/** hidden το tab "Συνδρομές" εφόσον είναι checked η αντίστοιχη επιλογή*/
			// if(pegasus_module_exists('gym00') && $_SESSION['gym00_00_p01'] == 1){
			// 	$data['customers_a01_d_tab01_x_hidden'] = true;
			// }

			/** hidden το tab "Κινήσεις Μονάδων" ή "Κινήσεις Επισκέψεων" με βάση την αντίστοιχη παράμετρο στις Βασικές Παραμέτρους Gym*/
			// if(pegasus_module_exists('gym00')){
			// 	if($_SESSION['gym00_00_gym00_87_type'] == 1) {
			// 		$data['customers_a01_d_tab01_visits_hidden'] = true;
			// 	}
			// 	if($_SESSION['gym00_00_gym00_87_type'] == 2) {
			// 		$data['customers_a01_d_tab01_points_hidden'] = true;
			// 	}
			// }

			/* Barcode [p801] αν υπάρχει το Module gym00 και είναι νέα εγγραφή */
			// if(pegasus_module_exists('gym00') && $peg_is_newrec && $_SESSION['gym00_00_p05']==1){
			// 	$data['p801'] = $data['nr01'];
			// }
 
			//	Πίνακας: a72_d
			//	-> Έλεγχος Καρτέλας Ειδικές Τιμές > Τιμές Ανά Είδος
	        pegasusSetGlobalVar( 
				$container_id. '_where_a72' , 
				array(
					'sql' => ' peg_tmp_a72.p00=:mnr01 and '.$whereTmpTbl,
					'sqlParams' => $values
				)
			);
			
			// Πίνακας: a73_d 
			// -> Έλεγχος Καρτέλας Ειδικές Τιμές > Εκπτώσεις Ανά Ομάδα
	        pegasusSetGlobalVar(
				$container_id. '_where_a73' , 
				array(
					'sql' => ' peg_tmp_a73.p00=:mnr01 and '.$whereTmpTbl,
					'sqlParams' => $values 
				)
			);
			
			// Πίνακας: a71_d -> Υποκαταστήματα Πελατών
	        pegasusSetGlobalVar(
				$container_id. '_where_a71' ,
				array(
					'sql' => ' peg_tmp_a71.p601=:mnr01 and '.$whereTmpTbl,
					'sqlParams' => $values
				)
			);

			// Πίνακας: erpa02_d00 / grid
	        pegasusSetGlobalVar(
				$container_id. '_where_erpa02' , 
				array(
					'sql' => ' erpa02.p03=:mnr01 ',
					'sqlParams' => $values 
				)
			);		
			
			// Πίνακας: erpa80_d03 / grid
	        pegasusSetGlobalVar(
				$container_id. '_where_erpa80_d03' , 
				array(
					'sql' => ' erpa80_d03.nr01=:nr01 ',
					'sqlParams' => array('nr01' => $data['nr01'])
				)
			);	
	        
	        if( !empty($data['pc22']) ){
	            $data['p22_readonly'] = 1;
	        }
			 
			if ($data['nr01'] == $_SESSION['customers_000_retail_a01'] && !pegasus_check_permission('customers.customer.lianiki')) {
				$data['message'] = '<div class="alert_message">' . $_SESSION['peg_dic_customers_customer_lianikis_permission'] . '</div>';
				$data['readonly'] = 1;
			}

			if(pegasus_module_exists('genlogef')) {
				// Αν έχει το module genlogef και είναι ορισμένη η παράμετρος χρήστη "enet_genlo_xml_1" με ζεύγος "παραμέτρος;προεπιλεγμένη_τιμή" σετάρουμε την τιμή σε νέες εγγραφές
				if($peg_is_newrec == 1 && isset($_SESSION['cor011_enet_genlo_xml_1']) && !empty($_SESSION['cor011_enet_genlo_xml_1'])) {
					$a01_custid_arr = explode(';', $_SESSION['cor011_enet_genlo_xml_1']);
					$field_map = array('1' => 'pd10', '2' => 'pd11', '3' => 'pd12', '4' => 'pd13');
				
					if (!empty($field_map[$a01_custid_arr[0]]) && !empty($a01_custid_arr[1])) {
						$data[$field_map[$a01_custid_arr[0]]] = $a01_custid_arr[1];
					}
				}
			}
		}

		$data['v_pending_orders_hidden'] = 1;
		$data['v_pen_order_bt_hidden'] = 1;
		if(pegasus_module_exists('ordercust')) {
			$data['v_pending_orders_hidden'] = 0;
			$data['v_pen_order_bt_hidden'] = 0;

			$data['v_pending_orders'] = ordercust_customers_atimologites_total($data);
		}
		
		$data['v_t03_hidden'] = 1;
		$data['v_t03_but_hidden'] = 1;
		if(pegasus_module_exists('axio')) {
			$data['v_t03_hidden'] = 0;
			$data['v_t03_but_hidden'] = 0;

			if((!empty($data['p21']))) {
				$query = "SELECT t03.p01 AS log, sum(t03.p05) AS xr 
							FROM t03 
						   WHERE t03.p01=:p21 /* Λογαριασμός */
						   	 AND t03.p04 >= curdate() /* Ημ/νία Λήξης */
							 AND (t03.p060 <= '0100-01-01' OR t03.p060 > curdate()) /* Ημ/νία Εξόφλησης */
							 AND (t03.p063 <= '0100-01-01' OR t03.p063 > curdate()) /* Ημ/νία Ακύρωσης */
							 AND t03.p06 <= curdate()"; /* Ημ/νία Εξόφλησης */

				pegasus_mysql_use($query, $res, array("p21" => $data['p21']));
				$data['v_t03'] = $res['xr'];
			}
		}

		/* Αν έχει Hermes: Πελάτες (front end) εμφανίζουμε τα πεδία Τιμοκαταλόγων Site */
		if(pegasus_module_exists('customer')) {
			$data['customers_a01_d002_fset04_hidden'] = false;
			$data['ep48_hidden'] = 0;
			$data['ep06_hidden'] = 0;
		}else{
			$data['customers_a01_d002_fset04_hidden'] = true;
			$data['ep48_hidden'] = 1;
			$data['ep06_hidden'] = 1;
		}

		$data['nr01_hidden'] = 2;
		if(empty($data['message'])){
			$data['message_hidden'] = 1;	
		}
	    
	    return $data;
	}

	function customers_a01_d_onsave($data, $permDeny, $mmnr01, $checkOnlyPerm){
		$ret_arr  = customers_a01_d_check_data($data, $permDeny);
        $data     = $ret_arr[0];
        $permDeny = $ret_arr[1];
        
		$data['p20'] = trim($data['p20']);

		// Δεν μπορώ να καταχωρήσω πελάτη με default παραστατικό αν ο πελάτης αυτός είναι αρχικός πελάτης σε τουλάχιστον ένα a10.
		if(
			!empty($data['p101'])
			&& pegasus_mysql_printfld('a10','COUNT(nr01)','a01 = :a01',array('a01' => $data['nr01'])) > 0 
		) {
			$sql ="	SELECT p02
					FROM a10
					WHERE 1 = 1
					AND a01 = :a01
					LIMIT 20
			";
			$values = array(
				'a01' => $data['nr01']
			);
			$res = pegasus_query($sql,$values);
			$msg = $_SESSION['peg_dic_customers_a01_p101_unacceptable_2'];
			$msg .= "<ul>";
			while($rs = pegasus_fetch_assoc($res)) {
				$msg .='<li>'.$rs['p02'].'</li>';
			}
			$msg .= "</ul>";
			array_push($permDeny, array('type'=>'deny', 'message'=>$msg));
		}
		
        if($checkOnlyPerm==0){  
			if(pegasus_module_exists('courier00')){
				courier00_r12_d_insert_default_data($data['nr01']);
			}
        }

        return array($data, $permDeny);
	}

	function customers_a01_d_check_data($data, $permDeny){

		if(!empty($data['pc22'])){
			$data['p22'] = pegasus_mysql_printfld('d40', 'p01', 'p02=:p02', array('p02' => $data['pc22']));
		}

		// same p801 if not empty
		if(!empty($data['p801']) and (int) pegasus_mysql_printfld('a01', 'nr01', 'nr01<>:nr01 and p801=:p801', 
			array('nr01' => $data['nr01'],'p801' => $data['p801']))<>0){
			array_push($permDeny, array('type'=>'deny', 'message'=>$_SESSION['peg_dic_customers_a01_001'])); 
		}
		
		// same pnr01 if not empty
		if(!empty($data['pnr01']) and (int) pegasus_mysql_printfld('a01', 'nr01', 'nr01<>:nr01 and pnr01=:pnr01 ',
			array('nr01' => $data['nr01'], 'pnr01' => $data['pnr01']))<>0){ 
			array_push($permDeny, array('type'=>'confirm', 'message'=>$_SESSION['peg_dic_customers_a01_002'])); 
		}
		
		if(empty($data['p19']) && $data['p2']!='' && $data['p3']!=''){
			$data['p19'] = $data['p2'] . ' ' . $data['p3'];
		}

		//not empty p19
		if(trim($data['p19'])==false){ 
			array_push($permDeny, array('type'=>'deny', 'message'=>$_SESSION['peg_dic_customers_a01_003'])); 
		}
		
		//VAT Code is right?
		if($data['p05']==1 and check_AFM($data['p20'])==false){ 
			array_push($permDeny, array('type'=>'deny', 'message'=>$_SESSION['peg_dic_customers_a01_004'])); 
		}
		if($data['pl20']==0 and check_AFM($data['p20'])==false){ 
			array_push($permDeny, array('type'=>'deny', 'message'=>$_SESSION['peg_dic_customers_a01_011'])); 
		}

		if ($data['p20'] != pegasus_mysql_printfld('a01', 'p20', 'nr01 = ?', array($data['nr01'])) 
			&& !invoices_check_for_afm_change('a01', $data['nr01']))
		{
			array_push($permDeny, array('type'=>'deny', 'message'=>$_SESSION['peg_dic_customers_afm_change'])); 
		}

		// basic pricelist (i23)
		 
		if(pegasus_mysql_table_exists('i23') and (int) pegasus_mysql_printfld('i23', 'nr01', "p01=:p01", 
			array('p01' => $data['p48']))==0){ 
			array_push($permDeny, array('type'=>'deny', 'message'=>$_SESSION['peg_dic_customers_a01_005'])); 
		}
		
		// VAT type
		if(pegasus_mysql_table_exists('a26') and 
			(int) pegasus_mysql_printfld('a26', 'nr01', "p01=:p01", array('p01' => $data['p45']))==0){ 
			array_push($permDeny, array('type'=>'deny', 'message'=>$_SESSION['peg_dic_customers_a01_006'])); 
		}
		
		//p803c invcust_diatiaxi_fpa_deny - Υποχρεωτική διάταξη απαλλαγης για το συγκεκριμένο καθεστως
		if (!($data['p803c']>0) and 
			pegasus_mysql_printfld('a26', 'p04', "p01=:p01", array('p01' => $data['p45'])) == 1) {
			array_push($permDeny, array('type' => 'deny', 'message' =>   $_SESSION['peg_dic_customers_diatiaxi_fpa_deny']));
		}
		
		// receipt Code
		if(pegasus_mysql_table_exists('a14') and (int) pegasus_mysql_printfld('a14', 'nr01', "nr01=:nr01", 
			array('nr01' => $data['p02']))==0){ 
			array_push($permDeny, array('type'=>'deny', 'message'=>$_SESSION['peg_dic_customers_a01_007'])); 
		}
		
		// Tax Office
		if(empty($data['p22']) and empty( $data['pc22']) and $data['p05']==1){ 
			array_push($permDeny, array('type'=>'deny', 'message'=>$_SESSION['peg_dic_customers_a01_008'])); 
		}
		
		// same p20  if not empty
		if(!empty($data['p20']) and (int) pegasus_mysql_printfld('a01', 'nr01', 'nr01<>:nr01 and p20=:p20', 
			array('nr01'=> $data['nr01'], 'p20' => $data['p20']))<>0 && $data['p0400']==0){ 
				
			if($_SESSION['customers_000_dn_p20']==1){
				array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_customers_a01_012']));
			}else{
				array_push($permDeny, array('type' => 'confirm', 'message' => $_SESSION['peg_dic_customers_a01_009']));
			}
		}
		
		// Δεν μπορώ να ενημερώσω τον Πελάτη Λιανικής αν δεν έχω το δικαίωμα
		if($data['nr01'] == $_SESSION['customers_000_retail_a01'] && !pegasus_check_permission('customers.customer.lianiki')){ 
			array_push($permDeny, array('type'=>'deny', 'message'=>$_SESSION['peg_dic_customers_customer_lianikis_permission'])); 
		}

		if(empty($data['p23']) && pegasus_mysql_printfld('customers_000', 'p103', 'nr01 = 1') == 1){
			// Εαν έχει κενή κατηγορία επαγγέλματος και έχει επιλεγμένο το αντίστοιχο check βγάζει μήνυμα
			array_push( $permDeny , array( 'type'=>'deny' , 'message'=>$_SESSION['peg_dic_customers_empty_industry_category']));
		}
	
		if(empty($data['p4']) && pegasus_mysql_printfld('customers_000', 'mand_a', 'nr01 = 1') == 1){
			// Εαν έχει κενή διεύθυνση στο tab 'Στοιχεία Διεύθυνσης' και έχει επιλεγμένο το αντίστοιχο check βγάζει μήνυμα
			array_push( $permDeny , array( 'type'=>'deny' , 'message'=>$_SESSION['peg_dic_customers_empty_address']));
		}
	
		if(empty($data['p4_1']) && pegasus_mysql_printfld('customers_000', 'mand_c', 'nr01 = 1') == 1){
			// Εαν έχει κενή χώρα στο tab 'Στοιχεία Διεύθυνσης' και έχει επιλεγμένο το αντίστοιχο check βγάζει μήνυμα
			array_push( $permDeny , array( 'type'=>'deny' , 'message'=>$_SESSION['peg_dic_customers_empty_country']));
		}
	
		if(empty($data['p5']) && pegasus_mysql_printfld('customers_000', 'mand_r', 'nr01 = 1') == 1){
			// Εαν έχει κενή περιοχή στο tab 'Στοιχεία Διεύθυνσης' και έχει επιλεγμένο το αντίστοιχο check βγάζει μήνυμα
			array_push( $permDeny , array( 'type'=>'deny' , 'message'=>$_SESSION['peg_dic_customers_empty_region']));
		}
	
		if(empty($data['p7']) && pegasus_mysql_printfld('customers_000', 'mand_pc', 'nr01 = 1') == 1){
			// Εαν έχει κενό Τ.Κ στο tab 'Στοιχεία Διεύθυνσης' και έχει επιλεγμένο το αντίστοιχο check βγάζει μήνυμα
			array_push( $permDeny , array( 'type'=>'deny' , 'message'=>$_SESSION['peg_dic_customers_empty_postalcode']));
		}
        
        return array($data, $permDeny);	
	}
	
	function peg_customers_a01_d00_initialize($data,$mmnr01='',$mnr01='',$_d='',$container_id=''){

		$pnr01 = explode('-',$mmnr01);
		// Πίνακας: a01_d - Πελάτες
	    pegasusSetGlobalVar( 
			$container_id . '_where_a01' , 
			array(
				'sql' => "pnr01=:mnr01",
				'sqlParams' => array(
					'mnr01' => $pnr01[1]
				)
			)
		);	
	    return $data;
	}

	
	function peg_customers_a71_d_initialize($data,$mmnr01='',$mnr01='',$_d='',$container_id=''){
		
		if($_d=='a71_d'){
    	    if(substr($mmnr01,0,5)=='a01_d'){
    	        $data['p601_hidden'] = '2';
    	        $data['p601'] = $mnr01;
			}
			
			// Πίνακας: a71_d00 -> Υποκατάστημα Πελάτη / grid
			pegasusSetGlobalVar(
				$container_id . '_where_a71' ,  
				array(
					'sql' => ' p601=:mnr01 ',
					'sqlParams' => array(
						'mnr01' => $mnr01
					)
				)
			);
	    }
	    return $data;
	}
	function peg_customers_erpa02_d_initialize($data,$mmnr01='',$mnr01='',$_d='',$container_id=''){
		$nr01 = $data['nr01'];

		if($data['nr01'] <= 0) {
			$nr01 = -1;
		}

		$data['invcust_erpa02_d01_grid_invcust_cancel_invoice_hidden'] = false;
		$data['invcust_erpa02_d01_grid_invcust_transform_invoice_hidden'] = false;	
		$data['invcust_erpa02_d01_grid_account_proceed_to_payment_hidden'] = false;
		$data['invtrans_erpa02_d06_grid_invtrans_view_relation_hidden'] = false;

		if(pegasus_module_exists('stores')) {
			$data['invcust_erpa02_d01_grid_stores_disable_store_filter_hidden'] = false;
			$data['ordercust_erpa02_d03_grid_stores_disable_store_filter_hidden'] = false;
		}

		if (pegasus_module_exists('ordercust')) {
			$data['ordercust_erpa02_d03_grid_invoice_order_hidden'] = false;
		}
		if($_d=='erpa02_d') {
			if(substr($mmnr01,0,5)=="a01_d"){
				$data['p03'] = $mnr01;
				$data['p03_readonly'] = 1;
			} else if($_REQUEST['a01_nr01'] > 0) {
				$data['p03'] = $_REQUEST['a01_nr01'];
				$data['p03_readonly'] = 1;
			}
			
			pegasusSetGlobalVar(
				$container_id . '_where_erpa02_d01' ,  
				array(
					'sql' 		=> ' a55.p705 = :nr01',
					'sqlParams' => array("nr01"=>$nr01)
				)
			);

			pegasusSetGlobalVar(
				$container_id . '_where_erpa02_d03' ,  
				array(
					'sql' 		=> ' a57.p705 = :nr01',
					'sqlParams' => array("nr01"=>$nr01)
				)
			);
	        
			invtrans_erpa02_d06_set_grid_query($data['nr01'], $data['p03'], $container_id);

			if(pegasus_module_exists('carwash')){
				carwash_carwash02_d_set_grid_query($container_id, $data['nr01']);
			}

	    }

		if(pegasus_module_exists('park00')){
			park00_update_data_parr03_fields($data);
		}

	    return $data;
	}

	/**
	 * Κάνει hidden ή unhidden και clear ή not clear το υποκατάστημα πελάτη
	 * @param data περιέχει πελάτη @customer, υποκατάστημα πελάτη @a71
	 * @return return_array @a71_hidden, @clear_a71
	 */
	function customers_return_a71($data){
	    
		$return_array = array();

	    $customer = $data['customer'];
    	$a71 = $data['a71'];	
    
    	$return_array['clear_a71'] = 0;
    	// Εάν έχουμε επιλέξει πελάτη
    	if($customer>0){  	
			// Clear υποκαταστημα		 		
    		if($a71>0){						
				if(pegasus_mysql_printfld('a71' , 'p601' , 'nr01=? ' , array($a71) ) != $customer){
						$return_array['clear_a71'] = 1;
				} 					 							
			}
			// Hide υποκαταστημα
			$return_array['a71_hidden']=true;		
			$query = "SELECT count(*) AS cnt, 
									1 AS p_tp 
						FROM a71 
						JOIN a01 ON a71.p601=a01.nr01 AND a01.nr01= :nr01 ;";
			
			pegasus_mysql_use($query, $has_store, array('nr01' => $customer ));
			if($has_store['cnt']>0){
				$return_array['a71_hidden']=false;
			}
    	}
    
    	return $return_array;
	}
/**
 *
 * @param string $ckafmuser
 * @param string $ckafmpass
 * @param string $ckafmafm
 * @return array
 */
function customers_check_connection(
	$ckafmuser = '',
	$ckafmpass = '',
	$ckafmafm = ''
) {
	$url = 'services00.pegcloud.io';
	//$url = 'mock.pegcloud.io';
	try {
		$params = array();
		$headers = array();
		$options = array(CURLOPT_TIMEOUT => 4);
		$resp = pegasus_curl_request(
				"https://$url/is_alive.php",
				false,
				$params,
				$headers,
				$options
			);
		if ($resp != 'true') {
			throw new Exception('Server Unavailable');
		}
	} catch (Exception $e) {
		$url = 'services.tesae.gr';
	}
	//
	$return = array(
		'ok'	=> 0,
		'data'	=> '',
		'msg'	=> 'Error'
	);
	$sid = '';
	$is_login = false;
	try {
		$user = $_SESSION['cor000_tesae_user'];
		$pass = $_SESSION['cor000_tesae_pass'];
		$params = array(
			'action'	=> 'login',
			'user'		=> $user,
			'pass'		=> $pass,
			'un'		=> 1
		);
		$resp = pegasus_curl_request_post(
			"https://$url/services01/execute.php",
			$params
		);
		//print_r($resp);
		$xml = simplexml_load_string($resp);
		if ($xml->code != '100') {
			throw new Exception($xml->description, 601);
		}
		$sn = pegasus_leading_zeros($_SESSION['cor000_sn'], 7);
		$code = "";
		$sid = $xml->sid;
		$is_login = true;
		$params = array(
			'action'	=> 'checkConnection',
			'username'	=> $ckafmuser,
			'password'	=> $ckafmpass,
			'sn'		=> $sn,
			'code'		=> $code,
			'sid'		=> $sid,
			'fromafm'	=> $ckafmafm,
		);
		$resp =  pegasus_curl_request_post(
			"https://$url/services01/execute.php",
			$params
		);
		$xml = simplexml_load_string($resp);
		if ($xml->code != 200) {
			throw new Exception((string) $xml->description, 601);
		}
		$return = array(
			'ok'	=> 1,
			'data'	=> '',
			'msg'	=> (string) $xml->description
		);
	} catch (Exception $e) {
		$message = 'Error';
		if ($e->getCode() == 601) {
			$message = $e->getMessage();
		}
		$return = array(
			'ok'	=> 0,
			'data'	=> '',
			'msg'	=> $message
		);
	}
	if($is_login)
	{
		try {
			if (!empty($sid)) {
				$params = array(
					'action'	=> 'sessionDestroy',
					'sid'		=> $sid
				);
				$resp = pegasus_curl_request_post(
					"https://$url/services01/execute.php",
					$params
				);
			}
			return $return;
		} catch (Exception $e) {
			return array(
				'ok'	=> 0,
				'data'	=> '',
				'msg'	=> 'Error'
			);
		}
	}
	return $return;	
}

function customers_a14_d_initialize($data, $mmnr01='', $mnr01='', $_d='', $container_id=''){
	
	$new_rec = false;
	if(!($data['nr01'] > 0)) {
		$data['nr01'] = pegasus_mysql_newrec('a14');
		$new_rec = true;
	}

	global $PegInput;
	$PegInput->addVar(new peg_input_number('rec_copy_nr01'));
	$rec_copy_nr01  = $PegInput->getRequest('rec_copy_nr01');


	if(pegasus_module_exists('pos00')){
		pegasus_make_all_tmp_recs('a14', $data, $data['nr01'], $_REQUEST['rec_copy_nr01'], 'a14_d-'.$data['nr01']);

		$where_pos00_02 = ' peg_flag!=9 and peg_sess_id=:sid and peg_mmnr01=:mmnr01 and peg_mnr01=:mnr01 and a14=:nr01 and este55=""';
		$values_array   = array("sid"     => session_id(),
								"mnr01"   => $data['nr01'],
								"mmnr01"  => "a14_d-".$data['nr01'],
								"nr01" 	  => $data['nr01']
							);
							
		pegasusSetGlobalVar(
			$container_id. '_where_pos00_02', 
			array(
				'sql' 		=> $where_pos00_02,
				'sqlParams' => $values_array 
			)
		);
	}

	//Παραμετροποίηση myDATA
	if ($rec_copy_nr01 > 0) {
		$data['v_q30_620042'] = pegasus_mysql_printfld("q31", "p05", "p03 = ? and p01 = 620042", array($rec_copy_nr01));
	}else{	
		$data['v_q30_620042'] = pegasus_mysql_printfld("q31", "p05", "p03 = ? and p01 = 620042", array($data['nr01'])); 
	}

	return $data;
}

function customers_a14_d_onchange($data , $permDeny , $mmnr01 , $checkOnlyPerm){

	global $PegInput;	
	$PegInput->addVar(new peg_input_alphanumeric('v_q30_620042', 'request'));
	$v_q30 = $PegInput->getRequest('v_q30_620042');
	

	//Παραμετροποίηση myDATA
	if ($checkOnlyPerm == 1){
		core00_manage_relation($v_q30, '620042', $data['nr01']);
	}

	if(pegasus_module_exists('retail00')){
		$retail00_00_a55p015 =  pegasus_mysql_printfld('retail00_00', 'a55p015', 'nr01 = 1');
		if($retail00_00_a55p015 == $data['nr01'] and !empty($data['p31'])){
			$msg = $_SESSION['peg_dic_customers_a14_p31_deny'];
			array_push($permDeny, array('type' => 'deny', 'message' => $msg));
		}
		if($retail00_00_a55p015 == $data['nr01'] and !empty($data['p02'])){
			$msg = $_SESSION['peg_dic_customers_a14_p02_deny'];
			array_push($permDeny, array('type' => 'deny', 'message' => $msg));
		}
	}
	
	if(pegasus_module_exists('pos00')){
		//Έλεγχος αν εχει ορισθεί συνδεση του Τrοπου Εισπραξης με myDATA-Τρόποι Πληρωμής: 7|POS/e-POS σε περιπτωση που εχουν εισαχθεί Ρυθμίσεις POS
		$query  = "select peg_tmp_pos00_02.* from peg_tmp_pos00_02 ";
		$query .= "join pos00_01 on peg_tmp_pos00_02.pos00_01=pos00_01.nr01 ";
		$query .= "where peg_flag!=9 and peg_sess_id=:sid and peg_mmnr01=:mmnr01 and peg_mnr01=:mnr01 and peg_tmp_pos00_02.a14=:nr01 and pos00_01.req_sign=1 ";

		$values_array = array(	"sid"     => session_id(),
								"mnr01"   => $data['nr01'],
								"mmnr01"  => $mmnr01,
								"nr01" 	  => $data['nr01']
							);

		$result = pegasus_query($query, $values_array);
		$cnt 	= pegasus_num_rows($result);

		if($cnt>0){
			if($v_q30!=7){
				array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_pos00_pos00_02_a14_mydt_not_related']));
			}

			if($data['p02']>0){
				array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_pos00_pos00_02_a14_p02_not_valid']));
			}
		}
	}


	return array($data, $permDeny);
}

/**
	 * Υπολογίζει τις τιμές Χρέωση, Πίστωση και Συνολικό Υπολοιπο για την φόρμα εκτυπωσης Οικονομική Καρτέλα Πελάτη
	 * @param dias_main_nr01
	 * @param dt_to 
	 * @param dt_from 
	 * @param days 
	 * @param t07_p01 
	 * @param sum   
	 * @return return_array
	 */
function customers_financials_form($dias_main_nr01, $dt_to, $dt_from, $days, $t07_p01, $sum = 0){

	$tmp_lo = pegasus_mysql_printfld('a01','p21', 'nr01=?',array( $dias_main_nr01));

	if(empty($days)){
	$days=30;
	}
	$tmp_df= $dt_from;
	$tmp_dt= $dt_to;

	$tmp_ka1= $t07_p01;
	$tmp_ka2= $t07_p01;
	if(!isset($tmp_ka1) && pegasus_mysql_table_exists('t07') ){
		if(pegasus_module_exists('stores') && !pegasus_check_permission('stores.change')  ){
			pegasus_mysql_use("select * from cor003 where p01=? " , $cor003,array($_SESSION['pegasus_client_uid']) );
			$kat1=$cor003['p301'];
			$kat2=$cor003['p302'];
			$tmp_ka1=pegasus_mysql_printfld('t07', 'min(p01)', 'nr01>=0 and p01 >= ? ',array($kat1));
			$tmp_ka2=pegasus_mysql_printfld('t07', 'max(p01)', 'nr01>=0 and p01 <= ? ',array($kat2));
		}else if(pegasus_module_exists('stores')){
			$tmp_ka1=pegasus_mysql_printfld('t07', 'min(p01)', 'nr01>=0' );
			$tmp_ka2=pegasus_mysql_printfld('t07', 'max(p01)', 'nr01>=0' );
		}else{
			  $tmp_ka1=0;
			$tmp_ka2=999999;
		}
	}			
	$tmp_p03='t01.p03';
	$tmp_p04='t01.p04';
	$tmp_cond1="t01.nr01>=0";
	$fields = ' tabl01.p03,tabl01.p04 ';
	if($sum == 1){
		$fields = ' sum(tabl01.p03) as tot_p03, sum(tabl01.p04) as tot_p04 ';
	}
	
	$sql_code="
			select tabl01.p02,$fields,tabl01.p05,tabl01.p06, (@sum := @sum + tabl01.p03-tabl01.p04) as tmp_p01 ,tabl01.type 
			FROM 
			(    /*********************************
					tabl01=all final records
				**********************************    
			/*************************
				 find previous total
			**************************/     
			(select  0 as nr01, 
					cast('01000101' as date)  as p02, 
					if(sum($tmp_p03-$tmp_p04)>0, sum($tmp_p03-$tmp_p04), 0)  as p03, 
					if(sum($tmp_p04-$tmp_p03)>0, sum($tmp_p04-$tmp_p03), 0)  as p04, 
					'" . $_SESSION['peg_dic_account_t01_011'] . "'  as p05, 
					''  as p06, 
					'1' as type
			FROM t01 
			WHERE t01.p01=:var_tmp_lo
				&& t01.p02<:var_tmp_df
				&& t01.p09>=:var_tmp_ka1
				&& t01.p09<=:var_tmp_ka2
				&& $tmp_cond1
				GROUP BY t01.p01
			)

			 union ALL 

			 /*****************************
				 analysis into period
			*****************************/
			(select  t01.nr01 as nr01, 
					t01.p02  as p02, 
					$tmp_p03  as p03, 
					$tmp_p04  as p04,         
					t01.p05  as p05, 
					t01.p06  as p06,
					'2' as type     
			FROM t01 
			LEFT JOIN t02 ON t02.p01=t01.p07 ";
			if(pegasus_mysql_table_exists('t07')){           
				$sql_code .="  LEFT JOIN t07 ON t07.p01=t01.p09 ";
			}	
	$sql_code .="
	   LEFT JOIN us0 ON us0.p01=t01.p401 
	   WHERE t01.p01=:var_tmp_lo
		  && t01.p02>=:var_tmp_df
		  && t01.p02<=:var_tmp_dt
		  && t01.p09>=:var_tmp_ka1
		  && t01.p09<=:var_tmp_ka2
		  && $tmp_cond1
	   )	  
	) as tabl01,
	 (select @sum := 0) AS params
	ORDER BY tabl01.p02 , tabl01.nr01;";
//echo pegasus_replace_values_in_sql($sql_code);
$query_params = array('var_tmp_lo'=>$tmp_lo, 'var_tmp_df'=>$tmp_df, 'var_tmp_ka1'=>$tmp_ka1, 'var_tmp_ka2'=>$tmp_ka2, 'var_tmp_dt'=>$tmp_dt);

return array("sql" => $sql_code, "sqlParams" => $query_params);

}

function customers_erpa02_d_onsave($data, $permDeny, $mmnr01, $checkOnlyPerm){

	$data['p05'] = peg_core_abschr($data['p01']);

	$check_if_erpa02_exists = pegasus_mysql_printfld('erpa02',
											   'nr01',
											   'nr01 != :var_nr01 && p05 = :var_p05',
												array('var_nr01'=>$data['nr01'], 'var_p03'=>$data['p03'], 'var_p05'=> $data['p05'])
											);
	if(!empty($check_if_erpa02_exists)){
		array_push($permDeny, array('type' => 'confirm', 'message' => $_SESSION['peg_dic_customers_vehicle_check']));

	}

	if($_SESSION['customers_000_erpa02_chk'] == 1 && empty($data['p03'])){
		array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_customers_erpa02_check']));

	}

	if(pegasus_module_exists('park00') && $checkOnlyPerm == 0){
		park00_insert_update_parr03_from_variable_fields($data['nr01']);
		$data = park00_erpa02_d_onsave($data);
	}

	return array($data, $permDeny);

}