<?php

require('../dashboard00_00/classes.php');
function peg_dashboard00_dashboard00_10_d_initialize($data, $mmnr01 = '', $mnr01 = '', $_d = '', $container_id = '')
{
    if ($_d == 'dashboard00_10_d') {
        if (empty($data['nr01'])) {
            $data['nr01'] = pegasus_mysql_newrec('dashboard00_10');
        }
    }
    pegasus_make_all_tmp_recs('dashboard00_10', $data, $data['nr01'], $_REQUEST['rec_copy_nr01'], 'dashboard00_10_d-' . $data['nr01']);

    pegasusSetGlobalVar(
        $container_id . '_where_grid_dashboard00_11_arr',
        array(
            'sql'        =>    'peg_flag!=9 and peg_tmp_dashboard00_11.dashboard00_10=:var_dashboard00_10
                                and peg_tmp_dashboard00_11.peg_sess_id=:var_sess_id
                                and peg_tmp_dashboard00_11.peg_mmnr01=:var_mmnr01
                                and peg_tmp_dashboard00_11.peg_mnr01=:var_mnr01 ',
            'sqlParams'    =>    array(
                'var_dashboard00_10' => $data['nr01'],
                'var_sess_id' => session_id(),
                'var_mmnr01' =>  'dashboard00_10_d-' . $data['nr01'],
                'var_mnr01' => $data['nr01']
            )
        )
    );

    $data['dashboard00_dashboard00_10_d_dashboard00_11_disabled'] = $data['auto_updated'];
    return $data;
}

function peg_dashboard00_dashboard00_11_d_initialize($data, $mmnr01 = '', $mnr01 = '', $_d = '', $container_id = '')
{
    $new_rec = 0;

    if (!($data['nr01'] > 0)) {
        $new_rec = 1;
    }

    if ($new_rec == 1) {

        $mmnr01_arr =  explode('-', $mmnr01);
        if ($mmnr01_arr[0] == 'dashboard00_10_d') {
            $data['dashboard00_10'] = $mmnr01_arr[1];
        }
    }
    if (!pegasus_module_exists('lang')) {
        $data['ep00_hidden'] = 2;
    }
    //TODO: Εδώ - εφόσον βάλω αυτην τη λογική θα πρέπει να βάλω το προφιλ της οθόνης στο where.
    /*$where = peg_query_generateProfilePermissionWhere();
    if (!empty($where)) {
        $where = " and en=1";
    }
    pegasusSetGlobalVar(
        $container_id . '_where_selectbox_q10',
        " q08.in_menu=1 and q09.in_menu=1  $where "
    );
*/
    switch ($data['dashboard00_12']) {
        case 140000108000000 :
            $data['fieldset_140000108000000_hidden'] = false;
        break;
        case 140000003000000 :
            $data['fieldset_140000003000000_hidden'] = false;
        break;
        case 140000003000001 :
            $data['fieldset_140000003000001_hidden'] = false;
        break;
        case 140000003000002 : 
            $data['fieldset_140000003000002_hidden'] = false;
        break;
        case 140000003000003 : 
            $data['fieldset_140000003000003_hidden'] = false;
        break; 
    }
    return $data;
}

function peg_dashboard00_dashboard00_12_d_initialize($data, $mmnr01 = '', $mnr01 = '', $_d = '', $container_id = '')
{
    $new_rec = 0;

    if (!($data['nr01'] > 0)) {
        $new_rec = 1;
    }

    

    if(!pegasus_module_exists('dias')){
        $data['module_hidden'] = 2;
        if ($new_rec == 1) {
            $data['nr01']            = pegasus_mysql_newrec('dashboard00_12');
            $data['module']          = 'sme';
            $data['module_readonly'] = 1;
        }else{
            $data['readonly'] = 1;   
        }  
    }
    
    return $data;
}

function peg_dashboard00_dashboard00_13_d00_initialize($data, $mmnr01 = '', $mnr01 = '', $_d = '', $container_id = '')
{
    if (!pegasus_module_exists('dias')) {
        $data['module'] = 'sme';
        $data['module_readonly'] = '1';
    }
    return $data;
}

function dashboard00_dashboard00_13_d_on_delete($data, $permDeny, $checkOnlyPerm)
{
    if ($data['module'] != "sme" and !pegasus_module_exists('dias')) {
        array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_dashboard00_delete_non_sme']));
    }
    return array('data' => $data, 'permDeny' => $permDeny);
}
function dashboard00_dashboard00_10_insert_values($data, $permDeny, $mmnr01, $checkOnlyPerm)
{
    if (!($data['p95'] > 0)) {
        array_push($permDeny, array('type' => 'deny', 'message' => 'Empty p95'));
    }
    if ($data['auto_updated'] == 1 && empty($data['dashboard00_13'])) {
        array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_dashboard00_auto_update_choose_dashboard']));
    } else if ($data['auto_updated'] == 1 && pegasus_mysql_printfld('dashboard00_13', 'module', 'nr01=?', array($data['dashboard00_13'])) == 'sme') {
        array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_dashboard00_auto_update_choose_dashboard']));
    }

    if ($checkOnlyPerm == 0) {
        if ($data['auto_updated'] == 1 && $data['dashboard00_13'] > 0) {
            //Update tmp according to the Dashboard Template
            dashboard00_import_from_dashboard00_13($data['nr01'], $data['dashboard00_13']);
        }
        $dashboard = new Dashboard(array('profile' => $data['p95'], 'dashboard00_10_mmnr01' => $mmnr01));
        $dashboard->create();
    }

    return array('data' => $data, 'permDeny' => $permDeny);
}

function dashboard00_dashboard00_11_check_values($data, $permDeny, $mmnr01)
{
    //TODO: Θα πρέπει να συμληρώνω όλους τους ελέγχους για όλους τους τύπους στοιχείων
    switch ($data['dashboard00_12']) { //Τύπος Στοιχείου
        case '140000108000000': //Button menu
            if (empty($data['p80'])) {
                array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_dashboard00_menu_item_empty_p80']));
            }
            break;
        case '140000003000000':
            if (empty($data['q10'])) { //Button άνοιγμα Window π-Αναφοράς
                array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_dashboard00_menu_item_empty_q10']));
            }
            break;
        case '140000003000001':
            if (empty($data['q10_raw'])) { //Grid με αποτελέσματα π-Αναφοράς
                array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_dashboard00_menu_item_empty_q10']));
            }
            break;
        case '140000003000002':
            if (empty($data['q10_grouped'])) { //Grid με ομαδοποιημένα αποτελέσματα αναφοράς
                array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_dashboard00_menu_item_empty_q10']));
            }
            break;
        case '140000003000003':
            if (empty($data['charts_q10'])) { //Chart
                array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_dashboard00_menu_item_empty_charts_q10']));
            }
            break;
        default:

            break;
    }

    return array('data' => $data, 'permDeny' => $permDeny);
}
/**
 * Η συνάρτηση αυτή θα γεμίσει την variable v_details στο grid των στοιχείων του dashboard
 * ανάλογα με τον τύπο στοιχείου. Το κάναμε για ευκολία ανάγνωσης του grid
 */
function dashboard00_dashboard00_11_d_browse_v_details($tb)
{
    switch ($tb['dashboard00_12']) { //Τύπος Στοιχείου
        case '140000108000000': //Button menu
            return $tb['v_selectbox_p80'];
            break;
        case '140000003000000':
            return $tb['v_selectbox_q10'];
            break;
        case '140000003000001':
            return $tb['v_selectbox_q10_raw'];
            break;
        case '140000003000002':
            return $tb['v_selectbox_q10_grouped'];
            break;
        case '140000003000003':
            return $tb['v_selectbox_charts_q10'];
            break;
        default:
            break;
    }
}


function dashboard00_dashboard00_12_check_values($data, $permDeny, $checkOnlyPerm)
{

    $nr01 = pegasus_mysql_printfld(
        'dashboard00_12',
        'nr01',
        'nr01 = :nr01 and module <> :module',
        array('nr01' => $data['nr01'], 'module' => $data['module'])
    );
    if ($nr01 > 0) {
        array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_dashboard00_deny_module_change']));
    }

    return array('data' => $data, 'permDeny' => $permDeny);
}


function dashboard00_query_q10_d901_make_grid_query($q10_nr01)
{

    $query = query_q10_d901_make_grid_query_replace_q13($q10_nr01);
    return $query;
}

/**
 * This function will read from dashboard00_11_tmp and will create a new dashboard00_13 (Dashboard template)
 */
function dashboard00_export_dashboard00_13_create_new($dashboard00_10_nr01, $module, $p00)
{

    if (!pegasus_module_exists('dias') && $module != 'sme') {
        return array('ok' => 0, 'msg' =>  $_SESSION['peg_dic_dashboard00_only_sme_dashboard'], 'new_nr01' => 0);
    }
    $nr01 = pegasus_mysql_module_newrec('dashboard00_13', $module);
    pegasus_mysql_insert('dashboard00_13', array('nr01', 'module', 'p00'), array($nr01, $module, $p00));

    dashboard00_copy_dashboard00_10_to_dashboard00_13($dashboard00_10_nr01, $nr01, $module);

    return array('ok' => 1, 'msg' => $_SESSION['peg_dic_dashboard00_export_new_success'], 'new_nr01' => $nr01);
}

/**
 * This function will read from dashboard00_11_tmp and will update an existent dashboard00_13 (Dashboard template)
 */
function dashboard00_export_dashboard00_13_update_old($dashboard00_10_nr01, $dashboard00_13_nr01)
{

    pegasus_mysql_use('select * from dashboard00_13 where nr01 = ?', $dashboard00_13, array($dashboard00_13_nr01));
    if (!($dashboard00_13['nr01'] > 0)) {
        return array('ok' => 0, 'msg' => $_SESSION['peg_dic_dashboard00_empty_dashboard00_13'], 'new_nr01' => 0);
    }
    if (!pegasus_module_exists('dias') && $dashboard00_13['module'] != 'sme') {
        return array('ok' => 0, 'msg' => $_SESSION['peg_dic_dashboard00_only_sme_dashboard'], 'new_nr01' => 0);
    }
    pegasus_mysql_delete('dashboard00_14', 'dashboard00_13 = ?', 0, array($dashboard00_13['nr01']));
    dashboard00_copy_dashboard00_10_to_dashboard00_13($dashboard00_10_nr01, $dashboard00_13['nr01'], $dashboard00_13['module']);
    return array('ok' => 1, 'msg' => $_SESSION['peg_dic_dashboard00_export_update_success']);
}
/**
 * This function will import from the default dashboard to peg_tmp_dashboard00_11
 */
function dashboard00_import_from_dashboard00_13($dashboard00_10_nr01, $dashboard00_13_nr01, $tmp = true)
{
    pegasus_mysql_use('select * from dashboard00_13 where nr01 = ?', $dashboard00_13, array($dashboard00_13_nr01));
    if (!($dashboard00_13['nr01'] > 0)) {
        return array('ok' => 0, 'msg' =>  $_SESSION['peg_dic_dashboard00_only_sme_dashboard'], 'new_nr01' => 0);
    }

    if ($tmp) {
        $sqlWhere =
            ' peg_flag!=9 and peg_tmp_dashboard00_11.dashboard00_10=:var_dashboard00_10
            and peg_tmp_dashboard00_11.peg_sess_id=:var_sess_id
            and peg_tmp_dashboard00_11.peg_mmnr01=:var_mmnr01
            and peg_tmp_dashboard00_11.peg_mnr01=:var_mnr01 ';
        $sqlWhereParams  =
            array(
                'var_dashboard00_10' => $dashboard00_10_nr01,
                'var_sess_id' => session_id(),
                'var_mmnr01' =>  'dashboard00_10_d-' . $dashboard00_10_nr01,
                'var_mnr01' => $dashboard00_10_nr01
            );

        pegasus_mysql_update('peg_tmp_dashboard00_11', array('peg_flag'), array('9'), $sqlWhere, 0, 1, 1, $sqlWhereParams);
    } else {
        pegasus_mysql_delete('dashboard00_11', 'dashboard00_10=:var_dashboard00_10', 0, array('var_dashboard00_10' => $dashboard00_10_nr01));
    }

    $query = "select * from dashboard00_14 where dashboard00_13 = ?";
    $result = pegasus_query($query, array($dashboard00_13['nr01']));
    while ($dashboard00_14 = pegasus_fetch($result)) {

        $dashboard00_11 = array();
        $dashboard00_11['nr01'] = pegasus_mysql_newrec('dashboard00_11');
        $dashboard00_11['dashboard00_10'] = $dashboard00_10_nr01;
        $dashboard00_11['dashboard00_12'] = $dashboard00_14['dashboard00_12'];

        $dashboard00_11['p00'] = $dashboard00_14['p00']; //Περιγραφή
        $dashboard00_11['ep00'] = $dashboard00_14['ep00']; //Αγγλική Περιγραφή

        $dashboard00_11['p01'] = $dashboard00_14['p01']; //Διαδοχή
        $dashboard00_11['p02'] = $dashboard00_14['p02']; //Γραμμη
        $dashboard00_11['p03'] = $dashboard00_14['p03']; //Εικαστικό
        $dashboard00_11['p04'] = $dashboard00_14['p04']; //Ύψος

        $dashboard00_11['p80'] = $dashboard00_14['p80']; //Menu
        $dashboard00_11['q10'] = $dashboard00_14['q10']; //Αναφορά
        $dashboard00_11['q10_raw'] = $dashboard00_14['q10_raw']; //Αποτελέσματα Αναφοράς
        $dashboard00_11['q10_grouped'] = $dashboard00_14['q10_grouped']; //Ομαδοποιημένα Αποτελέσματα Αναφοράς
        $dashboard00_11['charts_q10'] = $dashboard00_14['charts_q10']; //Γράφημα

        if ($tmp) {
            $dashboard00_11['peg_flag'] = 1;
            $dashboard00_11['peg_sess_id'] = session_id();
            $dashboard00_11['peg_mmnr01'] = 'dashboard00_10_d-' . $dashboard00_10_nr01;
            $dashboard00_11['peg_mnr01'] = $dashboard00_10_nr01;
            pegasus_mysql_insert('peg_tmp_dashboard00_11', array_keys($dashboard00_11), array_values($dashboard00_11));
        } else {
            pegasus_mysql_insert('dashboard00_11', array_keys($dashboard00_11), array_values($dashboard00_11));
        }

        unset($dashboard00_11);
    }

    return array('ok' => 1, 'msg' => $_SESSION['peg_dic_dashboard00_import_success']);
}

function dashboard00_copy_dashboard00_10_to_dashboard00_13($dashboard00_10_nr01, $dashboard00_13_nr01, $module)
{

    $sqlWhere =
        ' peg_flag!=9 and peg_tmp_dashboard00_11.dashboard00_10=:var_dashboard00_10
    and peg_tmp_dashboard00_11.peg_sess_id=:var_sess_id
    and peg_tmp_dashboard00_11.peg_mmnr01=:var_mmnr01
    and peg_tmp_dashboard00_11.peg_mnr01=:var_mnr01 ';
    $sqlWhereParams  =
        array(
            'var_dashboard00_10' => $dashboard00_10_nr01,
            'var_sess_id' => session_id(),
            'var_mmnr01' =>  'dashboard00_10_d-' . $dashboard00_10_nr01,
            'var_mnr01' => $dashboard00_10_nr01
        );


    $query = "select * from peg_tmp_dashboard00_11 where " . $sqlWhere;
    $result = pegasus_query($query, $sqlWhereParams);
    while ($peg_tmp_dashboard00_11 = pegasus_fetch($result)) {
        $dashboard00_14 = array();
        $dashboard00_14['nr01'] = pegasus_mysql_module_newrec('dashboard00_14', $module);
        $dashboard00_14['module'] = $module;
        $dashboard00_14['dashboard00_13'] = $dashboard00_13_nr01;
        $dashboard00_14['dashboard00_12'] = $peg_tmp_dashboard00_11['dashboard00_12'];

        $dashboard00_14['p00'] = $peg_tmp_dashboard00_11['p00']; //Περιγραφή
        $dashboard00_14['ep00'] = $peg_tmp_dashboard00_11['ep00']; //Αγγλική Περιγραφή

        $dashboard00_14['p01'] = $peg_tmp_dashboard00_11['p01']; //Διαδοχή
        $dashboard00_14['p02'] = $peg_tmp_dashboard00_11['p02']; //Γραμμη
        $dashboard00_14['p03'] = $peg_tmp_dashboard00_11['p03']; //Εικαστικό
        $dashboard00_14['p04'] = $peg_tmp_dashboard00_11['p04']; //Ύψος

        $dashboard00_14['p80'] = $peg_tmp_dashboard00_11['p80']; //Menu
        $dashboard00_14['q10'] = $peg_tmp_dashboard00_11['q10']; //Αναφορά
        $dashboard00_14['q10_raw'] = $peg_tmp_dashboard00_11['q10_raw']; //Αποτελέσματα Αναφοράς
        $dashboard00_14['q10_grouped'] = $peg_tmp_dashboard00_11['q10_grouped']; //Ομαδοποιημένα Αποτελέσματα Αναφοράς
        $dashboard00_14['charts_q10'] = $peg_tmp_dashboard00_11['charts_q10']; //Γράφημα

        pegasus_mysql_insert('dashboard00_14', array_keys($dashboard00_14), array_values($dashboard00_14));

        unset($dashboard00_14);
    }
}

function dashboard00_remake_all_dashboard_screens()
{
    $all_dashboards =
        "select dashboard00_10.* from dashboard00_10 
     join dashboard00_13 on dashboard00_13.nr01 = dashboard00_10.dashboard00_13";

    $result = pegasus_query($all_dashboards);
    while ($dashboard00_10 = pegasus_fetch($result)) {
        $dashboard = new Dashboard(array('profile' => $dashboard00_10['p95']));
        $dashboard->create();
    }
}

function dashboard00_reset_all_auto_updated_dashboard()
{
    $all_auto_updated_dashboards =
        "select dashboard00_10.* from dashboard00_10 
     join dashboard00_13 on dashboard00_13.nr01 = dashboard00_10.dashboard00_13
     where auto_updated = 1 and dashboard00_13.module<>'sme'";

    $result = pegasus_query($all_auto_updated_dashboards);
    while ($dashboard00_10 = pegasus_fetch($result)) {
        dashboard00_import_from_dashboard00_13($dashboard00_10['nr01'], $dashboard00_10['dashboard00_13'], false);
        $dashboard = new Dashboard(array('profile' => $dashboard00_10['p95']));
        $dashboard->create();
    }
}
function dashboard00_reset_auto_updated_dashboard_of_profile($profile)
{
    if (empty($profile) || !(pegasus_mysql_printfld('p95', 'nr01', 'nr01=?', array($profile)) > 0)) {
        return;
    }
    $auto_updated_dashboard =
        "select dashboard00_10.* from dashboard00_10 
        join dashboard00_13 on dashboard00_13.nr01 = dashboard00_10.dashboard00_13
        where auto_updated = 1 and dashboard00_13.module<>'sme' and dashboard00_10.p95=:profile";

    $result = pegasus_query($auto_updated_dashboard, array('profile' => $profile));
    while ($dashboard00_10 = pegasus_fetch($result)) {
        //Έβαλα το while για να μην χρειαστεί να ελέγξω αν είναι empty κοκ. To query θα πρέπει να φέρνει πάντα μόνο ένα αποτέλεσμα
        dashboard00_import_from_dashboard00_13($dashboard00_10['nr01'], $dashboard00_10['dashboard00_13'], false);
        $dashboard = new Dashboard(array('profile' => $dashboard00_10['p95']));
        $dashboard->create();
    }
}

function dashboard00_open_menu_item_JScode($p80_nr01)
{
    pegasus_mysql_use('select * from p80 where nr01 = ?', $p80, array($p80_nr01));

    if(!empty($p80['view_d'])){
        return
            "WebApp.view.treePanel.column.MenuItem.pegExecuteAction('','',{
                act:'" . $p80['act'] . "',
                urlparams:'" . eval($p80['urlparams']) . "',
                view_module:'" . $p80['view_module'] . "',
                view_d:'" . $p80['view_d'] . "',
                view_table:'" . $p80['view_table'] . "',
                text:'" . $p80['text'] . "',
                enable_quick_find:'" . $p80['full_text_search'] . "',
                browse_copy:'" . $p80['copy_recs'] . "',
                browse_edit:'" . $p80['browse_edit'] . "',
                view_groupby:'" . $p80['view_groupby'] . "',
                view_orderby:'" . $p80['view_orderby'] . "'
            });";
    } else if (!empty($p80['handler_js'])) {
        $tmp =  @eval($p80['handler_js']);
        if ($tmp  === false && ($error = error_get_last())) {
            if (pegasus_displayErrors()) {
                print_r($p80);
                var_dump($error);
            }
            die('Error in eval');
        }
        return $tmp;
    }

}

function dashboard00_main_d_show_dashboard()
{
    pegasus_mysql_use('select count(*) as cnt from dashboard00_10',$result);
    if($result['cnt']>0){
        return true;
    }
    return false;
}
function dashboard00_get_app_updates(
    $page = 0,
    $container_id = ''
) {
    $upgrades_available=0;
    try {
        $json_response = pegasus_curl_request('http://update.pegcloud.io/is_alive.php', false,  array(), array(CURLOPT_TIMEOUT => 4));
    } catch (Exception $ex) {
        $json_response = false;
    }
    if( !empty($json_response) and  $json_response=='true') {
        $service_name = 'pegcloud.io';
        $url = "http://update.pegcloud.io/pegasus/update_ver5/execute.php";
    }else{
        $service_name = 'tesae.gr';
        $url = "https://update.tesae.gr/pegasus/update_ver5/execute.php";
    }
    $data = array(
        'html'  => ''
    );
	$sn			= 'Π'.pegasus_leading_zeros($_SESSION['cor000_sn'], 7);
    $user = $_SESSION['cor000_tesae_user'];
    $pass = $_SESSION['cor000_tesae_pass'];
    $app_code = $_SESSION['cor000_app_code'];
    $sid = '';
    // Login to service
	$params = array(
		'action'	=> 'login',
		'user'		=> $user,
		'pass'		=> $pass,
		'sn'		=> $sn,
		'un'		=> 1
	);
    try {
	    $resp = pegasus_curl_request_post($url,$params,false,array(),array(CURLOPT_TIMEOUT => 10));
    } catch (Exception $ex) {
        $resp = false;
    }
	$xml = simplexml_load_string($resp);
	if($xml->code == '100'){
        $sid = $xml->sid;
        $versions = array();
        $sql =" SELECT 
                    p00 AS module_name,
                    ver  AS module_version,
                    rel AS module_release
                FROM p55
                WHERE en = 1
        ";
        $res = pegasus_query($sql);
        while($rs = pegasus_fetch_assoc($res)) {
            $versions['modules'][$rs['module_name']] = array(
                    'version'   => intval($rs['module_version']) * 100,
                    'release'   => $rs['module_release']
            );
        }
        $en = 1;
        if($_SESSION['lang']=='GR')
        {
            $en = 0;
        }
		$params = array(
			'action'	=> 'getAllUpdatesHistory',
			'sid'		=> $sid,
            'versions'  => json_encode($versions),
            'en'        => $en,
            'page'      => $page,
            'recperpage'=> 20
		);
        try {
            $resp = pegasus_curl_request_post($url,$params);
        } catch (Exception $ex) {
            $resp = false;
        }
		$xml = simplexml_load_string($resp);
		if($xml->code == 701){
            $getAllUpdatesHistory = $xml->getAllUpdatesHistory;
            $getAllUpdatesHistory = json_decode(base64_decode($getAllUpdatesHistory),true);

            $template = peg_read_file('../dashboard00_templates/dashboard00_peg_app_update.html');
            $cat_template =  pegasus_get_text_inside_tags('<!--cat start-->','<!--cat end-->',$template);
            $row_template = pegasus_get_text_inside_tags('<!--row start-->','<!--row end-->',$cat_template);
            $btn_template = pegasus_get_text_inside_tags('<!--nextPage start-->','<!--nextPage end-->',$template);
            $alert_template = pegasus_get_text_inside_tags('<!--alert start-->','<!--alert end-->',$template);
            $last_state = -1;
            $cat = array();
            $rows = '';
            $greekMonthsSort = array(
                '01'=>'Ιαν',
                '02'=>'Φεβ',
                '03'=>'Μαρ',
                '04'=>'Απρ',
                '05'=>'Μάι',
                '06'=>'Ιουν',
                '07'=>'Ιουλ',
                '08'=>'Αυγ',
                '09'=>'Σεπτ',
                '10'=>'Οκτ',
                '11'=> 'Νοε',
                '12'=> 'Δεκ'
            );
            $last_date  = '';
            $alert_html = '';
            foreach($getAllUpdatesHistory['data'] as $v) {
                if(empty($v['title'])) {
                    continue;
                }
                if(
                    $v['pending_update']
                    && $page == 0
                ) {
                    $link = "javascript: peg002_addTab_d('', '', '_upd_app_d', 'core', '');";
                    $message = '<div class="peg_alert_warning_plain" style="padding:10px 5px; text-align: center;">';
                    $message .= str_replace(
                        "#link#",
                        $link,
                        $_SESSION['peg_dic_dashboard00_app_update_upgrades_available']
                    );
                    $message .= '</div>';
                    $alert_html = str_replace(
                        '#alert_message#',
                        $message,
                        $alert_template
                    );
                    if($v['trigger_update_screen']==1){
                        $upgrades_available=1;
                    }
                }
                if($last_state != -1 && $v['pending_update'] != $last_state) {
                    $ico = $last_state == 1 ? 'fas fa-wrench' : 'fas fa-history';
                    $title = $last_state == 1 ? 'Εκκρεμείς Αναβαθμίσεις':'Ιστορικό Αναβαθμίσεων';
                    $cat[] = str_replace(
                        array(
                            "#cat-ico#",
                            "#cat-title#",
                            $row_template
                        ),
                        array(
                            $ico,
                            $title,
                            $rows
                        ),                        
                        $cat_template
                    );
                    $rows = '';
                    $last_state = $v['pending_update'];
                } elseif($last_state == -1) {
                    $last_state = $v['pending_update'];
                }
                $title = $v['title'];
                $desc = $v['description'];
                $desc = str_replace(
                    '<ol>',
                    '<ol style="margin: 0 0 1px 15px; padding:0">',
                    $desc
                );
                if($v['date'] != $last_date){
                    $day = peg_dateToStr($v['date'],'d');
                    $month = $greekMonthsSort[peg_dateToStr($v['date'],'m')];    
                }
                else{
                    $day = '';
                    $month = '';
                }
                $rows .= str_replace(
                    array(
                        '#row-title#',
                        '#row-desc#',
                        '#day#',
                        '#month#'
                    ),
                    array(
                        $title,
                        $desc,
                        $day,
                        $month
                    ),
                    $row_template
                );
                $last_date = $v['date'];
            }
            $ico = $last_state == 1 ? 'fas fa-wrench' : 'fas fa-history';
            $title = $last_state == 1 ? 'Εκκρεμείς Αναβαθμίσεις':'Ιστορικό Αναβαθμίσεων';
            $cat[] = str_replace(
                array(
                    "#cat-ico#",
                    "#cat-title#",
                    $row_template
                ),
                array(
                    $ico,
                    $title,
                    $rows
                ),                        
                $cat_template
            );
            $html = str_replace(
                $cat_template,
                implode('',$cat),
                $template
            );            
            $page ++;
            $href = "javascript:dashboard00_get_app_updates('$container_id',$page)";
            $data['html'] .= '<!--next-page--><a href="'.$href.'">Next Page</a>';
            
            $btn = str_replace(
                array(
                    '#more-upcoming#',
                    'href="#"'
                ),
                array(
                    $_SESSION['peg_dic_dashboard00_more_upcoming'],
                    'href="'.$href.'"',
                ),                
                $btn_template
            );

            $html = str_replace(
                array(
                    $alert_template,
                    $btn_template,
                ),
                array(
                    $alert_html,
                    $btn,
                ),
                $html
            );

            $data['html'] = $html;
        }
        $params = array(
            'action'	=> 'sessionDestroy',
            'sid'		=> $sid
        );
        
        try {
            $resp = pegasus_curl_request_post($url,$params);
        } catch (Exception $ex) {
            $resp = false;
        }
    }
    return array(
        'ok'    => 1,
        'error' => null,
        'data'  => $data,
        'msg'   => 'Success',
        'upgrades_available'=> $upgrades_available
    );
}
function dashboard00_peg_app_info($dashboads10_nr01 = 0) {

    try {
        $json_response = pegasus_curl_request('https://services00.pegcloud.io/is_alive.php', false,  array(), array(CURLOPT_TIMEOUT => 4));
    } catch (Exception $ex) {
        $json_response = false;
    }

    if( !empty($json_response) and  $json_response=='true') {
        $service_name = 'pegcloud.io';
        $url = "https://services00.pegcloud.io/peg_app_info/execute.php";
    }else{
        $service_name = 'tesae.gr';
        $url = "https://services.tesae.gr/peg_app_info/execute.php";
    }
    $data = array(
        'html'  => ''
    );
	$sn			= 'Π'.pegasus_leading_zeros($_SESSION['cor000_sn'], 7);
    $user = $_SESSION['cor000_tesae_user'];
    $pass = $_SESSION['cor000_tesae_pass'];
    $app_code = $_SESSION['cor000_app_code'];
    $sid = '';
    // Login to service
	$params = array(
		'action'	=> 'login',
		'user'		=> $user,
		'pass'		=> $pass,
		'sn'		=> $sn,
		'un'		=> 1
	);
    try {
        $resp = pegasus_curl_request_post($url,$params,false,array(),array(CURLOPT_TIMEOUT => 10)); 
    } catch (Exception $ex) {
        $resp = false;
    }

	$xml = simplexml_load_string($resp);
	if($xml->code == '100'){
        $sid = $xml->sid;
		$params = array(
			'action'	=> 'get_app_info',
			'sid'		=> $sid,
			'sn'		=> $sn,
			'app_code'	=> $app_code
		);
        try {
            $resp = pegasus_curl_request_post($url,$params);
        } catch (Exception $ex) {
            $resp = false;
        }
		$xml = simplexml_load_string($resp);
		if($xml->code==200){
            $lang=strtolower($_SESSION['lang']);
            if($lang == 'gr' ) {
                $lang = 'el';
            } else {
                $lang = 'en';
            }
			$xml_data = json_decode(base64_decode($xml->data),true);
            $tmpl = peg_read_file('../dashboard00_templates/dashboard00_peg_app_info.html');
            $tmpl_cat = pegasus_get_text_inside_tags('<!--cat_start-->', '<!--cat_end-->',$tmpl);
            $tmpl_cat_title = pegasus_get_text_inside_tags('<!--title_start-->', '<!--title_end-->',$tmpl_cat);
            $cat_html = '';
            $cat_title_html = '';
            $data['raw_value']=$xml_data;
			foreach($xml_data as $cat) {
                if(!empty($cat['cat'][$lang])){
                    $cat_title_html = str_replace('##title##',$cat['cat'][$lang],$tmpl_cat_title);
                }
                
                $cat_html .= str_replace($tmpl_cat_title,$cat_title_html,$tmpl_cat);



                $tmpl_arg = pegasus_get_text_inside_tags('<!--arg_start-->', '<!--arg_end-->',$tmpl_cat);
                $arg_html='';
                $arg_iterator = 0;
                if(!isset($cat['data'])){
                    continue;
                }
                foreach($cat['data'] as $v) {
                    $key = '';
                    if(!empty($v['label_'.$lang])) {
                        $key = $v['label_'.$lang].": ";
                    }
                    $value = $v['value'];
                    if($v['type'] == 'field') {
                        if(empty($cat['cat'][$lang]) && empty($v['label_'.$lang])) {
                            $arg_html .= $value;
                        }
                        else {
                            $arg_html .= str_replace(array('##key##','##value##'),array($key,$value),$tmpl_arg);
                        }
                        
                    }
                    if($v['name']=='disk_usage_info' && function_exists('pegasus_set_app_info_var')){
                        pegasus_set_app_info_var($v['raw_value']);
                    }
                    $arg_html = str_replace(array('##i##'),array( $arg_iterator%2 ),$arg_html);
                    $arg_iterator ++;
                }
                $cat_html = str_replace($tmpl_arg,$arg_html,$cat_html);
			}
            $tmpl = str_replace($tmpl_cat,$cat_html,$tmpl);

            $service_name_template = peg_read_file('../dashboard00_templates/dashboard00_peg_app_info_service_name.html');
            $tmpl .= str_replace('##serviceName##',$service_name,$service_name_template);
           
            $tmpl = '<div class="app_info_panel">'.$tmpl.'</div>';

        
			$data['html'].=$tmpl;
           // $data['src'] = $url;
		}
        $params = array(
            'action'	=> 'sessionDestroy',
            'sid'		=> $sid
        );
        try {
            pegasus_curl_request_post($url,$params);
        } catch (Exception $ex) {
            
        }
        return array(
            'ok'    => 1,
            'error' => null,
            'data'  => $data,
            'msg'   =>'Success'
        );
	}
    return array(
        'ok'    => 1,
        'error' => null,
        'data'  => array(
            'html'  => '<div class="alert_message">' .$_SESSION['peg_dic_dashboard00_peg_app_info_error']. '</div>'
        ),
        'msg'   => 'Abort'
    );
}
function dashboard00_after_update()
{

    pegasus_mysql_use('select rel, ver from p55 where p00="dashboard00"', $version);

    $dashboard00_10_nr01 = pegasus_mysql_printfld('dashboard00_10', 'nr01', 'p95=?', array('140000000000002'));
    if (empty($dashboard00_10_nr01) || !($dashboard00_10_nr01 > 0)) {
        if (pegasus_module_exists('hot000')) {
            if (pegasus_mysql_printfld('dashboard00_13', 'nr01', 'nr01=?', array('140000036000000')) == '140000036000000') {
                $dashboard00_10 = array();
                $dashboard00_10['nr01'] = pegasus_mysql_newrec('dashboard00_10');
                $dashboard00_10['p95'] = '140000000000002';
                $dashboard00_10['dashboard00_13'] = '140000036000000';
                $dashboard00_10['auto_updated'] = 1;
                pegasus_mysql_insert('dashboard00_10', array_keys($dashboard00_10), array_values($dashboard00_10));
            }
        } else if (pegasus_module_exists('courier00')) {
        } else if (pegasus_module_exists('champion')) {
        } else if (pegasus_module_exists('tran')) {
            if (pegasus_mysql_printfld('dashboard00_13', 'nr01', 'nr01=?', array('140000083000001')) == '140000083000001') {
                $dashboard00_10 = array();
                $dashboard00_10['nr01'] = pegasus_mysql_newrec('dashboard00_10');
                $dashboard00_10['p95'] = '140000000000002';
                $dashboard00_10['dashboard00_13'] = '140000083000001';
                $dashboard00_10['auto_updated'] = 1;
                pegasus_mysql_insert('dashboard00_10', array_keys($dashboard00_10), array_values($dashboard00_10));
            }
        } else if (pegasus_module_exists('estiasi')) {
            if (pegasus_mysql_printfld('dashboard00_13', 'nr01', 'nr01=?', array('140000091000000')) == '140000091000000') {
                $dashboard00_10 = array();
                $dashboard00_10['nr01'] = pegasus_mysql_newrec('dashboard00_10');
                $dashboard00_10['p95'] = '140000000000002';
                $dashboard00_10['dashboard00_13'] = '140000091000000';
                $dashboard00_10['auto_updated'] = 1;
                pegasus_mysql_insert('dashboard00_10', array_keys($dashboard00_10), array_values($dashboard00_10));
            }
        } else if (pegasus_module_exists('courier05')) {
        } else if (pegasus_module_exists('gov00')) {
        } else if (pegasus_module_exists('weddings')) {
        } else if (pegasus_module_exists('vehicle')) {
        } else if (pegasus_module_exists('ordercust') || pegasus_module_exists('invcust')) {
            if (pegasus_mysql_printfld('dashboard00_13', 'nr01', 'nr01=?', array('140000009000000')) == '140000009000000') {
                $dashboard00_10 = array();
                $dashboard00_10['nr01'] = pegasus_mysql_newrec('dashboard00_10');
                $dashboard00_10['p95'] = '140000000000002';
                $dashboard00_10['dashboard00_13'] = '140000009000000';
                $dashboard00_10['auto_updated'] = 1;
                pegasus_mysql_insert('dashboard00_10', array_keys($dashboard00_10), array_values($dashboard00_10));
            }
        }
    }

    //ενημέρωση freelancer όπου δεν είχε ελεγχθεί ότι ήταν προεπιλεγμένο το dashboard
    if ($version['ver'] == 1 && $version['rel'] <= 29) {
        $is_freelancer = pegasus_mysql_printfld('cor000', 'nr01', 'app_code="PC.16.00.00"');
        if ($is_freelancer > 0) {
            pegasus_mysql_update('dashboard00_10', array('auto_updated'), array('1'), 'dashboard00_13 = 140000009000000');
            dashboard00_remake_all_dashboard_screens();
        }
    }
    if ($version['ver'] == 1 && $version['rel'] <= 35) {
        dashboard00_remake_all_dashboard_screens();
    }

    if ($version['ver'] == 1 && $version['rel'] <= 45) {
        if(file_exists('../dashboard00_tempaltes/dashboard00_peg_app_info.html')) {
            unlink('../dashboard00_tempaltes/dashboard00_peg_app_info.html');
            rmdir('../dashboard00_tempaltes/');
        }
    }

    if ($version['ver'] == 1 && $version['rel'] <= 55) {

        $all_profiles = "select nr01 from p95";
        $result = pegasus_query($all_profiles);
        //Διαγράφω τα dashboard με τις παλιές ονομασίες. Πλέον δεν έχω καρφωτα ονομαασίες αλλά από την dashboard00_find_screen_name
        while ($p95 = pegasus_fetch($result)) {
            if(
                $p95['nr01'] == 10 || 
                $p95['nr01'] == 11 || 
                $p95['nr01'] == 12 || 
                $p95['nr01'] == 13 ||  
                $p95['nr01'] == 14 )
                {
                    //Είναι οι standard οθόνες του dashboard που δεν θέλω να διαγραφούν
                    continue;
                }
            $dashboard_name = 'dashboard00_'. $p95['nr01'].'_d';
            pegasus_mysql_delete('p52', 'p02=? and module=?', 0, array($dashboard_name, 'dashboard00'));
            pegasus_mysql_delete('p51', 'p02=? and module=?', 0, array($dashboard_name, 'dashboard00'));
            pegasus_mysql_delete('p50', 'p02=? and module=?', 0, array($dashboard_name, 'dashboard00'));
        }
        dashboard00_remake_all_dashboard_screens();
    }



}

/**
 * Η συνάρτηση αυτή βρίσκει το όνομα για το profile που περνάει ως παράμετρος. 
 * Αν η παράμετρος ειναι κενή βρίσκει το dashboard για το προφίλ του SESSION
 * Έχω και την αντίστοιχη js με το ίδιο όνομα - αν αλλάξω κάτι εδω να το αλλάξω και εκεί
 * @param int $profile 
 * @return string 
 */
function dashboard00_find_screen_name($profile = 0){

    if (empty($profile)) {
        $profile = $_SESSION['user_profile'];
    }
    if(empty($profile)){
        return '';    
    }
    return 'dashboard00_screen_'. $profile.'_d';
    
}