<?php

abstract class DashboardElement
{
    protected $_d; //p51.p02
    protected $profile;

    protected $name; //p51.name
    protected $title; //p51.desc02
    protected $eTitle; //p51.edesc02
    protected $screenIndex; //p51.desc06
    protected $view_type; //p51.desc07
    protected $field_type; //p51.desc16
    protected $peg_cssClass; 

    protected $p52; // $this->p52[par_nm] = array('par_val' => value , 'code' => (1 || 0 ) ); ;
    protected $container; //p52.fieldset
    protected $height; //p52.height

    protected $dashboard00_11_row;

    public function __construct($params_array)
    {
        $this->_d = $params_array['_d'];
        $this->profile = $params_array['profile'];
        $this->container = $params_array['container'];
        $this->name = $params_array['name'];
        $this->title = $params_array['dashboard00_11_row']['p00'];
        $this->eTitle = $params_array['dashboard00_11_row']['ep00'];
        $this->screenIndex = $params_array['screenIndex'];
        $this->peg_cssClass = $params_array['dashboard00_11_row']['p03'];
        $this->height = $params_array['dashboard00_11_row']['p04'];

        $this->dashboard00_11_row = $params_array['dashboard00_11_row']; //Περνάω ολόκληρη την εγγραφή του dashboard00_11

        $this->p52 = array();
        $this->p52['fieldset'] = array('par_val' => $this->container, 'code' => 0);
        $this->p52['style'] = array('par_val' => " marginLeft: '10px', marginTop: '10px', marginRight: '10px'", 'code' => 0);
        $this->p52['flex'] = array('par_val' => "1", 'code' => 0);
        $this->p52['peg_cssClass'] = array('par_val' => $this->peg_cssClass, 'code' => 0);
        if ($this->height > 0) {
            $this->p52['height'] = array('par_val' => $this->height, 'code' => 0);
        }
    }


    public function create()
    {
        $arr = array();
        $module = "dashboard00";
        $arr['nr01'] =  pegasus_mysql_newrec('p51');
        $arr['p02'] = $this->_d;
        $arr['module'] = $module;
        $arr['desc02'] = $this->title;
        $arr['edesc02'] = $this->eTitle;
        $arr['desc05'] = $this->name;
        $arr['desc07'] = $this->view_type; //view type
        $arr['desc06'] = $this->screenIndex; //Screen Index
        $arr['desc16'] = isset($this->field_type) ? $this->field_type : ''; //Τύπος πεδίου

        $arr['desc17'] = 0; //Μέγεθος πεδίου
        $arr['desc18'] = 0; //Δεκαδικά       
        $arr['desc13'] = 0; //Browse Index
        $arr['desc131'] = 0; //Property Browse Index
        $arr['desc08'] = 0; //Sorted Index
        $arr['desc99'] = 0; //Empty On Copy
        $arr['desc98'] = 0; //Enable Quick Find
        $arr['desc14'] = ''; //Index Expression

        pegasus_mysql_insert('p51', array_keys($arr), array_values($arr));

        $p52 = array();
        $p52['p02'] = $this->_d; //_d
        $p52['desc05'] = $this->name; //Όνομα πεδίου
        $p52['desc07'] = $this->view_type; //Τύπος πεδίου
        $p52['module'] = $module;
        foreach ($this->p52 as $par_nm => $par_val_arr) {
            $p52['nr01'] =  pegasus_mysql_newrec('p52');
            $p52['par_nm'] = $par_nm;
            $p52['par_val'] = $par_val_arr['par_val'];
            $p52['code'] = $par_val_arr['code'];
            $p52['par_val_js'] = isset($par_val_arr['par_val_js']) ? $par_val_arr['par_val_js'] : '';
            pegasus_mysql_insert('p52', array_keys($p52), array_values($p52));
        }
    }
    /**
     * Η συνάρτηση γίνεται override από όλες τις κλάσεις παιδιά 
     * και αρχικοποιεί π.χ. το p52 με βάση τον τύπο στοιχείου του
     */
    abstract protected function InitializeFromType();

    /** 
     * Θα γίνεται override από όλες τις κλάσεις παιδιά 
     * Θα ελέγχει αν το element μπορεί να εμφανιστεί ή όχι στο συγκεκριμένο profil
     * @return true||false
     */
    public function CheckPermission()
    {
        //Δεν την έχω κάνει abstract για να μην χτυπήσουν τα updates 
        //για τα modules που κάνουν extend αυτήν την κλάση. 
        return true;
    }
    //Το κάνω με update στη βάση για αρχή και το βλέπω πως θα μπορούσε να γίνει πιο έξυπνα.
    public function appendToScreenInitialize($phpCode)
    {

        $p50_nr01 = pegasus_mysql_printfld(
            "p50",
            "nr01",
            "p02=:p02 and module=:module",
            array('p02' => $this->_d, 'module' => 'dashboard00')
        );

        if (!($p50_nr01 > 0)) { //Δεν μπορεί να μην υπάρχει. Πρώτα δημιουργείται η οθόνη και μετά όλα τα fields
            die("Screen not Created successfully");
        }

        $p50_p44 = pegasus_mysql_printfld(
            "p50",
            "p44",
            "p02=:p02 and module=:module",
            array('p02' => $this->_d, 'module' => 'dashboard00')
        );

        $comment = "/* Init for " . $this->name . "*/\n";

        $p50_p44 = $p50_p44 . $comment . $phpCode . "\n\n";

        pegasus_mysql_update(
            "p50",
            array('p44'),
            array($p50_p44),
            "p02=:p02 and module=:module",
            0,
            1,
            1,
            array('p02' => $this->_d, 'module' => 'dashboard00')
        );
    }
}
