<?php

class DashboardShowTab extends DashboardElement
{
	private $is_empty;

	public function __construct($params_array)
	{
		parent::__construct($params_array); //Θα σετάρει το p52[fieldset]
		$this->view_type = 'tab';
		$this->is_empty = true;

		$this->InitializeFromType();

		$this->p52['title'] = array('par_val' => $this->title, 'code' => 0);
		$this->p52['eTitle'] = array('par_val' => $this->eTitle, 'code' => 0);

		//$this->p52['preventHeader'] = array('par_val' => "false", 'code' => 0);
	}
	public function create()
	{
		if (!$this->is_empty) {
			parent::create();
		}
	}

	protected function InitializeFromType()
	{
		$dashboard_grid_tabs=array();
		// Need to move this to loeader function
		$modules_with_dashboard_tabs=array(
			array('name'=>'tran','handler' => 'tran_dashboard_initialize_constructor'),
			array('name'=>'hot000','handler' => 'hot000_dashboard_initialize_constructor'),
			array('name'=>'crm002','handler' => 'crm002_dashboard_initialize_constructor'),
			array('name'=>'ordercust','handler' => 'ordercust_dashboard_initialize_constructor')
		);
		$tab_data=array();
		foreach($modules_with_dashboard_tabs as $module) {
			// Get module handler (if exists...)
			if(
				pegasus_module_exists($module['name'])
				&& function_exists($module['handler'])
			) {
				$module_handler = $module['handler']();
				if(!empty($module_handler['grid_tabs'])) {
					$tab_data[] = $module_handler['grid_tabs'];
				}
			}
		}
		$this->appendToScreenInitialize(
			"\n/* DashboardShowTab */\n"
			.'$tab_data = '."'".json_encode($tab_data)."';"."\n"
			."\n"
		);
		foreach($modules_with_dashboard_tabs as $module) {
			// Get module handler (if exists...)
			if(
				pegasus_module_exists($module['name'])
				&& function_exists($module['handler'])
			) {
				$module_handler = $module['handler']();
				// Append tabs to main tab array and update is_empty flag (if any...)
				if(!empty($module_handler['grid_tabs'])) {
					$dashboard_grid_tabs=array_merge($dashboard_grid_tabs,$module_handler['grid_tabs']);
					$this->is_empty = false;
				}
				// Append code (sum initialize function) to initiaze function (if exists...)
				if(
					!empty($module_handler['initialize_provider'])
					&& function_exists($module_handler['initialize_provider'])
				) {
					$this->appendToScreenInitialize(
						"\n/* Module ".$module['name']."*/\n"
						.'$ret = '.$module_handler['initialize_provider'].'($data, $mmnr01, $mnr01, $_d, $container_id,$tab_data);'."\n"
						.'$data=$ret["data"];'."\n"
						.'$tab_data=$ret["tab_data"];'."\n"
						."\n"
					);
				}
			}
		}
		//  Create tab array eval (items_array)
		$p52_items_array_str = '$arr1= array();' . "\n";
		$p52_save_d_string=array();
	   	$p52_help_d_string=array();
		foreach($dashboard_grid_tabs as $tab) {
			$p52_items_array_str .= 'array_push($arr1, array(\'_d\' => \''.$tab['_d'].'\' ,  \'load_on_render\'=> 1, \'module\' =>\''.$tab['module'].'\' ';
			if(!empty($tab['custom_id'])) {
				$p52_items_array_str .= ',\'custom_id\' =>\''.$tab['custom_id'].'\' ';
			}
			$p52_items_array_str .= "));\n";
			$p52_save_d_string[]=$tab['_d'];
		  	$p52_help_d_string[]=$tab['module']."#".$tab['_d'];
		}
		$p52_items_array_str .= 'return peg002_create_tab_items_array($arr1, $container_id, $module,$_d, $table, $nr01);';
		$this->p52['items_array']   = array('par_val' => $p52_items_array_str, 'code' => 1);
	   $this->SetParentScreenSave($p52_save_d_string);
	   $this->SetParentScreenHelp($p52_help_d_string);
	}
	private function SetParentScreenSave($p52_save_d_string = array()) {
		$values=array(
			'module'    => 'dashboard00',
			'p02'       => $this->_d,
			'desc05'    => 'screen',
			'desc07'    => 'screen',
			'par_nm'    => 'save_d_string',
			'par_val'	=> implode(',',$p52_save_d_string),
		);
		pegasus_mysql_insert(
			'p52',
			array_keys($values),
			array_values($values),
			1,0,0,1
		);
	}
	private function SetParentScreenHelp($p52_help_d_string = array()) {
		$values=array(
			'nr01'		=> pegasus_mysql_newrec('p52'),
			'module'    => 'dashboard00',
			'p02'       => $this->_d,
			'desc05'    => 'screen',
			'desc07'    => 'screen',
			'par_nm'    => 'help_d_string',
			'par_val'	=> implode(',',$p52_help_d_string),
		);
		pegasus_mysql_insert(
			'p52',
			array_keys($values),
			array_values($values),
			1,0,0,1
		);
	}
}
