<?php
/**
 * Αν υπάρχει auth_cd επιστρέφει το url της ηλεκτρονικής τιμολόγησης, αλλιώς empty string.
 *
 * @param string $auth_cd
 *
 * @return string $url
 */
function einv_get_qrcode_url(
	$auth_cd = '',
	$mydt10_nr01 = 0
) {
	$base = 'e-invoicing.pegcloud.io';
	if(!empty($_SESSION['cor011_einv_user_api_url'])) {
		if(strpos($_SESSION['cor011_einv_user_api_url'],'e-invoicing-api-dev.pegcloud.io') !== false) {
			$base = 'e-invoicing-dev.pegcloud.io';
		}
		if(strpos($_SESSION['cor011_einv_user_api_url'],'e-invoicing-api-dev01.pegcloud.io') !== false) {
			$base = 'e-invoicing-dev01.pegcloud.io';
		}
		if(strpos($_SESSION['cor011_einv_user_api_url'],'e-invoicing-api-dev02.pegcloud.io') !== false) {
			$base = 'e-invoicing-dev02.pegcloud.io';
		}
	}
	$uri = "$base/pegasus/einv02/search_invoice01.php";
	if (!empty($auth_cd)) {
		return "$uri?auth_code=$auth_cd";
	}
	return einv_get_temp_code($uri,$mydt10_nr01);
}
function einv_get_temp_code(
	$uri = '',
	$mydt10_nr01 = 0
) {
	$sql = "	SELECT 
					nr01,
					tbl,
					tbl_nr01,
					is_vat,
					issuedate,
					is_branch,
					invtype,
					series,
					aa,
					tr_fail
				FROM mydt10
				WHERE 1 = 1
				AND nr01 = :nr01 
				AND p102 = 0
	";
	$mydt10 = array();
	pegasus_mysql_use($sql, $mydt10, array('nr01' => $mydt10_nr01));
	// εμφανιζουμε temp_url μονο στην περιπτωση που tr_fail = 0. 
	// θυμιζω, υπάρχει περίπτωση να έχω κενό auth_code σε tr_fail = 2 όταν έχει επιχειρησιακο λαθος και έχει περάσει από tr_fail=2
	if (
		!($mydt10['nr01'] > 0)
		|| $mydt10['tr_fail'] != 0
	) {
		return '';
	}
	$einv01_nr01 = einv00_check_settings($mydt10['tbl'],$mydt10['tbl_nr01']);
	if (!($einv01_nr01 > 0)) {
		return '';
	}
	$einv01_p00 = pegasus_mysql_printfld('einv01','p00','nr01 = :nr01',array('nr01' => $einv01_nr01));
	if (empty($einv01_p00)) {
		return '';
	}
	$offline_data = array(
		'issuer_vat'    => $mydt10['is_vat'],
		'issue_date'    => peg_dateToStr($mydt10['issuedate'],'Ymd'),
		'issuer_branch' => $mydt10['is_branch'],
		'invoice_type'  => $mydt10['invtype'],
		'series'        => $mydt10['series'],
		'aa'            => $mydt10['aa']
	);
	$string = implode(';', $offline_data) . ";{$mydt10['is_vat']};{$einv01_p00}";
	$temp_code = hash('sha256', $string);
	$offline_data['user_vat'] = $mydt10['is_vat'];
	$offline_data['temp_code'] = $temp_code;
	return "$uri?".http_build_query($offline_data);
}
/**
 * Κοινή συνάρτηση για τις ηλεκτρονικές
 * @param string $tbl - Ο πίνακας (a55, a56, t08, tran01)
 * @param array $params - Πίνακας που περιέχει τη σειρά και τον τύπο
 *
 * @return string $einv01 - Το ΜΚ του einv01
 */
function einv00_check_settings($tbl, $tbl_nr01)
{
	// Ελέγχει για συνδιασμό ανάλογα με το $tbl που κλήθηκε
	switch ($tbl) {
		case 'a55': // Παραστατικά πελατών
			$einv_tbl   = 'einv02';
			$seira      = 'a18_p01';
			$type       = 'a10_p01';
			pegasus_mysql_use("SELECT p701 as seira, p05 as type, p0121 as store  FROM a55 WHERE nr01 = ?", $params, array($tbl_nr01));
			break;
		case 'a56': // Παραστατικά προμηθευτών
			$einv_tbl   = 'einv03';
			$seira      = 'a18_p01';
			$type       = 'a11_p01';
			pegasus_mysql_use("SELECT p701 as seira, p05 as type, p0121 as store FROM a56 WHERE nr01 = ?", $params, array($tbl_nr01));
			break;
		case 't08': // Αποδείξεις
			$einv_tbl   = 'einv04';
			$seira      = 'a18_p01';
			$type       = 't10_p01';
			pegasus_mysql_use("SELECT p701 as seira, p05 as type, p0121 as store FROM t08 WHERE nr01 = ?", $params, array($tbl_nr01));
			break;
		case 'tran01': // Φορτωτικές
			$einv_tbl   = 'einv05';
			$seira      = 'tran08_p01';
			$type       = 'tran20_p01';
			pegasus_mysql_use("SELECT sp00 as seira, p105 as type, p704 as store FROM tran01 WHERE nr01 = ?", $params, array($tbl_nr01));
			break;
		case 'a60': // Εσωτερικής Διακίνησης
			$einv_tbl   = 'einv06';
			$seira      = 'a18_p01';
			$type       = 'a30_p01';
			pegasus_mysql_use("SELECT p701 as seira, p05 as type, p0121 as store FROM a60 WHERE nr01 = ?", $params, array($tbl_nr01));
			break;
		case 'tran09': // Δελτία Αποστολής Φορτωτικών
			$einv_tbl   = 'einv07';
			$seira      = 'tran08_p00';
			$type       = 'tran24_p01';
			pegasus_mysql_use("SELECT p021 as seira, p101 as type, p020 as store FROM tran09 WHERE nr01 = ?", $params, array($tbl_nr01));
			break;
		case 't01': // Εστιασι
			if(pegasus_module_exists("estiasi")) {
				if(pegasus_mysql_printfld('t01' , 'p302' , "p303='71' AND nr01 = ?", array($tbl_nr01)) > 0){
					return $_SESSION['este98_einv01'];
				}
			}
			return;
		default:
			return;
	}

	// Φτιάχνει το where με βάση τα params
	if ($params['seira'] == "") {
		//* η 1η Μηχανογραφική έχει κενό κωδικό.
		//* Αν βρει κενό στα $params, αφαιρεί τα wildcards για να μην πέφτει πάνω και σε άλλες εγγραφές στο τελικό query
		$seira_param = '%##%';
	} else {
		$seira_param = "%#" . $params['seira'] . "#%";
	}

	$where = $seira . " LIKE :seira AND " . $type . " LIKE :type ";
	$whereParams = array(
		"seira" => $seira_param,
		"type"  => "%#" . $params['type'] . "#%"
	);
	if (pegasus_module_exists("stores")) {
		//* Δεν ξέρω αν το θέλω παραμετρικό εδώ. Θέλει τσεκάρισμα/επιβεβαιώση
		$where_store = " AND t07_p01 LIKE :store";
		$where .= $where_store;
		$whereParams['store'] = "%#" . $params['store'] . "#%";
	}

	//type: einv, einv01, einv02
	pegasus_mysql_use("select einv01 from ". $einv_tbl . " where ".$where . " ORDER BY type LIMIT 1", $rythmiseis, $whereParams);

	// Debug -
	// echo pegasus_replace_values_in_sql("select einv01 from ". $einv_tbl .  " where ".$where . " ORDER BY type LIMIT 1", $whereParams);

	return $rythmiseis["einv01"];
}

/**
 * Βρίσκει τα settings ηλεκτρονικής χωρίς να έχει γίνει save του παραστατικού
 * @param string $seira - Η επιλεγμένη σειρά
 * @param string $type - Ο τύπος του παραστατικού (πελάτη, προμηθευτή, απόδειξη, φορτωτική)
 * @param string $store - Το κατάστημα
 * @param string $tbl - Ο πίνακας (a55, a56, t08, tran01) - 08/07/2024 -> Δίνω default το 'a55' γιατί αρχικά είχε γραφτεί μόνο για αυτό, και πρόσθεσα το tbl.
 * @param array $params - Πίνακας που περιέχει τη σειρά και τον τύπο
 *
 * @return string $einv01 - Το ΜΚ του einv01
 */
function einv_check_settings_before_save($seira='', $type='', $store='', $tbl = 'a55')
{
	switch ($tbl) {
		case 'a55': // Παραστατικά πελατών
			$einv_tbl   = 'einv02';
			$seira_fld  = 'a18_p01';
			$type_fld   = 'a10_p01';
			break;
		case 'a56': // Παραστατικά προμηθευτών
			$einv_tbl   = 'einv03';
			$seira_fld  = 'a18_p01';
			$type_fld   = 'a11_p01';
			break;
		case 't08': // Αποδείξεις
			$einv_tbl   = 'einv04';
			$seira_fld  = 'a18_p01';
			$type_fld   = 't10_p01';
			break;
		case 'tran01': // Φορτωτικές
			$einv_tbl   = 'einv05';
			$seira_fld  = 'tran08_p01';
			$type_fld   = 'tran20_p01';
			break;
		case 'a60': // Εσωτερικής Διακίνησης
			$einv_tbl   = 'einv06';
			$seira_fld  = 'a18_p01';
			$type_fld   = 'a30_p01';
			break;
		case 'tran09': // Δελτία Αποστολής Φορτωτικών
			$einv_tbl   = 'einv07';
			$seira_fld  = 'tran08_p00';
			$type_fld   = 'tran24_p01';
			break;
		default:
			return;
	}

	if ($seira == "") {
		$seira_param = '%##%';
	} else {
		$seira_param = "%#" . $seira . "#%";
	}

	$where = $seira_fld . " LIKE :seira AND " . $type_fld . " LIKE :type ";
	$whereParams = array(
		"seira" => $seira_param,
		"type"  => "%#" . $type . "#%"
	);
	if (pegasus_module_exists("stores")) {
		$where_store = " AND t07_p01 LIKE :store";
		$where .= $where_store;
		$whereParams['store'] = "%#" . $store . "#%";
	}

	pegasus_mysql_use("select einv01 from ". $einv_tbl . " where ".$where . " ORDER BY type LIMIT 1", $rythmiseis, $whereParams);
	// echo pegasus_replace_values_in_sql("select einv01 from einv02 where ".$where . " ORDER BY type LIMIT 1", $whereParams);
	return $rythmiseis["einv01"];
}
