<?php
require_once '../firewall_classes/Firewall.php';
function firewall_after_update()
{
    pegasus_mysql_use('select rel, ver from p55 where p00="firewall"', $version);
    if ($version['ver'] == 1 && $version['rel'] <= 3) {
        $res = pegasus_query("SELECT  p95.nr01  as p95nr01 ,p95p55.nr01 as p95p55 FROM p95
                                LEFT JOIN p95p55 ON  p95p55.p95=p95.nr01 and module='firewall'
                                HAVING p95p55.nr01 is null");
        while ($p95 = pegasus_fetch($res)) {
            $p95p55array = array();
            $p95p55array['nr01'] = pegasus_mysql_newrec('p95p55');
            $p95p55array['p95'] = $p95['p95nr01'];
            $p95p55array['module'] = 'firewall';
            $p95p55array['en'] = '1';
            pegasus_mysql_insert('p95p55', array_keys($p95p55array), array_values($p95p55array));
        }
        $res = pegasus_query("SELECT  p95.nr01  as p95 ,p95p55.nr01 as p95p55 FROM p95
                                LEFT JOIN p95p55 ON  p95p55.p95=p95.nr01 and module='firewall' 
                                where p95p55.en!=1");
        while ($p95 = pegasus_fetch($res)) {
            $p95p55array = array();
            $p95p55array['en'] = '1';
            pegasus_mysql_update('p95p55', array_keys($p95p55array), array_values($p95p55array), 'nr01=?', 0, 1, 1, array($p95['p95p55']));
        }
    }
    if ($version['ver'] == 1 && $version['rel'] <= 11) {

        pegasus_mysql_update('firewall00', array('pwd_len'), array(8), 'nr01=1');
    }
}

/** 
 * Η συνάρτηση αυτή μετατρέπει πεδία που έχουν κρυπτογραφηθεί με τη μέθοδο mcrypt σε κρυπτογράφηση με openssl
 * ΣΗΜ: Θα πρέπει η παράμετρος [Toolbox->Εργαλεία Παραμετροποίησης->Παραμετροποίηση Firewall->Βασικές Παράμετροι Firewall-> Βιβλιοθήκη Κρυπτογράφησης PHP] (firewall00.encr_lib_php) να είναι openssl
 */
function firewall_encryption_convert()
{
    if (function_exists('pegasus_lock_convert_encryption')) {
        pegasus_lock_convert_encryption();
    }

    /* Εδώ ορίζουμε ποια πεδία στη βάση θα μετατραπούν με τη μορφή table => field */
    $fields = array(
        'firewall01.secret',
        'us0.pp01',
        'us0.smtp_pass',
        'massmail93.smtp_pass',
        'masssms01.apipass',
        'host04.pass',
        'host02.pass',
        'cor000.smtp_pass',
        'cor000.ftp_pass',
        'firewall02.pass'
    );

    foreach ($fields as $tb_fld) {
        $tb_fld_arr = explode('.', $tb_fld);
        $table = $tb_fld_arr[0];
        $field = $tb_fld_arr[1];
        if (!pegasus_mysql_table_field_exists($table, $field)) {
            continue;
        }
        $query = 'SELECT 	' . $table . '.nr01 as nr01,
							' . $table . '.' . $field . ' as fld
					FROM ' . $table . '
					WHERE (:var_encr_lib_php0=0 /*mcrypt*/ and ' . $table . '.' . $field . ' like "peg_crypt02:%" ) ||
                          (:var_encr_lib_php1=1 /*openssl*/ and ' . $table . '.' . $field . ' like "peg_crypt:%" )';
        $queryParams = array(
            'var_encr_lib_php0' =>  $_SESSION['firewall00_encr_lib_php'],
            'var_encr_lib_php1' =>  $_SESSION['firewall00_encr_lib_php']
        );
        $result = pegasus_query($query, $queryParams);
        while ($row = pegasus_fetch($result)) {
            $encr = $row['fld'];
            $decr = peg_decrypt($encr);
            if (!$decr) {
                continue;
            }
            $encr = peg_encrypt($decr);
            pegasus_mysql_update($table, array($field), array($encr), 'nr01=?', 0, 1, 1, array($row['nr01']));
        }
    }
}
function firewall_style_help($text)
{
    $style = "<style>
        .test_cls{ max-width: 300px;}
        @media (min-width: 500px) {
            .test_cls{ max-width: 480px;}
        } 
        @media (min-width: 700px) {
            .test_cls{max-width: 680px;}
        } 
        </style>";
    $help = $style . '<div class="peg_alert_info_plain test_cls" >' . $text . '</div>';
    return $help;
}

function firewall_firewall_2fa_d_initialize($data, $mmnr01, $mnr01, $_d, $container_id)
{
    $firewall = new Firewall();
    if (!$firewall->get_2fa_active()) {
        /* Είναι η πρώτη φορά που κανει login μετά την ενεργοποίηση 2fa */
        $data['qrcode'] = $firewall->create_2fa_QRcode(200);
        $data['help'] = firewall_style_help($_SESSION['peg_dic_firewall_2fa_login0']);
        $data['help'] = str_replace('##secret_key##', $firewall->get_2fa_secret(), $data['help']);
    } else {
        $data['help'] = firewall_style_help($_SESSION['peg_dic_firewall_2fa_login1']);
    }
    $data['help'] = str_replace('##meleti_link##', 'https://www.tesae.gr/articles/protipes-meletes-i-efarmoges/technika-themata-efarmogon-pegasus/basiki-parametropiisi-ke-leitourgia-2-factor-authentication-(2fa).html', $data['help']);

    if (empty($data['qrcode'])) {
        $data['firewall_firewall_2fa_d_qrcode_hidden'] = true;
    }
    return $data;
}
function firewall_firewall_pwd_reset_d_initialize($data, $mmnr01, $mnr01, $_d, $container_id)
{
    $firewall = new Firewall();
    if ($_SESSION['pwd_weak'] == 1) {
        $data['help'] = firewall_style_help($_SESSION['peg_dic_firewall_password_reset_help']);
    }
    if ($_SESSION['pwd_exp'] == 1) {
        $data['help'] = firewall_style_help($_SESSION['peg_dic_firewall_password_reset_help1']);
    }
    return $data;
}

function firewall_firewall02_d00_initialize($data, $mmnr01, $mnr01, $_d, $container_id)
{
    $sql = ' firewall02.us0=:var_us0 ';
    $sqlParams = array('var_us0' => $_REQUEST['us0_p01']);
    pegasusSetGlobalVar($container_id . '_where_grid00', array('sql' => $sql, 'sqlParams' => $sqlParams));
    return $data;
}

function firewall_firewall00_d_initialize($data, $mmnr01, $mnr01, $_d, $container_id)
{
    pegasusSetGlobalVar($container_id . '_old_encr_lib_php', $data['encr_lib_php']);
    return $data;
}

function peg_firewall_firewall00_d_onsave($data, $permDeny, $mmnr01, $checkOnlyPerm)
{
    $container_id = $_REQUEST['scr_container_id'];
    $old_encr_lib_php = pegasusGetGlobalVar($container_id . '_old_encr_lib_php');
    if (
        $data['encr_lib_php'] == 0 && !function_exists('mcrypt_encrypt') ||
        $data['encr_lib_php'] == 1 && !function_exists('openssl_encrypt')
    ) {
        array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_firewall_php_encr_not_exists']));
        return array($data, $permDeny);
    }
    if ($old_encr_lib_php != $data['encr_lib_php']) {
        array_push($permDeny, array('type' => 'confirm', 'message' => $_SESSION['peg_dic_firewall_php_encr_convert_confirm']));
    }
    if ($checkOnlyPerm == 0) {
        pegasusSetGlobalVar($container_id . '_old_encr_lib_php', $data['encr_lib_php']);
    }
    return array($data, $permDeny);
}

function peg_firewall_firewall00_d_execute_after_save()
{
    pegasusWriteSession('firewall00');
    pegasusReadSession('firewall00');
    firewall_encryption_convert();
}

function peg_firewall_firewall02_d_ondelete($data, $permDeny = array(), $mmnr01 = "", $check_perm_only = 0)
{
    if ($check_perm_only && !pegasus_check_permission('firewall02.delete')) {
        array_push($permDeny, array('type' => 'DENY', 'message' => $_SESSION['peg_dic_firewall_delete_records_deny']));
    }
    return $permDeny;
}
