<?php

class Firewall{
    private $user;
    private $username;
    private $en_2fa;
    private $firewall01_arr;
    private $login_notif_en;
    private $login_notif_email;
    private $secret;
    private $verification_success;

    public function __construct(){
        $this->user = $_SESSION['user'];
        $this->username = $_SESSION['username'];
        pegasus_mysql_use("SELECT firewall01.* FROM firewall01 JOIN us0 on us0.p01=firewall01.us0 WHERE us0.nr01=:var_us0",$firewall01,array('var_us0'=>$this->user) );
        $this->firewall01_arr=$firewall01;
        $this->secret=$firewall01['secret'];
        $this->login_notif_en=$_SESSION['firewall00_login_notif_en'];
        $this->login_notif_email=$_SESSION['firewall00_login_notif_email'];
        $this->verification_success=false;
    }
    public function get_2fa_enabled($us0=''){
        if(!empty($us0)){
            pegasus_mysql_use('select * from firewall01 where us0= :var_us0 ',$firewal01,array('var_us0'=>$us0));
            return $firewal01['en']==1;
        }
        if(!empty($this->firewall01_arr) && is_array($this->firewall01_arr)){
            return $this->firewall01_arr['en']==1;
        }
        return false;
    }
    public function get_2fa_verified(){
        return $this->verification_success;
    }
    public function vertify_2fa($code){
        /*Δεν έχω user */
        if(empty($this->user)){
            return false;
        }
        if(! ($this->get_2fa_enabled()) ){
            return false;
        }
        require_once('../firewall_classes/GoogleAuthenticator.php');
        $authenticator=new PHPGangsta_GoogleAuthenticator();
        if($_SESSION['firewall_tmp_secret']){
            $secret=$_SESSION['firewall_tmp_secret'];
        }else{
            $secret=$this->decrypt_2fa_secret($this->secret);
        }
        $checkResult=$authenticator->verifyCode($secret,$code);
        if( $checkResult){
            $this->verification_success=true;
            if($_SESSION['firewall_tmp_secret']){
                $save_secret=$this->encrypt_2fa_secret($_SESSION['firewall_tmp_secret']);

                pegasus_mysql_update('firewall01',array('secret'),array($save_secret),'us0=:var_us0',0,1,1,array('var_us0'=>$this->firewall01_arr['us0']));
                $this->firewall01_arr['secret']=$_SESSION['firewall_tmp_secret'];
                unset($_SESSION['firewall_tmp_secret']);
            }
        }
        return $checkResult;
    } 
    public function get_2fa_active(){
        return !empty($this->firewall01_arr['secret']);
    }
    public function get_2fa_secret(){
        if($_SESSION['firewall_tmp_secret']){
            return $_SESSION['firewall_tmp_secret'];
        }
        return $this->decrypt_2fa_secret($this->secret);
    }
    public function create_2fa_QRcode( $width=''){
        unset($_SESSION['firewall_tmp_secret']);
        $QRcode= ""; 
        if(!empty($this->user) && $this->get_2fa_enabled() ){
            if(empty($this->secret)){
                require_once('../firewall_classes/GoogleAuthenticator.php');
                $authenticator=new PHPGangsta_GoogleAuthenticator();
                $this->secret=$authenticator->createSecret();
            }
            $_SESSION['firewall_tmp_secret']=$this->secret;

            /* Το όνομα που θα εμφανίζεται στον Google Authenticator */
            $descriprion=$this->create_Authenticator_descriprion();

            $url_secret=$this->secret;

            $urlencoded = urlencode('otpauth://totp/'.$descriprion.'?secret='.$url_secret.''); 
            $style='';
            if(intval($width)>0){
                $style='style="width:'.intval($width).'px"';
            }
            return '<img src="data:image/png;base64,' . base64_encode(pegasus_qrcode_create($urlencoded)) . '" '.$style.' >'; 
        }
        return $QRcode;
    }


    public function update_2fa($us0,$value){
        if( !(pegasus_mysql_printfld('us0','nr01','p01=:var_p01',array('var_p01'=>$us0))>0) ){
            return;
        }
        pegasus_mysql_use('select * from firewall01 where us0= :var_us0 ',$firewal01,array('var_us0'=>$us0));
        if($value==1){
            /* Δεν υπαρχει εγγραφη για το δοσμενο χρηστη */
            if(!($firewal01['nr01']>0)){
                $arr=array();
                $arr['nr01']= pegasus_mysql_newrec('firewall01');
                $arr['us0']= $us0;
                $arr['en']= 1;	
                $arr['secret']='';
                pegasus_mysql_insert('firewall01',array_keys($arr),array_values($arr));
              }else if($firewal01['en']==0) {
                $arr=array();
                $arr['en']= 1;
                $arr['secret']='';
                pegasus_mysql_update('firewall01',array_keys($arr),array_values($arr),' us0= :var_us0 ',0,1,1,array('var_us0'=>$us0) );
            }
        }else{
            if($firewal01['nr01']>0 && $firewal01['en']==1){
                $arr=array();
                $arr['en']= 0;
                $arr['secret']='';
                pegasus_mysql_update('firewall01',array_keys($arr),array_values($arr),' us0= :var_us0 ',0,1,1,array('var_us0'=>$us0) );
            }
        }
    }

    public function reset_2fa($us0){
        pegasus_mysql_use('select * from firewall01 where us0= :var_us0 ',$firewal01,array('var_us0'=>$us0));
        if($firewal01['nr01']>0){
            if($firewal01['en']==1 && $firewal01['secret']!=''){
                pegasus_mysql_update(   'firewall01',
                                        array('secret'),
                                        array(''),
                                        'us0=:var_us0',0,1,1,
                                        array(  'var_us0'   =>  $us0 )   );
                return array(   'ok'    =>  1,
                                'msg'   =>  $_SESSION['peg_dic_firewall_reset_ok']);
            }else{
                return array(   'ok'    =>  0,
                                'msg'   =>  $_SESSION['peg_dic_firewall_reset_no_rec_found']);
            }
        }else{
            return array(   'ok'    =>  0,
                            'msg'   =>  $_SESSION['peg_dic_firewall_reset_no_rec_found']);
        }
    }
    public function notify_login_success(){
        if($this->login_notif_en){
            $subject=$this->get_notif_subject();
            $body=$this->get_notif_body();
            $body.="<p>Successfull Username/Password Login</p>";
            peg_send_mail($_SESSION['smtp_user']  , $this->login_notif_email , $subject , $body ); 
        }
    }
    public function notify_login_2fa_success(){
        if($this->login_notif_en){
            $subject=$this->get_notif_subject();
            $body=$this->get_notif_body();
            $body.="<p>Successfull 2FA Verification</p>";
            peg_send_mail($_SESSION['smtp_user']  , $this->login_notif_email , $subject , $body ); 
        }
    }
    public function notify_login_2fa_fail(){
        if($this->login_notif_en){
            $subject=$this->get_notif_subject();
            $body=$this->get_notif_body();
            $body.="<p>Login Failure: Wrong 2FA verification code</p>";
            peg_send_mail($_SESSION['smtp_user']  , $this->login_notif_email , $subject , $body ); 
        }
    }
    public function notify_login_invalid_host(){
        if($this->login_notif_en){
            $subject=$this->get_notif_subject();
            $body=$this->get_notif_body();
            $body.="<p>Login Failure: Invalid Host</p>";
            peg_send_mail($_SESSION['smtp_user']  , $this->login_notif_email , $subject , $body ); 
        }
    }
    public function notify_login_fail(){
        if($this->login_notif_en){
            $subject=$this->get_notif_subject();
            $body=$this->get_notif_body();
            $body.="<p>Login Failure: Invalid Username/Password </p>
                    <p>Login Attempt username: ".$_REQUEST['p800']."</p>";
            peg_send_mail($_SESSION['smtp_user']  , $this->login_notif_email , $subject , $body ); 
        }
    }
    /** This method sends an e-mail notification that the password was successfully changed **/
    public function notify_password_change(){
        if($this->login_notif_en){
            $subject=$this->get_notif_subject();
            $body=$this->get_notif_body();
            $body.="<p>Successfull Password Change</p>";
            peg_send_mail($_SESSION['smtp_user']  , $this->login_notif_email , $subject , $body ); 
        }
    }

    /** This method checks user's password has expired
     * @param string $us0 The user's username(us0.p01). If empty , $_SESSION['username'] value will be used.
     * @return boolean 
     */
    public function password_has_expired($us0=''){
        if(empty($us0)){
            $us0=$this->username;
        }
        pegasus_mysql_use("SELECT count(*) AS cnt FROM firewall02 JOIN us0 ON us0.p01=firewall02.us0 WHERE us0.p01=?",$cnt,array($us0));
        pegasus_mysql_use("SELECT  * FROM us0 WHERE us0.p01=?",$us0_arr,array($us0));
        

        if($cnt['cnt']==0 && $us0_arr['nr01']>0){
            $this->insert_firewall02_rec();
        }
        $query="SELECT * FROM(
                    SELECT firewall02.* 
                    FROM firewall02
                    JOIN us0 ON us0.p01=firewall02.us0
                    WHERE   us0.p01=:var_us0 
                    ORDER BY firewall02.dt DESC,firewall02.tm DESC
                    LIMIT 1 ) AS tbl
                HAVING (( tbl.dt + INTERVAL (SELECT pwd_duration FROM firewall00 LIMIT 1) DAY ) < curdate() && (SELECT pwd_duration FROM firewall00 LIMIT 1)>0)  || tbl.exp=1";
        $queryParams=array( 'var_us0'           =>  $us0_arr['p01']  );
        pegasus_mysql_use($query,$firewall02,$queryParams);
        if($firewall02['nr01']>0 ){
            return true;
        }
        return false;
    }
    /** This method checks user's password is weak according to Basic Module Configuration 
     * @param string $us0 The user's username(us0.p01). If empty , $_SESSION['username'] value will be used.
     * @return boolean 
     */
    public function password_is_weak($us0=''){
        if(empty($us0)){
            $us0=$this->username;
        }
        $pass=$this->get_last_password($us0);
        $ret=$this->check_password_strength($pass,$us0,array('old_passwords'=>0));
        return $ret['ok']==0;

    }
    /** This method updates user's password in us0 table and also inserts a new rec in user's password update history (firewall02 table).
     * @param string $pass The new password.Can be either encrypted on not encrypted.
     * @param string $us0 The user's username(us0.p01). If empty , $_SESSION['username'] value will be used.
     * @param int $upd_us0 If 1, method will update us0 record with the new password.If 0 , only firewall02 table will be updated.
     * @return array  ('ok'  => 1 for succeess, 0 for failure, 
     *                 'msg' => Success/Failure message )*/
    public function update_password($new_pass,$us0='',$upd_us0=1,$check_last_pwd=1){
        if(empty($us0)){
            $us0=$this->username;
        }
        pegasus_mysql_use("SELECT  * FROM us0 WHERE us0.p01=?",$us0_arr,array($us0));
        
        /*Password strength check*/
        $password_strength= $this->check_password_strength($new_pass,$us0,array('last_pwd'=>$check_last_pwd));
        if($password_strength['ok']==0){
            return $password_strength;
        }
        $ret=array();
        if(!peg_is_encrypted($new_pass)){
            $new_pass=peg_encrypt($new_pass);
        }
        $this->insert_firewall02_rec($new_pass,$us0);
        if($upd_us0==1){
            pegasus_mysql_update('us0',array('pp01'),array($new_pass),'p01=?',0,1,1,array($us0));
        }
        $ret['ok']=1;
        $ret['msg']=$_SESSION['peg_dic_firewall_password_reset_ok'];
        return $ret;
    }

    /** This method returns if the last password found in user's password change history has expired.
     * @param string $us0 The user's username(us0.p01). If empty , $_SESSION['username'] value will be used.
     * @return boolean The firewall02.exp value
     */
    public function get_firewall02_exp($us0=''){
        $last_pass=$this->get_last_firewall02($us0);
        return $last_pass['exp'];
    }
    /** This method updates the exp column in the last firewall02 record with the given value
     * @param int $value The value to set to the firewall02.exp column
     * @param string $us0 The user's username(us0.p01). If empty , $_SESSION['username'] value will be used.
     * @param string $pass This parameter will be used in case that there is no firewall02 rec for the user. A new record will be inserted with this password. 
     */
    public function update_pwd_exp($value,$us0='',$pass=''){
        $pass_arr=$this->get_last_firewall02($us0);
        if( !($pass_arr['nr01']>0) || 
            ( peg_decrypt($pass) != peg_decrypt($pass_arr['pass']) )    ){
            /* If last password found doesn't match given pass, a new record is inserted */
            $this->insert_firewall02_rec($pass,$us0,$value);
        }else{
            if( $pass_arr['exp']!=$value){
                pegasus_mysql_update('firewall02',array('exp'),array($value),'nr01=?',0,1,1,array($pass_arr['nr01']));
            }
        }
        
    }

    /** This method checks if the password is strong enough according to $opts given.
     * @param string $pass The password to check. If empty, the method will check the current password of the $us0 given.
     * @param string $us0 The user's username(us0.p01). If empty , $_SESSION['username'] value will be used.
     * @param array $opts This argument can be used to define wich checks will be applied. If empty, the method will perform all possible checks.
     * $opts can be an associative php array containing elements like 'check_id' => {0/1 to enable/disable check}. Accepted check ids can be:
     * * 'username' -> If enabled, the method will not allow the password to match the username.
     * * 'insecure_words' -> If enabled, the password will not contain insecure strings like 'password', 'admin' etch
     * * 'old_passwords' -> If enabled, the method will not allow the use of old passwords
     * * 'capital_lowercase' -> If enabled, the method will check if the password contains both capital an lowercase letters
     * * 'numbers' -> If enabled, the method will check if the password contains at least 1 digit
     * * 'symbols' -> If enabled, the method will check if the password contains at least 1 special symbol
     * * 'length' -> If enabled, passwords will not be shorter than 5 characters
     * * 'last_pwd' -> Set 1 to skip checking last password
     * @return boolean The firewall02.exp value
     * 
     * Example:  
     * $opts=array('insecure_words'=>0,'length'=>0) ;
     * 
     * $fwl->check_password_strength('admin','admin',$opts);
     */
    public function check_password_strength($pass='',$us0='',$opts=array()){
        if(empty($us0)){
            $us0=$this->username;
        }
        if(empty($pass)){
            $pass=pegasus_mysql_printfld('us0','pp01','p01=?',array($us0));
        }
        $pass=peg_decrypt($pass);
        $charset=pegasus_get_html_charset();

        $opts_keys_array=array('username','insecure_words','old_passwords','capital_lowercase','numbers','symbols','length','last_pwd');
        foreach($opts_keys_array as $opts_key){
            ${$opts_key.'_check'}=(!isset($opts[$opts_key]) || (isset($opts[$opts_key]) && $opts[$opts_key]==1));
        }

        /*Username and password are the same*/
        if( $us0 == peg_decrypt($pass) && $username_check ){
            return array('ok'=>0,'msg'=>$_SESSION['peg_dic_firewall_password_reset_error5']);
        }

        /*Password contains insecure strings*/
        if($insecure_words_check ){
            $pass_lowercase=mb_strtolower($pass,$charset);
            $insec_words=$this->get_isecure_password_words();
            foreach($insec_words as $word){
                if(mb_strpos ($pass_lowercase,$word,0,$charset)!==false){
                    return array(   'ok'=>0,
                                    'msg'=>str_replace('##word##',$word,$_SESSION['peg_dic_firewall_password_reset_error6']));
                }
            }
        }

        /*Password has been used before*/
        if($old_passwords_check){
            $firewall02nr01=$this->firewall02_search_pass($pass,$us0,$last_pwd_check);
            if($firewall02nr01>0){
                return array('ok'=>0,'msg'=>$_SESSION['peg_dic_firewall_password_reset_error7']);
            }
        }

        /*Password doesn't contain uppercase and lowercase letters*/
        if($capital_lowercase_check && $_SESSION['firewall00_pwd_caps_low']==1 && !$this->check_capital_lowercase($pass)){
            return array('ok'=>0,'msg'=>$_SESSION['peg_dic_firewall_password_reset_error8']);
        }
        
        /*Password doesn't contain at least one number*/
        if($numbers_check  && $_SESSION['firewall00_pwd_numbers']==1 && preg_match_all('/[0-9]+/', $pass)==false){
            return array('ok'=>0,'msg'=>$_SESSION['peg_dic_firewall_password_reset_error9']);
        }

        /*Password doesn't contain at least one symbol*/
        if($symbols_check  && $_SESSION['firewall00_pws_symbols']==1  && preg_match_all('/\W+/', $pass)==false){
            return array('ok'=>0,'msg'=>$_SESSION['peg_dic_firewall_password_reset_error10']);
        }

        /*Password length is less than 5 chars*/
        if($length_check && mb_strlen($pass)<$_SESSION['firewall00_pwd_len']){
            return array('ok'=>0,'msg'=>str_replace('##len##',$_SESSION['firewall00_pwd_len'],$_SESSION['peg_dic_firewall_password_reset_error11']));
        }
        return array('ok'=>1);
    }
    /************************** P R I V A T E   M E T H O D S  **************************/

    /** This method inserts a new record in user's password change history.
     * @param string $pass The new password.Can be either encrypted on not encrypted.
     * @param string $us0 The user's username(us0.p01). If empty , $_SESSION['username'] value will be used.
     * @param string $exp The firewall02.exp value for the new record.
     */
    private function insert_firewall02_rec($pass='',$us0='',$exp=0){
        if(empty($us0)){
            $us0=$this->username;
        }
        pegasus_mysql_use("SELECT  * FROM us0 WHERE us0.p01=?",$us0_arr,array($us0));

        if(empty($pass)){
            $pass=$us0_arr['pp01'];
        }
        /* Password has not changed */
        if(peg_decrypt($this->get_last_password($us0))==peg_decrypt($pass)){
            return;
        }
        $arr_ins=array();
        $arr_ins['nr01']=pegasus_mysql_newrec('firewall02');
        $arr_ins['us0']=$us0;
        $arr_ins['dt']=date('Y-m-d');
        $arr_ins['tm']=date('H:i:s');
        $arr_ins['pass']=$pass;
        $arr_ins['us0_ch']=$_SESSION['username'];
        $arr_ins['exp']=$exp;
        pegasus_mysql_insert('firewall02',array_keys($arr_ins),array_values($arr_ins));
    }

    /** This method returns the last password found in user's password change history.
     * @param string $us0 The user's username(us0.p01). If empty , $_SESSION['username'] value will be used.
     * @return string The most recent encrypted password found in firewall02 table.
     */
    private function get_last_password($us0=''){
        $last_pass=$this->get_last_firewall02($us0);
        $current_pass=pegasus_mysql_printfld('us0','pp01','p01=?',array($us0));
        if(peg_decrypt($last_pass['pass'])!=peg_decrypt($current_pass)){
            if(!peg_is_encrypted($current_pass)){
                $current_pass=peg_encrypt($current_pass);
            }
            $arr_ins=array();
            $arr_ins['nr01']=pegasus_mysql_newrec('firewall02');
            $arr_ins['us0']=$us0;
            $arr_ins['dt']=date('Y-m-d');
            $arr_ins['tm']=date('H:i:s');
            $arr_ins['pass']=$current_pass;
            $arr_ins['us0_ch']=$_SESSION['username'];
            $arr_ins['exp']=0;
            pegasus_mysql_insert('firewall02',array_keys($arr_ins),array_values($arr_ins));
            return $current_pass;
        }
        return $last_pass['pass'];
    }

    /** This method returns the last password reccord found in user's password change history.
     * @param string $us0 The user's username(us0.p01). If empty , $_SESSION['username'] value will be used.
     * @return array The firewall02 record
     */
    private function get_last_firewall02($us0=''){
        if(empty($us0)){
            $us0=$this->username;
        }
        pegasus_mysql_use('SELECT * FROM firewall02 WHERE  us0=? ORDER BY dt DESC,tm DESC LIMIT 1',$pass_arr,array($us0));
        return $pass_arr;
    }
    /** This method returns a php array with all the strings that are not allowed to be contained in passwords
     * @return array A php array with all the strings that are not allowed to be contained in passwords
     */
    private function get_isecure_password_words(){
        return array('admin','password','qwerty');
    }
    /** This method checks if the given password contains at least one capital and one lowecase letter.
     * @param string $pass The password to check.
     * @return boolean true if the password has both capitals and lowercase letters, false if not.
     */
    private function check_capital_lowercase($pass){
        $greekCaps=array('Α','Ά','Β','Γ','Δ','Ε','Ζ','Η','Θ','Ι','Ί','Ϊ','Κ','Λ','Μ','Ν','Ξ','Ο','Ό','Π','Ρ','Σ','Τ','Υ','Ϋ','Ύ','φ','Χ','Ψ','Ω','Ώ');
        $found=false;
        foreach($greekCaps as $cap){
            if( mb_strpos($pass,$cap,0,pegasus_get_html_charset()) > 0){
                $found=true;
            }
        }
        if(!$found && preg_match_all('/[A-Z]+/', $pass)==false ){
            return false;
        }
        $greekLowercase=array('α','ά','β','γ','δ','ε','έ','ζ','η','ή','θ','ι','ί','ϊ','ΐ','κ','λ','μ','ν','ξ','ο','ό','π','ρ','σ','τ','υ','ύ','ϋ','ΰ','φ','χ','ψ','ω','ώ');
        $found=false;
        foreach($greekLowercase as $lc){
            if( mb_strpos($pass,$lc,0,pegasus_get_html_charset()) > 0){
                $found=true;
            }
        }        
        if(!$found && preg_match_all('/[a-z]+/', $pass)==false ){
            return false;
        }
        return true;
    }

    /** This method checks if the given password matches one older password.
     * @param string $pass The password to check.
     * @param string $us0 The user's username(us0.p01). If empty , $_SESSION['username'] value will be used.
     * @param boolean $check_last true to check the mosth recent password , false to skip it.
     * @return boolean true if the password has both capitals and lowercase letters, false if not.
     */
    private function firewall02_search_pass($pass,$us0,$check_last=true){
        $query="SELECT firewall02.pass,firewall02.nr01,firewall02.dt FROM firewall02 WHERE firewall02.us0=? ORDER BY firewall02.dt DESC , firewall02.tm DESC ";
        $queryParams=array($us0);
        $result=pegasus_query($query,$queryParams);
        if(!$check_last){
            $rec0=pegasus_fetch($result);//I skip checking the last password 
        }
        while($rec=pegasus_fetch($result)){
            if(peg_decrypt($pass)==peg_decrypt($rec['pass'])){
                return $rec['nr01'];
            }
        }
        return false;
    }
    private function get_notif_subject(){
        $subject="Pegasus WebApp Firewall on ##host##: access alert from ##IP## (##dns##)";
        $subject=$this->replace_tags($subject);
        return $subject;
    }
    private function get_notif_body(){
        $body="======================================================<br>
        Time: ##datetime##<br>
        IP: ##IP## (##dns##)<br>
        User: ##user##<br>
        ======================================================";
        $body=$this->replace_tags($body);
        return $body;
    }
    private function replace_tags($str){
        $str=str_replace('##host##',$_SERVER['HTTP_HOST'],$str);
        $str=str_replace('##IP##',$_SERVER['REMOTE_ADDR'],$str);
        $str=str_replace('##dns##',gethostbyaddr($_SERVER['REMOTE_ADDR']),$str);
        $str=str_replace('##datetime##',date('D M d H:i:s Y O'),$str);
        
        $str=str_replace('##user##',$_SESSION['username'],$str);
        return $str;
    }
    private function create_Authenticator_descriprion(){
        return $_SESSION['cor000_title'].' ('.$this->username.')';
    }
    private function encrypt_2fa_secret($secret){
        return peg_encrypt($secret);
    }
    private function decrypt_2fa_secret($secret){
        return peg_decrypt($secret);
    }
}
?>