SELECT
	t1.p01 										AS p01,
	t1.name 									AS name,
	t1.p610 									AS p610,
	t1.pc01 									AS pc01,
	t1.pm01 									AS pm01,
	t1.vpc01 									AS vpc01,
	t1.vpm01 									AS vpm01,
	t1.p010 									AS p010,
	t1.p011 									AS p011,
	t1.p414 									AS p414,
	t1.t_poseis 								AS t_poseis,
	t1.t_posex 									AS t_posex,
	IFNULL(i07.nr01, 0)							AS inr01,
	t1.groupconcat								AS groupconcat

FROM
(
	(
		SELECT i01.p01 							AS p01,  
			i00.name  							AS name, 
			i01.p610  							AS p610, 
			''									AS pc01, 
			''									AS vpc01, 
			''									AS pm01, 
			''									AS vpm01, 
			''									AS p010, 
			''	   								AS p011, 
			i00.p414  							AS p414, 
			sum( i01.p012 * i01.p03 * i15.p03)	AS t_poseis,  
			sum( i01.p012 * i01.p03 * i15.p04)	AS t_posex,  
			concat(i00.p9901,',',i00.p9902,',',i00.p910,',',i00.p911) 	AS groupconcat
		FROM 
			i01, i15, i00 
		WHERE i01.p05=i15.p01
		AND i01.p01=i00.pno  
		AND ((i00.p9904=0 AND i00.p9905=0) 		OR {np_col}=0 )
		AND (i00.p904=0 						OR {np_lot}=0 )
		AND (i00.ps01=0 						OR {np_sn}=0 )
		AND i00.p202=0  
		AND i01.p013							<=:f01_p022  
		AND i01.p610 							>=:i16_p00_from
		AND i01.p610 							<=:i16_p00_to 
		AND i00.pno 							>=:i00_pno_from
		AND i00.pno 							<=:i00_pno_to
		AND 									( {nt_where} )
		GROUP BY i01.p01, i01.p610 
	)
	
	/*MOD_START_COLORSIZE*/
	UNION ALL
	(
		SELECT 
			i48_d01.p01							AS p01,   
			IFNULL(i00.name,'')					AS name,  
			i48_d01.p610						AS p610,  
			i48_d01.i40p01						AS pc01,  
			IFNULL(i40.p02, '')					AS vpc01,  
			i48_d01.i43p01						AS pm01,  
			IFNULL(i43.p02, '')					AS vpm01,  
			''									AS p010,
			''									AS p011, 
			IFNULL(i00.p414, 0)					AS p414,  
			sum(IFNULL(i48_d01.poseis,0)) 		AS t_poseis,   
			sum(IFNULL(i48_d01.posex,0))  		AS t_posex,   
			concat(i00.p9901,',',i00.p9902,',',i00.p910,',',i00.p911) 	AS groupconcat
		FROM 
			i48_d01
		LEFT JOIN i00 ON i00.pno=i48_d01.p01
		LEFT JOIN i40 ON i40.p01=i48_d01.i40p01
		LEFT JOIN i43 ON i43.p01=i48_d01.i43p01
		WHERE {np_col}=1 
		AND i48_d01.p013<=:f01_p022  
		AND i00.p9904<>0  
		AND i00.p9905<>0  
		AND i00.p202=0  
		AND i48_d01.p610 					>=:i16_p00_from 
		AND i48_d01.p610					<=:i16_p00_to 
		AND i00.pno							>=:i00_pno_from
		AND i00.pno							<=:i00_pno_to
		AND 								( {nt_where} )
		GROUP BY 
			i48_d01.p01,
			i48_d01.i40p01,
			i48_d01.i43p01,
			i48_d01.p610
		)
		/*MOD_END_COLORSIZE*/
		
		/*MOD_START_LOT*/
		UNION ALL
		(
			SELECT 
				i38_d01.p01   					AS p01,   
			  	IFNULL(i00.name, '')  			AS name,  
			  	i38_d01.p610  					AS p610,  
				''   							AS pc01,  
				''   							AS vpc01,  
				''   							AS pm01,  
				''   							AS vpm01,  
				i38_d01.p02 					AS p010,
				'' 								AS p011, 
				IFNULL(i00.p414, 0)  			AS p414,  
				sum(IFNULL(i38_d01.poseis,0))	AS t_poseis,   
				sum(IFNULL(i38_d01.posex,0))	AS t_posex,   
				concat(i00.p9901,',',i00.p9902,',',i00.p910,',',i00.p911) 	AS groupconcat								
			FROM 
				i38_d01
			LEFT JOIN i00 ON i00.pno=i38_d01.p01
			WHERE {np_lot}=1
			AND i00.p904<>0  
			AND i00.p202=0   
			AND i38_d01.p013					<=:f01_p022
			AND i38_d01.p610					>=:i16_p00_from  
			AND i38_d01.p610					<=:i16_p00_to 
			AND i00.pno							>=:i00_pno_from
			AND i00.pno							<=:i00_pno_to
			AND 								( {nt_where} )
			GROUP BY 
				i38_d01.p01, 
				i38_d01.p02, 
				i38_d01.p610
		)
		/*MOD_END_LOT*/
		
		/*MOD_START_SERIAL*/
		UNION ALL
		(
			SELECT 
				i01.p01   							AS p01,   
                IFNULL(i00.name, '') 				AS name,  
				i01.p610  							AS p610,  
				''   								AS pc01,  
				''   								AS vpc01,  
				''   								AS pm01,  
				''   								AS vpm01,  
				''   								AS p010,
				i32.p02 							AS p011, 
				IFNULL(i00.p414, 0)  AS p414,  
				sum( IFNULL(i01.p012*i15.p03, 0) )	AS t_poseis,   
				sum( IFNULL(i01.p012*i15.p04, 0) )	AS t_posex,   
				concat(i00.p9901,',',i00.p9902,',',i00.p910,',',i00.p911) 	AS groupconcat								
        	FROM 
				i32, 
				i01, 
				i00, 
				i15
        	WHERE {np_sn}=1 
			AND i01.p013<=:f01_p022
			AND i01.p01=i00.pno
			AND i32.p00=i01.nr01
			AND i32.p010=1
			AND i00.ps01<>0               
			AND i00.p202=0  
			AND i15.p01=i01.p05
			AND :i16_p00_from <=i01.p610  
			AND i01.p610<= :i16_p00_to  
			AND i00.pno>= :i00_pno_from
			AND i00.pno<= :i00_pno_to
			AND ( {nt_where} )
         	GROUP BY 
		  		i01.p01,
			  	i32.p02, 
			  	i01.p610
		)
		/*MOD_END_SERIAL*/

) AS t1
LEFT JOIN 
	i07 
ON 
	i07.p01=t1.p610 AND i07.p02=t1.p01 AND i07.pc01=t1.pc01 AND i07.pm01=t1.pm01 AND i07.p010=t1.p010 AND i07.p011=t1.p011
WHERE
	{peg_str1}
	{groupconcat}
ORDER BY 
	t1.p01, 
	t1.p610;