DROP TABLE IF EXISTS {colorsize_temporary}
/*PEG_QUERY_STEP_BREAK*/ 
CREATE TEMPORARY TABLE {colorsize_temporary}
SELECT 
	i07.*, 
	sum(i07.p06) AS p06tot 
FROM
	i07
WHERE p06<>0
AND pc01<>'' 
AND pm01<>''
GROUP BY 
	i07.p01, i07.p02,
	i07.p04
/*PEG_QUERY_STEP_BREAK*/
UPDATE {colorsize_temporary} SET nr01=0
/*PEG_QUERY_STEP_BREAK*/
UPDATE {colorsize_temporary} SET nr01=peg_new_nr01('i01', 1)
/*PEG_QUERY_STEP_BREAK*/  
INSERT INTO 
	i01
(
	nr01,
	p01,
	p02,
	p03,
	p04,
	p013,
	p011, 
	p022, 
	p05, 
	p012, 
	p610, 
	p0601, 
	pd01, 
	pd101, 
	remdate, 
	remtime, 
	remuser, 
	remfdate, 
	remftime, 
	remfuser
)
SELECT 
	i07.nr01				AS nr01, 
	i07.p02				AS p01, 
	i07.vp02				AS p02, 
	i07.p06tot				AS p03, 
	i07.p04				AS p04, 
	:np_dt					AS p013, 
	round(i07.p06tot*i07.p04, 2)	AS p011, 
	round(i07.p06tot*i07.p04, 2)	AS p022, 
	:np_kk					AS p05, 
	1					AS p012, 
	i07.p01 				AS p610, 
	concat(:peg_str1, ' Color - Size')	AS p0601, 
	concat(:peg_str2,'_c') 		AS pd01, 
	'i07' 					AS pd101, 
	curdate() 				AS remdate, 
	curtime() 				AS remtime, 
	:user_pswd 				AS remuser,  
	curdate() 				AS remfdate, 
	curtime() 				AS remftime, 
	:user_pswd 				AS remfuser
FROM 
	{colorsize_temporary} 		AS i07
/*PEG_QUERY_STEP_BREAK*/    
INSERT INTO 
	i48
(
	nr01, 
	p01, 
	p02, 
	p03, 
	p04, 
	remdate, 
	remtime, 
	remuser, 
	remfdate, 
	remftime, 
	remfuser
)
SELECT 
	peg_new_nr01('i48', 1)  		AS nr01, 
	{colorsize_temporary}.nr01 		AS p01, 
	i07.pc01 				AS p02, 
	i07.pm01 				AS p03, 
	i07.p06 				AS p04, 
	curdate() 				AS remdate, 
	curtime() 				AS remtime, 
	:user_pswd 				AS remuser, 
	curdate() 				AS remfdate, 
	curtime() 				AS remftime, 
	:user_pswd 				AS remfuser
FROM 
	{colorsize_temporary}, i07
WHERE {colorsize_temporary}.p01=i07.p01
AND {colorsize_temporary}.p02=i07.p02
AND {colorsize_temporary}.p04=i07.p04
AND i07.p06<>0
AND i07.pc01<>'' 
AND i07.pm01<>'';
/*PEG_QUERY_STEP_BREAK*/  
DROP TABLE IF EXISTS {colorsize_temporary}
