<?php
    if(class_exists('PrintsData')===false){
        if(file_exists('../../pegasus_cloud_app/prints_classes/prints_data.php')){
            require_once('../../pegasus_cloud_app/prints_classes/prints_data.php');
        }else{
            return;
        }
    }
    class InvcustA55PrintsData extends PrintsData { 

        public function __construct($p85nr01=0, $sid=0, $p85_input=array()){        
            parent::__construct($p85nr01, $sid, $p85_input);
            
            $this->setMultipleInputMode(1);
        }

        protected static function sanitizeExpressionField($field_name){
            return InvoicesPrintsClass::sanitizeExpressionField($field_name);
        }

        protected function setBodySql(){

            if(!empty($this->p85_arr['body_sql_code'])){
                $sql_code = eval($this->p85_arr['body_sql_code']);
            }

            $dias_main_nr01 = (is_array($this->p85_input["dias_main_nr01"])) ? $this->p85_input["dias_main_nr01"][0] : $this->p85_input["dias_main_nr01"];
                        
            if(empty($sql_code)){
                if(pegasus_module_exists('orders')){
                    pegasus_mysql_use("select apostpno, codpno, s_cost0pno, s_cost1pno, s_cost2pno, s_cost3pno from hero00", $costs);
                }    
                
                $lang = (isset($this->p85_input["lang"])) ? $this->p85_input["lang"] : "GR";   
                
                if($this->p85_input["invoice_grouped_products"]==true){
                    $sql_code = InvoicesPrintsClass::getProductsGroupedQuery('a55', 2, $dias_main_nr01, $this->p85_input["cs_analysis"], $costs, $this->p85_input["disable_i71"], $lang, $this->p85_input["order_by"], $this->p85_input["prd_analysis"]);            
                    //echo "<pre>". pegasus_replace_values_in_sql($sql_code['sql'],$sql_code['sqlParams']) . "</pre>";
                }else{
                    $sql_code = InvoicesPrintsClass::getProductsQuery('a55', 2, $dias_main_nr01, $this->p85_input["cs_analysis"], $costs, $this->p85_input["disable_i71"], $lang, $this->p85_input["order_by"]);  
                }     
            }

            $this->body_sql = (is_array($sql_code)) ? $sql_code : array('sql'=>$sql_code, 'sqlParams'=>array());
        }  

        protected function makeGlobalData(){
            $global_data = parent::makeGlobalData();
            
            $lang = (isset($this->p85_input["lang"])) ? $this->p85_input["lang"] : "GR"; 
            $dias_main_nr01 = (is_array($this->p85_input["dias_main_nr01"])) ? $this->p85_input["dias_main_nr01"][0] : $this->p85_input["dias_main_nr01"];
            
            //Λεκτικά Modules
            $p82_arr = array();
            if($_SESSION['lang']!=$lang){
                $p82_query = 'select p00,p01,ep01 from p82';                    
                $p82_res = pegasus_query($p82_query);
                while($p82_values = pegasus_fetch_assoc($p82_res)){
                    $p82_arr['peg_dic_'.$p82_values['p00']] = array("GR"=>$p82_values['p01'], "EN"=>$p82_values['ep01']);
                }
            }else{
                foreach ($_SESSION as $key => $value) {
                    if(strpos($key, 'peg_dic_', 0)!==false){
                        $p82_arr[$key] = array($lang=>$value);    
                    }
                }
            }
            
            //Store Titles
            $a55_p0121 = pegasus_mysql_printfld('a55', 'p0121', 'nr01=:a55nr01', array('a55nr01'=>$dias_main_nr01));
            $core_titles_data = invoices_get_store_titles($a55_p0121);

            for($i=1; $i<=8; $i++){ 
                $global_data['cor000_tit_line'.$i] = $core_titles_data[$i-1];
            }
            for($i=1; $i<=8; $i++){ 
                $global_data['cor000_eng_tit_line'.$i] = $core_titles_data[$i+7];
                if(empty($global_data['cor000_eng_tit_line'.$i])){
                    $global_data['cor000_eng_tit_line'.$i] = $core_titles_data[$i-1];
                }
            }

            if(isset($this->p85_input['hidden_values'])){
                $hidden_values = $this->p85_input['hidden_values'];
            }

            //Footer Titles
            if($hidden_values['inv_footer_titles'] !==true){
                $core_footer_data = invoices_get_store_footer($a55_p0121);
                for($i=1; $i<=5; $i++){ 
                    $global_data['f02_ftr00'.$i] = $core_footer_data[$i-1];
                }
                for($i=1; $i<=5; $i++){ 
                    $global_data['f02_eftr00'.$i] = $core_footer_data[$i+4];
                }
            }

            //Table Data
            $main_table_data = static::makeTableData($this->p85_arr['p50'], $dias_main_nr01);
            $counter = count($main_table_data);

            //Extra Table Data
            $copy = isset($this->p85_input['inv_copy']) ? $this->p85_input['inv_copy'] : 0;
            
            if(isset($this->p85_input['non_zero_values'])){
                $non_zero_values = $this->p85_input['non_zero_values'];
            }else{
                $non_zero_values = array('vp0112'=>true, 'vp0113'=>true,'p0601'=>true,'p0600'=>true,'p0108'=>true);
            }
            
            $i13_arr = array();
            $result  = pegasus_query("select * from i13;");
            while($peg_i13=pegasus_fetch_assoc($result)){
                $i13_arr[$peg_i13['p01']] = $peg_i13['p03'];
            }

            if(pegasus_module_exists('orders')){
                pegasus_mysql_use('select apostpno, codpno, s_cost0pno, s_cost1pno, s_cost2pno, s_cost3pno from hero00', $costs);
            }

            for ($j=0; $j<$counter; $j++) { 

                //Logo
                $logo_path = invoices_get_store_logo_path($main_table_data[$j][static::sanitizeExpressionField('a55_nr01_a55_nr01_p0121')]);
                $main_table_data[$j]['invoices_logo'] = $logo_path;

                //Watermark Logo
                $watermark_logo_path = invoices_get_store_watermark_logo_path($main_table_data[$j][static::sanitizeExpressionField('a55_nr01_a55_nr01_p0121')]);
                $main_table_data[$j]['invoices_watermark_logo'] = $watermark_logo_path;

                //Relative Documents
                $main_table_data[$j]['relative_docs_from_transf'] = invcust_print_relative_documents_from_invcust02_string($main_table_data[$j][static::sanitizeExpressionField('a55_nr01_a55_nr01_nr01')], $lang);

                //Ανάλυση ΦΠΑ
                $indx = 1;
                for($i=1; $i<10; $i++) {
                    if($main_table_data[$j][static::sanitizeExpressionField('a55_nr01_a55_nr01_p20'.$i)]>0) {
                        $main_table_data[$j]['fpa_'.$indx.'_net'] = $main_table_data[$j][static::sanitizeExpressionField('a55_nr01_a55_nr01_p20'.$i)];
                        $main_table_data[$j]['fpa_'.$indx.'_vat'] = $main_table_data[$j][static::sanitizeExpressionField('a55_nr01_a55_nr01_p30'.$i)];
                        $main_table_data[$j]['fpa_'.$indx.'_percent'] = $i13_arr[$i];
                        $indx++;
                    }
                }

                //Extra Χρεώσεις
                if(pegasus_module_exists('orders')){
                    $i01_query = "select p01, p02, p03, p04, p08, p010, p010a, p042, p616, p041 from i01 where p06=:a55nr01";
                    $i01_res   = pegasus_query($i01_query, array('a55nr01'=>$dias_main_nr01));
                    
                    while($i01 = pegasus_fetch_assoc($i01_res)) {
                        $cost_key = '';
                        if($i01['p01']==$costs['apostpno']) {
                            $cost_key = 'extras_s_cost';
                        }elseif($i01['p01']==$costs['codpno']) {
                            $cost_key = 'extras_cod';
                        }

                        for($i=0; $i<4; $i++) {
                            if($i01['p01']==$costs['s_cost'.$i.'pno']){
                                $cost_key = 'extras_s_cost'.$i;
                                break;
                            }
                        }

                        if(!empty($cost_key)){
                            $main_table_data[$j][$cost_key] = invoices_make_product_total($i01['p03'], $i01['p04'], $i01['p08'], $i01['p010'], $i01['p010a'], $i01['p041'], $i01['p616'], $main_table_data[$j][static::sanitizeExpressionField('a55_nr01_a55_nr01_p07')], $i01['p042']);
                            $main_table_data[$j][$cost_key . '_title'] = $i01['p02'];
                        }

                    }
                }

                //Συνολική Ποσότητα ανά ΜΜ
                $total_quan_arr = invoices_find_product_total_quan_per_i24("a55", $dias_main_nr01);
                $main_table_data[$j]['product_total_quan_flag'] = (count($total_quan_arr)==1) ? true : false;

                foreach ($total_quan_arr as $i => $quan_arr) {
                    $main_table_data[$j]['product_total_quan_'.$i.'_i24_p01'] = $quan_arr['i24_p01'];
                    $main_table_data[$j]['product_total_quan_'.$i.'_i24_dek'] = $quan_arr['i24_dek'];
                    $main_table_data[$j]['product_total_quan_'.$i]            = $quan_arr['tot_quan'];
                }
                

                //Σύνολα
                //Αν ο Πελάτης Παραστατικού ειναι ο "Πελάτης Λιανικής" (retail) hide Προηγούμενο/Νέο Υπόλοιπο
                if(pegasus_module_exists('estiasi')){
                    /**Βρίσκω το nr01 του este51 για το συγκεκριμένο παραστατικού*/
                    $i01_query = "select 
                            este51.nr01
                        from este03
                        join i01 on i01.pd101='este03' and i01.pd102=este03.nr01
                        join i00 on i00.pno=i01.p01
                        JOIN a55 ON a55.nr01 = i01.p06 AND i01.p07 = 2
                        left join este02 on este02.nr01=este03.p01
                        left join este51 on este51.nr01=este02.p101
                        where a55.nr01 = :a55_nr01";
                    
                    pegasus_mysql_use($i01_query, $i01, array('a55_nr01'=>$dias_main_nr01));
                    if(!empty($i01)){
                        $main_table_data[$j]['v_este51'] = $i01['nr01'];
                    }
                    /** Βρίσκω τον πελάτη του τραπεζιού*/
                    $este51_p04 = pegasus_mysql_printfld('este51', 'p04', 'nr01 = :este51_nr01', array('este51_nr01' => $main_table_data[$j]['v_este51']));

                    /**Αν ο πελάτης του τραπεζιού είναι ίδιος με τον πελάτη του παραστατικού τότε hide Προηγούμενο/Νέο Υπόλοιπο*/
                    if($main_table_data[$j][static::sanitizeExpressionField('a55_nr01_a55_nr01_p03')]==$este51_p04){
                        $hidden_values['p411'] = true;
                        $hidden_values['p413'] = true;
                        $hidden_values['p417'] = true;
                        $hidden_values['p418'] = true;
                    }
                }
                if($main_table_data[$j][static::sanitizeExpressionField('a55_nr01_a55_nr01_p03')]==$_SESSION['customers_000_retail_a01']){
                    $hidden_values['p411'] = true;
                    $hidden_values['p413'] = true;
                    $hidden_values['p417'] = true;
                    $hidden_values['p418'] = true;
                }

                $hidden_values['v616_total']  = (isset($hidden_values['v616_total']))  ? $hidden_values['v616_total']  : true;
                $hidden_values['v1041_total'] = (isset($hidden_values['v1041_total'])) ? $hidden_values['v1041_total'] : true;

                $totals_arr = invoices_find_product_totals("a55", $dias_main_nr01, $non_zero_values, $hidden_values, $lang);
                foreach ($totals_arr as $key => $value) {

                    $main_table_data[$j]['product_totals_'.$key . '_title'] = $totals_arr[$key]['title'];                
                    $main_table_data[$j]['product_totals_'.$key . '_field'] = $totals_arr[$key]['fld'];
                    $main_table_data[$j]['product_totals_'.$key]            = $totals_arr[$key]['value']; 
                    
                    if(isset($totals_arr[$key]['percent'])){
                        $main_table_data[$j]['product_totals_'.$key.'_percent'] = $totals_arr[$key]['percent'];   
                    }
                }
                
                // //Πόντοι παραστατικού
                if(
                    pegasus_module_exists('giftcards')
                    && function_exists('giftcards_find_points_invoice')
                ) {
                    $invoices_points = giftcards_find_points_invoice($dias_main_nr01);
                    $main_table_data[$j]['invoices_points'] = $invoices_points;
                }

                //Πόντοι πελάτη
                if(
                    pegasus_module_exists('giftcards')
                    && function_exists('giftcards_find_points_customer')
                ) {
                    $invoice_info = pegasus_mysql_use("SELECT p01, p02, p03 FROM a55 WHERE nr01 =:var_dias_main_nr01", $invoice_info, array('var_dias_main_nr01'=>$dias_main_nr01));
                    $total_points = giftcards_find_points_customer($invoice_info['p03'], $invoice_info['p01'], $invoice_info['p02'], '','','');
                    $main_table_data[$j]['total_points'] = $total_points;
                }

                //Σύνολα Ολογράφως
                $main_table_data[$j][static::sanitizeExpressionField('a55_nr01_a55_nr01_p0109_ftext')] = pegasus_convert_number_to_text($main_table_data[$j][static::sanitizeExpressionField('a55_nr01_a55_nr01_p0109')], $lang); 

                $mydt10_einv = 0;
                if(
                    (pegasus_module_exists('einv') || pegasus_module_exists('einv01')) &&
                    (pegasus_module_exists('mydt') || pegasus_module_exists('mydt10'))
                ) {
                    // Αν υπάρχει και έχει σημανθεί για ηλεκτρονική τιμολόγηση (einv=1)
                    $mydt10_einv = pegasus_mysql_printfld('mydt10', 'einv', 'tbl="a55" and tbl_nr01 = :tbl_nr01', array('tbl_nr01' => $dias_main_nr01));
                    $mydt00_p103 = pegasus_mysql_printfld('mydt00', 'p103', 'nr01=1');
                }
                

                //Authenticity
                if($hidden_values['orig_copy_dic'] !==true ){
                    $main_table_data[$j]['orig_copy_dic'] = '';
                    if(pegasus_module_exists("ca_servers") && function_exists("ca_server_print_orig_copy_dic")){ 
                        $main_table_data[$j]['orig_copy_dic'] = ca_server_print_orig_copy_dic($copy, $lang); 
                    }elseif(isset($this->p85_input['inv_copy'])){
                        $main_table_data[$j]['orig_copy_dic'] = invoices_print_orig_copy_dic($copy, $lang);
                    } 
                }   
                 


                //Υπογραφή
                $signature_array = InvoicesPrintsClass::getInvoicesSignature("a55", $dias_main_nr01, $lang, $mydt10_einv, $copy, $this->p85_input['ca_server_without_sign']);
                foreach ($signature_array as $key => $value) {
                    $main_table_data[$j][static::sanitizeExpressionField($key)] = $value;
                }
                 

                //Barcode
                $main_table_data[$j]['invoices_barcode_qrcode'] = InvoicesPrintsClass::getInvoicesQRCode("a55", $dias_main_nr01, $mydt10_einv, $copy);
                
                //Query στον i01
                $query = "SELECT * FROM i01 WHERE i01.p06=:var_nr01 and p07=2";
                $query_params = array('var_nr01'=>$dias_main_nr01);
                $i01_res = pegasus_query($query, $query_params);
                //$efk_total = 0;
                $p030_total = 0;
                // $p041_total = 0;
                // $p041_fpa_total = 0;
                $discount_total = 0;
                $tot_weight = 0;
                $tot_volume = 0;
                $tot_volumetric = 0;
                while($i01_values = pegasus_fetch_assoc($i01_res)) {
                    // //ΕΦΚ
                    // $efk_total += round((float)$i01_values['p03']*(float) $i01_values['p616'], 2);
                    //Συνολική δευτερεύουσα ποσότητα
                    $p030_total += round($i01_values['p030'], 2);
                    // //Εισφορά Ανακύκλωσης (Σύνολο)
                    // $p041_total += $i01_values['p041'] * $i01_values['p03'];
                    // //Εισφορά Ανακύκλωσης με ΦΠΑ (Σύνολο)
                    // $p041_fpa_total +=  (float)$i01_values['p041'] * (float)$i01_values['p03'] * (1 + ((float)$i01_values['p08']/100));
                    //Συνολική Έκπτωση από είδη(Ποσό)
                    $discount_1   = $i01_values['p03'] *$i01_values['p04'] * ($i01_values['p010']/100);
                    $discount_2   = ($i01_values['p03'] *$i01_values['p04'] - $discount_1) * ($i01_values['p010a']/100);
                    $discount_total += $discount_1 + $discount_2;
                    pegasus_mysql_use("SELECT p907_1, p907_2, p907_3, p906, p907 FROM i00 WHERE i00.pno=:var_i01_p01", $i00, array("var_i01_p01"=>$i01_values['p01']));
                    //Συνολικό βάρος ειδών
                    $i00_p906   = $i00['p906'];
                    $tot_weight += $i00_p906 * $i01_values['p03'];
                    //Συνολικός όγκος ειδών
                    $tot_volume += $i00['p907'] * $i01_values['p03'];
                    //Συνολικό ογκ.βάρος ειδών
                    $v_weight= 0;
                    if($_SESSION["f01_p014"] > 0){
                        $v_weight= $i00["p907_1"]*$i00["p907_2"]*$i00["p907_3"]*1000000 /$_SESSION["f01_p014"];
                    }                    
                    $tot_volumetric += $v_weight * $i01_values['p03'];
                }

                //Συνολική δευτερεύουσα ποσότητα
                $main_table_data[$j]['i01_p030_total'] = $p030_total;

                //Συνολική Έκπτωση από είδη(Ποσό)
                $main_table_data[$j]['discount_total'] = $discount_total;

                //Συνολικό βάρος ειδών
                $main_table_data[$j]['total_weight'] = $tot_weight;

                //Συνολικός όγκος ειδών
                $main_table_data[$j]['volume_total'] = $tot_volume;

                //Συνολικό ογκ.βάρος ειδών
                $main_table_data[$j]['volumetric_total'] = $tot_volumetric;
                //Oil
                if(
                    pegasus_module_exists('oil00')
                    && isset($this->p85_input['is_oil']) && $this->p85_input['is_oil']
                ) {
                    //κωδικός ΔΙΠΕΘΕ επιχείρησης
                    $main_table_data[$j]['oila98_p01'] = $_SESSION['oila98_p01'];
                    //Κωδικός ΔΙΠΕΘΕ/ΔΕΗ πελάτη
                    $a01_nr01 = $main_table_data[$j][static::sanitizeExpressionField('a55_p03_a01_nr01_nr01')];
                    $invoice_info = pegasus_mysql_use("SELECT p01, p02 FROM oila04 WHERE p00 =:a01_nr01", $oil04, array('a01_nr01'=>$a01_nr01));
                    $main_table_data[$j]['a01_nr01_oil04_p00_p01'] = $oil04['p01'];
                    $main_table_data[$j]['a01_nr01_oil04_p00_p02'] = $oil04['p02'];
                    
                }

                 //B2g
                if(pegasus_module_exists('b2g') && (pegasus_mysql_use("select * from b2g01 where tbl='a55' and tbl_nr01=?;", $b2g01, array($dias_main_nr01)) > 0 )){
                    $main_table_data[$j]['v_b2g01_is_b2g']   = $b2g01['is_b2g'];
                    $main_table_data[$j]['v_b2g01_contrref'] = $b2g01['is_b2g'] > 0 ? $b2g01['contrref']: '';
                    $main_table_data[$j]['v_b2g01_prjref']   = $b2g01['is_b2g'] > 0 ? $b2g01['prjref']: '';
                    $main_table_data[$j]['v_b2g01_buyerref'] = $b2g01['is_b2g'] > 0 ? $b2g01['buyerref']: '';
                    $main_table_data[$j]['v_b2g01_buyerid']  = $b2g01['is_b2g'] > 0 ? $b2g01['buyerid']: '';
                }
                
                //Estiasi
                if(pegasus_module_exists('estiasi')){
                    $query = "select q31.* 
                            from a55
                            left join a10 on a10.p01=a55.p05
                            left join q31 on q31.p03=a10.p01
                            where a55.nr01=:nr01
                            ";
                    pegasus_mysql_use($query, $a55, array('nr01'=>$dias_main_nr01));
                    $main_table_data[$j]['v_q30_620014']   = $a55['p05'];

                    $i01_query = "select 
                            este51.*
                        from este03
                        join i01 on i01.pd101='este03' and i01.pd102=este03.nr01
                        join i00 on i00.pno=i01.p01
                        JOIN a55 ON a55.nr01 = i01.p06 AND i01.p07 = 2
                        left join este02 on este02.nr01=este03.p01
                        left join este51 on este51.nr01=este02.p101
                        where a55.nr01 = :a55_nr01";
                    
                    pegasus_mysql_use($i01_query, $i01, array('a55_nr01'=>$dias_main_nr01));
                    if(!empty($i01)){
                        $main_table_data[$j]['v_este03'] = 1;
                        
                        $main_table_data[$j]['v_este51'] = $i01['pp01'];
                    }
                }

                $global_data = array_merge($global_data, $main_table_data[0]);
            //echo "<pre>". print_r($global_data,1) . "</pre>"; 
            return  $global_data;
        }
    }

                

        protected function getGlobalExpressions(){
            $global_exps = parent::getGlobalExpressions();             
            
            //Footer Titles
            $f02_fields = array('ftr001','ftr002','ftr003','ftr004','ftr005','eftr001','eftr002','eftr003','eftr004','eftr005');
            foreach ($f02_fields as $fld) {
                if(peg_substr($fld, 0, 3)=='ftr'){   
                    $p01 = (int)peg_substr($fld, -1, 1).'η Γραμμή Footer';
                }elseif(peg_substr($fld, 0, 4)=='eftr'){
                    $p01 = (int)peg_substr($fld, -1, 1).'η Γραμμή Footer (EN)';
                }
                $p00  = 'f02_' . $fld;
                $p30  = 'return array("text"=>$pdf->printsData->getData("'.$p00.'"), "autoSizing"=>true);';
                $global_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30, 'p02'=>'C', 'p03'=>60); 
            }
            

            //Table Expressions
            $table_exps = static::getTableExpressions($this->p85_arr['p50']);
            //Extra Table Expressions
            $p30_fn = 'getData';

            //Logo
            $p00 = 'invoices_logo';    $p01 = 'Λογότυπο';
            $p30  = '$logo_path = $pdf->printsData->'.$p30_fn.'("'.$p00 .'");';
            $p30 .= "\n" . 'return invoices_logo_print(1140, 360, $logo_path);';
            $table_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30, 'p02'=>'C', 'p05'=>'image'); 

            //Watermark Logo
            $p00 = 'invoices_watermark_logo';    $p01 = 'Λογότυπο Φόντου';
            $p30  = '$watermark_logo_path = $pdf->printsData->'.$p30_fn.'("'.$p00 .'");';
            $p30 .= "\n" . 'return invoices_logo_print(600, 390, $watermark_logo_path);';
            $table_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30, 'p02'=>'C', 'p05'=>'image'); 

            //Relative Documents
            $p00 = 'relative_docs_from_transf';     $p01 = 'Παραστατικά Μαζικού Μετασχηματισμού';
            $table_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_fn, 'p02'=>'C'); 

            //Authenticity
            $p00 = 'orig_copy_dic';     $p01 = 'Authenticity';
            $table_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_fn, 'p02'=>'C');

            //Φορολογικά Στοιχεία
            $p00 = 'invoices_signature';    $p01 = 'Φορολογικά Στοιχεία';
            $table_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_fn, 'p02'=>'C', 'p05'=>'exp_html'); 

            //Φορολογικά Στοιχεία σε 2 Γραμμές
            $p00 = 'invoices_signature_r2'; $p01 = 'Φορολογικά Στοιχεία σε 2 Γραμμές';
            $table_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_fn, 'p02'=>'C', 'p05'=>'exp_html'); 

            //Φορολογικά Στοιχεία σε 4 Γραμμές
            $p00 = 'invoices_signature_r4'; $p01 = 'Φορολογικά Στοιχεία σε 4 Γραμμές';
            $table_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_fn, 'p02'=>'C', 'p05'=>'exp_html'); 
            

            //Πόντοι παραστατικού 
            $p00 = 'invoices_points';    $p01 = 'Πόντοι παραστατικού';
            $table_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_fn, 'p02'=>'N', 'p03'=>'5', 'p04'=>'2');

            //Πόντοι πελάτη
            $p00 = 'total_points';    $p01 = 'Πόντοι πελάτη';
            $table_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_fn, 'p02'=>'N', 'p03'=>'5', 'p04'=>'2');
          
            //Barcode
            $p00 = 'invoices_barcode_qrcode';  $p01 = 'Barcode (QRCode)';
            $p30 = 'return array("value"=>$pdf->printsData->'.$p30_fn.'("invoices_barcode_qrcode"), "orientation"=>"H", "barcodeType"=>"QRCODE", "text"=>false, "vpadding"=>0, "hpadding"=>0);';
            $table_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30, 'p02'=>'C', 'p05'=>'barcode'); 

            //Ανάλυση ΦΠΑ
            for($i=1; $i<10; $i++){
                $p00  = 'fpa_'.$i.'_percent';   $p01  = 'Ανάλυση Φ.Π.Α.: %Φ.Π.Α.('.$i.')';
                $p30  = '$fpa_percent = $pdf->printsData->getNumber("'.$p00 .'", "2");';
                $p30 .= "\n" . 'return array("text"=>$fpa_percent);';
                $table_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30, 'p02'=>'N', 'p03'=>'5', 'p04'=>'2'); 
               
                
                $p00  = 'fpa_'.$i.'_net';
                $p01  = 'Ανάλυση Φ.Π.Α.: Kαθαρά('.$i.')';
                $p30  = '$fpa_net = $pdf->printsData->getNumber("'.$p00 .'", "2");';
                $p30 .= "\n" . 'return array("text"=>$fpa_net);';
                $table_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30, 'p02'=>'N', 'p03'=>'13', 'p04'=>'2'); 
               
                
                $p00 = 'fpa_'.$i.'_vat';
                $p01 = 'Ανάλυση Φ.Π.Α.: Φ.Π.Α.('.$i.')';
                $p30  = '$fpa_vat = $pdf->printsData->getNumber("'.$p00 .'", "2");';
                $p30 .= "\n" . 'return array("text"=>$fpa_vat);';
                $table_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30, 'p02'=>'N', 'p03'=>'13', 'p04'=>'2'); 
            }


            //Extra Χρεώσεις
            if(pegasus_module_exists('orders')){
                $p00 = 'extras_s_cost_title';   $p01 = 'Κόστος Αποστολής (Τίτλος)';
                $table_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_fn, 'p02'=>'C', 'p03'=>'100'); 
            
                $p00 = 'extras_s_cost';         $p01 = 'Κόστος Αποστολής';
                $table_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_fn, 'p02'=>'N', 'p03'=>'14', 'p04'=>'2'); 

                $p00 = 'extras_cod_title';      $p01 = 'Κόστος Αντικαταβολης (Τίτλος)';
                $table_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_fn, 'p02'=>'C', 'p03'=>'100'); 

                $p00 = 'extras_cod';            $p01 = 'Κόστος Αντικαταβολης';
                $table_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_fn, 'p02'=>'N', 'p03'=>'14', 'p04'=>'2'); 

                for($i=0; $i<4; $i++) {
                    $p00 = 'extras_s_cost'.$i.'_title';     $p01 = 'Κόστος ' . ($i+2) . ' (Τίτλος)';
                    $table_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_fn, 'p02'=>'C', 'p03'=>'100'); 

                    $p00 = 'extras_s_cost'.$i;              $p01 = 'Κόστος ' . ($i+2);
                    $table_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_fn, 'p02'=>'N', 'p03'=>'14', 'p04'=>'2'); 
                }
            }

            //Συνολική Ποσότητα ανά ΜΜ
            for($i=0; $i<5; $i++){
                $p00  = 'product_total_quan_'.$i.'_i24_p01';    $p01 = 'Συνολική Ποσότητα Ειδών ανά ΜΜ ('.$i.') - Περιγραφή';
                $table_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_fn, 'p02'=>'C'); 

                $p00  = 'product_total_quan_'.$i;    $p01 = 'Συνολική Ποσότητα Ειδών ανά ΜΜ ('.$i.')';
                $p30  = '$total_quan = $pdf->printsData->getNumber("'.$p00 .'", $pdf->printsData->getData("product_total_quan_dec_'.$i.'"));';
                $p30 .= "\n" . 'return array("text"=>$total_quan);';
                $table_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30, 'p02'=>'N', 'p03'=>'14', 'p04'=>'3');
            }


            //Σύνολα
            for($i=0; $i<=10; $i++){
                $p00 = 'product_totals_'.$i.'_title';    $p01 = 'Σύνολα ('.$i.') (Τίτλος)';
                $table_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_fn, 'p02'=>'C', 'p03'=>'100'); 

                $p00 = 'product_totals_'.$i;    $p01 = 'Σύνολα ('.$i.')';
                $table_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_fn, 'p02'=>'N', 'p03'=>'13', 'p04'=>'2'); 
            }

            //Σύνολα Ολογράφως
            $p00  = static::sanitizeExpressionField('a55_nr01_a55_nr01_p0109_ftext');
            $p01  = 'Παραστατικά Πελατών -> Σύνολο (Ολογράφως)';
            $table_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_fn, 'p02'=>'C', 'p03'=>'100'); 

           //Συνολική δευτερεύουσα ποσότητα
           $p00 = 'i01_p030_total';    $p01 = 'Συνολική δευτερεύουσα ποσότητα';
           $table_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_fn, 'p02'=>'N', 'p03'=>'5', 'p04'=>'2');
           

            //Συνολική Έκπτωση από είδη(Ποσό)
            $p00 = 'discount_total';    $p01 = 'Συνολική Έκπτωση από είδη(Ποσό)';
            $table_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_fn, 'p02'=>'N', 'p03'=>'5', 'p04'=>'2');

            //Συνολικός όγκος ειδών
            $p00 = 'volume_total';    $p01 = 'Συνολικός όγκος ειδών';
            $table_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_fn, 'p02'=>'N', 'p03'=>'5', 'p04'=>'2');

            //Συνολικό ογκ.βάρος ειδών
            $p00 = 'volumetric_total';    $p01 = 'Συνολικό ογκ.βάρος ειδών';
            $table_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_fn, 'p02'=>'N', 'p03'=>'5', 'p04'=>'2');

           //Συνολικό βάρος ειδών
           $p00 = 'total_weight';    $p01 = 'Συνολικό βάρος ειδών';
           $table_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_fn, 'p02'=>'N', 'p03'=>'5', 'p04'=>'2');

           //Oil
           if(
            pegasus_module_exists('oil00')
            && isset($this->p85_input['is_oil']) && $this->p85_input['is_oil']
        ) {
            //κωδικός ΔΙΠΕΘΕ επιχείρησης
            $p00  = 'oila98_p01';
            $p01  = 'Βασικές Παράμετροι Ήφαιστου';
            $table_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_fn, 'p02'=>'C', 'p03'=>'20'); 
            //Κωδικός ΔΙΠΕΘΕ πελάτη
            $p00  = 'a01_nr01_oil04_p00_p01';
            $p01  = 'Πελάτες ->  Στοιχεία Πελάτη για το Oil -> Κωδικός ΔΙΠΕΘΕ';
            $table_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_fn, 'p02'=>'C', 'p03'=>'20'); 

            //Κωδικός ΔΕΗ πελάτη
            $p00  = 'a01_nr01_oil04_p00_p02';
            $p01  = 'Πελάτες ->  Στοιχεία Πελάτη για το Oil -> Κωδικός ΔΕΗ';
            $table_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_fn, 'p02'=>'C', 'p03'=>'30'); 
        }

        //B2g
            if(pegasus_module_exists('b2g')){
                $p00 = 'v_b2g01_is_b2g';    $p01  = 'Παραστατικό B2G';
                $table_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_fn, 'p02'=>'N', 'p03'=>'5', 'p04'=>'2');
            
                $p00 = 'v_b2g01_contrref';    $p01  = 'Αριθμός Διαδικτυακής Ανάρτησης Σύμβασης (ΑΔΑΜ) (BT-12)';
                $table_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_fn, 'p02'=>'C', 'p03'=>'50'); 

                $p00 = 'v_b2g01_prjref';    $p01  = 'Κωδικός Έργου (BT-11)';
                $table_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_fn, 'p02'=>'C', 'p03'=>'50'); 

                $p00 = 'v_b2g01_buyerref';    $p01  = 'Όνομα Αναθέτουσας Αρχής (BT-10)';
                $table_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_fn, 'p02'=>'C', 'p03'=>'50'); 

                $p00 = 'v_b2g01_buyerid';    $p01  = 'Κωδικός Αναθέτουσας Αρχής (BT-46)';
                $table_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_fn, 'p02'=>'C', 'p03'=>'50'); 
                
            }
            //Estiasi
            if(pegasus_module_exists('estiasi')){
                $p00 = 'v_q30_620014';    $p01  = 'Προς Αποστολή στο myData';
                $table_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_fn, 'p02'=>'N', 'p03'=>'20');

                $p00 = 'v_este03';    $p01  = 'Συνδέεται με este03';
                $table_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_fn, 'p02'=>'C', 'p03'=>'1');

                $p00 = 'v_este51';    $p01  = 'Τραπέζι Παραστατικού';
                $table_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_fn, 'p02'=>'N', 'p03'=>'15');
                
            }

           $global_exps = array_merge($global_exps, $table_exps);
           return $global_exps;
        }

        protected function getBodyExpressions(){

            $body_exps   = array();
            $p30_default = 'getBodyData';

            $body_fields = InvoicesPrintsClass::getProductsQueryFields('a55');

            $fields_query  = "select p50.p01 as p50_p01, p50.p03 as p50_p03, p51.* from p51 ";
            $fields_query .= "join p50 on p50.p02=p51.p02 ";
            $fields_query .= "join p60 on p60.p00=p51.desc16 ";
            $fields_query .= "where p50.p01 in ('i01','i00','i10','i24','i46001') and p50.p102=1 and p60.isdbfld=1 ";
            $fields_query .= "order by field(p50.p01,'i01','i00','i10','i24','i46001'), p51.desc06,p51.nr01;";
            
            $result = pegasus_query($fields_query);
            while ($p51=pegasus_fetch_assoc($result)) {

                if(in_array($p51['p50_p01'], array('i00','i10','i24','i46001'))){
                    if(in_array($p51['p50_p01'].'_'.$p51['desc05'], array_keys($body_fields))){
                        $p00 = $body_fields[$p51['p50_p01'].'_'.$p51['desc05']];  
                    }else{
                        continue;
                    }
                }elseif(in_array($p51['desc05'], array_keys($body_fields))){
                    $p00 = $body_fields[$p51['desc05']]; 
                    if($p00=="v104"){
                        $p51['desc18'] = '$_SESSION["f01_p07"]';    
                    }elseif($p00=="v103"){
                        $p51['desc18'] = '$pdf->printsData->getBodyData("i24_dek")';
                    }
                }else{
                    continue;
                }

                $p01 = $p51['p50_p03'] . ' -> ' . $p51['desc02'];   
                $p05 = static::getExpressionType($p51['desc07']);

                $body_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_default, 'p100'=>1, 'p02'=>$p51['desc16'], 'p03'=>$p51['desc17'], 'p04'=>$p51['desc18'], 'p05'=>$p05); 
            }

            $p00 = 'i24_dek';   $p01 = 'Κινήσεις Ειδών Αποθήκης -> Μονάδες Μέτρησης Αποθήκης -> Δεκαδικά Ποσότητας';
            $body_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_default, 'p100'=>1, 'p02'=>'N', 'p03'=>'2');
            
            $p00 = 'i71_tot';
            $p01 = 'Φόροι/Κρατήσεις ανά Παραστατικό/Παραγγελια -> Σύνολο Φόρων/Κρατήσεων';
            $body_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_default, 'p100'=>1, 'p02'=>'N', 'p03'=>'13', 'p04'=>'2'); 


            //Extra Body Expressions

            //Product Price No VAT included
            $p00  = 'v104_no_vat';     $p01  = 'Κινήσεις Ειδών Αποθήκης -> Τιμή Μονάδας (χωρίς Φ.Π.Α.)';
            $p30  = '$prd_price = InvoicesPrintsClass::previewPrice($pdf->printsData->getBodyData("v104"), $pdf->printsData->getData("'.static::sanitizeExpressionField('a55_nr01_a55_nr01_p07').'"), $pdf->printsData->getBodyData("v105"), 0);';
            $p30 .= "\n" . 'return array("text"=>peg002_format_number($prd_price, $_SESSION["f01_p07"]));';   
            $body_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30, 'p100'=>1, 'p02'=>'N', 'p03'=>'14', 'p04'=>'5');  
            
            //Product Price VAT included 
            $p00  = 'v104_vat';     $p01  = 'Κινήσεις Ειδών Αποθήκης -> Τιμή Μονάδας (με Φ.Π.Α.)';
            $p30  = '$prd_price = InvoicesPrintsClass::previewPrice($pdf->printsData->getBodyData("v104"), $pdf->printsData->getData("'.static::sanitizeExpressionField('a55_nr01_a55_nr01_p07').'"), $pdf->printsData->getBodyData("v105"), 1);';
            $p30 .= "\n" . 'return array("text"=>peg002_format_number($prd_price, $_SESSION["f01_p07"]));';   
            $body_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30, 'p100'=>1, 'p02'=>'N', 'p03'=>'14', 'p04'=>'5');       



            //Products Total Price
            $p30_fn = '$prd_total = invoices_make_product_total(
                $pdf->printsData->getBodydata("v103"), 
                $pdf->printsData->getBodydata("v104"), 
                $pdf->printsData->getBodydata("v105"), 
                $pdf->printsData->getBodydata("v106"), 
                $pdf->printsData->getBodydata("v106a"), 
                $pdf->printsData->getBodydata("v1041"), 
                $pdf->printsData->getBodydata("v616"),
                $pdf->printsData->getData("'.static::sanitizeExpressionField('a55_nr01_a55_nr01_p07').'"),
                $pdf->printsData->getBodydata("v1042")
            );';

            $p00  = 'v107';     $p01  = 'Σύνολο Τιμής Είδους';
            $p30  = 'if($pdf->printsData->getBodyData("nr01")<0){ return ""; }';
            $p30 .= "\n" . $p30_fn;
            $p30 .= "\n" . 'return array("text"=>peg002_format_number($prd_total, 2));';   
            $body_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30, 'p100'=>1, 'p02'=>'N', 'p03'=>'13', 'p04'=>'3');          
            
            //Products Total Price No VAT included
            $p00  = 'v107_no_vat';     $p01  = 'Σύνολο Τιμής Είδους (χωρίς Φ.Π.Α.)';
            $p30  = 'if($pdf->printsData->getBodyData("nr01")<0){ return ""; }';
            $p30 .= "\n" . $p30_fn;
            $p30 .= "\n" . '$prd_total = InvoicesPrintsClass::previewPrice($prd_total, $pdf->printsData->getData("'.static::sanitizeExpressionField('a55_nr01_a55_nr01_p07').'"), $pdf->printsData->getBodyData("v105"), 0);';
            $p30 .= "\n" . 'return array("text"=>peg002_format_number($prd_total, 2));';   
            $body_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30, 'p100'=>1, 'p02'=>'N', 'p03'=>'13', 'p04'=>'3');          
            

            //Products Total Price VAT included
            $p00  = 'v107_vat';     $p01  = 'Σύνολο Τιμής Είδους (με Φ.Π.Α.)';
            $p30  = 'if($pdf->printsData->getBodyData("nr01")<0){ return ""; }';
            $p30 .= "\n" . $p30_fn;
            $p30 .= "\n" . '$prd_total = InvoicesPrintsClass::previewPrice($prd_total, $pdf->printsData->getData("'.static::sanitizeExpressionField('a55_nr01_a55_nr01_p07').'"), $pdf->printsData->getBodyData("v105"), 1);';
            $p30 .= "\n" . 'return array("text"=>peg002_format_number($prd_total, 2));';   
            $body_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30, 'p100'=>1, 'p02'=>'N', 'p03'=>'13', 'p04'=>'3');  

            // Barcode Αναζήτησης
            $p00  = 'search_barcode';         $p01 = 'Barcode Αναζήτησης';
            $p30  = 'if(!empty($pdf->printsData->getBodyData("v101b"))) { ';
            $p30 .= "\n" .'   $search_barcode = $pdf->printsData->getBodyData("v101b");';
            $p30 .= "\n" .'} else {';
            $p30 .= "\n" .'   $search_barcode = $pdf->printsData->getBodyData("v101");';
            $p30 .= "\n" .'}';
            $p30 .= "\n" . 'return array("text"=>$search_barcode);';   
            $body_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30, 'p100'=>1, 'p02'=>'M', 'p05'=>'exp_memo'); 
            
            $p00 = 'perigrafi';         $p01 = 'Πλήρης Περιγραφή';
            $body_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_default, 'p100'=>1, 'p02'=>'M', 'p05'=>'exp_memo'); 
                       
            $p00 = 'color_size';        $p01 = 'Χρωμα/Μέγεθος Περιγραφες x Ποσότητα';
            $body_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_default, 'p100'=>1, 'p02'=>'M', 'p05'=>'exp_memo'); 
            
            $p00 = 'color_size_code';   $p01 = 'Χρωμα/Μέγεθος Κωδικοί x Ποσότητα';
            $body_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_default, 'p100'=>1, 'p02'=>'M', 'p05'=>'exp_memo'); 

            //Serials
            $p00 = 'serials';           $p01 = 'Serial Number';
            $p30 = 'return InvoicesPrintsClass::getProductSerialNumbers($pdf->printsData->getBodyData("nr01"), "a55");';   
            $body_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30, 'p100'=>1, 'p02'=>'M', 'p05'=>'exp_memo');  

            $p00 = 'serials_with_crm';   $p01 = 'Serial Number (CRM)';
            $p30 = 'return InvoicesPrintsClass::getProductSerialNumbers($pdf->printsData->getBodyData("nr01"), "a55", true);';   
            $body_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30, 'p100'=>1, 'p02'=>'M', 'p05'=>'exp_memo');  


            //Αντιστοιχία 
            $p00 = 'i00_p9001';    $p01 = 'Αντιστοιχία';
            $p30 = '$i00_p9001 = pegasus_mysql_printfld("i00", "p9001", "pno=:i00_pno", array("i00_pno"=>$pdf->printsData->getBodyData("v101")));';
            $p30 .= "\n" . 'return array("text"=>$i00_p9001);';
            $body_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30, 'p100'=>1, 'p02'=>'M', 'p05'=>'exp_memo'); 



            //ΕΦΚ Μονάδας
            $p00  = 'efk';    $p01 = 'Ε.Φ.Κ. Ανά Μονάδα'; 
            $p30  = '$efk = invoices_make_product_v616($pdf->printsData->getBodyData("v616"), $pdf->printsData->getBodyData("v105"), $pdf->printsData->getData("'.static::sanitizeExpressionField('a55_nr01_a55_nr01_p07').'"));';
            $p30 .= "\n" . 'return array("text"=>peg002_format_number($efk, 2));'; 
            $body_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30, 'p100'=>1, 'p02'=>'N', 'p03'=>'7', 'p04'=>'2');


            //Εισφορά Ανακύκλωσης 
            $p00  = 'i01_p041';    $p01 = 'Εισφορά Ανακύκλωσης Ανά Μονάδα';
            $p30  = '$i01_p041 = invoices_make_product_v1041($pdf->printsData->getBodyData("v1041"), $pdf->printsData->getBodyData("v105"), $pdf->printsData->getData("'.static::sanitizeExpressionField('a55_nr01_a55_nr01_p07').'"));';
            $p30 .= "\n" . 'return array("text"=>peg002_format_number($i01_p041, 2));'; 
            $body_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30, 'p100'=>1, 'p02'=>'N', 'p03'=>'7', 'p04'=>'2');

            //Έκπτωση ανά γραμμή είδους(Ποσό)
            $p00 = 'total_item_discount';    $p01 = 'Έκπτωση ανά γραμμή είδους(Ποσό)';
            $p30 = '$v103 = $pdf->printsData->getBodyData("v103");';
            $p30 .= '$v104 = $pdf->printsData->getBodyData("v104");';
            $p30 .= '$discount1_percent = $pdf->printsData->getBodyData("v106");';
            $p30 .= '$discount2_percent = $pdf->printsData->getBodyData("v106a");';
            $p30 .= '$discount1         = $v103 * $v104 * ($discount1_percent/100);';
            $p30 .= '$discount2         = ($v103 * $v104 - $discount1)*($discount2_percent/100);';
            $p30 .= "\n" . 'return array("text"=>peg002_format_number($discount1 + $discount2, 2));';
            $body_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30, 'p100'=>1, 'p02'=>'N', 'p03'=>'5', 'p04'=>'2');

            //Συνολικό βάρος γραμμής
            $p00 = 'total_item_weight';   $p01 = 'Συνολικό βάρος γραμμής';
            $p30 = '$v103 = $pdf->printsData->getBodyNumber("v103", $pdf->printsData->getBodyData("i24_dek"));';
            $p30 .= '$i00_p906 = pegasus_mysql_printfld("i00", "p906", "pno=:i00_pno", array("i00_pno"=>$pdf->printsData->getBodyData("v101")));';
            $p30 .= "\n" . 'return array("text"=>(float)$v103 * (float)$i00_p906);';
            $body_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30, 'p100'=>1, 'p02'=>'N', 'p03'=>'5', 'p04'=>'2');

            //Συνολικό όγκου γραμμής
            $p00 = 'total_item_volume';   $p01 = 'Συνολικός όγκος γραμμής';
            $p30 = '$i00_p907 = pegasus_mysql_printfld("i00", "p907", "pno=:i00_pno", array("i00_pno"=>$pdf->printsData->getBodyData("v101")));';
            $p30 .= '$i01_p03 = $pdf->printsData->getBodyNumber("v103", $pdf->printsData->getBodyData("i24_dek"));';
            $p30 .= "\n" . 'return array("text"=>(float)$i00_p907 * (float)$i01_p03);';
            $body_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30, 'p100'=>1, 'p02'=>'N', 'p03'=>'5', 'p04'=>'2');

            //Συνολικό ογκ.βάρος γραμμής
            $p00 = 'total_item_volumetric';   $p01 = 'Συνολικό ογκ.βάρος γραμμής';
            $p30 = 'pegasus_mysql_use("SELECT p907_1, p907_2, p907_3 FROM i00 WHERE i00.pno=:i00_pno", $v_weight, array("i00_pno"=>$pdf->printsData->getBodyData("v101")));';
            $p30 .='if(!empty($_SESSION["f01_p014"]) && $_SESSION["f01_p014"] > 0){';
            $p30 .='$v_weight=$v_weight["p907_1"]*$v_weight["p907_2"]*$v_weight["p907_3"]*1000000 /$_SESSION["f01_p014"];';
            $p30 .='}else{$v_weight=0;}';
            $p30 .= '$i01_p03 = $pdf->printsData->getBodyNumber("v103", $pdf->printsData->getBodyData("i24_dek"));';
            $p30 .= "\n" . 'return array("text"=>(float)$v_weight * (float)$i01_p03);';
            $body_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30, 'p100'=>1, 'p02'=>'N', 'p03'=>'5', 'p04'=>'2');

            //Barcode (string)
            $p00 = 'item_barcode';   $p01 = 'Barcode είδους';
            $p30 = '$i01_p01 = pegasus_mysql_printfld("i00", "p01", "i00.pno = :v101", array("v101" => $pdf->printsData->getBodyData("v101")));';
            $p30 .= "\n" . 'return array("text"=>$i01_p01);';
            $body_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30, 'p100'=>1, 'p02'=>'M', 'p05'=>'exp_memo');  

            //Κατηγορία Είδους
            $p00 = 'i46_p02';   $p01 = 'Κατηγορία Είδους';
            $p30 = '$i46_p02 = pegasus_mysql_printfld("i46", "p02", "i46.p01 = :p9903", array("p9903" => $pdf->printsData->getBodyData("i00_p9903")));';
            $p30 .= "\n" . 'return array("text"=>$i46_p02);';
            $body_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30, 'p100'=>1, 'p02'=>'M', 'p05'=>'exp_memo');  

            //Φωτογραφία Είδους (50x50)
            $p00 = 'i00_i02_00';    $p01 = 'Φωτογραφία Είδους (50x50)';            
            $p30 = '$i00_i02_00 = inventory_MakeProductPhoto(0, $pdf->printsData->getBodyData("v101"), 0, "", false, 50, 50);';
            $p30 .= "\n" . 'return array("text"=>$i00_i02_00);';      
            $body_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30, 'p100'=>1, 'p02'=>'M', 'p05'=>'exp_html');

            return $body_exps;
        }

    }
