<?php

/**
 * Γυρνάει ένα string με τα παραστατικά που μετασχηματίστηκαν από τον μαζικό μετασχηματισμό 
 * @param mixed $nr01 
 * @return string 
 */
function invcust_print_relative_documents_from_invcust02_string($nr01, $lang = "GR")
{
    $ret_str = '';
    $i01_query = "
                    select a55_rel.* , a10_rel.p00 as a10_rel_p00 
                        from i01 
                        join a55 on a55.nr01 = i01.p06 /*Μετασχηματισμένο Παραστατικό*/

                        join i01 as i01_rel on i01_rel.nr01 = i01.p3051 /*Η αρχική κίνηση που μετασχηματίστηκε*/
                        join a55 as a55_rel on a55_rel.nr01 = i01_rel.p06 /*Το αρχικό παραστατικό που μετασχημετίστηκε*/
                        join a10 as a10_rel on a10_rel.p01 = a55_rel.p05
                        
                        where 
                        i01.p06 = :a55_nr01 and i01.p07 = 2 and
                        a55.p601 = 0 /*Πρόκειται για μαζικό μετασχηματισμό και όχι για μεμονωμένο μετασχηματισμό*/

                        group by a55_rel.nr01
                    ";


    $peg_res = pegasus_query($i01_query, array('a55_nr01' => $nr01));
    while ($peg_a55 = pegasus_fetch($peg_res)) {
        $ret_str .= !empty($ret_str) ? ", " : "";
        $ret_str .= $peg_a55['a10_rel_p00'] . ' ' . $peg_a55['p701'] . ' ' . pegasus_leading_zeros($peg_a55['p06'], 8);
    }
    if($lang == "GR"){
        $ret_str = !empty($ret_str) ? "ΜΕΤΑΣΧ: " . $ret_str : "";
        return $ret_str;
    }

    $ret_str = !empty($ret_str) ? "TRANSF: " . $ret_str : "";
    return $ret_str;
}
