<?php

/**
 * Προσθήκης προεπιλεγμένων ειδών στο παραστατικό υπηρεσιών
 *
 * @param array $data
 * @param string $mmnr01
 * @param integer $mnr01
 * @param string $_d
 * @param string $container_id
 * @return array
 */
function peg_invcust01_a55_d_initialize_i01_tmp(
	$data = array(),
	$mmnr01 = '',
	$mnr01 = 0,
	$_d = '',
	$container_id = ''
) {
	try {
		$invcust01_00_i00pno = $_SESSION['invcust01_00_i00pno'];
		$i00 = explode("#", $invcust01_00_i00pno);
		//  Αν ΔΕΝ υπάρχουν προεπιλεγμένα ειδή
		if (
			count($i00) == 0
		) {
			return $data;
		}
		array_pop($i00);
		array_shift($i00);
		//  Αν δεν υπάρχουν τα function της online καταχώρησης
		if (
			!function_exists('invoices__invoices_online_find')
			|| !function_exists('invoices__invoices_online_insert')
		) {
			throw new Exception($_SESSION['peg_dic_invcust01_a55_d_initialize_i01_tmp_nosupport'], 1);
		}
		//  Για κάθε ένα από τα pno
		foreach ($i00 as $i00_pno) {
			//  Βρίσκουμε το Είδος
			$resp = invoices__invoices_online_find(
				$i00_pno,
				0
			);
			if ($resp['ok'] != 1) {
				throw new Exception($resp['msg'], 1);
			}
			//  Προσθέτουμε το Είδος
			$resp = invoices__invoices_online_insert(
				$mmnr01,
				$mnr01,
				$resp['data']['code'],
				$resp['data']['p9000'],
				$resp['data']['ser'],
				$resp['data']['timh1'],
				$resp['data']['timh2'],
				$resp['data']['timh3'],
				$resp['data']['timh4'],
				$resp['data']['type'],
				$resp['data']['v101'],
				$resp['data']['v102'],
				$resp['data']['v103'],
				$resp['data']['v161'],
				$resp['data']['v172'],
				$resp['data']['v173'],
				$resp['data']['v_baltot'],
				$resp['data']['v_cusord'],
				$resp['data']['v_locbaltot'],
				$resp['data']['v_loccusord'],
				$resp['data']['v_locsuppord'],
				$resp['data']['v_suppord'],
				$resp['data']['vtype'],
				$data['p09'],
				'',
				date("Y-m-d")
			);
			if ($resp['ok'] != 1) {
				throw new Exception($resp['msg'], 1);
			}
		}
		return $data;
	} catch (Exception $e) {
		$msg = $_SESSION['peg_dic_invcust01_a55_d_initialize_i01_tmp_error'];
		if ($e->getCode() == 1) {
			$msg = $e->getMessage();
		}
		$data['permDeny'] = 1;
		$data['permDenyMessage'] = $msg;
		return $data;
	}
}
/**
 * @deprecated
 */
function invcust01_query_where_string_of_a55()
{
	$where_arr = invcust01_query_where_of_a55();
	if ($where_arr == null) {
		return '';
	}
	return pegasus_replace_values_in_sql(' and ' . $where_arr['sql'], $where_arr['sqlParams']);
}
/**
 * @return array('sql', 'sqlParams') or null
 */
function invcust01_query_where_of_a55()
{
	$where = array();
	$where['sql'] = '';
	$where['sqlParams'] = array();
	if (isset($_SESSION['invcust01_00_fa10p01']) && !empty($_SESSION['invcust01_00_fa10p01'])) {
		$multi = explode('#', trim($_SESSION['invcust01_00_fa10p01'], '#'));
		$invcust01_00_fa10p01_in = '';
		foreach ($multi as $key => $value) {
			if (!empty($invcust01_00_fa10p01_in)) {
				$invcust01_00_fa10p01_in .= ', ';
			}
			$invcust01_00_fa10p01_in .= ':var' . $key;
			$where['sqlParams']['var' . $key] = $value;
		}
		if (!empty($invcust01_00_fa10p01_in)) {
			$where['sql'] .= ' a55.p05 in ( ' . $invcust01_00_fa10p01_in . ') ';
		}
	}
	if ($where['sql'] == '') {
		return null;
	}
	return $where;
}

function peg_invcust01_a55_d_initialize($data, $mmnr01 = '', $mnr01 = '', $_d = '', $container_id = '')
{

	//Κάνω έλεγχο και στη βάση ωστε να μην υπάρχει θεμα αν αλλάξει η θέση
	//που καλείται η peg_invcust01_a55_d_initialize
	if (
		!($_REQUEST['rec_copy_nr01'] > 0) 
		&& !(pegasus_mysql_printfld('a55', 'nr01', 'nr01=?', array($data['nr01'])) > 0)
	) {
		if (isset($_SESSION['invcust01_00_a10p01']) && $_SESSION['invcust01_00_a10p01'] > 0) {
			$data['p05'] = $_SESSION['invcust01_00_a10p01'];

			// Ε:10000058
			// Ξανά κάνουμε έλεγχο για την σειρά του παραστατικου
			$data =  invoices_find_p05_data($data, 'a55', true);
		}
	}
	if (isset($_SESSION['invcust01_00_fa10p01']) && !empty($_SESSION['invcust01_00_fa10p01'])) {
		$where = array();
		$where['sql'] = '';
		$where['sqlParams'] = array();
		$multi = explode('#', trim($_SESSION['invcust01_00_fa10p01'], '#'));
		$invcust01_00_fa10p01_in = '';
		foreach ($multi as $key => $value) {
			if (!empty($invcust01_00_fa10p01_in)) {
				$invcust01_00_fa10p01_in .= ', ';
			}
			$invcust01_00_fa10p01_in .= ':var' . $key;
			$where['sqlParams']['var' . $key] = $value;
		}
		if (!empty($invcust01_00_fa10p01_in)) {
			$where['sql'] .= '  a10.p01 in ( ' . $invcust01_00_fa10p01_in . ') ';
		}
		$data['invcust01_p05_where_arr'] = $where;
	}
	//$data['{module}_{_d}_{tab fld name}_{custom_id}_hidden']
	//$data['invcust_a55_d_tab_a55_d3_custom_id_hidden'] = true;

	// Μ.Κ.:2058339
	$data['p702_hidden'] = true;
	$data['p013_hidden'] = true;
	$data['p014_hidden'] = true;
	$data['p012_hidden'] = true;
	if($_SESSION['invcust01_00_show_a55p702']) {
		$data['p702_hidden']=false;
	}
	if($_SESSION['invcust01_00_show_a55p013']) {
		$data['p013_hidden']=false;
	}
	if($_SESSION['invcust01_00_show_a55p014']) {
		$data['p014_hidden']=false;
	}
	if($_SESSION['invcust01_00_show_a55p012']) {
		$data['p012_hidden']=false;
	}


	$data['p017_hidden'] = true;
	$data['pl601_hidden'] = true;
	return $data;
}
function peg_invcust01_a55_d00_initialize($data, $mmnr01 = '', $mnr01 = '', $_d = '', $container_id = '')
{

	$data['invcust01_where_arr'] = invcust01_query_where_of_a55();
	return $data;
}
function peg_invcust01_a55_d5_initialize($data, $mmnr01 = '', $mnr01 = '', $_d = '', $container_id = '')
{

	// Eίναι το fieldset των Τοπικών Συνολων δεν εχει νοημα να κρυβεται στις υπήρεσιες
	//$data['fldset01_hidden'] = true;

	return $data;
}
function peg_invcust01_a55_d8_initialize($data, $mmnr01 = '', $mnr01 = '', $_d = '', $container_id = '')
{

	$data['invcust01_a55_d8_grid_invoices_eidi_mass_selection_hidden'] = false;

	if ($data['is_invoice_cancel'] == 1) {
		$data['invcust_a55_d8_readonly'] = 1;
	}
	return $data;
}
function invcust01_invcust01_00_check_values($data, $permDeny, $mmnr01, $checkOnlyPerm)
{
	$ok = false;
	if (
		isset($data['a10p01']) && ($data['a10p01'] > 0) &&
		isset($data['fa10p01']) && !empty($data['fa10p01'])
	) {
		$multi = explode('#', trim($data['fa10p01'], '#'));
		foreach ($multi as $key => $value) {
			if ($value == $data['a10p01']) {
				$ok = true;
				break;
			}
		}
	} else {
		$ok = true;
	}

	if (!$ok) {
		array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_invcust01_00_a10p01_not_valid']));
	}
	return array('data' => $data, 'permDeny' => $permDeny);
}
