<?php
require('../invcust00/header.php');

global $PegInput;
$PegInput->addVar(new peg_input_alphanumeric('peg_grid_dt_from'));
$dt_from = $PegInput->getRequest('peg_grid_dt_from');

$PegInput->addVar(new peg_input_alphanumeric('peg_grid_dt_to'));
$dt_to = $PegInput->getRequest('peg_grid_dt_to');

$PegInput->addVar(new peg_input_alphanumeric('peg_grid_status'));
$status = $PegInput->getRequest('peg_grid_status');

$PegInput->addVar(new peg_input_number('offset'));
$offset = $PegInput->getRequest('offset');

$PegInput->addVar(new peg_input_alphanumeric('invcust_step'));
$invcust_step = $PegInput->getRequest('invcust_step');

$PegInput->addVar(new peg_input_alphanumeric('a57'));
$a57 = $PegInput->getRequest('a57');

$PegInput->addVar(new peg_input_alphanumeric('peg_grid_a10'));
$a10 = $PegInput->getRequest('peg_grid_a10');

// STEPS
// 1 find all proformas
// 2,3...n Billing records 

// την πρώτη φορά θα αρχικοποιηθεί το step
if (empty($invcust_step)) {
    $invcust_step = 'auth_user';
}

$ret = array();
$log = '';
$limit = 10; // εδώ ορίζουμε πόσα παραστατικά να φτιάχνει την φορά

switch ($invcust_step) {
    case 'auth_user':
        // Μήνυμα μπάρας - $_SESSION["peg_dic_invcust_from_a57_to_a55_auto_6"]
        peg_write_file('../../tmp/p92_exec.txt', "Aυθεντικοποίηση χρήστη");

        $us0_nr01 = pegasus_mysql_printfld('us0', 'nr01', 'nr01=:nr01', array('nr01'=>$_SESSION['user']));
        // Συνθήκη τερματισμού του αυτοματισμού
        if ($us0_nr01 > 0) {
            $next_step = "find_proformas_records";
            $_REQUEST['dt_from'] = $dt_from;
            $_REQUEST['dt_to'] = $dt_to;
            $_REQUEST['status'] = $status;
            $log .= $_SESSION["peg_dic_invcust_from_a57_to_a55_auto_6"];
        } else {
            // Μη έγκυρος χρήστης!
            $log .= $_SESSION["peg_dic_invcust_from_a57_to_a55_auto_5"];
            $next_step = "last_step";
        }

        // set Requests
        $_REQUEST['log'] = $log;
        $_REQUEST['invcust_step'] = $next_step;

        pegasusSetGlobalVar('p92_d00_go_next', $_REQUEST);

        peg_write_file('../../tmp/p92_exec_again.txt', '1');

        // set ret array
        $ret['ok'] = 1;
        $ret['exec_next'] = 1;
        $ret['invcust_step'] = $invcust_step;
        $ret['next_invcust_step'] = $next_step;
        echo json_encode($ret);
        return;
        break;
    case 'find_proformas_records':
        // Μήνυμα μπάρας - Εύρεση των παραγγελιών
        peg_write_file('../../tmp/p92_exec.txt', $_SESSION["peg_dic_invcust_from_a57_to_a55_auto_1"]);

        // step logic
        $params = array();
        $dt_from = $dt_from != '' ? peg_strTodate($dt_from, 'd/m/Y') : "0000-00-00";
        $dt_to   = $dt_to != '' ? peg_strTodate($dt_to, 'd/m/Y') : "2099-01-01";

        $params['dt_from'] = $dt_from;
        $params['dt_to'] = $dt_to;

        // setάρω τις καταστάσεις για το query με pdo
        $status = explode('#', $status);
        foreach ($status as $key => $value) {
            if ($value == '') {
                unset($status[$key]);
            }
        }

        $in_stmt = pegasus_mysql_create_in($status, 'a33');
        $params = array_merge($params, $in_stmt['sqlParams']);

		$where = '';

        if (!empty($in_stmt['sqlParams'])) {
            $where .= " AND a57.p590 IN (" . $in_stmt['sql'] . ")";
        }

		

		// a10 filter (E:10000434)
		if(!empty($a10)) {
			$a10 = explode('#',$a10);
			foreach ($a10 as $key => $value) {
				if ($value == '') {
					unset($a10[$key]);
				}
			}
			$in_stmt = pegasus_mysql_create_in($a10, 'a10');
        	$params = array_merge($params, $in_stmt['sqlParams']);
			if (!empty($in_stmt['sqlParams'])) {
				$where .= " AND a57.p05 IN (" . $in_stmt['sql'] . ")";
			}
		}
		//
        $query = "  SELECT a57.* 
                    FROM a57
                    LEFT JOIN a33 ON a33.p01 = a57.p590 AND a33.p05_1<>1 /** p05_1: Δεν τιμολογείται η παραγγελία */
                    WHERE   a33.nr01>0 AND
                            a57.p01>=:dt_from AND 
                            a57.p01<=:dt_to" . $where .
            " ORDER BY nr01 ";
        $res = pegasus_query($query, $params);

       // echo pegasus_replace_values_in_sql($query, $params);

        $new_records = 0; // χρήσιμο για συνθήκη τερματισμού
        $a57_nr01 = array(); // κρατάμε όλα τα nr01 των παραγγελιών που θα γίνουν παραστατικά

        while ($row = pegasus_fetch_assoc($res)) {
            $new_records++;
            array_push($a57_nr01, $row['nr01']);
        }

        // το κάνω json και το στέλνω με request για να έχω τα Μ.Κ.
        $a57 = json_encode($a57_nr01);
        $_REQUEST['a57'] = $a57;

        // Μήνυμα log - Εκτέλεση query εύρεσης των παραγγελιών
        $log .= $_SESSION["peg_dic_invcust_from_a57_to_a55_auto_2"];

        // Συνθήκη τερματισμού του αυτοματισμού
        if ($new_records == 0) {
            // Δεν βρέθηκαν παραγγελίες!
            $log .= "\n" . $_SESSION["peg_dic_invcust_from_a57_to_a55_auto_3"];
            $next_step = "last_step";
        } else {
            $next_step = "records_billing";
            $_REQUEST['offset'] = 0;
        }

        // set Requests
        $_REQUEST['log'] = $log;
        $_REQUEST['invcust_step'] = $next_step;

        pegasusSetGlobalVar('p92_d00_go_next', $_REQUEST);

        peg_write_file('../../tmp/p92_exec_again.txt', '1');

        // set ret array
        $ret['ok'] = 1;
        $ret['exec_next'] = 1;
        $ret['invcust_step'] = $invcust_step;
        $ret['next_invcust_step'] = $next_step;
        echo json_encode($ret);
        return;
        break;
    case 'records_billing':

        $a57_array = json_decode($a57, true);

        $new_records = 0; // χρήσιμο για συνθήκη τερματισμού

        // Billing each record from offset to offset+limit
        for ($i = $offset; $i < ($offset + $limit); $i++) {
            $a57_arr = array();
            $a57_arr['nr01'] = $a57_array[$i];
            if ($a57_arr['nr01'] > 0) {
                $my_arr = invcust_create_a55($a57_arr);
                // Μήνυμα μπάρας
                peg_write_file('../../tmp/p92_exec.txt', $my_arr['message']);
                $log .= $my_arr['message'] . "***Αφορά την παραγγελία με Μ.Κ.: " . $a57_arr['nr01'] . "\n";
                $new_records++;
            }
        }

        // Συνθήκη τερματισμού του αυτοματισμού
        if ($new_records == 0) {
            // Δεν βρέθηκαν παραγγελίες!
            $log .= $_SESSION["peg_dic_invcust_from_a57_to_a55_auto_3"];
            $next_step = "last_step";
        } else {
            $next_step = "records_billing";
            $offset = $offset + $limit;
            $_REQUEST['offset'] = $offset;
            $_REQUEST['a57'] = $a57; // το μεταφερουμε απλα..
        }

        // set Requests
        $_REQUEST['log'] = $log;
        $_REQUEST['invcust_step'] = $next_step;

        pegasusSetGlobalVar('p92_d00_go_next', $_REQUEST);

        peg_write_file('../../tmp/p92_exec_again.txt', '1');

        // set ret array
        $ret['ok'] = 1;
        $ret['exec_next'] = 1;
        $ret['invcust_step'] = $invcust_step;
        $ret['next_invcust_step'] = $next_step;
        echo json_encode($ret);
        return;
        break;
    case 'last_step':
        // Μήνυμα log - Ο αυτοματισμός ολοκληρώθηκε!
        $log .= $_SESSION["peg_dic_invcust_from_a57_to_a55_auto_4"];

        $ret['ok'] = 1;
        $ret['exec_next'] = 0;
        $ret['log'] = $log;
        $ret['msg'] = $_SESSION['peg_dic_core_pros_ok'];
        echo json_encode($ret);
        return;
        break;
    default:
        break;
}