/**
 *  @class inventory
 *  
 *  ##Properties
 *  
 *  The global variables of the module
 *   
 *  ##Methods
 *  
		- General functions
		- Start After draw listeners
 *  
 *	The functions of the module
 *  
 */

var inventory_updateCategoryActionReq='';
function inventory_updateCategory(container_id){
	var inventory_params = {};
	
	inventory_params.container_id = container_id;
	inventory_params   = Ext.Object.merge(inventory_params, pegGetFormVal(container_id));
	inventory_params.confirm = 1;	
	if(inventory_updateCategoryActionReq!=''){
	   if(inventory_updateCategoryActionReq.dias_fld_mnr01>0){ 
		  Ext.ux.AjaxDefer.abort(inventory_updateCategoryActionReq);  
	   }
    }
	
	inventory_updateCategoryActionReq = pegAjax('/' + main_path + '/inventory02/updatecategory00.php' , inventory_params , function(jsondata){

		if(jsondata.confirm==0){
			pegAlert(jsondata.msg);
		}else{
			
			pegConfirmBox( '' , jsondata.msg , function(but){
				 if(but=='yes'){
						//pegAlert('update');
					 pegAjax('/' + main_path + '/inventory02/updatecategory01.php' , inventory_params, function(json_data){
						 if(json_data.ok==1){
							 pegAlert(json_data.msg);
						 }
					 } );
				 }
		 	});
		}	 
	} , 'json');
}
/**
 * The requestin XSR on function {@link inventory_d00_d7_prices}
 * @type {string}
 */
var inventory_d00_d7_prices_ajax='';	
function inventory_d00_d7_prices(container_id, called_from){
	var i00_d7_container_id   =  pegGetContainer_id_d(container_id , 'i00_d7'   , '' , 'i00_d' );
	
	var i00_params = {};	
	i00_params = Ext.Object.merge(i00_params, pegGetFormVal(i00_d7_container_id));
	
	i00_params.called_from = called_from;

	var container_id_array = {};
	container_id_array= Ext.Object.merge(container_id_array, i00_d7_container_id);
	
	inventory_d00_d7_prices_ajax = pegAjaxDefer('/' + main_path + '/inventory01/find_prices.php' , i00_params , function(jsondata){
		Ext.each(container_id_array , function(container_id){
			fld  =  pegGetFormFields(i00_d7_container_id);
			if(fld){				
				fld.each(  function(item) {
					if(jsondata[item.name]!=undefined){
						pegSetVal(item.name , item.container_id , jsondata[item.name]);
					}
				});
			}
		});					
	
	});		
}
var inventory_d00_d7_refresh_cost_method_price_ajax='';	
function inventory_d00_d7_refresh_cost_method_price(container_id){
	var i00_d_container_id   =  pegGetContainer_id_d(container_id , 'i00_d'   , '' , 'i00_d' );
	var i00_d5_container_id   = pegGetContainer_id_d(container_id , 'i00_d5' , '' , 'i00_d' ) ;
	
	if (inventory_d00_d7_refresh_cost_method_price_ajax != '') {
		if (inventory_d00_d7_refresh_cost_method_price_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(inventory_d00_d7_refresh_cost_method_price_ajax);
		}
	}
	var i00_params = {};	
	i00_params.pno = pegGetVal('pno', i00_d_container_id);
	i00_params.p414 = pegGetVal('p414', i00_d5_container_id);
	
	inventory_d00_d7_refresh_cost_method_price_ajax = pegAjaxDefer('/' + main_path + '/inventory01/refresh_cost_method_price.php' , i00_params , function(jsondata){
		pegSetVal('v_timh' , container_id , jsondata.v_timh);
	} , 'json' , true);		
}

function inventory_i00_d5_calc_p907(container_id){
	var params = {};
    params.p907_1=pegGetVal('p907_1', container_id);
    params.p907_2=pegGetVal('p907_2', container_id);
    params.p907_3=pegGetVal('p907_3', container_id);

	if(   params.p907_1 == 0  ||    params.p907_2 == 0 ||    params.p907_3==0){		
			pegSetFieldReadonly('p907' , container_id , false);
	}else{
		pegSetFieldReadonly('p907' , container_id , true);
	
		pegAjax('/' + main_path + '/inventory02/find_v_weight.php' , params , function(jsonData) {
	
			pegSetVal('p907',container_id,jsonData.p907);
			pegSetVal('vp906_1',container_id,jsonData.vp906_1);
		} , 'json' , true);
	}
	
}

//XXX  Start After draw listeners
/**
 * Αποθήκη
 * @param  {String} container_id
 * @returns
 */
function inventory_i00_d_afterDraw_listeners(container_id){
	var screen = pegGetCmp(container_id );
	var tabs = pegGetCmp(container_id+'_tab');
	var pnoSearch = pegGetCmp(container_id+'_pno_search');
	var i00pno = screen.peg_getData('pno');

	var pno = pegGetCmp(container_id, pno );
	var name = pegGetCmp(container_id, name );
	let fldset00= pegGetCmp(container_id ,'fldset00');

	let container_id_skeuasmatos = pegGetContainer_id_d(container_id, '_geopon_03_d', 0, 'i00_d');
	let gepa01_p02 = pegGetCmp(container_id_skeuasmatos, 'gepa01_p02');

	if(screen.getPeg_new_rec()){
//	if(pegIsEmpty(i00pno)){
		var totalItems = tabs.items.getCount();
		for (i = 0; i < totalItems; i++) {
			 _d  = tabs.getItem_d(i);
			 
			 if(_d == 'i00_d4'){
				 tabs.items.get(i).disable(); 
			 }	 
		}
	} 
	if(pnoSearch){
		pnoSearch.setHandler(
			function(){
				var params = {};
				var container_id00 = container_id;
				var container_id_i00_d6   = pegGetContainer_id_d(container_id , 'i00_d6' , '' , 'i00_d' ) ;
				params.nr01 = pegGetVal('nr01',  container_id00);
				params.pno  = pegGetVal('pno' , container_id00);

				params.p9901  = pegGetVal('p9901' , container_id_i00_d6);
				params.p9902  = pegGetVal('p9902' , container_id_i00_d6);
				params.p910   = pegGetVal('p910'  , container_id_i00_d6);
				params.p911   = pegGetVal('p911'  , container_id_i00_d6);
				
				pegAjax('/' + main_path + '/inventory01/find_pno.php' , params , function(jsonData) {

							if(jsonData.ok==1){		
								pegSetVal('pno' , container_id00 , jsonData.pno);
							}else{
								pegAlert(jsonData.msg);
							}
			
				} , 'json' , true);
			}
		);  
	}
	
	if(gepa01_p02) {
		gepa01_p02.on('change', function(me, newValue, oldValue, eOpts) {
			inventory__geopon_03_d_find_active_preparation(container_id_skeuasmatos);
		});
	}

	name.on('change', function (me, e) {
		inventory_i00_d_update_top_fset_title(container_id);
	});

	pno.on('change', function (me, e) {
		inventory_i00_d_update_top_fset_title(container_id);
	});

	fldset00.on('collapse',function(){	
		inventory_i00_d_update_top_fset_title(container_id);
	});
	fldset00.on('expand',function(){
		inventory_i00_d_update_top_fset_title(container_id);
	});

}

function inventory_i00_d_grid_view_afterDraw_listeners(container_id){

	console.log("In inventory_i00_d_grid_view_afterDraw_listeners");
	var grid = pegGetCmp(container_id, 'grid');

	var v_color_red =  'ed0e1d'; 

	var pnoColumn   = WebApp.view.grid.Grid.peg_getColumn(grid, 'pno');			// Κωδικός
	var nameColumn  = WebApp.view.grid.Grid.peg_getColumn(grid, 'name'); 		// Περιγραφή
	
	console.log("pnoColumn: " + pnoColumn);
	console.log("nameColumn: " + nameColumn);

	// Κωδικός
	if(pnoColumn){
		pnoColumn.peg_set_metaData  = function(value, metaData, record, rowIndex, colIndex, store, view) {  
			try {
				var anenergos_data = record.get('p203');			// έλεγχος με το Μη Ενεργό	
				if(anenergos_data>0){
					metaData.tdStyle = "color:#"+v_color_red+";";
					metaData.style = "font-weight:bold;";
				}				
			} catch (error) {
				
			}
			return metaData;
		};
	}

	// Περιγραφή
	if(nameColumn){
		nameColumn.peg_set_metaData  = function(value, metaData, record, rowIndex, colIndex, store, view) {  
			try {
				var anenergos_data = record.get('p203');			// έλεγχος με το Μη Ενεργό	
				if(anenergos_data>0){
					metaData.tdStyle = "color:#"+v_color_red+";";
					metaData.style = "font-weight:bold;";
				}				
			} catch (error) {
				
			}
			return metaData;
		};
	}

}

/**
 * Τιµές
 * @param {String} container_id
 * @returns
 */
function inventory_i00_d7_afterDraw_listeners(container_id){
	var screen = pegGetCmp(container_id );
	
	var bt1 = pegGetCmp(container_id, 'bt1');
	var p610 = pegGetCmp(container_id, 'p610');
	var p611e = pegGetCmp(container_id, 'p611e');
	var p611 = pegGetCmp(container_id, 'p611');

	var timh2 = pegGetCmp(container_id, 'timh2');
	var timh3 = pegGetCmp(container_id, 'timh3');
	var timh4 = pegGetCmp(container_id, 'timh4');

	var p_vtim2 = pegGetCmp(container_id, 'p_vtim2');
	var p_vtim3 = pegGetCmp(container_id, 'p_vtim3');
	var p_vtim4 = pegGetCmp(container_id, 'p_vtim4');

	var timh1_btn = pegGetCmp(container_id, 'timh1_btn');
	var timh2_btn = pegGetCmp(container_id, 'timh2_btn');
	var timh3_btn = pegGetCmp(container_id, 'timh3_btn');
	var timh4_btn = pegGetCmp(container_id, 'timh4_btn');

	if(bt1){
		bt1.setHandler(
			function(){
				inventory_d00_d7_prices(container_id, "bt1");
			}
		);
	}

	if(p610){
		p610.on('blur', function(me){
			if(me.peg_onBlurValueHasChanged()) {
				inventory_d00_d7_prices(container_id, "p610");
			}
		});
	}

	if(p611e){
		p611e.on('blur', function(me){
			if(me.peg_onBlurValueHasChanged()) {
				inventory_d00_d7_prices(container_id, "p611e");
			}
		});
	}	

	if(p611){
		p611.on('blur', function(me){
			if(me.peg_onBlurValueHasChanged()) {
				inventory_d00_d7_prices(container_id, "p611");
			}
		});
	}

	if(timh2){
		timh2.on('blur', function(me){
			if(me.peg_onBlurValueHasChanged()) {
				inventory_d00_d7_prices(container_id, "timh2");
			}
		});
	}

	if(timh3){
		timh3.on('blur', function(me){
			if(me.peg_onBlurValueHasChanged()) {
				inventory_d00_d7_prices(container_id, "timh3");
			}
		});
	}

	if(timh4){
		timh4.on('blur', function(me){
			if(me.peg_onBlurValueHasChanged()) {
				inventory_d00_d7_prices(container_id, "timh4");
			}
		});
	}

	if(p_vtim2){
		p_vtim2.on('blur', function(me){
			if(me.peg_onBlurValueHasChanged()) {
				inventory_d00_d7_prices(container_id, "p_vtim2");
			}
		});
	}

	if(p_vtim3){
		p_vtim3.on('blur', function(me){
			if(me.peg_onBlurValueHasChanged()) {
				inventory_d00_d7_prices(container_id, "p_vtim3");
			}
		});
	}

	if(p_vtim4){
		p_vtim4.on('blur', function(me){
			if(me.peg_onBlurValueHasChanged()) {
				inventory_d00_d7_prices(container_id, "p_vtim4");
			}
		});
	}

	if(timh1_btn){
		pegGetDic('peg_dic_prices_with_without_vat', function(desc){
			timh1_btn.setTooltip(desc);
		});
		timh1_btn.setHandler(
			function(){
				peg_windowShow_d( '' , 'i00_d7_price', 'inventory', container_id  , '', 0, '' ,  '', {
					mefpa:    pegGetVal('mefpa1', container_id),
					timh:	  pegGetVal('timh1', container_id),
					fpa:      pegGetVal('fpa', container_id),
					timh_field: 1
				},false, true, 0, 0, 'tablet');
			});	
	}

	if(timh2_btn){
		pegGetDic('peg_dic_prices_with_without_vat', function(desc){
			timh2_btn.setTooltip(desc);
		});
		timh2_btn.setHandler(
			function(){
				peg_windowShow_d( '' , 'i00_d7_price', 'inventory', container_id  , '', 0, '' ,  '', {
					mefpa:    pegGetVal('mefpa2', container_id),
					timh:	  pegGetVal('timh2', container_id),
					fpa:      pegGetVal('fpa', container_id),
					timh_field: 2
				}, false, true, 0, 0, 'tablet');
			});	
	}

	if(timh3_btn){
		pegGetDic('peg_dic_prices_with_without_vat', function(desc){
			timh3_btn.setTooltip(desc);
		});
		timh3_btn.setHandler(
			function(){
				peg_windowShow_d( '' , 'i00_d7_price', 'inventory', container_id  , '', 0, '' ,  '', {
					mefpa:    pegGetVal('mefpa3', container_id),
					timh:	  pegGetVal('timh3', container_id),
					fpa:      pegGetVal('fpa', container_id),
					timh_field: 3
				}, false, true, 0, 0, 'tablet');
			});	
	}

	if(timh4_btn){
		pegGetDic('peg_dic_prices_with_without_vat', function(desc){
			timh4_btn.setTooltip(desc);
		});
		timh4_btn.setHandler(
			function(){
				peg_windowShow_d( '' , 'i00_d7_price', 'inventory', container_id  , '', 0, '' ,  '', {
					mefpa:    pegGetVal('mefpa4', container_id),
					timh:	  pegGetVal('timh4', container_id),
					fpa:      pegGetVal('fpa', container_id),
					timh_field: 4
				}, false, true, 0, 0, 'tablet');
			});	
	}

}

function inventory_i00_d7_set_prices(container_id){

	i00_d7_container_id = pegGetContainer_id_d(container_id , 'i00_d7'   , '' , 'i00_d7' );
	timh_field 			= pegGetVal('timh_field', container_id);

	//περναω στο params το mefpa, timh, fpa και timh_field ανάλογα απο το ποιο button πατησα
	switch (timh_field) {
	  case 1:
		var params = {
			mefpa:  	 pegGetVal('mefpa1', i00_d7_container_id),
		};
		break;
	  case 2:
		var params = {
			mefpa:  	 pegGetVal('mefpa2', i00_d7_container_id),
		};
		break;
	  case 3:
		var params = {
			mefpa:  	 pegGetVal('mefpa3', i00_d7_container_id),
		};
		break;

	  default:
		var params = {
			mefpa:  	 pegGetVal('mefpa4', i00_d7_container_id),
		};
	}

	params.fpa 		  = pegGetVal('fpa', i00_d7_container_id);
	params.timh	 	  = pegGetVal('change_price', container_id);
	params.timh_fpa	  = pegGetVal('change_price_fpa', container_id);


	params.timh_field = timh_field;


	pegAjax('/' + main_path + '/inventory01/set_from_d7_price.php' , params , function(jsonData) {
		if(jsonData.ok==1){
			if(timh_field == 1){
			pegSetVal('timh1' ,i00_d7_container_id, jsonData.timh1);
			}else if(timh_field == 2){
			pegSetVal('timh2' ,i00_d7_container_id, jsonData.timh2);
			}else if(timh_field == 3){
			pegSetVal('timh3' ,i00_d7_container_id, jsonData.timh3);
			}else{
			pegSetVal('timh4' ,i00_d7_container_id, jsonData.timh4);
			}
		}
	} , 'json' , true);
	
	pegWindowClose(container_id);


}

/**
 * Λογιστικά Στοιχεία Είδους
 * @param {String} container_id
 * @returns
 */
function inventory_i00_d5_afterDraw_listeners(container_id){
	var screen = pegGetCmp(container_id );
	var v_cust_ord_bt = pegGetCmp(container_id, 'v_cust_ord_bt');
	var v_supp_ord_bt = pegGetCmp(container_id,'v_supp_ord_bt');
	var v_inter_ord_bt = pegGetCmp(container_id,'v_inter_ord_bt');
	var p907_1 = pegGetCmp(container_id,'p907_1');
	var p907_2	= pegGetCmp(container_id,'p907_2');
	var p907_3=pegGetCmp(container_id,'p907_3');
	var p616=pegGetCmp(container_id,'p616');
	var p616p=pegGetCmp(container_id,'p616p');


	inventory_i00_d5_calc_p907(container_id);
	if(v_cust_ord_bt){
		v_cust_ord_bt.setHandler(
			function(){
				var isModuleEn = Ext.data.StoreManager.lookup('store_p95p55').isModuleEn('ordercust');
				if(isModuleEn === false){
					return;
				} 
				peg_windowShow_d( '' , 'a57_d11', 'ordercust', container_id  , '', 0, '' ,  '', {
					mmnr01: screen.peg_mmnr01,
					mnr01: screen.peg_mnr01,
				} );
			});	
	}

	if(v_supp_ord_bt){
		v_supp_ord_bt.setHandler(
			function(){
				var isModuleEn = Ext.data.StoreManager.lookup('store_p95p55').isModuleEn('ordersupp');
				if(isModuleEn === false){
					return;
				} 
				peg_windowShow_d( '' , 'a67_d11', 'ordersupp', container_id  , '', 0, '' ,  '', {
					mmnr01: screen.peg_mmnr01,
					mnr01: screen.peg_mnr01,
				} );
			});	
	}

	
	if(v_inter_ord_bt){
		v_inter_ord_bt.setHandler(
			function(){
				var isModuleEn = Ext.data.StoreManager.lookup('store_p95p55').isModuleEn('interorder');
				if(isModuleEn === false){
					return;
				} 
				peg_windowShow_d( '' , 'a61_d11', 'interorder', container_id  , '', 0, '' ,  '', {
					mmnr01: screen.peg_mmnr01,
					mnr01: screen.peg_mnr01,
				} );
			});	
	}
	
	if(p907_1){
		p907_1.on('change', function(me, newValue, oldValue, eOpts ){
			if(newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue) )){
				return ;
			} 
			inventory_i00_d5_calc_p907(container_id);
		});
	}

	if(p907_2){
		p907_2.on('change', function(me, newValue, oldValue, eOpts ){
			if(newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue) )){
				return ;
			} 
			inventory_i00_d5_calc_p907(container_id);
		});
	}

	if(p907_3){
		p907_3.on('change', function(me, newValue, oldValue, eOpts ){
			if(newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue) )){
				return ;
			} 
			inventory_i00_d5_calc_p907(container_id);
		});
	}

	if(p616p){
		p616p.on('blur', function(this_00){
			if((this_00.value_old!=this_00.getValue()) || (!this_00.value_old)){		
				this_00.value_old=this_00.getValue();
				if(this_00.getValue()> 0){
					pegSetFieldReadonly('p616' , container_id , true);
					pegSetVal('p616' ,container_id, 0);
				}else{
					pegSetFieldReadonly('p616' , container_id , false);
				}
			}
			
		});
	}
}
/**
 * Οµαδοποίηση
 * @param {String} container_id
 * @returns
 */
function inventory_i00_d6_afterDraw_listeners(container_id){
	var screen	= pegGetCmp(container_id );
	var p9901	= pegGetCmp(container_id ,'p9901');
	var p9902	= pegGetCmp(container_id ,'p9902');
	var p910	= pegGetCmp(container_id ,'p910');
	var p911	= pegGetCmp(container_id ,'p911');

	if(p9901){
		p9901.on('change', function(me, newValue, oldValue, eOpts ){
			if(newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue) )){
				return ;
			} 
			var params = {};
		  	params.omada=pegGetVal('p9901', container_id);
			params.ypoomada=pegGetVal('p9902', container_id);
			pegAjax('/' + main_path + '/inventory01/find_omada.php' , params , function(jsonData) {
				if(!pegIsComboboxV2Object(pegGetCmp(container_id,'p9902'))){
					pegSetVal('p9902' ,container_id, jsonData.new_ypoomada);
				}else{
					pegSetVal('p9902' ,container_id, {'value':jsonData.new_ypoomada,'display':jsonData.new_ypoomada_display });
				}
			} , 'json' , true);
		});
	}

	if(p9902){
		p9902.on('change', function(me, newValue, oldValue, eOpts ){
			if(newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue) )){
				return ;
			}
			var params = {};
			params.omada   =pegGetVal('p9901', container_id);
			params.ypoomada=pegGetVal('p9902', container_id);
			params.oikog   =pegGetVal('p910', container_id);
			pegAjax('/' + main_path + '/inventory01/find_ypoomada.php' , params , function(jsonData){
				if(!pegIsComboboxV2Object(pegGetCmp(container_id,'p9901'))){
					pegSetVal('p9901' ,container_id, jsonData.new_omada);
				}else{
					pegSetVal('p9901' ,container_id, {'value':jsonData.new_omada,'display':jsonData.new_omada_display });
				}
				if(!pegIsComboboxV2Object(pegGetCmp(container_id,'p910'))){
					pegSetVal('p910' ,container_id, jsonData.new_oikog);
				}else{
					pegSetVal('p910' ,container_id, {'value':jsonData.new_oikog,'display':jsonData.new_oikog_display });
				}
			} , 'json' , true);
		});
	}
	if(p910){
		p910.on('change', function(me, newValue, oldValue, eOpts ){
			if(newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue) )){
				return ;
			} 
			var params = {};
			params.ypoomada=pegGetVal('p9902', container_id);
			params.oikog   =pegGetVal('p910', container_id);
			params.ypooikog=pegGetVal('p911', container_id);
			pegAjax('/' + main_path + '/inventory01/find_oikog.php' , params , function(jsonData){
				if(!pegIsComboboxV2Object(pegGetCmp(container_id,'p9902'))){
					pegSetVal('p9902' ,container_id, jsonData.new_ypoomada);
				}else{
					pegSetVal('p9902' ,container_id, {'value':jsonData.new_ypoomada,'display':jsonData.new_ypoomada_display });
				}
				if(!pegIsComboboxV2Object(pegGetCmp(container_id,'p911'))){
					pegSetVal('p911' ,container_id, jsonData.new_ypooikog);
				}else{
					pegSetVal('p911' ,container_id, {'value':jsonData.new_ypooikog,'display':jsonData.new_ypooikog_display });
				}
			} , 'json' , true);
		});
	}
	if(p911){
		p911.on('change', function(me, newValue, oldValue, eOpts ){
			if(newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue) )){
				return ;
			} 
			var params = {};
				params.oikog   =pegGetVal('p910', container_id);
				params.ypooikog=pegGetVal('p911', container_id);
				pegAjax('/' + main_path + '/inventory01/find_ypooikog.php' , params , function(jsonData){
					if(!pegIsComboboxV2Object(pegGetCmp(container_id,'p910'))){
						pegSetVal('p910' ,container_id, jsonData.new_oikog);
					}else{
						pegSetVal('p910' ,container_id, {'value':jsonData.new_oikog,'display':jsonData.new_oikog_display });
					}
				} , 'json' , true);
		});
	}
	
}

function inventory_inventory_003_d_afterDraw_listeners(container_id){
	var screen	= pegGetCmp(container_id );
	var p9901	= pegGetCmp(container_id ,'p9901');
	var p9902	= pegGetCmp(container_id +'_p9902');
	var p910	= pegGetCmp(container_id +'_p910');
	var p911	= pegGetCmp(container_id +'_p911');
	
	var p9901_1	= pegGetCmp(container_id +'_p9901_1');
	var p9902_1	= pegGetCmp(container_id +'_p9902_1');
	var p910_1	= pegGetCmp(container_id +'_p910_1');
	var p911_1	= pegGetCmp(container_id +'_p911_1');
	
	var bttn	= pegGetCmp(container_id +'_bttn');
	p9901.on('change', function(me, newValue, oldValue, eOpts ){
		if(newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue) )){
			return ;
		} 
		  var params = {};
          params.omada=pegGetVal('p9901', container_id);
          params.ypoomada=pegGetVal('p9902', container_id);
	      pegAjax('/' + main_path + '/inventory01/find_omada.php' , params , function(jsonData) {
			  if(!pegIsComboboxV2Object(pegGetCmp(container_id,'p9902'))){
				pegSetVal('p9902' ,container_id, jsonData.new_ypoomada);
			  }else{
				pegSetVal('p9902' ,container_id, {'value':jsonData.new_ypoomada,'display':jsonData.new_ypoomada_display });
			  }
	      } , 'json' , true);
	});
	
	p9902.on('change', function(me, newValue, oldValue, eOpts ){
		if(newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue) )){
			return ;
		}
        var params = {};
        params.omada   =pegGetVal('p9901', container_id);
        params.ypoomada=pegGetVal('p9902', container_id);
        params.oikog   =pegGetVal('p910', container_id);
        pegAjax('/' + main_path + '/inventory01/find_ypoomada.php' , params , function(jsonData){
			if(!pegIsComboboxV2Object(pegGetCmp(container_id,'p9901'))){
				pegSetVal('p9901' ,container_id, jsonData.new_omada);
			}else{
				pegSetVal('p9901' ,container_id, {'value': jsonData.new_omada , 'display': jsonData.new_omada_display });
			}
			if(!pegIsComboboxV2Object(pegGetCmp(container_id,'p910'))){
				pegSetVal('p910' ,container_id, jsonData.new_oikog);
			}else{
				pegSetVal('p910' ,container_id, {'value': jsonData.new_oikog , 'display': jsonData.new_oikog_display });
			}
        } , 'json' , true);
	});
	
	p910.on('change', function(me, newValue, oldValue, eOpts ){
		if(newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue) )){
			return ;
		} 
		var params = {};
        params.ypoomada=pegGetVal('p9902', container_id);
        params.oikog   =pegGetVal('p910', container_id);
        params.ypooikog=pegGetVal('p911', container_id);
        pegAjax('/' + main_path + '/inventory01/find_oikog.php' , params , function(jsonData){
			if(!pegIsComboboxV2Object(pegGetCmp(container_id,'p9902'))){
				pegSetVal('p9902' ,container_id, jsonData.new_ypoomada);
			}else{
				pegSetVal('p9902' ,container_id, {'value': jsonData.new_ypoomada , 'display': jsonData.new_ypoomada_display });
			}
			if(!pegIsComboboxV2Object(pegGetCmp(container_id,'p911'))){
				pegSetVal('p911' ,container_id, jsonData.new_ypooikog);
			}else{
				pegSetVal('p911' ,container_id, {'value': jsonData.new_ypooikog , 'display': jsonData.new_ypooikog_display });
			}
        } , 'json' , true);
	});
	p911.on('change', function(me, newValue, oldValue, eOpts ){
		if(newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue) )){
			return ;
		}
		var params = {};
	    	params.oikog   =pegGetVal('p910', container_id);
	    	params.ypooikog=pegGetVal('p911', container_id);
	        pegAjax('/' + main_path + '/inventory01/find_ypooikog.php' , params , function(jsonData){
				if(!pegIsComboboxV2Object(pegGetCmp(container_id,'p910'))){
					pegSetVal('p910' ,container_id, jsonData.new_oikog);
				}else{
					pegSetVal('p910' ,container_id, {'value': jsonData.new_oikog , 'display': jsonData.new_oikog_display });
				}
	        } , 'json' , true);
	});
	
	
	//_1
	p9901_1.on('change', function(me, newValue, oldValue, eOpts ){
		if(newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue) )){
			return ;
		}
		var params = {};
        params.omada=pegGetVal('p9901_1', container_id);
        params.ypoomada=pegGetVal('p9902_1', container_id);
	    pegAjax('/' + main_path + '/inventory01/find_omada.php' , params , function(jsonData) {
			if(!pegIsComboboxV2Object(pegGetCmp(container_id,'p9902_1'))){
				pegSetVal('p9902_1' ,container_id, jsonData.new_ypoomada);
			}else{
				pegSetVal('p9902_1' ,container_id, {'value': jsonData.new_ypoomada , 'display': jsonData.new_ypoomada_display });
			}
	    } , 'json' , true);
	});
	
	p9902_1.on('change', function(me, newValue, oldValue, eOpts ){
		if(newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue) )){
			return ;
		}
        var params = {};
        params.omada   =pegGetVal('p9901_1', container_id);
        params.ypoomada=pegGetVal('p9902_1', container_id);
        params.oikog   =pegGetVal('p910_1', container_id);
        pegAjax('/' + main_path + '/inventory01/find_ypoomada.php' , params , function(jsonData){
        	if(!pegIsComboboxV2Object(pegGetCmp(container_id,'p9901_1'))){
				pegSetVal('p9901_1' ,container_id, jsonData.new_omada);
			}else{
				pegSetVal('p9901_1' ,container_id, {'value': jsonData.new_omada , 'display': jsonData.new_omada_display });
			}
			if(!pegIsComboboxV2Object(pegGetCmp(container_id,'p910_1'))){
				pegSetVal('p910_1' ,container_id, jsonData.new_oikog);
			}else{
				pegSetVal('p910_1' ,container_id, {'value': jsonData.new_oikog , 'display': jsonData.new_oikog_display });
			}
        } , 'json' , true);
	});
	
	p910_1.on('change', function(me, newValue, oldValue, eOpts ){
		if(newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue) )){
			return ;
		}
		var params = {};
        params.ypoomada=pegGetVal('p9902_1', container_id);
        params.oikog   =pegGetVal('p910_1', container_id);
        params.ypooikog=pegGetVal('p911_1', container_id);
        pegAjax('/' + main_path + '/inventory01/find_oikog.php' , params , function(jsonData){
			if(!pegIsComboboxV2Object(pegGetCmp(container_id,'p9902_1'))){
				pegSetVal('p9902_1' ,container_id, jsonData.new_ypoomada);
			}else{
				pegSetVal('p9902_1' ,container_id, {'value': jsonData.new_ypoomada , 'display': jsonData.new_ypoomada_display });
			}
			if(!pegIsComboboxV2Object(pegGetCmp(container_id,'p911_1'))){
				pegSetVal('p911_1' ,container_id, jsonData.new_ypooikog);
			}else{
				pegSetVal('p911_1' ,container_id, {'value': jsonData.new_ypooikog , 'display': jsonData.new_ypooikog_display });
			}
        } , 'json' , true);
	});
	p911_1.on('change', function(me, newValue, oldValue, eOpts ){
		if(newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue) )){
			return ;
		}
		var params = {};
	    	params.oikog   =pegGetVal('p910_1', container_id);
	    	params.ypooikog=pegGetVal('p911_1', container_id);
	        pegAjax('/' + main_path + '/inventory01/find_ypooikog.php' , params , function(jsonData){
				if(!pegIsComboboxV2Object(pegGetCmp(container_id,'p910_1'))){
					pegSetVal('p910_1' ,container_id, jsonData.new_oikog);
				}else{
					pegSetVal('p910_1' ,container_id, {'value': jsonData.new_oikog , 'display': jsonData.new_oikog_display });
				}
	        } , 'json' , true);
	});
	
	bttn.setHandler(
		function(){
			inventory_updateCategory(container_id);
		});
}

function inventory_i02_d_afterDraw_listeners(container_id){
	var grid	= pegGetCmp(container_id , 'grid');
	var i02_nr01	= pegGetVal( 'nr01', container_id);
	
  	 grid.on('drop', function(node, data, dropRec, dropPosition){
  	 	var peg_parms_array = {};
		var peg_selected_items = data.records;
		var peg_i=0;
		Ext.Array.each(peg_selected_items, function(name, index, peg_selected_items_itself) {		
			peg_i++;
			var peg_fld_name = 'peg_fld_' + peg_i + '_';
				
			var peg_data = peg_selected_items_itself[index].data;
			Ext.Object.each(peg_data, function(name, index, peg_data_itself) {
				peg_parms_array[peg_fld_name + name] = index;
			});	
		});
		
		peg_parms_array['container_id'] = container_id;
		peg_parms_array['mmnr01'] =  grid.getMmnr01();
		peg_parms_array['mnr01']  = i02_nr01;
		 
		pegAjax('/' + main_path + '/colorsize04/drop.php' , peg_parms_array , function(jsonData){
			pegGridRefresh( container_id , 'grid' ,  jsonData.nr01 );
			if(jsonData.ok==0){
				pegAlert(jsonData.message);
			}
		} , 'json' );
  });
}

function inventory__i00_change_pno_d_afterDraw_listeners(container_id){
	var btn00= pegGetCmp(container_id , 'btn00');
	btn00.setHandler(function(){
		inventory_update_db_table(container_id);
	});

}

function inventory_i00_d_update_top_fset_title(container_id){

	let fldset00= pegGetCmp(container_id ,'fldset00');
	let screenData=pegGetCmp(container_id).peg_getData();
	if(fldset00.peg_isCollapsed() && screenData.name !== undefined && (screenData.name.length> 0) ){
		let pno,name, chars=40;
		if(peg002_IsMobileScreen()){
			chars=20;
		}
		if(screenData.pno.length>=chars){
			pno=screenData.pno.substr(0,chars-3)+'...';
		}else{
			pno=screenData.pno;
		}
		if(screenData.name.length>=chars){
			name=screenData.name.substr(0,chars-3)+'...';
		}else{
			name=screenData.name;
		}

		fldset00.setTitle(pno + '/' + name);
	}else{
		fldset00.setTitle(fldset00.title00);
	}
}

function inventory_update_db_table(container_id,next){
	var params={};
	params.old_pno=pegGetVal( 'old_pno' , container_id);
	params.new_pno=pegGetVal( 'new_pno' , container_id );
	
	/*Την πρώτη φορά*/
	if(!(next>=0)){
		pegAjaxDefer('/' + main_path + '/inventory02/change_pno.php' , params , function(json_data){
			if(json_data.msg){
				
				pegAlert(json_data.msg);
			}else{
				peg_dic_core_confirm_submit = json_data.peg_dic_core_confirm_submit;
				pegConfirmBox(peg_dic_core_confirm_submit , json_data.confirm_message,  function(but){
					if(but==='yes'){
						pegSetVal('log' , container_id, '');
						if(pegGetFramework() == 'peg002'){
							peg002_mask(container_id);
						}else{
							Ext.getCmp(container_id).mask( dic_mask_msg );
						}
						
						
						inventory_update_db_table(container_id,0);
					}
				});
			}
		});
		return;
	}
	
	
	params.no_confirm=1;
	params.next=next;
	
	pegAjaxDefer('/' + main_path + '/inventory02/change_pno.php' , params , function(json_data){
		if(json_data.gotonext == 1){
			pegSetVal('log' , container_id, pegGetVal( 'log' , container_id)+''+json_data.log);
			inventory_update_db_table(container_id,json_data.next);
		}else{
			if(pegGetFramework() == 'peg002'){
				peg002_unmask();
			}else{
				Ext.getCmp(container_id).unmask();
			}
			if(json_data.msg){
				pegAlert(json_data.msg);
			}
			if(json_data.ok==1){
				pegSetVal('log' , container_id, pegGetVal( 'log' , container_id)+''+json_data.log);
				pegSetVal('new_pno' , container_id, json_data.new_pno);
				pegSetVal('old_pno' , container_id, json_data.old_pno);
				pegGridRefresh(pegGetContainer_id_d(container_id , 'browse_d00', '', 'browse_d00' ) , 'grid' ,  pegGetVal( 'nr01' , container_id) );
			}else{
				pegSetVal('log' , container_id, '');
			}
		}
	});
}

var inventory__geopon_03_d_find_active_preparation_ajax = '';
function inventory__geopon_03_d_find_active_preparation(container_id) {
	if (inventory__geopon_03_d_find_active_preparation_ajax != '') {
		if (inventory__geopon_03_d_find_active_preparation_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(inventory__geopon_03_d_find_active_preparation_ajax);
		}
	}

	let params = {};
	params.p02 = pegGetVal('gepa01_p02', container_id);
	inventory__geopon_03_d_find_active_preparation_ajax = pegAjaxDefer('/' + main_path + '/geopon01/geopon_gepa01_d_active_change.php', params, function(jsondata) {
		if(jsondata.p03 == 0) {
			pegSetVal('gepa01_v_gepa82_p03', container_id, 0);
		} else {
			pegSetVal('gepa01_v_gepa82_p03', container_id, 1);
		}
	})
}

function inventory_toolbar_item(container_id,grid_name){
	var screen = pegGetCmp(container_id );
	var grid = pegGetCmp(container_id,grid_name);
	pegGetDic('peg_dic_inventory_must_select_record', function(desc){
		peg_inventory_change_pno(container_id,screen.getMnr01(),screen.getMmnr01(),desc);
	}); 
}

function inventory_toolbar_item_mass_change_price(screen){
	const container_id = screen.getContainer_ID();
	const browse_d00_container_id =  pegGetContainer_id_d(container_id, 'browse_d00', '', 'browse_d00');
	const grid = pegGetCmp(browse_d00_container_id, 'grid');
	
	if(browse_d00_container_id == ''){
		return;
	}
	const grid_selection = grid.getSelection();
	// Μόνο αν έχουμε πάνω από μια επιλεγμένες εγγραφές
	var params = {};
	params.peg_view_table = grid.peg_view_table ;
	if(grid_selection.length > 1) {
		let grid_selection_nr01 = [];
		for(row of grid_selection) {
			if(row.get('nr01') > 0) {
				grid_selection_nr01.push(row.get('nr01'));
			}
		}
		if(grid_selection_nr01.length > 0) {
			params.grid_selection = grid_selection_nr01.join(',')
		}
	}
	peg_windowShow_d( '' , 'i00_mass_change_price', 'inventory' , container_id , '' , '' , '', '' ,params, false, true, 0, 0,'tablet' );					

}

function inventory_i00_mass_change_price_afterDraw_listeners(container_id){
	var i14_p01	   = pegGetCmp(container_id , 'i14_p01');
	var create	   = pegGetCmp(container_id , 'create');
	var update_i14	   = pegGetCmp(container_id , 'update_i14');

	create.on('change', function(me, newValue, oldValue, eOpts ){
		if(newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue) )){
			return ;
		} 
		if(!pegIsEmpty(pegGetVal('i14_p01', container_id))){
			pegSetFieldReadonly('update_i14',container_id, true)
		}
		pegSetVal('update_i14' ,container_id, '0');
		//pegSetFieldReadonly('update_i14',container_id,newValue)
	});

	i14_p01.on('change', function(me, newValue, oldValue, eOpts ){
		if(newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue) )){
			return ;
		} 
		var params = {};
		params.i14_p01 = pegGetVal('i14_p01', container_id);
	      pegAjax('/' + main_path + '/inventory01/find_i14_p03.php' , params , function(jsonData) {
			  if(jsonData.ok == 1){
				pegSetVal('fpa' ,container_id, jsonData.fpa);
			  }
	      } , 'json' , true);

		  pegSetVal('update_i14' ,container_id, '0');
		  pegSetFieldReadonly('update_i14',container_id,newValue)

	});

	update_i14.on('change', function(me, newValue, oldValue, eOpts ){
		if(newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue) )){
			return ;
		} 
		if(!pegIsEmpty(pegGetVal('create', container_id))){
			pegSetVal('create' ,container_id, '0');
			//pegSetFieldReadonly('create',container_id,newValue)
		}
	});
}

inventory_i00_mass_change_price_set_values_ajax = '';
function inventory_i00_mass_change_price_set_values(screen){
	const container_id = screen.getContainer_ID();
	const browse_d00_container_id =  pegGetContainer_id_d(container_id, 'browse_d00', '', 'browse_d00');

	if(browse_d00_container_id == ''){
		return;
	}
	const grid = pegGetCmp(browse_d00_container_id, 'grid');
	const selection = grid.getSelection();
	let params={
		timh1 			: pegGetVal('timh1', container_id),
		timh2 			: pegGetVal('timh2', container_id),
		timh3 			: pegGetVal('timh3', container_id),
		timh4 			: pegGetVal('timh4', container_id),
		timh1_check		: pegGetVal('timh1_check', container_id),
		timh2_check 	: pegGetVal('timh2_check', container_id),
		timh3_check 	: pegGetVal('timh3_check', container_id),
		timh4_check 	: pegGetVal('timh4_check', container_id),
		timh1_fpa_check	: pegGetVal('timh1_fpa_check', container_id),
		timh2_fpa_check	: pegGetVal('timh2_fpa_check', container_id),
		timh3_fpa_check	: pegGetVal('timh3_fpa_check', container_id),
		timh4_fpa_check	: pegGetVal('timh4_fpa_check', container_id),
		update_markup 	: pegGetVal('update_markup', container_id),
		i14_p01 	    : pegGetVal('i14_p01', container_id),
		markup 	   		: pegGetVal('markup', container_id),
		update_markup_2 : pegGetVal('update_markup_2', container_id),
		update_i14 		: pegGetVal('update_i14', container_id),
		fpa 			: pegGetVal('fpa', container_id),
		create 			: pegGetVal('create', container_id),
		calculate 		: pegGetVal('calculate', container_id),
		increases 		: pegGetVal('increases', container_id),
		decimals 		: pegGetVal('decimals', container_id),
		balance_from 	: pegGetVal('balance_from', container_id),
		balance_to 		: pegGetVal('balance_to', container_id),
		local_balance_from : pegGetVal('local_balance_from', container_id),
		local_balance_to   : pegGetVal('local_balance_to', container_id),
		container_id    : container_id,
		grid_selection	: ''
	};
	//console.log(selection);
	if(selection.length  < 2){
		return pegGetDic('peg_dic_inventory_confirm_mass_changes',function(msg){
			return pegConfirmBox('', msg, function(ok){
				if(ok == 'yes'){
					if (inventory_i00_mass_change_price_set_values_ajax != '') {
						if (inventory_i00_mass_change_price_set_values_ajax.dias_fld_mnr01 > 0) {
							Ext.ux.AjaxDefer.abort(inventory_i00_mass_change_price_set_values_ajax);
						}
					}
					
						inventory_i00_mass_change_price_set_values_ajax = pegAjaxDefer('/' + main_path + '/inventory01/mass_change_price.php', params,
						function (json_data) {
								pegAlert(json_data.msg);
						}
					);
				}
			})
		})
	}
	
			let grid_selection_nr01 = [];
			for(row of selection) {
				grid_selection_nr01.push(row.get('nr01'));
			}

				params.grid_selection = grid_selection_nr01.join(",");
	

	
		
	if (inventory_i00_mass_change_price_set_values_ajax != '') {
		if (inventory_i00_mass_change_price_set_values_ajax.dias_fld_mnr01 > 0) {
			Ext.ux.AjaxDefer.abort(inventory_i00_mass_change_price_set_values_ajax);
		}
	}
	
		inventory_i00_mass_change_price_set_values_ajax = pegAjaxDefer('/' + main_path + '/inventory01/mass_change_price.php', params,
		function (json_data) {
				pegAlert(json_data.msg);
		}
	);
	
}


function peg_inventory_change_pno(container_id,mnr01,mmnr01,msg){
	var row=pegGridGetSelectedRow(container_id , 'grid' , mnr01, mmnr01 );
    if(row){
    	var nr01=row.nr01;
		if(nr01<1){
        	pegAlert(msg);
           	return;
    	}
     	if(pegGetFramework() == 'peg002'){
  			peg_windowShow_d( '' , '_i00_change_pno_d', 'inventory' , container_id , '' , '' , '', '' ,{i00_nr01:nr01}, true );
		}else{
			pegWindowShow_d( '' , '_i00_change_pno_d' , 'inventory' , '' , 0 , '&i00_nr01='+nr01,container_id, 0,0,'c-c',{}, true);
		}
    }else{
    	pegAlert(msg);
    }
}

function peg_inventory_show_i00_d(container_id,nr01,id){		

	pegAddTab_d('' , 'i00' , 'i00_d' , 'inventory' ,'' , nr01 ); 

}

function inventory_i00_d_comboboxV2_extraSearchFields(combo){
	
	pegAjax('/' + main_path + '/inventory02/check_modules.php' , {} , function(jsonData){
		
		if(jsonData['invspcodes']==true){
			pegGetDic('peg_dic_inventory_invspcodes_desc', function(desc){ 
				combo.addExtraSearchField('invspcodes',desc,'textbox',0,1); 
			});
		}
		if(jsonData['serial']==true){
			pegGetDic('peg_dic_inventory_serial_desc', function(desc){ 
				combo.addExtraSearchField('serial',desc,'textbox',0,1); 
			});
		}
		pegGetDic('peg_dic_inventory_all_codes', function(desc){ 
			combo.addExtraSearchField('all_codes',desc,'textbox',0,1); 
		});
	} , 'json' );	
}

function inventory_i00_d_on_save(screenParams){
	if(typeof(products04_i00_d_on_save)=="function"){
		products04_i00_d_on_save(screenParams);
	}
}

function inventory_inventory_004_d00_afterDraw_listeners(container_id){
	var screen  = pegGetCmp(container_id);
	var grid	= pegGetCmp(container_id, 'grid');
	var vi24p01 = pegGetCmp(container_id, 'vi24p01');
	
	var v_colorsize = pegGetCmp(container_id, 'v_colorsize');
	var v_serial    = pegGetCmp(container_id, 'v_serial');
	var v_lot       = pegGetCmp(container_id, 'v_lot');
	
	vi24p01.on('change', function(me, newValue, oldValue, eOpts){
		oldValue = oldValue.filter(function(element){return element!='';});

		if(JSON.stringify(oldValue) === JSON.stringify(newValue)){
			return;
		}
		
		if(newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue) )){
			return;
		}

		inventory_inventory_004_d00_refresh(container_id, 'vi24p01');
	});

	v_colorsize.on('change', function(me, newValue, oldValue, eOpts){
		if(newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue) )){
			return;
		}

		inventory_inventory_004_d00_refresh(container_id, 'vi24p01');
	});

	v_serial.on('change', function(me, newValue, oldValue, eOpts){
		if(newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue) )){
			return;
		}

		inventory_inventory_004_d00_refresh(container_id, 'vi24p01');
	});

	v_lot.on('change', function(me, newValue, oldValue, eOpts){
		if(newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue) )){
			return;
		}

		inventory_inventory_004_d00_refresh(container_id, 'vi24p01');
	});
}

var inventory_004_d00_refresh_ajax = '';
function inventory_inventory_004_d00_refresh(container_id, field){

	if (inventory_004_d00_refresh_ajax) {
		if (inventory_004_d00_refresh_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(inventory_004_d00_refresh_ajax);
		}
	}

	var container_inventory_004_d01 = pegGetContainer_id_d(container_id , 'inventory_004_d01', '', 'inventory_004_d00');
	var screen_inventory_004_d01  	= pegGetCmp(container_inventory_004_d01);
	
	var params = {};
	params.field 	    	= field;
	params.container_id 	= container_id;
	params.par_container_id = container_inventory_004_d01;
	params.par_mmnr01		= screen_inventory_004_d01.peg_mmnr01;

	params = Ext.Object.merge(params, pegGetFormVal(container_id));
	inventory_004_d00_refresh_ajax = pegAjax('/' + main_path + '/inventory03/inventory_004_d00_refresh.php', params, function(jsondata){
		if(jsondata.ok==1){
			pegGridRefresh(container_id, 'grid');
		}	
	}, 'json');
}

var inventory_search_is_new_rec_ajax = '';
function inventory_search_is_new_rec(container_id, _d, module) {
	let screen = pegGetCmp(container_id);

	let i00_pno = screen.peg_getData('pno');
	let mmnr01  = screen.getMmnr01();
	let mnr01   = screen.getMnr01();

	if (inventory_search_is_new_rec_ajax) {
		if (inventory_search_is_new_rec_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(inventory_search_is_new_rec_ajax);
		}
	}

	let params = {};
	params.nr01 = mnr01;
	params._d   = _d;

	inventory_search_is_new_rec_ajax = pegAjax('/' + main_path + '/inventory01/search_is_new_rec.php', params, function(jsondata){
		if(jsondata.ok == 1) {
			let params = {};

			params.mmnr01 = mmnr01;
			params.mnr01 = mnr01;

			if(_d == "i11_d03"){
				params.i00_pno = i00_pno;
			} else {
				params.pno = i00_pno;
			}

			peg_windowShow_d('', _d, module, container_id, '', 0, '', '', params, false, true, 0, 0, 'tablet');
		} else {
			pegAlert(jsondata.msg);
		}
	}, 'json');
}