<?php

function inventory_get_session_value($session_name, $table, $field)
{

    if (isset($_SESSION[$session_name])) {
        $session_value = $_SESSION[$session_name];
    } else {
        $session_value = pegasus_mysql_printfld($table, $field, 'nr01=1');
    }

    return $session_value;
}



/**
 * Yπολογίζει την τιμή μονάδας ενός είδους
 * @param mixed $product_code ο κωδικός του προιόντος
 * @param mixed $p03 o μοναδικός κώδικός του πελάτη ή ο μοναδικός κώδικος του προμηθευτη
 * @param mixed $pos η ποσότητα του είδους.
 * @param mixed $date η Ημερομηνία για την οποιά θελουμε την τιμη 
 * @param int $kath_fpa 0 το καθεστώς ΦΠΑ
 * @param string $mode 'a01' για πελάτές (ειναι το default) ,a00 για προμηθευτες , -  για οτι αλλο
 * @param mixed $preview_wthfpa 0 το τιμές με ΦΠΑ
 * @param bool $p703 Ο κωδικός αποθηκευτικού χώρου (Χρησιμοποιείται για τον υπολογισμό κόστους)
 * @param int $p03_p48 Βασικός Τιμοκατάλογος
 * @param int $p03_p06 Ειδικός Τιμοκατάλογος
 * @param int $p03_p52 Ποσοστό Έκπτωσης 1
 * @param int $p03_p52a Ποσοστό Έκπτωσης 2
 * @param int $p03_p523 Ποσοστό επιβάρυνσης/προσαύξησης πελάτη
 * @param string $i31_p02
 * @param string $cona11_nr01 Σύμβαση  
 * @return false|array ['price','fpa', 'kfpa', 'discount_1', 'discount_2', 'preview_wthfpa', 'min_timh']
 */
function inventory_find_price(
    $product_code,
    $p03,
    $pos,
    $date,
    $kath_fpa = 0,
    $mode = 'a01',
    $preview_wthfpa = 0,
    $p703 = false,
    $p03_p48 = 0,
    $p03_p06 = 0,
    $p03_p52 = 0,
    $p03_p52a = 0,
    $p03_p523 = 0,
    $i31_p02='',
    $cona11_nr01='',
    $zero_prices=0
) {
    //echo  'product_code:' . $product_code . ' p03:' .  $p03 . ' p03:' .  $pos . ' date:' .  $date .' kath_fpa:' .   $kath_fpa . ' mode:' . $mode ;

    /******
     * 1. Αρχικοποίηση Μεταβλητών 
     ******/

    //Eυρεση ειδους στην αποθήκη
    pegasus_mysql_use("select * from i00 where pno=?", $i00, array($product_code));
    if (!($i00['nr01'] > 0)) {
        return false;
    }

    $p03_tbl_p48 = 0;
    $discount_1 = 0;
    $discount_2 = 0;

    $eisfora_anakyklosis = $i00['p905']; // Μηδενίζετε στο τέλος αν έχω $zero_prices - Δεν τροποποιείται περαιτέρω στη συνάρτηση.

    $ss_cor003_p105       = inventory_get_session_value('cor003_p105', 'cor003', 'p105'); //Αποθηκευτικός Χώρος τερματικού
    $ss_f02_p06           = inventory_get_session_value('f02_p06', 'f02', 'p06'); //Η κατώτερη τιμή έχει ΦΠΑ
    $ss_customers_000_p02 = inventory_get_session_value('customers_000_p02', 'customers_000', 'p02'); //Κωδικός Βασικού Τιμοκαταλόγου
    $ss_suppliers_000_p02 = inventory_get_session_value('suppliers_000_p02', 'suppliers_000', 'p02'); //Κωδικός Βασικού Τιμοκαταλόγου
    $ss_inventory_000_p07 = inventory_get_session_value('inventory_000_p07', 'f01', 'p07'); //Δεκαδικά τιμής μονάδας
    $is_quantity_price = false;
    $is_quantity_discounts = false;

    $i23_query = "select * from i23"; //Όλοι οι βασικοί τιμοκατάλογοι
    $result = pegasus_query($i23_query);
    while ($row = pegasus_fetch($result, PEG_FETCH_ASSOC)) {
        if ($row['p01'] == 1) {
            $wthfpa_timh_3 = $row['p03_1'];
        }
        if ($row['p01'] == 2) {
            $wthfpa_timh_2 = $row['p03_1'];
        }
        if ($row['p01'] == 3) {
            $wthfpa_timh_4 = $row['p03_1'];
        }
        if ($row['p01'] == 4) {
            $wthfpa_timh_1 = $row['p03_1'];
        }
    }
    if ($p703 === FALSE) {
        $p703 = $ss_cor003_p105; //Αποθηκευτικός Χώρος τερματικού
    }
    if (empty($date)) {
        $date = date('Ymd');
    }
    //Oι τιμές περιέχουν ΦΠΑ
    $wthfpa = $ss_f02_p06;
    //$preview_wthfpa = $_SESSION['f02_p06'];
   
    
    /******
     * 2. Ενημέρωση μεταβλητών από την καρτέλα πελάτη ή Προμηθευτη 
     *    (Αν ήρθαν κενές από την κλήση της συνάρτησης) 
     ******/
    //Eυρεση πελάτη ή προμηθετή
    if ($p03 > 0 && ($mode == 'a01' || $mode == 'a00')) {
        pegasus_mysql_use("select * from " . $mode . " where nr01=?", $p03_tbl, array($p03));
    }

     //Ποσοστό έκπτωσης. Έρχεται συμπληρωμένο π.χ. στην εύρεση τιμής της προσφοράς 
    if ($p03_p52 > 0 || $p03_p52a > 0) {
        $discount_1  = $p03_p52;
        $discount_2  = $p03_p52a;
    } else if($mode == 'a01' || $mode == 'a00'){
        $discount_1  = $p03_tbl['p52'];
        $discount_2  = $p03_tbl['p52a'];
    }
    //Βασικός τιμοκατάλογος. Έρχεται συμπληρωμένος π.χ. στην εύρεση τιμής της προσφοράς
    if ($p03_p48 > 0) { 
        $p03_tbl_p48 = $p03_p48;
    } else if($mode == 'a01' || $mode == 'a00'){
        $p03_tbl_p48 = $p03_tbl['p48'];
        if (empty($p03_tbl_p48)) {

            if ($mode == 'a01') {
                $p03_tbl_p48 = $ss_customers_000_p02;
            } else {
                $p03_tbl_p48 = $ss_suppliers_000_p02;
            }
        }
        if (empty($p03_tbl_p48)) {
            if ($mode == "a01") {
                $p03_tbl_p48 = 2;
            } else {
                $p03_tbl_p48 = 4;
            }
        }
    }
    //Ειδικός τιμοκατάλογος. Έρχεται συμπληρωμένος π.χ. στην εύρεση τιμής της προσφοράς
    if ($p03_p06 == 0 && ($mode == 'a01' || $mode == 'a00')) { 
        $p03_p06 = $p03_tbl['p06'];
    }
    if($p03_p523 == 0){ //Ποσοστό προσαύξησης-Επιβάρυνσης. Έρχεται συμπληρωμένος π.χ. στην εύρεση τιμής της προσφοράς
        $p03_p523 = $p03_tbl['p523'];
    }

    /******
     * 3. Αρχικοποίηση wthfpa από τον Τιμοκατάλογο. 
     *    Θα αλλάξει πιο κατω για να πάρει τον ορισμό από τον τιμοκατάλογο που θα βρει την τιμη
     ******/
    //Timokatalogos
    if ($p03_tbl_p48 > 0) {
        pegasus_mysql_use(' select * from i23 where p01=?', $i23, array($p03_tbl_p48));
        $wthfpa = $i23['p03_1'];
        //$preview_wthfpa = $i23['p05'];
    }
    //Eidikos Timokatalogos
    if (pegasus_module_exists('invprices') && $p03_p06 > 0) {
        pegasus_mysql_use(' select * from i14 where p01=?', $i14, array($p03_p06));
        $wthfpa = $i14['p03'];
        //$preview_wthfpa = $i14['p05'];
    }

    /******
     * 4. Υπολογισμός Τιμής
     ******/

    $timh = 0;

    $not_calc_charge = 0;
    $disable_min_price = 0;
    $aekp_en = 0; 
    $serial_en = 0; 
    $discount_a72p012 = 0;
    $discount_1_a72p012 = 0;
    $discount_2_a72p012 = 0;

    $price_quantity = 0; 
    $discount_1_quantity = 0;
    $discount_2_quantity = 0;

     /******
     * 4.1 Serial Number
     * Αν βρεθεί τιμή στο serial θα σετάρεται $serial_en = 1
     ******/ 
    if (!empty($i31_p02)) {

        $query = '  SELECT * 
                    FROM i31 
                    WHERE i31.p02= :i31_p02';

        pegasus_mysql_use($query, $_i00, array('i31_p02' => $i31_p02));
        //echo pegasus_replace_values_in_sql($query, array('i31_p02' => $i31_p02));

        if ($p03_tbl_p48 == 1) {
            $timh = $_i00['timh3'];
            $wthfpa = $wthfpa_timh_3;
        }
        if ($p03_tbl_p48 == 2) {
            $timh = $_i00['timh2'];
            $wthfpa = $wthfpa_timh_2;
        }
        if ($p03_tbl_p48 == 3) {
            $timh = $_i00['timh4'];
            $wthfpa = $wthfpa_timh_4;
        }
        if ($p03_tbl_p48 == 4) {
            $timh = $_i00['timh1'];
            $wthfpa = $wthfpa_timh_1;     
        }
        if($timh>0){
            $serial_en = 1;
        }
    }

    /******
     * 4.2 Υπολογισμός Τιμων με σειρά προτεραιότητας από 
     *      Ειδικές τιμές , 
     *      Εκπτώσεις Ανά Ομάδα, 
     *      Ποσσοτικες Τιμές, 
     *      Ειδικό Τιμοκατάλογο πελάτη
     * 
     * Αν βρεθεί τιμή σε κάποιο από τα παρακάτω σετάρεται $aekp_en = 1
     ******/ 
    if (pegasus_mysql_table_exists('a72') and $mode == 'a01' and $serial_en == 0) {
        /* ελεγχω αν υπάρχει ειδική τιμή του είδους ή εκπτωση */
        /**
         * i37
         * p02 = Ποσότητα
         * p901 = Ισχύει και για μεγαλύτερες ποσότητες που δεν είναι ακέραια πολλαπλάσια
         * :pos0 = Τρέχουσα ποσότητα
         * :pos1 = -||-
         * 
         * a72
         * p010 = Ποσότητα
         * p011 = Ισχύει μόνο για ακέραια πολλαπλάσια (**! ΕΔΩ ΦΑΙΝΕΤΑΙ ΠΩΣ ΕΧΕΙ ΑΝΑΠΟΔΗ ΛΟΓΙΚΗ ΑΠΟ ΤΟ i37 !**)
         */

        $query_a72 = "SELECT * FROM a72 WHERE 
                            (    
                                (p00=:p00_0 AND p00<>0 AND p00_1=0) OR
                                (p00=0 AND p00_1<>0 AND p00_1=:p00_1)
                            ) 
                            AND
                            (  
                                (mod(:pos0, a72.p010)=0 AND a72.p011=1) OR
                                (a72.p010=0 AND a72.p011=1) OR
                                a72.p011=0 
                            )
                            AND
                            (
                                (a72.p010>0 AND a72.p010<=:pos1) OR
                                a72.p010=0
                            )
                            AND p01=:p01
                            AND p05<=:p05
                            AND :p06<=p06 
                            AND p000 IN (:cona11_nr01, 0)
                            ORDER BY p000 DESC, p00_1, p010 DESC";
        
        $query_params_a72 = array(
            "p00_0"  => $p03,
            "p00_1"  => $p03_p06,
            "p01"    => $i00['pno'],
            "p05"    => $date,
            "p06"    => $date,
            "cona11_nr01" => $cona11_nr01,
            "pos0" => $pos,
            "pos1" => $pos
        );

        pegasus_mysql_use($query_a72, $a72, $query_params_a72);

        // echo pegasus_replace_values_in_sql($query_a72, $query_params_a72);

        if (!empty($a72['nr01']) and $a72['nr01'] > 0) {
            // Χρησιμοποιείται σε ΣΜΕ στο tesae η inventory_find_price, γι'αυτό ελέγχουμε function_exists
            if(function_exists('pegasus_check_permission')){
                if((pegasus_check_permission('invoices.check_min_price') && $_SESSION['f02_p615']==1) || $_SESSION['f02_p615']==0 ){
                    $disable_min_price = $a72['p013'];
                }
            }else{
                $disable_min_price = $a72['p013'];
            }
            $discount_1 = $a72['p030'];
            $discount_2 = $a72['p031'];
            $aekp_en = 1;
            $not_calc_charge = 1;
            if ($a72['p03'] != 0) {
                $timh = $a72['p03'];

                if ($p03_tbl_p48 == 1) {
                    $wthfpa = $wthfpa_timh_3;
                }
                if ($p03_tbl_p48 == 2) {
                    $wthfpa = $wthfpa_timh_2;
                }
                if ($p03_tbl_p48 == 3) {
                    $wthfpa = $wthfpa_timh_4;
                }
                if ($p03_tbl_p48 == 4) {
                    $wthfpa = $wthfpa_timh_1;
                }
            }
            
            //* Αν έχει συμπληρωμένο "Επί τιμοκαταλόγου", παίρνουμε τιμή, wthfpa από αυτόν.
            //* Η τιμή του a72, υπερισχύει του τιμοκαταλόγου.
            if ($a72['pt01'] == 1) {
                $timh = $a72['p03'] != 0 ? $timh : $i00['timh3'];
                // $timh = $i00['timh3'];
                $wthfpa = $wthfpa_timh_3;
            }
            if ($a72['pt01'] == 2) {
                $timh = $a72['p03'] != 0 ? $timh : $i00['timh2'];
                // $timh = $i00['timh2'];
                $wthfpa = $wthfpa_timh_2;
            }
            if ($a72['pt01'] == 3) {
                $timh = $a72['p03'] != 0 ? $timh : $i00['timh4'];
                // $timh = $i00['timh4'];
                $wthfpa = $wthfpa_timh_4;
            }
            if ($a72['pt01'] == 4) {
                $timh = $a72['p03'] != 0 ? $timh : $i00['timh1'];
                // $timh = $i00['timh1'];
                $wthfpa = $wthfpa_timh_1;
            }

            if ($a72['p04'] != 0) {
                $timh = $timh - $a72['p04']; //ποσό έκπτωσης
                if ($timh < 0) {
                    $timh = 0;
                }
            }
            if ($a72['p012'] == 1) { //οι εκπτώσεις υπερισχύουν όλων
                $discount_a72p012 = 1;
                $discount_1_a72p012 = $discount_1;
                $discount_2_a72p012 = $discount_2;
            }
            
            // Πλέον ελέγχουμε και την ποσότητα στο query άρα υφίσταται και έννοια ποσοτικής τιμής οπότε σετάρουμε και τα παρακάτω
            if($a72['p010'] > 0) {
                if($a72['p030'] > 0 || $a72['p031'] > 0) {
                    $is_quantity_discounts = true;
                    $discount_1_quantity = $discount_1;
                    $discount_2_quantity = $discount_2;
                }

                if($a72['p03'] > 0 || $a72['pt01'] > 0){
                    $is_quantity_price = true;
                    $price_quantity = $timh;
                }
            }
        }
    }

    if (pegasus_mysql_table_exists('a74') and $mode == 'a00' and $serial_en == 0) {
        $query_a74 = "SELECT * FROM a74 WHERE
                                 	(    
                                        (p00=:p03 AND p00<>0 AND p00_1=0) OR
                                        (p00=0 AND p00_1<>0 AND p00_1=:p00_1)
                                    )           
                                    AND
                                    (  
                                        (mod(:pos0, a74.p010)=0 AND a74.p011=1) OR
                                        (a74.p010=0 AND a74.p011=1) OR
                                        a74.p011=0 
                                    )
                                    AND 
                                    (
                                        (a74.p010>0 AND a74.p010<=:pos1) OR
                                        a74.p010=0
                                    )
                                    AND p01=:p01 
                                    AND p05<=:p05 
                                    AND :p06<=p06 
                                    ORDER BY p000 DESC, p00_1, p010 DESC";

        $query_params_a74 = array(
            "p03"   => $p03,
            "p00_1" => $p03_p06,
            "p01"   => $i00['pno'],
            "p05"   => $date,
            "p06"   => $date,
            "pos0"  => $pos,
            "pos1"  => $pos
        );

        /* ελεγχω αν υπάρχει ειδική τιμή του είδους ή εκπτωση */
        pegasus_mysql_use($query_a74, $a74, $query_params_a74);

        if (!empty($a74['nr01']) and $a74['nr01'] > 0) {
            // Χρησιμοποιείται σε ΣΜΕ στο tesae η inventory_find_price, γι'αυτό ελέγχουμε function_exists
            if(function_exists('pegasus_check_permission')){
                if((pegasus_check_permission('invoices.check_min_price') && $_SESSION['f02_p615']==1) || $_SESSION['f02_p615']==0 ){
                    $disable_min_price = $a74['p013'];
                }
            }else{
                $disable_min_price = $a74['p013'];
            }

            $discount_1 = $a74['p030'];
            $discount_2 = $a74['p031'];
            $aekp_en = 1;

            if ($a74['p03'] != 0) {
                $timh = $a74['p03'];

                if ($p03_tbl_p48 == 1) {
                    $wthfpa = $wthfpa_timh_3;
                }
                if ($p03_tbl_p48 == 2) {
                    $wthfpa = $wthfpa_timh_2;
                }
                if ($p03_tbl_p48 == 3) {
                    $wthfpa = $wthfpa_timh_4;
                }
                if ($p03_tbl_p48 == 4) {
                    $wthfpa = $wthfpa_timh_1;
                }
            }
            
            //* Αν έχει συμπληρωμένο "Επί τιμοκαταλόγου", παίρνουμε τιμή, wthfpa από αυτόν.
            //* Η τιμή του a74, υπερισχύει του τιμοκαταλόγου.
            if ($a74['pt01'] == 1) {
                $timh = $a74['p03'] != 0 ? $timh : $i00['timh3'];
                // $timh = $i00['timh3'];
                $wthfpa = $wthfpa_timh_3;
            }
            if ($a74['pt01'] == 2) {
                $timh = $a74['p03'] != 0 ? $timh : $i00['timh2'];
                // $timh = $i00['timh2'];
                $wthfpa = $wthfpa_timh_2;
            }
            if ($a74['pt01'] == 3) {
                $timh = $a74['p03'] != 0 ? $timh : $i00['timh4'];
                // $timh = $i00['timh4'];
                $wthfpa = $wthfpa_timh_4;
            }
            if ($a74['pt01'] == 4) {
                $timh = $a74['p03'] != 0 ? $timh : $i00['timh1'];
                // $timh = $i00['timh1'];
                $wthfpa = $wthfpa_timh_1;
            }

            if ($a74['p04'] != 0) {
                $timh = $timh - $a74['p04'];
                if ($timh < 0) {
                    $timh = 0;
                }
            }

            // Πλέον ελέγχουμε και την ποσότητα στο query άρα υφίσταται και έννοια ποσοτικής τιμής οπότε σετάρουμε και τα παρακάτω
            if($a74['p010'] > 0) {
                if($a74['p030'] > 0 || $a74['p031'] > 0) {
                    $is_quantity_discounts = true;
                    $discount_1_quantity = $discount_1;
                    $discount_2_quantity = $discount_2;
                }

                if($a74['p03'] > 0 || $a74['pt01'] > 0){
                    $is_quantity_price = true;
                    $price_quantity = $timh;
                }
            }

        }
    }

    if (pegasus_mysql_table_exists('a73') and $mode == 'a01' and $serial_en == 0) {
        /* ελεγχω αν υπάρχει ειδική τιμή στην ομαδα του είδους ή εκπτωση */
        if ($aekp_en == 0) {
            pegasus_mysql_use(
                "SELECT * FROM a73 WHERE 
                        (    (p00=:p03 && p00<>0 && p00_1=0) 
                            || (p00=0 && p00_1<>0 && p00_1=:p00_1 )
                        )
                        && p000 IN (:cona11_nr01, 0)   
                        && p05<=:p05 && :p06<=p06 and " .
                    "  
                        ( 
                               (a73.p01=:a73_p01
                                  || a73.p01=0 )  
                            && (    a73.p07=:a73_p07
                                  || a73.p07=0 )
                            && (    a73.p08=:a73_p08
                                  || a73.p08=0 )
                            && (    a73.p09=:a73_p09
                                  || a73.p09=0 )                                                         
                         )  
                        
                        ORDER BY a73.p000 DESC, a73.p00_1, a73.p07 DESC ",
                $a73,
                array(
                    "p03"        =>    $p03,
                    "p00_1"        =>  $p03_p06,
                    "p01"        =>    $i00['p9901'],
                    "p05"        =>    $date,
                    "p06"        =>    $date,
                    "a73_p01"    =>    $i00['p9901'],
                    "a73_p07"    =>    $i00['p9902'],
                    "a73_p08"    =>    $i00['p9907'],
                    "a73_p09"    =>    $i00['p99'],
                    "cona11_nr01" => $cona11_nr01
                )
            );
            if (!empty($a73['nr01']) and $a73['nr01'] > 0) {
                $discount_1 = $a73['p03'];
                $discount_2 = $a73['p031'];
                $aekp_en = 1;
                if ($a73['pt01'] == 1) {
                    $timh = $i00['timh3'];
                    $wthfpa = $wthfpa_timh_3;
                }
                if ($a73['pt01'] == 2) {
                    $timh = $i00['timh2'];
                    $wthfpa = $wthfpa_timh_2;
                }
                if ($a73['pt01'] == 3) {
                    $timh = $i00['timh4'];
                    $wthfpa = $wthfpa_timh_4;
                }
                if ($a73['pt01'] == 4) {
                    // $timh = inventory_find_cost_price($product_code, $p703, $p703, '', $date);
                    $timh = $i00['timh1'];
                    $wthfpa = $wthfpa_timh_1;
                }
            }
        }
    }

    if (pegasus_mysql_table_exists('a75') and $mode == 'a00' and $serial_en == 0) {
        /* ελεγχω αν υπάρχει ειδική τιμή στην ομαδα του είδους ή εκπτωση */
        if ($aekp_en == 0) {
            pegasus_mysql_use(
                "SELECT * FROM a75 
                     WHERE 
                    (    (p00=:p03 && p00<>0 && p00_1=0) 
                        || (p00=0 && p00_1<>0 && p00_1=:p00_1)
                    ) &&
                     p05<=:p05 && 
                     :p06<=p06 and 
                     ( 
                         (a75.p01=:a75_p01
                              || a75.p01=0 )  
                        && (    a75.p07=:a75_p07
                              || a75.p07=0 )
                        && (    a75.p08=:a75_p08
                              || a75.p08=0 )    
                        && (    a75.p09=:a75_p09
                              || a75.p09=0 )    
                     ) 
                     
                     ORDER BY a75.p000 DESC, a75.p00_1, a75.p07 DESC ",
                $a75,
                array(
                    "p03"        =>    $p03,
                    "p00_1"       =>   $p03_p06,
                    "p01"        =>    $i00['p9901'],
                    "p05"        =>    $date,
                    "p06"        =>    $date,
                    "a75_p01"    =>    $i00['p9901'],
                    "a75_p07"    =>    $i00['p9902'],
                    "a75_p08"    =>    $i00['p9907'],
                    "a75_p09"    =>    $i00['p99']
                )
            );
            if (!empty($a75['nr01']) and $a75['nr01'] > 0) {
                $discount_1 = $a75['p03'];
                $discount_2 = $a75['p031'];
                $aekp_en = 1;
                if ($a75['pt01'] == 1) {
                    $timh = $i00['timh3'];
                    $wthfpa = $wthfpa_timh_3;
                }
                if ($a75['pt01'] == 2) {
                    $timh = $i00['timh2'];
                    $wthfpa = $wthfpa_timh_2;
                }
                if ($a75['pt01'] == 3) {
                    $timh = $i00['timh4'];
                    $wthfpa = $wthfpa_timh_4;
                }
                if ($a75['pt01'] == 4) {
                    // $timh = inventory_find_cost_price($product_code, $p703, $p703, '', $date);
                    $timh = $i00['timh1'];
                    $wthfpa = $wthfpa_timh_1;
                }
            }
        }
    }

    //Τιμή είδους από ποσότητα
    if ($pos > 0 and $timh == 0 and pegasus_module_exists('invprices') and $aekp_en == 0 and ($mode == 'a01' /*|| $mode == 'a00'*/) and $serial_en == 0) {
        /* 10=i37 akeraio pollapl h megal */
        $timh_cost = inventory_find_cost_price($i00['pno'], $p703, $p703, '', $date);
        $query = "SELECT
                    10 as type,
                    if(timh1=0, :timh1 , timh1) as timh1,
                    if(timh2=0, :timh2 , timh2) as timh2,
                    if(timh3=0, :timh3 , timh3) as timh3,
                    if(timh4=0, :timh4 , timh4) as timh4,
                    p90 as ekp
                 FROM i37
                 WHERE i37.p01=:i37_p01
                   AND (  
                         (mod(:pos0, i37.p02) = 0 AND i37.p901 = 0) OR
                         i37.p901 = 1
                       )
                   AND i37.p02 > 0
                   AND i37.p02 <= :pos1
                   AND (
                         (i37.p010 <= :i37_p010 AND i37.p011 >= :i37_p011) OR
                         i37.p011 <= '01000101'
                       )
                ORDER BY i37.p02 DESC
                LIMIT 1 ";
        $query_array = array(
            "timh1"        =>    $timh_cost,
            "timh2"        =>    $i00['timh2'],
            "timh3"        =>    $i00['timh3'],
            "timh4"        =>    $i00['timh4'],
            "i37_p01"    =>    $i00['pno'],
            "pos0"        =>    $pos,
            "pos1"        =>    $pos,
            "i37_p010"    =>    $date,
            "i37_p011"    =>    $date
        );
        pegasus_mysql_use($query,  $pos_timh, $query_array);

        if ($timh == 0 and $pos_timh['type'] == 10) {
            if ($p03_tbl['p48'] == 1) {
                $timh = ($pos_timh['timh3']);
                $wthfpa = $wthfpa_timh_3;
            }
            if ($p03_tbl['p48'] == 2) {
                $timh = ($pos_timh['timh2']);
                $wthfpa = $wthfpa_timh_2;
            }
            if ($p03_tbl['p48'] == 3) {
                $timh = ($pos_timh['timh4']);
                $wthfpa = $wthfpa_timh_4;
            }
            if ($p03_tbl['p48'] == 4) {
                $timh = $pos_timh['timh1']; /* inventory_find_cost_price($product_code, $p703, $p703, '', $date); */
                $wthfpa = $wthfpa_timh_1;
            }
        }
       // var_dump($timh);

        if ($pos_timh['type'] == 10 /*$pos_timh[ekp]!=0*/) {
            $discount_1 = $pos_timh['ekp'];
            $discount_2 = 0;
            $aekp_en = 1;
            $is_quantity_discounts = true;
            $discount_1_quantity = $discount_1;
            $discount_2_quantity = $discount_2;
        }
        if($timh>0){
            $is_quantity_price = true;
            $price_quantity = $timh;
        }
    }

    $i14_p07 = 0;
    $find_price_from_i17 = 0;
    /* Ελέγχω αν ο εχει ο πέλάτης ειδικο τιμοκατάλογο  και άν το είδος δεν ειναι εξοδα αποστολής */
    if ($p03_p06 > 0  and  $aekp_en == 0 and pegasus_module_exists('invprices') and $serial_en == 0) {
        $timh = pegasus_mysql_printfld('i17', 'pe03', 'pe01=? and pe02=?', array($i00['pno'], $p03_p06));

        if ($timh > 0) {
            $find_price_from_i17 = 1;
            if($p03_p52 > 0 || $p03_p52a > 0) { //Ποσοστό έκπτωσης. Έρχεται συμπληρωμένο π.χ. στην εύρεση τιμής της προσφοράς 
                $discount_1  = $p03_p52;
                $discount_2  = $p03_p52a;
            } 
            else if($mode == 'a01' || $mode == 'a00'){
                $discount_1  = $p03_tbl['p52'];
                $discount_2  = $p03_tbl['p52a'];
            }

            pegasus_mysql_use('select p03, p07 from i14 where  p01=? ', $i14_ar, array($p03_p06));
            $wthfpa =   $i14_ar['p03'];
            $i14_p07 =   $i14_ar['p07'];

        }
    }

    /* το p617 είναι η % Εκπτωσης που βάζω στο είδος στην αποθηκη*/
    $p617  = $i00['p617'];
    $p617a = $i00['p617a'];

    /******
     * 4.3 Τιμή από τον βασικό τιμοκατάλογο
     ******/ 

    /* Αν η τιμή είναι ίση με 0 ψάχνω για τιμη απο τον τιμοκατάλογο  */
    if ($timh == 0) {
        if ($p03_tbl_p48 == 1) {
            $timh = $i00['timh3'];
            $wthfpa = $wthfpa_timh_3;
        }
        if ($p03_tbl_p48 == 2) {
            $timh = $i00['timh2'];
            $wthfpa = $wthfpa_timh_2;
        }
        if ($p03_tbl_p48 == 3) {
            $timh = $i00['timh4'];
            $wthfpa = $wthfpa_timh_4;
        }

        if($p03_tbl_p48 == 4) {
            // Αν αφορά προμηθευτή με Βασικό Τιμοκατάλογο "Κόστος" |-> Κόστος = MK: 4
            if($_SESSION['f02_p624']==1){   //Τιμή Κόστους
                $timh = pegasus_mysql_printfld('i00','timh1','pno=?',array($product_code));
            }else if($_SESSION['f02_p624']==2){ //Τιμή Αγοράς
                $timh = pegasus_mysql_printfld('i00',' p610*(100-p611e)/100','pno=?',array($product_code));
            } else if($_SESSION['f02_p624']==3){//Aπό Τοπικές Αγορές
                $timh=inventory_find_cost_price($product_code, $p703,$p703, '', $date);
            }else if($_SESSION['f02_p624']==4){//Από Συνολικές Αγορές      
                $timh=inventory_find_cost_price($product_code, $p703,$p703, '', $date, 0,0);
            }else if($_SESSION['f02_p624']==5){//Τιμή Αγοράς πριν την Έκπτωση
                $timh = pegasus_mysql_printfld('i00','p610','pno=?', array($product_code));
            }else{
                $timh = inventory_find_teliki_timh_agoras($i00['p610'], $i00['p611e'], $i00['p611']);
            }

            // Σχολιάζω - Έβρισκε την έκπτωση από την Τιμολογική του προμηθευτή πιο πάνω και εδώ την μηδένιζε με αποτέλεσμα να έρχεται πάντα 0 στο είδος παραγγελίας/παραστατικού
            // $discount_1 = 0;
            // $discount_2 = 0;

            //Για την τιμή αγοράς, ξέρουμε αν έχει ΦΠΑ ή όχι μόνο από τον βασικό τιμ του προμηθευτη
            // Έσβησα τα if με τα φπα των άλλων τιμοκ, εδώ θα μπει μόνο όταν έχει Βασικό Τιμ. "Κόστος"
            $wthfpa = $wthfpa_timh_1;
        }
    }
    
     /******
     * 4.4 Εκπτώσεις
     ******/ 
    // Αν αφορά πελάτη Ή προμηθευτή με Βασικό Τιμοκατάλογο διαφορετικό του "Κόστος" |-> Κόστος = MK: 4
    if ($mode == 'a01' || ($mode == 'a00' && $p03_tbl_p48 != 4) ) {
        //Αν δεν βρώ τιμή απο τον ειδικο τιμοκαταλό ή βρω τιμοκαταλογο και εχει το υπολογίζει τις εκπτώσεις  
        if (($i14_p07 == 0 and $find_price_from_i17 == 1) or $find_price_from_i17 == 0) {
            // ** get i00 discounts
            if ($p617 > 0  and ($i00['p617l'] == 0  or $i00['p617l'] == 2)) {
                $discount_1 = $p617;
            }
            if ($p617a > 0  and ($i00['p617l'] == 0  or $i00['p617l'] == 2)) {
                $discount_2 = $p617a;
            }

            // ** add i00 discounts
            if ($p617 > 0   and ($i00['p617l'] == 1)) {
                $discount_1 = round($p617 + $discount_1 - ($p617 * $discount_1) / 100, 3);
            }
            if ($p617a > 0  and ($i00['p617l'] == 1)) {
                $discount_2 = round($p617a + $discount_2 - ($p617a * $discount_2) / 100, 3);
            }

            if ($p617 > 0  and !($discount_1 > 0) and $i00['p617l'] == 3) {
                $discount_1 =  $p617;
            }
            if ($p617a > 0 and !($discount_2 > 0) and $i00['p617l'] == 3) {
                $discount_2 =  $p617a;
            }

            //** get max discount                       
            if ($p617 > 0   and $i00['p617l'] == 4 and $discount_1 < $p617) {
                $discount_1 =  $p617;
            }
            if ($p617a > 0  and $i00['p617l'] == 4 and $discount_2 < $p617a) {
                $discount_2 =  $p617a;
            }

            //** get min discount
            if ($p617 > 0   and $i00['p617l'] == 5 and $discount_1 > $p617) {
                $discount_1 =  $p617;
            }
            if ($p617a > 0  and $i00['p617l'] == 5 and $discount_2 > $p617a) {
                $discount_2 =  $p617a;
            }
        } elseif ($i14_p07 == 2 and $find_price_from_i17 == 1) {
            $discount_1 = 0;
            $discount_2 = 0;
        }
    }  

    /******
     * 4.5 ΦΠΑ
     ******/ 

    if($kath_fpa == 0 && ($mode == 'a01' || $mode == 'a00')) {
       $kath_fpa = $p03_tbl['p45'];
    }

    $fpa_arr = invoice_find_product_fpa($i00['pno'], $kath_fpa,  $date);
    $kfpa = $fpa_arr['v108']; // Katigoria FPA
    $pfpa = $fpa_arr['v105']; // Pososto FPA     


    /* βρίσκω την ελάχιστη τιμή πωλησης */
    $min_timh = $i00['p614'];
    

    //var_dump($price_quantity);
    //var_dump($timh);
    // ελεγχος αν η τιμή μεταβλήθηκε απο την ποσότητα και δεν ξανα αλλαξε
    if( $price_quantity != $timh && $timh>0){
        $is_quantity_price=false;
    }

    if( $discount_1_quantity !=  $discount_1 || $discount_2_quantity != $discount_2){
        $is_quantity_discounts = false;
    }
    
    /* Αν οι τιμές εμφανίζονρια με το φπα  */
    if ($preview_wthfpa == 1) {
        /* Αν η τιμη στην αποθηκη είναι χωρις το φπα το προσθετει */
        if ($wthfpa == 0) {
            $timh = round($timh * (100 + (float)$pfpa) / 100, $ss_inventory_000_p07);
            //echo $timh;
        }
        if ($_SESSION['f02_p06'] != 1 and $mode == 'a01') {
            $min_timh = round($min_timh * (100 + (float)$pfpa) / 100, $ss_inventory_000_p07);
        }

        /* Αν η τιμη στην αποθηκη είναι με το φπα  την αποφορολογεί και προσθετει το Φπα που εχει υπολογισει βασει του καθεστωτος  */
        if ($wthfpa == 1 and $i00['fpa'] != $kfpa) {
            $timh = $timh / ((100 + floatval(pegasus_mysql_printfld('i13', 'p03', 'p01=? ', array($i00['fpa'])))) / 100);
            $timh = round($timh * (100 + (float)$pfpa) / 100,  $ss_inventory_000_p07);
        }

        if ($_SESSION['f02_p06'] == 1  and $mode == 'a01' and $i00['fpa'] != $kfpa) {
            $min_timh = $min_timh / ((100 + floatval(pegasus_mysql_printfld('i13', 'p03', 'p01=?', array($i00['fpa'])))) / 100);
            $min_timh = round($min_timh * (100 + (float)$pfpa) / 100,  $ss_inventory_000_p07);
        }
        //echo $timh;
    }
     else {/* Aν ειναι ενεργό το τιμές χωρίς ΦΠΑ */
        /* Αν η τιμη στην αποθηκη είναι με το φπα την αποφορολογεί */
        if ($wthfpa == 1) {
            $timh = $timh / ((100 + floatval(pegasus_mysql_printfld('i13', 'p03', 'p01=? ', array($i00['fpa'])))) / 100);
        }
        if ($_SESSION['f02_p06'] == 1 and $mode == 'a01') {
            $min_timh = $min_timh / ((100 + floatval(pegasus_mysql_printfld('i13', 'p03', 'p01=? ', array($i00['fpa'])))) / 100);
        }
    }

    if (
        $min_timh > $timh &&
        $_SESSION['f02_p615'] == 1 && /*Οι τιμές πώλησης δεν μπορει να είναι μικρότερες από την κατώτερη*/
        $disable_min_price == 0 &&    /*Ειδικές Τιμές: ∆εν ελέγχεται η κατώτερη τιµή πώλησης */
        $mode == 'a01'
    ) {
        $timh  = $min_timh;
    }


    // προσθέτει τις επιβαρύνσεις
    if ($p03_p523 > 0 && $not_calc_charge == 0) {
        $timh = $timh * (100 + $p03_p523) / 100;
    }

   // echo 'timh -> ' . $timh;
    $timh = round((float) $timh, $ss_inventory_000_p07);

    if ($discount_a72p012 === 1) {
        $discount_1 = $discount_1_a72p012;
        $discount_2 = $discount_2_a72p012;
    }

    if($zero_prices){
        $timh = 0;
        $discount_1 = 0;
        $discount_2 = 0;
        $eisfora_anakyklosis = 0;
    }

    return array(
        'price' => $timh, 
        'fpa' => $pfpa, 
        'kfpa' => $kfpa, 
        'discount_1' => $discount_1, 
        'discount_2' => $discount_2, 
        'preview_wthfpa' => $preview_wthfpa,
        'is_quantity_price' => $is_quantity_price,
        'is_quantity_discounts' => $is_quantity_discounts,
        'eisfora_anakyklosis' => $eisfora_anakyklosis,
        'min_timh' => $min_timh
    );
}



/** Υπολογίζει την τιμή κόστους βάσει της μεθόδου αποτίμησης κόστους του είδους
 * @param string $i00pno , Ο κωδικός του είδους
 * @param int $i00xor1 , κωδικός αποθηκευτικού χώρου 1
 * @param int $i00xor2 , κωδικός αποθηκευτικού χώρου 2
 * @param date $i00df , ημερομηνία από
 * @param date $i00dt , ημερομηνία έως
 * @param int $i00ypol , υπόλοιπο (για FIFO)
 * @param int $i25p01 , Μέθοδος Αποτίμισης Κόστους
 * @return cost , Η τιμή κόστους
 * */
function inventory_find_cost_price($i00pno, $i00xor1, $i00xor2, $i00df, $i00dt, $i00ypol=0, $i25p01 = -1)
{

    if (peg_dateIsEmpty($i00df, 'Y-m-d')) {
        $i00df = '0100-01-01';
    }
    if (peg_dateIsEmpty($i00dt, 'Y-m-d')) {
        $i00dt = '0100-01-01';
    }
    // if (empty($i00ypol)) {
    //     $i00ypol = 0;
    // }

    $peg_dektim = inventory_get_session_value('f01_p07', 'f01', 'p07');   /*Δεκαδικα Τιμής*/

    pegasus_mysql_use('select * from i00 where pno=?', $i00,array($i00pno));
    if ($i00['timh1'] > 0) {
        return round($i00['timh1'], $peg_dektim);
    }
    if ($i25p01 == -1) {
        if (in_array($i00['p414'], array(1, 2, 3, 4, 5, 6, 7, 11, 12, 13, 14, 15, 17))) {
            $i25p01 = $i00['p414'];
        } else {
            $i25p01 = 6;
        }
    } 
    pegasus_mysql_use(
        "select peg_i00cost(i00.pno,?,?,?,?,?,?) as cost from i00 where pno=?",
        $ret,
        array($i00df, $i00dt, $i00xor1, $i00xor2, $i25p01,$i00ypol, $i00pno)
    );

    return $ret['cost'];
  
}
