<?php 
if(!pegasus_module_exists('pegapi')){
	return;
}

class inventory_pegapi_i02 extends pegapi_RestTableObject{
	public function __construct($method, $request = null, $file = null) {
		parent::__construct($method, $request , $file );
		$this->table = 'i02';
		$this->_d = 'i02_d';
		$this->module = 'inventory';
	}
	public function get($args = array()){
		return parent::get($args);
	}
	
	public function post(){		
		if(	empty($this->request['p03']) || 
			empty($this->request['p08']) ){
			$error_msg="Missing File";
				return array(
					'status'	=> 406,
					'code'		=> 406,
					'data'		=> array(
							'msg' => $error_msg
					)
				);
		}
		$filexte=$this->request['p08'];	// extension αρχείου 
		if(!in_array($filexte, array('jpg','jpeg','png','gif') )){
			$error_msg="Not Accepted File Extension! Only jpg , jpeg , png , gif allowed";
			return array(
					'status'	=> 406,
					'code'		=> 406,
					'data'		=> array(
									'msg' => $error_msg
					)
			);
		}
		try{
			$decoded_file=base64_decode($this->request['p03']);
			$this->request['p03']=$decoded_file;
			$retAr=parent::post();
			$this->totalrec = 1 ;
		}catch (PegApiException $e) {
			if( $e->getStatus()!='201'){
				throw new PegApiException('', $e->getCode(), null, $e->getStatus(),  $e->getErrorData()['error']['title'] ,  $e->getErrorData()['error']['detail'],$e->getAction());
				return;
			}
		}
		return $retAr;
			
	}
	public function put(){
		try{
			$decoded_file=base64_decode($this->request['p03']);
			$this->request['p03']=$decoded_file;
			$retAr=parent::put();
			$this->totalrec = 1 ;
			return $retAr;
		}catch (PegApiException $e) {
			if( $e->getStatus()!='201'){
				throw new PegApiException('', $e->getCode(), null, $e->getStatus(),  $e->getErrorData()['error']['title'] ,  $e->getErrorData()['error']['detail'],$e->getAction());
				return;
			}
		}
	}
	protected function _getFieldsFromTable(){
		$tableFields = array(
				'nr01'		=>	array( 'fld' => 'nr01', 'tp' => 'N', 'fldsz' => 15, 'flddec' => 0 ),
				'p00'		=>	array( 'fld' => 'p00' , 'tp' => 'C', 'fldsz' => 14 , 'flddec' => 0 ),
				'p01'		=>	array( 'fld' => 'p01' , 'tp' => 'N', 'fldsz' => 1 , 'flddec' => 0 ),
				'p02'		=>	array( 'fld' => 'p02',  'tp' => 'Μ', 'fldsz' => 10 , 'flddec' => 0 ),
				'p03'		=>	array( 'fld' => 'p03' , 'tp' => 'M', 'fldsz' => 10 , 'flddec' => 0 ),
				'p04'		=>	array( 'fld' => 'p04',  'tp' => 'D', 'fldsz' => 8 , 'flddec' => 0 ),
				'p05'		=>	array( 'fld' => 'p05' , 'tp' => 'C', 'fldsz' => 10 , 'flddec' => 0 ),
				'p08'		=>	array( 'fld' => 'p08',  'tp' => 'C', 'fldsz' => 10, 'flddec' => 0 ),
				'tax'		=>	array( 'fld' => 'tax',  'tp' => 'C', 'fldsz' => 10, 'flddec' => 0 ));	
	
	
		$tableFields['remdate'] = array('fld' => 'remdate','tp' => 'D', 'fldsz' => 10 ,  'flddec' => 0);
		$tableFields['remtime'] = array('fld' => 'remtime','tp' => 'C', 'fldsz' => 10 ,  'flddec' => 0);
		$tableFields['remuser'] = array('fld' => 'remuser','tp' => 'C', 'fldsz' => 50 ,  'flddec' => 0);
		$tableFields['remfdate'] = array('fld' => 'remfdate','tp' => 'D', 'fldsz' => 10 ,  'flddec' => 0);
		$tableFields['remftime'] = array('fld' => 'remftime','tp' => 'C', 'fldsz' => 10 ,  'flddec' => 0);
		$tableFields['remfuser'] = array('fld' => 'remfuser','tp' => 'C', 'fldsz' => 50 ,  'flddec' => 0); 
	

		return $tableFields;
	}
	protected function _getQuery($fields='' , $joinTables = '',  $params = array()){
		if(!is_array($params)){
			$params = array();
		}	
		$select =  "select 	nr01,p00,p01,p02,TO_BASE64(p03) as p03,p04,p05,p08,tax,
									remdate,remtime,remuser,remfdate,remftime,remfuser
							from i02 ";

		return str_replace(array_keys($params), array_values($params) , $select); 
	}
}

?>