<?php
require_once('../inventory00/header.php');

$barcode_len = $_REQUEST['peg_grid_barcode_len'];
$i00_pref = $_REQUEST['peg_grid_bar_i00_pref'];
$i47_pref = $_REQUEST['peg_grid_bar_colsize_pref'];


if (empty($barcode_len) || $barcode_len < 1) {
    echo json_encode(array(
        'ok' => 0,
        'msg' => $_SESSION['peg_dic_inventory_barcode_no_min_len']
    ));
    return;
}
if(!pegasus_module_exists('colorsize') && !empty($i47_pref)) {
    echo json_encode(array(
        'ok' => 0,
        'msg' => $_SESSION['peg_dic_inventory_not_exist_color_size']
    ));
    return;
}

if (pegasus_module_exists('colorsize') && !empty($i47_pref)) {
    if ($i00_pref == $i47_pref) {
        echo json_encode(array(
            'ok' => 0,
            'msg' => $_SESSION['peg_dic_inventory_barcode_prefix_same']
        ));
        return;
    }
}

if (empty($i00_pref) && empty($i47_pref)) {
    echo json_encode(array(
        'ok' => 0,
        'msg' => $_SESSION['peg_dic_inventory_barcode_no_prefix']
    ));
    return; 
}

if(!empty($i00_pref)){
    $i00_pref = substr($i00_pref,0,1);
}

if(!empty($i47_pref)){
    $i47_pref = substr($i47_pref,0,1);
}

$my_num = pow(10,($barcode_len - 1));

$i00_query = "SET @n1:= :my_num + ifnull( (SELECT MAX( cast(substr(p01, 2, :barlen-1) as signed) ) 
                                            from i00 
                                            where substr(p01, 1, 1)=:i00_pref
                                            AND length(p01)=:barlen ), 0) ;";

pegasus_query(
    $i00_query,
    array(
        'my_num' => $my_num,
        'i00_pref' => $i00_pref,
        'barlen' => $barcode_len
    )
);

$i00_query = "UPDATE i00
              set p01=concat(:i00_pref, substr(@n1:=@n1 + 1, 2, :barlen-1) ), 
                  remdate=curdate(), 
                  remtime=curtime(), 
                  remuser=:user
              where p01='';";
pegasus_query(
    $i00_query,
    array(
        'i00_pref' => $i00_pref,
        'barlen' => $barcode_len,
        'user'=>$_SESSION['username']
    )
);

if (pegasus_module_exists('colorsize')) {
    $i47_query = "SET @n1:= :my_num + ifnull( (SELECT MAX( cast(substr(p04, 2, :barlen-1) as signed) ) 
                                            from i47 
                                            where substr(p04, 1, 1)=:i47_pref
                                            AND length(p04)=:barlen ), 0) ;";

    pegasus_query(
        $i47_query,
        array(
            'my_num' => $my_num,
            'i47_pref' => $i47_pref,
            'barlen' => $barcode_len
        )
    );

    $i47_query = "UPDATE i47
              set p04=concat(:i47_pref, substr(@n1:=@n1 + 1, 2, :barlen-1) ), 
                  remdate=curdate(), 
                  remtime=curtime(), 
                  remuser=:user
              where p04='';";

    pegasus_query(
        $i47_query,
        array(
            'i47_pref' => $i47_pref,
            'barlen' => $barcode_len,
            'user'=>$_SESSION['username']
        )
    );
}

echo json_encode(array(
    'ok' => 1,
    'msg' =>  $_SESSION['peg_dic_core_pros_ok']   
));
return;