<?php

    Class InvoicesPrintsClass {

        public static function getProductsQueryFields($mode){

            if(in_array($mode, array('a55','a56', 'a60'))){
                return self::invoiceProductsQueryFields($mode);
            }elseif(in_array($mode, array('a57','a67', 'a61'))){
                return self::orderProductsQueryFields($mode);
            }         
            
        }

        public static function getProductsQuery($mode, $type, $nr01, $cs_analysis=false, $costs=array(), $disable_i71=false, $lang="GR", $order_by=""){
            if(in_array($mode, array('a55','a56', 'a60'))){
                return self::invoiceProductsQuery($type, $nr01, $cs_analysis, $costs, $disable_i71, $lang, $order_by);
            }elseif(in_array($mode, array('a57','a67', 'a61'))){
                return self::orderProductsQuery($mode, $nr01, $costs, $disable_i71, $lang, $order_by);
            }
        }   
        
        /**
         * Ομαδοποιημένο Query Ειδών - Χρήση γα την εκτυπωση Παραστατικών Μαζικού Μετασχηματισμού
         */
        public static function getProductsGroupedQuery($mode, $type, $nr01, $cs_analysis=false, $costs=array(), $disable_i71=false, $lang="GR", $order_by="", $prd_analysis=0){
            if(in_array($mode, array('a55','a56', 'a60'))){
                return self::invoiceProductsGroupedQuery($type, $nr01, $cs_analysis, $costs, $disable_i71, $lang, $order_by, $prd_analysis);
            }
        }

        public static function getProductsQueryOrderBy($mode, $order_by=''){

            if(empty($order_by)){ return ''; }

            if($mode=='a57'){
                $tbl = 'a58'; 
            }elseif($mode=='a67'){
                $tbl = 'a68'; 
            }else{
                $tbl = 'i01';  
            } 
            $tbl_in = "'".$tbl."','i00','i10'";

            $products_query_fields = self::getProductsQueryFields($mode);

            //Find only Numeric Fields ('L','N') 
            $p51_query  = "select p50.p01 as p50_p01, p51.desc05, p51.desc16 from p51 ";
            $p51_query .= "join p50 on p50.p02=p51.p02 ";
            $p51_query .= "join p60 on p60.p00=p51.desc16 ";
            $p51_query .= "where p50.p01 in (".$tbl_in.") and p50.p102=1 and p60.isdbfld=1 and p51.desc16 in ('L','N') ";
            $p51_query .= "order by field(p50.p01,".$tbl_in."), p51.desc06,p51.nr01;";
            $result = pegasus_query($p51_query);
            while ($p51=pegasus_fetch_assoc($result)) {
                if($p51['p50_p01']==$tbl){
                    $numeric_fields[] = $p51['desc05'];
                }else{
                    $numeric_fields[] = $p51['p50_p01'].'_'.$p51['desc05'];
                }
            }

            $order_by_arr = explode(',', $order_by); 
            foreach ($order_by_arr as $key=>$value) {
                $fld_tmp = explode(' ', trim($value));
                if(!in_array($fld_tmp[0], array_values($products_query_fields))){
                    unset($order_by_arr[$key]); 
                    continue;   
                }
                $fld_tmp_key = array_search($fld_tmp[0], $products_query_fields);
                if(in_array($fld_tmp_key, $numeric_fields)){
                    $order_by_arr[$key] = 'cast('.$fld_tmp[0]. ' as unsigned) ' . $fld_tmp[1];    
                }                
            }
            $order_by = implode(',', $order_by_arr);

                       
            
            
            return $order_by;
        }

        public static function sanitizeExpressionField($field_name){

            $replace_arr = array();
            
            $replace_arr['a67_'] = 'a55a56a57a67_';
            $replace_arr['a57_'] = 'a55a56a57a67_';
            $replace_arr['a56_'] = 'a55a56a57a67_';
            $replace_arr['a55_'] = 'a55a56a57a67_';
            
            $replace_arr['_a00_'] = '_a00a01_';      $replace_arr['_a01_'] = '_a00a01_';
            $replace_arr['_a03_'] = '_a03a05_';      $replace_arr['_a05_'] = '_a03a05_';
            $replace_arr['_a04_'] = '_a04a06_';      $replace_arr['_a06_'] = '_a04a06_';
            $replace_arr['_a07_'] = '_a07a08_';      $replace_arr['_a08_'] = '_a07a08_';
            $replace_arr['_a10_'] = '_a10a11_';      $replace_arr['_a11_'] = '_a10a11_';
            $replace_arr['_a14_'] = '_a14a15_';      $replace_arr['_a15_'] = '_a14a15_';
            $replace_arr['_a71_'] = '_a71a76_';      $replace_arr['_a76_'] = '_a71a76_';
            $replace_arr['_a33_'] = '_a33a34_';      $replace_arr['_a34_'] = '_a33a34_';

            $replace_arr['_a71_00_'] = '_a71_00a76_00_';      $replace_arr['_76_00_'] = '_a71_00a76_00_';

            $field_name = str_replace(array_keys($replace_arr), array_values($replace_arr), $field_name);

            return $field_name;
        }
        
        /**
         * Preview Price With/Without VAT
         * @param float     $price
         * @param boolean   $vat_included: If Price includes VAT or Not
         * @param float     $vat: VAT Percentage
         * @param boolean   $preview_with_vat: If Previewed Price will include VAT or Not
         * @return float 
         */
        public static function previewPrice($price, $vat_included, $vat, $preview_with_vat){

            if($vat_included==$preview_with_vat){
                return $price;                
            }elseif($preview_with_vat==0){
                //Προσέθεσα το round γιατί αν έχει πολλά δεκαδικά ψηφία θεωρείται string στην peg002_format_number και δεν κάνει round
                $price = round($price * 100/(100 + $vat) , 5); 
            }elseif($preview_with_vat==1){
                $price = round($price * ((100 + $vat)/100), 5);
            }
            
            return $price;
        }

        /**
         * Get Product Serial Numbers
         * @param int       $nr01 ΜΚ Κίνησης
         * @param string    $mode 'a55','a56','a60','a57','a67','a61'
         * @param boolean   $i31p07_en Εφάνιση Ιδιοκτήτη SN
         * @param boolean   $is_array
         * @param string    $separator 
         * @return mixed 
         */
        public static function getProductSerialNumbers($nr01, $mode, $i31p07_en=false, $is_array=false, $separator=''){

            if(in_array($mode, array('a55','a56'))){
                $i32p010 = 1;
            }elseif(in_array($mode, array('a57','a67'))){
                $i32p010 = 2;
            }elseif(in_array($mode, array('a60', 'a61'))){
                $i32p010 = 3;
            }

            if(pegasus_module_exists('serial')){

                $sql  = "select ";
                $sql .= "i32.nr01, i32.p00, i32.p010, i32.p01, i32.p02, ";
                $sql .= "i31.p015 as i31_p015, ";
                if(pegasus_mysql_table_exists('cona11')){
                    $sql .= "cona11.p04 as cona11_p04, cona11.p05 as cona11_p05,  ";
                }                
                $sql .= "d00_i31p07.p19 as d00_i31p07_p19 ";
                $sql .= "from i32 ";
                $sql .=	"left join i31 on i32.p02=i31.p02 and i32.p01=i31.p01 ";
                $sql .=	"left join d00 as d00_i31p07 on d00_i31p07.nr01=i31.p07 ";
                if(pegasus_mysql_table_exists('cona11')){
                    $sql .=	"left join cona11 on cona11.nr01=i31.p030 ";
                }
                $sql .= "where i32.p010=:i32p010 and i32.p00=:i32p00;";

                $sqlParams = array('i32p010'=>$i32p010, 'i32p00'=>$nr01);

                $result = pegasus_query($sql, $sqlParams);
                $serial_numbers = pegasus_fetchall($result);
                //echo "<pre>". print_r($serial_numbers,1) . "</pre>";
                //echo pegasus_replace_values_in_sql($sql, $sqlParams);
                
                if($is_array==true){
                    return $serial_numbers;
                }else{
                    $serial_numbers_str = '';   
                    foreach ($serial_numbers as $sn) {
                        $serial_numbers_str .= !empty($serial_numbers_str) ? '##sep##' : '';
                        $serial_numbers_str .= 'S.N.:'.$sn['p02'];

                        if($i31p07_en==true && !empty($sn['d00_i31p07_p19'])){
                            $serial_numbers_str .= ' '.$sn['d00_i31p07_p19'];
                        }
                        
                        if(!peg_dateIsEmpty($sn['cona11_p04']) && !peg_dateIsEmpty($sn['cona11_p05'])){
                            $serial_numbers_str .= ' '.peg_dateToStr($sn['cona11_p04']).'-'.peg_dateToStr($sn['cona11_p05']);
                        }

                        if(!empty($sn['i31_p015'])){
                            $serial_numbers_str .= "\n".$sn['i31_p015'];
                        }
                    } 

                    $separator = !empty($separator) ? $separator : ",\n";
                    $serial_numbers_str = str_replace('##sep##', $separator, $serial_numbers_str);
                    //echo "<pre>". $serial_numbers_str . "</pre>";

                    return $serial_numbers_str;
                }

            }
            
            return false;
        }

        private static function orderProductsQueryFields($mode){

            $products_query_fields = array(
                'nr01'      => 'nr01', 
                'p00'       => 'p00', 
                'p591'      => 'p591', 
                'remdate'   => 'remdate', 
                'remfdate'  => 'remfdate', 
                'remftime'  => 'remftime', 
                'remfuser'  => 'remfuser', 
                'remguc'    => 'remguc', 
                'remtime'   => 'remtime', 
                'remuser'   => 'remuser', 
                'timh1'     => 'timh1', 
                'timh2'     => 'timh2', 
                'timh3'     => 'timh3', 
                'timh4'     => 'timh4', 
                'v101'      => 'v101', 
                'v102'      => 'v102', 
                'v103'      => 'v103', 
                'v104'      => 'v104', 
                'v1041'     => 'v1041', 
                'v1042'     => 'v1042', 
                'v105'      => 'v105', 
                'v106'      => 'v106', 
                'v106a'     => 'v106a', 
                'v107'      => 'v107', 
                'v108'      => 'v108', 
                'v109'      => 'v109', 
                'v111'      => 'v111', 
                'v120'      => 'v120', 
                'v160'      => 'v160', 
                'v161'      => 'v161', 
                'v301'      => 'v301', 
                'v302'      => 'v302', 
                'v303'      => 'v303', 
                'v304'      => 'v304', 
                'v306'      => 'v306', 
                'v307'      => 'v307', 
                'v308'      => 'v308', 
                'v309'      => 'v309', 
                'v310'      => 'v310', 
                'v616'      => 'v616', 
                'v900'      => 'v900', 
                'vapc1'     => 'vapc1', 
                'vapcl1'    => 'vapcl1',
                'vd100'     => 'vd100', 
                'i19p03'    => 'i19p03', 
                'i71_tot'   => 'i71_tot',

                'i24_dek'   => 'i24_dek',
                'i24_p02'   => 'i24_p02',                
                'i24_ep02'  => 'i24_ep02',

                'i00_p9001' => 'i00_p9001',  
                'i00_ths'   => 'i00_ths', 
                'i00_p200'  => 'i00_p200',
                'i00_p9903' => 'i00_p9903',
                'a90_p30'   => 'a90_p30',
                
                'perigrafi'         =>  'perigrafi',
                'color_size'        =>  'color_size',   
                'color_size_code'   =>  'color_size_code',
                'serials'           =>  'serials', 
                'serials_with_crm'  =>  'serials_with_crm', 
                'lots'              =>  'lots',
            );

            if($mode=='a57'){ 
                $products_query_fields['vd01']   = 'vd01';
                $products_query_fields['v614']   = 'v614';
                $products_query_fields['i18a58'] = 'i18nr01';

                $products_query_fields['vd101'] = 'vd101';
                $products_query_fields['vd101'] = 'vd101';
                $products_query_fields['p703'] = 'p703';
                $products_query_fields['p616p'] = 'p616p';
            }elseif($mode=='a67'){
                $products_query_fields['i18a68'] = 'i18nr01';

                $products_query_fields['vd101'] = 'vd101';
                $products_query_fields['vd101'] = 'vd101';
                $products_query_fields['p703'] = 'p703';
                $products_query_fields['p616p'] = 'p616p';
            }

            return $products_query_fields;
        }

        private static function orderProductsQuery($mode, $a57a67_nr01, $costs, $disable_i71=false, $lang="GR", $order_by=""){
            
            $tbl    = ($mode=='a67') ? 'a68' : 'a58';            
            $cs_tbl = ($mode=='a67') ? 'a69' : 'a59';

            if($mode == 'a61'){
                $tbl = 'a62';
                $cs_tbl = 'a63';
            }

            $perigrafi  = "concat(if('".$lang."'!='GR' and i00.p9000!='', i00.p9000, ".$tbl.".v102)";
            $perigrafi .= ", if(".$tbl.".v160='', '', concat(if(".$tbl.".v102 = '', '', '\\n'), ".$tbl.".v160))";
            $perigrafi .= ", IF(a90.p30 IS NULL, '', concat('\n', a90.p30))";
            $perigrafi .= ") ";

            $color_size      = "''";
            $color_size_code = "''";
            //$p85_output['cs_analysis': Υπάρχει άλλη φόρμα που καλεί τη φόρμα εδώ, με μόνη αλλαγή ότι έχει σεταρισμένο το $cs_analysis = true
            if(pegasus_module_exists('colorsize')){
                //Χρειάζομαι το distinct για την περίπτωση όπου έχω και πολλαπλά χρώματα μεγέθη
                $color_size_tmp = "group_concat(distinct if(".$cs_tbl.".nr01 IS NULL || i40.p01 IS NULL || i43.p01 IS NULL, '', ##color_size##) SEPARATOR ',\\n')";
                if($lang=="GR"){
                    $color_size =  "concat(i40.p02, IF(i40.p02='', '', '-'), i43.p02, ' x ', Format(".$cs_tbl.".p04, i24.dek))";
                }elseif($lang=="EN"){
                    $color_size =  "concat(i40.ep02, IF(i40.ep02='', '', '-'), i43.ep02, ' x ', Format(".$cs_tbl.".p04, i24.dek))";
                }
                $color_size_code =  "concat(i40.p01, IF(i40.p01='', '', '-'), i43.p01, ' x ', Format(".$cs_tbl.".p04, i24.dek))";

                $color_size      = str_replace("##color_size##", $color_size, $color_size_tmp);
                $color_size_code = str_replace("##color_size##", $color_size_code, $color_size_tmp);
            }



            $serials          = '""';
            $serials_with_crm = '""';
            if(pegasus_module_exists('serial')){
                //Χρειάζομαι το distinct για την περίπτωση όπου έχω και πολλαπλά serial
                $concat_serial  = "concat('S.N.:', i32.p02";
                $concat_serial .= ", ##serial_crm##";
                if(pegasus_mysql_table_exists('cona11')){
                    $concat_serial .= ", if(i32.cona11_p04 is not NULL AND i32.cona11_p05 is not NULL, concat(' ', DATE_FORMAT(i32.cona11_p04, '%d/%m/%Y'), '-', DATE_FORMAT(i32.cona11_p05, '%d/%m/%Y')), '')";
                }
                $concat_serial .= ", if(i32.i31_p015!='', concat('\\n', i31_p015), '')";
                $concat_serial .= ")";

                $serials = "group_concat(distinct if(i32.nr01 IS NULL, '', ". str_replace("##serial_crm##", "''", $concat_serial) ." ) SEPARATOR ',\\n')";
                $serials_with_crm = "group_concat(distinct if(i32.nr01 IS NULL, '', ". str_replace("##serial_crm##", "if(i32.d00_i31p07_p19!='', concat(' ', i32.d00_i31p07_p19), '')", $concat_serial) ." ) SEPARATOR ',\\n')";
            }


            $lots = '""';
            if(pegasus_module_exists('lot')){
                //Χρειάζομαι το distinct για την περίπτωση όπου έχω και πολλαπλά Lot
                if($lang=="EN"){
                    $concat_lot  = "concat('Lot: ', i38.p02,' ',' (',i38.p04,')')";
                }else{
                    $concat_lot  = "concat('Παρτίδα: ', i38.p02,' ',' (',i38.p04,')')";    
                }

                $lots = "group_concat(distinct if(i38.nr01 IS NULL, '', ".$concat_lot." ) SEPARATOR ',\\n')";
            }



            $products_query_fields = self::getProductsQueryFields($mode);

            $sql_fields = '';
            foreach ($products_query_fields as $field=>$alias) {
                if(!empty($sql_fields)) { $sql_fields .= ", \n"; }
    
                switch (true) {
                    case (strpos($field, 'i00_')!==false):
                        $dbfield = "i00.".substr($field, 4);
                        break;

                    case ($field=='perigrafi'): 
                        $dbfield = $perigrafi;
                        break;
                        
                    case ($field=='color_size'): 
                        $dbfield = $color_size;
                        break;   
                        
                    case ($field=='color_size_code'): 
                        $dbfield = $color_size_code;
                        break;     
                        
                    case ($field=='serials'): 
                        $dbfield = $serials;
                        break;   
                        
                    case ($field=='serials_with_crm'): 
                        $dbfield = $serials_with_crm;
                        break;
    
                    case ($field=='lots'): 
                        $dbfield = $lots;
                        break;
    
                    case ($field=='a90_p30'):
                        $dbfield = "a90.p30";
                        break;    

                    case ($field=='i24_dek'):
                        $dbfield = "i24.dek";
                        break;
    
                    case ($field=='i24_p02'):
                        $dbfield = "i24.p02";
                        break;

                    case ($field=='i24_ep02'):
                        $dbfield = "i24.ep02";
                        break;

                    case ($field=='i71_tot'):
                        $dbfield = "0";
                        break;    
                    
                    default:
                        $dbfield = $tbl.".".$field;
                        break;
                }
    
                $sql_fields .= $dbfield . " as " . $alias;
            }
            
            $sql  = " (select ";
            $sql .= $sql_fields;
            $sql .=	" from ".$tbl." ";
            $sql .= " left join i00 on i00.pno=".$tbl.".v101 ";
            $sql .= " left join i24 on i24.p01=i00.ths ";
    
            if(pegasus_module_exists('colorsize')){
                //$sql .= ($mode=='a67') ? " left join a69 on a69.p01=a68.nr01" : " left join a59 on a59.p01=a58.nr01";
                $sql .= " left join ".$cs_tbl." on ".$cs_tbl.".p01=".$tbl.".nr01 ";                
                $sql .=	" left join i40 on i40.p01=".$cs_tbl.".p02 ";
                $sql .=	" left join i43 on i43.p01=".$cs_tbl.".p03 ";
            }

            if(pegasus_module_exists('serial')){
                $sql .=	"left join (";
                $sql .=	"select i32.*, d00_i31p07.p19 as d00_i31p07_p19, i31.p015 as i31_p015 ";
                
                if(pegasus_mysql_table_exists('cona11')){
                    $sql .=	", cona11.p04 as cona11_p04, cona11.p05 as cona11_p05 " ;
                }
                $sql .=	"from i32 ";
                $sql .=	"left join i31 on i32.p02=i31.p02 " ;
                $sql .=	"left join d00 as d00_i31p07 on d00_i31p07.nr01=i31.p07 " ;
                if(pegasus_mysql_table_exists('cona11')){
                    $sql .=	"left join cona11 on cona11.nr01=i31.p030 " ;
                }
                $sql .=	") as i32 on i32.p00=".$tbl.".nr01 and i32.p010=2 ";            
            }


            if(pegasus_module_exists('lot')){
                $sql .=	"left join (select i38.nr01, i38.p02, SUM(i38.p04) AS p04, i38.p01
                                    from i38
                                    WHERE i38.p010=2
                                    group by p01,p02
                                ) as i38 on i38.p01=".$tbl.".nr01 ";
            }


            $sql .= " left join a90 on a90.tbl='".$tbl."' and a90.tbl_nr01=".$tbl.".nr01 ";
            $sql .=	" where ".$tbl.".p00=:a57a67_nr01";
    
            if($mode=='a57' && pegasus_module_exists('orders')){
                $sql .= " and ".$tbl.".v101 not in(:costs_apostpno, :costs_codpno, :costs_cost0pno, :costs_cost1pno, :costs_cost2pno, :costs_cost3pno) ";
            }
            $sql .= " group by ".$tbl.".nr01 ) ";



            $sql_i71_fields = '';
            foreach ($products_query_fields as $field=>$alias) {
                if(!empty($sql_i71_fields)) { $sql_i71_fields .= ", \n"; }
    
                switch (true) {
    
                    case ($field=='nr01'):
                        $dbfield = "(-1) * i71.nr01";
                        break;
    
                    case ($field=='v102'):
                        $dbfield = "i70.p01";
                        break; 
                        
                    case ($field=='v104'):
                        $dbfield = "i71.p100";
                        break;  

                    case ($field=='perigrafi'):
                        $dbfield = "i70.p01";
                        break;   
                    
                    default:
                        $dbfield = "''";
                        break;
                }
    
                $sql_i71_fields .= $dbfield . " as " . $alias . " ";
            }

            //Deductions
            $sql_i71_deduc  = " union (select " . $sql_i71_fields;        
            //$sql_i71_deduc .=  "if(i71.i70p02=1, 1, -1) * if(i71.i70p07=0, 0, i71.p100) as i71_tot, ";
            $sql_i71_deduc .= "from i71 join i70 on i71.i70=i70.nr01 ";	
            $sql_i71_deduc .= "where i71.tbl='".$mode."' and i71.tbl_nr=:a57a67_nr01 and i71.i70p02=2 ";
            $sql_i71_deduc .= "order by i71.i70p02,i70.p01) ";
    
            $replace_array = array("i70.p01"=>($lang=="GR") ? "'Κρατήσεις'" : "'Deductions'","i71.p100"=>"''");
            $sql_i71_deduc_title  = " union (select " . str_replace(array_keys($replace_array), array_values($replace_array), $sql_i71_fields);
            $sql_i71_deduc_title .= "from i71 join i70 on i71.i70=i70.nr01 ";	
            $sql_i71_deduc_title .= "where i71.tbl='".$mode."' and i71.tbl_nr=:a57a67_nr01 and i71.i70p02=2 ";
            $sql_i71_deduc_title .= "limit 1) ";

            //Taxes
            $sql_i71_tax  = " union (select " . $sql_i71_fields;        
            //$sql_i71_tax .=  "if(i71.i70p02=1, 1, -1) * if(i71.i70p07=0, 0, i71.p100) as i71_tot, ";
            $sql_i71_tax .= "from i71 join i70 on i71.i70=i70.nr01 ";	
            $sql_i71_tax .= "where i71.tbl='".$mode."' and i71.tbl_nr=:a57a67_nr01 and i71.i70p02=1 ";
            $sql_i71_tax .= "order by i71.i70p02,i70.p01) ";
            
            $replace_array = array("i70.p01"=>($lang=="GR") ? "'Φόροι'" : "'Taxes'","i71.p100"=>"''");
            $sql_i71_tax_title  = " union (select " . str_replace(array_keys($replace_array), array_values($replace_array), $sql_i71_fields);
            $sql_i71_tax_title .= "from i71 join i70 on i71.i70=i70.nr01 ";	
            $sql_i71_tax_title .= "where i71.tbl='".$mode."' and i71.tbl_nr=:a57a67_nr01 and i71.i70p02=1 ";
            $sql_i71_tax_title .= "limit 1) ";


            $sql_i71 = $sql_i71_deduc_title . $sql_i71_deduc . $sql_i71_tax_title . $sql_i71_tax;
            
            if($disable_i71==false){
                $sql .= $sql_i71;    
            }

            
            $order_by = self::getProductsQueryOrderBy($mode, $order_by);
            
            if(!empty($order_by)){
                $sql  = 'select * from ('.$sql.') as products ';
                $sql .= "\n" . 'order by ';
                $sql .= 'case ';
                $sql .= 'when nr01>0 then 0  ';
                $sql .= 'when nr01<=0 then 1 ';
                $sql .= 'end, ';
                $sql .= $order_by;
            }
            
            $sqlParams = array();
            $sqlParams['a57a67_nr01'] = $a57a67_nr01;
            if($mode=='a57' && pegasus_module_exists('orders')){
                $sqlParams['costs_apostpno'] = isset($costs['apostpno'])   ? $costs['apostpno']   : "";  
                $sqlParams['costs_codpno']   = isset($costs['codpno'])     ? $costs['codpno']     : "";
                $sqlParams['costs_cost0pno'] = isset($costs['s_cost0pno']) ? $costs['s_cost0pno'] : "";
                $sqlParams['costs_cost1pno'] = isset($costs['s_cost1pno']) ? $costs['s_cost1pno'] : "";
                $sqlParams['costs_cost2pno'] = isset($costs['s_cost2pno']) ? $costs['s_cost2pno'] : "";
                $sqlParams['costs_cost3pno'] = isset($costs['s_cost3pno']) ? $costs['s_cost3pno'] : "";
            }
            
            // echo "<pre>". pegasus_replace_values_in_sql($sql,$sqlParams) . "</pre>";
            return array('sql'=>$sql, 'sqlParams'=>$sqlParams);
        }

        private static function invoiceProductsQueryFields($mode=''){
            //[field-name, alias]
            $products_query_fields = array(
                'nr01'              =>  'nr01', 
                'p013'              =>  'p013', 
                'p01'               =>  'v101',
                'p01b'              =>  'v101b',
                'p02'               =>  'v102', 
                'p03'               =>  'v103', 
                'p04'               =>  'v104', 
                'p05'               =>  'p05', 
                'p610'              =>  'p610', 
                'p023'              =>  'p023', 
                'p0601'             =>  'v160',
                'p030'              =>  'v120', 
                'p301'              =>  'v301', 
                'p302'              =>  'v302', 
                'p303'              =>  'v303', 
                'p304'              =>  'v304',
                'p306'              =>  'v306', 
                'p307'              =>  'v307', 
                'p309'              =>  'v309', 
                'p310'              =>  'v310', 
                'p308'              =>  'v308',
                'p09'               =>  'p09', 
                'p012'              =>  'p012', 
                'p010'              =>  'v106', 
                'p010a'             =>  'v106a', 
                'p0100'             =>  'p0100',
                'p042'              =>  'v1042', 
                'p616'              =>  'v616', 
                'p041'              =>  'v1041', 
                'pp011'             =>  'pp011', 
                'p011'              =>  'p011',
                'p0101'             =>  'p0101',    
                'p021'              =>  'p021', 
                'p022'              =>  'p022', 
                'fp011'             =>  'fp011', 
                'p081'              =>  'v108',
                'p08'               =>  'v105', 
                'pn01'              =>  'pn01',  
                'pn02'              =>  'pn02', 
                'p061'              =>  'p061', 
                'p014'              =>  'p014',  
                'p015'              =>  'p015', 
                'pd01'              =>  'vd01',  
                'pd101'             =>  'vd101', 
                'pd102'             =>  'vd102', 
                'p3051'             =>  'p3051', 
                'p904'              =>  'p904', 
                'p305'              =>  'p305', 
                'p500'              =>  'p500', 
                'p501'              =>  'p501', 
                'timh2'             =>  'timh2', 
                'timh4'             =>  'timh4',  
                'timh3'             =>  'timh3',  
                'timh1'             =>  'timh1',  
                'p614'              =>  'v614',  
                'ppnr01'            =>  'ppnr01', 
                'p06'               =>  'p06',  
                'p07'               =>  'p07',  
                'remdate'           =>  'remdate',  
                'remtime'           =>  'remtime', 
                'remuser'           =>  'remuser', 
                'remfdate'          =>  'remfdate',  
                'remftime'          =>  'remftime', 
                'remfuser'          =>  'remfuser', 
                'remguc'            =>  'remguc',  
                'i18i01'            =>  'i18nr01', 
                'i19p03'            =>  'i19p03',   
                'p013t'             =>  'p013t',                
                'p501_1'            =>  'p501_1',       
                'p500_1'            =>  'p500_1',   
                'p616p'             =>  'v616p',
                
                'i00_p9000'         =>  'i00_p9000', 
                'i00_ths'           =>  'i00_ths', 
                'i00_p200'          =>  'i00_p200',  
                'i00_p62'           =>  'i00_p62', 
                'i00_p9903'         =>  'i00_p9903',

                'a90_p30'           => 'a90_p30',
                'i46001_p02'        => 'i46001_p02',

                'i10_p02'           =>  'i10_p02', 

                'i24_dek'           =>  'i24_dek',
                'i24_p02'           =>  'i24_p02',                
                'i24_ep02'          =>  'i24_ep02',  
                'i01_p03_formatted' =>  'i01_p03_formatted', 

                'perigrafi'         =>  'perigrafi',
                'color_size'        =>  'color_size',   
                'color_size_code'   =>  'color_size_code', 
                'serials'           =>  'serials', 
                'serials_with_crm'  =>  'serials_with_crm',      
                'lots'              =>  'lots',

                'i71_tot'           =>  'i71_tot',   
            );

            return $products_query_fields;
        }

        private static function invoiceProductsQuery($type, $i01_p06, $cs_analysis, $costs=array(), $disable_i71=false, $lang="GR", $order_by=""){

            $tbl = ($type == 1) ? 'a56' : 'a55';
            
            if($type == 3){
                $tbl = 'a60';
            }
            
            $sql       = '';
            $sqlParams = array();

            $perigrafi  = "concat(if('".$lang."'!='GR' and i00.p9000!='', i00.p9000, i01.p02)";
            $perigrafi .= ", if(i01.p0601='', '', concat(if(i01.p02 = '', '', '\\n'), i01.p0601))";
            $perigrafi .= ", IF(a90.p30 IS NULL, '', concat('\n', a90.p30))";
            $perigrafi .= ") ";


            $color_size      = "''";
            $color_size_code = "''";
            //$p85_output['cs_analysis': Υπάρχει άλλη φόρμα που καλεί τη φόρμα εδώ, με μόνη αλλαγή ότι έχει σεταρισμένο το $cs_analysis = true
            if(isset($cs_analysis) && $cs_analysis && pegasus_module_exists('colorsize')){
                //Χρειάζομαι το distinct για την περίπτωση όπου έχω και πολλαπλά χρώματα μεγέθη
                $color_size_tmp = "group_concat(distinct if(i48.nr01 IS NULL || i40.p01 IS NULL || i43.p01 IS NULL, '', ##color_size##) SEPARATOR ',\\n')";
                if($lang=="GR"){
                    $color_size =  "concat(i40.p02, IF(i40.p02='', '', '-'), i43.p02, ' x ', Format(i48.p04, i24.dek))";
                }elseif($lang=="EN"){
                    $color_size =  "concat(i40.ep02, IF(i40.ep02='', '', '-'), i43.ep02, ' x ', Format(i48.p04, i24.dek))";
                }
                $color_size_code =  "concat(i40.p01, IF(i40.p01='', '', '-'), i43.p01, ' x ', Format(i48.p04, i24.dek))";

                $color_size      = str_replace("##color_size##", $color_size, $color_size_tmp);
                $color_size_code = str_replace("##color_size##", $color_size_code, $color_size_tmp);
            }


            $serials          = '""';
            $serials_with_crm = '""';
            if(pegasus_module_exists('serial')){
                //Χρειάζομαι το distinct για την περίπτωση όπου έχω και πολλαπλά serial
                $concat_serial  = "concat('S.N.:', i32.p02";
                $concat_serial .= ", ##serial_crm##";
                if(pegasus_mysql_table_exists('cona11')){
                    $concat_serial .= ", if(i32.cona11_p04 is not NULL AND i32.cona11_p05 is not NULL, concat(' ', DATE_FORMAT(i32.cona11_p04, '%d/%m/%Y'), '-', DATE_FORMAT(i32.cona11_p05, '%d/%m/%Y')), '')";
                }
                $concat_serial .= ", if(i32.i31_p015!='', concat('\\n', i31_p015), '')";
                $concat_serial .= ")";

                $serials = "group_concat(distinct if(i32.nr01 IS NULL, '', ". str_replace("##serial_crm##", "''", $concat_serial) ." ) SEPARATOR ',\\n')";
                $serials_with_crm = "group_concat(distinct if(i32.nr01 IS NULL, '', ". str_replace("##serial_crm##", "if(i32.d00_i31p07_p19!='', concat(' ', i32.d00_i31p07_p19), '')", $concat_serial) ." ) SEPARATOR ',\\n')";
            }


            $lots = '""';
            if(pegasus_module_exists('lot')){
                //Χρειάζομαι το distinct για την περίπτωση όπου έχω και πολλαπλά Lot
                if($lang=="EN"){
                    $concat_lot  = "concat('Lot: ', i38.p02,' ',' (',i38.p04,')')";
                }else{
                    $concat_lot  = "concat('Παρτίδα: ', i38.p02,' ',' (',i38.p04,')')";    
                }

                $lots = "group_concat(distinct if(i38.nr01 IS NULL, '', ".$concat_lot." ) SEPARATOR ',\\n')";
            }




            //Products Query Fields
            $products_query_fields = self::getProductsQueryFields($tbl);

                
            $sql_i01_fields = '';
            foreach ($products_query_fields as $field=>$alias) {
                if(!empty($sql_i01_fields)) { $sql_i01_fields .= ", \n"; }

                switch (true) {
                    case (strpos($field, 'i00_')!==false):
                        $dbfield = "i00.".substr($field, 4);
                        break;

                    case ($field=='i10_p02'):
                        $dbfield = "i10.p02";
                        break;

                    case ($field=='i24_dek'):
                        $dbfield = "i24.dek";
                        break;

                    case ($field=='i24_p02'):
                        $dbfield = "i24.p02";
                        break;

                    case ($field=='i24_ep02'):
                        $dbfield = "i24.ep02";
                        break;

                    case ($field=='i01_p03_formatted'): 
                        $dbfield = "FORMAT(i01.p03, i24.dek)";
                        break; 

                    case ($field=='perigrafi'): 
                        $dbfield = $perigrafi;
                        break;

                    case ($field=='color_size'): 
                        $dbfield = $color_size;
                        break;   
                        
                    case ($field=='color_size_code'): 
                        $dbfield = $color_size_code;
                        break;  

                    case ($field=='serials'): 
                        $dbfield = $serials;
                        break;   
                        
                    case ($field=='serials_with_crm'): 
                        $dbfield = $serials_with_crm;
                        break;    
                        
                    case ($field=='lots'): 
                        $dbfield = $lots;
                        break; 
                        
                    case ($field=='a90_p30'):
                        $dbfield = "a90.p30";
                        break;

                    case ($field=='i46001_p02'):
                        $dbfield = "i46001.p02";
                        break;
                    
                    case ($field=='i71_tot'):
                        $dbfield = "0";
                        break;    
                    
                    default:
                        $dbfield = "i01.".$field;
                        break;
                }

                $sql_i01_fields .= $dbfield . " as " . $alias;
            }

            $sql  = " (select ";
            $sql .= $sql_i01_fields;
            $sql .=	" from i01 ";
            $sql .= " left join i00 on i01.p01 = i00.pno ";
            $sql .= " left join i24 on i00.ths = i24.p01 ";
            $sql .= " left join i10 on i10.p01=i00.p62 ";
            $sql .= " left join i46001 on i46001.p01=i00.p912 ";

            if(isset($cs_analysis) && $cs_analysis && pegasus_module_exists('colorsize')){
                $sql .=	" left join i48 on i48.p01=i01.nr01 ";
                $sql .=	" left join i40 on i40.p01=i48.p02 ";
                $sql .=	" left join i43 on i43.p01=i48.p03 ";
            }

            if(pegasus_module_exists('serial')){
                $sql .=	"left join (";
                $sql .=	"select i32.*, d00_i31p07.p19 as d00_i31p07_p19, i31.p015 as i31_p015 ";
                
                if(pegasus_mysql_table_exists('cona11')){
                    $sql .=	", cona11.p04 as cona11_p04, cona11.p05 as cona11_p05 " ;
                }
                $sql .=	"from i32 ";
                $sql .=	"left join i31 on i32.p02=i31.p02 " ;
                $sql .=	"left join d00 as d00_i31p07 on d00_i31p07.nr01=i31.p07 " ;
                if(pegasus_mysql_table_exists('cona11')){
                    $sql .=	"left join cona11 on cona11.nr01=i31.p030 " ;
                }
                $sql .=	") as i32 on i32.p00=i01.nr01 and i32.p010=1 ";            
            }

            if(pegasus_module_exists('lot')){
                $sql .=	"left join (
                        select 
                            i38.nr01,
                            i38.p02,
                            SUM(i38.p04) AS p04,
                            i38.p01
                        from 
                            i38
                        WHERE
                            i38.p010=1
                        group by p01,p02
                    ) as i38 on i38.p01=i01.nr01";
            }

            $sql .= " left join a90 on a90.tbl = 'i01' and a90.tbl_nr01 = i01.nr01 "; /////

            $sql .=	" where i01.p06=:i01_p06 and i01.p07=:type ";
        
            if(pegasus_module_exists('orders') and $type==2){
                $sql .=  "  and i01.p01 not in( :costs_apostpno , :costs_codpno , :costs_cost0pno , :costs_cost1pno , :costs_cost2pno , :costs_cost0pno ) ";
            }
            
            if($type==3){
                $sql .=  "  and i01.ppnr01='0' ";
            }

            $sql .= " group by i01.nr01 ";
            $sql .= ")";           
            
                                
            $sql_i71_fields = '';
            foreach ($products_query_fields as $field=>$alias) {
                if(!empty($sql_i71_fields)) { $sql_i71_fields .= ", \n"; }

                switch ($field) {
                    case 'nr01':
                        $dbfield = "(-1) * i71.nr01";
                        break;

                    case 'p02':
                        $dbfield = "i70.p01";
                        break; 
                        
                    case 'p04':
                        $dbfield = "i71.p100";
                        break;

                    case 'perigrafi':
                        $dbfield = "i70.p01";
                        break;  
                    
                    default:
                        $dbfield = "''";
                        break;
                }

                $sql_i71_fields .= $dbfield . " as " . $alias . " ";
            }
            
            $sql_i71_deduc  = " union (select " . $sql_i71_fields;        
            //$sql_i71_deduc .=  "if(i71.i70p02=1 ,1,-1) * if(i71.i70p07=0 ,0,i71.p100) as i71_tot, ";
            $sql_i71_deduc .= "from i71 join i70 on i71.i70=i70.nr01 ";	
            $sql_i71_deduc .= "where i71.tbl=:tbl and i71.tbl_nr=:i01_p06 and i71.i70p02=2 ";
            $sql_i71_deduc .= "order by i71.i70p02,i70.p01) ";
            
            $replace_array = array("i70.p01"=>($lang=="GR") ? "'Κρατήσεις'" : "'Deductions'","i71.p100"=>"''");
            $sql_i71_deduc_title  = " union (select " . str_replace(array_keys($replace_array), array_values($replace_array), $sql_i71_fields);
            $sql_i71_deduc_title .= "from i71 join i70 on i71.i70=i70.nr01 ";	
            $sql_i71_deduc_title .= "where i71.tbl=:tbl and i71.tbl_nr=:i01_p06 and i71.i70p02=2 ";
            $sql_i71_deduc_title .= "limit 1) ";


            $sql_i71_tax  = " union (select " . $sql_i71_fields;        
            //$sql_i71_tax .=  "if(i71.i70p02=1 ,1,-1) * if(i71.i70p07=0 ,0,i71.p100) as i71_tot, ";
            $sql_i71_tax .= "from i71 join i70 on i71.i70=i70.nr01 ";	
            $sql_i71_tax .= "where i71.tbl=:tbl and i71.tbl_nr=:i01_p06 and i71.i70p02=1 ";
            $sql_i71_tax .= "order by i71.i70p02,i70.p01) ";

            $replace_array = array("i70.p01"=>($lang=="GR") ? "'Φόροι'" : "'Taxes'","i71.p100"=>"''");
            $sql_i71_tax_title  = " union (select " . str_replace(array_keys($replace_array), array_values($replace_array), $sql_i71_fields);
            $sql_i71_tax_title .= "from i71 join i70 on i71.i70=i70.nr01 ";	
            $sql_i71_tax_title .= "where i71.tbl=:tbl and i71.tbl_nr=:i01_p06 and i71.i70p02=1 ";
            $sql_i71_tax_title .= "limit 1) ";

            $sql_i71 = $sql_i71_deduc_title . $sql_i71_deduc . $sql_i71_tax_title . $sql_i71_tax;
            
            if($disable_i71==false){
                $sql .= $sql_i71;    
            }


            $order_by = self::getProductsQueryOrderBy($tbl, $order_by);

            if(!empty($order_by)){
                $sql  = 'select * from ('.$sql.') as products ';
                $sql .= "\n" . 'order by ';
                $sql .= 'case ';
                $sql .= 'when nr01>0 then 0  ';
                $sql .= 'when nr01<=0 then 1 ';
                $sql .= 'end, ';
                $sql .= $order_by;
            }


            $sqlParams['type']    = $type;		
            $sqlParams['i01_p06'] = $i01_p06;
            $sqlParams['tbl']     = $tbl;
            

            if(pegasus_module_exists('orders') and $type==2){
                $sqlParams['costs_apostpno'] = isset($costs['apostpno'])   ? $costs['apostpno']   : "";  
                $sqlParams['costs_codpno']   = isset($costs['codpno'])     ? $costs['codpno']     : "";
                $sqlParams['costs_cost0pno'] = isset($costs['s_cost0pno']) ? $costs['s_cost0pno'] : "";
                $sqlParams['costs_cost1pno'] = isset($costs['s_cost1pno']) ? $costs['s_cost1pno'] : "";
                $sqlParams['costs_cost2pno'] = isset($costs['s_cost2pno']) ? $costs['s_cost2pno'] : "";
                $sqlParams['costs_cost3pno'] = isset($costs['s_cost3pno']) ? $costs['s_cost3pno'] : "";
            }
            
            //echo "<pre>". pegasus_replace_values_in_sql($sql,$sqlParams) . "</pre>";
            return array('sql' => $sql, 'sqlParams' => $sqlParams);    
        }


        private static function invoiceProductsGroupedQuery($type, $i01_p06, $cs_analysis, $costs=array(), $disable_i71=false, $lang="GR", $order_by="", $prd_analysis=0){
            $stm = self::invoiceProductsQuery($type, $i01_p06, $cs_analysis, $costs, $disable_i71, $lang, $order_by);

            $sql_grouped = array('sql' => '', 'sqlParams' => $stm['sqlParams']);
            
            switch ($type) {
                case '1':
                    $tbl = 'a56';
                    break;
                case '2':
                    $tbl = 'a55';
                    break;
                case '3':
                    $tbl = 'a60';
                    break;
            }

            //Products Query Fields
            $products_query_fields = self::getProductsQueryFields($tbl);   
            
            //Ομαδοποιημένες Στήλες Ειδών
            $sql_grouped_fields_sum = array('v103','v120','v301','v306','v307','v309','v310','v1042');
            $sql_grouped_fields_str = array('v160','a90_p30','perigrafi','color_size','color_size_code','serials','serials_with_crm','lots');


            
            $perigrafi = "concat(
                if('GR'!='GR' and i00_p9000!='', i00_p9000, v102), 
                if(TRIM(BOTH '\\n' FROM GROUP_CONCAT(DISTINCT trim(v160) SEPARATOR '\\n'))='', '', concat(if(v102 = '', '', '\\n'), TRIM(BOTH '\n' FROM GROUP_CONCAT(DISTINCT trim(v160) SEPARATOR '\\n')))), 
                IF(TRIM(BOTH '\\n' FROM GROUP_CONCAT(DISTINCT trim(a90_p30) SEPARATOR '\\n')) IS NULL, '', concat('\\n', TRIM(BOTH '\\n' FROM GROUP_CONCAT(DISTINCT trim(a90_p30) SEPARATOR '\\n')))))";
                
            //$prd_analysis
            //0: εμφανιζεται η πλήρης Περιγραφή (Περιγραφή Είδους, Αιτιολογία, Σημειώσεις Είδους)
            //1: εμφανιζεται μόνο η Περιγραφή Είδους
            if(isset($prd_analysis) && $prd_analysis==1){
                $perigrafi = "concat(if('GR'!='GR' and i00_p9000!='', i00_p9000, v102), '')";
            }


            $sql_select_fields  = '';
            foreach ($products_query_fields as $field=>$alias) {
                if(!empty($sql_select_fields)) { $sql_select_fields .= ", \n"; }

                if(in_array($alias, $sql_grouped_fields_sum)){
                    $sql_select_fields .= "sum(".$alias.") as ".$alias;
                }elseif(in_array($alias, $sql_grouped_fields_str)){
                        if($alias=='perigrafi'){
                            $sql_select_fields .= $perigrafi;
                            $sql_select_fields .= " as ".$alias;
                        }else{
                            $sql_select_fields .= "TRIM(BOTH '\\n' FROM GROUP_CONCAT(DISTINCT trim(".$alias.") SEPARATOR '\\n')) as ".$alias;
                        }
                }else{
                    $sql_select_fields .= $alias." as ".$alias;
                }
            }

            $sql_grouped['sql']  = "select "."\n";
            $sql_grouped['sql'] .= $sql_select_fields;
            $sql_grouped['sql'] .= " from (";
            $sql_grouped['sql'] .= $stm['sql'];            
            $sql_grouped['sql'] .= ") as products_grouped ";           
            $sql_grouped['sql'] .= "group by ";         
            $sql_grouped['sql'] .= "    v101,
                                        v104,
                                        v106,
                                        v106a,
                                        v1041,
                                        v302,
                                        v303,
                                        v304,
                                        p904,
                                        v616,
                                        v308,
                                        v307,
                                        p610 ";

            $order_by = self::getProductsQueryOrderBy($tbl, $order_by);

            $sql_grouped['sql'] .= "\n" . 'order by ';
            $sql_grouped['sql'] .= 'case ';
            $sql_grouped['sql'] .= 'when nr01>0 then 0  ';
            $sql_grouped['sql'] .= 'when nr01<=0 then 1 ';
            $sql_grouped['sql'] .= 'end';

            if(!empty($order_by)){
                $sql_grouped['sql'] .= ','.$order_by;
            }
            
            //echo "<pre>". pegasus_replace_values_in_sql($sql_grouped['sql'], $sql_grouped['sqlParams']) . "</pre>";
            
            return $sql_grouped;
        }


        public static function getInvoicesSignature($mode, $nr01, $lang, $mydt10_einv=0, $copy=0, $ca_server_without_sign=false){

            $signature_array = array();

            //Λεκτικά Modules
            $p82_arr = array();
            //Ελεγχω αν εκτυπωνω απο Pegasus Web App ή Web Site
            if($_SESSION['lang']==$lang){
                foreach ($_SESSION as $key => $value) {
                    if(strpos($key, 'peg_dic_', 0)!==false){
                        $p82_arr[$key] = array($lang=>$value);    
                    }
                }                
            }

            if((is_array($p82_arr) && !(count($p82_arr)>0)) || $_SESSION['lang']!=$lang){
                $p82_query = 'select p00,p01,ep01 from p82';                    
                $p82_res = pegasus_query($p82_query);
                while($p82_values = pegasus_fetch_assoc($p82_res)){
                    $p82_arr['peg_dic_'.$p82_values['p00']] = array("GR"=>$p82_values['p01'], "EN"=>$p82_values['ep01']);
                }
            }
            

            $einv_sign      = '';
            $einv_sign_tmp  = '';
            $einv_sign_arr  = array();

            if((pegasus_module_exists('mydt') || pegasus_module_exists('mydt10'))){
                pegasus_mysql_use("SELECT nr01,uid, mark, auth_cd, tr_fail, series, p011, p012 FROM mydt10 WHERE tbl=:tbl AND tbl_nr01=:tbl_nr01", $mydt10, array('tbl'=>$mode, 'tbl_nr01'=>$nr01));
                
                $uid_mark_str  = $p82_arr['peg_dic_mydt_label_uid'][$lang].': ' . $mydt10['uid'] . ' / '.$p82_arr['peg_dic_mydt_label_mark'][$lang].': ' . $mydt10['mark'];
                $uid_mark_str .= (!peg_dateIsEmpty($mydt10['p011'], 'Y-m-d')) ? ' / '.$p82_arr['peg_dic_mydt_label_p011_p112'][$lang].': ' . peg_dateToStr($mydt10['p011'], 'd/m/Y') . ' ' . $mydt10['p012'] : '';                         
            
                $auth_cd_label = $p82_arr['peg_dic_einv_label_auth_cd'][$lang];

                //Υπογραφή
                $einv_sign  = '<table border="0">';
                $einv_sign .= '<tr><td>'.$uid_mark_str.'</td></tr>';
                $einv_sign .= '##auth_cd##';
                $einv_sign .= '<tr><td>##provider_label## ##provider_url##</td></tr>';
                $einv_sign .= '##error_message##';
                $einv_sign .= '</table>';

                //Σε περιπτωση χρησης Υπογραφής σε 2 ή 4 γραμμές εχουμε αλλη διαταξη
                $einv_sign_tmp  =  '<table border="0" cellspacing="0" cellpadding="2">';
                $einv_sign_tmp .= '<tr><td width="##width_1##">'.$p82_arr['peg_dic_mydt_label_uid'][$lang].'</td><td width="##width_2##">'.$mydt10['uid'].'</td></tr>';
                $einv_sign_tmp .= '<tr><td>'.$p82_arr['peg_dic_mydt_label_mark'][$lang].'</td><td>'.$mydt10['mark'].'</td></tr>';
                $einv_sign_tmp .= (!peg_dateIsEmpty($mydt10['p011'], 'Y-m-d')) ? '<tr><td>'.$p82_arr['peg_dic_mydt_label_p011_p112'][$lang].'</td><td>'.peg_dateToStr($mydt10['p011'], 'd/m/Y') . ' ' . $mydt10['p012'].'</td></tr>' : '';
                $einv_sign_tmp .= '##auth_cd_tmp##';
                $einv_sign_tmp .= '<tr><td colspan="2">##provider_label##</td></tr>';
                $einv_sign_tmp .= '<tr><td colspan="2">##provider_url##</td></tr>';
                $einv_sign_tmp .= '##error_message##';
                $einv_sign_tmp .= '</table>';                

                $einv_sign_arr = array(
                    'uid'           => array('title'=>$p82_arr['peg_dic_mydt_label_uid'][$lang], 'value'=>$mydt10['uid']),
                    'mark'          => array('title'=>$p82_arr['peg_dic_mydt_label_mark'][$lang], 'value'=>$mydt10['mark']), 
                    'auth_cd'       => array('title'=>'##auth_cd_label##', 'value'=>$mydt10["auth_cd"]), 
                    'provider'      => array('title'=>'##provider_label##', 'value'=>'##provider_url##'), 
                    'error'         => array('title'=>'', 'value'=>'##error_message##'), 
                );
                
                if(!peg_dateIsEmpty($mydt10['p011'], 'Y-m-d')){
                    $einv_sign_arr['mydt10_p011'] = array('title'=>$p82_arr['peg_dic_mydt_label_p011_p112'][$lang], 'value'=>peg_dateToStr($mydt10['p011'], 'd/m/Y') . ' ' . $mydt10['p012']);
                }
            }

            

            //Συμμετέχει στην Ηλ. Τιμολόγηση: "Συμμετέχει με Pegasus"(1) / "Συμμετέχει με SoftOne"(2)
            if($mydt10_einv>0) {                

                //Ενημέρωση της Σειρας Παραστατικού σε περίπτωση που το Παραστατικό αφορά πάροχο Ηλεκτρονικής Τιμολογησης(e-Invoicing ή Softone)
                $signature_array['a55_nr01_a55_nr01_p701'] = $mydt10['series'];                
                $color = '#dc3545';

                if($mydt10_einv == 1) { 
                    $error_message = '';
                    if($mydt10['tr_fail']==1){
                        $error_message = $p82_arr['peg_dic_einv_tr_fail_msg_1'][$lang];
                        $color = '#ffc107';
                    }elseif($mydt10['tr_fail']==2){
                        
                        if(empty($mydt10["auth_cd"])){ //επιχειρησιακο σφαλμα  μηνυματα κοκκινα
                            $error_message = $p82_arr['peg_dic_einv_tr_fail_msg_2_mydata_sync_004'][$lang];
                            $auth_cd_label = '<b style="color:#dc3545;">'.$p82_arr['peg_dic_einv_label_auth_cd'][$lang].'</b>';
                        }else{
                            if(empty($mydt10["mark"])){ //temporary auth_Code - μηνυματα κοκκινα
                                $error_message = $p82_arr['peg_dic_einv_tr_fail_msg_2_mydata_sync_005'][$lang];
                                $auth_cd_label = '<b style="color:#dc3545;">'.$p82_arr['peg_dic_einv_label_auth_cd_tmp'][$lang].'</b>';
                            }
                            else{ //mhnymata kitrina
                                $color = '#ffc107';
                                $error_message = $p82_arr['peg_dic_einv_tr_fail_msg_2_mydata_sync_004_01'][$lang];
                                $auth_cd_label = $p82_arr['peg_dic_einv_label_auth_cd'][$lang];
                            }
                            
                        }

                    } elseif(
                        $mydt10['tr_fail'] == 0
                        && $mydt10['auth_cd'] == ''
                    ){
                        $error_message = $p82_arr['peg_dic_einv_tr_fail_msg_0'][$lang];
                    }
                    
                    $provider_label     = $p82_arr['peg_dic_einv_provider'][$lang];
                    $provider_url       = $p82_arr['peg_dic_einv_provider_url'][$lang];
                    $error_message_tmp  = (!empty($error_message)) ? '<tr><td colspan="2" style="color:'.$color.'"><b>' . $error_message . '</b></td></tr>' : '';                    

                }elseif($mydt10_einv == 3) { 
                    $error_message = '';
                    if($mydt10['tr_fail']==1){
                        $error_message = $p82_arr['peg_dic_einv_tr_fail_msg_1'][$lang];
                        $color = '#ffc107';
                    }elseif($mydt10['tr_fail']==2){
                        if(empty($mydt10["auth_cd"])){ 
                            $error_message = $p82_arr['peg_dic_einv_provider_ilyda'][$lang];
                            $auth_cd_label = '<b style="color:#dc3545;">'.$p82_arr['peg_dic_einv_label_auth_cd'][$lang].'</b>';
                        }else{
                            $color = '#ffc107';
                            $error_message = $p82_arr['peg_dic_einv_tr_fail_msg_2_mydata_sync_004_01'][$lang];
                            $auth_cd_label = $p82_arr['peg_dic_einv_label_auth_cd'][$lang];
                        }
                    } elseif(
                        $mydt10['tr_fail'] == 0
                        && $mydt10['auth_cd'] == ''
                    ){
                        if($mydt10['y_ekd'] == 1) {
                            $color = '#ffc107';
                            $error_message = $p82_arr['peg_dic_einv_y_ekd_msg_1'][$lang];
                        }else{
                            $error_message = $p82_arr['peg_dic_einv_tr_fail_msg_0'][$lang];
                        }
                    } 
                    
                    $provider_label     = $p82_arr['peg_dic_einv_provider_ilida'][$lang];
                    $provider_url       = $p82_arr['peg_dic_einv_provider_ilida_url'][$lang];
                    $error_message_tmp  = (!empty($error_message)) ? '<tr><td colspan="2" style="color:'.$color.'"><b>' . $error_message . '</b></td></tr>' : '';                    

                }elseif($mydt10_einv == 2)  {  
                    $provider_label     = $p82_arr['peg_dic_einv_provider_softone'][$lang];
                    $provider_url       = $p82_arr['peg_dic_einv_provider_softone_url'][$lang];
                    $error_message_tmp  = '';
                }
                
                $auth_cd      = '<tr><td>##auth_cd_label##: '.$mydt10["auth_cd"].'</td></tr>';  
                $auth_cd_tmp  = '<tr><td>##auth_cd_label##</td><td>'.$mydt10["auth_cd"].'</td></tr>';              

                $einv_sign_r2 = str_replace(array('##width_1##','##width_2##'), array('20%','80%'), $einv_sign_tmp);
                $einv_sign_r4 = str_replace(array('##width_1##','##width_2##'), array('35%','65%'), $einv_sign_tmp);

            }else{
                $auth_cd        = '';
                $auth_cd_tmp    = '';
                $einv_sign_p30  = '';

                if(in_array($mode, array('a55'))){
                    $einv_sign_p30 = pegasus_mysql_printfld("p30", "p03", " p01=:p01 and p02=:nr01 and p04=:p04 ", array("p01" => "POLPA", "nr01" => $nr01, "p04" => $copy));
                }elseif(in_array($mode, array('a56'))){
                    $einv_sign_p30 = pegasus_mysql_printfld("p30", "p03", " p01=:p01 and p02=:nr01 and p04=:p04 ", array("p01" => "AGOPA", "nr01" => $nr01, "p04" => $copy));
                }
                
                if(!empty($einv_sign_p30)){

                    $einv_sign     = $einv_sign_p30;
                    $einv_sign_arr = array();

                    $einv_sign_r2  =  '<table>';
                    $einv_sign_r2 .=  '<tr><td>' . peg_substr($einv_sign, 0, 40) . '</td></tr>';
                    $einv_sign_r2 .=  '<tr><td>' . peg_substr($einv_sign, 40, 37) . '</td></tr>';
                    $einv_sign_r2 .=  '</table>';
    
                    $einv_sign_r4  =  '<table>';
                    $einv_sign_r4 .=  '<tr><td>' . peg_substr($einv_sign, 0, 20) . '</td></tr>';
                    $einv_sign_r4 .=  '<tr><td>' . peg_substr($einv_sign, 20, 20) . '</td></tr>';
                    $einv_sign_r4 .=  '<tr><td>' . peg_substr($einv_sign, 40, 20) . '</td></tr>';
                    $einv_sign_r4 .=  '<tr><td>' . peg_substr($einv_sign, 60, 17) . '</td></tr>';
                    $einv_sign_r4 .=  '</table>';

                    $einv_sign_arr['ca_sign'] = array('title'=>'', 'value'=>$einv_sign);
                    
                }elseif(!empty($mydt10["uid"]) && !empty($mydt10["mark"])){                    
                    $provider_label     = '';
                    $provider_url       = '';
                    $error_message_tmp  = '';
                    
                    $einv_sign_r2 = str_replace(array('##width_1##','##width_2##'), array('20%','80%'), $einv_sign_tmp);
                    $einv_sign_r4 = str_replace(array('##width_1##','##width_2##'), array('35%','65%'), $einv_sign_tmp);

                }else{
                    $einv_sign      = '';
                    $einv_sign_r2   = '';
                    $einv_sign_r4   = '';
                    $einv_sign_arr  = array();
                }

                
            }    
            
            
            $replace_arr = array(
                '##provider_label##'    => $provider_label,
                '##provider_url##'      => $provider_url,
                '##error_message##'     => $error_message_tmp,
                '##auth_cd##'           => $auth_cd,
                '##auth_cd_tmp##'       => $auth_cd_tmp,
                '##auth_cd_label##'     => $auth_cd_label
            );

            if($mode=='a55'){
                $y_ekd = pegasus_mysql_printfld($mode, 'y_ekd', 'nr01=?', array($nr01));
                if($y_ekd){
                    $lekt_y_ekd = $p82_arr['peg_dic_invoices_form_y_ekd_warning'][$lang];
                    $einv_sign .= '<tr><td>'.$lekt_y_ekd.'</td></tr>';
                    $einv_sign_r2 .= '<tr><td>'.$lekt_y_ekd.'</td></tr>';
                    $einv_sign_r4 .= '<tr><td>'.$lekt_y_ekd.'</td></tr>';
                    $einv_sign_arr['y_ekd']['title']  = '';
                    $einv_sign_arr['y_ekd']['value']  = $lekt_y_ekd;
                }
            }
            
            $einv_sign      = str_replace(array_keys($replace_arr), array_values($replace_arr), $einv_sign);
            $einv_sign_r2   = str_replace(array_keys($replace_arr), array_values($replace_arr), $einv_sign_r2);
            $einv_sign_r4   = str_replace(array_keys($replace_arr), array_values($replace_arr), $einv_sign_r4);

            foreach ($einv_sign_arr as $key => $value) {
                $einv_sign_arr[$key]['title'] = str_replace(array_keys($replace_arr), array_values($replace_arr), $value['title']);
                $einv_sign_arr[$key]['value'] = str_replace(array_keys($replace_arr), array_values($replace_arr), $value['value']);

                $einv_sign_arr[$key]['title'] = strip_tags($einv_sign_arr[$key]['title']);
                $einv_sign_arr[$key]['value'] = strip_tags($einv_sign_arr[$key]['value']);
            }



            $signature_array['invoices_signature']     = $einv_sign;
            $signature_array['invoices_signature_r2']  = $einv_sign_r2;
            $signature_array['invoices_signature_r4']  = $einv_sign_r4;
            $signature_array['invoices_signature_arr'] = $einv_sign_arr;
            
            if($ca_server_without_sign==true){
                $signature_array['invoices_signature']     = '';
                $signature_array['invoices_signature_r2']  = '';
                $signature_array['invoices_signature_r4']  = '';
                $signature_array['invoices_signature_arr'] = array();
            }

            return $signature_array;
        }

        public static function getInvoicesQRCode($mode, $nr01, $mydt10_einv=0, $copy=0){
            $invoices_barcode_qrcode = '';

            if($mydt10_einv>0) {
                pegasus_mysql_use("SELECT nr01,uid, mark, auth_cd,tr_fail,series,p011,p012 FROM mydt10 WHERE tbl=:tbl AND tbl_nr01=:tbl_nr01", $mydt10, array('tbl'=>$mode, 'tbl_nr01'=>$nr01));
            }

            if($mydt10_einv == 1) {
                $invoices_barcode_qrcode = einv_get_qrcode_url($mydt10['auth_cd'], $mydt10['nr01']);
            }elseif($mydt10_einv == 2) {
                $invoices_barcode_qrcode = einv01_einv01_20_get_url($mydt10['nr01']);
            }else{
                if(function_exists("invoices_find_qrcode")){ 
                    if(in_array($mode, array('a55'))){
                        $invoices_barcode_qrcode = invoices_find_qrcode($nr01, $copy, "POLPA");
                    }elseif(in_array($mode, array('a56'))){
                        $invoices_barcode_qrcode = invoices_find_qrcode($nr01, $copy, "AGOPA");
                    }
                } 

                if($invoices_barcode_qrcode==''){
                    $invoices_barcode_qrcode = pegasus_mysql_printfld('mydt10', 'qrurl', 'tbl=:tbl and tbl_nr01=:tbl_nr01', array('tbl'=>$mode, 'tbl_nr01'=>$nr01));
                }
            }

            return $invoices_barcode_qrcode;
        }
        
    }

    class InvoicesA60PrintsData extends PrintsData { 

        /**
         * Εδώ φτιάχνουμε το query για το body
         */
        protected function setBodySql(){
            $table = $this->p85_input['dias_main_table'];
            
            if(!empty($this->p85_arr['body_sql_code'])){
                $sql_code = eval($this->p85_arr['body_sql_code']);
            }

            $dias_main_nr01 = (is_array($this->p85_input["dias_main_nr01"])) ? $this->p85_input["dias_main_nr01"][0] : $this->p85_input["dias_main_nr01"];
                        
            if(empty($sql_code)){ 
                $lang = (isset($this->p85_input["lang"])) ? $this->p85_input["lang"] : "GR";
       
                // type=3 Παραστατικά εσωτ. διακ.
                $sql_code = InvoicesPrintsClass::getProductsQuery($table, 3, $dias_main_nr01, $this->p85_input["cs_analysis"], array(), $this->p85_input["disable_i71"], $lang, $this->p85_input["order_by"]); 
                
            }

            $this->body_sql = (is_array($sql_code)) ? $sql_code : array('sql'=>$sql_code, 'sqlParams'=>array());
        }  

        protected function makeGlobalData(){
            $table = $this->p85_input['dias_main_table'];
            $global_data = parent::makeGlobalData();
            
            $lang = (isset($this->p85_input["lang"])) ? $this->p85_input["lang"] : "GR"; 
            $dias_main_nr01 = (is_array($this->p85_input["dias_main_nr01"])) ? $this->p85_input["dias_main_nr01"][0] : $this->p85_input["dias_main_nr01"];
            
            //Store Titles
            $table_p0121 = pegasus_mysql_printfld($table, 'p0121', 'nr01=:table_nr01', array('table_nr01'=>$dias_main_nr01));
            $core_titles_data = invoices_get_store_titles($table_p0121);

            for($i=1; $i<=8; $i++){ 
                $global_data['cor000_tit_line'.$i] = $core_titles_data[$i-1];
            }
            for($i=1; $i<=8; $i++){ 
                $global_data['cor000_eng_tit_line'.$i] = $core_titles_data[$i+7];
                if(empty($global_data['cor000_eng_tit_line'.$i])){
                    $global_data['cor000_eng_tit_line'.$i] = $core_titles_data[$i-1];
                }
            }


            //Footer Titles
            $core_footer_data = invoices_get_store_footer($table_p0121);
            for($i=1; $i<=5; $i++){ 
                $global_data['f02_ftr00'.$i] = $core_footer_data[$i-1];
            }
            for($i=1; $i<=5; $i++){ 
                $global_data['f02_eftr00'.$i] = $core_footer_data[$i+4];
                if(empty($global_data['f02_eftr00'.$i])){
                    $global_data['f02_eftr00'.$i] = $core_footer_data[$i-1];
                }
            }

            //Table Data
            $main_table_data = static::makeTableData($this->p85_arr['p50'], $dias_main_nr01);
            $counter = count($main_table_data);

            //Extra Table Data
            $ca_server_copy = isset($this->p85_input['ca_server_copy']) ? $this->p85_input['ca_server_copy'] : 0;
            
            if(isset($this->p85_input['non_zero_values'])){
                $non_zero_values = $this->p85_input['non_zero_values'];
            }else{
                $non_zero_values = array('vp0112'=>true, 'vp0113'=>true,'p0601'=>true,'p0600'=>true,'p0108'=>true);
            }

            if(isset($this->p85_input['hidden_values'])){
                $hidden_values = $this->p85_input['hidden_values'];
            }
            
            // κατηγορίες ΦΠΑ
            $i13_arr = array();
            $result  = pegasus_query("select * from i13;");
            while($peg_i13=pegasus_fetch_assoc($result)){
                $i13_arr[$peg_i13['p01']] = $peg_i13['p03'];
            }

            for ($j=0; $j<$counter; $j++) { 

                //Logo
                $logo_path = invoices_get_store_logo_path($main_table_data[$j][static::sanitizeExpressionField($table.'_nr01_'. $table .'_nr01_p0121')]);
                $main_table_data[$j]['invoices_logo'] = $logo_path;

                //Watermark Logo
                $watermark_logo_path = invoices_get_store_watermark_logo_path($main_table_data[$j][static::sanitizeExpressionField($table.'_nr01_'. $table .'_nr01_p0121')]);
                $main_table_data[$j]['invoices_watermark_logo'] = $watermark_logo_path;

                //Συνολική Ποσότητα ανά ΜΜ
                $total_quan_arr = invoices_find_product_total_quan_per_i24($table, $dias_main_nr01); // todo
                $main_table_data[$j]['product_total_quan_flag'] = (count($total_quan_arr)==1) ? true : false;

                foreach ($total_quan_arr as $i => $quan_arr) {
                    $main_table_data[$j]['product_total_quan_'.$i.'_i24_p01'] = $quan_arr['i24_p01'];
                    $main_table_data[$j]['product_total_quan_'.$i.'_i24_dek'] = $quan_arr['i24_dek'];
                    $main_table_data[$j]['product_total_quan_'.$i]            = $quan_arr['tot_quan'];
                }

                $mydt10_einv = 0;
                if(
                    (pegasus_module_exists('einv') || pegasus_module_exists('einv01')) &&
                    (pegasus_module_exists('mydt') || pegasus_module_exists('mydt10'))
                ) {
                    // Αν υπάρχει και έχει σημανθεί για ηλεκτρονική τιμολόγηση (einv=1)
                    $mydt10_einv = pegasus_mysql_printfld('mydt10', 'einv', 'tbl="a60" and tbl_nr01 = :tbl_nr01', array('tbl_nr01' => $dias_main_nr01));
                    $mydt00_p103 = pegasus_mysql_printfld('mydt00', 'p103', 'nr01=1');
                }

                //Authenticity
                $main_table_data[$j]['ca_server_orig_copy_dic'] = '';
                if(function_exists("ca_server_print_orig_copy_dic")){ 
                    $main_table_data[$j]['ca_server_orig_copy_dic'] = ca_server_print_orig_copy_dic($ca_server_copy, $lang); 
                }    

                //Barcode
                // $main_table_data[$j]['invoices_barcode_qrcode'] = '';
                // if(function_exists("invoices_find_qrcode")){ 
                //     $main_table_data[$j]['invoices_barcode_qrcode'] = invoices_find_qrcode($dias_main_nr01, $ca_server_copy);
                // } 

                //Υπογραφή
                $signature_array = InvoicesPrintsClass::getInvoicesSignature("a60", $dias_main_nr01, $lang, $mydt10_einv, $ca_server_copy, $this->p85_input['ca_server_without_sign']);
                foreach ($signature_array as $key => $value) {
                    $main_table_data[$j][static::sanitizeExpressionField($key)] = $value;
                }
                
                //Barcode
                $main_table_data[$j]['invoices_barcode_qrcode'] = '';
                if(function_exists("invoices_find_qrcode")){ 
                    $main_table_data[$j]['invoices_barcode_qrcode'] = invoices_find_qrcode($dias_main_nr01, $ca_server_copy);
                } 
                $main_table_data[$j]['invoices_barcode_qrcode'] = InvoicesPrintsClass::getInvoicesQRCode("a60", $dias_main_nr01, $mydt10_einv, $ca_server_copy);
                
                //Query στον i01
                $query = "SELECT * FROM i01 WHERE i01.p06=:var_nr01 AND p07 = 3 AND ppnr01 = 0";
                $query_params = array('var_nr01'=>$dias_main_nr01);
                $i01_res = pegasus_query($query, $query_params);
                $p041_total = 0;
                $p041_fpa_total = 0;
                while($i01_values = pegasus_fetch_assoc($i01_res)) {
                    //Εισφορά Ανακύκλωσης (Σύνολο)
                    $p041_total += $i01_values['p041'] * $i01_values['p03'];
                    //Εισφορά Ανακύκλωσης με ΦΠΑ (Σύνολο)
                    $p041_fpa_total += $i01_values['p041'] * $i01_values['p03'] * (1 + ($i01_values['p08']/100));
                }      

                //Εισφορά Ανακύκλωσης (Σύνολο)
                $main_table_data[$j]['i01_p041_total'] = $p041_total;

                //Εισφορά Ανακύκλωσης με ΦΠΑ (Σύνολο)
                $main_table_data[$j]['i01_p041_fpa_total'] = $p041_fpa_total;                  
 
            }
            $global_data = array_merge($global_data, $main_table_data[0]);
            //echo "<pre>". print_r($global_data,1) . "</pre>"; 
            return  $global_data;
        }

        protected function getGlobalExpressions(){
            $global_exps = parent::getGlobalExpressions(); 
            
            //Footer Titles
            $f02_fields = array('ftr001','ftr002','ftr003','ftr004','ftr005','eftr001','eftr002','eftr003','eftr004','eftr005');
            foreach ($f02_fields as $fld) {
                if(peg_substr($fld, 0, 3)=='ftr'){   
                    $p01 = (int)peg_substr($fld, -1, 1).'η Γραμμή Footer';
                }elseif(peg_substr($fld, 0, 4)=='eftr'){
                    $p01 = (int)peg_substr($fld, -1, 1).'η Γραμμή Footer (EN)';
                }
                $p00  = 'f02_' . $fld;
                $p30  = 'return array("text"=>$pdf->printsData->getData("'.$p00.'"), "autoSizing"=>true);';
                $global_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30, 'p02'=>'C', 'p03'=>60); 
            }
            

            //Table Expressions
            $table_exps = static::getTableExpressions($this->p85_arr['p50']);
            //Extra Table Expressions
            $p30_fn = 'getData';

            //Logo
            $p00 = 'invoices_logo';    $p01 = 'Λογότυπο';
            $p30  = '$logo_path = $pdf->printsData->'.$p30_fn.'("'.$p00 .'");';
            $p30 .= "\n" . 'return invoices_logo_print(1140, 360, $logo_path);';
            $table_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30, 'p02'=>'C', 'p05'=>'image'); 

            //Watermark Logo
            $p00 = 'invoices_watermark_logo';    $p01 = 'Λογότυπο Φόντου';
            $p30  = '$watermark_logo_path = $pdf->printsData->'.$p30_fn.'("'.$p00 .'");';
            $p30 .= "\n" . 'return invoices_logo_print(600, 390, $watermark_logo_path);';
            $table_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30, 'p02'=>'C', 'p05'=>'image');

            //Authenticity
            $p00 = 'ca_server_orig_copy_dic';     $p01 = 'Authenticity';
            $table_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_fn, 'p02'=>'C'); 

            //Φορολογικά Στοιχεία
            $p00 = 'invoices_signature';    $p01 = 'Φορολογικά Στοιχεία';
            $table_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_fn, 'p02'=>'C', 'p05'=>'exp_html'); 

            //Φορολογικά Στοιχεία σε 2 Γραμμές
            $p00 = 'invoices_signature_r2'; $p01 = 'Φορολογικά Στοιχεία σε 2 Γραμμές';
            $table_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_fn, 'p02'=>'C', 'p05'=>'exp_html'); 

            //Φορολογικά Στοιχεία σε 4 Γραμμές
            $p00 = 'invoices_signature_r4'; $p01 = 'Φορολογικά Στοιχεία σε 4 Γραμμές';
            $table_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_fn, 'p02'=>'C', 'p05'=>'exp_html'); 

            //Barcode
            $p00 = 'invoices_barcode_qrcode';  $p01 = 'Barcode (QRCode)';
            $p30 = 'return array("value"=>$pdf->printsData->'.$p30_fn.'("invoices_barcode_qrcode"), "orientation"=>"H", "barcodeType"=>"QRCODE", "text"=>false, "vpadding"=>0, "hpadding"=>0);';
            $table_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30, 'p02'=>'C', 'p05'=>'barcode'); 

            //Συνολική Ποσότητα ανά ΜΜ
            for($i=0; $i<5; $i++){
                $p00  = 'product_total_quan_'.$i.'_i24_p01';    $p01 = 'Συνολική Ποσότητα Ειδών ανά ΜΜ ('.$i.') - Περιγραφή';
                $table_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_fn, 'p02'=>'C'); 

                $p00  = 'product_total_quan_'.$i;    $p01 = 'Συνολική Ποσότητα Ειδών ανά ΜΜ ('.$i.')';
                $p30  = '$total_quan = $pdf->printsData->getNumber("'.$p00 .'", $pdf->printsData->getData("product_total_quan_dec_'.$i.'"));';
                $p30 .= "\n" . 'return array("text"=>$total_quan);';
                $table_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30, 'p02'=>'N', 'p03'=>'14', 'p04'=>'3');
            }

            //Εισφορά Ανακύκλωσης (Σύνολο)
            $p00 = 'i01_p041_total';    $p01 = 'Εισφορά Ανακύκλωσης (Σύνολο)';
            $table_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_fn, 'p02'=>'N', 'p03'=>'5', 'p04'=>'2');
 
            //Εισφορά Ανακύκλωσης με ΦΠΑ (Σύνολο)
            $p00 = 'i01_p041_fpa_total';    $p01 = 'Εισφορά Ανακύκλωσης με ΦΠΑ (Σύνολο)';
            $table_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_fn, 'p02'=>'N', 'p03'=>'5', 'p04'=>'2');    

            $global_exps = array_merge($global_exps, $table_exps);
            return $global_exps;
        }

        protected function getBodyExpressions(){
            $table = 'a60';
            $body_exps   = array();
            $p30_default = 'getBodyData';

            $body_fields = InvoicesPrintsClass::getProductsQueryFields($table);

            $fields_query  = "select p50.p01 as p50_p01, p50.p03 as p50_p03, p51.* from p51 ";
            $fields_query .= "join p50 on p50.p02=p51.p02 ";
            $fields_query .= "join p60 on p60.p00=p51.desc16 ";
            $fields_query .= "where p50.p01 in ('i01','i00','i10') and p50.p102=1 and p60.isdbfld=1 ";
            $fields_query .= "order by field(p50.p01,'i01','i00','i10'), p51.desc06,p51.nr01;";

            $result = pegasus_query($fields_query);
            while ($p51=pegasus_fetch_assoc($result)) {

                if(in_array($p51['p50_p01'], array('i00','i10'))){
                    if(in_array($p51['p50_p01'].'_'.$p51['desc05'], array_keys($body_fields))){
                        $p00 = $body_fields[$p51['p50_p01'].'_'.$p51['desc05']];  
                    }else{
                        continue;
                    }
                }elseif(in_array($p51['desc05'], array_keys($body_fields))){
                    $p00 = $body_fields[$p51['desc05']]; 
                    if($p00=="v104"){
                        $p51['desc18'] = '$_SESSION["f01_p07"]';    
                    }elseif($p00=="v103"){
                        $p51['desc18'] = '$pdf->printsData->getBodyData("i24_dek")';
                    }
                }else{
                    continue;
                }

                $p01 = $p51['p50_p03'] . ' -> ' . $p51['desc02'];   
                $p05 = static::getExpressionType($p51['desc07']);

                $body_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_default, 'p100'=>1, 'p02'=>$p51['desc16'], 'p03'=>$p51['desc17'], 'p04'=>$p51['desc18'], 'p05'=>$p05); 
            }

            $p00 = 'i24_dek';   $p01 = 'Κινήσεις Ειδών Αποθήκης -> Μονάδες Μέτρησης Αποθήκης -> Δεκαδικά Ποσότητας';
            $body_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_default, 'p100'=>1, 'p02'=>'N', 'p03'=>'2');
            
            $p00 = 'i71_tot';
            $p01 = 'Φόροι/Κρατήσεις ανά Παραστατικό/Παραγγελια -> Σύνολο Φόρων/Κρατήσεων';
            $body_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_default, 'p100'=>1, 'p02'=>'N', 'p03'=>'13', 'p04'=>'2'); 


            //Extra Body Expressions

            //Product Price No VAT included
            $p00  = 'v104_no_vat';     $p01  = 'Κινήσεις Ειδών Αποθήκης -> Τιμή Μονάδας (χωρίς Φ.Π.Α.)';
            $p30  = '$prd_price = InvoicesPrintsClass::previewPrice($pdf->printsData->getBodyData("v104"), 1, $pdf->printsData->getBodyData("v105"), 0);'; // todo
            $p30 .= "\n" . 'return array("text"=>peg002_format_number($prd_price, $_SESSION["f01_p07"]));';   
            $body_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30, 'p100'=>1, 'p02'=>'N', 'p03'=>'14', 'p04'=>'5');  
            
            //Product Price VAT included 
            $p00  = 'v104_vat';     $p01  = 'Κινήσεις Ειδών Αποθήκης -> Τιμή Μονάδας (με Φ.Π.Α.)';
            $p30  = '$prd_price = InvoicesPrintsClass::previewPrice($pdf->printsData->getBodyData("v104"), 1, $pdf->printsData->getBodyData("v105"), 1);'; // todo
            $p30 .= "\n" . 'return array("text"=>peg002_format_number($prd_price, $_SESSION["f01_p07"]));';   
            $body_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30, 'p100'=>1, 'p02'=>'N', 'p03'=>'14', 'p04'=>'5');       

            //Εισφορά Ανακύκλωσης 
            $p00 = 'i01_p041';    $p01 = 'Εισφορά Ανακύκλωσης';
            $p30 = '$i01_p041 = $pdf->printsData->getBodyData("v1041");';
            $p30 .= '$i01_p03 = $pdf->printsData->getBodyData("v103");';
            $p30 .= "\n" . 'return array("text"=>peg002_format_number($i01_p041*$i01_p03, 2));';
            $body_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30, 'p100'=>1, 'p02'=>'N', 'p03'=>'5', 'p04'=>'2');

            //Εισφορά Ανακύκλωσης με ΦΠΑ
            $p00  = 'i01_p041_fpa';    $p01 = 'Εισφορά Ανακύκλωσης με ΦΠΑ';
            $p30  = '$i01_p041_fpa = $pdf->printsData->getBodyData("v1041");';
            $p30 .= "\n" . '$i01_p03 = $pdf->printsData->getBodyData("v103");';
            $p30 .= "\n" . '$i01_p08 = $pdf->printsData->getBodyData("v105");';
            $p30 .= "\n\n" . 'return array("text"=>peg002_format_number($i01_p041_fpa*$i01_p03*(1 + ($i01_p08/100)), 2));';
            $body_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30, 'p100'=>1, 'p02'=>'N', 'p03'=>'5', 'p04'=>'2');

            //Products Total Price
            $p30_fn = '$prd_total = invoices_make_product_total(
                $pdf->printsData->getBodydata("v103"), 
                $pdf->printsData->getBodydata("v104"), 
                $pdf->printsData->getBodydata("v105"), 
                $pdf->printsData->getBodydata("v106"), 
                $pdf->printsData->getBodydata("v106a"), 
                $pdf->printsData->getBodydata("v1041"), 
                $pdf->printsData->getBodydata("v616"),
                0,
                $pdf->printsData->getBodydata("v1042")
            );'; // todo

            $p00  = 'v107';     $p01  = 'Σύνολο Τιμής Είδους';
            $p30  = 'if($pdf->printsData->getBodyData("nr01")<0){ return ""; }';
            $p30 .= "\n" . $p30_fn;
            $p30 .= "\n" . 'return array("text"=>peg002_format_number($prd_total, 2));';   
            $body_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30, 'p100'=>1, 'p02'=>'N', 'p03'=>'13', 'p04'=>'3');          
            
            //Products Total Price No VAT included
            $p00  = 'v107_no_vat';     $p01  = 'Σύνολο Τιμής Είδους (χωρίς Φ.Π.Α.)';
            $p30  = 'if($pdf->printsData->getBodyData("nr01")<0){ return ""; }';
            $p30 .= "\n" . $p30_fn;
            $p30 .= "\n" . '$prd_total = InvoicesPrintsClass::previewPrice($prd_total, 1, $pdf->printsData->getBodyData("v105"), 0);';
            $p30 .= "\n" . 'return array("text"=>peg002_format_number($prd_total, 2));';   
            $body_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30, 'p100'=>1, 'p02'=>'N', 'p03'=>'13', 'p04'=>'3');          
            

            //Products Total Price VAT included
            $p00  = 'v107_vat';     $p01  = 'Σύνολο Τιμής Είδους (με Φ.Π.Α.)';
            $p30  = 'if($pdf->printsData->getBodyData("nr01")<0){ return ""; }';
            $p30 .= "\n" . $p30_fn;
            $p30 .= "\n" . '$prd_total = InvoicesPrintsClass::previewPrice($prd_total, 1, $pdf->printsData->getBodyData("v105"), 1);';
            $p30 .= "\n" . 'return array("text"=>peg002_format_number($prd_total, 2));';   
            $body_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30, 'p100'=>1, 'p02'=>'N', 'p03'=>'13', 'p04'=>'3');          
                        
            
            $p00 = 'perigrafi';         $p01 = 'Πλήρης Περιγραφή';
            $body_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_default, 'p100'=>1, 'p02'=>'M', 'p05'=>'exp_memo'); 
                       
            $p00 = 'color_size';        $p01 = 'Χρωμα/Μέγεθος Περιγραφες x Ποσότητα';
            $body_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_default, 'p100'=>1, 'p02'=>'M', 'p05'=>'exp_memo'); 
            
            $p00 = 'color_size_code';   $p01 = 'Χρωμα/Μέγεθος Κωδικοί x Ποσότητα';
            $body_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_default, 'p100'=>1, 'p02'=>'M', 'p05'=>'exp_memo'); 
             
            $p00 = 'serials';           $p01 = 'Serial Number';
            $body_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_default, 'p100'=>1, 'p02'=>'M', 'p05'=>'exp_memo'); 
            
            $p00 = 'serials_with_crm';   $p01 = 'Serial Number (CRM)';
            $body_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_default, 'p100'=>1, 'p02'=>'M', 'p05'=>'exp_memo'); 
            
            //Κατηγορία Είδους
            $p00 = 'i46_p02';   $p01 = 'Κατηγορία Είδους';
            $p30 = '$i46_p02 = pegasus_mysql_printfld("i46", "p02", "i46.p01 = :p9903", array("p9903" => $pdf->printsData->getBodyData("i00_p9903")));';
            $p30 .= "\n" . 'return array("text"=>$i46_p02);';
            $body_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30, 'p100'=>1, 'p02'=>'M', 'p05'=>'exp_memo');  

            //var_dump($body_exps);
            return $body_exps;
        }

    }

    class InvoicesA61PrintsData extends PrintsData { 

        /**
         * Εδώ φτιάχνουμε το query για το body
         */
        protected function setBodySql(){
            $table = $this->p85_input['dias_main_table'];
            
            if(!empty($this->p85_arr['body_sql_code'])){
                $sql_code = eval($this->p85_arr['body_sql_code']);
            }

            $dias_main_nr01 = (is_array($this->p85_input["dias_main_nr01"])) ? $this->p85_input["dias_main_nr01"][0] : $this->p85_input["dias_main_nr01"];
                        
            if(empty($sql_code)){ 
                $lang = (isset($this->p85_input["lang"])) ? $this->p85_input["lang"] : "GR";
       
                // type=3 Παραστατικά εσωτ. διακ.
                $sql_code = InvoicesPrintsClass::getProductsQuery($table, 3, $dias_main_nr01, $this->p85_input["cs_analysis"], array(), $this->p85_input["disable_i71"], $lang, $this->p85_input["order_by"]); 
                
            }

            $this->body_sql = (is_array($sql_code)) ? $sql_code : array('sql'=>$sql_code, 'sqlParams'=>array());
        }  

        protected function makeGlobalData(){
            $table = $this->p85_input['dias_main_table'];
            $global_data = parent::makeGlobalData();
            
            $lang = (isset($this->p85_input["lang"])) ? $this->p85_input["lang"] : "GR"; 
            $dias_main_nr01 = (is_array($this->p85_input["dias_main_nr01"])) ? $this->p85_input["dias_main_nr01"][0] : $this->p85_input["dias_main_nr01"];
            
            //Store Titles
            $table_p0121 = pegasus_mysql_printfld($table, 'p0121', 'nr01=:table_nr01', array('table_nr01'=>$dias_main_nr01));
            $core_titles_data = invoices_get_store_titles($table_p0121);

            for($i=1; $i<=8; $i++){ 
                $global_data['cor000_tit_line'.$i] = $core_titles_data[$i-1];
            }
            for($i=1; $i<=8; $i++){ 
                $global_data['cor000_eng_tit_line'.$i] = $core_titles_data[$i+7];
                if(empty($global_data['cor000_eng_tit_line'.$i])){
                    $global_data['cor000_eng_tit_line'.$i] = $core_titles_data[$i-1];
                }
            }


            //Footer Titles
            $core_footer_data = invoices_get_store_footer($table_p0121);
            for($i=1; $i<=5; $i++){ 
                $global_data['f02_ftr00'.$i] = $core_footer_data[$i-1];
            }
            for($i=1; $i<=5; $i++){ 
                $global_data['f02_eftr00'.$i] = $core_footer_data[$i+4];
                if(empty($global_data['f02_eftr00'.$i])){
                    $global_data['f02_eftr00'.$i] = $core_footer_data[$i-1];
                }
            }

            //Table Data
            $main_table_data = static::makeTableData($this->p85_arr['p50'], $dias_main_nr01);
            $counter = count($main_table_data);

            //Extra Table Data
            $ca_server_copy = isset($this->p85_input['ca_server_copy']) ? $this->p85_input['ca_server_copy'] : 0;
            
            if(isset($this->p85_input['non_zero_values'])){
                $non_zero_values = $this->p85_input['non_zero_values'];
            }else{
                $non_zero_values = array('vp0112'=>true, 'vp0113'=>true,'p0601'=>true,'p0600'=>true,'p0108'=>true);
            }

            if(isset($this->p85_input['hidden_values'])){
                $hidden_values = $this->p85_input['hidden_values'];
            }
            
            // κατηγορίες ΦΠΑ
            $i13_arr = array();
            $result  = pegasus_query("select * from i13;");
            while($peg_i13=pegasus_fetch_assoc($result)){
                $i13_arr[$peg_i13['p01']] = $peg_i13['p03'];
            }

            for ($j=0; $j<$counter; $j++) { 

                //Logo
                $logo_path = invoices_get_store_logo_path($main_table_data[$j][static::sanitizeExpressionField($table.'_nr01_'. $table .'_nr01_p0121')]);
                $main_table_data[$j]['invoices_logo'] = $logo_path;

                //Watermark Logo
                $watermark_logo_path = invoices_get_store_watermark_logo_path($main_table_data[$j][static::sanitizeExpressionField($table.'_nr01_'. $table .'_nr01_p0121')]);
                $main_table_data[$j]['invoices_watermark_logo'] = $watermark_logo_path;

                //Συνολική Ποσότητα ανά ΜΜ
                $total_quan_arr = invoices_find_product_total_quan_per_i24($table, $dias_main_nr01); // todo
                $main_table_data[$j]['product_total_quan_flag'] = (count($total_quan_arr)==1) ? true : false;

                foreach ($total_quan_arr as $i => $quan_arr) {
                    $main_table_data[$j]['product_total_quan_'.$i.'_i24_p01'] = $quan_arr['i24_p01'];
                    $main_table_data[$j]['product_total_quan_'.$i.'_i24_dek'] = $quan_arr['i24_dek'];
                    $main_table_data[$j]['product_total_quan_'.$i]            = $quan_arr['tot_quan'];
                }

                //Authenticity
                $main_table_data[$j]['ca_server_orig_copy_dic'] = '';
                if(function_exists("ca_server_print_orig_copy_dic")){ 
                    $main_table_data[$j]['ca_server_orig_copy_dic'] = ca_server_print_orig_copy_dic($ca_server_copy, $lang); 
                }    

                //Barcode
                $main_table_data[$j]['invoices_barcode_qrcode'] = '';
                if(function_exists("invoices_find_qrcode")){ 
                    $main_table_data[$j]['invoices_barcode_qrcode'] = invoices_find_qrcode($dias_main_nr01, $ca_server_copy);
                } 
            }
            
            $global_data = array_merge($global_data, $main_table_data[0]);
            //echo "<pre>". print_r($global_data,1) . "</pre>"; 
            return  $global_data;
        }

        protected function getGlobalExpressions(){
            $global_exps = parent::getGlobalExpressions(); 
            
            //Footer Titles
            $f02_fields = array('ftr001','ftr002','ftr003','ftr004','ftr005','eftr001','eftr002','eftr003','eftr004','eftr005');
            foreach ($f02_fields as $fld) {
                if(peg_substr($fld, 0, 3)=='ftr'){   
                    $p01 = (int)peg_substr($fld, -1, 1).'η Γραμμή Footer';
                }elseif(peg_substr($fld, 0, 4)=='eftr'){
                    $p01 = (int)peg_substr($fld, -1, 1).'η Γραμμή Footer (EN)';
                }
                $p00  = 'f02_' . $fld;
                $p30  = 'return array("text"=>$pdf->printsData->getData("'.$p00.'"), "autoSizing"=>true);';
                $global_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30, 'p02'=>'C', 'p03'=>60); 
            }
            

            //Table Expressions
            $table_exps = static::getTableExpressions($this->p85_arr['p50']);
            //Extra Table Expressions
            $p30_fn = 'getData';

            //Logo
            $p00 = 'invoices_logo';    $p01 = 'Λογότυπο';
            $p30  = '$logo_path = $pdf->printsData->'.$p30_fn.'("'.$p00 .'");';
            $p30 .= "\n" . 'return invoices_logo_print(1140, 360, $logo_path);';
            $table_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30, 'p02'=>'C', 'p05'=>'image'); 

            //Watermark Logo
            $p00 = 'invoices_watermark_logo';    $p01 = 'Λογότυπο Φόντου';
            $p30  = '$watermark_logo_path = $pdf->printsData->'.$p30_fn.'("'.$p00 .'");';
            $p30 .= "\n" . 'return invoices_logo_print(600, 390, $watermark_logo_path);';
            $table_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30, 'p02'=>'C', 'p05'=>'image');

            //Authenticity
            $p00 = 'ca_server_orig_copy_dic';     $p01 = 'Authenticity';
            $table_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_fn, 'p02'=>'C'); 

            //Barcode
            $p00 = 'invoices_barcode_qrcode';  $p01 = 'Barcode (QRCode)';
            $p30 = 'return array("value"=>$pdf->printsData->'.$p30_fn.'("invoices_barcode_qrcode"), "orientation"=>"H", "barcodeType"=>"QRCODE", "text"=>false, "vpadding"=>0, "hpadding"=>0);';
            $table_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30, 'p02'=>'C', 'p05'=>'barcode'); 

            //Συνολική Ποσότητα ανά ΜΜ
            for($i=0; $i<5; $i++){
                $p00  = 'product_total_quan_'.$i.'_i24_p01';    $p01 = 'Συνολική Ποσότητα Ειδών ανά ΜΜ ('.$i.') - Περιγραφή';
                $table_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_fn, 'p02'=>'C'); 

                $p00  = 'product_total_quan_'.$i;    $p01 = 'Συνολική Ποσότητα Ειδών ανά ΜΜ ('.$i.')';
                $p30  = '$total_quan = $pdf->printsData->getNumber("'.$p00 .'", $pdf->printsData->getData("product_total_quan_dec_'.$i.'"));';
                $p30 .= "\n" . 'return array("text"=>$total_quan);';
                $table_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30, 'p02'=>'N', 'p03'=>'14', 'p04'=>'3');
            }

            $global_exps = array_merge($global_exps, $table_exps);
            return $global_exps;
        }

        protected function getBodyExpressions(){
            $table = 'a61';
            $body_exps   = array();
            $p30_default = 'getBodyData';

            $body_fields = InvoicesPrintsClass::getProductsQueryFields($table);

            
            $fields_query  = "select p50.p01 as p50_p01, p50.p03 as p50_p03, p51.* from p51 ";
            $fields_query .= "join p50 on p50.p02=p51.p02 ";
            $fields_query .= "join p60 on p60.p00=p51.desc16 ";
            $fields_query .= "where p50.p01 in ('a62','a90','i32','i00') and p50.p102=1 and p60.isdbfld=1 ";
            $fields_query .= "order by field(p50.p01,'a62','a90','i32','i00'), p51.desc06,p51.nr01;";  

            $result = pegasus_query($fields_query);
            while ($p51=pegasus_fetch_assoc($result)) {

                if(in_array($p51['p50_p01'], array('i00','i10'))){
                    if(in_array($p51['p50_p01'].'_'.$p51['desc05'], array_keys($body_fields))){
                        $p00 = $body_fields[$p51['p50_p01'].'_'.$p51['desc05']];  
                    }else{
                        continue;
                    }
                }elseif(in_array($p51['desc05'], array_keys($body_fields))){
                    $p00 = $body_fields[$p51['desc05']]; 
                    if($p00=="v104"){
                        $p51['desc18'] = '$_SESSION["f01_p07"]';    
                    }elseif($p00=="v103"){
                        $p51['desc18'] = '$pdf->printsData->getBodyData("i24_dek")';
                    }
                }else{
                    continue;
                }

                $p01 = $p51['p50_p03'] . ' -> ' . $p51['desc02'];   
                $p05 = static::getExpressionType($p51['desc07']);

                $body_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_default, 'p100'=>1, 'p02'=>$p51['desc16'], 'p03'=>$p51['desc17'], 'p04'=>$p51['desc18'], 'p05'=>$p05); 
            }

            $p00 = 'i24_dek';   $p01 = 'Κινήσεις Ειδών Αποθήκης -> Μονάδες Μέτρησης Αποθήκης -> Δεκαδικά Ποσότητας';
            $body_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_default, 'p100'=>1, 'p02'=>'N', 'p03'=>'2');
            
            $p00 = 'i71_tot';
            $p01 = 'Φόροι/Κρατήσεις ανά Παραστατικό/Παραγγελια -> Σύνολο Φόρων/Κρατήσεων';
            $body_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_default, 'p100'=>1, 'p02'=>'N', 'p03'=>'13', 'p04'=>'2'); 


            //Extra Body Expressions

            //Product Price No VAT included
            $p00  = 'v104_no_vat';     $p01  = 'Κινήσεις Ειδών Αποθήκης -> Τιμή Μονάδας (χωρίς Φ.Π.Α.)';
            $p30  = '$prd_price = InvoicesPrintsClass::previewPrice($pdf->printsData->getBodyData("v104"), 1, $pdf->printsData->getBodyData("v105"), 0);'; // todo
            $p30 .= "\n" . 'return array("text"=>peg002_format_number($prd_price, $_SESSION["f01_p07"]));';   
            $body_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30, 'p100'=>1, 'p02'=>'N', 'p03'=>'14', 'p04'=>'5');  
            
            //Product Price VAT included 
            $p00  = 'v104_vat';     $p01  = 'Κινήσεις Ειδών Αποθήκης -> Τιμή Μονάδας (με Φ.Π.Α.)';
            $p30  = '$prd_price = InvoicesPrintsClass::previewPrice($pdf->printsData->getBodyData("v104"), 1, $pdf->printsData->getBodyData("v105"), 1);'; // todo
            $p30 .= "\n" . 'return array("text"=>peg002_format_number($prd_price, $_SESSION["f01_p07"]));';   
            $body_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30, 'p100'=>1, 'p02'=>'N', 'p03'=>'14', 'p04'=>'5');       



            //Products Total Price
            $p30_fn = '$prd_total = invoices_make_product_total(
                $pdf->printsData->getBodydata("v103"), 
                $pdf->printsData->getBodydata("v104"), 
                $pdf->printsData->getBodydata("v105"), 
                $pdf->printsData->getBodydata("v106"), 
                $pdf->printsData->getBodydata("v106a"), 
                $pdf->printsData->getBodydata("v1041"), 
                $pdf->printsData->getBodydata("v616"),
                0,
                $pdf->printsData->getBodydata("v1042")
            );'; // todo

            $p00  = 'v107';     $p01  = 'Σύνολο Τιμής Είδους';
            $p30  = 'if($pdf->printsData->getBodyData("nr01")<0){ return ""; }';
            $p30 .= "\n" . $p30_fn;
            $p30 .= "\n" . 'return array("text"=>peg002_format_number($prd_total, 2));';   
            $body_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30, 'p100'=>1, 'p02'=>'N', 'p03'=>'13', 'p04'=>'3');          
            
            //Products Total Price No VAT included
            $p00  = 'v107_no_vat';     $p01  = 'Σύνολο Τιμής Είδους (χωρίς Φ.Π.Α.)';
            $p30  = 'if($pdf->printsData->getBodyData("nr01")<0){ return ""; }';
            $p30 .= "\n" . $p30_fn;
            $p30 .= "\n" . '$prd_total = InvoicesPrintsClass::previewPrice($prd_total, 1, $pdf->printsData->getBodyData("v105"), 0);';
            $p30 .= "\n" . 'return array("text"=>peg002_format_number($prd_total, 2));';   
            $body_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30, 'p100'=>1, 'p02'=>'N', 'p03'=>'13', 'p04'=>'3');          
            

            //Products Total Price VAT included
            $p00  = 'v107_vat';     $p01  = 'Σύνολο Τιμής Είδους (με Φ.Π.Α.)';
            $p30  = 'if($pdf->printsData->getBodyData("nr01")<0){ return ""; }';
            $p30 .= "\n" . $p30_fn;
            $p30 .= "\n" . '$prd_total = InvoicesPrintsClass::previewPrice($prd_total, 1, $pdf->printsData->getBodyData("v105"), 1);';
            $p30 .= "\n" . 'return array("text"=>peg002_format_number($prd_total, 2));';   
            $body_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30, 'p100'=>1, 'p02'=>'N', 'p03'=>'13', 'p04'=>'3');          
                        
            
            $p00 = 'perigrafi';         $p01 = 'Πλήρης Περιγραφή';
            $body_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_default, 'p100'=>1, 'p02'=>'M', 'p05'=>'exp_memo'); 
                       
            $p00 = 'color_size';        $p01 = 'Χρωμα/Μέγεθος Περιγραφες x Ποσότητα';
            $body_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_default, 'p100'=>1, 'p02'=>'M', 'p05'=>'exp_memo'); 
            
            $p00 = 'color_size_code';   $p01 = 'Χρωμα/Μέγεθος Κωδικοί x Ποσότητα';
            $body_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_default, 'p100'=>1, 'p02'=>'M', 'p05'=>'exp_memo'); 
             
            $p00 = 'serials';           $p01 = 'Serial Number';
            $body_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_default, 'p100'=>1, 'p02'=>'M', 'p05'=>'exp_memo'); 
            
            $p00 = 'serials_with_crm';   $p01 = 'Serial Number (CRM)';
            $body_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30_default, 'p100'=>1, 'p02'=>'M', 'p05'=>'exp_memo'); 
             
            //Κατηγορία Είδους
            $p00 = 'i46_p02';   $p01 = 'Κατηγορία Είδους';
            $p30 = '$i46_p02 = pegasus_mysql_printfld("i46", "p02", "i46.p01 = :p9903", array("p9903" => $pdf->printsData->getBodyData("i00_p9903")));';
            $p30 .= "\n" . 'return array("text"=>$i46_p02);';
            $body_exps[] = array('p00'=>$p00, 'p01'=>$p01, 'p30'=>$p30, 'p100'=>1, 'p02'=>'M', 'p05'=>'exp_memo');  

            //var_dump($body_exps);
            return $body_exps;
        }

    }

?>