var _invoices_p07_onchange_pause = false;

function invoices_set_p07_onchange_pause(value) {
	_invoices_p07_onchange_pause = value;
}
function invoices_get_p07_onchange_pause() {
	return _invoices_p07_onchange_pause;
}

/**
 * 
 * @param {object} screen 
 * @param einv_mode einv01, einv01_01 
 * @returns 
 */

var invoices_toolbaritem_invoice_resend_ajax = '';
function invoices_toolbaritem_invoice_resend(
	screen = {}, einv_mode
) {
	const _d = screen.peg__d;
	const nr01 = screen.getNr01();
	let mode = null;
	switch(_d) {
		case 'a55_d' :
			mode = 'a55';
			break;
		case 'tran09_d' :
			mode = 'tran09';
			break;
		default :
			mode = null;
	}
	if(!mode) {
		// Unknown Mode
		return pegGetDic('peg_dic_invoice_invoice_resend_no_support',function(msg) {
			return pegAlert(msg);
		});
	}
	if(!(nr01 > 0)) {
		//Unknown Nr01
		return pegGetDic('peg_dic_invoice_invoice_resend_no_nr01',function(msg) {
			return pegAlert(msg);
		});
	}

    params = {};
    params.einv_mode = einv_mode;

	//check einv01 or einv01_01 if there is any record
    invoices_toolbaritem_invoice_resend_ajax  = pegAjaxDefer('/'+main_path + '/invoices01/invoices_toolbaritem_invoice_resend.php' , params , function(jsondata) {
		if(jsondata.ok === 1) {
			return invoices_document_after_save_global_check(
				mode,
				nr01,
				function(check) {
					if(
						check.einv == true
						|| check.einv01 == true
					) {
						const doc = {
							type : mode,
							nr01 : nr01,
							einv : check.einv,
							einv01 : check.einv01
						};
						
						invoices_document_after_save_global_send(doc,null,true);
						return;
					}
					pegGetDic('peg_dic_invoice_invoice_resend_no_einv',function(msg) {
						pegAlert(msg);
					});
				}
			);
		} else {
            pegToast(jsondata.msg, 'alert');
        }
	});
}
/**
 * 
 * @param {string} mode (a55, a56, t08, tran01)
 * @param {number} nr01 
 * @param {function} next
 */
function invoices_global_document_after_save(
	mode = 'a55',
	nr01 = 0,
	next
 ) {
	return invoices_document_after_save_global_check(
		mode,
		nr01,
		function(check) {
			return invoices_document_after_save_global_send(check,next);
		}
	);
}
var invoices_document_after_save_global_check_ajax = '';
/**
 * 
 * @param {string} mode
 * @param {number} nr01 
 * @param {function} next
 */
function invoices_document_after_save_global_check(
	mode = 'a55',
	nr01 = 0,
	next
) {
	if (
		invoices_document_after_save_global_check_ajax != ''
		&& invoices_document_after_save_global_check_ajax.id > 0
	) {
		Ext.ux.AjaxDefer.abort(invoices_document_after_save_global_check_ajax)
	}
	const params = {
		mode : mode,
		nr01 : nr01
	}
	invoices_document_after_save_global_check_ajax = pegAjaxDefer(
		'/' + main_path + '/invoices01/invoices_document_after_save_global_check.php', 
		params, 
		function (jsondata) {
			next(jsondata.data);
	});
}
/**
 * 
 * @param {object} check 
 * @param {function} next 
 * @returns 
 */
function invoices_document_after_save_global_send(
	document,
	next,
	is_from_toolbaritem = false
) {
	if(document.einv == true) {
		return einv01_check_if_einv_and_save_call(document.type,document.nr01,function(jsondata) {
			if(jsondata.msg!='') {
				pegToast(jsondata.msg, jsondata.ok == 1 ? 'info' : 'alert');
			}
			if(typeof next === 'function') {
				return next(jsondata.ok == 1?true:false,false);
			}
			return;
		}, is_from_toolbaritem)
	}
	if(document.einv01 == true) {
		return einv01_01_check_if_einv_and_save_call(document.type,document.nr01,function(jsondata) {
			if(jsondata.msg!='') {
				pegToast(`SoftOne e-invoicing: ${jsondata.msg}`, jsondata.ok == 1 ? 'info' : 'alert');
			}
			
			if(typeof next === 'function') {
				return next(jsondata.ok == 1?true:false,false);
			}
			return;
		})
	}
	if(typeof next === 'function') {
		return next(true,document.mydt);
	}
}
var invoices_grid_rowedit_handler_ajax=''
function invoices_grid_rowedit_handler(
	grid = {}
) {
	if(peg002_IsMobileOrTabletScreen()) {
		return grid.setpeg_isEditable(false)
	}
	if (
		invoices_grid_rowedit_handler_ajax != ''
		&& invoices_grid_rowedit_handler_ajax.id > 0
	) {
		Ext.ux.AjaxDefer.abort(invoices_grid_rowedit_handler_ajax)
	}
	const params = {}
	invoices_grid_rowedit_handler_ajax = pegAjaxDefer('/' + main_path + '/invoices01/invoices_grid_rowedit_handler.php', params, function (jsondata) {
		if(
			jsondata.ok != 1
			||	jsondata.data.f02_p017 == 1
		) {
			return grid.setpeg_isEditable(false)
		}
		if(!grid.readOnly) {
			grid.setpeg_isEditable(true)
		}
	})
	return true
}
/**
 *
 * @param {*} container_id
 */
function invoices_i70_d_afterDraw_listeners(container_id){
	var p03	= pegGetCmp(container_id ,'p03');
	p03.on( 'change', function( me, newValue, oldValue, eOpts ){
		const params ={
			nr01:pegGetVal('nr01', container_id),
			p03:newValue
		}
		if(newValue != oldValue && newValue!=1 && newValue!=5) {
			pegSetVal('p08',container_id,'');
			pegSetFieldReadonly('p08',container_id,true);
		}
		if(newValue==1 || newValue==5) {
			pegSetFieldReadonly('p08',container_id,false);
		}
		invoices_i70_d_refresh(container_id,params);
	});
}

var invoices_i70_d_refresh_change_ajax = '';
/**
 *
 * @param {*} container_id
 */
function invoices_i70_d_refresh(container_id,params) {
	if (invoices_i70_d_refresh_change_ajax != '') {
		if (invoices_i70_d_refresh_change_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(invoices_i70_d_refresh_change_ajax);
		}
	}

	invoices_i70_d_refresh_change_ajax = pegAjaxDefer('/' + main_path + '/invoices03/i70_refresh.php', params, function (jsondata) {

		pegSetFieldReadonly('p04'   , container_id , jsondata.data.p04_readonly);
		pegSetFieldHidden('p05'     , container_id , jsondata.data.p05_hidden);
		pegSetFieldHidden('p05_1'     , container_id , jsondata.data.p05_1_hidden);

	});
}

function invoices__invoices_copy_tables_d_afterDraw_listeners(container_id) {
    //Αντιγραφή σε Παραστατικά Πελατών
    let bt01 = pegGetCmp(container_id, 'bt01');
	//Αντιγραφή σε Παραστατικά Προμηθευτών
	let bt02 = pegGetCmp(container_id, 'bt02');
	//Αντιγραφή σε Παραγγελίες Πελατών
	let bt03 = pegGetCmp(container_id, 'bt03');
	//Αντιγραφή σε Παραγγελίες Προμηθευτών
	let bt04 = pegGetCmp(container_id, 'bt04');
	//Αντιγραφή σε Παραστατικά Εσωτερικής Διακίνησης
	let bt05 = pegGetCmp(container_id, 'bt05');
	//Αντιγραφή σε Εσωτερική Παραγγελία
	let bt06 = pegGetCmp(container_id, 'bt06');

	bt01.on('click', function(me) {
		let to_tbl   = "a55";
		let module   = "invcust";
		invoices_copy_table(container_id, to_tbl, module);
    });
	bt02.on('click', function(me) {
		let to_tbl   = "a56";
		let module   = "invsupp";
		invoices_copy_table(container_id, to_tbl, module);
    });
	bt03.on('click', function(me) {
		let to_tbl   = "a57";
		let module   = "ordercust";
		invoices_copy_table(container_id, to_tbl, module);
    });
	bt04.on('click', function(me) {
		let to_tbl   = "a67";
		let module   = "ordersupp";
		invoices_copy_table(container_id, to_tbl, module);
    });
	bt05.on('click', function(me) {
		let to_tbl   = "a60";
		let module   = "invtrans00";
		invoices_copy_table(container_id, to_tbl, module);
    });
	bt06.on('click', function(me) {
		let to_tbl   = "a61";
		let module   = "interorder";
		invoices_copy_table(container_id, to_tbl, module);
    });
}

function invoices_copy_table(container_id, to_tbl, module) {
	let params00  	 		= "";

	var screen=pegGetCmp(container_id);

	let grid 	  	 		= pegGetCmp(screen.peg_screen_parent_container_id, screen.peg_screen_parent_element_name);
	var row	 	  	 		= pegGridGetSelectedRow(screen.peg_screen_parent_container_id, screen.peg_screen_parent_element_name);
	let from_tbl  	 		= grid.peg_view_table;
	let from_nr01 	 		= row.nr01;
	//Με αυτή την παράμετρο καταλαβαίνουμε ότι πρόκειται για μη τιμολογημένες παραγγελίες
	let invoice_get_total_quantity = 1; 

	if(from_tbl != to_tbl) {
		if(from_tbl == "a55") {
			params00 = {"a55_mnr01": from_nr01, 'invoice_get_total_quantity': invoice_get_total_quantity};
		} else if(from_tbl == "a56") {
			params00 = {"a56_mnr01": from_nr01, 'invoice_get_total_quantity': invoice_get_total_quantity};
		} else if(from_tbl == "a57") {
			params00 = {"a57_mnr01": from_nr01, 'invoice_get_total_quantity': invoice_get_total_quantity};
		} else if(from_tbl == "a67") {
			params00 = {"a67_mnr01": from_nr01, 'invoice_get_total_quantity': invoice_get_total_quantity};
		} else if(from_tbl == "a60") {
			params00 = {"a60_mnr01": from_nr01, 'invoice_get_total_quantity': invoice_get_total_quantity};
		} else if(from_tbl == "a61") {
			params00 = {"a61_mnr01": from_nr01, 'invoice_get_total_quantity': invoice_get_total_quantity};
		}

		pegAddTab_d("", to_tbl, to_tbl+"_d", module, "", 0, "", params00);
	} else {
		var request = {};
		request['rec_copy_nr01'] = from_nr01;
		pegAddTab_d(
			'' , 
			grid.peg_view_table , 
			grid.peg_view__d, 
			grid.peg_view_module , 
			'' , 
			0 , 
			'' , 
			request,
			grid.container_id,
			grid.name
		);
	}
	pegWindowClose(container_id);
}

/**
 *
 * @param {*} container_id
 */
function invoices_i71_d_afterDraw_listeners(container_id){
	var i70p02	= pegGetCmp(container_id ,'i70p02');
	i70p02.on( 'change', function( me, e, eOpts ){
		invoices_i71_d_refresh(container_id);
	});

	var i70	= pegGetCmp(container_id ,'i70');
	i70.on( 'change', function( me, e, eOpts ){
		invoices_i71_d_refresh(container_id,true);
	});

	var p04 = pegGetCmp(container_id, 'p04');
	p04.on('blur', function (me) {
		if (me.peg_onBlurValueHasChanged()) {
			invoices_i71_d_refresh(container_id);
		}
	});

	var p05 = pegGetCmp(container_id, 'p05');
	p05.on('blur', function (me) {
		if (me.peg_onBlurValueHasChanged()) {
			invoices_i71_d_refresh(container_id);
		}
	});
	var tax = pegGetCmp(container_id, 'tax');
	tax.on('blur', function (me) {
		if (me.peg_onBlurValueHasChanged()) {
			invoices_i71_d_refresh(container_id);
		}
	});
}

var invoices_i71_d_refresh_change_ajax = '';
/**
 * 
 * @param {string} container_id 
 * @param {boolean} is_i70_change
 */
function invoices_i71_d_refresh(
	container_id='',
	is_i70_change=false
) {
	const a55_d_container_id_main		= pegGetContainer_id_d(container_id, 'a55_d', '', 'a55_d');
	const a56_d_container_id_main		= pegGetContainer_id_d(container_id, 'a56_d', '', 'a56_d');
	const a57_d_container_id_main		= pegGetContainer_id_d(container_id, 'a57_d', '', 'a57_d');
	const a67_d_container_id_main		= pegGetContainer_id_d(container_id, 'a67_d', '', 'a67_d');
	const tran01_d_container_id_main	= pegGetContainer_id_d(container_id, 'tran01_d', '', 'tran01_d');
	let container_id_main=null;
	if(!pegIsEmpty(a55_d_container_id_main)){
		container_id_main = a55_d_container_id_main;
		mode = 'a55';
	}
	if(!pegIsEmpty(a57_d_container_id_main)){
		container_id_main = a57_d_container_id_main;
		mode = 'a57';
	}
	if(!pegIsEmpty(a56_d_container_id_main)){
		container_id_main = a56_d_container_id_main;
		mode = 'a56';
	}
	if(!pegIsEmpty(a67_d_container_id_main)){
		container_id_main = a67_d_container_id_main;
		mode = 'a67';
	}
	if(!pegIsEmpty(tran01_d_container_id_main)){
		container_id_main = tran01_d_container_id_main;
		mode = 'tran01';
	}
	const container_id_stoixeia	= invoice_get_container_id_stoixeia(container_id,mode);
	let params = {
		nr01 			: pegGetVal('nr01',		container_id),
		i70				: pegGetVal('i70' ,		container_id),
		i70p02			: pegGetVal('i70p02',	container_id),
		p04				: pegGetVal('p04', 		container_id),
		p05				: pegGetVal('p05', 		container_id),
		tax				: pegGetVal('tax', 		container_id),
		total_p0100		: pegGetVal('p0100', 	container_id_main),
		p0102			: pegGetVal('p0102', 	container_id_main),
		tbl				: pegGetVal('tbl', 		container_id),
		tbl_nr			: pegGetVal('tbl_nr',	container_id),
		tbl_p07			: pegGetVal('p07',		container_id_stoixeia) ? 1 : 0,
		is_i70_change	: is_i70_change?1:0,
	};
	if(mode == 'tran01'){ //χρεαζεται κατα την αλλαγή πχ του φόρου/κράτησης, ώστε να υπολογιστει η Αξια Υπολογισμου και Συνολική αξία
		params.tbl_p07 	   = pegGetVal('sp03',		container_id_main) ? 1 : 0; //τιμές με ΦΠΑ
		params.total_p0100 = pegGetVal('v_p09', 	container_id_main); //σύνολο προ ΦΠΑ
		params.p0102 	   = 0;
	}
	if(mode == 'a55' || mode == 'a56') {
		params.tbl_pn02 = pegGetVal('pn02',	container_id_stoixeia);
	}

	if (invoices_i71_d_refresh_change_ajax != '') {
		if (invoices_i71_d_refresh_change_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(invoices_i71_d_refresh_change_ajax);
		}
	}
	invoices_i71_d_refresh_change_ajax = pegAjaxDefer('/' + main_path + '/invoices03/i71_refresh.php', params, function (jsondata) {
		pegSetVal('i70p02' , container_id, jsondata.data.i70p02);
		pegSetVal('i70'    , container_id,{value:jsondata.data.i70 , display:jsondata.data.v_selectbox_i70});
		pegSetVal('i70p07' , container_id, jsondata.data.i70p07);
		pegSetVal('tax' , container_id, jsondata.data.tax);
		pegSetVal('p04'  , container_id, jsondata.data.p04);
		pegSetVal('p05'  , container_id, jsondata.data.p05);
		pegSetVal('p100' , container_id, jsondata.data.p100);
		pegSetVal('message'  , container_id, jsondata.data.message);
		pegSetFieldReadonly('p04'   , container_id , jsondata.data.p04_readonly);
		pegSetFieldHidden('p04'     , container_id , jsondata.data.p04_hidden);
		pegSetFieldReadonly('p05'   , container_id , jsondata.data.p05_readonly);
		pegSetFieldReadonly('p05_1'   , container_id , jsondata.data.p05_1_readonly);
		pegSetFieldHidden('p05'     , container_id , jsondata.data.p05_hidden);
		pegSetFieldHidden('p05_1'     , container_id , jsondata.data.p05_1_hidden);
	});
}
function invoices_i71_d00_afterDraw_listeners(container_id) {
	let screen = pegGetCmp(container_id);
	let mode = screen.getMmnr01().substr(0, 3);
	var grid = pegGetCmp(container_id, 'grid');
	grid.record_change = function (me, row) {

		const a55_d_container_id_main		= pegGetContainer_id_d(container_id, 'a55_d', '', 'a55_d');
		const a56_d_container_id_main		= pegGetContainer_id_d(container_id, 'a56_d', '', 'a56_d');
		const a57_d_container_id_main		= pegGetContainer_id_d(container_id, 'a57_d', '', 'a57_d');
		const a67_d_container_id_main		= pegGetContainer_id_d(container_id, 'a67_d', '', 'a67_d');
		let container_id_main=null;
		if(!pegIsEmpty(a55_d_container_id_main)){
			container_id_main = a55_d_container_id_main;
			mode = 'a55';
		}
		if(!pegIsEmpty(a57_d_container_id_main)){
			container_id_main = a57_d_container_id_main;
			mode = 'a57';
		}
		if(!pegIsEmpty(a56_d_container_id_main)){
			container_id_main = a56_d_container_id_main;
			mode = 'a56';
		}
		if(!pegIsEmpty(a67_d_container_id_main)){
			container_id_main = a67_d_container_id_main;
			mode = 'a67';
		}
		const container_id_stoixeia	= invoice_get_container_id_stoixeia(container_id,mode);
		const params={
			mmnr01:me.getMmnr01(),
			mnr01: me.getGridMnr01(),
			peg_screen_parent_element_name: me.name,
			peg_screen_parent_container_id: me.getContainer_ID(),
			tbl_p07			: pegGetVal('p07',		container_id_stoixeia) ? 1 : 0,
			is_i70_change	: 0,
		}
		if(mode == 'a55' || mode == 'a56') {
			params.tbl_pn02 = pegGetVal('pn02',	container_id_stoixeia) ? 1 : 0;
		}
		return peg_windowShow_d(
			me.peg_view_table,
			me.peg_view__d,
			me.peg_view_module,
			me.getContainer_ID(),
			'',
			row.nr01,
			me.store.url_vars00 ,
			'',
			params,
			false,true,0,0,'tablet'
		);  
	}
	grid.record_copy = function(me,row){
		const a55_d_container_id_main		= pegGetContainer_id_d(container_id, 'a55_d', '', 'a55_d');
		const a56_d_container_id_main		= pegGetContainer_id_d(container_id, 'a56_d', '', 'a56_d');
		const a57_d_container_id_main		= pegGetContainer_id_d(container_id, 'a57_d', '', 'a57_d');
		const a67_d_container_id_main		= pegGetContainer_id_d(container_id, 'a67_d', '', 'a67_d');
		let container_id_main=null;
		if(!pegIsEmpty(a55_d_container_id_main)){
			container_id_main = a55_d_container_id_main;
			mode = 'a55';
		}
		if(!pegIsEmpty(a57_d_container_id_main)){
			container_id_main = a57_d_container_id_main;
			mode = 'a57';
		}
		if(!pegIsEmpty(a56_d_container_id_main)){
			container_id_main = a56_d_container_id_main;
			mode = 'a56';
		}
		if(!pegIsEmpty(a67_d_container_id_main)){
			container_id_main = a67_d_container_id_main;
			mode = 'a67';
		}
		const container_id_stoixeia	= invoice_get_container_id_stoixeia(container_id,mode);
		const params={
			mmnr01:me.getMmnr01(),
			mnr01: me.getGridMnr01(),
			peg_screen_parent_element_name: me.name,
			peg_screen_parent_container_id: me.getContainer_ID(),
			tbl_p07			: pegGetVal('p07',		container_id_stoixeia) ? 1 : 0,
			is_i70_change	: 0,
			rec_copy_nr01: row.nr01
		}
		if(mode == 'a55' || mode == 'a56') {
			params.tbl_pn02 = pegGetVal('pn02',	container_id_stoixeia) ? 1 : 0;
		}
		return peg_windowShow_d(
			me.peg_view_table,
			me.peg_view__d,
			me.peg_view_module,
			me.getContainer_ID(),
			'',
			0,
			me.store.url_vars00 ,
			'',
			params,
			false,true,0,0,'tablet'
		);
	}
	grid.record_delete = function (me, row) {
		pegGridDelSelectedRow(
			container_id,
			me.name,
			me.peg_view_table,
			me.getMnr01(),
			me.getMmnr01(),
			function () {
				const tran01_d_container_id_main      	 = pegGetContainer_id_d(container_id, 'tran01_d', '', 'tran01_d');
				if(!pegIsEmpty(tran01_d_container_id_main)){
					tran_tran02_btn_save(screen);
				}else{
					invoices_calculate_total( container_id, mode);
				}
				pegGridRefresh(me.getContainer_ID(), me.name);
			}
		);
	};
}
function invoices_main_invoice_screen_after_draw(container_id){
	var fldcont_top	= pegGetCmp(container_id ,'fldcont_top');

	invoices_update_top_fldcont_title(container_id);

	fldcont_top.on('collapse',function(){
		invoices_update_top_fldcont_title(container_id);
	});
	fldcont_top.on('expand',function(){
		invoices_update_top_fldcont_title(container_id);
	});

	var p701	= pegGetCmp(container_id ,'p701');
	p701.on( 'change', function( me, e, eOpts ){
		invoices_update_total_fldcont_title(container_id);
	});

	var p06	= pegGetCmp(container_id ,'p06');
	p06.on( 'change', function( me, e, eOpts ){
		invoices_update_total_fldcont_title(container_id);
	});

	var fieldcont_total	= pegGetCmp(container_id ,'fieldcont_total');
	fieldcont_total.on('collapse',function(){
		invoices_update_total_fldcont_title(container_id);
	});
	fieldcont_total.on('expand',function(){
		invoices_update_total_fldcont_title(container_id);
	});

	var p0109	= pegGetCmp(container_id ,'p0109');
	p0109.on( 'change', function( me, e, eOpts ){
		invoices_update_total_fldcont_title(container_id);
	});
}

function invoices_update_top_fldcont_title(container_id){
	fldcont_top= pegGetCmp(container_id ,'fldcont_top');
	let screenData=pegGetCmp(container_id).peg_getData();
	if(fldcont_top.peg_isCollapsed()==true){
		let p03,p05,p701,p06,chars=40;
		if(peg002_IsMobileScreen()){
			chars=20;
		}
		if(screenData.dias_var_p03.length>=chars){
			p03=screenData.dias_var_p03.substr(0,chars-3)+'...';
		}else{
			p03=screenData.dias_var_p03;
		}
		if(screenData.dias_var_p05.length>=chars){
			p05=screenData.dias_var_p05.substr(0,chars-3)+'...';
		}else{
			p05=screenData.dias_var_p05;
		}

		p701=screenData.p701;
		p06=screenData.p06;


		fldcont_top.setTitle(p03+'/'+p05+' '+p701+' No:'+p06);
	}else{
		fldcont_top.setTitle(fldcont_top.title00);
	}
}

function invoices_update_total_fldcont_title(container_id){
	fldcont00= pegGetCmp(container_id ,'fieldcont_total');
	let screenData=pegGetCmp(container_id).peg_getData();
   let tale=':'
   if(fldcont00.collapsed!==false) {
	   tale=`: ${screenData.p0109}`
   }
   fldcont00.setTitle(fldcont00.getTitle().split(':')[0]+tale)
}

function invoices__invoices_mass_sel_product_d_afterDraw_listeners(container_id) {
	var grid = pegGetCmp(container_id + '_grid');
	grid.peg_preventDefault_itemdblclick = true;

	grid.on('itemdblclick', function (view, record, item, index, e, opts) {
		invoices_mass_sel_product(container_id);
	});
	// WebApp.view.grid.Grid.pegSetDBClicknEnter(grid, function(me, row){
	// 	invoices_mass_sel_product( container_id);
	// });

}
var invoices_refresh_invoice_num_ajax = '';
function invoices_refresh_invoice_num(container_id, mode) {

	let prefix = '';
	if(mode =='a55'){
		var container_d = pegGetContainer_id_d(container_id, 'a55_d', '', 'a55_d');
		var container_d4 = pegGetContainer_id_d(container_id, 'a55_d4', '', 'a55_d');

	}else if(mode=='a56'){
		var container_d = pegGetContainer_id_d(container_id, 'a56_d', '', 'a56_d');
		var container_d4 = pegGetContainer_id_d(container_id, 'a56_d4', '', 'a56_d');
	}else if(mode == 'retail00_01')  {
		var parent_d = 'retail00_01_d';
		var retail00_01_d_container_id   = pegGetContainer_id_d(container_id , 'retail00_01_d'   , 0 , parent_d );
		if(!retail00_01_d_container_id) {
			parent_d = 'retail00_02_d';
			retail00_01_d_container_id = pegGetContainer_id_d(container_id , 'retail00_02_d'   , 0 , parent_d );
		}
		var container_d  = pegGetContainer_id_d(container_id, 'retail00_01_d04', '', parent_d);
		var container_d4 = pegGetContainer_id_d(container_id, 'retail00_01_d04', '', parent_d);

		prefix = 'a55';
	} else if(mode=='a60') {
		var container_d = pegGetContainer_id_d(container_id, 'a60_d', '', 'a60_d');
		var container_d4 = pegGetContainer_id_d(container_id, 'a60_d3', '', 'a60_d');
	}

	var p05Val 	= pegGetVal(prefix + 'p05', container_d);
	var p701Val = pegGetVal(prefix + 'p701', container_d);
	var p0121Val= pegGetVal(prefix + 'p0121', container_d4);
	var p08Val 	= pegGetVal(prefix + 'p08', container_d4);
	var nr01Val = pegGetVal(prefix + 'nr01',container_d);

	if (invoices_refresh_invoice_num_ajax != '') {
		if (invoices_refresh_invoice_num_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(invoices_refresh_invoice_num_ajax);
		}
	}
	params = {};
	params.p05 = p05Val;
	params.p701 = p701Val;
	params.p0121 = p0121Val;
	params.p08 = p08Val;
	params.nr01 = nr01Val;
	params.mode = mode;


	invoices_refresh_invoice_num_ajax = pegAjaxDefer('/' + main_path + '/invoices01/invoices_refresh_invoice_num.php', params, function (json_data) {
		if(json_data.change_value == 1){
			pegSetVal(prefix + 'p06',container_d,json_data['p06']);
		}
	});
}


function invoices_eidi_mass_selectiontoolbar_item(container_id, id, dic) {
	var screen = pegGetCmp(container_id);
	peg_windowShow_d('',
		'_invoices_mass_sel_product_d',
		'invoices',
		screen.getContainer_ID(),
		'', 0, '', '',
		{ mmnr01: screen.getMmnr01(), mnr01: screen.getMnr01() });
}

var invoices_mass_sel_product_ajax = '';
function invoices_mass_sel_product(container_id) {

	var _nr01_str = '';
	var screen = pegGetCmp(container_id);
	var mode = screen.getMmnr01().substr(0, 3);

	if (mode == 'a55') {
		var container_id_main = pegGetContainer_id_d(container_id, 'a55_d', '', 'a55_d');
		var container_id_eidi = pegGetContainer_id_d(container_id, 'a55_d3', '', 'a55_d');
		var container_id_eidi_service_only = pegGetContainer_id_d(container_id, 'a55_d8', '', 'a55_d');
		var container_id_stoixeia = pegGetContainer_id_d(container_id, 'a55_d4', '', 'a55_d');

	}

	if (mode == 'a56') {
		var container_id_main = pegGetContainer_id_d(container_id, 'a56_d', '', 'a56_d');
		var container_id_eidi = pegGetContainer_id_d(container_id, 'a56_d3', '', 'a56_d');
		var container_id_stoixeia = pegGetContainer_id_d(container_id, 'a56_d4', '', 'a56_d');

	}

	if (mode == 'a57') {
		var container_id_main = pegGetContainer_id_d(container_id, 'a57_d', '', 'a57_d');
		var container_id_eidi = pegGetContainer_id_d(container_id, 'a57_d2', '', 'a57_d');
		var container_id_stoixeia = pegGetContainer_id_d(container_id, 'a57_d3', '', 'a57_d');
	}

	if (mode == 'a67') {
		var container_id_main = pegGetContainer_id_d(container_id, 'a67_d', '', 'a67_d');
		var container_id_eidi = pegGetContainer_id_d(container_id, 'a67_d2', '', 'a67_d');
		var container_id_stoixeia = pegGetContainer_id_d(container_id, 'a67_d3', '', 'a67_d');
	}

	if (mode == 'a60') {
		var container_id_main = pegGetContainer_id_d(container_id, 'a60_d', '', 'a60_d');
		var container_id_eidi = pegGetContainer_id_d(container_id, 'a60_d2', '', 'a60_d');
	}

	if (mode == 'a61') {
		var container_id_main = pegGetContainer_id_d(container_id, 'a61_d', '', 'a61_d');
		var container_id_eidi = pegGetContainer_id_d(container_id, 'a61_d2', '', 'a61_d');
	}


	var selectedItems = pegGetCmp(container_id, 'grid').getSelectionModel().selected.items;

	selectedItems.forEach(function (item) {
		_nr01_str = _nr01_str + item.data['nr01'] + ';';
	});

	if (invoices_mass_sel_product_ajax != '') {
		if (invoices_mass_sel_product_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(invoices_mass_sel_product_ajax);
		}
	}

	var params = {};
	params.nr01_str = _nr01_str;
	params.mode = mode;

	params.nr01 = pegGetVal('nr01', container_id_main);
	params.date = pegGetVal('p01', container_id_main);
	params.kath_fpa = 0;
	if (mode != 'a60' && mode != 'a61') {
		params.kath_fpa = pegGetVal('p09', container_id_stoixeia);
	}


	invoices_mass_sel_product_ajax = pegAjaxDefer('/' + main_path + '/invoices02/eidi_mass_selection.php', params, function (json_data) {
		if (json_data.ok == 1) {
			pegGridRefresh(container_id_eidi, 'grid', json_data.last_nr01);
			if (mode != 'a60' && mode != 'a61') {
				invoices_calculate_total(container_id_main, mode);
			}
		}
	});



}

var invoices_refresh_ajax = '';
function invoices_refresh(container_id) {
	/* Δεν χρησιμοποιήτε καπο ακόμα*/
	var container_id_main        = pegGetContainer_id_d(container_id, 'a55_d', '', 'a55_d');
	var container_id_eidi        = pegGetContainer_id_d(container_id, 'a55_d3', '', 'a55_d');
	var container_id_stoixeia    = pegGetContainer_id_d(container_id, 'a55_d4', '', 'a55_d');
	var container_id_lp_stoixeia = pegGetContainer_id_d(container_id, 'a55_d5', '', 'a55_d');
	var container_id_fpa         = pegGetContainer_id_d(container_id, 'a55_d6', '', 'a55_d');
	var container_id_totals      = pegGetContainer_id_d(container_id, 'a55_d9', '', 'a55_d');

	var invoices_params = {};
	invoices_params = Ext.Object.merge(invoices_params, pegGetFormVal(container_id_main));
	invoices_params = Ext.Object.merge(invoices_params, pegGetFormVal(container_id_eidi));
	invoices_params = Ext.Object.merge(invoices_params, pegGetFormVal(container_id_stoixeia));
	invoices_params = Ext.Object.merge(invoices_params, pegGetFormVal(container_id_lp_stoixeia));
	invoices_params = Ext.Object.merge(invoices_params, pegGetFormVal(container_id_fpa));
	invoices_params = Ext.Object.merge(invoices_params, pegGetFormVal(container_id_totals));

	var container_id_array = {};
	container_id_array = Ext.Array.push(container_id_array, container_id_main);
	container_id_array = Ext.Array.push(container_id_array, container_id_eidi);
	container_id_array = Ext.Array.push(container_id_array, container_id_stoixeia);
	container_id_array = Ext.Array.push(container_id_array, container_id_lp_stoixeia);
	container_id_array = Ext.Array.push(container_id_array, container_id_fpa);
	container_id_array = Ext.Array.push(container_id_array, container_id_totals);


	if (invoices_refresh_ajax != '') {
		if (invoices_refresh_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(invoices_refresh_ajax);
		}
	}

	invoices_refresh_ajax = pegAjaxDefer('/' + main_path + '/invoices01/invoices_refresh_vals.php', invoices_params, function (jsondata) {
		Ext.each(container_id_array, function (container_id) {
			fld = pegGetFormFields(container_id);
			if (fld) {
				fld.each(function (item) {
					if (jsondata[item.name] != undefined && item.name != 'nr01') {
						pegSetVal(item.name, item.container_id, jsondata[item.name]);
					}
				});
			}
		});
	});

}

/* */
function invoices_sign_invoice(table, nr01, container_id) {
	return;
	params = {};
	params.invoice_nr01 = nr01;
	params.invoice_table = table;
	if (table == 'a55') {
		pegWindowShow_d('', 'a55_d100', 'invcust', container_id, 0, '', '', '', '', '', params, true, true);
	}
}

var invoices_check_sign_exist_ajax = '';
function invoices_check_sign_exist(table, nr01, container_id, restart) {

	params = {};
	params.invoice_nr01 = nr01;
	params.invoice_table = table;
	params.container_id = container_id;
	params.restart = restart;
	invoices_check_sign_exist_ajax = pegAjaxDefer('/' + main_path + '/invoices01/sign_invoice_exist.php', params, function (json_data) {

		if (json_data.next == 1) {
			invoices_check_sign_exist(json_data.table, json_data.nr01, json_data.container_id, 0);
		} else {
			if (json_data.sign_exist == 0) {
				pegConfirmBox('', json_data.message, function (but) {
					if (but == 'yes') {
						invoices_check_sign_exist(json_data.table, json_data.nr01, json_data.container_id, 1);
					} else {
						parent = Ext.getCmp(json_data.container_id).up();
						pegWindowClose(parent.id);
					}
				});


			} else {
				pegAlert('ok and stop ');
				pegWindowClose(json_data.container_id);
			}
		}

	});

}

function invoices_change_katestos_fpa(container_id, mode) {
	let prefix = "";

	var main_container_id = pegGetContainer_id_d(container_id, mode+'_d', '', mode+'_d');
	if(mode == 'a55' || mode == 'a56') {
		var container_id_stoixeia  = pegGetContainer_id_d(container_id, mode+'_d4', '', mode+'_d');
	} else if(mode == 'a57' || mode == 'a67') {
		var container_id_stoixeia  = pegGetContainer_id_d(container_id, mode+'_d3', '', mode+'_d');
	}

	if(mode == 'retail00_01') {
		prefix = "a55";

		var parent_d = 'retail00_01_d';
		var retail00_01_d_container_id   = pegGetContainer_id_d(container_id, 'retail00_01_d', '', parent_d);
		if(!retail00_01_d_container_id) {
			parent_d = 'retail00_02_d';
			retail00_01_d_container_id = pegGetContainer_id_d(container_id, 'retail00_02_d', '', parent_d);
		}

		var container_id_stoixeia  = pegGetContainer_id_d(container_id, 'retail00_01_d04', '', parent_d);

		main_container_id = container_id_stoixeia;
	}

	let p07 = pegGetVal(prefix+'p07', container_id_stoixeia); // Τιμές με ΦΠΑ
	let p0109 = pegGetVal(prefix+'p0109', main_container_id); // Σύνολο

	// Γίνεται έλεγχος του πεδίου [Σύνολο] ώστε να μην εμφανίζεται αχρείστατα το συγκεκριμένο μήνυμα
	if(p07 && p0109 > 0) {
		pegGetDic('peg_dic_invoices_recalc_unit_price', function(msg) {
			pegConfirmBox("", msg, function(res) {
				if(res == 'yes') {
					invoices_change_katestos_fpa_00(container_id, mode, 1);
				} else {
					invoices_change_katestos_fpa_00(container_id, mode);
				}

				return;
			});			
		});
	} else {
		invoices_change_katestos_fpa_00(container_id, mode);
		return;		
	}
}

var invoices_change_katestos_fpa_ajax = '';
function invoices_change_katestos_fpa_00(container_id, mode, recalculate_unit_price=0) {
	if (invoices_change_katestos_fpa_ajax != '') {
		if (invoices_change_katestos_fpa_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(invoices_change_katestos_fpa_ajax);
		}
	}

	if (mode == 'a55') {
		var container_id_main      = pegGetContainer_id_d(container_id, 'a55_d', '', 'a55_d');
		var container_id_eidi      = pegGetContainer_id_d(container_id, 'a55_d3', '', 'a55_d');
		var container_id_stoixeia  = pegGetContainer_id_d(container_id, 'a55_d4', '', 'a55_d');
		var container_id_fpa       = pegGetContainer_id_d(container_id, 'a55_d6', '', 'a55_d');
		var container_id_totals    = pegGetContainer_id_d(container_id, 'a55_d9', '', 'a55_d');

	}

	if (mode == 'a56') {
		var container_id_main      = pegGetContainer_id_d(container_id, 'a56_d', '', 'a56_d');
		var container_id_eidi      = pegGetContainer_id_d(container_id, 'a56_d3', '', 'a56_d');
		var container_id_stoixeia  = pegGetContainer_id_d(container_id, 'a56_d4', '', 'a56_d');
		var container_id_fpa 	   = pegGetContainer_id_d(container_id, 'a56_d6', '', 'a56_d');
		var container_id_totals    = pegGetContainer_id_d(container_id, 'a56_d9', '', 'a56_d');

	}

	if (mode == 'a57') {
		var container_id_main      = pegGetContainer_id_d(container_id, 'a57_d', '', 'a57_d');
		var container_id_eidi      = pegGetContainer_id_d(container_id, 'a57_d2', '', 'a57_d');
		var container_id_stoixeia  = pegGetContainer_id_d(container_id, 'a57_d3', '', 'a57_d');
		var container_id_fpa       = pegGetContainer_id_d(container_id, 'a57_d5', '', 'a57_d');
		var container_id_totals    = pegGetContainer_id_d(container_id, 'a57_d9', '', 'a57_d');

	}

	if (mode == 'a67') {
		var container_id_main      = pegGetContainer_id_d(container_id, 'a67_d', '', 'a67_d');
		var container_id_eidi      = pegGetContainer_id_d(container_id, 'a67_d2', '', 'a67_d');
		var container_id_stoixeia  = pegGetContainer_id_d(container_id, 'a67_d3', '', 'a67_d');
		var container_id_fpa       = pegGetContainer_id_d(container_id, 'a67_d4', '', 'a67_d');
		var container_id_totals    = pegGetContainer_id_d(container_id, 'a67_d9', '', 'a67_d');

	}

	if (mode == 'retail00_01') {
		var parent_d = 'retail00_01_d';
		var retail00_01_d_container_id   = pegGetContainer_id_d(container_id , 'retail00_01_d'   , '' , parent_d );
		if(!retail00_01_d_container_id) {
			parent_d = 'retail00_02_d';
			retail00_01_d_container_id = pegGetContainer_id_d(container_id , 'retail00_02_d'   , '' , parent_d );
		}
		var container_id_main      = pegGetContainer_id_d(container_id, parent_d, '', parent_d);
		var container_id_eidi      = pegGetContainer_id_d(container_id, 'retail00_01_d03', '', parent_d);
		var container_id_stoixeia  = pegGetContainer_id_d(container_id, 'retail00_01_d04', '', parent_d);
		var container_id_fpa       = pegGetContainer_id_d(container_id, 'retail00_01_d04', '', parent_d);
		var container_id_totals    = pegGetContainer_id_d(container_id, 'retail00_01_d04', '', parent_d);

		var container_id_pelatis   = pegGetContainer_id_d(container_id, 'retail00_01_d02', '', parent_d);
	}

	params = {};
	params.mode = mode;
	params.recalculate_unit_price = recalculate_unit_price;

	if(mode == 'retail00_01') {
		params.p05 = pegGetVal('a55p05', container_id_stoixeia);
		params.p04 = pegGetVal('a01a71', container_id_pelatis);
		params.a01nr01 = pegGetVal('a01nr01', container_id_pelatis);
		params.nr01 = pegGetVal('a55nr01', container_id_stoixeia);
		params.p01 = pegGetVal('a55p01', container_id_stoixeia);
		params.p09 = pegGetVal('a01p45', container_id_pelatis);
	} else {
		params.p05 = pegGetVal('p05', container_id_main);
		params.p04 = pegGetVal('p04', container_id_main);
		params.a01nr01 = pegGetVal('p03', container_id_main);
		params.nr01 = pegGetVal('nr01', container_id_main);
		params.p01 = pegGetVal('p01', container_id_main);
		params.p09 = pegGetVal('p09', container_id_stoixeia);
	}
	
	params.container_id_eidi = container_id_eidi;
	params.container_id = container_id_main;

	invoices_change_katestos_fpa_ajax = pegAjaxDefer('/' + main_path + '/invoices01/change_kathestos_fpa.php', params, function (json_data) {
		if(recalculate_unit_price == 1) {
			prefix = "";
			if(mode == 'retail00_01') {
				prefix = 'a55';
			}

			invoices_set_p07_onchange_pause(true);
			pegSetVal(prefix+'p07', container_id_stoixeia, 0);
			invoices_set_p07_onchange_pause(false);
		}
		invoices_calculate_total(container_id, mode);
		if(mode == 'retail00_01') {
			retail00_refresh_item_grids(container_id_main);
		} else {
			pegGridRefresh(container_id_eidi, 'grid');
		}		
	});
}

function invoice_get_container_id_stoixeia(container_id,mode){
	var container_id_stoixeia = '';
	if (mode == 'a55') {
		container_id_stoixeia  = pegGetContainer_id_d(container_id, 'a55_d4', '', 'a55_d');
	}

	if (mode == 'a56') {
		container_id_stoixeia  = pegGetContainer_id_d(container_id, 'a56_d4', '', 'a56_d');
	}

	if (mode == 'a57') {
		container_id_stoixeia  = pegGetContainer_id_d(container_id, 'a57_d3', '', 'a57_d');
	}

	if (mode == 'a67') {
		container_id_stoixeia  = pegGetContainer_id_d(container_id, 'a67_d3', '', 'a67_d');
	}

	if (mode == 'a61') {
		container_id_stoixeia = pegGetContainer_id_d(container_id, 'a61_d3', '', 'a61_d');
	}

	if (mode == 'a60') {
		container_id_stoixeia = pegGetContainer_id_d(container_id, 'a60_d3', '', 'a60_d');
	}

	if (mode == 'retail00_01') {
		var parent_d = 'retail00_01_d';
		var retail00_01_d_container_id   = pegGetContainer_id_d(container_id , 'retail00_01_d'   , '' , parent_d );
		if(!retail00_01_d_container_id) {
			parent_d = 'retail00_02_d';
		}
		container_id_stoixeia = pegGetContainer_id_d(container_id, 'retail00_01_d04', '', parent_d);
	}

	return container_id_stoixeia;
}

/**
 * Eυρεση αποθηκευτικου χωρου παραστατικου και παραγγελιας
 * @param {*} container_id
 * @param {*} mode
 */
function invoice_get_p703(container_id,mode){
	var p703 = 0;
	var container_id_stoixeia = invoice_get_container_id_stoixeia(container_id,mode);
	if(pegIsEmpty(container_id_stoixeia)){
		return p703;
	}

	var fld = 'p703';
	if (mode == 'retail00_01') {
		fld = 'a55p703';
	}
	return pegGetVal(fld, container_id_stoixeia);
}

/**
 * Eυρεση αν οι τιμες εχουν ΦΠΑ σε  παραστατικο και  παραγγελιας
 * @param {*} container_id
 * @param {*} mode
 */
function invoice_get_p07(container_id,mode){
	var p07 = 0;
	var container_id_stoixeia = invoice_get_container_id_stoixeia(container_id,mode);
	if(pegIsEmpty(container_id_stoixeia)){
		return p07;
	}
	var fld = 'p07';
	if (mode == 'retail00_01') {
		fld = 'a55p07';
	}
	return pegGetVal(fld, container_id_stoixeia);
}

function invoices_save_i71(container_id, mode) {
	if(pegIsEmpty(mode)){
		var screen = pegGetCmp(container_id);
		var tran01_d_container_id_main      	 = pegGetContainer_id_d(container_id, 'tran01_d', '', 'tran01_d');
		if(!pegIsEmpty(tran01_d_container_id_main)){
			tran_tran02_btn_save(screen);
		}else{
			invoices_calculate_total( container_id, '');
		}
	}
}

var invoices_calculate_total_ajax = '';
function invoices_calculate_total(container_id, mode, callback) {

	if (invoices_calculate_total_ajax != '') {
		if (invoices_calculate_total_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(invoices_calculate_total_ajax);
		}
	}
	
	var screen = pegGetCmp(container_id);
	var prefix = '';
	//retail: add retail00_01 mode
	if(pegIsEmpty(mode)){
		var a55_d_container_id_main      		 = pegGetContainer_id_d(container_id, 'a55_d', '', 'a55_d');
		var a56_d_container_id_main      		 = pegGetContainer_id_d(container_id, 'a56_d', '', 'a56_d');
		var a57_d_container_id_main      		 = pegGetContainer_id_d(container_id, 'a57_d', '', 'a57_d');
		var a67_d_container_id_main      		 = pegGetContainer_id_d(container_id, 'a67_d', '', 'a67_d');

		var parent_d = 'retail00_01_d';
		var retail00_01_d_container_id   = pegGetContainer_id_d(container_id , 'retail00_01_d'   , '' , parent_d );
		if(!retail00_01_d_container_id) {
			parent_d = 'retail00_02_d';
		}
		var retail00_01_d_container_id_main      = pegGetContainer_id_d(container_id, parent_d, '', parent_d);

		if(!pegIsEmpty(a55_d_container_id_main)){
			mode = 'a55';
		}
		if(!pegIsEmpty(a57_d_container_id_main)){
			mode = 'a57';
		}
		if(!pegIsEmpty(a56_d_container_id_main)){
			mode = 'a56';
		}
		if(!pegIsEmpty(a67_d_container_id_main)){
			mode = 'a67';
		}
		if(!pegIsEmpty(retail00_01_d_container_id_main)){
			mode = 'retail00_01';
		}
	}

	if (mode == 'a55') {
		var container_id_main      = pegGetContainer_id_d(container_id, 'a55_d', '', 'a55_d');
		var container_id_eidi      = pegGetContainer_id_d(container_id, 'a55_d3', '', 'a55_d');
		var container_id_stoixeia  = pegGetContainer_id_d(container_id, 'a55_d4', '', 'a55_d');
		var container_id_fpa       = pegGetContainer_id_d(container_id, 'a55_d6', '', 'a55_d');
		var container_id_totals    = pegGetContainer_id_d(container_id, 'a55_d9', '', 'a55_d');
		var container_id_i71_d00   = pegGetContainer_id_d(container_id, 'i71_d00', '', 'a55_d');
	}

	if (mode == 'a56') {
		var container_id_main      = pegGetContainer_id_d(container_id, 'a56_d', '', 'a56_d');
		var container_id_eidi      = pegGetContainer_id_d(container_id, 'a56_d3', '', 'a56_d');
		var container_id_stoixeia  = pegGetContainer_id_d(container_id, 'a56_d4', '', 'a56_d');
		var container_id_fpa 	   = pegGetContainer_id_d(container_id, 'a56_d6', '', 'a56_d');
		var container_id_totals    = pegGetContainer_id_d(container_id, 'a56_d9', '', 'a56_d');
		var container_id_i71_d00   = pegGetContainer_id_d(container_id, 'i71_d00', '', 'a56_d');
	}

	if (mode == 'a57') {
		var container_id_main      = pegGetContainer_id_d(container_id, 'a57_d', '', 'a57_d');
		var container_id_eidi      = pegGetContainer_id_d(container_id, 'a57_d2', '', 'a57_d');
		var container_id_stoixeia  = pegGetContainer_id_d(container_id, 'a57_d3', '', 'a57_d');
		var container_id_fpa       = pegGetContainer_id_d(container_id, 'a57_d5', '', 'a57_d');
		var container_id_totals    = pegGetContainer_id_d(container_id, 'a57_d9', '', 'a57_d');
		var container_id_i71_d00   = pegGetContainer_id_d(container_id, 'i71_d00', '', 'a57_d');

	}

	if (mode == 'a67') {
		var container_id_main      = pegGetContainer_id_d(container_id, 'a67_d', '', 'a67_d');
		var container_id_eidi      = pegGetContainer_id_d(container_id, 'a67_d2', '', 'a67_d');
		var container_id_stoixeia  = pegGetContainer_id_d(container_id, 'a67_d3', '', 'a67_d');
		var container_id_fpa       = pegGetContainer_id_d(container_id, 'a67_d5', '', 'a67_d');
		var container_id_totals    = pegGetContainer_id_d(container_id, 'a67_d9', '', 'a67_d');
		var container_id_i71_d00   = pegGetContainer_id_d(container_id, 'i71_d00', '', 'a67_d');

	}

	//retail: add retail00_01 container ids -- Θεωρητικά θα χρειαστώ το ίδιο container id σε διαφορετικά vars για να μην πειράξω κώδικα παρακάτω.
	if (mode == 'retail00_01') {
		prefix = 'a55';
		var parent_d = 'retail00_01_d';
		var retail00_01_d_container_id   = pegGetContainer_id_d(container_id , 'retail00_01_d'   , '' , parent_d );
		if(!retail00_01_d_container_id) {
			parent_d = 'retail00_02_d';
			retail00_01_d_container_id = pegGetContainer_id_d(container_id , 'retail00_02_d'   , '' , parent_d );
			retail00_02_d00_container_id = pegGetContainer_id_d(container_id , 'retail00_02_d00'   , '' , parent_d );

			// Αυτή η συνάρτηση καλείται και από mobile και συγκεκριμένα από την ενέργεια των Εκκρεμών Αντλήσεων
			// Από mobile δεν υπήρχε το retail00_02_d00_container_id και έβγαζε σφάλμα στην .setText(total_button_set_text); παρακάτω.
			if(!retail00_02_d00_container_id) {
				retail00_02_d00_container_id = pegGetContainer_id_d(screen.getPeg_screen_parent_container_id(), 'retail00_02_d00', 0, parent_d);
			}
		}
		var container_id_main      = pegGetContainer_id_d(container_id, 'retail00_01_d04', 	'', parent_d);
		var container_id_eidi      = pegGetContainer_id_d(container_id, 'retail00_01_d03', 	'', parent_d);
		var container_id_stoixeia  = pegGetContainer_id_d(container_id, 'retail00_01_d04', 	'', parent_d);
		var container_id_fpa       = pegGetContainer_id_d(container_id, 'retail00_01_d04', 	'', parent_d);
		var container_id_totals    = pegGetContainer_id_d(container_id, 'retail00_01_d04', 	'', parent_d);
		var container_id_i71_d00   = pegGetContainer_id_d(container_id, 'retail00_01_d08', 	'', parent_d);

		var container_id_pelatis   = pegGetContainer_id_d(container_id, 'retail00_01_d02', 	'', parent_d);

	}

	/**
	 *  Στο retail έχω αυτά τα πεδία, τα υπόλοιπα να τα βάλω κανονικά;
	 * 	MK Παραστατικού a55nr01
		Παραστατικό 	a55p05 
		Ηµεροµηνία 		a55p01 
		Αποθήκη 		a55p703
		Τιµές µε ΦΠΑ 	a55p07 
		Υποκατάστηµα 	a55p04 
	 */


	var params = {};
	params.mode = mode;

	//% Εκπτωση
	params.p0101 = pegGetVal(prefix + 'p0101', container_id_totals);
	// if (mode == 'a67') {
	//  	params.p0101 = pegGetVal('vp0101', container_id_eidi);
	// }
	//Εκπτωση Προ ΦΠΑ
	params.p0102_1 = pegGetVal(prefix + 'p0102_1', container_id_totals);
	//Εκπτωση Επι του συνολου
	params.p0102_2 = pegGetVal(prefix + 'p0102_2', container_id_totals);
	//% Κρατησεις
	params.p0112 = pegGetVal(prefix + 'p0112', container_id_totals);
	//% Φόρος
	params.p0113 = pegGetVal(prefix + 'p0113', container_id_totals);
	//% Επιβαρύνσεις
	params.p0108 = pegGetVal(prefix + 'p0108', container_id_totals);

	if(mode == 'retail00_01') {
		params.p03  = pegGetVal('a01nr01', container_id_pelatis); //retail:___ a01nr01
		params.p09  = pegGetVal('a01p45', container_id_pelatis);  //retail:___ a01p45
		params.p05  = pegGetVal('a55p05', container_id_main);
	}else{
		params.p03  = pegGetVal('p03', container_id_main);
		params.p09  = pegGetVal('p09', container_id_stoixeia);
	}
	params.date = pegGetVal(prefix + 'p01', container_id_main);
	params.nr01 = pegGetVal(prefix + 'nr01', container_id_main);
	
	// params.p09  = pegGetVal(prefix + 'p09', container_id_stoixeia);
	params.p410 = pegGetVal(prefix + 'p410', container_id_fpa);
	params.p420 = pegGetVal(prefix + 'p420', container_id_fpa);
	params.p506 = pegGetVal(prefix + 'p506', container_id_stoixeia);

	params.pn02 = pegGetVal(prefix + 'pn02', container_id_stoixeia)

	
	params.p201 = pegGetVal(prefix + 'p201', container_id_fpa);
	params.p202 = pegGetVal(prefix + 'p202', container_id_fpa);
	params.p203 = pegGetVal(prefix + 'p203', container_id_fpa);
	params.p204 = pegGetVal(prefix + 'p204', container_id_fpa);
	params.p205 = pegGetVal(prefix + 'p205', container_id_fpa);
	params.p206 = pegGetVal(prefix + 'p206', container_id_fpa);
	params.p207 = pegGetVal(prefix + 'p207', container_id_fpa);
	params.p208 = pegGetVal(prefix + 'p208', container_id_fpa);
	params.p209 = pegGetVal(prefix + 'p209', container_id_fpa);

	params.p301 = pegGetVal(prefix + 'p301', container_id_fpa);
	params.p302 = pegGetVal(prefix + 'p302', container_id_fpa);
	params.p303 = pegGetVal(prefix + 'p303', container_id_fpa);
	params.p304 = pegGetVal(prefix + 'p304', container_id_fpa);
	params.p305 = pegGetVal(prefix + 'p305', container_id_fpa);
	params.p306 = pegGetVal(prefix + 'p306', container_id_fpa);
	params.p307 = pegGetVal(prefix + 'p307', container_id_fpa);
	params.p308 = pegGetVal(prefix + 'p308', container_id_fpa);
	params.p309 = pegGetVal(prefix + 'p309', container_id_fpa);

	//Με ΦΠΑ
	params.preview_wthvat    = invoice_get_p07(container_id,mode); //retail 16/05 an alalxoyme tin sinartisi na paizei me mode=retail01
	params.container_id_eidi = container_id_eidi;
	if(mode == 'retail00_01') {
		params.container_id      = retail00_01_d_container_id;
	}else{
		params.container_id      = container_id_main;
	}
	

	invoices_calculate_total_ajax = pegAjaxDefer('/' + main_path + '/invoices01/find_totals.php', params, function (json_data) {


		//Συνολο φόρων
		pegSetVal(prefix + 'p0600',container_id_totals , json_data.p0600);

		//Συνόλο κρατησεων
		pegSetVal(prefix + 'p0601',container_id_totals , json_data.p0601);

		//Εκπτωση
		pegSetVal(prefix + 'p0102',container_id_main , json_data.p0102);

		//Εκπτωση Προ ΦΠΑ
		pegSetVal(prefix + 'p0102_1', container_id_totals, json_data.p0102_1);

		//Εκπτωση Επι του συνολου
		pegSetVal(prefix + 'p0102_2', container_id_totals, json_data.p0102_2);

		//% Κρατησεις
		pegSetVal(prefix + 'p0112', container_id_totals, json_data.p0112);
		//Κρατησεις
		pegSetVal(prefix + 'vp0112', container_id_totals, json_data.vp0112);

		//% Επιβαρύνσεις
		pegSetVal(prefix + 'p0113', container_id_totals, json_data.p0113);
		//Επιβαρύνσεις
		pegSetVal(prefix + 'vp0113', container_id_totals, json_data.vp0113);

		// Αρχική Αξια
		pegSetVal(prefix + 'p0100', container_id_main, json_data.p0100);
		//% Εκπτωση
		pegSetVal(prefix + 'p0101', container_id_totals, json_data.p0101);
		// if (mode == 'a67') {
		// 	pegSetVal('vp0101', container_id_eidi, json_data.p0101);
		// }
		//ΦΠΑ
		pegSetVal(prefix + 'p0105', container_id_main, json_data.p0105);
		//Συνολο
		pegSetVal(prefix + 'p0109', container_id_main, json_data.p0109);


		pegSetVal(prefix + 'p201', container_id_fpa, json_data.p201);
		pegSetVal(prefix + 'p202', container_id_fpa, json_data.p202);
		pegSetVal(prefix + 'p203', container_id_fpa, json_data.p203);
		pegSetVal(prefix + 'p204', container_id_fpa, json_data.p204);
		pegSetVal(prefix + 'p205', container_id_fpa, json_data.p205);
		pegSetVal(prefix + 'p206', container_id_fpa, json_data.p206);
		pegSetVal(prefix + 'p207', container_id_fpa, json_data.p207);
		pegSetVal(prefix + 'p208', container_id_fpa, json_data.p208);
		pegSetVal(prefix + 'p209', container_id_fpa, json_data.p209);

		pegSetVal(prefix + 'p301', container_id_fpa, json_data.p301);
		pegSetVal(prefix + 'p302', container_id_fpa, json_data.p302);
		pegSetVal(prefix + 'p303', container_id_fpa, json_data.p303);
		pegSetVal(prefix + 'p304', container_id_fpa, json_data.p304);
		pegSetVal(prefix + 'p305', container_id_fpa, json_data.p305);
		pegSetVal(prefix + 'p306', container_id_fpa, json_data.p306);
		pegSetVal(prefix + 'p307', container_id_fpa, json_data.p307);
		pegSetVal(prefix + 'p308', container_id_fpa, json_data.p308);
		pegSetVal(prefix + 'p309', container_id_fpa, json_data.p309);

		//Ext.getCmp(container_id_main).enable();
		//Ext.util.Observable.resumeEvents();
		// Ext.getCmp('loading_text_' + container_id_main).setText('');


		//refresh taxes & deductions
		if (Ext.getCmp(container_id_i71_d00)) { //retail 16/05 na elexw oti paizei swsta 
			if(mode == 'retail00_01') {
				retail00_refresh_all_i71(container_id_i71_d00);
			}else{
				pegGridRefresh(container_id_i71_d00, 'grid', 0);
			}

		}

		if(mode == 'retail00_01') {
			retail00_set_retail00_01_d__lektiko_par(json_data.lektiko_par);
			let total_button_set_text = '<b><big>'+json_data.p0109_formatted+'€</big></b><br>Πληρωμή & Έκδοση' + ' ' + retail00_get_retail00_01_d__lektiko_par();
			if(parent_d == 'retail00_02_d') {
				pegGetCmp(retail00_02_d00_container_id, 'but_total').setText(total_button_set_text);
			}else{
				pegGetCmp(retail00_01_d_container_id, 'but_total').setText(total_button_set_text);
			}
			if(typeof retail01_get_ecr_sim_container_id === 'function') {
				let ecr_sim_container_id = retail01_get_ecr_sim_container_id();
				if(pegGetContainer_id_d(ecr_sim_container_id , '_retail01_ecr_sim_d' , 0 , '_retail01_ecr_sim_d')) {
					pegGetCmp(ecr_sim_container_id, 'but_submit_ecr').setText(total_button_set_text)
				}
			}

		}

		if(typeof callback === "function"){
			callback();
		}
	}, 'json', 0);



}

var invoices_find_invoice_data_ajax = '';
function invoices_find_invoice_data(
	container_id,
	 mode,
	 check_or_set_p03 = ''
) {
	let prefix = '';
	if (mode == 'a55') {
		var container_id_main = pegGetContainer_id_d(container_id, 'a55_d', '', 'a55_d');
		var container_id_eidi = pegGetContainer_id_d(container_id, 'a55_d3', '', 'a55_d');
		var container_id_stoixeia = pegGetContainer_id_d(container_id, 'a55_d4', '', 'a55_d');
		var container_id_totals    = pegGetContainer_id_d(container_id, 'a55_d9', '', 'a55_d');
		var container_id_lp_stoixeia = pegGetContainer_id_d(container_id, 'a55_d5', '', 'a55_d');
	}if (mode == 'a56') {
		var container_id_main = pegGetContainer_id_d(container_id, 'a56_d', '', 'a56_d');
		var container_id_eidi = pegGetContainer_id_d(container_id, 'a56_d3', '', 'a56_d');
		var container_id_stoixeia = pegGetContainer_id_d(container_id, 'a56_d4', '', 'a56_d');
		var container_id_totals    = pegGetContainer_id_d(container_id, 'a56_d9', '', 'a56_d');
		var container_id_lp_stoixeia = pegGetContainer_id_d(container_id, 'a56_d5', '', 'a56_d');
	}
	if (mode == 'a57') {
		var container_id_main = pegGetContainer_id_d(container_id, 'a57_d', '', 'a57_d');
		var container_id_eidi = pegGetContainer_id_d(container_id, 'a57_d2', '', 'a57_d');
		var container_id_stoixeia = pegGetContainer_id_d(container_id, 'a57_d3', '', 'a57_d');
		var container_id_totals    = pegGetContainer_id_d(container_id, 'a57_d9', '', 'a57_d');
		var container_id_lp_stoixeia = pegGetContainer_id_d(container_id, 'a57_d4', '', 'a57_d');
	}
	if (mode == 'a67') {
		var container_id_main = pegGetContainer_id_d(container_id, 'a67_d', '', 'a67_d');
		var container_id_eidi = pegGetContainer_id_d(container_id, 'a67_d2', '', 'a67_d');
		var container_id_stoixeia = pegGetContainer_id_d(container_id, 'a67_d3', '', 'a67_d');
		var container_id_totals    = pegGetContainer_id_d(container_id, 'a67_d9', '', 'a67_d');
		var container_id_lp_stoixeia = pegGetContainer_id_d(container_id, 'a67_d4', '', 'a67_d');
	}

	if (mode == 'a61') {
		var container_id_main = pegGetContainer_id_d(container_id, 'a61_d', '', 'a61_d');
		var container_id_eidi = pegGetContainer_id_d(container_id, 'a61_d2', '', 'a61_d');
		var container_id_stoixeia = pegGetContainer_id_d(container_id, 'a61_d3', '', 'a61_d');
	}
	if (mode == 'a60') {
		var container_id_main = pegGetContainer_id_d(container_id, 'a60_d', '', 'a60_d');
		var container_id_eidi = pegGetContainer_id_d(container_id, 'a60_d2', '', 'a60_d');
		var container_id_stoixeia = pegGetContainer_id_d(container_id, 'a60_d3', '', 'a60_d');
	}
	if (mode == 'retail00_01') {
		var parent_d = 'retail00_01_d';
		var retail00_01_d_container_id   = pegGetContainer_id_d(container_id , 'retail00_01_d'   , '' , parent_d );

		var container_id_eidi = pegGetContainer_id_d(container_id, 'retail00_01_d', '', parent_d);
		if(!retail00_01_d_container_id) {
			parent_d = 'retail00_02_d';
			retail00_01_d_container_id = pegGetContainer_id_d(container_id , 'retail00_02_d'   , '' , parent_d );
			container_id_eidi = pegGetContainer_id_d(container_id, 'retail00_02_d00', '', parent_d);
		}
		var container_id_main = pegGetContainer_id_d(container_id, 'retail00_01_d04', '', parent_d);
		var container_id_stoixeia = pegGetContainer_id_d(container_id, 'retail00_01_d04', '', parent_d);
		var container_id_totals    = pegGetContainer_id_d(container_id, 'retail00_01_d04', '', parent_d);
		var container_id_lp_stoixeia = pegGetContainer_id_d(container_id, 'retail00_01_d04', '', parent_d);

		prefix = 'a55';
		var container_id_pelatis = pegGetContainer_id_d(container_id, 'retail00_01_d02', '', parent_d);
		var container_id_stoixeia_diakinisis = container_id_main;
	}else{
		var container_id_stoixeia_diakinisis = pegGetContainer_id_d(container_id, mode+'_d8', '', mode+'_d');
	}



	let p03 = '';
	let p04 = '';
	if (mode == 'retail00_01') {
		p03 = pegGetVal('a01nr01', container_id_pelatis);
		p04 = pegGetVal('a01a71', container_id_pelatis);
	} else {
		p03 = pegGetVal('p03', container_id_main);
		p04 = pegGetVal('p04', container_id_main);
	}
	const params = {
		nr01	: pegGetVal(prefix + 'nr01', container_id_main),
		p03		: p03,
		p04 	: p04,
		p05 	: pegGetVal(prefix + 'p05', container_id_main),
		p0121	: pegGetVal(prefix + 'p0121', container_id_stoixeia),
		mode	: mode,
		container_id : container_id_main
	};
	if (mode == 'a55' || mode == 'a56' || mode == 'retail00_01') {
		//Σειρα Παραστατικου
		params.p701 = pegGetVal(prefix + 'p701', container_id_main);
	}
	// Αν η αλλαγή έχει γίνει απο το πεδίο του "Ορισμού Παραστατικού" (a55 | a56 | a57 | a67).p05 
	if(
		check_or_set_p03 == 'check_for_new_p03'
		&& (
			mode == 'a55'
			|| mode == 'a56'
			|| mode == 'a57'
			|| mode == 'a67'
			|| mode == 'retail00_01'
		)
	) {
		params.check_or_set_p03 = check_or_set_p03;
	}
	if(
		check_or_set_p03 == 'set_new_p03_data'
		&& (
			mode == 'a55'
			|| mode == 'a56'
			|| mode == 'a57'
			|| mode == 'a67'
			|| mode == 'retail00_01'
		)
	) {
		params.check_or_set_p03 = check_or_set_p03;
		// php:find_p03_data require fields
		params.p01  = pegGetVal(prefix + 'p01', container_id_main);
		params.p02  = pegGetVal(prefix + 'p02', container_id_main);
		params.p415 = pegGetVal(prefix + 'p415', container_id_lp_stoixeia);
		params.p416 = pegGetVal(prefix + 'p416', container_id_lp_stoixeia);
	}

	if (invoices_find_invoice_data_ajax != '') {
		if (invoices_find_invoice_data_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(invoices_find_invoice_data_ajax);
		}
	}

	invoices_find_invoice_data_ajax = pegAjaxDefer('/' + main_path + '/invoices01/find_invoice_data.php', params, function (jsondata) {

		if(
			!pegIsEmpty(jsondata.confirm_new_p03)
			&& jsondata.confirm_new_p03 == true
		) {
			return pegConfirmBox(
				'',
				jsondata.message,
				function(ans) {
					if(ans == 'yes') {
						return invoices_find_invoice_data(container_id,mode,'set_new_p03_data');
					}
					return invoices_find_invoice_data(container_id,mode,'');
				}
			)
		}

		pegSetVal(prefix + 'p805', container_id_stoixeia, jsondata.p805);

		if (!pegIsEmpty(jsondata.p0112)) {
			pegSetVal(prefix + 'p0112', container_id_totals, jsondata.p0112);
		}

		if (!pegIsEmpty(jsondata.p0113)) {
			pegSetVal(prefix + 'p0113', container_id_totals, jsondata.p0113);
		}

		//Καταστημα
		if (!pegIsEmpty(jsondata.p0121)) {
			pegSetVal(prefix + 'p0121', container_id_stoixeia, {value:jsondata.p0121 , display:jsondata.p0121_display});
		}

		//Αποθηκη
		if (!pegIsEmpty(jsondata.p703)) {
			pegSetVal(prefix + 'p703', container_id_stoixeia, {value:jsondata.p703 , display:jsondata.p703_display});
		}

		if (mode == 'a55' || mode == 'a56' || mode == 'retail00_01') {

			if (pegGetVal(prefix + 'p08', container_id_stoixeia) != jsondata.p08 && jsondata.p08 != null) {
				var new_p08 = jsondata.p08;
				pegSetVal(prefix + 'p08', container_id_stoixeia, new_p08);
				invoices_p08_change(container_id_main, mode, new_p08);
			}

			pegSetVal(prefix + 'p701', container_id_main, jsondata.p701);
			if (!pegIsEmpty(jsondata.p015) && mode != 'retail00_01') { // Retail: no p015 field
				pegSetVal('p015', container_id_main, jsondata.p015);
			}

			if (!pegIsEmpty(jsondata.p06)) {
				pegSetVal(prefix + 'p06', container_id_main, jsondata.p06);
			}
		} else {

			if (!pegIsEmpty(jsondata.p015)) {
				pegSetVal('p015', container_id_stoixeia, {value:jsondata.p015 , display:jsondata.p015_display});
			}
		}
		if (mode == 'a61' || mode == 'a60') {
			pegSetVal('p03', container_id_main, jsondata.p03);
			pegSetVal('p04', container_id_main, jsondata.p04);
			if(pegGetCmp(container_id_main, 'dias_var_p03')){
				pegSetVal('dias_var_p03', container_id_main, jsondata.p03_i16p01);
			}
			if(pegGetCmp(container_id_main, 'dias_var_p04')){
				pegSetVal('dias_var_p04', container_id_main, jsondata.p04_i16p01);
			}

			if(jsondata.a30_p05 > 0) {
				pegSetFieldHidden('p04', container_id_main, false);
			} else {
				pegSetFieldHidden('p04', container_id_main, true);
				pegSetVal("p04", container_id_main, -1); 
			}
			
			pegSetVal('p08', container_id_stoixeia, jsondata.p08);
		}
		pegSetVal(prefix + 'p012', container_id_stoixeia, jsondata.p012);
		pegSetVal(prefix + 'p013', container_id_stoixeia, jsondata.p013);
		pegSetVal(prefix + 'p014', container_id_stoixeia, jsondata.p014);

		if(jsondata.hasOwnProperty('p07') ) {
			pegSetVal(prefix + 'p07' , container_id_stoixeia, jsondata.p07);
		}

		if(jsondata.dlvstreet !== undefined) {
			// Παράδοση
			pegSetVal(prefix + 'dlvstreet', container_id_stoixeia_diakinisis, jsondata.dlvstreet);	// Οδός
			pegSetVal(prefix + 'dlvnumber', container_id_stoixeia_diakinisis, jsondata.dlvnumber);	// Αριθμός
			pegSetVal(prefix + 'dlvzip',    container_id_stoixeia_diakinisis, jsondata.dlvzip);		// Τ.Κ.
			pegSetVal(prefix + 'dlvcity',   container_id_stoixeia_diakinisis, jsondata.dlvcity);		// Πόλη
			pegSetVal(prefix + 'cs_branch', container_id_stoixeia_diakinisis, jsondata.cs_branch);	// Εγκατάσταση ολοκλήρωσης διακίνησης
		}
		if(jsondata.ldstreet !== undefined) {
			// Φόρτωση
			pegSetVal(prefix + 'ldstreet', container_id_stoixeia_diakinisis,  jsondata.ldstreet);	// Οδός
			pegSetVal(prefix + 'ldnumber', container_id_stoixeia_diakinisis,  jsondata.ldnumber);	// Αριθμός
			pegSetVal(prefix + 'ldzip',    container_id_stoixeia_diakinisis,  jsondata.ldzip);		// Τ.Κ.
			pegSetVal(prefix + 'ldcity',   container_id_stoixeia_diakinisis,  jsondata.ldcity);		// Πόλη
			pegSetVal(prefix + 'ss_branch', container_id_stoixeia_diakinisis, jsondata.ss_branch);	// Εγκατάσταση έναρξης διακίνησης
		}
		
		
		if(check_or_set_p03 ==  'set_new_p03_data') {
			//Retail - 04/07/2023 - Reverted changes. Retail only changes a01nr01 and a01nr01's "onchange" takes over.
			if(mode == 'retail00_01') {
				pegSetVal('a01nr01', container_id_pelatis, {value: jsondata.p03, display: jsondata.p03_display});
			} else {
				pegSetVal('p03', container_id_main, {value:jsondata.p03,display:jsondata.p03_display});
				pegSetVal('p09', container_id_stoixeia, {'value': jsondata.p09, 'display':jsondata.p09_display});
				pegSetVal('p706c'  , container_id_stoixeia , {'value': jsondata.p706c, 'display':jsondata.p706c_display});
				pegSetVal('p707'   , container_id_stoixeia , jsondata.p707);
				pegSetVal('p412', container_id_lp_stoixeia, jsondata.p412);
				if (jsondata.clear_p04 == 1) {
					pegSetVal('p04', container_id_main, '');
				}
				pegSetFieldHidden('p04', container_id_main, jsondata.p04_hidden);
	
				// pegSetVal('p07', container_id_stoixeia, jsondata.p07);
				pegSetVal('p016', container_id_stoixeia, jsondata.p016);
				pegSetVal('p017', container_id_stoixeia, jsondata.p017);
				pegSetVal('p704', container_id_stoixeia, jsondata.p704);
				pegSetVal('vp506_2', container_id_stoixeia , jsondata.vp506_2);
				pegSetVal('p411', container_id_lp_stoixeia, jsondata.p411);
				pegSetVal('p417', container_id_lp_stoixeia, jsondata.p417);
				pegSetVal('p0101', container_id_totals, jsondata.p0101);
				if (jsondata.p30) {
					pegToast( jsondata.p30, 'info');
				}
			}
		}

		if(mode != 'a61' && mode != 'a60') {
			invoices_calculate_total(container_id, mode);
		}

		if((mode != 'a61' && mode != 'a60') || jsondata.p107 == 1) {			
			if (mode == 'retail00_01') {
				retail00_refresh_item_grids(container_id_main, 0);
			} else {
				pegGridRefresh(container_id_eidi, 'grid', 0);
			}
	    }
	});
}

var invoices_substore_change_ajax = '';
function invoices_substore_change(container_id, mode) {
	if (mode == 'a55') {
		var container_id_main = pegGetContainer_id_d(container_id, 'a55_d', '', 'a55_d');
		var container_id_stoixeia = pegGetContainer_id_d(container_id, 'a55_d4', '', 'a55_d');
	}

	if (mode == 'a56') {
		var container_id_main = pegGetContainer_id_d(container_id, 'a56_d', '', 'a56_d');
		var container_id_stoixeia = pegGetContainer_id_d(container_id, 'a56_d4', '', 'a56_d');
	}

	if (mode == 'a57') {
		var container_id_main = pegGetContainer_id_d(container_id, 'a57_d', '', 'a57_d');
		var container_id_stoixeia = pegGetContainer_id_d(container_id, 'a57_d3', '', 'a57_d');
	}

	params = {};
	params.p04 = pegGetVal('p04', container_id_main);
	params.mode = mode;

	if (invoices_substore_change_ajax != '') {
		if (invoices_substore_change_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(invoices_substore_change_ajax);
		}
	}

	invoices_substore_change_ajax = pegAjax('/' + main_path + '/invoices01/find_substore_data.php', params, function (jsondata) {
		if (jsondata.p017 > 0) {
			/*Τροπος μεταφοράς*/
			pegSetVal('p017', container_id_stoixeia, jsondata.p017);
		}

		if (jsondata.p09 > 0) {
			/*Τροπος μεταφοράς*/
			pegSetVal('p09', container_id_stoixeia, jsondata.p09);
		}
		//epanevresi ton stoixeion toy parastaikoy
		invoices_find_invoice_data(container_id, mode);
	});


}

var invoices_p03_change_ajax = '';
function invoices_p03_change(container_id, mode) {

	if (mode == 'a55') {
		var container_id_main = pegGetContainer_id_d(container_id, 'a55_d', '', 'a55_d');
		var container_id_eidi = pegGetContainer_id_d(container_id, 'a55_d3', '', 'a55_d');
		var container_id_stoixeia = pegGetContainer_id_d(container_id, 'a55_d4', '', 'a55_d');
		var container_id_lp_stoixeia = pegGetContainer_id_d(container_id, 'a55_d5', '', 'a55_d');
		var container_id_fpa = pegGetContainer_id_d(container_id, 'a55_d6', '', 'a55_d');
		var container_id_memo = pegGetContainer_id_d(container_id, 'a55_d7', '', 'a55_d');
		var container_id_totals    = pegGetContainer_id_d(container_id, 'a55_d9', '', 'a55_d');
	}

	if (mode == 'a56') {
		var container_id_main = pegGetContainer_id_d(container_id, 'a56_d', '', 'a56_d');
		var container_id_eidi = pegGetContainer_id_d(container_id, 'a56_d3', '', 'a56_d');
		var container_id_stoixeia = pegGetContainer_id_d(container_id, 'a56_d4', '', 'a56_d');
		var container_id_lp_stoixeia = pegGetContainer_id_d(container_id, 'a56_d5', '', 'a56_d');
		var container_id_fpa = pegGetContainer_id_d(container_id, 'a56_d6', '', 'a56_d');
		var container_id_memo = pegGetContainer_id_d(container_id, 'a56_d7', '', 'a56_d');
		var container_id_totals    = pegGetContainer_id_d(container_id, 'a56_d9', '', 'a56_d');
	}

	if (mode == 'a57') {
		var container_id_main = pegGetContainer_id_d(container_id, 'a57_d', '', 'a57_d');
		var container_id_eidi = pegGetContainer_id_d(container_id, 'a57_d2', '', 'a57_d');
		var container_id_stoixeia = pegGetContainer_id_d(container_id, 'a57_d3', '', 'a57_d');
		var container_id_lp_stoixeia = pegGetContainer_id_d(container_id, 'a57_d4', '', 'a57_d');
		var container_id_fpa = pegGetContainer_id_d(container_id, 'a57_d5', '', 'a57_d');
		var container_id_memo = pegGetContainer_id_d(container_id, 'a57_d6', '', 'a57_d');
		var container_id_totals    = pegGetContainer_id_d(container_id, 'a57_d9', '', 'a57_d');
	}

	if (mode == 'a67') {
		var container_id_main = pegGetContainer_id_d(container_id, 'a67_d', '', 'a67_d');
		var container_id_eidi = pegGetContainer_id_d(container_id, 'a67_d2', '', 'a67_d');
		var container_id_stoixeia = pegGetContainer_id_d(container_id, 'a67_d3', '', 'a67_d');
		var container_id_lp_stoixeia = pegGetContainer_id_d(container_id, 'a67_d4', '', 'a67_d');
		var container_id_fpa = pegGetContainer_id_d(container_id, 'a67_d5', '', 'a67_d');
		var container_id_totals    = pegGetContainer_id_d(container_id, 'a67_d9', '', 'a67_d');
	}

	var container_id_stoixeia_diakinisis = pegGetContainer_id_d(container_id, mode+'_d8', '', mode+'_d');

	params = {};
	params.p01 = pegGetVal('p01', container_id_main);
	params.p02 = pegGetVal('p02', container_id_main);
	params.p03 = pegGetVal('p03', container_id_main);
	params.p04 = pegGetVal('p04', container_id_main);
	params.p05 = pegGetVal('p05', container_id_main);
	params.p415 = pegGetVal('p415', container_id_lp_stoixeia);
	params.p416 = pegGetVal('p416', container_id_lp_stoixeia);
	params.nr01 = pegGetVal('nr01', container_id_main);
	params.p506 = pegGetVal('p506', container_id_stoixeia);
	params.p703 = pegGetVal('p703', container_id_stoixeia);
	params.p0121 = pegGetVal('p0121', container_id_stoixeia);
	params.mode = mode;
	params.container_id = container_id_main;
	if (invoices_p03_change_ajax != '') {
		if (invoices_p03_change_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(invoices_p03_change_ajax);
		}
	}

	invoices_p03_change_ajax = pegAjaxDefer('/' + main_path + '/invoices01/find_p03_data.php', params, function (jsondata) {

		pegSetVal('p07', container_id_stoixeia, jsondata.p07); //Tιμες με ΦΠΑ
        pegSetVal('p016', container_id_stoixeia, {'value': jsondata.p016, 'display':jsondata.p016_display}); //Πωλητης
        pegSetVal('p017', container_id_stoixeia, jsondata.p017); //Τρ.μεταφορας
        pegSetVal('p09', container_id_stoixeia, {'value': jsondata.p09, 'display':jsondata.p09_display}); //Κωδ. καθεστως ΦΠΑ
        pegSetVal('p704', container_id_stoixeia, jsondata.p704);  //Δεν ενημερωνει πόντους
		pegSetVal('p705', container_id_stoixeia, 0);
		pegSetVal('p706c'  , container_id_stoixeia , {'value': jsondata.p706c, 'display':jsondata.p706c_display}); //Διαταξη απαλαγης ΦΠΑ
        pegSetVal('p707'   , container_id_stoixeia , jsondata.p707);    // ΑΡ.Φορολογικης καρτας
        pegSetVal('vp506_2', container_id_stoixeia , jsondata.vp506_2); // Ποντοι
        pegSetVal('p506', container_id_stoixeia , jsondata.p506); // Δωροεπιταγή

        pegSetVal('p412', container_id_lp_stoixeia, jsondata.p412);  // Πιστωτικό Οριο Πελατη
        pegSetVal('p411', container_id_lp_stoixeia, jsondata.p411);  // Προηγούμενο Υπόλοιπο Πελάτη
        pegSetVal('p417', container_id_lp_stoixeia, jsondata.p417);  // Προηγούμενο Τοπικό Υπόλοιπο
        pegSetVal('p413', container_id_lp_stoixeia, jsondata.p413);  // Νέο Υπόλοιπο Πελάτη
        pegSetVal('p418', container_id_lp_stoixeia, jsondata.p418);  // Νέο Τοπικό Υπόλοιπο 
        pegSetVal('p0101', container_id_totals, jsondata.p0101);     // % Εκπτωσης  στο σύνολο
        pegSetVal('p0112', container_id_totals, jsondata.p0112);     // % Εκπτωσης  στο σύνολο
        pegSetVal('p0113', container_id_totals, jsondata.p0113);     // %Κράτησης 
		pegSetVal('p805', container_id_stoixeia, jsondata.p805);	 // Δεν υπολογίζει Εισφορά Ανακύκλωσης
		if(jsondata.dlvstreet !== undefined) {
			// Παράδοση
			pegSetVal('dlvstreet', container_id_stoixeia_diakinisis, jsondata.dlvstreet);	// Οδός
			pegSetVal('dlvnumber', container_id_stoixeia_diakinisis, jsondata.dlvnumber);	// Αριθμός
			pegSetVal('dlvzip',    container_id_stoixeia_diakinisis, jsondata.dlvzip);		// Τ.Κ.
			pegSetVal('dlvcity',   container_id_stoixeia_diakinisis, jsondata.dlvcity);		// Πόλη
			pegSetVal('cs_branch', container_id_stoixeia_diakinisis, jsondata.cs_branch);	// Εγκατάσταση ολοκλήρωσης διακίνησης
		}
		if(jsondata.ldstreet !== undefined) {
			// Φόρτωση
			pegSetVal('ldstreet', container_id_stoixeia_diakinisis,  jsondata.ldstreet);	// Οδός
			pegSetVal('ldnumber', container_id_stoixeia_diakinisis,  jsondata.ldnumber);	// Αριθμός
			pegSetVal('ldzip',    container_id_stoixeia_diakinisis,  jsondata.ldzip);		// Τ.Κ.
			pegSetVal('ldcity',   container_id_stoixeia_diakinisis,  jsondata.ldcity);		// Πόλη
			pegSetVal('ss_branch', container_id_stoixeia_diakinisis, jsondata.ss_branch);	// Εγκατάσταση έναρξης διακίνησης
		}


		//if (mode == 'a67') {
		//	pegSetVal('vp0101', container_id_eidi, jsondata.p0101);
		//}
		
		if (jsondata.p30) {
			//pegSetVal('p30', container_id_memo, jsondata.p30);
			pegToast( jsondata.p30, 'info');
		}

		if (mode == 'a55' || mode == 'a56') {
			pegSetVal('p015', container_id_main, {'value': jsondata.p015, 'display':jsondata.p015_display});   // Τρ.εισπαραξης 
		} else {
			pegSetVal('p015', container_id_stoixeia, {'value': jsondata.p015, 'display':jsondata.p015_display});   // Τρ.εισπαραξης 
		}

		if (jsondata.clear_p04 == 1) {
			pegSetVal('p04', container_id_main, '');   //Υποκαταστημα
		}

		let p05_changed = false;
        if (jsondata.p05) {
            pegSetVal('p05', container_id_main, jsondata.p05); // Είδος παραστατικου
            p05_changed = true;
        }

		pegSetFieldHidden('p04', container_id_main, jsondata.p04_hidden); //Υποκαταστημα
	
        //Επανεύρεση των στοιχείων του παραστατικού
        if(p05_changed == false) {
            invoices_find_invoice_data(container_id, mode);
        } else {
			// Αν μπει στο πάνω if θα τα ενημερώσει από την find_invoice_data
			pegSetVal('p013', container_id_stoixeia, jsondata.p013);     // Από 
        	pegSetVal('p014', container_id_stoixeia, jsondata.p014);     // Προς
		}
	});
}

function invoices_change_product_v103(container_id, mode) {
	//0906fretail Delete unused container ids
	//0906fretail Add retail00_01 mode
	if (mode == 'a55' || mode == 'a56' || mode == 'a60') {
		var screen_container_id00 = pegGetContainer_id_d(container_id, 'i01_d101', '', 'i01_d101');
	} else {
		if (mode == 'retail00_01') {
			var parent_d = 'retail00_01_d';
			var retail00_01_d_container_id   = pegGetContainer_id_d(container_id , 'retail00_01_d'   , '' , parent_d );
			if(!retail00_01_d_container_id) {
				parent_d = 'retail00_02_d';
			}
			var screen_container_id00 = pegGetContainer_id_d(container_id, 'retail00_01_d03', '', parent_d);
		} else if (mode == 'a67') {
			var screen_container_id00 = pegGetContainer_id_d(container_id, 'a68_d00', '', 'a68_d');
		} else if (mode == 'a61') {
			var screen_container_id00 = pegGetContainer_id_d(container_id, 'a62_d00', '', 'a62_d');
		} else {
			var screen_container_id00 = pegGetContainer_id_d(container_id, 'a58_d00', '', 'a58_d');
		}
	}
	
	// Σχέση Πρωτευουσας-Δευτερεύουσας ΜΜ
	//0906fretail Add mode retail (sto if)
	var v_i00_p201 = pegGetVal('v_i00_p201', screen_container_id00); 
	if (mode == 'a55' || mode == 'a56' || mode == 'a60' || mode == 'retail00_01') {
		var p03  = pegGetVal('p03',  screen_container_id00);
		var p030 = pegGetVal('p030', screen_container_id00);
		//Δε θέλω να ενημερωνω τη Δευτερευουσα Ποσοτητα οταν αλλαζει η Ποσοτητα
		//Εαν η Δευτερευουσα Ποσοτητα ΔΕΝ ειναι μηδενική κι εχω Σχεση ΜΜ, δεν επιτρεπω αλλαγή Ποσότητας, την υπολογίζω με βαση τη ΔΜΜ/Σχεση ΜΜ.
		if(v_i00_p201>0 && p030>0){ 
			p03 = p030*v_i00_p201;
			pegSetVal('p03', screen_container_id00, p03);
		}

		//pegAlert('p03:' + pegGetVal('p03' , screen_container_id00) + ' v_i00_p201 ' +pegGetVal('v_i00_p201' , screen_container_id00) );

	} else {
		var v103 = pegGetVal('v103', screen_container_id00);
		var v120 = pegGetVal('v120', screen_container_id00);

		//Δε θέλω να ενημερωνω τη Δευτερευουσα Ποσοτητα οταν αλλαζει η Ποσοτητα
		//Εαν η Δευτερευουσα Ποσοτητα ΔΕΝ ειναι μηδενική κι εχω Σχεση ΜΜ, δεν επιτρεπω αλλαγή Ποσότητας, την υπολογίζω με βαση τη ΔΜΜ/Σχεση ΜΜ.
		if(v_i00_p201>0 && v120>0){ 
			v103 = v120*v_i00_p201;
			pegSetVal('v103', screen_container_id00, v103);
		}

		var v_rest = pegGetCmp(screen_container_id00, 'v_rest');
		if(v_rest){
			pegSetVal(
				'v_rest',
				screen_container_id00,
			pegGetVal('v103', screen_container_id00) - pegGetVal('v109', screen_container_id00));
		}
	}
}

function invoices_change_product_v120(container_id, mode) {
	//0906fretail -- Svinoume container ids pou den xrhsimopoiountai
	//0906fretail -- Add mode retail00_01
	if (mode == 'a55' || mode == 'a56' || mode == 'a60') {
		var screen_container_id00 = pegGetContainer_id_d(container_id, 'i01_d101', '', 'i01_d101');
	} else {
		if (mode == 'retail00_01') {
			var parent_d = 'retail00_01_d';
			var retail00_01_d_container_id   = pegGetContainer_id_d(container_id , 'retail00_01_d'   , '' , parent_d );
			if(!retail00_01_d_container_id) {
				parent_d = 'retail00_02_d';
			}
			var screen_container_id00 = pegGetContainer_id_d(container_id, 'retail00_01_d03', '', parent_d);
		} else if (mode == 'a67') {
			var screen_container_id00 = pegGetContainer_id_d(container_id, 'a68_d00', '', 'a68_d');
		} else if (mode == 'a61') {
			var screen_container_id00 = pegGetContainer_id_d(container_id, 'a62_d00', '', 'a62_d');
		} else {
			var screen_container_id00 = pegGetContainer_id_d(container_id, 'a58_d00', '', 'a58_d');
		}

	}

	var v_i00_p201 = pegGetVal('v_i00_p201', screen_container_id00);
	//0906fretail Add mode retail00_01
	if (mode == 'a55' || mode == 'a56' || mode == 'a60' || mode == 'retail00_01') {
		var p03  = pegGetVal('p03',  screen_container_id00);
		var p030 = pegGetVal('p030', screen_container_id00);
		if(v_i00_p201>0){
			p03 = p030*v_i00_p201;
		}
		pegSetVal('p03', screen_container_id00, p03);
	} else {
		var v103 = pegGetVal('v103', screen_container_id00);
		var v120 = pegGetVal('v120', screen_container_id00);
		if(v_i00_p201>0){
			v103 = v120*v_i00_p201;
		}
		pegSetVal('v103', screen_container_id00, v103);
	}
}

var invoices_p08_change_ajax = '';
function invoices_p08_change(container_id, mode, new_p08) {
	let prefix = '';
	if (mode == 'a55') {
		var container_d = pegGetContainer_id_d(container_id, 'a55_d', '', 'a55_d');
		var container_d4 = pegGetContainer_id_d(container_id, 'a55_d4', '', 'a55_d');

	} else if (mode == 'a56') {
		var container_d = pegGetContainer_id_d(container_id, 'a56_d', '', 'a56_d');
		var container_d4 = pegGetContainer_id_d(container_id, 'a56_d4', '', 'a56_d');

	} else if (mode == 'a60') {
		var container_d  = pegGetContainer_id_d(container_id, 'a60_d',  '', 'a60_d');
		var container_d4 = pegGetContainer_id_d(container_id, 'a60_d3', '', 'a60_d');

	} else if (mode == 'retail00_01') {
		var parent_d = 'retail00_01_d';
		var retail00_01_d_container_id   = pegGetContainer_id_d(container_id , 'retail00_01_d'   , '' , parent_d );
		if(!retail00_01_d_container_id) {
			parent_d = 'retail00_02_d';
		}
		var container_d  = pegGetContainer_id_d(container_id, 'retail00_01_d04', '', parent_d);
		var container_d4 = pegGetContainer_id_d(container_id, 'retail00_01_d04', '', parent_d);
		prefix = 'a55';
	}

	var nr01Val  = pegGetVal(prefix + 'nr01',container_d); // ΜΚ Παραστατικού
	var p05Val 	 = pegGetVal(prefix + 'p05', container_d); // Παραστατικό
	var p701Val  = pegGetVal(prefix + 'p701', container_d); // Σειρά
	var p0121Val = pegGetVal(prefix + 'p0121', container_d4); // Κατάστημα
	var p08Val 	 = pegGetVal(prefix + 'p08', container_d4); // Χειρόγραφο


	params = {};
	params.mode  = mode;
	params.p05   = p05Val;
	params.p701  = p701Val;
	params.p0121 = p0121Val;
	params.p08   = p08Val;
	params.nr01  = nr01Val;

	if (invoices_p08_change_ajax != '') {
		if (invoices_p08_change_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(invoices_p08_change_ajax);
		}
	}


	invoices_p08_change_ajax = pegAjaxDefer('/' + main_path + '/invoices01/find_p08_data.php', params, function (jsondata) {


		if(jsondata.change_value == 1){
			pegSetVal(prefix + 'p06',container_id,jsondata['p06']); //Αριθμός
		}

		if (new_p08 == 1 || jsondata.is_master) {
			pegSetFieldReadonly(prefix + 'p06', container_id, false); // Αριθμός
			pegSetFieldReadonly(prefix + 'p01', container_id, false); // Ώρα
			pegSetFieldReadonly(prefix + 'p02', container_id, false); // Ημερομηνία
		} else {
			pegSetFieldReadonly(prefix + 'p06', container_id, true);
			pegSetFieldReadonly(prefix + 'p01', container_id, true);
			pegSetFieldReadonly(prefix + 'p02', container_id, true);
			// KANEI KENEI TIN IMEROMINIUA KAI TIN ORA
			pegSetVal(prefix + 'p01', container_id, '');
			pegSetVal(prefix + 'p02', container_id, '');
		}
	});

}

var invoices_find_product_total_var = '';
function invoices_find_product_total(_d, container_id, a01_nr01, mode) {

	if (invoices_find_product_total_var != '') {
		if (invoices_find_product_total_var.id > 0) {
			Ext.ux.AjaxDefer.abort(invoices_find_product_total_var);
		}
	}
	p05 = 0;
	//0906fretail Add mode retail00_01
	if (mode == 'a55' || mode == 'a56') {
		var screen_container_id   = pegGetContainer_id_d(container_id, 'i01_d10', '', 'i01_d10');
		var screen_container_id00 = pegGetContainer_id_d(container_id, 'i01_d101', '', 'i01_d101');
		var screen_container_id01 = pegGetContainer_id_d(container_id, 'i01_d102', '', 'i01_d102');

		//Βρισκουμαι το parent με την getPeg_screen_parent_container_id για να παίζει και όταν έχει ανοίξει από mobile σε no tab
		let temp_parent_container_id = pegGetCmp(screen_container_id).getPeg_screen_parent_container_id();

		p07      = invoice_get_p07(temp_parent_container_id,mode);
		p616p    = pegGetVal_d('p616p', temp_parent_container_id, mode + '_d', '', mode + '_d');
		mnr01    = pegGetVal_d('nr01', temp_parent_container_id, mode + '_d', '', mode + '_d');
		p05      = pegGetVal_d('p05', temp_parent_container_id, mode + '_d', '', mode + '_d');
		kath_fpa = pegGetVal_d('p09', temp_parent_container_id, mode + '_d4', '', mode + '_d');	
	} else {
		if (mode == 'retail00_01') {
			var parent_d = 'retail00_01_d';
			var retail00_01_d_container_id   = pegGetContainer_id_d(container_id , 'retail00_01_d'   , '' , parent_d );
			if(!retail00_01_d_container_id) {
				parent_d = 'retail00_02_d';
			}
			var screen_container_id   = pegGetContainer_id_d(container_id, 'retail00_01_d03', '', parent_d);
			var parastatiko_container_id = pegGetContainer_id_d(container_id, 'retail00_01_d04', '', parent_d);
			var pelatis_container_id = pegGetContainer_id_d(container_id, 'retail00_01_d02', '', parent_d);
			
			p07      = invoice_get_p07(parastatiko_container_id, mode);
			p616p    = pegGetVal('p616p', screen_container_id);
			mnr01    = pegGetVal('a55nr01', parastatiko_container_id);
			p05    	 = pegGetVal('a55p05', parastatiko_container_id);
			kath_fpa = pegGetVal('a01p45', pelatis_container_id);
		} else if (mode == 'a67') {
			var screen_container_id = pegGetContainer_id_d(container_id, 'a68_d', '', 'a68_d');
			var screen_container_id00 = pegGetContainer_id_d(container_id, 'a68_d00', '', 'a68_d');
			var screen_container_id01 = pegGetContainer_id_d(container_id, 'a68_d01', '', 'a68_d');

			// var parent_screen = pegGetCmp(pegGetContainer_id_d(container_id, 'a68_d', '', 'a68_d'));

			//Βρισκουμαι το parent με την getPeg_screen_parent_container_id για να παίζει και όταν έχει ανοίξει από mobile σε no tab
			let temp_parent_container_id = pegGetCmp(screen_container_id).getPeg_screen_parent_container_id();			

			p07   = invoice_get_p07(temp_parent_container_id,mode);
			mnr01 = pegGetVal_d('nr01', temp_parent_container_id, 'a67_d', '', 'a67_d');
			p05   = pegGetVal_d('p05', temp_parent_container_id, 'a67_d', '', 'a67_d');
			kath_fpa = pegGetVal_d('p09', temp_parent_container_id, 'a67_d3', '', 'a67_d');
		} else if (mode == 'a61' ) {
			var screen_container_id = pegGetContainer_id_d(container_id, 'a62_d', '', 'a62_d');
			var screen_container_id00 = pegGetContainer_id_d(container_id, 'a62_d00', '', 'a62_d');
			var screen_container_id01 = pegGetContainer_id_d(container_id, 'a62_d01', '', 'a62_d');

			// var parent_screen = pegGetCmp(pegGetContainer_id_d(container_id, 'a62_d', '', 'a62_d'));

			//Βρισκουμαι το parent με την getPeg_screen_parent_container_id για να παίζει και όταν έχει ανοίξει από mobile σε no tab
			let temp_parent_container_id = pegGetCmp(screen_container_id).getPeg_screen_parent_container_id();	

			mnr01 = pegGetVal_d('nr01', temp_parent_container_id, 'a61_d', '', 'a61_d');
			p05   = pegGetVal_d('p05', temp_parent_container_id, 'a61_d', '', 'a61_d');//0; //Το βγαζω για να μην χρειαστει να κανω update το findproduct_total
			p07 = 0;
			kath_fpa = 0;
		} else if (mode == 'a60' ) {
			var screen_container_id   = pegGetContainer_id_d(container_id, 'i01_d10', '', 'i01_d10');
			var screen_container_id00 = pegGetContainer_id_d(container_id, 'i01_d101', '', 'i01_d101');
			var screen_container_id01 = pegGetContainer_id_d(container_id, 'i01_d102', '', 'i01_d102');

			// var parent_screen = pegGetCmp(pegGetContainer_id_d(container_id, 'i01_d10', '', 'i01_d10'));

			//Βρισκουμαι το parent με την getPeg_screen_parent_container_id για να παίζει και όταν έχει ανοίξει από mobile σε no tab
			let temp_parent_container_id = pegGetCmp(screen_container_id).getPeg_screen_parent_container_id();	

			mnr01 = pegGetVal_d('nr01', temp_parent_container_id, 'a60_d', '', 'a60_d');
			p05   = pegGetVal_d('p05', temp_parent_container_id, mode + '_d', '', mode + '_d');// 0; //Το βγαζω για να μην χρειαστει να κανω update το findproduct_total
			p07 = 0;
			kath_fpa = 0;
		} else {
			var screen_container_id = pegGetContainer_id_d(container_id, 'a58_d', '', 'a58_d');
			var screen_container_id00 = pegGetContainer_id_d(container_id, 'a58_d00', '', 'a58_d');
			var screen_container_id01 = pegGetContainer_id_d(container_id, 'a58_d01', '', 'a58_d');

			// var parent_screen = pegGetCmp(pegGetContainer_id_d(container_id, 'a58_d', '', 'a58_d'));

			//Βρισκουμαι το parent με την getPeg_screen_parent_container_id για να παίζει και όταν έχει ανοίξει από mobile σε no tab
			let temp_parent_container_id = pegGetCmp(screen_container_id).getPeg_screen_parent_container_id();	

			p07 = invoice_get_p07(temp_parent_container_id,mode);
			mnr01 = pegGetVal_d('nr01', temp_parent_container_id, 'a57_d', '', 'a57_d');
			p05 = pegGetVal_d('p05', temp_parent_container_id, 'a57_d', '', 'a57_d');
			kath_fpa = pegGetVal_d('p09', temp_parent_container_id, 'a57_d3', '', 'a57_d');
		}
	}

	var ppp_params = {};

	ppp_params = Ext.Object.merge(ppp_params, pegGetFormVal(screen_container_id));

	if(mode != 'retail00_01') {
		ppp_params = Ext.Object.merge(ppp_params, pegGetFormVal(screen_container_id00));
		ppp_params = Ext.Object.merge(ppp_params, pegGetFormVal(screen_container_id01));

		kath_fpa = pegGetVal_d('p09', container_id, mode + '_d', '', mode + '_d');
	}

	ppp_params.mode = mode;
	ppp_params.mnr01 = mnr01;

	ppp_params.kath_fpa = kath_fpa;
	ppp_params.p07 = p07;
	ppp_params.p05Fld = p05;

	invoices_find_product_total_var = pegAjaxDefer('/' + main_path + '/invoices01/find_product_total.php', ppp_params, function (jsondata) {
		pegSetVal('v107', container_id, jsondata.v107);
		
		pegSetVal('v_cs', container_id, jsondata.v_cs);
		pegSetVal('v_lot', container_id, jsondata.v_lot);
		pegSetVal('v_sn', container_id, jsondata.v_sn);

		//0906fretail Add mode retail00_01
		if(mode == 'a55' || mode == 'a56' || mode == 'a60' || mode == 'retail00_01') {
			if (
				jsondata.zero_prices_msg && 
				(
					pegGetVal('p04',  container_id)  != jsondata.v104  ||
					pegGetVal('p616', container_id)  != jsondata.v616  ||
					pegGetVal('p041', container_id)  != jsondata.v1041 ||
					pegGetVal('p042', container_id)  != jsondata.v1042 ||
					pegGetVal('p04_1', container_id) != jsondata.v104_1
				)
			) {
				pegToast(jsondata.zero_prices_msg, 'alert');
			}
			pegSetVal('p616', container_id, jsondata.v616);
			pegSetVal('p04',  container_id, jsondata.v104);
			pegSetVal('p041', container_id, jsondata.v1041);
			pegSetVal('p042', container_id, jsondata.v1042);
			pegSetVal('p04_1', container_id, jsondata.v104_1);
		} else {
			if (
				jsondata.zero_prices_msg && 
				(
					pegGetVal('v104',  container_id)  != jsondata.v104  ||
					pegGetVal('v616',  container_id)  != jsondata.v616  ||
					pegGetVal('v1041', container_id)  != jsondata.v1041 ||
					pegGetVal('v1042', container_id)  != jsondata.v1042 ||
					pegGetVal('v104_1', container_id) != jsondata.v104_1
				)
			) {
				pegToast(jsondata.zero_prices_msg, 'alert');
			}
			pegSetVal('v616',   container_id, jsondata.v616);
			pegSetVal('v104',   container_id, jsondata.v104);
			pegSetVal('v1041',  container_id, jsondata.v1041);
			pegSetVal('v1042',  container_id, jsondata.v1042);
			pegSetVal('v104_1', container_id, jsondata.v104_1);
		}
	}, 'json', 0);
}

var invoices_find_product_quantity_var = '';
/**
 *
 */
function invoices_find_product_quantity(_d, container_id, p03, date, mode, called_from, callback) {

	if (invoices_find_product_quantity_var != '') {
		if (invoices_find_product_quantity_var.id > 0) {
			Ext.ux.AjaxDefer.abort(invoices_find_product_quantity_var);
		}
	}
	//0906fretail -- Remove container ids
	//0906fretail -- Add mode retail
	if (mode == 'a55') {
		// var screen_container_id = pegGetContainer_id_d(container_id, 'i01_d10', '', 'i01_d10');
		var screen_container_id00 = pegGetContainer_id_d(container_id, 'i01_d101', '', 'i01_d10');
		// var screen_container_id01 = pegGetContainer_id_d(container_id, 'i01_d102', '', 'i01_d10');

		var ppp_params = pegGetFormVal_d(container_id, 'i01_d101', '', '', 'i01_d10');
		ppp_params.p01 = pegGetVal_d('p01', container_id, 'i01_d10', '', 'i01_d10');
		ppp_params.i01_nr01 = pegGetVal_d('nr01', container_id, 'i01_d10', '', 'i01_d10');
		ppp_params.a55_nr01 = pegGetVal_d('p06', container_id, 'i01_d10', '', 'i01_d10');
		ppp_params.a55_p03 = pegGetVal_d('p03', container_id, 'a55_d', '', 'a55_d');
		ppp_params.a55_p07 = invoice_get_p07(container_id,mode);
		ppp_params.date = pegGetVal_d('p01', container_id, 'a55_d', '', 'a55_d');
		ppp_params.kath_fpa = pegGetVal_d('p09', container_id, 'a55_d4', '', 'a55_d');
		ppp_params.p05 = pegGetVal_d('p05', container_id, 'a55_d', '', 'a55_d');
	}

	if (mode == 'retail00_01') {
		var parent_d = 'retail00_01_d';
		var retail00_01_d_container_id   = pegGetContainer_id_d(container_id , 'retail00_01_d'   , '' , parent_d );
		if(!retail00_01_d_container_id) {
			parent_d = 'retail00_02_d';
		}
		var screen_container_id00 = pegGetContainer_id_d(container_id, 'retail00_01_d03', '', parent_d);
		var parastatiko_container_id = pegGetContainer_id_d(container_id, 'retail00_01_d04', '', parent_d);
		var pelatis_container_id = pegGetContainer_id_d(container_id, 'retail00_01_d02', '', parent_d);

		var ppp_params 		= pegGetFormVal_d(container_id, 'retail00_01_d03', '', '', parent_d);
		ppp_params.p01 		= pegGetVal('p01', screen_container_id00);
		ppp_params.i01_nr01 = pegGetVal('i01nr01', screen_container_id00);
		ppp_params.a55_nr01 = pegGetVal('p06', parastatiko_container_id);
		ppp_params.a55_p03 	= pegGetVal('a01nr01', pelatis_container_id);
		ppp_params.a55_p07 	= invoice_get_p07(parastatiko_container_id, mode);
		ppp_params.date 	= pegGetVal('a55p01', parastatiko_container_id);
		ppp_params.kath_fpa = pegGetVal('a01p45', pelatis_container_id);
		ppp_params.p05      = pegGetVal('a55p05', parastatiko_container_id);		
		//retail only start
		ppp_params.p03_p48  = pegGetVal('a01p48',  pelatis_container_id);
		ppp_params.p03_p06  = pegGetVal('a01p06',  pelatis_container_id);
		ppp_params.p03_p52  = pegGetVal('a01p52',  pelatis_container_id);
		ppp_params.p03_p52a = pegGetVal('a01p52a', pelatis_container_id);
		ppp_params.p03_p523 = pegGetVal('a01p523', pelatis_container_id);
		//retail only end
	}

	if (mode == 'a56') {
		// var screen_container_id = pegGetContainer_id_d(container_id, 'i01_d10', '', 'i01_d10');
		var screen_container_id00 = pegGetContainer_id_d(container_id, 'i01_d101', '', 'i01_d10');
		// var screen_container_id01 = pegGetContainer_id_d(container_id, 'i01_d102', '', 'i01_d10');

		var ppp_params = pegGetFormVal_d(container_id, 'i01_d101', '', '', 'i01_d10');
		ppp_params.p01 = pegGetVal_d('p01', container_id, 'i01_d10', '', 'i01_d10');
		ppp_params.i01_nr01 = pegGetVal_d('nr01', container_id, 'i01_d10', '', 'i01_d10');
		ppp_params.a56_nr01 = pegGetVal_d('p06', container_id, 'i01_d10', '', 'i01_d10');
		ppp_params.a56_p03 = pegGetVal_d('p03', container_id, 'a56_d', '', 'a56_d');
		ppp_params.a56_p07 = invoice_get_p07(container_id,mode);
		ppp_params.date = pegGetVal_d('p01', container_id, 'a56_d', '', 'a56_d');
		ppp_params.kath_fpa = pegGetVal_d('p09', container_id, 'a56_d4', '', 'a56_d');
		ppp_params.p05 = pegGetVal_d('p05', container_id, 'a56_d', '', 'a56_d');
	}

	if (mode == 'a57') {
		// var screen_container_id = pegGetContainer_id_d(container_id, 'a58_d', '', 'a58_d');
		var screen_container_id00 = pegGetContainer_id_d(container_id, 'a58_d00', '', 'a58_d');
		// var screen_container_id01 = pegGetContainer_id_d(container_id, 'a58_d01', '', 'a58_d');

		var ppp_params = pegGetFormVal_d(container_id, 'a58_d00', '', '', 'a58_d');
		ppp_params.v101 = pegGetVal_d('v101', container_id, 'a58_d', '', 'a58_d');
		ppp_params.a58_nr01 = pegGetVal_d('nr01', container_id, 'a58_d', '', 'a58_d');
		ppp_params.a57_nr01 = pegGetVal_d('p00', container_id, 'a58_d', '', 'a58_d');
		ppp_params.a57_p03 = pegGetVal_d('p03', container_id, 'a57_d', '', 'a57_d');
		ppp_params.a57_p07 = invoice_get_p07(container_id,mode);
		ppp_params.date = pegGetVal_d('p01', container_id, 'a57_d', '', 'a57_d');
		ppp_params.kath_fpa = pegGetVal_d('p09', container_id, 'a57_d3', '', 'a57_d');
		ppp_params.p05 = pegGetVal_d('p05', container_id, 'a57_d', '', 'a57_d');
	}


	if (mode == 'a67') {
		// var screen_container_id = pegGetContainer_id_d(container_id, 'a68_d', '', 'a68_d');
		var screen_container_id00 = pegGetContainer_id_d(container_id, 'a68_d00', '', 'a68_d');
		// var screen_container_id01 = pegGetContainer_id_d(container_id, 'a68_d01', '', 'a68_d');

		var ppp_params = pegGetFormVal_d(container_id, 'a68_d00', '', '', 'a68_d');
		ppp_params.v101 = pegGetVal_d('v101', container_id, 'a68_d', '', 'a68_d');
		ppp_params.a68_nr01 = pegGetVal_d('nr01', container_id, 'a68_d', '', 'a68_d');
		ppp_params.a67_nr01 = pegGetVal_d('p00', container_id, 'a68_d', '', 'a68_d');
		ppp_params.a67_p03 = pegGetVal_d('p03', container_id, 'a67_d', '', 'a67_d');
		ppp_params.a67_p07 = invoice_get_p07(container_id,mode);
		ppp_params.date = pegGetVal_d('p01', container_id, 'a67_d', '', 'a67_d');
		ppp_params.kath_fpa = pegGetVal_d('p09', container_id, 'a67_d3', '', 'a67_d');
		ppp_params.p05 = pegGetVal_d('p05', container_id, 'a67_d', '', 'a67_d');
	}

	if (mode == 'a61') {
		// var screen_container_id = pegGetContainer_id_d(container_id, 'a62_d', '', 'a62_d');
		var screen_container_id00 = pegGetContainer_id_d(container_id, 'a62_d00', '', 'a62_d');
		// var screen_container_id01 = pegGetContainer_id_d(container_id, 'a62_d01', '', 'a62_d');

		var ppp_params = pegGetFormVal_d(container_id, 'a62_d00', '', '', 'a62_d');
		ppp_params.v101 = pegGetVal_d('v101', container_id, 'a62_d', '', 'a62_d');
		ppp_params.a62_nr01 = pegGetVal_d('nr01', container_id, 'a62_d', '', 'a62_d');
		ppp_params.a61_nr01 = pegGetVal_d('p00', container_id, 'a62_d', '', 'a62_d');
		ppp_params.date = pegGetVal_d('p01', container_id, 'a61d', '', 'a61_d');
		ppp_params.p05 = pegGetVal_d('p05', container_id, 'a61_d', '', 'a61_d');
	}


	if (mode == 'a60') {
		// var screen_container_id = pegGetContainer_id_d(container_id, 'i01_d10', '', 'i01_d10');
		var screen_container_id00 = pegGetContainer_id_d(container_id, 'i01_d101', '', 'i01_d10');
		// var screen_container_id01 = pegGetContainer_id_d(container_id, 'i01_d102', '', 'i01_d10');

		var ppp_params = pegGetFormVal_d(container_id, 'i01_d101', '', '', 'i01_d10');
		ppp_params.p01 = pegGetVal_d('p01', container_id, 'i01_d10', '', 'i01_d10');
		ppp_params.i01_nr01 = pegGetVal_d('nr01', container_id, 'i01_d10', '', 'i01_d10');
		ppp_params.a60_nr01 = pegGetVal_d('p06', container_id, 'i01_d10', '', 'i01_d10');
		ppp_params.a60_p03 = pegGetVal_d('p03', container_id, 'a60_d', '', 'a60_d');
		ppp_params.a60_p04 = pegGetVal_d('p04', container_id, 'a60_d', '', 'a60_d');
		ppp_params.date = pegGetVal_d('p01', container_id, 'a60_d', '', 'a60_d');
		ppp_params.p05 = pegGetVal_d('p05', container_id, 'a60_d', '', 'a60_d');
	}
	ppp_params.mode = mode;
	ppp_params.called_from = called_from;
	


	invoices_find_product_quantity_var = pegAjaxDefer('/' + main_path + '/invoices01/find_product_quantity.php', ppp_params, function (jsondata) {

		//0906fretail -- Add mode retail00
		if (mode == 'a55' || mode == 'a56' || mode == 'a60' || mode == 'retail00_01') {
			//Πρέπει η τιμη να σεταριστεί πριν το p03 γιατι το change p03 διαβαζει την τιμη για να βρει το total
			//Είχα θέμα σε ειδος με τεμαχια και ποσοτικη τιμη
			if (jsondata.v104_change == 1) {
				pegSetVal('p04', screen_container_id00, jsondata.v104);
			}
			pegSetVal('p03', screen_container_id00, jsondata.v103);
			pegSetVal('p310', screen_container_id00, jsondata.v310);
			pegSetVal('p030', screen_container_id00, jsondata.v120);

			if (jsondata.v106_change == 1) {
				pegSetVal('p010', screen_container_id00, jsondata.v106);
				pegSetVal('p010a', screen_container_id00, jsondata.v106a);
			}

			// Αν το παραστατικό έχει επιλεγμένες τις [Μηδενικές Τιμές Ειδών] τότε μηδενίζονται τα παρακάτω πεδία
			if(
				jsondata.zero_prices_msg &&
				(
					pegGetVal('p04',  container_id)  != jsondata.v104  ||
					pegGetVal('p616', container_id)  != jsondata.v616  ||
					pegGetVal('p041', container_id)  != jsondata.v1041 ||
					pegGetVal('p042', container_id)  != jsondata.v1042 ||
					pegGetVal('p04_1', container_id) != jsondata.v104_1
				)
			) {
				pegToast(jsondata.zero_prices_msg, "alert");
				pegSetVal('p04',   screen_container_id00, 0); // Τιμή Μονάδας
				pegSetVal('p041',  screen_container_id00, 0); // Εισφορά Ανακύκλωσης
				pegSetVal('p042',  screen_container_id00, 0); // Επιπλέον Αξία
				pegSetVal('p616',  screen_container_id00, 0); // Ε.Φ.Κ.
				pegSetVal('p04_1', screen_container_id00, 0); // Τιμή Συσκευασίας
			}
		}

		if (mode == 'a57' || mode == 'a67' || mode == 'a61') {

			if (jsondata.v104_change == 1) {
				pegSetVal('v104', screen_container_id00, jsondata.v104);
			}
			pegSetVal('v103', screen_container_id00, jsondata.v103);
			pegSetVal('v310', screen_container_id00, jsondata.v310);
			pegSetVal('v120', screen_container_id00, jsondata.v120);
			
			if (jsondata.v106_change == 1) {
				pegSetVal('v106', screen_container_id00, jsondata.v106);
				pegSetVal('v106a', screen_container_id00, jsondata.v106a);
			}

			// Αν το παραστατικό έχει επιλεγμένες τις [Μηδενικές Τιμές Ειδών] τότε μηδενίζονται τα παρακάτω πεδία
			if(
				jsondata.zero_prices_msg && 
				(
					pegGetVal('v104', container_id)   != jsondata.v104  ||
					pegGetVal('v616', container_id)   != jsondata.v616  ||
					pegGetVal('v1041', container_id)  != jsondata.v1041 ||
					pegGetVal('v1042', container_id)  != jsondata.v1042 ||
					pegGetVal('v104_1', container_id) != jsondata.v104_1 
				)
			) {
				pegToast(jsondata.zero_prices_msg, "alert");
				pegSetVal('v104',   screen_container_id00, 0); // Τιμή Μονάδας
				pegSetVal('v1041',  screen_container_id00, 0); // Εισφορά Ανακύκλωσης
				pegSetVal('v1042',  screen_container_id00, 0); // Επιπλέον Αξία
				pegSetVal('v616',   screen_container_id00, 0); // Ε.Φ.Κ.
				pegSetVal('v104_1', screen_container_id00, 0); // Τιμή Συσκευασίας
			}
		}

		pegSetVal('v107', screen_container_id00, jsondata.v107);

		if(typeof callback === 'function') {
			callback(jsondata);
		}
	}, 'json', 1);

}

var invoices_get_product_data_var = '';
function invoices_get_product_data(row, p03, screen_container_id, grid_container_id, date, mode , save_to_db) {
	if (invoices_get_product_data_var != '') {
		if (invoices_get_product_data_var.id > 0) {
			Ext.ux.AjaxDefer.abort(invoices_get_product_data_var);
		}
	}
	let product_tbl = '';
	switch (mode) {
		case 'a57':
			product_tbl = 'a58';
			break;
		case 'a67':
			product_tbl = 'a68';
			break;
		case 'a61':
			product_tbl = 'a62';
			break;
		case 'a55':
		case 'a56':
		case 'a60':
		case 'retail00_01':
		//retail:neo case  	
			product_tbl = 'i01';
			break;
		default:
			product_tbl = '';
			break;
	}


	
	var screen = pegGetCmp(screen_container_id);
	var grid = pegGetCmp(screen.getContainer_ID(), 'grid');

	if(mode == 'retail00_01') {
		var parent_d = 'retail00_01_d';
		var retail00_01_d_container_id   = pegGetContainer_id_d(screen_container_id , 'retail00_01_d'   , '' , parent_d );
		if(!retail00_01_d_container_id) {
			parent_d = 'retail00_02_d';
			retail00_01_d_container_id   = pegGetContainer_id_d(screen_container_id , 'retail00_02_d'   , '' , parent_d );
		}
	}

	let main_screen_container_id = '';
	grid_editing = 0;
	if(grid){
		//console.log(screen);
		main_screen_container_id     = pegGetContainer_id_d(screen_container_id,  mode + '_d', '',  mode + '_d');
		grid_editing = 1;
	}
	else{//retail:edw prepei na paixei xwris allagi

	    
		//console.log(screen);
		let temp_parent_container_id = screen.getPeg_screen_parent_container_id();
		// console.log(temp_parent_container_id);
		if(mode == 'retail00_01') {
			main_screen_container_id 	 = pegGetContainer_id_d(screen_container_id,  parent_d, '',  parent_d);
		}else{
			main_screen_container_id     = pegGetContainer_id_d(temp_parent_container_id,  mode + '_d', '',  mode + '_d');
		}
		
		// console.log(main_screen_container_id);
	}


	var ppp_params = {};
	/*Αν ειναι από παραστατικό Πελάτη ή Προμηθευτή */
	if (mode == 'a55' || mode == 'a56' || mode == 'a60') {
		if (mode == 'a60') {
			kath_fpa = 0;
			ppp_params[mode + '_p805'] = 0;
			ppp_params[mode + '_p07']  = 0;
			ppp_params.p703 = 0;
			ppp_params[mode + '_p03']  = 0;
		} else {
			kath_fpa = pegGetVal_d('p09', main_screen_container_id, mode + '_d4', '', mode + '_d');
			ppp_params[mode + '_p805'] = pegGetVal('p805', invoice_get_container_id_stoixeia(main_screen_container_id, mode));
			ppp_params[mode + '_p07']  = invoice_get_p07(main_screen_container_id,mode);
			ppp_params.p703            = invoice_get_p703(main_screen_container_id,mode);
			ppp_params[mode + '_p03']  = pegGetVal('p03', main_screen_container_id);
		}

		ppp_params[mode + '_p05'] = pegGetVal('p05', main_screen_container_id);
		ppp_params.p05Fld         = pegGetVal('p05', main_screen_container_id);
		date                      = pegGetVal('p01', main_screen_container_id);

		if (grid) {
			var grid_row = pegGridGetSelectedRow(grid.getContainer_ID(), grid.getName(), grid.getMnr01(), grid.getMmnr01());
			ppp_params[product_tbl + '_nr01'] = grid_row.nr01;
			ppp_params[mode + '_nr01'] = pegGetVal('nr01', main_screen_container_id);
			ppp_params['i18' + product_tbl] = grid_row['i18' + product_tbl];
			ppp_params[product_tbl + '_p042'] = grid_row.p042;
		} else {
			//TODO:check if i01_d11, i01_d104
			var screen_container_id     = pegGetContainer_id_d(screen_container_id, 'i01_d10', '', 'i01_d10');
			var screen_container_id00   = pegGetContainer_id_d(screen_container_id, 'i01_d101', 'down', 'i01_d10');
			var color_size_container_id = pegGetContainer_id_d(screen_container_id, 'i01_d102', '', 'i01_d10');
			var serial_container_id     = pegGetContainer_id_d(screen_container_id, 'i01_d103', '', 'i01_d10');
			var notes_container_id     = pegGetContainer_id_d(screen_container_id, 'a90_d00', '', 'i01_d10');

			var lot_container_id     = pegGetContainer_id_d(screen_container_id, 'i01_d104', '', 'i01_d10');

			ppp_params[product_tbl + '_nr01'] = pegGetVal_d('nr01', screen_container_id, 'i01_d10', '', 'i01_d10');
			ppp_params[mode + '_nr01']        = pegGetVal_d('p06', screen_container_id, 'i01_d10', '', 'i01_d10');
			ppp_params['i18' + product_tbl]   = pegGetVal('i18' + product_tbl, screen_container_id00);
			ppp_params[product_tbl + '_p042'] = pegGetVal('p042', screen_container_id00);
		}
	}
	/*Αν ειναι από παραγγελία πελάτη */
	if (mode == 'a57' || mode == 'a67' || mode == 'a61') {
		if (mode == 'a61') {
			kath_fpa = 0;
			ppp_params[mode + '_p805'] = 0;
			ppp_params[mode + '_p03']  = 0;
			ppp_params[mode + '_p07']  = 0;
			ppp_params.p703 = 0;
		} else {
			// var parent_screen = pegGetCmp(pegGetContainer_id_d(screen_container_id, product_tbl + '_d', '', product_tbl + '_d'));
			ppp_params[mode + '_p805'] = pegGetVal('p805', invoice_get_container_id_stoixeia(main_screen_container_id, mode));
			kath_fpa = pegGetVal_d('p09', main_screen_container_id, mode + '_d3', '', mode + '_d');
			//Πελάτης - Προμηθευτής
			ppp_params[mode + '_p03'] = pegGetVal('p03', main_screen_container_id);
			//Τιμές με ΦΠΑ
			ppp_params[mode + '_p07'] = invoice_get_p07(main_screen_container_id, mode);
			//Αποθηκευτικός χώρος
			ppp_params.p703 		  = invoice_get_p703(main_screen_container_id, mode);
		}

		ppp_params.p05Fld 		  = pegGetVal('p05', main_screen_container_id);
		ppp_params[mode + '_p05'] = pegGetVal('p05', main_screen_container_id);
		date = pegGetVal('p01', main_screen_container_id);

		if (grid) {
			var grid_row = pegGridGetSelectedRow(grid.getContainer_ID(), grid.getName(), grid.getMnr01(), grid.getMmnr01());
			ppp_params[product_tbl + '_nr01'] = grid_row.nr01;
			ppp_params[mode + '_nr01']        = pegGetVal('nr01', main_screen_container_id);
			ppp_params['i18' + product_tbl]   = grid_row['i18' + product_tbl];
			ppp_params[product_tbl + '_v1042'] = grid_row.v1042;
		} else {
			var screen_container_id     = pegGetContainer_id_d(screen_container_id, product_tbl + '_d', '', product_tbl + '_d');
			var screen_container_id00   = pegGetContainer_id_d(screen_container_id, product_tbl + '_d00', '', product_tbl + '_d');
			var color_size_container_id = pegGetContainer_id_d(screen_container_id, product_tbl + '_d01', '', product_tbl + '_d');
			var serial_container_id     = pegGetContainer_id_d(screen_container_id, product_tbl + '_d02', '', product_tbl + '_d');
			var lot_container_id     	= pegGetContainer_id_d(screen_container_id, product_tbl + '_d03', '', product_tbl + '_d');
			
			var notes_container_id     = pegGetContainer_id_d(screen_container_id, 'a90_d00', '', product_tbl + '_d');



			ppp_params[product_tbl + '_nr01'] = pegGetVal_d('nr01', screen_container_id, product_tbl + '_d', '', product_tbl + '_d');
			ppp_params[mode + '_nr01']        = pegGetVal_d('p00', screen_container_id, product_tbl + '_d', '', product_tbl + '_d');
			ppp_params['i18' + product_tbl]   = pegGetVal_d('i18' + product_tbl, screen_container_id00, product_tbl + '_d', '', product_tbl + '_d');
			ppp_params[product_tbl + '_v1042'] = pegGetVal('v1042', screen_container_id00);
		}
	}

	if (mode == 'retail00_01') {
		
		kath_fpa 				  = pegGetVal_d('a01p45',  main_screen_container_id, mode + '_d02', '', parent_d);
		ppp_params[mode + '_p03'] = pegGetVal_d('a01nr01', main_screen_container_id, mode + '_d02', '', parent_d); //pelati
		ppp_params[mode + '_p07'] = pegGetVal_d('a55p07',  main_screen_container_id, mode + '_d04', '', parent_d); //FPA h oxi
		ppp_params.p703           = pegGetVal_d('a55p703', main_screen_container_id, mode + '_d04', '', parent_d); //apothikeytikos
		ppp_params.p05Fld         = pegGetVal_d('a55p05',  main_screen_container_id, mode + '_d04', '', parent_d); //parastatiko
		ppp_params[mode + '_p05'] = pegGetVal_d('a55p05',  main_screen_container_id, mode + '_d04', '', parent_d); 
		date                      = pegGetVal_d('a55p01',  main_screen_container_id, mode + '_d04', '', parent_d);
		// ppp_params[mode + '_a55_nr01'] = pegGetVal_d('a55nr01', main_screen_container_id, mode + '_d04', '', parent_d);
		ppp_params[mode + '_nr01'] = pegGetVal_d('a55nr01', main_screen_container_id, mode + '_d04', '', parent_d);
		ppp_params[product_tbl + '_nr01'] = pegGetVal_d('i01nr01', main_screen_container_id, mode + '_d03', '', parent_d);

		ppp_params['p03_p48']  = pegGetVal_d('a01p48',  main_screen_container_id, mode + '_d02', '', parent_d);
		ppp_params['p03_p06']  = pegGetVal_d('a01p06',  main_screen_container_id, mode + '_d02', '', parent_d);
		ppp_params['p03_p52']  = pegGetVal_d('a01p52',  main_screen_container_id, mode + '_d02', '', parent_d);
		ppp_params['p03_p52a'] = pegGetVal_d('a01p52a',  main_screen_container_id, mode + '_d02', '', parent_d);
		ppp_params['p03_p523'] = pegGetVal_d('a01p523',  main_screen_container_id, mode + '_d02', '', parent_d);

		var screen_container_id     = pegGetContainer_id_d(screen_container_id, mode + '_d03', '', parent_d);
		var screen_container_id00   = screen_container_id;

		if(row.return_message){
			ppp_params.return_message = row.return_message;
		}
		
		ppp_params.item_search = row.item_search;
	}

    //retail:gia arxi den tha valw simvasi sto retail to afinoyme os exei
	ppp_params.cona11_nr01 = ''
	if(mode == 'a55') {
		ppp_params.cona11_nr01 = pegGetVal_d('p505', screen_container_id, 'a55_d5', '', 'a55_d');
	}
	if(mode == 'a57') {
		ppp_params.cona11_nr01 = pegGetVal_d('p505', screen_container_id, 'a57_d4', '', 'a57_d');
	}

	//retail:na bgalw to id den exei noima alla na kanw kai mia dokimi
	Ext.getCmp(screen_container_id).mask('');
	
	invoice_set_last_selected_row(row);

	ppp_params.screen_container_id = screen_container_id;

	ppp_params.v101 = row.v101;
	ppp_params.timh1 = row.timh1;
	ppp_params.timh2 = row.timh2;
	ppp_params.timh3 = row.timh3;
	ppp_params.timh4 = row.timh4;
	ppp_params.v172 = row.v172;
	ppp_params.v173 = row.v173;
	ppp_params.v103 = row.v103;
	ppp_params.v104 = row.v104;
	ppp_params.v161 = row.v161;
	ppp_params.ser = row.ser;
	ppp_params.type = row.type;
	ppp_params.code = row.code;
	//ppp_params.p03      = p03;
	//ppp_params.p07      = p07;
	ppp_params.date = date;
	ppp_params.kath_fpa = kath_fpa;
	ppp_params.grid_editing = grid_editing;

	if(save_to_db==1){
		ppp_params.save_to_db = save_to_db;
	}
	//retail: Το πρόσθεσα
	ppp_params.mode = mode;

	/*pegAlert(grid_container_id);*/
	if (Ext.getCmp(grid_container_id)) {
		if (Ext.getCmp(grid_container_id).up()) {
			pegWindowClose(Ext.getCmp(grid_container_id).up().id);
		}
	}
	invoices_get_product_data_var = pegAjaxDefer('/' + main_path + '/invoices01/find_product_data.php', ppp_params, function (jsondata) {
		if (grid) {

			invoices_update_row(mode, screen_container_id, jsondata);

			if (mode == 'a55' || mode == 'a56' || mode == 'a60') {

				//το χρειάζομαι γιατι αλλιώς δεν ενημερώνει το πεδίο που αναζητά
				//(αν το ειδος ειναι μοναδικό) ππυ2048743
				//* 21/11/2023
				//* Αντί να σετάρω το jsondata.v101 σε p01/v101 - grid_p01/grid_v101 - Απλά βγάζω το slash
				//* Οπότε αν έχει έρθει από αναζήτηση να μπορέσει οταν πάει να κάνει commit τη γραμμή, να ξανα-αναζητήσει π.χ. με το barcode όπως αναζήτησε.
				// pegSetVal('p01', screen_container_id, jsondata.v101);
				if(pegGetVal('p01', screen_container_id).at(-1) == '/'){
					pegSetVal('p01', screen_container_id, pegGetVal('p01', screen_container_id).slice(0, -1));
				}else{
					pegSetVal('p01', screen_container_id, pegGetVal('p01', screen_container_id));
				}
				//pegSetVal('p01', screen_container_id, pegGetVal('p01', screen_container_id).replace('/', ''))
				pegSetVal('p02', screen_container_id, jsondata.v102);

				// Αν πατησω / + Εnter γρηγορα μενει ανοιχτο το πεδιο στο grid αν δεν το ενημερωσω μετα μ εχει απλα ενα /
				// pegSetVal('grid_p01', screen_container_id, jsondata.v101);
				if(pegGetVal('grid_p01', screen_container_id).at(-1) == '/'){
					pegSetVal('grid_p01', screen_container_id, pegGetVal('grid_p01', screen_container_id).slice(0, -1));
				}else{
					pegSetVal('grid_p01', screen_container_id, pegGetVal('grid_p01', screen_container_id));
				}
				//pegSetVal('grid_p01', screen_container_id, pegGetVal('grid_p01', screen_container_id).replace('/', ''))
				pegSetVal('grid_p02', screen_container_id, jsondata.v102);
			}
			if (mode == 'a57' || mode == 'a67' || mode == 'a61') {
				//το χρειάζομαι γιατι αλλιώς δεν ενημερώνει το πεδίο που αναζητά
				//(αν το ειδος ειναι μοναδικό) ππυ2048743
				// pegSetVal('v101', screen_container_id, jsondata.v101);
				if(pegGetVal('v101', screen_container_id).at(-1) == '/'){
					pegSetVal('v101', screen_container_id, pegGetVal('v101', screen_container_id).slice(0, -1));
				}else{
					pegSetVal('v101', screen_container_id, pegGetVal('v101', screen_container_id));
				}
				//pegSetVal('v101', screen_container_id, pegGetVal('v101', screen_container_id).replace('/', ''))
				pegSetVal('v102', screen_container_id, jsondata.v102);

				// Αν πατησω / + Εnter γρηγορα μενει ανοιχτο το πεδιο στο grid αν δεν το ενημερωσω μετα μ εχει απλα ενα /
				pegSetVal('grid_v101', screen_container_id, jsondata.v101);
				pegSetVal('grid_v102', screen_container_id, jsondata.v102);
			}
		} else {
			//Metefera tis sysxetiseis twn monadwn prwtes gia na pai3oun
			//swsta ta onchange twn "posotita" kai "deutereuousa posotita"

			if(jsondata.v_p200_en!=1 || jsondata.color_size_en==1 || jsondata.p03_serial==1 || jsondata.p03_lot==1){ 
                jsondata.v_i00_p201 = 0; 
            }
			//retail: na prostethon ston othoni - OK.
			pegSetVal('v_i00_ths',  screen_container_id00, jsondata.v_i00_ths);
			pegSetVal('v_i00_p200', screen_container_id00, jsondata.v_i00_p200);
			pegSetVal('v_i00_p201', screen_container_id00, jsondata.v_i00_p201);

			if (mode == 'a55' || mode == 'a56' || mode == 'a60' || mode == 'retail00_01') { //retail: na prosthesw to mode toy retail
				//Από φακό πρέπει να γίνεται set αυτό και να σταματάμε να ξανατρέχει το change του είδους
				invoice_set_search_item_value_onchange_pause(true);
				pegSetVal('v_i00', screen_container_id, jsondata.v101);
				invoice_set_search_item_value_onchange_pause(false);

				pegSetVal('p01', screen_container_id, jsondata.v101);
				pegSetVal('p09', screen_container_id, jsondata.i01_p09);

				pegSetVal('p02', screen_container_id00, jsondata.v102);
				pegSetVal('p0601', screen_container_id00, jsondata.v160);
				pegSetVal('p030', screen_container_id00, jsondata.v120);
				pegSetVal('p301', screen_container_id00, jsondata.v301);
				pegSetVal('p302', screen_container_id00, jsondata.v302);
				pegSetVal('p303', screen_container_id00, jsondata.v303);
				pegSetVal('p304', screen_container_id00, jsondata.v304);
				pegSetVal('p306', screen_container_id00, jsondata.v306);
				pegSetVal('p307', screen_container_id00, jsondata.v307);
				pegSetVal('p04', screen_container_id00, jsondata.v104);
				pegSetVal('p08', screen_container_id00, jsondata.fpa);
				pegSetVal('p081', screen_container_id00, jsondata.kfpa);
				pegSetVal('p010', screen_container_id00, jsondata.v106);
				pegSetVal('p010a', screen_container_id00, jsondata.v106a);
				pegSetVal('p041', screen_container_id00, jsondata.v1041);
				pegSetVal('p616', screen_container_id00, jsondata.v616);
				pegSetVal('p616p', screen_container_id, jsondata.p616p);
				pegSetVal('p309', screen_container_id00, jsondata.v309);
				pegSetVal('p308', screen_container_id00, jsondata.v308);
				pegSetVal('p614', screen_container_id00, jsondata.v614);
				
				pegSetVal('v_a90_p30', notes_container_id, jsondata.v_a90_p30);

				if(mode == 'retail00_01') {
					pegSetVal('i01nr01', screen_container_id00, jsondata.i01_nr01);
				}

				pegSetVal('p030', screen_container_id00, 0);
				if (jsondata.v103 > 0) {
					pegSetVal('p03', screen_container_id00, jsondata.v103);
				} else {
					pegSetVal('p03', screen_container_id00, 0);

					//retail: set active tab idous
					if(mode == 'retail00_01' && save_to_db == 1) {
						pegGetCmp(main_screen_container_id + '_tabs_1').setActiveTab(Ext.getCmp(screen_container_id).up().id);
					}
				}
				if (jsondata.v120 > 0) {
					pegSetVal('p030', screen_container_id00, jsondata.v120);
				}
			}
			if (mode == 'a57' || mode == 'a67' || mode == 'a61') {
				//Από φακό πρέπει να γίνεται set αυτό και να σταματάμε να ξανατρέχει το change του είδους
				invoice_set_search_item_value_onchange_pause(true);
				pegSetVal('v_i00', screen_container_id, jsondata.v101);
				invoice_set_search_item_value_onchange_pause(false);

				pegSetVal('v101', screen_container_id, jsondata.v101);

				pegSetVal('v102', screen_container_id00, jsondata.v102);
				pegSetVal('v160', screen_container_id00, jsondata.v160);
				pegSetVal('v120', screen_container_id00, jsondata.v120);
				pegSetVal('v301', screen_container_id00, jsondata.v301);
				pegSetVal('v302', screen_container_id00, jsondata.v302);
				pegSetVal('v303', screen_container_id00, jsondata.v303);
				pegSetVal('v304', screen_container_id00, jsondata.v304);
				pegSetVal('v306', screen_container_id00, jsondata.v306);
				pegSetVal('v307', screen_container_id00, jsondata.v307);
				pegSetVal('v104', screen_container_id00, jsondata.v104);
				pegSetVal('v105', screen_container_id00, jsondata.fpa);
				pegSetVal('v108', screen_container_id00, jsondata.kfpa);
				pegSetVal('v106', screen_container_id00, jsondata.v106);
				pegSetVal('v106a', screen_container_id00, jsondata.v106a);
				pegSetVal('v1041', screen_container_id00, jsondata.v1041);
				pegSetVal('v616', screen_container_id00, jsondata.v616);
				pegSetVal('p616p', screen_container_id, jsondata.p616p);
				pegSetVal('v309', screen_container_id00, jsondata.v309);
				pegSetVal('v308', screen_container_id00, jsondata.v308);
				pegSetVal('v614', screen_container_id00, jsondata.v614);

				pegSetVal('v_a90_p30', notes_container_id, jsondata.v_a90_p30);


				pegSetVal('v103', screen_container_id00, 0);
				pegSetVal('v120', screen_container_id00, 0);
				if (jsondata.v103 > 0) {
					pegSetVal('v103', screen_container_id00, jsondata.v103);
				}
				if (jsondata.v120 > 0) {
					pegSetVal('v120', screen_container_id00, jsondata.v120);
				}
			}
			pegSetVal('v107', screen_container_id00, jsondata.v107);

			pegSetVal('timh1', screen_container_id00, jsondata.timh1);
			pegSetVal('timh2', screen_container_id00, jsondata.timh2);
			pegSetVal('timh3', screen_container_id00, jsondata.timh3);
			pegSetVal('timh4', screen_container_id00, jsondata.timh4);

			/* ftiaxnei tiw perigrafes */
			if (mode == 'a55' || mode == 'a56' || mode == 'a60' || mode == 'retail00_01') {//retail: na prosthesw to mode toy retail
				if (jsondata.i18i01 > 0) {
					pegSetFieldReadonly('p01', screen_container_id, true);
					pegSetFieldReadonly('v_i00', screen_container_id, true);
					// pegSetFieldReadonly('p02', screen_container_id, true);
				} else {
					pegSetFieldReadonly('p01', screen_container_id, false);
					pegSetFieldReadonly('v_i00', screen_container_id, false);
					// pegSetFieldReadonly('p02', screen_container_id, false);
				}
			} else {
				if (jsondata.i18a58 > 0 || jsondata.i18a68 > 0 || jsondata.i18a62 > 0) {
					pegSetFieldReadonly('v101', screen_container_id, true);
					pegSetFieldReadonly('v_i00', screen_container_id, true);
					// pegSetFieldReadonly('v102', screen_container_id, true);
				} else {
					pegSetFieldReadonly('v101', screen_container_id, false);
					pegSetFieldReadonly('v_i00', screen_container_id, false);
					// pegSetFieldReadonly('v102', screen_container_id, false);
				}
			}

			if (jsondata.i24_p101 == 0 &&
				jsondata.i24_p102 == 0 &&
				jsondata.i24_p103 == 0 &&
				jsondata.i24_p104 == 0 &&
				jsondata.i24_p106 == 0 &&
				jsondata.i24_p107 == 0 &&
				jsondata.i24_p108 == 0 &&
				jsondata.i24_p109 == 0 &&
				jsondata.i24_p110 == 0 && 
				jsondata.p03_lot == 0  &&
				jsondata.p03_serial == 0 &&
				jsondata.color_size_en == 0
			) {

				if (mode == 'a55' || mode == 'a56' || mode == 'a60' || mode == 'retail00_01') {//retail: na prosthesw to mode toy retail
					pegSetFieldReadonly('p03', screen_container_id00, false);
					pegSetFieldReadonly('p030', screen_container_id00, false);
				} else {
					pegSetFieldReadonly('v103', screen_container_id00, false);
					pegSetFieldReadonly('v120', screen_container_id00, false);
				}
			} else {
				if (mode == 'a55' || mode == 'a56'|| mode == 'a60' || mode == 'retail00_01') {//retail: na prosthesw to mode toy retail
					pegSetFieldReadonly('p03', screen_container_id00, true);
					pegSetFieldReadonly('p030', screen_container_id00, false);
				} else {
					pegSetFieldReadonly('v103', screen_container_id00, true);
					pegSetFieldReadonly('v120', screen_container_id00, false);
				}
			}

			/* Δεν χρειάζεται να κρύβουμε Ε.Φ.Κ. και Εισφορά Ανακύκλωσης διότι γίνεται έλεγχος από τα τσεκ στις βασικές παραμέτρους και όχι αν έχει τιμή η Εισφορά Ανακύκλωσης και ο Ε.Φ.Κ.*/
			
			// //Ε.Φ.Κ./ Μονάδα
			// if(!(jsondata.v616>0) && !(jsondata.p616p>0)){
			// 	if (mode == 'a55' || mode == 'a56' || mode == 'a60' || mode == 'retail00_01') {//retail: na prosthesw to mode toy retail
			// 		pegSetFieldHidden('p616', screen_container_id00, true);
			// 	} else {
			// 		pegSetFieldHidden('v616', screen_container_id00, true);
			// 	}
			// }else{
			// 	if (mode == 'a55' || mode == 'a56' || mode == 'a60' || mode == 'retail00_01') {//retail: na prosthesw to mode toy retail
			// 		pegSetFieldHidden('p616', screen_container_id00, false);
			// 	} else {
			// 		pegSetFieldHidden('v616', screen_container_id00, false);
			// 	}
			// }

			// //Εισφορά Ανακύκλωσης
			// if(!(jsondata.v1041>0)){
			// 	if (mode == 'a55' || mode == 'a56' || mode == 'a60' || mode == 'retail00_01') {//retail: na prosthesw to mode toy retail
			// 		pegSetFieldHidden('p041', screen_container_id00, true);
			// 	} else {
			// 		pegSetFieldHidden('v1041', screen_container_id00, true);
			// 	}
			// }else{
			// 	if (mode == 'a55' || mode == 'a56' || mode == 'a60' || mode == 'retail00_01') {//retail: na prosthesw to mode toy retail
			// 		pegSetFieldHidden('p041', screen_container_id00, false);
			// 	} else {
			// 		pegSetFieldHidden('v1041', screen_container_id00, false);
			// 	}
			// }

			//Σχέση Μ.Μ., Δευτερευουσα Μ.Μ.
			//Ελεγχος αν ειναι σύνθετη ΜΜ & Έλεγχος εμφανισης Σχέσης ΜΜ
			// if(jsondata.v_p200_en==1 && jsondata.color_size_en!=1 && jsondata.p03_serial!=1 && jsondata.p03_lot!=1){
			if(jsondata.v_i00_p200 != "") {
				if(jsondata.v_i00_p201 > 0) {
					pegSetFieldHidden('v_i00_p201', screen_container_id00, false);
				}

				if (mode == 'a55' || mode == 'a56' || mode == 'a60' || mode == 'retail00_01') {//retail: na prosthesw to mode toy retail
					pegSetFieldHidden('p030', screen_container_id00, false);
					pegSetFieldHidden('v_i00_p200', screen_container_id00, false);
					pegSetFieldHidden('fldcont_left012', screen_container_id00, false);
				} else {
					pegSetFieldHidden('v120', screen_container_id00, false);
					pegSetFieldHidden('v_i00_p200', screen_container_id00, false);
					pegSetFieldHidden('fldcont_v120', screen_container_id00, false);
				}
			}else{
				pegSetFieldHidden('v_i00_p201', screen_container_id00, true);

				if (mode == 'a55' || mode == 'a56' || mode == 'a60' || mode == 'retail00_01') {
					pegSetFieldHidden('p030', screen_container_id00, true);
					pegSetFieldHidden('v_i00_p200', screen_container_id00, true);
					pegSetFieldHidden('fldcont_left012', screen_container_id00, true);
				} else {
					pegSetFieldHidden('v120', screen_container_id00, true);
					pegSetFieldHidden('v_i00_p200', screen_container_id00, true);
					pegSetFieldHidden('fldcont_v120', screen_container_id00, true);
				}
			}

			//Τεμαχια
			if (jsondata.i24_p101 == 1) {
				if (mode == 'a55' || mode == 'a56' || mode == 'a60' || mode == 'retail00_01') {//retail: na prosthesw to mode toy retail
					pegSetFieldHidden('p301', screen_container_id00, false);
					pegSetFieldReadonly('p301', screen_container_id00, false);
				} else {
					pegSetFieldHidden('v301', screen_container_id00, false);
					pegSetFieldReadonly('v301', screen_container_id00, false);
					pegSetFieldHidden('v111', screen_container_id00, false);
				}
			} else {
				if (mode == 'a55' || mode == 'a56' || mode == 'a60' || mode == 'retail00_01') {//retail: na prosthesw to mode toy retail
					pegSetFieldHidden('p301', screen_container_id00, true);
				} else {
					pegSetFieldHidden('v301', screen_container_id00, true);
					pegSetFieldHidden('v111', screen_container_id00, true);
				}
			}

			//mikos
			if (jsondata.i24_p102 == 1) {
				if (mode == 'a55' || mode == 'a56' || mode == 'a60' || mode == 'retail00_01') {//retail: na prosthesw to mode toy retail
					pegSetFieldHidden('p302', screen_container_id00, false);
					pegSetFieldReadonly('p302', screen_container_id00, false);
				} else {
					pegSetFieldHidden('v302', screen_container_id00, false);
					pegSetFieldReadonly('v302', screen_container_id00, false);
				}
			} else {
				if (mode == 'a55' || mode == 'a56' || mode == 'a60' || mode == 'retail00_01') {//retail: na prosthesw to mode toy retail
					pegSetFieldHidden('p302', screen_container_id00, true);
				} else {
					pegSetFieldHidden('v302', screen_container_id00, true);
				}
			}

			//PLATOS
			if (jsondata.i24_p103 == 1) {
				if (mode == 'a55' || mode == 'a56' || mode == 'a60' || mode == 'retail00_01') {//retail: na prosthesw to mode toy retail
					pegSetFieldHidden('p303', screen_container_id00, false);
					pegSetFieldReadonly('p303', screen_container_id00, false);
				} else {
					pegSetFieldHidden('v303', screen_container_id00, false);
					pegSetFieldReadonly('v303', screen_container_id00, false);
				}
			} else {
				if (mode == 'a55' || mode == 'a56' || mode == 'a60' || mode == 'retail00_01') {//retail: na prosthesw to mode toy retail
					pegSetFieldHidden('p303', screen_container_id00, true);
				} else {
					pegSetFieldHidden('v303', screen_container_id00, true);
				}
			}

			//YPSOS
			if (jsondata.i24_p104 == 1) {
				if (mode == 'a55' || mode == 'a56' || mode == 'a60' || mode == 'retail00_01') {//retail: na prosthesw to mode toy retail
					pegSetFieldHidden('p304', screen_container_id00, false);
					pegSetFieldReadonly('p304', screen_container_id00, false);
				} else {
					pegSetFieldHidden('v304', screen_container_id00, false);
					pegSetFieldReadonly('v304', screen_container_id00, false);
				}
			} else {
				if (mode == 'a55' || mode == 'a56' || mode == 'a60' || mode == 'retail00_01') {//retail: na prosthesw to mode toy retail
					pegSetFieldHidden('p304', screen_container_id00, true);
				} else {
					pegSetFieldHidden('v304', screen_container_id00, true);
				}
			}

			//MIKTO VAROS
			if (jsondata.i24_p106 == 1) {
				if (mode == 'a55' || mode == 'a56' || mode == 'a60' || mode == 'retail00_01') {//retail: na prosthesw to mode toy retail
					pegSetFieldHidden('p306', screen_container_id00, false);
					pegSetFieldReadonly('p306', screen_container_id00, false);
				} else {
					pegSetFieldHidden('v306', screen_container_id00, false);
					pegSetFieldReadonly('v306', screen_container_id00, false);
				}
			} else {
				if (mode == 'a55' || mode == 'a56' || mode == 'a60' || mode == 'retail00_01') {//retail: na prosthesw to mode toy retail
					pegSetFieldHidden('p306', screen_container_id00, true);
				} else {
					pegSetFieldHidden('v306', screen_container_id00, true);
				}
			}

			//SYNOLIKH POSOTHTA
			if (jsondata.i24_p107 == 1) {
				if (mode == 'a55' || mode == 'a56' || mode == 'a60' || mode == 'retail00_01') {//retail: na prosthesw to mode toy retail
					pegSetFieldHidden('p307', screen_container_id00, false);
					pegSetFieldReadonly('p307', screen_container_id00, false);
				} else {
					pegSetFieldHidden('v307', screen_container_id00, false);
					pegSetFieldReadonly('v307', screen_container_id00, false);
				}
			} else {
				if (mode == 'a55' || mode == 'a56' || mode == 'a60' || mode == 'retail00_01') {//retail: na prosthesw to mode toy retail
					pegSetFieldHidden('p307', screen_container_id00, true);
				} else {
					pegSetFieldHidden('v307', screen_container_id00, true);
				}
			}

			//EIDOS SYSKEYASIAS
			if (jsondata.i24_p108 == 1) {
				if (mode == 'a55' || mode == 'a56' || mode == 'a60' || mode == 'retail00_01') {//retail: na prosthesw to mode toy retail
					pegSetFieldHidden('p308', screen_container_id00, false);
					pegSetFieldReadonly('p308', screen_container_id00, false);
				} else {
					pegSetFieldHidden('v308', screen_container_id00, false);
					pegSetFieldReadonly('v308', screen_container_id00, false);
				}
			} else {
				if (mode == 'a55' || mode == 'a56' || mode == 'a60' || mode == 'retail00_01') {//retail: na prosthesw to mode toy retail
					pegSetFieldHidden('p308', screen_container_id00, true);
				} else {
					pegSetFieldHidden('v308', screen_container_id00, true);
				}
			}

			//KOLLA
			if (jsondata.i24_p109 == 1) {
				if (mode == 'a55' || mode == 'a56' || mode == 'a60' || mode == 'retail00_01') {//retail: na prosthesw to mode toy retail
					pegSetFieldHidden('p309', screen_container_id00, false);
					pegSetFieldReadonly('p309', screen_container_id00, false);
				} else {
					pegSetFieldHidden('v309', screen_container_id00, false);
					pegSetFieldReadonly('v309', screen_container_id00, false);
				}
			} else {
				if (mode == 'a55' || mode == 'a56' || mode == 'a60' || mode == 'retail00_01') {//retail: na prosthesw to mode toy retail
					pegSetFieldHidden('p309', screen_container_id00, true);
				} else {
					pegSetFieldHidden('v309', screen_container_id00, true);
				}
			}

			//KOLLA
			if (jsondata.i24_p110 == 1) {
				if (mode == 'a55' || mode == 'a56' || mode == 'a60' || mode == 'retail00_01') {//retail: na prosthesw to mode toy retail
					pegSetFieldHidden('p310', screen_container_id00, false);
					pegSetFieldReadonly('p310', screen_container_id00, false);
				} else {
					pegSetFieldHidden('v310', screen_container_id00, false);
					pegSetFieldReadonly('v310', screen_container_id00, false);
				}
			} else {
				if (mode == 'a55' || mode == 'a56' || mode == 'a60' || mode == 'retail00_01') {//retail: na prosthesw to mode toy retail
					pegSetFieldHidden('p310', screen_container_id00, true);
				} else {
					pegSetFieldHidden('v310', screen_container_id00, true);
				}
			}


			//retail: na prosthesw ena megalo if gia to mode=retail  sot else olos o kwdika mexri to (jsondata.show_price_window
			// an einai retail kai exw xrwmamegehos h serila ...  prepei an kanwe active tin othoni toy idoys toast me ton logo kia active to tab toy eidoys  
			if (mode == 'retail00_01') {

				//an exw save_db ki eimai retial kia exvw kai i01_nr01 refreshgrid me elected to nr01
				//peg002_GridRefresh('C230','items_grid',10000923);
				if(save_to_db == 1) {
					retail00_refresh_item_grids(retail00_01_d_container_id, jsondata.i01_nr01);
					retail00_calculate_total(pegGetContainer_id_d(screen_container_id, parent_d, '', parent_d));
				}
				
				
				// if(jsondata.color_size_en == 1) {
				// 	pegToast('Πρέπει να συμπληρώσετε το Χρώμα Μέγεθος του είδους.', 'info');
				// 	pegGetCmp(main_screen_container_id + '_tabs_1').setActiveTab(Ext.getCmp(screen_container_id).up().id);
				// }
				// if(jsondata.serial_en == 1) {
				// 	pegToast('Πρέπει να συμπληρώσετε το Serial του είδους.', 'info');
				// 	pegGetCmp(main_screen_container_id + '_tabs_1').setActiveTab(Ext.getCmp(screen_container_id).up().id);
				// }
				// if(jsondata.lot_en == 1) {
				// 	pegToast('Πρέπει να συμπληρώσετε την Παρτίδα του είδους.', 'info');
				// 	pegGetCmp(main_screen_container_id + '_tabs_1').setActiveTab(Ext.getCmp(screen_container_id).up().id);
				// }
			}
			else {
				if (jsondata.color_size_en == 1 && Ext.getCmp(color_size_container_id)) {
					Ext.getCmp(color_size_container_id).up().enable();
					if (Ext.getCmp(screen_container_id + '_tab')) {
						Ext.getCmp(screen_container_id + '_tab').setActiveTab(Ext.getCmp(color_size_container_id).up().id);
					}
					pegGridRefresh(color_size_container_id, 'grid', 0);
				}
	
				if (jsondata.color_size_en == 0) {
					if (color_size_container_id != '') {
						if (Ext.getCmp(color_size_container_id)) {
							Ext.getCmp(color_size_container_id).up().disable();
						}
					}
				}
				// Check for enable/disable serial tab
				if (jsondata.serial_en == 1 && Ext.getCmp(serial_container_id)) {
					Ext.getCmp(serial_container_id).up().enable();
					if (Ext.getCmp(serial_container_id + '_tab')) {
						Ext.getCmp(screen_container_id + '_tab').setActiveTab(Ext.getCmp(serial_container_id).up().id);
	
					}
					pegGridRefresh(serial_container_id, 'grid', 0);
				}
				if (jsondata.serial_en == 0) {
	
					if (serial_container_id != '') {
						if (Ext.getCmp(serial_container_id)) {
							Ext.getCmp(serial_container_id).up().disable();
						}
					}
				}
				// Check for enable/disable lot tab (***)
				if (jsondata.lot_en == 1 && Ext.getCmp(lot_container_id)) {
					Ext.getCmp(lot_container_id).up().enable();
					if (Ext.getCmp(lot_container_id + '_tab')) {
						Ext.getCmp(screen_container_id + '_tab').setActiveTab(Ext.getCmp(lot_container_id).up().id);
	
					}
					pegGridRefresh(lot_container_id, 'grid', 0);
				}
				if (jsondata.lot_en == 0) {
	
					if (lot_container_id != '') {
						if (Ext.getCmp(lot_container_id)) {
							Ext.getCmp(lot_container_id).up().disable();
						}
					}
				}
				//
				if (jsondata.color_size_en == 0 &&
					jsondata.color_size_en == 0 && mode != 'a60' &&
					Ext.getCmp(screen_container_id00) &&
					Ext.getCmp(screen_container_id + '_tab')) {
					Ext.getCmp(screen_container_id + '_tab').setActiveTab(Ext.getCmp(screen_container_id00).up().id);
				}
			}

		}

		Ext.getCmp(screen_container_id).unmask();
		//retail: na to emfanisoyme kai na kanoyme tis allages poy prepei se proti fasis na mhn paizei em rtail kai na to grapsoyme sta to-do
		//Ελέγχουμε αν θα πρέπει να ανοίξει η οθόνη τελευταία τιμή πώλησης
		if ((jsondata.show_price_window == true && mode != 'retail00_01')
			|| (mode == 'retail00_01' && jsondata.show_price_window == true && jsondata.retail00_show_price_window == 1)
		) {
			let url_params = '';
			for (const [key, value] of Object.entries(jsondata.prc_win_params)) {
				url_params += '&' + key + '=' + value;
			}

			let p03_new = 1, id;
			if (grid) {
				p03_new = jsondata.v103;
			} else {
				if (mode == 'a57' || mode == 'a67' || mode == 'a61') {
					p03_new = pegGetVal('v103', screen_container_id00);
				} else {
					p03_new = pegGetVal('p03', screen_container_id00);
				}
			}

			url_params += '&p03_new=' + p03_new;

			if (grid) {
				url_params += '&grid_edit=1';
				url_params += '&parent_container_id=' + grid.id;
				id = grid.id;
			} else {
				if(mode == 'retail00_01') {
					url_params += '&parent_container_id=' + main_screen_container_id;
					id = main_screen_container_id;
				} else {
					url_params += '&parent_container_id=' + screen_container_id;
					id = screen_container_id;
				}
			}

			if (!pegGetCmp("peg_win_" + id + "_i01_d2_invoices")) {
				pegWindowShow_d('', 'i01_d2', 'invoices',
					"peg_win_" + id + "_i01_d2_invoices", 
					0, 
					url_params, id,
					'', '', '', {mmnr01: screen.getMmnr01(), mnr01: screen.getMnr01()}, false, true, 0, 'tablet');
			}

		}
		if(mode == 'retail00_01') {
			if(jsondata.is_zero_quantity_barcode == 1 && (jsondata.show_price_window != true || jsondata.retail00_show_price_window == 0)) {
				retail00_open_quantity_change(main_screen_container_id);
			} else if(jsondata.v104 == 0  // unit price is 0
				&&  jsondata.retail00_updated_p04 == 0 // and unit price is not updated in db
				&&  jsondata.v103 > 0  // and quantity is > 0 (if v103 > 0 item tab will be focused)
				&& (jsondata.show_price_window != true || jsondata.retail00_show_price_window == 0)) { // and price window from session OR retail specifically is not shown
				retail00_open_unit_price_change(main_screen_container_id);
			}
			invoices_show_stock_screen(screen_container_id00, jsondata.v101, pegGetVal_d('a55p703', main_screen_container_id, mode + '_d04', '', parent_d), jsondata.i01_nr01);
			if(row.return_message == 1 && jsondata.return_msg != '') {
				pegToast(jsondata.return_msg, 'success');
			}
		}
	}, 'json', 0);
}

/**
 *
 * @param {Object} mode = a55 αν πρόκειται για παραστατικό πελάτη
 * @param {Object} nr01 = Ο Μ.Κ. του παραστατικού που θα ακυρώσει
 */
var invoices_cancel_invoice_ajax = '';
function invoices_cancel_invoice(mode, nr01, container_id, id) {

	if (invoices_cancel_invoice_ajax != '') {
		if (invoices_cancel_invoice_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(invoices_cancel_invoice_ajax);
		}
	}
	var params = {};
	params.nr01 = nr01;
	params.mode = mode;
	invoices_cancel_invoice_ajax = pegAjaxDefer('/' + main_path + '/invoices02/check_invoice_cancel.php', params, function (json_data) {
		if (json_data.ok == 1) {
			if (json_data.mode == 'a55') {
				pegConfirmBox('', json_data.message, function (but) {
					if (but == 'yes') {
						pegAddTab_d('', 'a55', 'a55_d', 'invcust', '', 0, '&rec_copy_nr01=' + json_data.nr01 + '&a55_cancel_invoice_nr01=' + json_data.nr01, '', container_id, id);
					}
				});
			}
			if (json_data.mode == 'a56') {
				pegConfirmBox('', json_data.message, function (but) {
					if (but == 'yes') {
						pegAddTab_d('', 'a56', 'a56_d', 'invsupp', '', 0, '&rec_copy_nr01=' + json_data.nr01 + '&a56_cancel_invoice_nr01=' + json_data.nr01, '', container_id, id);
					}
				});
			}
		} else {
			pegAlert(json_data.message);
		}
	});
}

/**
 * @param {Object} mode = a55 αν πρόκειται για παραστατικό πελάτη
 * @param {Object} nr01 = Ο Μ.Κ. του παραστατικού που θα μετασχοιματίσει
 */
var invoices_transform_invoice_ajax = '';
function invoices_transform_invoice(mode, nr01, container_id, id) {

	if (invoices_transform_invoice_ajax != '') {
		if (invoices_transform_invoice_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(invoices_transform_invoice_ajax);
		}
	}
	var params = {};
	params.nr01 = nr01;
	params.mode = mode;
	invoices_cancel_invoice_ajax = pegAjaxDefer('/' + main_path + '/invoices02/check_invoice_transform.php', params, function (json_data) {
		if (json_data.ok == 1) {
			if (json_data.mode == 'a55') {
				pegConfirmBox('', json_data.message, function (but) {
					if (but == 'yes') {
						pegAddTab_d('', 'a55', 'a55_d', 'invcust', '', 0, '&rec_copy_nr01=' + json_data.nr01 + '&a55_transform_invoice_nr01=' + json_data.nr01, '', container_id, id);
					}
				});
			}

			if (json_data.mode == 'a56') {
				pegConfirmBox('', json_data.message, function (but) {
					if (but == 'yes') {
						pegAddTab_d('', 'a56', 'a56_d', 'invsupp', '', 0, '&rec_copy_nr01=' + json_data.nr01 + '&a56_transform_invoice_nr01=' + json_data.nr01, '', container_id, id);
					}
				});
			}
		} else {
			pegAlert(json_data.message);
		}
	});
}

function invoices_search_product(container_id, mode, type, values, on_screen) {

	//retail: neo if gia mode retail00_01  na vrei ta 3 pedia
	if (mode == 'a57') {
		var p03 = pegGetVal_d('p03', container_id, 'a57_d', '', 'a57_d');
		var date = pegGetVal_d('p01', container_id, 'a57_d', '', 'a57_d');
		var nr01 = pegGetVal_d('nr01', container_id, 'a57_d', '', 'a57_d');
	}

	if (mode == 'a55') {
		var p03 = pegGetVal_d('p03', container_id, 'a55_d', '', 'a55_d');
		var date = pegGetVal_d('p01', container_id, 'a55_d', '', 'a55_d');
		var nr01 = pegGetVal_d('nr01', container_id, 'a55_d', '', 'a55_d');
	}

	if (mode == 'a56') {
		var p03 = pegGetVal_d('p03', container_id, 'a56_d', '', 'a56_d');
		var date = pegGetVal_d('p01', container_id, 'a56_d', '', 'a56_d');
		var nr01 = pegGetVal_d('nr01', container_id, 'a56_d', '', 'a56_d');
	}

	if (mode == 'a60') {
		var p03 = '';
		var date = pegGetVal_d('p01', container_id, 'a60_d', '', 'a60_d');
		var nr01 = pegGetVal_d('nr01', container_id, 'a60_d', '', 'a60_d');
	}

	if (mode == 'a61') {
		var p03 = '';
		var date = pegGetVal_d('p01', container_id, 'a61_d', '', 'a61_d');
		var nr01 = pegGetVal_d('nr01', container_id, 'a61_d', '', 'a61_d');
	}

	if (mode == 'a67') {
		var p03 = pegGetVal_d('p03', container_id, 'a67_d', '', 'a67_d');
		var date = pegGetVal_d('p01', container_id, 'a67_d', '', 'a67_d');
		var nr01 = pegGetVal_d('nr01', container_id, 'a67_d', '', 'a67_d');
	}

	if(mode == 'retail00_01') {
		var parent_d = 'retail00_01_d';
		var retail00_01_d_container_id   = pegGetContainer_id_d(container_id , 'retail00_01_d'   , '' , parent_d );
		if(!retail00_01_d_container_id) {
			parent_d = 'retail00_02_d';
		}
		var p03  = pegGetVal_d('a01nr01', container_id, 'retail00_01_d02', '', parent_d);
		var date = pegGetVal_d('a55p01',  container_id, 'retail00_01_d04', '', parent_d);
		var nr01 = pegGetVal_d('a55nr01', container_id, 'retail00_01_d04', '', parent_d);
	}
	/*alert('" .$this->container_id. "');*/
	params = {};

	//retail: tha prosthesoyme kai sta 2 types if gia retail wste an dtivazei thn timi poa to pedio search toy retail
	//retail: Προσωρινά μόνο με κωδικό.
	if (type == 2 || type == 202 || type == 203 || type == 204) {
		if (mode == 'a57' || mode == 'a67' || mode == 'a61') {
			params.name = pegGetVal('v102', container_id);
		} else if (mode == 'retail00_01') {
			params.name = pegGetVal('item_search', container_id);
		} else {
			params.name = pegGetVal('p02', container_id);
		}

	} else if (type == 3) {
		if (mode == 'retail00_01') {
			params.exact_i00 = values.code;
			if(values.color && values.size) {
				params.color = values.color;
				params.size  = values.size;
			}
			if(values.v104) {
				params.v104 = values.v104;
			}
			if(values.v103) {
				params.v103 = values.v103;
			}
		}
	} else {
		if (mode == 'a57' || mode == 'a67' || mode == 'a61') {
			params.code = pegGetVal('v101', container_id);
		} else if (mode == 'retail00_01') {
			params.code = pegGetVal('item_search', container_id);
		} else {
			params.code = pegGetVal('p01', container_id);
		}
	}

	if(on_screen == 1) {
		if(type == 1) {
			params.code = pegGetVal('item_search', container_id);
		}else if(type == 2 || type == 202 || type == 203 || type == 204) {
			params.name = pegGetVal('item_search', container_id);
		}
	}

	params.type = 1;
	params.mode = mode;
	params.nr01 = nr01;
	params.container_id = container_id;
	params.fld_search = pegGetVal('fld_search', container_id);
	params.p03 = p03;
	params.date = date;
	params.s_value = pegGetVal('s_value', container_id);

	if (pegGetFramework() == 'peg002') {
		Ext.getCmp(container_id).mask('');
	} else {
		Ext.getCmp(container_id).mask(dic_mask_msg);
	}
	pegAjax('/' + main_path + '/invoices01/find_products.php', params, function (jsondata) {
		if((type == 2 || type == 202 || type == 203 || type == 204) && params.name) {
			//params.name = params.name.replace('/', '');
			if(params.name.at(-1) == '/'){
				params.name = params.name.slice(0, -1);
			}
		}

		if(type == 1 && params.code) {
			//params.code = params.code.replace('/', '');
			if(params.code.at(-1) == '/'){
				params.code = params.code.slice(0, -1);
			}
		}

		if(typeof(carwash_add_a01_and_i00) === "function" && jsondata.carwash01_nr01){
			carwash_add_a01_and_i00(container_id, jsondata.carwash01_nr01, jsondata.a01, jsondata.dc0001, 0);
		    pegSetVal('item_search', container_id, '');
			Ext.getCmp(container_id).unmask();
			return;
		}

		if(jsondata.name) {
			pegSetVal('item_search', container_id, jsondata.name);
			pegSetVal('fld_search', container_id, jsondata.fld_search);
		}

		if(((
			 mode == 'retail00_01' && parent_d == 'retail00_02_d' && jsondata.count > 0 && !values.is_std_action)
			 || on_screen == 1 && jsondata.count > 0)
			 && !values.is_ecr // Αν είμαι απο Ταμειακή, δεν θέλω να μπει εδώ.
		) {
			let grid_id = 'grid';
			pegGridRefresh(container_id, grid_id);
			Ext.getCmp(container_id).unmask();
			return;
		}

		if (jsondata.count == 0) {
			//retail: den prepei an mpei oyte sto if oute sto else giati anazita me ENTER
			if (type == 2 || type == 202 || type == 203 || type == 204) {
				if (mode == 'a55' || mode == 'a56' || mode == 'a60') {
					//pegSetVal('p02', container_id, params.name.replace('/', ''));
					if(params.name.at(-1) == '/'){
						pegSetVal('p02', container_id, params.name.slice(0, -1));
					}else{
						pegSetVal('p02', container_id, params.name);
					}
				} else {
					//pegSetVal('v102', container_id, params.name.replace('/', ''));
					if(params.name.at(-1) == '/'){
						pegSetVal('v102', container_id, params.name.slice(0, -1));
					}else{
						pegSetVal('v102', container_id, params.name);
					}
				}
			} else {
				if (mode == 'a55' || mode == 'a56' || mode == 'a60') {
					//pegSetVal('p01', container_id, params.code.replace('/', ''));
					if(params.code.at(-1) == '/'){
						pegSetVal('p01', container_id, params.code.slice(0, -1));
					}else{
						pegSetVal('p01', container_id, params.code);
					}
				} else {
					//pegSetVal('v101', container_id, params.code.replace('/', ''));
					if(params.code.at(-1) == '/'){
						pegSetVal('v101', container_id, params.code.slice(0, -1));
					}else{
						pegSetVal('v101', container_id, params.code);
					}
				}
			}

			pegGridRefresh(container_id, 'grid');
			
			// Αλλαγή πάντα να βγάζει toast
			pegToast(jsondata.message, 'alert');

			// if (pegGetCmp(container_id).name == 'grid' || (mode == 'retail00_01' && on_screen != 1)) {//retail: Na bgaloyme toast kai to retail na mpei sto if
			// 	pegToast(jsondata.message, 'alert');
			// } else {
			// 	pegAlert(jsondata.message);
			// }

			Ext.getCmp(container_id).unmask();
			return;
		}


		//retail 15/05 να διαγραφω το πεδιο αναζητηση ανα εφερε αποτελσματαρα
		if(mode == 'retail00_01' && jsondata.count > 0) {
			pegSetVal('item_search', container_id, '');
		}

		if (jsondata.count > 1) {
			invoice_show__invoices_find_product_d(container_id, params);

			Ext.getCmp(container_id).unmask();
			return;
		}

		if (jsondata.count == 1) {
			//retail: edw an eimai retail to leme na kanei save
			let save_to_db = 0;
			if(mode == 'retail00_01') {
				save_to_db = 1;
			}

			Ext.getCmp(container_id).unmask();
			if (values && values.return_message) {
				jsondata.data[0].return_message = values.return_message;
			}
			invoices_get_product_data(jsondata.data[0], p03, container_id, '', date, mode, save_to_db);
			return;
		}

	}, 'json', 0, 1);

}

var invoices_change_local_stores_ajax = '';
function invoices_change_local_stores(container_id, mode) {

	if (invoices_change_local_stores_ajax != '') {
		if (invoices_change_local_stores_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(invoices_change_local_stores_ajax);
		}
	}

	let prefix = '';
	if (mode == 'a55') {
		var container_id_main = pegGetContainer_id_d(container_id, 'a55_d', '', 'a55_d');
		var container_id_lp_stoixeia = pegGetContainer_id_d(container_id, 'a55_d5', '', 'a55_d');
	}

	if (mode == 'a56') {
		var container_id_main = pegGetContainer_id_d(container_id, 'a56_d', '', 'a56_d');
		var container_id_lp_stoixeia = pegGetContainer_id_d(container_id, 'a56_d5', '', 'a56_d');
	}

	if (mode == 'a57') {
		var container_id_main = pegGetContainer_id_d(container_id, 'a57_d', '', 'a57_d');
		var container_id_lp_stoixeia = pegGetContainer_id_d(container_id, 'a57_d4', '', 'a57_d');
	}

	if (mode == 'a67') {
		var container_id_main = pegGetContainer_id_d(container_id, 'a67_d', '', 'a67_d');
		var container_id_lp_stoixeia = pegGetContainer_id_d(container_id, 'a67_d4', '', 'a67_d');
	}


	if (mode == 't08') {
		var container_id_main = pegGetContainer_id_d(container_id, 't08_d', '', 't08_d');
		var container_id_lp_stoixeia = pegGetContainer_id_d(container_id, 't08_d02', '', 't08_d');
	}

	if(mode == 'retail00_01') {
		var parent_d = 'retail00_01_d';
		var retail00_01_d_container_id   = pegGetContainer_id_d(container_id , 'retail00_01_d'   , '' , parent_d );
		if(!retail00_01_d_container_id) {
			parent_d = 'retail00_02_d';
		}
		var container_id_main = pegGetContainer_id_d(container_id, 'retail00_01_d04', '', parent_d);
		var container_id_lp_stoixeia = pegGetContainer_id_d(container_id, 'retail00_01_d04', '', parent_d);

		var container_id_pelatis = pegGetContainer_id_d(container_id, 'retail00_01_d02', '', parent_d);
		prefix = 'a55';
	}



	params = {};
	if(mode == 'retail00_01') {
		params.p03 = pegGetVal('a01nr01', container_id_pelatis);
	}else{
		params.p03 = pegGetVal('p03', container_id_main);
	}
	params.p415 = pegGetVal(prefix + 'p415', container_id_lp_stoixeia);
	params.p416 = pegGetVal(prefix + 'p416', container_id_lp_stoixeia);
	params.nr01 = pegGetVal(prefix + 'nr01', container_id_main);
	params.mode = mode;



	invoices_change_local_stores_ajax = pegAjaxDefer('/' + main_path + '/invoices01/change_local_stores.php', params, function (jsondata) {
		pegSetVal(prefix + 'p417', container_id_lp_stoixeia, jsondata.p417);
		if (mode == 't08') {
			pegSetVal('p418', container_id_lp_stoixeia, jsondata.p418);
		}
	});


}

function invoices_i01_d10_afterDraw_listeners(container_id) {
	invoices_i01_d10_or_d11_afterDraw_listeners(container_id);
}

function invoices_i01_d11_afterDraw_listeners(container_id) {
	invoices_i01_d10_or_d11_afterDraw_listeners(container_id, 1);
}

function invoices_i01_d10_or_d11_afterDraw_listeners(container_id, service_only) {

	var screen = pegGetCmp(container_id);
	//Νομιζω ότι δεν υπάρχει πια i01_d11 ΦΨ
	var mmnr01 = screen.getMmnr01();

	// var p01Fld = pegGetCmp(container_id, 'p01');
	// var search_p01Fld = pegGetCmp(container_id, 'search_p01');
	// var p02Fld = pegGetCmp(container_id, 'p02');
	// var search_p02Fld = pegGetCmp(container_id, 'search_p02');
	// var but_mng_i00Fld = pegGetCmp(container_id, 'but_mng_i00');
	// var but_i00_insFld = pegGetCmp(container_id, 'but_i00_ins');
	var tabs 			= pegGetCmp(container_id, 'tab');
	var v_i00 			= pegGetCmp(container_id, 'v_i00');
	var has_color_size 	= screen.peg_getData('has_color_size');
	var has_serial 		= screen.peg_getData('has_serial');
	var has_lot 		= screen.peg_getData('has_lot');

	if (has_color_size == 1) {
		var totalItems = tabs.items.getCount();
		for (i = 0; i < totalItems; i++) {
			_d = tabs.getItem_d(i);

			if (_d == 'i01_d102') {
				tabs.items.get(i).enable();
			}
		}
	}
	if (has_serial == 1) {
		var totalItems = tabs.items.getCount();
		for (i = 0; i < totalItems; i++) {
			_d = tabs.getItem_d(i);

			if (_d == 'i01_d103') {
				tabs.items.get(i).enable();
			}
		}
	}


	if(has_lot==1){
		var totalItems = tabs.items.getCount();
		for (i = 0; i < totalItems; i++) {
			 _d  = tabs.getItem_d(i);

			 if(_d == 'i10_d104'){
				 tabs.items.get(i).enable();
			 }
		}
	}


	v_i00.on('change', function(me, newValue, oldValue, eOpts ){
		if(newValue == oldValue || invoice_get_search_item_value_onchange_pause() == true){
			return ;
		}
		pegSetVal('p01' ,container_id ,newValue);
		var row = {};
		row.v101 = newValue;
		invoices_get_product_data(row, '', container_id , '' , '' ,  mmnr01.substr(0, 3));
	});


	var s_but = pegGetCmp(container_id, 's_but');

	s_but.setPeg_handler(function(me) {
		invoice_search_item(container_id);
	});

	// invoices_set_tooltips(container_id, 'i01');
	// p01Fld.on('keydown', function (me, e) {
	// 	if (e.keyCode == 13 || e.keyCode == 191) {
	// 		pegGetCmp(me.container_id, 'search_p01').handler();
	// 	}
	// });
	// search_p01Fld.setHandler(function () {

	// 	params = {};
	// 	params.nr01 = screen.getNr01();
	// 	params.mmnr01 = mmnr01;

	// 	pegAjax('/' + main_path + '/invoices01/check_if_readonly.php', params, function (jsondata) {
	// 		if (jsondata.readonly) {
	// 			pegAlert(jsondata.readonly_dic);
	// 		}
	// 		else {
	// 			if (pegGetVal_d('i18i01', container_id, 'i01_d101', '', 'i01_d10') > 0) {
	// 				pegGetDic('peg_dic_invoices_i18', function (desc) {
	// 					pegAlert(desc);
	// 				});
	// 			} else {
	// 				invoices_search_product(container_id, mmnr01.substr(0, 3), 1);
	// 			}
	// 		}
	// 	}, 'json', 0, 1);

	// });

	// p02Fld.on('keydown', function (me, e) {
	// 	if (e.keyCode == 13 || e.keyCode == 191) {
	// 		pegGetCmp(me.container_id, 'search_p02').handler();
	// 	}
	// });

	// search_p02Fld.setHandler(function () {
	// 	params = {};
	// 	params.nr01 = screen.getNr01();
	// 	params.mmnr01 = mmnr01;

	// 	pegAjax('/' + main_path + '/invoices01/check_if_readonly.php', params, function (jsondata) {
	// 		if (jsondata.readonly) {
	// 			pegAlert(jsondata.readonly_dic);
	// 		}
	// 		else {
	// 			if (pegGetVal_d('i18i01', container_id, 'i01_d101', '', 'i01_d10') > 0) {
	// 				pegGetDic('peg_dic_invoices_i18', function (desc) {
	// 					pegAlert(desc);
	// 				});
	// 			} else {
	// 				invoices_search_product(container_id, mmnr01.substr(0, 3), 2);
	// 			}
	// 		}
	// 	}, 'json', 0, 1);

	// });

	// but_mng_i00Fld.setHandler(function () {
	// 	pedEditRec2Tab('i00', 'i00_d', 'inventory', container_id, 'pno', pegGetVal('p01', container_id));
	// });

	// but_i00_insFld.setHandler(function () {
	// 	if (service_only == 1) {
	// 		pegAddTab_d('', 'i00', 'i00_d', 'inventory', '', 0, '', { 'service_only': 1 });
	// 	}
	// 	else {
	// 		pegAddTab_d('', 'i00', 'i00_d', 'inventory', '', 0, '');
	// 	}
	// });
}

function invoices_i01_d101_afterDraw_listeners(container_id) {
	var screen = pegGetCmp(container_id);

	var mmnr01  = screen.getMmnr01();
	var p03Fld  = pegGetCmp(container_id, 'p03'); // Ποσότητα
	var p030Fld = pegGetCmp(container_id, 'p030'); // Δευτερεύουσα Ποσότητα
	var p081Fld = pegGetCmp(container_id, 'p081');
	var p030_1 	  = pegGetCmp(container_id,'p030_1');

	var bt_clear_i18Fld = pegGetCmp(container_id, 'bt_clear_i18'); // Καθαρισμός Συνταγής

	//ποσότητα
	p03Fld.on('blur', function (me, newValue, oldValue, eOpts) {
		if (me.peg_onBlurValueHasChanged()) {
			invoices_change_product_v103(container_id, mmnr01.substr(0, 3));
			invoices_find_product_quantity('i01_d10', container_id, '', '', mmnr01.substr(0, 3), "quantity_change");
		}
	});

	//δευτερεύουσα ποσότητα
	p030Fld.on('blur', function (me, newValue, oldValue, eOpts) {
		if (me.peg_onBlurValueHasChanged()) {
			let old_p03 = 0;
			old_p03 = pegGetVal('p03',  container_id);

			invoices_change_product_v120(container_id, mmnr01.substr(0, 3));

			if(old_p03 != pegGetVal('p03',  container_id)){
				invoices_find_product_quantity('i01_d10', container_id, '', '', mmnr01.substr(0, 3), "quantity_change");
			}
		}
	});

	//συνταγή
	bt_clear_i18Fld.setHandler(function () {
		if (pegGetVal('i18i01', container_id) > 0) {
			pegSetVal('i18i01', container_id, '0');

			var screen_container_id = pegGetContainer_id_d(container_id, 'i01_d10', '', 'i01_d10');

			row = {};
			row.v101 = pegGetVal('p01', screen_container_id);
			invoices_get_product_data(row, '', screen_container_id, '', '', mmnr01.substr(0, 3));
		}
	});

	//ποσότητα συσκευασίας 
	p030_1.on('blur', function(me){ 
		if(me.peg_onBlurValueHasChanged()) {
			invoices_check_if_parts(container_id, function(jsondata) {
				if(jsondata.ok == 1) {
					if(jsondata.pg02 == 0) {
						pegSetFieldReadonly('p04', container_id, true);

						if(pegGetVal('p030_1' ,container_id) > 0) {
							pegSetFieldReadonly('p04_1', container_id, false);	
						} else {
							pegSetFieldReadonly('p04_1', container_id, true);
							pegSetVal('p04_1', container_id, 0);
						}
					} else {
						if(pegGetVal('p030_1' ,container_id) > 0) {
							pegSetFieldReadonly('p04', container_id, true);
							pegSetFieldReadonly('p04_1', container_id, false);	
						} else {
							pegSetFieldReadonly('p04', container_id, false);
							pegSetFieldReadonly('p04_1', container_id, true);
							pegSetVal('p04_1', container_id, 0);
						}
					}
					
					invoices_find_product_quantity('i01_d10', container_id, '', '', mmnr01.substr(0, 3));
				} else {
					if(jsondata.pg02 == 0) {
						pegSetFieldReadonly('p04', container_id, true);
					} else {
						pegSetFieldReadonly('p04', container_id, false);
					}

					pegSetFieldReadonly('p04_1', container_id, true);
					pegSetVal('p030_1', container_id, 0);
					pegToast(jsondata.msg, 'alert');
				}
			});				
		}
	});

	//ΜΜ
	var fld_quantity = ["p301", "p302", "p304", "p306", "p309", "p303", "p307", "p310", "p04_1"];
	for (var i = 0; i < fld_quantity.length; i++) {
		var fld = fld_quantity[i];
		var tmpVar = pegGetCmp(container_id, fld);
		tmpVar.on('blur', function (me) {
			if (me.peg_onBlurValueHasChanged()) {
				//0906fretail -- Αλλαγές εντος τoy functions
				invoices_find_product_quantity('i01_d10', container_id, '', '', mmnr01.substr(0, 3));
			}
		});
	}

	//Είδος Συσκευασίας
	let p308Fld = pegGetCmp(container_id, "p308");
	p308Fld.on("change", function (me, newValue, oldValue, eOpts) {
		if (newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue))) {
			return false;
		}
		invoices_find_product_quantity('i01_d10', container_id, '', '', mmnr01.substr(0, 3));
	});
	
	//Τιμή μονάδος, έκπτωση κοκ 
	var fld_total = ["p04", "p010", "p010a", "p041", "p616", "p042"];
	for (var i = 0; i < fld_total.length; i++) {
		var fld = fld_total[i];
		var tmpVar = pegGetCmp(container_id, fld);
		tmpVar.on('blur', function (me) {
			if (me.peg_onBlurValueHasChanged()) {
				invoices_find_product_total('i01_d10', container_id, '', mmnr01.substr(0, 3));
			}
		});
	}

	p081Fld.on('change', function(me, newValue, oldValue, eOpts ){
		if(newValue == oldValue ){
			return ;
		}
		
		invoices_change_product_vat_category(container_id, mmnr01.substr(0, 3), newValue);
	});

}

function invoices_i01_d102_afterDraw_listeners(container_id) {
	var screen = pegGetCmp(container_id);
	var screen_i01_d10 = pegGetCmp(pegGetContainer_id_d(container_id, 'i01_d10', '', 'i01_d10'));
	var grid = pegGetCmp(container_id, 'grid');
	grid.setpeg_isEditable(true);

	var mmnr01 = screen_i01_d10.getMmnr01();

	grid.on('edit', function (editor, context) {
		for (var editable_element in context.newValues) {
			context.record.set(editable_element, context.newValues[editable_element]);
		}
		values = context.record.data;

		if (values.nr01 < 0) {
			values.nr01 = 0;
		}

		values.p01 = screen_i01_d10.peg_getData('nr01');

		//An eimai se kataxwthsh parastatikou - h paraggelia den exei antistoixo pedio
		if (screen_i01_d10.peg_getData('p01')) {
			values.i01p01 = screen_i01_d10.peg_getData('p01');
		}
		
		pegSave_grid_row(
			grid.peg_view__d,
			grid.peg_view_table,
			grid.peg_view_module,
			grid.getGridMnr01(),
			grid.getMmnr01(),
			values,
			function (jsondata) {
				context.record.data['nr01'] = jsondata.nr01;
				context.record.commit();
				invoices_find_product_quantity('i01_d101', container_id, 0, '', mmnr01.substr(0, 3));
			});
	});

	grid.record_delete = function (me, row) {
		pegGridDelSelectedRow(
			container_id,
			me.name,
			me.peg_view_table,
			me.getMnr01(),
			me.getMmnr01(),
			function () {
				invoices_find_product_quantity('i01_d101', container_id, 0, '', mmnr01.substr(0, 3));
				pegGridRefresh(me.getContainer_ID(), me.name);
			}
		);
	};
}

function invoices_i01_d103_afterDraw_listeners(container_id) {
	var screen_i01_d10 = pegGetCmp(pegGetContainer_id_d(container_id, 'i01_d10', '', 'i01_d10'));
	var grid = pegGetCmp(container_id, 'grid');
	grid.setpeg_isEditable(true);
	grid.on('edit', function (editor, context) {
		for (var editable_element in context.newValues) {
			context.record.set(editable_element, context.newValues[editable_element]);
		}
		values = context.record.data;
		values.p02 = values.v_p02;
		values.p00 = screen_i01_d10.peg_getData('nr01');
		pegSave_grid_row(
			grid.peg_view__d,
			'peg_tmp_i32',
			grid.peg_view_module,
			grid.getGridMnr01(),
			grid.getMmnr01(),
			values,
			function (jsondata) {
				if (!jsondata.ok) {
					pegAlert(jsondata.message);
					context.record.data['v_p02'] = jsondata.data.p02;
					context.record.commit();
				} else {
					context.record.commit();
				}
			});
	});
	grid.on('canceledit', function (editor, context) {
		context.record.reject();
	});

	grid.record_delete = function (me, row) {
		var screen_container_id = pegGetCmp(container_id).getPeg_screen_parent_container_id();
		if(!screen_container_id) {
			screen_container_id = container_id;
		}

		let serial_container_id = pegGetContainer_id_d(screen_container_id, 'i01_d103', '', 'i01_d10');

		pegGridDelSelectedRow(
			container_id,
			me.name,
			me.peg_view_table,
			me.getMnr01(),
			me.getMmnr01(),
			function () {
				let mmnr01 = me.getMmnr01();
				let mode = mmnr01.split('_d-')[0];

				invoices_find_product_quantity(mode+"_d", serial_container_id, 0,	'',	mode);
				pegGridRefresh(me.getContainer_ID(), me.name);
			}
		);
	};
}

/*function invoices_i01_d104_afterDraw_listeners(container_id) {
	var screen = pegGetCmp(container_id);
	var p03Fld = pegGetCmp(container_id, 'p03');

	p03Fld.on('change', function (me, newValue, oldValue, eOpts) {
		if (newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue))) {
			return;
		}
		invoices_find_product_total('', container_id, '', 'a55');
	});

	var fld_total = ["p04", "p010", "p010a"];
	for (var i = 0; i < fld_total.length; i++) {
		var fld = fld_total[i];
		var tmpVar = pegGetCmp(container_id, fld);
		tmpVar.on('blur', function (me) {
			if (me.peg_onBlurValueHasChanged()) {
				invoices_find_product_total('', container_id, '', 'a55');
			}
		});
	}
}*/

function invoices_f02_d2_afterDraw_listeners(container_id) {

	// Αυτόματη ενημέρωση Τιμής Αγοράς από Παραστατικό προμηθευτή
	let invoice_f02_p626 = pegGetCmp(container_id, 'p626');
	invoice_f02_p626.on('change', function(me, newValue, oldValue, eOpts ){
		if(newValue == oldValue) {
			return;
		}

		pegSetVal('p638', container_id, 0);

		if(newValue) {
			pegSetFieldHidden('p638', container_id, false);
		} else {
			pegSetFieldHidden('p638', container_id, true);
		}
	});
}

function invoices_f02_d5_afterDraw_listeners(container_id) {

	// Button Handler
	var invoice_logo_btn = pegGetCmp(container_id, 'invoice_logo_btn');
	invoice_logo_btn.setPeg_handler(function (me) {
		peg_windowShow_d(
			'',
			'f02_d51',
			'invoices',
			container_id,
			''
		);

	});

	// Button Handler
	var invoice_logo_view_btn = pegGetCmp(container_id, 'invoice_logo_view_btn');
	invoice_logo_view_btn.setPeg_handler(function (me) {
		peg_windowShow_d(
			'',
			'f02_d52',
			'invoices',
			container_id,
			''
		);

	});

	// Button Handler
	var invoice_logo_del_btn = pegGetCmp(container_id, 'invoice_logo_del_btn');
	invoice_logo_del_btn.setPeg_handler(function (me) {
		pegGetDic('invoices_delete_logo_cnf', function (desc) {
			pegConfirmBox('', desc, function (btn) {
				if (btn == 'yes') {
					invoices_delete_invoice_logo(container_id, 'const_path');
				}
			});
		});

	});


	// Button Handler
	var invoice_wm_logo_btn = pegGetCmp(container_id, 'invoice_wm_logo_btn');
	invoice_wm_logo_btn.setPeg_handler(function (me) {
		peg_windowShow_d(
			'',
			'f02_d53',
			'invoices',
			container_id,
			''
		);

	});
	// Button Handler
	var invoice_wm_logo_view_btn = pegGetCmp(container_id, 'invoice_wm_logo_view_btn');
	invoice_wm_logo_view_btn.setPeg_handler(function (me) {
		peg_windowShow_d(
			'',
			'f02_d54',
			'invoices',
			container_id,
			''
		);

	});

	// Button Handler
	var invoice_wm_logo_del_btn = pegGetCmp(container_id, 'invoice_wm_logo_del_btn');
	invoice_wm_logo_del_btn.setPeg_handler(function (me) {
		pegGetDic('invoices_delete_wm_logo_cnf', function (desc) {
			pegConfirmBox('', desc, function (btn) {
				if (btn == 'yes') {
					invoices_delete_invoice_logo(container_id, 'wm_const_path');
				}
			});
		});

	});
}
var invoices_i01_syntagh_main_product_refresh_grid_ajax ='';
function invoices_i01_syntagh_main_product_refresh_grid(container_id, mode, data){

	if (mode == 'a55') {
		var container_id_main = pegGetContainer_id_d(container_id, 'a55_d', '', 'a55_d');
		var container_id_eidi = pegGetContainer_id_d(container_id, 'a55_d3', '', 'a55_d');
	}

	if (mode == 'a56') {
		var container_id_main = pegGetContainer_id_d(container_id, 'a56_d', '', 'a56_d');
		var container_id_eidi = pegGetContainer_id_d(container_id, 'a56_d3', '', 'a56_d');
	}

	if (mode == 'a57') {
		var container_id_main = pegGetContainer_id_d(container_id, 'a57_d', '', 'a57_d');
		var container_id_eidi = pegGetContainer_id_d(container_id, 'a57_d2', '', 'a57_d');
	}

	if (mode == 'a67') {
		var container_id_main = pegGetContainer_id_d(container_id, 'a67_d', '', 'a67_d');
		var container_id_eidi = pegGetContainer_id_d(container_id, 'a67_d2', '', 'a67_d');
	}

	if (mode == 'a60') {
		var container_id_main = pegGetContainer_id_d(container_id, 'a60_d', '', 'a60_d');
		var container_id_eidi = pegGetContainer_id_d(container_id, 'a60_d2', '', 'a60_d');
	}

	if (mode == 'a61') {
		var container_id_main = pegGetContainer_id_d(container_id, 'a61_d', '', 'a61_d');
		var container_id_eidi = pegGetContainer_id_d(container_id, 'a61_d2', '', 'a61_d');
	}
	if (invoices_i01_syntagh_main_product_refresh_grid_ajax != '') {
		if (invoices_i01_syntagh_main_product_refresh_grid_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(invoices_i01_syntagh_main_product_refresh_grid_ajax);
		}
	}
	invoices_i01_syntagh_main_product_refresh_grid_ajax = pegAjaxDefer('/' + main_path + '/invoices01/check_recipe_items.php', data, function(jsonData){
		if(jsonData.ok===1){
			pegGridRefresh(container_id_eidi, 'grid',1);
		}
	});
}

function invoices__invoices_find_product_d_afterDraw_listeners(container_id) {
	var screen = pegGetCmp(container_id);
	var screen_i01_d10 = pegGetCmp(screen.peg_screen_parent_container_id);

	var bt_ok  = pegGetCmp(container_id, 'bt_ok');
	var bt_cancel  = pegGetCmp(container_id, 'bt_cancel');
	var bt_search = pegGetCmp(container_id, 'bt_search');
	var item_search = pegGetCmp(container_id, 'item_search');

	var grid = pegGetCmp(container_id, 'grid');

	grid.peg_isEditable = false;
	//grid.peg_preventDefault_itemdblclick = true;
	let save_to_db = 0;
	if(screen_i01_d10.peg__d === 'retail00_01_d' || screen_i01_d10.peg__d === 'retail00_02_d00') {
		var mode = 'retail00_01';
		save_to_db = 1;
	}else{
		var mmnr01 = screen_i01_d10.getMmnr01();
		var mode = mmnr01.substr(0, 3);
	}

	grid.record_change = function (me, row) {
		//retail: na pernaei svsta to mode substr(0, 3) , + save_db 
		var row = pegGridGetSelectedRow(container_id, grid.getName(), grid.getMnr01(), grid.getMmnr01());
		invoices_get_product_data(row, '', screen_i01_d10.getContainer_ID(), screen.getContainer_ID(), '', mode, save_to_db);
	};

	bt_ok.on('click', function(me) {
		var row = pegGridGetSelectedRow(container_id, grid.getName(), grid.getMnr01(), grid.getMmnr01());
		invoices_get_product_data(row, '', screen_i01_d10.getContainer_ID(), screen.getContainer_ID(), '', mode, save_to_db);
	});
	WebApp.view.Screen.peg_appendKeyMap(
		screen,
		Ext.event.Event.F12,
		function(event, screen) {
			event.preventDefault();
			var row = pegGridGetSelectedRow(container_id, grid.getName(), grid.getMnr01(), grid.getMmnr01());
			invoices_get_product_data(row, '', screen_i01_d10.getContainer_ID(), screen.getContainer_ID(), '', mode, save_to_db);
			
			return false;
		},
		{}
	);

	bt_cancel.on('click', function(me) {
		invoice_set_last_selected_row("");

		if (screen.peg_inWindow == 1) {
			pegWindowClose(container_id);
		} else {
			pegTabClose(pegGetCmp(container_id).peg_tabid);
		}
	});

	bt_search.on('click', function(me) {
		invoices_search_product(container_id, mode, pegGetVal('fld_search', container_id), {}, 1);
	});
	
	item_search.on('peg_qrscan_success', function (myTextfield, decodedText, decodedResult){
		invoices_search_product(container_id, mode, pegGetVal('fld_search', container_id), {}, 1);
	});

	item_search.on('keyup', function (me, event) {
		if (event.keyCode !== 13) {
			return false;
		}
		if(me.getValue() == '') {
			return false;
		}
		invoices_search_product(container_id, mode, pegGetVal('fld_search', container_id), {}, 1);
	});



	/*
	grid.on('itemdblclick', function( me, record, item, index, e, opts){
		var row = pegGridGetSelectedRow(container_id , grid.getName()  ,  grid.getMnr01() ,grid.getMmnr01());
		invoices_get_product_data( row, '' , screen_i01_d10.getContainer_ID() , screen.getContainer_ID() , '' ,  mmnr01.substr(0 ,3)  );
	});

	/*grid.setKeyMap({
		key: Ext.EventObject.ENTER,
		ctrl: false,
		stopEvent: true,
		fn: function(keycode,e){
			e.stopEvent();
			var row = pegGridGetSelectedRow(container_id, grid.getName() , grid.getMnr01() , grid.getMmnr01());
			invoices_get_product_data( row, '' ,container_id , container_id , '' ,  mmnr01.substr(0 ,3) );

		}
	});*/

}

function invoices__invoices_find_product_d00_grid_view_afterDraw_listeners(container_id){


	var grid = pegGetCmp(container_id, 'grid');

	var v_baltot     = WebApp.view.grid.Grid.peg_getColumn(grid, 'v_baltot'); //Συνολικό Υπολοιπο
	var v_locbaltot  = WebApp.view.grid.Grid.peg_getColumn(grid, 'v_locbaltot'); //Τοπικό Υπολοιπο

	var v_color_green =  '148c46';
	var v_color_red =  'ed0e1d';

	//Συνολικό Υπολοιπο
	if(v_baltot){
		v_baltot.peg_set_metaData = function(value, metaData, record, rowIndex, colIndex, store, view) {
			try {
				var v_baltot_data = record.get('v_baltot');
				if(v_baltot_data>0){
					metaData.tdStyle = "color:#"+v_color_green+";";
					metaData.style = "font-weight:bold;";
				}
				if(v_baltot_data<0){
					metaData.tdStyle = "color:#"+v_color_red+";";
					metaData.style = "font-weight:bold;";
				}
			} catch (error) {

			}
			return metaData;
		};
	}

	//Τοπικό Υπολοιπο
	if(v_locbaltot){
		v_locbaltot.peg_set_metaData = function(value, metaData, record, rowIndex, colIndex, store, view) {
			try {
				var v_locbaltot_data = record.get('v_baltot');
				if(v_locbaltot_data>0){
					metaData.tdStyle = "color:#"+v_color_green+";";
					metaData.style = "font-weight:bold;";
				}
				if(v_locbaltot_data<0){
					metaData.tdStyle = "color:#"+v_color_red+";";
					metaData.style = "font-weight:bold;";
				}

			} catch (error) {

			}
			return metaData;
		};
	}


}

var invoices_toolbar_item_invoice_order_ajax = '';
function invoices_toolbar_item_invoice_order(container_id, id, dic, mode) {
	const grid = pegGetCmp(container_id,id);
	const selected = grid.getSelection();
	if (selected.length == 0) {
		return pegAlert(dic);
	}
	let nr01s = [];
	selected.forEach(function(row) {
		nr01s.push(row.get('nr01'));
	})
	params = {
		mode : mode,
		nr01s : nr01s.join(',')
	};
	if (invoices_toolbar_item_invoice_order_ajax != '') {
		if (invoices_toolbar_item_invoice_order_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(invoices_toolbar_item_invoice_order_ajax);
		}
	}
	invoices_toolbar_item_invoice_order_ajax = pegAjaxDefer('/' + main_path + '/invoices01/order_invoice_group_by.php',
	params, function(jsonData){
		if(jsonData.ok!=1){
			pegAlert(jsonData.msg?jsonData.msg:"Error");
			return;
		}
		if(jsonData.data.length == 1) {
			invoices_toolbar_item_invoice_order_single(container_id, id, dic, mode);
			return;
		}
		return pegConfirmBox(
			'',
			jsonData.msg,
			function(ans) {
				if(ans == 'yes') {
					return pegGetDic('contract_periodic_invoicing_mass_start',function(msg){
						grid.mask(msg);
						return invoices_orders_to_invoices(
							jsonData.data,
							grid,
							[msg],
							mode
						)
					})
				}
			}
		)
	});
}
var invoices_orders_to_invoices_ajax = '';
/**
 * 
 * @param {array} group_orders 
 * @param {function} next 
 * @returns 
 */
function invoices_orders_to_invoices(
	group_orders,
	musk_target,
	msgs,
	mode
) {
	if(group_orders.length == 0) {
		setTimeout(function(){
			musk_target.unmask();
		},4000)
		return;
	}
	let group = group_orders.pop();
	const params = {
		nr01s : group,
		mode : mode
	}
	if (invoices_orders_to_invoices_ajax != '') {
		if (invoices_orders_to_invoices_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(invoices_orders_to_invoices_ajax);
		}
	}
	invoices_orders_to_invoices_ajax = pegAjaxDefer('/' + main_path + '/invoices01/invoices_orders_to_invoices.php',
	params, function(jsonData){
		msgs.push(jsonData.msg);
		let msg = msgs.slice(-10).join('<br>');
		musk_target.mask(msg);
		if(!pegIsEmpty(jsonData.data.mydt)){
			pegToast(jsonData.data.mydt);
		}
		if(!pegIsEmpty(jsonData.data.einv)){
			pegToast(jsonData.data.einv);
		}
		return invoices_orders_to_invoices(
			group_orders,
			musk_target,
			msgs,
			mode
		);
	});
}


/************************Custom Actions******************************/
var invoices_toolbar_item_invoice_order_single_ajax ='';
function invoices_toolbar_item_invoice_order_single(container_id, id, dic, mode) {

	const grid = pegGetCmp(container_id,id);
	const selected = grid.getSelection();
	if (selected.length == 0) {
		return pegAlert(dic);
	}
	const row = selected[0].data;

	if (row) {
		var nr01 = row.nr01;
		if (nr01 < 1) {
			pegAlert(dic);
			return;
		}
		let append_mnr01 = []
		if(selected.length > 1) {
			for(i=1; i<selected.length; i++) {
				append_mnr01.push(selected[i].data.nr01)
			}
		}
		params = {};
		params.nr01   = nr01;
		params.mode   = mode;

		if (invoices_toolbar_item_invoice_order_single_ajax != '') {
			if (invoices_toolbar_item_invoice_order_single_ajax.id > 0) {
				Ext.ux.AjaxDefer.abort(invoices_toolbar_item_invoice_order_single_ajax);
			}
		}
		invoices_toolbar_item_invoice_order_single_ajax = pegAjaxDefer('/' + main_path + '/invoices01/check_p05_1_data.php',
		params, function(jsonData){
			if(jsonData.open_tab==1){
				/* Παραγγελία Προμηθευτή */
				if (mode == 'a67') {
					const params = {
						a67_mnr01: nr01
					}
					if(append_mnr01.length > 0) {
						params.append_mnr01 = append_mnr01.join(',')
					}
					pegAddTab_d("", "a56", "a56_d", "invsupp", "", 0, "", params, container_id, id);
				/* Εσωτερική Παραγγελία */
				} else if (mode == 'a61') {
					const params = {
						a61_mnr01: nr01
					}
					if(append_mnr01.length > 0) {
						params.append_mnr01 = append_mnr01.join(',')
					}
					pegAddTab_d("", "a60", "a60_d", "invtrans00", "", 0, "", params, container_id, id);
				/* Παραγγελία Πελάτη */
				} else {
					const params = {
						a57_mnr01: nr01
					}
					if(append_mnr01.length > 0) {
						params.append_mnr01 = append_mnr01.join(',')
					}
					pegAddTab_d("", "a55", "a55_d", "invcust", "", 0, "", params, container_id, id);
				}
			}
			else{
				//pegToast(jsonData.msg,'alert');
				// Maziki timologisi me screen
			}
		} , 'json' , true);
	}
}

function invoices_toolbar_item_show_report(container_id, id, dic, q10nr01, parent_container_id, parent_d, grid_columns={}) {

	var row = pegGridGetSelectedRow(container_id, id);

	if (row) {
		var params = {};
		if(grid_columns.i00_pno!=undefined){
			params.i00_pno = row[grid_columns.i00_pno];
		}else{
			params.i00_pno = row.v101;
		}
		if (parent_d) {
			parent_container_id = pegGetContainer_id_d(container_id, parent_d, '', parent_d);
		}
		pegAjaxDefer('/' + main_path + '/invoices01/find_product_nr01.php', params, function (jsondata) {
			peg_query_window_execute(
				q10nr01 ,
				'' ,
				parent_container_id   ,
				{
					dias_main_table: 'i00',
					dias_main_nr01: jsondata.i00_nr01
				}
			);
		});
	} else {
		pegAlert(dic);
		return;
	}
}

function invoices_toolbar_item_cancel_invoice(container_id, id, dic, mode, _d_with_grid_to_refresh_on_submit, grid_to_refresh_on_submit) {


	var row = pegGridGetSelectedRow(container_id, id);
	if (row) {
		var nr01 = row.nr01;
		if (nr01 < 1) {
			pegAlert(dic);
			return;
		}

		if (!grid_to_refresh_on_submit) {
			invoices_cancel_invoice(mode, nr01);
		}
		else {
			container_of_grid_to_refresh_on_submit = pegGetContainer_id_d(container_id, _d_with_grid_to_refresh_on_submit);
			invoices_cancel_invoice(mode, nr01, container_of_grid_to_refresh_on_submit, grid_to_refresh_on_submit);
		}

	}
}

function invoices_toolbar_item_transform_invoice(container_id, id, dic, mode, _d_with_grid_to_refresh_on_submit, grid_to_refresh_on_submit) {

	var row = pegGridGetSelectedRow(container_id, id);
	if (row) {
		var nr01 = row.nr01;
		if (nr01 < 1) {
			pegAlert(dic);
			return;
		}
		if (!grid_to_refresh_on_submit) {
			invoices_transform_invoice(mode, nr01);
		}
		else {
			container_of_grid_to_refresh_on_submit = pegGetContainer_id_d(container_id, _d_with_grid_to_refresh_on_submit);
			invoices_transform_invoice(mode, nr01, container_of_grid_to_refresh_on_submit, grid_to_refresh_on_submit);
		}

	}
}
/************************Custom Actions******************************/

var invoices_delete_invoice_logo_ajax = '';
function invoices_delete_invoice_logo(container_id, field) {

	if (invoices_delete_invoice_logo_ajax != '') {
		if (invoices_delete_invoice_logo_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(invoices_delete_invoice_logo_ajax);
		}
	}

	var url = '/' + main_path + '/invoices01/delete_invoice_logo.php';
	var params = {};
	params.container_id = container_id;
	params.filename = pegGetVal(field, container_id);

	invoices_delete_invoice_logo_ajax = pegAjaxDefer(url, params, function (json_data) {
		if (json_data.ok == 1) {

		} else {
			pegAlert(json_data.msg);
		}
	});
}

function invoices_on_edit_posotita(container_id, context, mode) {
	var params = {};
	var save_table;
	var container_id_stoixeia;
	var grid = pegGetCmp(container_id, 'grid');
	if (mode == 'a57') {
		save_table = 'peg_tmp_a58';
		container_id_stoixeia = pegGetContainer_id_d(container_id, 'a57_d3', '', 'a57_d');
	} else if (mode == 'a67') {
		save_table = 'peg_tmp_a68';
		container_id_stoixeia = pegGetContainer_id_d(container_id, 'a67_d3', '', 'a67_d');
	} else if (mode == 'a61') {
		save_table = 'peg_tmp_a62';
		container_id_stoixeia = pegGetContainer_id_d(container_id, 'a61_d', '', 'a61_d');
	}
	params.v101 = context.record.data.v101;	//ειδος
	params.v103 = context.record.data.v103;	//ποσότητα
	params.nr01 = context.record.data.nr01; 	//ΜΚ
	params[mode + '_p07'] = invoice_get_p07(container_id,mode);	//τιμες με ΦΠΑ



	params.nr01 = context.record.data.nr01;	//ΜΚ ειδους
	params.mode = mode;						//mode


	pegAjaxDefer('/' + main_path + '/invoices01/on_edit_posotita.php', params, function (jsondata) {
		if (jsondata.ok == 1) {
			context.record.data.v120 = jsondata.v120;		//Δευτερευουσα ποσότητα
			context.record.data.v107 = jsondata.v107;		//Σύνολο
			values = context.record.data;
			pegSave_grid_row(grid.peg_view__d, save_table, grid.peg_view_module, grid.getMnr01(), grid.getMmnr01(), values, function (jsondata) {
				if (!jsondata.ok) {
					pegAlert(jsondata.message);
					context.record.reject();
				} else {
					context.record.commit();
					if (mode == 'a57' || mode == 'a67') {
						invoices_calculate_total(container_id, mode);
					}
				}
			});
		} else {
			pegAlert(jsondata.message);
			context.record.reject();
		}
	});
}

function invoices_is_checked_update(container_id, mode) {
	if (mode == 'a55') {
		var container_id_stoixeia = pegGetContainer_id_d(container_id, 'a55_d4', '', 'a55_d');
	}

	if (mode == 'a56') {
		var container_id_stoixeia = pegGetContainer_id_d(container_id, 'a56_d4', '', 'a56_d');
	}

	if (mode == 'a57') {
		var container_id_stoixeia = pegGetContainer_id_d(container_id, 'a57_d3', '', 'a57_d');
	}

	if (mode == 'a67') {
		var container_id_stoixeia = pegGetContainer_id_d(container_id, 'a67_d3', '', 'a67_d');
	}


	var screen = pegGetCmp(container_id);
	var params = {};
	params.nr01 = screen.getNr01();
	params.p901 = pegGetVal('p901', container_id_stoixeia);
	params.mode = mode;
	if (mode == 'a55' || mode == 'a56' || mode == 't08') {
		pegAjaxDefer('/' + main_path + '/invoices02/is_checked_update.php',
			params,
			function (jsondata) {
				if (jsondata.p901 == 1 || jsondata.p901 == 0) {
					pegSetVal('p901', container_id_stoixeia, jsondata.p901);
				}
				if (jsondata.message != null) {
					pegToast(jsondata.message , 'info');
				}
				if (jsondata.message_alert != null) {
					pegToast(jsondata.message_alert , 'alert');
				}
			}
		);
	} else {
		console.info("Mode '" + mode + "' action has not been defined!");
	}
}

invoice_is_checked_ajax = '';
function invoices_edit_ischecked_from_grid(container_id, nr01, peg_view_table, p901, context){
	
	if (invoice_is_checked_ajax) {
		if (invoice_is_checked_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(invoice_is_checked_ajax);
		}
	}
	var params ={};
	params.nr01 = nr01;
	params.mode = peg_view_table;
	params.from_grid = 1;
	params.p901 = 0;
	
	if(p901){
		params.p901 = 1;
	}
	invoice_is_checked_ajax = pegAjaxDefer(
				'/' + main_path + '/invoices02/is_checked_update.php',
				params,
				function (jsondata) {
					if (jsondata.p901 == 1 || jsondata.p901 == 0) {
						pegSetVal('p901', container_id, jsondata.p901);
					}
					if (jsondata.message != null) {
						context.record.commit();
						pegToast(jsondata.message , 'info');
					}
					if (jsondata.message_alert != null) {
						context.record.reject();
						pegToast(jsondata.message_alert , 'alert');
					}
				})
}
function invoices_update_row(mode, screen_container_id, data) {

	var screen    = pegGetCmp(screen_container_id);
	var selection = pegGetCmp(screen.getContainer_ID(), 'grid').getSelection()[0];

	selection.set('p616p', data.p616p);
	if ((mode == 'a55' || mode == 'a56' || mode == 'a60')) {
		selection.set('p01b', data.p01b);
		selection.set('p01', data.v101);
		selection.set('p02', data.v102);
		selection.set('p0601', data.v160);
		selection.set('p030', data.v120);
		selection.set('p301', data.v301);
		selection.set('p302', data.v302);
		selection.set('p303', data.v303);
		selection.set('p304', data.v304);
		selection.set('p306', data.v306);
		selection.set('p307', data.v307);
		selection.set('p04', data.v104);
		selection.set('p08', data.fpa);
		selection.set('p081', data.kfpa);
		selection.set('p010', data.v106);
		selection.set('p010a', data.v106a);
		selection.set('p041', data.v1041);
		selection.set('p616', data.v616);
		selection.set('p309', data.v309);
		selection.set('p308', data.v308);
		selection.set('p614', data.v614);
		selection.set('p03', 0);
		selection.set('p030', 0);
		if (data.v103 > 0) {
			selection.set('p03', data.v103);
		}
		if (data.v120 > 0) {
			selection.set('p030', data.v120);
		}
		selection.set('v107', data.v107);

		selection.set('p030_1', data.v1030_1);
		selection.set('p03', data.v103);
		selection.set('p04_1', data.v104_1);

		selection.set('v_ths', data.v_i00_ths);
		selection.set('v_p200', data.v_i00_p200);		
		selection.set('v_i00_p201', data.v_i00_p201);
		selection.set('p610', data.p610);
		selection.set('p09', data.i01_p09);
	} else if (mode == 'a57' || mode == 'a67' || mode == 'a61') {
		selection.set('v101b', data.v101b);
		selection.set('v101', data.v101);
		selection.set('v102', data.v102);
		selection.set('v107', data.v107);

		selection.set('v160', data.v160);
		selection.set('v120', data.v120);
		selection.set('v301', data.v301);
		selection.set('v302', data.v302);
		selection.set('v303', data.v303);
		selection.set('v304', data.v304);
		selection.set('v306', data.v306);
		selection.set('v307', data.v307);
		selection.set('v104', data.v104);
		selection.set('v105', data.fpa);
		selection.set('v108', data.kfpa);
		selection.set('v106', data.v106);
		selection.set('v106a', data.v106a);
		selection.set('v1041', data.v1041);
		selection.set('v616', data.v616);
		selection.set('v309', data.v309);
		selection.set('v308', data.v308);
		selection.set('v614', data.v614);
		selection.set('v103', 0);
		selection.set('v120', 0);
		if (data.v103 > 0) {
			selection.set('v103', data.v103);
		}
		if (data.v120 > 0) {
			selection.set('v120', data.v120);
		}
		selection.set('v1030_1', data.v1030_1);
		selection.set('v301', data.v301);
		selection.set('v104_1', data.v104_1);
		selection.set('v_baltot', data.v_baltot);
		selection.set('v_i00_ths',  data.v_i00_ths);
		selection.set('v_i00_p200', data.v_i00_p200);		
		selection.set('v_i00_p201', data.v_i00_p201);
		selection.set('p703', data.p703);
		selection.set('p03', data.p03);
		selection.set('p04', data.p04);
	}

	selection.set('v_i00_p9001', data.v_i00_p9001);
	selection.set('v_i00_p00', data.v_i00_p00);
	selection.set('v_i00_p9907', data.v_i00_p9907);
	selection.set('v_i00_p01', data.v_i00_p01);
	selection.set('v_a90_p30', data.v_a90_p30);
	selection.set('timh1', data.timh1);
	selection.set('timh2', data.timh2);
	selection.set('timh3', data.timh3);
	selection.set('timh4', data.timh4);
	selection.set('i19p03', data.i19p03);

	selection.set('v_cs_en', data.color_size_en);
	selection.set('v_sn_en', data.serial_en);
	selection.set('v_lot_en', data.lot_en);
	selection.set('v_p200_en', data.v_p200_en);

	//i00_in.p200='' and 
	if (
		data.i24_p102 == 0 &&
		data.i24_p103 == 0 &&
		data.i24_p104 == 0 &&
		data.i24_p106 == 0 &&
		data.i24_p107 == 0 &&
		data.i24_p108 == 0 &&
		data.i24_p109 == 0 &&
		data.i24_p110 == 0
	) {
		selection.set('v_ths_readonly', 0);
	} else {
		selection.set('v_ths_readonly', 1);
	}
	let plugin = pegGetCmp(screen.getContainer_ID(), 'grid').getPlugins()[0];
		plugin.startEditByPosition(
			{
				row: plugin.context.rowIdx,
				column: plugin.context.colIdx
			});
}

function invoices_cellkeydown_actions(keyCode, rowIndex, container_id, mode) {
	let aCol = pegGetCmp(container_id, "grid").getPlugins()[0].activeColumn;
	if (aCol) {
		return;
	}
	if (keyCode == 40 && rowIndex == (pegGetCmp(container_id, 'grid').getStore().getCount() - 1) && pegGetCmp(container_id, 'grid').editing == true) {
		invoices_add_row(container_id, mode);
	}


}

function invoices_keydown_actions(keyCode, container_id, type) {
	if (keyCode == 191 || keyCode == 111) {

		invoices_search_product(container_id + "_grid", pegGetCmp(container_id).peg_table, type);
	}
}

function invoices_keyup_actions(val, container_id, type) {
	let sliced = val.slice(-1);
	if(sliced == '/'){
		invoices_search_product(container_id + "_grid", pegGetCmp(container_id).peg_table, type);
	}
}

function invoices_set_tooltips(container_id, mode) {
	pegGetDic('peg_dic_invoices_search_tooltip', function (desc) {
		let fldP01, fldP02;
		if (mode == 'a55' || mode == 'a56' || mode == 'a60') {
			fldP01 = pegGetCmp(container_id + '_grid_p01');
			fldP02 = pegGetCmp(container_id + '_grid_p02');

		} else if (mode == 'a57' || mode == 'a67' || mode == 'a61') {
			fldP01 = pegGetCmp(container_id + '_grid_v101');
			fldP02 = pegGetCmp(container_id + '_grid_v102');
		} else if (mode == 'a58' || mode == 'a68'|| mode == 'a62') {
			fldP01 = pegGetCmp(container_id + '_v101');
			fldP02 = pegGetCmp(container_id + '_v102');
		} else if (mode == 'i01') {
			fldP01 = pegGetCmp(container_id + '_p01');
			fldP02 = pegGetCmp(container_id + '_p02');
		}

		if(fldP01 && fldP02){
			if (mode == 'a58' || mode == 'a68' || mode == 'i01' || mode == 'a62') {
				fldP01.setTooltip(desc);
				fldP02.setTooltip(desc);
			} else {
				fldP01.on('afterrender', function () {
					fldP01.setTooltip(desc);
				});
				fldP02.on('afterrender', function () {
					fldP02.setTooltip(desc);
				});
			}
		}
	});
}

function invoices_beforeedit_actions(container_id, context, mode) {
	values = { ...context.record.data };
	let getData = pegGetCmp(pegGetContainer_id_d(container_id, mode + "_d")).peg_getData();
	if (mode == 'a56' || mode == 'a55') { //TODO: if για παραστατικό εσωτερικής διακινησης
		if (getData['invoices_i01_d101_' + context.field + '_readonly'] == 1) {
			return false;
		}
		//Δεν μπορεί να αλλάξει κωδικό είδους αν συμμετεχει σε συνταγη
		if(context.field == 'p01' && values.i18i01 > 0){
			return false;
		}
	}
	if (mode == 'a57' || mode == 'a67' || mode == 'a61' ) {
		//console.log("Before edit: "+context.field + "  " + getData[context.field + '_not_readonly']);
		if (getData[context.field + '_not_readonly'] == 0) {
			return false;
		}
		//Δεν μπορεί να αλλάξει κωδικό είδους αν συμμετεχει σε συνταγη
		if(context.field == 'v101' && ( values.i18a58 > 0 || values.i18a68 > 0 || values.i18a62 > 0)){
			return false;
		}
	}
	pegGetCmp(container_id, 'grid').getSelectionModel().select(context.rowIdx);
}

function invoices_canceledit_actions(container_id, context, mode) {
	invoice_set_last_selected_row("");

	context.record.reject();
}


var invoices_edit_actions_invoices_show_stock_screen_semafor = '';
function invoices_edit_actions(container_id, context, mode) {
	let grid = pegGetCmp(container_id, 'grid');

	if (Ext.getCmp(container_id).masked == true) {
		return;
	}

	// if (context.value == '' &&
	// 	((mode == 'a55' || mode == 'a56' || mode == 'a60') && context.field == 'p01' ||
	// 		(mode == 'a57' || mode == 'a67' || mode == 'a61') && context.field == 'v101')) {
	// 	return;
	// }
	let values = { ...context.record.data };

	if (pegGetContainer_id_d(container_id, "_invoices_find_product_d") == '') {
		if (!pegIsEmpty(values[context.field]) && (
			context.field == 'p01' && (mode == 'a55' || mode == 'a56' || mode == 'a60') ||
			context.field == 'v101' && (mode == 'a57' || mode == 'a67'  || mode == 'a61'))
			&& context.originalValue != context.value) {
				invoices_search_product(container_id + "_grid", pegGetCmp(container_id).peg_table, 1);

				return;
		}

		parent_container_id = pegGetContainer_id_d(container_id, mode+'_d', 0, mode+'_d');

		if(mode == 'a55' || mode == 'a56') {
			parent_container_id_stoixeia = pegGetContainer_id_d(container_id, mode+'_d4', 0, mode+'_d');

			peg_tmp_var_mode_p07 = pegGetVal("p07", parent_container_id_stoixeia);
			values.peg_tmp_var_p03 = pegGetVal("p03", parent_container_id); //Πελάτης
			values.peg_tmp_var_kath_fpa = pegGetVal("p09", parent_container_id_stoixeia); //Κωδ.Καθεστώτος ΦΠΑ
		} else if(mode == 'a57' || mode == 'a67') {
			parent_container_id_stoixeia = pegGetContainer_id_d(container_id, mode+'_d3', 0, mode+'_d');

			peg_tmp_var_mode_p07 = pegGetVal("p07", parent_container_id_stoixeia);
			values.peg_tmp_var_p03 = pegGetVal("p03", parent_container_id); //Προμηθευτής
			values.peg_tmp_var_kath_fpa = pegGetVal("p09", parent_container_id_stoixeia); //Κωδ.Καθεστώτος ΦΠΑ
		} else if(mode == 'a60' || mode == 'a61') {
			peg_tmp_var_mode_p07 = 0;
		}

		if (values.nr01 <= 0) {
			Ext.getCmp(container_id).mask('');
		}
   
		if(invoice_get_last_selected_row()) {
		   let last_selected_row = invoice_get_last_selected_row();
   
		   values.peg_tmp_var_ser  = last_selected_row.ser;
		   values.peg_tmp_var_v172 = last_selected_row.v172;
		   values.peg_tmp_var_v173 = last_selected_row.v173;
		   values.peg_tmp_var_v161 = last_selected_row.v161;
		}

		values.no_confirm = 1;

		values.peg_tmp_var_context_field = context.field; //Όνομα Πεδίου
		
		values.peg_tmp_var_context_originalValue = context.originalValue; //Αρχική τιμή
		values.peg_tmp_var_context_changed_value = context.value;		  //Αλλαγμένη τιμή

		values.peg_tmp_var_p07 	= peg_tmp_var_mode_p07; //Τιμές με ΦΠΑ
		values.peg_tmp_var_date = pegGetVal("p01", parent_container_id); //Ημερομηνία
		values.peg_tmp_var_p05  = pegGetVal('p05', parent_container_id); //Παραστατικό

		values.no_confirm = 1;
		_d = grid.peg_view__d;
		module = grid.peg_view_module;
		if(_d == 'i01_d10'){
			_d = 'i01_d';
			module = 'invtrans';
		} 
		pegSave_grid_row(_d,
			grid.peg_view_table,
			module,
			grid.getMnr01(),
			grid.getMmnr01(),
			values,
			function (jsondata) {
				if (!jsondata.ok) {
					let tmp_msg = jsondata.message;
					if(tmp_msg){
						tmp_msg = tmp_msg.replace('<br>', '');
					}
					pegToast(tmp_msg, 'alert');
					context.record.reject();
				} else {
					//ψclaculate tootals 
					//kai emfnais to stockscreen
					// και αν διαγραπσο την grid saveproduct
					// na diagpaso ola ta v πεδια που δνε χριαζονται απο το i01_d10 , a58 .... κια να δω και αν οι συνρτησεις που εχονυ μεσα καλουνται καπου 
					
					if (mode == 'a57' || mode == 'a67' || mode == 'a61') {
						context.record.data.v616   = jsondata.data.v616;
						context.record.data.v107   = jsondata.data.v107;
						context.record.data.v104   = jsondata.data.v104;
						context.record.data.v103   = jsondata.data.v103;
						context.record.data.v120   = jsondata.data.v120;
						context.record.data.v106   = jsondata.data.v106;
						context.record.data.v106a  = jsondata.data.v106a;
						context.record.data.v1041  = jsondata.data.v1041;
						context.record.data.v1042  = jsondata.data.v1042;
						context.record.data.v104_1 = jsondata.data.v104_1;
						context.record.data.v105 = jsondata.data.v105;

					} else if(mode == 'a55' || mode == 'a56' || mode == 'a60') {
						_pososto_fpa = ((100 + pegParseFloat(jsondata.data.p08)) / 100);
						_ekptosi_1   = ((100 - pegParseFloat(jsondata.data.p010)) / 100);
						_ekptosi_2   = ((100 - pegParseFloat(jsondata.data.p010a)) / 100);

						if(values.peg_tmp_var_p07 == 1) {
							p616 = jsondata.data.p616 * _pososto_fpa;
							p041 = jsondata.data.p041 * _pososto_fpa;
						} else {
							p616 = jsondata.data.p616;
							p041 = jsondata.data.p041;
						}

						v107 = invoices_calculate_v107(jsondata.data.p03, jsondata.data.p04, _ekptosi_1, _ekptosi_2, p616, p041, jsondata.data.p042);
						
						context.record.data.p616  = jsondata.data.p616;
						context.record.data.v107  = v107;
						context.record.data.p04   = jsondata.data.p04;
						context.record.data.p03   = jsondata.data.p03;
						context.record.data.p030  = jsondata.data.p030;
						context.record.data.p010  = jsondata.data.p010;
						context.record.data.p010a = jsondata.data.p010a;
						context.record.data.p041  = jsondata.data.p041;
						context.record.data.p042  = jsondata.data.p042;
						context.record.data.p04_1 = jsondata.data.p04_1;
						context.record.data.p08 = jsondata.data.p08;

						if(values.peg_tmp_var_p07 == 1) {
							context.record.data.v_i01_p04_novat = jsondata.data.p04 / _pososto_fpa;
							context.record.data.v_i01_p04_vat   = jsondata.data.p04;
							context.record.data.v_v107_novat    = (v107 / _pososto_fpa).toFixed(2);
							context.record.data.v_v107_vat      = v107.toFixed(2);
						} else {
							context.record.data.v_i01_p04_novat = jsondata.data.p04;
							context.record.data.v_i01_p04_vat   = jsondata.data.p04 * _pososto_fpa;
							context.record.data.v_v107_novat    = v107.toFixed(2);
							context.record.data.v_v107_vat      = (v107 * _pososto_fpa).toFixed(2);							
						}
					}

					if(mode == 'a57' || mode == 'a67') {
						_pososto_fpa = ((100 + parseFloat(jsondata.data.v105)) / 100);

						let v107 = pegParseFloat(jsondata.data.v107);

						if(values.peg_tmp_var_p07 == 1) {
							context.record.data.v_v104_novat = jsondata.data.v104 / _pososto_fpa;
							context.record.data.v_v104_vat   = jsondata.data.v104;
							context.record.data.v_v107_novat = (v107 / _pososto_fpa).toFixed(2);
							context.record.data.v_v107_vat   = v107.toFixed(2);
						} else {
							context.record.data.v_v104_novat = jsondata.data.v104;
							context.record.data.v_v104_vat   = jsondata.data.v104 * _pososto_fpa;
							context.record.data.v_v107_novat = v107.toFixed(2);
							context.record.data.v_v107_vat   = (v107 * _pososto_fpa).toFixed(2);							
						}
					}

					if (context.record.data.nr01 <= 0) {
						context.record.data.nr01 = jsondata.nr01;
					}

					let modified = grid.getSelection()[0].modified;
					context.record.commit();

					if (mode == 'a57') {
						ordercust_calculate_total(container_id);
						context.record.data.v_rest = context.record.data['v103'] - context.record.data['v109'];
					} else if (mode == 'a67') {
						ordersupp_calculate_total(container_id);
					} else if (mode == 'a55') {
						invcust_calculate_total(container_id);
					} else if (mode == 'a56') {
						invsupp_calculate_total(container_id);
					}

					if (context.record.previousValues &&
						(
							(context.record.previousValues.p03 != context.record.data.p03   || context.record.previousValues.p01 != context.record.data.p01) && (mode == 'a55' || mode == 'a56') ||
							(context.record.previousValues.v103 != context.record.data.v103 || context.record.previousValues.v101 != context.record.data.v101) && (mode == 'a57' || mode == 'a67'))

						) {
							
						var product_code;

						if (mode == 'a55' || mode == 'a56') {
							product_code = context.record.data.p01;
							product_quan = context.record.data.p03;
						} else {
							product_code = context.record.data.v101;
							product_quan = context.record.data.v103;
						}
						
						p703 = invoice_get_p703(container_id,mode);

						if(invoices_edit_actions_invoices_show_stock_screen_semafor !== '####' + product_code + '####' + product_quan + '####' +p703 ){
							invoices_edit_actions_invoices_show_stock_screen_semafor = '####' + product_code + '####' + product_quan + '####' + p703;
							invoices_show_stock_screen(container_id, product_code, p703, context.record.data.nr01);
						}
					}

					// if(jsondata.data.i19p03 > 0 && 
					// 	(
					// 		!(jsondata.data.i18i01>0) && 
					// 		!(jsondata.data.i18a58>0) && 
					// 		!(jsondata.data.i18a68>0) && 
					// 		!(jsondata.data.i18a62>0)
					// 	)
					// ) {
					// 	 pegGridRefresh(container_id, 'grid');
					// }
				}
				
				Ext.getCmp(container_id).unmask();
			}
		);
		
		invoice_set_last_selected_row('');
	} else {
		context.record.reject();
	}
}

function invoices_add_row(container_id, mode) {
	let rec;
	let grid = pegGetCmp(container_id, 'grid');
	var today = new Date();
	var dd = String(today.getDate()).padStart(2, '0');
	var mm = String(today.getMonth() + 1).padStart(2, '0'); //January is 0!
	var yyyy = today.getFullYear();
	let curdate = yyyy + "-" + mm + "-" + dd;
	if (grid.store.getData().items.filter(x => x.data.nr01 < 0).length == 0) {
		if (mode == 'a55') {
			rec = {
				p013: curdate,
				p06: pegGetVal_d('nr01', container_id, mode + '_d', '', mode + '_d'),
				p07: 2
			};
		} else if (mode == 'a56') {
			rec = {
				p013: curdate,
				p06: pegGetVal_d('nr01', container_id, mode + '_d', '', mode + '_d'),
				p07: 1
			};
		} else if (mode == 'a60') {
			rec = {
				p013: curdate,
				p06: pegGetVal_d('nr01', container_id, mode + '_d', '', mode + '_d'),
				p07: 3
			};
		} else if (mode == 'a57' || mode == 'a67' || mode == 'a61') {
			rec = {
				p00: pegGetVal_d('nr01', container_id, mode + '_d', '', mode + '_d')
			};
		}
		pegGetCmp(container_id, 'grid').store.add(rec);

	}
	grid.getSelectionModel().select(grid.getStore().getCount() - 1);
	let plugin = grid.getPlugins()[0];
		plugin.startEditByPosition(
			{
				row: grid.getStore().getCount() - 1,
				column: 0
			});
	
}

function invoices_validateedit_actions(container_id, context, mode) {

	if (Ext.getCmp(container_id + "_grid").masked == true) {
		return false;
	}
}

function invoices_i01_d2_use_params(container_id) {
	var screen = pegGetCmp(container_id);
	
	let parent_container_id = pegGetVal('v_parent_container_id', container_id);
	let parent_screen__d = pegGetCmp(parent_container_id).peg__d;
	let parent_is_grid = pegGetCmp(parent_container_id).xtype == 'webappGrid';
	let mode = '';
	if(parent_screen__d.substr(0, 11) == 'retail00_01' || parent_screen__d.substr(0, 11) == 'retail00_02') {
		mode = 'retail00_01';
		var parent_d = 'retail00_01_d';
		var retail00_01_d_container_id   = pegGetContainer_id_d(parent_container_id , 'retail00_01_d'   , '' , parent_d );
		if(!retail00_01_d_container_id) {
			parent_d = 'retail00_02_d';
		}
		var retail00_01_d03_container_id = pegGetContainer_id_d(parent_container_id, 'retail00_01_d03', '', parent_d);
	} else {
		mode = pegGetCmp(parent_container_id).getMmnr01().substr(0, 3);
	}
	
	if (parent_is_grid) {
		var parent_screen = pegGetCmp(parent_container_id);
		var selection = pegGetCmp(parent_screen.getContainer_ID(), 'grid').getSelection()[0];
		let is_readonly_p03 = pegGetVal('is_readonly_p03', container_id);
		if (mode == 'a55' || mode == 'a56') {
			selection.set('p04', pegGetVal('p04', container_id));
			selection.set('p010', pegGetVal('p010', container_id));
			selection.set('p010a', pegGetVal('p010a', container_id));
			selection.set('p042', pegGetVal('p042', container_id));
			if(is_readonly_p03 == 0) {
				selection.set('p03', pegGetVal('p03_new', container_id));
			}
		} else {
			selection.set('v104', pegGetVal('p04', container_id));
			selection.set('v106', pegGetVal('p010', container_id));
			selection.set('v106a', pegGetVal('p010a', container_id));
			selection.set('v1042', pegGetVal('p042', container_id));
			if(is_readonly_p03 == 0) {
				selection.set('v103', pegGetVal('p03_new', container_id));
			}
		}
		let plugin = pegGetCmp(parent_container_id).getPlugins()[0];
			plugin.startEditByPosition(
				{
					row: plugin.context.rowIdx,
					column: plugin.context.colIdx
				});
	} else {
		let parent_id;
		if (mode == 'a55' || mode == 'a56') {
			parent_id = pegGetContainer_id_d(screen.getPeg_screen_parent_container_id(), 'i01_d101', 0, 'i01_d10');
			pegSetVal('p04', parent_id, pegGetVal('p04', container_id));
			pegSetVal('p010', parent_id, pegGetVal('p010', container_id));
			pegSetVal('p010a', parent_id, pegGetVal('p010a', container_id));
			pegSetVal('p042', parent_id, pegGetVal('p042', container_id));
			pegSetVal('p03', parent_id, pegGetVal('p03_new', container_id));
			invoices_find_product_total('i01_d10', parent_id, '', mode);
		} else if(mode == 'retail00_01') {
			
			pegSetVal('p04', retail00_01_d03_container_id, pegGetVal('p04', container_id));
			pegSetVal('p010', retail00_01_d03_container_id, pegGetVal('p010', container_id));
			pegSetVal('p010a', retail00_01_d03_container_id, pegGetVal('p010a', container_id));
			pegSetVal('p042', retail00_01_d03_container_id, pegGetVal('p042', container_id));
			pegSetVal('p03', retail00_01_d03_container_id, pegGetVal('p03_new', container_id));
			invoices_find_product_total('retail00_01_d03', retail00_01_d03_container_id, '', mode);
			retail00_update_i01(retail00_01_d03_container_id);
		} else {
			if (mode == 'a57') {
				parent_id = pegGetContainer_id_d(screen.getPeg_screen_parent_container_id(), 'a58_d00', 0, 'a58_d');
			} else if (mode == 'a67') {
				parent_id = pegGetContainer_id_d(screen.getPeg_screen_parent_container_id(), 'a68_d00', 0, 'a68_d');
			} else {
				return;
			}
			pegSetVal('v104', parent_id, pegGetVal('p04', container_id));
			pegSetVal('v106', parent_id, pegGetVal('p010', container_id));
			pegSetVal('v106a', parent_id, pegGetVal('p010a', container_id));
			pegSetVal('v1042', parent_id, pegGetVal('p042', container_id));
			pegSetVal('v103', parent_id, pegGetVal('p03_new', container_id));
			if (mode == 'a57') {
				invoices_find_product_total('a58_d', parent_id, '', mode);
			} else {
				invoices_find_product_total('a68_d', parent_id, '', mode);
			}
		}
	}
	if (screen.peg_inWindow == 1) {
		pegWindowClose(container_id);
	} else {
		pegTabClose(pegGetCmp(container_id).peg_tabid);
	}
}

var invoices_show_stock_screen_var = '';
function invoices_show_stock_screen(container_id, pno, p610, tmp_nr01) {
	if (invoices_show_stock_screen_var != '') {
		if (invoices_show_stock_screen_var.id > 0) {
			Ext.ux.AjaxDefer.abort(invoices_show_stock_screen_var);
		}
	}
	var screen = pegGetCmp(container_id);
	var screen__d = pegGetCmp(container_id).peg__d;
	let mode = '';
	if(screen__d.substr(0, 11) == 'retail00_01' || screen__d.substr(0, 11) == 'retail00_02') {
		mode = 'retail00_01';
		var parent_d = 'retail00_01_d';
		var retail00_01_d_container_id   = pegGetContainer_id_d(container_id , 'retail00_01_d'   , '' , parent_d );
		if(!retail00_01_d_container_id) {
			parent_d = 'retail00_02_d';
		}
	} else {
		mode = screen.getMmnr01().substr(0, 3);
	}
	// var mode = screen.getMmnr01().substr(0, 3);
	var ppp_params = {
		mode: mode,
		pno: pno,
		p610: p610,
		tmp_nr01: tmp_nr01,
		nr01:pegGetVal_d('nr01', container_id, mode + '_d', '', mode + '_d'),
		p590:pegGetVal_d('p590', container_id, mode + '_d', '', mode + '_d')
	};
	invoices_show_stock_screen_var = pegAjaxDefer('/' + main_path + '/invoices01/invoices_show_stock_screen.php', ppp_params, function (jsondata) {
		if (!pegIsEmpty(jsondata.text)) {
			pegToast(jsondata.text);
		}
		if (!pegIsEmpty(jsondata.availability_text_warn)) {
			pegToast(jsondata.availability_text_warn, 'warn');
		}
		if (!pegIsEmpty(jsondata.availability_text_alert)) {
			pegToast(jsondata.availability_text_alert, 'alert');
		}
	});
}

function invoices_recalc_prices(container_id) {
	invoices_recalc_prices_00(container_id);
}

var invoices_recalc_prices_ajax = '';
function invoices_recalc_prices_00(container_id, last_price="search") {
	let screen = pegGetCmp(container_id);
	var screen__d = pegGetCmp(container_id).peg__d;
	let mode = '';
	if(screen__d.substr(0, 11) == 'retail00_01' || screen__d.substr(0, 11) == 'retail00_02' || screen__d.substr(0, 9) == '_retail01') {
		mode = 'retail00_01';
		var parent_d = 'retail00_01_d';
		var retail00_01_d_container_id   = pegGetContainer_id_d(container_id , 'retail00_01_d'   , '' , parent_d );
		if(!retail00_01_d_container_id) {
			parent_d = 'retail00_02_d';
		}
	} else {
		mode = screen.getMmnr01().substr(0, 3);
	}

	let container_id_stoixeia = invoice_get_container_id_stoixeia(container_id,mode);
	let container_id_eidi = pegGetContainer_id_d(container_id, mode+'_d3', '', mode+'_d');
	if(mode!='a55' && mode!='a56'){
		if(mode == 'retail00_01') {
			container_id_eidi = pegGetContainer_id_d(container_id, mode + '_d03', 	'', parent_d); 
		}else{
			container_id_eidi = pegGetContainer_id_d(container_id, mode+'_d2', '', mode+'_d');
		}
	}
	let container_main = pegGetContainer_id_d(container_id, mode+'_d', '', mode+'_d');
	if(mode == 'retail00_01') {
		container_main = pegGetContainer_id_d(container_id, parent_d, '', parent_d);
	}
	

	params = {};
	params.container_id = container_main;
	params.p07  = invoice_get_p07(container_id,mode);
	params.p703 = invoice_get_p703(container_id,mode);
	params.mode = mode;
	params.last_price = last_price;

	let p03 = 0;//Πελάτης - Προμηθευτής
	if(mode == 'retail00_01') {
		let container_pelatis 	  = pegGetContainer_id_d(container_id, mode + '_d02', '', parent_d);
		let container_parastatiko = pegGetContainer_id_d(container_id, mode + '_d04', '', parent_d);
		params.date = pegGetVal('a55p01' , container_parastatiko);
		params.nr01 = pegGetVal('a55nr01', container_parastatiko);
		params.p03  = pegGetVal('a01nr01', container_pelatis);
		params.p09  = pegGetVal('a01p45' , container_pelatis);
		//Retail only start
		params.p03_p48  = pegGetVal('a01p48',  container_pelatis);
		params.p03_p06  = pegGetVal('a01p06',  container_pelatis);
		params.p03_p52  = pegGetVal('a01p52',  container_pelatis);
		params.p03_p52a = pegGetVal('a01p52a', container_pelatis);
		params.p03_p523 = pegGetVal('a01p523', container_pelatis);
		//Retail only end
	} else {
		let date = pegGetVal('p01', container_main);
		if (mode == 'a61'|| mode=='a60') {
			p03 = 0;
		} else {
			p03 = pegGetVal('p03', container_main);
		}
		params.date = date;
		params.nr01 = pegGetVal('nr01', container_main);
		params.p03  = p03;
		params.p09  = pegGetVal('p09', container_id_stoixeia);
	}

	params.cona11_nr01 = ''
	if(mode == 'a55') {
		params.cona11_nr01 = pegGetVal_d('p505', container_id, 'a55_d5', '', 'a55_d');
	}
	if(mode == 'a57') {
		params.cona11_nr01 = pegGetVal_d('p505', container_id, 'a57_d4', '', 'a57_d');
	}
	

	if (invoices_recalc_prices_ajax != '') {
		if (invoices_recalc_prices_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(invoices_recalc_prices_ajax);
		}
	}
	invoices_recalc_prices_ajax = pegAjaxDefer('/' + main_path + '/invoices01/recalc_prices.php', params, function (jsondata) {
		if(jsondata.last_sale_purchase_price == 1) {
			pegConfirmBox("", jsondata.msg, function(res) {
				if(res == 'yes') {
					invoices_recalc_prices_00(container_id, "recalc_last_price");
				} else {
					invoices_recalc_prices_00(container_id, "");
				}

				return;
			});			
		}

		if(jsondata.ok == 1) {
			if(!(mode=='a60' || mode=='a61')){
				invoices_calculate_total(container_id,mode);
			}
			if (mode == 'retail00_01') {
				retail00_refresh_item_grids(container_main, 1);
			} else {
				pegGridRefresh(container_id, 'grid',1);
			}
			
		}
	}, 'json');
}

var invoices_calc_efk_ajax = '';
function invoices_calc_efk(container_id) {
	const screen = pegGetCmp(container_id);
	const mode = screen.getMmnr01().substr(0, 3); //a55, a56, a57 ..

	let container_id_eidi = pegGetContainer_id_d(container_id, mode+'_d3', '', mode+'_d');
	if(mode!='a55' && mode!='a56'){
		container_id_eidi = pegGetContainer_id_d(container_id, mode+'_d2', '', mode+'_d');
	}
	const container_main = pegGetContainer_id_d(container_id, mode+'_d', '', mode+'_d')


	let ajax_params = {};
	ajax_params.container_id = container_main;
	ajax_params.p07 = invoice_get_p07(container_id,mode);
	ajax_params.mode = mode;

	if (invoices_calc_efk_ajax != '') {
		if (invoices_calc_efk_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(invoices_calc_efk_ajax);
		}
	}
	invoices_calc_efk_ajax = pegAjaxDefer('/' + main_path + '/invoices01/calculate_efk.php', ajax_params, 
	function (jsondata) {
		if (jsondata.ok == 1) {
			if(!(mode=='a60' || mode=='a61' )){
				invoices_calculate_total(container_id,mode);
			}
			pegGridRefresh(container_id, 'grid',-1);
			pegToast(jsondata.msg,'success')
		}else{
			pegAlert(jsondata.msg);
		}
	}, 'json');
}

var invoices_total_quantity_of_items_per_unit_ajax = '';
function invoices_total_quantity_of_items_per_unit(container_id) {
	const screen = pegGetCmp(container_id);
	const mode = screen.getMmnr01().substr(0, 3); //a55, a56, a57 ..

	let container_id_eidi = pegGetContainer_id_d(container_id, mode+'_d', '', mode+'_d');

	if (invoices_total_quantity_of_items_per_unit_ajax != '') {
        if (invoices_total_quantity_of_items_per_unit_ajax.id > 0) {
            Ext.ux.AjaxDefer.abort(invoices_total_quantity_of_items_per_unit_ajax);
        }
    }

    let params = {};
	params.container_id = container_id_eidi;
	params.mode = mode;

    invoices_total_quantity_of_items_per_unit_ajax = pegAjaxDefer('/' + main_path + '/invoices01/invoices_total_quantity_of_items_per_unit.php', params, function(jsondata) {
		pegAlert(jsondata.msg, jsondata.title);
    });
}

var invoices_total_quantity_per_item_ajax = '';
function invoices_total_quantity_per_item(container_id) {
	if (invoices_total_quantity_per_item_ajax != '') {
        if (invoices_total_quantity_per_item_ajax.id > 0) {
            Ext.ux.AjaxDefer.abort(invoices_total_quantity_per_item_ajax);
        }
    }
	
	const screen = pegGetCmp(container_id);
	const mode = screen.getMmnr01().substr(0, 3); //a55, a56, a57 ..

	let container_id_eidi = pegGetContainer_id_d(container_id, mode+'_d', '', mode+'_d');

    let params = {};
	params.container_id = container_id_eidi;
	params.mode = mode;

    invoices_total_quantity_per_item_ajax = pegAjaxDefer('/' + main_path + '/invoices01/invoices_total_quantity_per_item.php', params, function(jsondata) {
		pegAlert(jsondata.msg, jsondata.title);
    });
}

function invoices__invoices_online_show(
	screen = {}
) {
	const container_id = screen.getContainer_ID();
	let kath_fpa = 0;
	let p09_val	 = 0;
	let p01 	 = '0100-01-01';

	let mmnr01 = screen.getMmnr01();
	let mnr01  = screen.getMnr01();
	let nr01   = screen.getNr01();
	
	if(screen.peg__d == 'retail00_01_d' || screen.peg__d == 'retail00_02_d00' || screen.peg__d == '_retail01_ecr_sim_d') {
		var parent_d = 'retail00_01_d';
		var retail00_01_d_container_id   = pegGetContainer_id_d(container_id , 'retail00_01_d'   , 0 , parent_d );
		if(!retail00_01_d_container_id) {
			parent_d = 'retail00_02_d';
			if(screen.peg_screen_parent_container_id) {
				retail00_01_d_container_id = pegGetContainer_id_d(screen.peg_screen_parent_container_id , 'retail00_02_d'   , 0 , parent_d );
			}
		}
		var retail00_01_d02_container_id = pegGetContainer_id_d(container_id, 'retail00_01_d02', '', parent_d);
		var retail00_01_d04_container_id = pegGetContainer_id_d(container_id, 'retail00_01_d04', '', parent_d);

		p01    	= pegGetVal('a55p01', retail00_01_d04_container_id);
		p09_val = pegGetVal('a01p45', retail00_01_d02_container_id);

		let a55nr01 = pegGetVal('a55nr01', retail00_01_d04_container_id);

		mmnr01 = 'a55_d-' + a55nr01;
		mnr01  = a55nr01;
		nr01   = a55nr01;
	}else{
		if(screen.getMmnr01().split('-')[0] == 'a55_d') {
			const a55_d_container_id=pegGetContainer_id_d(container_id,'a55_d','','a55_d')
			const a55_d4_container_id=pegGetContainer_id_d(container_id,'a55_d4','','a55_d')
			p09_val=pegGetVal('p09',a55_d4_container_id)
			p01=pegGetVal('p01',a55_d_container_id)
		}
		else if(screen.getMmnr01().split('-')[0] == 'a56_d') {
			const a56_d_container_id=pegGetContainer_id_d(container_id,'a56_d','','a56_d')
			const a56_d4_container_id=pegGetContainer_id_d(container_id,'a56_d4','','a56_d')
			p09_val=pegGetVal('p09',a56_d4_container_id)
			p01=pegGetVal('p01',a56_d_container_id)
		}
		else if(screen.getMmnr01().split('-')[0] == 'a57_d') {
			const a57_d_container_id=pegGetContainer_id_d(container_id,'a57_d','','a57_d')
			const a57_d3_container_id=pegGetContainer_id_d(container_id,'a57_d3','','a57_d')
			p09_val=pegGetVal('p09',a57_d3_container_id)
			p01=pegGetVal('p01',a57_d_container_id)
		}
		else if(screen.getMmnr01().split('-')[0] == 'a67_d') {
			const a67_d_container_id=pegGetContainer_id_d(container_id,'a67_d','','a67_d')
			const a67_d3_container_id=pegGetContainer_id_d(container_id,'a67_d3','','a67_d')
			p09_val=pegGetVal('p09',a67_d3_container_id)
			p01=pegGetVal('p01',a67_d_container_id)
		}
		else if(screen.getMmnr01().split('-')[0] == 'a60_d') {
			const a60_d_container_id=pegGetContainer_id_d(container_id,'a60_d','','a60_d')
			p01=pegGetVal('p01',a60_d_container_id)
		}
		else if(screen.getMmnr01().split('-')[0] == 'a61_d') {
			const a60_d_container_id=pegGetContainer_id_d(container_id,'a61_d','','a61_d')
			p01=pegGetVal('p01',a60_d_container_id)		

		}else if(screen.getMmnr01().split('-')[0] == 'tran01_d') {
			const tran01_d_container_id   = pegGetContainer_id_d(container_id,'tran01_d','','tran01_d');
			const tran01_d01_container_id = pegGetContainer_id_d(container_id,'tran01_d01','','tran01_d');

			p01     = pegGetVal('p301', tran01_d_container_id)	
			p09_val = pegGetVal('p114', tran01_d01_container_id)	
		}
	}
	
	
	
	if(p09_val > 0) {
		kath_fpa = p09_val
	}

	return peg_windowShow_d(
		'',
		'_invoices_online_d',
		'invoices',
		container_id,
		'',
		0,
		null,
		'',
		{
			mmnr01: mmnr01,
			mnr01: mnr01,
			nr01: nr01,
			kath_fpa : kath_fpa,
			date : p01,
			peg_screen_parent_container_id: container_id
		},
		true,
		true,
		0,
		'',
		'tablet'
	)
}

function invoices__invoices_online_d_afterDraw_listeners(container_id = '') {
	const code = pegGetCmp(container_id, 'code');
	const v103 = pegGetCmp(container_id, 'v103');
	const btn00 = pegGetCmp(container_id, 'btn00');
	const btn01 = pegGetCmp(container_id, 'btn01');
	const btn02 = pegGetCmp(container_id, 'btn02');
	const v_auto_add = pegGetCmp(container_id, 'v_auto_add');

	v103.on('change', function (me, newValue, oldValue, eOpts) {
		 if(newValue < 0) {
			pegSetVal('v103', container_id, 0);
		 }
	});

	v_auto_add.on('change', function (me, newValue, oldValue, eOpts) {
		 if(newValue) {
			pegSetFieldReadonly('v103', container_id, newValue);
		 } else {
			const code_val = pegGetVal('code', container_id)
			
			const values = {
				code: code_val,
				a00_nr01: 0
			}

			if(code_val != '') {
				return invoices__invoices_online_find(
					container_id,
					values
				)
			}			
		 }
	})
	// "C324_code-trigger-scanQR"
	code.on('peg_qrscan_success', function (myTextfield, decodedText,decodedResult){
		const values = {
			code: decodedText,
			a00_nr01: 0
		}
		return invoices__invoices_online_find(
			container_id,
			values,
			function(v103_value) {
				const v_auto_add_value = pegGetVal('v_auto_add',container_id)
				if(v_auto_add_value) {
					WebApp.view.field.Text.scanQR(code)
				}
			}
		)
	})
	code.on('keyup', function (me, event) {
		
		if (event.keyCode !== 13) {
			return false;
		}
		if(me.getValue() == '') {
			return false;
		}
		const values = {
			code: me.getValue(),
			a00_nr01: 0
		}
		return invoices__invoices_online_find(
			container_id,
			values
		)
	})
	btn02.on('click', function (me, event) {
		WebApp.view.field.Text.scanQR(code)
	})
	btn00.on('click', function (me, event) {
		const v101_val = pegGetVal('v101', container_id)
		const code_val = pegGetVal('code', container_id)
		if (!v101_val) {
			if(code_val != '') {
				const v_values = {
					code: code_val,
					a00_nr01: 0
				}
				return invoices__invoices_online_find(
					container_id,
					v_values,
					function(v103_val) {
						pegSetVal('v103',container_id,v103_val)
						if(pegGetVal('v_auto_add',container_id) == 0) {
							btn00.click()
						}
					}
				)
			}
			return;
		}
		const values = {
			code: pegGetVal('code', container_id),
			p9000: pegGetVal('p9000', container_id),
			ser: pegGetVal('ser', container_id),
			timh1: pegGetVal('timh1', container_id),
			timh2: pegGetVal('timh2', container_id),
			timh3: pegGetVal('timh3', container_id),
			timh4: pegGetVal('timh4', container_id),
			type: pegGetVal('type', container_id),
			v101: v101_val,
			v102: pegGetVal('v102', container_id),
			v103: pegGetVal('v103', container_id),
			v104: pegGetVal('v104', container_id),
			v161: pegGetVal('v161', container_id),
			v172: pegGetVal('v172', container_id),
			v173: pegGetVal('v173', container_id),
			v_baltot: pegGetVal('v_baltot', container_id),
			v_cusord: pegGetVal('v_cusord', container_id),
			v_locbaltot: pegGetVal('v_locbaltot', container_id),
			v_loccusord: pegGetVal('v_loccusord', container_id),
			v_locsuppord: pegGetVal('v_locsuppord', container_id),
			v_suppord: pegGetVal('v_suppord', container_id),
			vtype: pegGetVal('vtype', container_id),
			kath_fpa : pegGetVal('kath_fpa', container_id),
			date : pegGetVal('date', container_id)
		}
		return invoices__invoices_online_insert(
			container_id,
			values
		)
	})
	btn01.on('click', function (me, event) {
		return invoices__invoices_online_reset(container_id,true)
	})
}
/**
 * 
 * @param {String} container_id 
 */
function invoices_a10_d_afterDraw_listeners(container_id) {

	const btn00 = pegGetCmp(container_id, 'btn00');	
	const p500  = pegGetCmp(container_id, 'p500');
	
	btn00.on('click', function (me) {
		const values = {
			invoices_p500: p500.value
		}
		return peg_windowShow_d(
			'',
			'a10_d01',
			'invoices',
			container_id,
			'',
			0,
			null,
			'',
			values,
			true,
			true,
			0,
			'',
			'tablet'
		);
	})
}
/**
 * 
 * @param {String} container_id 
 */
function invoices_a11_d_afterDraw_listeners(container_id) {

	const btn00 = pegGetCmp(container_id, 'btn00');	
	const p500  = pegGetCmp(container_id, 'p500');
	
	btn00.on('click', function (me) {
		const values = {
			invoices_p500: p500.value
		}
		return peg_windowShow_d(
			'',
			'a10_d01',
			'invoices',
			container_id,
			'',
			0,
			null,
			'',
			values,
			true,
			true,
			0,
			'',
			'tablet'
		);
	})
}
/**
 * 
 * @param {String} container_id 
 */
function invoices_a10_d01_afterDraw_listeners(container_id) {
	const grid00 = pegGetCmp(container_id, 'grid00');
	const grid01 = pegGetCmp(container_id, 'grid01');

	pegGetCmp(container_id,"grid00").setPegMultiSelect(true);
	pegGetCmp(container_id,"grid01").setPegMultiSelect(true);
	
	grid00.on('drop', function (node, data, dropRec, dropPositio) {
		return invoices_selected_items_wrap_grid_rows_update(container_id, data.records, true)
	})
	grid01.on('drop', function (node, data, dropRec, dropPositio) {
		return invoices_selected_items_wrap_grid_rows_update(container_id, data.records, false)
	})
}
invoices_selected_items_wrap_grid_rows_update_ajax = ''
function invoices_selected_items_wrap_grid_rows_update(container_id, records, add = true) {
	let ret = []
	if (records) {
		records.forEach(record => {
			ret.push([record.data.pno])
		})
	}
	let drop = ret.join('#')

	if (invoices_selected_items_wrap_grid_rows_update_ajax != '') {
		if (invoices_selected_items_wrap_grid_rows_update_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(invoices_selected_items_wrap_grid_rows_update_ajax)
		}
	}
	const url = '/' + main_path + '/invoices01/invoices_selected_items_wrap_grid_rows_update.php'
	const params = {
		container_id: container_id,
		drop: drop,
		add: add ? 1 : 0
	}
	invoices_selected_items_wrap_grid_rows_update_ajax = pegAjaxDefer(url, params, function (jsonData) {
		invbalance_f01_set_date_range_ajax = ''
		if (!jsonData) {
			return next(Error('pegAjaxDefer response error'))
		}
		if (jsonData.ok != 1) {
			return next(Error(jsonData.msg))
		}
		return true
	}, 'json', 1, true)
	return true
}
var invoices_selected_items_for_invoice_ajax = '';
/**
 * 
 * @returns 
 */
function invoices_selected_items_for_invoice(container_id) {

	parent_container_id = pegGetCmp(container_id).peg_screen_parent_container_id;
	params = {
		container_id : container_id
	};
	if (invoices_selected_items_for_invoice_ajax != '') {
		if (invoices_selected_items_for_invoice_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(invoices_selected_items_for_invoice_ajax);
		}
	}
	invoices_selected_items_for_invoice_ajax = pegAjaxDefer('/' + main_path + '/invoices01/invoices_selected_items_for_invoice.php',
	params, function(jsonData){
		pegSetVal('p500', parent_container_id, jsonData.data);
		pegWindowClose(Ext.getCmp(container_id).up().id)
	});
}
function invoices__invoices_online_reset(
	container_id = '',
	clear_log = false
) {
	const code = pegGetCmp(container_id, 'code');
	const v_auto_add_val=pegGetVal('v_auto_add',container_id)
	if(clear_log) {
		pegSetVal('v_info', container_id, '')
	}
	pegSetVal('code', container_id, '')
	pegSetVal('p9000', container_id, '')
	pegSetVal('ser', container_id, '')
	pegSetVal('timh1', container_id, '')
	pegSetVal('timh2', container_id, '')
	pegSetVal('timh3', container_id, '')
	pegSetVal('timh4', container_id, '')
	pegSetVal('type', container_id, '')
	pegSetVal('v101', container_id, '')
	pegSetVal('v102', container_id, '')
	pegSetVal('v103', container_id, 1)
	pegSetVal('v104', container_id, 0)
	pegSetVal('v161', container_id, '')
	pegSetVal('v172', container_id, '')
	pegSetVal('v173', container_id, '')
	pegSetVal('v_baltot', container_id, '')
	pegSetVal('v_cusord', container_id, '')
	pegSetVal('v_locbaltot', container_id, '')
	pegSetVal('v_loccusord', container_id, '')
	pegSetVal('v_locsuppord', container_id, '')
	pegSetVal('v_suppord', container_id, '')
	pegSetVal('vtype', container_id, '')
	//pegSetFieldReadonly('v103',container_id,v_auto_add_val)
	code.focus()
}
var invoices__invoices_online_insert_ajax = ''
function invoices__invoices_online_insert(
	container_id = '',
	values = {}
) {
	if (invoices__invoices_online_insert_ajax != '') {
		if (invoices__invoices_online_insert_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(invoices__invoices_online_insert_ajax)
		}
	}

	const screen = pegGetCmp(container_id);
	let mode = screen.getMmnr01().substr(0, 3);
	let a37_from_order = 0;

	var parent_screen = pegGetCmp(screen.peg_screen_parent_container_id);
	var parent_mode = '';
	if( parent_screen && (parent_screen.peg__d == 'retail00_01_d' || parent_screen.peg__d == 'retail00_02_d00' || parent_screen.peg__d == '_retail01_ecr_sim_d') ) {
		parent_mode = 'retail00_01';
	}

	const params = {
		mmnr01: screen.getMmnr01(),
		mnr01: screen.getMnr01(),
		code: values.code,
		p9000: values.p9000,
		ser: values.ser,
		timh1: values.timh1,
		timh2: values.timh2,
		timh3: values.timh3,
		timh4: values.timh4,
		type: values.type,
		v101: values.v101,
		v102: values.v102,
		v103: values.v103,
		v104: values.v104,
		v161: values.v161,
		v172: values.v172,
		v173: values.v173,
		v_baltot: values.v_baltot,
		v_cusord: values.v_cusord,
		v_locbaltot: values.v_locbaltot,
		v_loccusord: values.v_locsuppord,
		v_locsuppord: values.v_locsuppord,
		v_suppord: values.v_suppord,
		vtype: values.vtype,
		date: values.date
	}

	if(mode == "a37") {
		stoixeia_container_id = pegGetContainer_id_d(container_id, 'a37_d01' , '', 'a37_d')

		let a37_p08  = pegGetVal('p08', stoixeia_container_id);
		let a37_p09  = pegGetVal('p09', stoixeia_container_id);
		let a37_p012 = pegGetVal('p012', stoixeia_container_id);
		
		if(a37_p08 > 0 || a37_p09 > 0 || a37_p012 > 0) {
			a37_from_order = 1;
		}
	}

	params.a37_from_order = a37_from_order;

	invoices__invoices_online_insert_ajax = pegAjaxDefer('/' + main_path + '/invoices01/invoices__invoices_online_insert.php', params, function (jsondata) {
		if (!jsondata) {
			return pegAlert('pegAjaxDefer Error');
		}
		if (jsondata.ok != 1) {
			return pegAlert(jsondata.msg)
		}
		invoices__invoices_online_reset(container_id,false);
		if(parent_mode == 'retail00_01') {
			retail00_refresh_item_grids(screen.getPeg_screen_parent_container_id(), jsondata.data.product_nr01);
			invoices_calculate_total(screen.getPeg_screen_parent_container_id(), 'retail00_01')
		}else{
			if (jsondata.data._d) {
				const parent_grid_container_id = screen.getPeg_screen_parent_container_id()
				const parent_grid = pegGetCmp(parent_grid_container_id,'grid');
				pegGridRefresh(parent_grid.getContainer_ID(), parent_grid.name)
				// _d Exceptions
				if (jsondata.data._d == 'a55_d') {
					const a55_d_container_id = pegGetContainer_id_d(parent_grid_container_id, 'a55_d', '', 'a55_d')
					invoices_calculate_total(a55_d_container_id, 'a55')
				}
				else if (jsondata.data._d == 'a56_d') {
					const a56_d_container_id = pegGetContainer_id_d(parent_grid_container_id, 'a56_d', '', 'a56_d')
					invoices_calculate_total(a56_d_container_id, 'a56')
				}
				else if (jsondata.data._d == 'a57_d') {
					const a57_d_container_id = pegGetContainer_id_d(parent_grid_container_id, 'a57_d', '', 'a57_d')
					invoices_calculate_total(a57_d_container_id, 'a57')
				}
				else if (jsondata.data._d == 'a67_d') {
					const a67_d_container_id = pegGetContainer_id_d(parent_grid_container_id, 'a67_d', '', 'a67_d')
					invoices_calculate_total(a67_d_container_id, 'a67')

				}else if (jsondata.data._d == 'tran01_d') {
					var tran01_d_container_id   = pegGetContainer_id_d(parent_grid_container_id, 'tran01_d', '', 'tran01_d');
					var tran01_d00_container_id = pegGetContainer_id_d(parent_grid_container_id, 'tran01_d00', '', 'tran01_d');
					var tran01_d01_container_id = pegGetContainer_id_d(parent_grid_container_id, 'tran01_d01', '', 'tran01_d');
					var tran01_d06_container_id = pegGetContainer_id_d(parent_grid_container_id, 'tran01_d06', '', 'tran01_d');
					
					const grid = pegGetCmp(tran01_d00_container_id, 'grid');
					const values = {
						p114: 	pegGetVal('p114', tran01_d01_container_id),
						p014: 	pegGetVal('p014', tran01_d_container_id),
						p72:	pegGetVal('p72', tran01_d06_container_id),
						p73: 	pegGetVal('p73', tran01_d06_container_id),
						p74: 	pegGetVal('p74', tran01_d06_container_id),
						p75: 	pegGetVal('p75', tran01_d06_container_id),
						p76: 	pegGetVal('p76', tran01_d06_container_id),
						p77: 	pegGetVal('p77', tran01_d06_container_id),
						p78: 	pegGetVal('p78', tran01_d06_container_id),
						sp01: 	pegGetVal('sp01', tran01_d_container_id),
						sp03: 	pegGetVal('sp03', tran01_d_container_id),
						p011a: 	pegGetVal('p011a', tran01_d_container_id)
					}
			
					if(typeof tran_tran01_d_updateValues === 'function') {
						tran_tran01_d_updateValues(tran01_d_container_id, values, function (data) {
							//pegToast('tran_tran01_d_updateValues');
						});
					}
				}
			}
		}
		
		let log = pegGetVal('v_info', container_id)
		log = jsondata.msg+ '\n'+log
		pegSetVal('v_info', container_id, log)
	});
	return true
}
var invoices__invoices_online_find_ajax = ''
function invoices__invoices_online_find(
	container_id = '',
	values = {},
	next
) {
	const btn00 = pegGetCmp(container_id, 'btn00');
	if (invoices__invoices_online_find_ajax != '') {
		if (invoices__invoices_online_find_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(invoices__invoices_online_find_ajax)
		}
	}
	const screen = pegGetCmp(container_id)
	let mode = screen.getMmnr01().substr(0, 3);
	let a37_from_order = 0;

	if(mode == "a56" || mode == "a67") {
		main_container_id = pegGetContainer_id_d(container_id, mode+'_d', '', mode+'_d');
		values.a00_nr01 = pegGetVal('p03', main_container_id);
	}

	const params = {
		code		: values.code,
		a00_nr01	: values.a00_nr01,
		mmnr01		: screen.getMmnr01(),
		v_auto_add	: pegGetVal('v_auto_add', container_id)
	}

	if(mode == "a37") {
		stoixeia_container_id = pegGetContainer_id_d(container_id, 'a37_d01' , '', 'a37_d')

		let a37_p08  = pegGetVal('p08', stoixeia_container_id);
		let a37_p09  = pegGetVal('p09', stoixeia_container_id);
		let a37_p012 = pegGetVal('p012', stoixeia_container_id);
		
		if(a37_p08 > 0 || a37_p09 > 0 || a37_p012 > 0) {
			a37_from_order = 1;
		}
	}

	params.a37_from_order = a37_from_order;

	invoices__invoices_online_find_ajax = pegAjaxDefer('/' + main_path + '/invoices01/invoices__invoices_online_find.php', params, function (jsondata) {
		if (!jsondata) {
			return pegAlert('pegAjaxDefer Error');
		}
		if (jsondata.ok != 1) {
			return pegAlert(jsondata.msg)
		}
		let v103_val=pegGetVal('v103',container_id)
		if (jsondata.data) {
			if(jsondata.data.v103 != 1) {
				v103_val = jsondata.data.v103;
			}
			pegSetVal('code', container_id, jsondata.data.code)
			pegSetVal('p9000', container_id, jsondata.data.p9000)
			pegSetVal('ser', container_id, jsondata.data.ser)
			pegSetVal('timh1', container_id, jsondata.data.timh1)
			pegSetVal('timh2', container_id, jsondata.data.timh2)
			pegSetVal('timh3', container_id, jsondata.data.timh3)
			pegSetVal('timh4', container_id, jsondata.data.timh4)
			pegSetVal('type', container_id, jsondata.data.type)
			pegSetVal('v101', container_id, jsondata.data.v101)
			pegSetVal('v102', container_id, jsondata.data.v102)
			pegSetVal('v103', container_id, jsondata.data.v103)
			pegSetVal('v104', container_id, jsondata.data.v104)
			pegSetVal('v161', container_id, jsondata.data.v161)
			pegSetVal('v172', container_id, jsondata.data.v172)
			pegSetVal('v173', container_id, jsondata.data.v173)
			pegSetVal('v_baltot', container_id, jsondata.data.v_baltot)
			pegSetVal('v_cusord', container_id, jsondata.data.v_cusord)
			pegSetVal('v_locbaltot', container_id, jsondata.data.v_locbaltot)
			pegSetVal('v_loccusord', container_id, jsondata.data.v_loccusord)
			pegSetVal('v_locsuppord', container_id, jsondata.data.v_locsuppord)
			pegSetVal('v_suppord', container_id, jsondata.data.v_suppord)
			pegSetVal('vtype', container_id, jsondata.data.vtype)

			let v_auto_add = pegGetVal('v_auto_add', container_id);

			if(v_auto_add == 0) {
				pegSetFieldReadonly('v103', container_id, false);
				if(jsondata.data.ser.trim()!='' || jsondata.data.has_colorsize == 1) {
					pegSetFieldReadonly('v103', container_id, true);
				}
			} else {
				pegSetFieldReadonly('v103', container_id, true);
			}

			btn00.focus()
		} else {
			pegSetVal('code', container_id, '')
		} 
		let log = pegGetVal('v_info', container_id)
		log = jsondata.msg+ '\n'+log
		pegSetVal('v_info', container_id, log)
		const v_auto_add_val = pegGetVal('v_auto_add',container_id)
		if(v_auto_add_val) {
			pegSetVal('v103',container_id,v103_val)
			btn00.click()
			if(next) {
				next(v103_val);
			}
		}
		else {
			if(next) {
				next(v103_val);
			}
		}
		return true
	});
	return true
}
/**
 * 
 * @param {object} screen 
 * @returns 
 */
function invoices__invoices_masschange_show(
	screen ={}
) {
	let p01=null;
	const container_id = screen.getContainer_ID();
	const grid = pegGetCmp(container_id,'grid')
	if(grid) {
		const selection = grid.getSelection();
		if(
			selection
			&& selection[0]
			&& selection[0].data
			&& selection[0].data.p01
		) {
			p01 = selection[0].data.p01
		}
		if(
			selection
			&& selection[0]
			&& selection[0].data
			&& selection[0].data.v101
		) {
			p01 = selection[0].data.v101
		}
	}
	return peg_windowShow_d(
		'',
		'_invoices_masschange_d',
		'invoices',
		container_id,
		'',
		0,
		null,
		'',
		{
			mmnr01	: screen.getMmnr01(),
			mnr01	: screen.getMnr01(),
			nr01	: screen.getNr01(),
			p01		: p01
		},
		true,
		true,
		0,
		'',
		'tablet'
	)
}
var invoices__invoices_masschange_check_ajax=''
/**
 * 
 * @param {object} screen 
 * @returns 
 */
function invoices__invoices_masschange_check(
	screen ={}
) {
	const container_id= screen.getContainer_ID();
	if (invoices__invoices_masschange_check_ajax != '') {
		if (invoices__invoices_masschange_check_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(invoices__invoices_masschange_check_ajax)
		}
	}
	const params = {
		mmnr01	: screen.getMmnr01(),
		p01		: pegGetVal('p01',container_id),
		p04		: pegGetVal('p04',container_id)
	}
	invoices__invoices_masschange_check_ajax = pegAjaxDefer('/' + main_path + '/invoices01/invoices__invoices_masschange_check.php', params, function (jsondata) {
		if (!jsondata) {
			return pegAlert('pegAjaxDefer Error')
		}
		if(jsondata.ok!=1) {
			return pegAlert(jsondata.msg)
		}
		return pegConfirmBox(jsondata.data.title,jsondata.data.message,function(ans) {
			if(ans!='yes') {
				return true
			}
			return invoices__invoices_masschange_update(screen)
		})
	})
	return true
}
var invoices__invoices_masschange_update_ajax=''
/**
 * 
 * @param {object} screen 
 * @returns 
 */
function invoices__invoices_masschange_update(
	screen ={}
)
{
	const container_id= screen.getContainer_ID();
	if (invoices__invoices_masschange_update_ajax != '') {
		if (invoices__invoices_masschange_update_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(invoices__invoices_masschange_update_ajax)
		}
	}
	const params = {
		mmnr01	: screen.getMmnr01(),
		p01		: pegGetVal('p01',container_id),
		p04		: pegGetVal('p04',container_id)
	}
	invoices__invoices_masschange_update_ajax = pegAjaxDefer('/' + main_path + '/invoices01/invoices__invoices_masschange_update.php', params, function (jsondata) {
		if (!jsondata) {
			return pegAlert('pegAjaxDefer Error')
		}
		if(jsondata.ok!=1) {
			return pegAlert(jsondata.msg)
		}
		if(jsondata.data.mode) {
			let grid_container_id=false
			let main_container_id=false
			switch(jsondata.data.mode) {
				case 'a55' :
					grid_container_id=pegGetContainer_id_d(container_id, 'a55_d3', '', 'a55_d')
					main_container_id=pegGetContainer_id_d(container_id, 'a55_d', '', 'a55_d')
					break
				case 'a56' :
					grid_container_id=pegGetContainer_id_d(container_id, 'a56_d3', '', 'a56_d')
					main_container_id=pegGetContainer_id_d(container_id, 'a56_d', '', 'a56_d')
					break
				case 'a57' :
					grid_container_id=pegGetContainer_id_d(container_id, 'a57_d2', '', 'a57_d')
					main_container_id=pegGetContainer_id_d(container_id, 'a57_d', '', 'a57_d')
					break
				case 'a67' :
					grid_container_id=pegGetContainer_id_d(container_id, 'a67_d2', '', 'a67_d')
					main_container_id=pegGetContainer_id_d(container_id, 'a67_d', '', 'a67_d')
					break
				case 'a60' :
					grid_container_id=pegGetContainer_id_d(container_id, 'a60_d2', '', 'a60_d')
					break
				case 'a61' :
					grid_container_id=pegGetContainer_id_d(container_id, 'a61_d2', '', 'a61_d')
					break
			}
			if(grid_container_id) {
				const grid=pegGetCmp(grid_container_id,'grid')
				if(grid) {
					pegGridRefresh(grid.getContainer_ID(), grid.name);
				}
			}
			if(main_container_id) {
				invoices_calculate_total(main_container_id,jsondata.data.mode)
			}
		}
		return pegWindowClose(container_id)
	})
	return true
}


var invoices_find_earnings_ajax = '';
function invoices__invoices_find_invoice_earn_d_afterDraw_listeners(
	container_id = ''
) {
	const screen = pegGetCmp(container_id);
	const mode = screen.getMmnr01().substr(0, 3);

	const container_main = screen.getPeg_screen_parent_container_id();//pegGetContainer_id_d(container_id, mode + '_d', '', mode + '_d')	

	if (mode == 'a61' || mode == 'a60') {
		p03 = 0;
	} else {
		p03 = pegGetVal('p03', container_main);
	}

	let ajax_params = {};
	ajax_params.container_id = container_main;
	ajax_params.mode = mode;
	ajax_params.p703 = invoice_get_p703(container_id, mode);
	ajax_params.date = pegGetVal('p01', container_main);;
	ajax_params.p0100 = pegGetVal('p0100', container_main);
	ajax_params.p0102 = pegGetVal('p0102', container_main);

	if (invoices_find_earnings_ajax != '') {
		if (invoices_find_earnings_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(invoices_find_earnings_ajax);
		}
	}
	invoices_find_earnings_ajax = pegAjaxDefer('/' + main_path + '/invoices01/find_invoice_earn.php', ajax_params, function (jsondata) {
		if (jsondata.ok == 1) {
			pegSetVal('te01',container_id, jsondata.nte01);
			pegSetVal('te02',container_id, jsondata.nte02);
			pegSetVal('te03',container_id, jsondata.nte03);
			pegSetVal('te04',container_id, jsondata.nte04);
			pegSetVal('te05',container_id, jsondata.nte05);
			pegSetVal('te020',container_id, jsondata.nte020);
			pegSetVal('te030',container_id, jsondata.nte030);
			pegSetVal('te040',container_id, jsondata.nte040);
			pegSetVal('te050',container_id, jsondata.nte050);

		}
	}, 'json');
}


var invoices_change_product_vat_category_ajax = '';
function invoices_change_product_vat_category(container_id, mode, i13p01){

	let params = {};
	params.container_id = container_id;
	params.mode 		= mode;
	params.i13p01 		= i13p01;


	if (invoices_change_product_vat_category_ajax != '') {
		if (invoices_change_product_vat_category_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(invoices_change_product_vat_category_ajax);
		}
	}

	invoices_change_product_vat_category_ajax = pegAjaxDefer('/' + main_path + '/invoices01/change_product_vat_category.php', params, function (jsondata) {
		if (jsondata.ok == 1) {
			if (mode=='a55' || mode=='a56' || mode=='a60' || mode=='retail00_01') {
				pegSetVal('p08', container_id, jsondata.i13.p03);
				pegSetFieldReadonly('p08', container_id, true);

			}else if(mode=='a57' || mode=='a67' || mode=='a61'){
				pegSetVal('v105', container_id, jsondata.i13.p03);
				pegSetFieldReadonly('v105', container_id, true);
			}
		}
	}, 'json');
}

function invoices_check_if_parts(container_id, callback){  //Syskevasies
	let screen = pegGetCmp(container_id);

	if(screen.getMmnr01()) {
		mmnr01 = screen.getMmnr01();
	} else {
		mmnr01 = screen.peg__d;
	}

	mode = mmnr01.substr(0, mmnr01.indexOf('_d'));

	if(mode == "a55" || mode == "a56" || mode == "a60" || mode == "retail00_01") {
		p030_1 = pegGetVal('p030_1' ,container_id);
	} else {
		p030_1 = pegGetVal('v1030_1' ,container_id);
	}

	params={
		p030_1    : p030_1,
		v_i00_ths : pegGetVal('v_i00_ths' ,container_id),
		mode      : mode
	};

	pegAjaxDefer('/' + main_path + '/invoices01/check_if_parts.php' , params ,function(jsondata){
		callback(jsondata);
	});			
}

function invoices_save_invoice(screen, pay = 0){
	if(pay == 1) {
		pegSetVal('y_ekd', screen.getContainer_ID(), '1');
		WebApp.view.toolbar.button.SaveUpdate.pegSave_d(screen.getContainer_ID(), 0, function(){

			var device = '';
			if(peg002_IsMobileOrTabletScreen() || peg002_HasTouchScreenCheck()){
				device = 'mobile';
			}

			peg_windowShow_d(
				'', 
				'_account00_pay_d', 
				'account00', 
				'', //* το βαζω να ανοίγει στο main με modal true
				'', 0 , '', '',  
				{
				peg_screen_parent_container_id: screen.peg_screen_parent_container_id,
				peg_screen_parent_element_name: screen.peg_screen_parent_element_name,
				account00_tbl: 'a55',
				account00_tbl_nr01: screen.getNr01(),
				account00_tbl_mode: '',
				device: device
				},
				true,false,0,0, 
				'tablet'
			);
		}, '', 1)
	}else{
		pegSetVal('y_ekd', screen.getContainer_ID(), '0');
		WebApp.view.toolbar.button.SaveUpdate.pegSave_d(screen.getContainer_ID(), 0, function(){
			var temp_screen_nr01 = screen.getNr01();
			var container_id_stoixeia = pegGetContainer_id_d(screen.getContainer_ID(), 'a55_d4', '', 'a55_d');
			var p08=pegGetVal('p08', container_id_stoixeia);
			invcust_a55_d_on_save(screen.getContainer_ID(), temp_screen_nr01, p08);
		}, '', 1)
	}
}

function invoice_p07_change(container_id, mode, callback){
	let prefix = "";

	var main_container_id = pegGetContainer_id_d(container_id, mode+'_d', '', mode+'_d');
	if(mode == 'a55' || mode == 'a56') {
		var container_id_stoixeia  = pegGetContainer_id_d(container_id, mode+'_d4', '', mode+'_d');
	} else if(mode == 'a57' || mode == 'a67') {
		var container_id_stoixeia  = pegGetContainer_id_d(container_id, mode+'_d3', '', mode+'_d');
	}

	if(mode == 'retail00_01') {
		prefix = "a55";

		var parent_d = 'retail00_01_d';
		var retail00_01_d_container_id   = pegGetContainer_id_d(container_id , 'retail00_01_d'   , '' , parent_d );
		if(!retail00_01_d_container_id) {
			parent_d = 'retail00_02_d';
			retail00_01_d_container_id = pegGetContainer_id_d(container_id , 'retail00_02_d'   , '' , parent_d );
		}

		var container_id_stoixeia  = pegGetContainer_id_d(container_id, 'retail00_01_d04', '', parent_d);

		main_container_id = container_id_stoixeia;
	}

	let p07 = pegGetVal(prefix+'p07', container_id_stoixeia); // Τιμές με ΦΠΑ
	let p0109 = pegGetVal(prefix+'p0109', main_container_id); // Σύνολο

	// Γίνεται έλεγχος του πεδίου [Σύνολο] ώστε να μην εμφανίζεται αχρείστατα το συγκεκριμένο μήνυμα
	if(!p07 && p0109 > 0) {
		pegGetDic('peg_dic_invoices_recalc_unit_price_1', function(msg) {
			pegConfirmBox("", msg, function(res) {
				if(res == 'yes') {
					invoice_p07_change_00(container_id , mode, 1, callback);
				} else {
					invoice_p07_change_00(container_id , mode, 0, callback);
				}

				return;
			});			
		});
	} else {
		invoice_p07_change_00(container_id , mode, 0, callback);				
	}
}

var invoice_p07_change_ajax = '';
function invoice_p07_change_00(container_id , mode, recalculate_unit_price, callback) {
	let prefix = '';

	switch(mode) {
		case 'a55' :
			main_container_id     = pegGetContainer_id_d(container_id, 'a55_d' , '', 'a55_d');
			stoixeia_container_id = pegGetContainer_id_d(container_id, 'a55_d4', '', 'a55_d');
			container_id_eidi     = pegGetContainer_id_d(container_id, 'a55_d3', '', 'a55_d');
			break;
		case 'a56' :
			main_container_id     = pegGetContainer_id_d(container_id, 'a56_d' , '', 'a56_d');
			stoixeia_container_id = pegGetContainer_id_d(container_id, 'a56_d4', '', 'a56_d');
			container_id_eidi     = pegGetContainer_id_d(container_id, 'a56_d3', '', 'a56_d');
			break;
		case 'a57' :
			main_container_id     = pegGetContainer_id_d(container_id, 'a57_d' , '', 'a57_d');
			stoixeia_container_id = pegGetContainer_id_d(container_id, 'a57_d3', '', 'a57_d');
			container_id_eidi     = pegGetContainer_id_d(container_id, 'a57_d2', '', 'a57_d');
			break;
		case 'a67' :
			main_container_id     = pegGetContainer_id_d(container_id, 'a67_d' , '', 'a67_d');
			stoixeia_container_id = pegGetContainer_id_d(container_id, 'a67_d3', '', 'a67_d');
			container_id_eidi     = pegGetContainer_id_d(container_id, 'a67_d2', '', 'a67_d');
			break;
		case 'retail00_01' :
			var parent_d = 'retail00_01_d';
			var retail00_01_d_container_id   = pegGetContainer_id_d(container_id , 'retail00_01_d'   , '' , parent_d );
			if(!retail00_01_d_container_id) {
				parent_d = 'retail00_02_d';
				retail00_01_d_container_id = pegGetContainer_id_d(container_id , 'retail00_02_d'   , '' , parent_d );
				container_id_eidi = pegGetContainer_id_d(container_id , 'retail00_02_d00'   , '' , parent_d );
			}else{
				container_id_eidi = retail00_01_d_container_id;
			}
			main_container_id     = retail00_01_d_container_id;
			stoixeia_container_id  = pegGetContainer_id_d(container_id, 'retail00_01_d04', '', parent_d);

			prefix = 'a55';
			break;
	}

	if (invoice_p07_change_ajax != '') {
		if (invoice_p07_change_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(invoice_p07_change_ajax);
		}
	}
	let grid = 'grid';
	params = {};	
	params.p07  = pegGetVal(prefix + 'p07', stoixeia_container_id);
	params.mode = mode;
	params.container_id = main_container_id;
	params.recalculate_unit_price = recalculate_unit_price;

	if(mode == 'retail00_01') {
		params.nr01 = pegGetVal(prefix + 'nr01', stoixeia_container_id);
		// grid = 'items_grid';
	}else{
		params.nr01 = pegGetVal('nr01', main_container_id);
	}
	invoice_p07_change_ajax = pegAjaxDefer('/' + main_path + '/invoices01/change_p07.php' , 
		params, function(){
			callback();
			if(mode == 'retail00_01') {
				retail00_refresh_item_grids(container_id_eidi)
			}else{
				pegGridRefresh(container_id_eidi, grid);
			}
	});
}

var invoices_change_p805_ajax = '';
function invoices_change_p805(container_id, mode, callback) {
	let prefix = '';

	switch(mode) {
		case 'a55' :
			main_container_id     = pegGetContainer_id_d(container_id, 'a55_d' , '', 'a55_d');
			stoixeia_container_id = pegGetContainer_id_d(container_id, 'a55_d4', '', 'a55_d');
			container_id_eidi     = pegGetContainer_id_d(container_id, 'a55_d3', '', 'a55_d');
			break;
		case 'a56' :
			main_container_id     = pegGetContainer_id_d(container_id, 'a56_d' , '', 'a56_d');
			stoixeia_container_id = pegGetContainer_id_d(container_id, 'a56_d4', '', 'a56_d');
			container_id_eidi     = pegGetContainer_id_d(container_id, 'a56_d3', '', 'a56_d');
			break;
		case 'a57' :
			main_container_id     = pegGetContainer_id_d(container_id, 'a57_d' , '', 'a57_d');
			stoixeia_container_id = pegGetContainer_id_d(container_id, 'a57_d3', '', 'a57_d');
			container_id_eidi     = pegGetContainer_id_d(container_id, 'a57_d2', '', 'a57_d');
			break;
		case 'a67' :
			main_container_id     = pegGetContainer_id_d(container_id, 'a67_d' , '', 'a67_d');
			stoixeia_container_id = pegGetContainer_id_d(container_id, 'a67_d3', '', 'a67_d');
			container_id_eidi     = pegGetContainer_id_d(container_id, 'a67_d2', '', 'a67_d');
			break;
		case 'retail00_01' :
			var parent_d = 'retail00_01_d';
			var retail00_01_d_container_id   = pegGetContainer_id_d(container_id , 'retail00_01_d'   , '' , parent_d );
			if(!retail00_01_d_container_id) {
				parent_d = 'retail00_02_d';
				retail00_01_d_container_id = pegGetContainer_id_d(container_id , 'retail00_02_d'   , '' , parent_d );
				container_id_eidi = pegGetContainer_id_d(container_id , 'retail00_02_d00'   , '' , parent_d );
			}else{
				container_id_eidi = retail00_01_d_container_id;
			}
			main_container_id     = retail00_01_d_container_id;
			stoixeia_container_id  = pegGetContainer_id_d(container_id, 'retail00_01_d04', '', parent_d);

			prefix = 'a55';
			break;
	}

	if (invoices_change_p805_ajax != '') {
		if (invoices_change_p805_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(invoices_change_p805_ajax);
		}
	}

	let grid = 'grid';

	params = {};
	params.p07  = pegGetVal(prefix + 'p07', stoixeia_container_id);
	params.p805 = pegGetVal(prefix + 'p805', stoixeia_container_id);
	params.mode = mode;

	if(mode == 'retail00_01') {
		params.nr01 = pegGetVal(prefix + 'nr01', stoixeia_container_id);
		// grid = 'items_grid';
	} else {
		params.nr01 = pegGetVal('nr01', main_container_id);
	}

	invoices_change_p805_ajax = pegAjaxDefer('/' + main_path + '/invoices01/invoices_change_p805.php', params, function() {
			callback();
			if(mode == 'retail00_01') {
				retail00_refresh_item_grids(container_id_eidi)
			}else{
				pegGridRefresh(container_id_eidi, grid);
			}
	});
}

var _calc_value_onchange_pause = false;

function invoice_set_calc_value_onchange_pause(value) {
	_calc_value_onchange_pause = value;
}
function invoice_get_calc_value_onchange_pause() {
	return _calc_value_onchange_pause;
}

function invoices_i01_d310_afterDraw_listeners(container_id){
	let bt_update = pegGetCmp(container_id, 'bt_update');
	
	var params = {};
	params = invoices_get_i01_d101_values(container_id);

	if(params.p07 == 0) {
		_timh_monadas_no_fpa    = params.p04;
		_timh_monadas_with_fpa  = params.p04 * params._pososto_fpa;
	} else {
		_timh_monadas_no_fpa    = params.p04 / params._pososto_fpa;
		_timh_monadas_with_fpa  = params.p04;
	}

	_synolo_no_fpa   = invoices_calculate_v107(params.p03, _timh_monadas_no_fpa, params._ekptosi_1, params._ekptosi_2, params._p616_no_fpa, params._p041_no_fpa, params._p042_no_fpa);
	_synolo_with_fpa = invoices_calculate_v107(params.p03, _timh_monadas_with_fpa, params._ekptosi_1, params._ekptosi_2, params._p616_with_fpa, params._p041_with_fpa, params._p042_with_fpa);

	if(params.p03 && !params.p04) {
		if(params.p07 == 0) {
			_synolo_with_fpa = _synolo_with_fpa * params._pososto_fpa;
		} else {
			_synolo_no_fpa = _synolo_no_fpa / params._pososto_fpa;
		}
	}

	//Τιμή Μονάδας (Χωρίς ΦΠΑ)
	peg002_set_screen_data(container_id, 'p04_novat', _timh_monadas_no_fpa);
	//Τιμή Μονάδας (Με ΦΠΑ)
	peg002_set_screen_data(container_id, 'p04_withvat', _timh_monadas_with_fpa);
	//Διόρθωση Συνόλου
	peg002_set_screen_data(container_id, 'p042_correction', 0);
	//Σύνολο (Χωρίς ΦΠΑ)
	peg002_set_screen_data(container_id, 'v107_novat', _synolo_no_fpa);
	//Σύνολο (Με ΦΠΑ)
	peg002_set_screen_data(container_id, 'v107_withvat', _synolo_with_fpa);
	if(params.p07 == 0) {
		//Σύνολο
		peg002_set_screen_data(container_id, 'v107', _synolo_no_fpa);
	} else {
		//Σύνολο
		peg002_set_screen_data(container_id, 'v107', _synolo_with_fpa);
	}
	//Ποσοστό Έκπτωσης
	peg002_set_screen_data(container_id, 'p010', 0);

	var choose_calc = pegGetCmp(container_id, 'choose_calc');
	choose_calc.on('change', function( me, newValue, oldValue, eOpts ){
		if(newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue))) {
			return;
		}

		var params = {};
		params = invoices_get_i01_d101_values(container_id);
		
		if(newValue == 1) {
			pegSetVal('p042_correction', container_id, 0);

			pegSetFieldHidden('p04_novat', container_id, false);
			pegSetFieldHidden('p04_withvat', container_id, false);
			pegSetFieldHidden('v107_novat', container_id, false);
			pegSetFieldHidden('v107_withvat', container_id, false);
			pegSetFieldHidden('v107', container_id, true);
			pegSetFieldHidden('p010', container_id, true);
			pegSetFieldHidden('p042_correction', container_id, true);
		} else if(newValue == 2 || newValue == 3) {
			pegSetVal('p042_correction', container_id, 0);

			pegSetFieldHidden('p04_novat', container_id, true);
			pegSetFieldHidden('p04_withvat', container_id, true);
			pegSetFieldHidden('v107_novat', container_id, true);
			pegSetFieldHidden('v107_withvat', container_id, true);
			pegSetFieldHidden('v107', container_id, false);
			pegSetFieldHidden('p010', container_id, false);
			pegSetFieldHidden('p042_correction', container_id, true);
		}
		
		invoice_set_calc_value_onchange_pause(true);

		if(newValue == 2) {
			if(params.p07 == 1) {
				_synolo = invoices_calculate_v107(params.p03, params.p04, params._ekptosi_1, params._ekptosi_2, params._p616_with_fpa, params._p041_with_fpa, params.p042);
			} else {
				_synolo = invoices_calculate_v107(params.p03, params.p04, params._ekptosi_1, params._ekptosi_2, params.p616, params.p041, params.p042);
			}
			
			pegSetVal('p010', container_id, pegParseFloat(params.p010));
			pegSetVal('v107', container_id, _synolo);
		} else if(newValue == 3) {
			if(params.p07 == 1) {
				_synolo = invoices_calculate_v107(params.p03, params.p04, params._ekptosi_1, params._ekptosi_2, params._p616_with_fpa, params._p041_with_fpa, params.p042);
			} else {
				_synolo = invoices_calculate_v107(params.p03, params.p04, params._ekptosi_1, params._ekptosi_2, params.p616, params.p041, params.p042);
			}

			pegSetVal('p010', container_id, pegParseFloat(params.p010a));
			pegSetVal('v107', container_id, _synolo);
		}

		invoice_set_calc_value_onchange_pause(false);
	});

	var p04_novat	= pegGetCmp(container_id ,'p04_novat');
	p04_novat.on('blur', function( me ){
		if(!me.value) {
			pegSetVal('p04_novat', container_id, 0);
		}
	});

	p04_novat.on('change', function( me, newValue, oldValue, eOpts ){
		if(newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue)) || invoice_get_calc_value_onchange_pause() == true) {
			return;
		}

		invoice_set_calc_value_onchange_pause(true);

		var params = {};
		params = invoices_get_i01_d101_values(container_id);

		if(newValue) {
			_timh_monadas_with_fpa = newValue * params._pososto_fpa;
			_synolo_no_fpa   = invoices_calculate_v107(params.p03, newValue, params._ekptosi_1, params._ekptosi_2, params._p616_no_fpa, params._p041_no_fpa, params._p042_no_fpa);
			_synolo_with_fpa = invoices_calculate_v107(params.p03, _timh_monadas_with_fpa, params._ekptosi_1, params._ekptosi_2, params._p616_with_fpa, params._p041_with_fpa, params._p042_with_fpa);

			pegSetVal('p04_withvat', container_id, _timh_monadas_with_fpa);
		} else {
			pegSetVal('p04_withvat', container_id, 0);
			_synolo_no_fpa   = 0;
			_synolo_with_fpa = 0;
		}

		pegSetVal('v107_novat',   container_id, _synolo_no_fpa);
		pegSetVal('v107_withvat', container_id, _synolo_with_fpa);
		pegSetVal('p042_correction', container_id, 0);
		pegSetFieldHidden('p042_correction', container_id, true);	

		invoice_set_calc_value_onchange_pause(false);
	});

	var p04_withvat	= pegGetCmp(container_id ,'p04_withvat');
	p04_withvat.on('blur', function( me ){
		if(!me.value) {
			pegSetVal('p04_withvat', container_id, 0);
		}
	});

	p04_withvat.on('change', function( me, newValue, oldValue, eOpts ){
		if(newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue)) || invoice_get_calc_value_onchange_pause() == true) {
			return;
		}

		invoice_set_calc_value_onchange_pause(true);

		var params = {};
		params = invoices_get_i01_d101_values(container_id);

		if(newValue) {
			_timh_monadas_no_fpa = newValue / params._pososto_fpa;
			_synolo_no_fpa   = invoices_calculate_v107(params.p03, _timh_monadas_no_fpa, params._ekptosi_1, params._ekptosi_2, params._p616_no_fpa, params._p041_no_fpa, params._p042_no_fpa);
			_synolo_with_fpa = invoices_calculate_v107(params.p03, newValue, params._ekptosi_1, params._ekptosi_2, params._p616_with_fpa, params._p041_with_fpa, params._p042_with_fpa);
			pegSetVal('p04_novat', container_id, _timh_monadas_no_fpa);
		} else {
			pegSetVal('p04_novat', container_id, 0);
			_synolo_no_fpa   = 0;
			_synolo_with_fpa = 0;
		}

		pegSetVal('v107_novat',   container_id, _synolo_no_fpa);
		pegSetVal('v107_withvat', container_id, _synolo_with_fpa);
		pegSetVal('p042_correction', container_id, 0);
		pegSetFieldHidden('p042_correction', container_id, true);

		invoice_set_calc_value_onchange_pause(false);
	});
	
	var v107_novat	= pegGetCmp(container_id ,'v107_novat');
	v107_novat.on('blur', function( me ){
		if(!me.value) {
			pegSetVal('v107_novat', container_id, 0);
		}
	});

	v107_novat.on('change', function( me, newValue, oldValue, eOpts ){
		if(newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue)) || invoice_get_calc_value_onchange_pause() == true) {
			return;
		}

		invoice_set_calc_value_onchange_pause(true);

		var params = {};
		params = invoices_get_i01_d101_values(container_id);

		if(newValue) {
			_additional_calcs_no_fpa   = (params._p041_no_fpa * params.p03) + (params._p616_no_fpa * params.p03) + params._p042_no_fpa;
			
			if(params.p03) {
				_timh_monadas_no_fpa   = (newValue - _additional_calcs_no_fpa) / (params._ekptosi_1 * params._ekptosi_2 * params.p03);
				_timh_monadas_with_fpa = _timh_monadas_no_fpa * params._pososto_fpa;
			} else {
				_timh_monadas_no_fpa    = 0;
				_timh_monadas_with_fpa  = 0;
			}

			pegSetVal('p04_novat',    container_id, _timh_monadas_no_fpa);
			pegSetVal('p04_withvat',  container_id, _timh_monadas_with_fpa);

			_synolo_no_vat = invoices_calculate_v107(params.p03, pegGetVal('p04_novat', container_id), params._ekptosi_1, params._ekptosi_2, params._p616_no_fpa, params._p041_no_fpa, params._p042_no_fpa);

			if(newValue.toFixed(2) !== _synolo_no_vat.toFixed(2)) {
				if(params.p07 == 1) {
					pegSetVal('p042_correction', container_id, (newValue.toFixed(2) - _synolo_no_vat.toFixed(2)) * params._pososto_fpa);
				} else {
					pegSetVal('p042_correction', container_id, newValue.toFixed(2) - _synolo_no_vat.toFixed(2));
				}
				
				pegSetFieldHidden('p042_correction', container_id, false);
			} else {
				pegSetVal('p042_correction', container_id, 0);
				pegSetFieldHidden('p042_correction', container_id, true);	
			}

			_synolo_with_fpa = (newValue * params._pososto_fpa);
			
			pegSetVal('v107_withvat', container_id, _synolo_with_fpa);			
		} else {
			newValue = 0;
			_synolo_with_fpa = 0;

			pegSetVal('p04_novat',    container_id, 0);
			pegSetVal('p04_withvat',  container_id, 0);
			pegSetVal('v107_withvat', container_id, _synolo_with_fpa);
		}

		invoice_set_calc_value_onchange_pause(false);
	});

	var v107_withvat	= pegGetCmp(container_id ,'v107_withvat');
	v107_withvat.on('blur', function( me ){
		if(!me.value) {
			pegSetVal('v107_withvat', container_id, 0);
		}
	});

	v107_withvat.on('change', function( me, newValue, oldValue, eOpts ){
		if(newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue)) || invoice_get_calc_value_onchange_pause() == true) {
			return;
		}

		invoice_set_calc_value_onchange_pause(true);

		var params = {};
		params = invoices_get_i01_d101_values(container_id);

		if(newValue) {
			_additional_calcs_with_fpa = (params._p041_with_fpa * params.p03) + (params._p616_with_fpa * params.p03) + params._p042_with_fpa;
			
			if(params.p03) {
				_timh_monadas_with_fpa = (newValue - _additional_calcs_with_fpa) / (params._ekptosi_1 * params._ekptosi_2 * params.p03);
				_timh_monadas_no_fpa   = _timh_monadas_with_fpa / params._pososto_fpa;
			} else {
				_timh_monadas_no_fpa    = 0;
				_timh_monadas_with_fpa  = 0;
			}

			pegSetVal('p04_novat',    container_id, _timh_monadas_no_fpa);
			pegSetVal('p04_withvat',  container_id, _timh_monadas_with_fpa);

			_synolo_with_vat = invoices_calculate_v107(params.p03, pegGetVal('p04_withvat', container_id), params._ekptosi_1, params._ekptosi_2, params._p616_with_fpa, params._p041_with_fpa, params._p042_with_fpa);

			if(newValue.toFixed(2) !== _synolo_with_vat.toFixed(2)) {
				if(params.p07 == 1) {
					pegSetVal('p042_correction', container_id, newValue.toFixed(2) - _synolo_with_vat.toFixed(2));
				} else {
					pegSetVal('p042_correction', container_id, (newValue.toFixed(2) - _synolo_with_vat.toFixed(2)) / (params._pososto_fpa));
				}
			
				pegSetFieldHidden('p042_correction', container_id, false);
			} else {
				pegSetVal('p042_correction', container_id, 0);
				pegSetFieldHidden('p042_correction', container_id, true);	
			}

			_synolo_no_fpa = newValue / params._pososto_fpa;

			pegSetVal('v107_novat', container_id, _synolo_no_fpa);			
		} else {
			newValue = 0;
			_synolo_no_fpa = 0;

			pegSetVal('p04_novat',   container_id, 0);
			pegSetVal('p04_withvat', container_id, 0);
			pegSetVal('v107_novat', container_id, _synolo_no_fpa);
		}

		invoice_set_calc_value_onchange_pause(false);
	});	

	var v107 = pegGetCmp(container_id, 'v107');
	v107.on('blur', function( me ){
		if(!me.value) {
			pegSetVal('v107', container_id, 0);
		}
	});

	v107.on('change', function( me, newValue, oldValue, eOpts ){
		if(newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue)) || invoice_get_calc_value_onchange_pause() == true) {
			return;
		}

		var params = {};
		params = invoices_get_i01_d101_values(container_id);

		//Επιλογή Υπολογισμού 
		choose_calc = pegGetVal('choose_calc', container_id);

		if(!newValue) {
			newValue = 0;
		}
		
		if(choose_calc == 2) {
			if(params.p07 == 1) {
				_pososto_ekptosis = invoices_make_product_discount(newValue, params.p03, params.p04, params._ekptosi_2, params._p616_with_fpa, params._p041_with_fpa, params.p042);
			} else {
				_pososto_ekptosis = invoices_make_product_discount(newValue, params.p03, params.p04, params._ekptosi_2, params.p616, params.p041, params.p042);
			}
		} else if(choose_calc == 3) {
			if(params.p07 == 1) {
				_pososto_ekptosis = invoices_make_product_discount(newValue, params.p03, params.p04, params._ekptosi_1, params._p616_with_fpa, params._p041_with_fpa, params.p042);
			} else {
				_pososto_ekptosis = invoices_make_product_discount(newValue, params.p03, params.p04, params._ekptosi_1, params.p616, params.p041, params.p042);
			}
		} else {
			_pososto_ekptosis = 0;
		}

		// _pososto_ekptosis = (1 - _pososto_ekptosis) * 100;

		pegSetVal('p010', container_id, _pososto_ekptosis);
	});

	bt_update.on('click', function(me) {
		invoices_change_unit_price(container_id);
    });
}

function invoices_get_i01_d101_values(container_id) {
	let screen = pegGetCmp(container_id);
	//Εύρεση container_id για τις οθόνες των παραστατικών
	var screen_i01_d10_container_id   = pegGetContainer_id_d(container_id, 'i01_d10', '' , 'i01_d10');
	var screen_i01_d101_container_id  = pegGetContainer_id_d(container_id, 'i01_d101', '', 'i01_d10');
	//Εύρεση container_id για την οθόνη της παραγγελίας πελατών
	var screen_a58_d_container_id   = pegGetContainer_id_d(container_id, 'a58_d', '' , 'a58_d');
	var screen_a58_d00_container_id = pegGetContainer_id_d(container_id, 'a58_d00', '', 'a58_d');
	//Εύρεση container_id για την οθόνη της παραγγελίας προμηθευτών
	var screen_a68_d_container_id   = pegGetContainer_id_d(container_id, 'a68_d', '' , 'a68_d');
	var screen_a68_d00_container_id = pegGetContainer_id_d(container_id, 'a68_d00', '', 'a68_d');
	//Εύρεση container_id για την οθόνη των εσωτερικών παραγγελιών
	var screen_a62_d_container_id   = pegGetContainer_id_d(container_id, 'a62_d', '' , 'a62_d');
	var screen_a62_d00_container_id = pegGetContainer_id_d(container_id, 'a62_d00', '', 'a62_d');

	var parent_d = 'retail00_01_d';
	var retail00_01_d_container_id   = pegGetContainer_id_d(container_id , 'retail00_01_d'   , 0 , parent_d );
	if(!retail00_01_d_container_id) {
		parent_d = 'retail00_02_d';
		if(screen.peg_screen_parent_container_id) {
			retail00_01_d_container_id = pegGetContainer_id_d(screen.peg_screen_parent_container_id , 'retail00_02_d'   , 0 , parent_d );
		}
	}
	if(retail00_01_d_container_id) {
		var screen_retail00_01_d_container_id = retail00_01_d_container_id;
		var screen_retail00_01_d03_container_id = pegGetContainer_id_d(retail00_01_d_container_id, 'retail00_01_d03', '', parent_d);
	}

	if(screen_i01_d10_container_id) {
		_invoice = 1;
		screen_main_container_id = screen_i01_d10_container_id;
		screen_child_container_id = screen_i01_d101_container_id;
	} else if(screen_a58_d_container_id) {
		_invoice = 0;
		screen_main_container_id = screen_a58_d_container_id;
		screen_child_container_id = screen_a58_d00_container_id;
	} else if(screen_a68_d_container_id) {
		_invoice = 0;
		screen_main_container_id = screen_a68_d_container_id;
		screen_child_container_id = screen_a68_d00_container_id;
	} else if(screen_a62_d_container_id) {
		_invoice = 0;
		screen_main_container_id = screen_a62_d_container_id;
		screen_child_container_id = screen_a62_d00_container_id;
	} else if(screen_retail00_01_d_container_id) {
		_invoice = 1;
		screen_main_container_id = screen_retail00_01_d_container_id;
		screen_child_container_id = screen_retail00_01_d03_container_id;
	}

	//Βρισκουμαι το parent με την getPeg_screen_parent_container_id για να παίζει και όταν έχει ανοίξει από mobile σε no tab
	let temp_parent_container_id = '';
	let values_with_vat = '';
	if(screen_retail00_01_d_container_id) {
		temp_parent_container_id = pegGetContainer_id_d(screen_main_container_id, 'retail00_01_d04', '', parent_d);
		values_with_vat =  invoice_get_p07(temp_parent_container_id, 'retail00_01');
	}else{	
		temp_parent_container_id = pegGetCmp(screen_main_container_id).getPeg_screen_parent_container_id();
		values_with_vat =  invoice_get_p07(temp_parent_container_id, pegGetCmp(temp_parent_container_id).peg_table);
	}
	let params = {};

	if(_invoice == 0) {
		params.p03   = pegGetVal('v103',  screen_child_container_id); //Ποσότητα  
		params.p04   = pegGetVal('v104',  screen_child_container_id); //Τιμή Μονάδας                 
		params.p08   = pegGetVal('v105',  screen_child_container_id); //Κατηγορία Φ.Π.Α.          
		params.p010  = pegGetVal('v106',  screen_child_container_id); //Έκπτωση 1η
		params.p010a = pegGetVal('v106a', screen_child_container_id); //Έκπτωση 2η
		params.p041  = pegGetVal('v1041', screen_child_container_id); //Εισφορά ανακύλωσης      
		params.p616  = pegGetVal('v616',  screen_child_container_id); //Ειδικός Φόρος Κατανάλωσης 
		params.p042  = pegGetVal('v1042', screen_child_container_id); //Επιπλέον Αξία
	} else {
		params.p03   = pegGetVal('p03',   screen_child_container_id); //Ποσότητα  
		params.p04   = pegGetVal('p04',   screen_child_container_id); //Τιμή Μονάδας                 
		params.p08   = pegGetVal('p08',   screen_child_container_id); //Κατηγορία Φ.Π.Α.          
		params.p010  = pegGetVal('p010',  screen_child_container_id); //Έκπτωση 1η
		params.p010a = pegGetVal('p010a', screen_child_container_id); //Έκπτωση 2η
		params.p041  = pegGetVal('p041',  screen_child_container_id); //Εισφορά ανακύλωσης      
		params.p616  = pegGetVal('p616',  screen_child_container_id); //Ειδικός Φόρος Κατανάλωσης 
		params.p042  = pegGetVal('p042',  screen_child_container_id); //Επιπλέον Αξία
	}

	_pososto_fpa = ((100 + pegParseFloat(params.p08)) / 100);
    _ekptosi_1   = ((100 - pegParseFloat(params.p010)) / 100);
    _ekptosi_2   = ((100 - pegParseFloat(params.p010a)) / 100);

	params._p616_no_fpa = params.p616;
	params._p041_no_fpa = params.p041;

	params._p616_with_fpa = params.p616 * _pososto_fpa;
	params._p041_with_fpa = params.p041 * _pososto_fpa;

	if(values_with_vat == 0) {
		params._p042_no_fpa   = params.p042;
		params._p042_with_fpa = params.p042 * _pososto_fpa;
	} else {
		params._p042_no_fpa   = params.p042 / _pososto_fpa;
		params._p042_with_fpa = params.p042;
	}

	params.p07 			= values_with_vat; //Τιμές με ΦΠΑ
	params._pososto_fpa = _pososto_fpa	   //Ποσοστό ΦΠΑ
	params._ekptosi_1 	= _ekptosi_1;	   //Έκπτωση 1η
	params._ekptosi_2 	= _ekptosi_2;	   //Έκπτωση 2η

	return params;
}

function invoices_change_unit_price(container_id) {
	let screen = pegGetCmp(container_id);
	//Εύρεση container_id για τις οθόνες των παραστατικών
	var screen_i01_d10_container_id   = pegGetContainer_id_d(container_id, 'i01_d10', '' , 'i01_d10');
	//Εύρεση container_id για την οθόνη της παραγγελίας πελατών
	var screen_a58_d_container_id   = pegGetContainer_id_d(container_id, 'a58_d', '' , 'a58_d');
	//Εύρεση container_id για την οθόνη της παραγγελίας προμηθευτών
	var screen_a68_d_container_id   = pegGetContainer_id_d(container_id, 'a68_d', '' , 'a68_d');

	var parent_d = 'retail00_01_d';
	var retail00_01_d_container_id   = pegGetContainer_id_d(container_id , 'retail00_01_d'   , 0 , parent_d );
	if(!retail00_01_d_container_id) {
		parent_d = 'retail00_02_d';
		if(screen.peg_screen_parent_container_id) {
			retail00_01_d_container_id = pegGetContainer_id_d(screen.peg_screen_parent_container_id , 'retail00_02_d'   , 0 , parent_d );
		}
	}
	if(retail00_01_d_container_id) {
		var screen_retail00_01_d_container_id = retail00_01_d_container_id;
	}

	if(screen_i01_d10_container_id) {
		_invoice = 1;
	} else if(screen_a58_d_container_id) {
		_invoice = 0;
	} else if(screen_a68_d_container_id) {
		_invoice = 0;
	} else if(screen_retail00_01_d_container_id) {
		_invoice = 1;
	} else if(screen_retail00_01_d_container_id) {
		_invoice = 1;
	}

	var params = {};
	params = invoices_get_i01_d101_values(container_id);

	if(_invoice == 1) {
		_timi_monadas       = 'p04';
		_addition_value     = 'p042';
		_pososto_ekptosis_1 = 'p010';
		_pososto_ekptosis_2 = 'p010a';
	} else {
		_timi_monadas       = 'v104';
		_addition_value     = 'v1042';
		_pososto_ekptosis_1 = 'v106';
		_pososto_ekptosis_2 = 'v106a';
	}

	if(params.p07 == 1) {
		p04 = pegGetVal('p04_withvat', container_id);
	} else {
		p04 = pegGetVal('p04_novat', container_id);
	}

	//Επιλογή Υπολογισμού 
	choose_calc = pegGetVal('choose_calc', container_id);
	//Ποσοστό Έκπτωσης
	p010 = pegGetVal('p010', container_id);
	//Σύνολο
	v107 = pegGetVal('v107', container_id);
	//Διόρθωση Σύνολο
	p042_correction = pegGetVal('p042_correction', container_id);

	let _synolo = 0;

	if(choose_calc == 1) {
		if(params.p07 == 1) {
			_synolo = invoices_calculate_v107(params.p03, p04, params._ekptosi_1, params._ekptosi_2, params._p616_with_fpa, params._p041_with_fpa, (params.p042 + p042_correction));
		} else {
			_synolo = invoices_calculate_v107(params.p03, p04, params._ekptosi_1, params._ekptosi_2, params._p616_no_fpa, params._p041_no_fpa, (params.p042 + p042_correction));
		}
		pegSetVal(_timi_monadas, screen_child_container_id, p04);
	} else if(choose_calc == 2) {
		// _synolo = v107;
		if(p010 != 0) {
			_synolo = v107;
		}
		if((p010 <= 999.99 && p010 >= -99.99)) {
			pegSetVal(_pososto_ekptosis_1, screen_child_container_id, p010);
		} else {
			pegGetDic('peg_dic_invoices_discount_rate', function (desc) {
				pegToast(desc, 'alert');
			});		

			return;	
		}
	} else if(choose_calc == 3) {
		// _synolo = v107;
		if(p010 != 0) {
			_synolo = v107;
		}
		if((p010 <= 999.99 && p010 >= -99.99)) {
			pegSetVal(_pososto_ekptosis_2, screen_child_container_id, p010);
		} else {
			pegGetDic('peg_dic_invoices_discount_rate', function (desc) {
				pegToast(desc, 'alert');
			});
			
			return;
		}
	}

	pegSetVal('v107', screen_child_container_id, _synolo);
	pegSetVal(_addition_value, screen_child_container_id, params.p042 + p042_correction);

	//If Retail, update the item.
	if(retail00_01_d_container_id) {
		retail00_update_i01(retail00_01_d_container_id);
	}

	if (screen.peg_inWindow == 1) {
		pegWindowClose(container_id);
	} else {
		pegTabClose(pegGetCmp(container_id).peg_tabid);
	}
}

function invoices_calculate_v107(p03=0, p04=0, p010=0, p010a=0, p616=0, p041=0, p042=0) {
    let v107 = (pegParseFloat(p03) * pegParseFloat(p04) * p010 * p010a) + (pegParseFloat(p616) * pegParseFloat(p03)) + (pegParseFloat(p041) * pegParseFloat(p03)) + pegParseFloat(p042);

	v107 = Math.round(v107 * 100) / 100;

    return v107;
}

invoices_check_p08_ajax = '';
function invoices_check_p08(nr01, p01, p06, p701, mode, p05){

	if (invoices_check_p08_ajax != '') {
		if (invoices_check_p08_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(invoices_check_p08_ajax);
		}
	}

	params = {
		nr01: nr01,
		p01: p01,
		p06: p06,
		p701: p701,
		mode: mode,
		p05: p05
	};

	invoices_check_p08_ajax = pegAjaxDefer('/' + main_path + '/invoices01/invoices_check_p08.php' , 
		params, function(jsondata){
			if(jsondata.ok==0){
				pegToast(jsondata.msg, 'alert');
			}
	});
}

var invoces_find_p013_p014_ajax = '';
function invoices_find_p013_p014(container_id, mode){
	var container_id_d = pegGetContainer_id_d(container_id, mode + '_d', '', mode + '_d');
	var p05 = pegGetVal('p05', container_id_d);
	var p703 = pegGetVal('p703', container_id);
	var p0121 = pegGetVal('p0121', container_id);

	if (invoces_find_p013_p014_ajax != '') {
		if (invoces_find_p013_p014_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(invoces_find_p013_p014_ajax);
		}
	}
	params = {};
	params.p05 = p05;
	params.p703 = p703;
	params.p0121 = p0121;
	params.mode = mode;		
	invoces_find_p013_p014_ajax = pegAjaxDefer('/' + main_path + '/invoices01/invoices_find_p013_p014.php' , 
		params, function(jsondata){
			if(jsondata.ok==1){
				if(!pegIsEmpty(jsondata.p013)){
					pegSetVal('p013', container_id, jsondata.p013);
				}
				if(!pegIsEmpty(jsondata.p014)){
					pegSetVal('p014', container_id, jsondata.p014);
				}
			}
	});
}

function invoices_make_product_discount(v107=0, p03=0, p04=0, p010=0, p616=0, p041=0, p042=0) {
    let divider = pegParseFloat(p03) * pegParseFloat(p04) * p010;
   
    let _pososto_ekptosis = 1;
    if(divider != 0) {
        _pososto_ekptosis = (pegParseFloat(v107) - ((pegParseFloat(p041) * pegParseFloat(p03)) + (pegParseFloat(p616) * pegParseFloat(p03)) + pegParseFloat(p042))) / divider;
    }
 
    _pososto_ekptosis = (1 - _pososto_ekptosis) * 100;
 
    return _pososto_ekptosis;
}

function invoice_show__invoices_find_product_d(container_id, params) {
	peg_windowShow_d('',
		'_invoices_find_product_d',
		'invoices', container_id, '', 0,
		encodeURI ('&peg_mode=' + params.mode +
		'&peg_code=' + params.code +
		'&peg_nr01=' + params.nr01 +
		'&peg_name=' + params.name +
		'&peg_p03=' + params.p03 +
		'&peg_date=' + params.date).replace('+','%2b'),
		'', {}, false, true, 0, 0, 'tablet');
}

var _search_item_onchange_pause = false;

function invoice_set_search_item_value_onchange_pause(value) {
	_search_item_onchange_pause = value;
}
function invoice_get_search_item_value_onchange_pause() {
	return _search_item_onchange_pause;
}

function invoice_search_item(container_id) {
	let params = {};
	var screen = pegGetCmp(container_id);

	mmnr01 = screen.getMmnr01();
	mode = mmnr01.split("_d-");

	var p03  = pegGetVal_d('p03',  container_id, mode[0]+"_d", '', mode[0]+"_d");
	var date = pegGetVal_d('p01',  container_id, mode[0]+"_d", '', mode[0]+"_d");
	var nr01 = pegGetVal_d('nr01', container_id, mode[0]+"_d", '', mode[0]+"_d");

	if(mode[0] == 'a60') {
		var p03 = '';
	}

	if(mode[0] == 'a61') {
		var p03 = '';
	}

	if(mode[0] == 'retail00_01') {
		var parent_d = 'retail00_01_d';
		var retail00_01_d_container_id   = pegGetContainer_id_d(container_id , 'retail00_01_d'   , '' , parent_d );
		if(!retail00_01_d_container_id) {
			parent_d = 'retail00_02_d';
		}
		var p03  = pegGetVal_d('a01nr01', container_id, 'retail00_01_d02', '', parent_d);
		var date = pegGetVal_d('a55p01',  container_id, 'retail00_01_d04', '', parent_d);
		var nr01 = pegGetVal_d('a55nr01', container_id, 'retail00_01_d04', '', parent_d);
	}

	params.nr01 = nr01;
	params.mode = mode[0];
	params.p03  = p03
	params.date = date;

	invoice_show__invoices_find_product_d(container_id, params);
}

if (typeof pegParseFloat !== "function") {
    function pegParseFloat(number) {
        number = parseFloat(number);
   
        if(isNaN(number)) {
            number = 0;
        }
   
        return number;
    }
}

var _invoice_last_selected_row = "";

function invoice_set_last_selected_row(value) {
	_invoice_last_selected_row = value;
}

function invoice_get_last_selected_row() {
	return _invoice_last_selected_row;
}

function invoices_i01_d10_grid_view_afterDraw_listeners(container_id) {
    var grid = pegGetCmp(container_id, 'grid');
    var v107 = WebApp.view.grid.Grid.peg_getColumn(grid, 'v107'); //Σύνολο
    var v_color_red = 'fad7d7';
    
    if(v107) {
        v107.peg_set_metaData = function (value, metaData, record, rowIndex, colIndex) { 
			try {
				var i18i01 = record.get('i18i01');

				if(i18i01 > 0) {
					metaData.tdStyle = "background-color:#" + v_color_red + " ;";
				}
				
				return metaData;
			} catch (error) {

			}
        }
    }
}


var invoices_save_kinisi_and_reopen_i = 0; 
function invoices_save_kinisi_and_reopen(screen) {
	invoices_save_kinisi_and_reopen_i++;
	
	WebApp.view.toolbar.button.SaveUpdate.pegSave_d(screen.getContainer_ID(), 0, function() {
		let mmnr01 = screen.getMmnr01();
		let mode = mmnr01.substr(0, 3);
		let main_container_id = pegGetContainer_id_d(screen.getContainer_ID(), mode+'_d', '', mode+'_d');
		
		if(mode == "a55" || mode == "a56" || mode == "a57" || mode == "a67") {
			invoices_calculate_total(screen.peg_screen_parent_container_id, mode);
		}

		peg_windowShow_d(
			screen.peg_table,
			screen.peg__d, 
			screen.peg_module, 
			main_container_id,
			screen.peg_winid+"_i" + invoices_save_kinisi_and_reopen_i, 
			0 , '', '',  
			{
				peg_screen_parent_container_id: screen.peg_screen_parent_container_id,
				peg_screen_parent_element_name: 'grid',
				mmnr01 :screen.getMmnr01(),
				mnr01 :screen.getMnr01()
			},
			true, true, 0, 0, 
			'tablet'
		);
	}, '', 1);
}

//TODO Να αλλάξουμε όνομα συναρτησης
//TODO Να ενσωματωθεί και η λειτουργία της find_p013_p014 σε αυτό το ajax. Προσοχή και στο Retail.
var invoices_where_p05_ajax = '';
function invoices_where_p05(container_id, mode) {
	var prefix = '';
	var main_container_id = pegGetContainer_id_d(container_id, mode+'_d', '', mode+'_d');

	if(mode == "a57" || mode == "a67" || mode == "a60" || mode == "a61") {
		var container_id_stoixeia = pegGetContainer_id_d(container_id, mode+'_d3', '', mode+'_d');
		var container_id_stoixeia_diakinisis = pegGetContainer_id_d(container_id, mode+'_d8', '', mode+'_d');
	} else if(mode == 'retail00_01') {
		var parent_d = 'retail00_01_d';
		var retail00_01_d_container_id   = pegGetContainer_id_d(container_id , 'retail00_01_d'   , '' , parent_d );
		if(!retail00_01_d_container_id) {
			parent_d = 'retail00_02_d';
			retail00_01_d_container_id = pegGetContainer_id_d(container_id , 'retail00_02_d'   , '' , parent_d );
		}
		var main_container_id = retail00_01_d_container_id;
		var container_id_stoixeia = pegGetContainer_id_d(container_id, 'retail00_01_d04', '', parent_d);
		var container_id_stoixeia_diakinisis = container_id_stoixeia;
		var container_id_pelatis = pegGetContainer_id_d(container_id, 'retail00_01_d02', '', parent_d);
		prefix = 'a55';
	} else {
		var container_id_stoixeia = pegGetContainer_id_d(container_id, mode+'_d4', '', mode+'_d');
		var container_id_stoixeia_diakinisis = pegGetContainer_id_d(container_id, mode+'_d8', '', mode+'_d');
	}


	if (invoices_where_p05_ajax != '') {
		if (invoices_where_p05_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(invoices_where_p05_ajax);
		}
	}
	params = {};
	params.mode  = mode;
	params.container_id = main_container_id; 

	if(mode == "a60" || mode == "a61") {
		params.p03   = pegGetVal('p03',  main_container_id); 		// Αποθήκη 1
		params.p04   = pegGetVal('p04',  main_container_id); 		// Αποθήκη 2
		params.p05   = pegGetVal('p05',  main_container_id); 		// Παραστατικό
	} else {
		if(mode == 'retail00_01') {
			params.nr01  = pegGetVal(prefix+'nr01',  container_id_stoixeia);  // Μ.Κ. Οθόνης
			params.p05   = pegGetVal(prefix+'p05',   container_id_stoixeia);  // Παραστατικό
			params.p03   = pegGetVal('a01nr01',   container_id_pelatis);      // Πελάτης/Προμηθευτής
			params.p04   = pegGetVal('a01a71',   container_id_pelatis);       // Υποκατάστημα
		} else {
			params.nr01  = pegGetVal(prefix+'nr01',  main_container_id);  // Μ.Κ. Οθόνης
			params.p05   = pegGetVal(prefix+'p05',   main_container_id);  // Παραστατικό
			params.p03   = pegGetVal('p03',   main_container_id);		  // Πελάτης/Προμηθευτής
			params.p04   = pegGetVal('p04',   main_container_id);		  // Υποκατάστημα
		}
		params.p703  = pegGetVal(prefix+'p703',  container_id_stoixeia);  // Αποθήκη
		params.p0121 = pegGetVal(prefix+'p0121', container_id_stoixeia);  // Κατάστημα
	}
	invoices_where_p05_ajax = pegAjaxDefer('/' + main_path + '/invoices01/invoices_where_p05.php', params, function (jsondata) {
		if(jsondata.address.ldstreet !== undefined) {
			pegSetVal(prefix+'ldstreet',  container_id_stoixeia_diakinisis, jsondata.address.ldstreet);	  // Οδός Φόρτωσης
			pegSetVal(prefix+'ldnumber',  container_id_stoixeia_diakinisis, jsondata.address.ldnumber);	  // Αριθμός Φόρτωσης
			pegSetVal(prefix+'ldzip',     container_id_stoixeia_diakinisis, jsondata.address.ldzip);		  // Τ.Κ. Φόρτωσης
			pegSetVal(prefix+'ldcity',    container_id_stoixeia_diakinisis, jsondata.address.ldcity);		  // Πόλη Φόρτωσης
			if(jsondata.address.ss_branch !== undefined) {
				pegSetVal(prefix+'ss_branch', container_id_stoixeia_diakinisis, jsondata.address.ss_branch); // Εγκατάσταση έναρξης διακίνησης Φόρτωσης
			}
		}
		if(jsondata.address.dlvstreet !== undefined) {
			pegSetVal(prefix+'dlvstreet',  container_id_stoixeia_diakinisis, jsondata.address.dlvstreet);	  // Οδός Φόρτωσης
			pegSetVal(prefix+'dlvnumber',  container_id_stoixeia_diakinisis, jsondata.address.dlvnumber);	  // Αριθμός Φόρτωσης
			pegSetVal(prefix+'dlvzip',     container_id_stoixeia_diakinisis, jsondata.address.dlvzip);		  // Τ.Κ. Φόρτωσης
			pegSetVal(prefix+'dlvcity',    container_id_stoixeia_diakinisis, jsondata.address.dlvcity);	  // Πόλη Φόρτωσης
			if(jsondata.address.cs_branch !== undefined) {
				pegSetVal(prefix+'cs_branch', container_id_stoixeia_diakinisis, jsondata.address.cs_branch); // Εγκατάσταση ολοκλήρωσης διακίνησης Φόρτωσης
			}
		}
	});
}

invoices_delete_invoiced_items_ajax = ""
function invoices_delete_invoiced_items(container_id, tbl = "") {
	if (invoices_delete_invoiced_items_ajax != '') {
		if (invoices_delete_invoiced_items_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(invoices_delete_invoiced_items_ajax);
		}
	}
	
	pegGetDic('peg_dic_invoices_delete_invoiced_items', function(title) {
		pegGetDic('peg_dic_invoices_confirm_delete_invoiced_items', function(msg) {
			pegConfirmBox(title, msg, function(res) {
				if(res == "yes") {
					var container_id_main = pegGetContainer_id_d(container_id , tbl+'_d', '', tbl+'_d');
					
					params = {};
					params.tbl      = tbl;
					params.tbl_nr01 = pegGetVal('nr01', container_id_main);

					invoices_delete_invoiced_items_ajax = pegAjaxDefer('/' + main_path + '/invoices01/invoices_delete_invoiced_items.php', params, function (jsondata) {
						if(jsondata.ok == 1 && tbl != 'a61') {
							invoices_calculate_total(container_id, tbl);
						}

						pegGridRefresh(container_id, 'grid');
					}, 'json', true);
				}
			});
		});
	});
}