<?php
/**
 * Επιλέγει με ποιο τρόπο θα πρέπει να τιμολογηθεί το παραστατικό
 * 
 * *** Δεν ελέγχουμε πλέον αν το παραστατικό υπάρχει (για να μας εξυπηρετεί στον έλεγχο του αν το παραστατικό θα σταλεί με CnA)
 *
 * @param  string  $mode (a55)
 * @param  integer $nr01
 * @return data[
 * 	- bool mydt,		-- Αν μπορεί να σταλεί με mydt / Mydata
 *  - bool einv,		-- Αν μπορεί να σταλεί με einv / ηλεκτρονική τιμολόγηση (Pegasus)
 *  - bool einv01,		-- Αν μπορεί να σταλεί με einv01 / ηλεκτρονική τιμολόγηση (SoftOne)
 *  - bool ca_server	-- Αν μπορεί να περάσει από φορολογικό μηχανισμό ca_server / CnA Server
 * ]
 */
function invoices_document_after_save_global_check($mode = 'a55', $nr01 = 0) {
	if($mode == 'a55' && pegasus_mysql_printfld('mydt10', 'p09', "tbl = 'a55' AND tbl_nr01= ?", array($nr01)) == 3) {
		return array(
			'ok'	=> 1,
			'data'	=> array(
				'mydt'		=> false,
				'einv'		=> false,
				'einv01'	=> false,
				'ca_server'	=> false
			)
		);
	}
	if(pegasus_module_exists('oil01')) {
		$oil01_epistrofi_p01 = 0;
		$oil01_epistrofi_p08 = 0;
		$oil01_epistrofi_p05 = 0;

		$oil01_epistrofi = oil01_get_a55_epistrofi($nr01, $mode);

		if($oil01_epistrofi['p01'] > 0) {
			$oil01_epistrofi_p01 = floatval($oil01_epistrofi['p01']);
			$oil01_epistrofi_p08 = floatval($oil01_epistrofi['p08']);
			$oil01_epistrofi_p05 = floatval($oil01_epistrofi['p05']);
		}
	}

	//* a55 ή t08 και χειρόγραφο, δεν διαβιβάζεται πουθενά.
	//TODO τα oil στοιχεία να ρωτήσω, δεν ξερω αν χρειάζονται.
	$xeir = mydt_check_if_xeir_and_customer_invoice($mode, $nr01);
	if($mode == 'a55' && $xeir == 1) {
		// Αν είναι a55 και χειρόγραφο
		return array(
			'ok'	=> 1,
			'data'	=> array(
				'mydt'		=> false,
				'einv'		=> false,
				'einv01'	=> false,
				'ca_server'	=> false,
				'oil01_epistrofi_p01' => $oil01_epistrofi_p01,
				'oil01_epistrofi_p08' => $oil01_epistrofi_p08,
				'oil01_epistrofi_p05' => $oil01_epistrofi_p05
			)
		);
	}elseif($mode == 't08' && $xeir == 1) {
		// Αν είναι t08 (Πελάτη) και χειρόγραφο
		return array(
			'ok'	=> 1,
			'data'	=> array(
				'mydt'		=> false,
				'einv'		=> false,
				'einv01'	=> false,
				'ca_server'	=> false
			)
		);
	}

	/**
	 * Αν μπορεί να σταλεί με ηλεκτρονική τιμολόγηση (Pegasus)
	 */
	if(
		pegasus_module_exists('einv')
		&& function_exists('einv00_check_settings')
	) {
		$einv_nr01 = einv00_check_settings($mode,$nr01);
		if($einv_nr01 > 0) {
			return array(
				'ok'	=> 1,
				'data'	=> array(
					'mydt'		=> false,
					'einv'		=> true,
					'einv01'	=> false,
					'ca_server'	=> false,
					'oil01_epistrofi_p01' => $oil01_epistrofi_p01,
					'oil01_epistrofi_p08' => $oil01_epistrofi_p08,
					'oil01_epistrofi_p05' => $oil01_epistrofi_p05
				)
			);
		}
	}
	/**
	 * Αν μπορεί να σταλεί με ηλεκτρονική τιμολόγηση (SoftOne)
	 */
	if(
		pegasus_module_exists('einv01')
		&& function_exists('einv01_einv00_check_settings')
	) {
		$einv_nr01 = einv01_einv00_check_settings($mode,$nr01);
		if($einv_nr01 > 0) {
			return array(
				'ok'	=> 1,
				'data'	=> array(
					'mydt'		=> false,
					'einv'		=> false,
					'einv01'	=> true,
					'ca_server'	=> false,
					'oil01_epistrofi_p01' => $oil01_epistrofi_p01,
					'oil01_epistrofi_p08' => $oil01_epistrofi_p08,
					'oil01_epistrofi_p05' => $oil01_epistrofi_p05
				)
			);
		}
	}
	/**
	 * Αν υπάρχει το module του φορολογικού μηχανισμού (CnA Server)
	 */
	if(
		pegasus_module_exists('ca_server')
		&& $mode == 'a55'
	) {
		return array(
			'ok'	=> 1,
			'data'	=> array(
				'mydt'		=> true,
				'einv'		=> false,
				'einv01'	=> false,
				'ca_server'	=> true,
				'oil01_epistrofi_p01' => $oil01_epistrofi_p01,
				'oil01_epistrofi_p08' => $oil01_epistrofi_p08,
				'oil01_epistrofi_p05' => $oil01_epistrofi_p05
			)
		);
	}
	/**
	 * Αλλιώς θα πρέπει να τιμολογηθεί με myData
	 */
	return array(
		'ok'	=> 1,
		'data'	=> array(
			'mydt'		=> true,
			'einv'		=> false,
			'einv01'	=> false,
			'ca_server'	=> false,
			'oil01_epistrofi_p01' => $oil01_epistrofi_p01,
			'oil01_epistrofi_p08' => $oil01_epistrofi_p08,
			'oil01_epistrofi_p05' => $oil01_epistrofi_p05
		)
	);
}
/**
 * 
 * @param  array  $i01
 * @param  string $field
 * @return array|int
 * 
 * @see Δ: 2116836 
 */
function invoice_i01_d10_calulate_v_fields(
	$i01 = array()
) {
	$return_array = array();

	$_p07 = pegasusGetGlobalVar('peg_'.$i01['mode'].'_d-' . $i01['p06'] . '_p07');
	$_pososto_fpa = ((100 + $i01['p08']) / 100);
	
	$v107 = invoices_make_product_total($i01['p03'], $i01['p04'], $i01['p08'], $i01['p010'], $i01['p010a'], $i01['p041'], $i01['p616'], $_p07, $i01['p042']);

	if($_p07 == 0) {
		$_timh_monadas_no_fpa    = $i01['p04'];
		$_timh_monadas_with_fpa  = $i01['p04'] * $_pososto_fpa;
		//Σύνολο (Χωρίς ΦΠΑ)
		$return_array['v_v107_novat'] = round($v107, 2);

		//Σύνολο (Με ΦΠΑ)
		$return_array['v_v107_vat']   = round($v107 * $_pososto_fpa, 2);
	} else {
		$_timh_monadas_no_fpa    = $i01['p04'] / $_pososto_fpa;
		$_timh_monadas_with_fpa  = $i01['p04'];
		//Σύνολο (Χωρίς ΦΠΑ)
		$return_array['v_v107_novat'] = round($v107 / $_pososto_fpa, 2);

		//Σύνολο (Με ΦΠΑ)
		$return_array['v_v107_vat']   = round($v107, 2);
	
	}

	//Τιμή Μονάδας (Χωρίς ΦΠΑ)
	$return_array['v_i01_p04_novat'] = round($_timh_monadas_no_fpa, $_SESSION['inventory_000_p07']);

	//Τιμή Μονάδας (Με ΦΠΑ)
	$return_array['v_i01_p04_vat']   = round($_timh_monadas_with_fpa, $_SESSION['inventory_000_p07']);

	return $return_array;
}
/**
 * i71 ενημερωση  Κ.Κ. και  συντελεστη -1 Ακυρα
 * invoices_update_i71_onsave($mmnr01, $p_kkapo, $p_asyn)
 */
function invoices_update_i71_d00_onsave($mmnr01, $t02p01, $p012)
{
	$peg_arr1 = array();
	$peg_arr2 = array();
	array_push($peg_arr1, 't02p01');
	array_push($peg_arr2, $t02p01);
	array_push($peg_arr1, 'p012');
	array_push($peg_arr2, $p012);
	array_push($peg_arr1, 'peg_flag');
	array_push($peg_arr2, "2");

	$sql_arr = pegasusGetGlobalVar('peg_' . $mmnr01 . '_where_i71_d00');
	pegasus_mysql_update('peg_tmp_i71', $peg_arr1, $peg_arr2, $sql_arr['sql'], 0, 1, 1, $sql_arr['sqlParams']);
}

function invoices_make_i71_d00_whereVar($mode, $container_id, $data)
{
	//where_i17_d00
	$sql = '
		peg_flag!=9 and
		peg_tmp_i71.tbl_nr=:nr01 and
		peg_tmp_i71.tbl=:mode and
		peg_tmp_i71.peg_sess_id=:session_id and
		peg_tmp_i71.peg_mmnr01=:mmnr01 and
		peg_tmp_i71.peg_mnr01=:mnr01
	';
	$sqlParams = array(
		'nr01'       => $data['nr01'],
		'session_id' => session_id(),
		'mmnr01'     => $mode . '_d-'  . $data['nr01'],
		'mnr01'      => $data['nr01'],
		'mode'       => $mode
	);

	pegasusSetGlobalVar($container_id . '_where_i71_d00',   array('sql' => $sql, 'sqlParams' => $sqlParams));
	pegasusSetGlobalVar('peg_' . $mode . '_d-' . $data['nr01'] . '_where_i71_d00',   array('sql' => $sql, 'sqlParams' => $sqlParams));
}

/**
 * This function is used in a55_d,a57_d,a56_d,a67_d initialization
 * The global var $mode.'_d' . $data['nr01'] . '_totals_array' also is setted in invoices_find_totals() func
 */
function invoices_set_total_var($mode, $nr01, $data)
{//retail: 16/05 check if retail01 set mode to a55
	if($mode == 'retail00_01') {
		$mode = 'a55';
	}
	pegasusSetGlobalVar($mode . '_d' . $nr01 . '_totals_array', array(
		"p0100"   => $data['p0100'],
		"p0101"   => $data['p0101'],
		"p0102"   => $data['p0102'],
		"p0102_1" => $data['p0102_1'],
		"p0102_2" => $data['p0102_2'],
		"p0112"   => $data['p0112'],
		"vp0112"  => $data['vp0112'],
		"p0113"   => $data['p0113'],
		"vp0113"  => $data['vp0113'],

		"p0105" => $data['p0105'],
		"p0108" => $data['p0108'],
		"p0109" => $data['p0109'],

		"pn02"	=> $data['pn02']
	));
}

function invoices_get_total_var($mode, $nr01)
{//retail: 16/05 check if retail01 set mode to a55
	if($mode == 'retail00_01') {
		$mode = 'a55';
	}
	return pegasusGetGlobalVar($mode . '_d' . $nr01 . '_totals_array');
}

function invoices_a77_d_initialize($data, $mmnr01, $mnr01, $_d, $container_id)
{
	global $PegInput;
	$PegInput->addVar(new peg_input_number('rec_copy_nr01'));
	$rec_copy_nr01  = $PegInput->getRequest('rec_copy_nr01');

	if ($data['is_std'] == 1) {
		$data['p01_readonly']   = true;
		$data['message'] = '<div class="alert_message">' . $_SESSION['peg_dic_core_is_std_nochange'] . '</div>';
	}
	if (empty($data['message'])) {
		$data['message_hidden'] = 1;
	}
	
	//Παραμετροποίηση myDATA 
	if ($rec_copy_nr01 > 0) {
		$data['v_q30_620051'] = pegasus_mysql_printfld("q31", "p05", "p03 = ? and p01 = 620051", array($rec_copy_nr01));;
	}else{
		$data['v_q30_620051'] = pegasus_mysql_printfld("q31", "p05", "p03 = ? and p01 = 620051", array($data['nr01']));
	}

	return $data;
}
function invoices_a77_d_onchange($data , $permDeny , $mmnr01 , $checkOnlyPerm){
	global $PegInput;
	
	//Παραμετροποίηση myDATA
	if ($checkOnlyPerm == 1){
		$PegInput->addVar(new peg_input_alphanumeric('v_q30_620051', 'request'));
		$v_q30_620051 = $PegInput->getRequest('v_q30_620051');

		core00_manage_relation($v_q30_620051, '620051', $data['nr01']);
	}
	

	return array($data, $permDeny);
}
function invoices_erpa13_d_initialize($data, $mmnr01, $mnr01, $_d, $container_id)
{
	//Παραμετροποίηση myDATA
	$data['v_q30_620057'] = pegasus_mysql_printfld("q31", "p05", "p03 = ? and p01 = 620057", array($data['nr01']));

	if($data['is_std'] == 1) {
		$data['v_message'] = '<div class="alert_message">' . $_SESSION['peg_dic_invoices_i70_is_std'] . '</div>';
		$data['v_message_hidden'] = 0;
		$data['p01_readonly'] = 1;
		$data['p101_readonly'] = 1;
		$data['v_q30_620057_readonly'] = 1;
	}

	return $data;
}
function invoices_erpa13_d_onchange($data , $permDeny , $mmnr01 , $checkOnlyPerm){
	$new_rec = 0;

	if(!($data['nr01'] > 0)) {
        $new_rec = 1;
	}

	global $PegInput;
	//Παραμετροποίηση myDATA
	if ($checkOnlyPerm == 1){
		$PegInput->addVar(new peg_input_alphanumeric('v_q30_620057', 'request'));
		$v_q30_620057 = $PegInput->getRequest('v_q30_620057');

		core00_manage_relation($v_q30_620057, '620057', $data['nr01']);
	}

	if($data['nr01'] >= 10000000000 && $new_rec == 1) {
		array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_invoices_deny_rec_submitted']));
	}

	return array($data, $permDeny);
}

function invoices_set_a90($mode, $parent_nr01, $nr01)
{

	if ($mode == "a57") {
		$mode2 = "a58";
	}
	if ($mode == "a67") {
		$mode2 = "a68";
	}
	if ($mode == "a55") {
		$mode2 = "i01";
	}
	if ($mode == "a56") {
		$mode2 = "i01";
	}
	if ($mode == "a60") {
		$mode2 = "i01";
	}

	if (isset($_REQUEST['v_a90_p30'])) {

		$arr = array();

		$arr['peg_sess_id']    = session_id();
		$arr['peg_mnr01']    = $nr01;
		$arr['peg_mmnr01']    = $mode . "_d-" . $parent_nr01;
		$arr['p30'] = $_REQUEST['v_a90_p30'];
		$arr['tbl']    = $mode2;
		$arr['tbl_nr01']    = $nr01;



		$a90_tmp_where = "peg_mmnr01=:peg_mmnr01 and peg_mnr01=:peg_mnr01  and peg_sess_id=:peg_sess_id and peg_flag!=:peg_flag and tbl=:tbl and tbl_nr01=:tbl_nr01";
		$a90_tmp_vals = array(
			'peg_mmnr01'	=>	$mode . "_d-" . $parent_nr01,
			'peg_mnr01'		=>	$nr01,
			'peg_sess_id'	=>	session_id(),
			'peg_flag'		=>	'9',
			'tbl'			=>  $mode2,
			'tbl_nr01'		=>	$nr01
		);

		$a90_nr01 = pegasus_mysql_printfld('peg_tmp_a90', 'nr01', $a90_tmp_where, $a90_tmp_vals);

		if ($a90_nr01 > 0) {
			//update peg_tmp_a90
			$arr['peg_flag'] = 2;
			$arr['nr01'] = $a90_nr01;
			pegasus_mysql_update('peg_tmp_a90', array_keys($arr), array_values($arr), $a90_tmp_where, 0, 1, 1, $a90_tmp_vals);
		} else {
			//insert peg_tmp_a90
			$arr['peg_flag'] = 1;
			$arr['nr01'] = pegasus_mysql_newrec('a90');
			pegasus_mysql_insert('peg_tmp_a90', array_keys($arr), array_values($arr));
		}
	}
}

function invoices_find_a90_p30($mode, $parent_nr01, $nr01)
{

	if ($mode == "a57") {
		$mode2 = "a58";
	}
	if ($mode == "a67") {
		$mode2 = "a68";
	}
	if ($mode == "a55") {
		$mode2 = "i01";
	}
	if ($mode == "a56") {
		$mode2 = "i01";
	}
	if ($mode == "a60") {
		$mode2 = "i01";
	}

	$a90_tmp_where = "peg_mmnr01=:peg_mmnr01 and peg_mnr01=:peg_mnr01  and peg_sess_id=:peg_sess_id and peg_flag!=:peg_flag and tbl=:tbl and tbl_nr01=:tbl_nr01";
	$a90_tmp_vals = array(
		'peg_mmnr01'	=>	$mode . "_d-" . $parent_nr01,
		'peg_mnr01'		=>	$nr01,
		'peg_sess_id'	=>	session_id(),
		'peg_flag'		=>	'9',
		'tbl'			=>  $mode2,
		'tbl_nr01'		=>	$nr01
	);

	pegasus_mysql_use("select * from peg_tmp_a90 where " . $a90_tmp_where, $a90, $a90_tmp_vals);

	$p30 = '';
	if ($a90['nr01'] > 0) {
		$p30 = $a90['p30'];
	}


	return $p30;
}


function invoices_i70_d_initialize($data, $mmnr01, $mnr01, $_d, $container_id)
{
	global $PegInput;
	$PegInput->addVar(new peg_input_number('rec_copy_nr01'));
	$rec_copy_nr01  = $PegInput->getRequest('rec_copy_nr01');

	$new_rec=false;
	if(!(pegasus_mysql_printfld('i70','nr01','nr01=:nr01',array('nr01'=>$data['nr01'])) >0 )){
		$new_rec=true;
		if(!($data['nr01']>0)) {
			$data['nr01'] = pegasus_mysql_newrec('i70');
		}
	}
	$data = invoices_i70_d_refresh($data);
	//	Αν είναι Standard ή Αν δεν είναι νέα εγγραφή και έχει υπάρχει έστω και μια φορά στον i71 δεν μπορεί να αλλάξει πεδία της εγγραφής

	$data['p08_readonly']   = true;

	$is_std=$data['is_std']==1?true:false;
	$is_used=pegasus_mysql_printfld('i71','nr01','i70=:i70',array('i70'=>$data['nr01'])) > 0?true:false;
	$msg='';
	if(in_array($data['p03'], array('1','5') )) {
		$data['p08_readonly']   = false;
	}
	if($is_std) {
		$data['tax_readonly']   = true;
		$data['p01_readonly']   = true;
		$data['p02_readonly']   = true;
		$data['p03_readonly']   = true;
		$data['p04_readonly']   = true;
		$data['p05_readonly']   = true;
		$data['p05_1_readonly']   = true;
		$data['p06_readonly']   = true;
		$data['p06_1_readonly'] = true;
		$data['p07_readonly']   = true;
		$data['p106_readonly']   = true;
		$msg = $_SESSION['peg_dic_invoices_i70_is_std'];
		if($is_used) {
			$data['p08_readonly']   = true;
			$msg.="<br>".$_SESSION['peg_dic_invoices_i70_is_std_type'];
		}
	}
	elseif($is_used) {
		$data['tax_readonly']   = true;
		$data['p01_readonly']   = true;
		$data['p02_readonly']   = true;
		$data['p03_readonly']   = true;
		$data['p04_readonly']   = true;
		$data['p05_readonly']   = true;
		$data['p05_1_readonly']   = true;
		$data['p06_readonly']   = true;
		$data['p06_1_readonly'] = true;
		$data['p07_readonly']   = true;
		$data['p08_readonly']   = true;
		$data['p106_readonly']   = true;
		$msg = $_SESSION['peg_dic_invoices_i70_is_used'];
	}
	if (empty($msg)) {
		$data['message_hidden'] = 1;
	}
	else {
		$data['message'] = '<div class="alert_message">' .$msg. '</div>';
	}

	//Παραμετροποίηση myDATA
	if ($rec_copy_nr01 > 0) {
		$data['v_q30_620046'] = pegasus_mysql_printfld("q31", "p05", "p03 = ? and p01 = 620046", array($rec_copy_nr01)); 
		$data['v_q30_620047'] = pegasus_mysql_printfld("q31", "p05", "p03 = ? and p01 = 620047", array($rec_copy_nr01)); 
		$data['v_q30_620048'] = pegasus_mysql_printfld("q31", "p05", "p03 = ? and p01 = 620048", array($rec_copy_nr01)); 
		$data['v_q30_620049'] = pegasus_mysql_printfld("q31", "p05", "p03 = ? and p01 = 620049", array($rec_copy_nr01)); 
		$data['v_q30_620052'] = pegasus_mysql_printfld("q31", "p05", "p03 = ? and p01 = 620052", array($rec_copy_nr01)); 
		$data['v_q30_620053'] = pegasus_mysql_printfld("q31", "p05", "p03 = ? and p01 = 620053", array($rec_copy_nr01)); 
		$data['v_q30_620054'] = pegasus_mysql_printfld("q31", "p05", "p03 = ? and p01 = 620054", array($rec_copy_nr01)); 
		$data['v_q30_620055'] = pegasus_mysql_printfld("q31", "p05", "p03 = ? and p01 = 620055", array($rec_copy_nr01)); 
		$data['v_q30_620059'] = pegasus_mysql_printfld("q31", "p05", "p03 = ? and p01 = 620059", array($rec_copy_nr01)); 
	}else{
		$data['v_q30_620046'] = pegasus_mysql_printfld("q31", "p05", "p03 = ? and p01 = 620046", array($data['nr01'])); 
		$data['v_q30_620047'] = pegasus_mysql_printfld("q31", "p05", "p03 = ? and p01 = 620047", array($data['nr01'])); 
		$data['v_q30_620048'] = pegasus_mysql_printfld("q31", "p05", "p03 = ? and p01 = 620048", array($data['nr01'])); 
		$data['v_q30_620049'] = pegasus_mysql_printfld("q31", "p05", "p03 = ? and p01 = 620049", array($data['nr01'])); 
		$data['v_q30_620052'] = pegasus_mysql_printfld("q31", "p05", "p03 = ? and p01 = 620052", array($data['nr01'])); 
		$data['v_q30_620053'] = pegasus_mysql_printfld("q31", "p05", "p03 = ? and p01 = 620053", array($data['nr01'])); 
		$data['v_q30_620054'] = pegasus_mysql_printfld("q31", "p05", "p03 = ? and p01 = 620054", array($data['nr01'])); 
		$data['v_q30_620055'] = pegasus_mysql_printfld("q31", "p05", "p03 = ? and p01 = 620055", array($data['nr01'])); 
		$data['v_q30_620059'] = pegasus_mysql_printfld("q31", "p05", "p03 = ? and p01 = 620059", array($data['nr01'])); 
	}

	return $data;
}

function peg_invoices_i70_d_onsave($data, $permDeny, $mmnr01, $checkOnlyPerm)
{
	global $PegInput;

	//Παραμετροποίηση myDATA
	if ($checkOnlyPerm == 1){
		$PegInput->addVar(new peg_input_alphanumeric('v_q30_620046', 'request'));
		$PegInput->addVar(new peg_input_alphanumeric('v_q30_620047', 'request'));
		$PegInput->addVar(new peg_input_alphanumeric('v_q30_620048', 'request'));
		$PegInput->addVar(new peg_input_alphanumeric('v_q30_620049', 'request'));
		$PegInput->addVar(new peg_input_alphanumeric('v_q30_620052', 'request'));
		$PegInput->addVar(new peg_input_alphanumeric('v_q30_620053', 'request'));
		$PegInput->addVar(new peg_input_alphanumeric('v_q30_620054', 'request'));
		$PegInput->addVar(new peg_input_alphanumeric('v_q30_620055', 'request'));
		$PegInput->addVar(new peg_input_alphanumeric('v_q30_620059', 'request'));
		$v_q30_620046 = $PegInput->getRequest('v_q30_620046');
		$v_q30_620047 = $PegInput->getRequest('v_q30_620047');
		$v_q30_620048 = $PegInput->getRequest('v_q30_620048');
		$v_q30_620049 = $PegInput->getRequest('v_q30_620049');
		$v_q30_620052 = $PegInput->getRequest('v_q30_620052');
		$v_q30_620053 = $PegInput->getRequest('v_q30_620053');
		$v_q30_620054 = $PegInput->getRequest('v_q30_620054');
		$v_q30_620055 = $PegInput->getRequest('v_q30_620055');
		$v_q30_620059 = $PegInput->getRequest('v_q30_620059');
		
		core00_manage_relation($v_q30_620046, '620046', $data['nr01']);
		core00_manage_relation($v_q30_620047, '620047', $data['nr01']);
		core00_manage_relation($v_q30_620048, '620048', $data['nr01']);
		core00_manage_relation($v_q30_620049, '620049', $data['nr01']);
		core00_manage_relation($v_q30_620052, '620052', $data['nr01']);
		core00_manage_relation($v_q30_620053, '620053', $data['nr01']);
		core00_manage_relation($v_q30_620054, '620054', $data['nr01']);
		core00_manage_relation($v_q30_620055, '620055', $data['nr01']);
		core00_manage_relation($v_q30_620059, '620059', $data['nr01']);
	}
	return array($data, $permDeny);
}

function invoices_i70_d_refresh($data)
{
	// 2 = Αξία Οριζόμενη από Χρήστη
	$data['p04_readonly'] = false;
	if ($data['p03'] == 2) {
		$data['p04_readonly'] = true;
	}

	// 3 = Ποσοστό * Αξία Συγκεκριμένης Χρέωσης
	$data['p05_hidden'] = true;
	if ($data['p03'] == 3) {
		$data['p05_hidden'] = false;
	}

	$data['p05_1_hidden'] = true;
	if ($data['p03'] == 3) {
		$data['p05_1_hidden'] = false;
	}

	return $data;
}

function invoices_i71_d_initialize($data, $mmnr01, $mnr01, $_d, $container_id)
{
	$is_new=true;
	if(pegasus_mysql_printfld('i71','nr01','nr01=:nr01',array('nr01'=>$data['nr01']))>0) {
		$is_new=false;
	}
	if (substr($mmnr01, 0, 3) == 'a55') {
		$data['tbl'] = 'a55';
		$data['readonly'] = pegasusGetGlobalVar('peg_a55_d-' . $mnr01 . '_is_readonly');
	}

	if (substr($mmnr01, 0, 3) == 'a57') {
		$data['tbl'] = 'a57';
	}

	if (substr($mmnr01, 0, 3) == 'a67') {
		$data['tbl'] = 'a67';
	}

	if (substr($mmnr01, 0, 3) == 'a56') {
		$data['tbl'] = 'a56';
		$data['readonly'] = pegasusGetGlobalVar('peg_a56_d-' . $mnr01 . '_is_readonly');
	}

	if (substr($mmnr01, 0, 6) == 'tran01') {
		$data['tbl'] = 'tran01';
	}

	$data['tbl_nr'] = $mnr01;

	if (!($data['i70p02'] > 0)) {
		$data['i70p02'] = 1;
	}



	if($data['tbl'] == 'tran01') {
		$tot_array = pegasusGetGlobalVar($data['tbl'] . '_d' . $data['tbl_nr'] . '_totals_arr');
		$vp0109 = $tot_array['p09'];
	}else{
		//echo $data['tbl_nr'] . '_' .  $data['tbl_nr'];
		$tot_array   = invoices_get_total_var($data['tbl'], $data['tbl_nr']);
		$total_p0100 = $tot_array['p0100'];
		$total_p0102 = $tot_array['p0102'];
		$vp0109 = $total_p0100 - $total_p0102;
		//echo print_r($tot_array, true);
		//echo 'total_p0100' . $total_p0100;
	}
	

	$refresh_data=$data;
	$refresh_data['tbl_p07'] = $_REQUEST['tbl_p07'];
	$refresh_data['tbl_pn02'] = $_REQUEST['tbl_pn02'];

	$newi70=false;
	if($_REQUEST['rec_copy_nr01'] > 0){
		$newi70=true;
	}

	$data = invoices_i71_d_refresh($refresh_data, $vp0109,$newi70,$is_new);

	return $data;
}

function invoices_i71_d_refresh($data, $vp0109,$is_i70_change=false,$is_new=false)
{


	$data['p04_hidden']  = true;
	$data['p05_hidden']  = true;
	$data['p05_1_hidden']  = true;
	$data['p04_readonly']  = true;
	$data['p05_readonly']  = true;
	$data['p05_1_readonly']   = true;

	pegasus_mysql_use('select * from i70 where nr01=:nr01', $i70,  array('nr01' => $data['i70']));
	if ($data['i70p02'] != $i70['p02']) {

		$data['p04']  = 0;
		$data['p05']  = 0;
		$data['p100'] = 0;

		$data['i70']  = 0;
		$data['v_selectbox_i70']='';

		$data['i70p07']  = 0;
		return $data;
	}
	//	Ενημέρωση το i71.tax από το i70.tax
	if($is_i70_change) {
		$data['tax']=$i70['tax'];
	}

	$data['i70']     = $i70['nr01'];
	$data['v_selectbox_i70'] = $i70['p01'];
	$data['i70p07']  = $i70['p07'];
	// Ποσοστό * Καθαρή Αξία Παραστατικού
	if ($i70['p03'] == 1) {

		$i70_p08=explode("#",$i70['p08']);
		if(count($i70_p08)>1 && $data['tbl'] !== 'tran01') {
			array_pop($i70_p08);
			array_shift($i70_p08);
			$resp=invoice_get_netValueSum(
				$data['tbl'],
				$data['tbl_nr'],
				$data['tbl_p07'],
				$i70_p08,
				$data['tbl_pn02']
			);
			// Testing
			// if($resp['ok']!=1) {
			// 	print_r($resp);
			// 	die ();
			// }
			$vp0109= $resp['data']['p0100'];
		}
		$data['p04']  = $i70['p04'];
		$data['p04_hidden']    = false;
		$data['p04_readonly']  = true;


		$data['p05']  = $vp0109;
		$data['p05_hidden']    = false;
		$data['p05_1_hidden']  = false;
		$data['p05_readonly']  = true;
		$data['p05_1_readonly']   = true;

		$data['p100']  = $data['p04'] * $data['p05'] / 100;
	}

	// Αξία Οριζόμενη από Χρήστη
	if ($i70['p03'] == 2) {
		$data['p04']  = 0;
		$data['p04_hidden']    = true;
		$data['p04_readonly']  = true;

		$data['p05_hidden']    = false;
		$data['p05_1_hidden']  = false;
		$data['p05_readonly']  = false;
		$data['p05_1_readonly']   = false;

		$data['p100']  = $data['p05'];
	}

	// "Ποσοστό * Αξία Συγκεκριμένης Χρέωσης
	if ($i70['p03'] == 3) {

		$data['p04']  = $i70['p04'];
		$data['p04_hidden']    = false;
		$data['p04_readonly']  = true;

		$i70_p05_1 = $i70['p05_1'];

		$i70_p05_1 = str_replace("#",",",$i70_p05_1);
		$i70_p05_1 = substr($i70_p05_1, 1);
		$i70_p05_1 = substr($i70_p05_1, 0, -1);

		$i70_p05_1 = explode(',' , $i70_p05_1);
		
		$i70_p05_1_in = pegasus_mysql_create_in($i70_p05_1, 'i70_p05');

		$values = array(
			'peg_sess_id' => session_id(),
			'peg_mmnr01'  => $data['tbl'] . '_d-' . $data['tbl_nr']
		);
		
		$values = array_merge($values, $i70_p05_1_in['sqlParams']);

		$data['p05']  = pegasus_mysql_printfld(
			'peg_tmp_i71',
			'sum(p100)',
			'peg_tmp_i71.i70 IN (' . $i70_p05_1_in['sql'] . ') and peg_tmp_i71.peg_sess_id=:peg_sess_id and peg_tmp_i71.peg_flag!=9 and peg_tmp_i71.peg_mmnr01=:peg_mmnr01',
			$values
		);

		$data['p05_hidden']    = false;
		$data['p05_1_hidden']  = false;
		$data['p05_readonly']  = true;
		$data['p05_1_readonly']   = true;

		$data['p100']  = $data['p04'] * $data['p05'] / 100;
	}

	// Συγκεκριμένη Αξία
	if ($i70['p03'] == 4) {
		$data['p04']  = 0;
		$data['p04_hidden']    = true;
		$data['p04_readonly']  = true;

		$data['p05']  = $i70['p04'];
		$data['p05_hidden']    = false;
		$data['p05_1_hidden']  = false;
		$data['p05_readonly']  = true;
		$data['p05_1_readonly']   = true;

		$data['p100']  = $data['p05'];
	}
	//	Ποσοστό * Καθαρή Αξία και Προοδευτική Αξία Φόρων-Κρατήσεων
	if ($i70['p03'] == 5) {

		$i70_p08=explode("#",$i70['p08']);
		if(count($i70_p08)>1) {
			array_pop($i70_p08);
			array_shift($i70_p08);
			$resp=invoice_get_netValueSum(
				$data['tbl'],
				$data['tbl_nr'],
				$data['tbl_p07'],
				$i70_p08,
				$data['tbl_pn02']
			);
			// Testing
			 //if($resp['ok']!=1) {
			 	//print_r($resp);
			 	//die ();
			 //}
			$vp0109= $resp['data']['p0100'];
		}
		$data['p04']  = $i70['p04'];
		$data['p04_hidden']    = false;
		$data['p04_readonly']  = true;
		//if(!$is_new)
		//{
			//print "total_p0100=$total_p0100\n";
			$resp = invoices_i71_proodeutikos_ypologismos_i71_p05(
				$data,
				$vp0109
			);
			// Testing
			// if($resp['ok']!=1) {
			// 	print_r($resp);
			// 	die ();
			// }
			$data['p05'] = $resp['data']['p05'];
		//}
		$data['p05_hidden']    = false;
		$data['p05_1_hidden']  = false;
		$data['p05_readonly']  = true;
		$data['p05_1_readonly']   = true;
		$data['p100']  = $data['p04'] * $data['p05'] / 100;
	}
	if ($i70['nr01'] > 0 && !($vp0109 >= $i70['p06']  && $vp0109 < $i70['p06_1'])) {
		$data['p04']  = 0;
		$data['p05']  = 0;
		$data['p100'] = 0;
		$data['message'] = '<div class="alert_message">' .  $_SESSION['peg_dic_invoices_i70_p0100_limits'] . '</div>';
	}
	return $data;
}
/**
 * Υπολογισμός Συνόλου καθαρής αξίας ειδών (παραστατικού ή παραγγελίας)
 *
 * @param string $tbl			Πινάκας αναφοράς (a55,a56,a57,a67)		[παραστατικού ή παραγγελίας]
 * @param integer $tbl_nr01		nr01 Πινάκα αναφοράς					[παραστατικού ή παραγγελίας]
 * @param boolean $tbl_p07		Τιμές Με ΦΠΑ (Εγγραφής αναφοράς)		[παραστατικού ή παραγγελίας]
 * @param array $i10_p01		Φίλτρο Τύπου προϊόντων 					[παραστατικού ή παραγγελίας]
 * @param integer $tbl_pn02		Ισοτιμία Νομίσματος (Εγγραφής αναφοράς)	[παραστατικού]
 *
 * Φίλτρο Τύπου προϊόντων (Αν οριστεί αγνοεί όσα είδη δεν είναι μέσα σε αυτούς τους τύπους)
 *
 * @return array
 */
function invoice_get_netValueSum(
	$tbl = '',
	$tbl_nr01 = 0,
	$tbl_p07 = false,
	$i10_p01 = array(),
	$tbl_pn02 = 1

) {
	try {
		$data = array();
		//	Παραγγελίες
		if (in_array($tbl, array('a57', 'a67'))) {
			$resp = invoice_get_order_netValueSum(
				$tbl,
				$tbl_nr01,
				$tbl_p07,
				$i10_p01
			);
			if ($resp['ok'] != 1) {
				throw new Exception($resp['error']);
			}
			$data = $resp['data'];
		}
		//	Παραστατικά
		elseif (in_array($tbl, array('a55', 'a56'))) {
			$resp = invoice_get_document_netValueSum(
				$tbl,
				$tbl_nr01,
				$tbl_p07,
				$i10_p01,
				$tbl_pn02
			);
			if ($resp['ok'] != 1) {
				throw new Exception($resp['error']);
			}
			$data = $resp['data'];
		} else {
			throw new Exception("Table $tbl not supported");
		}
		return array(
			'ok'	=> 1,
			'error'	=> NULL,
			'data'	=> $data,
			'msg'	=> 'Success'
		);
	} catch (Exception $e) {
		return array(
			'ok'	=> 1,
			'error'	=> '[invoice_get_netValueSum]' . $e->getMessage(),
			'data'	=> NULL,
			'msg'	=> 'Error'
		);
	}
}
/**
 * Εύρεση της συνολικής καθαρής αξίας ειδών παραστατικού (p0100)
 *
 * @param string $tbl			Πινάκας αναφοράς (a55,a56)
 * @param integer $tbl_nr01		nr01 Πινάκα αναφοράς
 * @param boolean $tbl_p07		Τιμές Με ΦΠΑ (Εγγραφής αναφοράς)
 * @param array $i10_p01		Φίλτρο Τύπου προϊόντων (Αν οριστεί αγνοεί όσα είδη δεν είναι μέσα σε αυτούς τους τύπους)
 * @param integer $tbl_pn02		Ισοτιμία Νομίσματος (Εγγραφής αναφοράς)
 * @return array data[
 * - p0100	Συνολική καθαρή αξία ειδών παραστατικού
 * ]
 */
function invoice_get_document_netValueSum(
	$tbl = '',
	$tbl_nr01 = 0,
	$tbl_p07 = false,
	$i10_p01 = array(),
	$tbl_pn02 = 1

) {
	try {
		$data = array();
		if (!in_array($tbl, array('a55', 'a56'))) {
			throw new Exception("Table $tbl not supported");
		}
		$v1042 = 'p042';
		$v616  = 'p616';
		//	Αν οι τιμές περιέχουν ΦΠΑ…  αποφορολόγηση
		if ($tbl_p07) {
			$v1042 = '(p042 * (100 + p08) / 100)';
			$v616  = '(p616 * (100 + p08) / 100)';
		}
		$v107 = "((p03 * p04 * ((100 - p010) / 100) * ((100 - p010a) / 100)) + ( $v1042 * p03) + ( $v616 * p03))";
		$pkath = "ROUND( ($v107) * (100 - p0100) / 100, 2)";
		//	Αν οι τιμές περιέχουν ΦΠΑ…  αποφορολόγηση
		if ($tbl_p07) {
			$pkath = "ROUND( ($v107 * 100/(100 + p08)) * (100 - p0100) / 100, 2)";
		}
		$sql = "SELECT
				SUM(ttt.p011) AS p011_sum
			FROM (
				SELECT
					($pkath * :tbl_pn02)	AS p011,
					p01						AS pno
				FROM
					peg_tmp_i01
				WHERE p06 		 = :p06
				AND	p07			 = :p07
				AND peg_mnr01  	 = :peg_mnr01
				AND peg_mmnr01	 = :peg_mmnr01
				AND peg_sess_id  = :peg_sess_id
				AND peg_flag	!= :peg_flag
			) AS ttt
		";
		$values = array(
			"p06"			=> $tbl_nr01,
			"p07"			=> $tbl == "a55" ? 2 : 1,
			"tbl_pn02"		=> $tbl_pn02,
			"peg_mnr01"		=> $tbl_nr01,
			"peg_mmnr01"	=> $tbl . '_d-' . $tbl_nr01,
			"peg_sess_id"	=> session_id(),
			"peg_flag"		=> 9,
		);
		//	//	Αν έχει δοθεί φίλτρο το προσθέτουμε
		if (count($i10_p01) > 0) {
			$i10_p01_in = pegasus_mysql_create_in($i10_p01, 'i10');
			$sql .= "
				LEFT JOIN i00 ON i00.pno = ttt.pno
				WHERE i00.p62 IN (" . $i10_p01_in['sql'] . ")
			";
			$values = array_merge($values, $i10_p01_in['sqlParams']);
		}
		//print pegasus_replace_values_in_sql($sql,$values);
		$res = pegasus_query($sql, $values);
		if (!$res) {
			throw new Exception(pegasus_mysql_error());
		}
		$sum = pegasus_fetch_assoc($res);
		//print_r($sum);
		$data['p0100'] = $sum['p011_sum'];
		return array(
			'ok'	=> 1,
			'error'	=> NULL,
			'data'	=> $data,
			'msg'	=> 'Success'
		);
	} catch (Exception $e) {
		return array(
			'ok'	=> 1,
			'error'	=> '[invoice_get_document_netValueSum]' . $e->getMessage(),
			'data'	=> NULL,
			'msg'	=> 'Error'
		);
	}
}
/**
 * Εύρεση της συνολικής καθαρής αξίας ειδών παραγγελίας (p0100)
 *
 * @param string $tbl			Πινάκας αναφοράς (a57,a67)
 * @param integer $tbl_nr01		nr01 Πινάκα αναφοράς
 * @param boolean $tbl_p07		Τιμές Με ΦΠΑ (Εγγραφής αναφοράς)
 * @param array $i10_p01		Φίλτρο Τύπου προϊόντων (Αν οριστεί αγνοεί όσα είδη δεν είναι μέσα σε αυτούς τους τύπους)
 * @return array data[
 *  - p0100	Συνολική καθαρή αξία ειδών παραγγελίας
 * ]
 */
function invoice_get_order_netValueSum(
	$tbl = '',
	$tbl_nr01 = 0,
	$tbl_p07 = false,
	$i10_p01 = array()
) {
	try {
		$data = array();
		$p_dek = 2;		// AFTO DEN KSERW APO POU NA TO PARW....
		$p0100=0;
		if (!in_array($tbl, array('a57', 'a67'))) {
			throw new Exception("Table $tbl not supported");
		}
		//	Βρίσκουμε των line Items (από τους temporary τους)
		$lineItemTable = $tbl == 'a57' ? 'peg_tmp_a58' : 'peg_tmp_a68';
		$sql = "SELECT
				ttt.v105,
				ttt.v107
			FROM
			(
				SELECT
					v105	AS v105,
					v107	AS v107,
					v101	AS pno
				FROM $lineItemTable
				WHERE p00		 = :p00
				AND peg_mnr01	 = :peg_mnr01
				AND peg_mmnr01	 = :peg_mmnr01
				AND peg_sess_id  = :peg_sess_id
				AND peg_flag	!= :peg_flag
			) AS ttt
		";
		$values = array(
			"p00"			=> $tbl_nr01,
			"peg_mnr01"		=> $tbl_nr01,
			"peg_mmnr01"	=> $tbl . '_d-' . $tbl_nr01,
			"peg_sess_id"	=> session_id(),
			"peg_flag"		=> 9,
		);
		//	Αν έχει δοθεί φίλτρο το προσθέτουμε
		if (count($i10_p01) > 0) {
			$i10_p01_in = pegasus_mysql_create_in($i10_p01, 'i10');
			$sql .= "
				LEFT JOIN i00 ON i00.pno = ttt.pno
				WHERE i00.p62 IN (" . $i10_p01_in['sql'] . ")
			";
			$values = array_merge($values, $i10_p01_in['sqlParams']);
		}
		//	Line Items query
		$res = pegasus_query($sql, $values);
		if (!$res) {
			throw new Exception(pegasus_mysql_error());
		}
		//	Υπολογισμός Συνόλου p0100
		while ($lineItem = pegasus_fetch_assoc($res)) {
			//	Προσθήκη υποσύνολου (Line Item v107) στο p0100
			$liv=$lineItem['v107'];
			//	Αν περιέχει ΦΠΑ αποφορολόγηση
			if ($tbl_p07){
				$liv = $liv * 100 / (100 + $lineItem['v105']);
			}
			$p0100 += round($liv, $p_dek);
		}
		//	Υπολογισμός του net value sum (για παραγγελίες) p0100
		$data['p0100'] = $p0100;
		return array(
			'ok'	=> 1,
			'error'	=> NULL,
			'data'	=> $data,
			'msg'	=> 'Success'
		);
	} catch (Exception $e) {
		return array(
			'ok'	=> 1,
			'error'	=> '[invoice_get_order_netValueSum]' . $e->getMessage(),
			'data'	=> NULL,
			'msg'	=> 'Error'
		);
	}
}
function invoices_i71_proodeutikos_ypologismos_i71_p05(
	$curent_i71,
	$p05
) {
	try {
		$i71s=array();
		$data=array();
		$sql="	SELECT * FROM peg_tmp_i71
			WHERE
			i70p07 = 1
			AND tbl			=:tbl
			AND tbl_nr		=:tbl_nr
			AND peg_mnr01	=:peg_mnr01
			AND peg_mmnr01	=:peg_mmnr01
			AND peg_sess_id	=:peg_sess_id
			AND peg_flag	!=:peg_flag
			AND (tax < :tax OR (tax = :tax AND nr01 < :nr01))
			ORDER BY tax, nr01
		";
		$values=array(
			'tbl'			=> $curent_i71['tbl'],
			'tbl_nr'		=> $curent_i71['tbl_nr'],
			'peg_mnr01'		=> $curent_i71['tbl_nr'],
			'peg_mmnr01'	=> $curent_i71['tbl'] . '_d-' . $curent_i71['tbl_nr'],
			'peg_sess_id'	=> session_id(),
			'peg_flag'		=> 9,
			'tax'			=> $curent_i71['tax'],
			'nr01'			=> is_null($curent_i71['nr01'])?99999999:$curent_i71['nr01']	//
		);
		$res=pegasus_query($sql,$values);
		if(!$res) {
			throw new Exception(pegasus_mysql_error());
		}
		$i71s = pegasus_fetchall($res);
		foreach($i71s  as $i71) {
			$pp=$i71['i70p02']==1?1:-1;
			$p05  += $pp * $i71['p100'];
		};
		$data['p05'] = $p05;
		return array(
			'ok'	=> 1,
			'error'	=> NULL,
			'data'	=> $data,
			'msg'	=> 'Success'
		);
	} catch (Exception $e) {
		return array(
			'ok'	=> 0,
			'error'	=> '[invoices_i71_proodeutikos_ypologismos_i71_p05]' . $e->getMessage(),
			'data'	=> NULL,
			'msg'	=> 'Error'
		);
	}
}

function invoices_eidi_mass_selection_custom_actions_peg002($retArray = array(), $id = '')
{
	$peg_handler = "invoices_eidi_mass_selectiontoolbar_item(screen.getContainer_ID(), '" . $id . "' , '" . $_SESSION['peg_dic_core_perm_deny'] . "' )";
	$retArray[] = array(
		'xtype' => 'pegasusToolBarGridAction',
		'peg_custom_id' => 'invoices_eidi_mass_selection',
		'icon' => 'invoices_images/invoices_mass_submition_16x16.png',
		'text' =>  $_SESSION['peg_dic_invoices_mass_submition'],
		'peghandler' => $peg_handler
	);
	return $retArray;
}

//Καλείται π.χ. στο browse_value του πεδίου v_cs_en
function peg_invoices_v_cs_en($pno)
{
	if (!pegasus_module_exists('colorsize')) {
		return 0;
	}
	return ((pegasus_mysql_printfld('i47', 'count(*)', 'p01=?', array($pno)) > 0) ? 1 : 0);
}

function peg_invoices_v_sn_en($pno)
{
	if (!pegasus_module_exists('serial')) {
		return 0;
	}
	return ((pegasus_mysql_printfld('i00', 'ps01', 'pno=?', array($pno)) > 0) ? 1 : 0);
}

function peg_invoices_v_lot_en($pno, $mode='')
{
	if (!pegasus_module_exists('lot')) {
		return 0;
	}
	$f02_p637_var = $_SESSION['f02_p637'];
	if($mode == 'a57' || $mode == 'a67' || $mode == 'a61' ){
		$f02_p637_var = $_SESSION['f02_p637o'];
	}
	return ((pegasus_mysql_printfld('i00', 'p904', 'pno=?', array($pno))>0 && $f02_p637_var==1) ? 1 : 0);
}
function peg_invoices_v_v104_novat($tb) {
	if(in_array(substr($tb['peg_mmnr01'], 0, 3), array('a57', 'a67'))) {
		$_pososto_fpa = (100 + $tb['v105']) / 100;
		$order_p07    = pegasusGetGlobalVar('peg_'.substr($tb['peg_mmnr01'], 0, 3).'_d-' . $tb['peg_mnr01'] . '_p07');

		$ret = $tb['v104'];

		if($order_p07 == 1) {
			$ret = $tb['v104'] / $_pososto_fpa;
		}
	} else if(in_array(substr($tb['peg_mmnr01'], 0, 3), array('a55', 'a56', 'a60'))) { 
		$_pososto_fpa = (100 + $tb['p08']) / 100;

		$ret = $tb['p04'];

		if($tb['p09'] == 1) {
			$ret = $tb['p04'] / $_pososto_fpa;
		}
	} else {
		$ret = 0;
	}
	return $ret;
}
function peg_invoices_v_v104_vat($tb) {
	if(in_array(substr($tb['peg_mmnr01'], 0, 3), array('a57', 'a67'))) {
		$_pososto_fpa = (100 + $tb['v105']) / 100;
		$order_p07    = pegasusGetGlobalVar('peg_'.substr($tb['peg_mmnr01'], 0, 3).'_d-' . $tb['peg_mnr01'] . '_p07');

		$ret = $tb['v104'] * $_pososto_fpa;

		if($order_p07 == 1) {
			$ret = $tb['v104'];
		}
	} else if(in_array(substr($tb['peg_mmnr01'], 0, 3), array('a55', 'a56', 'a60'))) {
		$_pososto_fpa = (100 + $tb['p08']) / 100;

		$ret = $tb['p04'] * $_pososto_fpa;

		if($tb['p09'] == 1) {
			$ret = $tb['p04'];
		}
	} else {
		$ret = 0;
	}
	return $ret;
}
function peg_invoices_v_v107_novat($tb) {
	if(in_array(substr($tb['peg_mmnr01'], 0, 3), array('a57', 'a67'))) {
		$_pososto_fpa = (100 + $tb['v105']) / 100;
		$order_p07    = pegasusGetGlobalVar('peg_'.substr($tb['peg_mmnr01'], 0, 3).'_d-' . $tb['peg_mnr01'] . '_p07');

		$v107 = invoices_make_product_total($tb['v103'], $tb['v104'], $tb['v105'], $tb['v106'], $tb['v106a'], $tb['v1041'], $tb['v616'], $order_p07, $tb['v1042']);

		if($order_p07 == 1) {
			$ret = round($v107 / $_pososto_fpa, 2);
		} else {
			$ret = round($v107, 2);
		}
	} else if(in_array(substr($tb['peg_mmnr01'], 0, 3), array('a55', 'a56', 'a60'))) {
		$_pososto_fpa = (100 + $tb['p08']) / 100;

		$v107 = invoices_make_product_total($tb['p03'], $tb['p04'], $tb['p08'], $tb['p010'], $tb['p010a'], $tb['p041'], $tb['p616'], $tb['p09'], $tb['p042']);

		if($tb['p09'] == 1) {
			$ret = round($v107 / $_pososto_fpa, 2);
		} else {
			$ret = round($v107, 2);
		}
	} else {
		$ret = 0;
	}
	return $ret;
}
function peg_invoices_v_v107_vat($tb) {
	if(in_array(substr($tb['peg_mmnr01'], 0, 3), array('a57', 'a67'))) {
		$_pososto_fpa = (100 + $tb['v105']) / 100;
		$order_p07    = pegasusGetGlobalVar('peg_'.substr($tb['peg_mmnr01'], 0, 3).'_d-' . $tb['peg_mnr01'] . '_p07');

		$v107 = invoices_make_product_total($tb['v103'], $tb['v104'], $tb['v105'], $tb['v106'], $tb['v106a'], $tb['v1041'], $tb['v616'], $order_p07, $tb['v1042']);

		if($order_p07 == 1) {
			$ret = round($v107, 2);
		} else {
			$ret = round($v107 * $_pososto_fpa, 2);
		}
	} else if(in_array(substr($tb['peg_mmnr01'], 0, 3), array('a55', 'a56', 'a60'))) {
		$_pososto_fpa = (100 + $tb['p08']) / 100;

		$v107 = invoices_make_product_total($tb['p03'], $tb['p04'], $tb['p08'], $tb['p010'], $tb['p010a'], $tb['p041'], $tb['p616'], $tb['p09'], $tb['p042']);

		if($tb['p09'] == 1) {
			$ret = round($v107, 2);
		} else {
			$ret = round($v107 * $_pososto_fpa, 2);
		}
	} else {
		$ret = 0;
	}
	return $ret;
}
function invoices_a58_calculate_v_fields($a58 = array()) {
	$return_array = array();
	$a57_p07 = pegasusGetGlobalVar('peg_a57_d-' . $a58['p00'] . '_p07');
	$_pososto_fpa = (100 + $a58['v105']) / 100;

	$v107 = invoices_make_product_total($a58['v103'], $a58['v104'], $a58['v105'], $a58['v106'], $a58['v106a'], $a58['v1041'], $a58['v616'], $a57_p07, $a58['v1042']);

	if($a57_p07 == 0) {
		$_timh_monadas_no_fpa    = $a58['v104'];
		$_timh_monadas_with_fpa  = $a58['v104'] * $_pososto_fpa;
		$return_array['v_v107_novat'] = round($v107, 2);
		$return_array['v_v107_vat']   = round($v107 * $_pososto_fpa, 2);
	} else {
		$_timh_monadas_no_fpa    = $a58['v104'] / $_pososto_fpa;
		$_timh_monadas_with_fpa  = $a58['v104'];
		$return_array['v_v107_novat'] = round($v107 / $_pososto_fpa, 2);
		$return_array['v_v107_vat']   = round($v107, 2);
	}

	$return_array['v_v104_novat'] = round($_timh_monadas_no_fpa, $_SESSION['inventory_000_p07']);
	$return_array['v_v104_vat']   = round($_timh_monadas_with_fpa, $_SESSION['inventory_000_p07']);

	return $return_array;
}

//Καλείται π.χ. στο browse_value του πεδίου v_i18_en
function peg_invoices_v_i18_en($tb)
{
	if (!pegasus_module_exists('invsets')) {
		return 0;
	}
	if ($tb['i18i01'] > 0 || $tb['i18a58'] > 0 || $tb['i18a68'] > 0 || $tb['i18a62'] > 0) {
		return 1;
	}
	if (substr($tb['peg_mmnr01'], 0, 3) == 'a55' || substr($tb['peg_mmnr01'], 0, 3) == 'a56') {

		$Q = '
			SELECT count(*) as tot from
			peg_tmp_i01 where
				peg_flag!=9 and
				peg_tmp_i01.p06=:v_p06 and
				peg_tmp_i01.p07=:v_p07 and
				peg_tmp_i01.peg_sess_id=:v_peg_sess_id and
				peg_tmp_i01.peg_mmnr01=:v_peg_mmnr01 and
				peg_tmp_i01.peg_mnr01=:v_peg_mnr01  and
				peg_tmp_i01.i18i01=:v_i18i01 ';
		$Q_arr = array(
			'v_p06' 		=>	$tb['p06'],
			'v_p07'			=>	$tb['p07'],
			'v_peg_sess_id'	=>	session_id(),
			'v_peg_mmnr01'	=>	$tb['peg_mmnr01'],
			'v_peg_mnr01'	=>	$tb['peg_mnr01'],
			'v_i18i01'		=>	$tb['nr01']
		);
		pegasus_mysql_use($Q, $res, $Q_arr);
		//die(pegasus_replace_values_in_sql($Q,$Q_arr));
	} else if (substr($tb['peg_mmnr01'], 0, 3) == 'a57') {
		$Q = '
			SELECT count(*) as tot from
			peg_tmp_a58 where
				peg_flag!=9 and
				peg_tmp_a58.p00=:v_p00 and
				peg_tmp_a58.peg_sess_id=:v_peg_sess_id and
				peg_tmp_a58.peg_mmnr01=:v_peg_mmnr01 and
				peg_tmp_a58.peg_mnr01=:v_peg_mnr01  and
				peg_tmp_a58.i18a58=:v_i18a58 ';
		$Q_arr = array(
			'v_p00' 		=>	$tb['p00'],
			'v_peg_sess_id'	=>	session_id(),
			'v_peg_mmnr01'	=>	$tb['peg_mmnr01'],
			'v_peg_mnr01'	=>	$tb['peg_mnr01'],
			'v_i18a58'		=>	$tb['nr01']
		);
		//die(pegasus_replace_values_in_sql($Q,$Q_arr));
		pegasus_mysql_use($Q, $res, $Q_arr);
	} else if (substr($tb['peg_mmnr01'], 0, 3) == 'a67') {
		$Q = '
			SELECT count(*) as tot from
			peg_tmp_a68 where
				peg_flag!=9 and
				peg_tmp_a68.p00=:v_p00 and
				peg_tmp_a68.peg_sess_id=:v_peg_sess_id and
				peg_tmp_a68.peg_mmnr01=:v_peg_mmnr01 and
				peg_tmp_a68.peg_mnr01=:v_peg_mnr01  and
				peg_tmp_a68.i18a68=:v_i18a68 ';
		$Q_arr = array(
			'v_p00' 		=>	$tb['p00'],
			'v_peg_sess_id'	=>	session_id(),
			'v_peg_mmnr01'	=>	$tb['peg_mmnr01'],
			'v_peg_mnr01'	=>	$tb['peg_mnr01'],
			'v_i18a68'		=>	$tb['nr01']
		);
		//	die(pegasus_replace_values_in_sql($Q,$Q_arr));
		pegasus_mysql_use($Q, $res, $Q_arr);
	} else if (substr($tb['peg_mmnr01'], 0, 3) == 'a61') {
		$Q = '
			SELECT count(*) as tot from
			peg_tmp_a62 where
				peg_flag!=9 and
				peg_tmp_a62.p00=:v_p00 and
				peg_tmp_a62.peg_sess_id=:v_peg_sess_id and
				peg_tmp_a62.peg_mmnr01=:v_peg_mmnr01 and
				peg_tmp_a62.peg_mnr01=:v_peg_mnr01  and
				peg_tmp_a62.i18a62=:v_i18a62 ';
		$Q_arr = array(
			'v_p00' 		=>	$tb['p00'],
			'v_peg_sess_id'	=>	session_id(),
			'v_peg_mmnr01'	=>	$tb['peg_mmnr01'],
			'v_peg_mnr01'	=>	$tb['peg_mnr01'],
			'v_i18a62'		=>	$tb['nr01']
		);
		// die(pegasus_replace_values_in_sql($Q,$Q_arr));
		pegasus_mysql_use($Q, $res, $Q_arr);
	}

	if ($res['tot'] > 0) {
		return 1;
	};
	return 0;
}

//Καλείται π.χ. στο browse_value του πεδίου v_ths_readonly
function peg_invoices_v_ths_readonly($pno)
{
	//Δεν καταλαβαίνω γιατί δεν έχουμε και το p101(Τεμάχια) στον έλεγχο. Έτσι, το θέλουμε;
	pegasus_mysql_use(
		"SELECT !(p101=0 AND p102=0 AND p103=0 AND p104=0 AND p106=0 AND p107=0 AND p108=0 AND p109=0 AND p110=0) AS rdonly
				FROM i24
				LEFT JOIN i00 AS i00_in ON i00_in.ths=i24.p01
				WHERE i00_in.pno=?",
		$res,
		array($pno)
	);
	return $res['rdonly'];
}

//Ελεγχος αν το Είδος παρακολουθεί Δευτερεύουσα Μονάδα Μέτρησης
function peg_invoices_v_p200_en($pno, $relation=true){

	$tmp_fld = ($relation) ? "(i00.p200!='' and i00.p201>0)" : "(i00.p200!='')";

	$query = "select (
				".$tmp_fld." and 
				p101=0 and p102=0 and p103=0 and p104=0 and p106=0 and p107=0 and p108=0 and p109=0 and p110=0
			) as active
			from i24
			left join i00 on i00.ths=i24.p01
			where i00.pno=?";

	pegasus_mysql_use($query, $res, array($pno));
	return $res['active'];
}

function invoices_after_update()
{
	// Moved to account00_01
	if(file_exists('../../pegasus_cloud_app/invoices01/account00_add_payment.php')) {
		unlink('../../pegasus_cloud_app/invoices01/account00_add_payment.php');
	}

	// ελεγχω ποσες εγγραφες εχει ο πινακας a97
    $oldEntries = pegasus_mysql_printfld('a97' , 'count(*)' , 'nr01>0');
    $newEntries = 9;

    // σε περιπτωση που εχει 0 εγγραφες ο πίνακας a97 τοτε κανουμε 9 εγγραφες!
    if($oldEntries==0){
        $newEntry = 1;
        while($newEntry <= $newEntries){

            $a97Array['nr01']  = $newEntry; // Μ.Κ.

            pegasus_mysql_use('select * from p82 where p00= :p00; ', $p82, array('p00' => 'invoices_lexical_'.$newEntry));
            $tit  = $p82['p01'];

            $a97Array['p01']   = $tit; // Όνομα Πεδίου
            $a97Array['p02']   = $tit; // Τίτλος

            pegasus_mysql_insert("a97", array_keys($a97Array),  array_values($a97Array));

            $newEntry++; // εγινε εγγραφη
        }
    }
	invoices_user_defined_fields();
	invoices_vehicle_defined_fields();
	pegasus_mysql_use('select rel, ver from p55 where p00="invoices"', $version);

	if ($version['ver'] == 2 && $version['rel'] <= 151) {
		pegasus_query("update a10 set ep02 = p02_1, remdate = curdate(), remtime = curtime(), remuser='upd_inv_152' where p02_1 <> ''");
	}
	if ($version['ver'] == 2 && $version['rel'] <= 164) {
		pegasus_mysql_update(
			'erpa13',
			array('p101'),
			array(1),
			" p01 in (
				select
				a10.p104
				from a10
				group by p104)"
		);
		pegasus_mysql_update(
			'erpa13',
			array('p101'),
			array(1),
			" p01 in (
				select
				a11.p104
				from a11
				group by p104)"
		);
	}
	if ($version['ver'] == 2 && $version['rel'] <= 204) {
		$tt = pegasus_mysql_printfld('f02', 'p011', 'nr01=1');
		if (empty($tt)) {
			pegasus_mysql_update('f02', array('p011'), array('1016'), 'nr01=1');
		}
		$tt = pegasus_mysql_printfld('f02', 'p014', 'nr01=1');
		if (empty($tt)) {
			pegasus_mysql_update('f02', array('p014'), array('2008'), 'nr01=1');
		}
	}

	invoices_after_update_a77();
	invoices_after_update_i70();
	invoices_after_update_erpa13();

	//	Εργασία 2000916 (v2.282)
	if($version['ver'] == 2 && $version['rel'] <= 310) {
		pegasus_mysql_update(
			'i70',
			array('tax'),
			array(100),
			'nr01 > 0 && tax = 0'
		);
	}

	//	Εργασία 2001354 (v2.341)
	if ($version['ver'] == 2 && $version['rel'] <= 341) {
		$query = "  UPDATE i70
            SET p05_1=concat('#', p05, '#'),
                remdate=curdate(),
                remtime=curtime(),
                remuser=:user_pswd
            WHERE   p05<>0 AND 
                    ifnull(p05_1, '')=''";

		$query2 = " UPDATE i70
					SET p05=0,
						remdate=curdate(),
						remtime=curtime(),
						remuser=:user_pswd
					where p05<>0";

		pegasus_query($query, array('user_pswd'=>$_SESSION['username']));
		pegasus_query($query2, array('user_pswd'=>$_SESSION['username']));
	}


	if ($version['ver'] == 2 && $version['rel'] <= 424) {
		// a10.p09
		pegasus_mysql_update(
			'a10',
			array('p09'),
			array(-1),
			"p09 = 0"
		);
		// a10.p010
		pegasus_mysql_update(
			'a10',
			array('p010'),
			array(-1),
			"p010 = 0"
		);
		// a10.p109
		pegasus_mysql_update(
			'a10',
			array('p109'),
			array('****'),
			"p109 = ''"
		);
		// a11.p09
		pegasus_mysql_update(
			'a11',
			array('p09'),
			array(-1),
			"p09 = 0"
		);
		// a11.p010
		pegasus_mysql_update(
			'a11',
			array('p010'),
			array(-1),
			"p010 = 0"
		);
		// a11.p109
		pegasus_mysql_update(
			'a11',
			array('p109'),
			array('****'),
			"p109 = ''"
		);
		// a11.p010
		pegasus_mysql_update(
			'a30',
			array('p010'),
			array(-1),
			"p010 = 0"
		);
	}
	
	if ($version['ver'] == 2 && $version['rel'] <= 437) {
		if(
			(strpos($_SERVER['HTTP_HOST'], "pegcloud.io") !== false) &&
			(pegasus_mysql_printfld('a10', 'p010', "p00='ΠΤ'") == 1) &&
			(!pegasus_module_exists('stores'))
		) {
			pegasus_mysql_update(
				'a10',
				array('p010'),
				array(0),
				"p00='ΠΤ'"
			);
		}
	}


	if ($version['ver'] == 2 && $version['rel'] <= 459) {
		pegasus_mysql_update(
			'f02',
			array('p637'),
			array(1),
			'nr01 = 1'
		);
	}

	if ($version['ver'] == 2 && $version['rel'] <= 526) {
		if((pegasus_mysql_printfld('f02', 'p637', 'nr01 = 1') == 1)){
			pegasus_mysql_update(
				'f02',
				array('p637o'),
				array(1),
				'nr01 = 1'
			);
		}
	}

	if($version['ver'] == 2 && $version['rel'] <= 721) {
		pegasus_mysql_remake_p75('a90');
	}

	if($version['ver'] == 2 && $version['rel'] <= 741) {
		pegasus_mysql_delete("p95p51", "module = 'invoices' AND p02 = 'i01_d10' AND desc05 = 'p061'");

		pegasus_delete_directory('../../tmp/invoices/');

		if(pegasus_module_exists('peg002') && function_exists('peg002_clean_dCache')) {
			peg002_clean_dCache('i01_d10');
		}
	}

	if($version['ver'] == 2 && $version['rel'] <= 775) {
		if(pegasus_module_exists('mydt')) {
			// Ορισμοί ΔΑ παραστατικών πελατών για νέες εγκαταστάσεις
			if(pegasus_module_exists('invcust')) {
				pegasus_mysql_use('SELECT count(*) as cnt FROM a55', $a55);
			
				if($a55['cnt'] == 0) {
					pegasus_mysql_delete('q31', 'p01 = 620014 AND p03 = "1003"', 1);
			
					$arr1 = array();            $arr2 = array();
					array_push($arr1, 'nr01');  array_push($arr2, pegasus_mysql_newrec('q31'));
					array_push($arr1, 'p01');   array_push($arr2, '620014');
					array_push($arr1, 'p03');   array_push($arr2, '1005');
					array_push($arr1, 'p05');   array_push($arr2, '9.3');
					pegasus_mysql_insert('q31', $arr1, $arr2);
			
					$arr1 = array();            $arr2 = array();
					array_push($arr1, 'nr01');  array_push($arr2, pegasus_mysql_newrec('q31'));
					array_push($arr1, 'p01');   array_push($arr2, '620068');
					array_push($arr1, 'p03');   array_push($arr2, '1003');
					array_push($arr1, 'p05');   array_push($arr2, '1.1');
					pegasus_mysql_insert('q31', $arr1, $arr2);
				}
			}
			invoices_update_invtype_p115();
		}
	}

	if($version['ver'] == 2 && $version['rel'] <= 838) {
		// Προσθήκη δικαιώματος στις ομάδες χρηστών πέραν του administrator
		if(pegasus_module_exists('invcust') || pegasus_module_exists('invsupp') || pegasus_module_exists('invtrans00')) {
			$query_p97 = "SELECT * FROM p97 WHERE nr01 != 140000000000000";

			$res = pegasus_query($query_p97);

			while($row = pegasus_fetch_assoc($res)) {
				$p97p96_nr01 = pegasus_mysql_printfld("p97p96", "nr01", "p97=:p97_nr01 and p96='invoices_check_balance'", array('p97_nr01' => $row['nr01']));

				if(!($p97p96_nr01 > 0)) {
					$p97p96_array = array();

					$p97p96_array['nr01'] = pegasus_mysql_newrec("p97p96");
					$p97p96_array['p96']  = "invoices_check_balance";
					$p97p96_array['p97']  = $row['nr01'];
					$p97p96_array['en']   = 1;

					pegasus_mysql_insert('p97p96', array_keys($p97p96_array), array_values($p97p96_array));
				}
			}
		}
	}

	if($version['ver'] == 2 && $version['rel'] <= 846) {
		// Για συμβατότητα με τις αλλαγές των σκοπών διακίνησης για την 1.0.11
		if(pegasus_mysql_table_exists('a10')){
			$arr1 = array(); $arr2 = array();
			array_push($arr1, 'p104'); array_push($arr2, 'Ενδοδιακίνηση');
			pegasus_mysql_update('a10', $arr1, $arr2, 'p104 = "Μεταξύ Εγκαταστάσεων Οντότητας"');

			$arr1 = array(); $arr2 = array();
			array_push($arr1, 'p104'); array_push($arr2, 'Επεξεργασία - Συν/ση - Αποσυν/ση');
			pegasus_mysql_update('a10', $arr1, $arr2, 'p104 = "Επεξεργασία Συναρμολόγηση"');
		}
		if(pegasus_mysql_table_exists('a11')){
			$arr1 = array(); $arr2 = array();
			array_push($arr1, 'p104'); array_push($arr2, 'Ενδοδιακίνηση');
			pegasus_mysql_update('a11', $arr1, $arr2, 'p104 = "Μεταξύ Εγκαταστάσεων Οντότητας"');

			$arr1 = array(); $arr2 = array();
			array_push($arr1, 'p104'); array_push($arr2, 'Επεξεργασία - Συν/ση - Αποσυν/ση');
			pegasus_mysql_update('a11', $arr1, $arr2, 'p104 = "Επεξεργασία Συναρμολόγηση"');
		}
		if(pegasus_mysql_table_exists('a30')){
			$arr1 = array(); $arr2 = array();
			array_push($arr1, 'p106'); array_push($arr2, 'Ενδοδιακίνηση');
			pegasus_mysql_update('a30', $arr1, $arr2, 'p106 = "Μεταξύ Εγκαταστάσεων Οντότητας"');

			$arr1 = array(); $arr2 = array();
			array_push($arr1, 'p106'); array_push($arr2, 'Επεξεργασία - Συν/ση - Αποσυν/ση');
			pegasus_mysql_update('a30', $arr1, $arr2, 'p106 = "Επεξεργασία Συναρμολόγηση"');			
		}
	}
}

function invoices_after_update_a77()
{
		// List of [nr01, p01] pairs
    $a77_data = array(
        array(1,  "Αρθρο 2 και 3"),
        array(2,  "Αρθρο 5"),
        array(3,  "Αρθρο 17 (πρώην 13)"),
        array(4,  "Αρθρο 18  (πρώην 14)"),
        array(5,  "Αρθρο 21  (πρώην 16)"),
        array(6,  "Αρθρο 24 (πρώην 19)"),
        array(7,  "Αρθρο 27 (πρώην 22)"),
        array(8,  "Αρθρο 29 (πρώην 24)"),
        array(9,  "Αρθρο 30 (πρώην 25)"),
        array(10, "Αρθρο 31 (πρώην 26)"),
        array(11, "Αρθρο 32 (πρώην 27)"),
        array(12, "Αρθρο 32 - Πλοία Ανοικτής Θαλάσσης  (πρώην 27)"),
        array(13, "Αρθρο 32 .1.γ. - Πλοία Ανοικτής Θαλάσσης  (πρώην 27.1.γ)"),
        array(14, "Αρθρο 33  (πρώην 28)"),
        array(15, "Αρθρο 44  (πρώην 39)"),
        array(16, "Αρθρο 45  (πρώην 39α)"),
        array(17, "Αρθρο 47  (πρώην 40)"),
        array(18, "Αρθρο 48  (πρώην 41)"),
        array(19, "Αρθρο 54  (πρώην 47)"),
        array(20, "ΦΠΑ εμπεριεχόμενος - Αρθρο 50  (πρώην 43)"),
        array(21, "ΦΠΑ εμπεριεχόμενος - Αρθρο 51  (πρώην 44)"),
        array(22, "ΦΠΑ εμπεριεχόμενος - Αρθρο 52  (πρώην 45)"),
        array(23, "ΦΠΑ εμπεριεχόμενος - Αρθρο 53  (πρώην 46)"),
        array(24, "Αρθρο 8  (πρώην 6)"),
        array(25, "ΠΟΛ.1029/1995"),
        array(26, "ΠΟΛ.1167/2015"),
        array(27, "Λοιπές Εξαιρέσεις ΦΠΑ"),
        array(28, "Αρθρο 29 περ. β' παρ.1, (Tax Free)   (πρώην 24)"),
        array(29, "Αρθρο 56 (OSS_μη ενωσιακό καθεστώς)  (πρώην 47β)"),
        array(30, "Αρθρο 57 (OSS_ενωσιακό καθεστώς)  (πρώην 47γ)"),
        array(31, "Αρθρο 58 (IOSS)  (πρώην 47δ)")
    );

    foreach ($a77_data as $row) {
        invoices_new_recs_for_a77_q31($row[0], $row[1]);
    }
}

function invoices_new_recs_for_a77_q31($mydt52_p00, $p01) {
	$a77_arr = array();
    $a77_arr['nr01'] = 10000000000+$mydt52_p00;
    $a77_arr['p01'] = $p01;
    $a77_arr['is_std'] = "1";

    $where = "nr01=:nr01";
    $where_params = array('nr01' => $a77_arr['nr01']);

    if (pegasus_mysql_printfld('a77', 'nr01', $where, $where_params) > 0) {
        pegasus_mysql_update('a77', array_keys($a77_arr), array_values($a77_arr), $where, 0, 1, 1, $where_params);
    } else {
        $a77_arr['p300'] = 1;
        pegasus_mysql_insert('a77', array_keys($a77_arr), array_values($a77_arr));
    }

	$q31_arr = array();
	$q31_arr['p05'] = $mydt52_p00;
	$q31_arr['p01'] = "620051";
	$q31_arr['p03'] = $a77_arr['nr01'];
	

	$q31_where = "p01=620051 AND p03 = :a77_nr01 AND p05 = :p05";
	$q31_where_params = array(
		"a77_nr01" => $a77_arr['nr01'], 
		"p05"      => $mydt52_p00
	);

	if (pegasus_mysql_printfld('q31', 'nr01', $q31_where, $q31_where_params) > 0) {
		pegasus_mysql_update('q31', array_keys($q31_arr), array_values($q31_arr), $q31_where, 0, 1, 1, $q31_where_params);
	} else {
		$q31_arr['nr01'] = pegasus_mysql_newrec("q31");
		pegasus_mysql_insert('q31', array_keys($q31_arr), array_values($q31_arr));
	}
}

function invoices_after_update_i70()
{
	/* i70 Update start
	  sql -->
			select
				concat(
				'$i70_arr=array(); \n',
				'$i70_arr[\'nr01\']="',i70.nr01,'"; \n',
				'$i70_arr[\'p01\']="',i70.p01,'"; \n',
				'$i70_arr[\'p02\']="',i70.p02,'"; \n',
				'$i70_arr[\'p03\']="',i70.p03,'"; \n',
				'$i70_arr[\'p04\']="',i70.p04,'"; \n',
				'$i70_arr[\'p05\']="',p05,'"; \n',
				'$i70_arr[\'p06\']="',p06,'"; \n',
				'$i70_arr[\'p07\']="',p07,'"; \n',
				'$i70_arr[\'p06_1\']="',p06_1,'"; \n',
				'$i70_arr[\'is_std\']="',is_std,'"; \n',
				'if(pegasus_mysql_printfld(\'i70\' , \'nr01\' , \'nr01=:nr01\' , array(\'nr01\' => $i70_arr[\'nr01\']))>0){\n',
				'	pegasus_mysql_update(\'i70\' ,array_keys($i70_arr),array_values($i70_arr), \'nr01=:nr01\',0,1,1, array(\'nr01\' => $i70_arr[\'nr01\']));\n',
				'}else{\n',
				'	$i70_arr[\'p300\']=1; \n',
				'	pegasus_mysql_insert(\'i70\' ,array_keys($i70_arr),array_values($i70_arr));\n',
				'}\n'
				),

				i70.* from i70 where is_std=1;
	 */

	$i70_arr = array();
	$i70_arr['nr01'] = "10000000001";
	$i70_arr['p01'] = "Τόκοι 15% (Περιπτ. β’)";
	$i70_arr['p02'] = "2";
	$i70_arr['p03'] = "1";
	$i70_arr['p04'] = "15.0000000";
	$i70_arr['p05'] = "0";
	$i70_arr['p06'] = "0.00";
	$i70_arr['p07'] = "1";
	$i70_arr['p06_1'] = "9999999999.99";
	$i70_arr['is_std'] = "1";
	if (pegasus_mysql_printfld('i70', 'nr01', 'nr01=:nr01', array('nr01' => $i70_arr['nr01'])) > 0) {
		pegasus_mysql_update('i70', array_keys($i70_arr), array_values($i70_arr), 'nr01=:nr01', 0, 1, 1, array('nr01' => $i70_arr['nr01']));
	} else {
		$i70_arr['p300'] = 1;
		pegasus_mysql_insert('i70', array_keys($i70_arr), array_values($i70_arr));
	}

	$i70_arr = array();
	$i70_arr['nr01'] = "10000000002";
	$i70_arr['p01'] = "Δικαιώματα 20% (Περιπτ. γ’)";
	$i70_arr['p02'] = "2";
	$i70_arr['p03'] = "1";
	$i70_arr['p04'] = "20.0000000";
	$i70_arr['p05'] = "0";
	$i70_arr['p06'] = "0.00";
	$i70_arr['p07'] = "1";
	$i70_arr['p06_1'] = "9999999999.99";
	$i70_arr['is_std'] = "1";
	if (pegasus_mysql_printfld('i70', 'nr01', 'nr01=:nr01', array('nr01' => $i70_arr['nr01'])) > 0) {
		pegasus_mysql_update('i70', array_keys($i70_arr), array_values($i70_arr), 'nr01=:nr01', 0, 1, 1, array('nr01' => $i70_arr['nr01']));
	} else {
		$i70_arr['p300'] = 1;
		pegasus_mysql_insert('i70', array_keys($i70_arr), array_values($i70_arr));
	}

	$i70_arr = array();
	$i70_arr['nr01'] = "10000000003";
	$i70_arr['p01'] = "Αμοιβές Συμβουλών Διοίκησης 20% (Περιπτ. δ’)";
	$i70_arr['p02'] = "2";
	$i70_arr['p03'] = "1";
	$i70_arr['p04'] = "20.0000000";
	$i70_arr['p05'] = "0";
	$i70_arr['p06'] = "0.00";
	$i70_arr['p07'] = "1";
	$i70_arr['p06_1'] = "9999999999.99";
	$i70_arr['is_std'] = "1";
	if (pegasus_mysql_printfld('i70', 'nr01', 'nr01=:nr01', array('nr01' => $i70_arr['nr01'])) > 0) {
		pegasus_mysql_update('i70', array_keys($i70_arr), array_values($i70_arr), 'nr01=:nr01', 0, 1, 1, array('nr01' => $i70_arr['nr01']));
	} else {
		$i70_arr['p300'] = 1;
		pegasus_mysql_insert('i70', array_keys($i70_arr), array_values($i70_arr));
	}

	$i70_arr = array();
	$i70_arr['nr01'] = "10000000004";
	$i70_arr['p01'] = "Τεχνικά Έργα 3% (Περιπτ. δ’)";
	$i70_arr['p02'] = "2";
	$i70_arr['p03'] = "1";
	$i70_arr['p04'] = "3.0000000";
	$i70_arr['p05'] = "0";
	$i70_arr['p06'] = "0.00";
	$i70_arr['p07'] = "1";
	$i70_arr['p06_1'] = "9999999999.99";
	$i70_arr['is_std'] = "1";
	if (pegasus_mysql_printfld('i70', 'nr01', 'nr01=:nr01', array('nr01' => $i70_arr['nr01'])) > 0) {
		pegasus_mysql_update('i70', array_keys($i70_arr), array_values($i70_arr), 'nr01=:nr01', 0, 1, 1, array('nr01' => $i70_arr['nr01']));
	} else {
		$i70_arr['p300'] = 1;
		pegasus_mysql_insert('i70', array_keys($i70_arr), array_values($i70_arr));
	}

	$i70_arr = array();
	$i70_arr['nr01'] = "10000000005";
	$i70_arr['p01'] = "Υγρά καύσιμα και προϊόντα καπνοβιομηχανίας 1%";
	$i70_arr['p02'] = "2";
	$i70_arr['p03'] = "1";
	$i70_arr['p04'] = "1.0000000";
	$i70_arr['p05'] = "0";
	$i70_arr['p06'] = "0.00";
	$i70_arr['p07'] = "1";
	$i70_arr['p06_1'] = "9999999999.99";
	$i70_arr['is_std'] = "1";
	if (pegasus_mysql_printfld('i70', 'nr01', 'nr01=:nr01', array('nr01' => $i70_arr['nr01'])) > 0) {
		pegasus_mysql_update('i70', array_keys($i70_arr), array_values($i70_arr), 'nr01=:nr01', 0, 1, 1, array('nr01' => $i70_arr['nr01']));
	} else {
		$i70_arr['p300'] = 1;
		pegasus_mysql_insert('i70', array_keys($i70_arr), array_values($i70_arr));
	}

	$i70_arr = array();
	$i70_arr['nr01'] = "10000000006";
	$i70_arr['p01'] = "Λοιπά Αγαθά 4%";
	$i70_arr['p02'] = "2";
	$i70_arr['p03'] = "1";
	$i70_arr['p04'] = "4.0000000";
	$i70_arr['p05'] = "0";
	$i70_arr['p06'] = "0.00";
	$i70_arr['p07'] = "1";
	$i70_arr['p06_1'] = "9999999999.99";
	$i70_arr['is_std'] = "1";
	if (pegasus_mysql_printfld('i70', 'nr01', 'nr01=:nr01', array('nr01' => $i70_arr['nr01'])) > 0) {
		pegasus_mysql_update('i70', array_keys($i70_arr), array_values($i70_arr), 'nr01=:nr01', 0, 1, 1, array('nr01' => $i70_arr['nr01']));
	} else {
		$i70_arr['p300'] = 1;
		pegasus_mysql_insert('i70', array_keys($i70_arr), array_values($i70_arr));
	}

	$i70_arr = array();
	$i70_arr['nr01'] = "10000000007";
	$i70_arr['p01'] = "Παροχή Υπηρεσιών 8%";
	$i70_arr['p02'] = "2";
	$i70_arr['p03'] = "1";
	$i70_arr['p04'] = "8.0000000";
	$i70_arr['p05'] = "0";
	$i70_arr['p06'] = "0.00";
	$i70_arr['p07'] = "1";
	$i70_arr['p06_1'] = "9999999999.99";
	$i70_arr['is_std'] = "1";
	if (pegasus_mysql_printfld('i70', 'nr01', 'nr01=:nr01', array('nr01' => $i70_arr['nr01'])) > 0) {
		pegasus_mysql_update('i70', array_keys($i70_arr), array_values($i70_arr), 'nr01=:nr01', 0, 1, 1, array('nr01' => $i70_arr['nr01']));
	} else {
		$i70_arr['p300'] = 1;
		pegasus_mysql_insert('i70', array_keys($i70_arr), array_values($i70_arr));
	}

	$i70_arr = array();
	$i70_arr['nr01'] = "10000000008";
	$i70_arr['p01'] = "Προκ. Φόρου 4% Αρχιτ/νων & Μηχ/κών & Συμβατικών Αμοιβών, για Εκπόνηση Μελετών & Σχεδίων";
	$i70_arr['p02'] = "2";
	$i70_arr['p03'] = "1";
	$i70_arr['p04'] = "4.0000000";
	$i70_arr['p05'] = "0";
	$i70_arr['p06'] = "0.00";
	$i70_arr['p07'] = "1";
	$i70_arr['p06_1'] = "9999999999.99";
	$i70_arr['is_std'] = "1";
	if (pegasus_mysql_printfld('i70', 'nr01', 'nr01=:nr01', array('nr01' => $i70_arr['nr01'])) > 0) {
		pegasus_mysql_update('i70', array_keys($i70_arr), array_values($i70_arr), 'nr01=:nr01', 0, 1, 1, array('nr01' => $i70_arr['nr01']));
	} else {
		$i70_arr['p300'] = 1;
		pegasus_mysql_insert('i70', array_keys($i70_arr), array_values($i70_arr));
	}

	$i70_arr = array();
	$i70_arr['nr01'] = "10000000009";
	$i70_arr['p01'] = "Προκ. Φόρου 10% Αρχιτ/νων & Μηχ/κών & Συμβατικών Αμοιβών, αφορούν άλλης φύσης έργα";
	$i70_arr['p02'] = "2";
	$i70_arr['p03'] = "1";
	$i70_arr['p04'] = "10.0000000";
	$i70_arr['p05'] = "0";
	$i70_arr['p06'] = "0.00";
	$i70_arr['p07'] = "1";
	$i70_arr['p06_1'] = "9999999999.99";
	$i70_arr['is_std'] = "1";
	if (pegasus_mysql_printfld('i70', 'nr01', 'nr01=:nr01', array('nr01' => $i70_arr['nr01'])) > 0) {
		pegasus_mysql_update('i70', array_keys($i70_arr), array_values($i70_arr), 'nr01=:nr01', 0, 1, 1, array('nr01' => $i70_arr['nr01']));
	} else {
		$i70_arr['p300'] = 1;
		pegasus_mysql_insert('i70', array_keys($i70_arr), array_values($i70_arr));
	}

	$i70_arr = array();
	$i70_arr['nr01'] = "10000000010";
	$i70_arr['p01'] = "Προκ. Φόρου 15% στις Αμοιβές Δικηγόρων";
	$i70_arr['p02'] = "2";
	$i70_arr['p03'] = "1";
	$i70_arr['p04'] = "15.0000000";
	$i70_arr['p05'] = "0";
	$i70_arr['p06'] = "0.00";
	$i70_arr['p07'] = "1";
	$i70_arr['p06_1'] = "9999999999.99";
	$i70_arr['is_std'] = "1";
	if (pegasus_mysql_printfld('i70', 'nr01', 'nr01=:nr01', array('nr01' => $i70_arr['nr01'])) > 0) {
		pegasus_mysql_update('i70', array_keys($i70_arr), array_values($i70_arr), 'nr01=:nr01', 0, 1, 1, array('nr01' => $i70_arr['nr01']));
	} else {
		$i70_arr['p300'] = 1;
		pegasus_mysql_insert('i70', array_keys($i70_arr), array_values($i70_arr));
	}

	$i70_arr = array();
	$i70_arr['nr01'] = "10000000011";
	$i70_arr['p01'] = "Παρακράτηση Φ.Μ.Υ. Αξιωματικών Εμπορικού Ναυτικού (παρ. 2 αρ. 15 ν. 4172/2013)";
	$i70_arr['p02'] = "2";
	$i70_arr['p03'] = "1";
	$i70_arr['p04'] = "0.0000000";
	$i70_arr['p05'] = "0";
	$i70_arr['p06'] = "0.00";
	$i70_arr['p07'] = "1";
	$i70_arr['p06_1'] = "9999999999.99";
	$i70_arr['is_std'] = "1";
	if (pegasus_mysql_printfld('i70', 'nr01', 'nr01=:nr01', array('nr01' => $i70_arr['nr01'])) > 0) {
		pegasus_mysql_update('i70', array_keys($i70_arr), array_values($i70_arr), 'nr01=:nr01', 0, 1, 1, array('nr01' => $i70_arr['nr01']));
	} else {
		$i70_arr['p300'] = 1;
		pegasus_mysql_insert('i70', array_keys($i70_arr), array_values($i70_arr));
	}

	$i70_arr = array();
	$i70_arr['nr01'] = "10000000012";
	$i70_arr['p01'] = "Παρακράτηση Φ.Μ.Υ. Κατώτερο Πλήρωμα Εμπορικού Ναυτικού (παρ.2 αρ.15 ν. 4172/2013)";
	$i70_arr['p02'] = "2";
	$i70_arr['p03'] = "1";
	$i70_arr['p04'] = "0.0000000";
	$i70_arr['p05'] = "0";
	$i70_arr['p06'] = "0.00";
	$i70_arr['p07'] = "1";
	$i70_arr['p06_1'] = "9999999999.99";
	$i70_arr['is_std'] = "1";
	if (pegasus_mysql_printfld('i70', 'nr01', 'nr01=:nr01', array('nr01' => $i70_arr['nr01'])) > 0) {
		pegasus_mysql_update('i70', array_keys($i70_arr), array_values($i70_arr), 'nr01=:nr01', 0, 1, 1, array('nr01' => $i70_arr['nr01']));
	} else {
		$i70_arr['p300'] = 1;
		pegasus_mysql_insert('i70', array_keys($i70_arr), array_values($i70_arr));
	}

	$i70_arr = array();
	$i70_arr['nr01'] = "10000000013";
	$i70_arr['p01'] = "Παρακράτηση Φόρου Μισθωτών Υπηρεσιών  παρ. 1 αρ. 15 ν. 4172/2013";
	$i70_arr['p02'] = "2";
	$i70_arr['p03'] = "2";
	$i70_arr['p04'] = "0.0000000";
	$i70_arr['p05'] = "0";
	$i70_arr['p06'] = "0.00";
	$i70_arr['p07'] = "1";
	$i70_arr['p06_1'] = "9999999999.99";
	$i70_arr['is_std'] = "1";
	if (pegasus_mysql_printfld('i70', 'nr01', 'nr01=:nr01', array('nr01' => $i70_arr['nr01'])) > 0) {
		pegasus_mysql_update('i70', array_keys($i70_arr), array_values($i70_arr), 'nr01=:nr01', 0, 1, 1, array('nr01' => $i70_arr['nr01']));
	} else {
		$i70_arr['p300'] = 1;
		pegasus_mysql_insert('i70', array_keys($i70_arr), array_values($i70_arr));
	}

	$i70_arr = array();
	$i70_arr['nr01'] = "10000000014";
	$i70_arr['p01'] = "Παρακράτηση Ειδικής Εισφοράς Αλληλεγγύης";
	$i70_arr['p02'] = "2";
	$i70_arr['p03'] = "2";
	$i70_arr['p04'] = "0.0000000";
	$i70_arr['p05'] = "0";
	$i70_arr['p06'] = "0.00";
	$i70_arr['p07'] = "1";
	$i70_arr['p06_1'] = "9999999999.99";
	$i70_arr['is_std'] = "1";
	if (pegasus_mysql_printfld('i70', 'nr01', 'nr01=:nr01', array('nr01' => $i70_arr['nr01'])) > 0) {
		pegasus_mysql_update('i70', array_keys($i70_arr), array_values($i70_arr), 'nr01=:nr01', 0, 1, 1, array('nr01' => $i70_arr['nr01']));
	} else {
		$i70_arr['p300'] = 1;
		pegasus_mysql_insert('i70', array_keys($i70_arr), array_values($i70_arr));
	}

	$i70_arr = array();
	$i70_arr['nr01'] = "10000000015";
	$i70_arr['p01'] = "Παρακράτηση Φόρου Αποζημίωσης λόγω Διακοπής Σχέσης Εργασίας  παρ. 3 αρ. 15 ν. 4172/2013";
	$i70_arr['p02'] = "2";
	$i70_arr['p03'] = "2";
	$i70_arr['p04'] = "0.0000000";
	$i70_arr['p05'] = "0";
	$i70_arr['p06'] = "0.00";
	$i70_arr['p07'] = "1";
	$i70_arr['p06_1'] = "9999999999.99";
	$i70_arr['is_std'] = "1";
	if (pegasus_mysql_printfld('i70', 'nr01', 'nr01=:nr01', array('nr01' => $i70_arr['nr01'])) > 0) {
		pegasus_mysql_update('i70', array_keys($i70_arr), array_values($i70_arr), 'nr01=:nr01', 0, 1, 1, array('nr01' => $i70_arr['nr01']));
	} else {
		$i70_arr['p300'] = 1;
		pegasus_mysql_insert('i70', array_keys($i70_arr), array_values($i70_arr));
	}

	$i70_arr = array();
	$i70_arr['nr01'] = "10000000016";
	$i70_arr['p01'] = "Χαρτόσημο 1,2%";
	$i70_arr['p02'] = "1";
	$i70_arr['p03'] = "1";
	$i70_arr['p04'] = "1.2000000";
	$i70_arr['p05'] = "0";
	$i70_arr['p06'] = "0.00";
	$i70_arr['p07'] = "1";
	$i70_arr['p06_1'] = "9999999999.99";
	$i70_arr['is_std'] = "1";
	if (pegasus_mysql_printfld('i70', 'nr01', 'nr01=:nr01', array('nr01' => $i70_arr['nr01'])) > 0) {
		pegasus_mysql_update('i70', array_keys($i70_arr), array_values($i70_arr), 'nr01=:nr01', 0, 1, 1, array('nr01' => $i70_arr['nr01']));
	} else {
		$i70_arr['p300'] = 1;
		pegasus_mysql_insert('i70', array_keys($i70_arr), array_values($i70_arr));
	}

	$i70_arr = array();
	$i70_arr['nr01'] = "10000000017";
	$i70_arr['p01'] = "Χαρτόσημο 2,4%";
	$i70_arr['p02'] = "1";
	$i70_arr['p03'] = "1";
	$i70_arr['p04'] = "2.4000000";
	$i70_arr['p05'] = "0";
	$i70_arr['p06'] = "0.00";
	$i70_arr['p07'] = "1";
	$i70_arr['p06_1'] = "9999999999.99";
	$i70_arr['is_std'] = "1";
	if (pegasus_mysql_printfld('i70', 'nr01', 'nr01=:nr01', array('nr01' => $i70_arr['nr01'])) > 0) {
		pegasus_mysql_update('i70', array_keys($i70_arr), array_values($i70_arr), 'nr01=:nr01', 0, 1, 1, array('nr01' => $i70_arr['nr01']));
	} else {
		$i70_arr['p300'] = 1;
		pegasus_mysql_insert('i70', array_keys($i70_arr), array_values($i70_arr));
	}

	$i70_arr = array();
	$i70_arr['nr01'] = "10000000018";
	$i70_arr['p01'] = "Χαρτόσημο 3,6%";
	$i70_arr['p02'] = "1";
	$i70_arr['p03'] = "1";
	$i70_arr['p04'] = "3.6000000";
	$i70_arr['p05'] = "0";
	$i70_arr['p06'] = "0.00";
	$i70_arr['p07'] = "1";
	$i70_arr['p06_1'] = "9999999999.99";
	$i70_arr['is_std'] = "1";
	if (pegasus_mysql_printfld('i70', 'nr01', 'nr01=:nr01', array('nr01' => $i70_arr['nr01'])) > 0) {
		pegasus_mysql_update('i70', array_keys($i70_arr), array_values($i70_arr), 'nr01=:nr01', 0, 1, 1, array('nr01' => $i70_arr['nr01']));
	} else {
		$i70_arr['p300'] = 1;
		pegasus_mysql_insert('i70', array_keys($i70_arr), array_values($i70_arr));
	}

	$i70_arr = array();
	$i70_arr['nr01'] = "10000000019";
	$i70_arr['p01'] = "Για μηνιαίο λογαριασμό μέχρι και 50 ευρώ  12%";
	$i70_arr['p02'] = "1";
	$i70_arr['p03'] = "1";
	$i70_arr['p04'] = "12.0000000";
	$i70_arr['p05'] = "0";
	$i70_arr['p06'] = "0.00";
	$i70_arr['p07'] = "1";
	$i70_arr['p06_1'] = "9999999999.99";
	$i70_arr['is_std'] = "1";
	if (pegasus_mysql_printfld('i70', 'nr01', 'nr01=:nr01', array('nr01' => $i70_arr['nr01'])) > 0) {
		pegasus_mysql_update('i70', array_keys($i70_arr), array_values($i70_arr), 'nr01=:nr01', 0, 1, 1, array('nr01' => $i70_arr['nr01']));
	} else {
		$i70_arr['p300'] = 1;
		pegasus_mysql_insert('i70', array_keys($i70_arr), array_values($i70_arr));
	}

	$i70_arr = array();
	$i70_arr['nr01'] = "10000000020";
	$i70_arr['p01'] = "Για μηνιαίο λογαριασμό από 50,01 μέχρι και 100 ευρώ 15%";
	$i70_arr['p02'] = "1";
	$i70_arr['p03'] = "1";
	$i70_arr['p04'] = "15.0000000";
	$i70_arr['p05'] = "0";
	$i70_arr['p06'] = "0.00";
	$i70_arr['p07'] = "1";
	$i70_arr['p06_1'] = "9999999999.99";
	$i70_arr['is_std'] = "1";
	if (pegasus_mysql_printfld('i70', 'nr01', 'nr01=:nr01', array('nr01' => $i70_arr['nr01'])) > 0) {
		pegasus_mysql_update('i70', array_keys($i70_arr), array_values($i70_arr), 'nr01=:nr01', 0, 1, 1, array('nr01' => $i70_arr['nr01']));
	} else {
		$i70_arr['p300'] = 1;
		pegasus_mysql_insert('i70', array_keys($i70_arr), array_values($i70_arr));
	}

	$i70_arr = array();
	$i70_arr['nr01'] = "10000000021";
	$i70_arr['p01'] = "Για μηνιαίο λογαριασμό από 100,01 μέχρι και 150 ευρώ 18%";
	$i70_arr['p02'] = "1";
	$i70_arr['p03'] = "1";
	$i70_arr['p04'] = "18.0000000";
	$i70_arr['p05'] = "0";
	$i70_arr['p06'] = "0.00";
	$i70_arr['p07'] = "1";
	$i70_arr['p06_1'] = "9999999999.99";
	$i70_arr['is_std'] = "1";
	if (pegasus_mysql_printfld('i70', 'nr01', 'nr01=:nr01', array('nr01' => $i70_arr['nr01'])) > 0) {
		pegasus_mysql_update('i70', array_keys($i70_arr), array_values($i70_arr), 'nr01=:nr01', 0, 1, 1, array('nr01' => $i70_arr['nr01']));
	} else {
		$i70_arr['p300'] = 1;
		pegasus_mysql_insert('i70', array_keys($i70_arr), array_values($i70_arr));
	}

	$i70_arr = array();
	$i70_arr['nr01'] = "10000000022";
	$i70_arr['p01'] = "Για μηνιαίο λογαριασμό από 150,01 ευρώ και άνω 20%";
	$i70_arr['p02'] = "1";
	$i70_arr['p03'] = "1";
	$i70_arr['p04'] = "20.0000000";
	$i70_arr['p05'] = "0";
	$i70_arr['p06'] = "0.00";
	$i70_arr['p07'] = "1";
	$i70_arr['p06_1'] = "9999999999.99";
	$i70_arr['is_std'] = "1";
	if (pegasus_mysql_printfld('i70', 'nr01', 'nr01=:nr01', array('nr01' => $i70_arr['nr01'])) > 0) {
		pegasus_mysql_update('i70', array_keys($i70_arr), array_values($i70_arr), 'nr01=:nr01', 0, 1, 1, array('nr01' => $i70_arr['nr01']));
	} else {
		$i70_arr['p300'] = 1;
		pegasus_mysql_insert('i70', array_keys($i70_arr), array_values($i70_arr));
	}

	$i70_arr = array();
	$i70_arr['nr01'] = "10000000023";
	$i70_arr['p01'] = "Τέλος καρτοκινητής επί της αξίας του χρόνου ομιλίας (12%)";
	$i70_arr['p02'] = "1";
	$i70_arr['p03'] = "1";
	$i70_arr['p04'] = "12.0000000";
	$i70_arr['p05'] = "0";
	$i70_arr['p06'] = "0.00";
	$i70_arr['p07'] = "1";
	$i70_arr['p06_1'] = "9999999999.99";
	$i70_arr['is_std'] = "1";
	if (pegasus_mysql_printfld('i70', 'nr01', 'nr01=:nr01', array('nr01' => $i70_arr['nr01'])) > 0) {
		pegasus_mysql_update('i70', array_keys($i70_arr), array_values($i70_arr), 'nr01=:nr01', 0, 1, 1, array('nr01' => $i70_arr['nr01']));
	} else {
		$i70_arr['p300'] = 1;
		pegasus_mysql_insert('i70', array_keys($i70_arr), array_values($i70_arr));
	}

	$i70_arr = array();
	$i70_arr['nr01'] = "10000000024";
	$i70_arr['p01'] = "Τέλος στη συνδρομητική τηλεόραση 10%";
	$i70_arr['p02'] = "1";
	$i70_arr['p03'] = "1";
	$i70_arr['p04'] = "10.0000000";
	$i70_arr['p05'] = "0";
	$i70_arr['p06'] = "0.00";
	$i70_arr['p07'] = "1";
	$i70_arr['p06_1'] = "9999999999.99";
	$i70_arr['is_std'] = "1";
	if (pegasus_mysql_printfld('i70', 'nr01', 'nr01=:nr01', array('nr01' => $i70_arr['nr01'])) > 0) {
		pegasus_mysql_update('i70', array_keys($i70_arr), array_values($i70_arr), 'nr01=:nr01', 0, 1, 1, array('nr01' => $i70_arr['nr01']));
	} else {
		$i70_arr['p300'] = 1;
		pegasus_mysql_insert('i70', array_keys($i70_arr), array_values($i70_arr));
	}

	$i70_arr = array();
	$i70_arr['nr01'] = "10000000025";
	$i70_arr['p01'] = "Τέλος συνδρομητών σταθερής τηλεφωνίας 5%";
	$i70_arr['p02'] = "1";
	$i70_arr['p03'] = "1";
	$i70_arr['p04'] = "5.0000000";
	$i70_arr['p05'] = "0";
	$i70_arr['p06'] = "0.00";
	$i70_arr['p07'] = "1";
	$i70_arr['p06_1'] = "9999999999.99";
	$i70_arr['is_std'] = "1";
	if (pegasus_mysql_printfld('i70', 'nr01', 'nr01=:nr01', array('nr01' => $i70_arr['nr01'])) > 0) {
		pegasus_mysql_update('i70', array_keys($i70_arr), array_values($i70_arr), 'nr01=:nr01', 0, 1, 1, array('nr01' => $i70_arr['nr01']));
	} else {
		$i70_arr['p300'] = 1;
		pegasus_mysql_insert('i70', array_keys($i70_arr), array_values($i70_arr));
	}

	$i70_arr = array();
	$i70_arr['nr01'] = "10000000026";
	$i70_arr['p01'] = "Περιβαλλοντικό Τέλος & πλαστικής σακούλας";
	$i70_arr['p02'] = "1";
	$i70_arr['p03'] = "2";
	$i70_arr['p04'] = "0.0000000";
	$i70_arr['p05'] = "0";
	$i70_arr['p06'] = "0.00";
	$i70_arr['p07'] = "1";
	$i70_arr['p06_1'] = "9999999999.99";
	$i70_arr['is_std'] = "1";
	if (pegasus_mysql_printfld('i70', 'nr01', 'nr01=:nr01', array('nr01' => $i70_arr['nr01'])) > 0) {
		pegasus_mysql_update('i70', array_keys($i70_arr), array_values($i70_arr), 'nr01=:nr01', 0, 1, 1, array('nr01' => $i70_arr['nr01']));
	} else {
		$i70_arr['p300'] = 1;
		pegasus_mysql_insert('i70', array_keys($i70_arr), array_values($i70_arr));
	}

	$i70_arr = array();
	$i70_arr['nr01'] = "10000000027";
	$i70_arr['p01'] = "Εισφορά δακοκτονίας 2%";
	$i70_arr['p02'] = "1";
	$i70_arr['p03'] = "1";
	$i70_arr['p04'] = "2.0000000";
	$i70_arr['p05'] = "0";
	$i70_arr['p06'] = "0.00";
	$i70_arr['p07'] = "1";
	$i70_arr['p06_1'] = "9999999999.99";
	$i70_arr['is_std'] = "1";
	if (pegasus_mysql_printfld('i70', 'nr01', 'nr01=:nr01', array('nr01' => $i70_arr['nr01'])) > 0) {
		pegasus_mysql_update('i70', array_keys($i70_arr), array_values($i70_arr), 'nr01=:nr01', 0, 1, 1, array('nr01' => $i70_arr['nr01']));
	} else {
		$i70_arr['p300'] = 1;
		pegasus_mysql_insert('i70', array_keys($i70_arr), array_values($i70_arr));
	}

	$i70_arr = array();
	$i70_arr['nr01'] = "10000000028";
	$i70_arr['p01'] = "α1) ασφάλιστρα κλάδου πυρός 20%";
	$i70_arr['p02'] = "1";
	$i70_arr['p03'] = "1";
	$i70_arr['p04'] = "20.0000000";
	$i70_arr['p05'] = "0";
	$i70_arr['p06'] = "0.00";
	$i70_arr['p07'] = "1";
	$i70_arr['p06_1'] = "9999999999.99";
	$i70_arr['is_std'] = "1";
	if (pegasus_mysql_printfld('i70', 'nr01', 'nr01=:nr01', array('nr01' => $i70_arr['nr01'])) > 0) {
		pegasus_mysql_update('i70', array_keys($i70_arr), array_values($i70_arr), 'nr01=:nr01', 0, 1, 1, array('nr01' => $i70_arr['nr01']));
	} else {
		$i70_arr['p300'] = 1;
		pegasus_mysql_insert('i70', array_keys($i70_arr), array_values($i70_arr));
	}

	$i70_arr = array();
	$i70_arr['nr01'] = "10000000029";
	$i70_arr['p01'] = "α2) ασφάλιστρα κλάδου πυρός 20%";
	$i70_arr['p02'] = "1";
	$i70_arr['p03'] = "1";
	$i70_arr['p04'] = "20.0000000";
	$i70_arr['p05'] = "0";
	$i70_arr['p06'] = "0.00";
	$i70_arr['p07'] = "1";
	$i70_arr['p06_1'] = "9999999999.99";
	$i70_arr['is_std'] = "1";
	if (pegasus_mysql_printfld('i70', 'nr01', 'nr01=:nr01', array('nr01' => $i70_arr['nr01'])) > 0) {
		pegasus_mysql_update('i70', array_keys($i70_arr), array_values($i70_arr), 'nr01=:nr01', 0, 1, 1, array('nr01' => $i70_arr['nr01']));
	} else {
		$i70_arr['p300'] = 1;
		pegasus_mysql_insert('i70', array_keys($i70_arr), array_values($i70_arr));
	}

	$i70_arr = array();
	$i70_arr['nr01'] = "10000000030";
	$i70_arr['p01'] = "β) ασφάλιστρα κλάδου ζωής 4%";
	$i70_arr['p02'] = "1";
	$i70_arr['p03'] = "1";
	$i70_arr['p04'] = "4.0000000";
	$i70_arr['p05'] = "0";
	$i70_arr['p06'] = "0.00";
	$i70_arr['p07'] = "1";
	$i70_arr['p06_1'] = "9999999999.99";
	$i70_arr['is_std'] = "1";
	if (pegasus_mysql_printfld('i70', 'nr01', 'nr01=:nr01', array('nr01' => $i70_arr['nr01'])) > 0) {
		pegasus_mysql_update('i70', array_keys($i70_arr), array_values($i70_arr), 'nr01=:nr01', 0, 1, 1, array('nr01' => $i70_arr['nr01']));
	} else {
		$i70_arr['p300'] = 1;
		pegasus_mysql_insert('i70', array_keys($i70_arr), array_values($i70_arr));
	}

	$i70_arr = array();
	$i70_arr['nr01'] = "10000000031";
	$i70_arr['p01'] = "γ) ασφάλιστρα λοιπών κλάδων 15%";
	$i70_arr['p02'] = "1";
	$i70_arr['p03'] = "1";
	$i70_arr['p04'] = "15.0000000";
	$i70_arr['p05'] = "0";
	$i70_arr['p06'] = "0.00";
	$i70_arr['p07'] = "1";
	$i70_arr['p06_1'] = "9999999999.99";
	$i70_arr['is_std'] = "1";
	if (pegasus_mysql_printfld('i70', 'nr01', 'nr01=:nr01', array('nr01' => $i70_arr['nr01'])) > 0) {
		pegasus_mysql_update('i70', array_keys($i70_arr), array_values($i70_arr), 'nr01=:nr01', 0, 1, 1, array('nr01' => $i70_arr['nr01']));
	} else {
		$i70_arr['p300'] = 1;
		pegasus_mysql_insert('i70', array_keys($i70_arr), array_values($i70_arr));
	}

	$i70_arr = array();
	$i70_arr['nr01'] = "10000000032";
	$i70_arr['p01'] = "δ) απαλλασσόμενα φόρου ασφαλίστρων 0%";
	$i70_arr['p02'] = "1";
	$i70_arr['p03'] = "1";
	$i70_arr['p04'] = "0.0000000";
	$i70_arr['p05'] = "0";
	$i70_arr['p06'] = "0.00";
	$i70_arr['p07'] = "1";
	$i70_arr['p06_1'] = "9999999999.99";
	$i70_arr['is_std'] = "1";
	if (pegasus_mysql_printfld('i70', 'nr01', 'nr01=:nr01', array('nr01' => $i70_arr['nr01'])) > 0) {
		pegasus_mysql_update('i70', array_keys($i70_arr), array_values($i70_arr), 'nr01=:nr01', 0, 1, 1, array('nr01' => $i70_arr['nr01']));
	} else {
		$i70_arr['p300'] = 1;
		pegasus_mysql_insert('i70', array_keys($i70_arr), array_values($i70_arr));
	}

	$i70_arr = array();
	$i70_arr['nr01'] = "10000000033";
	$i70_arr['p01'] = "Ξενοδοχεία 1-2 αστέρων 0,50 €";
	$i70_arr['p02'] = "1";
	$i70_arr['p03'] = "2";
	$i70_arr['p04'] = "0.5000000";
	$i70_arr['p05'] = "0";
	$i70_arr['p06'] = "0.00";
	$i70_arr['p07'] = "1";
	$i70_arr['p06_1'] = "9999999999.99";
	$i70_arr['is_std'] = "1";
	if (pegasus_mysql_printfld('i70', 'nr01', 'nr01=:nr01', array('nr01' => $i70_arr['nr01'])) > 0) {
		pegasus_mysql_update('i70', array_keys($i70_arr), array_values($i70_arr), 'nr01=:nr01', 0, 1, 1, array('nr01' => $i70_arr['nr01']));
	} else {
		$i70_arr['p300'] = 1;
		pegasus_mysql_insert('i70', array_keys($i70_arr), array_values($i70_arr));
	}

	$i70_arr = array();
	$i70_arr['nr01'] = "10000000034";
	$i70_arr['p01'] = "Ξενοδοχεία 3 αστέρων 1,50 €";
	$i70_arr['p02'] = "1";
	$i70_arr['p03'] = "2";
	$i70_arr['p04'] = "1.5000000";
	$i70_arr['p05'] = "0";
	$i70_arr['p06'] = "0.00";
	$i70_arr['p07'] = "1";
	$i70_arr['p06_1'] = "9999999999.99";
	$i70_arr['is_std'] = "1";
	if (pegasus_mysql_printfld('i70', 'nr01', 'nr01=:nr01', array('nr01' => $i70_arr['nr01'])) > 0) {
		pegasus_mysql_update('i70', array_keys($i70_arr), array_values($i70_arr), 'nr01=:nr01', 0, 1, 1, array('nr01' => $i70_arr['nr01']));
	} else {
		$i70_arr['p300'] = 1;
		pegasus_mysql_insert('i70', array_keys($i70_arr), array_values($i70_arr));
	}

	$i70_arr = array();
	$i70_arr['nr01'] = "10000000035";
	$i70_arr['p01'] = "Ξενοδοχεία 4 αστέρων 3,00 €";
	$i70_arr['p02'] = "1";
	$i70_arr['p03'] = "2";
	$i70_arr['p04'] = "3.0000000";
	$i70_arr['p05'] = "0";
	$i70_arr['p06'] = "0.00";
	$i70_arr['p07'] = "1";
	$i70_arr['p06_1'] = "9999999999.99";
	$i70_arr['is_std'] = "1";
	if (pegasus_mysql_printfld('i70', 'nr01', 'nr01=:nr01', array('nr01' => $i70_arr['nr01'])) > 0) {
		pegasus_mysql_update('i70', array_keys($i70_arr), array_values($i70_arr), 'nr01=:nr01', 0, 1, 1, array('nr01' => $i70_arr['nr01']));
	} else {
		$i70_arr['p300'] = 1;
		pegasus_mysql_insert('i70', array_keys($i70_arr), array_values($i70_arr));
	}

	$i70_arr = array();
	$i70_arr['nr01'] = "10000000036";
	$i70_arr['p01'] = "Ξενοδοχεία 5 αστέρων 4,00 €";
	$i70_arr['p02'] = "1";
	$i70_arr['p03'] = "2";
	$i70_arr['p04'] = "4.0000000";
	$i70_arr['p05'] = "0";
	$i70_arr['p06'] = "0.00";
	$i70_arr['p07'] = "1";
	$i70_arr['p06_1'] = "9999999999.99";
	$i70_arr['is_std'] = "1";
	if (pegasus_mysql_printfld('i70', 'nr01', 'nr01=:nr01', array('nr01' => $i70_arr['nr01'])) > 0) {
		pegasus_mysql_update('i70', array_keys($i70_arr), array_values($i70_arr), 'nr01=:nr01', 0, 1, 1, array('nr01' => $i70_arr['nr01']));
	} else {
		$i70_arr['p300'] = 1;
		pegasus_mysql_insert('i70', array_keys($i70_arr), array_values($i70_arr));
	}

	$i70_arr = array();
	$i70_arr['nr01'] = "10000000037";
	$i70_arr['p01'] = "Ενοικιαζόμενα -επιπλωμένα δωμάτια -διαμερίσματα 0,50 €";
	$i70_arr['p02'] = "1";
	$i70_arr['p03'] = "2";
	$i70_arr['p04'] = "0.5000000";
	$i70_arr['p05'] = "0";
	$i70_arr['p06'] = "0.00";
	$i70_arr['p07'] = "1";
	$i70_arr['p06_1'] = "9999999999.99";
	$i70_arr['is_std'] = "1";
	if (pegasus_mysql_printfld('i70', 'nr01', 'nr01=:nr01', array('nr01' => $i70_arr['nr01'])) > 0) {
		pegasus_mysql_update('i70', array_keys($i70_arr), array_values($i70_arr), 'nr01=:nr01', 0, 1, 1, array('nr01' => $i70_arr['nr01']));
	} else {
		$i70_arr['p300'] = 1;
		pegasus_mysql_insert('i70', array_keys($i70_arr), array_values($i70_arr));
	}

	$i70_arr = array();
	$i70_arr['nr01'] = "10000000038";
	$i70_arr['p01'] = "Ειδικός Φόρος στις  διαφημίσεις που προβάλλονται από την τηλεόραση (ΕΦΤΔ) 5%";
	$i70_arr['p02'] = "1";
	$i70_arr['p03'] = "1";
	$i70_arr['p04'] = "5.0000000";
	$i70_arr['p05'] = "0";
	$i70_arr['p06'] = "0.00";
	$i70_arr['p07'] = "1";
	$i70_arr['p06_1'] = "9999999999.99";
	$i70_arr['is_std'] = "1";
	if (pegasus_mysql_printfld('i70', 'nr01', 'nr01=:nr01', array('nr01' => $i70_arr['nr01'])) > 0) {
		pegasus_mysql_update('i70', array_keys($i70_arr), array_values($i70_arr), 'nr01=:nr01', 0, 1, 1, array('nr01' => $i70_arr['nr01']));
	} else {
		$i70_arr['p300'] = 1;
		pegasus_mysql_insert('i70', array_keys($i70_arr), array_values($i70_arr));
	}

	$i70_arr = array();
	$i70_arr['nr01'] = "10000000039";
	$i70_arr['p01'] = "3.1 Φόρος πολυτελείας επί φορ\τέας αξίας για ενδοκοινοτικώς αποκτούμενα και εισαγόμενα τρίτων χώρων";
	$i70_arr['p02'] = "1";
	$i70_arr['p03'] = "1";
	$i70_arr['p04'] = "0.0000000";
	$i70_arr['p05'] = "0";
	$i70_arr['p06'] = "0.00";
	$i70_arr['p07'] = "1";
	$i70_arr['p06_1'] = "9999999999.99";
	$i70_arr['is_std'] = "1";
	if (pegasus_mysql_printfld('i70', 'nr01', 'nr01=:nr01', array('nr01' => $i70_arr['nr01'])) > 0) {
		pegasus_mysql_update('i70', array_keys($i70_arr), array_values($i70_arr), 'nr01=:nr01', 0, 1, 1, array('nr01' => $i70_arr['nr01']));
	} else {
		$i70_arr['p300'] = 1;
		pegasus_mysql_insert('i70', array_keys($i70_arr), array_values($i70_arr));
	}

	$i70_arr = array();
	$i70_arr['nr01'] = "10000000040";
	$i70_arr['p01'] = "3.2 Φόρος πολυτελείας 10% επί της τιμής πώλησης προ Φ.Π.Α. για τα εγχωρίως παραγόμενα είδη 10%";
	$i70_arr['p02'] = "1";
	$i70_arr['p03'] = "1";
	$i70_arr['p04'] = "10.0000000";
	$i70_arr['p05'] = "0";
	$i70_arr['p06'] = "0.00";
	$i70_arr['p07'] = "1";
	$i70_arr['p06_1'] = "9999999999.99";
	$i70_arr['is_std'] = "1";
	if (pegasus_mysql_printfld('i70', 'nr01', 'nr01=:nr01', array('nr01' => $i70_arr['nr01'])) > 0) {
		pegasus_mysql_update('i70', array_keys($i70_arr), array_values($i70_arr), 'nr01=:nr01', 0, 1, 1, array('nr01' => $i70_arr['nr01']));
	} else {
		$i70_arr['p300'] = 1;
		pegasus_mysql_insert('i70', array_keys($i70_arr), array_values($i70_arr));
	}

	$i70_arr = array();
	$i70_arr['nr01'] = "10000000041";
	$i70_arr['p01'] = "Δικαίωμα του Δημοσίου στα εισιτήρια των καζίνο (80% επί του εισιτηρίου)";
	$i70_arr['p02'] = "1";
	$i70_arr['p03'] = "1";
	$i70_arr['p04'] = "80.0000000";
	$i70_arr['p05'] = "0";
	$i70_arr['p06'] = "0.00";
	$i70_arr['p07'] = "1";
	$i70_arr['p06_1'] = "9999999999.99";
	$i70_arr['is_std'] = "1";
	if (pegasus_mysql_printfld('i70', 'nr01', 'nr01=:nr01', array('nr01' => $i70_arr['nr01'])) > 0) {
		pegasus_mysql_update('i70', array_keys($i70_arr), array_values($i70_arr), 'nr01=:nr01', 0, 1, 1, array('nr01' => $i70_arr['nr01']));
	} else {
		$i70_arr['p300'] = 1;
		pegasus_mysql_insert('i70', array_keys($i70_arr), array_values($i70_arr));
	}

	$i70_arr = array();
	$i70_arr['nr01'] = "10000000042";
	$i70_arr['p01'] = "Παρακράτηση Φόρου 20%";
	$i70_arr['p02'] = "2";
	$i70_arr['p03'] = "1";
	$i70_arr['p04'] = "20.0000000";
	$i70_arr['p05'] = "0";
	$i70_arr['p06'] = "300.00";
	$i70_arr['p07'] = "1";
	$i70_arr['p06_1'] = "9999999999.99";
	$i70_arr['is_std'] = "1";
	if (pegasus_mysql_printfld('i70', 'nr01', 'nr01=:nr01', array('nr01' => $i70_arr['nr01'])) > 0) {
		pegasus_mysql_update('i70', array_keys($i70_arr), array_values($i70_arr), 'nr01=:nr01', 0, 1, 1, array('nr01' => $i70_arr['nr01']));
	} else {
		$i70_arr['p300'] = 1;
		pegasus_mysql_insert('i70', array_keys($i70_arr), array_values($i70_arr));
	}

	$i70_arr = array();
	$i70_arr['nr01'] = "10000000043";
	$i70_arr['p01'] = "Παρακράτηση από Δικηγορικό Σύλλογο 12%";
	$i70_arr['p02'] = "2";
	$i70_arr['p03'] = "1";
	$i70_arr['p04'] = "12.0000000";
	$i70_arr['p05'] = "0";
	$i70_arr['p06'] = "0.00";
	$i70_arr['p07'] = "0";
	$i70_arr['p06_1'] = "9999999999.99";
	$i70_arr['is_std'] = "1";
	if (pegasus_mysql_printfld('i70', 'nr01', 'nr01=:nr01', array('nr01' => $i70_arr['nr01'])) > 0) {
		pegasus_mysql_update('i70', array_keys($i70_arr), array_values($i70_arr), 'nr01=:nr01', 0, 1, 1, array('nr01' => $i70_arr['nr01']));
	} else {
		$i70_arr['p300'] = 1;
		pegasus_mysql_insert('i70', array_keys($i70_arr), array_values($i70_arr));
	}

	$i70_arr = array();
	$i70_arr['nr01'] = "10000000044";
	$i70_arr['p01'] = "Παρακράτηση Φόρου από Δικηγορικό Σύλλογο 15%";
	$i70_arr['p02'] = "2";
	$i70_arr['p03'] = "1";
	$i70_arr['p04'] = "15.0000000";
	$i70_arr['p05'] = "0";
	$i70_arr['p06'] = "0.00";
	$i70_arr['p07'] = "0";
	$i70_arr['p06_1'] = "9999999999.99";
	$i70_arr['is_std'] = "1";
	if (pegasus_mysql_printfld('i70', 'nr01', 'nr01=:nr01', array('nr01' => $i70_arr['nr01'])) > 0) {
		pegasus_mysql_update('i70', array_keys($i70_arr), array_values($i70_arr), 'nr01=:nr01', 0, 1, 1, array('nr01' => $i70_arr['nr01']));
	} else {
		$i70_arr['p300'] = 1;
		pegasus_mysql_insert('i70', array_keys($i70_arr), array_values($i70_arr));
	}

	$i70_arr = array();
	$i70_arr['nr01'] = "10000000045";
	$i70_arr['p01'] = "Κρατήσεις Υπέρ Τρίτων";
	$i70_arr['p02'] = "2";
	$i70_arr['p03'] = "2";
	$i70_arr['p04'] = "0.0000000";
	$i70_arr['p05'] = "0";
	$i70_arr['p06'] = "0.00";
	$i70_arr['p07'] = "0";
	$i70_arr['p06_1'] = "9999999999.99";
	$i70_arr['is_std'] = "1";
	if (pegasus_mysql_printfld('i70', 'nr01', 'nr01=:nr01', array('nr01' => $i70_arr['nr01'])) > 0) {
		pegasus_mysql_update('i70', array_keys($i70_arr), array_values($i70_arr), 'nr01=:nr01', 0, 1, 1, array('nr01' => $i70_arr['nr01']));
	} else {
		$i70_arr['p300'] = 1;
		pegasus_mysql_insert('i70', array_keys($i70_arr), array_values($i70_arr));
	}

	$i70_arr = array();
	$i70_arr['nr01'] = "10000000050";
	$i70_arr['p01'] = "Παρακρατήσεις συναλλαγών αλλοδαπής βάσει συμβάσεων αποφυγής διπλής φορολογίας (Σ.Α.Δ.Φ.)";
	$i70_arr['p02'] = "2";
	$i70_arr['p03'] = "2";
	$i70_arr['p04'] = "0.0000000";
	$i70_arr['p05'] = "0";
	$i70_arr['p06'] = "0.00";
	$i70_arr['p07'] = "0";
	$i70_arr['p06_1'] = "9999999999.99";
	$i70_arr['is_std'] = "1";
	if (pegasus_mysql_printfld('i70', 'nr01', 'nr01=:nr01', array('nr01' => $i70_arr['nr01'])) > 0) {
		pegasus_mysql_update('i70', array_keys($i70_arr), array_values($i70_arr), 'nr01=:nr01', 0, 1, 1, array('nr01' => $i70_arr['nr01']));
	} else {
		$i70_arr['p300'] = 1;
		pegasus_mysql_insert('i70', array_keys($i70_arr), array_values($i70_arr));
	}

	$i70_arr = array();
	$i70_arr['nr01'] = "10000000051";
	$i70_arr['p01'] = "Λοιπές Παρακρατήσεις Φόρου";
	$i70_arr['p02'] = "2";
	$i70_arr['p03'] = "2";
	$i70_arr['p04'] = "0.0000000";
	$i70_arr['p05'] = "0";
	$i70_arr['p06'] = "0.00";
	$i70_arr['p07'] = "0";
	$i70_arr['p06_1'] = "9999999999.99";
	$i70_arr['is_std'] = "1";
	if (pegasus_mysql_printfld('i70', 'nr01', 'nr01=:nr01', array('nr01' => $i70_arr['nr01'])) > 0) {
		pegasus_mysql_update('i70', array_keys($i70_arr), array_values($i70_arr), 'nr01=:nr01', 0, 1, 1, array('nr01' => $i70_arr['nr01']));
	} else {
		$i70_arr['p300'] = 1;
		pegasus_mysql_insert('i70', array_keys($i70_arr), array_values($i70_arr));
	}
	
	$i70_arr = array();
	$i70_arr['nr01'] = "10000000052";
	$i70_arr['p01'] = "Λοιπές Περιπτώσεις Χαρτοσήμου";
	$i70_arr['p02'] = "1";
	$i70_arr['p03'] = "2";
	$i70_arr['tax'] = "100";
	$i70_arr['p05'] = "0";
	$i70_arr['p06'] = "0.00";
	$i70_arr['p07'] = "1";
	$i70_arr['p06_1'] = "9999999999.99";
	$i70_arr['is_std'] = "1";
	if (pegasus_mysql_printfld('i70', 'nr01', 'nr01=:nr01', array('nr01' => $i70_arr['nr01'])) > 0) {
		pegasus_mysql_update('i70', array_keys($i70_arr), array_values($i70_arr), 'nr01=:nr01', 0, 1, 1, array('nr01' => $i70_arr['nr01']));
	} else {
		$i70_arr['p300'] = 1;
		pegasus_mysql_insert('i70', array_keys($i70_arr), array_values($i70_arr));
	}
	/** i70 Update end*/
}

function invoices_user_defined_fields()
{
	$select = "select * from a97";
	$res = pegasus_query($select);

	while ($a97 = pegasus_fetch($res)) {
		$_SESSION['a97_' . $a97['nr01']] = $a97['p02'];
	}

	$i = 0;
	while ($i < 9) {
		$i++;
		if (!empty($_SESSION['a97_' . $i])) {
			$tit  = $_SESSION['a97_' . $i];
			$etit = $_SESSION['a97_' . $i];
		}
		/* αν κάποιο είναι κενό */
		else{
			pegasus_mysql_use('SELECT * FROM p82 WHERE p00= :p00; ', $p82, array('p00' => 'invoices_lexical_'.$i));
    		$tit  = $p82['p01'];
			$etit = $p82['ep01'];
		}

		$arr1 = array();
		$arr2 = array();
		array_push($arr1, 'desc02');
		array_push($arr2, $tit);
		array_push($arr1, 'edesc02');
		array_push($arr2, $etit);
		pegasus_mysql_update(
			'p51', 
			$arr1, 
			$arr2, 
			'p02 in ("a55_d" , "a56_d" , "a57_d" , "a67_d", "a55_d5" , "a56_d5" , "a57_d4" , "a67_d4" ) and desc05="p4' . pegasus_leading_zeros($i, 2) . '"');
	}

	pegasus_delete_directory('../../tmp/invoices/');
	pegasus_delete_directory('../../tmp/invcust/');
	pegasus_delete_directory('../../tmp/invsupp/');
	pegasus_delete_directory('../../tmp/ordercust/');
	pegasus_delete_directory('../../tmp/ordersupp/');
	if (pegasus_module_exists('peg002') && function_exists('peg002_clean_dCache')) {
		peg002_clean_dCache('a55_d');
		peg002_clean_dCache('a56_d');
		peg002_clean_dCache('a57_d');
		peg002_clean_dCache('a67_d');
		peg002_clean_dCache('a55_d5');
		peg002_clean_dCache('a56_d5');
		peg002_clean_dCache('a57_d4');
		peg002_clean_dCache('a67_d4');
	}
}

function invoices_vehicle_defined_fields()
{
	$select = "select * from a98";
	$res = pegasus_query($select);

	while ($a98 = pegasus_fetch($res)) {
		$_SESSION['a98_' . $a98['nr01']] = $a98['p02'];
	}

	$i = 0;
	while ($i < 4) {
		$i++;
		if (!empty($_SESSION['a98_' . $i])) {
			$tit  = $_SESSION['a98_' . $i];
			$etit = $_SESSION['a98_' . $i];
		}
		/* αν κάποιο είναι κενό */
		else{
			pegasus_mysql_use('SELECT * FROM p82 WHERE p00= :p00; ', $p82, array('p00' => 'invoices_lexical_'.$i));
    		$tit  = $p82['p01'];
			$etit = $p82['ep01'];
		}

		$arr1 = array();
		$arr2 = array();
		array_push($arr1, 'desc02');
		array_push($arr2, $tit);
		array_push($arr1, 'edesc02');
		array_push($arr2, $etit);
		pegasus_mysql_update(
			'p51', 
			$arr1, 
			$arr2, 
			'p02 = "a20_d" and desc05="p1' . pegasus_leading_zeros($i, 2) . '"');
	}

	pegasus_delete_directory('../../tmp/invoices/');

	if (pegasus_module_exists('peg002') && function_exists('peg002_clean_dCache')) {
		peg002_clean_dCache('a20_d');
	}
}

function invoices_custom_actions($container_id, $id, $mnr01, $mmnr01, $_d, $pec_cust_text = '')
{

	if ((pegasus_module_exists('invcust')  and  $_d == 'a55_d') or (pegasus_module_exists('invsupp')  and  $_d == 'a56_d')) {
		if (!empty($pec_cust_text)) {
			$pec_cust_text .= ',';
		}
		if ($_d == 'a55_d') {
			$mode = 'a55';
		} else {
			$mode = 'a56';
		}
		$pec_cust_text .= "{text:'" . $_SESSION['peg_dic_invoices_cancel_invoice'] . "',
					icon:'/" . $_SESSION['main_path'] . "/invoices_images/cancel_invoice_16x16.png',
					handler:function(){
						var row=pegGridGetSelectedRow('" . $container_id . "' , '" . $id . "' , '" . $mnr01 . "' , '" . $mmnr01 . "' );
						if(row){
							var nr01=row.nr01;
							if(nr01<1){
								pegAlert('" . $_SESSION['peg_dic_hot000_invoice_cust_select_res'] . "');
								return;
							}
							invoices_cancel_invoice( '" . $mode . "' , nr01);
						}
					}
					}";
	}

	if ((pegasus_module_exists('invcust')  and  $_d == 'a55_d') or (pegasus_module_exists('invsupp')  and  $_d == 'a56_d')) {
		if (!empty($pec_cust_text)) {
			$pec_cust_text .= ',';
		}

		if ($_d == 'a55_d') {
			$mode = 'a55';
		} else {
			$mode = 'a56';
		}
		$pec_cust_text .= "{text:'" . $_SESSION['peg_dic_invoices_transform_invoice'] . "',
					icon:'/" . $_SESSION['main_path'] . "/invoices_images/transform_invoice_16x16.png',
					handler:function(){
						var row=pegGridGetSelectedRow('" . $container_id . "' , '" . $id . "' , '" . $mnr01 . "' , '" . $mmnr01 . "' );
						if(row){
							var nr01=row.nr01;
							if(nr01<1){
								pegAlert('" . $_SESSION['peg_dic_hot000_invoice_cust_select_res'] . "');
								return;
							}
							invoices_transform_invoice( '" . $mode . "' , nr01);
						}
					}
					}";
	}
	if (pegasus_module_exists('query')) {
		$mmnr01_arr = explode('-', $mmnr01);
		$parent_d = $mmnr01_arr[0];
		if (pegasus_module_exists('ordercust') and  ($_d == 'a68_d' or $_d == 'a62_d')) {
			if (!empty($pec_cust_text)) {
				$pec_cust_text .= ',';
			}
			$pec_cust_text .= "{text:'" . $_SESSION['peg_dic_invoices_a57_pending'] . "',
					icon:'/" . $_SESSION['main_path'] . "/invoices_images/a57_16x16.png',
					handler:function(){
				   	 	invoices_toolbar_item_show_report('" . $container_id . "',
														  '" . $id . "',
														  '" . $_SESSION['peg_dic_invoices_select_item_first'] . "',
														  '140000012000002',
														  '" . pegasus_container_id_get_parentBy_d($container_id, $parent_d) . "'
						 );
			 		}
				}";
		}
		if (pegasus_module_exists('ordersupp') and  ($_d == 'a58_d' or $_d == 'a62_d')) {
			if (!empty($pec_cust_text)) {
				$pec_cust_text .= ',';
			}
			$pec_cust_text .= "{text:'" . $_SESSION['peg_dic_invoices_a67_pending'] . "',
					icon:'/" . $_SESSION['main_path'] . "/invoices_images/a68_16x16.png',
					handler:function(){
				   	 	invoices_toolbar_item_show_report('" . $container_id . "',
														  '" . $id . "',
														  '" . $_SESSION['peg_dic_invoices_select_item_first'] . "',
														  '140000081000001',
														  '" . pegasus_container_id_get_parentBy_d($container_id, $parent_d) . "'
						 );
			 		}
				}";
		}

		if (pegasus_module_exists('interorder') and  ($_d == 'a68_d' or $_d == 'a58_d')) {
			if (!empty($pec_cust_text)) {
				$pec_cust_text .= ',';
			}
			$pec_cust_text .= "{text:'" . $_SESSION['peg_dic_invoices_a61_pending'] . "',
					icon:'/" . $_SESSION['main_path'] . "/invoices_images/a61_16x16.png',
					handler:function(){
				   	 	invoices_toolbar_item_show_report('" . $container_id . "',
														  '" . $id . "',
														  '" . $_SESSION['peg_dic_invoices_select_item_first'] . "',
														  '140000103000000',
														  '" . pegasus_container_id_get_parentBy_d($container_id, $parent_d) . "'
						 );
			 		}
				}";
		}
	}
	return $pec_cust_text;
}

/**
 * @param  $retArray: ο πίνακας όπου βάζουμε τα Tollbar Grid Actions
 * @param $id: Πρέπει να έρχεται συμπληρωμένο.Είναι το όνομα του grid
 * @param $parent_d
 *
 * Στην περίπτωση που το action πρέπει να κάνει refresh κάποιο grid πέρα από το δικό του, μπορώ να χρησιμοποιήσω τα πεδία _d_with_grid_to_refresh, grid_to_refresh.
 * Έχει χρησιμοποιηθεί π.χ. στην οθόνη τιμολόγησης της κράτησης του hotel
 * @param $_d_with_grid_to_refresh : Είναι το όνομα της οθόνης του grid. Θα προσπαθήσω να βρω το grid στην js ως εξής: pegGetContainer_id_d(container_id , _d_with_grid_to_refresh_on_submit );
 * @param $grid_to_refresh : Είναι το όνομα του grid
 * */
function invoices_custom_actions_peg002($retArray = array(), $id = '', $parent_d = '', $_d_with_grid_to_refresh = '', $grid_to_refresh = '', $grid_columns = array())
{

	$grid_columns_json = json_encode($grid_columns);

	$moduleExistsInvsupp    = pegasus_module_exists('invsupp');
	$moduleExistsInvcust 	= pegasus_module_exists('invcust');
	$moduleExistsInvtrans00 = pegasus_module_exists('invtrans00');
	$moduleExistsOrdercust 	= pegasus_module_exists('ordercust');
	$moduleExistsOrdersupp 	= pegasus_module_exists('ordersupp');
	$moduleExistsInterorder = pegasus_module_exists('interorder');
	$moduleExistsQuery 		= pegasus_module_exists('query');
	$moduleExistsAccount00	= pegasus_module_exists('account00');
	$moduleExistsAccount	= pegasus_module_exists('account');

	if ($moduleExistsInvcust) {
		$peg_handler = 'invoices_toolbar_item_invoice_order(screen.getContainer_ID(),
															   \'' . $id . '\',
															   \'' . $_SESSION['peg_dic_invcust_invoice_cust_select_order'] . '\',\'a57\' );';
		$retArray[] = array(
			'xtype' => 'pegasusToolBarGridAction',
			'peg_custom_id' => 'invoice_order',
			'viewModel' => array(
				'type' => 'GridButtonModel',
				'isToolBar' => 1,
				'data' => array(
					'toolBarButton' => 'invoice_order',
				)
			),
			'icon' => 'invcust_images/a55_16x16.png',
			'text' =>  $_SESSION['peg_dic_invcust_invoice_order'],
			'peghandler' => $peg_handler
		);
	}

	if ($moduleExistsAccount00) {
		$peg_handler = 'account00_invoices_toolbar_item_account00_add_payment(screen.getContainer_ID(),
															   \'' . $id . '\',
															   \'' . $_SESSION['peg_dic_invcust_select_invoice'] . '\',\'a55\' );';
		$retArray[] = array(
			'xtype' => 'pegasusToolBarGridAction',
			'peg_custom_id' => 'account00_add_payment',
			'viewModel' => array(
				'type' => 'GridButtonModel',
				'isToolBar' => 1,
				'data' => array(
					'toolBarButton' => 'account00_add_payment',
				)
			),
			'icon' => 'account00_images/pos16x16.svg',
			'text' =>  $_SESSION['peg_dic_invoices_eftpos_payment'],
			'peghandler' => $peg_handler
		);
	}

	if ($moduleExistsAccount) {
		$peg_handler = 'account_proceed_to_payment(screen.getContainer_ID(), \'' . $id . '\', \'' . $_SESSION['peg_dic_invcust_select_invoice'] . '\');';

		$retArray[] = array(
			'xtype' 		=> 'pegasusToolBarGridAction',
			'peg_custom_id' => 'account_proceed_to_payment',
			'viewModel' 	=> array(
				'type' 		=> 'GridButtonModel',
				'isToolBar' => 1,
				'data' 		=> array(
					'toolBarButton' => 'account_proceed_to_payment',
				)
			),
			'iconCls'		=> 'x-fa fa-credit-card',
			'text' 			=> $_SESSION['peg_dic_account_proceed_to_payment'],
			'peghandler' 	=> $peg_handler
		);
	}

	if ($moduleExistsInvsupp) {
		$peg_handler = 'invoices_toolbar_item_invoice_order(screen.getContainer_ID(),
															   \'' . $id . '\',
															   \'' . $_SESSION['peg_dic_invcust_invoice_cust_select_order'] . '\' ,\'a67\');';
		$retArray[] = array(
			'xtype' => 'pegasusToolBarGridAction',
			'peg_custom_id' => 'invsupp_invoice_order',
			'icon' => 'invsupp_images/a56_16x16.png',
			'text' =>  $_SESSION['peg_dic_invsupp_invoice_order'],
			'peghandler' => $peg_handler
		);
	}

	if ($moduleExistsInvtrans00) {
		$peg_handler = 'invoices_toolbar_item_invoice_order(screen.getContainer_ID(),
															   \'' . $id . '\',
															   \'' . $_SESSION['peg_dic_invtrans00_invoice_select_order'] . '\' ,\'a61\');';
		$retArray[] = array(
			'xtype' => 'pegasusToolBarGridAction',
			'peg_custom_id' => 'invtrans00_invoice_order',
			'icon' => 'invtrans00_images/a60_16x16.png',
			'text' =>  $_SESSION['peg_dic_invtrans00_invoice_order'],
			'peghandler' => $peg_handler
		);
	}


	if (($moduleExistsInvcust) or ($moduleExistsInvsupp)) {
		$tmpAr = array('a55', 'a56');
		foreach ($tmpAr as $mode) {
			$mode_module = 'invsupp';
			if ($mode == 'a55') {
				$mode_module = 'invcust';
			}
			$peg_handler = 'invoices_toolbar_item_cancel_invoice(screen.getContainer_ID(),
																	 \'' . $id . '\',
																	 \'' . $_SESSION['peg_dic_hot000_invoice_cust_select_res'] . '\',
																	 \'' . $mode . '\',
																	 \'' . $_d_with_grid_to_refresh . '\',
																	 \'' . $grid_to_refresh . '\');';
			$retArray[] = array(
				'xtype' => 'pegasusToolBarGridAction',
				'peg_custom_id' => $mode_module . '_cancel_invoice',
				'viewModel' => array(
					'type' => 'GridButtonModel',
					'isToolBar' => 1,
					'data' => array(
						'toolBarButton' => $mode_module . '_cancel_invoice',

					)
				),
				'icon' => 'invoices_images/cancel_invoice_16x16.png',
				'text' =>  $_SESSION['peg_dic_invoices_cancel_invoice'],
				'peghandler' => $peg_handler
			);
		}
	}
	if (($moduleExistsInvcust) or ($moduleExistsInvsupp)) {
		$tmpAr = array('a55', 'a56');
		foreach ($tmpAr as $mode) {
			$mode_module = 'invsupp';
			if ($mode == 'a55') {
				$mode_module = 'invcust';
			}
			$peg_handler = 'invoices_toolbar_item_transform_invoice(screen.getContainer_ID(),
																		\'' . $id . '\',
																		\'' . $_SESSION['peg_dic_hot000_invoice_cust_select_res'] . '\',
																		\'' . $mode . '\',
																		\'' . $_d_with_grid_to_refresh . '\',
																		\'' . $grid_to_refresh . '\');';
			$retArray[] = array(
				'xtype' => 'pegasusToolBarGridAction',
				'peg_custom_id' => $mode_module . '_transform_invoice',
				'viewModel' => array(
					'type' => 'GridButtonModel',
					'isToolBar' => 1,
					'data' => array(
						'toolBarButton' => $mode_module . '_transform_invoice',

					)
				),
				'icon' => 'invoices_images/transform_invoice_16x16.png',
				'text' =>  $_SESSION['peg_dic_invoices_transform_invoice'],
				'peghandler' => $peg_handler
			);
		}
	}

	if ($moduleExistsQuery) {
		if ($moduleExistsOrdercust) {
			$mode_module = 'ordercust';
			$q10nr01 = "140000012000002";
			$peg_handler = 'invoices_toolbar_item_show_report(screen.getContainer_ID(),
																	 \'' . $id . '\',
																	 \'' . $_SESSION['peg_dic_invoices_select_item_first'] . '\',
																	 \'' . $q10nr01 . '\',
																	 \'\',
																	 \'' . $parent_d . '\',
																	 JSON.parse(\'' . $grid_columns_json . '\'));';
			$retArray[] = array(
				'xtype' => 'pegasusToolBarGridAction',
				'peg_custom_id' => $mode_module . '_show_report',
				'viewModel' => array(
					'type' => 'GridButtonModel',
					'isToolBar' => 1,
					'data' => array(
						'toolBarButton' => $mode_module . '_show_report',

					)
				),
				'icon' => 'invoices_images/a57_16x16.png',
				'text' =>  $_SESSION['peg_dic_invoices_a57_pending'],
				'peghandler' => $peg_handler
			);
		}


		if ($moduleExistsOrdersupp) {
			$q10nr01 = "140000081000001";
			$mode_module = 'ordersupp';

			$peg_handler = 'invoices_toolbar_item_show_report(screen.getContainer_ID(),
																	 \'' . $id . '\',
																	 \'' . $_SESSION['peg_dic_invoices_select_item_first'] . '\',
																	 \'' . $q10nr01 . '\',
																	 \'\',
																	 \'' . $parent_d . '\',
																	 JSON.parse(\'' . $grid_columns_json . '\'));';
			$retArray[] = array(
				'xtype' => 'pegasusToolBarGridAction',
				'peg_custom_id' => $mode_module . '_show_report',
				'viewModel' => array(
					'type' => 'GridButtonModel',
					'isToolBar' => 1,
					'data' => array(
						'toolBarButton' => $mode_module . '_show_report',

					)
				),
				'icon' => 'invoices_images/a68_16x16.png',
				'text' =>  $_SESSION['peg_dic_invoices_a67_pending'],
				'peghandler' => $peg_handler
			);
		}
		if ($moduleExistsInterorder) {
			$q10nr01 = "140000103000000";
			$mode_module = 'interorder';

			$peg_handler = 'invoices_toolbar_item_show_report(screen.getContainer_ID(),
																	 \'' . $id . '\',
																	 \'' . $_SESSION['peg_dic_invoices_select_item_first'] . '\',
																	 \'' . $q10nr01 . '\',
																	 \'\',
																	 \'' . $parent_d . '\',
																	 JSON.parse(\'' . $grid_columns_json . '\'));';
			$retArray[] = array(
				'xtype' => 'pegasusToolBarGridAction',
				'peg_custom_id' => $mode_module . '_show_report',
				'viewModel' => array(
					'type' => 'GridButtonModel',
					'isToolBar' => 1,
					'data' => array(
						'toolBarButton' => $mode_module . '_show_report',

					)
				),
				'icon' => 'invoices_images/a61_16x16.png',
				'text' =>  $_SESSION['peg_dic_invoices_a61_pending'],
				'peghandler' => $peg_handler
			);
		}
	}
	return $retArray;
}

function peg_invoices_f02_d52_initialize($data = array(), $mmnr01 = '', $mnr01 = '', $_d  = '', $container_id = '')
{

	if (file_exists('../../images/invoice_logo.png')) {
		$temp_file = invoices_logo_format(900, 350);
		if ($temp_file != '') {
			$data['vshph'] = "<p style='text-align:center;'><img src='" . $temp_file . "?" . date('His') . "' /></p>";
		}
	} else {
		$data['vshph'] = "<p style='text-align:center; font-weight:bold; color:red;'>" . $_SESSION['peg_dic_invoices_img_not_found'] . "</p>";
	}
	return $data;
}

function peg_invoices_f02_d54_initialize($data = array(), $mmnr01 = '', $mnr01 = '', $_d  = '', $container_id = '')
{

	if (file_exists('../../images/invoice_watermark_logo.png')) {
		$temp_file = invoices_logo_format(900, 350, '../../images/invoice_watermark_logo.png');
		if ($temp_file != '') {
			$data['vshph'] = "<p style='text-align:center;'><img src='" . $temp_file . "?" . date('His') . "' /></p>";
		}
	} else {
		$data['vshph'] = "<p style='text-align:center; font-weight:bold; color:red;'>" . $_SESSION['peg_dic_invoices_wm_img_not_found'] . "</p>";
	}
	return $data;
}

function peg_invoices_i01_d10_initialize($data = array(), $mmnr01 = '', $mnr01 = '', $_d  = '', $container_id = '', $is_retail = 0) //retail 15/05 add parameter , $is_retail=0
{
	$peg_tmp_newrec = 0;
	if (empty($data['nr01'])) {
		$peg_tmp_newrec = 1;
		$data['nr01'] = pegasus_mysql_newrec("i01");
	}

	$data['v_i00'] = $data['p01'];

	if (empty($data['p07'])) {
		if (substr($mmnr01, 0, 3) == 'a55') {
			$data['p07'] = 2;
		}
		if (substr($mmnr01, 0, 3) == 'a56') {
			$data['p07'] = 1;
		}
		if (substr($mmnr01, 0, 3) == 'a60') {
			$data['p07'] = 3;
		}
	}
	// if (substr($mmnr01, 0, 11) == 'retail00_01') { //retail 15/05 check $is_retail=0
	if ($is_retail == 1) { //retail 15/05 check $is_retail=0
		$module_d_prefix = 'retail00_01_d03_';
	}else{
		$module_d_prefix = 'invoices_i01_d101_';
	}

	$data[$module_d_prefix . 'pd01_hidden'] = 2;

	// Μ.Κ. Κίνησης που μετασχημάτισε
	$data[$module_d_prefix . 'p3051_readonly'] = 1;
	$data[$module_d_prefix . 'p3051_hidden'] = 1;
	if (($data['p3051'] == 0)) {
		$data[$module_d_prefix . 'p3051_hidden'] = 1;
	} else if (($data['p3051'] > 0)) {
		$data['invoices_i01_d10_v_i00_readonly'] = 1;
		$data[$module_d_prefix . 'p3051_hidden'] = 0;
		if(
			(pegasus_check_permission('invcust_master') && substr($mmnr01, 0, 3) == 'a55') ||
			(pegasus_check_permission('invsupp_master') && substr($mmnr01, 0, 3) == 'a56')
		) {
			$data[$module_d_prefix . 'p3051_readonly'] = 0;
		}
	}



	$data['has_color_size']		= 0;
	$data['has_lot']			= 0;
	$data['p301_not_readonly']	= 0;
	$data['p302_not_readonly']	= 0;
	$data['p303_not_readonly']	= 0;
	$data['p304_not_readonly']	= 0;
	$data['p306_not_readonly']	= 0;
	$data['p307_not_readonly']	= 0;
	$data['p308_not_readonly']	= 0;
	$data['p309_not_readonly']	= 0;
	$data['p310_not_readonly']	= 0;


	$data['p04_readonly']   = 1;
	$data['p010_readonly']  = 1;
	$data['p010a_readonly'] = 1;
	$data['p041_readonly'] = 1;
	$data['p616_readonly']  = 1;
	$data['p042_readonly'] = 1;
	$data['p0601_readonly'] = 1;


	$data[$module_d_prefix . 'p04_readonly']   = 1;
	$data[$module_d_prefix . 'p010_readonly']  = 1;
	$data[$module_d_prefix . 'p010a_readonly'] = 1;
	$data[$module_d_prefix . 'p041_readonly']  = 1;
	$data[$module_d_prefix . 'p616_readonly']  = 1;
	$data[$module_d_prefix . 'p042_readonly']  = 1;
	$data[$module_d_prefix . 'p0601_readonly'] = 1;
	// $data[$module_d_prefix . 'p030_readonly']  = 1;


	// retail: 12/06/2023 - Πρόσθεσα && $is_retail != 1, διότι υπάρχει περίπτωση να έχω $mmnr01 = a55 και $is_retail = 1 
	// και να μου φτιάξει τα readonly για το invoices prefix αντί του retail.
	if (substr($mmnr01, 0, 3) == 'a55' && $is_retail != 1) {
		$data['readonly'] = pegasusGetGlobalVar('peg_a55_d-' . $mnr01 . '_is_readonly');
		$data = invoices_get_f02_readonly_flds($data, 'a55');
		if (($data['pd101'] == 'hota17') ||
			$data['pd101'] == 'hota04'
		) {
			if (function_exists('hot000_set_i01_d10_readonly')) {
				$data = hot000_set_i01_d10_readonly($data);
			}
		}
	} elseif ($is_retail == 1) {//retail 15/05 check  $is_retail=0
		//! RETAIL
		$data = invoices_get_f02_readonly_flds($data, 'retail00_01'); 
	} elseif (substr($mmnr01, 0, 3) == 'a60') {
		$data = invoices_get_f02_readonly_flds($data, 'a60');
		$a30_p05 = pegasus_mysql_printfld('a30', 'p05', 'a30.p01 = :p05', array("p05"=>pegasusGetGlobalVar('peg_a60_d-'.$mnr01.'_p05')));
		if($a30_p05 > 0) {
			$data[$module_d_prefix . 'vapc2_hidden'] = 0;
		} else {
			$data[$module_d_prefix . 'vapc2_hidden'] = 1;
		}		
	}else {
		$data = invoices_get_f02_readonly_flds($data, 'a56');		
	}
	
	if (substr($mmnr01, 0, 3) == 'a56') {
		$data['readonly'] = pegasusGetGlobalVar('peg_a56_d-' . $mnr01 . '_is_readonly');
	}

	if (!empty($data['p01'])) {

		//εύρεση του είδους απο την αποθήκη.
		pegasus_mysql_use('select * from i00 where pno=? ', $i00, array($data['p01']));

		//έυρεση της μοναδας μετρησης.
		pegasus_mysql_use("select * from  i24 where i24.p01=? ", $i24, array($i00['ths']));
		
		if(pegasus_module_exists('colorsize')) {
			if(
				pegasus_mysql_printfld('i47', 'count(*)', 'i00=? ', array($i00['nr01'])) > 0 &&
				$data['i18i01'] == 0
			) {
				$data['has_color_size'] = 1;
			}
		}

		$data['has_serial'] = $i00['ps01'];
		$data['has_lot']    = $i00['p904'];

		//Μοναδες μετρησης και σχέση μονάδων μετρησης
		$v_i00_p201_active = peg_invoices_v_p200_en($data['p01']) && !$data['has_color_size'] && !$data['has_serial'] && !($data['has_lot']==1 && $_SESSION['f02_p637']==1);

		$data['v_i00_ths']  = $i00['ths'];
		$data['v_i00_p200'] = $i00['p200'];
		$data['v_i00_p201'] = ($v_i00_p201_active) ? $i00['p201'] : 0;
		$data = invoices_get_readonly_flds_from_i24($data, $i24);

		$data['v_i00_p00']   = $i00['p00'];
		$data['v_i00_p9001'] = $i00['p9001'];
		$data['v_i00_p9907'] = $i00['p9907'];
	}

	if(substr($mmnr01, 0, 3) == 'a60') {
		$mode = "a60";

		$_where_eidi = pegasusGetGlobalVar('peg_a60_d-' . $mnr01 . '_where_eidi');
		$peg_tmp_a60Ar = pegasusGetGlobalVar('peg_a60_d-' . $mnr01 . '_data');

		if($peg_tmp_newrec == 1 || empty($_SESSION['f02_p633'])) {
			$data['p610']  = -1;
			$data['vapc2'] = -1;
		} else {
			if(pegasus_mysql_printfld('peg_tmp_i01', 'count(*)', $_where_eidi['sql'] . ' and peg_tmp_i01.ppnr01=:nr01', array_merge($_where_eidi['sqlParams'], array('nr01'=>$data['nr01']))) > 0) {
				$data['vapc2'] = pegasus_mysql_printfld('peg_tmp_i01', 'p610', $_where_eidi['sql'] . 'and peg_tmp_i01.ppnr01=:nr01' , array_merge($_where_eidi['sqlParams'], array('nr01'=>$data['nr01'])));
			} else {
				$data['vapc2'] = -1;
			}
		}

		$data['p05'] = $peg_tmp_a60Ar['a30p04'];

		$data[$module_d_prefix.'p042_hidden'] = 0;
	}
	if(substr($mmnr01, 0, 3) == 'a55') {
		$mode = "a55";

		if($peg_tmp_newrec == 1 || $_SESSION['f02_p633'] == 0) {
			$data['p610'] = -1;
		}

		if($_SESSION['f02_pg034'] == 1) {
			$data[$module_d_prefix.'p042_hidden'] = 0;
		} else {
			$data[$module_d_prefix.'p042_hidden'] = 1;
		}
	}
	if(substr($mmnr01, 0, 3) == 'a56') {
		$mode = "a56";

		if($peg_tmp_newrec == 1 || $_SESSION['f02_p633'] == 0) {
			$data['p610'] = -1;
		}

		if($_SESSION['f02_apg034'] == 1) {
			$data[$module_d_prefix.'p042_hidden'] = 0;
		} else {
			$data[$module_d_prefix.'p042_hidden'] = 1;
		}
	}
	
	$data['v_a90_p30'] = invoices_find_a90_p30($mode, $data['p06'], $data['nr01']);

	$data['invoices_i01_d101_p04_1_readonly'] = 1; 
	//Υπολογίζω την τιμή μονάδας όταν έχω συσκευασία
	
	//Γιατι συμβαινει το pegasus_module_exists('invspcodes')
	$data[$module_d_prefix . 'p04_1_hidden']  = 2;
	$data[$module_d_prefix . 'p030_1_hidden'] = 2;
	if(pegasus_module_exists('invspcodes')){ 
		$data[$module_d_prefix . 'p04_1_hidden']  = 0;
		$data[$module_d_prefix . 'p030_1_hidden'] = 0;
	}

	$data[$module_d_prefix . 'p04_1_readonly'] = 1; 
	//Υπολογίζω την τιμή μονάδας όταν έχω συσκευασία
	if($data['p030_1'] > 0){
		$data['p04'] = round($data['p04_1'] / $data['p030_1'], $_SESSION['inventory_000_p07']);   //Κάνουμε αυτη την στρογγυλοποιηση γιατι δεν έφερνε το ιδιο συνολο με το grid.
		// Όταν το είδος ήταν με συσκευασία και χρησιμοποιούσε κάποιος τεμάχια, ότι και αλλαγή τιμής και να έκανε όταν άνοιγε το είδος έβλεπε 1 που είναι λάθος
		// διότι τα τεμάχια ενημερωνόντουσαν και άλλη τιμή φαινόταν από grid και άλλη από μέσα.
		// $data['p301'] = 1;
		$data[$module_d_prefix . 'p04_1_readonly'] = 0;
		$data[$module_d_prefix . 'p04_readonly'] = 1;
	}
	if (!empty($data['p01'])) {
		$data['v107']  = invoices_make_product_total($data['p03'], $data['p04'], $data['p08'],  $data['p010'], $data['p010a'], $data['p041'], $data['p616'], pegasusGetGlobalVar('peg_'.substr($mmnr01, 0, 3).'_d-' . $mnr01 . '_p07'), $data['p042']);
	}

	$data['nr01'] = intval($data['nr01']);

	$service = 0;
	if (substr($mmnr01, 0, 3) == 'a55' && pegasusGetGlobalVar('peg_a55_d-' . substr($mmnr01, 6) . '_service_only') == 1) {
		$service = 1;
	}

	$mode_p05 = pegasusGetGlobalVar('peg_'.$mode.'_d-' . substr($mmnr01, 6) . '_p05');
	$old_i00  = $data['v_i00'];
	$v_i00_where = invoices_find_v_i00_where($old_i00, $service, $mode, $mode_p05);
	pegasusSetGlobalVar($container_id . '_where_v_i00', $v_i00_where);


	pegasusSetGlobalVar(
		$container_id . '_where_grid_i01_d102',
		'peg_flag!=9 and peg_tmp_i48.p01="' . $data['nr01'] . '"
			and peg_tmp_i48.peg_sess_id="' . session_id() . '"
			and peg_tmp_i48.peg_mmnr01="'  . $mmnr01 . '"
			and peg_tmp_i48.peg_mnr01="'   . $data['nr01'] . '"'
	);
	pegasusSetGlobalVar(
		$container_id . '_where_grid_i01_d103',
		'peg_flag!=9 and peg_tmp_i32.p00="' . $data['nr01'] . '"
			and peg_tmp_i32.p010="1"
			and peg_tmp_i32.peg_sess_id="' . session_id() . '"
			and peg_tmp_i32.peg_mmnr01="'  . $mmnr01 . '"
			and peg_tmp_i32.peg_mnr01="'   . $data['nr01'] . '"'
	);
	pegasusSetGlobalVar(
		$container_id . '_where_grid_i01_d104',
		'peg_flag!=9 and peg_tmp_i38.p01="' . $data['nr01'] . '"
			and peg_tmp_i38.p010="1"
			and peg_tmp_i38.peg_sess_id="' . session_id() . '"
			and peg_tmp_i38.peg_mmnr01="'  . $mmnr01 . '"
			and peg_tmp_i38.peg_mnr01="'   . $data['nr01'] . '"'
	);

	$data[$module_d_prefix . 'p081_hidden'] = 2;
	if($mode=="a55"){
		if($_SESSION['f02_pweb01']==1){
			$data[$module_d_prefix . 'p081_hidden'] = 0;	
		}
	}elseif($mode=="a56"){
		if($_SESSION['f02_pweb02']==1){
			$data[$module_d_prefix . 'p081_hidden'] = 0;	
		}
	}
	
	if(($is_retail==1 && $data['nr01'] < 0) && $_SESSION['f02_pweb01']==1) {
		// Όταν διαγράφω είδος από οθόνη Retail (nr01 = -1) θέλω να το κάνω hidden.
		$data[$module_d_prefix . 'p081_hidden'] = 2;
	}


	//Kανει hide απο τη μοναδα μετρηση τα πεδια που ειαν readonly
	$i = 0;
	while ($i < 10) {
		$i++;
		if ($data['p3' . pegasus_leading_zeros($i, 2) . '_not_readonly'] == 0) {
			$data[$module_d_prefix . 'p3' . pegasus_leading_zeros($i, 2) . '_hidden'] = 1;
		}else{
			$data[$module_d_prefix . 'p3' . pegasus_leading_zeros($i, 2) . '_hidden'] = 0;
		}
	}

	//Ε.Φ.Κ./ Μονάδα
	$data[$module_d_prefix . 'p616_hidden'] = 0;
	if(
		($mode == 'a55' && $_SESSION['f02_pg032']  == 0) || 
		($mode == 'a56' && $_SESSION['f02_apg032'] == 0)
	) {
		$data[$module_d_prefix . 'p616_hidden'] = 1;
	}	

	//Εισφορά Ανακύκλωσης
	$data[$module_d_prefix . 'p041_hidden'] = 0;
	if(
		($mode == 'a55' && $_SESSION['f02_pg030']  == 0) || 
		($mode == 'a56' && $_SESSION['f02_apg030'] == 0)
	) {
		$data[$module_d_prefix . 'p041_hidden'] = 1;
	}

	if ($data['i18i01'] > 0) { //Αν το είδος είναι από συνταγή
		$data['p01_readonly'] = 1;
		// $data['p02_readonly'] = 1;
		$data['v_i00_readonly'] = 1;
	}

	// Κανει Hide την συνταγη αν δνε εχει δεδομενα
	$data[$module_d_prefix . 'fldcont_i18_hidden'] = 0;
	$data[$module_d_prefix . 'fldcont_i1800_hidden'] = 0;
	$data[$module_d_prefix . 'i18i01_hidden'] = 0;
	$data[$module_d_prefix . 'but_clear_i18_hidden'] = 0;
	$data[$module_d_prefix . 'i19p03_hidden'] = 0;

	if (!($data['i18i01'] > 0)) { //Αν το είδος δεν είναι από συνταγή
		$data[$module_d_prefix . 'fldcont_i18_hidden'] = 1;
		$data[$module_d_prefix . 'fldcont_i1800_hidden'] = 1;
		$data[$module_d_prefix . 'i18a58_hidden'] = 1;
		$data[$module_d_prefix . 'but_clear_i18_hidden'] = 1;
		$data[$module_d_prefix . 'i19p03_hidden'] = 1;
	}

	// $lot_en = 0;
	// if(
	// 	pegasus_module_exists('lot') && 
	// 	$data['has_lot'] == 1 && 
	// 	(($mode == 'a55' || $mode == 'a56' || $mode == 'a60') && $_SESSION['f02_p637'] == 1)
	// ) {
	// 	$lot_en = 1;
	// }

	// $serial_en = 0;
	// if(
	// 	pegasus_module_exists('serial') && 
	// 	$data['has_serial'] == 1 && 
	// 	($_SESSION['f02_pg905'] == 1 || $_SESSION['f02_pg905'] == 2)
	// ) {
	// 	$serial_en = 1;
	// }

	//Δευτερεύουσα Μ.Μ.
	$data[$module_d_prefix . 'p030_hidden'] 		   = 0;
	$data[$module_d_prefix . 'v_i00_p200_hidden'] 	   = 0;
	$data[$module_d_prefix . 'fldcont_left012_hidden'] = 0;


	if(empty($i00['p200'])) {
		$data[$module_d_prefix . 'p030_hidden'] 		   = 1;
		$data[$module_d_prefix . 'v_i00_p200_hidden'] 	   = 1;
		$data[$module_d_prefix . 'fldcont_left012_hidden'] = 1;
	}

	//Σχέση Μ.Μ.
	$data[$module_d_prefix . 'v_i00_p201_hidden'] = !$v_i00_p201_active;
	if($v_i00_p201_active){
		$data[$module_d_prefix . 'p030_readonly'] = 0;
	}

	// Set params (PDO) for grid00 (i11_d50) where
	pegasusSetGlobalVar(
		$container_id . '_where_i11_d50_grid00',
		array(
			'sql' => 'i11_tot.p01=:i01_p01',
			'sqlParams'    => array(
				"i01_p01" => $data["p01"]
			)
		)
	);

	return $data;
}

function peg_invoices_i01_d11_initialize($data = array(), $mmnr01 = '', $mnr01 = '', $_d  = '', $container_id = '')
{

	if (empty($data['nr01'])) {
		$data['nr01'] = pegasus_mysql_newrec("i01");
	}
	$data['p07'] = 2;

	$data['invoices_i01_d101_pd01_hidden'] = 2; // και στην i01_pd104 αυτό το hidden διαβαζω

	$data['p103_not_readonly'] = 1; //Έχω μόνο ποσότητα στην υπηρεσία, δεν έχω πλάτος, μήκος κοκ κοκ

	if (!empty($data['p01'])) {

		//εύρεση του είδους απο την αποθήκη.
		pegasus_mysql_use('select * from i00 where pno=? ', $i00, array($data['p01']));

		//Μοναδες μετρησης και σχέση μονάδων μετρησης
		$data['v_i00_ths']  = $i00['ths'];
	}

	if (!empty($data['p01'])) {
		$data['v107']  = invoices_make_product_total($data['p03'], $data['p04'], $data['p08'],  $data['p010'], $data['p010a'], $data['p041'], $data['p616'], pegasusGetGlobalVar('peg_a55_d-' . substr($mmnr01, 0, 3) . '_p07'), $data['p042']);
	}

	/*
		*
		Οι διαφορές με την i01_d10
		Δεν εκτελώ το invoices_get_f02_readonly_flds... επομένως για εμένα ισχύει πάντα το:
		$data['p04_readonly'] = 0;
		$data['invoices_i01_d104_p04_readonly'] = 0; //Τιμή
		$data['p010_readonly'] = 0;
		$data['invoices_i01_d104_p010_readonly'] = 0; //Έκπτωση 1
		$data['p010a_readonly'] = 0;
		$data['invoices_i01_d104_p010a_readonly'] = 0; //Έκπτωση 2

		Επίσης, πάντα ισχύει
		$data['has_color_size']	= 0;
		$data['has_serial']	= 0;
		$data['p103_not_readonly']=1;
		*/

	return $data;
}

function invoices_i01_d2_initialize($data = array(), $mmnr01 = '', $mnr01 = '', $_d = '', $container_id = '')
{
	$mode = substr($mmnr01, 0, 3);

	$data['i00'] 		= $_REQUEST['p01'];		  //Είδος
	$data['p03'] 		= $_REQUEST['p03'];		  //Ποσότητα
	$data['p03_new'] 	= $_REQUEST['p03_new'];	  //Νέα Ποσότητα
	$data['p04'] 		= $_REQUEST['p04'];		  //Τιμή Μονάδας
	$data['p010'] 		= $_REQUEST['p010'];	  //Έκπτωση 1
	$data['p010a'] 		= $_REQUEST['p010a'];	  //Έκπτωση 2
	$data['p013'] 		= $_REQUEST['p013'];	  //Ημερομηνία
	$data['p042'] 		= $_REQUEST['p042'];	  //Επιπλέον Αξία
	$data['p0100'] 		= $_REQUEST['p0100'];	  //% Επιπλέον Έκπτωσης
	$data['p09'] 		= $_REQUEST['p09'];		  //Τιμή με ΦΠΑ
	$data['p610'] 		= $_REQUEST['p610'];	  //Χώρος
	$data['i01_timh1'] 	= $_REQUEST['i01_timh1']; //Κόστος
	$data['i01_timh2'] 	= $_REQUEST['i01_timh2']; //Λιανική
	$data['i01_timh3'] 	= $_REQUEST['i01_timh3']; //Χονδρική
	$data['i01_timh4'] 	= $_REQUEST['i01_timh4']; //Υπερχονδρική
	$data['timh1'] 		= $_REQUEST['timh1'];	  //Κόστος
	$data['timh2'] 		= $_REQUEST['timh2'];	  //Λιανική
	$data['timh3'] 		= $_REQUEST['timh3'];	  //Χονδρική
	$data['timh4'] 		= $_REQUEST['timh4'];	  //Υπερχονδρική
	$data['v_parent_container_id'] = $_REQUEST['parent_container_id'];

	if(in_array($mode, array("a56", "a67"))) {
		/* Τιμή Μονάδας */
		$data['p04_readonly'] = 0;
		if ($_SESSION['f02_apg02'] != 1) {
			$data['p04_readonly'] = 1;
		}

		/* % Έκπτωσης 1 */
		$data['p010_readonly'] = 0;
		if($_SESSION['f02_apg03'] != 1) {
			$data['p010_readonly'] = 1;
		}

		/* % Έκπτωσης 2 */
		$data['p010a_readonly'] = 0;
		if ($_SESSION['f02_apg033'] != 1) {
			$data['p010a_readonly'] = 1;
		}
	} else {
		/* Τιμή Μονάδας */
		$data['p04_readonly'] = 0;
		if ($_SESSION['f02_pg02'] != 1) {
			$data['p04_readonly'] = 1;
		}

		/* % Έκπτωσης 1 */
		$data['p010_readonly'] = 0;
		if ($_SESSION['f02_pg03'] != 1) {
			$data['p010_readonly'] = 1;
		}

		/* % Έκπτωσης 2 */
		$data['p010a_readonly'] = 0;
		if ($_SESSION['f02_pg033'] != 1) {
			$data['p010a_readonly'] = 1;
		}
	}

	$data['p03_new_readonly'] =	peg_invoices_v_cs_en($data['i00']) ||
		peg_invoices_v_lot_en($data['i00'], $mode) ||
		peg_invoices_v_ths_readonly($data['i00']) ||
		peg_invoices_v_p200_en($data['i00'], false)  || /* το παραπανω ειναι με false giati στην οθονη που θα εμφανιστει δεν εχουμ δευτερευουσα μοναδα μετρηση και ειναι πη δευτερευοσα παντα 0 οποτε θελω να μ επιτρεπει να αλλαζω την προτευουσα ΜΜ ασχετε εμ το αν εχιε σχεση η οχι -  προτεινω να βλαουμε δευτρευουσα και σχεση καισ την οθονη που εμφανιζετια οπως και σοτ ειδος και αν σβησσουμε την παραμετρο αποσ την συναρτηση */
		peg_invoices_v_sn_en($data['i00']) && $_REQUEST['grid_edit'] == 1;

	if($data['p03_new_readonly'] == 1) {
		$data['is_readonly_p03'] = 1;
	} else {
		$data['is_readonly_p03'] = 0;
	}

	return $data;
}


function invoices_find_v_i00_where($old_i00='', $service=0, $mode="a55", $p05=0)
{
	$v_i00_where = array();

	$old_i00_where = '';
	//π.χ. στην περίπτωση που ανοίγω παλιό παραστατικό και έχει μη ενεργό είδος
	if (pegasus_mysql_printfld('i00', 'nr01', 'pno=?', array($old_i00)) > 0) {
		$old_i00_where = " or (i00.pno = :v_i00)";
		$old_i00_where_arr = array('v_i00' => $old_i00);
	}
	if ($service == 1) {
		$v_i00_where = inventory01_query_where_of_i00();
		if (!empty($v_i00_where['sql'])) {
			$v_i00_where['sql'] .= " AND ";
		}
		$v_i00_where['sql'] .= " i00.p203 <> 1 ";
		if (!empty($old_i00_where)) {
			$v_i00_where['sql'] = " ( (" . $v_i00_where['sql'] . ") " . $old_i00_where . ") ";
			$v_i00_where['sqlParams'] = array_merge((array)$v_i00_where['sqlParams'], $old_i00_where_arr);
		}
	} else {
		$v_i00_where['sql'] = " i00.p203 <> 1 ";
		if (!empty($old_i00_where)) {
			$v_i00_where['sql'] = "( (" . $v_i00_where['sql'] . ") " . $old_i00_where . " )";
			$v_i00_where['sqlParams'] = $old_i00_where_arr;
		}
	}

	if($p05>0){
		if ($mode == "a56"){
			$p32 = pegasus_mysql_printfld('a11', 'p32', 'p01=:var_p05', array("var_p05"=>$p05));
		}elseif ($mode == "a55"){
			$p32 = pegasus_mysql_printfld('a10', 'p32', 'p01=:var_p05', array("var_p05"=>$p05));
		}
		$i10_nr01_arr = array_filter(explode('#', $p32)); 		
		$i10_nr01_in = pegasus_mysql_create_in($i10_nr01_arr, 'i10_nr01');
		if(!empty($i10_nr01_in['sql'])){
			if(!empty( $v_i00_where['sql'])){
				$v_i00_where['sql'] .= " AND ";
			}
			$v_i00_where['sql'] = " i00.p62 in ( ". $i10_nr01_in['sql'] . ") AND i00.p203 <> 1";
			$v_i00_where['sqlParams'] = array_merge((array)$v_i00_where['sqlParams'], $i10_nr01_in['sqlParams']);
		}
		
	}

	return $v_i00_where;
}

function peg_invoices_invoices_mass_sel_product_d_initialize($data, $mmnr01, $mnr01, $_d, $container_id)
{

	// if (substr($mmnr01, 0, 3) == 'a55') {
	// 	$nr01 = substr($mmnr01, 6);
	// 	if (pegasusGetGlobalVar('peg_a55_d-' . $nr01 . '_service_only') == 1) {
	// 		pegasusSetGlobalVar($container_id . '_where_grid', inventory01_query_where_of_i00());
	// 	}
	// }

	$mode = substr($mmnr01, 0, 3);
	$service  = pegasusGetGlobalVar('peg_'.$mode.'_d-' .substr($mmnr01, 6) . '_service_only');
	$mode_p05 = pegasusGetGlobalVar('peg_'.$mode.'_d-' .substr($mmnr01, 6) . '_p05');

	$v_i00_where = invoices_find_v_i00_where('', $service, $mode, $mode_p05);
	pegasusSetGlobalVar($container_id . '_where_grid', $v_i00_where);

	return $data;
}
function invoices__invoices_find_invoice_earn_d_initialize($data, $mmnr01, $mnr01, $_d, $container_id)
{
	$data['readonly'] = 1;

	return $data;
}


/***/
function invoices_check_for_new_p03(
	$data = array(),
	$mode = ''
) {
	$p05 = $data['p05'];
	$p03 = $data['p03'];
	if(
		!($p05>0)
		|| !in_array($mode,array('a55', 'a56', 'a57', 'a67', 'retail00_01'))
	) {
		return array();
	}
	$p05_tbl_name = '';
	switch($mode) {
		case 'a55' :
		case 'retail00_01': 
			$p05_tbl_name = 'a10';
			$p03_tbl_name = 'a01';
			break;
		case 'a57' :
			$p05_tbl_name = 'a10';
			$p03_tbl_name = 'a01';
			break;
		case 'a56' :
			$p05_tbl_name = 'a11';
			$p03_tbl_name = 'a00';
			break;
		case 'a67' :
			$p05_tbl_name = 'a11';
			$p03_tbl_name = 'a00';
			break;
	}
	$p05_tbl = array();
	pegasus_mysql_use("SELECT * FROM $p05_tbl_name WHERE p01 = :p01",$p05_tbl,array('p01' => $p05));
	if(
		!($p05_tbl[$p03_tbl_name] > 0)
		|| $p05_tbl[$p03_tbl_name]== $p03
	) {
		return array();
	}
	$p03_tbl_p19 = pegasus_mysql_printfld($p03_tbl_name,'p19','nr01 = :nr01',array('nr01' => $p05_tbl[$p03_tbl_name]));
	$msg = $_SESSION['peg_dic_invoices_check_for_new_'.$p03_tbl_name]." ".$p03_tbl_p19;
	return array(
		'confirm_new_p03'	=> true,
		'p03'				=> $p05_tbl[$p03_tbl_name],
		'p03_display'		=> $p03_tbl_p19,
		'message'			=> $msg
	);
}
function invoices_find_p05_data($data, $mode,$set_new_p03_data_from_p05 = false)
{
	global $PegInput;

	if($mode == 'retail00_01') {
		$mode = 'a55';
	}
	/* Αρχικοποίηση μεταβλητών */
	$p03   			= $data['p03'];				// Πελάτη || Προμηθευτή  (a01 || a00).nr01
	$p04    		= intval($data['p04']);		// Υποκαταστήμα Πελάτη || Προμηθευτή 
	$p05    		= $data['p05'];				// Κωδικός Ορισμoύ Παραστατικού Πελάτη || Προμηθευτή || Εσωτερικής Διακίνησης (a10 || a11 || a30).p01
	$nr01   		= $data['nr01'];			// M.K. Παραστατικού (a55 || a56 || a60 || a57 || a67 || a61).nr01
	$p05_tbl_name	= '';						// Όνομα Πίνακα Ορισμού Παραστατικού (a10 || a11 || a30)
	$p05_tbl		= array();					// Ορισμός Παραστατικού (Πελάτη || Προμηθευτή || Εσωτερικής Διακίνησης)
	$p03_tbl		= array();					// Πελάτης | Προμηθευτής (a01 || a00)
	$vp04			= '';
	switch($mode) {
		case 'a55' :	// Παραστατικά Πελατών
			$p05_tbl_name = 'a10';	// Ορισμός παραστατικών πελατών
			$p03_tbl_name = 'a01';	// Πελάτες
			break;
		case 'a56' :	// Παραστατικά Προμηθευτών
			$p05_tbl_name = 'a11';	// Ορισμός παραστατικών προμηθευτών
			$p03_tbl_name = 'a00';	// Προμηθευτές
			break;
		case 'a60' :	// Παραστατικά Εσωτερικής Διακίνησης
			$p05_tbl_name = 'a30';	// Ορισμός Παραστατικών Εσωτερικής Διακίνησης
			break;
		case 'a57' : 	// Παραγγελίες Πελατών
			$p05_tbl_name = 'a10';	// Ορισμός παραστατικών πελατών
			$p03_tbl_name = 'a01';	// Πελάτες
			break;
		case 'a67' :	// Παραγγελίες Σε Προμηθευτές
			$p05_tbl_name = 'a11';	// Ορισμός παραστατικών προμηθευτών
			$p03_tbl_name = 'a00';	// Προμηθευτές
			break;
		case 'a61' :	// Εσωτερικές Παραγγελίες
			$p05_tbl_name = 'a30';	// Ορισμός Παραστατικών Εσωτερικής Διακίνησης
			break;
	}
	
	$return_array	= array();					// Return array

	// Όρισμός Παραστατικού (a10 || a11 || a30)
	if($p05_tbl_name != '') {
		pegasus_mysql_use(
			"	SELECT * FROM $p05_tbl_name WHERE p01 = :p01",
			$p05_tbl,
			array('p01' => $p05)
		);
	}

	// $return_array['p07']  = -1;
	if(
		in_array($mode,array('a55','a56','a57','a67'))
		&& $set_new_p03_data_from_p05 == true
		&& $p05_tbl[$p03_tbl_name] > 0
		&& $p05_tbl[$p03_tbl_name] != $p03
	) {
			$data['p03'] = $p05_tbl[$p03_tbl_name];
			$p03 = $data['p03'];

			$return_array = invoices_find_p03_data($data,$mode);

			$return_array['p03_display'] = pegasus_mysql_printfld($p03_tbl_name,'p19','nr01 = :nr01',array('nr01' => $p05_tbl[$p03_tbl_name]));
	}else{
		if($p05_tbl['p601'] == 1){
			$return_array['p07']  = 1;
		}elseif($p05_tbl['p601'] == 2){
			$return_array['p07']  = 0;
		}
		invoices_set_p015_global_var($data, $mode);
	}

	// Global Vars
	switch($mode) {
		case 'a55' :	// Παραστατικά Πελατών
			pegasusSetGlobalVar('peg_a55_d-' . $nr01 . '_p03', $p03);
			pegasusSetGlobalVar('peg_a55_d-' . $nr01 . '_p05', $p05);
			break;
		case 'a56' :	// Παραστατικά Προμηθευτών
			pegasusSetGlobalVar('peg_a56_d-' . $nr01 . '_p03', $p03);
			pegasusSetGlobalVar('peg_a56_d-' . $nr01 . '_p05', $p05);
			break;
		case 'a60' :	// Παραστατικά Εσωτερικής Διακίνησης
			pegasusSetGlobalVar('peg_a60_d-' . $nr01 . '_p05', $p05);
			break;
		case 'a57' : 	// Παραγγελίες Πελατών
			pegasusSetGlobalVar('peg_a57_d-' . $nr01 . '_p03', $p03);
			pegasusSetGlobalVar('peg_a57_d-' . $nr01 . '_p05', $p05);
			break;
		case 'a67' :	// Παραγγελίες Σε Προμηθευτές
			pegasusSetGlobalVar('peg_a67_d-' . $nr01 . '_p03', $p03);
			pegasusSetGlobalVar('peg_a67_d-' . $nr01 . '_p05', $p05);
			break;
		case 'a61' :	// Εσωτερικές Παραγγελίες
			pegasusSetGlobalVar('peg_a61_d-' . $nr01 . '_p05', $p05);
			break;
	}
	// Πελάτης p03_tbl από p03 για Παραστατικά και Παραγγελιες Πελάτη
	if (
		$p03 > 0
		&& in_array($mode,array('a55','a57'))
	) {
		// Πελάτης
		pegasus_mysql_use("SELECT * FROM a01 WHERE nr01=? ", $p03_tbl, array($p03));
		// Υποκατάστημα Πελάτη / Διεύθυνση
		$vp04 = trim(pegasus_mysql_printfld('a71', 'p603', 'nr01=? ', array($p04)));
	}
	// Προμηθευτής p03_tbl από p03 για Παραστατικά και Παραγγελιες Προμηθευτής
	elseif (
		$p03 > 0
		&& in_array($mode,array('a56','a67'))
	) {
		// Προμηθευτής
		pegasus_mysql_use("SELECT * FROM a00 WHERE nr01= ? ", $p03_tbl, array($p03));
		// Υποκατάστημα Προμηθευτή / Διεύθυνση
		$vp04 = trim(pegasus_mysql_printfld('a76', 'p603', 'nr01=? ', array($p04)));
	}
	// ~~ %Κράτησης ~~
	$return_array['p0112'] = $p05_tbl['p204'];		// %Κράτησης
	// %Κράτησης fallback from (a01 || a00).p521
	if (
		!($return_array['p0112'] > 0)
		&& $p03_tbl['p521'] > 0
	) {
		$return_array['p0112'] = $p03_tbl['p521'];	// % Κρατήσεων
	}
	// ~~ % Φόρου ~~~
	$return_array['p0113'] = $p05_tbl['p205'];		// % Φόρου
	// % Φόρου fallback from (a01 || a00).p522
	if (
		!($return_array['p0113'] > 0)
		&& $p03_tbl['p522'] > 0
	) {
		$return_array['p0113'] = $p03_tbl['p522'];	// % Φόρου
	}

	// Κατάργηση με την αρχικοποίηση του κατάστηματος με -1 (Ε:10000058) 
	//REM $p0121  		= $data['p0121'];			
	//REM $return_array['p0121'] = $p0121;

	// ~~~ Κατάστημα ~~~
	// Κωδικός Καταστήματος Παραστατικού (a55 || a56 || a60 || a57 || a67 || a61).p0121
	$return_array['p0121'] = $p05_tbl['p010'];	// Κωδ.Καταστήματος (a10 || a11 || a30).p010
	// Κατάστημα fallback from cor003.p104 (Βασικές Παράμετροι Τερματικών / Κατάστημα)
	// Μόνο αν (a10 || a11 || a30).p010 == -1.
	if($p05_tbl['p010'] == -1) {
		$return_array['p0121'] = $_SESSION['cor003_p104'];	// Τερμματικό / Κατάστημα cor003.p104
	}
	// ~~~ Κωδ.Καθεστώτος ΦΠΑ ~~~
	if (
		isset($p05_tbl['p33']) 			// Επιτρεπτά Καθεστώτα ΦΠΑ
		&& !empty($p05_tbl['p33'])
	) {
		// O Κωδ.Καθεστώτος ΦΠΑ (p09 N:2:0) δεν πρέπει να είναι κενός
		// Αν δεν υπάρχει ο Κωδ. καθεστώτος ΦΠΑ μέσα στους  επιτρεπτούς τοτε βάζουμε τον πρώτο από τους επιτρεπτούς.
		if (strpos($p05_tbl['p33'], '#' . $data['p09'] . '#') === false) {
			$valid_rate = explode('#', trim($p05_tbl['p33'],'#'));
			$return_array['p09'] = $valid_rate[0];
		}
	}
	//Εσωτερικές Παραγγελίες και Παραστατικα Εσωτερικής Διακίνησης
	if(in_array($mode,array('a61','a60'))) {
		//	~~~ Αποθήκη 1 & Αποθήκη 2
		$return_array['p03']  = $p05_tbl['p104'];  // Αποθήκη 1 (a30.p104)
		$return_array['p04']  = $p05_tbl['p105'];  // Αποθήκη 2 (a30.p105)

		//ΚΚ Αποθήκης 2
		$a30_p05 = pegasus_mysql_printfld('a30', 'p05', 'a30.p01 = :p05', array("p05"=>$p05));
		$return_array['a30_p05'] = $a30_p05; //ΚΚ Αποθήκης 2		
		// Αν δεν υπαρχει η Αποθήκη 1 στον πινακα αποθηκών και υπαρχει η αποθήκη του Τερματικου
		if(
			!(pegasus_mysql_printfld('i16', 'nr01', 'p00=?', array($return_array['p03']))  > 0)
			&& pegasus_mysql_printfld('i16', 'nr01', 'p00=?', array($_SESSION['cor003_p105']))  > 0
		) {
			$return_array['p03'] = $_SESSION['cor003_p105'];	// Αποθηκευτικός Χώρος cor003.p105
		}
		// Αν δεν υπαρχει η Αποθήκη 2 στον πινακα αποθηκών και υπαρχει η αποθήκη του Τερματικου
		if(
			!(pegasus_mysql_printfld('i16', 'nr01', 'p00=?', array($return_array['p04']))  > 0)
			&& pegasus_mysql_printfld('i16', 'nr01', 'p00=?', array($_SESSION['cor003_p105']))  > 0
		) {
			$return_array['p04'] = $_SESSION['cor003_p105'];	// Αποθηκευτικός Χώρος cor003.p105
		}
		$query_table = ' (' . peg_inventory_get_warehouses_query($_SESSION['peg_dic_interorder_default_warehouse']) . ') as i16_00 ';
		$return_array['p03_i16p01'] = pegasus_mysql_printfld($query_table, 'p01', 'p00=?', array($return_array['p03'])); // Αποθηκευτικοί Χώροι / Περιγραφή
		$return_array['p04_i16p01'] = pegasus_mysql_printfld($query_table, 'p01', 'p00=?', array($return_array['p04'])); // Αποθηκευτικοί Χώροι / Περιγραφή

		// ~~~ Σκοπός Διακίνησης ~~~
		$return_array['p012'] = $p05_tbl['p106'];	
	} else {
		// ~~ Κωδ.Αποθήκης ~~
		if ($p05_tbl['p09'] > -1) {
			$return_array['p703']  = $p05_tbl['p09'];  // Κ.Κ.Αποθ. Χώρου
		}
		// Κωδ.Αποθήκης fallback from cor003.p105
		if(
			!isset($return_array['p703'])
			|| $p05_tbl['p09'] == -1
		) {
			$return_array['p703'] = $_SESSION['cor003_p105'];	// Αποθηκευτικός Χώρος
		}

		// ~~~ Σκοπός Διακίνησης ~~~
		$return_array['p012'] = $p05_tbl['p104'];		
	}

	//	Αν δεν είναι παραστατικό η παραγγελια Εσωτερικής διακίνησης
	if(!in_array($mode,array('a60','a61'))) {
		$peg_str = $_SESSION['peg_dic_invoices_144'];	// Έδρα σας
		$a01p40 =  implode(' ',array(
			$p03_tbl['p40'],	// Παράδοση Εμπορευμάτων
			$p03_tbl['p41'], 	// Παράδοση Εμπορευμάτων 2
			$p03_tbl['p42']		// Παράδοση Εμπορευμάτων 3
		));
		// (Από - Προς) Από Πελάτη || Προμηθευτή
		if (!empty(trim($a01p40)) && $p03_tbl_name == "a01") {
			$peg_str = $a01p40;
		}
		// (Από - Προς) Από Υποκατάστημα
		if (!empty($vp04)) {
			$peg_str = $vp04;
		}
		// Κατάστημα / Λεκτικό Από-Προς
		if(pegasus_module_exists('stores')){
			$peg_str1 = pegasus_mysql_printfld('t07', 'p05', 'p01=? ', array($return_array['p0121']));
		}
		if (empty($peg_str1)) {
			$peg_str1 = $_SESSION['peg_dic_invoices_145'];	// Έδρα μας
			if (!empty($_SESSION['cor000_lektiko'])) {
				$peg_str1 = $_SESSION['cor000_lektiko'];
			}
		}
		// Από - Προς
		$return_array['p014'] = '';
		$return_array['p013'] = '';
		//Η Εδρα Προμηθευτή Ενημερώνει το Aπό
		if ($p05_tbl['p103'] == 1) {
			$return_array['p014'] = $peg_str1;
			$return_array['p013'] = $peg_str;
		}
		// Η Εδρα Προμηθευτή Ενημερώνει το Πρός
		elseif ($p05_tbl['p103'] == 2) {
			$return_array['p014'] = $peg_str;
			$return_array['p013'] = $peg_str1;
		}

		//Ο Απ. Χώρος ενημερώνει το Aπό
		if ($p05_tbl['p114'] == 1) {
			pegasus_mysql_use("SELECT p02, p03, p7 FROM i16 WHERE p00 = ?", $i16, array($return_array['p703']));
			if(!empty($i16)){
				$return_array['p013'] = $i16['p02'].' '.$i16['p03'].' '.$i16['p7'];
			}
		}
		// Ο Απ. Χώρος ενημερώνει το Πρός
		elseif ($p05_tbl['p114'] == 2) {
			pegasus_mysql_use("SELECT p02, p03, p7 FROM i16 WHERE p00 = ?", $i16, array($return_array['p703']));
			if(!empty($i16)){
				$return_array['p014'] = $i16['p02'].' '.$i16['p03'].' '.$i16['p7'];
			}
		}
	}
	//Tρόπος είσπραξης
	if ($p05_tbl['p011'] > 0) {
		$return_array['p015'] = $p05_tbl['p011'];

		if($mode == 'a55' || $mode == 'a57' || $mode == 'a56' || $mode == 'a67') {
			if($mode == 'a55' || $mode == 'a57') {
				$tbl = 'a14';
			}elseif ($mode == 'a56' || $mode == 'a67') {
				$tbl = 'a15';
			}
			
			$ttt = array();

			$p015_where = pegasusGetGlobalVar('peg_'. $data['nr01'] . '_' . $mode . '_p015_where');
			if(!empty($p015_where)) { // Στο retail είναι κενό.
				pegasus_mysql_use('SELECT GROUP_CONCAT(nr01 SEPARATOR ",") AS nr01s FROM '.$tbl.' WHERE ' . $p015_where['sql'], $ttt, $p015_where['sqlParams']);
			
				$a14_nr01s = array_filter(explode(',', $ttt['nr01s']));
				if(!in_array($return_array['p015'], $a14_nr01s)) {
					$return_array['p015'] = 0;
				}
			}
		}
	}
	// Αν είναι παραστατικό
	if (in_array($mode, array('a55', 'a56', 'a60'))) {
		// ~~~ Χειρόγραφο ~~~
		if($mode == "a60") {
			$return_array['p08'] = $p05_tbl['p202'];	//Χειρόγραφο
		} else {
			$return_array['p08'] = $p05_tbl['p203'];	//Χειρόγραφο
		}
		
		// ~~~ Σειρά ~~~
		// Σειρά
		$PegInput->addVar(new peg_input_alphanumeric('p701', 'request'));
		$return_array['p701'] = trim($PegInput->getRequest('p701'));
		// Αν είναι παραστατικό Πελάτη ή Προμηθευτή και το (a10 || a11).p109 δεν εναι '****'
		if(
			in_array($mode,array('a55','a56'))
			&& !empty($p05_tbl)
			&& $p05_tbl['p109'] != '****'
		) {
			$return_array['p701'] = $p05_tbl['p109'];
		}
		// Σειρά (p701) fallback από cor003.p105
		else {
			$return_array['p701'] = $_SESSION['cor003_p101'];
		}
	}
	if (in_array($mode,array('a55','a56'))) {
		$invoice_num_arr = invoices_refresh_invoice_num(
			$mode,
			$data['nr01'],
			$p05,
			$return_array['p701'],
			$return_array['p0121'],
			$return_array['p08']
		);
		//Η συνάρτηση κάνει όλους τους ελέγχους αν ειναι χειρόγραφο, νέο παραστατικό κοκ
		//και αν πρέπει να αλλάξει, ενημερώνει το change_value
		if ($invoice_num_arr['change_value'] == 1) {
			$return_array['p06'] = $invoice_num_arr['p06'];
		}
	}
	foreach ($return_array as $key => $value) {
		$data[$key] = $value;
	}
	// Καθεστώτος ΦΠΑ
	if (isset($data['p09'])) {
		$data['p09_display'] = pegasus_mysql_printfld('a26', 'p02', 'p01=:p01', array('p01' => $data['p09']));
	}
	// Κατάστημα
	if (pegasus_module_exists('stores') && isset($data['p0121'])) {
		$data['p0121_display'] = pegasus_mysql_printfld('t07', 'p02', 'p01=:p01', array('p01' => $data['p0121']));
	}
	// Αποθηκευτικός Χώρος
	if (isset($data['p703'])) {
		$data['p703_display'] = pegasus_mysql_printfld('i16', 'p01', 'p00=:p00', array('p00' => $data['p703']));
	}
	// Τρόπος Είσπραξης 
	if (isset($data['p015'])) {
		$data['p015_display'] = pegasus_mysql_printfld('a14', 'p01', 'nr01=:nr01', array('nr01' => $data['p015']));
	}
	if(in_array($mode,array('a55','a56','a57','a67'))) {
		if($p03_tbl['p805'] == 1 || $p05_tbl['p012'] == 1) {
			$data['p805'] = 1;
		} else {
			$data['p805'] = 0;
		}

		//Δεν υπολογίζεται η εισφορά ανακύκλωσης
		pegasusSetGlobalVar('peg_'.$mode.'_d-' . $data['nr01'] . '_p805', $data['p805']);
		//Περιέχει ΦΠΑ το παραστατικό
		pegasusSetGlobalVar('peg_'.$mode.'_d-' . $nr01 . '_p07', $return_array['p07']);
		//Κωδικός παραστατικού
		pegasusSetGlobalVar('peg_'.$mode.'_d-' . $nr01 . '_p05', $p05);

		// Προεπιλεγμένα Είδη του παραστατικού
		if(function_exists('invoices_i01_from_axx_p500')) {
			$resp=invoices_i01_from_axx_p500(
				$mode,
				$data['nr01'],
				$data['p05'],
				$data['p09']
			);
		}
		// Προεπιλεγμένοι φόροι - Κρατήσεις του παραστατικού
		if(function_exists('invoices_i01_from_axx_p501')) {
			$resp=invoices_i01_from_axx_p501(
				$mode,
				$data['nr01'],
				$data['p05']
			);
		}
		
		invoices_update_efk($data['nr01'], $mode, $p05_tbl['p206'], $return_array['p07']);
	}

	invoices_update_zero_prices_for_items($data['nr01'], $mode, $p05_tbl['p107']);

	$data['p107'] = $p05_tbl['p107'];

	// Είναι ο ίδιος έλεγχος που κάνει στην αρχή για το αν θα καλέσει find_p03_data
	if(
		in_array($mode,array('a55','a56','a57','a67'))
		&& $set_new_p03_data_from_p05 == true
		&& $p05_tbl[$p03_tbl_name] > 0
		&& $p05_tbl[$p03_tbl_name] != $p03
	){
		// Nothing
	}else{
		$address_array = invoices_calc_diakinisi_fields($data, $mode);
		$data = array_merge($data, $address_array);
	}

	return $data;
}

/***/
function invoices_find_p03_data($data, $mode)
{
	if($mode == 'retail00_01') {
		$mode = 'a55';
	}
	if(!pegasus_module_exists('stores')){
		$data['p415'] = 0;
		$data['p416'] = 9999999999;
	}

	$p03     = $data['p03'];
	//Υποκατάστημα
	$p04     = $data['p04'];
	//Κατάστημα Από
	$p415    = $data['p415'];
	//Κατάστημα Έως
	$p416    = $data['p416'];
	$nr01    = $data['nr01'];
	//Ημερομηνία
	$p01     = $data['p01'];
	//Ώρα
	$p02     = $data['p02'];
	//container_id
	$container_id = $data['container_id'];

	if($mode == 'a55') {
		pegasusSetGlobalVar('peg_a55_d-' . $nr01 . '_p03', $p03);
		// Κανουμε set το where για το οχημα του πελατη
		if ($data['p705'] > 0) {
			$where_p705 = array(
				'sql'=> '((erpa02.p03 = :var_p03  and erpa02.p010=0) OR erpa02.nr01= :var_p705) ',
				'sqlParams'=> array('var_p03' => $data['p03'], 'var_p705'=>$data['p705'])
			);
		}else{
			$where_p705 = array(
				'sql'=> ' erpa02.p03 = :var_p03 and  erpa02.p010=0',
				'sqlParams'=> array('var_p03' => $data['p03'])
			);
		}
		pegasusSetGlobalVar($container_id . '_where_p705', $where_p705);
	
	} else if($mode == 'a56') {
		pegasusSetGlobalVar('peg_a56_d-' . $nr01 . '_p03', $p03);
	} else if($mode == 'a57') {
		pegasusSetGlobalVar('peg_a57_d-' . $nr01 . '_p03', $p03);
		// Κανουμε set το where για το οχημα του πελατη
		if(!empty($data['container_id'])){
			if ($data['p705'] > 0) {
				$where_p705 = array(
					'sql'=> '((erpa02.p03 = :var_p03  and erpa02.p010=0) OR erpa02.nr01= :var_p705) ',
					'sqlParams'=> array('var_p03' => $data['p03'], 'var_p705'=>$data['p705'])
				);
			}else{
				$where_p705 = array(
					'sql'=> ' erpa02.p03 = :var_p03 and  erpa02.p010=0',
					'sqlParams'=> array('var_p03' => $data['p03'])
				);
			}
			pegasusSetGlobalVar($container_id . '_where_p705', $where_p705);
		}
	} else if($mode == 'a67') {
		pegasusSetGlobalVar('peg_a67_d-' . $nr01 . '_p03', $p03);
	}

	invoices_set_p015_global_var($data, $mode);


	$return_array = array();
	$preview_wthfpa = $_SESSION['f02_p06'];

	$return_array['p07']   = $preview_wthfpa;  //times me FPA
	$return_array['p09']   = 1;  //Kathestos FPA
	$return_array['p015']  = 0;  //tropos eispraxis
	$return_array['p016']  = 0;  //Politis
	$return_array['p412']  = 0;  //Pistotiko orio
	$return_array['p411']  = 0;  //Proigoymeno ypoloipo
	$return_array['p417']  = 0;  //Proigoymeno ypoloipo
	$return_array['p0101'] = 0;  //Synolikh ekptosh
	$return_array['p0112'] = 0;  //Kratiseis
	$return_array['p0113'] = 0;  //Foros
	$return_array['p704']  = 0;  //Δεν ενημερώνει πόντους
	$return_array['p703']  = $data['p703'];  // Αποθήκη
	$return_array['p0121'] = $data['p0121']; // Κατάστημα

	$return_array['clear_p04'] = 0;
	//Eυρεση πελάτη ή προμηθευτή
	if ($p03 > 0) {

		if ($mode == 'a55' or $mode == 'a57') {
			pegasus_mysql_use("select
				a01.*,
				a77.p01 as p803c_display ,
				a14.p01 as p02_display ,
				a26.p02 as p45_display

				from a01
					left join a77 on a77.nr01=a01.p803c
					left join a14 on a14.nr01=a01.p02
					left join a26 on a26.p01=a01.p45

				where a01.nr01=? ", $tbl_p03, array($p03));
		}

		if ($mode == 'a56' or $mode == 'a67') {
			pegasus_mysql_use("select
				a00.*,
				a77.p01 as p803c_display,
				a15.p01 as p02_display ,
				a26.p02 as p45_display

				from a00
					left join a77 on a77.nr01=a00.p803c
					left join a15 on a15.nr01=a00.p02
					left join a26 on a26.p01=a00.p45

				where a00.nr01=? ", $tbl_p03, array($p03));
		}

		$return_array['p805'] = 0;
		if($tbl_p03['p805'] == 1) {
			$return_array['p805'] = 1;
		}

		//ευρεση Τιμοκαταλόγου
		$tbl_p03_p48 = $tbl_p03['p48'];
		if (empty($tbl_p03_p48)) {
			$tbl_p03_p48 = $_SESSION['customers_000_p02'];
		}

		if (empty($tbl_p03_p48)) {
			$tbl_p03_p48 = 2;
		}

		//Timokatalogos
		if ($tbl_p03_p48 > 0) {
			pegasus_mysql_use(' select * from i23 where p01=? ', $i23, array($tbl_p03_p48));
			$wthfpa = $i23['p03'];
			$preview_wthfpa = $i23['p05'];
		}

		//Eidikos Timokatalogos
		if ($tbl_p03['p06'] > 0 and pegasus_module_exists('invprices')) {
			pegasus_mysql_use(' select * from i14 where p01=? ', $i14, array($tbl_p03['p06']));
			$preview_wthfpa = $i14['p05'];
		}

		$return_array['p07']  = $preview_wthfpa;  //times me FPA
		$return_array['p09']  = $tbl_p03['p45'];  //Kathestos FPA
		$return_array['p09_display']  = $tbl_p03['p45_display'];  //Kathestos FPA Περιγραφη
		$return_array['p015'] = $tbl_p03['p02'];  //Τρόπος είσπαραξης ή πληρωμης \
		$return_array['p015_display'] = $tbl_p03['p02_display'];  //Τρόπος είσπαραξης ή πληρωμης Περιγραφη

		if($return_array['p015'] > 0 && !empty($data['p05'])) { // Αν δεν έχει συμπληρωθεί τύπος παραστατικού δεν θέλω να μπει εδώ για να μου φέρει το default του πελάτη.
			if($mode == 'a55' || $mode == 'a57' || $mode == 'a56' || $mode == 'a67') {
				if($mode == 'a55' || $mode == 'a57') {
					$tbl = 'a14';
				}elseif ($mode == 'a56' || $mode == 'a67') {
					$tbl = 'a15';
				}
							
				$ttt = array();

				$p015_where = pegasusGetGlobalVar('peg_'. $data['nr01'] . '_' . $mode . '_p015_where');
				if(!empty($p015_where)) { // Στο retail είναι κενό.
					pegasus_mysql_use('SELECT GROUP_CONCAT(nr01 SEPARATOR ",") AS nr01s FROM '.$tbl.' WHERE ' . $p015_where['sql'], $ttt, $p015_where['sqlParams']);
				}

				$a14_nr01s = array_filter(explode(',', $ttt['nr01s']));
				if(!in_array($return_array['p015'], $a14_nr01s)) {
					$return_array['p015'] = 0;
					$return_array['p015_display'] = '';
				}
			}
		}

		$return_array['p412'] = $tbl_p03['p27'];  //Pistotiko orio


		$return_array['p706c'] = $tbl_p03['p803c']; /* diataxi apolagis FPA*/
		$return_array['p706c_display'] = $tbl_p03['p803c_display']; /* diataxi apolagis FPA*/
		$return_array['p707'] = $tbl_p03['p804']; /* arithmos forologikis kartas*/

		$return_array['p411'] = account_find_balance($tbl_p03['p21'], 0,  9999999999, $p01, $p02, $nr01, 0, $mode); //Proigoymeno ypoloipo
		$return_array['p417'] = account_find_balance($tbl_p03['p21'], $p415,  $p416, $p01, $p02, $nr01, 0, $mode); //Topiko ypoloipo

		$return_array['p413'] = 0; // Νέο Υπόλοιπο
		$return_array['p418'] = 0; // Νέο Τοπικό Υπόλοιπο

		$return_array['p0101'] = $tbl_p03['p520']; //Synolikh ekptosh
		$return_array['p0112'] = $tbl_p03['p521']; //Kratiseis
		$return_array['p0113'] = $tbl_p03['p522']; //Foros


		$return_array['p704'] = $tbl_p03['p0401']; //Symetexoyn oi pontoi

		if ($tbl_p03['pl31'] == 1) {
			$return_array['p30'] = preg_replace( "/\n/", "<br/>", $tbl_p03['p31']);
		}

		$return_array['p017'] =	$tbl_p03['p361']; // tropos apostolis
		$return_array['a01p40'] = peg_substr(trim($tbl_p03['p40']) . ' '  .  trim($tbl_p03['p41'])  .  ' '  . trim($tbl_p03['p42']), 0, 40); // skopos diakisnhshs

		if(in_array($mode,array('a55', 'a57', 'a56', 'a67'))) {
			$resp = invoices_find_politis($p03,$mode);
			$return_array['p016'] = $resp['data']['p016'];
			$return_array['p016_display'] = $resp['data']['p016_display'];
		}


		if (pegasus_module_exists('giftcards') and ($mode == 'a55' or $mode == 'a57')) {
			$return_array['vp506_2'] =  giftcards_find_total_points($p03);

			//p506 where
			if(!empty($data['p03'])) {
				pegasusSetGlobalVar(
					$data['container_id'] . '_where_p506',
					array(	'sql'		=>	" (erpa80.p01 = :a55_p03 OR erpa80.p13 = 1) AND erpa80.p09 = 0 ",
							'sqlParams'	=>	array(
								'a55_p03' => $data['p03'], 
							) 
				));
			}
			$return_array['p506'] = $data['p506'];
			if(!empty($data['p506'])) {
				$tmp_p506 = pegasus_mysql_printfld(
					'erpa80', 
					'nr01', 
					'(erpa80.p01 = :a55_p03 OR erpa80.p13 = 1) AND erpa80.p09 = 0 AND erpa80.nr01 = :a55_p506',
					array('a55_p03' => $data['p03'], 'a55_p506' => $data['p506'])
				);
				if(empty($tmp_p506)) {
					$return_array['p506'] = '';
				}
			}
		}


		if (!empty($tbl_p03['p101']) && ($data['p05'] != $tbl_p03['p101'])) {
			$return_array['p05'] = $tbl_p03['p101'];
			
			if(in_array($mode, array("a55", "a57"))) {
				$tbl_p05 = "a10";
			} 
			
			if(in_array($mode, array("a56", "a67"))) {
				$tbl_p05 = "a11";
			}

			if(!empty($tbl_p05)) {
				$query = "SELECT p010, p09 FROM $tbl_p05 WHERE p01 = :p05";
				pegasus_mysql_use($query, $res, array("p05"=>$return_array['p05']));

				$data['p0121'] = ($res['p010'] == -1) ? $_SESSION['cor003_p104'] : $res['p010']; // Κατάστημα
				$data['p703']  = ($res['p09'] == -1)  ? $_SESSION['cor003_p105'] : $res['p09']; // Αποθήκη
				invoices_where_p05($data, $mode, $container_id);
			}
		}

		if ($p04 > 0) {
			/*echo $mode . ' - p04' . $p04;*/
			if (strtolower($mode) == 'a55' or strtolower($mode) == 'a57') {

				if (pegasus_mysql_printfld('a71', 'p601', 'nr01=? ', array($p04)) != $p03) {
					$return_array['clear_p04'] = 1;
				} else {
					pegasus_mysql_use("select * from a71 where nr01=? ", $a71, array($p04));
					if (!empty($a71['p6012'])) {
						$return_array['p017'] = $a71['p6012'];
					}
					if (!empty($a71['p6016'])) {
						$return_array['p09']  = $a71['p6016'];
						$return_array['p09_display']  = pegasus_mysql_printfld('a26', 'p02', 'p01 = ?' , array($a71['p6016']));
					}
					$vp04 = trim($a71['p603']); // Διεύθυνση Υποκαταστήματος για το Από/Προς
				}
			}

			if (strtolower($mode) == 'a56' or strtolower($mode) == 'a67') {
				if (pegasus_mysql_printfld('a76', 'p601', 'nr01= ? ', array($p04)) !=  $p03) {
					$return_array['clear_p04'] = 1;
				} else {
					pegasus_mysql_use("select * from a76 where nr01=? ", $a76, array($p04));
					if (!empty($a76['p6012'])) {
						$return_array['p017'] = $a76['p6012'];
					}

					if (!empty($a76['p6016'])) {
						$return_array['p09']  = $a76['p6016'];
						$return_array['p09_display']  = pegasus_mysql_printfld('a26', 'p02', 'p01 = ?' , array($a76['p6016']));
					}
					$vp04 = trim($a76['p603']); // Διεύθυνση Υποκαταστήματος για το Από/Προς
				}
			}
		}

		// Hide υποκαταστημα
		$return_array['p04_hidden'] = true;

		// 03/07/2023
		// $data['p05'] = Έχω το παραστατικό στην κλήση
		// $return_array['p05'] = Έχω default παραστατικό πελάτη, υπερισχύει της κλήσης.
		$p05 = '';
		//! Προσοχή! Όταν η συνάρτηση καλείται από την invoices_find_p05_data, στο data έχει γεμάτο το $data['p05']
		//! Άρα δεν είναι μόνο η περίπτωση του retail που μπορεί να έρθει γεμάτο αυτό.
		//! Έξτρα προσοχή ότι τα αποτελέσματα που γυρίζουν είναι τα ίδια!!!!!!!!!
		if(!empty($return_array['p05'])) {
			$p05 = $return_array['p05'];
		}elseif(empty($return_array['p05']) && !empty($data['p05'])) {
			$p05 = $data['p05'];
		}
		
		if(!empty($p05)) {
			if(strtolower($mode) == 'a55' or strtolower($mode) == 'a57') {
				$p05_query = 'SELECT p204, p205, p206, p33, p103, p601, p012, p114 FROM a10 WHERE p01 = ?';
			} else if(strtolower($mode) == 'a56' or strtolower($mode) == 'a67') {
				$p05_query = 'SELECT p204, p205, p206, p33, p103, p601, p012, p114 FROM a11 WHERE p01 = ?';
			}

			$p05_queryValues = array($p05);
			pegasus_mysql_use($p05_query, $p05_tbl, $p05_queryValues);

			if($p05_tbl['p012'] == 1) {
				$return_array['p805'] = 1;
			}

			// % Κρατησης
			// Αν το % Κράτησης του Ορισμού Παραστατικού ΔΕΝ είναι μεγαλύτερο του 0, ενημερώνεται από του πελάτη
			// To p0112 έχει αρχικοποιηθεί με του πελάτη παραπάνω
			if ($p05_tbl['p204'] > 0) {
				$return_array['p0112'] = $p05_tbl['p204'];	// % Κρατήσεων
			}

			if($p05_tbl['p601']==1 ){
				$return_array['p07']  = 1;
			}elseif($p05_tbl['p601']==2 ){
				$return_array['p07']  = 0;
			}

			// % Φόρου
			// Αν το % Φόρου του Ορισμού Παραστατικού ΔΕΝ είναι μεγαλύτερο του 0, ενημερώνεται από του πελάτη
			// To p0112 έχει αρχικοποιηθεί με του πελάτη παραπάνω
			if ($p05_tbl['p205'] > 0) {
				$return_array['p0113'] = $p05_tbl['p205'];	// % Φόρου
			}

			// Καθεστώς ΦΠΑ
			// Αν το Καθεστώς ΦΠΑ του Πελάτη δεν βρίσκεται στα επιτρεπτά καθεστώτα ΦΠΑ του παραστατικού, ενημερώνεται από το πρώτο επιτρεπτό.
			if (isset($p05_tbl['p33']) && !empty($p05_tbl['p33'])) {
				if (strpos($p05_tbl['p33'], '#' . $return_array['p09'] . '#') === false) {
					$valid_rate = explode('#', trim($p05_tbl['p33'],'#'));
					$return_array['p09'] = $valid_rate[0];
					$return_array['p09_display'] = pegasus_mysql_printfld('a26', 'p02', 'p01 = ?', array($valid_rate[0]));
				}
			}

			// Απο - Προς
			// Γίνεται έλεγχος για την τιμή του "Η έδρα ενημερώνει το". 
			// Αν η τιμή είναι "Τίποτα" δεν ενημερώνονται τα πεδία. Διαφορετικά ενημέρωνει αντίστοιχα τα πεδία από τον Πελάτη. 
			if(!in_array($mode,array('a60','a61'))) {
				$peg_str = $_SESSION['peg_dic_invoices_144'];	// Έδρα σας
				$a01p40 =  implode(' ',array(
					$tbl_p03['p40'],	// Παράδοση Εμπορευμάτων
					$tbl_p03['p41'], 	// Παράδοση Εμπορευμάτων 2
					$tbl_p03['p42']		// Παράδοση Εμπορευμάτων 3
				));
				// (Από - Προς) Από Πελάτη || Προμηθευτή
				if (!empty(trim($a01p40)) && in_array($mode, array('a55', 'a57'))) {
					$peg_str = $a01p40;
				}
				// (Από - Προς) Από Υποκατάστημα
				if (!empty($vp04)) {
					$peg_str = $vp04;
				}
				if(pegasus_module_exists('stores')){
					$peg_str1 = pegasus_mysql_printfld('t07', 'p05', 'p01=? ', array($return_array['p0121']));
				}
				if (empty($peg_str1)) {
					$peg_str1 = $_SESSION['peg_dic_invoices_145'];	// Έδρα μας
					if (!empty($_SESSION['cor000_lektiko'])) {
						$peg_str1 = $_SESSION['cor000_lektiko'];
					}
				}
				// Από - Προς
				$return_array['p014'] = '';
				$return_array['p013'] = '';
				//Η Εδρα Προμηθευτή Ενημερώνει το Aπό
				if ($p05_tbl['p103'] == 1) {
					$return_array['p014'] = $peg_str1;
					$return_array['p013'] = $peg_str;
				}
				// Η Εδρα Προμηθευτή Ενημερώνει το Πρός
				elseif ($p05_tbl['p103'] == 2) {
					$return_array['p014'] = $peg_str;
					$return_array['p013'] = $peg_str1;
				}
				
				//Ο Απ. Χώρος ενημερώνει το Aπό
				if ($p05_tbl['p114'] == 1) {
					pegasus_mysql_use("SELECT p02, p03, p7 FROM i16 WHERE p00 = ?", $i16, array($return_array['p703']));
					if(!empty($i16)){
						$return_array['p013'] = $i16['p02'].' '.$i16['p03'].' '.$i16['p7'];
					}
				}
				// Ο Απ. Χώρος ενημερώνει το Πρός
				elseif ($p05_tbl['p114'] == 2) {
					pegasus_mysql_use("SELECT p02, p03, p7 FROM i16 WHERE p00 = ?", $i16, array($return_array['p703']));
					if(!empty($i16)){
						$return_array['p014'] = $i16['p02'].' '.$i16['p03'].' '.$i16['p7'];
					}
				}
			}

			// Υπολογισμός των στοιχείων διακίνησης.
			$address_array = invoices_calc_diakinisi_fields($data, $mode);
			$return_array = array_merge($return_array, $address_array);
		}
		
		if ($mode == 'a55' or $mode == 'a57') {
			$query = "select count(*) as cnt, 1 as p_tp from a71 join a01 on a71.p601=a01.nr01 and a01.nr01=:nr01 ;";
		}

		if ($mode == 'a56' or $mode == 'a67') {
			$query = "select count(*) as cnt, 2 as p_tp from a76 join a00 on a76.p601=a00.nr01 and a00.nr01=:nr01 ;";
		}

		pegasus_mysql_use($query, $has_store, array('nr01' => $p03));
		if ($has_store['cnt'] > 0) {
			$return_array['p04_hidden'] = false;
		}

		if($mode == 'a55' || $mode == 'a57' || $mode == 'a56' || $mode == 'a67') {
			//Δεν υπολογίζεται η εισφορά ανακύκλωσης
			pegasusSetGlobalVar('peg_'.$mode.'_d-' . $data['nr01'] . '_p805', $return_array['p805']);
		}		
	}

	foreach ($return_array as $key => $value) {
		$data[$key] = $value;
	}

	//Περιέχει ΦΠΑ το παραστατικό
	pegasusSetGlobalVar('peg_'.$mode.'_d-' . $nr01 . '_p07', $return_array['p07']);

	//Κωδικός πελάτη
	pegasusSetGlobalVar('peg_'.$mode.'_d-' . $nr01 . '_p03', $p03);
	
	return $data;
}

function invoices_find_balance($a01_p21 = 0, $p09_min = 0,  $p09_max = 9999999999)
{
	pegasus_mysql_use(
		"SELECT  ifnull(sum(t00tot.p03),0) AS balance
							FROM t00tot
							WHERE p01= :p01 AND
								  p09>= :p09_min AND
								  p09<=	:p09_max",
		$t00tot,
		array(
			'p01'		=>	$a01_p21,
			'p09_min'	=>	$p09_min,
			'p09_max'	=>	$p09_max
		)
	);
	return $t00tot['balance'];
}

/***/
function invoices_change_local_stores($data, $mode)
{


	$p03     = $data['p03'];
	$p415    = $data['p415'];
	$p416    = $data['p416'];


	$return_array = array();


	$return_array['p417']  = 0;  //Proigoymeno ypoloipo topiko ypoloipo

	//Eυρεση πελάτη ή προμηθευτή
	if ($p03 > 0) {
		$p21 = 0;
		if ($mode == 'a55' or $mode == 'a57' or $mode == 'retail00_01') {
			pegasus_mysql_use("select * from a01 where nr01=? ", $tbl_p03, array($p03));
			$p21 = $tbl_p03['p21'];
		}


		if ($mode == 'a56' or $mode == 'a67') {
			pegasus_mysql_use("select * from a00 where nr01=? ", $tbl_p03, array($p03));
			$p21 = $tbl_p03['p21'];
		}

		// An ειναι αποδειξή
		if ($mode == 't08') {
			$p21 = $p03;
			$return_array['p418'] = 0;
		}


		$return_array['p417'] = invoices_find_balance($p21, $p415,  $p416); //Topiko ypoloipo

	}

	foreach ($return_array as $key => $value) {
		$data[$key] = $value;
	}

	return $data;
}

function invoices_make_product_search_query_exact($exact_i00, $color = '', $size = '', &$search_fields = array(), $v104 = 0, $v103 = 0) {
	$i00 =  pegasus_get_grid_table('i00');
	/*	Διαβάζει τις παραμετρους */
	$color_size_en     = 1;
	if (!pegasus_module_exists('colorsize')) {
		$color_size_en = 0;
	}

	$search_fields = array();
	// $exact_i00 = str_replace('/', '', $exact_i00);
	if(substr($exact_i00, -1) == '/'){
		$exact_i00 = substr($exact_i00, 0, -1);
	}
	

	$query_vals = array();
	/* Query για την αναζήτηση των ειδών */
	$query_vals['cor003_p303'] = $_SESSION['cor003_p303'];
	$query_vals['cor003_p304'] = $_SESSION['cor003_p304'];
	
	if($color_size_en == 1 and (!empty($color) and !empty($size))) {
		$color = str_replace('/', '', $color);
		$size  = str_replace('/', '', $size);
		$query_vals['i47_p02'] = $color;
		$query_vals['i47_p03'] = $size;

		$query_vals['i47_p01'] = $exact_i00;
		$type = 8;
		$vtype = "'colorsize'";
		$join = ' join i47 on i00.pno=i47.p01 ';
		$where = '(
					(i47.p01 = :i47_p01)
					AND
					(i47.p02 = :i47_p02)
					AND
					(i47.p03 = :i47_p03)
				)';
		$group_by = ' i00.pno , i47.p02 ,i47.p03 ';
		$v172 = " i47.p02 ";
		$v173 = " i47.p03 ";
	}else{
		$query_vals['exact_i00'] = $exact_i00;
		$type = 1;
		$vtype = "'pno'";
		$join = '';
		$where = ' i00.pno = :exact_i00 ';
		$group_by = ' i00.pno ';
		$v172 = "''";
		$v173 = "''";
	}
	//Ψάχνει με κωδικό είδους

	$query = "(SELECT
						".$type." AS type,
						".$vtype." AS vtype,
						i00.pno AS code,
						i00.pno AS  v101,
						i00.name AS v102,
						i00.p9000 AS p9000,
						".$v172." AS v172,
						".$v173." AS v173,
						".$v103." AS v103,
						".$v104." AS v104,
						'' AS v161,
						'' AS ser,
						i00.timh1 AS timh1,
						i00.timh2 AS timh2,
						i00.timh3 AS timh3,
						i00.timh4 AS timh4,
						sum(i00tot.p03) as v_baltot,
						sum(IF(i00tot.p610>=:cor003_p303 and i00tot.p610<=:cor003_p304 ,i00tot.p03,0)) as v_locbaltot,
						sum(i00tot.p04) as v_cusord,
						sum(IF(i00tot.p610>=:cor003_p303 and i00tot.p610<=:cor003_p304 ,i00tot.p04,0)) as v_loccusord,
						sum(i00tot.p05) as   v_suppord,
						sum(i00tot.p05) as   v_locsuppord

					FROM " . $i00 . "
					" . $join . "
					left join i00tot on i00tot.pno1=i00.pno
					WHERE i00.p203=0 AND
					" . $where . " 
					group by " . $group_by . " ) ";
		
	$search_fields[] = $_SESSION['peg_dic_invoices_search_code'];

	return array(
		'sql'	 =>	$query, 
		'values' => $query_vals
	);
}
/**
 * Enter description here...
 *
 */
function invoices_make_product_search_query($code = '', $a00_nr01 = '', $name = '', $return_array = 0, &$search_fields = array(), $service_only = 0, $i10_nr01_arr = array())
{
	if ($code == 'undefined') {
		$code = '';
	}
	if ($name == 'undefined') {
		$name = '';
	}
	if(count($i10_nr01_arr)>0){
		$i10_nr01_in = pegasus_mysql_create_in($i10_nr01_arr, 'i10_nr01');
	}
	$i00 =  pegasus_get_grid_table('i00');
	//echo 'code:'     . $code;
	//echo 'a00_nr01:' . $a00_nr01;
	//echo '$name:'    . $name;
	$search_fields = array();
	if(substr($code, -1) == '/'){
		$code = substr($code, 0, -1);
	}
	//$code = str_replace('/', '', $code);
	if(substr($name, -1) == '/'){
		$name = substr($name, 0, -1);
	}
	//$name = str_replace('/', '', $name);
	$queryParrams = array();
	if ((empty($code) and !empty($name)) or (empty($code) and empty($name))) {
		$query = " 	SELECT
						1 AS type,
						0 AS is_exact_the_same,
						'pno' AS vtype,
						i00.pno AS code,
						i00.pno AS  v101,
						i00.name AS v102,
						i00.p9000 AS p9000,
						'' AS v172,
						'' AS v173,
						0  AS v103,
						0  AS v1030_1,
						'' AS v161,
						'' AS ser,
						i00.nr01 AS nr01,
						i00.timh1 AS timh1,
						i00.timh2 AS timh2,
						i00.timh3 AS timh3,
						i00.timh4 AS timh4,
						sum(i00tot.p03) as v_baltot,
						sum(IF(i00tot.p610>=:cor003_p303 and i00tot.p610<=:cor003_p304 ,i00tot.p03,0)) as v_locbaltot,
						sum(i00tot.p04) as v_cusord,
						sum(IF(i00tot.p610>=:cor003_p303 and i00tot.p610<=:cor003_p304 ,i00tot.p04,0)) as v_loccusord,
						sum(i00tot.p05) as   v_suppord,
						sum(i00tot.p05) as   v_locsuppord
					FROM " . $i00 . "
					LEFT JOIN i00tot on i00tot.pno1=i00.pno
					WHERE i00.p203=0 ";

		if (!empty($name)) {
			if(
				substr($name, 0, 1) != '~'  && 
				substr($name, 0, 2) != '~+' && 
				substr($name, 0, 2) != '~-' && 
				substr($name, 0, 1) != '='
			) {
				$fld_search = pegasusGetGlobalVar('invoice__invoices_find_product_d_setValue_fld_search');

				if($_REQUEST['s_value'] == 0) {
					$fld_search = $_REQUEST['fld_search'];
				}

				if($fld_search == 2) {
					$name =  '~'.$name;
				} else if($fld_search == 202) {
					$name =  '~+'.$name;
				} else if($fld_search == 203) {
					$name =  '~-'.$name;
				} else if($fld_search == 204) {
					$name =  '='.$name;
				}
			}

			$cond_arr = peg002_cond(0, 'i00', 'name', $name, 'C');
			$cond_arr00 = peg002_cond(0, 'i00', 'p9000', $name, 'C');
			
			$query .= " AND ( (" . $cond_arr['where'] . ") || ( ".$cond_arr00['where']." )) ";
			$queryParrams = array_merge($queryParrams, $cond_arr['whereParams'], $cond_arr00['whereParams']);
		}

		if ($service_only) {
			$service_where = inventory01_query_where_of_i00();
			if(!empty($service_where)){
				$query .= " AND " . $service_where['sql'] . " ";
				$queryParrams = array_merge($queryParrams, $service_where['sqlParams']);	
			}
		}

		if(!empty($i10_nr01_in['sql'])){
			$query .= " AND i00.p62 in ( ". $i10_nr01_in['sql'] . ") ";
			$queryParrams = array_merge($queryParrams, $i10_nr01_in['sqlParams']);
		}

		$search_fields[] = $_SESSION['peg_dic_invoices_search_name'];
		//$query .= " group by i00.pno  order by case when name like :v_search_orderby then 0 else 1 end asc,name ";
		$query .= " GROUP BY i00.pno ";
        $query .= " ORDER BY ";
        $query .= " CASE WHEN name LIKE :v_search_orderby THEN 0 ELSE 1 END ASC, ";
        $query .= " CASE WHEN ptax >= 0 THEN 0 ELSE 1 END ASC, ";
        $query .= " name, ptax ";

		$name00 = $name;

		if (substr($name00, 0, 2) == '~+') {
			$name00 = substr($name00, 2);
		}
		if (substr($name00, 0, 2) == '~-') {
			$name00 = substr($name00, 2);
		}
		if (substr($name00, 0, 1) == '=') {
			$name00 = substr($name00, 1);
		}
		if (substr($name00, 0, 1) == '~') {
			$name00 = substr($name00, 1);
		}
		$queryParrams['v_search_orderby'] = $name00 . '%';


		$queryParrams['cor003_p303'] = $_SESSION['cor003_p303']; //Από Αποθηκευτικό Χώρο
		$queryParrams['cor003_p304'] = $_SESSION['cor003_p304']; //Έως Αποθηκευτικό Χώρο 

		// echo pegasus_replace_values_in_sql($query,$queryParrams);

		if ($return_array == 1) {
			return array(
				'sql'	=>	$query,
				'values' =>	$queryParrams
			);
		}

		return pegasus_replace_values_in_sql($query, $queryParrams);
	}

		/*	Διαβάζει τις παραμετρους */
	$barcode_en 	= $_SESSION['f02_pg06'];  // barcode
	$color_size_en  = 1;
	$antistoixia_en = $_SESSION['f02_pg07'];  // Antistoixia
	$spcodes_en     = $_SESSION['f02_pg011']; // Loipoys kvdikoys
	$lots_en 		= $_SESSION['f02_pg012']; // Partides
	$serial_en  	= $_SESSION['f02_pg08']; // Serial Number
	if (!pegasus_module_exists('invspcodes')) {
		$spcodes_en = 0;
	}
	if (!pegasus_module_exists('lot')) {
		$lots_en = 0;
	}
	if (!pegasus_module_exists('serial')) {
		$serial_en = 0;
	}
	if (!pegasus_module_exists('colorsize')) {
		$color_size_en = 0;
	}

	//debug
	// $barcode_en 	=1;  // barcode
	// $color_size_en     = 1;
	// $antistoixia_en = 1;  // Antistoixia
	// $spcodes_en     =1; // Loipoys kvdikoys
	// $lots_en 		= 1; // Partides
	// $serial_en  	= 1; // Serial Number

	$query_vals = array();
	/* Query για την αναζήτηση των ειδών */
	$query_vals['cor003_p303'] = $_SESSION['cor003_p303'];
	$query_vals['cor003_p304'] = $_SESSION['cor003_p304'];


	$service_only_where = '';
	$service_only_where_params = array();
	if ($service_only) {
		$service_where = inventory01_query_where_of_i00();
		if(!empty($service_where)){
			$service_only_where .= " AND " . $service_where['sql'] . " ";
			$service_only_where_params =  $service_where['sqlParams'];
		}
	}

	$i10_nr01_where = '';
	$i10_nr01_where_params = array();
	if(!empty($i10_nr01_in['sql'])){
		$i10_nr01_where .= " AND i00.p62 in ( ". $i10_nr01_in['sql'] . ") ";
		$i10_nr01_where_params =  $i10_nr01_in['sqlParams'];
	}

	//Ψάχνει με κωδικό είδους
	$cond_arr = peg002_cond(0, 'i00', 'pno', $code, 'C');
	$query = "(
				SELECT
					1 AS type,
					if(i00.pno = :i00_pno, 1, 0) AS is_exact_the_same,
					'pno' AS vtype,
					i00.pno AS code,
					i00.pno AS  v101,
					i00.name AS v102,
					i00.p9000 AS p9000,
					'' AS v172,
					'' AS v173,
					0  AS v103,
					0  AS v104,
					0  AS v1030_1,
					'' AS v161,
					'' AS ser,
					i00.nr01 AS nr01,
					i00.timh1 AS timh1,
					i00.timh2 AS timh2,
					i00.timh3 AS timh3,
					i00.timh4 AS timh4,
					sum(i00tot.p03) as v_baltot,
					sum(IF(i00tot.p610>=:cor003_p303 and i00tot.p610<=:cor003_p304 ,i00tot.p03,0)) as v_locbaltot,
					sum(i00tot.p04) as v_cusord,
					sum(IF(i00tot.p610>=:cor003_p303 and i00tot.p610<=:cor003_p304 ,i00tot.p04,0)) as v_loccusord,
					sum(i00tot.p05) as   v_suppord,
					sum(i00tot.p05) as   v_locsuppord
					FROM " . $i00 . "
				LEFT JOIN i00tot on i00tot.pno1=i00.pno
				WHERE i00.p203=0 AND " . $cond_arr['where'] .$service_only_where . $i10_nr01_where." 
				GROUP BY i00.pno
			  )";

	$query_vals['i00_pno'] = $code;

	$query_vals = array_merge($query_vals, $cond_arr['whereParams'], $service_only_where_params, $i10_nr01_where_params);
	$search_fields[] = $_SESSION['peg_dic_invoices_search_code'];


	if ($barcode_en == 1) {
		$barcode_array = invoices__invoices_online_value_barcode($code);
		// echo '<pre>' .print_r($barcode_array, 1). '</pre>';
		$tmp_v103 = 0;
		$tmp_v104 = 0;
		$tmp_ser  = "";
		$tmp_v161 = "";
		$having   = "";

		if(!empty($barcode_array['data']['v103'])) {
			$tmp_v103 = $barcode_array['data']['v103'];
		}

		if(!empty($barcode_array['data']['v104'])) {
			$tmp_v104 = $barcode_array['data']['v104'];
		}

		if(!empty($barcode_array['data']['code'])) {
			$code = $barcode_array['data']['code'];
		}

		if(!empty($barcode_array['data']['ser'])) {
			$tmp_ser = $barcode_array['data']['ser'];
			$having = "having ser = ".$tmp_ser;
		}

		if(!empty($barcode_array['data']['v161'])) {
			$tmp_v161 = $barcode_array['data']['v161'];
			$having .= " and v161 = ".$tmp_v161;
		}

		$cond_arr = peg002_cond(count($query_vals) + 1, 'i00', 'p01', $code, 'C');
		//Ψάχνει με barcode
		$query .= " UNION ALL ";
		$query .= " (
						SELECT
							2 AS type,
							if(i00.p01 = :i00_p01, 1, 0) AS is_exact_the_same,
							'Barcode' AS vtype,
							i00.p01 AS code,
							i00.pno AS  v101,
							i00.name AS v102,
							i00.p9000 AS p9000,
							'' AS v172,
							'' AS v173,
							".$tmp_v103."  AS v103,
							".$tmp_v104."  AS v104,
							0  AS v1030_1,
							'$tmp_v161' AS v161,
							'$tmp_ser' AS ser,
							i00.nr01 AS nr01,
							i00.timh1 AS timh1,
							i00.timh2 AS timh2,
							i00.timh3 AS timh3,
							i00.timh4 AS timh4,
							sum(i00tot.p03) as v_baltot,
							sum(IF(i00tot.p610>=:cor003_p303 and i00tot.p610<=:cor003_p304 ,i00tot.p03,0)) as v_locbaltot,
							sum(i00tot.p04) as v_cusord,
							sum(IF(i00tot.p610>=:cor003_p303 and i00tot.p610<=:cor003_p304 ,i00tot.p04,0)) as v_loccusord,
							sum(i00tot.p05) as   v_suppord,
							sum(i00tot.p05) as   v_locsuppord
						FROM " . $i00 . "
						LEFT JOIN i00tot on i00tot.pno1=i00.pno
						WHERE   i00.p203=0 AND " . $cond_arr['where'] . $service_only_where . $i10_nr01_where." 
						GROUP BY i00.pno  ".$having." 
					)";

		$query_vals['i00_p01'] = $code;

		$query_vals = array_merge($query_vals, $cond_arr['whereParams']);
		$search_fields[] = $_SESSION['peg_dic_invoices_search_barcode'];
	}


	if ($barcode_en == 1 and $color_size_en == 1) {
		$cond_arr_p04 = peg002_cond(count($query_vals) + 1, 'i47', 'p04', $code, 'C');
		$query_vals = array_merge($query_vals, $cond_arr_p04['whereParams']);
		$cond_arr_p05 = peg002_cond(count($query_vals) + 1, 'i47', 'p05', $code, 'C');
		$query_vals = array_merge($query_vals, $cond_arr_p05['whereParams']);
		$query .= " UNION ALL ";
		$query .= "(
						SELECT
							3 AS type,
							if((i47.p04 = :i47_p04 OR i47.p05 = :i47_p05), 1, 0) AS is_exact_the_same,
							'Color Barcode' AS vtype,
							if(i47.p04=:code_02 , i47.p04, i47.p05) AS code,
							i00.pno AS  v101,
							i00.name AS v102,
							i00.p9000 AS p9000,
							i47.p02 AS v172,
							i47.p03 AS v173,
							0 AS v103,
							0  AS v104,
							0  AS v1030_1,
							'' AS v161,
							'' AS ser,
							i00.nr01 AS nr01,
							i00.timh1 AS timh1,
							i00.timh2 AS timh2,
							i00.timh3 AS timh3,
							i00.timh4 AS timh4,
							sum(i00tot.p03) as v_baltot,
							sum(IF(i00tot.p610>=:cor003_p303 and i00tot.p610<=:cor003_p304 ,i00tot.p03,0)) as v_locbaltot,
							sum(i00tot.p04) as v_cusord,
							sum(IF(i00tot.p610>=:cor003_p303 and i00tot.p610<=:cor003_p304 ,i00tot.p04,0)) as v_loccusord,
							sum(i00tot.p05) as   v_suppord,
							sum(i00tot.p05) as   v_locsuppord
						FROM " . $i00 . "
						JOIN i47 on i00.pno=i47.p01
						LEFT JOIN i00tot on i00tot.pno1=i00.pno
						WHERE (
								(" . $cond_arr_p04['where'] . ") OR
								(" . $cond_arr_p05['where'] . ")
							  ) AND i00.p203=0". $service_only_where .$i10_nr01_where." 
						GROUP BY i00.pno, i47.p02, i47.p03
					)";

		$query_vals['i47_p04'] = $code;
		$query_vals['i47_p05'] = $code;
		$query_vals['code_02'] = $code;
	}

	if ($antistoixia_en == 1) {
		//Ψάχνει με αντιστοιχία
		$cond_arr = peg002_cond(count($query_vals) + 1, 'i00', 'p9001', $code, 'C');
		$query_vals = array_merge($query_vals, $cond_arr['whereParams']);
		$query .= " UNION ALL ";
		$query .= " (
						SELECT
							4 AS type,
							if(i00.p9001 = :i00_p9001, 1, 0) AS is_exact_the_same,
							'antisoixia' AS vtype,
							i00.p9001 AS code,
							i00.pno AS  v101,
							i00.name AS v102,
							i00.p9000 AS p9000,
							'' AS v172,
							'' AS v173,
							0  AS v103,
							0  AS v104,
							0  AS v1030_1,
							'' AS v161,
							'' AS ser,
							i00.nr01 AS nr01,
							i00.timh1 AS timh1,
							i00.timh2 AS timh2,
							i00.timh3 AS timh3,
							i00.timh4 AS timh4,
							sum(i00tot.p03) as v_baltot,
							sum(IF(i00tot.p610>=:cor003_p303 and i00tot.p610<=:cor003_p304 ,i00tot.p03,0)) as v_locbaltot,
							sum(i00tot.p04) as v_cusord,
							sum(IF(i00tot.p610>=:cor003_p303 and i00tot.p610<=:cor003_p304 ,i00tot.p04,0)) as v_loccusord,
							sum(i00tot.p05) as   v_suppord,
							sum(i00tot.p05) as   v_locsuppord
						FROM " . $i00 . "
						LEFT JOIN i00tot on i00tot.pno1=i00.pno
						WHERE " . $cond_arr['where'] . $service_only_where .$i10_nr01_where." AND i00.p203=0 
						GROUP BY i00.pno
					)";

		$query_vals['i00_p9001'] = $code;

		$search_fields[] = $_SESSION['peg_dic_invoices_search_antistoixia'];
	}

	if ($spcodes_en == 1) {
		$cond_arr = peg002_cond(count($query_vals) + 1, 'i08', 'pe02', $code, 'C');
		$query_vals = array_merge($query_vals, $cond_arr['whereParams']);
		$v1030_1 = 0;
		//echo $code;
		$timh1   = "i00.timh1";
		$timh2   = "i00.timh2";
		$timh3   = "i00.timh3";
		$timh4   = "i00.timh4";

		if (pegasus_module_exists('invspcodes')){
			$v1030_1 = 'IF(i08.pe06 = 1, i08.pe020, 0)';
			$timh1   = 'IF(i08.pe06 = 1, i08.petim1, i00.timh1)';
			$timh2   = 'IF(i08.pe06 = 1, i08.petim2, i00.timh2)';
			$timh3   = 'IF(i08.pe06 = 1, i08.petim3, i00.timh3)';
			$timh4   = 'IF(i08.pe06 = 1, i08.petim4, i00.timh4)';
		}

		$query .= " UNION ALL ";
		$query .= " (
						SELECT
							5 AS type,
							if(i08.pe02 = :i08_pe02, 1, 0) AS is_exact_the_same,
							'Special Code' AS vtype,
							i08.pe02 AS code,
							i00.pno AS  v101,
							i00.name AS v102,
							i00.p9000 AS p9000,
							i08.pc01 AS v172,
							i08.pm01 AS v173,
							i08.pe020 AS v103,
							0  AS v104,
							".$v1030_1."	AS v1030_1,
							'' AS v161,
							'' AS ser,
							".$timh1." AS timh1,
							".$timh2." AS timh2,
							".$timh3." AS timh3,
							".$timh4." AS timh4,
							i00.nr01 AS nr01,
							sum(i00tot.p03) as v_baltot,
							sum(IF(i00tot.p610>=:cor003_p303 and i00tot.p610<=:cor003_p304 ,i00tot.p03,0)) as v_locbaltot,
							sum(i00tot.p04) as v_cusord,
							sum(IF(i00tot.p610>=:cor003_p303 and i00tot.p610<=:cor003_p304 ,i00tot.p04,0)) as v_loccusord,
							sum(i00tot.p05) as   v_suppord,
							sum(i00tot.p05) as   v_locsuppord
						FROM " . $i00 . "
						JOIN i08 on i00.pno=i08.pe01
						LEFT JOIN i00tot on i00tot.pno1=i00.pno
						WHERE " . $cond_arr['where'] . $service_only_where .$i10_nr01_where." AND i00.p203=0 ";
									   
		if ($a00_nr01 > 0) {
			$query .= "  AND i08.pe03= :a00_nr01_00";
			$query_vals['a00_nr01_00'] = $a00_nr01;
		}
		$query .= " GROUP BY i00.pno, i08.pe02) ";

		$query_vals['i08_pe02'] = $code;

		$search_fields[] = $_SESSION['peg_dic_invoices_search_spcodes'];
	}

	if ($lots_en == 1) {
		$query .= " UNION ALL ";
		$query .= " (
						SELECT
							7 AS type,
							0 AS is_exact_the_same,
							'lot' AS vtype,
							i11.p02  AS code,
							i00.pno  AS  v101,
							i00.name AS v102,
							i00.p9000 AS p9000,
							'' AS v172,
							'' AS v173,
							0 AS v103,
							0 AS v104,
							0 AS v1030_1,
							i11.p02 AS v161,
							'' AS ser,
							i00.nr01 AS nr01,
							i11.timh1 AS timh1,
							i11.timh2 AS timh2,
							i11.timh3 AS timh3,
							i11.timh4 AS timh4,
							sum(i00tot.p03) as v_baltot,
							sum(IF(i00tot.p610>=:cor003_p303 and i00tot.p610<=:cor003_p304 ,i00tot.p03,0)) as v_locbaltot,
							sum(i00tot.p04) as v_cusord,
							sum(IF(i00tot.p610>=:cor003_p303 and i00tot.p610<=:cor003_p304 ,i00tot.p04,0)) as v_loccusord,
							sum(i00tot.p05) as   v_suppord,
							sum(i00tot.p05) as   v_locsuppord
						FROM " . $i00 . "
						JOIN i11 on i00.pno=i11.p01
						LEFT JOIN i00tot on i00tot.pno1=i00.pno
						WHERE (
								i11.p02= :code_07 OR
								i11.p03= :code_08 OR
								i11.p04= :code_09 ) AND i00.p203=0 " . $service_only_where .$i10_nr01_where."
						GROUP BY i00.pno
					)";

		$query_vals['code_07'] = $code;
		$query_vals['code_08'] = $code;
		$query_vals['code_09'] = $code;

		$search_fields[] = $_SESSION['peg_dic_invoices_search_lots'];
	}

	if ($serial_en == 1) {
		$cond_arr = peg002_cond(count($query_vals) + 1, 'i31', 'p02', $code, 'C');
		$query_vals = array_merge($query_vals, $cond_arr['whereParams']);
		$query .= " UNION ALL ";
		$query .= " (
						SELECT
							6 AS type,
							if(i31.p02 = :i31_p02, 1, 0) AS is_exact_the_same,
							'Serial Number' AS vtype,
							i31.p02 AS  code,
							i00.pno AS  v101,
							i00.name AS v102,
							i00.p9000 AS p9000,
							'' AS v172,
							'' AS v173,
							0 AS v103,
							0 AS v104,
							0  AS v1030_1,
							'' AS v161,
							i31.p02 AS ser,
							i00.nr01 AS nr01,
							i00.timh1 AS timh1,
							i00.timh2 AS timh2,
							i00.timh3 AS timh3,
							i00.timh4 AS timh4,
							sum(i00tot.p03) as v_baltot,
							sum(IF(i00tot.p610>=:cor003_p303 and i00tot.p610<=:cor003_p304 ,i00tot.p03,0)) as v_locbaltot,
							sum(i00tot.p04) as v_cusord,
							sum(IF(i00tot.p610>=:cor003_p303 and i00tot.p610<=:cor003_p304 ,i00tot.p04,0)) as v_loccusord,
							sum(i00tot.p05) as   v_suppord,
							sum(i00tot.p05) as   v_locsuppord
						FROM i31
						JOIN " . $i00 . " on i00.pno=i31.p01
						LEFT JOIN i00tot on i00tot.pno1=i00.pno
						WHERE " . $cond_arr['where'] . $service_only_where .$i10_nr01_where." AND i00.p203=0 
						GROUP BY i00.pno
					)";

		$query_vals['i31_p02'] = $code;

		$search_fields[] = $_SESSION['peg_dic_invoices_search_serial'];
	}
	if ($service_only) {
		//var_dump(pegasus_replace_values_in_sql($query, $query_vals));
	}
	// echo pegasus_replace_values_in_sql($query, $query_vals);
	if ($return_array == 1) {
		return array('sql'	=>	$query, 'values'	=> $query_vals);
	}


	return pegasus_replace_values_in_sql($query, $query_vals);
}


/**
 * vriskei ta synola h synarthsh ayth ekteleite kai sto sosimo poy parastaikoy/paraggelias sto onchange
 */
function invoices_find_totals($nr01, $p03, $product_table, $product_where, $p0101, $p0112, $p0113, $p0103, $p0108, $tbl_p03_p09, $preview_with_vat, $p410, $_totals, $p506, $p0102_1, $p0102_2, $p01080, $mode, $date, $pn02, $p420)
{


	//periexei fpa to parastaiko
	
	if ($mode == 'a55' || $mode == 'retail00_01') {//retail: add mode 
		pegasusSetGlobalVar('peg_a55_d-' . $nr01 . '_p07', $preview_with_vat);
	}

	if ($mode == 'a56') {
		pegasusSetGlobalVar('peg_a56_d-' . $nr01 . '_p07', $preview_with_vat);
	}

	if ($mode == 'a57') {
		pegasusSetGlobalVar('peg_a57_d-' . $nr01 . '_p07', $preview_with_vat);
	}

	if ($mode == 'a67') {
		pegasusSetGlobalVar('peg_a67_d-' . $nr01 . '_p07', $preview_with_vat);
	}

	$return_array = invoices_calculate_total($product_table, $product_where, $p0101, $p0112, $p0113, $p0103, $p0108, $tbl_p03_p09, $preview_with_vat, $p410, $_totals, $p506, $p0102_1, $p0102_2, $p01080, $mode, $date, $nr01, $pn02, $p420);
	invoices_set_total_var($mode, $nr01, $return_array);

	return $return_array;
}

/**
 * Aυτή η συναρτηση υπολογίζει τα σύνολα σε παραγγελίες και σε παραστατικά
 *
 * @param string $product_table				O πινακάς που υπάρχουν τα είδη π.χ. peg_tmp_
 * @param array|string $product_where		Το where στην αναζήτηση τών είδών
 * @param integer $p0101					Το ποσοστό της συνολικής εκπτώσης
 * @param integer $p0112					Το ποσοστό των κρατήσεων
 * @param integer $p0113					Το ποσοστό του φόρου
 * @param integer $p0103					Τον επιβαρύνσεών
 * @param integer $p0108
 * @param integer $a01_p09					Το καθεστώς Φ.Π.Α.
 * @param integer $preview_with_vat			Αν οι τιμές εμφανίζονται με το ΦΠΑ ή όχι
 * @param integer $p410
 * @param array $_totals
 * @param integer $p506						Μ.Κ. Δώροεπιταγής
 * @param integer $p0102_1
 * @param integer $p0102_2
 * @param integer $p01080
 * @param string $mode
 * @param string $date
 * @param integer $nr01
 * @param integer $pn02						Ισοτιμία Νομίσματος
 * @param integer $p420
 * @return array
 */
function invoices_calculate_total(
	$product_table = '',
	$product_where = '',
	$p0101 = 0,
	$p0112 = 0,
	$p0113 = 0,
	$p0103 = 0,
	$p0108 = 0,
	$a01_p09 = 0,
 	$preview_with_vat = 0,
	$p410 = 0,
	$_totals = null,
	$p506 = 0,
	$p0102_1 = 0,
	$p0102_2 = 0,
 	$p01080 = 0,
	$mode = "a55",
	$date = "",
	$nr01 = 0,
	$pn02 = 1,
	$p420 = 0	
) {


	if ($date == "") {
		$date = date('Y-m-d');
	}

	if ($p506 > 0 and ($mode == 'a55' or $mode == 'a57' or $mode == 'retail00_01')) {//retail: 16/05 add mode
		pegasus_mysql_use("select * from erpa80 where nr01=? ", $erpa80, array($p506));
		$p506_1 = $erpa80['p06'];
		if ($p506_1 > 0) {
			$p0102_2 = $p506_1;
			$p0101 = 0;
		}

		//An έχει % ΕΚπτωση
		if ($erpa80['p012'] > 0) {
			$p0102_2 = 0;
			$p0101 = $erpa80['p012'];
		}
	}
	if ($p0102_2 > 0) {
		$ret = invoices_calculate_total_00(
			$product_table,
			$product_where,
			$p0101,
			$p0112,
			$p0113,
			$p0103,
			$p0108,
			$a01_p09,
			$preview_with_vat,
			$p410, $_totals,
			0,
			0,
			0,
			0,
			$p01080,
			$mode,
			$date,
			$nr01,
			$pn02,
			$p420
		);
		if ($ret['p0109'] > 0) {
			return invoices_calculate_total_00(
				$product_table,
				$product_where,
				$p0101,
				$p0112,
				$p0113,
				$p0103,
				$p0108,
				$a01_p09,
				$preview_with_vat,
				$p410,
				$_totals,
				0,
				0,
				$p0102_2,
				$ret['p0109'],
				$p01080,
				$mode,
				$date,
				$nr01,
				$pn02,
				$p420
			);
		} else {
			return $ret;
		}
	} else {
		return invoices_calculate_total_00(
			$product_table,
			$product_where,
			$p0101,
			$p0112,
			$p0113,
			$p0103,
			$p0108,
			$a01_p09,
			$preview_with_vat,
			$p410,
			$_totals,
			0,
			$p0102_1,
			$p0102_2,
			0,
			$p01080,
			$mode,
			$date,
			$nr01,
			$pn02,
			$p420
		);
	}
}

function invoices_calculate_total_00(
	$product_table,
	$product_where,
	$p0101 = 0,
	$p0112 = 0,
	$p0113 = 0,
	$p0103 = 0,
	$p0108 = 0,
	$a01_p09 = null,
	$preview_with_vat = null,
	$p410 = 0,
	$_totals = 0,
	$p0109_1 = 0,
	$p0102_1 = 0,
	$p0102_2 = 0,
	$p0109 = 0,
	$p01080 = 0,
	$mode = "a55",
	$date = '',
	$nr01 = 0,
	$pn02 = 1 , //	Ισοτιμία Νομίσματος
	$p420 = 0				
) {
	// $p420 = 1; // --> p420

	if ($p0101 == 0) {
		$p0109_1 = 0;
	}

	$is_invoice = 0;
	if ($product_table == 'peg_tmp_i01') {
		$is_invoice = 1;
	}

	$p_dek = 2;

	$return_array = array();


	$total1 = 0;
	$total2 = 0;
	$total3 = 0;
	$total4 = 0;
	$total5 = 0;
	$total6 = 0;
	$total7 = 0;
	$total8 = 0;
	$total9 = 0;

	//find syntelestes fpa
	$_fp1 = 0;
	$_fp2 = 0;
	$_fp3 = 0;
	$_fp4 = 0;
	$_fp5 = 0;
	$_fp6 = 0;
	$_fp7 = 0;
	$_fp8 = 0;
	$_fp9 = 0;

	$query = "SELECT  	i13.p01,
							if(	i99001.p03 IS NULL,
								if(i13.p03 IS NULL, 0, i13.p03),
								i99001.p03) AS p03
				   FROM i13
				   left join i99001 ON 	i99001.p01=i13.p01
				   						AND i99001.p101<= :min_date
				   						AND i99001.p102>= :max_date ";
	$query_vals = array(
		'min_date'	=>	$date,
		'max_date'	=>	$date
	);
	$res = pegasus_query($query, $query_vals);
	while ($i13 = pegasus_fetch($res)) {
		${'_fp' . $i13['p01']} = $i13['p03'];
	}
	if (empty($p410)) { //Τα σύνολα δεν υπολογίζονται αυτόματα
		$p201 = 0;
		$p202 = 0;
		$p203 = 0;
		$p204 = 0;
		$p205 = 0;
		$p206 = 0;
		$p207 = 0;
		$p208 = 0;
		$p209 = 0;

		$p301 = 0;
		$p302 = 0;
		$p303 = 0;
		$p304 = 0;
		$p305 = 0;
		$p306 = 0;
		$p307 = 0;
		$p308 = 0;
		$p309 = 0;


		if (!pegasus_mysql_table_exists($product_table)) {
			$product_table = '';
		}

		$values = array();

		if (is_array($product_where)) {
			$where = $product_where['sql'];
			$values = array_merge($values, $product_where['sqlParams']);
		} else {
			$where = $product_where;
		}

		$wthfpa = $preview_with_vat;
		if ($is_invoice == 0) {
			$query = 'SELECT 	' . $product_table . '.*,
								' . $product_table . '.v103 AS quan ,
								' . $product_table . '.v105 AS pfpa ,
								' . $product_table . '.v108 AS kfpa
						FROM ' . $product_table;			
		} else {
			$query = 'SELECT 	' . $product_table . '.*,
								' . $product_table . '.p03  AS quan ,
								' . $product_table . '.p08  AS pfpa ,
								' . $product_table . '.p081 AS kfpa
						FROM ' . $product_table;
		}
		$query .= (!empty($where)) ? ' WHERE ' . $where . ' ' : '';

		$res = pegasus_query($query, $values);
		while ($products = pegasus_fetch_assoc($res)) {

			$kfpa = $products['kfpa']; // Katigoria FPA

			if ($is_invoice == 0) {
				$v107     = round($products['v107'], $p_dek);
		 		if ($wthfpa == 1) {
		 			$pkath = ROUND( ($v107 * 100/(100+$products['pfpa'])) , 2);
					$pfpa  = ROUND( ($v107 * $products['pfpa']/(100+$products['pfpa'])), 2);
		 		} else {
					$pkath = ROUND( $v107  , 2);
					$pfpa  = ROUND( ($v107 * $products['pfpa']/100) , 2);
				}

			} else {
				//Σύνολο
				$v107 = round(invoices_make_product_total($products['p03'], $products['p04'], $products['p08'], $products['p010'], $products['p010a'], $products['p041'], $products['p616'], $wthfpa, $products['p042']), $p_dek);

				if ($wthfpa == 1) {
				   $pkath = ROUND( ($v107 * 100/(100+$products['pfpa'])), 2);
				   $pfpa  = ROUND( ($v107 * $products['pfpa']/(100+$products['pfpa'])), 2);
				} else {
				   $pkath = ROUND( $v107 , 2);
				   $pfpa  = ROUND( ($v107 * $products['pfpa']/100), 2);
			    }

			}

			################
			#make the totals
			################
			if ($kfpa == 1) {
				$total1 += $v107;
				$pkath1 += $pkath;
				$pfpa1  += $pfpa;
			}

			if ($kfpa == 2) {
				$total2 += $v107;
				$pkath2 += $pkath;
				$pfpa2  += $pfpa;
			}

			if ($kfpa == 3) {
				$total3 += $v107;
				$pkath3 += $pkath;
				$pfpa3  += $pfpa;
			}

			if ($kfpa == 4) {
				$total4 += $v107;
				$pkath4 += $pkath;
				$pfpa4  += $pfpa;
			}

			if ($kfpa == 5) {
				$total5 += $v107;
				$pkath5 += $pkath;
				$pfpa5  += $pfpa;			
			}

			if ($kfpa == 6) {
				$total6 += $v107;
				$pkath6 += $pkath;
				$pfpa6  += $pfpa;			
			}

			if ($kfpa == 7) {
				$total7 += $v107;
				$pkath7 += $pkath;
				$pfpa7  += $pfpa;			
			}

			if ($kfpa == 8) {
				$total8 += $v107;
				$pkath8 += $pkath;
				$pfpa8  += $pfpa;			
			}

			if ($kfpa == 9) {
				$total9 += $v107;
				$pkath9 += $pkath;
				$pfpa9  += $pfpa;			
			}
		}



		################
		#Katigoria fpa 1
		################
		if($p420==1  and $pkath1 != 0 ){
			$p201 = round( $pkath1 , $p_dek);
			$p301 = round( $pfpa1 , $p_dek);
		}elseif($wthfpa == 1 and $total1 != 0) {
			$p201 = round($total1 * 100 / (100 + $_fp1), $p_dek);
			$p301 = $total1 - $p201;
		}elseif ($wthfpa == 0 and $total1 != 0) {
			$p301 = round($total1 * ($_fp1) / 100, $p_dek);
			$p201 = $total1;
		}

		################
		#Katigoria fpa 2
		################
		if($p420==1  and $pkath2 != 0 ){
			$p202 = round( $pkath2 , $p_dek);
			$p302 = round( $pfpa2 , $p_dek);
		}elseif($wthfpa == 1 and $total2 != 0) {
			$p202 = round($total2 * 100 / (100 + $_fp2), $p_dek);
			$p302 = $total2 - $p202;
		}elseif($wthfpa == 0 and $total2 != 0) {
			$p302 = round($total2 * ($_fp2) / 100, $p_dek);
			$p202 = $total2;
		}

		################
		#Katigoria fpa 3
		################
		if($p420==1  and $pkath3 != 0 ){
			$p203 = round( $pkath3 , $p_dek);
			$p303 = round( $pfpa3  , $p_dek);
		}elseif($wthfpa == 1 and $total3 != 0) {
			$p203 = round($total3 * 100 / (100 + $_fp3), $p_dek);
			$p303 = $total3 - $p203;
		}elseif($wthfpa == 0 and $total3 != 0) {
			$p303 = round($total3 * ($_fp3) / 100, $p_dek);
			$p203 = $total3;
		}

		################
		#Katigoria fpa 4
		################
		if($p420==1  and $pkath4 != 0 ){
			$p204 = round( $pkath4 , $p_dek);
			$p304 = round( $pfpa4  , $p_dek);
		}elseif($wthfpa == 1 and $total4 != 0) {
			$p204 = round($total4 * 100 / (100 + $_fp4), $p_dek);
			$p304 = $total4 - $p204;
		}elseif($wthfpa == 0 and $total4 != 0) {
			$p304 = round($total4 * ($_fp4) / 100, $p_dek);
			$p204 = $total4;
		}

		################
		#Katigoria fpa 5
		################
		if($p420==1  and $pkath5 != 0 ){
			$p205 = round( $pkath5 , $p_dek);
			$p305 = round( $pfpa5  , $p_dek);
		}elseif($wthfpa == 1 and $total5 != 0) {
			$p205 = round($total5 * 100 / (100 + $_fp5), $p_dek);
			$p305 = $total5 - $p205;
		}elseif($wthfpa == 0 and $total5 != 0) {
			$p305 = round($total5 * ($_fp5) / 100, $p_dek);
			$p205 = $total5;
		}

		################
		#Katigoria fpa 6
		################
		if($p420==1  and $pkath6 != 0 ){
			$p206 = round( $pkath6 , $p_dek);
			$p306 = round( $pfpa6  , $p_dek);
		}elseif($wthfpa == 1 and $total6 != 0) {
			$p206 = round($total6 * 100 / (100 + $_fp6), $p_dek);
			$p306 = $total6 - $p206;
		}elseif($wthfpa == 0 and $total6 != 0) {
			$p306 = round($total6 * ($_fp6) / 100, $p_dek);
			$p206 = $total6;
		}

		################
		#Katigoria fpa 7
		################
		if($p420==1  and $pkath7 != 0 ){
			$p207 = round( $pkath7 , $p_dek);
			$p307 = round( $pfpa7  , $p_dek);
		}elseif($wthfpa == 1 and $total7 != 0) {
			$p207 = round($total7 * 100 / (100 + $_fp7), $p_dek);
			$p307 = $total7 - $p207;
		}elseif($wthfpa == 0 and $total7 != 0) {
			$p307 = round($total7 * ($_fp7) / 100, $p_dek);
			$p207 = $total7;
		}

		################
		#Katigoria fpa 8
		################
		if($p420==1  and $pkath8 != 0 ){
			$p208 = round( $pkath8 , $p_dek);
			$p308 = round( $pfpa8  , $p_dek);
		}elseif($wthfpa == 1 and $total8 != 0) {
			$p208 = round($total8 * 100 / (100 + $_fp8), $p_dek);
			$p308 = $total8 - $p208;
		}elseif($wthfpa == 0 and $total8 != 0) {
			$p308 = round($total8 * ($_fp8) / 100, $p_dek);
			$p208 = $total8;
		}

		################
		#Katigoria fpa 9
		################
		if($p420==1  and $pkath9 != 0 ){
			$p209 = round( $pkath9 , $p_dek);
			$p309 = round( $pfpa9  , $p_dek);
		}elseif($wthfpa == 1 and $total9 != 0) {
			$p209 = round($total9 * 100 / (100 + $_fp9), $p_dek);
			$p309 = $total9 - $p209;
		}elseif($wthfpa == 0 and $total9 != 0) {
			$p309 = round($total9 * ($_fp9) / 100, $p_dek);
			$p209 = $total9;
		}
	} else {
		$p201 = $_totals['p201'];
		$p202 = $_totals['p202'];
		$p203 = $_totals['p203'];
		$p204 = $_totals['p204'];
		$p205 = $_totals['p205'];
		$p206 = $_totals['p206'];
		$p207 = $_totals['p207'];
		$p208 = $_totals['p208'];
		$p209 = $_totals['p209'];

		$p301 = $_totals['p301'];
		$p302 = $_totals['p302'];
		$p303 = $_totals['p303'];
		$p304 = $_totals['p304'];
		$p305 = $_totals['p305'];
		$p306 = $_totals['p306'];
		$p307 = $_totals['p307'];
		$p308 = $_totals['p308'];
		$p309 = $_totals['p309'];
	}

	$p0100  =  $p201 + $p202 + $p203 + $p204 + $p205 + $p206 + $p207 + $p208 + $p209;



	//***total discount
	if ($p0102_2 > 0) {
		//***totals pre discound

		/**
		 * p0100 = Arxiki axia
		 * p0102 = Ekptosi sto synolo
		 * p0105 = FPA
		 * p0108 = Epibarunseis
		 * p0112 = %Kratisis
		 * p0113 = %Forou
		 * p0109 = Sunolo
		 *
		 * $vp0112 = Poso kratiseon : pososto * kathari
		 * $vp0113 = Poso forou : pososto * kathari
		 *
		 */


		$p0102 = 0;

		$vp0112 = round(($p0100 - $p0102) * $p0112 / 100, $p_dek);
		$vp0113 = round(($p0100 - $vp0112 - $p0102) * $p0113 / 100, $p_dek);


		$p0105 = $p301 + $p302 + $p303 + $p304 + $p305 + $p306 + $p307 + $p308 + $p309;
		$p0109 = $p0100 - $p0102 + $p0105 + $p0108 - $vp0112 - $vp0113;
		$vp0109 = round($p0100 - $p0102, $p_dek);

		if (empty($p0109)) {
			$p0101 = 0;
		} else {
			$p0101 = 100 * $p0102_2 / $p0109;
		}


		$p0102_1 = 0;
		$p0109_1 = $p0109 - $p0102_2;
	}

	///***discount pre VAT
	if ($p0102_1 > 0) {
		$p0101   = 0;
		$p0102   = $p0102_1;
		$p0102_2 = 0;
		$p0109_1 = 0;
	}

	if ($p0101 != 0) {
		$p0102  = $p0100 * $p0101 / 100;
	} else {
		if ($p0100 != 0) {
			$p0101 =  $p0102 * 100 / $p0100;
		}
	}

	if ($p0101 < 0) {
		$p0101 = 0;
	}

	if ($p0101 == 0) {
		$p0109_1 = 0;
	}

	if ($p410 == 0) {
		if ($p0101 != 0) {
			$i = 0;
			while ($i < 9) {
				$i++;
				${'p20' . $i} = round(${'p20' . $i} * (100 - $p0101) / 100, $p_dek);
				${'p30' . $i} = round(${'p20' . $i} * ${'_fp' . $i} / 100, $p_dek);
			}
		}
	}

	//$p0101  = 0;
	$p0102  = round($p0100 * $p0101 / 100, $p_dek);
	$vp0112 = round(($p0100 - $p0102) * $p0112 / 100, $p_dek);
	$vp0113 = round(($p0100 - $vp0112 - $p0102) * $p0113 / 100, $p_dek);

	$p0105  = $p301 + $p302 + $p303 + $p304 + $p305 + $p306 + $p307 + $p308 + $p309;
	$p0109  = $p0100 - $p0102 + $p0105 + $p0108 - $vp0112 - $vp0113;
	$vp0109 = $p0100 - $p0102;



	if ($p0109_1 > 0) {
		$p0109  = $p0109_1;
		$vp0109 = round($p0109 - $p0105 - $p0108 + $vp0112 + $vp0113, $p_dek);
	}

	if (abs(round($p0109_1 - $p0109, 2)) > 0.02) {
		$p0109_1 = 0;
	}

	if ($p0109_1 > 0 and abs(round($p0109_1 - $p0109, 2)) < 0.02) {
		$p0109 = $p0109_1;
		$vp0109 = round($p0109 - $p0105 - $p0108 + $vp0112 + $vp0113, $p_dek);
	}

	//*** corect totals
	$return = 0;
	$peg_nnn  = round($p201 + $p202 + $p203 + $p204 + $p205 + $p206 + $p207 + $p208 + $p209, $p_dek);
	if (round($vp0109, $p_dek) == round($peg_nnn, $p_dek) or $p410 == 1) {
		$return = 1;
	}

	$i = 0;
	while ($i < 9 and $return == 0) {
		$i++;
		if (round($vp0109, $p_dek) != round($peg_nnn, $p_dek) and $p410 == 0 and  ${'p20' . $i} > 0) {
			${'p20' . $i} = ${'p20' . $i} + round($vp0109, $p_dek) - round($peg_nnn, $p_dek);
			$return = 1;
		}
	}

	$return_array['p0100']  = $p0100;   // kathari axia
	$return_array['p0101']  = $p0101;   // posossto ekptvshs
	$return_array['p0102']  = $p0102;  // ekptvsis

	$return_array['p0102_1']  = $p0102_1;  // ekptvsis pro fpa
	$return_array['p0102_2']  = $p0102_2;  // ekptvsis epi toy sunolou

	$return_array['p0112']  = $p0112;  // kratiseis pososto
	$return_array['vp0112'] = $vp0112; // kratiseis

	$return_array['p0113']  = $p0113;  // foros pososto
	$return_array['vp0113'] = $vp0113; // foros
	$return_array['p0105']  = $p0105;  // fpa
	$return_array['p0108']  = $p0108;  // Epibarynseis

	$return_array['p0109']  = $p0109;  // Synolo

	$return_array['p201']  = $p201;
	$return_array['p202']  = $p202;
	$return_array['p203']  = $p203;
	$return_array['p204']  = $p204;
	$return_array['p205']  = $p205;
	$return_array['p206']  = $p206;
	$return_array['p207']  = $p207;
	$return_array['p208']  = $p208;
	$return_array['p209']  = $p209;

	$return_array['p301']  = $p301;
	$return_array['p302']  = $p302;
	$return_array['p303']  = $p303;
	$return_array['p304']  = $p304;
	$return_array['p305']  = $p305;
	$return_array['p306']  = $p306;
	$return_array['p307']  = $p307;
	$return_array['p308']  = $p308;
	$return_array['p309']  = $p309;

	$vp0109 = $p0100 - $p0102;

	if($mode == 'retail00_01') {
		$mode = 'a55';
	}
	// Reload Taxes and Deductions
	$query =
		"select * from peg_tmp_i71
		 where
			 peg_sess_id =:peg_sess_id and
			 peg_mmnr01  =:peg_mmnr01 and
			 peg_mnr01   =:peg_mnr01 and
			 peg_flag   !=9 and
			 tbl     =:tbl and
			 tbl_nr  =:tbl_nr ";

	$query_values = array(
		'peg_sess_id' => session_id(),
		'peg_mmnr01'  => $mode . '_d-' . $nr01,//retail: 16/05 if mode retail se a55_d-546
		'peg_mnr01'   => $nr01,
		'tbl'     => $mode,
		'tbl_nr'  => $nr01
	);
	//echo pegasus_replace_values_in_sql($query, $query_values);
	//echo "wthfpa: $wthfpa";
	$i71_res = pegasus_query($query, $query_values);
	while ($i71 = pegasus_fetch_assoc($i71_res)) {
		$i71['tbl_p07'] = $preview_with_vat	;
		$i71['tbl_pn02'] = $pn02;
		$i71_data = invoices_i71_d_refresh($i71, $vp0109);
		//print_r($i71_data);
		pegasus_mysql_update(
			'peg_tmp_i71',
			array('p04', 'p05', 'p100', 'peg_flag'),
			array($i71_data['p04'], $i71_data['p05'], $i71_data['p100'], '2'),
			" 	peg_sess_id 	=:peg_sess_id
				AND	peg_mmnr01  =:peg_mmnr01
				AND	peg_mnr01   =:peg_mnr01
				AND	peg_flag   	!=9
				AND	tbl         =:tbl
				AND	tbl_nr      =:tbl_nr
				AND	nr01        =:nr01 ",
			0,
			1,
			1,
			array_merge($query_values, array('nr01' => $i71['nr01']))
		);
	}

	// MAKE TOTALS update
	// Taxes Total
	$return_array['p0600']  = (1) * pegasus_mysql_printfld(
		'peg_tmp_i71',
		'sum(ifnull(p100,0))',
		'	peg_sess_id =:peg_sess_id and
			peg_mmnr01  =:peg_mmnr01 and
			peg_mnr01   =:peg_mnr01 and
			peg_flag   !=9 and
			tbl     =:tbl and
			tbl_nr  =:tbl_nr and i70p02=1 and i70p07=1 ',
		$query_values
	);


	// echo pegasus_replace_values_in_sql('	peg_sess_id =:peg_sess_id and
	// peg_mmnr01  =:peg_mmnr01 and
	// peg_mnr01   =:peg_mnr01 and
	// peg_flag   !=9 and
	// tbl     =:tbl and
	// tbl_nr  =:tbl_nr and i70p02=1 and i70p07=1 ' , $query_values);


	// Deductions Total
	$return_array['p0601']  = (1) * pegasus_mysql_printfld(
		'peg_tmp_i71',
		'sum(ifnull(p100,0))',
		'	peg_sess_id =:peg_sess_id and
			peg_mmnr01  =:peg_mmnr01 and
			peg_mnr01   =:peg_mnr01 and
			peg_flag   !=9 and
			tbl     =:tbl and
			tbl_nr  =:tbl_nr and i70p02=2 and i70p07=1 ',
		$query_values
	);

	$return_array['pn02'] = $pn02;

	$return_array['p0109'] += $return_array['p0600'] - $return_array['p0601'];

	$return_array['p0109'] = round($return_array['p0109'], 2);

	return  $return_array;
}
function invoices_orders_to_invoices(
    $orders_nr01_str = '',
	$mode = ''
) {
    $orders_nr01 = explode(';',$orders_nr01_str);
	$count = count($orders_nr01);
    $mode_mnr01 = array_pop($orders_nr01);

	if($mode == 'a57'){
		$p05 = pegasus_mysql_printfld('a57','p05','nr01=?',array($mode_mnr01));
		$p03 = pegasus_mysql_printfld('a57','p03','nr01=?',array($mode_mnr01));
		$inv_code = pegasus_mysql_printfld('a10','p00','p01=?',array($p05));
		$inv_cust = pegasus_mysql_printfld('a01','p19','nr01=?',array($p03));
		$new_screen = 'a55';
		$module = 'invcust';
	}elseif($mode == 'a67'){
		$p05 = pegasus_mysql_printfld('a67','p05','nr01=?',array($mode_mnr01));
		$p03 = pegasus_mysql_printfld('a67','p03','nr01=?',array($mode_mnr01));
		$inv_code = pegasus_mysql_printfld('a11','p00','p01=?',array($p05));
		$inv_cust = pegasus_mysql_printfld('a00','p19','nr01=?',array($p03));
		$new_screen = 'a56';
		$module = 'invsupp';
	}

    $request_backup = $_REQUEST;
	$_REQUEST = array(
		$mode.'_mnr01'	        => $mode_mnr01,
		'append_mnr01'		=> implode(',',$orders_nr01),
	);
	$screen = new screen();
	$screen->container_id = pegasus_container_id_create(0 , session_id() , $new_screen.'_d');
	$screen->module       = $module;
	$screen->_d           = $new_screen.'_d';
	$screen->table        = $new_screen;
	$screen->read_data_from_db(1,1);
	$screen->read_params_from_db();
	$data = array();
	/**
	 * Καλούμε την invoices_document_after_save_global_check μόνο για να δούμε αν το παραστατικό θα 
	 * σταλεί με CnA το οποίο δεν μπορούμε να υποστηρίξουμε.
	 * Στο κύκλωμα των προμηθευτών δεν έχουμε CnA
	 */
	$invoices_document_after_save_global_check_resp = invoices_document_after_save_global_check($new_screen, $screen->data['nr01']);
	if($invoices_document_after_save_global_check_resp['data']['ca_server'] == true) {
		$signatures_config = ca_server_get_signatures_configuration($screen->data['p05'], $screen->data['p701'], $screen->data['p0121']);
		if ($signatures_config['config_count'] != 0) {
			$msg = '<i class="fas fa-times" style="color:red"></i> '.$_SESSION['peg_dic_invoices_invoice_mass_order_fiscal_fail'];
			peg_close_d($screen->container_id);
			return array(
				'ok'				=> 0,
				'data'				=> array(),
				'msg'				=> $msg
			);
		}
	}
	$_REQUEST = $screen->data;
	$error = $_REQUEST['permDenyMessage'];
	$_REQUEST['no_confirm'] = 1;
	$ret_array = $screen->save_data();
	peg_close_d($screen->container_id);
	$_REQUEST = $request_backup;
	if(!empty($ret_array[1])){
		$msg = '<i class="fas fa-times" style="color:red"></i> ';
		$msg .= $_SESSION['peg_dic_invoices_invoice_mass_order_fail'];
		$msg = str_replace(
			array(
				'#count#',
				'#inv_cust#',
			),
			array(
				$count,
				$inv_cust,
			),
			$msg
		);
		if($error){
			$msg .= $error.".<br>";
		}
		$msg .= str_replace("<br>", "\n", $ret_array[1]);
		return array(
			'ok'				=> 0,
			'data'				=> $ret_array,
			'msg'				=> $msg
		);
	}
	/**
	 * Τώρα που έχουμε nr01 (Έχουμε κάνει save) καλούμε ξανά την invoices_document_after_save_global_check 
	 * για να δούμε τον τρόπο που θα αποσταλεί το παραστατικό (έχουμε αποκλείσει παραπάνω το CnA).
	 */
	$invoices_document_after_save_global_check_resp = invoices_document_after_save_global_check($new_screen, $screen->data['nr01']);
	// Δεν αποστέλλουμε τα παραστατικά με Pegasus
	if($invoices_document_after_save_global_check_resp['data']['einv'] == true) {
		$einv00_check_and_save_resp = einv00_check_and_save($new_screen,$screen->data['nr01'],0);
		$data['einv'] = $einv00_check_and_save_resp['msg'];
	}
	// Δεν αποστέλλουμε τα παραστατικά με SoftOne
	if($invoices_document_after_save_global_check_resp['data']['einv01'] == true) {
		$msg = '<i class="fas fa-times" style="color:red"></i> '.$_SESSION['peg_dic_invoices_invoice_mass_order_softone_fail'];
		return array(
			'ok'				=> 0,
			'data'				=> array(),
			'msg'				=> $msg
		);
	}
	// Αν πρέπει να αποσταλεί με MyData
	if($invoices_document_after_save_global_check_resp['data']['mydt'] == true) {
		$mydt_create_n_send_resp = mydt_create_n_send($new_screen, $screen->data['nr01'], true);
		$mydt_errors = array();
		foreach ($mydt_create_n_send_resp as $v) {
			if (
				$v['has_pegasus_error'] == 1
                || ($v['has_msg_from_mydt_send_to_aade'] == 1 && $v['ok'] == 0)
			) {
				$mydt_errors[] = $v['msg'];
			}
		}
	}   
	if($mode == 'a57'){
		$data['a55'] = $screen->nr01;
	}elseif($mode == 'a67'){
		$data['a56'] = $screen->nr01;
	}
	$msg = '<i class="fas fa-check" style="color:green"></i> ';
	$msg .= str_replace(
		array(
			'#count#',
			'#inv_code#',
			'#inv_cust#',
		),
		array(
			$count,
			$inv_code,
			$inv_cust,
		),
		$_SESSION['peg_dic_invoices_invoice_mass_order_success']
	);
	
	if(!empty($mydt_errors)) {
		$msg .= '<br><i class="fas fa-times" style="color:red"></i> '.implode('<br><i class="fas fa-times" style="color:red"></i> ',$mydt_errors);
	}
	return array(
		'ok'				=> 1,
		'data'				=> $data,
		'msg'				=> $msg
	);
}
/**
 * @todo Πρέπει να αφαιρεθεί το mode ή να οριστεί σωστά από τα args
 *
 * @param  array   $data
 * @param  array   $permDeny
 * @param  string  $mmnr01
 * @param  string  $mode
 * @param  integer $grid_editing
 * @return array $permDeny
 */
function invoices_check_data(
	$data = array(), 
	$permDeny = array(), 
	$mmnr01 = '', 
	$mode = '', 
	$grid_editing = 0
) {
	if (empty($mode)) {
		$mode = strtolower(substr($mmnr01, 0, 3));
	}
	/**
	 * Αν είναι παραστατικό πελάτη ή προμηθευτή και ο κωδικός παραστατικού που ακυρώνει 
	 * είναι μεγαλύτερος του μηδενός (Άρα το παραστατικό ακυρώνει κάποιο άλλο).
	 * Ενημερώνουμε όλα τα line items του παραστατικού ως άκυρα (p012: Συντελεστής (-1=άκυρα))
	 */
	if(
		(
			$mode == 'a55'
			|| $mode == 'a56'
		)
		&& $data['p414'] > 0
	) {
		$_where_eidi = pegasusGetGlobalVar('peg_' . $mmnr01 . '_where_eidi');
		$where = '';
		$values = array();
		if(is_array($_where_eidi)) {
			$where = $_where_eidi['sql'];
			$values = $_where_eidi['sqlParams'];
		} else {
			$where = $_where_eidi;
		}
		pegasus_mysql_update(
			'peg_tmp_i01',
			array('p012'),
			array(-1),
			$where,
			$values
		);
	}
	/**
	 * Αν είναι παραστατικό (και όχι παραγγελία) 
	 */
	if (
		$mode == "a55" 
		|| $mode == "a56" 
		|| $mode == 'a60'
	) {
		$_where_eidi = pegasusGetGlobalVar('peg_' . $mmnr01 . '_where_eidi');
		$where = '';
		$values = array();
		if(is_array($_where_eidi)) {
			$where = $_where_eidi['sql'];
			$values = $_where_eidi['sqlParams'];
		} else {
			$where = $_where_eidi;
		}
		/**
		 * Αν ο τύπος παραστατικού πελάτη ή προμηθευτή έχει επιτρεπτούς τύπους ειδώ
		 */
		$only_i10_p02s = array();
		$axx_p32 = '';
		if($mode == "a55") {
			$axx_p32 = pegasus_mysql_printfld("a10", "p32", "p01 = :p01", array('p01' => $data['p05']));
		} else if ($mode == "a56") {
			$axx_p32 = pegasus_mysql_printfld("a11", "p32", "p01 = :p01", array('p01' => $data['p05']));
		}
		if(!empty($axx_p32)) {
			$only_i10_p02s = explode('#',trim($axx_p32,'#'));
		}
		$sql = "	SELECT
						peg_tmp_i01.nr01,
						peg_tmp_i01.p01,
						peg_tmp_i01.p02,
						peg_tmp_i01.p03,
						peg_tmp_i01.p04,
						peg_tmp_i01.p012,
						i00.pno			AS i00_pno,
						i00.name		AS i00_name,
						i00.p62			AS i00_p62,
						i00.p614		AS i00_p614
					FROM peg_tmp_i01
					JOIN i00 ON peg_tmp_i01.p01 = i00.pno
					WHERE 1 = 1 AND (peg_tmp_i01.ppnr01 = 0 OR peg_tmp_i01.ppnr01 = peg_tmp_i01.nr01)
					AND $where
					GROUP BY peg_tmp_i01.nr01
		";
		$res = pegasus_query($sql, $values);
		while($lineItem = pegasus_fetch_assoc($res)) {
			/**
			 * Αν έχουν οριστεί επιτρεπτοί τύποι ειδών και το είδος τις κίνησης δεν είναι σε αυτούς 
			 */
			if(
				!empty($only_i10_p02s)
				&& !in_array($lineItem['i00_p62'],$only_i10_p02s)
			) {
				$message = str_replace(
					array('##eidos##', '##i01_nr01##'),
					array($lineItem['i00_pno']." ".$lineItem['i00_name'], $lineItem['nr01']),
					$_SESSION['peg_dic_invoices_invalid_i10']
				);
				$permDeny[] = array('type' => 'deny', 'message' => $message);
			}
			/**
			 * Αν η ποσότητα της  κίνησης δεν είναι μεγαλύτερη του μηδενός
			 */
			if(!($lineItem['p03'] > 0)) {
				$message = str_replace(
					array('##eidos##', '##i01_nr01##'),
					array("{$lineItem['i00_pno']} {$lineItem['i00_name']}", "{$lineItem['nr01']}"),
					$_SESSION['peg_dic_invoices_invalid_qnt']
				);
				$permDeny[] = array('type' => 'deny', 'message' => $message);
			}
			/**
			 * Έλεγχος κατώτερης τιμής πώλησης
			 */
			$permDeny = invoices_check_min_price(
				$mode, 
				$lineItem, 
				$permDeny, 
				$mmnr01
			);
		}
	}

	if (pegasus_module_exists('colorsize') and ($mode == 'a55' or $mode == 'a56' or $mode == 'a60')) {

		if($grid_editing==0){
			$i01_tbl = "peg_tmp_i01";
			$where   = pegasusGetGlobalVar('peg_' . $mmnr01 . '_where_eidi');
		}else{
			$i01_tbl = "i01";
			$where 	 = array(
				'sql' => "i01.p07='3' and i01.p06=:i01_p06", 
				'sqlParams' => array('i01_p06'=>$data['nr01'])
			);
		}
		
		$values_arr = array();
		if (is_array($where)) {
			$values_arr = $where['sqlParams'];
			$where 	    = $where['sql'];
		}

		$i01_query = "	SELECT 	i00.pno,
								i00.name,
								i01.nr01,
								i01.p03,
								count(i47.nr01) AS i47cnt
							FROM (	SELECT *
									FROM " . $i01_tbl . "
									WHERE " . $where . " AND (peg_tmp_i01.ppnr01 = 0 OR peg_tmp_i01.ppnr01 = peg_tmp_i01.nr01)
								 )  AS i01
							JOIN i00 ON i01.p01 = i00.pno
							JOIN i47 ON i00.nr01 = i47.i00
							GROUP BY i01.nr01";
							
		//echo pegasus_replace_values_in_sql($i01_query,$values_arr);		
		$i01_res = pegasus_query($i01_query, $values_arr);

		while ($i01_tmp =  pegasus_fetch($i01_res)) {
			if($grid_editing==0){
				$i48_tbl   = "peg_tmp_i48";
				$i48_where = "	peg_tmp_i48.p01= :p01 AND
								peg_tmp_i48.peg_mnr01= :peg_mnr01 AND
								peg_tmp_i48.peg_mmnr01= :peg_mmnr01 AND
								peg_tmp_i48.peg_sess_id= :peg_sess_id AND
								peg_tmp_i48.peg_flag!=9";
				$i48_query_vals = array(
					'p01'			=>	$i01_tmp['nr01'],
					'peg_mnr01'		=>	$i01_tmp['nr01'],
					'peg_mmnr01'	=>	substr($mmnr01, 0, 5) . '-' . $data['nr01'],
					'peg_sess_id'	=>	session_id()
				);
			}else{
				$i48_tbl   = "i48";
				$i48_where = "i48.p01=:i01nr01";
				$i48_query_vals = array('i01nr01' => $i01_tmp['nr01']);
			}

			$i48_query = '	SELECT sum(p04) AS i48_p04
								FROM '.$i48_tbl.'
								WHERE 	'.$i48_where.';';

			//echo pegasus_replace_values_in_sql($i48_query,$i48_query_vals);	
			pegasus_mysql_use($i48_query, $i48_tmp, $i48_query_vals);
			
			
			$i48_p04 = $i48_tmp['i48_p04'];
			if (empty($i48_p04)) {
				$i48_p04 = 0;
			}

			if ($i48_p04 != $i01_tmp['p03']) {
				array_push($permDeny, array('type' => 'deny', 'message' => str_replace('##i01_nr01##', $i01_tmp['nr01'],  str_replace('##eidos##', $i01_tmp['pno'] . ' ' . $i01_tmp['name'],  $_SESSION['peg_dic_invoices_color_size_qnt'])) . '(' . $i01_tmp['p03'] . '/' . $i48_p04 . ' )'));
			}
		}
	}

	//retail: εδώ κάνει μόνο για παραγγελίες, δεν θα με πειράξει.
	$permDeny = invoices_check_availability($data,  $permDeny, $mmnr01, $mode, $grid_editing);

	$data['nr01'] = intval($data['nr01']);
	if (pegasus_module_exists('colorsize')) {
		if ($mode == 'a57') {		

			if($grid_editing==0){
				$a58_tbl   = "peg_tmp_a58";
				$a58_where = pegasusGetGlobalVar('peg_' . $mmnr01 . '_where_eidi');
				$a58_query_vals = array();
			}else{
				$a58_tbl   = "a58";
				$a58_where = "a58.p00=:a57nr01";
				$a58_query_vals = array('a57nr01' => $data['nr01']);
			}
			$a58_query =  "	SELECT i00.pno,i00.name,a58.nr01,a58.v103 , count(i47.nr01) AS i47cnt
								FROM (	SELECT *
										FROM ".$a58_tbl."
										WHERE ".$a58_where." 
									  )  AS a58
								JOIN i00 ON a58.v101 = i00.pno
								JOIN i47 ON i00.nr01 = i47.i00
								GROUP BY a58.nr01";

			$a58_res = pegasus_query($a58_query, $a58_query_vals);
			while ($a58_tmp =  pegasus_fetch($a58_res)) {
				if($grid_editing==0){
					$a59_tbl   = "peg_tmp_a59";
					$a59_where = "	peg_tmp_a59.p01=:p01 AND
									peg_tmp_a59.peg_mnr01= :peg_mnr01 AND
									peg_tmp_a59.peg_mmnr01= :peg_mmnr01 AND
									peg_tmp_a59.peg_sess_id= :peg_sess_id AND
									peg_tmp_a59.peg_flag!=9";
					$a59_query_vals = array(
						'p01'			=>	$a58_tmp['nr01'],
						'peg_mnr01'		=>	$a58_tmp['nr01'],
						'peg_mmnr01'	=>	substr($mmnr01, 0, 5) . '-' . $data['nr01'],
						'peg_sess_id'	=>	session_id()
					);
				}else{
					$a59_tbl   = "a59";
					$a59_where = "a59.p01=:a58nr01";
					$a59_query_vals = array('a58nr01' => $a58_tmp['nr01']);
				}

				$a59_query = 'SELECT sum(p04) AS a59_p04 FROM '.$a59_tbl.' WHERE '.$a59_where;
				
				pegasus_mysql_use($a59_query, $a59_tmp, $a59_query_vals);
				
				$a59_p04 = $a59_tmp['a59_p04'];
				if (empty($a59_p04)) {
					$a59_p04 = 0;
				}
				if ($a59_p04 != $a58_tmp['v103']) {
					array_push($permDeny, array('type' => 'deny', 'message' => str_replace('##i01_nr01##', $a58_tmp['nr01'],  str_replace('##eidos##', $a58_tmp['pno'] . ' ' . $a58_tmp['name'],  $_SESSION['peg_dic_invoices_color_size_qnt'])) . '(' . $a58_tmp['v103'] . '/' . $a59_p04 . ' )'));
				}
			}
		}

		if ($mode == 'a67') {
			$a68_query =  "	SELECT i00.pno,i00.name,a68.nr01,a68.v103 , count(i47.nr01) AS i47cnt
								FROM (	SELECT *
										FROM peg_tmp_a68
										WHERE " . pegasusGetGlobalVar('peg_' . $mmnr01 . '_where_eidi') . "
									) AS a68
								JOIN i00 ON a68.v101 = i00.pno
								JOIN i47 ON i00.nr01 = i47.i00
								GROUP BY a68.nr01";
			$a68_res = pegasus_query($a68_query);
			while ($a68_tmp =  pegasus_fetch($a68_res)) {
				$a69_query = '	SELECT sum(p04) AS a69_p04
									FROM peg_tmp_a69
									WHERE  	peg_tmp_a69.p01=:p01 AND
											peg_tmp_a69.peg_mnr01= :peg_mnr01 AND
											peg_tmp_a69.peg_mmnr01= :peg_mmnr01 AND
											peg_tmp_a69.peg_sess_id= :peg_sess_id AND
											peg_tmp_a69.peg_flag!=9';
				$a69_query_vals = array(
					'p01'			=>	$a68_tmp['nr01'],
					'peg_mnr01'		=> 	$a68_tmp['nr01'],
					'peg_mmnr01'	=>	substr($mmnr01, 0, 5) . '-' . $data['nr01'],
					'peg_sess_id'	=>	session_id()
				);
				pegasus_mysql_use($a69_query, $a69_tmp, $a69_query_vals);
				$a69_p04 = $a69_tmp['a69_p04'];
				if (empty($a69_p04)) {
					$a69_p04 = 0;
				}
				if ($a69_p04 != $a68_tmp['v103']) {
					array_push($permDeny, array('type' => 'deny', 'message' => str_replace('##i01_nr01##', $a68_tmp['nr01'],  str_replace('##eidos##', $a68_tmp['pno'] . ' ' . $a68_tmp['name'],  $_SESSION['peg_dic_invoices_color_size_qnt'])) . '(' . $a68_tmp['v103'] . '/' . $a69_p04 . ' )'));
				}
			}
		}
		if ($mode == 'a61') {
			$a62_query =  "	SELECT i00.pno,i00.name,a62.nr01,a62.v103 , count(i47.nr01) AS i47cnt
								FROM ( 	SELECT *
										FROM peg_tmp_a62
										WHERE " . pegasusGetGlobalVar('peg_' . $mmnr01 . '_where_eidi') . "
									 ) AS a62
								JOIN i00 ON a62.v101 = i00.pno
								JOIN i47 ON i00.nr01 = i47.i00
								GROUP BY a62.nr01";

			$a62_res = pegasus_query($a62_query);
			while ($a62_tmp =  pegasus_fetch($a62_res)) {
				$a63_query = '	select sum(p04) as a63_p04
									from peg_tmp_a63
									where
										peg_tmp_a63.p01=? and
										peg_tmp_a63.peg_mnr01=? and
										peg_tmp_a63.peg_mmnr01=? and
										peg_tmp_a63.peg_sess_id=? and
										peg_tmp_a63.peg_flag!=9';
				pegasus_mysql_use($a63_query, $a63_tmp, array(
					$a62_tmp['nr01'],
					$a62_tmp['nr01'],
					substr($mmnr01, 0, 5) . '-' . $data['nr01'],
					session_id()
				));
				$a63_p04 = $a63_tmp['a63_p04'];
				if (empty($a63_p04)) {
					$a63_p04 = 0;
				}
				if ($a63_p04 != $a62_tmp['v103']) {
					array_push($permDeny, array('type' => 'deny', 'message' => str_replace('##i01_nr01##', $a62_tmp['nr01'],  str_replace('##eidos##', $a62_tmp['pno'] . ' ' . $a62_tmp['name'],  $_SESSION['peg_dic_invoices_color_size_qnt'])) . '(' . $a62_tmp['v103'] . '/' . $a63_p04 . ' )'));
				}
			}
		}
	}


	//Ελεγχος Φόρων/Κρατήσεων
	$where_i71_d00 = pegasusGetGlobalVar('peg_' . $mode . '_d-' . $data['nr01'] . '_where_i71_d00');

	if(!empty($where_i71_d00['sql'])){
		$query_i71  = "select nr01,tbl,tbl_nr,i70p02,i70 ";
		$query_i71 .= "from peg_tmp_i71 ";
		$query_i71 .= "where " . $where_i71_d00['sql'] . " ";
		$query_i71 .= "order by tax;";
	
		$result_i71 = pegasus_query($query_i71, $where_i71_d00['sqlParams']);
		while($i71_tmp=pegasus_fetch_assoc($result_i71)){
			if(!($i71_tmp['i70']>0)){
				array_push($permDeny, array('type'=>'deny', 'message'=>$_SESSION['peg_dic_invoices_empty_i71_i70']));	
				break;
			}
		}
	}


	//Ελεγχος δωροεπιταγής
	if (pegasus_module_exists('giftcards') and ($mode == 'a55' or $mode == 'a57')) {

		$ttt = 0;
		if ($mode == 'a55' and ($data['p414'] > 0 or $data['p601a'] > 0)) {
			$ttt = 1;
		}



		//***doroepitagh
		if (!empty($data['p506'])  and $ttt == 0) {
			pegasus_mysql_use("SELECT * FROM erpa80 WHERE nr01=? ", $erpa80, array($data['p506']));

			if ($erpa80['nr01'] > 0) {
				if ($erpa80['p06'] <= 0 and $erpa80['p012'] <= 0) {
					array_push($permDeny, array('type' => 'deny', 'message' =>   $_SESSION['peg_dic_giftcards_empty_amount']));
				}

				if ($erpa80['p09'] != 0) {
					array_push($permDeny, array('type' => 'deny', 'message' =>   $_SESSION['peg_dic_giftcards_disabled']));
				}

				if (peg_dateDiff($erpa80['p03'], $data['p01'], 'Y-m-d') > 0 or peg_dateDiff($data['p01'], $erpa80['p04'], 'Y-m-d') > 0) {
					$msg = str_replace('#1#', peg_dateToStr($erpa80['p03'], 'd/m/Y'), str_replace('#2#', peg_dateToStr($erpa80['p04'], 'd/m/Y'), $_SESSION['peg_dic_giftcards_out_of_date']));
					array_push($permDeny, array('type' => 'deny', 'message' =>  $msg));
				}

				//Πλέον ο έλεγχος αυτός γίνεται με την παρακάτω συνάρτηση και όχι από το p08.
				$is_eksoflimeni = giftcards_check_if_eksoflimeni($data['nr01'], $data['p506'], $data['p05']);
				// if (!empty($erpa80['p08'])) {
				if ($is_eksoflimeni >= 1) {
					array_push($permDeny, array('type' => 'deny', 'message' =>  $_SESSION['peg_dic_giftcards_is_closed']));
				}

				if ($erpa80['p01'] != $data['p03'] and $erpa80['p13'] == 0) {
					array_push($permDeny, array('type' => 'confirm', 'message' =>  $_SESSION['peg_dic_giftcards_other_customer']));
				}

				//not valid invoice value
				$peg_nnn = 0;

				if ($data['p06'] > 0) {
					$peg_nnn = $data['p06'];
				} else {
					$peg_nnn = (float)$data['p012'] * (float)$data['p0109'] / 100;
				}
				// An to elaxisto poso parastikoy pot exei oristei sthn dwroepitagi einai megalitero apo to poso toy parastikoy
				if (((float)$data['p011'] - (float)$peg_nnn) > $data['p0109']) {

					$msg = $_SESSION['peg_dic_giftcards_msg_315'];
					$msg = str_replace('#1#', $data['p011'], $msg);
					$msg = str_replace('#2#', $data['p0109'], $msg);
					$msg = str_replace('#3#', $data['p0109'] + $peg_nnn, $msg);
					array_push($permDeny, array('type' => 'deny', 'message' => $msg));
				}


				//Ελεγχός αν ο πελατης έχει ξαναχρησιμοποιήσει την δωροεπιταγη giftcards_msg_318
				$peg_nnn = 0;
				if ($erpa80['p13'] == 1) {
					if ($mode == 'a55') {


						$peg_str = " && erpa80.nr01='" . intval($erpa80['nr01']) . "' && a55.p03='" . intval($data['p03']) . "' && a55.nr01!=" . intval($data['nr01']);
						$sql = pegasus_get_view_sql_code('erpa80_d02', $peg_str);
						$sql = "SELECT sum(p106) as fld FROM ( " .  $sql . " ) as tbl01 GROUP BY nr01;";
						pegasus_mysql_use($sql, $tbl);

						if ($tbl['fld'] > 0) {
							array_push($permDeny, array('type' => 'deny', 'message' =>  $_SESSION['peg_dic_giftcards_msg_318']));
						}
					}
				}
			} else {
				array_push($permDeny, array('type' => 'deny', 'message' =>   $_SESSION['peg_dic_giftcards_not_exist']));
			}
		}
	}
	return $permDeny;
}


function invoices_check_availability($data, $permDeny=array(), $mmnr01 ='', $mode='', $grid_editing=0) {
	$where_eidi = pegasusGetGlobalVar('peg_' . $mmnr01 . '_where_eidi');

	if($mode == "a57") {
		if($grid_editing==0){
			$a58_tbl   = "peg_tmp_a58";
			$a58_where = $where_eidi;
			$a58_query_vals = array(
				'nr01' 		 => $data['nr01'],
				'mmnr01' 	 => 'a57_d-' . $data['nr01'],
				'session_id' => session_id()
			);
		}else{
			$a58_tbl   = "a58";
			$a58_where = "a58.p00=:a57nr01";
			$a58_query_vals = array('a57nr01' => $data['nr01']);
		}

		$a58_query = 'select * from '.$a58_tbl.' where '.$a58_where;
		
		$a58_res = pegasus_query($a58_query, $a58_query_vals);
		while ($a58_tmp = pegasus_fetch($a58_res)) {
			$msg = ordercust_check_product_availability($data['nr01'], $data['p590'], $data['p703'], $a58_tmp['nr01']);
			if (!pegasus_check_permission('ordercust.deny_if_unavailable') && !empty($msg)) {
				array_push($permDeny, array('type' => 'deny', 'message' => $msg));
			}
		}
	} else if(in_array($mode, array("a55", "a56", "a60"))) {
    	// Επιτρέπεται η εξαγωγή είδους χωρίς υπόλοιπο σε νέες εγγραφές
		if(pegasus_check_permission('invoices_check_balance')) { 
			return $permDeny;
		}

		$mode_nr01 = pegasus_mysql_printfld($mode, "nr01", "nr01 = :nr01", array("nr01" => $data['nr01']));

		// Μόνο αν είναι νέο παραστατικό θα προχωρήσει από την if
		if($mode_nr01 > 0) {
			return $permDeny;
		}

		$p05 = pegasusGetGlobalVar('peg_'.$mode.'_d-' . $data['nr01'] . '_p05');
		$res = array();

		if($mode == "a55") {
			$query = "SELECT ((i15.p03 - i15.p04) < 0) as is_export FROM a10 LEFT JOIN i15 on i15.p01 = a10.p05 WHERE a10.p01 = :p05";

			pegasus_mysql_use($query, $res, array("p05"=>$p05));

			if(!$res['is_export']) {
				return $permDeny;
			}
		} else if($mode == "a56") {
			$query = "SELECT ((i15.p03 - i15.p04) < 0) as is_export FROM a11 LEFT JOIN i15 on i15.p01 = a11.p05 WHERE a11.p01 = :p05";

			pegasus_mysql_use($query, $res, array("p05"=>$p05));

			if(!$res['is_export']) {
				return $permDeny;
			}
		} else {
			$query = "SELECT ((i15_00.p03 - i15_00.p04) < 0) as is_export_1,
							 ((i15_01.p03 - i15_01.p04) < 0) as is_export_2
					  FROM a30
					  LEFT JOIN i15 as i15_00 on i15_00.p01 = a30.p04
					  LEFT JOIN i15 as i15_01 on i15_01.p01 = a30.p05
					  WHERE a30.p01 = :p05";

			pegasus_mysql_use($query, $res, array("p05"=>$p05));

			if(!$res['is_export_1'] && !$res['is_export_2']) {
				return $permDeny;
			}
		}

		if($mode == "a60") {
			if($res['is_export_1'] == 1) {
				$query_i01 = "SELECT ((i00tot.p03 - sum(peg_tmp_i01.p03)) >= 0) as is_balance_remain,
									 i16.p01 as i16_p01,
								     peg_tmp_i01.p01
							  FROM peg_tmp_i01
							  LEFT JOIN i00tot on i00tot.pno1 = peg_tmp_i01.p01 AND i00tot.p610 = peg_tmp_i01.p610
							  LEFT JOIN i16 on i16.p00 = peg_tmp_i01.p610
							  LEFT JOIN i00 on i00.pno = peg_tmp_i01.p01
							  WHERE (peg_tmp_i01.ppnr01 = 0 OR peg_tmp_i01.ppnr01 = peg_tmp_i01.nr01)
							    AND i00.p202 = 0
							    AND ". $where_eidi['sql'] ."   
							  GROUP BY peg_tmp_i01.p01";			
			} 
			
			if($res['is_export_2'] == 1) {
				$query_i01 = "SELECT ((i00tot.p03 - sum(peg_tmp_i01.p03)) >= 0) as is_balance_remain,
									 i16.p01 as i16_p01,
								     peg_tmp_i01.p01
							  FROM peg_tmp_i01
							  LEFT JOIN i00tot on i00tot.pno1 = peg_tmp_i01.p01 AND i00tot.p610 = peg_tmp_i01.p610
							  LEFT JOIN i16 on i16.p00 = peg_tmp_i01.p610
							  LEFT JOIN i00 on i00.pno = peg_tmp_i01.p01
							  WHERE peg_tmp_i01.ppnr01 != 0 
							  	AND peg_tmp_i01.ppnr01 != peg_tmp_i01.nr01
								AND i00.p202 = 0
							    AND ". $where_eidi['sql'] ."  
							  GROUP BY peg_tmp_i01.p01";	
			}			

			$res_i01 = pegasus_query($query_i01, $where_eidi['sqlParams']);
		} else {
			$query_i01 = "SELECT ((i00tot.p03 - sum(peg_tmp_i01.p03)) >= 0) as is_balance_remain,
								 i16.p01 as i16_p01,
								 peg_tmp_i01.p01
						  FROM peg_tmp_i01
						  LEFT JOIN i00tot on i00tot.pno1 = peg_tmp_i01.p01 AND i00tot.p610 = peg_tmp_i01.p610
						  LEFT JOIN i16 on i16.p00 = peg_tmp_i01.p610
						  LEFT JOIN i00 on i00.pno = peg_tmp_i01.p01
						  WHERE (peg_tmp_i01.ppnr01 = 0 OR peg_tmp_i01.ppnr01 = peg_tmp_i01.nr01)
						    AND i00.p202 = 0
						    AND ". $where_eidi ." 
						  GROUP BY peg_tmp_i01.p01";

			$res_i01 = pegasus_query($query_i01);
		}

		while($row = pegasus_fetch($res_i01)) {
			if(!$row['is_balance_remain']) {
				array_push($permDeny, array('type' => 'deny', 'message' =>  str_replace(array("#i01_p01#", "#i16_p01#"), array($row['p01'], $row['i16_p01']), $_SESSION['peg_dic_invoices_balance_is_not_enough'])));
			}
		}
	}

	return $permDeny;
}



function invoices_f02_d51_before_change()
{

	$logo_path = '../../images/invoice_logo.png';
	$tmp_logo_dir = '../../images/tmp_invoice_logo/';
	$ret_arr = array();
	$ret_arr['denysave'] = 0;
	$ret_arr['denymsg'] = '';
	
	if(!is_dir('../../images/')){
		mkdir('../../images/');
	}

	if ($_FILES['vph']["error"] == 0) {
		if ($_FILES['vph']["type"] != 'image/png') {
			$ret_arr['denysave'] = 1;
			$ret_arr['denymsg'] = $_SESSION['peg_dic_invoices_img_wrong_type'];
			return $ret_arr;
		} else {
			/*Upload image*/
			move_uploaded_file($_FILES['vph']["tmp_name"], $logo_path);
			invoices_clear_temp_logo();
		}
	} else if ($_FILES['vph']["error"] == 1) {
		$denySave = 1;
		$denyMsg = '<p style="color:red;text-align:center;font-weight:bold;">' . $_SESSION['peg_dic_core_upload_err_ini_size'] . ' (' . ini_get('upload_max_filesize') . ')</p>';
		return array('denymsg' => $denyMsg, 'denysave' => $denySave);
	} else if ($_FILES['vph']["error"] > 0) {
		$denySave = 1;
		$denyMsg = "<p>Error: " . $_FILES["vph"]["error"] . "<p/>";
		return array('denymsg' => $denyMsg, 'denysave' => $denySave);
	}
}

function invoices_f02_d53_before_change()
{

	$logo_path = '../../images/invoice_watermark_logo.png';
	$tmp_logo_dir = '../../images/tmp_invoice_logo/';
	$ret_arr = array();
	$ret_arr['denysave'] = 0;
	$ret_arr['denymsg'] = '';

	if ($_FILES['vph']["error"] == 0) {
		if ($_FILES['vph']["type"] != 'image/png') {
			$ret_arr['denysave'] = 1;
			$ret_arr['denymsg'] = $_SESSION['peg_dic_invoices_img_wrong_type'];
			return $ret_arr;
		} else {
			/*Upload image*/
			move_uploaded_file($_FILES['vph']["tmp_name"], $logo_path);
			invoices_clear_temp_logo();
		}
	} else if ($_FILES['vph']["error"] == 1) {
		$denySave = 1;
		$denyMsg = '<p style="color:red;text-align:center;font-weight:bold;">' . $_SESSION['peg_dic_core_upload_err_ini_size'] . ' (' . ini_get('upload_max_filesize') . ')</p>';
		return array('denymsg' => $denyMsg, 'denysave' => $denySave);
	} else if ($_FILES['vph']["error"] > 0) {
		$denySave = 1;
		$denyMsg = "<p>Error: " . $_FILES["vph"]["error"] . "<p/>";
		return array('denymsg' => $denyMsg, 'denysave' => $denySave);
	}
}

function invoices_clear_temp_logo($image_name = '')
{

	if (!empty($image_name)) {
		$temp_arr = explode('.', $image_name);
		$image_name = $temp_arr[0] . "_";
	}

	$files = glob('../../images/tmp_invoice_logo/' . $image_name . '*'); // get all file names
	foreach ($files as $file) { // iterate files
		if (is_file($file))
			unlink($file); // delete file
	}
}

function peg_invoices_check_if_same_image($current_p85_logo = '', $standard_p85_logo = '')
{

	if (!file_exists($standard_p85_logo) || !file_exists($current_p85_logo)) {
		return false;
	}

	if (md5_file($current_p85_logo) == md5_file($standard_p85_logo)) {
		return true;
	}
	return false;
}

function peg_invoices__invoices_find_product_d_initialize($data, $mmnr01 = '', $mnr01 = '', $_d = '', $container_id = '')
{
	$data['grid_quickfind_hidden'] = false;
	//Προεπιλογή περιγραφη - κωδικος 
	$browse_where_mode = pegasusGetGlobalVar('invoice__invoices_find_product_d_setValue_fld_search');
	$data['fld_search'] = $browse_where_mode;
	$peg_name = $_REQUEST['peg_name'];

	if(
		(!empty($peg_name) && $peg_name != 'undefined') || 
		(empty($peg_name) && $_REQUEST['peg_code'] == 'undefined')
	) {
		if(substr($peg_name, 0, 2) == '~-') {
			$data['item_search'] = substr($peg_name, 2);
			$data['fld_search']  = 203;
		} else if(substr($peg_name, 0, 2) == '~+') {
			$data['item_search'] = substr($peg_name, 2);
			$data['fld_search']  = 202;
		} else if(substr($peg_name, 0, 1) == '~') {
			$data['item_search'] = substr($peg_name, 1);
			$data['fld_search'] = 2;
		} else if(substr($peg_name, 0, 1) == '=') {
			$data['item_search'] = substr($peg_name, 1);
			$data['fld_search']  = 204;
		} else {
			$data['item_search'] = $peg_name;
			$data['fld_search']  = 2;
		}
	}elseif((!empty($_REQUEST['peg_code']) && $_REQUEST['peg_code'] != 'undefined')
		|| empty($_REQUEST['peg_code']) && $_REQUEST['peg_name'] == 'undefined') {
		$data['item_search'] = $_REQUEST['peg_code'];
		$data['fld_search'] = 1;
	}

	// if(!isset($_REQUEST['peg_name']) && !isset($_REQUEST['peg_code'])) {
	if($_REQUEST['peg_name'] == 'undefined' && $_REQUEST['peg_code'] == 'undefined') {
		$data['s_value'] = 1;
	} else {
		$data['s_value'] = 0;
	}

	return $data;
}

function peg_invoices__invoices_find_product_d00_initialize($data, $mmnr01 = '', $mnr01 = '', $_d = '', $container_id = '')
{
	$data['grid_quickfind_hidden'] = false;

	return $data;
}

function peg_invoice_find_product_data($request)
{
	foreach ($request as $key => $value) {
		$request[$key] = $value;
	}

	// $ret_array=array();
	// $is_invoice = 0;

	//retail: na m erxetai i pliroforia ws $retail_a55nr01= $request['retail00_01_a55_nr01'];

	$i01_p042  = $request['i01_p042'];
	$a58_v1042 = $request['a58_v1042'];
	$a68_v1042 = $request['a68_v1042'];
	$a62_v1042 = $request['a62_v1042'];

	$a55_nr01 = $request['a55_nr01'];
	$a56_nr01 = $request['a56_nr01'];
	$a57_nr01 = $request['a57_nr01'];
	$a67_nr01 = $request['a67_nr01'];
	$a60_nr01 = $request['a60_nr01'];
	$a61_nr01 = $request['a61_nr01'];
	$d74_nr01 = $request['d74_nr01'];
	$tran01_nr01 = $request['tran01_nr01'];
	// $retail_a55nr01 = $request['retail00_01_a55_nr01'];
	$retail_a55nr01 = $request['retail00_01_nr01'];
	$i18i01   = $request['i18i01'];
	$i18a58   = $request['i18a58'];
	$i18a68   = $request['i18a68'];
	$i18a62   = $request['i18a62'];
	$type	  = $request['type'];

	$mode = '';
	/* Αν η μεταβλητη nr01 Παρασταικου πελάτη ειναι μεγαλύτερη απο 0  */
	if ($a55_nr01 > 0) {
		$mode = 'a55';
		$invoice_nr01 = $a55_nr01;
		$invoice_p042 = $i01_p042;
	}

	/* Αν η μεταβλητη nr01 Παρασταικου προμηθευτή ειναι μεγαλύτερη απο 0 */
	if ($a56_nr01 > 0) {
		$mode = 'a56';
		$invoice_nr01 = $a56_nr01;
		$invoice_p042 = $i01_p042;
	}

	/* Αν η μεταβλητη nr01 Παραγγελίας πελάτη ειναι μεγαλύτερη απο 0 */
	if ($a57_nr01 > 0) {
		$mode = 'a57';
		$invoice_nr01 = $a57_nr01;
		$invoice_p042 = $a58_v1042;
	}

	/* Αν η μεταβλητη nr01 Παραγγελίας προμηθευτή ειναι μεγαλύτερη απο 0 */
	if ($a67_nr01 > 0) {
		$mode = 'a67';
		$invoice_nr01 = $a67_nr01;
		$invoice_p042 = $a68_v1042;
	}

	/* Αν η μεταβλητη nr01 Παραστατικό Εσωτερικής Διακίνησης ειναι μεγαλύτερη απο 0 */
	if ($a60_nr01 > 0) {
		$mode = 'a60';
		$invoice_nr01 = $a60_nr01;
		$invoice_p042 = $i01_p042;
	}

	/* Αν η μεταβλητη nr01 Εσωτερικής Παραγγελίας ειναι μεγαλύτερη απο 0 */
	if ($a61_nr01 > 0) {
		$mode = 'a61';
		$invoice_nr01 = $a61_nr01;
		$invoice_p042 = $a62_v1042;
	}

	/* Αν η μεταβλητη nr01 Προσφοράς ειναι μεγαλύτερη απο 0 */
	if ($d74_nr01 > 0) {
		$mode = 'd74';
		$invoice_nr01 = $d74_nr01;
	}
	// retail: add mode retail00_01
	/* Αν η μεταβλητή a55nr01 (retail00) είναι μεγαλύτερη από 0 */
	if ($retail_a55nr01 > 0) {
		$mode = 'retail00_01';
		$invoice_nr01 = $retail_a55nr01;
	}

	if ($mode == 'a55' or $mode == "a57" or $mode == "retail00_01"  or ($mode == "d74" && $request['d74_p03'] >0 )) { //retail: add mode retail00_01
		$p03_tbl = 'a01';
	}

	if ($mode == 'a56' or $mode == "a67") {
		$p03_tbl = 'a00';
	}

	/* Παράμετροι*/
	$result_arr = array(); // Το array με τα αποτελέσματα.

	$result_arr['i18i01'] = $i18i01;
	$result_arr['i18a58'] = $i18a58;
	$result_arr['i18a68'] = $i18a68;
	$result_arr['i18a62'] = $i18a62;

	$i01_nr01 = 0;
	$a58_nr01 = 0;
	$a68_nr01 = 0;
	$a62_nr01 = 0;
	$tran02_nr01 = 0;

	//* 29/05/2023 - Retail -
	//* Σχολιάζουμε την ανάθεση τιμής στο i01_nr01 από το request εφόσον δεν υπάρχει λογική αλλαγής είδους (ακόμα)
	//* Είχαμε πρόβλημα ότι ερχόταν στο request το nr01 της κίνησης του προηγούμενου είδους με αποτέλεσμα να κάνει update λανθασμένα
	//* τα tmp του προηγούμενου είδους.
	//* ***Δεν έχουμε αφαιρέσει τον κώδικα παρακάτω για mode retail που χρησιμοποιεί το i01_nr01*** 
	// if ($mode == 'a55' or $mode == 'a56' or $mode == 'a60' or $mode == "retail00_01") { //retail: add mode retail00_01
	if ($mode == 'a55' or $mode == 'a56' or $mode == 'a60') {
		$i01_nr01 = $request['i01_nr01'];
		$result_arr['i01_nr01'] = $i01_nr01;
		$kinisi_nr01 = $i01_nr01;
		$p010 = 1;
	} else if ($mode == 'a57') {
		$a58_nr01 = $request['a58_nr01'];
		$result_arr['a58_nr01'] = $a58_nr01;
		$kinisi_nr01 = $a58_nr01;
		$p010 = 2;
	} else if ($mode == 'a61') {
		$a62_nr01 = $request['a62_nr01'];
		$result_arr['a62_nr01'] = $a62_nr01;
		$kinisi_nr01 = $a62_nr01;
		$p010 = 4;
	} else if ($mode == 'a67') {
		$a68_nr01 = $request['a68_nr01'];
		$result_arr['a68_nr01'] = $a68_nr01;
		$kinisi_nr01 = $a68_nr01;
		$p010 = 3;
	}


	$v101 = $request['v101'];   // Ο κωδικός του είδους.

	$p03  = intval($request[$mode . '_p03']);   //Ο κωδικός του πελάτη
	$p05  = intval($request[$mode . '_p05']);   //Ο κωδικός του παραστατικού
	$p07  = intval($request[$mode . '_p07']);   //Τιμές με ΦΠΑ
	$p805 = intval($request[$mode . '_p805']);  //Δεν υπολογίζεται η εισφορά ανακύκλωσης
	$p703 = intval($request['p703']); // Kwdikos Apothikeutikou Χωρου
	$date 	  = $request['date'];

	// $mnr01 	  = $request['mnr01'];    // mnr01
	// $mmnr01   = $request['mmnr01'];   // mmnr01
	$kath_fpa = intval($request['kath_fpa']);


	//οι παράμετροι απο το query στα είδη
	//$v103  = $request['v103'];
	//Τα σχολίασα γιατί δεν φαίνεται να χρησιμοποιούνται κάπου
	// $v172  = $request['v172'];
	// $v173  = $request['v173'];
	// $v161  = $request['v161'];
	// $ser   = $request['ser'];

	// $timh1 = floatval($request['timh1']);
	// $timh2 = floatval($request['timh2']);
	// $timh3 = floatval($request['timh3']);
	// $timh4 = floatval($request['timh4']);


	//έυρεση τού είδους στην αποθήκη
	pegasus_mysql_use("SELECT * FROM i00 WHERE pno=? ", $i00, array($v101));
	//echo pegasus_replace_values_in_sql("SELECT * FROM i00 WHERE pno=? ", array($v101));

	//Εύρεση της Αντιστοιχίας 
	$result_arr['v_i00_p9001'] = $i00['p9001'];

	//Εύρεση της Θέσης-Ράφη
	$result_arr['v_i00_p00'] = $i00['p00'];

	//Ευρεση του Κατασκευαστή
	$v_i00_p9907 = 0;
	if(pegasus_module_exists("invsite")) {
		$res_i49 = array();
		$query_i49 = "SELECT p02 FROM i00 LEFT JOIN i49 ON i00.p9907 = i49.p01 WHERE i00.pno = :v101";
		pegasus_mysql_use($query_i49, $res_i49, array("v101"=>$request['v101']));

		$v_i00_p9907  = $res_i49['p02'];
	}
	$result_arr['v_i00_p9907'] = $v_i00_p9907;

	//Εύρεση barcode Αναζήτησης
	if(in_array($mode, array("a55", "a56", "a60"))) {
		$result_arr['p01b'] = $request['code'];
	} else if(in_array($mode, array("a57", "a67", "a61"))) {
		$result_arr['v101b'] = $request['code'];
	}
	
    if(pegasus_module_exists("invsets")) {
		$query_i18 = "SELECT p02, p03, p04, p05 FROM i18 WHERE p00 = :p01 AND pc01 = :pc01 AND pm01 = :pm01";

		$query_params_i18 = array(
			"p01"  => $request['v101'],
			"pc01" => '',
			"pm01" => ''
		);

		pegasus_mysql_use($query_i18, $res_i18, $query_params_i18);

		if(
			(in_array($mode, array("a55", "a57")) && $res_i18['p03'] == 1) ||
			(in_array($mode, array("a56", "a67")) && $res_i18['p04'] == 1) ||
			(in_array($mode, array("a60", "a61")) && $res_i18['p05'] == 1)
		) {
			$result_arr['i19p03'] = $res_i18['p02'];
		}
	}

	$result_arr['v_i00_p01'] = $i00['p01']; //barcode
	$result_arr['v_a90_p30'] = $i00['p30']; //σημειώσεις είδους

	$timh1 = inventory_find_cost_price($i00['pno'], $p703, $p703, '', $date, 0);
	$timh2 = floatval($i00['timh2']);
	$timh3 = floatval($i00['timh3']);
	$timh4 = floatval($i00['timh4']);

	//έυρεση τις μοναδας μετρησης
	pegasus_mysql_use("SELECT * FROM  i24 WHERE i24.p01=? ", $i24, array($i00['ths']));
	//echo pegasus_replace_values_in_sql("SELECT * FROM  i24 WHERE i24.p01=? ", array($i00['ths']));

	//Πελάτη / Προμηθευτής
	if ($mode == 'a57' or $mode == 'a55' or $mode == "retail00_01" or ($mode == "d74" && $p03 >0)) { //retail: add mode retail00_01
		pegasus_mysql_use("SELECT * FROM a01 WHERE a01.nr01=? ", $p03_tbl, array($p03));
	} else if ($mode == 'a56' or $mode == "a67") {
		pegasus_mysql_use("SELECT * FROM a00 WHERE a00.nr01=? ", $p03_tbl, array($p03));
	}

	//Eυρεσή ανα έχω χρώμα-Μεγεθος στο είδος
	$result_arr['color_size_en'] = 0;
	if (pegasus_module_exists('colorsize')) {
		if (pegasus_mysql_printfld('i47', 'count(*)',  'i00=? ', array($i00['nr01'])) > 0) {
			$result_arr['color_size_en'] = 1;
		}
	}

	$result_arr['serial_en'] = 0;
	$result_arr['p03_serial'] = 0;
	if (pegasus_module_exists('serial') && $i00['ps01'] == 1) {
		$result_arr['serial_en'] = 1;
		$result_arr['p03_serial'] = 1;
	}

	$result_arr['lot_en'] = 0;
	$result_arr['p03_lot'] = 0;
	if (pegasus_module_exists('lot') && $i00['p904'] == 1 && in_array($mode, array("a55", "a56", "a60", "a57", "a67", "a61", "retail00_01"))) {
		$result_arr['lot_en'] = 1;
		$result_arr['p03_lot'] = 1;
	}

	$result_arr['v_i18_en'] = 0;
	if (!empty($i18i01) || !empty($i18a58) || !empty($i18a68) || !empty($i18a62)) {
		$result_arr['v_i18_en'] = 1;
	}

	$result_arr['v_p200_en'] = peg_invoices_v_p200_en($i00['pno']);


	$result_arr['v101'] = $i00['pno'];
	$result_arr['v102'] = $i00['name'];
	$result_arr['v_i00_ths']  = $i00['ths'];
	$result_arr['v_i00_p200'] = $i00['p200'];
	$result_arr['v_i00_p201'] = $i00['p201'];
	if ($_SESSION['f02_pg04'] == 1 and ($mode=='a55' or $mode=='a57' or $mode == "retail00_01")) { //retail: add mode retail00_01
		$result_arr['v160'] = $i00['p9000'];
	}elseif ($_SESSION['f02_apg04'] == 1 and ($mode=='a56' or $mode=='a67')) {
		$result_arr['v160'] = $i00['p9000'];
	} else {
		$result_arr['v160'] = '';
	}

	//TEMAXIA
	$result_arr['i24_p101'] = $i24['p101'];
	//MHKOS
	$result_arr['i24_p102'] = $i24['p102'];
	//PLATOS
	$result_arr['i24_p103'] = $i24['p103'];
	//YPSOS
	$result_arr['i24_p104'] = $i24['p104'];
	//MIKTO VAROS
	$result_arr['i24_p106'] = $i24['p106'];
	//SYNOLIKH POSOTHTA
	$result_arr['i24_p107'] = $i24['p107'];
	//EIDOS SYSKEYASIAS
	$result_arr['i24_p108'] = $i24['p108'];
	//KOLLA
	$result_arr['i24_p109'] = $i24['p109'];
	//APOVARO
	$result_arr['i24_p110'] = $i24['p110'];


	$result_arr['v103'] = $request['v103'];
	$result_arr['v120'] = $request['v120'];
	
	$result_arr['v301'] = '0';
	if (!($result_arr['v103'] > 0)) {
		$result_arr['v103'] = 0;

		// Aν δεν έχει παραμετρικό υπολογισμό της ποσοτητάς
		if (
			$result_arr['i24_p102'] == 0 and
			$result_arr['i24_p103'] == 0 and
			$result_arr['i24_p104'] == 0 and
			$result_arr['i24_p105'] == 0 and
			$result_arr['i24_p106'] == 0 and
			$result_arr['i24_p107'] == 0 and
			$result_arr['i24_p108'] == 0 and
			$result_arr['i24_p109'] == 0 and
			$result_arr['i24_p110'] == 0 and
			$result_arr['color_size_en'] == 0 	and
			$result_arr['serial_en'] == 0 		and
			$result_arr['lot_en'] == 0 and 
			empty($result_arr['v_i00_p200'])
		) {

			if ($result_arr['i24_p101'] == 1 ) {
				$result_arr['v301'] = 1;
			}
			$result_arr['v103'] = 1;
		}elseif(
			//* Αν δεν έχει τίποτα τσεκαρισμένο στην ΜΜ και το Είδος παρακολουθεί Δευτερεύουσα ΜΜ, δίνω στην κύρια ποσότητα 1.
			$result_arr['i24_p101'] == 0 and
			$result_arr['i24_p102'] == 0 and
			$result_arr['i24_p103'] == 0 and
			$result_arr['i24_p104'] == 0 and
			$result_arr['i24_p105'] == 0 and
			$result_arr['i24_p106'] == 0 and
			$result_arr['i24_p107'] == 0 and
			$result_arr['i24_p108'] == 0 and
			$result_arr['i24_p109'] == 0 and
			$result_arr['i24_p110'] == 0 and
			$result_arr['color_size_en'] == 0 	and
			$result_arr['serial_en'] == 0 		and
			!empty($result_arr['v_i00_p200'])	
		) {
			$result_arr['v103'] = 1;
		}
	}

	$peg_mmnr01 = $mode.'_d-'.$invoice_nr01;
	if($mode == 'retail00_01') {//retail 15/05 na fygei
		$peg_mmnr01 = 'a55_d-' . $invoice_nr01;
	}

	if($request['grid_editing'] == 0) {
		invoices_delete_tmp_kinisi($peg_mmnr01, $v101, $mode, $kinisi_nr01, $p010);
	}

	if($result_arr['serial_en'] == 1) {
		if($_SESSION['f02_pg905'] == 1 || ($_SESSION['f02_pg905'] == 2 && ($mode == 'a55' || $mode == 'a56' || $mode == 'a60'))) {
			$result_arr['i24_p101'] = 0;
			$result_arr['i24_p102'] = 0;
			$result_arr['i24_p103'] = 0;
			$result_arr['i24_p104'] = 0;
			$result_arr['i24_p105'] = 0;
			$result_arr['i24_p106'] = 0;
			$result_arr['i24_p107'] = 0;
			$result_arr['i24_p108'] = 0;
			$result_arr['i24_p109'] = 0;
			$result_arr['i24_p110'] = 0;
		} else {
			$result_arr['p03_serial'] = 0;
		}
	}

	if($result_arr['lot_en'] == 1) {
		if(
			(($mode == 'a57' || $mode == 'a67' || $mode == 'a61') && $_SESSION['f02_p637o'] == 1) ||
			(($mode == 'a55' || $mode == 'a56' || $mode == 'a60') && $_SESSION['f02_p637'] == 1) 
		) {
			$result_arr['i24_p101'] = 0;
			$result_arr['i24_p102'] = 0;
			$result_arr['i24_p103'] = 0;
			$result_arr['i24_p104'] = 0;
			$result_arr['i24_p105'] = 0;
			$result_arr['i24_p106'] = 0;
			$result_arr['i24_p107'] = 0;
			$result_arr['i24_p108'] = 0;
			$result_arr['i24_p109'] = 0;
			$result_arr['i24_p110'] = 0;
		} else {
			$result_arr['p03_lot'] = 0;
		}
	}

	if($result_arr['color_size_en'] == 1) {	
		$result_arr['i24_p101'] = 0;
		$result_arr['i24_p102'] = 0;
		$result_arr['i24_p103'] = 0;
		$result_arr['i24_p104'] = 0;
		$result_arr['i24_p105'] = 0;
		$result_arr['i24_p106'] = 0;
		$result_arr['i24_p107'] = 0;
		$result_arr['i24_p108'] = 0;
		$result_arr['i24_p109'] = 0;
		$result_arr['i24_p110'] = 0;

		if($mode == "a55" || $mode == "a56" || $mode == "a60" || $mode == "retail00_01") {
			$peg_tmp_tbl = "peg_tmp_i48";
		} else if($mode == "a57") {
			$peg_tmp_tbl = "peg_tmp_a59";
		} else if($mode == "a67") {
			$peg_tmp_tbl = "peg_tmp_a69";
		} else if($mode == "a61") {
			$peg_tmp_tbl = "peg_tmp_a63";
		}

		$query_where = "$peg_tmp_tbl.p01  		 = :p01         AND
						$peg_tmp_tbl.peg_mnr01   = :peg_mnr01   AND
						$peg_tmp_tbl.peg_mmnr01  = :peg_mmnr01  AND
						$peg_tmp_tbl.peg_sess_id = :peg_sess_id AND
						$peg_tmp_tbl.peg_flag   != 9";

		$query_params = array(
			'p01'			=> $kinisi_nr01,
			'peg_mnr01'		=> $kinisi_nr01,
			'peg_mmnr01'	=> $peg_mmnr01,
			'peg_sess_id'	=> session_id()
		);

		if(
			(($mode == "a55" || $mode == "a56" || $mode == "a60" || $mode == "retail00_01") && pegasus_mysql_table_exists("peg_tmp_i48")) ||
			($mode == "a57" && pegasus_mysql_table_exists('peg_tmp_a59')) || 
			($mode == "a67" && pegasus_mysql_table_exists("peg_tmp_a69")) || 
			($mode == "a61" && pegasus_mysql_table_exists("peg_tmp_a63"))				
		) {
			$result_arr['v103'] = pegasus_mysql_printfld($peg_tmp_tbl, "ifnull(sum(p04), 0)", $query_where, $query_params);
		}
	}	

	// if($mode == 'd74'){
	// 	$result_arr['v103'] = $v103;
	// }

	if(       
		$result_arr['color_size_en'] == 0 && 
		$result_arr['p03_serial']    == 0 && 
		$result_arr['p03_lot']       == 0 &&
		$result_arr['v_p200_en']     == 1
	){
		if($result_arr['v120']>0){
			$v120 = $result_arr['v103'] / $i00['p201'];
		}
		$v_i00_p201 = $i00['p201'];
	}else{
		$v120 		= $result_arr['v120'];
		$v_i00_p201 = 0;	
	}

	
	$result_arr['v120'] 	  = $v120;
	$result_arr['v_i00_p201'] = $v_i00_p201;
				
	// $result_arr['v301'] = '0'; // To μεταφέρω πιο ψηλά.
	$result_arr['v302'] = '0.000';
	$result_arr['v303'] = '0.000';
	$result_arr['v304'] = '0.000';
	$result_arr['v306'] = '0.000';
	$result_arr['v307'] = '0.000';

	$zero_prices = invoices_check_if_zero_prices($mode, $invoice_nr01);
	
	$is_syskevasia = 0;
		// 19/12/2023
		// Βρίσκω αν έχω έρθει από ειδικό κωδικό με συσκευασία, για να μην εμφανίσω price window
		// Πιο κάτω, βάσει του $is_syskevasia, αν είναι 1, βρίσκω και τις τιμές συσκευασίας
		// TODO: Σε δεύτερο χρόνο, θέλουμε να προσαρμόσουμε την οθόνη του price window, να παίζει και για συσκευασίες.
		if(pegasus_module_exists('invspcodes') && $type == '5'){
			$is_syskevasia = pegasus_mysql_printfld('i08', 'pe06', 'pe02 = :code', array('code' => $request['code']));
		}

	if (($mode == 'a57' or $mode == 'a55' or $mode == 'retail00_01') && pegasus_mysql_table_exists('a55')) { //retail: add mode retail00_01
		$cona11_nr01 = $request['cona11_nr01'];

		// echo print_r(
		// 	array(
		// 		$i00['pno'],
		// 		$p03_tbl['nr01'],
		// 		$result_arr['v103'],
		// 		$date,
		// 		$kath_fpa,
		// 		'a01',
		// 		$p07,
		// 		$p703
		// 	),1
		// );
		$p03_p48  = 0;
		$p03_p06  = 0;
		$p03_p52  = 0;
		$p03_p52a = 0;
		$p03_p523 = 0;
		if($mode == 'retail00_01') {
			if(isset($request['p03_p48']) && !empty($request['p03_p48'])) {
				$p03_p48 = $request['p03_p48']; //Βασικός Τιμοκατάλογος
			}
			if(isset($request['p03_p06']) && !empty($request['p03_p06'])) {
				$p03_p06 = $request['p03_p06']; //Ειδικός Τιμοκατάλογος
			}
			if(isset($request['p03_p52']) && !empty($request['p03_p52'])) {
				$p03_p52 = $request['p03_p52']; //%Έκπτωσης 1
			}
			if(isset($request['p03_p52a']) && !empty($request['p03_p52a'])) {
				$p03_p52a = $request['p03_p52a']; //%Έκπτωσης 2
			}
			if(isset($request['p03_p523']) && !empty($request['p03_p523'])) {
				$p03_p523 = $request['p03_p523']; //%Προσαύξησης
			}		
		}

		$price_array = inventory_find_price(
			$i00['pno'],
			$p03_tbl['nr01'],
			$result_arr['v103'],
			$date,
			$kath_fpa,
			'a01',
			$p07,
			$p703,
			$p03_p48,
			$p03_p06,
			$p03_p52,
			$p03_p52a,
			$p03_p523,
			'',
			$cona11_nr01,
			$zero_prices
		);

		if($_SESSION['f02_pg09']!=0 && $is_syskevasia == 0) {
			$prc_win_result = invoices_i01_get_last_prices($mode, $i01_nr01, $result_arr['v101'], $p03_tbl['nr01']);
			
			$result_arr['show_price_window'] = $prc_win_result['nr01'] > 0; //Εμφάνιση Οθόνης με Τελευταία Τιμή
			$result_arr['prc_win_params'] 	 = array();
			foreach ($prc_win_result as $key => $value) {
				$result_arr['prc_win_params'][$key] = $value;
			}
		}
	}

	if (($mode == 'a67' or $mode == 'a56') && pegasus_mysql_table_exists('a56')) {
		$price_array = inventory_find_price(
			$i00['pno'],
			$p03_tbl['nr01'],
			$result_arr['v103'],
			$date,
			$kath_fpa,
			'a00',
			$p07,
			$p703,
			0,
			0,
			0,
			0,
			0,
			'',
			'',
			$zero_prices
		);		

		if($_SESSION['f02_apg09']!=0 && $is_syskevasia == 0) {
			$prc_win_result = invoices_i01_get_last_prices($mode, $i01_nr01, $result_arr['v101'], $p03_tbl['nr01']);

			$result_arr['show_price_window'] = $prc_win_result['nr01'] > 0; //Εμφάνιση Οθόνης με Τελευταία Τιμή
			$result_arr['prc_win_params'] 	 = array();
			foreach ($prc_win_result as $key => $value) {
				$result_arr['prc_win_params'][$key] = $value;
			}
		}
	}

	if ($mode == 'a60' or $mode == 'a61') {
		//Άλλαξα το kath_fpa,p07,p703 σε 0 γιατί δεν φαινεται για τις εσωτερικες να ειναι ποτε <>0
		$price_array = inventory_find_price($i00['pno'], 0, $result_arr['v103'], $date, 0, '-', 0, false, 4);
	}

	if ($mode == 'd74') {
		//Στην προσφορά δεν περνάω κωδικό πελάτη. Διαβάζω Τιμοκαταλόγους, Καθεστως, Εκτπώσεις από τα πεδία της προσφοράς
		$result_arr['d75_p03']  = $i00['p9000'];
		$result_arr['d75_p09']  = $i00['p600'];
		$result_arr['d75_p010'] = $i00['p6001'];
		$result_arr['d75_p012'] = $i00['p907'];

		$p03_p48 = 0;
		$p03_p06 = 0;
		$p03_p52 = 0;
		$p03_p52a = 0;
		$p03_p523 = 0;

		if($p03_tbl['nr01'] > 0){
			$p03_p48  = $p03_tbl['p48'];  // Βασικός Τιμοκατάλογος
			$p03_p06  = $p03_tbl['p06'];  // Ειδικός Τιμοκατάλογος
			$p03_p52  = $p03_tbl['p52'];  // %Έκπτωσης 1
			$p03_p52a = $p03_tbl['p52a']; // %Έκπτωσης 2
			$p03_p523 = $p03_tbl['p523']; // %Προσαύξησης
		}
		else {
			$p03_p48  = $request['p03_p48'];  // Βασικός Τιμοκατάλογος
			$p03_p06  = $request['p03_p06'];  // Ειδικός Τιμοκατάλογος
			$p03_p52  = $request['p03_p52'];  // %Έκπτωσης 1
			$p03_p52a = $request['p03_p52a']; // %Έκπτωσης 2
			$p03_p523 = $request['p03_p523']; // %Προσαύξησης
		}

		$result_arr['d75_px01'] = $i00['px01'];
		$result_arr['d75_px02'] = $i00['px02'];
		$price_array = inventory_find_price($i00['pno'], $p03, $result_arr['v103'], $date, $kath_fpa, 'a01', $p07, $p703, $p03_p48, $p03_p06, $p03_p52, $p03_p52a, $p03_p523);
	}

	//echo print_r($price_array  , true);

	//if($price_array['aekp']){
	$discount_1 = $price_array['discount_1'];
	$discount_2 = $price_array['discount_2'];
	//}

	//τιμή μόναδας
	//* 22/11/2023 - Αν έχω έρθει με γεμάτη τιμή μονάδας από αναζήτηση (αξιακό barcode), παίρνω αυτή.
	if($request['v104'] > 0) {
		$result_arr['v104'] = $request['v104'];
	}else{
		$result_arr['v104']  = $price_array['price'];
	}
	if ($mode == 'a55' || $mode == 'a57' || $mode == 'retail00_01') { //retail: add mode retail00_01
		$p05_tbl = 'a10';
	} else if ($mode == 'a56' || $mode == 'a67') {
		$p05_tbl = 'a11';
	} else {
		$p05_tbl = "";
	}
	
	//Αν ανοίγει από την οθόνη των προσφορών d74 η μεταβλητη $p05_tbl έρχεται κενή
	if(!empty($p05_tbl)) {
		pegasus_mysql_use("select * from ".$p05_tbl." where p01=:p05", ${$p05_tbl."_arr"}, array("p05"=>$p05));
	}

	
	if (${$p05_tbl."_arr"}['p107'] == 1) {
		$result_arr['v104']  = 0;
	}

	//Αν είναι συσκευασία
	if(pegasus_module_exists('invspcodes') && $type == '5' && $is_syskevasia == 1){
		$code	 = $request['code'];
		$p03_p48 = $request['p03_p48'];
		if(empty($p03_p48)){
			$p03_p48 = pegasus_mysql_printfld('a01', 'p48', 'nr01 = :p03', array('p03'=>$p03));
		}
		//Παίρνω το ΦΠΑ απο το είδος
		$fpa_arr = invoice_find_product_fpa($v101, $kath_fpa,  $date);
		$pfpa = $fpa_arr['v105']; // Pososto FPA     
		$i08 	 = peg_invspcodes_get_price_values($code, $p03_p48, $p07, $pfpa);
		//* Αν η Βασική ΜΜ έχει Τεμάχια checked, τότε επιστρέφω και το v301 που μου γύρισε η peg_invspcodes_get_price_values
        //* Μας βολεύει αυτός ο έλεγχος, διότι στην προσθήκη είδους από grid, δεν θα το καταχωρήσει επειδή θα έχει τεμαχια 0.
        if($i24['p101'] == 1) {
            $result_arr['v301']= $i08['v301'];
        }

		$result_arr['v103']    = $i08['v103'];
		$result_arr['v1030_1'] = $i08['v1030_1'];
		$result_arr['v104']    = $i08['v104'];
		$result_arr['v104_1']  = $i08['v104_1'];
	}

	// Αν είναι τσεκαρισμένο το [Παίρνει Τιμές Κόστους] άσχετα τον τιμοκατάλογο του πελάτη, υπολογίζει τιμές κόστους
	if(${$p05_tbl."_arr"}['p302'] == 1) {
		$result_arr['v104'] = $timh1;
	}

	//syntelestis fpa
	$result_arr['fpa']   = $price_array['fpa'];

	//katigoria fpa
	$result_arr['kfpa']  = $price_array['kfpa'];

	//Eκπτωση 1
	$result_arr['v106']  = floatval($discount_1);

	//Eκπτωση 2
	$result_arr['v106a'] = floatval($discount_2);

	//Eisfora anakyklvsiw
	//$result_arr['v1041'] = floatval($i00['p905']);
	// $result_arr['v1041'] = (${$p05_tbl."_arr"}['p207']!=1) ? $price_array['eisfora_anakyklosis'] : 0;
	//04/06/2024 - Rollback το check για εισφορά ανακύκλωσης στον a10/11, θα το υλοποιήσουμε από a01/a00 όπως η τοπική
	$result_arr['v1041'] = ($p805 == 1) ? 0 : $price_array['eisfora_anakyklosis'];
	
	//E.F.K
	$result_arr['v616']  = (${$p05_tbl."_arr"}['p206']!=1) ? floatval($i00['p616'])  : 0;
	$result_arr['p616p'] = (${$p05_tbl."_arr"}['p206']!=1) ? floatval($i00['p616p']) : 0;
	invoices_calculate_EFK($v101, $result_arr['v104'], $discount_1, $discount_2, $result_arr['fpa'], $p07, $result_arr['v616'], $result_arr['p616p']);

	if($zero_prices == 1) {
		$result_arr['v616']   = 0;
		$result_arr['v104_1'] = 0;
		$result_arr['show_price_window'] = false;
	}

	//kolla
	$result_arr['v309']  = 0;

	//kovdikos syskeyasias
	$result_arr['v308']  = $i00['p9908'];

	//Βάρος: Ογκομετρικό ή βάρος προϊόντος(το μεγαλύτερο)
	$result_arr['v306']  = $i00['p906'];
	pegasus_mysql_use(
		' SELECT (  if(f01.p014>0 ,
										(i00.p907_1*i00.p907_2*i00.p907_3*1000000 /f01.p014),
										0 )
									) AS ogkometriko
							FROM i00
							LEFT JOIN f01 ON f01.nr01=1
							WHERE i00.pno=? ',
		$temp_array_baros,
		array($i00['pno'])
	);
	if ($temp_array_baros['ogkometriko'] > $result_arr['v306']) {
		$result_arr['v306'] = $temp_array_baros['ogkometriko'];
	}

	//kovdikos syskeyasias
	$result_arr['v614']  = $i00['p614'];
	$result_arr['timh1'] = $timh1;
	$result_arr['timh2'] = $timh2;
	$result_arr['timh3'] = $timh3;
	$result_arr['timh4'] = $timh4;

	if ($mode == 'a55' || $mode == 'a60' || $mode == 'a56') { 
		$result_arr['p610'] = -1;
	} else if ($mode == 'a67' || $mode == 'a57') {
		$result_arr['p703'] = -1;
	} else if($mode == 'a61') {
		$result_arr['p03'] = -1;
		$result_arr['p04'] = -1;
	}
	
	$timh  = invoices_make_product_total($result_arr['v103'], $result_arr['v104'],  $result_arr['fpa'], $result_arr['v106'], $result_arr['v106a'], $result_arr['v1041'], $result_arr['v616'], $p07, $invoice_p042);
	$result_arr['v107'] = $timh;

	$result_arr['i01_p09'] = $p07;

	if($mode == 'retail00_01') {
		// Αυτό μπορεί να αλλάξει σε 1 μέσα στην invoice_after_find_save_product_data
		$result_arr['is_zero_quantity_barcode'] = 0;
		$result_arr['item_search'] = $request['item_search'];
	}

	if(in_array($mode, array("a57", "a67", "a61"))) {
		//Συνολικό Υπόλοιπο
		$result_arr['v_baltot'] = pegasus_mysql_printfld("i00tot", "sum(p03)", "pno1 = :pno", array("pno"=>$i00['pno']));
	}

	return $result_arr;
}
/**
 *
 * @param array $data
 * @param string $mmnr01
 * @param string $mnr01
 * @param string $_d
 * @param string $container_id
 * @return array $data
 */
function invoices_a10_d01_initialize($data = array(), $mmnr01 = '', $mnr01 = '', $_d = '', $container_id = ''
) {
	global $PegInput;
	$PegInput->addVar(new peg_input_alphanumeric('invoices_p500'));
	$invoices_p500 = $PegInput->getRequest('invoices_p500');
	$invoices_p500s = explode('#', $invoices_p500);

	$in_invoices_p500s = pegasus_mysql_create_in($invoices_p500s, 'i00');
	$sql = "SELECT * FROM i00 WHERE pno IN ({$in_invoices_p500s['sql']})";
	$queryParams  = $in_invoices_p500s['sqlParams'];
	
	pegasusSetGlobalVar(
		$container_id . '_query_grid01_a10_d01',
		array(
			'sql' => $sql,
			'sqlParams' => $queryParams
		)
	);
	$result = pegasus_query($sql, $queryParams);
	$group = array();
	while($res = pegasus_fetch($result)){
		array_push($group, $res['pno']);
	}
	
	pegasusSetGlobalVar('_a10_a11_d01_group_data_' . $container_id, $group);

	$sql = "SELECT * FROM i00 WHERE pno NOT IN ({$in_invoices_p500s['sql']}) AND p203 <> 1";
	pegasusSetGlobalVar(
		$container_id . '_query_grid02_a10_d01',
		array(
			'sql' => $sql,
			'sqlParams' => $queryParams
		)
	);
	return $data;
}
/**
 *
 */
function invoices_find_product_quantity($request)
{
	/* Παράμετροι*/
	$result_arr = array(); // Το array με τα αποτελέσματα.
	// Set Default value for quantity to 0
	$result_arr['v103'] = '0';

	$mode = $request['mode'];

	$p03_p48  = 0;
	$p03_p06  = 0;
	$p03_p52  = 0;
	$p03_p52a = 0;
	$p03_p523 = 0;
	if($mode == 'retail00_01') {
		if(isset($request['p03_p48']) && !empty($request['p03_p48'])) {
			$p03_p48 = $request['p03_p48']; //Βασικός Τιμοκατάλογος
		}
		if(isset($request['p03_p06']) && !empty($request['p03_p06'])) {
			$p03_p06 = $request['p03_p06']; //Ειδικός Τιμοκατάλογος
		}
		if(isset($request['p03_p52']) && !empty($request['p03_p52'])) {
			$p03_p52 = $request['p03_p52']; //%Έκπτωσης 1
		}
		if(isset($request['p03_p52a']) && !empty($request['p03_p52a'])) {
			$p03_p52a = $request['p03_p52a']; //%Έκπτωσης 2
		}
		if(isset($request['p03_p523']) && !empty($request['p03_p523'])) {
			$p03_p523 = $request['p03_p523']; //%Προσαύξησης
		}		
	}
	//0906fretail -- Εδώ να παίξω με if $mode == retail then $mode = 'a55'
	//0906fretail -- Και αν υπάρξει καποιο conflict, το βλέπουμε.
	// if($mode == 'retail00_01') {
	// 	$mode = 'a55';
	// }

	$is_invoice = 0;
	if ($mode == 'a55'  or $mode == 'a56'  or $mode == 'a60') {
		$is_invoice = 1;
		$i01_nr01 = $request['i01_nr01'];
		$a55_nr01 = $request['a55_nr01'];
		$a56_nr01 = $request['a56_nr01'];
		$a60_nr01 = $request['a60_nr01'];
		$i18i01   = $request['i18i01'];
		$invoice_nr01 = $a55_nr01;
		if ($mode == 'a56') {
			$invoice_nr01 = $a56_nr01;
		} else if ($mode == 'a60') {
			$invoice_nr01 = $a60_nr01;
		}
		$kinisi_nr01 = $i01_nr01;
	} else if ($mode == 'a67') {
		$a68_nr01 = $request['a68_nr01'];
		$a67_nr01 = $request['a67_nr01'];
		$i18i01   = $request['i18a68'];
		$invoice_nr01 = $a67_nr01;
		$kinisi_nr01 = $a68_nr01;
	} else if ($mode == 'a61') {
		$a62_nr01 = $request['a62_nr01'];
		$a61_nr01 = $request['a61_nr01'];
		$i18i01   = $request['i18a62'];
		$invoice_nr01 = $a61_nr01;
		$kinisi_nr01 = $a62_nr01;
	} else if ($mode == 'a57') {
		$a58_nr01 = $request['a58_nr01'];
		$a57_nr01 = $request['a57_nr01'];
		$i18i01   = $request['i18a58'];
		$invoice_nr01 = $a57_nr01;
		$kinisi_nr01 = $a58_nr01;
	} else if($mode == 'retail00_01') {
		$is_invoice = 1;
		$mode = 'a55';
		$i01_nr01 = $request['i01_nr01'];
		$retail00_01_nr01 = $request['p06'];
		$kinisi_nr01 = $i01_nr01;
		$invoice_nr01 = $retail00_01_nr01;
	}
	if ($is_invoice == 1) {
		$v104     = floatval($request['p04']);
		$v105     = floatval($request['p08']);
		$v106     = floatval($request['p010']);
		$v106a    = floatval($request['p010a']);
		$v1042    = floatval($request['p042']);
		$v1041    = floatval($request['p041']);
		$v616     = floatval($request['p616']);
		//Κώδικος αποθήκης
		$v101 = $request['p01'];
		//posotita
		$v103 = floatval($request['p03']);
		//Δευτερεύουσα Ποσότητα
		$v120 = floatval($request['p030']);
		//Ποσότητα συσκευασίας
		$v1030_1 = floatval($request['p030_1']);
		//Τιμή Συσκευασίας
		$v104_1  = floatval($request['p04_1']);
		//temaxia
		$v301 = floatval($request['p301']);
		//Mhkos
		$v302 = floatval($request['p302']);
		//PLatos
		$v303 = floatval($request['p303']);
		//Ypos
		$v304 = floatval($request['p304']);
		//MIkto varos
		$v306 = floatval($request['p306']);
		//apovaro
		$v310 = floatval($request['p310']);
		//kola
		$v309 = floatval($request['p309']);
		//Eidos syskeyasias
		$v308 = $request['p308'];
		//Synolikh posotita
		$v307 = floatval($request['p307']);
	} else {
		$v104  = floatval($request['v104']);
		$v105  = floatval($request['v105']);
		$v106  = floatval($request['v106']);
		$v106a = floatval($request['v106a']);
		$v1042 = floatval($request['v1042']);
		$v1041 = floatval($request['v1041']);
		$v616  = floatval($request['v616']);
		//Κώδικος αποθήκης
		$v101 = $request['v101'];
		//posotita
		$v103 = floatval($request['v103']);
		//Δευτερεύουσα Ποσότητα
		$v120 = floatval($request['v120']);
		//Ποσότητα συσκευασίας
		$v1030_1 = floatval($request['v1030_1']);
		//Τιμή Συσκευασίας
		$v104_1  = floatval($request['v104_1']);
		//temaxia
		$v301 = floatval($request['v301']);
		//Mhkos
		$v302 = floatval($request['v302']);
		//PLatos
		$v303 = floatval($request['v303']);
		//Ypos
		$v304 = floatval($request['v304']);
		//MIkto varos
		$v306 = floatval($request['v306']);
		//apovaro
		$v310 = floatval($request['v310']);
		//kola
		$v309 = floatval($request['v309']);
		//Eidos syskeyasias
		$v308 = $request['v308'];
		//Synolikh posotita
		$v307 = floatval($request['v307']);
	}

	//O κωδικός του πελάτη ή του προμηθευτή
	$p03 = $request[$mode . '_p03'];
	//ΦΠΑ
	$p07 = $request[$mode . '_p07'];
	//Παραστατικό
	$p05 = $request['p05'];
	//Η ημερομήνία του παραστατικου
	$date     = $request['date'];
	$kath_fpa = $request['kath_fpa'];

	//έυρεση τού είδους στην αποθήκη
	pegasus_mysql_use("select * from i00 where pno=?", $i00, array($v101));
	if(!($i00['nr01'] > 0)) {
		return $result_arr;
	}
	//Eυρεσή ανα έχω χρώμα-Μεγεθος στο είδος
	$result_arr['color_size_en'] = 0;
	if(pegasus_module_exists('colorsize')) {
		if(/*($i00['p9904']!=0 and $i00['p9905']!=0) or*/pegasus_mysql_printfld('i47', 'count(*)', 'i47.i00=?', array($i00['nr01'])) > 0) {
			$result_arr['color_size_en'] = 1;
		}
	}
	//Eυρεσή ανα lot if not at colorsize
	$result_arr['lot_en'] = 0;
	if(pegasus_module_exists('lot') && $i00['p904'] == 1) {
		$result_arr['lot_en'] = 1;
	}

	//Eυρεσή ανα lot if not at colorsize
	$result_arr['serial_ps01'] = 0;
	if(pegasus_module_exists('serial') && $i00['ps01'] == 1) {
		$result_arr['serial_ps01'] = 1;
	}

	//To Είδος ανήκει σε συνταγή
	if(empty($i18i01)) {
		$i18i01 = 0;
	}

	if($i18i01 > 0) {
		$result_arr['v103']  = $v103;
		//$result_arr['v120']  = $v120; //Δεν σετάρεται κάπου το v120... Δεν ξερω τι ειναι
		$result_arr['v310']  = $v310;

		$result_arr['v103_change'] = 1;
		$result_arr['v103_change_message'] = $_SESSION["peg_dic_invoices_quantity_prescription"];

		return $result_arr;
	}

	/**
	 * Εξαίρεση υπολογισμού ποσότητας αν το Είδος παρακολουθεί παρτίδες.
	 * Σε περίπτωση που το Είδος έχει και χρώμα μέγεθος ο υπολογισμός της ποσότητας από τις παρτίδες θα αγνοηθεί.
	 *
	 */
	//Οταν είμαστε απο Retail να μην τα υπολογίζουμε την ποσότητα σε serial, lot, colorsize	
	if(empty($retail00_01_nr01)){
		if($result_arr['serial_ps01'] == 1) {
			if($_SESSION['f02_pg905'] == 1 || ($_SESSION['f02_pg905'] == 2 && ($mode == 'a55' || $mode == 'a56' || $mode == 'a60'))) {
				$v103_00 = pegasus_mysql_printfld(
					'peg_tmp_i32',
					'ifnull(count(nr01), 0)',
					'p01=:v101 and peg_mnr01=:peg_mnr01 and peg_mmnr01=:peg_mmnr01 and peg_sess_id=:peg_sess_id and peg_flag!=:peg_flag ',
					array(
						'v101'		  => $v101,
						'peg_mnr01'	  => $kinisi_nr01,
						'peg_mmnr01'  => $mode."_d-" . $invoice_nr01,
						'peg_sess_id' => session_id(),
						'peg_flag'	  => 9
					)
				);

				$v103 = $v103_00;
				$result_arr['v103_change'] = 1;
				$result_arr['v103_change_message'] = $_SESSION['peg_dic_invoices_edit_serial_deny'];
				$request['called_from'] = 'serial_quantity';
			}
		}
		
		if(isset($result_arr['lot_en']) && $result_arr['lot_en'] == 1) {
			if(
				(($mode == 'a57' || $mode == 'a67' || $mode == 'a61') && $_SESSION['f02_p637o'] == 1) ||
				(($mode == 'a55' || $mode == 'a56' || $mode == 'a60') && $_SESSION['f02_p637'] == 1)
			) {
				$v103_00 = pegasus_mysql_printfld(
					'peg_tmp_i38',
					'ifnull(sum(p04), 0)',
					'p01=:p01 and peg_mnr01=:peg_mnr01 and peg_mmnr01=:peg_mmnr01 and peg_sess_id=:peg_sess_id and peg_flag!=:peg_flag ',
					array(
						'p01'		  => $kinisi_nr01,
						'peg_mnr01'	  => $kinisi_nr01,
						'peg_mmnr01'  => $mode."_d-" . $invoice_nr01,
						'peg_sess_id' => session_id(),
						'peg_flag'	  => 9
					)
				);

				$v103 = $v103_00;
				$result_arr['v103_change'] = 1;
				$result_arr['v103_change_message'] = $_SESSION["peg_dic_invoices_quantity_lot"];
				$request['called_from'] = 'lot_quantity';
			}
		}

		if ($result_arr['color_size_en'] == 1) {
			if(($mode == 'a55' || $mode == 'a56' || $mode == 'a60')) {
				$peg_tmp_tbl = "peg_tmp_i48";
			} else if($mode == 'a57') {
				$peg_tmp_tbl = "peg_tmp_a59";
			} else if($mode == 'a67') {
				$peg_tmp_tbl = "peg_tmp_a69";
			} else if($mode == 'a61') {
				$peg_tmp_tbl = "peg_tmp_a63";
			}

			$v103_00 = pegasus_mysql_printfld(
				$peg_tmp_tbl,
				'ifnull(sum(p04), 0)',
				'p01=:p01 and peg_mnr01=:peg_mnr01 and peg_mmnr01=:peg_mmnr01 and peg_sess_id=:peg_sess_id and peg_flag!=:peg_flag ',
				array(
					'p01'		  => $kinisi_nr01,
					'peg_mnr01'	  => $kinisi_nr01,
					'peg_mmnr01'  => $mode."_d-" . $invoice_nr01,
					'peg_sess_id' => session_id(),
					'peg_flag'	  => 9
				)
			);

			$v103 = $v103_00;
			$result_arr['v103_change'] = 1;
			$result_arr['v103_change_message'] = $_SESSION["peg_dic_invoices_quantity_colorsize"];
			$request['called_from'] = 'cs_quantity';
		}
	}

	if(
		$request['called_from'] != 'cs_quantity'     && 
	 	$request['called_from'] != 'lot_quantity'    && 
		$request['called_from'] != 'serial_quantity' && 
		$request['called_from'] != 'quantity_change' && 
		peg_invoices_v_ths_readonly($v101) == 1
	){
		//έυρεση τις μοναδας μετρησης
		pegasus_mysql_use("select * from  i24 where i24.p01=? ", $i24, array($i00['ths']));
		//TEMAXIA
		$i24_p101 = $i24['p101'];

		//MHKOS
		$i24_p102 = $i24['p102'];

		//PLATOS
		$i24_p103 = $i24['p103'];

		//YPSOS
		$i24_p104 = $i24['p104'];

		//MIKTO VAROS
		$i24_p106 = $i24['p106'];

		//SYNOLIKH POSOTHTA
		$i24_p107 = $i24['p107'];

		//EIDOS SYSKEYASIAS
		$i24_p108 = $i24['p108'];

		//KOLLA
		$i24_p109 = $i24['p109'];

		//APOVARO
		$i24_p110 = $i24['p110'];

		/*Αν στην κίνηση ο χρήστης δίνει κόλλα και είδος συσκευασίας, η εφαρμογή υπολογίζει το απόβαρο απευθείας (<Κόλλα$v309> Χ <Βάρος Συσκευασίας>.*/
		if ($i24_p109 == 1 and $i24_p108 == 1) {
			$varos_siskeyasias = 0;

			$kodikos_eidos_syskeyasias = pegasus_mysql_printfld('i52', 'p03', 'p01=?', array($v308));

			$varos_siskeyasias = pegasus_mysql_printfld('i00', 'p906', 'pno=? ', array($kodikos_eidos_syskeyasias));

			//apovaro
			$v310 =  $v309 * $varos_siskeyasias;
		}


		//(Τεμάχια Χ Μήκος Χ Υψος Χ Πλάτος Χ Μικτό Βάρος ) - Απόβαρο

		$v103 = 0;
		//temaxia
		if ($i24_p101 == 1) {
			if ($v103 > 0) {
				$v103 = $v103 * $v301;
			}else if($v1030_1 > 0){ //Οταν έχουμε ποσοτητα συσκευασίας
				$v103 = $v1030_1 * $v301;
			} else {
				$v103 = $v301;
			}
		}
		//MHKOS
		if ($i24_p102 == 1) {
			if ($v103 > 0) {
				$v103 = $v103 * $v302;
			} else {
				$v103 = $v302;
			}
		}

		//PLATOS
		if ($i24_p103 == 1) {
			if ($v103 > 0) {
				$v103 = $v103 * $v303;
			} else {
				$v103 = $v303;
			}
		}


		//YPSOS
		if ($i24_p104 == 1) {
			if ($v103 > 0) {
				$v103 = $v103 * $v304;
			} else {
				$v103 = $v304;
			}
		}

		//MIKTO VAROS
		if ($i24_p106 == 1) {
			if ($v103 > 0) {
				$v103 = $v103 * $v306;
			} else {
				$v103 = $v306;
			}
		}

		//afairei to apovaro apo to varos
		$v103 = $v103 - $v310;
	}


	// An h synolikh posothta einai megalhterh apo to synolo tote afairei thn synolikι posothta tοτε αλλάζει την συνολική ποσότητα
	if ($v307 > 0) {
		$v103 = $v307;
	}

	if(
		peg_invoices_v_p200_en($v101) == 1 && 
		$result_arr['color_size_en'] == 0 && 
		$request['called_from'] != 'lot_quantity' &&
		$request['called_from'] != 'serial_quantity' &&
		$v120 > 0
	) {
		$v103 = $v120 * $i00['p201'];
	}

	if ($v103 < 0) {
		$v103 = 0;
	}

	if ($mode == 'a55' or $mode == 'a57') {
		$p03_mode = 'a01';
	}

	if ($mode == 'a56' or $mode == 'a67') {
		$p03_mode = 'a00';
	}

	$zero_prices = invoices_check_if_zero_prices($mode, $invoice_nr01);
	if ($mode == 'a61' || $mode == 'a60') {
		$price_array = inventory_find_price($v101, 0, $v103, $date,	0, '-',  0, false, 4, 0, 0,0 ,0, '','',$zero_prices);
	} else {
		// Τα p03_p48, p03_p06, p03_p52, p03_p52a, p03_p523 αρχικοποιούνται με 0 στην αρχή της συνάρτησης.
		// Αν έχει έρθει απο retail, γεμίζουν από το request μετά την αρχικοποίηση.
		$price_array = inventory_find_price(
			$v101, 
			$p03, 
			$v103, 
			$date,	
			$kath_fpa, 
			$p03_mode, 
			$p07, 
			false, 
			$p03_p48, 
			$p03_p06, 
			$p03_p52, 
			$p03_p52a, 
			$p03_p523, 
			'', 
			'', 
			$zero_prices
		);
	}
	// var_dump($price_array);
	$v104_change = 0;
	if (($v104 != $price_array['price']) && ($price_array['price'] > 0)  &&  $price_array['is_quantity_price'] === true) {
		$v104 = $price_array['price'];
		$v104_change = 1;
	}
	//Όταν έχω Ποσότητα συσκευασίας
	if($v1030_1 > 0){
		$v104 = round($v104_1 / $v1030_1, $_SESSION['inventory_000_p07']); 
		$v104_change = 1;
	}

	$v106_change = 0;
	if (($v106 != $price_array['discount_1']  or $v106a != $price_array['discount_2']) && $price_array['is_quantity_discounts'] === true) {
		$v106  = $price_array['discount_1'];
		$v106a = $price_array['discount_2'];
		$v106_change = 1;
	}

	if(invoices_check_if_zero_prices($mode, $invoice_nr01) == 1) {
		if($v104 != 0 || $v616 != 0 || $v1041!=0 || $v1042 != 0 || $v104_1 != 0) {
			$v104  = 0;
			$v1041 = 0;
			$v1042 = 0;
			$v616  = 0;
			$result_arr['zero_prices_msg'] = $_SESSION['peg_dic_invoices_zero_prices_en'];
		}
	}

	$total = invoices_make_product_total($v103 , $v104, $v105, $v106, $v106a, $v1041, $v616, $price_array['preview_wthfpa'], $v1042);

	// κανει return πάνω αν το είδος ανοικει σε συνταγή
	$result_arr['v103']  = $v103;
	$result_arr['v120']  = $v120;
	$result_arr['v310']  = $v310;

	//v104
	$result_arr['v104']         = $v104;
	$result_arr['v104_change']  = $v104_change;

	//v106
	$result_arr['v106']         = $v106;
	$result_arr['v106a']        = $v106a;
	$result_arr['v106_change']  = $v106_change;

	$result_arr['v107']  = $total;

	if( function_exists("sme_invoice_find_product_quantity") ){
		$params = array('ths' => $i00['ths'], 'v301' => $v301, 'v302' => $v302, 'v303' => $v303, 'v307' => $v307);
		$result_arr = sme_invoice_find_product_quantity($result_arr, $params);
	}
	return $result_arr;
}

function invoices_get_readonly_flds_from_i24($data, $i24, $mode = 'i01')
{

	if ($mode == 'i01') {
		$data['p301_not_readonly'] = $i24['p101']; //TEMAXIA
		$data['p302_not_readonly'] = $i24['p102']; //MHKOS
		$data['p303_not_readonly'] = $i24['p103']; //PLATOS
		$data['p304_not_readonly'] = $i24['p104']; //YPSOS
		$data['p306_not_readonly'] = $i24['p106']; //MIKTO VAROS
		$data['p307_not_readonly'] = $i24['p107']; //SYNOLIKH POSOTHTA
		$data['p308_not_readonly'] = $i24['p108']; //EIDOS SYSKEYASIAS
		$data['p309_not_readonly'] = $i24['p109']; //KOLLA
		$data['p310_not_readonly'] = $i24['p110']; //APOVARO
		if (
			$data['p301_not_readonly'] == 0 and
			$data['p302_not_readonly'] == 0 and
			$data['p303_not_readonly'] == 0 and
			$data['p304_not_readonly'] == 0 and
			$data['p306_not_readonly'] == 0 and
			$data['p307_not_readonly'] == 0 and
			$data['p308_not_readonly'] == 0 and
			$data['p309_not_readonly'] == 0 and
			$data['p310_not_readonly'] == 0
		) {
			$data['p103_not_readonly'] = 1;
		} else {
			$data['p103_not_readonly'] = 0;
		}

		$has_serial = 0;
		if($data['has_serial'] == 1) {
			if($_SESSION['f02_pg905'] == 1 || $_SESSION['f02_pg905'] == 2) {
				$data['p103_not_readonly'] = 0;
				$has_serial = 1;
			}
		}

		$has_lot = 0;
		if($data['has_lot'] == 1) {
			if($_SESSION['f02_p637'] == 1) {
				$data['p103_not_readonly'] = 0;
				$has_lot = 1;
			}
		}

		if($data['has_color_size'] == 1) {
			$data['p103_not_readonly'] = 0;
		}

		if($data['has_color_size'] == 1 || $has_lot == 1 || $has_serial == 1 || $data['i18i01'] > 0) {
			$data['p301_not_readonly'] = 0;
			$data['p302_not_readonly'] = 0;
			$data['p303_not_readonly'] = 0;
			$data['p304_not_readonly'] = 0;
			$data['p306_not_readonly'] = 0;
			$data['p307_not_readonly'] = 0;
			$data['p308_not_readonly'] = 0;
			$data['p309_not_readonly'] = 0;
			$data['p310_not_readonly'] = 0;
			$data['p103_not_readonly'] = 0;
		}
	} else { //Παραγγελίες πελατων/προμηθευτων/Εωτερικές
		$i18 = 0;
		if ($mode == 'a62') {
			$i18 = $data['i18a62'];
		}
		if ($mode == 'a58') {
			$i18 = $data['i18a58'];
		}
		if ($mode == 'a68') {
			$i18 = $data['i18a68'];
		}
		$data['v301_not_readonly'] = $i24['p101']; //TEMAXIA
		$data['v302_not_readonly'] = $i24['p102']; //MHKOS
		$data['v303_not_readonly'] = $i24['p103']; //PLATOS
		$data['v304_not_readonly'] = $i24['p104']; //YPSOS
		$data['v306_not_readonly'] = $i24['p106']; //MIKTO VAROS
		$data['v307_not_readonly'] = $i24['p107']; //SYNOLIKH POSOTHTA
		$data['v308_not_readonly'] = $i24['p108']; //EIDOS SYSKEYASIAS
		$data['v309_not_readonly'] = $i24['p109']; //KOLLA
		$data['v310_not_readonly'] = $i24['p110']; //APOVARO
		if (
			$data['v301_not_readonly'] == 0 and
			$data['v302_not_readonly'] == 0 and
			$data['v303_not_readonly'] == 0 and
			$data['v304_not_readonly'] == 0 and
			$data['v306_not_readonly'] == 0 and
			$data['v307_not_readonly'] == 0 and
			$data['v308_not_readonly'] == 0 and
			$data['v309_not_readonly'] == 0 and
			$data['v310_not_readonly'] == 0
		) {
			$data['v103_not_readonly'] = 1;
		} else {
			$data['v103_not_readonly'] = 0;
		}

		$has_serial = 0;
		if($data['has_serial'] == 1) {
			if($_SESSION['f02_pg905'] == 1) {
				$data['v103_not_readonly'] = 0;
				$has_serial = 1;
			}
		}

		$has_lot = 0;
		if($data['has_lot'] == 1) {
			if($_SESSION['f02_p637o'] == 1) {
				$data['v103_not_readonly'] = 0;
				$has_lot = 1;
			}
		}

		if($data['has_color_size'] == 1) {
			$data['v103_not_readonly'] = 0;
		}

		if ($data['has_color_size'] == 1 || $has_lot == 1 || $has_serial == 1 || $i18 > 0) {
			$data['v301_not_readonly'] = 0;
			$data['v302_not_readonly'] = 0;
			$data['v303_not_readonly'] = 0;
			$data['v304_not_readonly'] = 0;
			$data['v306_not_readonly'] = 0;
			$data['v307_not_readonly'] = 0;
			$data['v308_not_readonly'] = 0;
			$data['v309_not_readonly'] = 0;
			$data['v310_not_readonly'] = 0;
			$data['v103_not_readonly'] = 0;
		}
	}
	return $data;
}

function invoices_get_f02_readonly_flds($data, $mode = '')
{
	if ($mode == 'retail00_01') {
		$module_d_prefix = 'retail00_01_d03_';
	}else{
		$module_d_prefix = 'invoices_i01_d101_';
	}

	if ($mode == 'a55' || $mode == 'retail00_01') {
		$data[$module_d_prefix . 'p04_readonly'] = 1;
		$data[$module_d_prefix . 'p010_readonly']  = 1;
		$data[$module_d_prefix . 'p010a_readonly'] = 1;
		$data[$module_d_prefix . 'p041_readonly'] = 1;
		$data[$module_d_prefix . 'p616_readonly']  = 1;
		$data[$module_d_prefix . 'p042_readonly'] = 1;
		$data[$module_d_prefix . 'p0601_readonly'] = 1;
		$data[$module_d_prefix . 'vapc2_hidden'] = 1;

		//Timi monads
		if ($_SESSION['f02_pg02'] == 1) {
			$data['p04_readonly'] = 0;
			$data[$module_d_prefix . 'p04_readonly'] = 0;
		}
		//Ekp 1
		if ($_SESSION['f02_pg03'] == 1) {
			$data['p010_readonly'] = 0;
			$data[$module_d_prefix . 'p010_readonly'] = 0;
		}
		//Ekp 2
		if ($_SESSION['f02_pg033'] == 1) {
			$data['p010a_readonly'] = 0;
			$data[$module_d_prefix . 'p010a_readonly'] = 0;
		}
		//Eisfora
		if ($_SESSION['f02_pg030'] == 1) {
			$data['p041_readonly'] = 0;
			$data[$module_d_prefix . 'p041_readonly'] = 0;
		}
		//EFK
		if ($_SESSION['f02_pg032'] == 1) {
			$data['p616_readonly'] = 0;
			$data[$module_d_prefix . 'p616_readonly'] = 0;
		}
		//Αιτιολογία είδους
		if ($_SESSION['f02_pg031'] == 1) {
			$data['p0601_readonly'] = 0;
			$data[$module_d_prefix . 'p0601_readonly'] = 0;
		}
		//Επιτρέπεται Διαφορετική Αποθήκη ανά Είδος
		if(empty($_SESSION['f02_p633'])) {
			$data[$module_d_prefix.'p610_readonly'] = 1;
		}

		//Επιπλέον Αξία Στα Είδη
		if($_SESSION['f02_pg034'] == 1) {
			$data[$module_d_prefix.'p042_readonly'] = 0;
		}
	} else if ($mode == 'a56') {
		$data[$module_d_prefix . 'p04_readonly'] = 1;
		$data[$module_d_prefix . 'p010_readonly']  = 1;
		$data[$module_d_prefix . 'p010a_readonly'] = 1;
		$data[$module_d_prefix . 'p041_readonly'] = 1;
		$data[$module_d_prefix . 'p616_readonly']  = 1;
		$data[$module_d_prefix . 'p042_readonly'] = 1;
		$data[$module_d_prefix . 'p0601_readonly'] = 1;
		$data[$module_d_prefix . 'vapc2_hidden'] = 1;

		//Τιμη μοναδας
		if ($_SESSION['f02_apg02'] == 1) {
			$data['p04_readonly'] = 0;
			$data[$module_d_prefix . 'p04_readonly'] = 0;
		}
		//Ekp 1
		if ($_SESSION['f02_apg03'] == 1) {
			$data['p010_readonly'] = 0;
			$data[$module_d_prefix . 'p010_readonly'] = 0;
		}
		//Ekp 2
		if ($_SESSION['f02_apg033'] == 1) {
			$data['p010a_readonly'] = 0;
			$data[$module_d_prefix . 'p010a_readonly'] = 0;
		}
		//Eisfora
		if ($_SESSION['f02_apg030'] == 1) {
			$data['p041_readonly'] = 0;
			$data[$module_d_prefix . 'p041_readonly'] = 0;
		}
		//EFK
		if ($_SESSION['f02_apg032'] == 1) {
			$data['p616_readonly'] = 0;
			$data[$module_d_prefix . 'p616_readonly'] = 0;
		}
		//Επιπλέον αξία
		/*if($_SESSION['f02_apg034']==1){
				$data['p042_readonly'] = 0;
			}*/
		//Αιτιολογία είδους
		if ($_SESSION['f02_apg031'] == 1) {
			$data['p0601_readonly'] = 0;
			$data[$module_d_prefix . 'p0601_readonly'] = 0;
		}
		//Επιτρέπεται Διαφορετική Αποθήκη ανά Είδος
		if(empty($_SESSION['f02_p633'])) {
			$data[$module_d_prefix.'p610_readonly'] = 1;
		}

		//Επιπλέον αξία Στα Είδη
		if($_SESSION['f02_apg034'] == 1) {
			$data[$module_d_prefix.'p042_readonly'] = 0;
		}			
	} else if ($mode == 'a57') {
		$data['v104_not_readonly']  = 0;
		$data['v106_not_readonly']  = 0;
		$data['v106a_not_readonly'] = 0;
		$data['v1041_not_readonly'] = 0;
		$data['v616_not_readonly']  = 0;
		// $data['v1042_not_readonly'] = 0;
		$data['v160_not_readonly']  = 0;


		//Τιμη μοναδας
		if ($_SESSION['f02_pg02'] == 1) {
			$data['v104_not_readonly'] = 1;
		}

		//Ekp 1
		if ($_SESSION['f02_pg03'] == 1) {
			$data['v106_not_readonly'] = 1;
		}

		//Ekp 2
		if ($_SESSION['f02_pg033'] == 1) {
			$data['v106a_not_readonly'] = 1;
		}

		//Eisfora
		if ($_SESSION['f02_pg030'] == 1) {
			$data['v1041_not_readonly'] = 1;
		}

		//EFK
		if ($_SESSION['f02_pg032'] == 1) {
			$data['v616_not_readonly'] = 1;
		}

		//Eisfora
		if ($_SESSION['f02_pg031'] == 1) {
			$data['v160_not_readonly'] = 1;
		}

		//Επιτρέπεται Διαφορετική Αποθήκη ανά Είδος
		if($_SESSION['f02_p633']==0) {
			$data['ordercust_a58_d00_p703_readonly'] = 1;
		}

		//Επιπλέον Αξία Στα Είδη
		if($_SESSION['f02_pg034'] == 1) {
			$data['ordercust_a58_d00_v1042_readonly'] = 0;
		}
	} else if ($mode == 'a67') {
		$data['v104_not_readonly']  = 0;
		$data['v106_not_readonly']  = 0;
		$data['v106a_not_readonly'] = 0;
		$data['v1041_not_readonly'] = 0;
		$data['v616_not_readonly']  = 0;
		// $data['v1042_not_readonly'] = 0;
		$data['v160_not_readonly']  = 0;

		//Τιμη μοναδας
		if ($_SESSION['f02_apg02'] == 1) {
			$data['v104_not_readonly'] = 1;
		}
		//Ekp 1
		if ($_SESSION['f02_apg03'] == 1) {
			$data['v106_not_readonly'] = 1;
		}

		//Ekp 2
		if ($_SESSION['f02_apg033'] == 1) {
			$data['v106a_not_readonly'] = 1;
		}

		//Eisfora
		if ($_SESSION['f02_apg030'] == 1) {
			$data['v1041_not_readonly'] = 1;
		}

		//EFK
		if ($_SESSION['f02_apg032'] == 1) {
			$data['v616_not_readonly'] = 1;
		}

		//Eisfora
		if ($_SESSION['f02_apg031'] == 1) {
			$data['v160_not_readonly'] = 1;
		}

		//Επιτρέπεται Διαφορετική Αποθήκη ανά Είδος
		if($_SESSION['f02_p633'] == 0) {
			$data['ordersupp_a68_d00_p703_readonly'] = 1;
		}

		//Επιπλέον Αξία Στα Είδη
		if($_SESSION['f02_apg034'] == 1) {
			$data['ordersupp_a68_d00_v1042_readonly'] = 0;
		}
	} else if ($mode == 'a61') {
		//Πάντα τα πεδία αυτά είναι editable στις εσωτερικές παραγγελίες.
		//Τιμή Μονάδας
		$data['v104_not_readonly']  = 1;
		//Εκπτωση 1
		$data['v106_not_readonly']  = 1;
		//Εκπτωση 2
		$data['v106a_not_readonly'] = 1;
		//Εισφωρά Ανακύκλωσης
		$data['v1041_not_readonly'] = 1;
		//Ε.Φ.Κ.
		$data['v616_not_readonly']  = 1;
		//Επιπλέον Αξία
		$data['v1042_not_readonly'] = 1;
		//Αιτιολογία
		$data['v160_not_readonly']  = 1;

		//Επιτρέπεται Διαφορετική Αποθήκη ανά Είδος
		if(empty($_SESSION['f02_p633'])) {
			$data['interorder_a62_d00_p03_readonly'] = 1;
			$data['interorder_a62_d00_p04_readonly'] = 1;
		} else {
			$data['interorder_a62_d00_p03_readonly'] = 0;
			$data['interorder_a62_d00_p04_readonly'] = 0;
		}

		//Επιπλέον Αξία
		$data['v1042_not_readonly'] = 0;
	}else if ($mode == 'a60') {
		$data['p0601_readonly'] = 0;
		$data[$module_d_prefix . 'p0601_readonly'] = 0;
		$data[$module_d_prefix . 'p04_readonly']   = 0;
		$data[$module_d_prefix . 'p010_readonly']  = 0;
		$data[$module_d_prefix . 'p010a_readonly'] = 0;
		$data[$module_d_prefix . 'p041_readonly']  = 0;
		$data[$module_d_prefix . 'p616_readonly']  = 0;

		//Επιτρέπεται Διαφορετική Αποθήκη ανά Είδος
		if(empty($_SESSION['f02_p633'])) {
			$data[$module_d_prefix . 'p610_readonly']  = 1;
			$data[$module_d_prefix . 'vapc2_readonly'] = 1;
		} else {
			$data[$module_d_prefix . 'p610_readonly']  = 0;
			$data[$module_d_prefix . 'vapc2_readonly'] = 0;
		}

		//Επιπλέον Αξία
		$data[$module_d_prefix . 'p042_readonly']  = 0;
	}
	
	return $data;
}

function invoices_show_stock_screen($data)
{

	$return_array = array();
	if ($data['mode'] == 'a57' && $_SESSION['f02_pgp10'] == 1) {
		$msg = ordercust_check_product_availability(
			$data['nr01'],
			$data['p590'],
			$data['p610'],
			$data['tmp_nr01']
		);
		if (!pegasus_check_permission('ordercust.deny_if_unavailable')) {
			$return_array['availability_text_alert']  = $msg;
		} else {
			$return_array['availability_text_warn']  = $msg;
		}
	}

	if (
		($data['mode'] == 'a55' || $data['mode'] == 'retail00_01') && !($_SESSION['f02_pg13'] == 1) ||
		$data['mode'] == 'a57' && !($_SESSION['f02_pgp13'] == 1) ||
		$data['mode'] == 'a56' && !($_SESSION['f02_apg13'] == 1) ||
		$data['mode'] == 'a67' && !($_SESSION['f02_apgp13'] == 1)
	) {
		return $return_array;
	}

	$return_array['text'] = $_SESSION['peg_dic_invoices_stock_screen'];
	$query = " SELECT i00.pno as i00_pno,
						i00.name as i00_name,
						ifnull(i00tot_wh.p03,0) as i00tot_p03,
						ifnull(sum(i00tot_tot.p03),0) as i00tot_p03_tot,
						ifnull(i00tot_wh.p04,0) as i00tot_p04,
						ifnull(sum(i00tot_tot.p04),0) as i00tot_p04_tot,
						ifnull(i00tot_wh.p05 ,0)as i00tot_p05,
						ifnull(sum(i00tot_tot.p05),0) as i00tot_p05_tot,
						ifnull((select if(i28.p03=0, null, i28.p03) from i28 where i28.p05=:i16_p00_00 and i28.p01=:i00_pno_00 ),i00.rp) as i00_rp,
						ifnull((select if(i28.p04=0, null, i28.p04) from i28 where i28.p05=:i16_p00_01 and i28.p01=:i00_pno_01),i00.op) as i00_op,
						:i16_p00_02 as i16_p00,
						(select i16.p01 from i16 where p00=:i16_p00_03) as i16_p01

		from i00 
		left join i00tot as i00tot_tot on i00tot_tot.pno1=i00.pno
		left join i00tot as i00tot_wh on i00tot_wh.pno1=i00.pno and i00tot_wh.p610=:i16_p00_04


		where i00.pno=:i00_pno_02
		group by i00.pno";
	$query_params = array(
		'i16_p00_00'	=>	$data['p610'],
		'i16_p00_01'	=>	$data['p610'],
		'i16_p00_02'	=>	$data['p610'],
		'i16_p00_03'	=>	$data['p610'],
		'i16_p00_04'	=>	$data['p610'],
		'i00_pno_00'	=>	$data['pno'],
		'i00_pno_01'	=>	$data['pno'],
		'i00_pno_02'	=>	$data['pno']
	);
	pegasus_mysql_use($query, $res, $query_params);
	foreach ($res as $key => $value) {
		$return_array['text'] = str_replace("##$key##", $value, $return_array['text']);
	}
	return $return_array;
}


/**
 * $input_array['mode']
 * $input_array['nr01']
 * $input_array['date']
 * $input_array['v101']
 * $input_array['v103']
 * $input_array['kath_fpa']
 */

function invoice_add_product_to_tmp($input_array)
{

	//Aν δεν το σωστο mode
	if (!($input_array['mode'] == 'a55' || $input_array['mode'] == 'a56' || $input_array['mode'] == 'a60' || $input_array['mode'] == 'a57' || $input_array['mode'] == 'a67' || $input_array['mode'] == 'a61')) {
		return false;
	}

	//Aν δεν εχει nr01
	if (!($input_array['nr01'] > 0)) {
		return false;
	}

	$request =  array();
	$request[$input_array['mode'] . '_nr01'] = $input_array['nr01'];
	$request[$input_array['mode'] . '_p03']  = pegasusGetGlobalVar('peg_' . $input_array['mode'] . '_d-' . $input_array['nr01'] . '_p03');
	$request[$input_array['mode'] . '_p05']  = pegasusGetGlobalVar('peg_' . $input_array['mode'] . '_d-' . $input_array['nr01'] . '_p05');
	$request[$input_array['mode'] . '_p07']  = pegasusGetGlobalVar('peg_' . $input_array['mode'] . '_d-' . $input_array['nr01'] . '_p07');
	$request[$input_array['mode'] . '_p805'] = pegasusGetGlobalVar('peg_' . $input_array['mode'] . '_d-' . $input_array['nr01'] . '_p805');
	$request['date'] 	 = $input_array['date'];
	$request['v101'] 	 = $input_array['v101'];
	$request['kath_fpa'] = $input_array['kath_fpa'];


	//product_data
	$product_data = peg_invoice_find_product_data($request);

	$db_array = array();
	if ($input_array['mode'] == 'a55' || $input_array['mode'] == 'a56' || $input_array['mode'] == 'a60') {
		$db_array['p01']   = $product_data['v101'];
		$db_array['p02']   = $product_data['v102'];
		$db_array['p03']   = $product_data['v103'];
		$db_array['p04']   = $product_data['v104'];
		$db_array['p0601'] = $product_data['v160'];
		$db_array['p030']  = $product_data['v120'];
		$db_array['p301']  = $product_data['v301'];
		$db_array['p302']  = $product_data['v302'];
		$db_array['p303']  = $product_data['v303'];
		$db_array['p304']  = $product_data['v304'];
		$db_array['p306']  = $product_data['v306'];
		$db_array['p307']  = $product_data['v307'];
		$db_array['p08']   = $product_data['fpa'];
		$db_array['p081']  = $product_data['kfpa'];
		$db_array['p010']  = $product_data['v106'];
		$db_array['p010a'] = $product_data['v106a'];
		$db_array['p041']  = $product_data['v1041'];
		$db_array['p616']  = $product_data['v616'];
		$db_array['p616p'] = $product_data['p616p'];
		$db_array['p309']  = $product_data['v309'];
		$db_array['p308']  = $product_data['v308'];
		$db_array['p614']  = $product_data['v614'];
		$db_array['p03']   = $product_data['v103'];
		$db_array['p030']  = $product_data['v120'];
	}

	if ($input_array['mode'] == 'a57' || $input_array['mode'] == 'a67' || $input_array['mode'] == 'a61') {
		$db_array['v101'] 	= $product_data['v101'];
		$db_array['v102'] 	= $product_data['v102'];
		$db_array['v103'] 	= $product_data['v103'];
		$db_array['v104'] 	= $product_data['v104'];
		$db_array['v160'] 	= $product_data['v160'];
		$db_array['v120'] 	= $product_data['v120'];
		$db_array['v301'] 	= $product_data['v301'];
		$db_array['v302'] 	= $product_data['v302'];
		$db_array['v303'] 	= $product_data['v303'];
		$db_array['v304'] 	= $product_data['v304'];
		$db_array['v306'] 	= $product_data['v306'];
		$db_array['v307'] 	= $product_data['v307'];
		$db_array['v105'] 	= $product_data['fpa'];
		$db_array['v108'] 	= $product_data['kfpa'];
		$db_array['v106'] 	= $product_data['v106'];
		$db_array['v106a']  = $product_data['v106a'];
		$db_array['v1041']  = $product_data['v1041'];
		$db_array['v616']   = $product_data['v616'];


		if ($input_array['mode'] !== 'a61') {
			$db_array['p616p']  = $product_data['p616p'];
		}

		$db_array['v309']  	= $product_data['v309'];
		$db_array['v308']  	= $product_data['v308'];

		if ($input_array['mode'] !== 'a67') {
			$db_array['v614']  	= $product_data['v614'];
		}

		$db_array['v103']  	= $product_data['v103'];
		$db_array['v120']  	= $product_data['v120'];
		$db_array['v107']  	= $product_data['v107'];
	}

	$db_array['timh1']  = $product_data['timh1'];
	$db_array['timh2']  = $product_data['timh2'];
	$db_array['timh3']  = $product_data['timh3'];
	$db_array['timh4']  = $product_data['timh4'];

	if ($input_array['mode'] == 'a56') {
		$db_array['p013'] = $request['date'];
		$db_array['p06']  = $request[$input_array['mode'] . '_nr01'];
		$db_array['p07']  = 1;
		$table = 'peg_tmp_i01';
		$db_array['nr01']  = pegasus_mysql_newrec('i01');
	}

	if ($input_array['mode'] == 'a55') {
		$db_array['p013'] = $request['date'];
		$db_array['p06']  = $request[$input_array['mode'] . '_nr01'];
		$db_array['p07']  = 2;
		$table = 'peg_tmp_i01';
		$db_array['nr01']  = pegasus_mysql_newrec('i01');
	}

	if ($input_array['mode'] == 'a60') {
		$db_array['p013'] = $request['date'];
		$db_array['p06']  = $request[$input_array['mode'] . '_nr01'];
		$db_array['p07']  = 3;
		$table = 'peg_tmp_i01';
		$db_array['nr01']  = pegasus_mysql_newrec('i01');
	}

	if ($input_array['mode'] == 'a57') {
		$db_array['p00']  = $request[$input_array['mode'] . '_nr01'];
		$table = 'peg_tmp_a58';
		$db_array['nr01']  = pegasus_mysql_newrec('a58');
	}

	if ($input_array['mode'] == 'a67') {
		$db_array['p00']  = $request[$input_array['mode'] . '_nr01'];
		$table = 'peg_tmp_a68';
		$db_array['nr01']  = pegasus_mysql_newrec('a68');
	}

	if ($input_array['mode'] == 'a61') {
		$db_array['p00']  = $request[$input_array['mode'] . '_nr01'];
		$table = 'peg_tmp_a62';
		$db_array['nr01']  = pegasus_mysql_newrec('a62');
	}

	$db_array['peg_mmnr01']    = $input_array['mode'] . '_d-' . $request[$input_array['mode'] . '_nr01'];
	$db_array['peg_mnr01']     = $request[$input_array['mode'] . '_nr01'];
	$db_array['peg_flag']  = '1';
	$db_array['peg_sess_id']  = session_id();
	pegasus_mysql_insert($table, array_keys($db_array), array_values($db_array));


	// echo print_r($db_array , true);
	return $db_array['nr01'];
}

function invoices_a30_d_initialize($data = array(), $mmnr01 = '', $mnr01 = '', $_d = '', $container_id = '')
{

	$peg_tmp_newrec = 0;
	if (empty($data['nr01']) and empty($_REQUEST['rec_copy_nr01'])) {
		$peg_tmp_newrec = 1;
	}

	if ($peg_tmp_newrec == 1) {
		$data['p104'] = -1;
		$data['p105'] = -1;
	}
	
	//Παραμετροποίηση Lotify
	$data['v_q30_640008'] = pegasus_mysql_printfld("q31", "p05", "p03 = ? and p01 = 640008", array($data['p01'])); 
	$data['v_q30_640005'] = pegasus_mysql_printfld("q31", "p05", "p03 = ? and p01 = 640005", array($data['p01'])); 
	$data['v_q30_640002'] = pegasus_mysql_printfld("q31", "p05", "p03 = ? and p01 = 640002", array($data['p01'])); 

	//Παραμετροποίηση myDATA
	$data['v_q30_620072'] = pegasus_mysql_printfld("q31", "p05", "p03 = ? and p01 = 620072", array($data['p01'])); 

	//Παραμετροποίηση Oil
	$data['v_q30_650000'] = pegasus_mysql_printfld("q31", "p05", "p03 = ? and p01 = 650000", array($data['p01'])); 

	return $data;
}
function invoices_a30_d_onsave($data, $permDeny, $mmnr01, $checkOnlyPerm)
{
	global $PegInput;

	//Δεν επιτρέπουμε την καταχώριση νέας εγγραφής με p01 = 0
	$new_check = pegasus_mysql_printfld('a30', 'nr01', 'a30.p01 = 0');
	if($data['p01'] == 0 && empty($new_check)){
		array_push($permDeny, array('type'=>'deny', 'message'=>$_SESSION['peg_dic_invoices_a30_p01_empty_deny'])); 
	}

	// Permdeny αν έστω μια επιλεγμένη αποθήκη, δεν έχει το επιλεγμένο κατάστημα και κανενός η τιμή δεν είναι -1.
	if(pegasus_module_exists('stores')) {
		if(!empty($data['p104'])) {
			$p104_t07p01 = pegasus_mysql_printfld('i16', 't07p01', 'p00 = :p104', array("p104" => $data['p104']));
		}
	
		if(!empty($data['p105'])) {
			$p105_t07p01 = pegasus_mysql_printfld('i16', 't07p01', 'p00 = :p105', array("p105" => $data['p105']));
		}

		if (
			(isset($p104_t07p01) && $p104_t07p01 != $data['p010'] && $p104_t07p01 != -1 && $data['p010'] != -1) &&
			(isset($p105_t07p01) && $p105_t07p01 != $data['p010'] && $p105_t07p01 != -1 && $data['p010'] != -1)
		) {
			array_push($permDeny, array('type' => 'deny', 'message' => 'Καμία από τις αποθήκες του παραστατικού δεν έχουν ορισμένο το επιλεγμένο κατάστημα')); 
		}
	}


	
	if ($checkOnlyPerm == 1){
		if(pegasus_module_exists("mydt")) {
			// Παραμετροποίηση myData
			$PegInput->addVar(new peg_input_alphanumeric('v_q30_620072', 'request'));

			$v_q30_620072 = $PegInput->getRequest('v_q30_620072');

			core00_manage_relation($v_q30_620072, '620072', $data['p01']);
		}

		if(pegasus_module_exists("lotf")) {
			// Παραμετροποίηση Lotify
			$PegInput->addVar(new peg_input_alphanumeric('v_q30_640008', 'request'));
			$PegInput->addVar(new peg_input_alphanumeric('v_q30_640005', 'request'));
			$PegInput->addVar(new peg_input_alphanumeric('v_q30_640003', 'request'));	
			
			$v_q30_640008 = $PegInput->getRequest('v_q30_640008');
			$v_q30_640005 = $PegInput->getRequest('v_q30_640005');
			$v_q30_640002 = $PegInput->getRequest('v_q30_640002');
			
			core00_manage_relation($v_q30_640008, '640008', $data['p01']);
			core00_manage_relation($v_q30_640005, '640005', $data['p01']);
			core00_manage_relation($v_q30_640002, '640002', $data['p01']);			
		}

		if(pegasus_module_exists("oil01")) {
			// Παραμετροποίηση Oil
			$PegInput->addVar(new peg_input_alphanumeric('v_q30_650000', 'request'));

			$v_q30_650000 = $PegInput->getRequest('v_q30_650000');

			core00_manage_relation($v_q30_650000, '650000', $data['p01']);
		}
	}

	return array(
		'data' => $data, 
		'permDeny' => $permDeny
	);
}
/**
 * @param p05 : Τυπος Παραστατικού
 * @param p701 : Σειρά
 * @param p0121 : Καταστημα
 * @param p08: Χειρόγραφο
 *  */
function invoices_refresh_invoice_num($mode, $nr01, $p05, $p701, $p0121, $p08)
{

	$result_array = array();
	$result_array['change_value'] = 0;
	$metritis = 0;
	//$dikaiomata= '';

	if ($mode == 'a55' || $mode == 'retail00_01') {
		$is_new = 1;
		if ($nr01 > 0) {
			if (pegasus_mysql_printfld('a55', 'count(*)', 'nr01=? ', array($nr01)) > 0) {
				$is_new = 0;
			}
		}

		pegasus_mysql_use('select * from a10 where p01=? ', $a10, array($p05));
		$metritis = $a10['p06'];
		//$dikaiomata=pegasus_check_permission('invcust_master');
	} else if ($mode == 'a56') {
		$is_new = 1;
		if ($nr01 > 0) {
			if (pegasus_mysql_printfld('a56', 'count(*)', 'nr01=? ', array($nr01)) > 0) {
				$is_new = 0;
			}
		}

		pegasus_mysql_use('select * from a11 where p01=? ', $a11, array($p05));
		$metritis = $a11['p06'];
		//$dikaiomata=pegasus_check_permission('invsupp_master');
	} else if ($mode == 'a60') {
		$is_new = 1;
		if ($nr01 > 0) {
			if (pegasus_mysql_printfld('a60', 'count(*)', 'nr01=? ', array($nr01)) > 0) {
				$is_new = 0;
			}
		}
		pegasus_mysql_use('select * from a30 where p01=? ', $a30, array($p05));
		$metritis = $a30['p06'];
	}
	if (
		$p08 != 1 // Δεν είναι χειρόγραφο
		//&& !$dikaiomata
		&& $is_new == 1
		&& $metritis > 0 // Μετρητής
	) {
		$p06 = account_make_invoice_num($p0121, $metritis, $p701, false);
		$result_array['p06'] = $p06;
		$result_array['change_value'] = 1;
	}
	return $result_array;
}
/**
 *
 * @param  int $data (a01.nr01 || a00.nr01)
 * @return array
 */
function invoices_find_politis($p03 = 0,$mode = 'a55')
{
	$p016 = 0;
	// Πωλητής Πάντα ο Χρήστης
	if ($_SESSION['f02_pg914'] == 1) {
		$p016  = $_SESSION['username'];
	} else {
		$p03_data = array();
		$sql = '';
		switch($mode) {
			case 'a55' :
			case 'a57' :
				$sql = "SELECT p51, pnr01 FROM a01 WHERE nr01 = :nr01";
				break;
			case 'a56' :
			case 'a67' :
				$sql = "SELECT p51, pnr01 FROM a00 WHERE nr01 = :nr01";
				break;
			default :
				$sql = "SELECT p51, pnr01 FROM a01 WHERE nr01 = :nr01";
		}
		$values = array(
			'nr01' => $p03
		);
		pegasus_mysql_use(
			$sql,
			$p03_data,
			$values
		);
		$p016 = $p03_data['p51'];		// Κωδικός Υπεύθυνου
		if (
			empty($p016)
			&& pegasus_module_exists('crm001')
		) {
			// Υπεύθυνος Συναλλασσόμενου
			$p016 = pegasus_mysql_printfld('d00', 'p900', 'nr01= :pnr01', array('pnr01' => $p03_data['pnr01']));
		}
	}
	// Πωλητής ο Καταχωρητής
	if (
		empty($p016) 
		&& $_SESSION['f02_pg902'] == 1
	) {
		$p016 = $_SESSION['username'];
	}
	return array(
		'ok'	=> 1,
		'data'	=> array(
			'p016'			=> $p016,
			'p016_display'	=> pegasus_mysql_printfld('us0','p100','p01 = :p01',array('p01' => $p016))
		)
	);
}


function invoices_check_if_zero_prices($mode, $nr01) {
	if($mode == "retail00_01") {
		$mode = "a55";
	}

	$p05 = 0;
	$p05_table = '';

	if($mode == "a55" || $mode == "a57") {
		$p05 = pegasusGetGlobalVar('peg_' . $mode . '_d-' . $nr01 . '_p05');
		$p05_table = 'a10';
	} else if($mode == "a56" || $mode == "a67") {
		$p05 = pegasusGetGlobalVar('peg_' . $mode . '_d-' . $nr01 . '_p05');
		$p05_table = 'a11';
	} else if($mode == "a60" || $mode == "a61") {
		$p05 = pegasusGetGlobalVar('peg_' . $mode . '_d-' . $nr01 . '_p05');
		$p05_table = 'a30';
	}

	if (!empty($p05)) {
		return pegasus_mysql_printfld($p05_table, 'p107', 'p01=?', array($p05));
	}

	return 0;
}

/** Καλείται όταν επιλέγουμε το button "Τιμολόγηση Παραγγελίας" από
 * Παραγγελία Προμηθευτή, Πελάτη ή Εσωτερική
 * @param request το REQUEST με το nr01 της παραγγελίας και την οθόνη που πάει να ανοίξει
 **/
function invoices_check_if_order_not_invoiced_from_p05_1($request)
{
	$ret_array['open_tab'] = 1;

	/* M.K Παραγγελίας */
	$nr01 = $request['nr01'];

	/* ποια οθόνη θα ανοίξει */
	$mode = $request['mode'];

	/* Παραγγελία Προμηθευτή */
	if ($mode == 'a67') {
		$query = '  SELECT p05_1 FROM a34
					JOIN a67 on a67.p590 = a34.p01
					WHERE a67.nr01 = :nr01';

		/* Εσωτερική Παραγγελία */
	} else if ($mode == 'a61') {
		$query = '  SELECT p05_1 FROM a64
					JOIN a61 on a61.p590 = a64.p01
					WHERE a61.nr01 = :nr01';

		/* Παραγγελία Πελάτη */
	} else {
		$query = '  SELECT p05_1 FROM a33
					JOIN a57 on a57.p590 = a33.p01
					WHERE a57.nr01 = :nr01';
	}

	$query_params = array('nr01' => $nr01);

	pegasus_mysql_use($query, $results, $query_params);

	/* Εάν ο χρήστης έχει επιλέξει ή όχι  το "Δεν Τιμολογείται η παραγγελία" από την κατάσταση αυτής. */
	if ($results['p05_1'] == 1) {
		$ret_array['msg'] = $_SESSION['peg_dic_invoices_order_not_invoiced'];
		$ret_array['open_tab'] = 0;
	} else if ($results['p05_1'] == 0) {
		$ret_array['open_tab'] = 1;
	}

	return $ret_array;
}
function invoices_recalc_prices_custom_actions_peg002($retArray = array(), $id = '')
{
	$peg_handler = "invoices_recalc_prices(screen.getContainer_ID(),'" . $id . "')";
	$retArray[] = array(
		'xtype' => 'pegasusToolBarGridAction',
		'peg_custom_id' => 'invoices_recalc_prices',
		'icon' => 'invoices_images/invoices_recalc_prices_16px.png',
		'text' =>  $_SESSION['peg_dic_invoices_recalc_prices'],
		'peghandler' => $peg_handler
	);
	return $retArray;
}
function invoices_calc_efk_custom_actions_peg002($retArray = array(), $id = '')
{
	$peg_handler = "invoices_calc_efk(screen.getContainer_ID())";
	$retArray[] = array(
		'xtype' => 'pegasusToolBarGridAction',
		'peg_custom_id' => 'invoices_calc_efk',
		'iconCls' => 'fas fa-recycle',
		'text' =>  $_SESSION['peg_dic_invoices_calc_efk'],
		'peghandler' => $peg_handler
	);
	return $retArray;
}

function invoices_total_quantity_of_items_per_unit_custom_actions_peg002($retArray = array(), $id = '') {
	$peg_handler = "invoices_total_quantity_of_items_per_unit(screen.getContainer_ID())";
	$retArray[] = array(
		'xtype' => 'pegasusToolBarGridAction',
		'peg_custom_id' => 'invoices_total_quantity_of_items_per_unit',
		'iconCls' => 'fas fa-database',
		'text' =>  $_SESSION['peg_dic_invoices_total_quantity_of_items_per_unit'],
		'peghandler' => $peg_handler
	);
	return $retArray;
}

//Σύνολα Ποσότητας ανά Είδος
function invoices_total_quantity_per_item_custom_actions_peg002($retArray = array()) {
	$peg_handler = "invoices_total_quantity_per_item(screen.getContainer_ID())";
	$retArray[] = array(
		'xtype' => 'pegasusToolBarGridAction',
		'peg_custom_id' => 'invoices_total_quantity_per_item',
		'iconCls' => 'fas fa-cubes',
		'text' =>  $_SESSION['peg_dic_invoices_total_quantity_per_item'],
		'peghandler' => $peg_handler
	);
	return $retArray;
}

/**
 * Προσθέτει το custom action της Καρτέλας Είδους
 *
 * @param array $data		To array με τα υπόλοιπα custom actions (set as array() για κλήση από field)
 * @return boolean
 */
function invoices_inventory_item_custom_actions_peg002($data = array()) {	
	$peg_handler = "
		var row=pegGridGetSelectedRow(screen.getContainer_ID() , 'grid' , screen.getMnr01(), screen.getMmnr01());
		if(row){
			pegEditRec2Tab( 'i00' , 'i00_d' , 'inventory' , screen.getContainer_ID()  , 'pno' , row.p01 );
		}else{
			pegAlert('" . $_SESSION['peg_dic_inventory_must_select_record'] . "');
		}
	";
	$data[] = array(
		'xtype' => 'pegasusToolBarGridAction',
		'peg_custom_id' => 'inventory_item',
		'viewModel' => array(
			'type' => 'GridButtonModel',
			'isToolBar' => 1,
			'data' => array(
				'toolBarButton' => 'inventory_item',

			)
		),
		'icon' => 'inventory_images/i00_16x16.png',
		'text' =>  $_SESSION['peg_dic_inventory_item_details'],
		'peghandler' => $peg_handler
	);
	return $data;
}
/** Συνάρτηση για τον επαναυπολογισμο των χαρακτηριστικων των ειδών στο grid των προιόντων
 * 	Για ordercust,invcust,ordersupp,invsupp,interorder,invtrans00
 *  @param mixed $mode : a55,a56,a57,a67,a60,a61
 * 	@param mixed $container_id: id container
 * 	@param mixed $p03: Πελάτης/Προμηδευτής
 * 	@param boolean $p07: Οι τιμές έχουν ΦΠΑ {0,1}
 * 	@param number $p703: Αποθηκευτικός χώρος
 * 	@param number $kath_fpa: Καθεστός ΦΠΑ
 * 	@param mixed $date : Ημ/νία Παραστατικόυ/Παραγγελίας
 *  @param int $invoice_nr01: Το ΜΚ του παραστατικού
 *  @param int $p03_p48: Βασικός Τιμοκατάλογος
 *  @param int $p03_p06: Ειδικός Τιμοκατάλογος
 *  @param int $p03_p52: % Έκπτωση 1
 *  @param int $p03_p52a: % Έκπτωση 2
 *  @param int $p03_p523: % Επιβάρυνσης
 *  @param int $get_last_prices: Εύρεση των τελευταίων τιμών πώλησης/αγοράς
 *  @param int $only_zero_prices: Επανεύρεση τιμών στα είδη με μηδενική τιμή
 */
function invoices_recalulate_prices(
	$mode, 
	$container_id, 
	$p03, 
	$p07, 
	$p703, 
	$kath_fpa, 
	$date, 
	$invoice_nr01,
	$cona11_nr01,
	$p03_p48 = 0,
	$p03_p06 = 0,
	$p03_p52 = 0,
	$p03_p52a = 0,
	$p03_p523 = 0,
	$get_last_prices = 0,
	$only_zero_prices = 0
)
{
	if($mode == 'retail00_01') {
		$mode = 'a55';
	}
	$where = pegasusGetGlobalVar($container_id . '_where_eidi');

	switch ($mode) {
		case 'a57':
			$query = "SELECT * FROM peg_tmp_a58 WHERE " . $where;
			$tbl_to_update = 'peg_tmp_a58';
			break;
		case 'a67':
			$query = "SELECT * FROM peg_tmp_a68 WHERE " . $where;
			$tbl_to_update = 'peg_tmp_a68';
			break;
		case 'a61':
			$query = "SELECT * FROM peg_tmp_a62 WHERE " . $where;
			$tbl_to_update = 'peg_tmp_a62';
			break;
		default:
			if (is_array($where)) {
				$query = "SELECT * FROM peg_tmp_i01 WHERE " . $where['sql'];
			} else {
				$query = "SELECT * FROM peg_tmp_i01 WHERE " . $where;
			}
			$tbl_to_update = 'peg_tmp_i01';
			break;
	}
	//Έλεγχος αν ειναι array το where λόγω invtrans00 .Στο μέλλον θα προσαρμοστει και για τα υπόλοιπα
	if (is_array($where)) {
		$res = pegasus_query($query, $where['sqlParams']);
	} else {
		$res = pegasus_query($query);
	}

	while ($row = pegasus_fetch_assoc($res)) {
		$result_arr = array();
		$arr_to_upd = array();
		$pno = null;
		$quantity = null;
		$user_mode = 'a01'; //Τύπος χρήστη

		if ($mode == 'a57' || $mode == 'a67' || $mode == 'a61') {
			$pno = $row['v101'];
			$quantity = $row['v103'];
			$package_price = $row['v104_1'];
			$package_quan  = $row['v1030_1'];
			$price = $row['v104'];
			$additional_value = $row['v1042'];

			if($mode == "a67") {
				$user_mode = 'a00';
			}
		} else {
			$pno = $row['p01'];
			$quantity = $row['p03'];
			$package_price = $row['p04_1'];
			$package_quan  = $row['p030_1'];
			$price = $row['p04'];
			$additional_value = $row['p042'];

			// Βρίσκω αν είμαι σε παραστατικό προμηθευτή από την Κατηγορία Κίνησης του i01
			if($row['p07'] == 1) {
				$user_mode = 'a00';
			}
		}

		if($only_zero_prices == 1 && $price != 0) {
			continue;
		}

		//εύρεση του είδους απο την αποθήκη.
		pegasus_mysql_use('select * from i00 where pno=? ', $i00, array($pno));
		$zero_prices = invoices_check_if_zero_prices($mode, $invoice_nr01);
		if ($mode == 'a60' || $mode == 'a61') {
			//Άλλαξα το kath_fpa,p07,p703 σε 0 γιατί δεν φαινεται για τις εσωτερικες να ειναι ποτε <>0
			$price_array = inventory_find_price($pno, 0, $quantity, $date, 0, '-', 0, false, 4, 0, 0, 0 ,0, '','',$zero_prices);
		} else {
			$price_array = inventory_find_price(
				$pno, //pno
				$p03,
				$quantity, //posotita
				$date,
				$kath_fpa,
				$user_mode,
				$p07,
				$p703,
				$p03_p48,
				$p03_p06,
				$p03_p52,
				$p03_p52a,
				$p03_p523,
				'',
				$cona11_nr01,
				$zero_prices
			);

			if($get_last_prices == 1) {
				$last_price_array = invoices_i01_get_last_prices($mode, $row['nr01'], $pno, $p03);

				if(!empty($last_price_array)) {
					$price_array['price']      = $last_price_array['p04'];
					$price_array['discount_1'] = $last_price_array['p010'];
					$price_array['discount_2'] = $last_price_array['p010a'];
					$additional_value 		   = $last_price_array['p042'];					
				}
			}
		}

		$discount_1 = $price_array['discount_1'];
		$discount_2 = $price_array['discount_2'];

		//τιμή μόναδας
		if($package_price == 0 || $package_quan == 0){
			$result_arr['v104']  = $price_array['price'];
		}else{
			$result_arr['v104']  = $price;
		}


		$result_arr['fpa']   = $price_array['fpa'];
		//katigoria fpa
		$result_arr['kfpa']  = $price_array['kfpa'];
		//Eκπτωση 1
		$result_arr['v106']  = floatval($discount_1);
		//Eκπτωση 2
		$result_arr['v106a'] = floatval($discount_2);
		//Επιπλέον Αξία
		$result_arr['v1042'] = $additional_value;
		//Τιμή Συσκευασίας
		$result_arr['v104_1'] = $package_price;
		//Eisfora anakyklvsiw
		// $result_arr['v1041'] = floatval($i00['p905']);
		$result_arr['v1041'] = $price_array['eisfora_anakyklosis'];

		// Βρίσκω ΕΦΚ από το είδος -- Δεν έπαιζε σωστά πριν, το έφερνε πάντα 0 εδώ και δεν το υπολόγιζε.
		$result_arr['v616']  = floatval($i00['p616']);
		$result_arr['p616p']  = floatval($i00['p616p']);
		$p616 = invoices_calculate_EFK(
			$pno, //pno
			$result_arr['v104'],
			$discount_1,
			$discount_2,
			$result_arr['fpa'],
			$p07,
			$result_arr['v616'],
			$result_arr['p616p']
		);

		$result_arr['v616'] = floatval($p616);

		if($zero_prices == 1) {
			$result_arr['v616']   = 0; // Ε.Φ.Κ.
			$result_arr['v1042']  = 0; // Επιπλέον Αξία
			$result_arr['v104_1'] = 0; // Τιμή Συσκευασίας
		}

		$v107  = invoices_make_product_total(
			$quantity, //posotita
			$result_arr['v104'],
			$result_arr['fpa'],
			$result_arr['v106'],
			$result_arr['v106a'],
			$result_arr['v1041'],
			$result_arr['v616'],
			$price_array['preview_wthfpa'],
			$additional_value
		);

		// Προσθέσαμε στο update και τα ΕΦΚ, Εισφορά Ανακύκλωσης.
		if ($mode == 'a57' || $mode == 'a67' || $mode == 'a61') {
			$arr_to_upd['v104'] = $result_arr['v104'];
			$arr_to_upd['v107'] = $v107;
			$arr_to_upd['v105'] = $result_arr['fpa'];
			$arr_to_upd['v106'] = $result_arr['v106'];
			$arr_to_upd['v106a'] = $result_arr['v106a'];

			$arr_to_upd['v616']   = $result_arr['v616'];
			$arr_to_upd['v1041']  = $result_arr['v1041'];
			$arr_to_upd['v1042']  = $result_arr['v1042'];
			$arr_to_upd['v104_1'] = $result_arr['v104_1'];
		} else {
			$arr_to_upd['p04'] = $result_arr['v104'];
			$arr_to_upd['p08'] = $result_arr['fpa'];
			$arr_to_upd['p081'] = $result_arr['kfpa'];
			$arr_to_upd['p010'] = $result_arr['v106'];
			//$arr_to_upd['p011'] = $result_arr['v104'] / (1+ ($result_arr['fpa']/100)); καθαρη αξια
			$arr_to_upd['p010a'] = $result_arr['v106a'];

			$arr_to_upd['p616']  = $result_arr['v616'];
			$arr_to_upd['p041']  = $result_arr['v1041'];
			$arr_to_upd['p042']  = $result_arr['v1042'];
			$arr_to_upd['p04_1'] = $result_arr['v104_1'];
		}
		$arr_to_upd['peg_flag'] = 2;

		if (is_array($where)) {
			$params = array_merge($where['sqlParams'], array('var_nr01' => $row['nr01']));
			pegasus_mysql_update($tbl_to_update, array_keys($arr_to_upd), array_values($arr_to_upd), $where['sql'] . ' AND nr01=:var_nr01', 0, 1, 1, $params);
		} else {
			pegasus_mysql_update($tbl_to_update, array_keys($arr_to_upd), array_values($arr_to_upd), $where . ' AND nr01=:var_nr01', 0, 1, 1, array('var_nr01' => $row['nr01']));
		}
	}

	return array('ok' => 1);
}
/** Υπολογίζει το ΕΦΚ ή κάνει reset (ΕΦΚ=0) το ΕΦΚ 
 * @param mixed $container_id
 * @param boolean $p07: Οι τιμές έχουν ΦΠΑ.
 * @param mixed $invoice_nr01: a55.nr01 || a56.nr01
 */
function invoices_calculate_efk_action($container_id, $p07, $mode)
{
	$ret_array = array();
	$ret_array['ok'] = 1;
	$ret_array['msg'] = $_SESSION['peg_dic_invoices_efk_calculated'];
	//Check απο βασικές Παραμέτρους
	if($mode ==='a55' || $mode ==='a57'){
		$has_efk = $_SESSION['f02_pg032'];
	}else{
		$has_efk = $_SESSION['f02_apg032'];
	}

	if($has_efk == 0){
		$ret_array['ok'] = 0;
		$ret_array['msg'] = $_SESSION['peg_dic_invoices_efk_check_'.$mode];
		return $ret_array;
	}
	if(!pegasus_check_permission('invoices.calculate_efk')){
		$ret_array['ok'] = 0;
		$ret_array['msg'] = $_SESSION['peg_dic_invoices_calc_efk_permission'];
		return $ret_array;
	}

	//
	$where = pegasusGetGlobalVar($container_id . '_where_eidi');
	if ($mode==='a57') {
		$query = "SELECT * FROM peg_tmp_a58 WHERE ";
	}elseif ($mode==='a67') {
		$query = "SELECT * FROM peg_tmp_a68 WHERE ";
	} else {
		$query = "SELECT * FROM peg_tmp_i01 WHERE ";
	}


	//Έλεγχος αν ειναι array το where λόγω invtrans00 .Στο μέλλον θα προσαρμοστει και για τα υπόλοιπα
	if (is_array($where)) {
		$query = $query . $where['sql'];
		$res = pegasus_query($query, $where['sqlParams']);
	} else {
		$query =$query . $where;
		$res = pegasus_query($query);
	}

	//Βρισκομαι το συνολικο ΕΦΚ για το παραστατικό , αν ειναι >0 τότε θα γίνει 0 και θα υπολογιστουν οι τιμές.
	//Αλλιώς θα υπολογιστει βάσει του ΕΦΚ που έχει το είδος στο i00
	if ($mode==='a57') {
		$query_sum = "SELECT sum(v616) as sum_p616 , sum(p616p)  as sum_p616p FROM peg_tmp_a58 WHERE ";
	}elseif ($mode==='a67') {
		$query_sum = "SELECT sum(v616) as sum_p616 , sum(p616p)  as sum_p616p FROM peg_tmp_a68 WHERE ";
	}else{
		$query_sum = "SELECT sum(p616) as sum_p616 , sum(p616p)  as sum_p616p FROM peg_tmp_i01 WHERE ";
	}
	if (is_array($where)) {
		pegasus_mysql_use(
			$query_sum . $where['sql'],
			$sums_efk,
			$where['sqlParams']
		);
	} else {
		pegasus_mysql_use(
			$query_sum . $where,
			$sums_efk
		);
	}

	while ($row = pegasus_fetch($res)) {
		$arr_to_upd = array();
		if ($mode ==='a57' || $mode ==='a67') {
			$v104   = $row['v104'];
			$v105   = $row['v105'];
			$v106   = $row['v106'];
			$v106a  = $row['v106a'];
			$v1042  = $row['v1042'];
			//Κώδικος αποθήκης
			$v101 = $row['v101'];
		}else{
			$v104   = $row['p04'];
			$v105   = $row['p08'];
			$v106   = $row['p010'];
			$v106a  = $row['p010a'];
			$v1042  = $row['p042'];
			//Κώδικος αποθήκης
			$v101 = $row['p01'];
		}
		if (!($sums_efk['sum_p616'] > floatval(0) || $sums_efk['sum_p616p'] > floatval(0))) {
			pegasus_mysql_use('select * from i00 where pno=? ', $i00, array($v101));
			$v616   = $i00['p616']; //ΕΦΚ
			$p616p  = $i00['p616p']; //% ΕΦΚ
			$v616 = invoices_calculate_EFK($v101, $v104, $v106, $v106a, $v105, $p07, $v616, $p616p);
		} else {
			$v616 = 0;
		}

		if ($mode==='a57') {
			$update_table='peg_tmp_a58';
			$arr_to_upd['v104']  = $v104; 
			$arr_to_upd['v616']  = $v616; 
			$arr_to_upd['v107']	 = invoices_make_product_total($row['v103'], $v104, $v105, $v106, $v106a, $row['v1041'], $v616, $p07, $v1042);
		}elseif ($mode==='a67') {
			$update_table='peg_tmp_a68';
			$arr_to_upd['v104']  = $v104; 
			$arr_to_upd['v616']  = $v616;
			$arr_to_upd['v107']	 = invoices_make_product_total($row['v103'], $v104, $v105, $v106, $v106a, $row['v1041'], $v616, $p07, $v1042);
		}else{
			$update_table='peg_tmp_i01';
			$arr_to_upd['p04']  = $v104; //v104
			$arr_to_upd['p616']  = $v616; //v616
		}
		$arr_to_upd['peg_flag'] = 2;

		pegasus_mysql_update($update_table, array_keys($arr_to_upd), array_values($arr_to_upd), 'nr01=?', 0, 1, 1, array($row['nr01']));
	}
	return $ret_array;
}

function invoices_calc_total_quantity_of_items($container_id, $mode) {
	$ret_array = array();
	$ret_array['ok'] = 1;
	$ret_array['data'] = array();

	if($mode == 'retail00_01') {
		$mode = 'a55';
	}

	$query = '';
	$where = pegasusGetGlobalVar($container_id . '_where_eidi');
	$group_by = " GROUP BY i00.ths ";
	$join_i24 = " LEFT JOIN i24 ON i24.p01 = i00.ths ";
	$peg_tmp_tbl = "";
	$select_val = "";
	$join_val = "";

	if($mode == 'a57') {
		$peg_tmp_tbl = "peg_tmp_a58";
		$select_val = "v103";
		$join_val = "v101";
	} else if($mode == 'a55') {
		$peg_tmp_tbl = "peg_tmp_i01";
		$select_val = "p03";
		$join_val = "p01";
	} else if($mode == 'a56') {
		$peg_tmp_tbl = "peg_tmp_i01";
		$select_val = "p03";
		$join_val = "p01";
	} else if($mode == 'a67') {
		$peg_tmp_tbl = "peg_tmp_a68";
		$select_val = "v103";
		$join_val = "v101";
	} else if($mode == 'a60') {
		$peg_tmp_tbl = "peg_tmp_i01";
		$select_val = "p03";
		$join_val = "p01";
		if(is_array($where)) {
			$where['sql'] .= ' AND (peg_tmp_i01.ppnr01 = 0 OR peg_tmp_i01.ppnr01 = peg_tmp_i01.nr01) ';
		}else{
			$where .= ' AND (peg_tmp_i01.ppnr01 = 0 OR peg_tmp_i01.ppnr01 = peg_tmp_i01.nr01) ';
		}
	} else if($mode == 'a61') {
		$peg_tmp_tbl = "peg_tmp_a62";
		$select_val = "v103";
		$join_val = "v101";
	}

	$query  = "SELECT i24.p02 AS i24_p02, i00.ths, sum(".$peg_tmp_tbl.".".$select_val.") AS sunolo ";
	$query .= " FROM i00 ".$join_i24;
	$query .= " LEFT JOIN ".$peg_tmp_tbl." ON ".$peg_tmp_tbl.".".$join_val." = i00.pno WHERE ";

	if(is_array($where)) {
		$query = $query . $where['sql'] . $group_by;
		$res = pegasus_query($query, $where['sqlParams']);
	} else {
		$query = $query . $where . $group_by;
		$res = pegasus_query($query);		
	}

	$ret_array['data'] = pegasus_fetchall($res);	

	return $ret_array;
}

function invoices_calc_total_quantity_per_item($container_id, $mode) {
	$ret_array = array();
	$ret_array['ok'] = 1;
	$ret_array['data'] = array();

	if($mode == 'retail00_01') {
		$mode = 'a55';
	}

	$where = pegasusGetGlobalVar($container_id . '_where_eidi');
	$where_params = array();

	if($mode == 'a57') {
		$peg_tmp_tbl = "peg_tmp_a58";
		$select_val = "v103";
		$product_code_field = "v101";
		$product_name_field = "v102";
	} else if($mode == 'a67') {
		$peg_tmp_tbl = "peg_tmp_a68";
		$select_val = "v103";
		$product_code_field = "v101";
		$product_name_field = "v102";
	} else if(in_array($mode, array("a55", "a56", "a60"))) {
		$peg_tmp_tbl = "peg_tmp_i01";
		$select_val = "p03";
		$product_code_field = "p01";
		$product_name_field = "p02";

		if(is_array($where)) {
			$where_params = $where['sqlParams'];
			$where = "(peg_tmp_i01.ppnr01 = 0 OR peg_tmp_i01.ppnr01 = peg_tmp_i01.nr01) AND ". $where['sql'];	
		}else{
			$where = '(peg_tmp_i01.ppnr01 = 0 OR peg_tmp_i01.ppnr01 = peg_tmp_i01.nr01) AND '. $where;
		}
	} else if($mode == 'a61') {
		$peg_tmp_tbl = "peg_tmp_a62";
		$select_val = "v103";
		$product_code_field = "v101";
		$product_name_field = "v102";
	} else {
		return;
	}

	$query = "SELECT sum($select_val) as product_quantity_sum, 
					 $product_name_field as product_name,
					 $product_code_field as product_code
			  FROM $peg_tmp_tbl 
			  WHERE $where 
			  GROUP BY $product_code_field" ;

	$res = pegasus_query($query, $where_params);

	$ret_array['data'] = pegasus_fetchall($res);	

	return $ret_array;
}

/** Συνάρτηση για τον επαναυπολογισμο των χαρακτηριστικων των ειδών στο grid των προιόντων
 * 	Για ordercust,invcust,ordersupp,invsupp,interorder,invtrans00
 *  @param mixed $mode : a55,a56,a57,a67,a60,a61
 * 	@param mixed $container_id: id container
 * 	@param number $p703: Αποθηκευτικός χώρος
 *  @param number $np0100: Αρχική αξία παραστατικού
 * 	@param number $np0102: Εκπτωση ποσο προ ΦΠΑ
 * 	@param mixed $date : Ημ/νία Παραστατικόυ/Παραγγελίας
 */
function invoice_calculate_invoice_costs($container_id,$mode,$np0100,$np0102,$date,$p703)
{
	$ret_array = array();
	$ret_array['ok'] = 1;
	$where = pegasusGetGlobalVar($container_id . '_where_eidi');

	switch ($mode) {
		case 'a57':
			$table = "peg_tmp_a58";
			break;
		case 'a67':
			$table = "peg_tmp_a68";
			break;
		case 'a61':
			$table = "peg_tmp_a62";
			break;
		default:
			$table = "peg_tmp_i01";
			break;
	}

	if (is_array($where)) {
		$query = "SELECT * FROM $table WHERE peg_flag!='9' AND " . $where['sql'];
	} else {
		$query = "SELECT * FROM $table WHERE peg_flag!='9' AND " . $where;
	}
	//Έλεγχος αν ειναι array το where λόγω invtrans00 .Στο μέλλον θα προσαρμοστει και για τα υπόλοιπα
	if (is_array($where)) {
		$res = pegasus_query($query, $where['sqlParams']);
	} else {
		$res = pegasus_query($query);
	}

	$nte01 = 0;
	$nte020 = 0;
	while ($row = pegasus_fetch_assoc($res)) {
		$timh1 = $row['timh1'];
		$pno = null;
		$quantity = null;
		$recycle_value = 0;

		if ($mode == 'a57' || $mode == 'a67' || $mode == 'a61') {
			$pno = $row['v101'];
			$quantity = $row['v103'];
			$recycle_value = $row['v1041']; //row['v1042']
		} else {
			$pno = $row['p01'];
			$quantity = $row['p03'];
			$recycle_value = $row['p041']; //p042
		}
		if ($timh1 == 0) {
			$timh1 = inventory_find_cost_price($pno, $p703, $p703, '', $date, 0);
		}

		$nte01  += $quantity * $timh1;
		$nte020 += $quantity * $recycle_value;
	}
	$nte02 = $np0100 - $np0102;
	$nte03 = $nte02 - $nte01;
	$nte030 = $nte03 - $nte020;
	$nte04 = empty($nte01) ? 0 : $nte03 * 100 / $nte01;
	$nte05 = empty($nte02) ? 0 : $nte03 * 100 / $nte02;
	$nte040 = empty($nte01) ? 0 : $nte030 * 100 / $nte01;
	$nte050 = empty($nte02) ? 0 : $nte030 * 100 / $nte02;

	$ret_array['nte01'] = $nte01;
	$ret_array['nte02'] = $nte02;
	$ret_array['nte03'] = $nte03;
	$ret_array['nte04'] = $nte04;
	$ret_array['nte05'] = $nte05;
	$ret_array['nte020'] = $nte020;
	$ret_array['nte030'] = $nte030;
	$ret_array['nte040'] = $nte040;
	$ret_array['nte050'] = $nte050;

	return $ret_array;
}
/**
 * Επιστρέφει όλες τις διαθέσιμες αποποίηση για την γρήγορη καταχώρηση
 *
 * @return array
 */
function invoices__invoices_online_parents()
{
	return array(
		'a37_d'	=> array(
			'module'				=> 'packages',
			'_initialize_function'	=> 'packages_a37_invoices_online_initialize',
			'_insert_function'		=> 'packages_a37_invoices_online_insert'
		),
		'a55_d'	=> array(
			'module'				=> 'invcust',
			//'_initialize_function'	=> '',
			'_insert_function'		=> 'invcust_a55__invoices_online_insert'
		),
		'a56_d'	=> array(
			'module'				=> 'invsupp',
			//'_initialize_function'	=> '',
			'_insert_function'		=> 'invsupp_a56__invoices_online_insert'
		),
		'a60_d'	=> array(
			'module'				=> 'invtrans00',
			//'_initialize_function'	=> '',
			'_insert_function'		=> 'invtrans00_a60__invoices_online_insert'
		),

		//	Παραγγελίες Πελατών
		'a57_d'	=> array(
			'module'				=> 'ordercust',
			//'_initialize_function'	=> '',
			'_insert_function'		=> 'ordercust_a57__invoices_online_insert'
		),
		//	Παραγγελίες Προμηθευτών
		'a67_d'	=> array(
			'module'				=> 'ordersupp',
			//'_initialize_function'	=> '',
			'_insert_function'		=> 'ordersupp_a67__invoices_online_insert'
		),
		//	Εσωτερικές Παραγγελίες
		'a61_d'	=> array(
			'module'				=> 'interorder',
			//'_initialize_function'	=> '',
			'_insert_function'		=> 'interorder_a61__invoices_online_insert'
		),

		'tran01_d'	=> array(
			'module'				=> 'tran'
		),
	);
}
/**
 * Ενεργοποίηση του custom action (button).
 * Πρέπει να γίνει κλήση αυτής της συνάρτησης στην
 * initialize του _d  θα έχει γρήγορη καταχώρηση
 *
 * @param array $data		module_initialize $data argument
 * @param string $main_d	main _d name (like i00_d, a37_d etc.)
 * @param string $module	Module name
 * @param string $grid_d	Grid's _d name (like i00_d00, a37_d00 etc.)
 * @param string $grid_name	Grid's name
 * @return void
 */
function invoices__invoices_online_enable_custom_actions(
	&$data,
	$main_d = '',
	$module = '',
	$grid_d = '',
	$grid_name = ''
) {
	$data[$module . '_' . $grid_d . '_' . $grid_name . '_invoices__invoices_online_' . $main_d . '_hidden'] = false;
}
/**
 * Προσθέτει το custom action της γρήγορης καταχώρησης.
 * Πρέπει να κληθεί στο εκάστοτε custom action function του grid ή στο ανάλογο field toy grid
 *
 * @param array $data		To array με τα υπόλοιπα custom actions (set as array() για κλήση από field)
 * @param string $main_d	Main _d name (like i00_d, a37_d etc.)
 * @return boolean
 */
function invoices__invoices_online_custom_action_peg002(
	$data = array(),
	$main_d = ''
) {
	$is_parent = invoices__invoices_online_is_parent($main_d);
	if ($is_parent['ok'] != 1) {
		return $data;
	}
	$peg_handler = "invoices__invoices_online_show(screen)";
	$data[] = array(
		'xtype' => 'pegasusToolBarGridAction',
		'peg_custom_id' => 'invoices__invoices_online_' . $main_d,
		'viewModel' => array(
			'type' => 'GridButtonModel',
			'isToolBar' => 1,
			'data' => array(
				'toolBarButton' => 'invoices__invoices_online_' . $main_d,

			)
		),
		'icon' => 'invoices_images/online_16x16.png',
		'text' =>  $_SESSION['peg_dic_invoices__invoices_online_button'],
		'peghandler' => $peg_handler
	);
	return $data;
}
/**
 * Έλεγχος και αναγνώριση στοιχείων αξιακών και ποσοτικών barcodes
 *
 * @source erpi00p902.peg
 * @param string $barcode
 * @return array data[
 * - boolean	is_quantity_barcode 	- Αν το Barcode αναγνωρίστηκε ως ποσοτικό
 * - boolean	is_price_barcode		- Αν το Barcode αναγνωρίστηκε ως αξιακό
 * - string		code					- Το BarCode του είδους
 * - float		value					- Το value (του βάρους ή της τιμές)
 * -
 * ]
 */
function invoices__invoices_online_value_barcode(
	$barcode = ''
) {
	try {
		$prefix_len = 2;

		$data=array(
			'code' => "", //Barcode
			'v103' => 1,  //Ποσότητα
			'v104' => 0,  //Τιμή Μονάδας
			'v107' => 0,  //Σύνολο
			'ser'  => "", //Serial Number
			'v161' => ""  //Παρτίδες
		);

		$ret_array = array(
			'ok' 	=> 1,
			'error'	=> NULL,
			'data'	=> $data,
			'msg'	=> 'Success'
		);

		$is_quantity_barcode = false;
		$is_price_barcode	 = false;

		$f01_p401 = $_SESSION['f01_p401']; //Ποσοτικά Barcode
		$f01_p411 = $_SESSION['f01_p411']; //Αξιακά Barcode
		$f01_p419 = $_SESSION['f01_p419']; //Ποσοτικά/Αξιακά Barcode

		$posotika_start	= $_SESSION['f01_p402']; //Πρώτο Ψηφίο Βάρους
		$posotika_len 	= $_SESSION['f01_p403']; //Πλήθος Ψηφίων Βάρους
		$posotika_dec	= $_SESSION['f01_p404']; //Δεκαδικά Βάρους

		$posotika_tim_mon_start = $_SESSION['f01_p405']; //Πρώτο Ψηφίο Βάρους Τιμής Μονάδας
		$posotika_tim_mon_len 	= $_SESSION['f01_p406']; //Ψηφία Βάρους Τιμής Μονάδας
		$posotika_tim_mon_dec	= $_SESSION['f01_p407']; //Δεκαδικά Βάρους Τιμής Μονάδας

		$axiaka_start = $_SESSION['f01_p412']; //Πρώτο Ψηφίο Αξίας
		$axiaka_len	  = $_SESSION['f01_p413']; //Πλήθος Ψηφίων Αξίας
		$axiaka_dec	  = $_SESSION['f01_p414']; //Δεκαδικά Αξίας

		$axiaka_tim_mon_start = $_SESSION['f01_p416']; //Πρώτο Ψηφίο Αξίας Τιμής Μονάδας
		$axiaka_tim_mon_len   = $_SESSION['f01_p417']; //Ψηφία Αξίας Τιμής Μονάδας
		$axiaka_tim_mon_dec   = $_SESSION['f01_p418']; //Δεκαδικά Αξίας Τιμής Μονάδας

		//Αν έχουν γίνει αρχικοποιήσεις για αξιακά ή ποσοτικά barcode
		if(!empty($f01_p401) || 
		   !empty($f01_p411) || 
		   !empty($f01_p419)) {
			$f01_p401 = explode('#',$f01_p401);
			$f01_p411 = explode('#',$f01_p411);
			$f01_p419 = explode(PHP_EOL, trim($f01_p419));
		
			if(count($f01_p401) > 1) {
				array_pop($f01_p401);
				array_shift($f01_p401);
			} else {
				$f01_p401 = array();
			}

			if(count($f01_p411) > 1) {
				array_pop($f01_p411);
				array_shift($f01_p411);
			} else {
				$f01_p411 = array();
			}

			if(!empty($f01_p419)) {
				foreach($f01_p419 as $index=>$mask) {
					$f01_p419[$index] = explode(';', $mask);
				}
			} else {
				$f01_p419 = array();
			}

			//Αν έχουμε valid εγγραφές στην αρχικοποίηση αξιακών ή ποσοτικών barcodes
			if(
				count($f01_p401) > 0 || 
				count($f01_p411) > 0 || 
				!empty($f01_p419)
			) {
				//Αν ταιριάζει σε κάποιο από τα ποσοτικά
				foreach($f01_p401 as $mask) {
					if(substr($barcode, 0, $prefix_len) == $mask) {
						$is_quantity_barcode = true;
						$data['is_quantity_barcode'] = true;
						break;
					}
				}
				
				//Αν ταιριάζει σε κάποιο από τα αξιακά δεν γίνεται να είναι και τα δύο…
				if(!$is_quantity_barcode) {
					foreach($f01_p411 as $mask) {
						if(substr($barcode, 0, $prefix_len) == $mask) {
							$is_price_barcode = true;
							break;
						}
					}
				}
				
				if(!$is_price_barcode) {
					foreach($f01_p419 as $mask) {
						if(substr($barcode,0,$prefix_len) == $mask[0]) {
							//Εύρεση Είδους Ποσοτικού/Αξιακού Barcode
							if(($mask[1] == 0 || $mask[1] == 1)) {
								$kind = $mask[1];

								if($kind == 0) {
									$data['is_quantity_barcode'] = true;
								}
							} else {
								$ret_array['data'] = $data;
								return $ret_array;
							}

							//Εύρεση Barcode
							if(!empty($mask[2])) {
								$f01_p419_code = explode(',', $mask[2]);
								$code = substr($barcode, $f01_p419_code[0] - 1, $f01_p419_code[1]);
								
								if(empty($code)) {
									$ret_array['data'] = $data;
									return $ret_array;			
								}

								$data['code'] = $code;
								$i00_pno = pegasus_mysql_printfld("i00", "pno", "p01 = :code", array("code"=>$data['code']));
							} else {
								$ret_array['data'] = $data;
								return $ret_array;
							}

							//Εύρεση Ποσότητας
							$v103 = 0;
							if(!empty($mask[3]) && $kind == 0) {
								$f01_p419_v103 = explode(',', $mask[3]);
								$v103_int = substr($barcode, $f01_p419_v103[0] - 1, $f01_p419_v103[1]);

								if(!empty($v103_int)) {
									$v103_dec = $f01_p419_v103[2];
									$v103 = $v103_int / pow(10, $v103_dec);
								}
							}

							//Εύρεση Συνόλου
							$v107 = 0;
							if(!empty($mask[3]) && $kind == 1) {
								$f01_p419_v107 = explode(',', $mask[3]);
								$v107_int = substr($barcode, $f01_p419_v107[0] - 1, $f01_p419_v107[1]);
								if(!empty($v107_int)) {
									$v107_dec = $f01_p419_v107[2];
									$v107 = $v107_int / pow(10, $v107_dec);
								}
							}

							//Εύρεση Τιμής Μονάδας
							$v104 = 0;
							if(!empty($mask[4])) {
								$f01_p419_v104 = explode(',', $mask[4]);
								$v104_int = substr($barcode, $f01_p419_v104[0] - 1, $f01_p419_v104[1]);

								if(!empty($v104_int)) {
									$v104_dec = $f01_p419_v104[2];
									$v104 = $v104_int / pow(10, $v104_dec);
								}
							}	

							if($v107 > 0 && $v104 > 0) {
								$data['v103'] = $v107 / $v104;
								$data['v104'] = $v104;
								$data['v107'] = $v107;
							}	

							if($v107 > 0 && empty($v104)) {
								$data['v103'] =  1;
								$data['v104'] = $v107;
								$data['v107'] = $v107;
							}

							if($v103 > 0 && $v104 > 0) {
								$data['v103'] = $v103;
								$data['v104'] = $v104;
								$data['v107'] = $v103 * $v104;
							}
							
							if($v103 > 0 && empty($v104)) {
								$data['v103'] = $v103;
								$data['v104'] = 0;
								$data['v107'] = 0;
							}

							if($v104 > 0 && empty($v103) && empty($v107)) {
								$data['v103'] = 1;
								$data['v104'] = $v104;
								$data['v107'] = $v104;
							}

							if(empty($v103) && empty($v104) && empty($v107)) {
								$data['v103'] = 1;
								$data['v104'] = 0;
								$data['v107'] = 0;
							}

							//Εύρεση Serial
							if(!empty($mask[5])) {
								$f01_p419_serial = explode(',', $mask[5]);
								$serial = substr($barcode, $f01_p419_serial[0] - 1, $f01_p419_serial[1]);

								if(!empty($serial)) {
									$cnt = pegasus_mysql_printfld("i31", "count(*)", "p01 = :i00_pno and p02 = :serial", array("i00_pno"=>$i00_pno, "serial"=>$serial));

									if($cnt > 0) {
										$data['ser'] = $serial;
										$data['v103'] = 1; 
									}
								} else {
									$ret_array['data'] = $data;
									return $ret_array;
								}
							} else {
								$ret_array['data'] = $data;
								return $ret_array;
							}

							//Εύρεση lot
							if(!empty($mask[6])) {
								$f01_p419_lot = explode(',', $mask[6]);
								$lot = substr($barcode, $f01_p419_lot[0] - 1, $f01_p419_lot[1]);

								if(!empty($lot)) {
									$cnt = pegasus_mysql_printfld("i11", "count(*)", "p01 = :i00_pno and p02 = :lot", array("i00_pno"=>$i00_pno, "lot"=>$lot));
									
									if($cnt > 0) {
										$data['v161'] = $lot;
									}
								}								 
							}

							$ret_array['data'] = $data;
							return $ret_array;
						}
					}
				}
			}

			//Αν έχουμε Ποσοτικά barcode
			if($is_quantity_barcode) {
				if((strlen($barcode) >= ($posotika_start-1) + $posotika_len)) {
					$data['code'] = substr($barcode, 0, $posotika_start-1);
					$data['v103'] = substr($barcode, $posotika_start-1, $posotika_len) / pow(10, $posotika_dec);

					if($posotika_tim_mon_start > 0 && $posotika_tim_mon_len > 0) {
						$v104 = substr($barcode, ($posotika_tim_mon_start-1), $posotika_tim_mon_len) / pow(10, $posotika_tim_mon_dec);

						if(!empty($v104)) {
							$data['v104'] = $v104;
						}
					} else {
						$data['v104'] = 0;
					}

					$data['v107'] = $data['v103'] * $data['v104'];
				} 
				
				$ret_array['data'] = $data;
				return $ret_array;
			}

			//Αν έχουμε Αξιακά barcode
			if($is_price_barcode) {
				if((strlen($barcode) >= ($axiaka_start-1) + $axiaka_len)) {
					$data['code'] = substr($barcode, 0, $axiaka_start-1);

					if($axiaka_tim_mon_start > 0 && $axiaka_tim_mon_len > 0) {
						$data['v107'] = substr($barcode, $axiaka_start-1, $axiaka_len) / pow(10, $axiaka_dec);
						$data['v104'] = substr($barcode, ($axiaka_tim_mon_start-1), $axiaka_tim_mon_len) / pow(10, $axiaka_tim_mon_dec);
						$data['v103'] = $data['v107'] / $data['v104'];
					} else {
						$data['v103'] = 1;
						$data['v104'] = substr($barcode, ($axiaka_start-1), $axiaka_len) / pow(10, $axiaka_dec);
						$data['v107']  = $data['v103'] * $data['v104'];
					}	
				}

				$ret_array['data'] = $data;
				return $ret_array;
			}
		}
	} catch(Exception $e) {
		$msg = $_SESSION['peg_dic_invoices__invoices_online_value_barcode_error'];
		if($e->getCode()==1) {
			$msg = $e->getMessage();
		}
		return array(
			'ok' 	=> 0,
			'error'	=> $e->getMessage(),
			'data'	=> NULL,
			'msg'	=> $msg
		);
	}
}
/**
 * Βρίσκει και επιστρέφει πληροφορίες για ένα είδος με βάση τον κωδικό αναζήτησης
 *
 * @param string $code			Κωδικός Αναζήτησης
 * @param integer $a00_nr01		Κωδικός Προμηθευτή (δες invoices_make_product_search_query)
 * @return array $data[
 * - v101	Κωδικός Είδους
 * - v102	Όνομα Είδους
 * - v103	Ποσότητα
 * - v161	Κωδικός Παρτίδας
 * - v172	Κωδικός Χρώματος
 * - v173	Κωδικός Μεγέθους
 * - ser	Κωδικός Serial Number
 * ]
 */
function invoices__invoices_online_find(
	$code = '',
	$a00_nr01 = 0,
	$mmnr01 = "",
	$a37_from_order = 0
) {
	try {
		$ret_array = array();

		$ret_array['ok']    = 1;
		$ret_array['error'] = NULL;

		$v101b = $code;		// C:25 String Ανάγνωσης του Scanner

		$search_fields = array();
		$mmnr01_arr = explode('-', $mmnr01);
		$mode  = $mmnr01_arr[0];
		$mnr01 = $mmnr01_arr[1];

		$mmnr01_arr = explode('-', $mmnr01);
        if($mmnr01_arr[0]=='tran01_d'){
            $data['v103_hidden'] = 2;
        }

		if($mode == 'a55_d'){
			$service_only = 0;
			if(pegasusGetGlobalVar('peg_'.$mmnr01.'_service_only') == 1){
				$service_only = 1;
			}
		}

		$p05 = pegasusGetGlobalVar('peg_'.$mmnr01.'_p05');
		if($mode == 'a55_d'){
			$p32 = pegasus_mysql_printfld('a10', 'p32', 'p01=:var_p05', array("var_p05"=>$p05));
		}elseif($mode == 'a56_d'){
			$p32 = pegasus_mysql_printfld('a11', 'p32', 'p01=:var_p05', array("var_p05"=>$p05));
		}

		$i10_nr01_arr = array_filter(explode('#', $p32)); 
		/**
		 * v101	-> i00.pno
		 * v102	-> i00.name
		 * v103	-> i08.pe020
		 * v161	-> i11.p02
		 * v172	-> i47.p02 || i08.pc01
		 * v173	-> i47.p03 || i08.pm01
		 */
		$query_arr = invoices_make_product_search_query(
			$code,
			$a00_nr01,
			'',
			1,
			$search_fields,
			$service_only,
			$i10_nr01_arr
		);

		$query = "select * from (" . $query_arr['sql'] . ") as tt group by tt.v101 order by if(type=2, 0, if(is_exact_the_same = 1, 1, 99)), type, is_exact_the_same desc  limit 1";
		pegasus_mysql_use($query, $item, $query_arr['values']);

		$item['v101'] = trim($item['v101']);

		//Αν δεν βρήκε Είδος
		if(empty($item)	|| empty($item['v101'])	|| $item['v101'] == '') {
			$msg = "<b>".$_SESSION['peg_dic_invoices_searched_code'].":</b> ".$code;
			$msg .= "</br>";
			$msg .= $_SESSION['peg_dic_invoices__invoices_online_insert_none'];

			throw new Exception($msg);
		}

		//Log Text
		$msg = "<b>".$_SESSION['peg_dic_invoices_searched_code'].":</b> ".$item['code'];
		$msg .= "</br>";

		if($mode == "a37_d") {
			if($a37_from_order == 1) {
				$res_a38 = array();

				$query_a38 = "SELECT count(*) AS cnt, 
									 peg_tmp_a38.p041,
									 peg_tmp_a38.p04
							  FROM peg_tmp_a38
							  WHERE peg_tmp_a38.p01        = :v101   AND 
								    peg_tmp_a38.p00        = :p00    AND 
								    peg_tmp_a38.peg_mmnr01 = :mmnr01 AND 
								    peg_tmp_a38.peg_mnr01  = :mnr01  AND 
								    peg_tmp_a38.peg_flag  != 9 	     AND 
								    peg_tmp_a38.peg_sess_id = :sess_id ";

				$query_params_a38 = array();
				$colorsize_params = array();
				$lot_params		  = array();
				$serial_params    = array();

				if(pegasus_module_exists("colorsize") && !empty($item['v172']) && !empty($item['v173'])) {
					$query_a38 .= "AND peg_tmp_a38.p02 = :v172 AND peg_tmp_a38.p03 = :v173 ";

					$colorsize_params = array(
						"v172" => $item['v172'],
						"v173" => $item['v173']
					);
				}

				if(pegasus_module_exists("lot") && !empty($item['v161'])) {
					$query_a38 .= "AND peg_tmp_a38.p06 = :v161 ";

					$lot_params = array(
						"v161" => $item['v161']
					);
				}

				if(pegasus_module_exists("serial") && !empty($item['ser'])) {
					$query_a38 .= "AND peg_tmp_a38.p05 = :ser ";

					$serial_params = array(
						"ser" => $item['ser']
					);
				}

				$query_params_a38 = array(
					"v101"    => $item['v101'],
					"p00"     => $mnr01,
					"mmnr01"  => $mmnr01,
					"mnr01"   => $mnr01,
					"sess_id" => session_id()
				);

				$query_params_a38 = array_merge($query_params_a38, $colorsize_params, $lot_params, $serial_params);

				pegasus_mysql_use($query_a38, $res_a38, $query_params_a38);

				//Αν το πακέτο ανήκει σε παραγγελία και το είδος δεν υπάρχει στην συγκεκριμένη παραγγελία
				if($res_a38['cnt'] == 0) {
					$msg .= $_SESSION['peg_dic_packages_item_not_exist'];

					throw new Exception($msg);
				}
			}
		}


		$has_colorsize = pegasus_mysql_printfld("i47", "count(nr01)", "p01 = :v101", array("v101"=>$item['v101']));

		$item['has_colorsize'] = 0;
		//Αν το είδος έχει χρώμα-μέγεθος και δεν έχει γίνει αναζήτηση με ειδικό κωδικό η ποσότητα μηδενίζεται και το πεδίο της ποσότητα γίνεται readonly
		if($has_colorsize > 0 && empty($item['v172']) && empty($item['v173']) && $a37_from_order != 1) {
			$item['v103'] = 0;
			$item['has_colorsize'] = 1;
		}
		
		if($item['type'] == 2) {
			$msg .= str_replace(
				array(
					'#type#',
					'#v102#'
				),
				array(
					$item['vtype'],
					$item['v102']
				),
				$_SESSION['peg_dic_invoices_found_type_of_v101']
			);
		} else {
			$msg .= str_replace('#v102#', $item['v102'], $_SESSION['peg_dic_invoices__invoices_online_insert_v101']);
		}
		
		$msg .= "</br>";

		//Ποσότητα
		if($mode!='tran01_d' && $item['v103'] > 0){
			$v103 = round($item['v103'], $_SESSION['inventory_000_p08']);
			$msg .= '[<b>' . $_SESSION['peg_dic_invoices_quantity'] .':</b> '. $v103 .'] ';
		}

		//Normalize την τιμή της ποσότητας σε ελάχιστον 1
		if(!($item['v103'] > 0)) {
			$item['v103'] = 1;
		}

		if($a37_from_order==0 && $mode!='tran01_d' && $item['v104'] > 0) {	
			//Τιμή Μονάδας
			$v104 = round($item['v104'], $_SESSION['inventory_000_p07']);
			$msg .= '[<b>' . $_SESSION['peg_dic_invoices_unit_price'] .':</b> '. $v104 .'] ';
		}

		//Αν έχει Χρώμα
		$item['v172']=trim($item['v172']);
		if (!empty($item['v172'])) {
			$res_i40 = array();

			$query_i40 = "SELECT p02, ep02 FROM i40 WHERE p01 = :v172";

			pegasus_mysql_use($query_i40, $res_i40, array("v172"=>$item['v172']));

			if($_SESSION['lang'] == "GR") {
				$i40_p02 = $res_i40['p02'];
			} else {
				$i40_p02 = $res_i40['ep02'];
			}

			$msg .= '[' . str_replace('#v172#', $i40_p02, $_SESSION['peg_dic_invoices__invoices_online_insert_v172']) . '] ';
		}

		//Αν έχει Μέγεθος
		$item['v173']=trim($item['v173']);
		if (!empty($item['v173'])) {
			$res_i43 = array();

			$query_i43 = "SELECT p02, ep02 FROM i43 WHERE p01 = :v173";

			pegasus_mysql_use($query_i43, $res_i43, array("v173"=>$item['v173']));

			if($_SESSION['lang'] == "GR") {
				$i43_p02 = $res_i43['p02'];
			} else {
				$i43_p02 = $res_i43['ep02'];
			}

			$msg .= '[' . str_replace('#v173#', $i43_p02, $_SESSION['peg_dic_invoices__invoices_online_insert_v173']) . '] ';
		}

		//Αν έχει Παρτίδα
		$item['v161']=trim($item['v161']);
		if (!empty($item['v161'])) {
			$msg .= '[' . str_replace('#v161#', $item['v161'], $_SESSION['peg_dic_invoices__invoices_online_insert_v161']) . '] ';
		}

		//Αν έχει Serial
		$item['ser']=trim($item['ser']);
		if(!empty($item['ser'])) {
			$msg .= '[' . str_replace('#ser#', $item['ser'], $_SESSION['peg_dic_invoices__invoices_online_insert_ser']) . '] ';
		}
		$msg .= "</br></br>";
		$item['v101b'] = $v101b;

		$ret_array['data'] = $item;
		$ret_array['msg']  = $msg;

		return $ret_array;
	} catch (Exception $e) {
		$msg = $e->getMessage()."</br></br>";

		$ret_array['error'] = $e->getMessage();
		$ret_array['data']  = NULL;
		$ret_array['msg']   = $msg;

		return $ret_array;
	}
}
/**
 * Καλεί το αντίστοιχο function καταχώρησης
 * Προσοχή! Το function καταχώρησης θα πρέπει να επιστρέφει (και) την οθόνη αναφοράς
 *
 * @param string $mmnr01
 * @param integer $mnr01
 * @param string $code
 * @param string $p9000
 * @param string $ser
 * @param integer $timh1
 * @param integer $timh2
 * @param integer $timh3
 * @param integer $timh4
 * @param integer $type
 * @param string $v101
 * @param string $v102
 * @param integer $v103
 * @param string $v161
 * @param string $v172
 * @param string $v173
 * @param integer $v_baltot
 * @param integer $v_cusord
 * @param integer $v_locbaltot
 * @param integer $v_loccusord
 * @param integer $v_locsuppord
 * @param integer $v_suppord
 * @param integer $vtype
 * @param string $remguc
 * @param string $date
 * @param integer $v104
 * @param string $v101b
 * @param string $i01p05
 * @param integer $a37_from_order
 * @param string $i18_product_nr01
 * @param string $i19_p03
 * @param string $not_zero_prices: Εάν είναι 0 τότε μηδενίζεται η [Τιμή Μονάδας] και οι [% Εκπτώσεις 1/2]
 * @return array data[
 * 	- _d	οθόνη αναφοράς (like i00_d, a37_d etc)
 * ]
 */
function invoices__invoices_online_insert(
	$mmnr01			= '',
	$mnr01			= 0,
	$code			= '',
	$p9000			= '',
	$ser			= '',
	$timh1			= 0,
	$timh2			= 0,
	$timh3			= 0,
	$timh4			= 0,
	$type			= 0,
	$v101			= '',
	$v102			= '',
	$v103			= 0,
	$v161			= '',
	$v172			= '',
	$v173			= '',
	$v_baltot		= 0,
	$v_cusord	 	= 0,
	$v_locbaltot	= 0,
	$v_loccusord	= 0,
	$v_locsuppord	= 0,
	$v_suppord		= 0,
	$vtype			= 0,
	$kath_fpa		= 0,
	$remguc			= '',
	$date			= '0100-01-01',
	$v104			= 0,
	$v101b			= '',
	$i01p05			= '',
	$a37_from_order	= 0,
	$i18_product_nr01 = 0,
	$i19_p03          = 0,
	$not_zero_prices  = 1
) {
	try {
		$params = array(
			'mmnr01'		=> $mmnr01,
			'mnr01'			=> $mnr01,
			'code'			=> $code,
			'p9000'			=> $p9000,
			'ser'			=> $ser,
			'timh1'			=> $timh1,
			'timh2'			=> $timh2,
			'timh3'			=> $timh3,
			'timh4'			=> $timh4,
			'type'			=> $type,
			'v101'			=> $v101,
			'v101b'			=> $v101b,
			'v102'			=> $v102,
			'v103'			=> $v103,
			'v104'			=> $v104,
			'v161'			=> $v161,
			'v172'			=> $v172,
			'v173'			=> $v173,
			'v_baltot'		=> $v_baltot,
			'v_cusord'	 	=> $v_cusord,
			'v_locbaltot'	=> $v_locbaltot,
			'v_loccusord'	=> $v_loccusord,
			'v_locsuppord'	=> $v_locsuppord,
			'v_suppord'		=> $v_suppord,
			'vtype'			=> $vtype,
			'kath_fpa'		=> $kath_fpa,
			'remguc'		=> $remguc,
			'date'			=> $date,
			'i01p05'		=> $i01p05,
			'a37_from_order'=> $a37_from_order,
			'i18_product_nr01' => $i18_product_nr01,
			'i19_p03'          => $i19_p03,
			'not_zero_prices'  => $not_zero_prices
		);
		// $parent_d = explode('-', $params['mmnr01'])[0];
		// $get_parent = invoices__invoices_online_get_parent($parent_d);
		// if ($get_parent['ok'] != 1) {
		// 	throw new Exception($get_parent['error']);
		// }
		// $parent = $get_parent['data'];
		// if (!function_exists($parent['_insert_function'])) {
		// 	throw new Exception('_insert_function ' . $parent['_insert_function'] . ' function not available');
		// }

		$mode = explode("_d-", $mmnr01);
		$mode = $mode[0];

		return invoices_global_lineItem_insert($params, $mode);
		//εδω θα φτασει να εκτελσεη την συναρτηση invcust_a55__invoices_online_insert για το παραστατικο με τα παραπανω params
		// return $parent['_insert_function']($params);
	} catch (Exception $e) {
		return array(
			'ok'	=> 0,
			'error'	=> $e->getMessage(),
			'data'	=> NULL,
			'msg'	=> "Error: " . $e->getMessage()
		);
	}
}

/**
 * Ενοποιημένη συνάρτηση καταχώρισης είδους σε παραστατικά και παραγγελίες  

 * @param array $args
 * @param string $mode	a55 | a56 | a57 | a67 | a60 | a61 | tran01
 * @return array
 */
function invoices_global_lineItem_insert(
	$args = array(),
	$mode = ''
) {
	try {
		$mmnr01			= $args['mmnr01'];
		$mnr01			= $args['mnr01'];
		$code			= $args['code'];
		$p9000			= $args['p9000'];
		$ser			= $args['ser'];
		$timh1			= $args['timh1'];
		$timh2			= $args['timh2'];
		$timh3			= $args['timh3'];
		$timh4			= $args['timh4'];
		$type			= $args['type'];
		$v101			= $args['v101'];
		$v101b			= $args['v101b'];
		$v102			= $args['v102'];
		$v103			= $args['v103'];
		$v104			= $args['v104'];
		$v161			= $args['v161'];
		$v172			= $args['v172'];
		$v173			= $args['v173'];
		$v_baltot		= $args['v_baltot'];
		$v_cusord	 	= $args['v_cusord'];
		$v_locbaltot	= $args['v_locbaltot'];
		$v_loccusord	= $args['v_loccusord'];
		$v_locsuppord	= $args['v_locsuppord'];
		$v_suppord		= $args['v_suppord'];
		$vtype			= $args['vtype'];
		$kath_fpa		= $args['kath_fpa'];
		$remguc			= $args['remguc'];
		$date			= $args['date'];
		$a37_from_order	= $args['a37_from_order'];
		$i01p05         = $args['i01p05'];
		$i18_product_nr01 = $args['i18_product_nr01'];
		$i19_p03          = $args['i19_p03'];
		$not_zero_prices  = $args['not_zero_prices'];

		$ret_array = array();

		$ret_array['ok']    = 1;
		$ret_array['error'] = NULL;

		$data = array(
			'_d'	=> $mode."_d"	//	Οθόνη αναφοράς
		);
		// Αρχικοποίηση Ημερομηνίας 
		$p013 = date('Y-m-d');
		$p013t = date('H:i:s');
		if($date > '0100-01-01') {
			$p013 	= $date;
			$p013t  = '';
		}

		// Διαμόρφωση του input ($request[$mode]) της peg_invoice_find_product_data για κάθε mode
		$request=array(
			'a55'	=> array(),
			'a56'	=> array(),
			'a57'	=> array(),
			'a67'	=> array(),
			'a60'	=> array(),
			'a61'	=> array(),
			'a37'	=> array(),
			'tran01'=> array()
		);

		//	Αρχικοποίηση μεταβλητών και ονομάτων πινάκων αναφοράς ανάλογα με το mode
		$line_item_nr01 = 0;	//	nr01 της καταχώρισης που θα δημιουργήσουμε
		$line_item_table = 		//	Πίνακας αναφοράς για την καταχώρηση είδους παραγγελίας 
		$i01_p07 = 0;			//	Mode Καταχώρησης του i01 (Καταστατικό Πελάτη / Προμηθευτή / Εσωτερικής)
		$i3x_p010 = 0;			//	Mode Καταχώρισης Serial και Lot (Παραστατικά / Παραγγελίες Πελάτη / Προμηθευτή / Εσωτερικής )
		switch($mode) {
			case 'a55' :
				$line_item_nr01 = pegasus_mysql_newrec('i01');
				$i01_p07 = 2;
				$i3x_p010 = 1;
				break;
			case 'a56' :
				$line_item_nr01 = pegasus_mysql_newrec('i01');
				$i01_p07 = 1;
				$i3x_p010 = 1;
				break;
			case 'a60' :
				$line_item_nr01 = pegasus_mysql_newrec('i01');
				$i01_p07 = 3;
				$i3x_p010 = 1;
				break;
			case 'a57' :
				$line_item_nr01 = pegasus_mysql_newrec('a58');
				$line_item_table ='a58';
				$i3x_p010 = 2;
				break;
			case 'a67' :
				$line_item_nr01 = pegasus_mysql_newrec('a68');
				$line_item_table ='a68';
				$i3x_p010 = 3;
				break;
			case 'a61' :
				$line_item_nr01 = pegasus_mysql_newrec('a62');
				$line_item_table ='a62';
				$i3x_p010 = 4;
				break;
			case 'a37' :
				$line_item_nr01 = pegasus_mysql_newrec('a38');
				break;
			case 'tran01' :
				$line_item_nr01  = pegasus_mysql_newrec('tran02');
				$line_item_table ='tran02';
				break;
			default : 
				throw new Exception('invoices_document_lineitem_insert Unknown mode');
		}

		$request[$mode] = array (
			'p9000'			=> $p9000,
			'type'			=> $type,
			'code'			=> $code,
			'v101'			=> $v101,
			'v101b'			=> $v101b,
			'v102'			=> $v102,
			'v103'			=> $v103,
			'v_baltot'		=> $v_baltot,
			'v_cusord'		=> $v_cusord,
			'v_locbaltot'	=> $v_locbaltot,
			'v_loccusord'	=> $v_loccusord,
			'v_locsuppord'	=> $v_locsuppord,
			'v_suppord'		=> $v_suppord,
			'vtype'			=> $vtype,
			$mode.'_nr01'	=> $mnr01,
			$mode.'_p03'	=> pegasusGetGlobalVar('peg_'.$mode.'_d-' . $mnr01 . '_p03'),
			$mode.'_p05'	=> pegasusGetGlobalVar('peg_'.$mode.'_d-' . $mnr01. '_p05'),
			$mode.'_p07'	=> pegasusGetGlobalVar('peg_'.$mode.'_d-' . $mnr01 . '_p07'),
			$mode.'_p805'   => pegasusGetGlobalVar('peg_'.$mode.'_d-' . $mnr01 . '_p805'),
			'i18'.$line_item_table => $i18_product_nr01,
			'date'			=> date('Ymd'),
			'kath_fpa'		=> $kath_fpa,
			'p05'           => $i01p05
		);

		$data['product_nr01'] = $line_item_nr01;
		$data['request']      = $request[$mode];

		if($mode == 'a37') {
			//Αν το πακέτο ανήκει σε παραγγελία δεν επιτρέπετε να γίνει καταχώρηση
			if($a37_from_order == 1) {
				$query_a38 = "(peg_tmp_a38.p041 - peg_tmp_a38.p04) >= :v103 AND 
							  peg_tmp_a38.p01 = :v101            AND 
							  peg_tmp_a38.p00 = :p00             AND 
							  peg_tmp_a38.peg_mmnr01 = :mmnr01   AND 
							  peg_tmp_a38.peg_mnr01 = :mnr01     AND 
							  peg_flag != 9                      AND 
							  peg_tmp_a38.peg_sess_id = :sess_id ";

				$query_params_a38 = array();
				$colorsize_params = array();
				$lot_params		  = array();
				$serial_params    = array();

				if(pegasus_module_exists("colorsize") && !empty($v172) && !empty($v173)) {
					$query_a38 .= "AND peg_tmp_a38.p02 = :v172 AND peg_tmp_a38.p03 = :v173 ";

					$colorsize_params = array(
						"v172" => $v172,
						"v173" => $v173
					);
				}

				if(pegasus_module_exists("lot") && !empty($v161)) {
					$query_a38 .= "AND peg_tmp_a38.p06 = :v161 ";

					$lot_params = array(
						"v161" => $v161
					);
				}

				if(pegasus_module_exists("serial") && !empty($ser)) {
					$query_a38 .= "AND peg_tmp_a38.p05 = :ser ";

					$serial_params = array(
						"ser" => $ser
					);
				}

				$query_params_a38 = array(
					"v103"    => $v103,
					"v101"    => $v101,
					"p00"     => $mnr01,
					"mmnr01"  => $mmnr01,
					"mnr01"   => $mnr01,
					"sess_id" => session_id()
				);
				
				$query_params_a38 = array_merge($query_params_a38, $colorsize_params, $lot_params, $serial_params);
				
				pegasus_mysql_use("SELECT count(*) AS cnt, peg_tmp_a38.p041, peg_tmp_a38.p04 FROM peg_tmp_a38 WHERE ".$query_a38." LIMIT 1", $res_a38, $query_params_a38);							

				$ret_array['data'] = $data;

				if($res_a38['cnt'] == 0) {
					$ret_array['msg'] = $_SESSION['peg_dic_packages_exceed_order_quantity']."</br>";

					return $ret_array;
				} else {
					pegasus_mysql_update("peg_tmp_a38", array("peg_flag", "p04"), array(2, "p04+".$v103), $query_a38." LIMIT 1", 0, 0, 1, $query_params_a38);	
					
					$ret_array['msg'] = $_SESSION['peg_dic_invoices__invoices_online_insert_updated']."</br>";

					return $ret_array;
				}
			} else {
				$a38 = array(
					'nr01'			=> $line_item_nr01,	
					'p00'			=> $mnr01,						// Πακέτο
					'p01'			=> $v101,						// Είδος
					'p04'			=> $v103,						// Ποσότητα
					'p02'			=> $v172,						// Χρώμα
					'p03'			=> $v173,						// Μέγεθος
					'p05'			=> $ser,						// S.N.
					'p06'			=> $v161,						// Παρτίδα
					'p020'			=> $code,						// Barcode
					'peg_mnr01'		=> $mnr01,									
					'peg_mmnr01'	=> $mmnr01,						
					'peg_sess_id'	=> session_id(),				
					'peg_flag'		=> 1							
				);

				if (!pegasus_mysql_insert('peg_tmp_a38', array_keys($a38), array_values($a38), 0, 0, 0, 0)) {
					throw new Exception(pegasus_mysql_error());
				}

				$ret_array['data'] = $data;
				$ret_array['msg'] = $_SESSION['peg_dic_invoices__invoices_online_insert_success']."</br>";

				return $ret_array;			
			}
		}

		//	Καταχωρίσεις Ειδών Φορτωτικής
		if($mode=='tran01') {
			
			$tran01_arr = array();
			$global_var_fields  = array('sp03', 'p01', 'yp01', 'p02', 'yp02', 'p010', 'p61', 'p121', 'p701');
			foreach ($global_var_fields as $fld) {
				$tran01_arr[$fld] = pegasusGetGlobalVar('tran01_d-'.$mnr01.'_'.$fld);
			}		

			$where = " p00=:p00 AND peg_mnr01=:peg_mnr01 AND peg_mmnr01=:peg_mmnr01 AND peg_sess_id=:peg_sess_id AND peg_flag!=:peg_flag ";
			$values = array(
				'p00'			=> $mnr01,
				'peg_mnr01'		=> $mnr01,
				'peg_mmnr01'	=> $mmnr01,
				'peg_sess_id'	=> session_id(),
				'peg_flag'		=> 9
			);
			$tran02_p00_1 = pegasus_mysql_printfld("peg_tmp_tran02", "MAX(p00_1)+1", $where, $values);

			$query_tmp = "	SELECT ifnull(tran15.p00, '') as tran15_p00
								FROM i00
								LEFT JOIN tran15 ON tran15.p04=i00.ths
								WHERE i00.pno=:pno";
			pegasus_mysql_use($query_tmp, $tmp_arr, array("pno"=>$data['request']['v101']));

			//το πεδίο "Ποσοτητα" θα έχει τιμή "1" και ενημερώνει μονο τα πεδία "Πλήθος" & "Ποσότητα"
			$v103 = ($v103==1) ? $v103 : 1;

			$tran02_p02 = $v103;
			$tran02_p06 = $v103;
			$tran02_p05 = 0;
			$tran02_p09 = 0;
			
			$tran02_price_arr = peg_tran_find_price(
				$tran01_arr['sp03'],
				$tran01_arr['p01'],				
				$tran01_arr['yp01'],				
				$tran01_arr['p02'],				
				$tran01_arr['yp02'],
				$tran01_arr['p010'],
				$tran01_arr['p61'],
				$tran01_arr['p121'],
				$tran01_arr['p701'],
				$tran02_p02,
				$tmp_arr["tran15_p00"],
				$tran02_p05,
				$tran02_p06,
				$tran02_p09,
				false
			);

			$line_item_insert = array(
				'nr01'			=> $line_item_nr01,
				'p00'			=> $mnr01,
				'p00_1'			=> $tran02_p00_1,
				'p010'			=> $data['request']['v101'],
				'p04'			=> $data['request']['v102'],
				'p02'			=> $tran02_p02,
				'p05'			=> $tran02_p05,
				'p06'			=> $tran02_p06,
				'p09'			=> $tran02_p09,
				'p03'			=> $tran02_price_arr['data']['p03'],
				'p07'			=> $tran02_price_arr['data']['p07'],
				'p08'			=> $tran02_price_arr['data']['p08'],
				'p201'			=> $tran02_price_arr['data']['p201'],
				'p101'			=> $tran02_price_arr['data']['p101'],
				'p102'			=> $tran02_price_arr['data']['p102'],
				'p103'			=> $tran02_price_arr['data']['p103'],
				'p104'			=> $tran02_price_arr['data']['p104'],
				'peg_mmnr01'	=> $mmnr01,
				'peg_mnr01' 	=> $mnr01,
				'peg_flag'		=>	1,
				'peg_sess_id'	=> session_id(),
				'remguc'		=> $remguc
			);
			

			if(!pegasus_mysql_insert("peg_tmp_$line_item_table", array_keys($line_item_insert), array_values($line_item_insert),0,0,0,0)) {
				throw new Exception(pegasus_mysql_error());
			}
			
			$ret_array['data'] = $data;
			$ret_array['msg']  = $_SESSION['peg_dic_invoices__invoices_online_insert_success']."</br>";

			return $ret_array;	
		}

		//	Exception τιμής gια την εξυπηρέτηση των αξιακών barcode
		$product_data = peg_invoice_find_product_data($request[$mode]); //ti nohma exei ayto

		if($v104 > 0) {
			$product_data['v104'] = $v104;
		}

		if($not_zero_prices == 0) {
			$product_data['v104']  = 0;
			$product_data['v106']  = 0;
			$product_data['v106a'] = 0;
		}

		/*
			Αν το είδος δεν έχει χρώμα-μέγεθος, serial number, παρτίδα και δεν είναι δευτερεύουσα ποσότητα
			και η βασική μονάδα μέτρησής του είναι είτε τεμάχια, είτε μήκος, πλάτος, ύψος, μικτό βάρος τότε
			θα πρέπει να ενημερώνεται και κάποιο από αυτά τα πεδία με την ποσότητα που παίρνει το είδος.

			Αν δεν συνέβαινε αυτό με ένα grid edit είδους, η τιμή της ποσότητας θα μηδενιζότανε γτ θα κοίταζε
			τι έχει η βασική μονάδα μέτρησης σαν τιμή.

			Με την Γρήγορη Καταχώρηση είχαμε συναντήσει το παραπάνω φαινόμενο.
		*/
		if(
			$product_data['color_size_en'] == 0 && 
			$product_data['p03_serial']    == 0 && 
			$product_data['p03_lot']       == 0 &&
			$product_data['v_p200_en']     == 0
		) {
			if($product_data['i24_p101'] == 1) { // Τεμάχια
				$product_data['v301'] = $v103;

				if($product_data['v1030_1'] > 0) {
					$product_data['v301'] = 1;
				}				
			} else if($product_data['i24_p102'] == 1) { // Μήκος
				$product_data['v302'] = $v103;
			
				if($product_data['v1030_1'] > 0) {
					$product_data['v302'] = 1;
				}
			} else if($product_data['i24_p103'] == 1) { // Πλάτος
				$product_data['v303'] = $v103;
				
				if($product_data['v1030_1'] > 0) {
					$product_data['v303'] = 1;
				}
			} else if($product_data['i24_p104'] == 1) { // Υψος
				$product_data['v304'] = $v103;
				
				if($product_data['v1030_1'] > 0) {
					$product_data['v304'] = 1;
				}
			} else if($product_data['i24_p106'] == 1) { // Μικτό Βάρος
				$product_data['v306'] = $v103;
				
				if($product_data['v1030_1'] > 0) {
					$product_data['v306'] = 1;
				}
			}
		}

		//	Καταχωρήσεις παραστατικών (peg_tmp_i01)
		if(in_array($mode,array('a55','a56','a60'))) {
			$line_item_insert=array(
				'p01'			=> $product_data['v101'],
				'p01b'			=> $v101b,
				'p02'			=> $product_data['v102'],
				'p03'			=> $v103,
				'p030_1'		=> $product_data['v1030_1'],
				'p04'			=> $product_data['v104'],
				'p04_1'			=> $product_data['v104_1'],
				'p0601'			=> $product_data['v160'],
				'p030'			=> $product_data['v120'],
				'p301'			=> $product_data['v301'],
				'p302'			=> $product_data['v302'],
				'p303'			=> $product_data['v303'],
				'p304'			=> $product_data['v304'],
				'p306'			=> $product_data['v306'],
				'p307'			=> $product_data['v307'],
				'p08'			=> $product_data['fpa'],
				'p081'			=> $product_data['kfpa'],
				'p010'			=> $product_data['v106'],
				'p010a'			=> $product_data['v106a'],
				'p041'			=> $product_data['v1041'],
				'p616'			=> $product_data['v616'],
				'p616p'			=> $product_data['p616p'],
				'p309'			=> $product_data['v309'],
				'p308'			=> $product_data['v308'],
				'p614'			=> $product_data['v614'],
				'p030'			=> $product_data['v120'],
				'timh1'			=> $product_data['timh1'],
				'timh2'			=> $product_data['timh2'],
				'timh3'			=> $product_data['timh3'],
				'timh4'			=> $product_data['timh4'],
				'p06'			=> $mnr01,
				'p07'			=> $i01_p07,
				'p09'			=> $product_data['i01_p09'],
				'nr01'			=> $line_item_nr01,
				'peg_mmnr01'	=> $mmnr01,
				'peg_mnr01' 	=> $mnr01,
				'peg_flag'		=>	1,
				'peg_sess_id'	=> session_id(),
				'p013'			=> $p013,
				'p013t'			=> $p013t, //TODO (Ώρα) Ίσως εδώ πρεπει να βάζω την τρέχουσα.
				'p05'			=> $i01p05,
				'remguc'		=> $remguc,
				'i18i01'        => $i18_product_nr01,
				'i19p03'		=> $i19_p03
			);
			if(!pegasus_mysql_insert('peg_tmp_i01', array_keys($line_item_insert), array_values($line_item_insert),0,0,0,0)) {
				throw new Exception(pegasus_mysql_error());
			}
		}
		//	Καταχωρίσεις παραγγελιών Πελάτη / Προμηθευτή / Εσωτερικής
		if(in_array($mode,array('a57','a67','a61'))) {
			$v107 = invoices_make_product_total(
				$v103, 
				$product_data['v104'],  
				$product_data['fpa'], 
				$product_data['v106'], 
				$product_data['v106a'], 
				$product_data['v1041'],
				$product_data['v616'], 
				$product_data['preview_wth_vat']
			);
			$line_item_insert=array(
				'nr01'			=> $line_item_nr01,
				'p00'			=> $mnr01,
				'v101' 			=> $product_data['v101'],
				'v101b'			=> $v101b,
				'v102'			=> $product_data['v102'],
				'v103'			=> $v103,
				'v1030_1'		=> $product_data['v1030_1'],
				'v104'			=> $product_data['v104'],
				'v104_1'		=> $product_data['v104_1'],
				'v160'			=> $product_data['v160'],
				'v120'			=> $product_data['v120'],
				'v301'			=> $product_data['v301'],
				'v302'			=> $product_data['v302'],
				'v303'			=> $product_data['v303'],
				'v304'			=> $product_data['v304'],
				'v306'			=> $product_data['v306'],
				'v307'			=> $product_data['v307'],
				'v105'			=> $product_data['fpa'],
				'v108'			=> $product_data['kfpa'],
				'v106'			=> $product_data['v106'],
				'v106a'			=> $product_data['v106a'],
				'v1041'			=> $product_data['v1041'],
				'v616'			=> $product_data['v616'],
				'v120'			=> $product_data['v120'],
				'v107'			=> $v107,
				'v309'			=> $product_data['v309'],
				'v308'			=> $product_data['v308'],
				'timh1'			=> $product_data['timh1'],
				'timh2'			=> $product_data['timh2'],
				'timh3'			=> $product_data['timh3'],
				'timh4'			=> $product_data['timh4'],
				'peg_mmnr01'	=> $mmnr01,
				'peg_mnr01' 	=> $mnr01,
				'peg_flag'		=>	1,
				'peg_sess_id'	=> session_id(),
				'remguc'		=> $remguc,
				'i19p03'		=> $i19_p03
			);
			if($mode == 'a57' || $mode == 'a67') {
				$line_item_insert['p616p'] = $product_data['p616p'];
			}
			if($mode == 'a57' || $mode == 'a62') {
				$line_item_insert['v614'] = $product_data['v614'];
			}

			$line_item_insert['i18'.$line_item_table] = $i18_product_nr01;

			if(!pegasus_mysql_insert("peg_tmp_$line_item_table", array_keys($line_item_insert), array_values($line_item_insert),0,0,0,0)) {
				throw new Exception(pegasus_mysql_error());
			}
		}

		if(pegasus_module_exists("colorsize") && !empty($v172) && !empty($v173)) {
			if($mode == "a55" || $mode == "a56" || $mode == "a60") {
				if($mode == "a60") {
					$peg_tmp_a60DataAr = pegasusGetGlobalVar('peg_a60_d-' .$mnr01.'_data');

					if(!empty($peg_tmp_a60DataAr['a30p04'])) {
						$i01p05 = $peg_tmp_a60DataAr['a30p04'];
					}
				}
	
				invoices_add_colorsize($mmnr01, $mode, $line_item_nr01, $v101, $v172, $v173, $v103, $i01p05);
			} else if($mode == "a57" || $mode == "a67" || $mode == "a61") {
				invoices_add_colorsize($mmnr01, $mode, $line_item_nr01, $v101, $v172, $v173, $v103);
			}
			
		} else if(pegasus_module_exists("serial") && !empty($ser)) {
			invoices_add_serial($mmnr01, $line_item_nr01, $v101, $i3x_p010, $ser);
		} else if(pegasus_module_exists("lot") && !empty($v161)) {
			invoices_add_lot($mmnr01, $line_item_nr01, $i3x_p010, $v161, $v103, 1);	
		}

		$ret_array['data'] = $data;
		$ret_array['msg']  = $_SESSION['peg_dic_invoices__invoices_online_insert_success']."</br>";

		return $ret_array;
	}
	catch(Exception $e) {
		$ret_array['ok']    = 0;
		$ret_array['error'] = $e->getMessage();
		$ret_array['data']  = NULL;
		$ret_array['msg']   = 'Error';			// NA BALW ENDO KANENA LEKTIKO ...
		
		return $ret_array;
	}
}
/**
 * Καλεί ΑΝ ΥΠΑΡΧΕΙ το αντίστοιχο function αρχικοποίησης για την _invoices_online_d.
 * Ελέγχει και μπλοκάρει το άνοιγμα της οθόνης _invoices_online_d  αν δεν υπάρχει αντίστοιχη υλοποίηση.
 *
 * @param array $data
 * @param string $mmnr01
 * @param string $mnr01
 * @param string $_d
 * @param string $container_id
 * @return void
 */
function invoices__invoices_online_d_initialize($data = array(), $mmnr01 = '', $mnr01 = '', $_d  = '', $container_id = '') {
	try {
		$data['v_auto_add'] = pegasusGetSuperGlobalVar('invoices__invoices_online_d_'.$_SESSION['username'].'_v_auto_add');
		$data['date'] = '0100-01-01';
		if(isset($_REQUEST['date'])) {
			$data['date'] = $_REQUEST['date'];
		}

		$mmnr01_arr = explode('-', $mmnr01);
		if($mmnr01_arr[0]=='tran01_d'){
			$data['v103_hidden'] = 2;
		}
		
		if($data['v_auto_add'] == 1) {
			$data['v103_readonly'] = 1;
		}
		// $parent_d = explode('-', $mmnr01)[0];
		// $get_parent = invoices__invoices_online_get_parent($parent_d);
		// if ($get_parent['ok'] != 1) {
		// 	throw new Exception($get_parent['error']);
		// }
		// $parent = $get_parent['data'];
		// if ($parent['_initialize_function'] != '' && !function_exists($parent['_initialize_function'])) {
		// 	throw new Exception('_initialize_function ' . $parent['_initialize_function'] . ' function not available');
		// } elseif ($parent['_initialize_function'] != '') {
		// 	return $parent['_initialize_function'](
		// 		$data,
		// 		$mmnr01,
		// 		$mnr01,
		// 		$_d,
		// 		$container_id
		// 	);
		// }
		return $data;
	} catch (Exception $e) {
		$data['permDeny'] = 1;
		$data['permDenyMessage'] = $e->getMessage();
		return $data;
	}
}
/**
 * Επιστρέφει τα στοιχεία του parent που έχει ζητηθεί αν υπάρχει
 * υλοποίηση του και καταχώρηση στο invoices__invoices_online_parents
 *
 * @param string $_d
 * @return array
 */
function invoices__invoices_online_get_parent(
	$_d = ''
) {
	try {
		$is_parent = invoices__invoices_online_is_parent($_d);
		if ($is_parent['ok'] != 1) {
			throw new Exception($is_parent['error']);
		}
		$parents = invoices__invoices_online_parents();
		return array(
			'ok' 	=> 1,
			'error'	=> NULL,
			'data'	=> $parents[$_d],
			'msg'	=> 'Success'
		);
	} catch (Exception $e) {
		return array(
			'ok' 	=> 0,
			'error'	=> $e->getMessage(),
			'data'	=> NULL,
			'msg'	=> $e->getMessage()
		);
	}
}
/**
 * Ελέγχει αν υπάρχει σχετική εγγραφή στον invoices__invoices_online_parents
 * για υλοποίηση σε αυτό το _d
 *
 * @param string $_d
 * @return array
 */
function invoices__invoices_online_is_parent(
	$_d = ''
) {
	try {
		$parents = invoices__invoices_online_parents();
		if (!array_key_exists($_d, $parents)) {
			throw new Exception("H $_d Othoni den ypostirisete gia grigori kataxorish");
		}
		if (!pegasus_module_exists($parents[$_d]['module'])) {
			throw new Exception('module ' . $parents[$_d]['module'] . ' not available for _d ' . $_d);
		}
		return array(
			'ok' 	=> 1,
			'error'	=> NULL,
			'data'	=> NULL,
			'msg'	=> 'Success'
		);
	} catch (Exception $e) {
		return array(
			'ok' 	=> 0,
			'error'	=> $e->getMessage(),
			'data'	=> NULL,
			'msg'	=> $e->getMessage()
		);
	}
}


/**
 *  Αν διαγραψει απο τον πινακα τω ειδων του παραστατικο οτι εχει καταχωρηθει αυτοματα απο προηγουμενη επιλογη Τυπου Παραστατικου (a10,a11 ...)
 * $mode      = a55 || a56 || a57 || a67 
 * $axx_p01   =  Tυπος παραστατικου a10 , a11
 * $kath_fpa  =  Kαθεστως ΦΠΑ παραστατικου
 */
function invoices_i01_from_axx_p500 (
	$mode  = '',
	$parent_nr01 = 0,
	$axx_p01 = 0,
	$kath_fpa = 0
) {
	try {
		$remguc='auto';
		$p500=array();
		$parent_tbl='';
		$p07=0;
		$general_mode = '';		// order / invoice
		switch($mode) {
			case 'a55':
				$parent_tbl = 'a55';
				$line_item_table = 'i01';
				$axx_tpl = 'a10';
				$p07 = 2;
				$general_mode = 'invoice';
				break;
			case 'a56' :
				$parent_tbl = 'a56';
				$line_item_table = 'i01';
				$axx_tpl = 'a11';
				$p07 = 1;
				$general_mode = 'invoice';
				break;
			case 'a57' :
				$parent_tbl = 'a57';
				$line_item_table = 'a58';
				$axx_tpl = 'a10';
				//$p07 = 1;
				$general_mode = 'order';
				break;
			case 'a67' :
				$parent_tbl = 'a67';
				$line_item_table = 'a68';
				$axx_tpl = 'a11';
				//$p07 = 1;
				$general_mode = 'order';
				break;

			default :
				throw new Exception("Mode $mode not Supported");
		}
		if(!($parent_nr01>0)) {
			throw new Exception("$parent_tbl.nr01 (parent_nr01) not set");
		}

		//αν εχω επιεγμενο τυπο παραστατικου
		if($axx_p01 > 0) {
			$mmnr01 = $parent_tbl.'_d-'.$parent_nr01;
			$mnr01 = $parent_nr01;

			// διαβαζω τα ειδη που πρεπει να καταχωρηθουνς αυτοματα
			pegasus_mysql_use("select p500 , p05 from " . $axx_tpl . "  where p01=:p01;" , $rec_typou_parastatikou ,   array('p01'=>$axx_p01));
			$p500   = $rec_typou_parastatikou['p500'];
			$i01p05 = $rec_typou_parastatikou['p05'];

			//	Διαγράφουμε τα υπάρχοντα Είδη που εχουν καταχωρηθει αυτοματα απο ιδια καταχωρηση
			if($general_mode == 'invoice') {
				// For invoice mode
				$values=array(
					'p06'			=> $parent_nr01,
					'p07'			=> $p07,
					'peg_mmnr01'	=> $mmnr01,
					'peg_mnr01' 	=> $mnr01,
					'peg_sess_id'	=> session_id(),
					'remguc'		=> $remguc,
					'peg_flag'		=>	9,
				);
				$ret=pegasus_mysql_update(
					"peg_tmp_$line_item_table",
					array('peg_flag'),
					array(9),
					"
						p06				 = :p06
						AND p07			 = :p07
						AND peg_mmnr01	 = :peg_mmnr01
						AND peg_mnr01	 = :peg_mnr01
						AND peg_sess_id	 = :peg_sess_id
						AND remguc		 = :remguc
						AND peg_flag	!= :peg_flag
					",
					0,1,0,
					$values
				);
			} elseif($general_mode == 'order') {
				//	For order mode
				$values=array(
					'p00'			=> $parent_nr01,
					'peg_mmnr01'	=> $mmnr01,
					'peg_mnr01' 	=> $mnr01,
					'peg_sess_id'	=> session_id(),
					'remguc'		=> $remguc,
					'peg_flag'		=>	9,
				);
				$ret=pegasus_mysql_update(
					"peg_tmp_$line_item_table",
					array('peg_flag'),
					array(9),
					"
						p00				 = :p00
						AND peg_mmnr01	 = :peg_mmnr01
						AND peg_mnr01	 = :peg_mnr01
						AND peg_sess_id	 = :peg_sess_id
						AND remguc		 = :remguc
						AND peg_flag	!= :peg_flag
					",
					0,1,0,
					$values
				);
			} else {
				throw new Exception("Unknown mode ($mode)");
			}
			if(!$ret) {
				throw new Exception(pegasus_mysql_error());
			}

			if(!empty($p500)){
				//alalzei se array
				$p500=explode("#",$p500);
				
				//theoroyme oti exoyme 2 #
				if(count($p500)>1) {
					//ttwwi ti kenew eggrafe
					array_pop($p500);
					array_shift($p500);
					
					$in=pegasus_mysql_create_in($p500,'pno');
				
					//bgazei to peg_flag 9 gia an vrei aki ayta poy diegrapse prin  η το ειχει διαγραψει ο χρηστης
					unset($values['peg_flag']);
					$values=array_merge($values,$in['sqlParams']);
					$existing=array();
					if($general_mode == 'invoice') {
						//	For invoice mode
						$sql="	SELECT p01,nr01
								FROM peg_tmp_$line_item_table
								WHERE p06		 = :p06
								AND p07			 = :p07
								AND peg_mmnr01	 = :peg_mmnr01
								AND peg_mnr01	 = :peg_mnr01
								AND peg_sess_id	 = :peg_sess_id
								AND remguc		 = :remguc
								AND p01 IN (".$in['sql'].")
						";
						$ret=pegasus_query($sql,$values);
						if(!$ret) {
							throw new Exception(pegasus_mysql_error());
						}
						while($ex=pegasus_fetch_assoc($ret)) {
							$existing[$ex['p01']]=$ex['nr01'];
						}
					}elseif($general_mode == 'order') {
						//	For order mode
						$sql="	SELECT v101,nr01
								FROM peg_tmp_$line_item_table
								WHERE p00		 = :p00
								AND peg_mmnr01	 = :peg_mmnr01
								AND peg_mnr01	 = :peg_mnr01
								AND peg_sess_id	 = :peg_sess_id
								AND remguc		 = :remguc
								AND v101 IN (".$in['sql'].")
						";
						$ret=pegasus_query($sql,$values);
						if(!$ret) {
							throw new Exception(pegasus_mysql_error());
						}
						while($ex=pegasus_fetch_assoc($ret)) {
							$existing[$ex['v101']]=$ex['nr01'];
						}
					}
					$nr01ToRecover=array();

					// Προσθέτουμε τα Είδη του παραστατικού
					foreach($p500 as $i00_pno) {
						//για καθε εινα ειδο που υπαρχει στο παραστατικο ειτε ειανι διεγραμενο ειτε οχι ερχετε και το προτ που θα βρει το βαζει στο $nr01ToRecover
						if(array_key_exists($i00_pno,$existing)) {
							$nr01ToRecover[]=$existing[$i00_pno];
							continue;
						}

						//  Βρίσκουμε το Είδος // Anazeitaei se ola kai se serial number bug???  θα βρει παντα το πρωτο με τον κωδικο αργοπορια
						$resp = invoices__invoices_online_find(
							$i00_pno,
							0
						);
						if ($resp['ok'] != 1) {
							throw new Exception($resp['msg'], 1);
						}

						$i18_p02 = 0;
						if(pegasus_module_exists("invsets")) {
							$query_i18 = "SELECT nr01, p02, p03, p04, p05 FROM i18 WHERE p00 = :p01 AND pc01 = :pc01 AND pm01 = :pm01";

							$query_params_i18 = array(
								"p01"  => $resp['data']['v101'],
								"pc01" => "",
								"pm01" => ""
							);
				
							pegasus_mysql_use($query_i18, $res_i18, $query_params_i18);

							$i18_p02 = $res_i18['p02'];
						}

						// Προσθέτουμε το Είδος
						$resp = invoices__invoices_online_insert(
							$mmnr01,
							$mnr01,
							$resp['data']['code'],
							$resp['data']['p9000'],
							$resp['data']['ser'],
							$resp['data']['timh1'],
							$resp['data']['timh2'],
							$resp['data']['timh3'],
							$resp['data']['timh4'],
							$resp['data']['type'],
							$resp['data']['v101'],
							$resp['data']['v102'],
							$resp['data']['v103'],
							$resp['data']['v161'],
							$resp['data']['v172'],
							$resp['data']['v173'],
							$resp['data']['v_baltot'],
							$resp['data']['v_cusord'],
							$resp['data']['v_locbaltot'],
							$resp['data']['v_loccusord'],
							$resp['data']['v_locsuppord'],
							$resp['data']['v_suppord'],
							$resp['data']['vtype'],
							$kath_fpa,
							$remguc,
							date("Y-m-d"),
							0,
							'',
							$i01p05,
							0, 0,
							$i18_p02
						);

						if ($resp['ok'] != 1) {
							throw new Exception($resp['msg'], 1);
						}
						
						if(
							pegasus_module_exists("invsets") && 
							(
								(in_array($mode, array("a55", "a57")) && $res_i18['p03'] == 1) ||
								(in_array($mode, array("a56", "a67")) && $res_i18['p04'] == 1) ||
								(in_array($mode, array("a60", "a61")) && $res_i18['p05'] == 1)
							)
						) {
							invoices_execute_i18_add_item(
								$mode, 
								substr($mmnr01, 6), 
								$res_i18['nr01'], 
								$resp['data']['product_nr01'], 
								$resp['data']['request']['v101'], 
								$resp['data']['request']['v103'], 
								$resp['data']['request']['p05'], 
								$resp['data']['request']['kath_fpa'], 
								$remguc, 
								1, 0
							);
						}
					}
					$in=pegasus_mysql_create_in($nr01ToRecover,'pno');
					if(count($nr01ToRecover)>0) {
						$in=pegasus_mysql_create_in($nr01ToRecover,'nr01');
						$sql="	UPDATE peg_tmp_$line_item_table
								SET peg_flag = 2
								WHERE (
										nr01 IN (".$in['sql'].") OR 
										i18$line_item_table IN (".$in['sql'].")
									  )
								AND peg_mmnr01	 = :peg_mmnr01
								AND peg_mnr01	 = :peg_mnr01
								AND peg_sess_id	 = :peg_sess_id
						";
						$values=array(
							'peg_mmnr01'	=> $mmnr01,
							'peg_mnr01' 	=> $mnr01,
							'peg_sess_id'	=> session_id(),
						);
						$values=array_merge($values,$in['sqlParams']);
						if(!pegasus_query($sql,$values)) {
							throw new Exception(pegasus_mysql_error());
						}
					}
				}
			}
		}
		return array (
			'ok'	=> 1,
			'error'	=> NULL,
			'data'	=> NULL,
			'msg'	=> 'Success'
		);
	} catch(Exception $e) {
		$msg = "ERROR";
	//	if($e->getCode()==1) {
			$msg=$e->getMessage();
		//}
		return array (
			'ok'	=> 0,
			'error'	=> $e->getMessage(),
			'data'	=> NULL,
			'msg'	=> $msg
		);
	}
}
function invoices_i01_from_axx_p501 (
	$mode  = '',
	$parent_nr01 = 0,
	$axx_p01 = 0
) {
	try {
		$remguc='auto';
		$p501=array();
		$parent_tbl='';
		switch($mode) {
			case 'a55':
				$parent_tbl = 'a55';
				$axx_tpl = 'a10';
				break;
			case 'a56' :
				$parent_tbl = 'a56';
				$axx_tpl = 'a11';
				break;
			case 'a57' :
				$parent_tbl = 'a57';
				$axx_tpl = 'a10';
				break;
			case 'a67' :
				$parent_tbl = 'a67';
				$axx_tpl = 'a11';
				break;
			default :
				throw new Exception("Mode $mode not Supported");
		}
		if(!($parent_nr01>0)) {
			throw new Exception("$parent_tbl.nr01 (parent_nr01) not set");
		}
		$p501=pegasus_mysql_printfld($axx_tpl,'p501','p01=:p01',array('p01'=>$axx_p01));
		$mmnr01 = $parent_tbl.'_d-'.$parent_nr01;
		$mnr01 = $parent_nr01;
		$values=array(
			'tbl'			=> $parent_tbl,
			'tbl_nr'		=> $parent_nr01,
			'peg_mmnr01'	=> $mmnr01,
			'peg_mnr01' 	=> $mnr01,
			'peg_sess_id'	=> session_id(),
			'remguc'		=> $remguc,
			'peg_flag'		=>	9,
		);
		$ret=pegasus_mysql_update(
			'peg_tmp_i71',
			array('peg_flag'),
			array(9),
			"
				tbl				 = :tbl
				AND tbl_nr		 = :tbl_nr
				AND peg_mmnr01	 = :peg_mmnr01
				AND peg_mnr01	 = :peg_mnr01
				AND peg_sess_id	 = :peg_sess_id
				AND remguc		 = :remguc
				AND peg_flag	!= :peg_flag
			",
			0,1,0,
			$values
		);
		if(!$ret) {
			throw new Exception(pegasus_mysql_error());
		}
		if(!empty($p501)){
			$p501=explode("#",$p501);
			if(count($p501)>1) {
				array_pop($p501);
				array_shift($p501);
				$in=pegasus_mysql_create_in($p501,'i70');
				unset($values['peg_flag']);
				$sql="	SELECT nr01, i70
						FROM peg_tmp_i71
						WHERE i70 IN (".$in['sql'].")
						AND tbl			 = :tbl
						AND tbl_nr		 = :tbl_nr
						AND peg_mmnr01	 = :peg_mmnr01
						AND peg_mnr01	 = :peg_mnr01
						AND peg_sess_id	 = :peg_sess_id
						AND remguc		 = :remguc
				";
				$ret=pegasus_query($sql,array_merge($values,$in['sqlParams']));
				if(!$ret) {
					throw new Exception(pegasus_mysql_error());
				}
				$existing=array();
				while($ex=pegasus_fetch_assoc($ret)) {
					$existing[$ex['i70']]=$ex['nr01'];
				}
				$p501=array_diff($p501,array_keys($existing));
				$in=pegasus_mysql_create_in(array_values($existing),'i71');
				pegasus_mysql_update(
					'peg_tmp_i71',
					array('peg_flag'),
					array(2),
					"
						nr01 IN (".$in['sql'].")
						AND tbl			 = :tbl
						AND tbl_nr		 = :tbl_nr
						AND peg_mmnr01	 = :peg_mmnr01
						AND peg_mnr01	 = :peg_mnr01
						AND peg_sess_id	 = :peg_sess_id
						AND remguc		 = :remguc
					",
					0,1,0,
					array_merge($values,$in['sqlParams'])
				);
				if(!empty($p501)){
					$in=pegasus_mysql_create_in($p501,'i70');
					$sql="INSERT INTO peg_tmp_i71
						(
							nr01,
							tbl,
							tbl_nr,
							i70p02,
							i70,
							i70p07,
							remdate,
							remtime,
							remuser,
							remfdate,
							remftime,
							remfuser,
							remguc,
							peg_flag,
							peg_mmnr01,
							peg_mnr01,
							peg_sess_id,
							tax
						) (
							SELECT
								peg_new_nr01('i71' , 0)		AS nr01,
								:tbl						AS tbl,
								:tbl_nr						AS tbl_nr,
								i70.p02						AS i70p02,
								i70.nr01					AS i70,
								i70.p07						AS i70p07,
								curdate()					AS remdate,
								curtime()					AS remtime,
								:user						AS remuser,
								curdate()					AS remfdate,
								curtime()					AS remftime,
								:user						AS remfuser,
								:remguc						AS remguc,
								:peg_flag					AS peg_flag,
								:peg_mmnr01					AS peg_mmnr01,
								:peg_mnr01					AS peg_mnr01,
								:peg_sess_id				AS peg_sess_id,
								i70.tax						AS tax
							FROM
								i70
							WHERE
								nr01 IN (".$in['sql'].")
							ORDER BY
								tax, nr01
						)
					";
					$values=array(
						'tbl'			=> $parent_tbl,
						'tbl_nr'		=> $parent_nr01,
						'user'			=> $_SESSION['username'],
						'remguc'		=> $remguc,
						'peg_flag'		=> 2,
						'peg_mmnr01'	=> $mmnr01,
						'peg_mnr01'		=> $mnr01,
						'peg_sess_id'	=> session_id(),
					);
					$values=array_merge($values,$in['sqlParams']);
					$ret=pegasus_query($sql,$values);
					if(!$ret) {
						throw new Exception(pegasus_mysql_error());
					}
				}
			}
		}
		return array (
			'ok'	=> 1,
			'error'	=> NULL,
			'data'	=> NULL,
			'msg'	=> "Success"
		);
	} catch(Exception $e) {
		$msg = "ERROR";
		//if($e->getCode()==1) {
			$msg=$e->getMessage();
	//	}
		return array (
			'ok'	=> 0,
			'error'	=> $e->getMessage(),
			'data'	=> NULL,
			'msg'	=> $msg
		);
	}
}
/**
 * Προσθέτει το custom action της Μαζική αλλαγή τιμής σε καταχωρημένα  Είδη.
 * Πρέπει να κληθεί στο εκάστοτε custom action function του grid ή στο ανάλογο field toy grid
 *
 * @param array $data		To array με τα υπόλοιπα custom actions (set as array() για κλήση από field)
 * @param string $main_d	Main _d name (like a55_d, a56_d etc.)
 * @return boolean
 */
function invoices__invoices_masschange_custom_action_peg002(
	$data = array(),
	$main_d = ''
) {
	$data[] = array(
		'xtype'			=> 'pegasusToolBarGridAction',
		'peg_custom_id'	=> 'invoices__invoices_masschange_' . $main_d,
		'viewModel'		=> array(
			'type'		=> 'GridButtonModel',
			'isToolBar'	=> 1,
			'data' =>	array(
				'toolBarButton'		=> 'invoices__invoices_masschange_' . $main_d,
			)
		),
		'icon' => 'invoices_images/invoice02_16x16.png',
		'text' =>  $_SESSION['peg_dic_invoices__invoices_masschange_button'],
		'peghandler' => "invoices__invoices_masschange_show(screen)"
	);
	return $data;
}
/**
 * Ενεργοποίηση του custom action (button).
 * Πρέπει να γίνει κλήση αυτής της συνάρτησης στην
 * initialize του _d  θα έχει Μαζική αλλαγή τιμής σε καταχωρημένα  Είδη
 *
 * @param array $data		module_initialize $data argument
 * @param string $main_d	main _d name (like i00_d, a37_d etc.)
 * @param string $module	Module name
 * @param string $grid_d	Grid's _d name (like i00_d00, a37_d00 etc.)
 * @param string $grid_name	Grid's name
 * @return void
 */
function invoices__invoices_masschange_enable_custom_actions(
	&$data,
	$main_d = '',
	$module = '',
	$grid_d = '',
	$grid_name = ''
) {
	$data[$module . '_' . $grid_d . '_' . $grid_name . '_invoices__invoices_masschange_' . $main_d . '_hidden'] = false;
}
/**
 *
 * @param string $parent_table
 * @param integer $parent_nr01
 * @return array
 */
function peg_invoices__invoices_masschange_getLineItemSQL(
	$parent_table = '',
	$parent_nr01 = 0,
	$cnt_mode = false
) {
	try {
		$p07 = 0;
		$lineItemsTable='';
		$lineItemsTable_p01='';
		$lineItemsTable_p04='';
		switch ($parent_table) {
			case 'a55':
				$lineItemsTable='peg_tmp_i01';
				$lineItemsTable_p01='p01';
				$lineItemsTable_p04='p04';
				$p07 = 2;
				break;
			case 'a56':
				$lineItemsTable='peg_tmp_i01';
				$lineItemsTable_p01='p01';
				$lineItemsTable_p04='p04';
				$p07 = 1;
				break;
			case 'a57' :
				$lineItemsTable='peg_tmp_a58';
				$lineItemsTable_p01='v101';
				$lineItemsTable_p04='v104';
				break;
			case 'a67' :
				$lineItemsTable='peg_tmp_a68';
				$lineItemsTable_p01='v101';
				$lineItemsTable_p04='v104';
				break;
			case 'a60' :
				$lineItemsTable='peg_tmp_i01';
				$lineItemsTable_p01='p01';
				$lineItemsTable_p04='p04';
				$p07 = 3;
				break;
			case 'a61' :
				$lineItemsTable='peg_tmp_a62';
				$lineItemsTable_p01='v101';
				$lineItemsTable_p04='v104';
				break;
			default :
				throw new Exception($_SESSION['peg_dic_invoices__invoices_masschange_error_nosupport'],1);
		}
		$fields=$cnt_mode?"COUNT($lineItemsTable_p01) AS cnt":$lineItemsTable_p01;
		$sql="SELECT
				$fields
			FROM
				$lineItemsTable
			WHERE  peg_mmnr01	= :peg_mmnr01
			AND peg_mnr01		= :peg_mnr01
			AND peg_sess_id		= :peg_sess_id
			AND peg_flag		!= :peg_flag
		";
		$values=array(
			'peg_mmnr01'	=> $parent_table.'_d-'.$parent_nr01,
			'peg_mnr01'		=> $parent_nr01,
			'peg_sess_id'	=> session_id(),
			'peg_flag'		=> 9
		);
		$data=array(
			'sql'					=> $sql,
			'values'				=> $values,
			'lineItemsTable'		=> $lineItemsTable,
			'lineItemsTable_p01'	=> $lineItemsTable_p01,
			'lineItemsTable_p04'	=> $lineItemsTable_p04,
			'p07'					=> $p07
		);
		return array(
			'ok'	=> 1,
			'error'	=> null,
			'data'	=> $data,
			'msg'	=> 'Success'
		);
	} catch (Exception $e) {
		$msg=$_SESSION['peg_dic_invoices__invoices_masschange_error'];
		if($e->getCode()==1) {
			$msg=$e->getMessage();
		}
		return array(
			'ok'	=> 0,
			'error'	=> $e->getMessage(),
			'data'	=> null,
			'msg'	=> $msg
		);
	}

}
/**
 *
 * @param array $data
 * @param string $mmnr01
 * @param integer $mnr01
 * @param string $_d
 * @param string $container_id
 * @return array
 */
function peg_invoices__invoices_masschange_d_initialize(
	$data = array(),
	$mmnr01 = '',
	$mnr01 = 0,
	$_d  = '',
	$container_id = ''
) {
	try {
		$p01=$_REQUEST['p01'];
		if(!empty($p01)) {
			$data['p01'] = $p01;
			$data['v_selectbox_p01'] = pegasus_mysql_printfld('i00','name','pno=:pno',array('pno'=>$p01));
		}
		$parent_d=explode("-",$mmnr01)[0];
		$parent_nr01=explode("-",$mmnr01)[1];
		$parent_table=explode("_",$parent_d)[0];
		$resp=peg_invoices__invoices_masschange_getLineItemSQL($parent_table,$parent_nr01,false);
		if($resp['ok']!=1) {
			throw new Exception($resp['error'],1);
		}
		$sql				= $resp['data']['sql'];
		$values				= $resp['data']['values'];
		$lineItemsTable_p01	= $resp['data']['lineItemsTable_p01'];
		$p07				= $resp['data']['p07'];
		if(in_array($parent_table,array('a55','a56','a60'))) {
			$sql.="	AND p06 = :p06
					AND p07 = :p07
			";
			$values['p06'] = $parent_nr01;
			$values['p07'] = $p07;
		}
		elseif(in_array($parent_table,array('a57','a67','a61'))) {
			$sql.="	AND p00 = :p00";
			$values['p00'] = $parent_nr01;
		}
		else {
			throw new Exception($_SESSION['peg_dic_invoices__invoices_masschange_error_nosupport'],1);
		}
		$ret = pegasus_query($sql,$values);
		if(!$ret) {
			throw new Exception(pegasus_mysql_error());
		}
		$pnos=array();
		while($pno=pegasus_fetch_assoc($ret)) {
			$pnos[]=$pno[$lineItemsTable_p01];
		}
		$in=pegasus_mysql_create_in($pnos,'pno');
		$whereSql="i00.pno IN (".$in['sql'].")";
		pegasusSetGlobalVar($container_id . '_where_p01',   array('sql' => $whereSql, 'sqlParams' => $in['sqlParams']));
		return $data;
	} catch (Exception $e) {
		$msg=$_SESSION['peg_dic_invoices__invoices_masschange_error'];
		if($e->getCode()==1) {
			$msg=$e->getMessage();
		}
		$data['permDeny'] = 1;
		$data['permDenyMessage'] = $msg;
		return $data;
	}
}
/**
 *
 * @param string $mmnr01
 * @param integer $mnr01
 * @param string $p01
 * @param integer $p04
 * @return array
 */
function peg_invoices__invoices_masschange_check(
	$mmnr01 = '',
	$p01 = '',
	$p04 = 0
) {
	try {
		$data=array();
		$parent_d=explode("-",$mmnr01)[0];
		$parent_nr01=explode("-",$mmnr01)[1];
		$parent_table=explode("_",$parent_d)[0];

		if(empty($p01)) {
			throw new Exception($_SESSION['peg_dic_invoices__invoices_masschange_error_nop01'],1);
		}

		$resp=peg_invoices__invoices_masschange_getLineItemSQL($parent_table,$parent_nr01,true);
		if($resp['ok']!=1) {
			throw new Exception($resp['error'],1);
		}
		$sql				= $resp['data']['sql'];
		$values				= $resp['data']['values'];
		$p07				= $resp['data']['p07'];
		if(in_array($parent_table,array('a55','a56','a60'))) {
			$sql.="	AND p06 = :p06
					AND p07 = :p07
					AND p01 = :p01
			";
			$values['p06'] = $parent_nr01;
			$values['p07'] = $p07;
			$values['p01'] = $p01;
		}
		elseif(in_array($parent_table,array('a57','a67','a61'))) {
			$sql.="	AND p00 = :p00
					AND v101 = :v101
			";
			$values['p00'] = $parent_nr01;
			$values['v101'] = $p01;
		}
		$ret=pegasus_query($sql,$values);
		if(!$ret) {
			throw new Exception(pegasus_mysql_error());
		}
		$cnt=pegasus_fetch_assoc($ret);
		$msg=$_SESSION['peg_dic_invoices__invoices_masschange_check_inform'];
		$msg=str_replace(
			array('#cnt#','#p01#','#p04#'),
			array($cnt['cnt'],$p01,$p04),
			$msg
		);
		if(!($p04>0)) {
			$msg.=$_SESSION['peg_dic_invoices__invoices_masschange_check_inform_zero'];
		}
		$data=array(
			'title'		=> $_SESSION['peg_dic_invoices__invoices_masschange_check_inform_title'],
			'message' 	=> $msg
		);
		return array(
			'ok'	=> 1,
			'error'	=> null,
			'data'	=> $data,
			'msg'	=> 'Success'
		);
	} catch (Exception $e) {
		$msg=$_SESSION['peg_dic_invoices__invoices_masschange_error'];
		if($e->getCode()==1) {
			$msg=$e->getMessage();
		}
		return array(
			'ok'	=> 0,
			'error'	=> $e->getMessage(),
			'data'	=> null,
			'msg'	=> $msg
		);
	}
}
/**
 *
 * @param string $mmnr01
 * @param string $p01
 * @param integer $p04
 * @return array
 */
function peg_invoices__invoices_masschange_update(
	$mmnr01 = '',
	$p01 = '',
	$p04 = 0
) {
	try {
		$data=array();
		$parent_d=explode("-",$mmnr01)[0];
		$parent_nr01=explode("-",$mmnr01)[1];
		$parent_table=explode("_",$parent_d)[0];
		$resp=peg_invoices__invoices_masschange_getLineItemSQL($parent_table,$parent_nr01,true);
		if($resp['ok']!=1) {
			throw new Exception($resp['error'],1);
		}
		$lineItemsTable_p01	= $resp['data']['lineItemsTable_p01'];
		$lineItemsTable_p04	= $resp['data']['lineItemsTable_p04'];
		$lineItemsTable	= $resp['data']['lineItemsTable'];
		$sql="UPDATE $lineItemsTable SET
			$lineItemsTable_p04 = :p04
			WHERE $lineItemsTable_p01 = :p01
			AND peg_mmnr01	= :peg_mmnr01
			AND peg_mnr01	= :peg_mnr01
			AND peg_sess_id	= :peg_sess_id
			AND peg_flag	!= :peg_flag
		";
		$values = array(
			'p04'			=> $p04,
			'p01'			=> $p01,
			'peg_mmnr01'	=> $mmnr01,
			'peg_mnr01'		=> $parent_nr01,
			'peg_sess_id'	=> session_id(),
			'peg_flag'		=> 9
		);
		if(!pegasus_query($sql,$values)) {
			throw new Exception(pegasus_mysql_error());
		}
		$data['mode'] = $parent_table;
		return array(
			'ok'	=> 1,
			'error'	=> null,
			'data'	=> $data,
			'msg'	=> 'Success'
		);
	} catch (Exception $e) {
		$msg=$_SESSION['peg_dic_invoices__invoices_masschange_error'];
		if($e->getCode()==1) {
			$msg=$e->getMessage();
		}
		return array(
			'ok'	=> 0,
			'error'	=> $msg,
			'data'	=> null,
			'msg'	=> 'Error'
		);
	}
}
/**
 *
 * @param array $data
 * @param string $mmnr01
 * @param string $mnr01
 * @param string $_d
 * @param string $container_id
 * @return array
 */
function invoices_i01_d103_initialize(
	$data = array(),
	$mmnr01 = '',
	$mnr01 = '',
	$_d  = '',
	$container_id = ''
) {
	$data = serial_enable_custom_actions($data,'grid',$_d,'invoices');
	return $data;
}
/**
 *
 * @param array $data
 * @param string $mmnr01
 * @param string $mnr01
 * @param string $_d
 * @param string $container_id
 * @return array
 */
function invoices_i01_d104_initialize(
	$data = array(),
	$mmnr01 = '',
	$mnr01 = '',
	$_d  = '',
	$container_id = ''
) {
	$data = lot_enable_custom_actions($data,'grid',$_d,'lot');
	
	return $data;
}

/**
 *
 * @param string 	$table a01 ή a00
 * @param int 		$nr01  Πελάτης ή Προμηθευτής
 * @return bool		false αν πρεπει να ειναι read only
 */
function invoices_check_for_afm_change($table='', $nr01='') {
	
	if(pegasus_mysql_table_exists($table)){
		if($table=='a01' && pegasus_mysql_table_exists('a55') ){
			// πληθος παραστατικών πελάτη
			$query = "SELECT count(*) AS cnt FROM a55 WHERE p03=:nr01";
			pegasus_mysql_use($query, $arr, array('nr01'=>$nr01));
			// Εχει κοπεί ήδη παραστατικό..
			if(	$arr['cnt']>0 && 
				!pegasus_check_permission('customers_change_a01_p20') &&
				pegasus_module_exists('customers')
			){
				return false;
			}
		}
		else if($table=='a00' && pegasus_mysql_table_exists('a56')){
			$exta_join = '';
			if(pegasus_module_exists('receipts')){
				$exta_join = ' LEFT JOIN t08 ON t08.p03  = a00.p21';
			}
			// πληθος παραστατικών προμηθευτή
			$query = "SELECT count(*) AS cnt 
						FROM a56 
						LEFT JOIN a00 ON a56.p03  = a00.nr01 
						".$exta_join."
						WHERE a00.nr01 = :nr01";
			pegasus_mysql_use($query, $arr, array('nr01'=>$nr01));
			// Εχει κοπεί ήδη παραστατικό..
			if(	$arr['cnt']>0 && 
				!pegasus_check_permission('suppliers_change_a00_p20') &&
				pegasus_module_exists('suppliers')
			){
				return false;
			}
		}
	}
	return true;
}

/**
 *	Κάνει έλεγχο αν η παραγγελία αναφοράς και η παραγγελίες που θα συμπεριληφθούν 
 *	υπάρχουν και έχουν καινό τιμολογούμενο και παραστατικό.
 *
 * @param string $table 			Πίνακας Παραγγελιών (a57, a67, a61)
 * @param integer $mnr01			Μ.Κ. Παραγγελίας Αναφοράς
 * @param array $append_mnr01		Μ.Κ. Παραγγελιών που θα συμπεριληφθούν
 * @param string $table 
 * @return array
 */
function invoices_multiple_orders_to_single_document_check(
	$table = '',
	$mnr01 = 0,
	$append_mnr01 = array()
) {
	try {

		$order_main = array();
		if(!in_array($table,array('a57','a67','a61'))) {
			throw new Exception("Unknown Order's table");
		}
		pegasus_mysql_use(
			"SELECT nr01, p03, p04, p05 FROM $table WHERE nr01 = :nr01",
			$order_main,
			array('nr01' => $mnr01)
		);		
		if(!($order_main['nr01'] > 0)) {
			$msg = str_replace(
				'#nr01#',
				$mnr01,
				$_SESSION['peg_dic_invoices_multiple_orders_check_error_1']
			);
			throw new Exception($msg,601);
		}
		if(
			!is_array($append_mnr01)
			|| count($append_mnr01) == 0
		) {
			throw new Exception($_SESSION['peg_dic_invoices_multiple_orders_check_error_2'],601);
		}
		$in = pegasus_mysql_create_in(
			$append_mnr01, 
			'nr01'
		);
		$cnt_check = pegasus_mysql_printfld(
			$table,
			'COUNT(nr01)', 
			'nr01 IN ('.$in['sql'].')',
			$in['sqlParams']
		);
		if($cnt_check != count($append_mnr01 )) {
			throw new Exception($_SESSION['peg_dic_invoices_multiple_orders_check_error_3'],601);
		}
		$values = $in['sqlParams'];
		$values['p05'] = $order_main['p05'];
		$check_p03 = '';
		if($table != 'a61') {
			$check_p03 = 'OR p03 != :p03 OR p04 != :p04';
			$values['p03'] = $order_main['p03'];
			$values['p04'] = $order_main['p04'];
		}
		$similarity_check = pegasus_mysql_printfld(
			$table,
			'COUNT(nr01)',
			'nr01 IN ('.$in['sql'].') AND ( p05 !=:p05 '.$check_p03.')',
			$values
		);
		if($similarity_check > 0) {
			if($table != 'a61') {
				throw new Exception($_SESSION['peg_dic_invoices_multiple_orders_check_error_4'],601);
			}
			throw new Exception($_SESSION['peg_dic_invoices_multiple_orders_check_error_5'],601);
		}
		return array(
			'ok'	=> 1,
			'data'	=> null,
			'error'	=> null,
			'msg'	=> 'Pass'
		);
	} catch(Exception $e) {
		$msg = 'Fail';
		if($e->getCode() == 601) {
			$msg = 'Error: '.$e->getMessage();
		}
		return array(
			'ok'	=> 0,
			'data'	=> null,
			'error'	=> $e->getMessage(),
			'msg'	=> $msg
		);
	}
}
function invoices_get_wherehouse_query(
	$data = array()
) {
	$where = '';
	$values = array();
	if(function_exists('peg_inventory_get_storage_where_array')) {
		$where_arr = peg_inventory_get_storage_where_array($data['p09'],1);
		$where = 'AND '.$where_arr['sql'];
		$values = $where_arr['sqlParams'];
	}
	$sql = "	SELECT	t_i16.*
					FROM (
						SELECT
						0				AS nr01,
						-1				AS p00,
						:predefined		AS p01,
						''				AS p02,
						''				AS p03,
						''				AS p101,
						''				AS p102,
						''				AS p103,
						''				AS p104,
						''				AS pgef,
						-1				AS ptax,
						0				AS p300,
						''				AS p7,
						''				AS p05,
						''				AS ep05,
						''              AS t07p01
					UNION (
						SELECT
							nr01,
							p00,
							p01,
							p02,
							p03,
							p101,
							p102,
							p103,
							p104,
							pgef,
							ptax,
							p300,
							p7,
							p05,
							ep05,
							t07p01
						FROM i16
						WHERE 1 = 1
						$where
					)
			) AS t_i16
	";
	$values['predefined'] = $_SESSION['peg_dic_invoices_predefined'];
	return array(
		'sql' => $sql,
		'sqlParams' => $values
	);
}

function invoices_a10_get_p09_query(
	$data = array()
) {
	$where = '';
	$values = array();
	if(function_exists('peg_inventory_get_storage_where_array')) {
		$where_arr = peg_inventory_get_storage_where_array($data['p09'],1);
		$where = 'AND '.$where_arr['sql'];
		$values = $where_arr['sqlParams'];
	}
	$sql = "	SELECT	t_i16.*
					FROM (
						SELECT
						0				AS nr01,
						-1				AS p00,
						:predefined		AS p01,
						''				AS p02,
						''				AS p03,
						''				AS p101,
						''				AS p102,
						''				AS p103,
						''				AS p104,
						''				AS pgef,
						-1				AS ptax,
						0				AS p300,
						''				AS p7,
						''				AS p05,
						''				AS ep05,
						''				AS t07p01
					UNION (
						SELECT
							nr01,
							p00,
							p01,
							p02,
							p03,
							p101,
							p102,
							p103,
							p104,
							pgef,
							ptax,
							p300,
							p7,
							p05,
							ep05,
							t07p01
						FROM i16
						WHERE 1 = 1
						$where
					)
			) AS t_i16
	";
	$values['predefined'] = $_SESSION['peg_dic_invoices_predefined'];
	return array(
		'sql' => $sql,
		'sqlParams' => $values
	);
}
function invoices_a10_get_p109_query(
	$data = array()
) {
	$values = array();
	$sql = "	SELECT t_a18.*
				FROM (
					SELECT
						0			AS nr01,
						'****'		AS p01,
						:predefined	AS p02,
						''			AS p04,
						''			AS p03
					UNION (
						SELECT
							nr01,
							p01,
							p02,
							p03,
							p04
						FROM a18
						WHERE 1 = 1
					)
				) AS t_a18
	";
	$values['predefined'] = $_SESSION['peg_dic_invoices_predefined'];
	return array(
		'sql' => $sql,
		'sqlParams' => $values
	);
}
function invoices_a11_get_p09_query(
	$data = array()
) {
	return invoices_a10_get_p09_query($data);
}

function invoices_a11_get_p109_query(
	$data = array()
) {
	return invoices_a10_get_p109_query($data);
}

function invoices_a10_get_p010_query() {
	// Αν δεν υπαρχει το module stores
	if(!function_exists('peg_stores_get_stores_query')){ 
		return '';
	}
	return peg_stores_get_stores_query();
}
function invoices_a11_get_p010_query() {
	// Αν δεν υπαρχει το module stores
	if(!function_exists('peg_stores_get_stores_query')){ 
		return '';
	}
	return peg_stores_get_stores_query();
}
function invoices_a30_get_p010_query() {
	// Αν δεν υπαρχει το module stores
	if(!function_exists('peg_stores_get_stores_query')){ 
		return '';
	}
	return peg_stores_get_stores_query();
}
function invoices_a10_d_initialize($data, $mmnr01, $mnr01, $_d, $container_id) {
	// Παραμετροποίηση myDATA
	if(pegasus_module_exists('mydt')){
		$data['v_q30_620015'] = pegasus_mysql_printfld("q31", "p05", "p03 = ? and p01 = 620015", array($data['p01'])); 
		$data['v_q30_620014'] = pegasus_mysql_printfld("q31", "p05", "p03 = ? and p01 = 620014", array($data['p01'])); 
		$data['v_q30_620068'] = pegasus_mysql_printfld("q31", "p05", "p03 = ? and p01 = 620068", array($data['p01'])); 
		$data['v_q30_620061'] = pegasus_mysql_printfld("q31", "p05", "p03 = ? and p01 = 620061", array($data['p01'])); 
		$data['v_q30_620062'] = pegasus_mysql_printfld("q31", "p05", "p03 = ? and p01 = 620062", array($data['p01'])); 
	}
	
	// Παραμετροποίηση Lotify
	if(pegasus_module_exists('lotf')){
		$data['v_q30_640000'] = pegasus_mysql_printfld("q31", "p05", "p03 = ? and p01 = 640000", array($data['p01'])); 
		$data['v_q30_640003'] = pegasus_mysql_printfld("q31", "p05", "p03 = ? and p01 = 640003", array($data['p01'])); 
		$data['v_q30_640006'] = pegasus_mysql_printfld("q31", "p05", "p03 = ? and p01 = 640006", array($data['p01'])); 
	}

	// Παραμετροποίηση oil01
	if(pegasus_module_exists('oil01')){
		$data['v_q30_650000'] = pegasus_mysql_printfld("q31", "p05", "p03 = ? and p01 = 650000", array($data['p01'])); 
	}

	return $data;
}
function peg_invoices_a10_d_onsave($data, $permDeny, $mmnr01, $checkOnlyPerm)
{
	global $PegInput;

	if(
		!empty($data['a01'])
		&& pegasus_mysql_printfld('a01','p101','nr01 = :nr01',array('nr01' => $data['a01'])) > 0
	) {
		array_push($permDeny, array('type'=>'deny', 'message'=>$_SESSION['peg_dic_invoices_a10_a01_unacceptable'])); 
	}

	if(($data['p114'] == 1 || $data['p114'] == 2) && $data['p114'] == $data['p103']){
		array_push($permDeny, array('type'=>'deny', 'message'=>$_SESSION['peg_dic_invoices_a10_a11_p013_p014_check'])); 
	}

	$res_t02_a10 = array();
	$res_t02_a10 = "SELECT p03, p04 FROM t02 WHERE p01 = :p04";
	pegasus_mysql_use($res_t02_a10, $res_t02_a10, array('p04'=>$data['p04']));

	$res_t02_a14 = array();
	$query_t02_a14 = "SELECT a14.p01, t02.p03, t02.p04 FROM t02
					  LEFT JOIN a14 on a14.p02 = t02.p01
					  WHERE a14.nr01 = :p011";

	pegasus_mysql_use($query_t02_a14, $res_t02_a14, array('p011'=>$data['p011']));

	if($res_t02_a10['p03'] == 1 && $res_t02_a14['p04'] == -1) {
		array_push($permDeny, array('type'=>'deny', 'message'=>str_replace(array("#a10_p02#"), array($data['p02']), $_SESSION['peg_dic_invoices_a10_p04_positive_debit']))); 
	}

	if($res_t02_a10['p03'] == -1 && $res_t02_a14['p04'] == 1) {
		array_push($permDeny, array('type'=>'deny', 'message'=>str_replace(array("#a10_p02#"), array($data['p02']), $_SESSION['peg_dic_invoices_a10_p04_negative_debit']))); 
	}

	//Παραμετροποίηση myDATA/Lotify/Πρατήρια Καυσίμων
	if ($checkOnlyPerm == 1){
		if(pegasus_module_exists('mydt')){
			$PegInput->addVar(new peg_input_alphanumeric('v_q30_620015', 'request'));
			$PegInput->addVar(new peg_input_alphanumeric('v_q30_620014', 'request'));
			$PegInput->addVar(new peg_input_alphanumeric('v_q30_620068', 'request'));
			$PegInput->addVar(new peg_input_alphanumeric('v_q30_620061', 'request'));
			$PegInput->addVar(new peg_input_alphanumeric('v_q30_620062', 'request'));

			$v_q30_620015 = $PegInput->getRequest('v_q30_620015');
			$v_q30_620014 = $PegInput->getRequest('v_q30_620014');
			$v_q30_620068 = $PegInput->getRequest('v_q30_620068');
			$v_q30_620061 = $PegInput->getRequest('v_q30_620061');
			$v_q30_620062 = $PegInput->getRequest('v_q30_620062');

			core00_manage_relation($v_q30_620015, '620015', $data['p01']);
			core00_manage_relation($v_q30_620014, '620014', $data['p01']);
			core00_manage_relation($v_q30_620068, '620068', $data['p01']);
			core00_manage_relation($v_q30_620061, '620061', $data['p01']);
			core00_manage_relation($v_q30_620062, '620062', $data['p01']);			
		}

		if(pegasus_module_exists('lotf')){
			$PegInput->addVar(new peg_input_alphanumeric('v_q30_640000', 'request'));
			$PegInput->addVar(new peg_input_alphanumeric('v_q30_640003', 'request'));
			$PegInput->addVar(new peg_input_alphanumeric('v_q30_640006', 'request'));

			$v_q30_640000 = $PegInput->getRequest('v_q30_640000');
			$v_q30_640003 = $PegInput->getRequest('v_q30_640003');
			$v_q30_640006 = $PegInput->getRequest('v_q30_640006');

			core00_manage_relation($v_q30_640000, '640000', $data['p01']);
			core00_manage_relation($v_q30_640003, '640003', $data['p01']);
			core00_manage_relation($v_q30_640006, '640006', $data['p01']);			
		}

		if(pegasus_module_exists('oil01')){
			$PegInput->addVar(new peg_input_alphanumeric('v_q30_650000', 'request'));

			$v_q30_650000 = $PegInput->getRequest('v_q30_650000');

			core00_manage_relation($v_q30_650000, '650000', $data['p01']);
			
			// Όταν το [Καταχωρεί αυτόματα Επιστροφή] = 1 τότε απαραίτητα πρέπει [Τιμές με ΦΠΑ] = 1
			if($v_q30_650000 == 1 && $data['p601'] != 1) {
				array_push($permDeny, array('type'=>'deny', 'message'=> $_SESSION['peg_dic_oil01_deny_check_price_with_vat'])); 
			}			
		}
	}

	return array(
		'data' => $data, 
		'permDeny' => $permDeny
	);
}
function invoices_a11_d_initialize($data, $mmnr01, $mnr01, $_d, $container_id) {
	// Παραμετροποίηση myDATA
	if(pegasus_module_exists('mydt')) {
		$data['v_q30_620016'] = pegasus_mysql_printfld("q31", "p05", "p03 = ? and p01 = 620016", array($data['p01'])); 
		$data['v_q30_620017'] = pegasus_mysql_printfld("q31", "p05", "p03 = ? and p01 = 620017", array($data['p01'])); 
		$data['v_q30_620069'] = pegasus_mysql_printfld("q31", "p05", "p03 = ? and p01 = 620069", array($data['p01'])); 
		$data['v_q30_620063'] = pegasus_mysql_printfld("q31", "p05", "p03 = ? and p01 = 620063", array($data['p01'])); 
		$data['v_q30_620064'] = pegasus_mysql_printfld("q31", "p05", "p03 = ? and p01 = 620064", array($data['p01']));
	}

	// Παραμετροποίηση Lotify
	if(pegasus_module_exists('lotf')) {
		$data['v_q30_640001'] = pegasus_mysql_printfld("q31", "p05", "p03 = ? and p01 = 640001", array($data['p01']));
		$data['v_q30_640004'] = pegasus_mysql_printfld("q31", "p05", "p03 = ? and p01 = 640004", array($data['p01']));
		$data['v_q30_640007'] = pegasus_mysql_printfld("q31", "p05", "p03 = ? and p01 = 640007", array($data['p01']));
	}

	return $data;
}
function peg_invoices_a11_d_onsave($data, $permDeny, $mmnr01, $checkOnlyPerm)
{
	global $PegInput;

	if(
		!empty($data['a00'])
		&& pegasus_mysql_printfld('a00','p101','nr01 = :nr01',array('nr01' => $data['a00'])) > 0
	) {
		array_push($permDeny, array('type'=>'deny', 'message'=>$_SESSION['peg_dic_invoices_a11_a00_unacceptable'])); 
	}

	if(($data['p114'] == 1 || $data['p114'] == 2) && $data['p114'] == $data['p103']){
		array_push($permDeny, array('type'=>'deny', 'message'=>$_SESSION['peg_dic_invoices_a10_a11_p013_p014_check'])); 
	}

	// Παραμετροποίηση myDATA/Lotify
	if($checkOnlyPerm == 1){
		if(pegasus_module_exists('mydt')) {
			$PegInput->addVar(new peg_input_alphanumeric('v_q30_620016', 'request'));
			$PegInput->addVar(new peg_input_alphanumeric('v_q30_620017', 'request'));
			$PegInput->addVar(new peg_input_alphanumeric('v_q30_620069', 'request'));
			$PegInput->addVar(new peg_input_alphanumeric('v_q30_620063', 'request'));
			$PegInput->addVar(new peg_input_alphanumeric('v_q30_620064', 'request'));

			$v_q30_620016 = $PegInput->getRequest('v_q30_620016');
			$v_q30_620017 = $PegInput->getRequest('v_q30_620017');
			$v_q30_620069 = $PegInput->getRequest('v_q30_620069');
			$v_q30_620063 = $PegInput->getRequest('v_q30_620063');
			$v_q30_620064 = $PegInput->getRequest('v_q30_620064');
			
			core00_manage_relation($v_q30_620016, '620016', $data['p01']);
			core00_manage_relation($v_q30_620017, '620017', $data['p01']);
			core00_manage_relation($v_q30_620069, '620069', $data['p01']);
			core00_manage_relation($v_q30_620063, '620063', $data['p01']);
			core00_manage_relation($v_q30_620064, '620064', $data['p01']);			
		}

		if(pegasus_module_exists('lotf')) {
			$PegInput->addVar(new peg_input_alphanumeric('v_q30_640001', 'request'));
			$PegInput->addVar(new peg_input_alphanumeric('v_q30_640004', 'request'));
			$PegInput->addVar(new peg_input_alphanumeric('v_q30_640007', 'request'));

			$v_q30_640001 = $PegInput->getRequest('v_q30_640001');
			$v_q30_640004 = $PegInput->getRequest('v_q30_640004');
			$v_q30_640007 = $PegInput->getRequest('v_q30_640007');

			core00_manage_relation($v_q30_640001, '640001', $data['p01']);
			core00_manage_relation($v_q30_640004, '640004', $data['p01']);
			core00_manage_relation($v_q30_640007, '640007', $data['p01']);
		}
	}

	return array(
		'data' => $data, 
		'permDeny' => $permDeny
	);
}

function invoices_f02_d_initialize($data, $mmnr01, $mnr01, $_d, $container_id){

	$data["invoices_f02_d1_pg09_ls_data"] = array(
		array('p00' => 0, 'p01' => 'Δεν Εμφανίζεται'),
		array('p00' => 1, 'p01' => 'Τελευταία Τιμή επιλεγμένου Πελάτη'),
		array('p00' => 2, 'p01' => 'Τελευταία Τιμή οποιουδήποτε Πελάτη')
	);

	$data["invoices_f02_d2_apg09_ls_data"] = array(
		array('p00' => 0, 'p01' => 'Δεν Εμφανίζεται'),
		array('p00' => 1, 'p01' => 'Τελευταία Τιμή επιλεγμένου Προμηθευτή'),
		array('p00' => 2, 'p01' => 'Τελευταία Τιμή οποιουδήποτε Προμηθευτή')
	);

	// Ενημέρωση 
	if($data['p626'] == 1) {
		$data['p638_hidden'] = false;
	} else {
		$data['p638_hidden'] = true;
	}

	if(pegasus_module_exists('hot000')){	
		pegasusSetGlobalVar(
			$container_id . '_where_hota18',   
			array(
				'sql'		=> 'hota18.p03=1 and hota18.peid="" and hota18.p05=0', 
				'sqlParams' => array()
			)
		);
	}else{
		$data['p9000_hidden'] = true;
	}

	return $data;
}



/**
 * Ενημερώνει τις Κινήσεις που αφορούν ΚΚ Κίνησης=9 με βαση τα στοιχεια του Παραστατικού
 * @param array  - $tbl_data
 * @param string - $tbl
 */
function invoices_update_invoice_transactions($tbl_data=array(), $tbl='a55'){

	$query  = 'select * from t01 where p302=:p302 and p303="9"';
	$values = array('p302'=>$tbl_data['nr01']);

	$result  = pegasus_query($query, $values);
	$t01_arr = pegasus_fetchall($result);

	if($tbl=='a55'){
		pegasus_mysql_use("select * from a01 where nr01=?", $a00a01, array($tbl_data['p03']));
		pegasus_mysql_use('SELECT * FROM a10 WHERE p01 = ?', $a10, array($tbl_data['p05']));
	}elseif($tbl=='a56'){
		pegasus_mysql_use("select * from a00 where nr01=?", $a00a01, array($tbl_data['p03']));
		pegasus_mysql_use('SELECT * FROM a11 WHERE p01 = ?', $a10, array($tbl_data['p05']));
	}

	$tbl_data['pn02'] = (!empty($tbl_data['pn02'])) ? $tbl_data['pn02'] : 1;
	$p_asyn			  = 1;

	foreach ($t01_arr as $t01) {

		$arr1 = array();            $arr2 = array();

		array_push($arr1, 'p01');   array_push($arr2, $a00a01['p21']);
		array_push($arr1, 'pn01');  array_push($arr2, $tbl_data['pn01']);
		array_push($arr1, 'pn02');  array_push($arr2, $tbl_data['pn02']);
		array_push($arr1, 'p09');   array_push($arr2, $tbl_data['p0121']);
		array_push($arr1, 'p900');  array_push($arr2, $tbl_data['p04']);
		
		array_push($arr1, 'p503');  array_push($arr2, $tbl_data['p503']);
		array_push($arr1, 'p504');  array_push($arr2, $tbl_data['p504']);
		array_push($arr1, 'p401');  array_push($arr2, $tbl_data['p016']);

		array_push($arr1, 'p06');   array_push($arr2, $a10['p00'] . ' ' . $tbl_data['p701'] . ' ' . $tbl_data['p06']);

		array_push($arr1, 'pn03');  array_push($arr2, $t01['p03'] * $p_asyn * $tbl_data['pn02']);
		array_push($arr1, 'pn04');  array_push($arr2, $t01['p04'] * $p_asyn * $tbl_data['pn02']);

		pegasus_mysql_update('t01', $arr1, $arr2, 'nr01=:nr01', 0, 1, 1, array('nr01'=>$t01['nr01']));
	} 
}

/**
 * Υπολογίζει και επιστρέφει το ανείσπρακτο ποσό του παραστατικού 
 * με βάση τις Κινήσεις που αφορούν αυτό και έχουν ΚΚ Κίνησης = 9
 * @param int - $a55nr01 - ΜΚ Παραστατικού
 * @param string - $mode
 */
function invoices_calc_a55_aneisprakto($a55nr01, $mode, $get_totals_from_global_var = true, $calc_hota17 = false) {
	$p303_in = '"2", "4", "9"';
	if($get_totals_from_global_var) {
		$a55p05 = pegasusGetGlobalVar('peg_a55_d-' . $a55nr01 . '_p05');
		$totals = invoices_get_total_var($mode, $a55nr01);
		// Στοιχεία Ορισμού Παραστατικού
		pegasus_mysql_use('SELECT * FROM a10 WHERE p01 = ?', $a10, array($a55p05));
		$p_kklo = $a10['p04']; // Κωδικός Κίνησης Λογιστηρίου
	
		// Στοιχεία Κωδικού Κίνησης Λογιστηρίου (του επιλεγμένου παραστατικού)
		pegasus_mysql_use('SELECT * FROM t02 WHERE p01 = ? ', $t02, array($p_kklo));
		$p_kkxr = $t02['p03']; // Συντελεστής Χρέωσης
		$p_kkpi = $t02['p04']; // Συντελεστής Πίστωσης
	
		$p_asyn = 1; // Λογικά εδώ πάντα θα είναι 1, γίνεται -1 όταν αφορά ακύρωση.
		
		$pn02 = 1; // Ισοτιμία
		if(isset($totals['pn02']) && $totals['pn02'] > 0) {
			$pn02 = $totals['pn02'];
		}
		// Σύνολο Παραστατικού
		$total = ($totals['p0109'] * $p_asyn * $p_kkxr / $pn02) - ($totals['p0109'] * $p_asyn * $p_kkpi / $pn02);
		$p303_in = '"4", "9"';
	}

	pegasus_mysql_use(
		'   SELECT 
				sum(p03) AS xreosi, 
				sum(p04) AS pistosi 
			FROM t01 
			WHERE 
				p302=:a55nr01 AND p303 in ('.$p303_in.')', 
		$t01_sum, 
		array('a55nr01' => $a55nr01)
	);
    // Σύνολα Χρεώσεων και Πιστώσεων για αυτό το ΜΚ Σχετικής Κίνησης

    $t01_total = 0;

    if(!empty($t01_sum['xreosi']) || !empty($t01_sum['pistosi'])) {
        // Χρεώσεις μείον Πιστώσεις
        $t01_total = ($t01_sum['xreosi']) - ($t01_sum['pistosi'] );
    }
	// echo '<pre>t01_total: ' .$t01_total. '</pre>';
	if(pegasus_module_exists('account01')) {
		$t38_main = pegasus_mysql_printfld('t01', 'nr01', 'p302 = ? AND p303 = 2', array($a55nr01));
		if(!empty($t38_main)) {
			pegasus_mysql_use(
				'	SELECT
						sum(p03) AS t38_xreosi,
						sum(p04) AS t38_pistosi
					FROM t38
					WHERE
						p01 = :t38_main ',
				$t38_sum,
				array('t38_main' => $t38_main)
			);
		}
		if(!empty($t38_sum['t38_xreosi']) || !empty($t38_sum['t38_pistosi'])) {
			// Χρεώσεις μείον Πιστώσεις
			$t38_total = ($t38_sum['t38_xreosi']) - ($t38_sum['t38_pistosi'] );
			$t01_total = $t01_total + $t38_total;
		}
	}

	//Έλεγχος για κινήσεις Λοιπών Χρέωσεων - Πιστώσεων Διαμονής
	if(pegasus_module_exists('hot005') && $calc_hota17 === true) {
		pegasus_mysql_use(
			'	SELECT
					sum(p04) AS xreosi,
					sum(p05) AS pistosi
				FROM hota17
				WHERE pd101="a55" and pd102=:a55nr01',
			$hota17_sum,
			array('a55nr01' => $a55nr01)
		);

		if(!empty($hota17_sum['xreosi']) || !empty($hota17_sum['pistosi'])) {
			// Χρεώσεις μείον Πιστώσεις
			$hota17_total = ($hota17_sum['xreosi']) - ($hota17_sum['pistosi']);
			$t01_total = $t01_total - $hota17_total;
		}
	}

	// Είχα μια περίεργη ασυμφωνία που στο echo έφερνε σωστά το ποσό με 2 δεκαδικά 25.3, ενώ στο json_encode εφερνε 25.29999997
	// Του βάζω round σε 2 δεκαδικά, πάντα σε σύνολο αναφέρεται όπως και να'χει.
    $aneisprakto = round(abs($total + $t01_total), 2);

    return $aneisprakto;
}
/**
 * Έλεγχος στην γραμμή είδους παραστατικού (a55/ i01) η παραγγελίας (a57 / a58), αν η τιμή 
 * είναι μικρότερη από την κατώτερη τιμή πώλησης.
 * Ο έλεγχος εκτελείτε αν ο τύπος παραστατικού δεν έχει μηδενικές τιμές και αν το παραστατικό 
 * δεν ακυρώνει κάποιο παραστατικό αλλά και αν ειναι ενεργό το  (Οι τιμές πώλησης δεν μπορεί 
 * να είναι μικρότερες από την κατώτερη) f02.p615.
 * 
 * @param  string $mode
 * @param  array  $data
 * @param  array  $permDeny
 * @param  string $mmnr01
 * @return array $permDeny
 */
function invoices_check_min_price(
	$mode = '',
	$data = array(),
	$permDeny = array(),
	$mmnr01 = ''
) {
	$_d = explode('-', $mmnr01)[0];
	$nr01 = explode('-', $mmnr01)[1];
	$p05_table = false;
	$axx_table = false;
	switch ($_d) {
		case 'a55_d':
			$p05_table = 'a55';
			$axx_table = 'a10';
			break;
		case 'a57_d':
			$p05_table = 'a57';
			$axx_table = 'a10';
			break;
		default:
			return $permDeny;
	}
	// Τύπος παραστατικού
	$axx_p01 = pegasusGetGlobalVar('peg_' . $p05_table . '_d-' . $nr01 . '_p05');
	/**
	 * Αν πρόκειται για παραστατικό πελάτη και η γραμμή η έχει συντελεστή (p012) άκυρα (-1) τότε δεν κάνουμε έλεγχο 
	 * για αυτήν την γραμμή (ανήκει σε παραστατικό που ακυρώνει).
	 * 
	 */
	if(
		$p05_table == 'a55'
		&& $data['p012'] == -1
	) {
		return $permDeny;
	}
	/**
	 * Αν ο τύπος παραστατικού έχει μηδενικές τιμές ειδών.
	 * Δεν κάνουμε κάποιο έλεγχο.
	 */
	if (pegasus_mysql_printfld($axx_table, "p107", "p01 = :p01", array('p01' => $axx_p01)) > 0) {
		return $permDeny;
	}
	/**
	 * Aν το παραστατικό ακυρώνει κάποιο άλλο.
	 * Δεν κάνουμε κάποιο έλεγχο.
	 */
	if (
		$p05_table == 'a55'
		&& pegasus_mysql_printfld($p05_table, "p414", "nr01 = :nr01", array('nr01' => $nr01)) > 0
	) {
		return $permDeny;
	}
	/**
	 * Για το a55 mode αν oι τιμές πώλησης δεν μπορει να είναι μικρότερες από την κατώτερη
	 */
	if ($mode == "a55" && $_SESSION['f02_p615'] == 1) {
		$i00_p614 = pegasus_mysql_printfld('i00', 'p614', 'pno = :pno', array('pno' => $data['p01']));
		$vat = pegasusGetGlobalVar('peg_' . $mmnr01 . '_p07');
		$vat_perc = $data['p08'];

		if (
			($vat == 0 && $_SESSION['f02_p06'] == 0)
			|| ($vat == 1 && $_SESSION['f02_p06'] == 1)
		) {
			$price = $data['p04'];
		} else if ($vat == 1 && $_SESSION['f02_p06'] == 0) {
			$price = $data['p04'] / ((100 + $vat_perc) / 100);
		} else {
			$ss_inventory_000_p07 = inventory_get_session_value('inventory_000_p07', 'f01', 'p07'); //Δεκαδικά τιμής μονάδας
			$price = round((float)$data['p04'] * (100 + $vat_perc) / 100, $ss_inventory_000_p07);
		}
		if ($price < $i00_p614) {
			$deny_type = (!pegasus_check_permission('invoices.check_min_price')) ? 'deny' : 'confirm';
			$msg = $_SESSION['peg_dic_invoices_invalid_min_price'];
			if ($deny_type == 'confirm') {
				$msg = $_SESSION['peg_dic_invoices_invalid_min_price_confirm'];
			}
			array_push($permDeny, array('type' => $deny_type, 'message' => str_replace('##i01_nr01##', $data['nr01'], str_replace('##eidos##', $data['p01'] . ' ' . $data['p02'], $msg))));
		}
	}
	/**
	 * Για το a57 mode αν oι τιμές πώλησης δεν μπορει να είναι μικρότερες από την κατώτερη
	 */
	if ($mode == "a57" && $_SESSION['f02_p615'] == 1) {
		$i00_p614 = pegasus_mysql_printfld('i00', 'p614', 'pno = :pno', array('pno' => $data['v101']));
		// check αν οι τιμες ειναι με ΦΠΑ
		$a57_p07 = pegasusGetGlobalVar('peg_' . $mmnr01 . '_p07');
		if (
			($a57_p07 == 0 && $_SESSION['f02_p06'] == 0)
			|| ($a57_p07 == 1 && $_SESSION['f02_p06'] == 1)
		) {
			$price = $data['v104'];
		} elseif (
			$a57_p07 == 1
			&& $_SESSION['f02_p06'] == 0
		) {
			$price = $data['v104'] / ((100 + $data['v105']) / 100);
		} else {
			$ss_inventory_000_p07 = inventory_get_session_value('inventory_000_p07', 'f01', 'p07'); //Δεκαδικά τιμής μονάδας
			$price = round($data['v104'] * (100 + $data['v105']) / 100, $ss_inventory_000_p07);
		}
		if ($price < $i00_p614) {
			$deny_type = (!pegasus_check_permission('invoices.check_min_price')) ? 'deny' : 'confirm';
			$msg = $_SESSION['peg_dic_invoices_invalid_min_price'];
			if ($deny_type == 'confirm') {
				$msg = $_SESSION['peg_dic_invoices_invalid_min_price_confirm'];
			}
			$msg = str_replace(
				array(
					'##i01_nr01##',
					'##eidos##'
				),
				array(
					$data['nr01'],
					"{$data['v101']} {$data['v102']}"
				),
				$msg
			);
			array_push($permDeny, array('type'    => $deny_type, 'message' => $msg));
		}
	}
	return $permDeny;
}

function invoices_set_p015_global_var($data, $mode) {
	if($mode != 'a55' && $mode != 'a56' && $mode != 'a57' && $mode != 'a67') {
		return;
	}else{
		if($mode == 'a55' || $mode == 'a57') {
			$tbl = 'a14';
			$tbl_2 = 'a10';
			$fld_1 = 'p03';
			$fld_2 = 'p04';
		}elseif ($mode == 'a56' || $mode == 'a67') {
			$tbl = 'a15';
			$tbl_2 = 'a11';
			$fld_1 = 'p04';
			$fld_2 = 'p03';
		}
	}

	if (!empty($data['p05'])) {
        $kklo_p05 = pegasus_mysql_printfld($tbl_2, 'p04', 'p01 = :a55p05', array('a55p05' => $data['p05']));
        $kkxr_p05 = pegasus_mysql_printfld('t02', $fld_1, 'p01 = :kklo_p05', array('kklo_p05' => $kklo_p05));

		$p02_in = array();
		$a14_where_sql = '';

        if($kkxr_p05 > 0) {
            $query = "SELECT GROUP_CONCAT(p01 SEPARATOR ',') AS p02_in FROM t02 WHERE ".$fld_2." > 0";
            pegasus_mysql_use($query, $val);
            $p02_in_arr = explode(',' , $val['p02_in']);
            

            $p02_in      = pegasus_mysql_create_in($p02_in_arr, 'p02');
            $all_params  = $p02_in['sqlParams'];
            $a14_where_sql = "(".$tbl.".p02 IN (" . $p02_in['sql'] . ")";
        }elseif($kkxr_p05 < 0) {
            $query = "SELECT GROUP_CONCAT(p01 SEPARATOR ',') AS p02_in FROM t02 WHERE ".$fld_2." < 0";
            pegasus_mysql_use($query, $val);
            $p02_in_arr = explode(',' , $val['p02_in']);

            $p02_in      = pegasus_mysql_create_in($p02_in_arr, 'p02');
            $all_params = $p02_in['sqlParams'];
            $a14_where_sql = "(".$tbl.".p02 IN (" . $p02_in['sql'] . ")";
        }
        
		$pos00_join = "";
		$pos00_where = "";
		//* Αν έχει module POS, εξαιρώ από αυτό το IN τους Τρ. Είσπραξης χωρίς ΚΚ. Λογιστηρίου με σύνδεση σε Ρυθμίσεις POS.
		if(($mode == 'a55') && pegasus_module_exists('pos00')) {
			$pos00_join = " LEFT JOIN pos00_02 ON pos00_02.a14 = a14.nr01 ";
			$pos00_where = " pos00_02.a14 IS NULL AND ";
		}
		//* Φέρνω τους τρ. είσπραξης με κενό ΚΚ. Λογιστηρίου.
		$query_3 = "SELECT 
						GROUP_CONCAT(".$tbl.".nr01 SEPARATOR ',') AS a14_nr01_in
					FROM ".$tbl."
					".$pos00_join."
					WHERE 
						( ".$pos00_where." ".$tbl.".p02 = 0)";
		if($data['p015'] > 0) {
			$query_3 .= " OR ".$tbl.".nr01 = :data_p015 ";
			pegasus_mysql_use($query_3, $val_3, array("data_p015" => $data['p015']));
		}else{
			pegasus_mysql_use($query_3, $val_3);
		}
		
		$a14_nr01_in_arr = explode(',', $val_3['a14_nr01_in']);

		$a14_nr01_in = pegasus_mysql_create_in($a14_nr01_in_arr, 'a14_nr01');
		if(isset($p02_in['sqlParams'])) {
			$all_params = array_merge($p02_in['sqlParams'], $a14_nr01_in['sqlParams']);
		}else{
			$all_params = array_merge($a14_nr01_in['sqlParams']);
		}

		if(!empty($a14_where_sql)) {
			$a14_where_sql .= " OR ";
		}
		$a14_where_sql .= " ".$tbl.".nr01 IN (" . $a14_nr01_in['sql'] . ")";
        //* όλα τα προηγούμενα ΚΑΙ Διαδοχή >= 0 
		if(!empty($a14_where_sql)) {
			if(!empty($p02_in)) {
				$a14_where_sql .= " ) ";
			}
			$a14_where_sql .= " AND ";
		}

		if($data['p015'] > 0) {
			$a14_where_sql .= " ((".$tbl.".nr01 = :data_p015 OR ".$tbl.".p100 >= 0) OR ".$tbl.".nr01 = '0')";
			$all_params['data_p015'] = $data['p015'];
		}else{
			$a14_where_sql .= " ".$tbl.".p100 >= 0 ";
		}
		// echo '<pre>' .$a14_where_sql. '</pre>';
		// echo '<pre>' .print_r($all_params, 1). '</pre>';
        // echo '<pre>' . pegasus_replace_values_in_sql($a14_where_sql, $all_params) . '</pre>';

		pegasusSetGlobalVar(
            'peg_'. $data['nr01'] . '_' . $mode . '_p015_where',
            array(	'sql'		=> $a14_where_sql,
                    'sqlParams'	=> $all_params
            )
        );
	}
}

//p03: Ποσότητα: μπορεί να επιρεάσει την Τιμή Μονάδας, την %Εκπτωση 1 και το σύνολο
//p030: Δευτερεύουσα Ποσότητα: μπορεί να επιρεάσει την Τιμή Μονάδας, την %Εκπτωση 1 και το σύνολο
//p301: Τεμάχια: μπορεί να επιρεάσει την ποσότητα και το σύνολο
//p302: Μήκος: μπορεί να επιρεάσει ποσότητα και το σύνολο
//p303: Πλάτος: μπορεί να επιρεάσει ποσότητα και το σύνολο
//p304: Ύψος: μπορεί να επιρεάσει ποσότητα και το σύνολο
//p306: Μικτό Βάρος: μπορεί να επιρεάσει ποσότητα και το σύνολο
//p307: Αλλαγή Τελικής Ποσότητας: μπορεί να επιρεάσει ποσότητα και το σύνολο
//p309: Κόλλα: μπορεί να επιρεάσει το απόβαρο, την ποσότητα και το σύνολο
//p310: Απόβαρο: μπορεί να επιρεάσει ποσότητα και το σύνολο
//p030_1: Ποσότητα Συσκευασίας: μπορεί να επιρεάσει το σύνολο, την Τιμή Μονάδας και την Τιμή Συσκευασίας
//p04_1: Tιμη μοναδας Συσκευασίας: μπορεί να επιρεάσει το σύνολο και την Τιμή Μονάδας
//p04: Τιμή Μονάδας: μπορεί να επιρεάσει το σύνολο
//p010: Έκπτωση 1: μπορεί να επιρεάσει το σύνολο
//p010a: Έκπτωση 2: μπορεί να επιρεάσει το σύνολο
//p041: Εισφορά Ανακύκλωσης: μπορεί να επιρεάσει το σύνολο
//p616: Ε.Φ.Κ.: μπορεί να επιρεάσει το σύνολο
//p042: Επιπλέον Αξία: μπορεί να επιρεάσει το σύνολο
//p081: Κωδικός Κατηγορίας ΦΠΑ: μπορεί να επιρεάσει το %ΦΠΑ
function invoice_check_n_calculate_data_on_gridedit($mode, $data, $permDeny, $context_field, $p07, $p05, $p03, $date, $kath_fpa, $originalValue, $changed_value, $ser = "", $v172 = "", $v173 = "", $v161 = "") {
    if($mode == "a55" || $mode == "a56" || $mode == "a60") {
        $p01     = $data['p01'];
		$p01_fld = "p01";
		$p030_1  = $data['p030_1'];
		$p06     = $data['p06'];
		$p041    = $data['p041'];
		$p616    = $data['p616'];
		$p08     = $data['p08'];
		$p010    = 1;
		$kinisi_tbl = "i01";
    } else if($mode == "a57" || $mode == "a67" || $mode == "a61") {
        $p01     = $data['v101'];
		$p01_fld = "v101";
		$p030_1  = $data['v1030_1'];
		$p06     = $data['p00'];
    }

	if($mode == "a57") {
		$p010 = 2;
		$kinisi_tbl = "a58";
		$p041 = $data['v1041'];
		$p616 = $data['v616'];
		$p08  = $data['v105'];
	} else if($mode == "a67") {
		$p010 = 3;
		$kinisi_tbl = "a68";
	} else if($mode == "a61") {
		$p010 = 4;
		$kinisi_tbl = "a62";
	}

	$params_arr = array();

	$params_arr['mode']          	 = $mode;
	$params_arr[$mode.'_nr01']   	 = $p06;
	$params_arr[$kinisi_tbl.'_nr01'] = $data['nr01'];
	$params_arr[$mode.'_p03']    	 = $p03;
	$params_arr[$mode.'_p07']    	 = $p07;
	$params_arr['date']          	 = $date;
	$params_arr['kath_fpa']      	 = $kath_fpa;

    $query_i00 = "SELECT i00.p200, i00.p201, i00.ps01, i00.ths FROM i00 WHERE pno = :p01";
    pegasus_mysql_use($query_i00, $res_i00, array("p01"=>$p01));

	$query_i24 = "SELECT i24.p101, i24.p102, i24.p103, i24.p104, i24.p106, i24.p107, i24.p108, i24.p109, i24.p110 FROM i24 WHERE p01 = :v_ths";
	pegasus_mysql_use($query_i24, $res_i24, array("v_ths"=>$res_i00['ths']));

	/* Έλεγχοι που γίνονται από τις βασικές παραμέτρους παραγγελιών-παραστατικών */
	//Τιμή Μονάδας
	if(
		($context_field == "p04" || $context_field == "v104") &&
		(
			(
				($_SESSION['f02_pg02'] == 0) && ($mode == "a55" || $mode == "a57")
			) ||
			(
				($_SESSION['f02_apg02'] == 0) && ($mode == "a56" || $mode == "a67")
			)
		)
	) {
		array_push($permDeny, array('type' => 'deny', 'message' => str_replace(array('#monades#'), array($_SESSION['peg_dic_invoices_unit_price']), $_SESSION['peg_dic_invoices_basic_params_not_allowed'])));

		return array("data"=>$data, "permDeny"=>$permDeny);
	}

	//Έκπτωση 1
	if(
		($context_field == "p010" || $context_field == "v106") &&
		(
			(
				($_SESSION['f02_pg03'] == 0) && ($mode == "a55" || $mode == "a57")
			) ||
			(
				($_SESSION['f02_apg03'] == 0) && ($mode == "a56" || $mode == "a67")
			)
		)
	) {
		array_push($permDeny, array('type' => 'deny', 'message' => str_replace(array('#monades#'), array("% ".$_SESSION['peg_dic_invoices_discount']." 1"), $_SESSION['peg_dic_invoices_basic_params_not_allowed'])));

		return array("data"=>$data, "permDeny"=>$permDeny);
	}

	//Έκπτωση 2
	if(
		($context_field == "p010a" || $context_field == "v106a") &&
		(
			(
				($_SESSION['f02_pg033'] == 0) && ($mode == "a55" || $mode == "a57")
			) ||
			(
				($_SESSION['f02_apg033'] == 0) && ($mode == "a56" || $mode == "a67")
			)
		)
	) {
		array_push($permDeny, array('type' => 'deny', 'message' => str_replace(array('#monades#'), array("% ".$_SESSION['peg_dic_invoices_discount']." 2"), $_SESSION['peg_dic_invoices_basic_params_not_allowed'])));

		return array("data"=>$data, "permDeny"=>$permDeny);
	}

	//Εισφορά Ανακύκλωσης
	if(
		($context_field == "p041" || $context_field == "v1041") &&
		(
			(
				($_SESSION['f02_pg030'] == 0) && ($mode == "a55" || $mode == "a57")
			) ||
			(
				($_SESSION['f02_apg030'] == 0) && ($mode == "a56" || $mode == "a67")
			)
		)
	) {
		array_push($permDeny, array('type' => 'deny', 'message' => str_replace(array('#monades#'), array($_SESSION['peg_dic_invoices_e_waste_recycling_fee']), $_SESSION['peg_dic_invoices_basic_params_not_allowed'])));

		return array("data"=>$data, "permDeny"=>$permDeny);
	}

	//Ε.Φ.Κ.
	if(
		($context_field == "p616" || $context_field == "v616") &&
		(
			(
				($_SESSION['f02_pg032'] == 0) && ($mode == "a55" || $mode == "a57")
			) ||
			(
				($_SESSION['f02_apg032'] == 0) && ($mode == "a56" || $mode == "a67")
			)
		)
	) {
		array_push($permDeny, array('type' => 'deny', 'message' => str_replace(array('#monades#'), array($_SESSION['peg_dic_invoices_efk']), $_SESSION['peg_dic_invoices_basic_params_not_allowed'])));

		return array("data"=>$data, "permDeny"=>$permDeny);
	}

	//Αιτιολογία είδους
	if(
		($context_field == "p0601" || $context_field == "v160") &&
		(
			(
				($_SESSION['f02_pg031'] == 0) && ($mode == "a55" || $mode == "a57")
			) ||
			(
				($_SESSION['f02_apg031'] == 0) && ($mode == "a56" || $mode == "a67")
			)
		)
	) {
		array_push($permDeny, array('type' => 'deny', 'message' => str_replace(array('#monades#'), array($_SESSION['peg_dic_invoices_reason']), $_SESSION['peg_dic_invoices_basic_params_not_allowed'])));

		return array("data"=>$data, "permDeny"=>$permDeny);
	}

	//Επιτρέπεται Διαφορετική Αποθήκη ανά Είδος
	if(
		($context_field == "p610" || $context_field == "p703") && $_SESSION['f02_p633'] == 0
	) {
		array_push($permDeny, array('type' => 'deny', 'message' => str_replace(array('#monades#'), array($_SESSION['peg_dic_invoices_warehouse']), $_SESSION['peg_dic_invoices_basic_params_not_allowed'])));

		return array("data"=>$data, "permDeny"=>$permDeny);
	}

	//Επιπλέον Αξία Στα Είδη
	if(
		($context_field == "p042" || $context_field == "v1042") &&
		(
			(
				($_SESSION['f02_pg034'] == 0) && ($mode == "a55" || $mode == "a57")
			) ||
			(
				($_SESSION['f02_apg034'] == 0) && ($mode == "a56" || $mode == "a67")
			)
		)
	) {
		array_push($permDeny, array('type' => 'deny', 'message' => str_replace(array('#monades#'), array($_SESSION['peg_dic_invoices_additional_value']), $_SESSION['peg_dic_invoices_basic_params_not_allowed'])));

		return array("data"=>$data, "permDeny"=>$permDeny);
	}

	//Κωδικός Κατηγορίας ΦΠΑ
	if(
		($context_field == "p081" || $context_field == "v108") &&
		(
			(
				($_SESSION['f02_pweb01'] == 0) && ($mode == "a55" || $mode == "a57")
			) ||
			(
				($_SESSION['f02_pweb02'] == 0) && ($mode == "a56" || $mode == "a67")
			)
		)
	){
		array_push($permDeny, array('type' => 'deny', 'message' => str_replace(array('#monades#'), array($_SESSION['peg_dic_invoices_vat_category']), $_SESSION['peg_dic_invoices_basic_params_not_allowed'])));

		return array("data"=>$data, "permDeny"=>$permDeny);
	}

    if( in_array($context_field, array("p03",  "p030", "p301", "p302", "p303", "p304", "p306", "p307", "p308", "p309", "p310", "p030_1" , "p04_1" )) ||
        in_array($context_field, array("v103", "v120", "v301", "v302", "v303", "v304", "v306", "v307", "v308", "v309", "v310", "v1030_1", "v104_1"))
	) {
		if($originalValue == $changed_value) {
			return array('data' => $data , 'permDeny' => $permDeny);
		}

        $called_from = '';

        //Aν εχει αλλαξει το πεδιο της ποσόσοτητας
        if(in_array($context_field , array("p03", "v103"))) {
            if(peg_invoices_v_ths_readonly($p01) == 1) {
                array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_invoices_edit_ths_deny']));

                return array("data"=>$data, "permDeny"=>$permDeny);
            }

            $called_from = 'quantity_change';
        }

        //Aν εχει αλλαξει το πεδιο της δευτερευουσας ποόσοτητας
        if(in_array($context_field , array("p030", "v120"))) { 
			if($res_i00['p200']=='') {
                array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_invoices_no_permit_secondary_measuring_unit']));

                return array("data"=>$data, "permDeny"=>$permDeny);
			}

            // if(peg_invoices_v_ths_readonly($p01) == 1 ) {
            //     array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_invoices_edit_ths_deny']));

            //     return array("data"=>$data, "permDeny"=>$permDeny);
            // }
			$called_from = 'quantity_change';
        }
		
		//Αν έχουν αλλάξει τα πεδία των ΜΜ βγάζουμε τα κατάλληλα μηνύματα λάθος σε κάθε ΜΜ που δεν είναι επιλεγμένο από τις βασικες μοναδες μετρησης
		if(in_array($context_field , array("p301", "p302", "p303", "p304", "p306", "p307", "p308", "p309", "p310")) ||
		   in_array($context_field , array("v301", "v302", "v303", "v304", "v306", "v307", "v308", "v309", "v310"))
		) {
			if($res_i24['p101'] != 1 && ($context_field == "p301" || $context_field == "v301")) {
				array_push($permDeny, array('type' => 'deny', 'message' => str_replace(array('#monades#'), array($_SESSION['peg_dic_invoices_pieces']), $_SESSION['peg_dic_invoices_main_unit_not_changed'])));

				return array("data"=>$data, "permDeny"=>$permDeny);
			}

			if($res_i24['p102'] != 1 && ($context_field == "p302" || $context_field == "v302")) {
				array_push($permDeny, array('type' => 'deny', 'message' => str_replace(array('#monades#'), array($_SESSION['peg_dic_invoices_length']), $_SESSION['peg_dic_invoices_main_unit_not_changed'])));

				return array("data"=>$data, "permDeny"=>$permDeny);
			}

			if($res_i24['p103'] != 1 && ($context_field == "p303" || $context_field == "v303")) {
				array_push($permDeny, array('type' => 'deny', 'message' => str_replace(array('#monades#'), array($_SESSION['peg_dic_invoices_width']), $_SESSION['peg_dic_invoices_main_unit_not_changed'])));

				return array("data"=>$data, "permDeny"=>$permDeny);
			}

			if($res_i24['p104'] != 1 && ($context_field == "p304" || $context_field == "v304")) {
				array_push($permDeny, array('type' => 'deny', 'message' => str_replace(array('#monades#'), array($_SESSION['peg_dic_invoices_height']), $_SESSION['peg_dic_invoices_main_unit_not_changed'])));

				return array("data"=>$data, "permDeny"=>$permDeny);
			}

			if($res_i24['p106'] != 1 && ($context_field == "p306" || $context_field == "v306")) {
				array_push($permDeny, array('type' => 'deny', 'message' => str_replace(array('#monades#'), array($_SESSION['peg_dic_invoices_gross_weight']), $_SESSION['peg_dic_invoices_main_unit_not_changed'])));

				return array("data"=>$data, "permDeny"=>$permDeny);
			}

			if($res_i24['p107'] != 1 && ($context_field == "p307" || $context_field == "v307")) {
				array_push($permDeny, array('type' => 'deny', 'message' => str_replace(array('#monades#'), array($_SESSION['peg_dic_invoices_total_quantity']), $_SESSION['peg_dic_invoices_main_unit_not_changed'])));

				return array("data"=>$data, "permDeny"=>$permDeny);
			}

			if($res_i24['p108'] != 1 && ($context_field == "p308" || $context_field == "v308")) {
				array_push($permDeny, array('type' => 'deny', 'message' => str_replace(array('#monades#'), array($_SESSION['peg_dic_invoices_packing_item']), $_SESSION['peg_dic_invoices_main_unit_not_changed'])));

				return array("data"=>$data, "permDeny"=>$permDeny);
			}

			if($res_i24['p109'] != 1 && ($context_field == "p309" || $context_field == "v309")) {
				array_push($permDeny, array('type' => 'deny', 'message' => str_replace(array('#monades#'), array($_SESSION['peg_dic_invoices_package']), $_SESSION['peg_dic_invoices_main_unit_not_changed'])));

				return array("data"=>$data, "permDeny"=>$permDeny);
			}

			if($res_i24['p110'] != 1 && ($context_field == "p310" || $context_field == "v310")) {
				array_push($permDeny, array('type' => 'deny', 'message' => str_replace(array('#monades#'), array($_SESSION['peg_dic_invoices_tare']), $_SESSION['peg_dic_invoices_main_unit_not_changed'])));

				return array("data"=>$data, "permDeny"=>$permDeny);
			}
		}

        $params_arr['called_from'] = $called_from;
    
        $params_arr = array_merge($params_arr, $data);
        
        $invoices_find_product_quantity_return_data = invoices_find_product_quantity($params_arr);
        // die(print_r($invoices_find_product_quantity_return_data));

        if(
			$invoices_find_product_quantity_return_data['v103_change'] == 1 && 
			(	// Αφαίρεσα την τιμή συσκευασίας στον έλεγχο "p04_1" , "v104_1"
				in_array($context_field, array("p03",  "p301", "p302", "p303", "p304", "p306", "p307", "p308", "p309", "p310", "p030_1" )) ||
				in_array($context_field, array("v103", "v301", "v302", "v303", "v304", "v306", "v307", "v308", "v309", "v310", "v1030_1"))
			)
		){
            array_push($permDeny, array('type' => 'deny', 'message' => $invoices_find_product_quantity_return_data['v103_change_message']));

            return array("data"=>$data, "permDeny"=>$permDeny);
        }
   
		if(in_array($context_field , array("p301", "p302", "p303", "p304", "p306", "p307", "p308", "p309", "p310", "p030", "p03")) && ($mode=='a55' || $mode=='a56' || $mode=='a60')) {
            $data['p03'] = $invoices_find_product_quantity_return_data['v103'];
        }

        if(in_array($context_field , array("v301", "v302", "v303", "v304", "v306", "v307", "v308", "v309", "v310", "v120", "v103")) && ($mode=='a57' || $mode=='a67' || $mode=='a61') ) {
            $data['v103'] = $invoices_find_product_quantity_return_data['v103'];
            $data['v107'] = $invoices_find_product_quantity_return_data['v107'];
        }

		//Αν έχει αλλάξει η Ποσότητα/Τιμή Συσκευασίας
		if(in_array($context_field, array("p030_1", "p04_1", "v1030_1", "v104_1"))) {
			if(!pegasus_module_exists("invspcodes")) {
				array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_invoices_no_invspcode_module']));

				return array("data"=>$data, "permDeny"=>$permDeny);
			}

			if($res_i24['p101'] != 1) {
				array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_invoices_no_pieces_selected']));

				return array("data"=>$data, "permDeny"=>$permDeny);
			}				
			
			if(in_array($context_field, array("p030_1", "p04_1"))) {
				if($data['p030_1'] == 0) {
					$data['p04_1'] = 0;
				}

				$data['p04'] = $invoices_find_product_quantity_return_data['v104'];
				$data['p03'] = $invoices_find_product_quantity_return_data['v103'];

				if(invoices_check_if_zero_prices($mode, $p06) == 1) {
					$data['p616']  = 0;
					$data['p04']   = 0;
					$data['p041']  = 0;
					$data['p042']  = 0;
					$data['p04_1'] = 0;
				}				
			}

			if(in_array($context_field, array("v1030_1", "v104_1"))) {
				if($data['v1030_1'] == 0) {
					$data['v104_1'] = 0;
				}

				$data['v104'] = $invoices_find_product_quantity_return_data['v104'];
				$data['v103'] = $invoices_find_product_quantity_return_data['v103'];
				$data['v107'] = $invoices_find_product_quantity_return_data['v107'];

				if(invoices_check_if_zero_prices($mode, $p06) == 1) {
					$data['v616']   = 0;
					$data['v104']   = 0;
					$data['v1041']  = 0;
					$data['v1042']  = 0;
					$data['v104_1'] = 0;
					$data['v107']   = 0;
				}		
			}
		}

        if(($mode == 'a57' || $mode == 'a67' || $mode == 'a61')) {
            if($invoices_find_product_quantity_return_data['v104_change'] == 1){
                $data['v104'] = $invoices_find_product_quantity_return_data['v104'];
            }

			if($invoices_find_product_quantity_return_data['v106_change'] == 1){
                $data['v106'] = $invoices_find_product_quantity_return_data['v106'];
                $data['v106a'] = $invoices_find_product_quantity_return_data['v106a'];
            }    
        } else if($mode == 'a55' || $mode == 'a56' || $mode == 'a60'){
            if($invoices_find_product_quantity_return_data['v104_change'] == 1){
                $data['p04'] = $invoices_find_product_quantity_return_data['v104'];
            }

            if($invoices_find_product_quantity_return_data['v106_change'] == 1){
                $data['p010'] = $invoices_find_product_quantity_return_data['v106'];
                $data['p010a'] = $invoices_find_product_quantity_return_data['v106a'];
            }        
        }		
    } 

	if(in_array($context_field, array("v_i01_p04_novat", "v_i01_p04_vat", "v_v104_novat", "v_v104_vat", "p04", "v104"))) {
		if($originalValue == $changed_value) {
			return array('data' => $data , 'permDeny' => $permDeny);
		}

		if($res_i24['p101'] == 1 && $p030_1 > 0) {
			$monades = "";
			if($context_field == "v_i01_p04_novat" || $context_field == "v_v104_novat") {
				$monades = $_SESSION['peg_dic_invoices_unit_price_no_vat'];
			} else if($context_field == "v_i01_p04_vat" || $context_field == "v_v104_vat") {
				$monades = $_SESSION['peg_dic_invoices_unit_price_with_vat'];
			} else if($context_field == "p04" || $context_field == "v104") {
				$monades = $_SESSION['peg_dic_invoices_unit_price'];
			}

			array_push($permDeny, array('type' => 'deny', 'message' => str_replace(array('#monades#'), array($monades), $_SESSION['peg_dic_invoices_main_unit_pieces'])));

			return array("data"=>$data, "permDeny"=>$permDeny);
		}

		if($context_field == "v_i01_p04_novat") {
			if($data['p09'] == 1) {
				$data['p04'] = $changed_value * ((100 + $data['p08']) / 100);
			} else {
				$data['p04'] = $changed_value;
			}
		}
		
		if($context_field == "v_i01_p04_vat") {
			if($data['p09'] == 1) {
				$data['p04'] = $changed_value;
			} else {
				$data['p04'] = $changed_value / ((100 + $data['p08']) / 100);
			}
		}

		if($context_field == "v_v104_novat") {
			if($p07 == 1) {
				$data['v104'] = $changed_value * ((100 + $data['v105']) / 100);
			} else {
				$data['v104'] = $changed_value;
			}

			$data['v107'] = invoices_make_product_total($data['v103'], $data['v104'], $p08 , $data['v106'], $data['v106a'], $data['v1041'], $data['v616'], $p07, $data['v1042']);
		}
		
		if($context_field == "v_v104_vat") {
			if($p07 == 1) {
				$data['v104'] = $changed_value;
			} else {
				$data['v104'] = $changed_value / ((100 + $data['v105']) / 100);
			}

			$data['v107'] = invoices_make_product_total($data['v103'], $data['v104'], $p08 , $data['v106'], $data['v106a'], $data['v1041'], $data['v616'], $p07, $data['v1042']);
		}		
	}

	if(in_array($context_field, array("v_v107_vat", "v_v107_novat"))) {
		if($context_field == "v_v107_vat") {
			if($p07 == 1) {
				$p041 = $p041 * (100 + $p08) / 100;
            	$p616 = $p616 * (100 + $p08) / 100;
				$v107 = $changed_value;
			} else {
				$v107 = $changed_value / ((100 + $p08) / 100);
			}
		}

		if($context_field == "v_v107_novat") {
			if($p07 == 1) {
				$p041 = $p041 * (100 + $p08) / 100;
            	$p616 = $p616 * (100 + $p08) / 100;
				$v107 = $changed_value * ((100 + $p08) / 100);
			} else {
				$v107 = $changed_value;
			}
		}

		if(in_array($mode, array("a55", "a56", "a60"))) {
			$data['p04'] = (
				(
					$v107 - ($p041 * $data['p03']) - ($p616 * $data['p03']) - $data['p042']
				) / 
				(
					$data['p03'] * 
					((100 - $data['p010']) / 100) * 
					((100 - $data['p010a']) / 100)
				)
			);	

			$data['p04'] = round($data['p04'], $_SESSION['inventory_000_p07']);

			$epanaupologismos_synolou = invoices_make_product_total($data['p03'], $data['p04'], $p08 , $data['p010'], $data['p010a'], $data['p041'], $data['p616'], $p07, $data['p042']);

			if(($v107 - $epanaupologismos_synolou) != 0) {
				$data['p042'] = $data['p042'] + ($v107 - $epanaupologismos_synolou);
			}
		} else if(in_array($mode, array("a57", "a67"))) {
			$data['v104'] = (
				(
					$v107 - ($p041 * $data['v103']) - ($p616 * $data['v103']) - $data['v1042']
				) / 
				(
					$data['v103'] * 
					((100 - $data['v106']) / 100) * 
					((100 - $data['v106a']) / 100)
				)
			);	

			$data['v104'] = round($data['v104'], $_SESSION['inventory_000_p07']);
			
			$epanaupologismos_synolou = invoices_make_product_total($data['v103'], $data['v104'], $p08 , $data['v106'], $data['v106a'], $data['v1041'], $data['v616'], $p07, $data['v1042']);

			if(($v107 - $epanaupologismos_synolou) != 0) {
				$data['v1042'] = $data['v1042'] + ($v107 - $epanaupologismos_synolou);
			}

			$data['v107'] = $v107;
		}
	}

    if(in_array($context_field, array("p04", "p010", "p010a", "p041", "p616", "p042"))) {
		if($originalValue == $changed_value) {
			return array('data' => $data , 'permDeny' => $permDeny);
		}
        $params_arr = array_merge($params_arr, $data);
        
        $invoices_find_product_quantity_return_data = invoices_find_product_quantity($params_arr);
		// die(print_r($invoices_find_product_quantity_return_data));

		$data['p03'] = $invoices_find_product_quantity_return_data['v103'];
        
		//Υπολογίζουμε πάλι το ΕΦΚ στην περίπτωση που έχει μόνο πόσοστο αν άλλαξαν οι τιμές    
        $data['p616'] =invoices_calculate_EFK($data['p01'], $data['p04'], $data['p010'], $data['p010a'], $data['p08'], $p07, $data['p616'], $data['p616p']);

        if(invoices_check_if_zero_prices($mode, $p06) == 1) {
            $data['p616']  = 0;
            $data['p04']   = 0;
			$data['p041']  = 0;
			$data['p042']  = 0;
			$data['p04_1'] = 0;
        }
    } else if(in_array($context_field , array("v104", "v106", "v106a", "v1041", "v616", "v1042"))) {
		if($originalValue == $changed_value) {
			return array('data' => $data , 'permDeny' => $permDeny);
		}

        $params_arr = array_merge($params_arr, $data);
        
        $invoices_find_product_quantity_return_data = invoices_find_product_quantity($params_arr);
		// die(print_r($invoices_find_product_quantity_return_data));
		
		$data['v103'] = $invoices_find_product_quantity_return_data['v103'];
        
		//Υπολογίζουμε πάλι το ΕΦΚ στην περίπτωση που έχει μόνο πόσοστο αν άλλαξαν οι τιμές   
        $data['v616'] =invoices_calculate_EFK($data['v101'], $data['v104'], $data['v106'], $data['v106a'], $data['v105'], $p07, $data['v616'], $data['p616p']);

        if(invoices_check_if_zero_prices($mode, $p06) == 1) {
            $data['v616']   = 0;
            $data['v104']   = 0;
			$data['v1041']  = 0;
			$data['v1042']  = 0;
			$data['v104_1'] = 0;
            $data['v107']   = 0;
        } else {
            $data['v107'] = invoices_make_product_total($data['v103'], $data['v104'], $data['v105'], $data['v106'], $data['v106a'], $data['v1041'], $data['v616'], $p07, $data['v1042']);
        }
    } 

	if(in_array($context_field, array("p081", "v108"))) {
		if($originalValue == $changed_value) {
			return array('data' => $data , 'permDeny' => $permDeny);
		}

		$p03 = pegasus_mysql_printfld("i13", "p03", "p01 = :changed_value", array("changed_value"=>$changed_value));

		if($context_field == "p081") {
			$data['p08']  = $p03;
		} else {
			$data['v105'] = $p03;
		}
	}

	$peg_mmnr01 = $mode.'_d-'.$p06;
	
	$query_where = "nr01        = :nr01        AND 
					peg_mnr01   = :peg_mnr01   AND 
					peg_mmnr01  = :peg_mmnr01  AND 
					peg_sess_id = :peg_sess_id AND 
					peg_flag   != 9";

	$query_params = array(
		'nr01'			=> $data['nr01'],
		'peg_mnr01'		=> $p06,
		'peg_mmnr01'	=> $peg_mmnr01,
		'peg_sess_id'	=> session_id()
	);

	$old_p01 =  pegasus_mysql_printfld("peg_tmp_".$kinisi_tbl, $p01_fld, $query_where, $query_params);

	if($p01 != $old_p01 || !empty($ser) || (!empty($v172) && !empty($v173)) || !empty($v161)) {
		//Delete όλα τα tmp σε serial, lot, color-size 
		invoices_delete_tmp_kinisi($peg_mmnr01, $p01, $mode, $data['nr01'], $p010);
	}

	if(pegasus_module_exists("colorsize") && !empty($v172) && !empty($v173)) {
		if($mode == "a55" || $mode == "a56" || $mode == "a60") {
			$i01p05 = 0;
			if($mode == "a60") {
				$peg_tmp_a60DataAr = pegasusGetGlobalVar('peg_a60_d-' .$p06.'_data');

				if(!empty($peg_tmp_a60DataAr['a30p04'])) {
					$i01p05 = $peg_tmp_a60DataAr['a30p04'];
				}
			}

			invoices_add_colorsize($peg_mmnr01, $mode, $data['nr01'], $p01, $v172, $v173, 1, $i01p05);
			$data['p03'] = 1;
		} else if($mode == "a57" || $mode == "a67" || $mode == "a61") {
			invoices_add_colorsize($peg_mmnr01, $mode, $data['nr01'], $p01, $v172, $v173, 1);
			$data['v103'] = 1;
		}	
	} else if(pegasus_module_exists("serial") && !empty($ser)) {
		invoices_add_serial($peg_mmnr01, $data['nr01'], $p01, $p010, $ser);

		if($mode == "a55" || $mode == "a56" || $mode == "a60") {
			$data['p03'] = 1;
		} else if($mode == "a57" || $mode == "a67" || $mode == "a61") {
			$data['v103'] = 1;
		}
	} else if(pegasus_module_exists("lot") && !empty($v161)) {
		invoices_add_lot($peg_mmnr01, $data['nr01'], $p010, $v161, 1, 1);

		if($mode == "a55" || $mode == "a56" || $mode == "a60") {
			$data['p03'] = 1;
		} else if($mode == "a57" || $mode == "a67" || $mode == "a61") {
			$data['v103'] = 1;
		}
	}

	if(
		in_array($context_field, array("v101")) && 
		(
			(!empty($v172) && !empty($v173)) || 
			!empty($ser) || 
			!empty($v161)
		)
	) {
		if(($mode == 'a57' || $mode == 'a67' || $mode == 'a61')) {
			$data['v107']  = invoices_make_product_total($data['v103'], $data['v104'], $data['v105'], $data['v106'], $data['v106a'], $data['v1041'], $data['v616'], $p07, $data['v1042']);
		}
	}

	$ret_arr = array();

    $ret_arr['data']     = $data;
    $ret_arr['permDeny'] = $permDeny;

    return $ret_arr;
}

function peg_invoices_i01_d310_initialize($data = array(), $mmnr01 = '', $mnr01 = '', $_d = '', $container_id = '') {

	// $data["{module}_{_d}_{tab name}_hidden_mobile"] 
    $data["invoices_i01_d310_bt_update_hidden_mobile"] = false;

	return $data;
}

/**
 * Αν χρειαστεί να προστεθεί αυτόματη καταχώρηση είδους από την find_product_data
 * σε παραστατικά κ.ο.κ με X-M, Serial ή Παρτίδα
 * θα πρέπει να μεταφέρουμε/τροποποιήσουμε την παρακάτω function από το retail στο invoices
 */
function invoice_after_find_save_product_data($result_arr, $mode_nr01, $mode, $v172 = '', $v173 = '', $v161 = '', $ser = '') {
    // Στο Retail το έχω πάντα κενό το i01_nr01 γιατί δεν μπορώ να κάνω αλλαγή είδους όπως στα παραστατικά.
    $update_i01_p03 = 0;
    // echo '<pre>' .print_r($result_arr, 1). '</pre>'; 

	$result_arr[$mode.'_show_price_window'] = 1;

	if($mode == "retail00_01") {
		$result_arr['retail00_show_price_window'] = 1;
		
		if(pegasus_module_exists('retail01')) {
			pegasus_mysql_use('SELECT nr01 FROM retail01_01 WHERE i00pno = :v101', $retail01_01, array("v101" => $result_arr['v101']));
		}

		// 25/01/2024 - Προσθεσαμε στο if αν έχει ποσότητα συσκευασίας να το βάζει πάντα σε νέα γραμμή
		// διότι δεν μπορούμε να ελέγξουμε με σιγουριά, από ποιον κωδικό ήρθε.
		// Προσθέσαμε και στο select να ψάχνει για ίδιο κωδικό ΚΑΙ ποσότητα συσκευασίας = 0
		// ώστε να μην πάει να προσθέσει στην ίδια γραμμή κάποιου καταχωρημένου είδους με ποσ. συσκευασίας.
		// -----
		// 14/03/2024 - Αν το είδος που προσθέτω το έχω αντιστοιχίσει σε Τμήμα Ταμειακής, τότε το προσθέτω πάντα σε νέα γραμμή
		if($_SESSION['retail00_00_p03'] == 0 && empty($result_arr['v1030_1']) && empty($retail01_01['nr01'])) {
			pegasus_mysql_use(
				'SELECT * FROM peg_tmp_i01 WHERE p01 = :v101 AND i18i01 = 0 AND p030_1 = 0 AND peg_sess_id = :peg_sess_id AND peg_mnr01 = :peg_mnr01 AND peg_mmnr01 = :peg_mmnr01 AND peg_flag <> 9', 
				$existing_record_i01, 
				array(
					"v101" => $result_arr['v101'],
					"peg_sess_id" => session_id(),
					"peg_mnr01" => $mode_nr01,
					"peg_mmnr01" => "a55_d-".$mode_nr01
				)
			);
		}

		//TODO: Το ifelse ίσως να μην έχει νόημα για retail, θα μπαίνει πάντα στο if
		if(empty($result_arr['i01_nr01'])) {
			//* Αν βρω ίδιο κωδικό στο καλάθι, σετάρω το $update_i01_p03 = 1 για να αυξήσω ποσότητα
			//* Συμφωνήσαμε ότι το μόνο που θα κοιτάμε είναι ο κωδικός
			if($existing_record_i01['nr01'] > 0) {
				$update_i01_p03 = 1;
				$kinisi_nr01 = $existing_record_i01['nr01'];
			}else{
				$kinisi_nr01 = pegasus_mysql_newrec('i01');
			}
		} else {
			$kinisi_nr01 = $result_arr['i01_nr01'];
		}
		
		$result_arr['i01_nr01'] = $kinisi_nr01;
		$p010 = 1;
		$peg_mmnr01 = 'a55_d-'.$mode_nr01;
	} else {
		$update_i01_p03 = 1;
		if($mode == "a55" || $mode == "a56" || $mode == "a60") {
			$kinisi_nr01 = $result_arr['i01_nr01'];
			$p010        = 1;
		} else if($mode == "a57") {
			$kinisi_nr01 = $result_arr['a58_nr01'];
			$p010        = 2;
		} else if($mode == "a67") {
			$kinisi_nr01 = $result_arr['a68_nr01'];
			$p010        = 3;
		} else if($mode == "a61") {
			$kinisi_nr01 = $result_arr['a62_nr01'];
			$p010        = 4;
		}

		$peg_mmnr01 = $mode.'_d-'.$mode_nr01;
	}

	$i40_nr01 = pegasus_mysql_printfld("i40", "nr01", "p01 = :v172", array("v172"=>$v172));
	$i43_nr01 = pegasus_mysql_printfld("i43", "nr01", "p01 = :v173", array("v173"=>$v173));

	// Για να καλύψουμε και την περίπτωση που κάποιος έχει σαν κωδικό χρώματος ή μεγέθους το 0 (μηδέν)
    if($i40_nr01 > 0 && $i43_nr01 > 0) { // Αν έχω χρώμα (v172) και μέγεθος (v173)
        $update_i48_p04 = 0;
        //* Μόνο αν έχω flag για αύξηση ποσότητας στο i01, ελέγχω αν το Χ-Μ υπάρχει στον i48 για να αυξήσω ποσότητα αν είναι ίδιο.
        if($update_i01_p03 == 1) {
            pegasus_mysql_use(
                'SELECT * FROM peg_tmp_i48 WHERE 
                    i01p01 = :v101 AND p02 = :v172 AND p03 = :v173
                    AND peg_sess_id = :peg_sess_id AND peg_mnr01 = :peg_mnr01 AND peg_mmnr01 = :peg_mmnr01 AND peg_flag <> 9', 
                $existing_record_i48, 
                array(
                    "v101" => $result_arr['v101'],
                    "v172" => $v172,
                    "v173" => $v173,
                    "peg_sess_id" => session_id(),
                    "peg_mnr01" => $kinisi_nr01,
                    "peg_mmnr01" => $peg_mmnr01
                )
            );
            //* Αν βρω ίδιο Χ-Μ στο καλάθι, σετάρω το $update_i48_p04 = 1 για να αυξήσω ποσότητα στον i48
            if($existing_record_i48['nr01'] > 0) {
                $update_i48_p04 = 1;
            }
        }

        if($update_i48_p04 == 1) {
            $new_i48_p04 = $existing_record_i48['p04'] + 1; //i01.p03
            $where = ' i01p01 = :v101 AND p02 = :v172 AND p03 = :v173 AND peg_sess_id = :peg_sess_id AND peg_mnr01 = :peg_mnr01 AND peg_mmnr01 = :peg_mmnr01 AND peg_flag <> 9 ';
            $whereValues = array(
                "v101" => $result_arr['v101'],
                "v172" => $v172,
                "v173" => $v173,
                "peg_sess_id" => session_id(),
                "peg_mnr01" => $kinisi_nr01,
                "peg_mmnr01" => $peg_mmnr01
            );
            pegasus_mysql_update('peg_tmp_i48', array('p04'), array($new_i48_p04), $where, 0, 1, 1, $whereValues);
        }else{
			invoices_add_colorsize($peg_mmnr01, $mode, $kinisi_nr01, $result_arr['v101'], $v172, $v173, 1);
        }
        //Αν έχω Χ-Μ, τότε το i01.v103 έχει έρθει 0. Εφόσον πρόσθεσα 1 στην κίνηση Χ-Μ, κάνω 1 το v103
        $result_arr['v103'] = 1;
    }elseif(!empty($ser)) { //Αν έχω Serial Number (ser)
		invoices_add_serial($peg_mmnr01, $kinisi_nr01, $result_arr['v101'], $p010, $ser);
		
		$result_arr['v103'] = 1;
    }elseif(!empty($v161)) { // Αν έχω Παρτίδα
        //* Ιδια λογικη Χ-Μ για την αυξηση ποσότητας
        //* Μόνο αν έχω flag για αύξηση ποσότητας στο i01, ελέγχω αν η παρτίδα υπάρχει στον i38 για να αυξήσω ποσότητα αν είναι ίδιο.
        $update_i38_p04 = 0;
        if($update_i01_p03 == 1) {
            pegasus_mysql_use(
                'SELECT * FROM peg_tmp_i38 WHERE 
                    p01 =:i01_nr01 AND p02 = :v161
                    AND peg_sess_id = :peg_sess_id AND peg_mnr01 = :peg_mnr01 AND peg_mmnr01 = :peg_mmnr01 AND peg_flag <> 9', 
                $existing_record_i38, 
                array(
                    "i01_nr01" => $kinisi_nr01,
                    "v161" => $v161,
                    "peg_sess_id" => session_id(),
                    "peg_mnr01" => $kinisi_nr01,
                    "peg_mmnr01" => $peg_mmnr01
                )
            );
            //* Αν βρω ίδια παρτίδα στο καλάθι, σετάρω το $update_i48_p04 = 1 για να αυξήσω ποσότητα στον i48
            if($existing_record_i38['nr01'] > 0) {
                $update_i38_p04 = 1;
            }
        }
        if($update_i38_p04 == 1) {
            $new_i38_p04 = $existing_record_i38['p04'] + 1; //i01.p03
            $where = ' p01 =:i01_nr01 AND p02 = :v161 AND peg_sess_id = :peg_sess_id AND peg_mnr01 = :peg_mnr01 AND peg_mmnr01 = :peg_mmnr01 AND peg_flag <> 9 ';
            $whereValues = array(
                "i01_nr01" => $kinisi_nr01,
                "v161" => $v161,
                "peg_sess_id" => session_id(),
                "peg_mnr01" => $kinisi_nr01,
                "peg_mmnr01" => $peg_mmnr01
            );
            pegasus_mysql_update('peg_tmp_i38', array('p04'), array($new_i38_p04), $where, 0, 1, 1, $whereValues);
        }else{
			invoices_add_lot($peg_mmnr01, $kinisi_nr01, $p010, $v161, 1, 1);
        }

        //Αν έχω v161, τότε το i01.v103 έχει έρθει 0. Εφόσον πρόσθεσα 1 στην κίνηση παρτίδας, κάνω 1 το v103
        $result_arr['v103'] = 1;
    }
	if($mode == "retail00_01") {
		if($update_i01_p03 == 1) {
			$new_i01_p03 = $existing_record_i01['p03'] + $result_arr['v103'];
			$where = ' nr01 = :nr01 AND p01 = :v101 AND peg_sess_id = :peg_sess_id AND peg_mnr01 = :peg_mnr01 AND peg_mmnr01 = :peg_mmnr01 AND peg_flag <> 9 ';
			$whereValues = array(
				// "nr01" => $existing_record_i01['nr01'], // Για να ενημερώσει μόνο την τρέχουσα αν εχει 2 εγγραφές στο καλάθι του
				"nr01" => $kinisi_nr01,
				"v101" => $result_arr['v101'],
				"peg_sess_id" => session_id(),
				"peg_mnr01" => $mode_nr01,
				"peg_mmnr01" => $peg_mmnr01
			);
			pegasus_mysql_update('peg_tmp_i01', array('p03'), array($new_i01_p03), $where, 0, 1, 1, $whereValues);

			$whereValues = array(
				"nr01"        => $kinisi_nr01,
				"p06"         => $mode_nr01,
				"peg_sess_id" => session_id(),
				"peg_mnr01"   => $mode_nr01,
				"peg_mmnr01"  => $peg_mmnr01
			);

			$cnt_i01_i18i01 = pegasus_mysql_printfld('peg_tmp_i01', 'count(*)', 'p06 = :p06 AND p07 = 2 AND peg_sess_id = :peg_sess_id AND peg_mnr01 = :peg_mnr01 AND peg_mmnr01 = :peg_mmnr01 AND peg_flag <> 9 AND i18i01 = :nr01', $whereValues);

			if($cnt_i01_i18i01 > 0) {
				invoices_execute_i18_update_item($mode, $kinisi_nr01, $mode_nr01, $new_i01_p03, $result_arr['i19p03']);
			}
		}else{
			$ret_array = array();
			$ret_array['a55nr01'] = $mode_nr01;
			$ret_array['i01nr01'] = $kinisi_nr01;

			$ret_array['p01']     = $result_arr['v101'];
			$ret_array['p02']     = $result_arr['v102'];
			$ret_array['p03']     = $result_arr['v103'];
			$ret_array['p04']     = round($result_arr['v104'], $_SESSION['inventory_000_p07']);
			$ret_array['p06']     = $mode_nr01;
			$ret_array['p07']     = 2;
			$ret_array['p08']     = $result_arr['fpa'];
			$ret_array['p09']     = $result_arr['i01_p09'];

			$ret_array['p301']    = $result_arr['v301'];
			$ret_array['p302']    = $result_arr['v302'];
			$ret_array['p303']    = $result_arr['v303'];
			$ret_array['p304']    = $result_arr['v304'];
			$ret_array['p306']    = $result_arr['v306'];
			$ret_array['p307']    = $result_arr['v307'];
			$ret_array['p308']    = $result_arr['v308'];
			$ret_array['p309']    = $result_arr['v309'];

			$ret_array['p010']    = $result_arr['v106'];
			$ret_array['p010a']   = $result_arr['v106a'];
			
			$ret_array['p013']    = date('Y-m-d');
			$ret_array['p013t']   = date('H:i:s');

			$ret_array['p030']    = $result_arr['v120'];
			$ret_array['p030_1']  = $result_arr['v1030_1'];
			$ret_array['p04_1']   = $result_arr['v104_1'];			
			$ret_array['p041']    = $result_arr['v1041'];
			$ret_array['p0601']   = $result_arr['v160'];

			$ret_array['p616']    = $result_arr['v616'];
			$ret_array['p616p']   = $result_arr['v616p'];
			$ret_array['p614']    = $result_arr['v614'];
			$ret_array['p081']    = $result_arr['kfpa'];

			$ret_array['timh1']   = $result_arr['timh1'];
			$ret_array['timh2']   = $result_arr['timh2'];
			$ret_array['timh3']   = $result_arr['timh3'];
			$ret_array['timh4']   = $result_arr['timh4'];

			$ret_array['v172']    = $v172;
			$ret_array['v173']    = $v173;

			retail00_update_i01($ret_array);

			//* Προσθέτω και τις σημειώσεις του είδους αν υπάρχουν
			if(!empty($result_arr['v_a90_p30'])) {
				$a90_nr01 = pegasus_mysql_newrec('a90');
				$arr1 = array();                            $arr2 = array();
				array_push($arr1, 'nr01');					array_push($arr2, $a90_nr01);
				array_push($arr1, 'p30');					array_push($arr2, $result_arr['v_a90_p30']);
				array_push($arr1, 'tbl');					array_push($arr2, 'i01');
				array_push($arr1, 'tbl_nr01');				array_push($arr2, $kinisi_nr01);
				array_push($arr1, 'peg_mmnr01');			array_push($arr2, $peg_mmnr01);
				array_push($arr1, 'peg_mnr01');			    array_push($arr2, $kinisi_nr01);
				array_push($arr1, 'peg_sess_id');			array_push($arr2, session_id());
				array_push($arr1, 'peg_flag');              array_push($arr2, 1);
		
				pegasus_mysql_insert('peg_tmp_a90', $arr1, $arr2);
			}

			$new_i01_p03 = $ret_array['p03'];
		}
		// Άν έχει απενεργοποιημένη "Προσθήκη είδους σε νέα γραμμή", επιστρέφει την τιμή που έχει δώσει ο χρήστης στο i01_nr01 -- αλλιώς θα είναι ίσο με την τιμή μονάδας.
		$result_arr['retail00_updated_p04'] = floatval(pegasus_mysql_printfld('peg_tmp_i01', 'p04', 'nr01 = :nr01', array('nr01' => $kinisi_nr01)));

		if(!empty($result_arr['item_search']) && $_SESSION['retail00_00_p07'] == 1 && ($new_i01_p03 == 1 || $new_i01_p03 == 0)) {
			// Εύρεση ποσοτικού barcode
			$barcode_array = invoices__invoices_online_value_barcode($result_arr['item_search']);
	
			if($barcode_array['data']['is_quantity_barcode']) {
				$result_arr['is_zero_quantity_barcode'] = 1;
			}
		}
	}
    //Στην περίπτωση που έχουμε ήδη προσθέσει το είδος οταν το ξαναεπιλέξουμε δεν θέλουμε να ανοιξει η οθονη τελευταίας τιμής πώλησης 
    //γι αυτό κανουμε return το flag retail00_i01_d2 = 0
    if($update_i01_p03 == 1) {
		if($mode == "retail00_01") {
        	$result_arr['retail00_show_price_window'] = 0;
		} else {
			$result_arr[$mode.'_show_price_window'] = 0;
		}
		
    }

    //* Εδώ θα βρω το stock_screen και θα έρθω να το γυρίσω σε μηνυμα για toast.

    return $result_arr;
}

function invoices_delete_tmp_kinisi($peg_mmnr01, $p01, $mode = "a55", $kinisi_nr01 = 0, $p010 = 1) {
	//SERIAL
	if(pegasus_module_exists("serial") && pegasus_mysql_table_exists("peg_tmp_i32")) {
		$query_where = "peg_tmp_i32.p010 		= :p010        AND
						peg_tmp_i32.p00  		= :p00         AND
						peg_tmp_i32.peg_mnr01   = :peg_mnr01   AND
						peg_tmp_i32.peg_mmnr01  = :peg_mmnr01  AND
						peg_tmp_i32.peg_sess_id = :peg_sess_id AND
						peg_tmp_i32.peg_flag   != 9";

		$query_params = array(
			'p010'			=> $p010,
			'p00'			=> $kinisi_nr01,
			'peg_mnr01'		=> $kinisi_nr01,
			'peg_mmnr01'	=> $peg_mmnr01,
			'peg_sess_id'	=> session_id()
		);

		pegasus_mysql_update('peg_tmp_i32', array('peg_flag'), array(9), $query_where, 0, 1, 1, $query_params);
	}

	//LOT
	if(pegasus_module_exists("lot") && pegasus_mysql_table_exists("peg_tmp_i38")) {
		$query_where = "peg_tmp_i38.p010 		= :p010        AND
						peg_tmp_i38.p01  		= :p01         AND
						peg_tmp_i38.peg_mnr01   = :peg_mnr01   AND
						peg_tmp_i38.peg_mmnr01  = :peg_mmnr01  AND
						peg_tmp_i38.peg_sess_id = :peg_sess_id AND
						peg_tmp_i38.peg_flag   != 9";

		$query_params = array(
			'p010'			=> $p010,
			'p01'			=> $kinisi_nr01,
			'peg_mnr01'		=> $kinisi_nr01,
			'peg_mmnr01'	=> $peg_mmnr01,
			'peg_sess_id'	=> session_id()
		);

		pegasus_mysql_update('peg_tmp_i38', array('peg_flag'), array(9), $query_where, 0, 1, 1, $query_params);
	}

	//COLOR-SIZE
	if(pegasus_module_exists("colorsize")) {
		if(
			($mode == "a55" || $mode == "a56" || $mode == "a60" || $mode == "retail00_01") && pegasus_mysql_table_exists("peg_tmp_i48") ||
			($mode == "a57" && pegasus_mysql_table_exists('peg_tmp_a59')) || 
			($mode == "a67" && pegasus_mysql_table_exists("peg_tmp_a69")) || 
			($mode == "a61" && pegasus_mysql_table_exists("peg_tmp_a63"))
		) {
			if($mode == "a55" || $mode == "a56" || $mode == "a60" || $mode == "retail00_01") {
				$peg_tmp_tbl = "peg_tmp_i48";
			} else if($mode == "a57") {
				$peg_tmp_tbl = "peg_tmp_a59";
			} else if($mode == "a67") {
				$peg_tmp_tbl = "peg_tmp_a69";
			} else if($mode == "a61") {
				$peg_tmp_tbl = "peg_tmp_a63";
			}

			$query_where = "$peg_tmp_tbl.p01  		 = :p01         AND
							$peg_tmp_tbl.peg_mnr01   = :peg_mnr01   AND
							$peg_tmp_tbl.peg_mmnr01  = :peg_mmnr01  AND
							$peg_tmp_tbl.peg_sess_id = :peg_sess_id AND
							$peg_tmp_tbl.peg_flag   != 9";

			$query_params = array(
				'p01'			=> $kinisi_nr01,
				'peg_mnr01'		=> $kinisi_nr01,
				'peg_mmnr01'	=> $peg_mmnr01,
				'peg_sess_id'	=> session_id()
			);

			pegasus_mysql_update($peg_tmp_tbl, array('peg_flag'), array(9), $query_where, 0, 1, 1, $query_params);
		}

		/*
			Για peg_tmp_a59, peg_tmp_a69, peg_tmp_a63 έπαιζε με τον παρακάτω τρόπο, αλλά δεν δούλευε σωστά και το έβαλα να τρέξει με την λογική του peg_tmp_i48 όπως φαίνεται παραπάνω
			// $query_peg_tmp_tbl = "UPDATE $peg_tmp_tbl
			// 						LEFT JOIN i47  ON 
			// 								i47.p02 = $peg_tmp_tbl.p02 AND
			// 								i47.p03 = $peg_tmp_tbl.p03 AND i47.p01= :i47_p01
			// 						LEFT JOIN i40 ON i47.p02 = i40.p01
			// 						LEFT JOIN i43 ON i47.p03 = i43.p01
			// 						SET peg_flag = 9
			// 						WHERE $peg_tmp_tbl.p01 = :tbl_p01 AND
			// 								((i47.nr01 IS NULL) || (i40.nr01 IS NULL) || (i43.nr01 IS NULL))";

			// $query_peg_tmp_tbl_params = array(
			// 	'i47_p01' => $p01,
			// 	'tbl_p01' => $kinisi_nr01
			// );

			// pegasus_query($query_peg_tmp_tbl, $query_peg_tmp_tbl_params);
		*/
	}
}

function invoices_add_serial($peg_mmnr01, $kinisi_nr01, $p01, $p010, $ser, $pnr01 = 0) {
	$i32_nr01 = pegasus_mysql_newrec('i32');

	$arr1 = array();					$arr2 = array();

	array_push($arr1, 'nr01'); 			array_push($arr2, $i32_nr01);     //Μ.Κ.
	array_push($arr1, 'p01');			array_push($arr2, $p01); 		  //Κωδικός Είδους
	array_push($arr1, 'p02');			array_push($arr2, $ser); 		  //Serial Number
	array_push($arr1, 'p00');			array_push($arr2, $kinisi_nr01);  //Μ.Κ. Σχετικής Κίνησης
	array_push($arr1, 'p010');			array_push($arr2, $p010);         //Κατηγορία Κίνησης
	array_push($arr1, 'pnr01');			array_push($arr2, $pnr01);        //Μ.Κ. 1ης Κίνησης (Εσωτερική Διακίνηση)

	array_push($arr1, 'peg_mmnr01');    array_push($arr2, $peg_mmnr01);
	array_push($arr1, 'peg_mnr01');     array_push($arr2, $kinisi_nr01);  //Το Μ.Κ. Σχετικής Κίνησης
	array_push($arr1, 'peg_sess_id');   array_push($arr2, session_id());
	array_push($arr1, 'peg_flag');      array_push($arr2, 1);

	pegasus_mysql_insert('peg_tmp_i32', $arr1, $arr2);
}

function invoices_add_lot($peg_mmnr01, $kinisi_nr01, $p010, $v161, $p04, $p301, $p06 = 0, $p07 = 0, $pnr01 = 0) {
	$i38_nr01 = pegasus_mysql_newrec('i38');

	$arr1 = array();                    $arr2 = array();

	array_push($arr1, 'nr01');          array_push($arr2, $i38_nr01);    //Μ.Κ.
	array_push($arr1, 'p01');           array_push($arr2, $kinisi_nr01); //MK Κίνησης
	array_push($arr1, 'p02');           array_push($arr2, $v161);        //Παρτίδα
	array_push($arr1, 'p010');          array_push($arr2, $p010);        //Είδος κίνησης (1/2/3/4)
	array_push($arr1, 'p04');           array_push($arr2, $p04);	     //Ποσότητα
	array_push($arr1, 'p05');           array_push($arr2, $p301);	     //Τεμάχια
	array_push($arr1, 'p06');           array_push($arr2, $p06);	     //Τιμολογημένη Ποσότητα
	array_push($arr1, 'p07');           array_push($arr2, $p07);	     //Τιμολογημένα Τεμάχια
	array_push($arr1, 'pnr01');         array_push($arr2, $pnr01);	     //MK 1ης Κίνησης (Ενδοδιακίνηση)

	array_push($arr1, 'peg_mmnr01');    array_push($arr2, $peg_mmnr01);
	array_push($arr1, 'peg_mnr01');     array_push($arr2, $kinisi_nr01); //mnr01 το μκ της κίνησης
	array_push($arr1, 'peg_sess_id');   array_push($arr2, session_id());
	array_push($arr1, 'peg_flag');      array_push($arr2, 1);
	
	pegasus_mysql_insert('peg_tmp_i38', $arr1, $arr2);
}

function invoices_add_colorsize($peg_mmnr01, $mode, $kinisi_nr01, $p01, $v172, $v173, $p04, $i01p05 = 0, $i01p012 = 0, $i01p610 = -1, $pnr01 = 0) {
	$arr1 = array();					$arr2 = array();

	if($mode == "a55" || $mode == "a56" || $mode == "a60" || $mode == "retail00_01") {
		$peg_tmp_tbl = "peg_tmp_i48";
		$nr01 = pegasus_mysql_newrec('i48');
		
		array_push($arr1, 'i01p01');   array_push($arr2, $p01);     //Κωδ.Είδους
		array_push($arr1, 'i01p05');   array_push($arr2, $i01p05);  //K.K.
		array_push($arr1, 'i01p012');  array_push($arr2, $i01p012); //Συντελεστής
		array_push($arr1, 'i01p610');  array_push($arr2, $i01p610); //Χώρος
		array_push($arr1, 'pnr01');    array_push($arr2, $pnr01); //MK 1ης Κίνησης (Ενδοδιακίνηση)
	} else if($mode == "a57" || $mode == "a67" || $mode == "a61") {
		if($mode == "a57") {
			$peg_tmp_tbl = "peg_tmp_a59";
			$nr01 = pegasus_mysql_newrec('a59');
		} else if($mode == "a67") {
			$peg_tmp_tbl = "peg_tmp_a69";
			$nr01 = pegasus_mysql_newrec('a69');
		} else if($mode == "a61") {
			$peg_tmp_tbl = "peg_tmp_a63";
			$nr01 = pegasus_mysql_newrec('a63');
		}

		array_push($arr1, 'p06');    	array_push($arr2, $p01);     //Κωδ.Είδους
		array_push($arr1, 'p07');    	array_push($arr2, $i01p610); //Αποθηκευτικός Χώρος
	}
	
	array_push($arr1, 'nr01');     		array_push($arr2, $nr01);
	array_push($arr1, 'p01');           array_push($arr2, $kinisi_nr01); //M.K. Κίνησης

	array_push($arr1, 'p02');           array_push($arr2, $v172);        //Κωδ.Χρώματος
	array_push($arr1, 'p03');           array_push($arr2, $v173);        //Κωδ.Μεγέθους
	array_push($arr1, 'p04');           array_push($arr2, $p04);         //Ποσότητα

	array_push($arr1, 'peg_mmnr01');    array_push($arr2, $peg_mmnr01);
	array_push($arr1, 'peg_mnr01');     array_push($arr2, $kinisi_nr01); //Το M.K. Κίνησης
	array_push($arr1, 'peg_sess_id');   array_push($arr2, session_id());
	array_push($arr1, 'peg_flag');      array_push($arr2, 1);


	pegasus_mysql_insert($peg_tmp_tbl, $arr1, $arr2);	
}

function invoices_change_p805($mode_nr01, $mode, $p805, $p07) {
    $ret_array = array();

    if($mode == 'a55' || $mode == 'retail00_01') {
        $product_table = 'peg_tmp_i01';
        $is_invoice = 1;
    } else if($mode == 'a56') {
        $product_table = 'peg_tmp_i01';
        $is_invoice = 1;
    } else if($mode == 'a57') {
        $product_table = 'peg_tmp_a58';
        $is_invoice = 0;
    } else if($mode == 'a67') {
        $product_table = 'peg_tmp_a68';
        $is_invoice = 0;
    } else {
        return $ret_array;
    }

	if(invoices_check_if_zero_prices($mode, $mode_nr01) == 1) {
		return $ret_array;
	}

    pegasusSetGlobalVar('peg_'.$mode.'_d-' . $mode_nr01 . '_p805', $p805);

	$product_where = pegasusGetGlobalVar('peg_'.$mode.'_d-' . $mode_nr01 . '_where_eidi');

	if($is_invoice == 1) {
        if($p805 == 1) {
			$arr1 = array();               $arr2 = array();

            array_push($arr1, 'p041');     array_push($arr2, 0);
            array_push($arr1, 'peg_flag'); array_push($arr2, 2);

            pegasus_mysql_update($product_table, $arr1, $arr2, $product_where, 0, 0);

        } else {
			$query_product_table = "UPDATE peg_tmp_i01, i00 
									SET peg_tmp_i01.peg_flag = 2, 
										peg_tmp_i01.p041 = i00.p905
									WHERE $product_where AND 
										  i00.pno = peg_tmp_i01.p01";

            pegasus_query($query_product_table);
        }
    } else {
        if($p805 == 1) {
            $v1041 = 0;

			if($p07 == 1) {
				$v616 = '(v616 * (100 + v105) / 100)';
			} else {
				$v616 = '(v616)';
			}

            $v107 = '(( v103 * v104 * ((100 - v106) /100) * ((100 - v106a) /100)) + (' . $v1041 . ' * v103) + (' . $v616 . ' * v103)  + v1042)';
            $v107 = "ROUND((" . $v107 . "), 2)";

            $arr1 = array();               $arr2 = array();

            array_push($arr1, 'v1041');    array_push($arr2, $v1041);
            array_push($arr1, 'v107');	   array_push($arr2, $v107);
            array_push($arr1, 'peg_flag'); array_push($arr2, 2);

            pegasus_mysql_update($product_table, $arr1, $arr2, $product_where, 0, 0);
        } else {
			if($p07 == 1) {
				$v1041 = '(i00.p905 * (100 + v105) / 100)';
				$v616  = '(v616 * (100 + v105) / 100)';
			} else {
				$v1041 = '(i00.p905)';
				$v616  = '(v616)';
			}

            $v107 = '(( v103 * v104 * ((100 - v106) /100) * ((100 - v106a) /100)) + (' . $v1041 . ' * v103) + (' . $v616 . ' * v103)  + v1042)';
            $v107 = "ROUND((" . $v107 . "), 2)";

            $query_product_table = "UPDATE $product_table, i00 
									SET $product_table.peg_flag = 2, 
										$product_table.v107 = $v107 , 
										$product_table.v1041 = i00.p905
									WHERE $product_where AND 
										  i00.pno = $product_table.v101";

            pegasus_query($query_product_table);
        }
    }

	return $ret_array; 
}

function invoices_update_efk($mode_nr01, $mode, $p206, $p07) {
    $ret_array = array();

    if($mode == 'a55') {//σε αλλαγή πελάτη ή παραστατικού αν προέρχεται απο retail το mode αλλάζει σε a55
        $product_table = 'peg_tmp_i01';
        $is_invoice = 1;
    } else if($mode == 'a56') {
        $product_table = 'peg_tmp_i01';
        $is_invoice = 1;
    } else if($mode == 'a57') {
        $product_table = 'peg_tmp_a58';
        $is_invoice = 0;
    } else if($mode == 'a67') {
        $product_table = 'peg_tmp_a68';
        $is_invoice = 0;
    } else {
        return;
    }

	$product_where = pegasusGetGlobalVar('peg_'.$mode.'_d-' . $mode_nr01 . '_where_eidi');

	if($is_invoice == 1) {
		if($p206 == 1) {
			$arr1 = array();               $arr2 = array();

			array_push($arr1, 'p616');     array_push($arr2, 0);
			array_push($arr1, 'peg_flag'); array_push($arr2, 2);

			pegasus_mysql_update($product_table, $arr1, $arr2, $product_where);
		} else {
			$query_product_table = "UPDATE peg_tmp_i01, i00 
									SET peg_tmp_i01.peg_flag = 2, 
										peg_tmp_i01.p616 = i00.p616
									WHERE $product_where AND 
										  i00.pno = peg_tmp_i01.p01";
			// echo pegasus_replace_values_in_sql($query_product_table);
            pegasus_query($query_product_table);
		}
	} else {
		if($p206 == 1) {
			$v616 = 0;

			if($p07 == 1) {
				$v1041 = '(v1041 * (100 + v105) / 100)';
			} else {
				$v1041 = '(v1041)';
			}

			$v107 = '(( v103 * v104 * ((100 - v106) /100) * ((100 - v106a) /100)) + (' . $v1041 . ' * v103) + (' . $v616 . ' * v103)  + v1042)';
            $v107 = "ROUND((" . $v107 . "), 2)";

			$arr1 = array();               $arr2 = array();

			array_push($arr1, 'v616');     array_push($arr2, $v616);
            array_push($arr1, 'v107');	   array_push($arr2, $v107);
            array_push($arr1, 'peg_flag'); array_push($arr2, 2);

            pegasus_mysql_update($product_table, $arr1, $arr2, $product_where, 0, 0);
		} else {
			if($p07 == 1) {
				$v1041 = '(v1041 * (100 + v105) / 100)';
				$v616  = '(i00.p616 * (100 + v105) / 100)';
			} else {
				$v1041 = '(v1041)';
				$v616  = '(i00.p616)';
			}

			$v107 = '(( v103 * v104 * ((100 - v106) /100) * ((100 - v106a) /100)) + (' . $v1041 . ' * v103) + (' . $v616 . ' * v103)  + v1042)';
            $v107 = "ROUND((" . $v107 . "), 2)";

            $query_product_table = "UPDATE $product_table, i00 
									SET $product_table.peg_flag = 2, 
										$product_table.v107 = $v107, 
										$product_table.v616 = i00.p616
									WHERE $product_where AND 
										  i00.pno = $product_table.v101";

            pegasus_query($query_product_table);
		}
	}

	return $ret_array;
}

// invoices_save_invoice,
/**
 * $mode: Από πoια οθόνη προερχόμαστε a55, a57, a56, a67...
 * $invoice_nr01: Το nr01 του Παραστατικού / Παραγγελίας
 * $i18_nr01: Το nr01 της συνταγής
 * $main_product_nr01: Το nr01 της κίνησης προϊόντος
 * $v101: Κωδικός Είδους
 * $v103: Ποσότητα
 * $i01_p05: Κωδικός κίνησης
 * $kath_fpa: Καθεστός ΦΠΑ
 * $remguc: Γίνεται ως "auto" στην περίπτωση που έρχονται είδη μέσα από τον p500, δηλαδή από τα προεπιλεγμένα είδη του παραστατικού
 * $psyn_des: Αυτόματη Ενημέρωση Ποσοτήτων Από κύριο Είδος
 * $psyn_p99: Να καταχωρηθεί και το είδος-συνταγή
 */
function invoices_execute_i18_add_item(
	$mode,
	$invoice_nr01,
	$i18_nr01,
	$main_product_nr01,
	$v101,
	$v103,
	$i01_p05 = 0,
	$kath_fpa = 0,
	$remguc = "",
	$psyn_des = 1,
	$psyn_p99 = 1,
	$psyn_tim = -1
) {
	$mmnr01 = $mode."_d-".$invoice_nr01;

	$query_i18 = "SELECT * FROM i18 WHERE nr01 = :nr01";
	$query_params_i18 = array(
		"nr01" => $i18_nr01
	);

	pegasus_mysql_use($query_i18, $res_i18, $query_params_i18);

    if($psyn_p99==1){
		$data = invoices__invoices_online_insert(
			$mmnr01,
			$invoice_nr01,
			'', '', '', 0, 0, 0, 0,	'',	
			$v101,
			'',
			$v103,
			'',
			$res_i18['pc01'], 
			$res_i18['pm01'],
			0, 0, 0, 0,	0, 0, 0,
			$kath_fpa,
			$remguc, '0100-01-01', 0, '', $i01_p05, 0,
			0,
			$res_i18['p02']
		);

		$main_product_nr01 = $data['data']['product_nr01'];
    }
    
	$query = "SELECT  * FROM i19 WHERE i00=:i00 AND pc01=:pc01 AND pm01=:pm01 ORDER BY pdia;";
	$query_params = array(
		"i00"  => $res_i18['i00'],
		"pc01" => $res_i18['pc01'],
		"pm01" => $res_i18['pm01']
	);

	$res = pegasus_query($query, $query_params);
	while($i19 = pegasus_fetch_assoc($res)) {
		$posothta =  $v103 * $i19['p03'] / $res_i18['p02'];

		// Ελέγχει από τον ορισμό των τιμών αν παίρνει από τις συνταγές ή αν θα τις καταχωρήσει με τιμές ή όχι
		if($psyn_tim == -1) {
			if($i19['p04'] == 1) {
				$psyn_tim00 = 0;
			}else{
				$psyn_tim00 = 1;
			}
		} else {
			$psyn_tim00 = $psyn_tim;
		}

		invoices__invoices_online_insert(
			$mmnr01,
			$invoice_nr01,
			'', '', '', 0, 0, 0, 0,	'',	
			$i19['p02'],
			'',
			$posothta,
			'',
			$i19['pc02'],
			$i19['pm02'],
			0, 0, 0, 0,	0, 0, 0,
			$kath_fpa,
			$remguc, '0100-01-01', 0, '', $i01_p05, 0,
			($psyn_des == 1) ? $main_product_nr01 : 0,
			($psyn_des == 1) ? $i19['p03'] : 0,
			$psyn_tim00
		);
	}
}

function invoices_execute_i18_update_item($mode, $product_nr01, $invoice_nr01, $p03, $i19_p03) {
	if($mode == "retail00_01") {
		$mode = "a55";
	}

	$mmnr01 = $mode."_d-".$invoice_nr01;
	$where_eidi = pegasusGetGlobalVar('peg_'.$mode.'_d-' . $invoice_nr01 . '_where_eidi');

	if(in_array($mode, array("a55", "a56", "a60"))) {
		$product_tbl = "i01";
		$colorsize_tbl = "i48";
		$p03_fld = "p03";
		$p01_fld = "p01";
	} else if($mode == "a57") {
		$product_tbl = "a58";
		$colorsize_tbl = "a59";
		$p03_fld = "v103";
		$p01_fld = "v101";
	} else if($mode == "a67") {
		$product_tbl = "a68";
		$colorsize_tbl = "a69";
		$p03_fld = "v103";
		$p01_fld = "v101";
	} else if($mode == "a61") {
		$product_tbl = "a62";
		$colorsize_tbl = "a63";
		$p03_fld = "v103";
		$p01_fld = "v101";
	} else {
		return;
	}

	if($mode == "a60") {
		$query = "SELECT * FROM peg_tmp_$product_tbl WHERE ".$where_eidi['sql']." AND i18$product_tbl = :nr01";

		$query_params = array_merge(
			$where_eidi['sqlParams'],
			array("nr01" => $product_nr01)
		);
	} else {
		$query = "SELECT * FROM peg_tmp_$product_tbl WHERE $where_eidi AND i18$product_tbl = :nr01";

		$query_params = array(
			"nr01" => $product_nr01
		);
	}

	$res = pegasus_query($query, $query_params);

	while($row = pegasus_fetch_assoc($res)) {
		if(!empty($i19_p03) && $i19_p03 > 0) {
			$posothta = $p03 * $row['i19p03'] / $i19_p03;
		} else {
			$posothta = 0;
		}

		if($mode == "a60") {
			pegasus_mysql_update("peg_tmp_$product_tbl", array("peg_flag", $p03_fld), array(2, $posothta), $where_eidi['sql']." AND nr01=:nr01", 0, 1, 1, array_merge($where_eidi['sqlParams'], array('nr01' => $row['nr01'])));
		} else {
			pegasus_mysql_update("peg_tmp_$product_tbl", array("peg_flag", $p03_fld), array(2, $posothta), "$where_eidi AND nr01=:nr01", 0, 1, 1, array('nr01' => $row['nr01']));
		}

		if(pegasus_module_exists('colorsize')) {
			$query_i47 = "SELECT count(*) AS cnt FROM i47 WHERE p01 = :p01";
			pegasus_mysql_use($query_i47, $res_i47, array("p01"=>$row[$p01_fld]));

			if($res_i47['cnt'] > 0) {
				$where = "peg_flag != 9 AND peg_mmnr01 = :mmnr01 AND peg_mnr01 = :mnr01 AND peg_sess_id = :sess_id AND p01 = :product_nr01 limit 1";

				$where_params = array(
					"mmnr01"       => $mmnr01,
					"mnr01"        => $row['nr01'],
					"sess_id"      => session_id(),
					"product_nr01" => $row['nr01']
				);

				pegasus_mysql_update("peg_tmp_$colorsize_tbl", array("peg_flag", "p04"), array(2, $posothta), $where, 0, 0, 1, $where_params);
			}
		}
	}
}

function invoices_after_update_erpa13() {
	new_recs_for_erpa13_q31("Πώληση", 1);
	new_recs_for_erpa13_q31("Πώληση για Λογαριασμό Τρίτων", 2);
	new_recs_for_erpa13_q31("Δειγματισμός", 3);
	new_recs_for_erpa13_q31("Έκθεση", 4);
	new_recs_for_erpa13_q31("Επιστροφή", 5);
	new_recs_for_erpa13_q31("Φύλαξη", 6);
	new_recs_for_erpa13_q31("Επεξεργασία - Συν/ση - Αποσυν/ση", 7);
	new_recs_for_erpa13_q31("Ενδοδιακίνηση", 8);
	new_recs_for_erpa13_q31("Αγορά", 9);
	new_recs_for_erpa13_q31("Εφοδιασμός πλοίων και αεροσκαφών", 10);
	new_recs_for_erpa13_q31("Δωρεάν διάθεση", 11);
	new_recs_for_erpa13_q31("Εγγύηση", 12);
	new_recs_for_erpa13_q31("Χρησιδανεισμός", 13);
	new_recs_for_erpa13_q31("Αποθήκευση σε Τρίτους", 14);
	new_recs_for_erpa13_q31("Επιστροφή από Φύλαξη", 15);
	new_recs_for_erpa13_q31("Ανακύκλωση", 16);
	new_recs_for_erpa13_q31("Καταστροφή άχρηστου υλικού", 17);
	new_recs_for_erpa13_q31("Διακίνηση Παγίων (Ενδοδιακίνηση)", 18);
	new_recs_for_erpa13_q31("Λοιπές Διακινήσεις", 19);
	new_recs_for_erpa13_q31("Μεταφορές - Ταχυμεταφορές", 20);
}

function new_recs_for_erpa13_q31($p01, $p05) {
	$erpa13_arr = array();

	$erpa13_arr['nr01'] = 10000000000+$p05;
	$erpa13_arr['p01'] = $p01;
	$erpa13_arr['p101'] = "1";
	$erpa13_arr['p102'] = "0";
	$erpa13_arr['p103'] = "0";
	$erpa13_arr['is_std'] = "1";

	$erpa13_where = "nr01 = :nr01";
	$erpa13_where_params = array(
		"nr01" => $erpa13_arr['nr01']
	);

	if(pegasus_mysql_printfld('erpa13', 'nr01', $erpa13_where, $erpa13_where_params) > 0) {
		pegasus_mysql_update('erpa13', array_keys($erpa13_arr), array_values($erpa13_arr), 'nr01=:nr01', 0, 1, 1, array('nr01' => $erpa13_arr['nr01']));
	} else {
		pegasus_mysql_insert('erpa13', array_keys($erpa13_arr), array_values($erpa13_arr));
	}

	$q31_arr = array();
	$q31_arr['p05'] = $p05;
	if(in_array($p05, array(6, 15, 16, 17))) {
		$q31_arr['p05'] = 19; // Μεταφέρουμε τους κατηργημένους myDATA Σκοπούς Διακίνησης σε "Λοιπές Διακινήσεις" (myDATA 1.0.11)
	}elseif($p05 == 18) {
		$q31_arr['p05'] = 8; // Εκτός από την κατηργημένη Μεταφορά Παγίων (Ενδοδιακίνηση) που μεταφέρεται σε Ενδοδιακίνηση.
	}
	$q31_arr['p01'] = "620057";
	$q31_arr['p03'] = $erpa13_arr['nr01'];
	

	$q31_where = "p01=620057 AND p03 = :erpa13_nr01 AND p05 = :p05";
	$q31_where_params = array(
		"erpa13_nr01" => $erpa13_arr['nr01'], 
		"p05"         => $p05
	);

	if (pegasus_mysql_printfld('q31', 'nr01', $q31_where, $q31_where_params) > 0) {
		pegasus_mysql_update('q31', array_keys($q31_arr), array_values($q31_arr), $q31_where, 0, 1, 1, $q31_where_params);
	} else {
		$q31_arr['nr01'] = pegasus_mysql_newrec("q31");
		pegasus_mysql_insert('q31', array_keys($q31_arr), array_values($q31_arr));
	}
}

function invoices_check_p08($nr01, $p01, $p06, $p701, $mode, $p05){

	$arr = array();

	switch($mode) {
		case 'a55' :
			$p05_nr01 = pegasus_mysql_printfld('a10', 'nr01', 'p01 = ?', array($p05));
		break;
		case 'a56' :
			$p05_nr01 = pegasus_mysql_printfld('a11', 'nr01', 'p01 = ?', array($p05));
		break;
		case 't08' :
			$p05_nr01 = pegasus_mysql_printfld('t10', 'nr01', 'p01 = ?', array($p05));
		break;
	}

	if(	empty($nr01)|| 
		empty($p01) ||
		empty($p06) ||
		empty($mode) ||
		empty($p05_nr01)){
		$arr['ok'] = 1;
		return $arr;
	}

	
	$query = "SELECT nr01 FROM ".$mode." WHERE nr01 != :nr01 
	and  p01 = :p01 and p06 = :p06 and p701 = :p701 and p08 = 1 and p05 = :p05";
	$query_params = array( 'nr01'=>$nr01,'p01' => $p01, 'p06' => $p06, 'p701' => $p701, 'p05' => $p05);

	$res = pegasus_query($query, $query_params);
	$peg_msg = '';
	if(pegasus_num_rows($res) == 0){
		$arr['ok'] = 1;

	}elseif(pegasus_num_rows($res) == 1){
		$arr['ok'] = 0;
		$row = pegasus_fetch_assoc($res);
		$peg_msg = $_SESSION['peg_dic_invoices_one_invoice_exists'];
		$peg_msg = str_replace('#1#', $row['nr01'],  $peg_msg);
	}else{
		$arr['ok'] = 0;
		$nr01_arr =array();
		while($row = pegasus_fetch_assoc($res)) {
			$nr01_arr[] = $row['nr01'];
		}
		$nr01_str = implode(',', $nr01_arr);
		$peg_msg = $_SESSION['peg_dic_invoices_more_invoices_exists'];
		$peg_msg = str_replace('#1#', $nr01_str,  $peg_msg);
	}
	$arr['msg'] = $peg_msg;
	
	
	return $arr;
}


function invoices_where_p05($data = array(), $mode = '', $container_id) {

	if(in_array($mode, array("a55", "a56", "a57", "a67"))) {
		$where_p05 = '';

		if(in_array($mode, array("a55", "a57"))) {
			$tbl_p05  = 'a10';
		}

		if(in_array($mode, array("a56", "a67"))) {
			$tbl_p05  = 'a11';
		}

		$p0121 = intval($data['p0121']);
		$p703  = intval($data['p703']);
		$nr01  = intval($data['nr01']);
		$p200  = pegasusGetGlobalVar('peg_'.$mode.'_d-' . $nr01 . '_'.$tbl_p05.'_p200');

		if(empty($p200)) {
			$p200 = 0;
		}

		$where_p05 = " ((".$tbl_p05.".p30='' or ".$tbl_p05.".p30 IS NULL or locate( '#" . $p0121 . "#', ".$tbl_p05.".p30)<>0 ) and (".$tbl_p05.".p31='' or ".$tbl_p05.".p31 IS NULL or locate( '#" . $p703 . "#',  ".$tbl_p05.".p31)<>0)) and ".$tbl_p05.".p200>='" . $p200 . "' and ".$tbl_p05.".ptax>=0 ";

		if($mode == 'a55') {
			$peg_a55_d_p05_where = pegasusGetGlobalVar('peg_a55_d_p05_where');

			if ($peg_a55_d_p05_where) {
				$where_p05 .= ' and ' . $peg_a55_d_p05_where;
			}

			// Στους μετασχηματισμούς παίρνουμε μόνο παραστατικά με ptax > 0 (Δ: )
			if (isset($data['invcust01_p05_where_arr']) && !empty($data['invcust01_p05_where_arr'])) {
				$where_p05 .= ' and ' . pegasus_replace_values_in_sql(
					$data['invcust01_p05_where_arr']['sql'],
					$data['invcust01_p05_where_arr']['sqlParams']
				);
			}
		}

		$new_rec = 0;
		if(in_array($mode, array("a55", "a56", "a57", "a67"))) {
			$new_rec = pegasus_mysql_printfld($mode, "nr01", "nr01 = :nr01", array("nr01" => $data['nr01']));
		}

		if($new_rec != 0 && $data['p05'] > 0) {
			//Θέλω πάντα να εμφανίζεται ο Τύπος καταχωρημένου παραστατικού και η περιγραφή του αν είναι καταχωρημένο
			$where_p05 = " ((" . $where_p05 . ") OR ".$tbl_p05.".p01 = '" . $data['p05'] . "')";
		}

		pegasusSetGlobalVar($container_id . '_where_p05', $where_p05);
	}
}

function invoices_calc_diakinisi_fields($data = array(), $mode = '') {
	if($mode == 'retail00_01') {
		$mode = 'a55';
	}
	$address_array = array(
		'ldstreet' => '',
		'ldnumber' => 0,
		'ldzip'    => '',
		'ldcity'   => '',
		'ss_branch'=> 0,
		/*--------------*/
		'dlvstreet'=> '',
		'dlvnumber'=> 0,
		'dlvzip'   => '',
		'dlvcity'  => '',
		'cs_branch'=> 0
	);

	$q_t05 = "SELECT 
				ifnull( t05.nr01, 0)  as t05_nr01, 
				ifnull( t05.p207, '') as t05_street, 
				ifnull( t05.p208, '') as t05_number, 
				ifnull( t05.p209, '') as t05_zip,
				ifnull( t05.p206, '') as t05_city
			FROM t07
			LEFT JOIN t05 ON t05.p01=t07.p07 AND t05.p204<>''
			WHERE t07.p01 = :p0121;";

	if(in_array($mode, array("a55", "a56", "a57", "a67"))) {
		if(in_array($mode, array("a55", "a57"))) {
			$tbl_p05  = 'a10';
			$tbl_p03  = 'a01';
			$tbl_p04  = 'a71';
		}

		if(in_array($mode, array("a56", "a67"))) {
			$tbl_p05  = 'a11';
			$tbl_p03  = 'a00';
			$tbl_p04  = 'a76';
		}

		$p0121 = intval($data['p0121']);
		$p703  = intval($data['p703']);

		if(!empty($data['p05']) && pegasus_module_exists("inventory")) {
			$tbl_p05_p05 = pegasus_mysql_printfld($tbl_p05, 'p05', 'p01 = :p05', array("p05" => $data['p05']));
			if(!empty($tbl_p05_p05)) {
				$query_i15 = "SELECT * FROM i15 WHERE i15.p01 = :p05";
				pegasus_mysql_use($query_i15, $i15, array("p05" => $tbl_p05_p05));

				$res_i16   = array();
				$query_i16 = "SELECT * FROM i16 WHERE p00 = :p703";
				
				pegasus_mysql_use($query_i16, $res_i16, array("p703"=>$p703));
				
				$i16_address_array = array(
					'__street' => $res_i16['p03'],
					'__number' => 0,
					'__zip'    => $res_i16['p7'],
					'__city'   => $res_i16['p02'],
					'__branch' => 0
				);
				if(pegasus_module_exists("stores")) {
					$t07_p06 = pegasus_mysql_printfld("t07", "p06", "p01 = :p0121", array("p0121"=>$p0121));
					$i16_address_array['__branch'] = $t07_p06;
				}

				// Αν δεν έχω στοιχεία αποθήκης, παίρνω από την έδρα (Βασικές Παραμέτρους ή Ομάδα Καταστήματος) 
				if(empty($i16_address_array['__street']) && empty($i16_address_array['__zip']) && empty($i16_address_array['__city'])) {
					$i16_address_array['__street'] = $_SESSION['cor000_f00p207'];
					$i16_address_array['__number'] = $_SESSION['cor000_f00p208'];
					$i16_address_array['__zip']    = $_SESSION['cor000_f00p209'];
					$i16_address_array['__city']   = $_SESSION['cor000_f00p206'];
					if(pegasus_module_exists("stores")) {
						//* Εδώ διαβάζω από το Κατάστημα του Παραστατικού, όχι από το Κατάστημα της Αποθήκης!
						pegasus_mysql_use($q_t05, $t05_data, array('p0121' => $p0121));
						if($t05_data['t05_nr01'] > 0) {
							$i16_address_array['__street'] = $t05_data['t05_street'];
							$i16_address_array['__number'] = $t05_data['t05_number'];
							$i16_address_array['__zip']    = $t05_data['t05_zip'];
							$i16_address_array['__city']   = $t05_data['t05_city'];
						}
					}
				}

				if(!empty($data['p03'])) {
					// Από Πελάτη/Προμηθευτή
					pegasus_mysql_use("SELECT * FROM " .$tbl_p03. " WHERE nr01 = :p03", $tbl_p03_data, array("p03" => $data['p03']));
					$city_str = '';
					if(!empty($tbl_p03_data['p4_3'])) {
						$d22 = pegasus_mysql_printfld('d22', 'p02', 'p01 = ?', array($tbl_p03_data['p4_3']));
						$city_str .= (!empty($d22)) ? $d22 . " " : "";
					}
					$city_str .= (!empty($tbl_p03_data['p5'])) ? $tbl_p03_data['p5'] . " " : "";
					$city_str .= (!empty($tbl_p03_data['p6'])) ? $tbl_p03_data['p6'] . " " : "";

					$tbl_p03_address_array = array(
						'__street' => $tbl_p03_data['p4'],
						'__number' => 0,
						'__zip'    => $tbl_p03_data['p7'],
						'__city'   => trim($city_str),
						'__branch' => 0	
					);

					if(!empty($data['p04'])) {
						// Έξτρα έλεγχος το υποκατάστημα να ανήκει στον επιλεγμένο πελάτη/προμηθευτή.
						if (pegasus_mysql_printfld($tbl_p04, 'p601', 'nr01=? ', array($data['p04'])) == $data['p03']) {
							$query_ypokatasthma = "SELECT p603, p604, p605, branch FROM ".$tbl_p04." WHERE nr01 = :p04";

							$res_ypokatasthma = array();
							pegasus_mysql_use($query_ypokatasthma, $res_ypokatasthma, array("p04" => $data['p04']));
							// Από Υποκατάστημα Πελάτη/Προμηθευτή
							$tbl_p03_address_array['__street'] = $res_ypokatasthma['p603'];
							$tbl_p03_address_array['__number'] = 0; // Δεν έχει δημιουργηθεί πεδίο Αριθμός στον a71, a76
							$tbl_p03_address_array['__zip']    = $res_ypokatasthma['p604'];
							$tbl_p03_address_array['__city']   = $res_ypokatasthma['p605'];
						}
					}
					// if(pegasus_module_exists("stores")) {
						$tbl_p03_address_array['__branch'] = (isset($res_ypokatasthma['branch'])) ? $res_ypokatasthma['branch'] : $tbl_p03_data['branch'];
					// }
				}
				if($i15['p04']-$i15['p03'] > 0) {
					// Φόρτωση
					$address_array['ldstreet']  = $i16_address_array['__street']; // Οδός
					$address_array['ldnumber']  = $i16_address_array['__number']; // Αριθμός
					$address_array['ldzip']     = $i16_address_array['__zip'];    // Τ.Κ.
					$address_array['ldcity']    = $i16_address_array['__city'];   // Πόλη
					$address_array['ss_branch'] = $i16_address_array['__branch']; // Εγκατάσταση έναρξης διακίνησης

					// Παράδοση
					$address_array['dlvstreet'] = $tbl_p03_address_array['__street']; // Οδός
					$address_array['dlvnumber'] = $tbl_p03_address_array['__number']; // Αριθμός
					$address_array['dlvzip']    = $tbl_p03_address_array['__zip'];    // Τ.Κ.
					$address_array['dlvcity']   = $tbl_p03_address_array['__city'];   // Πόλη
					$address_array['cs_branch'] = $tbl_p03_address_array['__branch']; // Εγκατάσταση ολοκλήρωσης διακίνησης
				}
				if($i15['p04']-$i15['p03'] < 0) {
					// Φόρτωση
					$address_array['ldstreet']  = $tbl_p03_address_array['__street']; // Οδός
					$address_array['ldnumber']  = $tbl_p03_address_array['__number']; // Αριθμός
					$address_array['ldzip']     = $tbl_p03_address_array['__zip'];    // Τ.Κ.
					$address_array['ldcity']    = $tbl_p03_address_array['__city'];   // Πόλη
					$address_array['ss_branch'] = $tbl_p03_address_array['__branch']; // Εγκατάσταση έναρξης διακίνησης

					// Παράδοση
					$address_array['dlvstreet'] = $i16_address_array['__street']; // Οδός
					$address_array['dlvnumber'] = $i16_address_array['__number']; // Αριθμός
					$address_array['dlvzip']    = $i16_address_array['__zip'];    // Τ.Κ.
					$address_array['dlvcity']   = $i16_address_array['__city'];   // Πόλη
					$address_array['cs_branch'] = $i16_address_array['__branch']; // Εγκατάσταση ολοκλήρωσης διακίνησης
				}
			}
		}
	}
	if(in_array($mode, array("a60", "a61"))) {
		if(pegasus_module_exists("inventory")) {
			pegasus_mysql_use('SELECT * FROM a30 WHERE p01 = :p05', $a30, array('p05' => $data['p05']));
			if(!empty($a30['p04'])) {
				$res_i16   = array();
				$query_i16 = "SELECT p02, p03, p7, t07p01 FROM i16 WHERE p00 = :p03";
				
				pegasus_mysql_use($query_i16, $res_i16_1, array("p03"=>$data['p03']));
	
				// Φόρτωση
				$address_array['ldstreet'] = $res_i16_1['p03']; // Οδός
				$address_array['ldnumber'] = 0;			   	    // Αριθμός
				$address_array['ldzip']    = $res_i16_1['p7'];  // Τ.Κ.
				$address_array['ldcity']   = $res_i16_1['p02']; // Πόλη

				if(pegasus_module_exists("stores")) {
					$t07_p06_1 = pegasus_mysql_printfld("t07", "p06", "p01 = :t07p01", array("t07p01"=>$res_i16_1['t07p01']));
				
					if(empty($t07_p06_1)) {
						$t07_p06_1 = 0;
					}
					$address_array['ss_branch'] = $t07_p06_1; // Εγκατάσταση έναρξης διακίνησης
				}

				// Αν δεν έχω στοιχεία αποθήκης, παίρνω από την έδρα (Βασικές Παραμέτρους ή Ομάδα Καταστήματος) 
				if(empty($address_array['ldstreet']) && empty($address_array['ldzip']) && empty($address_array['ldcity'])) {
					$address_array['ldstreet'] = $_SESSION['cor000_f00p207'];
					$address_array['ldnumber'] = $_SESSION['cor000_f00p208'];
					$address_array['ldzip']    = $_SESSION['cor000_f00p209'];
					$address_array['ldcity']   = $_SESSION['cor000_f00p206'];
					if(pegasus_module_exists("stores")) {
						//* Εδώ διαβάζω από το Κατάστημα του Παραστατικού, όχι από το Κατάστημα της Αποθήκης!
						pegasus_mysql_use($q_t05, $t05_data, array('p0121' => $res_i16_1['t07p01']));
						if($t05_data['t05_nr01'] > 0) {
							$address_array['ldstreet'] = $t05_data['t05_street'];
							$address_array['ldnumber'] = $t05_data['t05_number'];
							$address_array['ldzip']    = $t05_data['t05_zip'];
							$address_array['ldcity']   = $t05_data['t05_city'];
						}
					}
				}
			}

			if(!empty($a30['p05'])) {
				$res_i16   = array();
				$query_i16 = "SELECT p02, p03, p7, t07p01 FROM i16 WHERE p00 = :p04";
				
				pegasus_mysql_use($query_i16, $res_i16_2, array("p04"=>$data['p04']));

				// Παράδοση
				$address_array['dlvstreet'] = $res_i16_2['p03']; // Οδός
				$address_array['dlvnumber'] = 0;			     // Αριθμός
				$address_array['dlvzip']    = $res_i16_2['p7'];  // Τ.Κ.
				$address_array['dlvcity']   = $res_i16_2['p02']; // Πόλη

				if(pegasus_module_exists("stores")) {
					$t07_p06_2 = pegasus_mysql_printfld("t07", "p06", "p01 = :t07p01", array("t07p01"=>$res_i16_2['t07p01']));

					if(empty($t07_p06_2)) {
						$t07_p06_2 = 0;
					}
					$address_array['cs_branch'] = $t07_p06_2; // Εγκατάσταση ολοκλήρωσης διακίνησης
				}

				// Αν δεν έχω στοιχεία αποθήκης, παίρνω από την έδρα (Βασικές Παραμέτρους ή Ομάδα Καταστήματος) 
				if(empty($address_array['dlvstreet']) && empty($address_array['dlvzip']) && empty($address_array['dlvcity'])) {
					$address_array['dlvstreet'] = $_SESSION['cor000_f00p207'];
					$address_array['dlvnumber'] = $_SESSION['cor000_f00p208'];
					$address_array['dlvzip']    = $_SESSION['cor000_f00p209'];
					$address_array['dlvcity']   = $_SESSION['cor000_f00p206'];
					if(pegasus_module_exists("stores")) {
						//* Εδώ διαβάζω από το Κατάστημα της Αποθήκης, όχι από το Κατάστημα του Παραστατικού!
						pegasus_mysql_use($q_t05, $t05_data, array('p0121' => $res_i16_2['t07p01']));
						if($t05_data['t05_nr01'] > 0) {
							$address_array['dlvstreet'] = $t05_data['t05_street'];
							$address_array['dlvnumber'] = $t05_data['t05_number'];
							$address_array['dlvzip']    = $t05_data['t05_zip'];
							$address_array['dlvcity']   = $t05_data['t05_city'];
						}
					}
				}
			}
		}
	}

	// Αν ο αριθμός είναι στο τέλος της διεύθυνσης, τον εντοπίζω και τον διαχωρίζω στα δύο πεδία.
	$reg_exp = '/^(.*\S)\s(\d+)$/';
	if(!empty($address_array['ldstreet']) && empty($address_array['ldnumber'])) {
		$loading_address = trim($address_array['ldstreet']);
		if (preg_match($reg_exp, $loading_address, $matches)) {
			$address_array['ldstreet'] = trim($matches[1]);
			$address_array['ldnumber'] = $matches[2];
		}
	}
	if(!empty($address_array['dlvstreet']) && empty($address_array['dlvnumber'])) {
		$delivery_address = trim($address_array['dlvstreet']);
		if (preg_match($reg_exp, $delivery_address, $matches)) {
			$address_array['dlvstreet'] = trim($matches[1]);
			$address_array['dlvnumber'] = $matches[2];
		}
	}
	
	return $address_array;
}

function invoices_update_zero_prices_for_items($mode_nr01, $mode, $p107) {
    $ret_array = array();

    if($mode == 'a55') {//σε αλλαγή πελάτη ή παραστατικού αν προέρχεται απο retail το mode αλλάζει σε a55
        $product_table = 'peg_tmp_i01';
        $is_invoice = 1;
    } else if($mode == 'a56') {
        $product_table = 'peg_tmp_i01';
        $is_invoice = 1;
    } else if($mode == 'a57') {
        $product_table = 'peg_tmp_a58';
        $is_invoice = 0;
    } else if($mode == 'a67') {
        $product_table = 'peg_tmp_a68';
        $is_invoice = 0;
    } else if($mode == 'a60'){
        $product_table = 'peg_tmp_i01';
		$is_invoice = 1;
    } else if($mode == 'a61'){
        $product_table = 'peg_tmp_a62';
		$is_invoice = 0;
    } else {
        return;
    }

	$product_where = pegasusGetGlobalVar('peg_'.$mode.'_d-' . $mode_nr01 . '_where_eidi');	

	if($is_invoice == 1) {
		if($p107 == 1) {
			$arr1 = array();               $arr2 = array();

			array_push($arr1, 'p04');      array_push($arr2, 0);
			array_push($arr1, 'p616');     array_push($arr2, 0);			
			array_push($arr1, 'p041');     array_push($arr2, 0);
			array_push($arr1, 'p042');     array_push($arr2, 0);
			array_push($arr1, 'p04_1');    array_push($arr2, 0);
			array_push($arr1, 'peg_flag'); array_push($arr2, 2);

			if($mode == 'a60') {
				pegasus_mysql_update($product_table, $arr1, $arr2, $product_where['sql'], 0, 1, 1, $product_where['sqlParams']);
			} else {
				pegasus_mysql_update($product_table, $arr1, $arr2, $product_where);
			}
		}
	} else {
		if($p107 == 1) {
			$arr1 = array();               $arr2 = array();

			array_push($arr1, 'v104');     array_push($arr2, 0);
			array_push($arr1, 'v616');     array_push($arr2, 0);			
			array_push($arr1, 'v1041');    array_push($arr2, 0);
			array_push($arr1, 'v1042');    array_push($arr2, 0);
			array_push($arr1, 'v104_1');   array_push($arr2, 0);
            array_push($arr1, 'v107');	   array_push($arr2, 0);
            array_push($arr1, 'peg_flag'); array_push($arr2, 2);

            pegasus_mysql_update($product_table, $arr1, $arr2, $product_where);
		}
	}

	return $ret_array;
}

/**
 * Ενημερώνει το check [p115: Ελέγχει Στοιχεία Φόρτωσης/Παράδοσης] για όλους τους τύπους παραστατικών που έχουν στήσιμο προς αποστολή στο myDATA με δελτίο διακίνησης.
 */
function invoices_update_invtype_p115() {
	$queries = array();
	/* a10 QUERY */
	$queries['a10'] = "  SELECT GROUP_CONCAT(result.nr01 SEPARATOR ',') AS nr01s
					FROM (
						SELECT a10.nr01
						FROM q31
							JOIN a10 ON q31.p03 = a10.p01
							JOIN mydt50 ON q31.p05 = mydt50.p00
						WHERE q31.p01 = 620014
							AND mydt50.p107 = 1
							AND a10.p115 = 0
						UNION
						SELECT a10.nr01
						FROM q31
							JOIN a10 ON q31.p03 = a10.p01
						WHERE q31.p01 = 620068
							AND a10.p115 = 0
					) AS result;";

	/* a11 QUERY */
	$queries['a11'] = "  SELECT GROUP_CONCAT(result.nr01 SEPARATOR ',') AS nr01s
					FROM (
						SELECT a11.nr01
						FROM q31
							JOIN a11 ON q31.p03 = a11.p01
							JOIN mydt50 ON q31.p05 = mydt50.p00
						WHERE q31.p01 = 620017
							AND mydt50.p107 = 1
							AND a11.p115 = 0
						UNION
						SELECT a11.nr01
						FROM q31
							JOIN a11 ON q31.p03 = a11.p01
						WHERE q31.p01 = 620069
							AND a11.p115 = 0
					) AS result;
	";

	/* a30 QUERY */
	$queries['a30'] = "   SELECT GROUP_CONCAT(a30.nr01 SEPARATOR ',') AS nr01s
								FROM q31
									JOIN a30 ON q31.p03 = a30.p01
									JOIN mydt50 ON q31.p05 = mydt50.p00
								WHERE q31.p01 = 620072
									AND mydt50.p107 = 1
									AND a30.p115 = 0";

	foreach($queries as $tbl => $sql) {
		if(!pegasus_mysql_table_exists($tbl)) {
			continue;
		}
		pegasus_mysql_use($sql, $res);

		if(!empty($res['nr01s'])) {
			$tbl_in_arr = explode(',' , $res['nr01s']);
			$tbl_in     = pegasus_mysql_create_in($tbl_in_arr, $tbl);
			pegasus_mysql_update($tbl, array('p115'), array(1), 'p115 = 0 AND nr01 IN ('.$tbl_in['sql'].')', 0, 1, 1, $tbl_in['sqlParams']);
		}
	}
}

// περναω $data 
function invoices_i32_checks($data, $mode, $permDeny = array()) {
	if(!pegasus_module_exists("serial")) {
		return $permDeny;
	}

	if(in_array($mode, array("a55", "a56"))) {
		$product_tbl = "peg_tmp_i01";
		$product_i16_fld = "p610";
		$product_mode_nr01_fld = "p06";
		$p010 = 1;
	} else if($mode == "a57") {
		$product_tbl = "peg_tmp_a58";
		$product_i16_fld = "p703";
		$product_mode_nr01_fld = "p00";
		$p010 = 2;
	} else if($mode == "a67") {
		$product_tbl = "peg_tmp_a68";
		$product_i16_fld = "p703";
		$product_mode_nr01_fld = "p00";
		$p010 = 3;
	} else {
		return $permDeny;
	}

	$query_i32 = "SELECT 
					peg_tmp_i32.p01   as i32_p01, 
					peg_tmp_i32.p02   as i32_p02, 
					$product_tbl.$product_i16_fld as product_i16, 
					$product_tbl.nr01 as product_nr01 
				FROM peg_tmp_i32 
				LEFT JOIN $product_tbl on $product_tbl.nr01 = peg_tmp_i32.p00 and peg_tmp_i32.p010 = :p010
				WHERE $product_tbl.$product_mode_nr01_fld = :nr01
				  AND $product_tbl.peg_flag   != 9
				  AND $product_tbl.peg_sess_id = :sess_id
				  AND $product_tbl.peg_mmnr01  = :mmnr01
				  AND $product_tbl.peg_mnr01   = :mnr01
				  AND peg_tmp_i32.peg_flag    != 9
				  AND peg_tmp_i32.peg_sess_id  = :sess_id
				  AND peg_tmp_i32.peg_mmnr01   = :mmnr01";


	$query_i32_params = array(
		"p010"	  => $p010,
		"nr01"    => $data['nr01'],
		"sess_id" => session_id(),
		"mmnr01"  => $mode."_d-".$data['nr01'],
		"mnr01"   => $data['nr01']
	);

	$res = pegasus_query($query_i32, $query_i32_params);

	while($row = pegasus_fetch_assoc($res)) {
		if($row['product_i16'] == -1) {
			$row['product_i16'] = $data['p703'];

			if(in_array($mode, array("a60", "a61"))) {
				$row['product_i16'] = $data['p03'];
			}
		}

		if(in_array($mode, array("a55", "a57", "a56", "a67")) && $_SESSION['f02_pg904'] == 1) {
			$ypol_i16   = serial_find_balance($row['i32_p01'], $row['i32_p02'], $row['product_i16'], $row['product_nr01']);
			$ypol_total = serial_find_balance($row['i32_p01'], $row['i32_p02'], "***", $row['product_nr01']);

			if($data['p05'] > 0) {
				if(in_array($mode, array("a55", "a57"))) {
					$query_a10 = "SELECT i15.* FROM a10 JOIN i15 on i15.p01=a10.p05 WHERE a10.p01=:p05 ";
					$query_a10_params = array('p05' => $data['p05']);

					pegasus_mysql_use($query_a10, $i15, $query_a10_params);
				} else if(in_array($mode, array("a56", "a67"))) {
					$query_a11 = "SELECT i15.* FROM a11 JOIN i15 on i15.p01=a11.p05 WHERE a11.p01=:p05 ";
					$query_a11_params = array('p05' => $data['p05']);

					pegasus_mysql_use($query_a11, $i15, $query_a11_params);
				}
			}

			if(
				($ypol_i16 + $i15['p03'] - $i15['p04']) != 0 && 
				($ypol_i16 + $i15['p03'] - $i15['p04']) != 1
			) {
				array_push($permDeny, array('type' => 'deny', 'message' => str_replace(array('##i31_p02##', '##i16_p01##'), array($row['i32_p02'], pegasus_mysql_printfld("i16", "p01", "p00 = :product_i16", array("product_i16"=>$row['product_i16']))), $_SESSION['peg_dic_serial_no_balance_i16'])));
			}

			if(
				($ypol_total + $i15['p03'] - $i15['p04']) != 0 && 
				($ypol_total + $i15['p03'] - $i15['p04']) != 1
			) {
				array_push($permDeny, array('type' => 'deny', 'message' => str_replace('##i31_p02##', $row['i32_p02'], $_SESSION['peg_dic_serial_no_balance'])));
			}
		}
	}

	return $permDeny;
}

function invoices_search_for_last_sale_purchase_price($container_id, $mode, $p03) {
	$ret_array = array();
	$ret_array['last_sale_purchase_price'] = 0;
	$ret_array['msg'] = "";

	if(($_SESSION['f02_pg09'] != 0 && in_array($mode, array("a55", "a57", "retail00_01"))) || 
	   ($_SESSION['f02_apg09'] != 0 && in_array($mode, array("a56", "a67")))) {

		$where = pegasusGetGlobalVar($container_id . '_where_eidi');

		switch($mode) {
			case 'a57':
				$query = "SELECT nr01, v101 as p01, v102 as p02, v104 as p04, 0 as p3051 FROM peg_tmp_a58 WHERE " . $where;

				break;
			case 'a67':
				$query = "SELECT nr01, v101 as p01, v102 as p02, v104 as p04, 0 as p3051 FROM peg_tmp_a68 WHERE " . $where;

				break;
			default:
				if(is_array($where)) {
					$query = "SELECT nr01, p01, p02, p04, p3051 FROM peg_tmp_i01 WHERE " . $where['sql'];
				} else {
					$query = "SELECT nr01, p01, p02, p04, p3051 FROM peg_tmp_i01 WHERE " . $where;
				}

				break;
		}

		if(is_array($where)) {
			$res = pegasus_query($query, $where['sqlParams']);
		} else {
			$res = pegasus_query($query);
		}

		$items_p04 = "<ul>";
		while($row = pegasus_fetch_assoc($res)) {
			$price_array = invoices_i01_get_last_prices($mode, $row['nr01'], $row['p01'], $p03);

			if($price_array['p04'] == $row['p04'] || empty($price_array['p04']) || ($row['p04'] == 0 && $row['p3051'] > 0)) {
				continue;
			}

			$items_p04 .= "<li><b>".$row['p02']."</b> ".$_SESSION['peg_dic_invoices_with_unit_price']." <b>".$price_array['p04']."</b></li>";

			if($price_array['nr01'] > 0) {
				$ret_array['last_sale_purchase_price'] = 1;
			}
		}

		if(!empty($items_p04)) {
			$items_p04 .= "</ul>";

			$ret_array['msg'] .= str_replace(array("#items_p04#"), array($items_p04), $_SESSION['peg_dic_invoices_found_last_price']);
		}
	}

	return $ret_array;
}

function invoices_i01_get_last_prices($mode, $i01_nr01, $i01_p01, $p03) {
	$price_array = array();

	if(($_SESSION['f02_pg09'] != 0 && in_array($mode, array("a55", "a57", "retail00_01"))) || 
	   ($_SESSION['f02_apg09'] != 0 && in_array($mode, array("a56", "a67")))) {

		if(in_array($mode, array("a55", "a57", "retail00_01"))) {
			$mode_00 = "a55";
			$where_retail_a01 = " and a55.p03 != customers_000.retail_a01";
			$p07 = 2;
		} else if(in_array($mode, array("a56", "a67"))) {
			$mode_00 = "a56";
			$where_retail_a01 = "";
			$p07 = 1;
		} else {
			return $price_array;
		}

		$price_where = array(
			'sql' => ' i01.p01 = :i01p01 and i01.nr01 != :i01nr01 and i01.p07 = :p07 and i01.p04 != 0 '.$where_retail_a01,
			'sqlParams'	=>	array(
				'i01p01'  => $i01_p01,
				'i01nr01' => $i01_nr01,
				'p07'     => $p07
			),
		);

		if(
			($_SESSION['f02_pg09'] == 1 && in_array($mode, array("a55", "a57", "retail00_01"))) || 
			($_SESSION['f02_apg09'] == 1 && in_array($mode, array("a56", "a67")))
		) {
			$price_where['sql'] .= " and $mode_00.p03=:p03 ";
			$price_where['sqlParams']['p03'] = $p03;
		}

		$price_query = "SELECT 	i01.nr01,	 i01.p01,	i01.p03,	 i01.p04,
								i01.p010,	 i01.p010a,	i01.p013,	 i01.p042,
								i01.p0100,	 i01.p09,	i01.p610,
								i01.timh1 as i01_timh1,	i01.timh4 as i01_timh4,
								i01.timh3 as i01_timh3,	i01.timh2 as i01_timh2,
								i00.timh1,	 i00.timh4,	i00.timh3,	 i00.timh2
						FROM i01
						JOIN $mode_00 ON $mode_00.nr01 = i01.p06
						JOIN i00 ON i00.pno = i01.p01
						JOIN customers_000 ON customers_000.nr01 = 1
						WHERE ".$price_where['sql']."
						ORDER BY i01.p013 DESC, 
								 i01.remdate DESC, 
								 i01.remtime DESC
						LIMIT 1 ";

		pegasus_mysql_use($price_query, $price_array, $price_where['sqlParams']);
	}

	return $price_array;
}