<?php


	/**
	 *  $type = 1-invsupp  
	 *  $i01_p06 =  a55.nr01 , a56.nr01
	 * 
	 * invoices_print_product_query(1 , $_REQUEST['a56_nr01'] , $p85_input['cs_analysis'])
	 * invoices_print_product_query(2 , $_REQUEST['a55_nr01'] , $p85_input['cs_analysis'] , $costs)
	 */
	function invoices_print_product_query($type, $i01_p06, $cs_analysis, $costs=array(), $disable_i71=false, $lang="GR"){
		$sql       = '';
		$sqlParams = array();

		$perigrafi  = "concat( i01.p02 ";
		$perigrafi .= ", if(i01.p0601='', '', concat(if(i01.p02 = '', '', '\\n'), i01.p0601))";
        $perigrafi .= ", IF(a90.p30 IS NULL, '', concat('\n', a90.p30))";
		//$p85_output['cs_analysis': Υπάρχει άλλη φόρμα που καλεί τη φόρμα εδώ, με μόνη αλλαγή ότι έχει σεταρισμένο το $cs_analysis = true
		if(isset($cs_analysis) && $cs_analysis && pegasus_module_exists('colorsize')){
			//Χρειάζομαι το distinct για την περίπτωση όπου έχω και πολλαπλά χρώματα μεγέθη
            if($lang=="GR"){
			    $perigrafi .=  ", group_concat(distinct if(i48.nr01 IS NULL || i40.p02 IS NULL || i43.p02 IS NULL, '', concat('\\n', i40.p02, if(i40.p02='', '', '-'), i43.p02, ' x ', FORMAT(i48.p04, i24.dek)) )) ";
            }
            if($lang=="EN"){
			    $perigrafi .=  ", group_concat(distinct if(i48.nr01 IS NULL || i40.ep02 IS NULL || i43.ep02 IS NULL, '', concat('\\n', i40.ep02, if(i40.ep02='', '', '-'), i43.ep02, ' x ', FORMAT(i48.p04, i24.dek)) )) ";
            }
        }
		if(pegasus_module_exists('serial')){
			//Χρειάζομαι το distinct για την περίπτωση όπου έχω και πολλαπλά serial
			$concat_serial  = "concat('\\n', 'S.N.:', i32.p02";
            $concat_serial .= ", if(i32.d00_i31p07_p19!='', concat(' ', i32.d00_i31p07_p19), '')";
            if(pegasus_mysql_table_exists('cona11')){
                $concat_serial .= ", if(i32.cona11_p04 is not NULL AND i32.cona11_p05 is not NULL, concat(' ', DATE_FORMAT(i32.cona11_p04, '%d/%m/%Y'), '-', DATE_FORMAT(i32.cona11_p05, '%d/%m/%Y')), '')";
            }
            $concat_serial .= ", if(i32.i31_p015!='', concat('\\n', i31_p015), '')";
            $concat_serial .= ")";
            $perigrafi .=  ", group_concat(distinct if(i32.nr01 IS NULL, '', ".$concat_serial." ))";
        }


        if(pegasus_module_exists('lot')){
			//Χρειάζομαι το distinct για την περίπτωση όπου έχω και πολλαπλά Lot
            if($lang=="GR")
			    $concat_lot  = "concat('\\n', 'Παρτίδα: ', i38.p02,' ',' (',i38.p04,')')";
            if($lang=="EN")
                $concat_lot  = "concat('\\n', 'Lot: ', i38.p02,' ',' (',i38.p04,')')";
            $perigrafi .=  ", group_concat(distinct if(i38.nr01 IS NULL, '', ".$concat_lot." ))";
        }



		$perigrafi .= ") ";

        //Products Query Fields
        $products_query_fields = array(
            'nr01'              =>  'nr01', 
            'p013'              =>  'p013', 
            'p01'               =>  'p01',
            'p02'               =>  'p02', 
            'p03'               =>  'p03', 
            'p04'               =>  'p04', 
            'p05'               =>  'p05', 
            'p610'              =>  'p610', 
            'p023'              =>  'p023', 
            'p0601'             =>  'p0601',
            'p030'              =>  'p030', 
            'p301'              =>  'p301', 
            'p302'              =>  'p302', 
            'p303'              =>  'p303', 
            'p304'              =>  'p304',
            'p306'              =>  'p306', 
            'p307'              =>  'p307', 
            'p309'              =>  'p309', 
            'p310'              =>  'p310', 
            'p308'              =>  'p308',
            'p09'               =>  'p09', 
            'p012'              =>  'p012', 
            'p010'              =>  'p010', 
            'p010a'             =>  'p010a', 
            'p0100'             =>  'p0100',
            'p042'              =>  'p042', 
            'p616'              =>  'p616', 
            'p041'              =>  'p041', 
            'pp011'             =>  'pp011', 
            'p011'              =>  'p011',
            'p0101'             =>  'p0101',    
            'p021'              =>  'p021', 
            'p022'              =>  'p022', 
            'fp011'             =>  'fp011', 
            'p081'              =>  'p081',
            'p08'               =>  'p08', 
            'pn01'              =>  'pn01',  
            'pn02'              =>  'pn02', 
            'p061'              =>  'p061', 
            'p014'              =>  'p014',  
            'p015'              =>  'p015', 
            'pd01'              =>  'pd01',  
            'pd101'             =>  'pd101', 
            'pd102'             =>  'pd102', 
            'p3051'             =>  'p3051', 
            'p904'              =>  'p904', 
            'p305'              =>  'p305', 
            'p500'              =>  'p500', 
            'p501'              =>  'p501', 
            'timh2'             =>  'timh2', 
            'timh4'             =>  'timh4',  
            'timh3'             =>  'timh3',  
            'timh1'             =>  'timh1',  
            'p614'              =>  'p614',  
            'ppnr01'            =>  'ppnr01', 
            'p06'               =>  'p06',  
            'p07'               =>  'p07',  
            'remdate'           =>  'remdate',  
            'remtime'           =>  'remtime', 
            'remuser'           =>  'remuser', 
            'remfdate'          =>  'remfdate',  
            'remftime'          =>  'remftime', 
            'remfuser'          =>  'remfuser', 
            'remguc'            =>  'remguc',  
            'i18i01'            =>  'i18i01', 
            'i19p03'            =>  'i19p03',   
            'p013t'             =>  'p013t',                
            'p501_1'            =>  'p501_1',       
            'p500_1'            =>  'p500_1',   
            'p616p'             =>  'p616p',
            
            'i24_dek'           =>  'i24_dek',  
            'i01_p03_formatted' =>  'i01_p03_formatted',    
            'perigrafi'         =>  'perigrafi',    
            'i71_tot'           =>  'i71_tot',
        );


            
        $sql_i01_fields = '';
        foreach ($products_query_fields as $field=>$alias) {
            if(!empty($sql_i01_fields)) { $sql_i01_fields .= ", \n"; }

            switch ($field) {
                case 'i24_dek':
                    $dbfield = "i24.dek";
                    break;

                case 'i01_p03_formatted':
                    $dbfield = "FORMAT(i01.p03, i24.dek)";
                    break; 
                    
                case 'perigrafi':
                    $dbfield = $perigrafi;
                    break;

                case 'i71_tot':
                    $dbfield = "0";
                    break;    
                
                default:
                    $dbfield = "i01.".$field;
                    break;
            }

            $sql_i01_fields .= $dbfield . " as " . $alias;
        }

        $sql  = " (select ";
        $sql .= $sql_i01_fields;
		$sql .=	" from i01 ";
		$sql .= " left join i00 on i01.p01 = i00.pno ";
		$sql .= " left join i24 on i00.ths = i24.p01 ";

		if(isset($cs_analysis) && $cs_analysis && pegasus_module_exists('colorsize')){
			$sql .=	" left join i48 on i48.p01=i01.nr01 ";
			$sql .=	" left join i40 on i40.p01=i48.p02 ";
			$sql .=	" left join i43 on i43.p01=i48.p03 ";
		}

		if(pegasus_module_exists('serial')){
            $sql .=	"left join (";
            $sql .=	"select i32.*, d00_i31p07.p19 as d00_i31p07_p19, i31.p015 as i31_p015 ";
            
            if(pegasus_mysql_table_exists('cona11')){
                $sql .=	", cona11.p04 as cona11_p04, cona11.p05 as cona11_p05 " ;
            }
            $sql .=	"from i32 ";
            $sql .=	"left join i31 on i32.p02=i31.p02 " ;
            $sql .=	"left join d00 as d00_i31p07 on d00_i31p07.nr01=i31.p07 " ;
            if(pegasus_mysql_table_exists('cona11')){
                $sql .=	"left join cona11 on cona11.nr01=i31.p030 " ;
            }
            $sql .=	") as i32 on i32.p00=i01.nr01 and i32.p010=1 ";            
		}

        if(pegasus_module_exists('lot')){
            $sql .=	"left join (
                    select 
                        i38.nr01,
                        i38.p02,
                        SUM(i38.p04) AS p04,
                        i38.p01
                    from 
                        i38
                    WHERE
                        i38.p010=1
                    group by p01,p02
                ) as i38 on i38.p01=i01.nr01";
		}

        $sql .= " left join a90 on a90.tbl = 'i01' and a90.tbl_nr01 = i01.nr01 "; /////

		$sql .=	" where i01.p06=:i01_p06 and i01.p07=:type ";
	
		if(pegasus_module_exists('orders') and $type==2){
			$sql .=  "  and i01.p01 not in( :costs_apostpno , :costs_codpno , :costs_cost0pno , :costs_cost1pno , :costs_cost2pno , :costs_cost0pno ) ";
		}

		$sql .= " group by i01.nr01 ) ";

        
                            
        $sql_i71_fields = '';
        foreach ($products_query_fields as $field=>$alias) {
            if($field=='i71_tot') { continue; }

            switch ($field) {
                case 'nr01':
                    $dbfield = "(-1) * i71.nr01";
                    break;

                case 'p02':
                    $dbfield = "i70.p01";
                    break; 
                    
                case 'p04':
                    $dbfield = "i71.p100";
                    break;

                case 'perigrafi':
                    $dbfield = "i70.p01";
                    break;    
                
                default:
                    $dbfield = "''";
                    break;
            }

            $sql_i71_fields .= $dbfield . " as " . $alias . ", \n";
        }
        
		$sql_i71_deduc  = " union (select " . $sql_i71_fields;        
        //$sql_i71_deduc .=  "if(i71.i70p02=1 ,1,-1) * if(i71.i70p07=0 ,0,i71.p100) as i71_tot, ";
		$sql_i71_deduc .=  "'' as i71_tot ";
		$sql_i71_deduc .= "from i71 join i70 on i71.i70=i70.nr01 ";	
		$sql_i71_deduc .= "where i71.tbl=:tbl and i71.tbl_nr=:i01_p06 and i71.i70p02=2 ";
        $sql_i71_deduc .= "order by i71.i70p02,i70.p01) ";
        
        $replace_array = array("i70.p01"=>($lang=="GR") ? "'Κρατήσεις'" : "'Deductions'","i71.p100"=>"''");
		$sql_i71_deduc_title  = " union (select " . str_replace(array_keys($replace_array), array_values($replace_array), $sql_i71_fields);
		$sql_i71_deduc_title .=  "'' as i71_tot ";
        $sql_i71_deduc_title .= "from i71 join i70 on i71.i70=i70.nr01 ";	
		$sql_i71_deduc_title .= "where i71.tbl=:tbl and i71.tbl_nr=:i01_p06 and i71.i70p02=2 ";
        $sql_i71_deduc_title .= "limit 1) ";


        $sql_i71_tax  = " union (select " . $sql_i71_fields;        
        //$sql_i71_tax .=  "if(i71.i70p02=1 ,1,-1) * if(i71.i70p07=0 ,0,i71.p100) as i71_tot, ";
		$sql_i71_tax .=  "'' as i71_tot ";
		$sql_i71_tax .= "from i71 join i70 on i71.i70=i70.nr01 ";	
		$sql_i71_tax .= "where i71.tbl=:tbl and i71.tbl_nr=:i01_p06 and i71.i70p02=1 ";
        $sql_i71_tax .= "order by i71.i70p02,i70.p01) ";

        $replace_array = array("i70.p01"=>($lang=="GR") ? "'Φόροι'" : "'Taxes'","i71.p100"=>"''");
        $sql_i71_tax_title  = " union (select " . str_replace(array_keys($replace_array), array_values($replace_array), $sql_i71_fields);
		$sql_i71_tax_title .=  "'' as i71_tot ";
		$sql_i71_tax_title .= "from i71 join i70 on i71.i70=i70.nr01 ";	
		$sql_i71_tax_title .= "where i71.tbl=:tbl and i71.tbl_nr=:i01_p06 and i71.i70p02=1 ";
        $sql_i71_tax_title .= "limit 1) ";

        $sql_i71 = $sql_i71_deduc_title . $sql_i71_deduc . $sql_i71_tax_title . $sql_i71_tax;
        
        if($disable_i71==false){
            $sql .= $sql_i71;    
        }


		$sqlParams['type'] = $type;		
		$sqlParams['i01_p06'] = $i01_p06;
		$sqlParams['tbl'] = ($type == 1) ? 'a56' : 'a55';

		$sqlParams['costs_apostpno'] = $costs['apostpno'];
		$sqlParams['costs_codpno']   = $costs['codpno'];
		$sqlParams['costs_cost0pno'] = $costs['s_cost0pno'];
		$sqlParams['costs_cost1pno'] = $costs['s_cost1pno'];
		$sqlParams['costs_cost2pno'] = $costs['s_cost2pno'];
		$sqlParams['costs_cost3pno'] = $costs['s_cost3pno'];


		//echo pegasus_replace_values_in_sql($sql,$sqlParams);
		return array('sql' => $sql, 'sqlParams' => $sqlParams);
    }


    /**
     * 
     * @param string $mode ("a55","a57","a68")
     * @param integer $nr01 
     * @return array 
     */
    function invoices_find_product_total_quan_per_i24($mode, $nr01){       

        $sql       = '';
        $sqlParams = array();

        $sql_where_costs = "";
        if(pegasus_module_exists('orders') and ($mode=="a57" || $mode=="a55")){
            $sql_where_costs = " and i00.pno not in (:costs_apostpno, :costs_codpno, :costs_cost0pno, :costs_cost1pno, :costs_cost2pno, :costs_cost0pno) ";
        
            pegasus_mysql_use('select apostpno, codpno, s_cost0pno, s_cost1pno, s_cost2pno, s_cost3pno from hero00', $costs);
            $sqlParams['costs_apostpno'] = $costs['apostpno'];
            $sqlParams['costs_codpno']   = $costs['codpno'];
            $sqlParams['costs_cost0pno'] = $costs['s_cost0pno'];
            $sqlParams['costs_cost1pno'] = $costs['s_cost1pno'];
            $sqlParams['costs_cost2pno'] = $costs['s_cost2pno'];
            $sqlParams['costs_cost3pno'] = $costs['s_cost3pno'];
        }
        
        if($mode=="a57"){
			$sql  = "select i24.p01 as i24_p01, i24.dek as i24_dek, sum(a58.v103) as tot_quan from a58 ";
            $sql .= "left join i00 on a58.v101=i00.pno ";
            $sql .= "left join i24 on i00.ths=i24.p01 ";
            $sql .= "where a58.p00=:a57_nr01 " . $sql_where_costs;
            $sql .= "group by i00.ths;";

            $sqlParams['a57_nr01'] = $nr01;

		}elseif($mode=="a67"){
			$sql  = "select i24.p01 as i24_p01, i24.dek as i24_dek, sum(a68.v103) as tot_quan from a68 ";
            $sql .= "left join i00 on a68.v101=i00.pno ";
            $sql .= "left join i24 on i00.ths=i24.p01 ";
            $sql .= "where a68.p00=:a67_nr01 " . $sql_where_costs;
            $sql .= "group by i00.ths;";

            $sqlParams['a67_nr01'] = $nr01;

        }elseif($mode=="a61"){
			$sql  = "select i24.p01 as i24_p01, i24.dek as i24_dek, sum(a62.v103) as tot_quan from a62 ";
            $sql .= "left join i00 on a62.v101=i00.pno ";
            $sql .= "left join i24 on i00.ths=i24.p01 ";
            $sql .= "where a62.p00=:a61_nr01 " . $sql_where_costs;
            $sql .= "group by i00.ths;";

            $sqlParams['a61_nr01'] = $nr01;
            
		}elseif($mode=="a55" || $mode=="a56" || $mode=="a60" ){

            $sql  = "select i24.p01 as i24_p01, i24.dek as i24_dek, sum(i01.p03) as tot_quan from i01 ";
            $sql .= "left join i00 on i01.p01=i00.pno ";
            $sql .= "left join i24 on i00.ths=i24.p01 ";
            $sql .= "where i01.p06=:i01_p06 and i01.p07=:i01_p07 and (i01.ppnr01 = 0 or i01.ppnr01 = i01.nr01) " . $sql_where_costs;
            $sql .= "group by i00.ths;";
            		
		    $sqlParams['i01_p06'] = $nr01;
            $sqlParams['i01_p07'] = "2";
            if($mode=="a56"){
                $sqlParams['i01_p07'] = "1";
            }
            if($mode=="a60"){
                $sqlParams['i01_p07'] = "3";
            }
		}

        $total_quan_arr = array();
        //echo pegasus_replace_values_in_sql($sql, $sqlParams);
        $res = pegasus_query($sql, $sqlParams);
        while(${$mode}=pegasus_fetch_assoc($res)){
            $total_quan_arr[] = array(  'i24_p01'  => ${$mode}['i24_p01'], 
                                        'i24_dek'  => ${$mode}['i24_dek'], 
                                        'tot_quan' => ${$mode}['tot_quan']
                                    );
        }
        
        
        return $total_quan_arr;       
    }

    /**
     * 
     * @param string  $mode ("a55","a57","a68")
     * @param integer $nr01 
     * @param array   $non_zero_values
     * @param array   $hidden_values
     * @return array 
     */
    function invoices_find_product_totals($mode, $nr01, $non_zero_values=array(), $hidden_values=array(), $lang="GR"){   

        if(!pegasus_mysql_table_exists($mode)){
            return false;
        }

        $totals_arr   = array();
        $products_arr = array();
            

        if($mode=="a57"){
            $sql  = 'select p0100,p0101,p0102,p0112,vp0112,p0113,vp0113, ';
            $sql .= 'p0601,p0600,p0105,p0108,p0109 ';
            $sql .= 'from '. $mode . ' where nr01=?';

            //Υπολογισμός Συνολικού ΕΦΚ και Εισφοράς Ανακύκλωσης

		}elseif($mode=="a67"){
			$sql  = 'select p0100,p0101,p0102,p0112,vp0112,p0113,vp0113, ';
            $sql .= 'p0601,p0600,p0105,p0108,p0109 ';
            $sql .= 'from '. $mode . ' where nr01=?';

            //Υπολογισμός Συνολικού ΕΦΚ και Εισφοράς Ανακύκλωσης

		}elseif($mode=="a55" || $mode=="a56"){            
            $sql  = 'select p411,p413,p417,p418,p0100,p0101,p0102,p0112,vp0112,p0113,vp0113, ';
            $sql .= 'p0601,p0600,p0105,p0108,p0109 ';
            $sql .= 'from '. $mode . ' where nr01=?';    
            
            
            //Υπολογισμός Συνολικού ΕΦΚ και Εισφοράς Ανακύκλωσης
            $type  = ($mode=="a55") ? 2 : 1;
            $query = "SELECT sum(p616*p03) as v616_total, sum(p041*p03) as v1041_total FROM i01 WHERE i01.p06=:nr01 and p07=:type";
            $query_params = array('nr01'=>$nr01, 'type'=>$type);
            pegasus_mysql_use($query, $products_arr, $query_params); 
		}
        
        //echo pegasus_replace_values_in_sql($sql, array($nr01));
        pegasus_mysql_use($sql, ${$mode}, array($nr01)); 

        $index = 0;
        foreach(${$mode} as $key=>$value){
            if(!in_array($key, array('p0101','p0112','p0113'))){
                if($hidden_values[$key]!=true && !($non_zero_values[$key]==true && $value<=0)){
                    $totals_arr[$index]["fld"]   = $key;
                    $totals_arr[$index]["value"] = $value;
                    $totals_arr[$index]["value_formatted"] = number_format($value, 2, $_SESSION['cor000_decimal_char'], "") . "€";
                    
                    $index++;

                    //Add extra custom total fields
                    if($key=='p0102'){
                        foreach($products_arr as $k=>$v){
                            if($hidden_values[$k]!=true){
                                $totals_arr[$index]["fld"]   = $k;
                                $totals_arr[$index]["value"] = $v;
                                $totals_arr[$index]["value_formatted"] = number_format($v, 2, $_SESSION['cor000_decimal_char'], "") . "€";
                                
                                $index++;
                            }
                        }
                    }
                }
            }            
        }

        foreach($totals_arr as $key=>$totals){
            switch ($totals["fld"]) {
                case 'p411':
                    $totals_arr[$key]["title"] = ($lang=="GR") ? "Προηγούμενο Υπόλοιπο" : "Previous Balance Due";
                    break;                
                case 'p413':
                    $totals_arr[$key]["title"] = ($lang=="GR") ? "Νέο Υπόλοιπο" : "Current Balance Due";
                    break;
                case 'p417':
                    $totals_arr[$key]["title"] = ($lang=="GR") ? "Προηγούμενο Υπόλοιπο" : "Previous Balance Due";
                    break;                
                case 'p418':
                    $totals_arr[$key]["title"] = ($lang=="GR") ? "Νέο Υπόλοιπο" : "Current Balance Due";
                    break;
                case 'p0100':
                    $totals_arr[$key]["title"] = ($lang=="GR") ? "Αξία πρό Φ.Π.Α." : "Net";
                    break;
                case 'p0102':
                    $totals_arr[$key]["title"] = ($lang=="GR") ? "Έκπτωση" : "Discount";
                    $totals_arr[$key]["percent"] = number_format(${$mode}["p0101"], 2, $_SESSION['cor000_decimal_char'], "") . "%";
                    break;  
                case 'v616_total':
                    $totals_arr[$key]["title"] = ($lang=="GR") ? "Ε.Φ.Κ. προ ΦΠΑ" : "Net Excise Duty";
                    break;     
                case 'v1041_total':
                    $totals_arr[$key]["title"] = ($lang=="GR") ? "Εισφορά Ανακύκλωσης προ ΦΠΑ" : "Net Electronic Waste Recycling Fee";
                    break;            
                case 'vp0112':   
                    $totals_arr[$key]["title"] = ($lang=="GR") ? "Κρατήσεις" : "Deductions";
                    $totals_arr[$key]["percent"] = number_format(${$mode}["p0112"], 2, $_SESSION['cor000_decimal_char'], "") . "%";
                    break;
                case 'vp0113':
                    $totals_arr[$key]["title"] = ($lang=="GR") ? "Φόρος" : "Tax";
                    $totals_arr[$key]["percent"] = number_format(${$mode}["p0113"], 2, $_SESSION['cor000_decimal_char'], "") . "%";
                    break;
                case 'p0601':
                    $totals_arr[$key]["title"] = ($lang=="GR") ? "Λοιπές Κρατήσεις" : "Other Deductions";
                    break;                
                case 'p0600':
                    $totals_arr[$key]["title"] = ($lang=="GR") ? "Λοιποί Φόροι" : "Other Taxes";
                    break;
                case 'p0105':
                    $totals_arr[$key]["title"] = ($lang=="GR") ? "Φ.Π.Α." : "VAT";
                    break;
                case 'p0108':
                    $totals_arr[$key]["title"] = ($lang=="GR") ? "Επιβαρύνσεις" : "Additional Charges";
                    break;                
                case 'p0109':
                    $totals_arr[$key]["title"] = ($lang=="GR") ? "Πληρωτέο Ποσό" : "Total Amount";
                    break;
            }
        }
        //echo "<pre>". print_r($totals_arr,1) . "</pre>";

        return $totals_arr;
    }
    
    /**
     * Ευρεση της κατηγορίας και τον συντελεστή ΦΠΑ γιά κάθε είδος.
     *
     * $code      = 'Κώδικός του είδους '
     * $kathestos = 'Το καθεστώς' Κωδικος
     * $date      = 'Η ημερομηνία'
     */
    function invoice_find_product_fpa($code, $kathestos , $date ){
            $ret_array = array();
            $ret_array['v101'] = '';
            $ret_array['v108'] = '';
            $ret_array['v105'] = '';
            if(empty($code)){
                return $ret_array;
            }
            
            
            if(empty($date)){
                return $ret_array;
            }
			$query_vals=array();
          	if(!empty($kathestos)){   
	            $query = "SELECT
	                           i00.pno  AS v101, 
	                           i00.fpa  AS v108_a,
	                           if(a27.p3 IS NULL, i00.fpa, a27.p3)   AS v108,
	                           if( i99001.p03 IS NULL,
	                               if(i13.p03 IS NULL, 0, i13.p03),
	                               i99001.p03) AS v105
	                        
	                        FROM i00
	                        LEFT JOIN a27 ON i00.fpa=a27.p2 && a27.p1=:a27_p1
	                        LEFT JOIN i13 ON i13.p01=IF	( a27.p3 IS NULL, i00.fpa, a27.p3 )
	                        LEFT JOIN i99001 ON i99001.p01=i13.p01
	                                         && i99001.p101<=:i99001_p101
	                                         && i99001.p102>=:i99001_p102
	                        WHERE pno=:pno
	                        GROUP BY pno ";
                $query_vals['a27_p1'] = $kathestos;
                $query_vals['i99001_p101'] = $date;
                $query_vals['i99001_p102'] = $date;
                $query_vals['pno'] = $code;
		  	}else{
		  		$query = "SELECT
	                           i00.pno  as v101, 
	                           i00.fpa  as v108_a,
	                           i00.fpa  as v108,
	                           if( i99001.p03 IS NULL,
	                               if(i13.p03 IS NULL, 0, i13.p03), 
                                   i99001.p03) as v105
	                        
	                        FROM i00
	                        LEFT JOIN i13 ON i13.p01=i00.fpa
	                        LEFT JOIN i99001 ON i99001.p01=i13.p01
	                                         && i99001.p101<=:i99001_p101
	                                         && i99001.p102>=:i99001_p102
	                        WHERE pno=:pno
	                        GROUP BY pno;";
                $query_vals['i99001_p101'] = $date;
                $query_vals['i99001_p102'] = $date;
                $query_vals['pno'] = $code;
		  	}
		  
		  
		     
            pegasus_mysql_use($query , $tb , $query_vals);

            $ret_array['v101'] = $tb['v101']; // Kωδικος είδος
            $ret_array['v108'] = $tb['v108']; // Κωδικός Κατηγορίας ΦΠΑ Καθεστώτος
            $ret_array['v105'] = $tb['v105']; // % ΦΠΑ      
            
            return $ret_array;
    }
    
    
    /**
     * H sinarisi ayth mas epistrefei ena array e toys titlous tvn ektypwsen
     * @param string $t07p01 o kwdikow oy katasthmatos
     * @return array
     */
    function invoices_get_store_titles($t07p01 = ''){
        
        $cor000_tit_line = array();
        if($t07p01!='' and pegasus_module_exists('stores')){
            $query = "SELECT eng_tit_line1,  eng_tit_line2, eng_tit_line3, eng_tit_line4, eng_tit_line5, eng_tit_line6, eng_tit_line7, eng_tit_line8,   
                             tit_line1, tit_line2, tit_line3, tit_line4, tit_line5, tit_line6, tit_line7,tit_line8 
                      FROM  t07
                      WHERE p01=:t07p01";
                                
            pegasus_mysql_use($query, $t07ar, array('t07p01'=>$t07p01));
           

            for($i=1; $i<=8; $i++){ 
                $cor000_tit_line[$i-1] = $t07ar['tit_line'.$i];
            }
            for($i=1; $i<=8; $i++){ 
                $cor000_tit_line[$i+7] = $t07ar['eng_tit_line'.$i];
            }

            $empty_store_titles = true;
            foreach ($cor000_tit_line as $title) {
                if(!empty($title)){
                    $empty_store_titles = false;
                    break;
                }
            }

            if(!$empty_store_titles){
                return $cor000_tit_line;
            }
        }
    
        return array(
                $_SESSION['cor000_tit_line1'],
                $_SESSION['cor000_tit_line2'],
                $_SESSION['cor000_tit_line3'],
                $_SESSION['cor000_tit_line4'],
                $_SESSION['cor000_tit_line5'],
                $_SESSION['cor000_tit_line6'],
                $_SESSION['cor000_tit_line7'],
                $_SESSION['cor000_tit_line8'],
                $_SESSION['cor000_eng_tit_line1'],
                $_SESSION['cor000_eng_tit_line2'],
                $_SESSION['cor000_eng_tit_line3'],
                $_SESSION['cor000_eng_tit_line4'],
                $_SESSION['cor000_eng_tit_line5'],
                $_SESSION['cor000_eng_tit_line6'],
                $_SESSION['cor000_eng_tit_line7'],
                $_SESSION['cor000_eng_tit_line8']
        );
    }

     /**
     * H sinartisi ayth tha elegxei an uparxei arxeio logo gia to katasthma
     * @param string $t07p01 o kwdikos toy katasthmatos
     * @return array
     */
    function invoices_get_store_logo_path($a55p0121 = ''){
        
        if(pegasus_module_exists('stores') && $a55p0121!=''){

            $query = "select t07.nr01 from t07 where t07.p01=:p0121";

            pegasus_mysql_use($query  , $t07, array('p0121' => $a55p0121));

            $logo_file_name = stores_get_logo_path($t07['nr01']);
            
            if(file_exists($logo_file_name) ){
                
                return $logo_file_name;
            }
            return '../../images/invoice_logo.png';
        }
        else{
            return '../../images/invoice_logo.png';
        }
          
    }

    /**
     * H sinartisi ayth tha elegxei an uparxei arxeio logo gia to katasthma (watermark)
     * @param string $t07p01 o kwdikos toy katasthmatos
     * @return array
     */
    function invoices_get_store_watermark_logo_path($a55p0121 = ''){

        if(pegasus_module_exists('stores') && $a55p0121!=''){
            
            $query = "select t07.nr01 from t07 where t07.p01=:p0121";

            pegasus_mysql_use($query  , $t07, array('p0121' => $a55p0121));

            $logo_file_name = stores_get_watermark_logo_path($t07['nr01']);

            if(file_exists($logo_file_name) ){
                
                return $logo_file_name;
            }
            return '../../images/invoice_watermark_logo.png';
        }
        else{
            return '../../images/invoice_watermark_logo.png';
        }
    }

    
    function invoices_temp_logo_prepare($width=0, $height=0, $logo_path='../../images/invoice_logo.png'){
        $tmp_logo_dir = '../../images/tmp_invoice_logo/';
        if (!file_exists('../../images')) {
            mkdir('../../images', 0777, true);
        }   
        if (!file_exists('../../images/tmp_invoice_logo')) {
            mkdir('../../images/tmp_invoice_logo', 0777, true);
        }
            
        $temp_arr = explode('/',$logo_path);
        $name = end($temp_arr);
        $temp_arr = explode('.',$name);
        $name = $temp_arr[0];
        
        $image_file_name = $tmp_logo_dir.$name.'_'.$width.'_'.$height.'.png';
        return $image_file_name;
    }
    
    /**
     * @param int       $width
     * @param int       $height
     * @param string    $logo_path
     * @param int       $image_quality
     * @param int       $path_type      {0:relative path οπως ερχεται,  1:relative path χωρίς "../../" ξεκινά όμως απο "/"}
     * @return string
     */
    function invoices_logo_print($width=0, $height=0, $logo_path='../../images/invoice_logo.png', $image_quality=-1, $path_type=0){
            
        $image_file_name = invoices_temp_logo_prepare($width, $height, $logo_path);
        
        if($width==0 && $height==0){
            return '';
        }
        if(!file_exists($logo_path)){
            return '';
        }
        if(  !file_exists($image_file_name) || 
            !(filemtime($image_file_name)>filemtime($logo_path))  ){
            invoices_logo_format($width, $height, $logo_path, $image_quality);
        }
        
        if($path_type==1){
            //Προέκυψε η ανάγκη διαχείρισης του path για τις εκφράσεις HTML στις Φόρμες Εκτύπωσης 
            $image_file_name = str_replace("../", "", $image_file_name);
            if(substr($image_file_name, 0, 1)!="/"){
                $image_file_name = "/".$image_file_name;
            }
        }

        return $image_file_name;
    }
    
    function invoices_logo_format($width=0, $height=0, $logo_path='../../images/invoice_logo.png', $image_quality=-1){
    
        $image_file_name = invoices_temp_logo_prepare($width, $height, $logo_path);
        if($width==0 && $height==0){
            return '';
        }
        
        
        $sizes = getimagesize( $logo_path );
        $fsize = filesize($logo_path);
        
        $original_width  = $sizes[0];
        $original_height = $sizes[1];
        $original_ratio = $original_width / $original_height;
        
        //Avoid division by zero
        if($original_ratio<0.0001){
            $original_ratio = 0.1;
        }
        
        /*START: Format Desired image dimensions
         * If height or width not defined find them
         * If desired image bigger than original, reset the desired with/height*/
        if($height == 0){
            $height=round($width/$original_ratio,0);
        }   
        else if($width == 0){
            $width=$original_ratio*$height;
        }
    
        $desired_width = $width;
        $desired_height = $height;
        
        //Avoid creating images bigger than the original image
        if((($width > $original_width) || ($height > $original_height))){
            if($width > $original_width){
                $width = $original_width;
            }
            if($height > $original_height){
                $height = $original_height;
            }   
        }
        //END: Format Desired image dimensions  
        
        //Keep original image ratio
        $new_width = $width;
        $new_height=round($new_width/$original_ratio,0);
        
        //only for extra long images - not really a case
        if($new_height == 0){
            $new_height = 1;
        }
        if($new_height > $height){
            $new_height = $height;
            $new_width=round($new_height*$original_ratio,0);    
            //only for extra tall images - not really a case
            if($new_width == 0){
                $new_width = 1;
            }
        }
        //Delete old file
        if(file_exists($image_file_name)){
            unlink($image_file_name);
        }
        $image = imagecreatefrompng ( $logo_path );
        
        //$image_p = imagecreatetruecolor($new_width, $new_height);
        $image_p = imagecreatetruecolor($desired_width , $desired_height );
        
        //If image transparent -> Fill with white
        $white = imagecolorallocate($image_p, 255, 255, 255);
        imagefilledrectangle($image_p, 0, 0, $desired_width , $desired_height , $white);
    
        /*imagealphablending($image_p, false);
        $transparency = imagecolorallocatealpha($image_p, 0, 0, 0, 127);
        imagefill($image_p, 0, 0, $transparency);
        imagesavealpha($image_p, true); 
        */
        
        //Position image created in the center
        $dst_x = $desired_width - $new_width;
        if($dst_x>0){
            $dst_x = $dst_x/2;
         }
         else{
            $dst_x = 0;
         }
         $dst_y = $desired_height - $new_height;
         if($dst_y>0){
            $dst_y = $dst_y/2;
         }
         else{
            $dst_y = 0;
         }  
        
        
        $ok = imagecopyresampled($image_p, $image, $dst_x, $dst_y, 0, 0, $new_width, $new_height, $original_width, $original_height);
        
        if($ok){
            $ok = imagepng($image_p, $image_file_name, $image_quality, PNG_ALL_FILTERS);
        }
        if($ok){
            return $image_file_name;
        }
    
        return '';
    }

    
    /*Check if custom logo to be printed is the default or not
     * p.e. we had uploaded a custom logo for the ordercust landscape printout. 
     * If changed by customer, print it . Else print the default invoice logo */
    function peg_invoices_custom_logo_path($current_p85_logo ='',$standard_p85_logo='', $p85_nr01=0){
    
        //Ean den yparxei fwtografia tou basikou logo den exei nohma na kanw kanenan elegxo
        if(!file_exists('../../images/invoice_logo.png')){
            return $current_p85_logo;
        }
        //Ean den yparxei to arxeio katholou    
        if(!file_exists($current_p85_logo)){
            return '../../images/invoice_logo.png';
        }
            
        if($standard_p85_logo == ''){
            $standard_p85_logo = "../../pegasus_cloud_app/invoices_images/".$p85_nr01."_logo.png";
        }
        if(!file_exists($standard_p85_logo)){
            return $current_p85_logo;
        }
        if(peg_invoices_check_if_same_image($current_p85_logo, $standard_p85_logo)){
            return '../../images/invoice_logo.png';
        }
    
        return $current_p85_logo;   
    } 
       
    
    /**
     * Eυρεση τις συνολικής τιμής 
     *
     * params
     * ------
     * $v103  = Ποσοτητά
     * $v104  = Τιμή Μονάδας 
     * $v105  = Κατηγορία Φ.Π.Α. 
     * $v106  = Εκπτώση 1ή
     * $v106a = Εκπτώση 2ή
     * $v1041 = Εισφορά ανακύλωσης
     * $v616  = Ειδικός Φόρος Κατάναλωσης
     * $preview_wth_vat = Οι τιμές περιέχουν
     * $v1042 = Επιπλέον Αξία
     * $decimals = Δεκαδικά στρογγυλοποίησης - Αλλάζει μόνο σε ειδικές περιπτώσεις
     * 
     * Return
     * ------
     * 
     */
    //Προσθήκη νέας παραμέτρου $v1042 = Επιπλέον Αξία στο τέλος
    function invoices_make_product_total( $v103 , $v104 , $v105 , $v106=0 , $v106a=0 ,$v1041=0 , $v616=0 , $preview_wth_vat=0, $v1042=0, $decimals = 2){
        // echo ' v103: ' . $v103 . ' v104: ' . $v104 . ' v105: ' . $v105 . ' v106 ' . $v106 . ' v106a ' . $v106a . '  v1042: ' . $v1042 . ' v616: ' . $v616 . ' ' . $preview_wth_vat .' --- ';
        $timh = 0;
        
        if($preview_wth_vat==1){
            $v1041 = $v1041 * (100 + $v105) / 100;
            $v616  = $v616  * (100 + $v105) / 100;        
        }

        /* Σύνολο */
        $timh = ($v103 * $v104 * ((100 - $v106) / 100) * ((100 - $v106a) / 100)) + ($v1041*$v103) + ($v616*$v103) + $v1042;
        
        $timh = round($timh, $decimals);
        
        return $timh;       
    }

    /**
     * Eυρεση ΕΦΚ Είδους
     */
    function invoices_make_product_v616($v616, $v105, $preview_wth_vat=0){

        if($preview_wth_vat==1){
            $v616 = round($v616 * ((100 + $v105)/100), 5);      
        }else{
            return $v616; 
        }
        
        return $v616;        
    }

    /**
     * Eυρεση Εισφοράς Ανακύκλωσης Είδους
     */
    function invoices_make_product_v1041($v1041, $v105, $preview_wth_vat=0){

        if($preview_wth_vat==1){
            $v1041 = round($v1041 * ((100 + $v105)/100), 5);      
        }else{
            return $v1041; 
        }
        
        return $v1041;        
    }

    function invoices_make_product_cs_serial_lots($rel_trans_id, $nr01, $mode){

        $mmnr01 = $mode.'_d-' . $rel_trans_id;
        if($mode == 'a55' || $mode == 'a56' || $mode == 'a60' || $mode==''){
            $product_table = 'peg_tmp_i01';
            $cs_table = 'peg_tmp_i48';
            $rel_trans_id_where =	" where peg_tmp_i01.p06=:rel_trans_id and peg_tmp_i01.nr01=:nr01_1"; //i01.p06 : ΜΚ Σχετικής Κίνησης
            $i00_join = " left join i00 on peg_tmp_i01.p01 = i00.pno "; 
        }
        
        if($mode == 'a57'){
            $product_table = 'peg_tmp_a58';
            $cs_table = 'peg_tmp_a59';
            $rel_trans_id_where =	" where peg_tmp_a58.p00=:rel_trans_id and peg_tmp_a58.nr01=:nr01_1"; //a58.p00 ΜΚ Σχετικής Κίνησης
            $i00_join = " left join i00 on peg_tmp_a58.v101 = i00.pno ";
        }
    
        if($mode == 'a67'){
            $product_table = 'peg_tmp_a68';
            $cs_table = 'peg_tmp_a69';
            $rel_trans_id_where =	" where peg_tmp_a68.p00=:rel_trans_id and peg_tmp_a68.nr01=:nr01_1"; //a68.p00 ΜΚ Σχετικής Κίνησης
            $i00_join = " left join i00 on peg_tmp_a68.v101 = i00.pno "; 
        }

        if($mode == 'a61'){
            $product_table = 'peg_tmp_a62';
            $cs_table = 'peg_tmp_a63';
            $rel_trans_id_where =	" where peg_tmp_a62.p00=:rel_trans_id and peg_tmp_a62.nr01=:nr01_1"; //a62.p00 ΜΚ Σχετικής Κίνησης
            $i00_join = " left join i00 on peg_tmp_a62.v101 = i00.pno ";
        }
        $values = array();

        $sql_fields = "";
		$color_size      = "";
		if(pegasus_module_exists('colorsize')){
			//Χρειάζομαι το distinct για την περίπτωση όπου έχω και πολλαπλά χρώματα μεγέθη
			$color_size_tmp = ", group_concat(distinct if(".$cs_table.".nr01 IS NULL || i40.p01 IS NULL || i43.p01 IS NULL, '', ##color_size##) SEPARATOR ',\\n') as color_size";
			$color_size =  "concat(i40.p02, IF(i40.p02='', '', '-'), i43.p02, ' x ', Format(".$cs_table.".p04, i24.dek))";
			$color_size = str_replace("##color_size##", $color_size, $color_size_tmp);
			$sql_fields .= $color_size;
		}

		$serials          = '';
		if(pegasus_module_exists('serial')){
			//Χρειάζομαι το distinct για την περίπτωση όπου έχω και πολλαπλά serial
			$serials = ", group_concat(distinct if(peg_tmp_i32.nr01 IS NULL, '', concat(peg_tmp_i32.p02, '', if(i31.p015!='', concat('\n', i31.p015), '')) ) SEPARATOR ',\n') as serials";
			$sql_fields .= $serials;
		}

		$lots = '';
		if(pegasus_module_exists('lot')){
			//Χρειάζομαι το distinct για την περίπτωση όπου έχω και πολλαπλά Lot
			$concat_lot  = "if(peg_tmp_i38.p04>0, concat(peg_tmp_i38.p02,' ',' (',peg_tmp_i38.p04,')'),'' )";    
			$lots = ", group_concat(distinct if(peg_tmp_i38.nr01 IS NULL, '', ".$concat_lot." ) SEPARATOR ',\\n') as lots";
			$sql_fields .= $lots;
		}
		$sql  = " (select ".$product_table.".nr01 as nr01 ";
        $sql .= $sql_fields;
        $sql .=	" from ".$product_table;
        $sql .= $i00_join ; //join με αποθήκη
        $sql .= " left join i24 on i00.ths = i24.p01 ";
        $extra_cs = "";
        if(pegasus_module_exists('colorsize')){
            $sql .=	" left join ".$cs_table." on ".$cs_table.".p01=".$product_table.".nr01 ";
            
            $extra_cs = " and ".$cs_table.".peg_flag!=9 and ".$cs_table.".p01=:nr01_2
            and ".$cs_table.".peg_sess_id=:session_id_1
            and ".$cs_table.".peg_mnr01=:nr01_3 
            and ".$cs_table.".peg_mmnr01=:mmnr01_1";
           
            $sql .= $extra_cs;

            $sql .=	" left join i40 on i40.p01=".$cs_table.".p02 ";
            $sql .=	" left join i43 on i43.p01=".$cs_table.".p03 ";
            
            $values['nr01_2'] = $nr01;
            $values['nr01_3'] = $nr01;
            $values['session_id_1'] = session_id();
            $values['mmnr01_1'] = $mmnr01;
        }

        $extra_serial = "";
        if(pegasus_module_exists('serial')){
            $sql .=	" left join peg_tmp_i32 on peg_tmp_i32.p00=".$product_table.".nr01  ";   
            $extra_serial = ' and peg_tmp_i32.peg_flag!=9 and peg_tmp_i32.p00=:nr01_4
            and peg_tmp_i32.peg_sess_id=:session_id_2
            and peg_tmp_i32.peg_mnr01=:nr01_5 
            and peg_tmp_i32.peg_mmnr01=:mmnr01_2';
            $sql .= $extra_serial;

            $sql .=	" left join i31 on peg_tmp_i32.p02=i31.p02 " ;
            
            $values['nr01_4'] = $nr01;
            $values['nr01_5'] = $nr01; 
            $values['session_id_2'] = session_id();    
            $values['mmnr01_2'] = $mmnr01;
        }

        $extra_lot = "";
        if(pegasus_module_exists('lot')){
            $sql .=	" left join peg_tmp_i38 on peg_tmp_i38.p01=".$product_table.".nr01 "; //todo
            $extra_lot = ' and peg_tmp_i38.peg_flag!=9 and peg_tmp_i38.p01=:nr01_6
            and peg_tmp_i38.peg_sess_id=:session_id_3
            and peg_tmp_i38.peg_mnr01=:nr01_7 
            and peg_tmp_i38.peg_mmnr01=:mmnr01_3';
            $sql .= $extra_lot;
            
            $values['nr01_6'] = $nr01;
            $values['nr01_7'] = $nr01;
            $values['session_id_3'] = session_id(); 
            $values['mmnr01_3'] = $mmnr01;
        }

        $sql .=	$rel_trans_id_where;
        $sql .= " group by ".$product_table.".nr01 ";
        $sql .= ")"; 

        $values['rel_trans_id'] = $rel_trans_id;
        $values['nr01_1'] = $nr01;
        // die(pegasus_replace_values_in_sql($sql, $values));
		pegasus_mysql_use($sql, $cs_serial_lots, $values);  
        return $cs_serial_lots;       
    }

    /**
     * @param v101: Δεν χρησιμοποιείται πια, ήταν Κωδικός είδους
     * @param v104: Τιμή Μονάδας
     * @param discount_1
     * @param discount_2
     * @param v105 : Ποσοστό ΦΠΑ
     * @param p07 : Τιμές με ΦΠΑ
     * @param &$v616: ΕΦΚ ανά μονάδα
     * @param $v616p: %ΕΦΚ
     */
    function invoices_calculate_EFK($v101,$v104,$discount_1,$discount_2,$v105,$p07,&$v616,$v616p){

		if(!($v616p>0)){/* An den upologizetai apo pososto */
			return $v616;
		}
		//E.F.K 
		if($p07==0){  		
            $v616= round($v104* ( ($_SESSION['f01_p015']!=1) ? (100-$discount_1)*(100-$discount_2)/10000  :  1) * ($v616p/100),  $_SESSION['f01_p012']); 
		}else{ 
            /* Times me FPA: Το ΕΦΚ υπολογίζεται στην τιμή χωρίς ΦΠΑ*/
            $v616 = round($v104* ( ($_SESSION['f01_p015']!=1) ?  (100-$discount_1)*(100-$discount_2)/10000  :  1) * (100/(100+$v105)) * ($v616p/100),  $_SESSION['f01_p012']);      
		}
		return $v616;
	}
	function invoices_find_qrcode($a55_nr01, $copy=0, $type="POLPA"){
		return pegasus_mysql_printfld('p30', 'p134', ' p01=:p01 and p02=:nr01 and p04=:p04 ' , array('p01' => $type, 'nr01' => $a55_nr01, 'p04' => $copy));
	}	

    /**
     * Η συνάρτηση αυτή βρίσκει το λεκτικό Πρωτότυπο/Αντίγραφο - Ελληνικά/Αγγλικά
     */
    function invoices_print_orig_copy_dic($copy=0, $lang="GR"){
        
        if($copy == 0 ){
            if($lang=="GR"){
                return  $_SESSION['peg_dic_invoices_original'];
            }else{
                return  $_SESSION['peg_dic_invoices_original_en'];
            }
        }else{
            if($lang=="GR"){
                return  $_SESSION['peg_dic_invoices_copy'];
            }else{
                return  $_SESSION['peg_dic_invoices_copy_en'];
            }
        }
    }

    
    function invoices_get_store_footer($t07p01 = ''){
        if ($t07p01!='' && pegasus_module_exists('stores')) {

            $cor000_ftr_line['5'] = '';
            $cor000_ftr_line['6'] = '';
            $cor000_ftr_line['7'] = '';
            $cor000_ftr_line['8'] = '';
            $cor000_ftr_line['9'] = '';

            $query = "SELECT eftr001,eftr002, eftr003, eftr004, eftr005, ftr001,ftr002, ftr003, ftr004, ftr005
                        FROM  t07
                        WHERE p01=:t07p01";
            pegasus_mysql_use($query, $t07ar, array('t07p01' => $t07p01));
            if (!empty($t07ar['eftr001'])
                || !empty($t07ar['eftr002'])
                || !empty($t07ar['eftr003'])
                || !empty($t07ar['eftr004'])
                || !empty($t07ar['eftr005'])) {
                $cor000_ftr_line['5'] = $t07ar['eftr001'];
                $cor000_ftr_line['6'] = $t07ar['eftr002'];
                $cor000_ftr_line['7'] = $t07ar['eftr003'];
                $cor000_ftr_line['8'] = $t07ar['eftr004'];
                $cor000_ftr_line['9'] = $t07ar['eftr005'];
            }

            if (!empty($t07ar['ftr001']) 
                || !empty($t07ar['ftr002'])
                || !empty($t07ar['ftr003'])
                || !empty($t07ar['ftr004'])
                || !empty($t07ar['ftr005'])
            ) {
                $cor000_ftr_line['0'] = $t07ar['ftr001'];
                $cor000_ftr_line['1'] = $t07ar['ftr002'];
                $cor000_ftr_line['2'] = $t07ar['ftr003'];
                $cor000_ftr_line['3'] = $t07ar['ftr004'];
                $cor000_ftr_line['4'] = $t07ar['ftr005'];
            }

            $empty_store_titles = true;
            foreach ($cor000_ftr_line as $title) {
                if(!empty($title)){
                    $empty_store_titles = false;
                    break;
                }
            }

            if(!$empty_store_titles){
                return $cor000_ftr_line;
            }
        }
        
        return array(
            $_SESSION['f02_ftr001'],
            $_SESSION['f02_ftr002'],
            $_SESSION['f02_ftr003'],
            $_SESSION['f02_ftr004'],
            $_SESSION['f02_ftr005'],
            $_SESSION['f02_eftr001'],
            $_SESSION['f02_eftr002'],
            $_SESSION['f02_eftr003'],
            $_SESSION['f02_eftr004'],
            $_SESSION['f02_eftr005']
        );
    }
?>