<?php
	require_once('../ordercust00/header.php');

    global $PegInput;
    $PegInput->addVar(new peg_input_alphanumeric('tbl'));
    $PegInput->addVar(new peg_input_number('tbl_nr01'));

    $tbl      = $PegInput->getRequest('tbl');
    $tbl_nr01 = $PegInput->getRequest('tbl_nr01');

    $ret_array = array();
	$ret_array['ok']  = 0;

    if($tbl == "a57") {
        $product_tbl = "peg_tmp_a58";
        $color_tbl   = "peg_tmp_a59";
    } else if($tbl == "a67") {
        $product_tbl = "peg_tmp_a68";
        $color_tbl   = "peg_tmp_a69";
    } else if($tbl == "a61") {
        $product_tbl = "peg_tmp_a62";
        $color_tbl   = "peg_tmp_a63";
    } else {
        echo json_encode($ret_array);
        return;        
    }

    $query_tbl = "SELECT nr01, (v103 - v109) as uninvoiced_quantity 
                  FROM $product_tbl
                  WHERE p00 = :tbl_nr01 
                    AND peg_flag != 9 
                    AND peg_sess_id = :sess_id
                    AND peg_mmnr01 = :mmnr01
                    AND peg_mnr01 = :mnr01";

    $res = pegasus_query($query_tbl, array('tbl_nr01' => $tbl_nr01, 'sess_id' => session_id(), "mmnr01" => $tbl."_d-".$tbl_nr01, "mnr01" => $tbl_nr01));

    while($row = pegasus_fetch_assoc($res)) {
        if($row['uninvoiced_quantity'] > 0) {
            continue;
        }

        $params = array(
            "nr01"    => $row['nr01'],
            "sess_id" => session_id(),
            "mmnr01"  => $tbl."_d-".$tbl_nr01,
            "mnr01"   => $row['nr01']
        );

        if(pegasus_module_exists("serial")) {
            $i32_array = array();
            $i32_array['peg_flag'] = 9;

            pegasus_mysql_update("peg_tmp_i32", array_keys($i32_array), array_values($i32_array), "p00 = :nr01 AND peg_flag != 9 AND peg_sess_id = :sess_id AND peg_mmnr01 = :mmnr01 AND peg_mnr01 = :mnr01", 0, 1, 1, $params);
        }

        if(pegasus_module_exists("lot")) {
            $i38_array = array();
            $i38_array['peg_flag'] = 9;

            pegasus_mysql_update("peg_tmp_i38", array_keys($i38_array), array_values($i38_array), "p01 = :nr01 AND peg_flag != 9 AND peg_sess_id = :sess_id AND peg_mmnr01 = :mmnr01 AND peg_mnr01 = :mnr01", 0, 1, 1, $params);
        }

        if(pegasus_module_exists("colorsize")) {
            $color_array = array();
            $color_array['peg_flag'] = 9;

            pegasus_mysql_update($color_tbl, array_keys($color_array), array_values($color_array), "p01 = :nr01 AND peg_flag != 9 AND peg_sess_id = :sess_id AND peg_mmnr01 = :mmnr01 AND peg_mnr01 = :mnr01", 0, 1, 1, $params);
        }

        $ret_array['ok'] = 1;

        $product_array = array();
        $product_array['peg_flag'] = 9;

        pegasus_mysql_update($product_tbl, array_keys($product_array), array_values($product_array), "nr01 = :nr01", 0, 1, 1, array("nr01"=>$row['nr01']));
    }

	echo json_encode($ret_array);
