<?php
require_once('../invoices00/header.php');

global $PegInput;

$PegInput->addVar(new peg_input_number('nr01'));
$PegInput->addVar(new peg_input_number('p03'));
$PegInput->addVar(new peg_input_number('p07'));
$PegInput->addVar(new peg_input_number('p703'));
$PegInput->addVar(new peg_input_number('p09'));
$PegInput->addVar(new peg_input_alphanumeric('date'));
$PegInput->addVar(new peg_input_alphanumeric('mode'));
$PegInput->addVar(new peg_input_number('cona11_nr01'));
$PegInput->addVar(new peg_input_alphanumeric('container_id'));
$PegInput->addVar(new peg_input_alphanumeric('last_price'));

$nr01 = $PegInput->getRequest('nr01'); // ΜΚ Παραστατικού/Παραγγελίας
$p03  = $PegInput->getRequest('p03');  // Πελάτης/Προμηθευτής
$p07  = $PegInput->getRequest('p07');  // Τιμές με ΦΠΑ
$p703 = $PegInput->getRequest('p703'); // Αποθήκη
$p09  = $PegInput->getRequest('p09');  // Καθεστώς ΦΠΑ
$date = $PegInput->getRequest('date'); // Ημερομηνία
$mode = $PegInput->getRequest('mode'); // a55/a56/a57/a67/a60/a61/retail00_01
$cona11_nr01  = $PegInput->getRequest('cona11_nr01');
$container_id = $PegInput->getRequest('container_id');

// search: θα αναζητάει αν υπάρχει τελευταία τιμή πώλησης/αγοράς υπό περιπτώσεις, αν ναι θα εμφανίζεται confirmbox
// recalc_last_price: θα προσχωράει στην επανεύρεση τιμών με την τελευταία τιμή πώλησης/αγοράς
// "" (κενό): θα προσχωράει στην επανεύρεση τιμών από τα είδη αποθήκης
$last_price = $PegInput->getRequest('last_price');

//* 21/06/2023 - Προς το παρόν αυτά έρχονται συμπληρωμένα μόνο από Retail
$p03_p48  = 0; // Βασικός Τιμοκατάλογος
$p03_p06  = 0; // Ειδικός Τιμοκατάλογος
$p03_p52  = 0; // %Έκπτωση 1
$p03_p52a = 0; // %Έκπτωση 2
$p03_p523 = 0; // %Επιβάρυνσης

if($mode == "retail00_01") {
    $PegInput->addVar(new peg_input_number('p03_p48'));
    $PegInput->addVar(new peg_input_number('p03_p06'));
    $PegInput->addVar(new peg_input_number('p03_p52'));
    $PegInput->addVar(new peg_input_number('p03_p52a'));
    $PegInput->addVar(new peg_input_number('p03_p523'));
    
    $p03_p48  = $PegInput->getRequest('p03_p48');  // Βασικός Τιμοκατάλογος
    $p03_p06  = $PegInput->getRequest('p03_p06');  // Ειδικός Τιμοκατάλογος
    $p03_p52  = $PegInput->getRequest('p03_p52');  // %Έκπτωση 1
    $p03_p52a = $PegInput->getRequest('p03_p52a'); // %Έκπτωση 2
    $p03_p523 = $PegInput->getRequest('p03_p523'); // %Επιβάρυνσης
}

if($last_price == "search") {
    $get_last_sale_purchase_array = invoices_search_for_last_sale_purchase_price($container_id, $mode, $p03);

    if($get_last_sale_purchase_array['last_sale_purchase_price'] == 1) {
        echo json_encode($get_last_sale_purchase_array);
        return;
    }
}

$ret_array = array();
$ret_array['ok']  = 1;
$ret_array['msg'] = '';
$ret_array['last_sale_purchase_price'] = 0;

$get_last_prices = 0;
if($last_price == "recalc_last_price") {
    $get_last_prices = 1;
}

$recalculate_prices_array = invoices_recalulate_prices(
    $mode,
    $container_id,
    $p03,
    $p07,
    $p703,
    $kath_fpa,
    $date,
    $nr01,
    $cona11_nr01,
    $p03_p48,
    $p03_p06,
    $p03_p52,
    $p03_p52a,
    $p03_p523,
    $get_last_prices
);

if(!$recalculate_prices_array['ok']) {
    $ret_array['ok']  = 0;
    $ret_array['msg'] = 'Failed to calculate prices';
}

echo json_encode($ret_array);
return;