function peg_i01_001(container_id){
	var peg_tmpp03=pegGetVal('p03', container_id);
	var peg_tmpp04=pegGetVal('p04', container_id);
	if(peg_tmpp03==null){peg_tmpp03=0};
	if(peg_tmpp04==null){peg_tmpp04=0};

	pegSetVal('p011', container_id, peg_tmpp03*peg_tmpp04); 
	pegSetVal('p022', container_id, peg_tmpp03*peg_tmpp04); 

}
var invtrans_i01_d100_search_ajax ='';
function invtrans_i01_d100_afterDraw_listeners(container_id){
	var screen = pegGetCmp(container_id );
	let i01_d1001_grid_container_id = pegGetContainer_id_d(container_id,'i01_d1001','','i01_d100');
	let i01_d1002_grid_container_id = pegGetContainer_id_d(container_id, 'i01_d1002', '', 'i01_d100');
	let i01_d1003_grid_container_id = pegGetContainer_id_d(container_id, 'i01_d1003', '', 'i01_d100');
	let i01_d1006_grid_container_id = pegGetContainer_id_d(container_id, 'i01_d1006', '', 'i01_d100');
	let i01_d1004_grid_container_id = pegGetContainer_id_d(container_id, 'i01_d1004', '', 'i01_d100');
	let i51_d00_grid_container_id = pegGetContainer_id_d(container_id, 'i51_d00', '', 'i01_d100');
	let i01_d1004_grid = pegGetCmp(i01_d1004_grid_container_id, 'grid01');		
	let but01 = pegGetCmp(container_id,'but01');
	let but02 = pegGetCmp(container_id,'but02');

	but01.on('click',function(me){
		if (invtrans_i01_d100_search_ajax != '') {
			if (invtrans_i01_d100_search_ajax.id > 0) {
				Ext.ux.AjaxDefer.abort(invtrans_i01_d100_search_ajax);
			}
		}
		params = {};
		params.container_id = container_id;
		params.t_lo = pegGetVal('t_lo', container_id);
		params.t_ka = pegGetVal('t_ka', container_id);
		params.t_df = pegGetVal('t_df', container_id);
		params.t_dt = pegGetVal('t_dt', container_id);

		invtrans_i01_d100_search_ajax = pegAjaxDefer('/' + main_path + '/invtrans01/set_i01_d100_params.php', params, function (jsondata) {
			pegGridRefresh(i01_d1001_grid_container_id,'grid01',0);
			pegGridRefresh(i01_d1002_grid_container_id,'grid',0);
			pegGridRefresh(i01_d1003_grid_container_id,'grid',0);
			pegGridRefresh(i01_d1006_grid_container_id,'grid01',0);
			pegGridRefresh(i01_d1004_grid_container_id,'grid01',0);
			pegGridRefresh(i51_d00_grid_container_id,'grid01',0);
		});
	})

	but02.setPeg_handler(function(me){
		peg_windowShow_d(
			'',
			'invtrans_browse_i01_d100' ,
			'invtrans',
			container_id,
			'',
				0 ,
			'',
			'',  
			{
				peg_screen_parent_container_id:container_id
			},
			false,true,0,0,'tablet' 
		);
	});
	
}

function invtrans_i01_d90_afterDraw_listeners(container_id){
	let i01_d1004_grid_container_id = pegGetContainer_id_d(container_id, 'i01_d1004', '', 'i01_d90');
	let i01_d1004_grid = pegGetCmp(i01_d1004_grid_container_id, 'grid01');		

	let i00_d_container_id = pegGetContainer_id_d(container_id, 'i00_d', '', 'i00_d');
	//i01_d1004
	var i01_d1004_mmnr01_arr = i01_d1004_grid.getMmnr01().split('-');

	i01_d1004_grid.peg_isEditable = true;	/*Ενεργοποιώ το is_editable*/

	i01_d1004_grid.on('edit', function(editor, context) {  
		var values = {};
		values = context.record.data;
		
		if(values && values['nr01']<0){
			values['nr01'] = 0;
			values['p01'] = pegGetVal( 'pno' , i00_d_container_id);
		}
		
		pegSave_grid_row( 
			i01_d1004_grid.peg_view__d ,
			i01_d1004_grid.peg_view_table , 
			i01_d1004_grid.peg_view_module  ,
			i01_d1004_mmnr01_arr[1],		//mnr01  
			i01_d1004_grid.getMmnr01(), 	//mmnr01
			values , 
			function(jsonData){   
				if(!jsonData.ok){  
					context.record.reject();
					pegToast(jsonData.message, 'alert');
				}else{
					context.record.data['nr01'] = jsonData.nr01;
					context.record.commit();
				}
			}
		);
		
	});

	i01_d1004_grid.on('canceledit', function(editor, context) {  
		context.record.reject();  
	}); 

	let i48_d102_grid_container_id = pegGetContainer_id_d(container_id, 'i48_d102', '', 'i01_d90');
	let i48_d102_grid = pegGetCmp(i48_d102_grid_container_id, 'grid01');	

	var i48_d102_mmnr01_arr = i48_d102_grid.getMmnr01().split('-');

	i48_d102_grid.peg_isEditable = true;	//*Ενεργοποιώ το is_editable*/

	i48_d102_grid.on('edit', function(editor, context) {  
		var values = {};
		values = context.record.data;

		if(values && values['nr01']<0){
			values['nr01'] = 0;
			values['p01'] = pegGetVal( 'pno' , i00_d_container_id);
		}
		
		pegSave_grid_row( 
			i48_d102_grid.peg_view__d ,
			i48_d102_grid.peg_view_table , 
			i48_d102_grid.peg_view_module  ,
			i48_d102_mmnr01_arr[1],		//mnr01  
			i48_d102_grid.getMmnr01(), 	//mmnr01
			values , 
			function(jsonData){   
				if(!jsonData.ok){  
					context.record.reject();
					pegToast(jsonData.message, 'alert');
				}else{
					context.record.data['nr01'] = jsonData.nr01;
					context.record.commit();
				}
			}
		);
		
	});

	i48_d102_grid.on('canceledit', function(editor, context) {  
		context.record.reject();  
	}); 
}
var account_i01_d1005_search_ajax='';	
function invtrans_i01_d1005_afterDraw_listeners(container_id){

	var but01  = pegGetCmp(container_id, 'but01');
	var a01_container_id = pegGetContainer_id_d(container_id, 'a01_d', '', 'a01_d');
	let container_id_main = pegGetContainer_id_d(container_id, 'i01_d1005', '', 'i01_d1005');	
	let i01_d10051_container = pegGetContainer_id_d(container_id, 'i01_d10051', '', 'i01_d1005');	
	let i01_d10052_container = pegGetContainer_id_d(container_id, 'i01_d10052', '', 'i01_d1005');	

	var mode = "";

	if(a01_container_id !== ""){
		mode = 'a01';
	}
	else{
		mode = 'a00';
	}

	but01.setPeg_handler(function (me) {

		params = {};
		params.container_id = container_id_main;
		params.mode 	 = mode;
		params.p_log 	 = pegGetVal('p_log', container_id);
		params.p_kat 	 = pegGetVal('p_kat', container_id);
		params.p_apoth 	 = pegGetVal('p_apoth', container_id);
		params.p_ypo_a71 = pegGetVal('p_ypo_a71', container_id);
		params.p_ypo_a76 = pegGetVal('p_ypo_a76', container_id);
		params.p_col 	 = pegGetVal('p_col', container_id);
		params.p_df 	 = pegGetVal('p_df', container_id);
		params.p_dt 	 = pegGetVal('p_dt', container_id);

		if (account_i01_d1005_search_ajax != '') {
			if (account_i01_d1005_search_ajax.id > 0) {
				Ext.ux.AjaxDefer.abort(account_i01_d1005_search_ajax);
			}
		}

		account_i01_d1005_search_ajax = pegAjaxDefer('/' + main_path + '/invtrans01/i01_d1005.php',params,function (jsonData) {
				pegGridRefresh(i01_d10051_container, 'grid');
				pegGridRefresh(i01_d10052_container, 'grid');
		});
	});

}


function invtrans_i01_d_afterDraw_listeners(container_id){
	var screen = Ext.getCmp(container_id );
	
	var p03 = peg_peg002_getCmp(container_id+'_p03');
	var p04 = peg_peg002_getCmp(container_id+'_p04');

	//Στο p02 σετάρω το displayfield του p01 
	if(peg_peg002_getCmp(container_id+'_p01').peg_selectboxClassId){ //Εάν είμαι σε selectbox
		var p01 = peg_peg002_getCmp(peg_peg002_getCmp(container_id+'_p01').peg_selectboxClassId);
		var p01ValueField = peg_peg002_getCmp(p01.peg_getValueID());
		p01ValueField.on('change', function(me, newValue, oldValue, eOpts ){
			if(newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue) )){
				return ;
			} 
			pegSetVal('p02' , container_id ,  newValue);
		});
	} else {//Εάν είμαι σε combobox
		var p01 = peg_peg002_getCmp(container_id+'_p01');
		p01.on('change', function(me, newValue, oldValue, eOpts ){
			if(newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue) )){
				return ;
			}

			invtrans_refresh_i01_cost_unit(container_id, newValue);
			pegSetVal('p02' , container_id ,  p01.getRawValue());
			pegSetVal('v_pno' , container_id ,  newValue);
		});
	}

	p03.on('change', function( me, newValue, oldValue, eOpts ){
		peg_i01_001(container_id);
	});
	p04.on('change', function( me, newValue, oldValue, eOpts ){
		peg_i01_001(container_id);
	});

}	

function invtrans_i01_relation(container_id,rel_nr01,mode){
	if(mode!='a00' && mode!='a01'&& mode!='i48'){
		mode='i01';
	}
	var rel_params = {mode:mode};
	if (!(rel_nr01>0)){
		let row;
		if(mode=='i01' || mode=='i48'){
			row = pegGridGetSelectedRow(container_id, 'grid01');
			rel_params.nr01 = row.nr01;
		} else {
			row = pegGridGetSelectedRow(container_id, 'grid');
			rel_params.nr01 = row.p01;
		}
	}else{
		rel_params.nr01 = rel_nr01;
	}
	pegAjaxDefer('/' + main_path + '/invtrans01/i01_relation.php', rel_params , 
		function(jsonData){
			if(jsonData.ok==1){
				pegAddTab_d('' , jsonData.view_table  , jsonData.view_d  , jsonData.view_module  , ''  , jsonData.view_nr01  , '' );   				
			}else{
				pegAlert(jsonData.msg);
			}
		} , 'json' , true);		
}

function invtrans_i01_d100_custom_actions(container_id) {
	let screen = pegGetCmp(container_id); 
	if (screen.peg__d =='i01_d1001'){
		invtrans_i01_relation(container_id);
	} else if (screen.peg__d == 'i01_d1002') {
		invtrans_i01_relation(container_id,0,'a01');
	} else if (screen.peg__d == 'i01_d1003') {
		invtrans_i01_relation(container_id, 0, 'a00');
	} else if (screen.peg__d == 'i01_d1006') {
		invtrans_i01_relation(container_id, 0, 'i01');
	} else if(screen.peg__d == 'i48_d100'){
		invtrans_i01_relation(container_id, 0,'i48');
	} else{
		console.warn("There is no custom action defined for " + screen.peg__d );
	}

}
function invtrans_invoice_relation(container_id) {
	let screen = pegGetCmp(container_id); 
	if (screen.peg__d =='i01_d10051' || screen.peg__d =='erpa02_d06') {
		invtrans_i01_d10051_relation(container_id);
	} else{
		console.warn("There is no custom action defined for " + screen.peg__d );
	}
}
var invtrans_i01_d10051_relation_ajax='';
function invtrans_i01_d10051_relation(container_id){
	row = pegGridGetSelectedRow(container_id, 'grid');
	var rel_params = {nr01 : row.nr01};

	if (invtrans_i01_d10051_relation_ajax != '') {
		if (invtrans_i01_d10051_relation_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(invtrans_i01_d10051_relation_ajax);
		}
	}

	invtrans_i01_d10051_relation_ajax = pegAjaxDefer('/' + main_path + '/invtrans01/i01_d1005_relation.php', rel_params , 
		function(jsonData){
			if(jsonData.ok==1){
				pegAddTab_d('' , jsonData.view_table  , jsonData.view_d  , jsonData.view_module  , ''  , jsonData.view_nr01  , '' );   				
			}else{
				pegAlert(jsonData.msg);
			}
		} , 'json' , true);		
}

function invtrans_i01_grid_record_change_handler(me) {
	let grid = me;
	let container_id = grid.getContainer_ID();

	let row = pegGridGetSelectedRow(grid.getContainer_ID(), 'grid');
	let screen = pegGetCmp(container_id); 
	if (screen.peg__d =='i01_d10051' || screen.peg__d == 'erpa02_d06'){
		row = pegGridGetSelectedRow(container_id, 'grid');
		pegAddTab_d('', 'i01', 'i01_d', 'invtrans'  , ''  , row.nr01  , '' );
	} else{
		console.warn("There is no custom action defined for " + screen.peg__d );
	}
}

function invtrans_inv_tot_d_afterDraw_listeners(container_id){
	let grid   = pegGetCmp(container_id, 'grid');
	let but01  = pegGetCmp(container_id, 'but01');
	let dt  = pegGetCmp(container_id,'dt');
	let p01  = pegGetCmp(container_id,'p01');
	let colorsize  = pegGetCmp(container_id,'colorsize');

	dt.on('blur', function(me){ 
		if((me.peg_onBlurValueHasChanged())){	
			invtrans_inv_tot_d_refresh_values(container_id);
		}
	});

	p01.on('change', function (me, newValue, oldValue, eOpts) {
		if (newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue))) {
			return;
		}
		if (pegIsEmpty(newValue)) {
			return;
		}

		invtrans_inv_tot_d_refresh_values(container_id);	
	});

	colorsize.on('change', function (me, newValue, oldValue, eOpts) {
		if (newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue))) {
			return;
		}
		if (pegIsEmpty(newValue)) {
			return;
		}

		invtrans_inv_tot_d_refresh_values(container_id);	
	});

	but01.setPeg_handler(function(me){
		invtrans_inv_tot_d_refresh_values(container_id);		
	});

	grid.record_change = function(me,row){
		pegAddTab_d("", "i00", "i00_d", "inventory", "", row.nr01, "");	
	};	

}

var invtrans_inv_tot_d_print_ajax='';

function invtrans_inv_tot_d_print(container_id) {
	invtrans_inv_tot_d_refresh_values(container_id);
	
	peg_windowShow_d('', 'browse_d005', 'core', '', '', 0, '', '', 
					{
						display_type: 'grid',
						tp: 'grid',
						dias_module: 'invtrans',
						dias_main_table: 'i00tot',
						dias_container_id: container_id,
					},
					null,
					null,
					null,
					null,
					'tablet');

	if (invtrans_inv_tot_d_print_ajax != '') {
		if (invtrans_inv_tot_d_print_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(invtrans_inv_tot_d_print_ajax);
		}
	}

	params = {
		parent_container_id: container_id,
		dt: pegGetVal('dt', container_id),
		p01: pegGetVal('p01', container_id),
		p02: pegGetVal('p02', container_id),
		p03: pegGetVal('p03', container_id),
		p04: pegGetVal('p04', container_id),
		colorsize: pegGetVal('colorsize', container_id),
		m_i16: pegGetVal('m_i16', container_id)
	}
	invtrans_inv_tot_d_print_ajax = pegAjaxDefer(
		'/' + main_path + '/invtrans01/invtrans_inv_tot_d_print.php',
		params,
		function (jsonData) {
			
		},
		'json', true);

}

var invtrans_inv_tot_d_search_ajax='';
/**
 * Με αυτή τη συνάρτηση σετάρουμε το grids της οθόνης inv_tot_d
 * @param container_id
 */
function invtrans_inv_tot_d_refresh_values(container_id) {
	
	const params = {
		container_id: container_id,
		dt: pegGetVal('dt', container_id),
		p01: pegGetVal('p01', container_id),
		colorsize: pegGetVal('colorsize', container_id),
		m_i16: pegGetVal('m_i16', container_id),
		p02: pegGetVal('p02', container_id),
		p03: pegGetVal('p03', container_id)
	};

	if (invtrans_inv_tot_d_search_ajax != '') {
		if (invtrans_inv_tot_d_search_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(invtrans_inv_tot_d_search_ajax);
		}
	}

	invtrans_inv_tot_d_search_ajax = pegAjaxDefer(
		'/' + main_path + '/invtrans01/inv_tot_d_refresh.php',
		params,
		function (jsonData) {
			pegGridRefresh(container_id, 'grid');
		},
		'json', true);
}

let invtrans_inv_tot_d_invoice_or_order_ajax='';
function invtrans_inv_tot_d_invoice_or_order(container_id, dest_table) {

	let selectedItems = pegGetCmp(container_id, 'grid').getSelectionModel().selected.items;

	let records = []; // PLACEHOLDER
	let jsonObj;
	selectedItems.forEach(function (item) {
		jsonObj = {	
				"nr01": item.data['nr01'],
				"pno": item.data['pno'],
				"name": item.data['name'],
				"p01": item.data['p01'],	
				"p02": item.data['p02'],		
				"p03": item.data['p03'],
				"rp": item.data['rp'],
				"op": item.data['op'],
				"p9001": item.data['p9001'],
				"pp08": item.data['pp08'],
				"pp09": item.data['pp09'],
				"vpp08": item.data['vpp08'],
				"vpp09": item.data['vpp09'],
				"i00p01": item.data['i00p01'],
				"p9000": item.data['p9000']
		};
		records.push(jsonObj);
	});

	const params = {
		i00: JSON.stringify(records)
	}
	
	params.container_id = container_id;
	params.dest_table =  dest_table;

	if (invtrans_inv_tot_d_invoice_or_order_ajax != '') {
		if (invtrans_inv_tot_d_invoice_or_order_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(invtrans_inv_tot_d_invoice_or_order_ajax);
		}
	}

	invtrans_inv_tot_d_invoice_or_order_ajax = pegAjaxDefer(
		'/' + main_path + '/invtrans01/invoice_or_order.php',
		params,
		function (jsonData) {
			if (jsonData.ok===1) {
				let params00 ={
					p04: pegGetVal('p04', container_id),
					inv_tot_invoice_multi: '1',
					inv_tot_d_container_id: container_id
				};
				
				switch (dest_table) {
					case 'a55': // παραστατικό πελάτη
						pegAddTab_d("", "a55", "a55_d", "invcust", "", 0, "", params00, container_id, 'grid');
						break;
					case 'a57': // παραγγελία πελάτη
						pegAddTab_d("", "a57", "a57_d", "ordercust", "", 0, "", params00, container_id, 'grid');
						break;
					case 'a56': // παραστατικό προμηθευτή
						pegAddTab_d("", "a56", "a56_d", "invsupp", "", 0, "", params00, container_id, 'grid');
						break;
					case 'a67': // παραγγελία προμηθευτή
						pegAddTab_d("", "a67", "a67_d", "ordersupp", "", 0, "", params00, container_id, 'grid');
						break;
					case 'a60': // παραστατικό εσωτ. διακίνησης
						pegAddTab_d("", "a60", "a60_d", "invtrans00", "", 0, "", params00, container_id, 'grid');
						break;
					case 'a61': // εσωτερική παραγγελία
						pegAddTab_d("", "a61", "a61_d", "interorder", "", 0, "", params00, container_id, 'grid');
						break;
					default:
						break;
				}
			} else {
				pegToast(jsonData.msg, 'alert');
			}
		},
		'json', true);

}

var invtrans_inv_anap_d_find_i00_nr01_ajax='';
function invtrans_inv_anap_d_afterDraw_listeners(container_id){
	let but01  = pegGetCmp(container_id, 'but01');
	
	let dt  = pegGetCmp(container_id,'dt');
	let dt2  = pegGetCmp(container_id,'dt2');

	let esed  = pegGetCmp(container_id,'esed');
	let kin  = pegGetCmp(container_id,'kin');
	let anx  = pegGetCmp(container_id,'anx');
	let ppe  = pegGetCmp(container_id,'ppe');
	let ppr  = pegGetCmp(container_id,'ppr');
	let pes  = pegGetCmp(container_id,'pes');
	let ypol  = pegGetCmp(container_id,'ypol');
	let elax  = pegGetCmp(container_id,'elax');
	let colorsize  = pegGetCmp(container_id,'colorsize');

	let cont_inv_anap_d02 = pegGetContainer_id_d(container_id, 'inv_anap_d02', '', 'inv_anap_d');
	let cont_inv_anap_d03 = pegGetContainer_id_d(container_id, 'inv_anap_d03', '', 'inv_anap_d');

	let grid_1   = pegGetCmp(cont_inv_anap_d02, 'grid');
	let grid_2   = pegGetCmp(cont_inv_anap_d03, 'grid');

	let p03_Col = WebApp.view.grid.Grid.peg_getColumn(grid_1, 'p03');

	dt.on('blur', function(me){ 
		if((me.peg_onBlurValueHasChanged())){	
			invtrans_inv_anap_d_refresh_values(container_id);
		}
	});

	dt2.on('blur', function(me){ 
		if((me.peg_onBlurValueHasChanged())){	
			invtrans_inv_anap_d_refresh_values(container_id);
		}
	});

	esed.on('change', function (me, newValue, oldValue, eOpts) {
		if (newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue))) {
			return;
		}
		if (pegIsEmpty(newValue)) {
			return;
		}

		invtrans_inv_anap_d_refresh_values(container_id);	
	});

	kin.on('change', function (me, newValue, oldValue, eOpts) {
		if (newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue))) {
			return;
		}
		if (pegIsEmpty(newValue)) {
			return;
		}

		invtrans_inv_anap_d_refresh_values(container_id);	
	});

	anx.on('change', function (me, newValue, oldValue, eOpts) {
		if (newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue))) {
			return;
		}
		if (pegIsEmpty(newValue)) {
			return;
		}

		invtrans_inv_anap_d_refresh_values(container_id);	
	});

	ppe.on('change', function (me, newValue, oldValue, eOpts) {
		if (newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue))) {
			return;
		}
		if (pegIsEmpty(newValue)) {
			return;
		}

		invtrans_inv_anap_d_refresh_values(container_id);	
	});

	ppr.on('change', function (me, newValue, oldValue, eOpts) {
		if (newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue))) {
			return;
		}
		if (pegIsEmpty(newValue)) {
			return;
		}

		invtrans_inv_anap_d_refresh_values(container_id);	
	});

	pes.on('change', function (me, newValue, oldValue, eOpts) {
		if (newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue))) {
			return;
		}
		if (pegIsEmpty(newValue)) {
			return;
		}

		invtrans_inv_anap_d_refresh_values(container_id);	
	});

	ypol.on('change', function (me, newValue, oldValue, eOpts) {
		if (newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue))) {
			return;
		}
		if (pegIsEmpty(newValue)) {
			return;
		}

		invtrans_inv_anap_d_refresh_values(container_id);	
	});

	elax.on('change', function (me, newValue, oldValue, eOpts) {
		if (newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue))) {
			return;
		}
		if (pegIsEmpty(newValue)) {
			return;
		}

		invtrans_inv_anap_d_refresh_values(container_id);	
	});

	colorsize.on('change', function (me, newValue, oldValue, eOpts) {
		if (newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue))) {
			return;
		}
		if (pegIsEmpty(newValue)) {
			return;
		}

		invtrans_inv_anap_d_refresh_values(container_id);	
	});

	but01.setPeg_handler(function(me){
		invtrans_inv_anap_d_refresh_values(container_id);		
	});

	grid_1.record_change = function(me,row){
		if (invtrans_inv_anap_d_find_i00_nr01_ajax != '') {
			if (invtrans_inv_anap_d_find_i00_nr01_ajax.id > 0) {
				Ext.ux.AjaxDefer.abort(invtrans_inv_anap_d_find_i00_nr01_ajax);
			}
		}

		const params = {
			code:row.p01
		}
	
		invtrans_inv_anap_d_find_i00_nr01_ajax = pegAjaxDefer(
			'/' + main_path + '/invtrans01/inv_anap_d_find_i00_nr01.php',
			params,
			function (jsonData) {
				pegAddTab_d("", "i00", "i00_d", "inventory", "", jsonData.nr01, "");	
			},
			'json', true);
		
	};	

}

var invtrans_inv_anap_d_search_ajax='';
/**
 * Με αυτή τη συνάρτηση σετάρουμε το grids της οθόνης inv_anap_d
 * @param container_id
 */
function invtrans_inv_anap_d_refresh_values(container_id) {

	let cont_inv_anap_d02 = pegGetContainer_id_d(container_id, 'inv_anap_d02', '', 'inv_anap_d');
	let cont_inv_anap_d03 = pegGetContainer_id_d(container_id, 'inv_anap_d03', '', 'inv_anap_d');
	
	const params = {
		container_id: container_id,
		dt: pegGetVal('dt', container_id),
		dt2: pegGetVal('dt2', container_id),
		esed: pegGetVal('esed', container_id),
		kin: pegGetVal('kin', container_id),
		anx: pegGetVal('anx', container_id),
		colorsize: pegGetVal('colorsize', container_id),
		ppe: pegGetVal('ppe', container_id),
		ppr: pegGetVal('ppr', container_id),
		pes: pegGetVal('pes', container_id),
		ypol: pegGetVal('ypol', container_id),
		elax: pegGetVal('elax', container_id),
		a00: pegGetVal('a00', container_id),
		i16: pegGetVal('i16', container_id),
		m_i16: pegGetVal('m_i16', container_id),
		p02: pegGetVal('p02', container_id),
		p03: pegGetVal('p03', container_id),
		p06: pegGetVal('p06', container_id),
		min_ypol: pegGetVal('min_ypol', container_id),
		max_ypol: pegGetVal('max_ypol', container_id)

	};

	if (invtrans_inv_anap_d_search_ajax != '') {
		if (invtrans_inv_anap_d_search_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(invtrans_inv_anap_d_search_ajax);
		}
	}

	invtrans_inv_anap_d_search_ajax = pegAjaxDefer(
		'/' + main_path + '/invtrans01/inv_anap_d_refresh.php',
		params,
		function (jsonData) {
			pegSetVal('p04' , container_id,  jsonData.p04);
			pegSetVal('p05' , container_id,  jsonData.p05);
			pegGridRefresh(cont_inv_anap_d02, 'grid');
			pegGridRefresh(cont_inv_anap_d03, 'grid');
		},
		'json', true);
}

let invtrans_inv_anap_d_order_ajax='';
/**
 * Με αυτή τη συνάρτηση υλοποιούμε τη λογική για τις ενέργειες της οθόνης inv_anap_d
 * @param container_id
 * @param dest_table 	a67 ή a61
 * @param mode 			'min' για ελάχιστη ανάγκη ή 'max' για μέγιστη ανάγκη
 */
function invtrans_inv_anap_d_order(container_id, dest_table, mode) {

	let cont_inv_anap_d02 = pegGetContainer_id_d(container_id, 'inv_anap_d02', '', 'inv_anap_d');
	let selectedItems = pegGetCmp(cont_inv_anap_d02, 'grid').getSelectionModel().selected.items;

	let records = []; // PLACEHOLDER
	let jsonObj;

	if (mode === 'min') {
		selectedItems.forEach(function (item) {
			jsonObj = {
				"a00": item.data['p03'],	// προμηθευτής
				"pno": item.data['p01'],	// κωδικός είδους
				"p01": item.data['p09'],	// ελάχιστη ανάγκη	
				"pp08": item.data['p401'],  // Κωδ. χρώματος
				"pp09": item.data['p402'],  // Κωδ. μεγέθους
			};
			records.push(jsonObj);
		});
	}
	else if (mode === 'max') {
		selectedItems.forEach(function (item) {
			jsonObj = {
				"a00": item.data['p03'],	// προμηθευτής
				"pno": item.data['p01'],	// κωδικός είδους
				"p01": item.data['p010'],	// μέγιστη ανάγκη	
				"pp08": item.data['p401'],  // Κωδ. χρώματος
				"pp09": item.data['p402'],  // Κωδ. μεγέθους
			};
			records.push(jsonObj);
		});
	}


	const params = {
		i00: JSON.stringify(records)
	}

	params.container_id = container_id;
	params.dest_table = dest_table;

	if (invtrans_inv_anap_d_order_ajax != '') {
		if (invtrans_inv_anap_d_order_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(invtrans_inv_anap_d_order_ajax);
		}
	}

	invtrans_inv_anap_d_order_ajax = pegAjaxDefer(
		'/' + main_path + '/invtrans01/inv_anap_d_order.php',
		params,
		function (jsonData) {
			if (jsonData.ok === 1) {
				let params00 = {
					inv_tot_invoice_multi: '1',
					inv_anap_d_container_id: container_id
				};

				switch (dest_table) {
					case 'a67': // παραγγελία προμηθευτή
						pegAddTab_d("", "a67", "a67_d", "ordersupp", "", 0, "", params00, container_id, 'grid');
						break;
					case 'a61': // εσωτερική παραγγελία
						pegAddTab_d("", "a61", "a61_d", "interorder", "", 0, "", params00, container_id, 'grid');
						break;
					default:
						break;
				}
			} else {
				pegToast(jsonData.msg, 'alert');
			}
		},
		'json', true);

}

var invtrans_inv_anap_d_search_ajax='';
/**
 * Με αυτή τη συνάρτηση υλοποιούμε τη λογική για το button "Ενημέρωση Αναγκών από Εξαγωγές Περιόδου"
 * @param container_id
 * @param container_id_parent
 */
function invtrans_inv_anap_d_update_needs(container_id, container_id_parent) {

	let cont_inv_anap_d02 = pegGetContainer_id_d(container_id_parent, 'inv_anap_d02', '', 'inv_anap_d');

	const params = {
		container_id: container_id_parent,
		dt: pegGetVal('dt', container_id_parent),
		dt2: pegGetVal('dt2', container_id_parent),
		esed: pegGetVal('esed', container_id_parent),
		kin: pegGetVal('kin', container_id_parent),
		anx: pegGetVal('anx', container_id_parent),
		colorsize: pegGetVal('colorsize', container_id_parent),
		ppe: pegGetVal('ppe', container_id_parent),
		ppr: pegGetVal('ppr', container_id_parent),
		pes: pegGetVal('pes', container_id_parent),
		ypol: pegGetVal('ypol', container_id_parent),
		elax: pegGetVal('elax', container_id_parent),
		a00: pegGetVal('a00', container_id_parent),
		i16: pegGetVal('i16', container_id_parent),
		m_i16: pegGetVal('m_i16', container_id_parent),
		p02: pegGetVal('p02', container_id_parent),
		p03: pegGetVal('p03', container_id_parent),

		pos: pegGetVal('pos', container_id),
		min: pegGetVal('min', container_id),
		max: pegGetVal('max', container_id)

	};

	if (invtrans_inv_anap_d_search_ajax != '') {
		if (invtrans_inv_anap_d_search_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(invtrans_inv_anap_d_search_ajax);
		}
	}

	invtrans_inv_anap_d_search_ajax = pegAjaxDefer(
		'/' + main_path + '/invtrans01/inv_anap_d_refresh.php',
		params,
		function (jsonData) {
			pegSetVal('p04' , container_id_parent,  jsonData.p04);
			pegSetVal('p05' , container_id_parent,  jsonData.p05);
			pegGridRefresh(cont_inv_anap_d02, 'grid');
		},
		'json', true);

}

function invtrans_toolbar_item_show_i01_d1005(screen, id, parent_d){

	//console.log(screen);
	var parent_container_id = pegGetContainer_id_d(screen.getContainer_ID(), parent_d, '', screen.peg__d);

	var row = pegGridGetSelectedRow(screen.getContainer_ID(), id);
	var i00pno   = "";
	var tbl      = "";
	var tbl_nr01 = pegGetVal('p03', parent_container_id);

	if(parent_d=="a55_d"){
		i00pno  = row.p01;
		tbl 	 = "a01";
	}else if(parent_d=="a56_d"){
		i00pno  = row.p01;
		tbl 	 = "a00";
	}else if(parent_d=="a57_d"){
		i00pno  = row.v101;
		tbl 	 = "a01";
	}else if(parent_d=="a67_d"){
		i00pno  = row.v101;
		tbl 	 = "a00";
	}

	peg_windowShow_d(  
	    '', 
	    'i01_d1005' , 
	    'invtrans', 
	    screen.getContainer_ID(), 
	    '', 
	    0, 
	    '',  
	    '', 
	        {
	            mmnr01: 	screen.getMmnr01(),
	            mnr01: 		screen.getNr01(),
	            mode: 		tbl,
	            tbl_nr01: 	tbl_nr01,
				p_col:		i00pno
	        }
	);
}

var invtrans_refresh_i01_cost_unit_ajax = "";	
function invtrans_refresh_i01_cost_unit(container_id, pno) {	
	if(invtrans_refresh_i01_cost_unit_ajax != '') {
		if(invtrans_refresh_i01_cost_unit_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(invtrans_refresh_i01_cost_unit_ajax);
		}
	}
	var params = {};	
	params.pno = pno;
	params.p07 = pegGetVal('p07', container_id);
	params.p06 = pegGetVal('p06', container_id);
	
	invtrans_refresh_i01_cost_unit_ajax = pegAjaxDefer('/' + main_path + '/invtrans01/invtrans_refresh_i01_cost_unit.php', params, function(jsondata) {
		if(jsondata.i01_p04) {
			pegSetVal('p04', container_id, jsondata.i01_p04);
		}
	}, 'json', true);		
}

function invtrans_invtrans_browse_i01_d100_afterDraw_listeners(container_id) {
	var screen = pegGetCmp(container_id);
	var container_id_i01_d100 = screen.peg_screen_parent_container_id;

	var grid = pegGetCmp(container_id,  'grid');
	grid.on('itemdblclick', function( view, record, item, index, e, opts){
		if(pegGetCmp(container_id_i01_d100).peg__d == 'i01_d100'){
			params = {
				parent_container_id: container_id_i01_d100,
				t_lo:  pegGetVal('t_lo',  container_id_i01_d100),
				t_df:  pegGetVal('t_df',  container_id_i01_d100),
				t_dt:  pegGetVal('t_dt',  container_id_i01_d100),
				t_ka1: pegGetVal('t_ka1', container_id_i01_d100),
				t_ka2: pegGetVal('t_ka2', container_id_i01_d100),
			}

			pegPrintToPDF(
				record.data.nr01, 
				params
			);
		} else {
			pegPrintToPDF(
				record.data.nr01, 
				{
					parent_container_id: container_id_i01_d100,
					t_lo:  pegGetVal('t_lo',  container_id_i01_d100),
					t_df:  pegGetVal('t_df',  container_id_i01_d100),
					t_dt:  pegGetVal('t_dt',  container_id_i01_d100),
					t_ka1: pegGetVal('t_ka1', container_id_i01_d100),
					t_ka2: pegGetVal('t_ka2', container_id_i01_d100),
				}
			);
		}
	});
}